// DESCRIPTION: Verilator: Concatenated UVM header for internal testing
// SPDX-License-Identifier: Apache-2.0
//----------------------------------------------------------------------
// To recreate:
//   Using verilator_ext_tests:
//     t_uvm_hello_v2020_3_1_nodpi --gold
//
//----------------------------------------------------------------------
// Copyright 2007-2022 Cadence Design Systems, Inc.
// Copyright 2023 Intel Corporation
// Copyright 2007-2011 Mentor Graphics Corporation
// Copyright 2013-2024 NVIDIA Corporation
// Copyright 2011-2022 Synopsys, Inc.
//   All Rights Reserved Worldwide
//
//   Licensed under the Apache License, Version 2.0 (the
//   "License"); you may not use this file except in
//   compliance with the License.  You may obtain a copy of
//   the License at
//
//       http://www.apache.org/licenses/LICENSE-2.0
//
//   Unless required by applicable law or agreed to in
//   writing, software distributed under the License is
//   distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
//   CONDITIONS OF ANY KIND, either express or implied.  See
//   the License for the specific language governing
//   permissions and limitations under the License.
//----------------------------------------------------------------------
`define UVM_NO_DPI
`define UVM_PKG_SV
`define UVM_MACROS_SVH
`define UVM_STRING_QUEUE_STREAMING_PACK(q) uvm_pkg::m_uvm_string_queue_join(q)
`define uvm_typename(X) $typename(X)
`define uvm_delay(TIME) #(TIME);
`define UVM_VERSION_DEFINES_SVH
`define UVM_VERSION 2020
`define UVM_VERSION_POST_2017
`define UVM_VERSION_POST_2017_1_0
`define UVM_VERSION_POST_2017_1_1
`define UVM_VERSION_POST_2020_1_0
`define UVM_VERSION_POST_2020_1_1
`define UVM_VERSION_POST_2020_2_0
`define UVM_NAME UVM
`define UVM_MAJOR_REV 2020
`define UVM_MINOR_REV 3.0
`define UVM_VERSION_STRING uvm_pkg::UVM_VERSION_STRING
`define UVM_POST_VERSION_1_1
`define UVM_POST_VERSION_1_2
`define UVM_GLOBAL_DEFINES_SVH
`define UVM_COMPONENT_CONFIG_MODE_DEFAULT CONFIG_CHECK_NAMES
`define UVM_MAX_STREAMBITS 4096
`define UVM_PACKER_MAX_BYTES `UVM_MAX_STREAMBITS
`define UVM_DEFAULT_TIMEOUT 9200s
`define UVM_MESSAGE_DEFINES_SVH
`define UVM_LINE_WIDTH 120
`define UVM_NUM_LINES 120
`define uvm_file `__FILE__
`define uvm_line `__LINE__
`define uvm_report_begin(SEVERITY, ID, VERBOSITY, RO=uvm_get_report_object()) \
   begin \
     uvm_pkg::uvm_report_object _local_report_object_;\
     _local_report_object_ = RO.uvm_get_report_object() ; \
     if ((_local_report_object_.get_report_verbosity_level(SEVERITY, ID) >= VERBOSITY) && \
         (_local_report_object_.get_report_action(SEVERITY, ID) != uvm_pkg::UVM_NO_ACTION)) begin
`define uvm_report_end \
     end \
   end
`define uvm_info(ID, MSG, VERBOSITY) \
  `uvm_report_begin(uvm_pkg::UVM_INFO, ID, VERBOSITY) \
  uvm_report_info(ID, MSG, VERBOSITY, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_warning(ID, MSG) \
  `uvm_report_begin(uvm_pkg::UVM_WARNING, ID, uvm_pkg::UVM_NONE) \
  uvm_report_warning(ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_error(ID, MSG) \
  `uvm_report_begin(uvm_pkg::UVM_ERROR, ID, uvm_pkg::UVM_NONE) \
  uvm_report_error(ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_fatal(ID, MSG) \
  `uvm_report_begin(uvm_pkg::UVM_FATAL, ID, uvm_pkg::UVM_NONE) \
  uvm_report_fatal(ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_info_context(ID, MSG, VERBOSITY, RO) \
  `uvm_report_begin(uvm_pkg::UVM_INFO, ID, VERBOSITY, RO) \
   _local_report_object_.uvm_report_info(ID, MSG, VERBOSITY, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_warning_context(ID, MSG, RO) \
  `uvm_report_begin(uvm_pkg::UVM_WARNING, ID, uvm_pkg::UVM_NONE, RO) \
   _local_report_object_.uvm_report_warning(ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_error_context(ID, MSG, RO) \
  `uvm_report_begin(uvm_pkg::UVM_ERROR, ID, uvm_pkg::UVM_NONE, RO) \
   _local_report_object_.uvm_report_error(ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_fatal_context(ID, MSG, RO) \
  `uvm_report_begin(uvm_pkg::UVM_FATAL, ID, uvm_pkg::UVM_NONE, RO) \
   _local_report_object_.uvm_report_fatal(ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, "", 1); \
  `uvm_report_end
`define uvm_message_begin(SEVERITY, ID, MSG, VERBOSITY, FILE, LINE, RM) \
   `uvm_report_begin(SEVERITY, ID, VERBOSITY) \
     uvm_pkg::uvm_report_message __uvm_msg; \
     if (RM == null) RM = uvm_pkg::uvm_report_message::new_report_message(); \
     __uvm_msg = RM; \
     __uvm_msg.set_report_message(SEVERITY, ID, MSG, VERBOSITY, FILE, LINE, "");
`define uvm_message_end \
    uvm_process_report_message(__uvm_msg); \
  `uvm_report_end
`define uvm_message_context_begin(SEVERITY, ID, MSG, VERBOSITY, FILE, LINE, RO, RM) \
   `uvm_report_begin(SEVERITY, ID, VERBOSITY, RO) \
     uvm_pkg::uvm_report_object __report_object; \
     uvm_pkg::uvm_report_message __uvm_msg; \
     __report_object = RO; \
     if (RM == null) RM = uvm_pkg::uvm_report_message::new_report_message(); \
       __uvm_msg = RM; \
       __uvm_msg.set_report_message(SEVERITY, ID, MSG, VERBOSITY, FILE, LINE, "");
`define uvm_message_context_end \
       __report_object.uvm_process_report_message(__uvm_msg); \
  `uvm_report_end
`define uvm_info_begin(ID, MSG, VERBOSITY, RM = __uvm_msg) \
   `uvm_message_begin(uvm_pkg::UVM_INFO, ID, MSG, VERBOSITY, `uvm_file, `uvm_line, RM)
`define uvm_info_end \
   `uvm_message_end
`define uvm_warning_begin(ID, MSG, RM = __uvm_msg) \
   `uvm_message_begin(uvm_pkg::UVM_WARNING, ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, RM)
`define uvm_warning_end \
   `uvm_message_end
`define uvm_error_begin(ID, MSG, RM = __uvm_msg) \
   `uvm_message_begin(uvm_pkg::UVM_ERROR, ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, RM)
`define uvm_error_end \
   `uvm_message_end
`define uvm_fatal_begin(ID, MSG, RM = __uvm_msg) \
   `uvm_message_begin(uvm_pkg::UVM_FATAL, ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, RM)
`define uvm_fatal_end \
   `uvm_message_end
`define uvm_info_context_begin(ID, MSG, VERBOSITY, RO, RM = __uvm_msg) \
   `uvm_message_context_begin(uvm_pkg::UVM_INFO, ID, MSG, VERBOSITY, `uvm_file, `uvm_line, RO, RM)
`define uvm_info_context_end \
   `uvm_message_context_end
`define uvm_warning_context_begin(ID, MSG, RO, RM = __uvm_msg) \
   `uvm_message_context_begin(uvm_pkg::UVM_WARNING, ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, RO, RM)
`define uvm_warning_context_end \
   `uvm_message_context_end
`define uvm_error_context_begin(ID, MSG, RO, RM = __uvm_msg) \
   `uvm_message_context_begin(uvm_pkg::UVM_ERROR, ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, RO, RM)
`define uvm_error_context_end \
   `uvm_message_context_end
`define uvm_fatal_context_begin(ID, MSG, RO, RM = __uvm_msg) \
   `uvm_message_context_begin(uvm_pkg::UVM_FATAL, ID, MSG, uvm_pkg::UVM_NONE, `uvm_file, `uvm_line, RO, RM)
`define uvm_fatal_context_end \
   `uvm_message_context_end
`define uvm_message_add_tag(NAME, VALUE, ACTION=(uvm_pkg::UVM_LOG|uvm_pkg::UVM_RM_RECORD)) \
    __uvm_msg.add_string(NAME, VALUE, ACTION);
`define uvm_message_add_int(VAR, RADIX, LABEL="", ACTION=(uvm_pkg::UVM_LOG|uvm_pkg::UVM_RM_RECORD)) \
    if (LABEL == "") \
      __uvm_msg.add_int(`"VAR`", VAR, $bits(VAR), RADIX, ACTION); \
    else \
      __uvm_msg.add_int(LABEL, VAR, $bits(VAR), RADIX, ACTION);
`define uvm_message_add_string(VAR, LABEL="", ACTION=(uvm_pkg::UVM_LOG|uvm_pkg::UVM_RM_RECORD)) \
    if (LABEL == "") \
      __uvm_msg.add_string(`"VAR`", VAR, ACTION); \
    else \
      __uvm_msg.add_string(LABEL, VAR, ACTION);
`define uvm_message_add_object(VAR, LABEL="", ACTION=(uvm_pkg::UVM_LOG|uvm_pkg::UVM_RM_RECORD)) \
    if (LABEL == "") \
      __uvm_msg.add_object(`"VAR`", VAR, ACTION); \
    else \
      __uvm_msg.add_object(LABEL, VAR, ACTION);
`define UVM_PHASE_DEFINES_SVH
`define m_uvm_task_phase(PHASE,COMP,PREFIX) \
        class PREFIX``PHASE``_phase extends uvm_task_phase; \
          virtual task exec_task(uvm_component comp, uvm_phase phase); \
            COMP comp_; \
            if ($cast(comp_,comp)) \
              comp_.``PHASE``_phase(phase); \
          endtask \
          local static PREFIX``PHASE``_phase m_inst; \
          `uvm_type_name_decl(`"PREFIX``PHASE``_phase`") \
          static function PREFIX``PHASE``_phase get(); \
            if(m_inst == null) begin \
              m_inst = new; \
            end \
            return m_inst; \
          endfunction \
          protected function new(string name=`"PHASE`"); \
            super.new(name); \
          endfunction \
        endclass \

`define m_uvm_topdown_phase(PHASE,COMP,PREFIX) \
        class PREFIX``PHASE``_phase extends uvm_topdown_phase; \
          virtual function void exec_func(uvm_component comp, uvm_phase phase); \
            COMP comp_; \
            if ($cast(comp_,comp)) \
              comp_.``PHASE``_phase(phase); \
          endfunction \
          local static PREFIX``PHASE``_phase m_inst; \
          `uvm_type_name_decl(`"PREFIX``PHASE``_phase`") \
          static function PREFIX``PHASE``_phase get(); \
            if(m_inst == null) begin \
              m_inst = new(); \
            end \
            return m_inst; \
          endfunction \
          protected function new(string name=`"PHASE`"); \
            super.new(name); \
          endfunction \
        endclass \

`define m_uvm_bottomup_phase(PHASE,COMP,PREFIX) \
        class PREFIX``PHASE``_phase extends uvm_bottomup_phase; \
          virtual function void exec_func(uvm_component comp, uvm_phase phase); \
            COMP comp_; \
            if ($cast(comp_,comp)) \
              comp_.``PHASE``_phase(phase); \
          endfunction \
          static PREFIX``PHASE``_phase m_inst; \
          `uvm_type_name_decl(`"PREFIX``PHASE``_phase`") \
          static function PREFIX``PHASE``_phase get(); \
            if(m_inst == null) begin \
              m_inst = new(); \
            end \
            return m_inst; \
          endfunction \
          protected function new(string name=`"PHASE`"); \
            super.new(name); \
          endfunction \
        endclass \

`define uvm_builtin_task_phase(PHASE) \
        `m_uvm_task_phase(PHASE,uvm_component,uvm_)
`define uvm_builtin_topdown_phase(PHASE) \
        `m_uvm_topdown_phase(PHASE,uvm_component,uvm_)
`define uvm_builtin_bottomup_phase(PHASE) \
        `m_uvm_bottomup_phase(PHASE,uvm_component,uvm_)
`define uvm_user_task_phase(PHASE,COMP,PREFIX) \
        `m_uvm_task_phase(PHASE,COMP,PREFIX)
`define uvm_user_topdown_phase(PHASE,COMP,PREFIX) \
        `m_uvm_topdown_phase(PHASE,COMP,PREFIX)
`define uvm_user_bottomup_phase(PHASE,COMP,PREFIX) \
        `m_uvm_bottomup_phase(PHASE,COMP,PREFIX)
`define UVM_PRINTER_DEFINES_SVH
`define uvm_print_int(VALUE, SIZE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_int(`"VALUE`", VALUE, SIZE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_int(NAME, VALUE, SIZE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
if (SIZE > 64) \
  PRINTER.print_field(NAME, VALUE, SIZE, RADIX, ".", `"VALUE_TYPE`"); \
else \
  PRINTER.print_field_int(NAME, VALUE, SIZE, RADIX, ".", `"VALUE_TYPE`");
`define uvm_print_real(VALUE, PRINTER=printer) \
  `uvm_print_named_real(`"VALUE`", VALUE, PRINTER)
`define uvm_print_named_real(NAME, VALUE, PRINTER=printer) \
  PRINTER.print_real(NAME, VALUE);
`define uvm_print_enum(TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_enum(TYPE, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_enum(TYPE, NAME, VALUE, PRINTER=printer) \
if (VALUE.name()  == "") \
  `uvm_print_named_int(NAME, VALUE, $bits(VALUE), UVM_NORADIX, TYPE, PRINTER) \
else \
  PRINTER.print_generic(NAME, `"TYPE`", $bits(VALUE), VALUE.name());
`define uvm_print_object(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_object(`"VALUE`", VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_named_object(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
    (RECURSION_POLICY != PRINTER.get_recursion_policy())) begin \
  uvm_recursion_policy_enum __saved_recursion_policy  = PRINTER.get_recursion_policy(); \
  PRINTER.set_recursion_policy(RECURSION_POLICY); \
  `m_uvm_print_named_object(NAME, VALUE, PRINTER) \
  PRINTER.set_recursion_policy(__saved_recursion_policy); \
end \
else begin \
  `m_uvm_print_named_object(NAME, VALUE, PRINTER) \
end
`define m_uvm_print_named_object(NAME, VALUE, PRINTER) \
if (PRINTER.object_printed(VALUE, PRINTER.get_recursion_policy()) != uvm_policy::NEVER) begin \
  uvm_recursion_policy_enum __saved_recursion_policy = PRINTER.get_recursion_policy(); \
  PRINTER.set_recursion_policy(UVM_REFERENCE); \
  PRINTER.print_object(NAME, VALUE); \
  PRINTER.set_recursion_policy(__saved_recursion_policy); \
end \
else begin \
  PRINTER.print_object(NAME, VALUE); \
end
`define uvm_print_string(VALUE, PRINTER=printer) \
  `uvm_print_named_string(`"VALUE`", VALUE, PRINTER)
`define uvm_print_named_string(NAME, VALUE, PRINTER=printer) \
  PRINTER.print_string(NAME, VALUE);
`define uvm_print_qda_int(ARRAY_TYPE, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(ARRAY_TYPE, `"VALUE`", VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_qda_int(ARRAY_TYPE, NAME, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
begin \
  int __tmp_max = $right(VALUE) + 1; \
  PRINTER.print_array_header(NAME, \
                             __tmp_max, \
                             `"ARRAY_TYPE``(``VALUE_TYPE``)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    int __tmp_begin_elements, __tmp_end_elements; \
    __tmp_begin_elements      = PRINTER.get_begin_elements(); \
    __tmp_end_elements        = PRINTER.get_end_elements(); \
    /* Fast Bypass */ \
    if (__tmp_begin_elements == -1 || __tmp_end_elements == -1) begin \
      foreach (VALUE[__tmp_index]) begin \
        `uvm_print_named_int($sformatf("[%0d]", __tmp_index), \
                             VALUE[__tmp_index], \
                             $bits(VALUE[__tmp_index]), \
                             RADIX, \
                             VALUE_TYPE, \
                             PRINTER) \
      end \
    end \
    else begin \
      int __tmp_curr; \
      foreach(VALUE[__tmp_index]) begin \
        if (__tmp_curr < __tmp_begin_elements) begin \
          `uvm_print_named_int($sformatf("[%0d]", __tmp_index), \
                               VALUE[__tmp_index], \
                               $bits(VALUE[__tmp_index]), \
                               RADIX, \
                               VALUE_TYPE, \
                               PRINTER) \
        end \
        else \
          break; \
        __tmp_curr++; \
      end \
      if (__tmp_curr < __tmp_max ) begin \
        if ((__tmp_max - __tmp_end_elements) > __tmp_curr) \
          __tmp_curr  = __tmp_max - __tmp_end_elements; \
        if (__tmp_curr < __tmp_begin_elements) \
          __tmp_curr = __tmp_begin_elements; \
        else \
          PRINTER.print_array_range(__tmp_begin_elements, __tmp_curr-1); \
        while (__tmp_curr < __tmp_max) begin \
          `uvm_print_named_int($sformatf("[%0d]", __tmp_curr), \
                               VALUE[__tmp_curr], \
                               $bits(VALUE[__tmp_curr]), \
                               RADIX, \
                               VALUE_TYPE, \
                               PRINTER) \
          __tmp_curr++; \
        end \
      end \
    end \
  end \
  PRINTER.print_array_footer(__tmp_max); \
end
`define uvm_print_array_int(VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(da, `"VALUE`", VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_array_int(NAME, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(da, NAME, VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_sarray_int(VALUE, RADIX=UVM_RADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(sa, `"VALUE`", VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_sarray_int(NAME, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(sa, NAME, VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_queue_int(VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(queue, `"VALUE`", VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_queue_int(NAME, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_qda_int(queue, NAME, VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_qda_real(ARRAY_TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_real(ARRAY_TYPE, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_qda_real(ARRAY_TYPE, NAME, VALUE, PRINTER=printer) \
begin \
  int __tmp_max = $right(VALUE) + 1; \
  PRINTER.print_array_header(NAME, \
                             __tmp_max, \
                             `"ARRAY_TYPE``(real)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    int __tmp_begin_elements, __tmp_end_elements; \
    __tmp_begin_elements    = PRINTER.get_begin_elements(); \
    __tmp_end_elements      = PRINTER.get_end_elements(); \
    /* Fast Bypass */ \
    if (__tmp_begin_elements == -1 || __tmp_end_elements == -1) begin \
      foreach (VALUE[__tmp_index]) begin \
        `uvm_print_named_real($sformatf("[%0d]", __tmp_index), \
                                VALUE[__tmp_index], \
                                PRINTER) \
      end \
    end \
    else begin \
      int __tmp_curr; \
      foreach(VALUE[__tmp_index]) begin \
        if (__tmp_curr < __tmp_begin_elements) begin \
          `uvm_print_named_real($sformatf("[%0d]", __tmp_index), \
                                  VALUE[__tmp_index], \
                                  PRINTER) \
        end \
        else \
          break; \
        __tmp_curr++; \
      end \
      if (__tmp_curr < __tmp_max ) begin \
        if ((__tmp_max - __tmp_end_elements) > __tmp_curr) \
          __tmp_curr  = __tmp_max - __tmp_end_elements; \
        if (__tmp_curr < __tmp_begin_elements) \
          __tmp_curr = __tmp_begin_elements; \
        else \
          PRINTER.print_array_range(__tmp_begin_elements, __tmp_curr-1); \
        while (__tmp_curr < __tmp_max) begin \
          `uvm_print_named_real($sformatf("[%0d]", __tmp_curr), \
                                  VALUE[__tmp_curr], \
                                  PRINTER) \
          __tmp_curr++; \
        end \
      end \
    end \
  end \
  PRINTER.print_array_footer(__tmp_max); \
end
`define uvm_print_array_real(VALUE, PRINTER=printer) \
  `uvm_print_named_qda_real(da, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_array_real(NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_real(da, NAME, VALUE, PRINTER)
`define uvm_print_sarray_real(VALUE, PRINTER=printer) \
  `uvm_print_named_qda_real(sa, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_sarray_real(NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_real(sa, NAME, VALUE, PRINTER)
`define uvm_print_queue_real(VALUE,PRINTER=printer) \
  `uvm_print_named_qda_real(queue, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_queue_real(NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_real(queue, NAME, VALUE, PRINTER)
`define uvm_print_qda_enum(ARRAY_TYPE, TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(ARRAY_TYPE, TYPE, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_qda_enum(ARRAY_TYPE, TYPE, NAME, VALUE, PRINTER=printer) \
begin \
  int __tmp_max = $right(VALUE) + 1; \
  PRINTER.print_array_header(NAME, \
                             __tmp_max, \
                             {`"ARRAY_TYPE``(`", `"TYPE`", ")"}); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    int __tmp_begin_elements, __tmp_end_elements; \
    __tmp_begin_elements      = PRINTER.get_begin_elements(); \
    __tmp_end_elements        = PRINTER.get_end_elements(); \
    /* Fast Bypass */ \
    if (__tmp_begin_elements == -1 || __tmp_end_elements == -1) begin \
      foreach (VALUE[__tmp_index]) begin \
        `uvm_print_named_enum(TYPE, \
                              $sformatf("[%0d]", __tmp_index), \
                              VALUE[__tmp_index], \
                              PRINTER) \
      end \
    end \
    else begin \
      int __tmp_curr; \
      foreach(VALUE[__tmp_index]) begin \
        if (__tmp_curr < __tmp_begin_elements) begin \
          `uvm_print_named_enum(TYPE, \
                                $sformatf("[%0d]", __tmp_index), \
                                VALUE[__tmp_index], \
                                PRINTER) \
        end \
        else \
          break; \
        __tmp_curr++; \
      end \
      if (__tmp_curr < __tmp_max ) begin \
        if ((__tmp_max - __tmp_end_elements) > __tmp_curr) \
          __tmp_curr  = __tmp_max - __tmp_end_elements; \
        if (__tmp_curr < __tmp_begin_elements) \
          __tmp_curr = __tmp_begin_elements; \
        else \
          PRINTER.print_array_range(__tmp_begin_elements, __tmp_curr-1); \
        while (__tmp_curr < __tmp_max) begin \
          `uvm_print_named_enum(TYPE, \
                                $sformatf("[%0d]", __tmp_curr), \
                                VALUE[__tmp_curr], \
                                PRINTER) \
          __tmp_curr++; \
        end \
      end \
    end \
  end \
  PRINTER.print_array_footer(__tmp_max); \
end
`define uvm_print_array_enum(TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(da, `"VALUE`", TYPE, VALUE, PRINTER)
`define uvm_print_named_array_enum(TYPE, NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(da, TYPE, NAME, VALUE, PRINTER)
`define uvm_print_sarray_enum(TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(sa, TYPE, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_sarray_enum(TYPE, NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(sa, TYPE, NAME, VALUE, PRINTER)
`define uvm_print_queue_enum(TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(queue, TYPE, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_queue_enum(TYPE, NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_enum(queue, TYPE, NAME, VALUE, PRINTER)
`define uvm_print_qda_object(ARRAY_TYPE, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(ARRAY_TYPE, `"VALUE`", VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_named_qda_object(ARRAY_TYPE, NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
begin \
  int __tmp_max = $right(VALUE) + 1; \
  PRINTER.print_array_header(NAME, \
                             __tmp_max, \
                             `"ARRAY_TYPE``(object)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    uvm_recursion_policy_enum __tmp_recursion_policy; \
    int __tmp_begin_elements, __tmp_end_elements; \
    __tmp_begin_elements    = PRINTER.get_begin_elements(); \
    __tmp_end_elements      = PRINTER.get_end_elements(); \
    __tmp_recursion_policy  = PRINTER.get_recursion_policy(); \
    if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
        (__tmp_recursion_policy != RECURSION_POLICY)) \
      PRINTER.set_recursion_policy(RECURSION_POLICY); \
    /* Fast Bypass */ \
    if (__tmp_begin_elements == -1 || __tmp_end_elements == -1) begin \
      foreach (VALUE[__tmp_index]) begin \
        `m_uvm_print_named_object($sformatf("[%0d]", __tmp_index), \
                                  VALUE[__tmp_index], \
                                  PRINTER) \
      end \
    end \
    else begin \
      int __tmp_curr; \
      foreach(VALUE[__tmp_index]) begin \
        if (__tmp_curr < __tmp_begin_elements) begin \
          `m_uvm_print_named_object($sformatf("[%0d]", __tmp_index), \
                                    VALUE[__tmp_index], \
                                    PRINTER) \
        end \
        else \
          break; \
        __tmp_curr++; \
      end \
      if (__tmp_curr < __tmp_max ) begin \
        if ((__tmp_max - __tmp_end_elements) > __tmp_curr) \
          __tmp_curr  = __tmp_max - __tmp_end_elements; \
        if (__tmp_curr < __tmp_begin_elements) \
          __tmp_curr = __tmp_begin_elements; \
        else \
          PRINTER.print_array_range(__tmp_begin_elements, __tmp_curr-1); \
        while (__tmp_curr < __tmp_max) begin \
          `m_uvm_print_named_object($sformatf("[%0d]", __tmp_curr), \
                                    VALUE[__tmp_curr], \
                                    PRINTER) \
          __tmp_curr++; \
        end \
      end \
    end \
    if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
        (__tmp_recursion_policy != RECURSION_POLICY)) \
      PRINTER.set_recursion_policy(__tmp_recursion_policy); \
  end \
  PRINTER.print_array_footer(__tmp_max); \
end
`define uvm_print_array_object(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(da, `"VALUE`", VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_named_array_object(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(da, NAME, VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_sarray_object(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(sa, `"VALUE`", VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_named_sarray_object(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(sa, NAME, VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_queue_object(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(queue, `"VALUE`", VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_named_queue_object(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_qda_object(queue, NAME, VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_qda_string(ARRAY_TYPE, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(ARRAY_TYPE, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_qda_string(ARRAY_TYPE, NAME, VALUE, PRINTER=printer) \
begin \
  int __tmp_max = $right(VALUE) + 1; \
  PRINTER.print_array_header(NAME, \
                             __tmp_max, \
                             `"ARRAY_TYPE``(string)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    int __tmp_begin_elements, __tmp_end_elements; \
    __tmp_begin_elements    = PRINTER.get_begin_elements(); \
    __tmp_end_elements      = PRINTER.get_end_elements(); \
    /* Fast Bypass */ \
    if (__tmp_begin_elements == -1 || __tmp_end_elements == -1) begin \
      foreach (VALUE[__tmp_index]) begin \
        `uvm_print_named_string($sformatf("[%0d]", __tmp_index), \
                                VALUE[__tmp_index], \
                                PRINTER) \
      end \
    end \
    else begin \
      int __tmp_curr; \
      foreach(VALUE[__tmp_index]) begin \
        if (__tmp_curr < __tmp_begin_elements) begin \
          `uvm_print_named_string($sformatf("[%0d]", __tmp_index), \
                                  VALUE[__tmp_index], \
                                  PRINTER) \
        end \
        else \
          break; \
        __tmp_curr++; \
      end \
      if (__tmp_curr < __tmp_max ) begin \
        if ((__tmp_max - __tmp_end_elements) > __tmp_curr) \
          __tmp_curr  = __tmp_max - __tmp_end_elements; \
        if (__tmp_curr < __tmp_begin_elements) \
          __tmp_curr = __tmp_begin_elements; \
        else \
          PRINTER.print_array_range(__tmp_begin_elements, __tmp_curr-1); \
        while (__tmp_curr < __tmp_max) begin \
          `uvm_print_named_string($sformatf("[%0d]", __tmp_curr), \
                                  VALUE[__tmp_curr], \
                                  PRINTER) \
          __tmp_curr++; \
        end \
      end \
    end \
  end \
  PRINTER.print_array_footer(__tmp_max); \
end
`define uvm_print_array_string(VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(da, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_array_string(NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(da, NAME, VALUE, PRINTER)
`define uvm_print_sarray_string(VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(sa, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_sarray_string(NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(sa, NAME, VALUE, PRINTER)
`define uvm_print_queue_string(VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(queue, `"VALUE`", VALUE, PRINTER)
`define uvm_print_named_queue_string(NAME, VALUE, PRINTER=printer) \
  `uvm_print_named_qda_string(queue, NAME, VALUE, PRINTER)
`define uvm_print_aa_int_string(VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
  `uvm_print_named_aa_int_string(`"VALUE`", VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_aa_int_string(NAME, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=integral, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             `"aa(``VALUE_TYPE``,string)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    foreach(VALUE[__tmp_index]) \
      `uvm_print_named_int($sformatf("[%s]", __tmp_index), \
                           VALUE[__tmp_index], \
                           $bits(VALUE[__tmp_index]), \
                           RADIX, \
                           VALUE_TYPE, \
                           PRINTER ) \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_aa_object_string(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
  `uvm_print_named_aa_object_string(`"VALUE`", VALUE, RECURSION_POLICY, PRINTER)
`define uvm_print_named_aa_object_string(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             "aa(object,string)"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    uvm_recursion_policy_enum __tmp_recursion_policy; \
    __tmp_recursion_policy  = PRINTER.get_recursion_policy(); \
    if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
        (__tmp_recursion_policy != RECURSION_POLICY)) \
      PRINTER.set_recursion_policy(RECURSION_POLICY); \
    foreach(VALUE[__tmp_index]) \
      `m_uvm_print_named_object($sformatf("[%s]", __tmp_index), \
                                VALUE[__tmp_index], \
                                PRINTER ) \
    if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
        (__tmp_recursion_policy != RECURSION_POLICY)) \
      PRINTER.set_recursion_policy(__tmp_recursion_policy); \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_aa_string_string(VALUE, PRINTER=printer) \
  `uvm_print_named_aa_string_string(`"VALUE`", VALUE, PRINTER)
`define uvm_print_named_aa_string_string(NAME, VALUE, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             "aa(string,string)"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    foreach(VALUE[__tmp_index]) \
      `uvm_print_named_string($sformatf("[%s]", __tmp_index), \
                              VALUE[__tmp_index], \
                              PRINTER ) \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_aa_int_int(VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=int, INDEX_TYPE=int, PRINTER=printer) \
  `uvm_print_named_aa_int_int(`"VALUE`", VALUE, RADIX, VALUE_TYPE, INDEX_TYPE, PRINTER)
`define uvm_print_named_aa_int_int(NAME, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=int, INDEX_TYPE=int, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             `"aa(``VALUE_TYPE``,``INDEX_TYPE``)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    foreach(VALUE[__tmp_index]) \
      `uvm_print_named_int($sformatf("[%0d]", __tmp_index), \
                           VALUE[__tmp_index], \
                           $bits(VALUE[__tmp_index]), \
                           RADIX, \
                           VALUE_TYPE, \
                           PRINTER ) \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_aa_object_int(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, INDEX_TYPE=int, PRINTER=printer) \
  `uvm_print_named_aa_object_int(`"VALUE`", VALUE, RECURSION_POLICY, INDEX_TYPE, PRINTER)
`define uvm_print_named_aa_object_int(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, INDEX_TYPE=int, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             `"aa(object,``INDEX_TYPE``)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    uvm_recursion_policy_enum __tmp_recursion_policy; \
    __tmp_recursion_policy  = PRINTER.get_recursion_policy(); \
    if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
        (__tmp_recursion_policy != RECURSION_POLICY)) \
      PRINTER.set_recursion_policy(RECURSION_POLICY); \
    foreach(VALUE[__tmp_index]) \
      `m_uvm_print_named_object($sformatf("[%0d]", __tmp_index), \
                                VALUE[__tmp_index], \
                                PRINTER ) \
    if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
        (__tmp_recursion_policy != RECURSION_POLICY)) \
      PRINTER.set_recursion_policy(__tmp_recursion_policy); \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_aa_string_int(VALUE, INDEX_TYPE=int, PRINTER=printer) \
  `uvm_print_named_aa_string_int(`"VALUE`", VALUE, INDEX_TYPE, PRINTER)
`define uvm_print_named_aa_string_int(NAME, VALUE, INDEX_TYPE=int, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             `"aa(string,``INDEX_TYPE``)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    foreach(VALUE[__tmp_index]) \
      `uvm_print_named_string($sformatf("[%0d]", __tmp_index), \
                              VALUE[__tmp_index], \
                              PRINTER ) \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_aa_int_enum(ENUM_TYPE, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=int, PRINTER=printer) \
  `uvm_print_named_aa_int_enum(`"VALUE`", ENUM_TYPE, VALUE, RADIX, VALUE_TYPE, PRINTER)
`define uvm_print_named_aa_int_enum(NAME, ENUM_TYPE, VALUE, RADIX=UVM_NORADIX, VALUE_TYPE=int, PRINTER=printer) \
begin \
  PRINTER.print_array_header(NAME, \
                             VALUE.num(), \
                             `"aa(``VALUE_TYPE``,``ENUM_TYPE``)`"); \
  if ((PRINTER.get_max_depth() == -1) || \
      (PRINTER.get_active_object_depth() < PRINTER.get_max_depth()+1)) begin \
    foreach(VALUE[__tmp_index]) \
      `uvm_print_named_int((__tmp_index.name() == "") ? $sformatf("[%s'(%0d)]", `"ENUM_TYPE`",__tmp_index) \
                                                      : $sformatf("[%s]", __tmp_index.name()), \
                           VALUE[__tmp_index], \
                           $bits(VALUE[__tmp_index]), \
                           RADIX, \
                           VALUE_TYPE, \
                           PRINTER ) \
  end \
  PRINTER.print_array_footer(VALUE.num()); \
end
`define uvm_print_int3(F, R, P) \
  `uvm_print_int(F, $bits(F), R, , P)
`define uvm_print_int4(F, R, NM, P) \
  `uvm_print_named_int(NM, F, $bits(F), R, , P)
`define uvm_print_object2(F, P) \
  `uvm_print_object(F, ,P)
`define uvm_print_string2(F, P) \
  `uvm_print_string(F, P)
`define uvm_print_array_int3(F, R, P) \
  `uvm_print_named_qda_int(da, `"F`", F, R, ,P)
`define uvm_print_sarray_int3(F, R, P) \
  `uvm_print_named_qda_int(sa, `"F`", F, R, ,P)
`define uvm_print_qda_int4(F, R, P, T) \
  `uvm_print_named_qda_int(T, `"F`", F, R, ,P)
`define uvm_print_queue_int3(F, R, P) \
  `uvm_print_named_qda_int(queue, `"F`", F, R, ,P)
`define uvm_print_array_object3(F, P, FLAG) \
  `uvm_print_array_object(F, ,P)
`define uvm_print_sarray_object3(F, P,FLAG) \
  `uvm_print_sarray_object(F, ,P)
`define uvm_print_object_qda4(F, P, T, FLAG) \
  `uvm_print_named_qda_object(T, `"F`", F, ,P)
`define uvm_print_object_queue3(F, P, FLAG) \
  `uvm_print_queue_object(F, ,P)
`define uvm_print_array_string2(F, P) \
  `uvm_print_array_string(F, P)
`define uvm_print_sarray_string2(F, P) \
  `uvm_print_sarray_string(F, P)
`define uvm_print_string_qda3(F, P, T) \
  `uvm_print_named_qda_string(T, `"F`", F, P)
`define uvm_print_string_queue2(F, P) \
  `uvm_print_queue_string(F, P)
`define uvm_print_aa_string_int3(F, R, P) \
  `uvm_print_aa_int_string(F, R, ,P)
`define uvm_print_aa_string_object3(F, P, FLAG) \
  `uvm_print_aa_object_string(F, ,P)
`define uvm_print_aa_string_string2(F, P) \
  `uvm_print_aa_string_string(F, P)
`define uvm_print_aa_int_object3(F, P, FLAG) \
  `uvm_print_aa_object_int(F, ,P)
`define uvm_print_aa_int_key4(KEY, F, R, P) \
  `uvm_print_aa_int_int(F, R, ,KEY, P)
`define UVM_COMPARER_DEFINES_SVH
`define m_uvm_compare_threshold_begin(COMPARER) \
  if ((!COMPARER.get_threshold() || \
       (COMPARER.get_result() < COMPARER.get_threshold()))) begin \

`define m_uvm_compare_threshold_end \
  end
`define m_uvm_compare_begin(LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_threshold_begin(COMPARER) \
    if ((LVALUE) !== (RVALUE)) begin \

`define m_uvm_compare_end \
    end \
  `m_uvm_compare_threshold_end
`define uvm_compare_int(LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `uvm_compare_named_int(`"LVALUE`", LVALUE, RVALUE, RADIX, COMPARER)
`define uvm_compare_named_int(NAME, LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
     if ($bits(LVALUE) <= 64) \
       void'(COMPARER.compare_field_int(NAME , LVALUE, RVALUE, $bits(LVALUE), RADIX)); \
     else \
       void'(COMPARER.compare_field(NAME , LVALUE, RVALUE, $bits(LVALUE), RADIX)); \
  `m_uvm_compare_end
`define uvm_compare_enum(LVALUE, RVALUE, TYPE, COMPARER=comparer) \
  `uvm_compare_named_enum(`"LVALUE`", LVALUE, RVALUE, TYPE, COMPARER)
`define uvm_compare_named_enum(NAME, LVALUE, RVALUE, TYPE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
     void'(COMPARER.compare_string(NAME , \
                                   $sformatf("%s'(%s)", `"TYPE`", LVALUE.name()), \
                                   $sformatf("%s'(%s)", `"TYPE`", RVALUE.name())) ); \
  `m_uvm_compare_end
`define uvm_compare_real(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_real(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_real(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_threshold_begin(COMPARER) \
    if ((LVALUE) != (RVALUE)) begin \
      void'(COMPARER.compare_field_real(NAME , LVALUE, RVALUE)); \
    end \
  `m_uvm_compare_threshold_end
`define uvm_compare_object(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `uvm_compare_named_object(`"LVALUE`", LVALUE, RVALUE, POLICY, COMPARER)
`define uvm_compare_named_object(NAME, LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
     uvm_recursion_policy_enum prev_rec__; \
     prev_rec__ = COMPARER.get_recursion_policy(); \
     if (POLICY != UVM_DEFAULT_POLICY) \
       COMPARER.set_recursion_policy(POLICY); \
     `m_uvm_compare_named_object(NAME, LVALUE, RVALUE, COMPARER) \
     if (POLICY != UVM_DEFAULT_POLICY) \
       COMPARER.set_recursion_policy(prev_rec__); \
  `m_uvm_compare_end
`define m_uvm_compare_named_object(NAME, LVALUE, RVALUE, COMPARER) \
  if (COMPARER.get_recursion_policy() != UVM_REFERENCE) begin \
    bit local_rv__; \
    uvm_policy::recursion_state_e local_state__; \
    local_state__ = COMPARER.object_compared(LVALUE, RVALUE, COMPARER.get_recursion_policy(), local_rv__); \
    if ((local_state__ == uvm_policy::FINISHED) && \
        !local_rv__) \
      COMPARER.print_msg($sformatf("'%s' miscompared using saved return value", NAME)); \
    else if (local_state__ == uvm_policy::NEVER) \
      void'(COMPARER.compare_object(NAME, LVALUE, RVALUE)); \
    /* else skip to avoid infinite loop */ \
  end \
  else begin \
    void'(COMPARER.compare_object(NAME, LVALUE, RVALUE)); \
  end
`define uvm_compare_string(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_string(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_string(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_threshold_begin(COMPARER) \
    if ((LVALUE) != (RVALUE)) begin \
      void'(COMPARER.compare_string(NAME , LVALUE, RVALUE)); \
    end \
  `m_uvm_compare_threshold_end
`define uvm_compare_sarray_int(LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `uvm_compare_named_sarray_int(`"LVALUE`", LVALUE, RVALUE, RADIX, COMPARER)
`define uvm_compare_named_sarray_int(NAME, LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach (LVALUE[i]) begin \
      `uvm_compare_named_int($sformatf("%s[%0d]", NAME, i), \
                             LVALUE[i], \
                             RVALUE[i], \
                             RADIX, \
                             COMPARER) \
    end \
  `m_uvm_compare_end
`define uvm_compare_qda_int(LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `uvm_compare_named_qda_int(`"LVALUE`", LVALUE, RVALUE, RADIX, COMPARER)
`define uvm_compare_named_qda_int(NAME, LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    `uvm_compare_named_int($sformatf("%s.size()", NAME), \
                           LVALUE.size(), \
                           RVALUE.size(), \
                           UVM_DEC, \
                           COMPARER) \
    `uvm_compare_named_sarray_int(NAME, LVALUE, RVALUE, RADIX, COMPARER) \
  `m_uvm_compare_end
`define uvm_compare_sarray_real(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_sarray_real(`"LVALUE`", LVALUE, RVALUE,COMPARER)
`define uvm_compare_named_sarray_real(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_threshold_begin(COMPARER) \
    if ((LVALUE) != (RVALUE)) begin \
      foreach (LVALUE[i]) begin \
        `uvm_compare_named_real($sformatf("%s[%0d]", NAME, i), \
                               LVALUE[i], \
                               RVALUE[i], \
                               COMPARER) \
      end \
    end \
  `m_uvm_compare_threshold_end
`define uvm_compare_qda_real(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_qda_real(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_qda_real(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_threshold_begin(COMPARER) \
    `uvm_compare_named_real($sformatf("%s.size()", NAME), \
                           LVALUE.size(), \
                           RVALUE.size(), \
                           COMPARER) \
    `uvm_compare_named_sarray_real(NAME, LVALUE, RVALUE, COMPARER) \
  `m_uvm_compare_threshold_end
`define uvm_compare_sarray_enum(LVALUE, RVALUE, TYPE, COMPARER=comparer) \
  `uvm_compare_named_sarray_enum(`"LVALUE`", LVALUE, RVALUE, TYPE, COMPARER)
`define uvm_compare_named_sarray_enum(NAME, LVALUE, RVALUE, TYPE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach (LVALUE[i]) begin \
      `uvm_compare_named_enum($sformatf("%s[%0d]", NAME, i), \
                              LVALUE[i], \
                              RVALUE[i], \
                              TYPE, \
                              COMPARER) \
    end \
  `m_uvm_compare_end
`define uvm_compare_qda_enum(LVALUE, RVALUE, TYPE, COMPARER=comparer) \
  `uvm_compare_named_qda_enum(`"LVALUE`", LVALUE, RVALUE, TYPE, COMPARER)
`define uvm_compare_named_qda_enum(NAME, LVALUE, RVALUE, TYPE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    `uvm_compare_named_int($sformatf("%s.size()", NAME), \
                           LVALUE.size(), \
                           RVALUE.size(), \
                           UVM_DEC, \
                           COMPARER) \
    `uvm_compare_named_sarray_enum(NAME, LVALUE, RVALUE, TYPE, COMPARER) \
  `m_uvm_compare_end
`define uvm_compare_sarray_object(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `uvm_compare_named_sarray_object(`"LVALUE`", LVALUE, RVALUE, POLICY, COMPARER)
`define uvm_compare_named_sarray_object(NAME, LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    uvm_recursion_policy_enum prev_rec__; \
    prev_rec__ = COMPARER.get_recursion_policy(); \
    if (POLICY != UVM_DEFAULT_POLICY) \
      COMPARER.set_recursion_policy(POLICY); \
    foreach (LVALUE[i]) begin \
      `m_uvm_compare_named_object($sformatf("%s[%0d]", NAME, i), \
                                  LVALUE[i], \
                                  RVALUE[i], \
                                  COMPARER) \
    end \
    if (POLICY != UVM_DEFAULT_POLICY) \
      COMPARER.set_recursion_policy(prev_rec__); \
  `m_uvm_compare_end
`define uvm_compare_qda_object(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `uvm_compare_named_qda_object(`"LVALUE`", LVALUE, RVALUE, POLICY, COMPARER)
`define uvm_compare_named_qda_object(NAME, LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    `uvm_compare_named_int($sformatf("%s.size()", NAME), \
                           LVALUE.size(), \
                           RVALUE.size(), \
                           UVM_DEC, \
                           COMPARER) \
    `uvm_compare_named_sarray_object(NAME, LVALUE, RVALUE, POLICY, COMPARER) \
  `m_uvm_compare_end
`define uvm_compare_sarray_string(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_sarray_string(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_sarray_string(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach (LVALUE[i]) begin \
      `uvm_compare_named_string($sformatf("%s[%0d]", NAME, i), \
                                LVALUE[i], \
                                RVALUE[i], \
                                COMPARER) \
    end \
  `m_uvm_compare_end
`define uvm_compare_qda_string(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_qda_string(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_qda_string(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    `uvm_compare_named_int($sformatf("%s.size()", NAME), \
                           LVALUE.size(), \
                           RVALUE.size(), \
                           UVM_DEC, \
                           COMPARER) \
    `uvm_compare_named_sarray_string(NAME, LVALUE, RVALUE, COMPARER) \
  `m_uvm_compare_end
`define uvm_compare_aa_int_string(LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `uvm_compare_named_aa_int_string(`"LVALUE`", LVALUE, RVALUE, RADIX, COMPARER)
`define uvm_compare_named_aa_int_string(NAME, LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach(LVALUE[i]) begin \
      if (!RVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%s' not in RHS", NAME, i)); \
      end \
      else begin \
        `uvm_compare_named_int($sformatf("%s[%s]", NAME, i), \
                               LVALUE[i], \
                               RVALUE[i], \
                               RADIX, \
                               COMPARER) \
      end \
    end \
    foreach(RVALUE[i]) begin \
      if(!LVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%s' not in LHS", NAME, i)); \
      end \
    end \
  `m_uvm_compare_end
`define uvm_compare_aa_object_string(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `uvm_compare_named_aa_object_string(`"LVALUE`", LVALUE, RVALUE, POLICY, COMPARER)
`define uvm_compare_named_aa_object_string(NAME, LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    uvm_recursion_policy_enum prev_rec__; \
    prev_rec__ = COMPARER.get_recursion_policy(); \
    if (POLICY != UVM_DEFAULT_POLICY) \
      COMPARER.set_recursion_policy(POLICY); \
    foreach(LVALUE[i]) begin \
      if (!RVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%s' not in RHS", NAME, i)); \
      end \
      else begin \
        `m_uvm_compare_named_object($sformatf("%s[%s]", NAME, i), \
                                    LVALUE[i], \
                                    RVALUE[i], \
                                    COMPARER) \
      end \
    end \
    foreach(RVALUE[i]) begin \
      if(!LVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%s' not in LHS", NAME, i)); \
      end \
    end \
    if (POLICY != UVM_DEFAULT_POLICY) \
      COMPARER.set_recursion_policy(prev_rec__); \
  `m_uvm_compare_end
`define uvm_compare_aa_string_string(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_aa_string_string(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_aa_string_string(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach(LVALUE[i]) begin \
      if (!RVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%s' not in RHS", NAME, i)); \
      end \
      else begin \
        `uvm_compare_named_string($sformatf("%s[%s]", NAME, i), \
                                  LVALUE[i], \
                                  RVALUE[i], \
                                  COMPARER) \
      end \
    end \
    foreach(RVALUE[i]) begin \
      if(!LVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%s' not in LHS", NAME, i)); \
      end \
    end \
  `m_uvm_compare_end
`define uvm_compare_aa_int_int(LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `uvm_compare_named_aa_int_int(`"LVALUE`", LVALUE, RVALUE, RADIX, COMPARER)
`define uvm_compare_named_aa_int_int(NAME, LVALUE, RVALUE, RADIX, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach(LVALUE[i]) begin \
      if (!RVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%0d' not in RHS", NAME, i)); \
      end \
      else begin \
        `uvm_compare_named_int($sformatf("%s[%d]", NAME, i), \
                               LVALUE[i], \
                               RVALUE[i], \
                               RADIX, \
                               COMPARER) \
      end \
    end \
    foreach(RVALUE[i]) begin \
      if(!LVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%0d' not in LHS", NAME, i)); \
      end \
    end \
  `m_uvm_compare_end
`define uvm_compare_aa_object_int(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `uvm_compare_named_aa_object_int(`"LVALUE`", LVALUE, RVALUE, POLICY, COMPARER)
`define uvm_compare_named_aa_object_int(NAME, LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    uvm_recursion_policy_enum prev_rec__; \
    prev_rec__ = COMPARER.get_recursion_policy(); \
    if (POLICY != UVM_DEFAULT_POLICY) \
      COMPARER.set_recursion_policy(POLICY); \
    foreach(LVALUE[i]) begin \
      if (!RVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%0d' not in RHS", NAME, i)); \
      end \
      else begin \
        `m_uvm_compare_named_object($sformatf("%s[%s]", NAME, i), \
                                    LVALUE[i], \
                                    RVALUE[i], \
                                    COMPARER) \
      end \
    end \
    foreach(RVALUE[i]) begin \
      if(!LVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%0d' not in LHS", NAME, i)); \
      end \
    end \
    if (POLICY != UVM_DEFAULT_POLICY) \
      COMPARER.set_recursion_policy(prev_rec__); \
  `m_uvm_compare_end
`define uvm_compare_aa_string_int(LVALUE, RVALUE, COMPARER=comparer) \
  `uvm_compare_named_aa_string_int(`"LVALUE`", LVALUE, RVALUE, COMPARER)
`define uvm_compare_named_aa_string_int(NAME, LVALUE, RVALUE, COMPARER=comparer) \
  `m_uvm_compare_begin(LVALUE, RVALUE, COMPARER) \
    foreach(LVALUE[i]) begin \
      if (!RVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%d' not in RHS", NAME, i)); \
      end \
      else begin \
        `uvm_compare_named_string($sformatf("%s[%d]", NAME, i), \
                                  LVALUE[i], \
                                  RVALUE[i], \
                                  COMPARER) \
      end \
    end \
    foreach(RVALUE[i]) begin \
      if(!LVALUE.exists(i)) begin \
        COMPARER.print_msg($sformatf("%s: Key '%d' not in LHS", NAME, i)); \
      end \
    end \
  `m_uvm_compare_end
`define UVM_RECORDER_DEFINES_SVH
`define uvm_record_attribute(TR_HANDLE,NAME,VALUE,RECORDER=recorder) \
      RECORDER.record_generic(NAME, $sformatf("%p", VALUE));
`define uvm_record_int(NAME,VALUE,SIZE,RADIX = UVM_NORADIX,RECORDER=recorder) \
    if (RECORDER != null && RECORDER.is_open()) begin \
      if (RECORDER.use_record_attribute()) \
        `uvm_record_attribute(RECORDER.get_record_attribute_handle(),NAME,VALUE,RECORDER) \
      else \
        if (SIZE > 64) \
          RECORDER.record_field(NAME, VALUE, SIZE, RADIX); \
        else \
          RECORDER.record_field_int(NAME, VALUE, SIZE, RADIX); \
    end
`define uvm_record_string(NAME,VALUE,RECORDER=recorder) \
    if (RECORDER != null && RECORDER.is_open()) begin \
      if (RECORDER.use_record_attribute()) \
        `uvm_record_attribute(RECORDER.get_record_attribute_handle(),NAME,VALUE,RECORDER) \
      else \
        RECORDER.record_string(NAME,VALUE); \
    end
`define uvm_record_time(NAME,VALUE,RECORDER=recorder) \
    if (RECORDER != null && RECORDER.is_open()) begin \
      if (RECORDER.use_record_attribute()) \
        `uvm_record_attribute(RECORDER.get_record_attribute_handle(),NAME,VALUE,RECORDER) \
      else \
         RECORDER.record_time(NAME,VALUE); \
    end
`define uvm_record_real(NAME,VALUE,RECORDER=recorder) \
    if (RECORDER != null && RECORDER.is_open()) begin \
      if (RECORDER.use_record_attribute()) \
        `uvm_record_attribute(RECORDER.get_record_attribute_handle(),NAME,VALUE,RECORDER) \
      else \
        RECORDER.record_field_real(NAME,VALUE); \
    end
`define uvm_record_field(NAME,VALUE,RECORDER=recorder) \
   if (RECORDER != null && RECORDER.is_open()) begin \
     if (RECORDER.use_record_attribute()) begin \
       `uvm_record_attribute(RECORDER.get_record_attribute_handle(),NAME,VALUE,RECORDER) \
     end \
     else \
       RECORDER.record_generic(NAME, $sformatf("%p", VALUE)); \
   end
`define uvm_record_enum(NAME,VALUE,TYPE,RECORDER=recorder) \
  if (RECORDER != null && RECORDER.is_open()) begin \
    if (RECORDER.use_record_attribute()) begin \
       `uvm_record_attribute(RECORDER.get_record_attribute_handle(),NAME,VALUE,RECORDER) \
    end \
    else begin \
      if (VALUE.name() == "") \
        RECORDER.record_generic(NAME, $sformatf("%0d", VALUE), `"TYPE`"); \
      else \
        RECORDER.record_generic(NAME, VALUE.name(), `"TYPE`"); \
    end \
 end
`define uvm_record_object(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, RECORDER=recorder) \
  `uvm_record_named_object(`"VALUE`", VALUE, RECURSION_POLICY, RECORDER)
`define uvm_record_named_object(NAME, VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, RECORDER=recorder) \
if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
    (RECURSION_POLICY != RECORDER.get_recursion_policy())) begin \
  uvm_recursion_policy_enum __saved_recursion_policy  = RECORDER.get_recursion_policy(); \
  RECORDER.set_recursion_policy(RECURSION_POLICY); \
  `m_uvm_record_named_object(NAME, VALUE, RECORDER) \
  RECORDER.set_recursion_policy(__saved_recursion_policy); \
end \
else begin \
  `m_uvm_record_named_object(NAME, VALUE, RECORDER) \
end
`define m_uvm_record_named_object(NAME, VALUE, RECORDER) \
if (RECORDER.object_recorded(VALUE, RECORDER.get_recursion_policy()) != uvm_policy::NEVER) begin \
  uvm_recursion_policy_enum __saved_recursion_policy = RECORDER.get_recursion_policy(); \
  RECORDER.set_recursion_policy(UVM_REFERENCE); \
  RECORDER.record_object(NAME, VALUE); \
  RECORDER.set_recursion_policy(__saved_recursion_policy); \
end \
else begin \
  RECORDER.record_object(NAME, VALUE); \
end
`define uvm_record_qda_int(ARG, RADIX,RECORDER=recorder) \
  begin \
    int sz__ = $size(ARG); \
    if(sz__ == 0) begin \
      `uvm_record_int(`"ARG`", 0, 32, UVM_DEC,RECORDER) \
    end \
    else if(sz__ < 10) begin \
      foreach(ARG[i]) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_int(nm__, ARG[i], $bits(ARG[i]), RADIX, RECORDER) \
      end \
    end \
    else begin \
      for(int i=0; i<5; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_int(nm__, ARG[i], $bits(ARG[i]), RADIX, RECORDER) \
      end \
      for(int i=sz__-5; i<sz__; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_int(nm__, ARG[i], $bits(ARG[i]), RADIX, RECORDER) \
      end \
    end \
  end
`define uvm_record_qda_object(VALUE, RECURSION_POLICY=UVM_DEFAULT_POLICY, RECORDER=recorder) \
   begin \
    int sz__ = $size(VALUE); \
     if(sz__ == 0) begin \
      `uvm_record_int(`"VALUE`", 0, 32, UVM_DEC, RECORDER) \
     end \
    else begin \
      uvm_recursion_policy_enum __tmp_recursion_policy; \
      __tmp_recursion_policy  = RECORDER.get_recursion_policy(); \
      if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
          (__tmp_recursion_policy != RECURSION_POLICY)) \
        RECORDER.set_recursion_policy(RECURSION_POLICY); begin \
        if(sz__ < 10) begin \
          foreach(VALUE[__tmp_index]) begin \
            `m_uvm_record_named_object($sformatf("%s[%0d]", `"VALUE`", __tmp_index), \
                                      VALUE[__tmp_index], \
                                      RECORDER) \
           end \
         end \
         else begin \
          for(int __tmp_index=0; __tmp_index<5; ++__tmp_index) begin \
            `m_uvm_record_named_object($sformatf("%s[%0d]", `"VALUE`", __tmp_index), \
                                      VALUE[__tmp_index], \
                                      RECORDER) \
          end \
          for(int __tmp_index=sz__-5; __tmp_index<sz__; ++__tmp_index) begin \
            `m_uvm_record_named_object($sformatf("%s[%0d]", `"VALUE`", __tmp_index), \
                                      VALUE[__tmp_index], \
                                      RECORDER) \
          end \
         end \
       end \
      if ((RECURSION_POLICY != UVM_DEFAULT_POLICY) && \
          (__tmp_recursion_policy != RECURSION_POLICY)) \
        RECORDER.set_recursion_policy(__tmp_recursion_policy); \
     end \
   end
`define uvm_record_qda_enum(ARG, T,RECORDER=recorder) \
  begin \
    int sz__ = $size(ARG); \
    if(sz__ == 0) begin \
      `uvm_record_int(`"ARG`", 0, 32, UVM_DEC, RECORDER) \
    end \
    else if(sz__ < 10) begin \
      foreach(ARG[i]) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_enum(nm__, ARG[i], T, RECORDER) \
      end \
    end \
    else begin \
      for(int i=0; i<5; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_enum(nm__, ARG[i], T, RECORDER) \
      end \
      for(int i=sz__-5; i<sz__; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_enum(nm__, ARG[i], T, RECORDER) \
      end \
    end \
  end
`define uvm_record_qda_string(ARG,RECORDER=recorder) \
  begin \
    int sz__; \
    /* workaround for sarray string + $size */ \
    foreach (ARG[i]) \
      sz__ = i; \
    if(sz__ == 0) begin \
      `uvm_record_int(`"ARG`", 0, 32, UVM_DEC, RECORDER) \
    end \
    else if(sz__ < 10) begin \
      foreach(ARG[i]) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_string(nm__, ARG[i], RECORDER) \
      end \
    end \
    else begin \
      for(int i=0; i<5; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_string(nm__, ARG[i], RECORDER) \
      end \
      for(int i=sz__-5; i<sz__; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_string(nm__, ARG[i], RECORDER) \
      end \
    end \
  end
`define uvm_record_qda_real(ARG,RECORDER=recorder) \
  begin \
    int sz__; \
    /* workaround for sarray real + $size */ \
    foreach (ARG[i]) \
      sz__ = i; \
    if(sz__ == 0) begin \
      `uvm_record_int(`"ARG`", 0, 32, UVM_DEC, RECORDER) \
    end \
    else if(sz__ < 10) begin \
      foreach(ARG[i]) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_real(nm__, ARG[i], RECORDER) \
      end \
    end \
    else begin \
      for(int i=0; i<5; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_real(nm__, ARG[i], RECORDER) \
      end \
      for(int i=sz__-5; i<sz__; ++i) begin \
        string nm__ = $sformatf("%s[%0d]", `"ARG`", i); \
        `uvm_record_real(nm__, ARG[i], RECORDER) \
      end \
    end \
  end
`define UVM_RESOURCE_DEFINES_SVH
`define uvm_resource_read(SUCCESS, RSRC, TYPE, VAL, OBJ=null) \
begin                                                           \
  uvm_resource#(TYPE) __tmp_rsrc__;                             \
  SUCCESS = $cast(__tmp_rsrc__, RSRC);                          \
  if (SUCCESS) begin                                            \
    VAL = __tmp_rsrc__.read(OBJ);                               \
  end                                                           \
end
`define uvm_resource_builtin_int_read(SUCCESS, RSRC, VAL, OBJ=null) \
begin                                                               \
  `uvm_resource_read(SUCCESS, RSRC, uvm_integral_t, VAL, OBJ)                \
  if (!SUCCESS)                                                     \
    `uvm_resource_read(SUCCESS, RSRC, uvm_bitstream_t, VAL, OBJ)             \
  if (!SUCCESS)                                                     \
    `uvm_resource_read(SUCCESS, RSRC, int, VAL, OBJ)                         \
  if (!SUCCESS)                                                     \
    `uvm_resource_read(SUCCESS, RSRC, int unsigned, VAL, OBJ)                \
end
`define uvm_resource_int_read(SUCCESS, RSRC, TYPE, VAL, OBJ=null) \
begin                                                             \
  `uvm_resource_read(SUCCESS, RSRC, TYPE, VAL, OBJ)               \
  if (!SUCCESS)                                                   \
    `uvm_resource_builtin_int_read(SUCCESS, RSRC, VAL, OBJ)       \
end
`define uvm_resource_enum_read(SUCCESS, RSRC, TYPE, VAL, OBJ=null) \
begin                                                              \
  `uvm_resource_read(SUCCESS, RSRC, TYPE, VAL, OBJ)                \
  if (!SUCCESS) begin                                              \
    TYPE __tmp_val__;                                              \
    string __tmp_string_val__;                                     \
    bit   __tmp_success_val__;                                     \
    `uvm_resource_read(__tmp_success_val__, \
                         RSRC, \
                         string, \
                         __tmp_string_val__, \
                         OBJ)                                      \
    if (__tmp_success_val__ &&                                     \
    uvm_enum_wrapper#(TYPE)::from_name(__tmp_string_val__, \
                       __tmp_val__)) begin     \
       VAL = __tmp_val__;                                          \
       SUCCESS = __tmp_success_val__;                              \
    end                                                            \
  end                                                              \
  if (!SUCCESS) begin                                              \
     typedef bit [$bits(TYPE)-1:0] __tmp_int_t__;                  \
     __tmp_int_t__                 __tmp_int_val__;                \
     bit                __tmp_success_val__;            \
     `uvm_resource_int_read(__tmp_success_val__, \
                RSRC, \
                __tmp_int_t__, \
                __tmp_int_val__, \
                OBJ)                                   \
     if (__tmp_success_val__) begin                                \
       VAL = TYPE'(__tmp_int_val__);                               \
       SUCCESS = __tmp_success_val__;                              \
     end                                                           \
  end                                                              \
end
`define uvm_resource_real_read(SUCCESS, RSRC, VAL, OBJ=null) \
begin                                                              \
  `uvm_resource_read(SUCCESS, RSRC, real, VAL, OBJ)                \
  if (!SUCCESS) begin                                              \
     typedef bit [63:0] __tmp_int_t__;                             \
     __tmp_int_t__      __tmp_int_val__;                           \
     bit             __tmp_success_val__;                       \
     `uvm_resource_int_read(__tmp_success_val__, \
                RSRC, \
                __tmp_int_t__, \
                __tmp_int_val__, \
                OBJ)                                   \
     if (__tmp_success_val__) begin                                \
       VAL = $bitstoreal(__tmp_int_val__);                         \
       SUCCESS = __tmp_success_val__;                              \
     end                                                           \
  end                                                              \
end
`define UVM_PACKER_DEFINES_SVH
`define uvm_pack_intN(VAR,SIZE,PACKER=packer) \
  if (SIZE <= $bits(uvm_integral_t)) begin \
     PACKER.pack_field_int(VAR, SIZE); \
  end \
  else if (SIZE <= $bits(uvm_bitstream_t)) begin \
     PACKER.pack_field(VAR, SIZE); \
  end \
  else begin \
    bit __array[]; \
    { << bit { __array}} = VAR; \
    __array = new [SIZE] (__array); \
    PACKER.pack_bits(__array, SIZE); \
  end
`define uvm_pack_enumN(VAR,SIZE,PACKER=packer) \
   `uvm_pack_intN(VAR,SIZE,PACKER)
`define uvm_packer_array_extension_begin(PACKER) \
  begin \
    uvm_object m__ext; \
    uvm_object m__prev_ext; \
    m__ext = uvm_packer_array_extension::get(); \
    m__prev_ext = PACKER.set_extension(m__ext);
`define uvm_packer_array_extension_end(PACKER) \
    if (m__prev_ext != null) begin \
      void'(PACKER.set_extension(m__prev_ext)); \
    end \
    else begin \
      PACKER.clear_extension(m__ext.get_object_type()); \
    end \
  end
`define uvm_pack_sarrayN(VAR,SIZE,PACKER=packer) \
    `uvm_packer_array_extension_begin(PACKER) \
        foreach(VAR `` [index]) begin \
          `uvm_pack_intN(VAR[index],SIZE,PACKER) \
        end \
    `uvm_packer_array_extension_end(PACKER)
`define uvm_pack_arrayN(VAR,SIZE,PACKER=packer) \
    begin \
      `uvm_pack_intN(VAR.size(),32,PACKER) \
      `uvm_pack_sarrayN(VAR,SIZE,PACKER) \
    end
`define uvm_pack_queueN(VAR,SIZE,PACKER=packer) \
   `uvm_pack_arrayN(VAR,SIZE,PACKER)
`define uvm_pack_int(VAR,PACKER=packer) \
   `uvm_pack_intN(VAR,$bits(VAR),PACKER)
`define uvm_pack_object(VAR,PACKER=packer) \
  PACKER.pack_object_with_meta(VAR);
`define uvm_pack_enum(VAR,PACKER=packer) \
   `uvm_pack_enumN(VAR,$bits(VAR),PACKER)
`define uvm_pack_string(VAR,PACKER=packer) \
  PACKER.pack_string(VAR);
`define uvm_pack_real(VAR,PACKER=packer) \
  PACKER.pack_real(VAR);
`define uvm_pack_sarray(VAR,PACKER=packer) \
   `uvm_pack_sarrayN(VAR,$bits(VAR[0]),PACKER)
`define uvm_pack_array(VAR,PACKER=packer) \
   `uvm_pack_arrayN(VAR,$bits(VAR[0]),PACKER)
`define uvm_pack_da(VAR,PACKER=packer) \
  `uvm_pack_array(VAR,PACKER)
`define uvm_pack_queue(VAR,PACKER=packer) \
   `uvm_pack_queueN(VAR,$bits(VAR[0]),PACKER)
`define uvm_unpack_intN(VAR,SIZE,PACKER=packer) \
  if (SIZE <= $bits(uvm_integral_t)) begin \
    VAR = PACKER.unpack_field_int(SIZE); \
  end \
  else if (SIZE <= $bits(uvm_bitstream_t)) begin \
    VAR = PACKER.unpack_field(SIZE); \
  end \
  else begin \
    bit __array[] = new [SIZE]; \
    PACKER.unpack_bits(__array, SIZE); \
    __array = new [$bits(VAR)] (__array); \
    VAR = { << bit { __array }}; \
  end
`define uvm_unpack_enumN(VAR,SIZE,TYPE,PACKER=packer) \
  begin \
    bit __array[] = new [SIZE]; \
    PACKER.unpack_bits(__array, SIZE); \
    __array = new [$bits(VAR)] (__array); \
    VAR = TYPE'({ << bit { __array }}); \
  end
`define uvm_unpack_sarrayN(VAR,SIZE,PACKER=packer) \
    `uvm_packer_array_extension_begin(PACKER) \
        foreach (VAR `` [i]) begin \
          `uvm_unpack_intN(VAR``[i], SIZE, PACKER) \
        end \
    `uvm_packer_array_extension_end(PACKER)
`define uvm_unpack_arrayN(VAR,SIZE,PACKER=packer) \
    begin \
      int sz__; \
      `uvm_unpack_intN(sz__,32,PACKER) \
      VAR = new[sz__]; \
      `uvm_unpack_sarrayN(VAR,SIZE,PACKER) \
    end
`define uvm_unpack_queueN(VAR,SIZE,PACKER=packer) \
    begin \
      int sz__; \
      `uvm_unpack_intN(sz__,32,PACKER) \
      while (VAR.size() > sz__) \
        void'(VAR.pop_back()); \
      for (int i=0; i<sz__; i++) \
        `uvm_unpack_intN(VAR[i],SIZE,PACKER) \
    end
`define uvm_unpack_int(VAR,PACKER=packer) \
   `uvm_unpack_intN(VAR,$bits(VAR),PACKER)
`define uvm_unpack_object(VAR,PACKER=packer) \
  begin \
    uvm_object __ref = VAR; \
    PACKER.unpack_object_with_meta(__ref); \
    if ((__ref != VAR) && !$cast(VAR,__ref)) begin \
      `uvm_fatal("UVM/UNPACK_EXT/OBJ_CAST_FAILED", \
                {"Could not cast object of type '", __ref.get_type_name(), \
                 "' into '", `"LVALUE`"}) \
    end \
  end
`define uvm_unpack_enum(VAR,TYPE,PACKER=packer) \
   `uvm_unpack_enumN(VAR,$bits(VAR),TYPE,PACKER)
`define uvm_unpack_string(VAR,PACKER=packer) \
  VAR = PACKER.unpack_string();
`define uvm_unpack_real(VAR,PACKER=packer) \
  VAR = PACKER.unpack_real();
`define uvm_unpack_sarray(VAR,PACKER=packer) \
   `uvm_unpack_sarrayN(VAR,$bits(VAR[0]),PACKER)
`define uvm_unpack_array(VAR,PACKER=packer) \
   `uvm_unpack_arrayN(VAR,$bits(VAR[0]),PACKER)
`define uvm_unpack_da(VAR,PACKER=packer) \
  `uvm_unpack_array(VAR,PACKER)
`define uvm_unpack_queue(VAR,PACKER=packer) \
   `uvm_unpack_queueN(VAR,$bits(VAR[0]),PACKER)
`define uvm_pack_aa_int_intN(VAR, SIZE, PACKER=packer) \
begin \
  `uvm_pack_intN(VAR.num(), 32, PACKER) \
  if (VAR.num()) begin \
    `uvm_pack_intN(SIZE, 32, PACKER) \
    foreach(VAR[i]) begin \
      `uvm_pack_intN(i, SIZE, PACKER) \
      `uvm_pack_int(VAR[i],PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_int_intN(VAR, SIZE, PACKER=packer) \
begin \
  int __num__; \
  `uvm_unpack_intN(__num__, 32, PACKER) \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    bit[SIZE-1:0] __index__; \
    int __sz__; \
    `uvm_unpack_intN(__sz__, 32, PACKER) \
    if (SIZE != __sz__) \
      `uvm_error("UVM/UNPACK/AA_INT_SZ", $sformatf("Unpack size '%0d' different from pack size '%0d'", \
                                                   SIZE, \
                                                   __sz__)) \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_intN(__index__, SIZE, PACKER) \
      `uvm_unpack_int(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_object_intN(VAR, SIZE, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    PACKER.pack_field_int(SIZE, 32); \
    foreach(VAR[i]) begin \
      `uvm_pack_intN(i, SIZE, PACKER) \
      `uvm_pack_object(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_object_intN(VAR, SIZE, PACKER=packer) \
begin \
  int __num__; \
  `uvm_unpack_intN(__num__, 32, PACKER) \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    bit[SIZE-1:0] __index__; \
    int __sz__; \
    `uvm_unpack_intN(__sz__, 32, PACKER) \
    if (SIZE != __sz__) \
      `uvm_error("UVM/UNPACK/AA_INT_SZ", $sformatf("Size '%d' insufficient to store '%d' bits", \
                                                   SIZE, \
                                                   __sz__)) \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_intN(__index__, __sz__, PACKER) \
      `uvm_unpack_object(VAR[__index__],PACKER) \
    end \
  end \
end
`define uvm_pack_aa_string_intN(VAR, SIZE, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    PACKER.pack_field_int(SIZE, 32); \
    foreach(VAR[i]) begin \
      `uvm_pack_intN(i, SIZE, PACKER) \
      `uvm_pack_string(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_string_intN(VAR, SIZE, PACKER=packer) \
begin \
  int __num__; \
  `uvm_unpack_intN(__num__, 32, PACKER) \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    bit[SIZE-1:0] __index__; \
    int __sz__; \
    `uvm_unpack_intN(__sz__, 32, PACKER) \
    if (SIZE != __sz__) \
      `uvm_error("UVM/UNPACK/AA_INT_SZ", $sformatf("Size '%d' insufficient to store '%d' bits", \
                                                   SIZE, \
                                                   __sz__)) \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_intN(__index__, __sz__, PACKER) \
      `uvm_unpack_string(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_object_string(VAR, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    foreach(VAR[i]) begin \
      `uvm_pack_string(i, PACKER) \
      `uvm_pack_object(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_object_string(VAR, PACKER=packer) \
begin \
  int __num__ = PACKER.unpack_field_int(32); \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    string __index__; \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_string(__index__, PACKER) \
      `uvm_unpack_object(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_int_string(VAR, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    foreach(VAR[i]) begin \
      `uvm_pack_string(i, PACKER) \
      `uvm_pack_int(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_int_string(VAR, PACKER=packer) \
begin \
  int __num__ = PACKER.unpack_field_int(32); \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    string __index__; \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_string(__index__, PACKER) \
      `uvm_unpack_int(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_string_string(VAR, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    foreach(VAR[i]) begin \
      `uvm_pack_string(i, PACKER) \
      `uvm_pack_string(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_string_string(VAR, PACKER=packer) \
begin \
  int __num__ = PACKER.unpack_field_int(32); \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    string __index__; \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_string(__index__, PACKER) \
      `uvm_unpack_string(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_int_enum(VAR, TYPE, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    foreach(VAR[i]) begin \
      `uvm_pack_enum(i, PACKER) \
      `uvm_pack_int(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_int_enum(VAR, TYPE, PACKER=packer) \
begin \
  int __num__ = PACKER.unpack_field_int(32); \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    TYPE __index__; \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_enum(__index__, TYPE, PACKER) \
      `uvm_unpack_int(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_object_enum(VAR, TYPE, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    foreach(VAR[i]) begin \
      `uvm_pack_enum(i, PACKER) \
      `uvm_pack_object(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_object_enum(VAR, TYPE, PACKER=packer) \
begin \
  int __num__ = PACKER.unpack_field_int(32); \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    TYPE __index__; \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_enum(__index__, TYPE, PACKER) \
      `uvm_unpack_object(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_aa_string_enum(VAR, TYPE, PACKER=packer) \
begin \
  PACKER.pack_field_int(VAR.num(), 32); \
  if (VAR.num()) begin \
    foreach(VAR[i]) begin \
      `uvm_pack_intN(i, SIZE, PACKER) \
      `uvm_pack_string(VAR[i], PACKER) \
    end \
  end \
end
`define uvm_unpack_aa_string_enum(VAR, TYPE, PACKER=packer) \
begin \
  int __num__ = PACKER.unpack_field_int(32); \
  if (__num__ == 0) \
    VAR.delete(); \
  else begin \
    TYPE __index__; \
    for (int __i__ = 0; __i__ < __num__; __i__++) begin \
      `uvm_unpack_enum(__index__, TYPE, PACKER) \
      `uvm_unpack_string(VAR[__index__], PACKER) \
    end \
  end \
end
`define uvm_pack_sarray_real(VAR, PACKER=packer) \
  `uvm_packer_array_extension_begin(PACKER) \
    foreach(VAR[index]) \
      `uvm_pack_real(VAR[index], PACKER) \
  `uvm_packer_array_extension_end(PACKER)
`define m_uvm_pack_qda_real(VAR, PACKER=packer) \
  `uvm_pack_intN(VAR.size(), 32, PACKER) \
  `uvm_pack_sarray_real(VAR, PACKER)
`define uvm_pack_queue_real(VAR, PACKER=packer) \
  `m_uvm_pack_qda_real(VAR, PACKER)
`define uvm_pack_da_real(VAR, PACKER=packer) \
  `m_uvm_pack_qda_real(VAR, PACKER)
`define uvm_unpack_sarray_real(VAR, PACKER=packer) \
  `uvm_packer_array_extension_begin(PACKER) \
  foreach(VAR[index]) \
    `uvm_unpack_real(VAR[index], PACKER) \
  `uvm_packer_array_extension_end(PACKER)
`define uvm_unpack_da_real(VAR, PACKER=packer) \
  begin \
    int tmp_size__; \
    `uvm_unpack_intN(tmp_size__, 32, PACKER) \
    VAR = new [tmp_size__]; \
    `uvm_unpack_sarray_real(VAR, PACKER) \
  end
`define uvm_unpack_queue_real(VAR, PACKER=packer) \
  begin \
    int tmp_size__; \
    `uvm_unpack_intN(tmp_size__, 32, PACKER) \
    while (VAR.size() > tmp_size__) \
      void'(VAR.pop_back()); \
    for (int i = 0; i < tmp_size__; i++) \
      `uvm_unpack_real(VAR[i], PACKER) \
  end
`define UVM_COPIER_DEFINES_SVH
`define uvm_copy_object(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COPIER=copier) \
if (LVALUE != RVALUE) begin \
  if ((RVALUE == null) || \
      (POLICY == UVM_REFERENCE) || \
      ((POLICY == UVM_DEFAULT_POLICY) && \
       (COPIER.get_recursion_policy() == UVM_REFERENCE))) begin \
    LVALUE = RVALUE; \
  end \
  else begin \
    uvm_object lvalue_ref__; \
    if (!COPIER.get_first_copy(RVALUE,lvalue_ref__) || !$cast(LVALUE,lvalue_ref__)) begin \
        uvm_recursion_policy_enum prev_pol__ = COPIER.get_recursion_policy(); \
        uvm_recursion_policy_enum curr_pol__; \
        if (POLICY != UVM_DEFAULT_POLICY) \
          COPIER.set_recursion_policy(POLICY); \
        curr_pol__ = COPIER.get_recursion_policy(); \
        if (LVALUE == null) begin \
          if (($cast(LVALUE, RVALUE.create(RVALUE.get_name())) == 0) || \
              (LVALUE == null)) begin \
            `uvm_fatal("UVM/COPY/NULL_CREATE", \
                   {"Could not create '", RVALUE.get_full_name(), \
                        "' of type '", RVALUE.get_type_name(), \
                        "', into '", `"LVALUE`", "'."}) \
          end \
          else begin \
             COPIER.copy_object(LVALUE, RVALUE); \
          end \
        end \
        else begin \
           if (COPIER.object_copied(LVALUE, RVALUE, curr_pol__) == uvm_policy::STARTED) begin \
             `uvm_warning("UVM/COPY/LOOP", \
                      {"Loop detected in copy operation (LHS:'", \
                   LVALUE.get_full_name(), \
                   "', RHS:'", \
                           RVALUE.get_full_name(), \
                   "')"}) \
           end \
           else begin \
             COPIER.copy_object(LVALUE, RVALUE); \
           end \
        end \
        if (POLICY != UVM_DEFAULT_POLICY) \
          COPIER.set_recursion_policy(prev_pol__); \
     end \
  end \
end
`define uvm_copy_aa_object(LVALUE, RVALUE, POLICY=UVM_DEFAULT_POLICY, COPIER=copier) \
if ((POLICY == UVM_REFERENCE) || !RVALUE.size()) \
  LVALUE = RVALUE; \
else begin \
  LVALUE.delete(); \
  foreach(RVALUE[i]) \
    `uvm_copy_object(LVALUE[i], RVALUE[i], POLICY, COPIER) \
end
`define uvm_copier_get_function(FUNCTION) \
function int get_``FUNCTION``_copy(uvm_object rhs, ref uvm_object lhs); \
  if (m_recur_states.exists(rhs)) \
    return m_recur_states[rhs].FUNCTION(lhs); \
  return 0; \
endfunction : get_``FUNCTION``_copy
`define UVM_OBJECT_DEFINES_SVH
`define UVM_FIELD_FLAG_SIZE UVM_FIELD_FLAG_RESERVED_BITS
`define uvm_field_utils_begin(T) \
function void do_execute_op( uvm_field_op op );                                 \
  super.do_execute_op(op);                                                      \
  __m_uvm_execute_field_op(op);                                                 \
endfunction : do_execute_op                                                     \
local function void __m_uvm_execute_field_op( uvm_field_op __local_op__ );      \
   uvm_field_flag_t local_op_type__; /* Used to avoid re-querying */            \
   T local_rhs__; /* Used for $casting copy and compare */                      \
   uvm_resource_base local_rsrc__; /* Used for UVM_SET ops */                   \
   string local_rsrc_name__;                                                    \
   uvm_object local_obj__; /* Used when trying to read uvm_object resources */  \
   bit local_success__; /* Used when trying to read resources */                \
   typedef T __local_type__; /* Used for referring to type T in field macros */ \
   int local_size__; /* Used when unpacking size values */                      \
   /* All possible policy classes */                                            \
   /* Using the same name as the do_* methods, allows macro reuse */            \
   uvm_printer __local_printer__;                                               \
   uvm_comparer __local_comparer__;                                             \
   uvm_recorder __local_recorder__;                                             \
   uvm_packer __local_packer__;                                                 \
   uvm_copier __local_copier__;                                                 \
   uvm_queue#(uvm_acs_name_struct) __local_field_names__;                       \
   void'($cast(local_rhs__, __local_op__.get_rhs()));                           \
   if (($cast(local_rsrc__, __local_op__.get_rhs())) &&                         \
       (local_rsrc__ != null))                                                  \
     local_rsrc_name__ = local_rsrc__.get_name();                               \
   local_op_type__ = __local_op__.get_op_type();                                \
   case (local_op_type__)                                                       \
     UVM_PRINT: begin                                                           \
       $cast(__local_printer__, __local_op__.get_policy());                     \
     end                                                                        \
     UVM_COMPARE: begin                                                         \
       if (local_rhs__ == null) return;                                         \
       $cast(__local_comparer__, __local_op__.get_policy());                    \
     end                                                                        \
     UVM_RECORD: begin                                                          \
       $cast(__local_recorder__, __local_op__.get_policy());                    \
     end                                                                        \
     UVM_PACK, UVM_UNPACK: begin                                                \
       $cast(__local_packer__, __local_op__.get_policy());                      \
     end                                                                        \
     UVM_COPY: begin                                                            \
       if (local_rhs__ == null) return;                                         \
       $cast(__local_copier__, __local_op__.get_policy());                      \
     end                                                                        \
     UVM_SET: begin                                                             \
       if (local_rsrc__ == null) return;                                        \
     end                                                                        \
     UVM_CHECK_FIELDS: begin                                                    \
       $cast(__local_field_names__, __local_op__.get_rhs());                    \
     end                                                                        \
     default:                                                                   \
       return; /* unknown op, just return */                                    \
   endcase                                                                      \

`define uvm_field_utils_end \
endfunction : __m_uvm_execute_field_op
`define uvm_object_utils(T) \
  `m_uvm_object_registry_internal(T,T)  \
  `m_uvm_object_create_func(T) \
  `uvm_type_name_decl(`"T`")
`define uvm_object_param_utils(T) \
  `m_uvm_object_registry_param(T)  \
  `m_uvm_object_create_func(T)
`define uvm_object_utils_begin(T) \
  `uvm_object_utils(T) \
  `uvm_field_utils_begin(T)
`define uvm_object_param_utils_begin(T) \
  `uvm_object_param_utils(T) \
  `uvm_field_utils_begin(T)
`define uvm_object_abstract_utils(T) \
  `m_uvm_object_abstract_registry_internal(T,T)  \
  `uvm_type_name_decl(`"T`")
`define uvm_object_abstract_param_utils(T) \
  `m_uvm_object_abstract_registry_param(T)
`define uvm_object_abstract_utils_begin(T) \
  `uvm_object_abstract_utils(T) \
  `uvm_field_utils_begin(T)
`define uvm_object_abstract_param_utils_begin(T) \
  `uvm_object_abstract_param_utils(T) \
  `uvm_field_utils_begin(T)
`define uvm_object_utils_end \
  `uvm_field_utils_end
`define uvm_component_utils(T) \
   `m_uvm_component_registry_internal(T,T) \
   `uvm_type_name_decl(`"T`") \

`define uvm_component_param_utils(T) \
   `m_uvm_component_registry_param(T) \

`define uvm_component_utils_begin(T) \
   `uvm_component_utils(T) \
   `uvm_field_utils_begin(T)
`define uvm_component_param_utils_begin(T) \
   `uvm_component_param_utils(T) \
   `uvm_field_utils_begin(T)
`define uvm_component_abstract_utils(T) \
   `m_uvm_component_abstract_registry_internal(T,T) \
   `uvm_type_name_decl(`"T`") \

`define uvm_component_abstract_param_utils(T) \
   `m_uvm_component_abstract_registry_param(T) \

`define uvm_component_abstract_utils_begin(T) \
   `uvm_component_abstract_utils(T) \
   `uvm_field_utils_begin(T)
`define uvm_component_abstract_param_utils_begin(T) \
   `uvm_component_abstract_param_utils(T) \
   `uvm_field_utils_begin(T)
`define uvm_component_utils_end \
  `uvm_field_utils_end
`define uvm_object_registry(T,S) \
   typedef uvm_object_registry#(T,S) type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define uvm_component_registry(T,S) \
   typedef uvm_component_registry #(T,S) type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define uvm_declare_type_alias(TYPE,NAME,SFX=) \
  static bit m__alias_declared``SFX = TYPE::type_id::set_type_alias(NAME);
`define uvm_new_func \
  function new (string name, uvm_component parent); \
    super.new(name, parent); \
  endfunction
`define m_uvm_object_create_func(T) \
   function uvm_object create (string name=""); \
     T tmp; \
     if (name=="") tmp = new(); \
     else tmp = new(name); \
     return tmp; \
   endfunction
`define uvm_type_name_decl(TNAME_STRING) \
     static function string type_name(); \
       return TNAME_STRING; \
     endfunction : type_name \
     virtual function string get_type_name(); \
       return TNAME_STRING; \
     endfunction : get_type_name
`define m_uvm_object_registry_internal(T,S) \
   typedef uvm_object_registry#(T,`"S`") type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_object_registry_param(T) \
   typedef uvm_object_registry #(T) type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_object_abstract_registry_internal(T,S) \
   typedef uvm_abstract_object_registry#(T,`"S`") type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_object_abstract_registry_param(T) \
   typedef uvm_abstract_object_registry #(T) type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_component_registry_internal(T,S) \
   typedef uvm_component_registry #(T,`"S`") type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_component_registry_param(T) \
   typedef uvm_component_registry #(T) type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_component_abstract_registry_internal(T,S) \
   typedef uvm_abstract_component_registry #(T,`"S`") type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_component_abstract_registry_param(T) \
   typedef uvm_abstract_component_registry #(T) type_id; \
   static function type_id get_type(); \
     return type_id::get(); \
   endfunction \
   virtual function uvm_object_wrapper get_object_type(); \
     return type_id::get(); \
   endfunction
`define m_uvm_field_radix(FLAG) uvm_radix_enum'((FLAG)&(UVM_RADIX))
`define m_uvm_field_recursion(FLAG) uvm_recursion_policy_enum'((FLAG)&(UVM_RECURSION))
`define m_warn_if_no_positive_ops(ARG,FLAG) \
  begin \
    static bit dont_warn_if_no_positive_ops ; \
    if (!dont_warn_if_no_positive_ops && !((FLAG)&UVM_FLAGS_ON) && ((FLAG)&(~(UVM_COPY|UVM_COMPARE|UVM_PRINT|UVM_RECORD|UVM_PACK|UVM_UNPACK)))) begin \
      string behavior; \
      `ifdef UVM_LEGACY_FIELD_MACRO_SEMANTICS behavior = "As UVM_LEGACY_FIELD_MACRO_SEMANTICS is set, we will treat this as if UVM_ALL_ON had been bitwise-or'd with FLAG.  This is not the behavior specified by IEEE 1800.2-2020."; \
      `else behavior = "Previous Accellera UVM libraries treated this as if UVM_ALL_ON had been bitwise-or'd with this FLAG, but per IEEE 1800.2-2020, we will treat it as a NO-OP (see UVM Mantis 7187)"; \
      `endif \
      `uvm_warning("UVM/FIELDS/NO_FLAG",{"Field macro for ARG uses FLAG without or'ing any explicit UVM_xxx actions. ",behavior}) \
      dont_warn_if_no_positive_ops = 1; \
    end \
  end
`define m_uvm_field_begin(ARG, FLAG, REGEX="") \
  `m_warn_if_no_positive_ops(ARG,FLAG) \
  begin \
    case (local_op_type__) \
      UVM_CHECK_FIELDS: \
        if ( \
           `ifndef UVM_LEGACY_FIELD_MACRO_SEMANTICS (((FLAG)&UVM_SET)) && `endif \
           (!((FLAG)&UVM_NOSET)) \
           ) begin \
          __local_field_names__.push_back('{`"ARG`", REGEX}); \
        end
`define m_uvm_field_end(ARG) \
    endcase \
  end
`define m_uvm_field_op_begin(OP, FLAG) \
UVM_``OP: \
  if ( \
     `ifndef UVM_LEGACY_FIELD_MACRO_SEMANTICS (((FLAG)&UVM_``OP)) && `endif \
     (!((FLAG)&UVM_NO``OP)) \
  ) begin
`define m_uvm_field_op_end(OP) \
  end
`define m_uvm_compat_physical_abstract(FLAG) \
     if ((__local_comparer__.physical&&((FLAG)&UVM_PHYSICAL)) || \
         (__local_comparer__.abstract&&((FLAG)&UVM_ABSTRACT)) || \
         (!((FLAG)&UVM_PHYSICAL) && !((FLAG)&UVM_ABSTRACT)) )
`define uvm_field_int(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG) \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_int(ARG, local_rhs__.ARG, `m_uvm_field_radix(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_int(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_int(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_int(`"ARG`", \
                      ARG, \
                      $bits(ARG), \
                      `m_uvm_field_radix(FLAG), \
                      __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_int(ARG, $bits(ARG), `m_uvm_field_radix(FLAG),,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_builtin_int_read(local_success__, \
                                       local_rsrc__, \
                                       ARG, \
                                       this) \
        /* TODO if(local_success__ && printing matches) */ \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_object(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG) \
    `m_uvm_field_op_begin(COPY,FLAG) \
      `uvm_copy_object(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_copier__) \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_object(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        `uvm_pack_object(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        `uvm_unpack_object(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_object(ARG, `m_uvm_field_recursion(FLAG), __local_recorder__); \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_object(ARG, `m_uvm_field_recursion(FLAG),__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_read(local_success__, \
                           local_rsrc__, \
                           uvm_object, \
                           local_obj__, \
                           this) \
        if (local_success__) begin \
          if (local_obj__ == null) begin \
            ARG = null; \
          end else if (!$cast(ARG, local_obj__) && uvm_config_db_options::is_tracing()) begin \
             `uvm_info("CFGDB/OBJ_TYPE", $sformatf("Can't set field '%s' on '%s' with '%s' type", \
                                                           `"ARG`", \
                                                           this.get_full_name(), \
                                                           local_obj__.get_type_name()),UVM_LOW) \
          end \
          /* TODO if(local_success__ && printing matches) */ \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG) \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_string(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_string(`"ARG`", ARG, __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      __local_printer__.print_string(`"ARG`", ARG); \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_read(local_success__, \
                           local_rsrc__, \
                           string, \
                           ARG, \
                           this) \
              /* TODO if(local_success__ && printing matches) */ \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_enum(T,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG) \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_enum(ARG, local_rhs__.ARG, T, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_enum(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_enum(ARG, T, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_enum(`"ARG`", ARG, T, __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      if (`m_uvm_field_radix(FLAG) inside {UVM_NORADIX, UVM_ENUM, UVM_STRING}) \
        `uvm_print_enum(T, ARG,__local_printer__) \
      else \
        `uvm_print_int(ARG, $bits(ARG), `m_uvm_field_radix(FLAG),T,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_resource_enum_read(local_success__, \
                                 local_rsrc__, \
                                 T, \
                                 ARG, \
                                 this) \
              /* TODO if(local_success__ && printing matches) */ \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_real(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG) \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_real(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_real(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_real(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_real(`"ARG`", ARG, __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      __local_printer__.print_real(`"ARG`", ARG); \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_resource_real_read(local_success__, \
                                 local_rsrc__, \
                                 ARG, \
                                 this) \
              /* TODO if(local_success__ && printing matches) */ \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_event(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG) \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compare_begin(ARG, local_rhs__.ARG, __local_comparer__) \
        __local_comparer__.print_msg({`"ARG`", " event miscompare"}); \
      `m_uvm_compare_end \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      __local_printer__.print_generic(`"ARG`", "event", -1, ""); \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_sarray_int(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_sarray_int(ARG, local_rhs__.ARG, `m_uvm_field_radix(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_sarray(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_sarray(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_int(ARG, `m_uvm_field_radix(FLAG), __local_recorder__)  \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_sarray_int(ARG, \
                            `m_uvm_field_radix(FLAG),, \
                            __local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if ((local_index__ >= $size(ARG)) || (local_index__ < 0)) begin \
              `uvm_warning("UVM/FIELDS/SARRAY_IDX", $sformatf("Index '%d' is not valid for static array '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              $size(ARG))) \
            end \
            else begin \
              `uvm_resource_builtin_int_read(local_success__, \
                                             local_rsrc__, \
                                             ARG[local_index__], \
                                             this) \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_sarray_object(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      foreach(ARG[i]) begin \
        `uvm_copy_object(ARG[i], local_rhs__.ARG[i], `m_uvm_field_recursion(FLAG), __local_copier__) \
      end \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_sarray_object(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        foreach(ARG[i])  \
          `uvm_pack_object(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        foreach(ARG[i])  \
          `uvm_unpack_object(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_object(ARG, `m_uvm_field_recursion(FLAG), __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_sarray_object(ARG, `m_uvm_field_recursion(FLAG), __local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if ((local_index__ >= $size(ARG)) || (local_index__ < 0)) begin \
              `uvm_warning("UVM/FIELDS/SARRAY_IDX", $sformatf("Index '%d' is not valid for static array '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              $size(ARG))) \
            end \
            else begin \
              `uvm_resource_read(local_success__, \
                                 local_rsrc__, \
                                 uvm_object, \
                                 local_obj__, \
                                 this) \
              if (local_success__) begin \
                if (local_obj__ == null) begin \
                  ARG[local_index__] = null; \
                end else if (!$cast(ARG[local_index__], local_obj__) && uvm_config_db_options::is_tracing()) begin \
                  `uvm_info("CFGDB/OBJ_TYPE", $sformatf("Can't set field '%s[%d]' on '%s' with '%s' type", \
                                                                `"ARG`", \
                                                                local_index__, \
                                                                this.get_full_name(), \
                                                                local_obj__.get_type_name()),UVM_LOW) \
                end \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_sarray_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_sarray_string(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      foreach(ARG[i]) \
        `uvm_pack_string(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      foreach(ARG[i]) \
       `uvm_unpack_string(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_string(ARG, __local_recorder__)  \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_sarray_string(ARG,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if ((local_index__ >= $size(ARG)) || (local_index__ < 0)) begin \
              `uvm_warning("UVM/FIELDS/SARRAY_IDX", $sformatf("Index '%d' is not valid for static array '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              $size(ARG))) \
            end \
            else begin \
              `uvm_resource_read(local_success__, \
                                 local_rsrc__, \
                                 string, \
                                 ARG[local_index__], \
                                 this) \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_sarray_enum(T,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_sarray_enum(ARG, local_rhs__.ARG, T, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      foreach (ARG[i]) \
        `uvm_pack_enumN(ARG[i], $bits(T), __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      foreach (ARG[i]) \
        `uvm_unpack_enumN(ARG[i], $bits(T), T, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_enum(ARG, T, __local_recorder__)  \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_sarray_enum(T, ARG ,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if ((local_index__ >= $size(ARG)) || (local_index__ < 0)) begin \
              `uvm_warning("UVM/FIELDS/SARRAY_IDX", $sformatf("Index '%d' is not valid for static array '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              $size(ARG))) \
            end \
            else begin \
              `uvm_resource_enum_read(local_success__, \
                                      local_rsrc__, \
                                      T, \
                                      ARG[local_index__], \
                                      this) \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define m_uvm_queue_resize(ARG, SZ) \
  if (ARG.size() > SZ) \
    ARG  = ARG[0:SZ-1]; \
  else \
    while (ARG.size() < SZ) ARG.push_back(ARG[SZ]);
`define m_uvm_da_resize(ARG, SZ) \
  if (ARG.size() != SZ) ARG = new[SZ](ARG);
`define m_uvm_field_qda_int(TYPE,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_qda_int(ARG, local_rhs__.ARG, `m_uvm_field_radix(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_``TYPE``(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_``TYPE``(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_int(ARG, `m_uvm_field_radix(FLAG), __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_qda_int(TYPE, ARG, `m_uvm_field_radix(FLAG),,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_builtin_int_read(local_success__, \
                                       local_rsrc__, \
                                       local_size__, \
                                       this) \
        if (local_success__) \
          `m_uvm_``TYPE``_resize(ARG, local_size__) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if (local_index__ < 0) begin \
              `uvm_warning("UVM/FIELDS/QDA_IDX", $sformatf("Index '%0d' is not valid for field '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              ARG.size() ) ) \
            end \
            else begin \
              bit tmp_stream__[]; \
              `uvm_resource_builtin_int_read(local_success__, \
                                             local_rsrc__, \
                                             { << bit { tmp_stream__ }}, \
                                             this) \
              if (local_success__) begin \
                if (local_index__ >= ARG.size()) \
                  `m_uvm_``TYPE``_resize(ARG, local_index__ + 1) \
                tmp_stream__ = new[$bits(ARG[local_index__])] (tmp_stream__); \
                ARG[local_index__] = { << bit { tmp_stream__ }}; \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_array_int(ARG,FLAG=UVM_DEFAULT) \
   `m_uvm_field_qda_int(da,ARG,FLAG)
`define m_uvm_field_qda_object(TYPE,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      if ((`m_uvm_field_recursion(FLAG) == UVM_REFERENCE) || !local_rhs__.ARG.size()) \
        ARG = local_rhs__.ARG; \
      else begin \
        `m_uvm_``TYPE``_resize(ARG, local_rhs__.ARG.size()) \
        foreach (ARG[i]) \
          `uvm_copy_object(ARG[i], local_rhs__.ARG[i], `m_uvm_field_recursion(FLAG), __local_copier__) \
      end \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_qda_object(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      __local_packer__.pack_field_int(ARG.size(), 32); \
      foreach (ARG[i]) \
        `uvm_pack_object(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      local_size__ = __local_packer__.unpack_field_int(32); \
      `m_uvm_``TYPE``_resize(ARG, local_size__); \
      foreach (ARG[i]) \
        `uvm_unpack_object(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_object(ARG, `m_uvm_field_recursion(FLAG), __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_qda_object(TYPE, ARG, `m_uvm_field_recursion(FLAG),__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_builtin_int_read(local_success__, \
                                       local_rsrc__, \
                                       local_size__, \
                                       this) \
        if (local_success__) \
          `m_uvm_``TYPE``_resize(ARG, local_size__) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if (local_index__ < 0) begin \
              `uvm_warning("UVM/FIELDS/QDA_IDX", $sformatf("Index '%0d' is not valid for field '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              ARG.size() ) ) \
            end \
            else begin \
              `uvm_resource_read(local_success__, \
                                 local_rsrc__, \
                                 uvm_object, \
                                 local_obj__, \
                                 this) \
              if (local_success__) begin \
                if (local_index__ >= ARG.size()) \
                  `m_uvm_``TYPE``_resize(ARG, local_index__ + 1) \
                if (local_obj__ == null) begin \
                  ARG[local_index__] = null; \
                end else if (!$cast(ARG[local_index__], local_obj__) && uvm_config_db_options::is_tracing()) begin \
                  `uvm_info("CFGDB/QDA_OBJ_TYPE", \
                             $sformatf("Can't set field '%s[%0d]' on '%s' with '%s' type", \
                                       `"ARG`", \
                                       local_index__, \
                                       this.get_full_name(), \
                                       local_obj__.get_type_name()),UVM_LOW) \
                end \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_array_object(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_object(da,ARG,FLAG)
`define uvm_field_array_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_string(da,ARG,FLAG)
`define m_uvm_field_qda_string(TYPE,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_qda_string(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
       __local_packer__.pack_field_int(ARG.size(), 32); \
       foreach (ARG[i]) \
         `uvm_pack_string(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      local_size__ = __local_packer__.unpack_field_int(32); \
      `m_uvm_``TYPE``_resize(ARG, local_size__) \
      foreach (ARG[i]) \
        `uvm_unpack_string(ARG[i], __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_string(ARG, __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_qda_string(TYPE, ARG,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_builtin_int_read(local_success__, \
                                       local_rsrc__, \
                                       local_size__, \
                                       this) \
        if (local_success__) \
          `m_uvm_``TYPE``_resize(ARG, local_size__) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if (local_index__ < 0) begin \
              `uvm_warning("UVM/FIELDS/QDA_IDX", $sformatf("Index '%0d' is not valid for field '%s.%s' of size '%0d'", \
                                                           local_index__, \
                                                           get_full_name(), \
                                                           `"ARG`", \
                                                           ARG.size() ) ) \
            end \
            else begin \
              string tmp_string__; \
              `uvm_resource_read(local_success__, \
                                 local_rsrc__, \
                                 string, \
                                 tmp_string__, \
                                 this) \
              if (local_success__) begin \
                if (local_index__ >= ARG.size()) \
                  `m_uvm_``TYPE``_resize(ARG, local_index__ + 1) \
                ARG[local_index__]  = tmp_string__; \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_array_enum(T,ARG,FLAG=UVM_DEFAULT) \
  `m_field_qda_enum(da,T,ARG,FLAG)
`define m_field_qda_enum(TYPE,T,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `m_uvm_compat_physical_abstract(FLAG) \
      `uvm_compare_qda_enum(ARG, local_rhs__.ARG, T, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
       __local_packer__.pack_field_int(ARG.size(), 32); \
       foreach (ARG[i]) \
         `uvm_pack_enumN(ARG[i], $bits(T), __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      local_size__ = __local_packer__.unpack_field_int(32); \
      `m_uvm_``TYPE``_resize(ARG, local_size__) \
      foreach (ARG[i]) \
        `uvm_unpack_enumN(ARG[i], $bits(T), T, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_enum(ARG, T, __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_qda_enum(TYPE, T, ARG,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_builtin_int_read(local_success__, \
                                       local_rsrc__, \
                                       local_size__, \
                                       this) \
        if (local_success__) \
          `m_uvm_``TYPE``_resize(ARG, local_size__) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if (local_index__ < 0) begin \
              `uvm_warning("UVM/FIELDS/QDA_IDX", $sformatf("Index '%0d' is not valid for field '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              ARG.size() ) ) \
            end \
            else begin \
              T tmp_enum__; \
              `uvm_resource_enum_read(local_success__, \
                                      local_rsrc__, \
                                      T, \
                                      tmp_enum__, \
                                      this) \
              if (local_success__) begin \
                if (local_index__ >= ARG.size()) \
                  `m_uvm_``TYPE``_resize(ARG, local_index__ + 1) \
                ARG[local_index__] = tmp_enum__; \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_queue_int(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_int(queue,ARG,FLAG)
`define uvm_field_queue_object(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_object(queue,ARG,FLAG)
`define uvm_field_queue_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_string(queue,ARG,FLAG)
`define uvm_field_queue_enum(T,ARG,FLAG=UVM_DEFAULT) \
  `m_field_qda_enum(queue,T,ARG,FLAG)
`define uvm_field_aa_int_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_int_string(ARG, local_rhs__.ARG, `m_uvm_field_radix(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_aa_int_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_aa_int_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_aa_int_string(ARG, `m_uvm_field_radix(FLAG), int, __local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/AA_SIZE", $sformatf("Associative array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index__ = local_rsrc_name__.substr(local_name__.len(), \
                                                          local_rsrc_name__.len()-2); \
          `uvm_resource_builtin_int_read(local_success__, \
                                         local_rsrc__, \
                                         ARG[local_index__], \
                                         this) \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_aa_object_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      `uvm_copy_aa_object(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_copier__) \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_object_string(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        `uvm_pack_aa_object_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
      `uvm_unpack_aa_object_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_aa_object_string(ARG, `m_uvm_field_recursion(FLAG),__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/AA_SIZE", $sformatf("Associative array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index__ = local_rsrc_name__.substr(local_name__.len(), \
                                                          local_rsrc_name__.len()-2); \
          `uvm_resource_read(local_success__, \
                             local_rsrc__, \
                             uvm_object, \
                             local_obj__, \
                             this) \
          if (local_success__) begin \
            if (local_obj__ == null) begin \
              ARG[local_index__] = null; \
            end else if (!$cast(ARG[local_index__], local_obj__) && uvm_config_db_options::is_tracing()) begin \
              `uvm_info("CFGDB/OBJ_TYPE", $sformatf("Can't set field '%s[%s]' on '%s' with '%s' type", \
                                                            `"ARG`", \
                                                            local_index__, \
                                                            this.get_full_name(), \
                                                            local_obj__.get_type_name()),UVM_LOW) \
            end \
          end \
          /* TODO if(local_success__ && printing matches) */ \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_aa_string_string(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG,`"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_string_string(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_aa_string_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_aa_string_string(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_aa_string_string(ARG,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/AA_SIZE", $sformatf("Associative array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index__ = local_rsrc_name__.substr(local_name__.len(), \
                                                          local_rsrc_name__.len()-2); \
          `uvm_resource_read(local_success__, \
                             local_rsrc__, \
                             string, \
                             ARG[local_index__], \
                             this) \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_aa_object_int(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_object_key(int, ARG, FLAG)
`define uvm_field_aa_object_key(KEY, ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      `uvm_copy_aa_object(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_copier__) \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_object_int(ARG, local_rhs__.ARG, `m_uvm_field_recursion(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        `uvm_pack_aa_object_intN(ARG, $bits(KEY), __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      if (`m_uvm_field_recursion(FLAG) != UVM_REFERENCE) \
        `uvm_unpack_aa_object_intN(ARG, $bits(KEY), __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_aa_object_int(ARG, `m_uvm_field_recursion(FLAG), KEY,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          KEY local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            `uvm_resource_read(local_success__, \
                               local_rsrc__, \
                               uvm_object, \
                               local_obj__, \
                               this) \
            if (local_success__) begin \
              if (local_obj__ == null) begin \
                ARG[local_index__] = null; \
              end else if (!$cast(ARG[local_index__], local_obj__) && uvm_config_db_options::is_tracing()) begin \
                `uvm_info("CFGDB/OBJ_TYPE", $sformatf("Can't set field '%s[%d]' on '%s' with '%s' type", \
                                                              `"ARG`", \
                                                              local_index__, \
                                                              this.get_full_name(), \
                                                              local_obj__.get_type_name()),UVM_LOW) \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_aa_string_int(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_string_key(int, ARG, FLAG)
`define uvm_field_aa_string_key(KEY, ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_string_int(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_aa_string_intN(ARG, $bits(KEY), __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_aa_string_intN(ARG, $bits(KEY), __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      /* TODO */ \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          KEY local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            `uvm_resource_read(local_success__, \
                               local_rsrc__, \
                               string, \
                               ARG[local_index__], \
                               this) \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_aa_int_int(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(int, ARG, FLAG) \

`define uvm_field_aa_int_int_unsigned(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(int unsigned, ARG, FLAG)
`define uvm_field_aa_int_integer(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(integer, ARG, FLAG)
`define uvm_field_aa_int_integer_unsigned(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(integer unsigned, ARG, FLAG)
`define uvm_field_aa_int_byte(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(byte, ARG, FLAG)
`define uvm_field_aa_int_byte_unsigned(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(byte unsigned, ARG, FLAG)
`define uvm_field_aa_int_shortint(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(shortint, ARG, FLAG)
`define uvm_field_aa_int_shortint_unsigned(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(shortint unsigned, ARG, FLAG)
`define uvm_field_aa_int_longint(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(longint, ARG, FLAG)
`define uvm_field_aa_int_longint_unsigned(ARG,FLAG=UVM_DEFAULT) \
  `uvm_field_aa_int_key(longint unsigned, ARG, FLAG)
`define uvm_field_aa_int_key(KEY, ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_int_int(ARG, local_rhs__.ARG, `m_uvm_field_radix(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_aa_int_intN(ARG, $bits(KEY), __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_aa_int_intN(ARG, $bits(KEY), __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_aa_int_int(ARG, `m_uvm_field_radix(FLAG), , KEY,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/AA_SIZE", $sformatf("Associative array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          KEY local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            `uvm_resource_int_read(local_success__, \
                                   local_rsrc__, \
                                   KEY, \
                                   ARG[local_index__], \
                                   this) \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_aa_int_enumkey(KEY, ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG, FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_aa_int_int(ARG, local_rhs__.ARG, `m_uvm_field_radix(FLAG), __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_aa_int_enum(ARG, KEY, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_aa_int_enum(ARG, KEY, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_aa_int_enum(KEY, ARG, `m_uvm_field_radix(FLAG),,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/AA_SIZE", $sformatf("Associative array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          KEY local_index__; \
          bit[$bits(KEY)-1:0] local_bit_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_bit_index__); \
          if (local_code__ > 0) begin \
            local_index__ = KEY'(local_bit_index__); \
            `uvm_resource_int_read(local_success__, \
                                   local_rsrc__, \
                                   KEY, \
                                   ARG[local_index__], \
                                   this) \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_sarray_real(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_sarray_real(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_sarray_real(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_sarray_real(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_real(ARG, __local_recorder__)  \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_sarray_real(ARG,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
         `uvm_warning("UVM/FIELDS/SARRAY_SIZE", $sformatf("Static array '%s.%s' cannot be resized via configuration.", get_full_name(), `"ARG`") ) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if ((local_index__ >= $size(ARG)) || (local_index__ < 0)) begin \
              `uvm_warning("UVM/FIELDS/SARRAY_IDX", $sformatf("Index '%d' is not valid for static array '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              $size(ARG))) \
            end \
            else begin \
              `uvm_resource_real_read(local_success__, \
                                      local_rsrc__, \
                                      ARG[local_index__], \
                                      this) \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define m_uvm_field_qda_real(TYPE,ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_begin(ARG,FLAG, `"ARG[+]`") \
    `m_uvm_field_op_begin(COPY,FLAG) \
      ARG = local_rhs__.ARG; \
    `m_uvm_field_op_end(COPY) \
    `m_uvm_field_op_begin(COMPARE,FLAG) \
      `uvm_compare_qda_real(ARG, local_rhs__.ARG, __local_comparer__) \
    `m_uvm_field_op_end(COMPARE) \
    `m_uvm_field_op_begin(PACK,FLAG) \
      `uvm_pack_``TYPE``_real(ARG, __local_packer__) \
    `m_uvm_field_op_end(PACK) \
    `m_uvm_field_op_begin(UNPACK,FLAG) \
      `uvm_unpack_``TYPE``_real(ARG, __local_packer__) \
    `m_uvm_field_op_end(UNPACK) \
    `m_uvm_field_op_begin(RECORD,FLAG) \
      `uvm_record_qda_real(ARG, __local_recorder__) \
    `m_uvm_field_op_end(RECORD) \
    `m_uvm_field_op_begin(PRINT,FLAG) \
      `uvm_print_qda_real(TYPE, ARG,__local_printer__) \
    `m_uvm_field_op_end(PRINT) \
    `m_uvm_field_op_begin(SET,FLAG) \
      if(local_rsrc_name__ == `"ARG`") begin \
        `uvm_resource_real_read(local_success__, \
                                local_rsrc__, \
                                local_size__, \
                                this) \
        if (local_success__) \
          `m_uvm_``TYPE``_resize(ARG, local_size__) \
      end \
      else begin \
        string local_name__ = {`"ARG`", "["}; \
        if (local_rsrc_name__.len() && \
            local_rsrc_name__[local_rsrc_name__.len()-1] == "]" && \
            local_rsrc_name__.substr(0, local_name__.len()-1) == local_name__) begin \
          string local_index_str__ = local_rsrc_name__.substr(local_name__.len(), \
                                                              local_rsrc_name__.len()-2); \
          int local_index__; \
          /* TODO: Non-decimal indexes */ \
          int local_code__ = $sscanf(local_index_str__, "%d", local_index__); \
          if (local_code__ > 0) begin \
            if (local_index__ < 0) begin \
              `uvm_warning("UVM/FIELDS/QDA_IDX", $sformatf("Index '%0d' is not valid for field '%s.%s' of size '%0d'", \
                                                              local_index__, \
                                                              get_full_name(), \
                                                              `"ARG`", \
                                                              ARG.size() ) ) \
            end \
            else begin \
              real tmp_real__; \
              `uvm_resource_real_read(local_success__, \
                                      local_rsrc__, \
                                      tmp_real__, \
                                      this) \
              if (local_success__) begin \
                if (local_index__ >= ARG.size()) \
                  `m_uvm_``TYPE``_resize(ARG, local_index__ + 1) \
                ARG[local_index__] = tmp_real__; \
              end \
            end \
          end \
        end \
      end \
    `m_uvm_field_op_end(SET) \
  `m_uvm_field_end(ARG)
`define uvm_field_array_real(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_real(da,ARG,FLAG)
`define uvm_field_queue_real(ARG,FLAG=UVM_DEFAULT) \
  `m_uvm_field_qda_real(queue,ARG,FLAG)
`define uvm_blocking_put_imp_decl(SFX) \
class uvm_blocking_put_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_BLOCKING_PUT_MASK,`"uvm_blocking_put_imp``SFX`",IMP) \
  `UVM_BLOCKING_PUT_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_nonblocking_put_imp_decl(SFX) \
class uvm_nonblocking_put_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_NONBLOCKING_PUT_MASK,`"uvm_nonblocking_put_imp``SFX`",IMP) \
  `UVM_NONBLOCKING_PUT_IMP_SFX( SFX, m_imp, T, t) \
endclass
`define uvm_put_imp_decl(SFX) \
class uvm_put_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_PUT_MASK,`"uvm_put_imp``SFX`",IMP) \
  `UVM_BLOCKING_PUT_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_NONBLOCKING_PUT_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_blocking_get_imp_decl(SFX) \
class uvm_blocking_get_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_BLOCKING_GET_MASK,`"uvm_blocking_get_imp``SFX`",IMP) \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_nonblocking_get_imp_decl(SFX) \
class uvm_nonblocking_get_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_NONBLOCKING_GET_MASK,`"uvm_nonblocking_get_imp``SFX`",IMP) \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_get_imp_decl(SFX) \
class uvm_get_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_GET_MASK,`"uvm_get_imp``SFX`",IMP) \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_blocking_peek_imp_decl(SFX) \
class uvm_blocking_peek_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_BLOCKING_PEEK_MASK,`"uvm_blocking_peek_imp``SFX`",IMP) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_nonblocking_peek_imp_decl(SFX) \
class uvm_nonblocking_peek_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_NONBLOCKING_PEEK_MASK,`"uvm_nonblocking_peek_imp``SFX`",IMP) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_peek_imp_decl(SFX) \
class uvm_peek_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_PEEK_MASK,`"uvm_peek_imp``SFX`",IMP) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_blocking_get_peek_imp_decl(SFX) \
class uvm_blocking_get_peek_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_BLOCKING_GET_PEEK_MASK,`"uvm_blocking_get_peek_imp``SFX`",IMP) \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_nonblocking_get_peek_imp_decl(SFX) \
class uvm_nonblocking_get_peek_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_NONBLOCKING_GET_PEEK_MASK,`"uvm_nonblocking_get_peek_imp``SFX`",IMP) \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_get_peek_imp_decl(SFX) \
class uvm_get_peek_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_GET_PEEK_MASK,`"uvm_get_peek_imp``SFX`",IMP) \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_imp, T, t) \
endclass
`define uvm_blocking_master_imp_decl(SFX) \
class uvm_blocking_master_imp``SFX #(type REQ=int, type RSP=int, type IMP=int, \
                                     type REQ_IMP=IMP, type RSP_IMP=IMP) \
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP)); \
  typedef IMP     this_imp_type; \
  typedef REQ_IMP this_req_type; \
  typedef RSP_IMP this_rsp_type; \
  `UVM_MS_IMP_COMMON(`UVM_TLM_BLOCKING_MASTER_MASK,`"uvm_blocking_master_imp``SFX`") \
  \
  `UVM_BLOCKING_PUT_IMP_SFX(SFX, m_req_imp, REQ, t) \
  \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  \
endclass
`define uvm_nonblocking_master_imp_decl(SFX) \
class uvm_nonblocking_master_imp``SFX #(type REQ=int, type RSP=int, type IMP=int, \
                                   type REQ_IMP=IMP, type RSP_IMP=IMP) \
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP)); \
  typedef IMP     this_imp_type; \
  typedef REQ_IMP this_req_type; \
  typedef RSP_IMP this_rsp_type; \
  `UVM_MS_IMP_COMMON(`UVM_TLM_NONBLOCKING_MASTER_MASK,`"uvm_nonblocking_master_imp``SFX`") \
  \
  `UVM_NONBLOCKING_PUT_IMP_SFX(SFX, m_req_imp, REQ, t) \
  \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  \
endclass
`define uvm_master_imp_decl(SFX) \
class uvm_master_imp``SFX #(type REQ=int, type RSP=int, type IMP=int, \
                            type REQ_IMP=IMP, type RSP_IMP=IMP) \
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP)); \
  typedef IMP     this_imp_type; \
  typedef REQ_IMP this_req_type; \
  typedef RSP_IMP this_rsp_type; \
  `UVM_MS_IMP_COMMON(`UVM_TLM_MASTER_MASK,`"uvm_master_imp``SFX`") \
  \
  `UVM_BLOCKING_PUT_IMP_SFX(SFX, m_req_imp, REQ, t) \
  `UVM_NONBLOCKING_PUT_IMP_SFX(SFX, m_req_imp, REQ, t) \
  \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  \
endclass
`define uvm_blocking_slave_imp_decl(SFX) \
class uvm_blocking_slave_imp``SFX #(type REQ=int, type RSP=int, type IMP=int, \
                                    type REQ_IMP=IMP, type RSP_IMP=IMP) \
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ)); \
  typedef IMP     this_imp_type; \
  typedef REQ_IMP this_req_type; \
  typedef RSP_IMP this_rsp_type; \
  `UVM_MS_IMP_COMMON(`UVM_TLM_BLOCKING_SLAVE_MASK,`"uvm_blocking_slave_imp``SFX`") \
  \
  `UVM_BLOCKING_PUT_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_req_imp, REQ, t) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_req_imp, REQ, t) \
  \
endclass
`define uvm_nonblocking_slave_imp_decl(SFX) \
class uvm_nonblocking_slave_imp``SFX #(type REQ=int, type RSP=int, type IMP=int, \
                                       type REQ_IMP=IMP, type RSP_IMP=IMP) \
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ)); \
  typedef IMP     this_imp_type; \
  typedef REQ_IMP this_req_type; \
  typedef RSP_IMP this_rsp_type; \
  `UVM_MS_IMP_COMMON(`UVM_TLM_NONBLOCKING_SLAVE_MASK,`"uvm_nonblocking_slave_imp``SFX`") \
  \
  `UVM_NONBLOCKING_PUT_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_req_imp, REQ, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_req_imp, REQ, t) \
  \
endclass
`define uvm_slave_imp_decl(SFX) \
class uvm_slave_imp``SFX #(type REQ=int, type RSP=int, type IMP=int, \
                           type REQ_IMP=IMP, type RSP_IMP=IMP) \
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ)); \
  typedef IMP     this_imp_type; \
  typedef REQ_IMP this_req_type; \
  typedef RSP_IMP this_rsp_type; \
  `UVM_MS_IMP_COMMON(`UVM_TLM_SLAVE_MASK,`"uvm_slave_imp``SFX`") \
  \
  `UVM_BLOCKING_PUT_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  `UVM_NONBLOCKING_PUT_IMP_SFX(SFX, m_rsp_imp, RSP, t) \
  \
  `UVM_BLOCKING_GET_IMP_SFX(SFX, m_req_imp, REQ, t) \
  `UVM_BLOCKING_PEEK_IMP_SFX(SFX, m_req_imp, REQ, t) \
  `UVM_NONBLOCKING_GET_IMP_SFX(SFX, m_req_imp, REQ, t) \
  `UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, m_req_imp, REQ, t) \
  \
endclass
`define uvm_blocking_transport_imp_decl(SFX) \
class uvm_blocking_transport_imp``SFX #(type REQ=int, type RSP=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP)); \
  `UVM_IMP_COMMON(`UVM_TLM_BLOCKING_TRANSPORT_MASK,`"uvm_blocking_transport_imp``SFX`",IMP) \
  `UVM_BLOCKING_TRANSPORT_IMP_SFX(SFX, m_imp, REQ, RSP, req, rsp) \
endclass
`define uvm_nonblocking_transport_imp_decl(SFX) \
class uvm_nonblocking_transport_imp``SFX #(type REQ=int, type RSP=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP)); \
  `UVM_IMP_COMMON(`UVM_TLM_NONBLOCKING_TRANSPORT_MASK,`"uvm_nonblocking_transport_imp``SFX`",IMP) \
  `UVM_NONBLOCKING_TRANSPORT_IMP_SFX(SFX, m_imp, REQ, RSP, req, rsp) \
endclass
`define uvm_non_blocking_transport_imp_decl(SFX) \
  `uvm_nonblocking_transport_imp_decl(SFX)
`define uvm_transport_imp_decl(SFX) \
class uvm_transport_imp``SFX #(type REQ=int, type RSP=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP)); \
  `UVM_IMP_COMMON(`UVM_TLM_TRANSPORT_MASK,`"uvm_transport_imp``SFX`",IMP) \
  `UVM_BLOCKING_TRANSPORT_IMP_SFX(SFX, m_imp, REQ, RSP, req, rsp) \
  `UVM_NONBLOCKING_TRANSPORT_IMP_SFX(SFX, m_imp, REQ, RSP, req, rsp) \
endclass
`define uvm_analysis_imp_decl(SFX) \
class uvm_analysis_imp``SFX #(type T=int, type IMP=int) \
  extends uvm_port_base #(uvm_tlm_if_base #(T,T)); \
  `UVM_IMP_COMMON(`UVM_TLM_ANALYSIS_MASK,`"uvm_analysis_imp``SFX`",IMP) \
  function void write( input T t); \
    m_imp.write``SFX( t); \
  endfunction \
  \
endclass
`define UVM_BLOCKING_PUT_IMP_SFX(SFX, imp, TYPE, arg) \
  task put( input TYPE arg); imp.put``SFX( arg); endtask
`define UVM_BLOCKING_GET_IMP_SFX(SFX, imp, TYPE, arg) \
  task get( output TYPE arg); imp.get``SFX( arg); endtask
`define UVM_BLOCKING_PEEK_IMP_SFX(SFX, imp, TYPE, arg) \
  task peek( output TYPE arg);imp.peek``SFX( arg); endtask
`define UVM_NONBLOCKING_PUT_IMP_SFX(SFX, imp, TYPE, arg) \
  function bit try_put( input TYPE arg); \
    if( !imp.try_put``SFX( arg)) return 0; \
    return 1; \
  endfunction \
  function bit can_put(); return imp.can_put``SFX(); endfunction
`define UVM_NONBLOCKING_GET_IMP_SFX(SFX, imp, TYPE, arg) \
  function bit try_get( output TYPE arg); \
    if( !imp.try_get``SFX( arg)) return 0; \
    return 1; \
  endfunction \
  function bit can_get(); return imp.can_get``SFX(); endfunction
`define UVM_NONBLOCKING_PEEK_IMP_SFX(SFX, imp, TYPE, arg) \
  function bit try_peek( output TYPE arg); \
    if( !imp.try_peek``SFX( arg)) return 0; \
    return 1; \
  endfunction \
  function bit can_peek(); return imp.can_peek``SFX(); endfunction
`define UVM_BLOCKING_TRANSPORT_IMP_SFX(SFX, imp, REQ, RSP, req_arg, rsp_arg) \
  task transport( input REQ req_arg, output RSP rsp_arg); \
    imp.transport``SFX(req_arg, rsp_arg); \
  endtask
`define UVM_NONBLOCKING_TRANSPORT_IMP_SFX(SFX, imp, REQ, RSP, req_arg, rsp_arg) \
  function bit nb_transport( input REQ req_arg, output RSP rsp_arg); \
    if(imp) return imp.nb_transport``SFX(req_arg, rsp_arg); \
  endfunction
`define UVM_SEQ_ITEM_PULL_IMP(imp, REQ, RSP, req_arg, rsp_arg) \
  function void disable_auto_item_recording(); imp.disable_auto_item_recording(); endfunction \
  function bit is_auto_item_recording_enabled(); return imp.is_auto_item_recording_enabled(); endfunction \
  task get_next_item(output REQ req_arg); imp.get_next_item(req_arg); endtask \
  task try_next_item(output REQ req_arg); imp.try_next_item(req_arg); endtask \
  function void item_done(input RSP rsp_arg = null); imp.item_done(rsp_arg); endfunction \
  task wait_for_sequences(); imp.wait_for_sequences(); endtask \
  function bit has_do_available(); return imp.has_do_available(); endfunction \
  function void put_response(input RSP rsp_arg); imp.put_response(rsp_arg); endfunction \
  task get(output REQ req_arg); imp.get(req_arg); endtask \
  task peek(output REQ req_arg); imp.peek(req_arg); endtask \
  task put(input RSP rsp_arg); imp.put(rsp_arg); endtask
`define UVM_TLM_BLOCKING_PUT_MASK (1<<0)
`define UVM_TLM_BLOCKING_GET_MASK (1<<1)
`define UVM_TLM_BLOCKING_PEEK_MASK (1<<2)
`define UVM_TLM_BLOCKING_TRANSPORT_MASK (1<<3)
`define UVM_TLM_NONBLOCKING_PUT_MASK (1<<4)
`define UVM_TLM_NONBLOCKING_GET_MASK (1<<5)
`define UVM_TLM_NONBLOCKING_PEEK_MASK (1<<6)
`define UVM_TLM_NONBLOCKING_TRANSPORT_MASK (1<<7)
`define UVM_TLM_ANALYSIS_MASK (1<<8)
`define UVM_TLM_MASTER_BIT_MASK (1<<9)
`define UVM_TLM_SLAVE_BIT_MASK (1<<10)
`define UVM_TLM_PUT_MASK (`UVM_TLM_BLOCKING_PUT_MASK    | `UVM_TLM_NONBLOCKING_PUT_MASK)
`define UVM_TLM_GET_MASK (`UVM_TLM_BLOCKING_GET_MASK    | `UVM_TLM_NONBLOCKING_GET_MASK)
`define UVM_TLM_PEEK_MASK (`UVM_TLM_BLOCKING_PEEK_MASK   | `UVM_TLM_NONBLOCKING_PEEK_MASK)
`define UVM_TLM_BLOCKING_GET_PEEK_MASK (`UVM_TLM_BLOCKING_GET_MASK    | `UVM_TLM_BLOCKING_PEEK_MASK)
`define UVM_TLM_BLOCKING_MASTER_MASK (`UVM_TLM_BLOCKING_PUT_MASK       | `UVM_TLM_BLOCKING_GET_MASK | `UVM_TLM_BLOCKING_PEEK_MASK | `UVM_TLM_MASTER_BIT_MASK)
`define UVM_TLM_BLOCKING_SLAVE_MASK (`UVM_TLM_BLOCKING_PUT_MASK       | `UVM_TLM_BLOCKING_GET_MASK | `UVM_TLM_BLOCKING_PEEK_MASK | `UVM_TLM_SLAVE_BIT_MASK)
`define UVM_TLM_NONBLOCKING_GET_PEEK_MASK (`UVM_TLM_NONBLOCKING_GET_MASK | `UVM_TLM_NONBLOCKING_PEEK_MASK)
`define UVM_TLM_NONBLOCKING_MASTER_MASK (`UVM_TLM_NONBLOCKING_PUT_MASK    | `UVM_TLM_NONBLOCKING_GET_MASK | `UVM_TLM_NONBLOCKING_PEEK_MASK | `UVM_TLM_MASTER_BIT_MASK)
`define UVM_TLM_NONBLOCKING_SLAVE_MASK (`UVM_TLM_NONBLOCKING_PUT_MASK    | `UVM_TLM_NONBLOCKING_GET_MASK | `UVM_TLM_NONBLOCKING_PEEK_MASK | `UVM_TLM_SLAVE_BIT_MASK)
`define UVM_TLM_GET_PEEK_MASK (`UVM_TLM_GET_MASK | `UVM_TLM_PEEK_MASK)
`define UVM_TLM_MASTER_MASK (`UVM_TLM_BLOCKING_MASTER_MASK    | `UVM_TLM_NONBLOCKING_MASTER_MASK)
`define UVM_TLM_SLAVE_MASK (`UVM_TLM_BLOCKING_SLAVE_MASK    | `UVM_TLM_NONBLOCKING_SLAVE_MASK)
`define UVM_TLM_TRANSPORT_MASK (`UVM_TLM_BLOCKING_TRANSPORT_MASK | `UVM_TLM_NONBLOCKING_TRANSPORT_MASK)
`define UVM_SEQ_ITEM_GET_NEXT_ITEM_MASK (1<<0)
`define UVM_SEQ_ITEM_TRY_NEXT_ITEM_MASK (1<<1)
`define UVM_SEQ_ITEM_ITEM_DONE_MASK (1<<2)
`define UVM_SEQ_ITEM_HAS_DO_AVAILABLE_MASK (1<<3)
`define UVM_SEQ_ITEM_WAIT_FOR_SEQUENCES_MASK (1<<4)
`define UVM_SEQ_ITEM_PUT_RESPONSE_MASK (1<<5)
`define UVM_SEQ_ITEM_PUT_MASK (1<<6)
`define UVM_SEQ_ITEM_GET_MASK (1<<7)
`define UVM_SEQ_ITEM_PEEK_MASK (1<<8)
`define UVM_SEQ_ITEM_PULL_MASK (`UVM_SEQ_ITEM_GET_NEXT_ITEM_MASK | `UVM_SEQ_ITEM_TRY_NEXT_ITEM_MASK | \
                        `UVM_SEQ_ITEM_ITEM_DONE_MASK | `UVM_SEQ_ITEM_HAS_DO_AVAILABLE_MASK |  \
                        `UVM_SEQ_ITEM_WAIT_FOR_SEQUENCES_MASK | `UVM_SEQ_ITEM_PUT_RESPONSE_MASK | \
                        `UVM_SEQ_ITEM_PUT_MASK | `UVM_SEQ_ITEM_GET_MASK | `UVM_SEQ_ITEM_PEEK_MASK)
`define UVM_SEQ_ITEM_UNI_PULL_MASK (`UVM_SEQ_ITEM_GET_NEXT_ITEM_MASK | `UVM_SEQ_ITEM_TRY_NEXT_ITEM_MASK | \
                           `UVM_SEQ_ITEM_ITEM_DONE_MASK | `UVM_SEQ_ITEM_HAS_DO_AVAILABLE_MASK | \
                           `UVM_SEQ_ITEM_WAIT_FOR_SEQUENCES_MASK | `UVM_SEQ_ITEM_GET_MASK | \
                           `UVM_SEQ_ITEM_PEEK_MASK)
`define UVM_SEQ_ITEM_PUSH_MASK (`UVM_SEQ_ITEM_PUT_MASK)
`define UVM_TLM_IMPS_SVH
`define UVM_BLOCKING_PUT_IMP(imp, TYPE, arg) \
  task put (TYPE arg); \
    imp.put(arg); \
  endtask
`define UVM_NONBLOCKING_PUT_IMP(imp, TYPE, arg) \
  function bit try_put (TYPE arg); \
    return imp.try_put(arg); \
  endfunction \
  function bit can_put(); \
    return imp.can_put(); \
  endfunction
`define UVM_BLOCKING_GET_IMP(imp, TYPE, arg) \
  task get (output TYPE arg); \
    imp.get(arg); \
  endtask
`define UVM_NONBLOCKING_GET_IMP(imp, TYPE, arg) \
  function bit try_get (output TYPE arg); \
    return imp.try_get(arg); \
  endfunction \
  function bit can_get(); \
    return imp.can_get(); \
  endfunction
`define UVM_BLOCKING_PEEK_IMP(imp, TYPE, arg) \
  task peek (output TYPE arg); \
    imp.peek(arg); \
  endtask
`define UVM_NONBLOCKING_PEEK_IMP(imp, TYPE, arg) \
  function bit try_peek (output TYPE arg); \
    return imp.try_peek(arg); \
  endfunction \
  function bit can_peek(); \
    return imp.can_peek(); \
  endfunction
`define UVM_BLOCKING_TRANSPORT_IMP(imp, REQ, RSP, req_arg, rsp_arg) \
  task transport (REQ req_arg, output RSP rsp_arg); \
    imp.transport(req_arg, rsp_arg); \
  endtask
`define UVM_NONBLOCKING_TRANSPORT_IMP(imp, REQ, RSP, req_arg, rsp_arg) \
  function bit nb_transport (REQ req_arg, output RSP rsp_arg); \
    return imp.nb_transport(req_arg, rsp_arg); \
  endfunction
`define UVM_PUT_IMP(imp, TYPE, arg) \
  `UVM_BLOCKING_PUT_IMP(imp, TYPE, arg) \
  `UVM_NONBLOCKING_PUT_IMP(imp, TYPE, arg)
`define UVM_GET_IMP(imp, TYPE, arg) \
  `UVM_BLOCKING_GET_IMP(imp, TYPE, arg) \
  `UVM_NONBLOCKING_GET_IMP(imp, TYPE, arg)
`define UVM_PEEK_IMP(imp, TYPE, arg) \
  `UVM_BLOCKING_PEEK_IMP(imp, TYPE, arg) \
  `UVM_NONBLOCKING_PEEK_IMP(imp, TYPE, arg)
`define UVM_BLOCKING_GET_PEEK_IMP(imp, TYPE, arg) \
  `UVM_BLOCKING_GET_IMP(imp, TYPE, arg) \
  `UVM_BLOCKING_PEEK_IMP(imp, TYPE, arg)
`define UVM_NONBLOCKING_GET_PEEK_IMP(imp, TYPE, arg) \
  `UVM_NONBLOCKING_GET_IMP(imp, TYPE, arg) \
  `UVM_NONBLOCKING_PEEK_IMP(imp, TYPE, arg)
`define UVM_GET_PEEK_IMP(imp, TYPE, arg) \
  `UVM_BLOCKING_GET_PEEK_IMP(imp, TYPE, arg) \
  `UVM_NONBLOCKING_GET_PEEK_IMP(imp, TYPE, arg)
`define UVM_TRANSPORT_IMP(imp, REQ, RSP, req_arg, rsp_arg) \
  `UVM_BLOCKING_TRANSPORT_IMP(imp, REQ, RSP, req_arg, rsp_arg) \
  `UVM_NONBLOCKING_TRANSPORT_IMP(imp, REQ, RSP, req_arg, rsp_arg)
`define UVM_TLM_GET_TYPE_NAME(NAME) \
  virtual function string get_type_name(); \
    return NAME; \
  endfunction
`define UVM_PORT_COMMON(MASK,TYPE_NAME) \
  function new (string name, uvm_component parent, \
                int min_size=1, int max_size=1); \
    super.new (name, parent, UVM_PORT, min_size, max_size); \
    m_if_mask = MASK; \
  endfunction \
  `UVM_TLM_GET_TYPE_NAME(TYPE_NAME)
`define UVM_SEQ_PORT(MASK,TYPE_NAME) \
  function new (string name, uvm_component parent, \
                int min_size=0, int max_size=1); \
    super.new (name, parent, UVM_PORT, min_size, max_size); \
    m_if_mask = MASK; \
  endfunction \
  `UVM_TLM_GET_TYPE_NAME(TYPE_NAME)
`define UVM_EXPORT_COMMON(MASK,TYPE_NAME) \
  function new (string name, uvm_component parent, \
                int min_size=1, int max_size=1); \
    super.new (name, parent, UVM_EXPORT, min_size, max_size); \
    m_if_mask = MASK; \
  endfunction \
  `UVM_TLM_GET_TYPE_NAME(TYPE_NAME)
`define UVM_IMP_COMMON(MASK,TYPE_NAME,IMP) \
  local IMP m_imp; \
  function new (string name, IMP imp); \
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1); \
    m_imp = imp; \
    m_if_mask = MASK; \
  endfunction \
  `UVM_TLM_GET_TYPE_NAME(TYPE_NAME)
`define UVM_MS_IMP_COMMON(MASK,TYPE_NAME) \
  local this_req_type m_req_imp; \
  local this_rsp_type m_rsp_imp; \
  function new (string name, this_imp_type imp, \
                this_req_type req_imp = null, this_rsp_type rsp_imp = null); \
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1); \
    if(req_imp==null) begin \
      $cast(req_imp, imp); \
    end \
    if(rsp_imp==null) begin \
      $cast(rsp_imp, imp); \
    end \
    m_req_imp = req_imp; \
    m_rsp_imp = rsp_imp; \
    m_if_mask = MASK; \
  endfunction  \
  `UVM_TLM_GET_TYPE_NAME(TYPE_NAME)
`define uvm_create(SEQ_OR_ITEM, SEQR=get_sequencer()) \
  begin \
  uvm_object_wrapper w_; \
  w_ = SEQ_OR_ITEM.get_type(); \
  $cast(SEQ_OR_ITEM , create_item(w_, SEQR, `"SEQ_OR_ITEM`"));\
  end
`define uvm_do(SEQ_OR_ITEM, SEQR=get_sequencer(), PRIORITY=-1, CONSTRAINTS={}) \
  begin \
  `uvm_create(SEQ_OR_ITEM, SEQR) \
  `uvm_rand_send(SEQ_OR_ITEM, PRIORITY, CONSTRAINTS) \
  end
`define uvm_send(SEQ_OR_ITEM, PRIORITY=-1) \
  begin \
  uvm_sequence_base __seq; \
  if (!$cast(__seq,SEQ_OR_ITEM)) begin \
     start_item(SEQ_OR_ITEM, PRIORITY);\
     finish_item(SEQ_OR_ITEM, PRIORITY);\
  end \
  else __seq.start(__seq.get_sequencer(), this, PRIORITY, 0);\
  end
`define uvm_rand_send(SEQ_OR_ITEM, PRIORITY=-1, CONSTRAINTS={}) \
  begin \
  uvm_sequence_base __seq; \
  if ( SEQ_OR_ITEM.is_item() ) begin \
    start_item(SEQ_OR_ITEM, PRIORITY);\
    if ( ! SEQ_OR_ITEM.randomize() with CONSTRAINTS ) begin \
      `uvm_warning("RNDFLD", "Randomization failed in uvm_rand_send action") \
    end\
    finish_item(SEQ_OR_ITEM, PRIORITY);\
  end \
  else if ( $cast( __seq, SEQ_OR_ITEM ) ) begin \
    __seq.set_item_context(this,SEQ_OR_ITEM.get_sequencer()); \
    if ( __seq.get_randomize_enabled() ) begin \
      if ( ! SEQ_OR_ITEM.randomize() with CONSTRAINTS ) begin \
        `uvm_warning("RNDFLD", "Randomization failed in uvm_rand_send action") \
      end \
    end \
    __seq.start(__seq.get_sequencer(), this, PRIORITY, 0);\
  end \
  else begin \
    `uvm_warning("NOT_SEQ_OR_ITEM", "Object passed uvm_rand_send appears to be neither a sequence or item." ) \
  end \
  end
`define uvm_add_to_seq_lib(TYPE,LIBTYPE) \
   static bit add_``TYPE``_to_seq_lib_``LIBTYPE =\
      LIBTYPE::m_add_typewide_sequence(TYPE::get_type());
`define uvm_sequence_library_utils(TYPE) \
\
   static protected uvm_object_wrapper m_typewide_sequences[$]; \
   \
   function void init_sequence_library(); \
     foreach (TYPE::m_typewide_sequences[i]) \
       sequences.push_back(TYPE::m_typewide_sequences[i]); \
   endfunction \
   \
   static function void add_typewide_sequence(uvm_object_wrapper seq_type); \
     if (m_static_check(seq_type)) \
       TYPE::m_typewide_sequences.push_back(seq_type); \
   endfunction \
   \
   static function void add_typewide_sequences(uvm_object_wrapper seq_types[$]); \
     foreach (seq_types[i]) \
       TYPE::add_typewide_sequence(seq_types[i]); \
   endfunction \
   \
   static function bit m_add_typewide_sequence(uvm_object_wrapper seq_type); \
     TYPE::add_typewide_sequence(seq_type); \
     return 1; \
   endfunction
`define uvm_declare_p_sequencer(SEQUENCER) \
  SEQUENCER p_sequencer;\
  virtual function void m_set_p_sequencer();\
    super.m_set_p_sequencer(); \
    if( !$cast(p_sequencer, m_sequencer)) \
        `uvm_fatal("DCLPSQ", \
        $sformatf("%m %s Error casting p_sequencer, please verify that this sequence/sequence item is intended to execute on this type of sequencer", get_full_name())) \
  endfunction
`define UVM_CB_MACROS_SVH
`define uvm_register_cb(T,CB) \
  static local bit m_register_cb_``CB = uvm_callbacks#(T,CB)::m_register_pair(`"T`",`"CB`");
`define uvm_set_super_type(T,ST) \
  static local bit m_register_``T``ST = uvm_derived_callbacks#(T,ST)::register_super_type(`"T`",`"ST`");
`define uvm_do_callbacks(T,CB,METHOD) \
  `uvm_do_obj_callbacks(T,CB,this,METHOD)
`define uvm_do_obj_callbacks(T,CB,OBJ,METHOD) \
   begin \
     uvm_callback_iter#(T,CB) iter = new(OBJ); \
     CB cb = iter.first(); \
     while(cb != null) begin \
       `uvm_cb_trace_noobj(cb,$sformatf(`"Executing callback method 'METHOD' for callback %s (CB) from %s (T)`",cb.get_name(), OBJ.get_full_name())) \
       cb.METHOD; \
       cb = iter.next(); \
     end \
   end
`define uvm_do_callbacks_exit_on(T,CB,METHOD,VAL) \
  `uvm_do_obj_callbacks_exit_on(T,CB,this,METHOD,VAL) \

`define uvm_do_obj_callbacks_exit_on(T,CB,OBJ,METHOD,VAL) \
   begin \
     uvm_callback_iter#(T,CB) iter = new(OBJ); \
     CB cb = iter.first(); \
     while(cb != null) begin \
       if (cb.METHOD == VAL) begin \
         `uvm_cb_trace_noobj(cb,$sformatf(`"Executed callback method 'METHOD' for callback %s (CB) from %s (T) : returned value VAL (other callbacks will be ignored)`",cb.get_name(), OBJ.get_full_name())) \
         return VAL; \
       end \
       `uvm_cb_trace_noobj(cb,$sformatf(`"Executed callback method 'METHOD' for callback %s (CB) from %s (T) : did not return value VAL`",cb.get_name(), OBJ.get_full_name())) \
       cb = iter.next(); \
     end \
     return 1-VAL; \
   end
`define uvm_cb_trace_noobj(CB,OPER) /* null */
`define uvm_cb_trace(OBJ,CB,OPER) /* null */
`define UVM_REG_ADDR_WIDTH 64
`define UVM_REG_DATA_WIDTH 64
`define UVM_REG_BYTENABLE_WIDTH ((`UVM_REG_DATA_WIDTH-1)/8+1)
`define UVM_REG_CVR_WIDTH 32
`define uvm_do_pri(SEQ_OR_ITEM, PRIORITY) \
  `uvm_do(SEQ_OR_ITEM, get_sequencer(), PRIORITY, {})
`define uvm_do_with(SEQ_OR_ITEM, CONSTRAINTS) \
  `uvm_do(SEQ_OR_ITEM, get_sequencer(), -1, CONSTRAINTS)
`define uvm_do_pri_with(SEQ_OR_ITEM, PRIORITY, CONSTRAINTS) \
  `uvm_do(SEQ_OR_ITEM, get_sequencer(), PRIORITY, CONSTRAINTS)
`define uvm_create_on(SEQ_OR_ITEM, SEQR) \
  `uvm_create(SEQ_OR_ITEM, SEQR)
`define uvm_do_on(SEQ_OR_ITEM, SEQR) \
  `uvm_do(SEQ_OR_ITEM, SEQR, -1, {})
`define uvm_do_on_pri(SEQ_OR_ITEM, SEQR, PRIORITY) \
  `uvm_do(SEQ_OR_ITEM, SEQR, PRIORITY, {})
`define uvm_do_on_with(SEQ_OR_ITEM, SEQR, CONSTRAINTS) \
  `uvm_do(SEQ_OR_ITEM, SEQR, -1, CONSTRAINTS)
`define uvm_do_on_pri_with(SEQ_OR_ITEM, SEQR, PRIORITY, CONSTRAINTS) \
  `uvm_do(SEQ_OR_ITEM, SEQR, PRIORITY, CONSTRAINTS)
`define uvm_send_pri(SEQ_OR_ITEM, PRIORITY) \
  `uvm_send(SEQ_OR_ITEM, PRIORITY)
`define uvm_rand_send_pri(SEQ_OR_ITEM, PRIORITY) \
  `uvm_rand_send(SEQ_OR_ITEM, PRIORITY, {})
`define uvm_rand_send_with(SEQ_OR_ITEM, CONSTRAINTS) \
  `uvm_rand_send(SEQ_OR_ITEM, -1, CONSTRAINTS)
`define uvm_rand_send_pri_with(SEQ_OR_ITEM, PRIORITY, CONSTRAINTS) \
  `uvm_rand_send(SEQ_OR_ITEM, PRIORITY, CONSTRAINTS)
`define uvm_create_seq(UVM_SEQ, SEQR_CONS_IF) \
  `uvm_create(UVM_SEQ, SEQR_CONS_IF.consumer_seqr) \

`define uvm_do_seq(UVM_SEQ, SEQR_CONS_IF) \
  `uvm_do(UVM_SEQ, SEQR_CONS_IF.consumer_seqr, -1, {}) \

`define uvm_do_seq_with(UVM_SEQ, SEQR_CONS_IF, CONSTRAINTS) \
  `uvm_do(UVM_SEQ, SEQR_CONS_IF.consumer_seqr, -1, CONSTRAINTS) \

package uvm_pkg;
`define UVM_DPI_SVH
`define UVM_HDL_NO_DPI
`define UVM_REGEX_NO_DPI
`define UVM_CMDLINE_NO_DPI
`define UVM_HDL__SVH
`define UVM_HDL_MAX_WIDTH 1024
parameter int UVM_HDL_MAX_WIDTH = 1024;
typedef logic [UVM_HDL_MAX_WIDTH-1:0] uvm_hdl_data_t;
  function int uvm_hdl_check_path(string path);
    uvm_report_fatal("UVM_HDL_CHECK_PATH",
      $sformatf("uvm_hdl DPI routines are compiled off. Recompile without +define+UVM_HDL_NO_DPI"));
    return 0;
  endfunction
  function int uvm_hdl_deposit(string path, uvm_hdl_data_t value);
    uvm_report_fatal("UVM_HDL_DEPOSIT",
      $sformatf("uvm_hdl DPI routines are compiled off. Recompile without +define+UVM_HDL_NO_DPI"));
    return 0;
  endfunction
  function int uvm_hdl_force(string path, uvm_hdl_data_t value);
    uvm_report_fatal("UVM_HDL_FORCE",
      $sformatf("uvm_hdl DPI routines are compiled off. Recompile without +define+UVM_HDL_NO_DPI"));
    return 0;
  endfunction
  task uvm_hdl_force_time(string path, uvm_hdl_data_t value, time force_time=0);
    uvm_report_fatal("UVM_HDL_FORCE_TIME",
      $sformatf("uvm_hdl DPI routines are compiled off. Recompile without +define+UVM_HDL_NO_DPI"));
  endtask
  function int uvm_hdl_release(string path);
    uvm_report_fatal("UVM_HDL_RELEASE",
      $sformatf("uvm_hdl DPI routines are compiled off. Recompile without +define+UVM_HDL_NO_DPI"));
    return 0;
  endfunction
  function int uvm_hdl_read(string path, output uvm_hdl_data_t value);
    uvm_report_fatal("UVM_HDL_READ",
      $sformatf("uvm_hdl DPI routines are compiled off. Recompile without +define+UVM_HDL_NO_DPI"));
    return 0;
  endfunction
function string uvm_dpi_get_next_arg(int init=0);
  return "";
endfunction
function string uvm_dpi_get_tool_name();
  return "?";
endfunction
function string uvm_dpi_get_tool_version();
  return "?";
endfunction
function chandle uvm_dpi_regcomp(string regex); return null; endfunction
function int uvm_dpi_regexec(chandle preg, string str); return 0; endfunction
function void uvm_dpi_regfree(chandle preg); endfunction
function int uvm_re_match(string re, string str, bit deglob = 0);
  int e, es, s, ss;
  string tmp;
  e  = 0; s  = 0;
  es = 0; ss = 0;
  if(re.len() == 0)
    return 0;
  if(re[0] == "^")
    re = re.substr(1, re.len()-1);
  while (s != str.len() && re.getc(e) != "*") begin
    if ((re.getc(e) != str.getc(s)) && (re.getc(e) != "?"))
      return 1;
    e++; s++;
  end
  while (s != str.len()) begin
    if (re.getc(e) == "*") begin
      e++;
      if (e == re.len()) begin
        return 0;
      end
      es = e;
      ss = s+1;
    end
    else if (re.getc(e) == str.getc(s) || re.getc(e) == "?") begin
      e++;
      s++;
    end
    else begin
      e = es;
      s = ss++;
    end
  end
  while (e < re.len() && re.getc(e) == "*")
    e++;
  if(e == re.len()) begin
    return 0;
  end
  else begin
    return 1;
  end
endfunction
function string uvm_glob_to_re(string glob);
  return glob;
endfunction
`define UVM_BASE_SVH
  typedef class uvm_cmdline_processor;
`define UVM_VERSION_SVH
parameter string UVM_VERSION_STRING = "Accellera:1800.2:UVM:2020.3.1";
function string uvm_revision_string();
  return UVM_VERSION_STRING;
endfunction
parameter UVM_STREAMBITS = 4096;
typedef logic signed [UVM_STREAMBITS-1:0] uvm_bitstream_t;
typedef logic signed [63:0] uvm_integral_t;
typedef int uvm_transaction_id_t;
typedef int uvm_tr_handle_t;
parameter UVM_FIELD_FLAG_RESERVED_BITS = 28;
typedef bit [UVM_FIELD_FLAG_RESERVED_BITS-1 : 0] uvm_field_flag_t;
typedef enum uvm_field_flag_t {
   UVM_BIN       = 'h1000000,
   UVM_DEC       = 'h2000000,
   UVM_UNSIGNED  = 'h3000000,
   UVM_UNFORMAT2 = 'h4000000,
   UVM_UNFORMAT4 = 'h5000000,
   UVM_OCT       = 'h6000000,
   UVM_HEX       = 'h7000000,
   UVM_STRING    = 'h8000000,
   UVM_TIME      = 'h9000000,
   UVM_ENUM      = 'ha000000,
   UVM_REAL      = 'hb000000,
   UVM_REAL_DEC  = 'hc000000,
   UVM_REAL_EXP  = 'hd000000,
   UVM_NORADIX   = 0
} uvm_radix_enum;
parameter UVM_RADIX = 'hf000000;
function string uvm_radix_to_string(uvm_radix_enum radix);
  case(radix)
    UVM_BIN:        begin
      return "b";
    end
    UVM_OCT:        begin
      return "o";
    end
    UVM_DEC:        begin
      return "d";
    end
    UVM_HEX:        begin
      return "h";
    end
    UVM_UNSIGNED:   begin
      return "u";
    end
    UVM_UNFORMAT2:  begin
      return "u";
    end
    UVM_UNFORMAT4:  begin
      return "z";
    end
    UVM_STRING:     begin
      return "s";
    end
    UVM_TIME:       begin
      return "t";
    end
    UVM_ENUM:       begin
      return "s";
    end
    UVM_REAL:       begin
      return "g";
    end
    UVM_REAL_DEC:   begin
      return "f";
    end
    UVM_REAL_EXP:   begin
      return "e";
    end
    default:        begin
      return "x";
    end
  endcase
endfunction
typedef enum uvm_field_flag_t {
  UVM_DEFAULT_POLICY = 0,
  UVM_DEEP           = (1<<16),
  UVM_SHALLOW        = (1<<17),
  UVM_REFERENCE      = (1<<18)
 } uvm_recursion_policy_enum;
parameter UVM_RECURSION = (UVM_DEEP|UVM_SHALLOW|UVM_REFERENCE);
typedef enum bit { UVM_PASSIVE=0, UVM_ACTIVE=1 } uvm_active_passive_enum;
parameter uvm_field_flag_t UVM_MACRO_NUMFLAGS    = 19;
parameter uvm_field_flag_t UVM_COPY         = (1<<0);
parameter uvm_field_flag_t UVM_NOCOPY       = (1<<1);
parameter uvm_field_flag_t UVM_COMPARE      = (1<<2);
parameter uvm_field_flag_t UVM_NOCOMPARE    = (1<<3);
parameter uvm_field_flag_t UVM_PRINT        = (1<<4);
parameter uvm_field_flag_t UVM_NOPRINT      = (1<<5);
parameter uvm_field_flag_t UVM_RECORD       = (1<<6);
parameter uvm_field_flag_t UVM_NORECORD     = (1<<7);
parameter uvm_field_flag_t UVM_PACK         = (1<<8);
parameter uvm_field_flag_t UVM_NOPACK       = (1<<9);
parameter uvm_field_flag_t UVM_UNPACK       = (1<<10);
parameter uvm_field_flag_t UVM_NOUNPACK     = UVM_NOPACK;
parameter uvm_field_flag_t UVM_SET          = (1<<11);
parameter uvm_field_flag_t UVM_NOSET        = (1<<12);
parameter uvm_field_flag_t UVM_PHYSICAL     = (1<<13);
parameter uvm_field_flag_t UVM_ABSTRACT     = (1<<14);
parameter uvm_field_flag_t UVM_READONLY     = UVM_NOSET;
parameter uvm_field_flag_t UVM_NODEFPRINT   = (1<<15);
parameter uvm_field_flag_t UVM_FLAGS_ON    = UVM_COPY | UVM_COMPARE |
                                             UVM_PRINT | UVM_RECORD |
                                             UVM_PACK | UVM_UNPACK | UVM_SET ;
parameter uvm_field_flag_t UVM_FLAGS_OFF   = 0;
parameter uvm_field_flag_t UVM_ALL_ON      = UVM_FLAGS_ON;
parameter uvm_field_flag_t UVM_DEFAULT     = UVM_ALL_ON;
parameter uvm_field_flag_t UVM_MACRO_EXTRAS  = (1<<UVM_MACRO_NUMFLAGS);
parameter uvm_field_flag_t UVM_FLAGS         = UVM_MACRO_EXTRAS+1;
parameter uvm_field_flag_t UVM_CHECK_FIELDS  = UVM_MACRO_EXTRAS+2;
parameter uvm_field_flag_t UVM_END_DATA_EXTRA = UVM_MACRO_EXTRAS+3;
parameter uvm_field_flag_t UVM_START_FUNCS   = UVM_END_DATA_EXTRA+1;
parameter uvm_field_flag_t UVM_END_FUNCS     = UVM_START_FUNCS+1;
string uvm_aa_string_key;
typedef enum bit [1:0]
{
  UVM_INFO,
  UVM_WARNING,
  UVM_ERROR,
  UVM_FATAL
} uvm_severity;
typedef uvm_severity uvm_severity_type;
typedef int uvm_action;
typedef enum
{
  UVM_NO_ACTION = 'b0000000,
  UVM_DISPLAY   = 'b0000001,
  UVM_LOG       = 'b0000010,
  UVM_COUNT     = 'b0000100,
  UVM_EXIT      = 'b0001000,
  UVM_CALL_HOOK = 'b0010000,
  UVM_STOP      = 'b0100000,
  UVM_RM_RECORD = 'b1000000
} uvm_action_type;
typedef enum
{
  UVM_NONE   = 0,
  UVM_LOW    = 100,
  UVM_MEDIUM = 200,
  UVM_HIGH   = 300,
  UVM_FULL   = 400,
  UVM_DEBUG  = 500
} uvm_verbosity;
typedef enum
{
  UVM_PORT ,
  UVM_EXPORT ,
  UVM_IMPLEMENTATION
} uvm_port_type_e;
typedef enum
{
  UVM_SEQ_ARB_FIFO,
  UVM_SEQ_ARB_WEIGHTED,
  UVM_SEQ_ARB_RANDOM,
  UVM_SEQ_ARB_STRICT_FIFO,
  UVM_SEQ_ARB_STRICT_RANDOM,
  UVM_SEQ_ARB_USER
} uvm_sequencer_arb_mode;
typedef uvm_sequencer_arb_mode UVM_SEQ_ARB_TYPE;
typedef enum
{
  UVM_CREATED   = 1,
  UVM_PRE_START = 2,
  UVM_PRE_BODY  = 4,
  UVM_BODY      = 8,
  UVM_POST_BODY = 16,
  UVM_POST_START= 32,
  UVM_ENDED     = 64,
  UVM_STOPPED   = 128,
  UVM_FINISHED  = 256
} uvm_sequence_state;
typedef uvm_sequence_state uvm_sequence_state_enum;
typedef enum
{
  UVM_SEQ_LIB_RAND,
  UVM_SEQ_LIB_RANDC,
  UVM_SEQ_LIB_ITEM,
  UVM_SEQ_LIB_USER
} uvm_sequence_lib_mode;
typedef enum { UVM_PHASE_IMP,
               UVM_PHASE_NODE,
               UVM_PHASE_TERMINAL,
               UVM_PHASE_SCHEDULE,
               UVM_PHASE_DOMAIN,
               UVM_PHASE_GLOBAL
} uvm_phase_type;
   typedef enum { UVM_PHASE_UNINITIALIZED = 0,
                  UVM_PHASE_DORMANT      = 1,
                  UVM_PHASE_SCHEDULED    = 2,
                  UVM_PHASE_SYNCING      = 4,
                  UVM_PHASE_STARTED      = 8,
                  UVM_PHASE_EXECUTING    = 16,
                  UVM_PHASE_READY_TO_END = 32,
                  UVM_PHASE_ENDED        = 64,
                  UVM_PHASE_CLEANUP      = 128,
                  UVM_PHASE_DONE         = 256,
                  UVM_PHASE_JUMPING      = 512
                  } uvm_phase_state;
typedef enum { UVM_LT,
               UVM_LTE,
               UVM_NE,
               UVM_EQ,
               UVM_GT,
               UVM_GTE
} uvm_wait_op;
typedef enum { UVM_RAISED      = 'h01,
               UVM_DROPPED     = 'h02,
               UVM_ALL_DROPPED = 'h04
} uvm_objection_event;
typedef int UVM_FILE;
parameter UVM_FILE UVM_STDIN  = 32'h8000_0000;
parameter UVM_FILE UVM_STDOUT = 32'h8000_0001;
parameter UVM_FILE UVM_STDERR = 32'h8000_0002;
typedef enum {
    UVM_CORE_UNINITIALIZED,
        UVM_CORE_PRE_INIT,
        UVM_CORE_INITIALIZING,
    UVM_CORE_INITIALIZED,
    UVM_CORE_PRE_RUN,
    UVM_CORE_RUNNING,
    UVM_CORE_POST_RUN,
    UVM_CORE_FINISHED,
    UVM_CORE_PRE_ABORT,
    UVM_CORE_ABORTED
} uvm_core_state;
typedef struct {
  string       name;
  string       regex;
} uvm_acs_name_struct;
uvm_core_state m_uvm_core_state[$];
parameter uvm_core_state UVM_CORE_POST_INIT = UVM_CORE_INITIALIZED;
typedef class uvm_object_wrapper;
uvm_object_wrapper uvm_deferred_init[$];
typedef class uvm_printer;
typedef class uvm_table_printer;
typedef class uvm_tree_printer;
typedef class uvm_line_printer;
typedef class uvm_comparer;
typedef class uvm_packer;
uvm_table_printer uvm_default_table_printer ;
uvm_tree_printer uvm_default_tree_printer  ;
uvm_line_printer uvm_default_line_printer  ;
uvm_printer uvm_default_printer ;
uvm_packer uvm_default_packer ;
uvm_comparer uvm_default_comparer ;
virtual class uvm_void;
endclass
typedef enum {UVM_APPEND, UVM_PREPEND} uvm_apprepend;
typedef class uvm_object;
typedef class uvm_coreservice_t;
typedef class uvm_factory;
typedef class uvm_config_db;
typedef uvm_config_db#(uvm_object) m_uvm_config_obj_misc;
typedef class uvm_comparer ;
typedef class uvm_packer ;
typedef class uvm_recorder ;
typedef class uvm_printer ;
int unsigned uvm_global_random_seed = $urandom;
class uvm_seed_map;
  int unsigned seed_table [string];
  int unsigned count [string];
endclass
uvm_seed_map uvm_random_seed_table_lookup [string];
function string uvm_instance_scope();
  byte c;
  int pos;
  if(uvm_instance_scope != "") begin
    return uvm_instance_scope;
  end
  $swrite(uvm_instance_scope, "%m");
  pos = uvm_instance_scope.len()-1;
  c = uvm_instance_scope[pos];
  while(pos && (c != ".") && (c != ":")) begin
    c = uvm_instance_scope[--pos];
  end
  if(pos == 0) begin
    uvm_report_error("SCPSTR", $sformatf("Illegal name %s in scope string",uvm_instance_scope));
  end
  uvm_instance_scope = uvm_instance_scope.substr(0,pos);
endfunction
parameter UVM_STR_CRC_POLYNOMIAL = 32'h04c11db6;
function int unsigned uvm_oneway_hash ( string string_in, int unsigned seed=0 );
  bit          msb;
  bit [7:0]    current_byte;
  bit [31:0]   crc1;
  if(!seed) begin
    seed = uvm_global_random_seed;
  end
  uvm_oneway_hash = seed;
  crc1 = 32'hffffffff;
  for (int _byte=0; _byte < string_in.len(); _byte++) begin
    current_byte = string_in[_byte];
    if (current_byte == 0) begin
      break;
    end
    for (int _bit=0; _bit < 8; _bit++) begin
      msb = crc1[31];
      crc1 <<= 1;
      if (msb ^ current_byte[_bit]) begin
        crc1 ^=  UVM_STR_CRC_POLYNOMIAL;
        crc1[0] = 1;
      end
    end
  end
  uvm_oneway_hash += ~{crc1[7:0], crc1[15:8], crc1[23:16], crc1[31:24]};
endfunction
function int unsigned uvm_create_random_seed ( string type_id, string inst_id="" );
  uvm_seed_map seed_map;
  if(inst_id == "") begin
    inst_id = "__global__";
  end
  if(!uvm_random_seed_table_lookup.exists(inst_id)) begin
    uvm_random_seed_table_lookup[inst_id] = new;
  end
  seed_map = uvm_random_seed_table_lookup[inst_id];
  type_id = {uvm_instance_scope(),type_id};
  if(!seed_map.seed_table.exists(type_id)) begin
    seed_map.seed_table[type_id] = uvm_oneway_hash ({type_id,"::",inst_id}, uvm_global_random_seed);
  end
  if (!seed_map.count.exists(type_id)) begin
    seed_map.count[type_id] = 0;
  end
  seed_map.seed_table[type_id] = seed_map.seed_table[type_id]+seed_map.count[type_id];
  seed_map.count[type_id]++;
  return seed_map.seed_table[type_id];
endfunction
function string uvm_object_value_str(uvm_object v);
  if (v == null) begin
    return "<null>";
  end
  uvm_object_value_str.itoa(v.get_inst_id());
  uvm_object_value_str = {"@",uvm_object_value_str};
endfunction
function string uvm_leaf_scope (string full_name, byte scope_separator = ".");
  byte bracket_match;
  int  pos;
  int  bmatches;
  bmatches = 0;
  case(scope_separator)
    "[": begin
      bracket_match = "]";
    end
    "(": begin
      bracket_match = ")";
    end
    "<": begin
      bracket_match = ">";
    end
    "{": begin
      bracket_match = "}";
    end
    default: begin
      bracket_match = "";
    end
  endcase
  if(bracket_match != "" && bracket_match != full_name[full_name.len()-1]) begin
    bracket_match = "";
  end
  for(pos=full_name.len()-1; pos>0; --pos) begin
    if(full_name[pos] == bracket_match) begin
      bmatches++;
    end
    else if(full_name[pos] == scope_separator) begin
      bmatches--;
      if(!bmatches || (bracket_match == "")) begin
        break;
      end
    end
  end
  if(pos) begin
    if(scope_separator != ".") begin
      pos--;
    end
    uvm_leaf_scope = full_name.substr(pos+1,full_name.len()-1);
  end
  else begin
    uvm_leaf_scope = full_name;
  end
endfunction
virtual class uvm_bit_vector_utils#(type T=int);
  static function string to_string(T value, int size,
                                   uvm_radix_enum radix=UVM_NORADIX,
                                   string radix_str="");
    if (radix == UVM_DEC && value[size-1] === 1) begin
      return $sformatf("%0d", value);
    end
    if($isunknown(value)) begin
      T _t;
      _t=0;
      for(int idx=0;idx<size;idx++) begin
        _t[idx]=value[idx];
      end
      value=_t;
    end
    else begin
      value &= (1 << size)-1;
    end
    case(radix)
      UVM_BIN:      begin
        return $sformatf("%0s%0b", radix_str, value);
      end
      UVM_OCT:      begin
        return $sformatf("%0s%0o", radix_str, value);
      end
      UVM_UNSIGNED: begin
        return $sformatf("%0s%0d", radix_str, value);
      end
      UVM_STRING:   begin
        return $sformatf("%0s%0s", radix_str, value);
      end
      UVM_TIME:     begin
        return $sformatf("%0s%0t", radix_str, value);
      end
      UVM_DEC:      begin
        return $sformatf("%0s%0d", radix_str, value);
      end
      default:      begin
        return $sformatf("%0s%0x", radix_str, value);
      end
    endcase
  endfunction : to_string
  static function int from_string(input string val_str, output T val);
    string base, extval, tmp;
    int    success ;
    bit    is_negative;
    if (val_str.len()  > 1) begin
      byte char;
      char = val_str.getc(0);
      if (char == "-") begin
        is_negative = 1;
        tmp = val_str.substr(1, val_str.len()-1);
      end
      else if (char == "+") begin
        tmp = val_str.substr(1, val_str.len()-1);
      end
      else begin
        tmp = val_str;
      end
    end
    else begin
      tmp = val_str;
    end
    if(tmp.len() > 2) begin
      base = tmp.substr(0,1);
      extval = tmp.substr(2,tmp.len()-1);
      case(base)
        "'b" : begin
          success= $sscanf(extval,"%b", val);
        end
        "0b" : begin
          success= $sscanf(extval,"%b", val);
        end
        "'o" : begin
          success= $sscanf(extval,"%o", val);
        end
        "'d" : begin
          success= $sscanf(extval,"%d", val);
        end
        "'h" : begin
          success= $sscanf(extval,"%x", val);
        end
        "'x" : begin
          success= $sscanf(extval,"%x", val);
        end
        "0x" : begin
          success= $sscanf(extval,"%x", val);
        end
        default : begin
          success = $sscanf(val_str,"%d", val);
        end
      endcase
    end
    else begin
      success = $sscanf(tmp,"%d", val);
    end
    if ((success == 1) && (is_negative)) begin
      val = -val;
    end
    return success;
  endfunction : from_string
endclass : uvm_bit_vector_utils
function string uvm_bitstream_to_string (uvm_bitstream_t value, int size,
                                         uvm_radix_enum radix=UVM_NORADIX,
                                         string radix_str="");
  return uvm_bit_vector_utils#(uvm_bitstream_t)::to_string(value,size,radix,radix_str);
endfunction
function string uvm_integral_to_string (uvm_integral_t value, int size,
                                         uvm_radix_enum radix=UVM_NORADIX,
                                         string radix_str="");
  return uvm_bit_vector_utils#(uvm_integral_t)::to_string(value, size, radix, radix_str);
endfunction
function int uvm_get_array_index_int(string arg, output bit is_wildcard);
  int i;
  int rt_val;
  uvm_get_array_index_int = 0;
  is_wildcard = 1;
  i = arg.len() - 1;
  if(arg[i] == "]") begin
    while(i > 0 && (arg[i] != "[")) begin
      --i;
      if((arg[i] == "*") || (arg[i] == "?")) begin
        i=0;
      end
      else if((arg[i] < "0") || (arg[i] > "9") && (arg[i] != "[")) begin
        uvm_get_array_index_int = -1;
        i=0;
      end
    end
  end
  else begin
    is_wildcard = 0;
    return 0;
  end
  if(i>0) begin
    arg = arg.substr(i+1, arg.len()-2);
    rt_val = $sscanf(arg, "%d" ,uvm_get_array_index_int );
    is_wildcard = 0;
  end
endfunction
function string uvm_get_array_index_string(string arg, output bit is_wildcard);
  int i;
  uvm_get_array_index_string = "";
  is_wildcard = 1;
  i = arg.len() - 1;
  if(arg[i] == "]") begin
    while(i > 0 && (arg[i] != "[")) begin
      if((arg[i] == "*") || (arg[i] == "?")) begin
        i=0;
      end
      --i;
    end
  end
  if(i>0) begin
    uvm_get_array_index_string = arg.substr(i+1, arg.len()-2);
    is_wildcard = 0;
  end
endfunction
function bit uvm_is_array(string arg);
  return arg[arg.len()-1] == "]";
endfunction
function automatic bit uvm_has_wildcard (string arg);
  uvm_has_wildcard = 0;
  if( (arg.len() > 1) && (arg[0] == "/") && (arg[arg.len()-1] == "/") ) begin
    return 1;
  end
  foreach(arg[i]) begin
    if( (arg[i] == "*") || (arg[i] == "+") || (arg[i] == "?") ) begin
      uvm_has_wildcard = 1;
    end
  end
endfunction
typedef class uvm_component;
typedef class uvm_root;
typedef class uvm_report_object;
class uvm_utils #(type TYPE=int, string FIELD="config");
  typedef TYPE types_t[$];
  static function types_t find_all(uvm_component start);
    uvm_component list[$];
    types_t types;
    uvm_root top;
    uvm_coreservice_t cs;
    cs = uvm_coreservice_t::get();
    top = cs.get_root();
    top.find_all("*",list,start);
    foreach (list[i]) begin
      TYPE typ;
      if ($cast(typ,list[i])) begin
        types.push_back(typ);
      end
    end
    if (types.size() == 0) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "find_type-no match") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "find_type-no match") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("find_type-no match", {"Instance of type '",TYPE::type_name, " not found in component hierarchy beginning at ",start.get_full_name()}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_misc.svh", 636, "", 1);
     end
   end
    end
    return types;
  endfunction
  static function TYPE find(uvm_component start);
    types_t types = find_all(start);
    if (types.size() == 0) begin
      return null;
    end
    if (types.size() > 1) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "find_type-multi match") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "find_type-multi match") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("find_type-multi match", {"More than one instance of type '",TYPE::type_name, " found in component hierarchy beginning at ",start.get_full_name()}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_misc.svh", 650, "", 1);
     end
   end
      return null;
    end
    return types[0];
  endfunction
  static function TYPE create_type_by_name(string type_name, string contxt);
    uvm_object obj;
    TYPE  typ;
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_factory factory=cs.get_factory();
    obj = factory.create_object_by_name(type_name,contxt,type_name);
       if (!$cast(typ,obj)) begin
         uvm_report_error("WRONG_TYPE",{"The type_name given '",type_name,
                "' with context '",contxt,"' did not produce the expected type."});
       end
    return typ;
  endfunction
  static function TYPE get_config(uvm_component comp, bit is_fatal);
    uvm_object obj;
    TYPE cfg;
    if (!m_uvm_config_obj_misc::get(comp,"",FIELD, obj)) begin
      if (is_fatal) begin
        comp.uvm_report_fatal("NO_SET_CFG", {"no set_config to field '", FIELD,
                           "' for component '",comp.get_full_name(),"'"},
                           UVM_MEDIUM, "t/uvm/src/base/uvm_misc.svh" , 689  );
      end
      else begin
        comp.uvm_report_warning("NO_SET_CFG", {"no set_config to field '", FIELD,
                           "' for component '",comp.get_full_name(),"'"},
                           UVM_MEDIUM, "t/uvm/src/base/uvm_misc.svh" , 696  );
      end
      return null;
    end
    if (!$cast(cfg, obj)) begin
      if (is_fatal) begin
        comp.uvm_report_fatal( "GET_CFG_TYPE_FAIL",
                          {"set_config_object with field name ",FIELD,
                          " is not of type '",TYPE::type_name,"'"},
                          UVM_NONE , "t/uvm/src/base/uvm_misc.svh" , 708 );
      end
      else begin
        comp.uvm_report_warning( "GET_CFG_TYPE_FAIL",
                          {"set_config_object with field name ",FIELD,
                          " is not of type '",TYPE::type_name,"'"},
                          UVM_NONE , "t/uvm/src/base/uvm_misc.svh" , 716 );
      end
    end
    return cfg;
  endfunction
endclass
function automatic string m_uvm_string_queue_join(ref string i[$]);
   m_uvm_string_queue_join = {>>{i}};
endfunction
typedef class uvm_factory;
typedef class uvm_default_factory;
typedef class uvm_report_server;
typedef class uvm_default_report_server;
typedef class uvm_root;
typedef class uvm_visitor;
typedef class uvm_component_name_check_visitor;
typedef class uvm_component;
typedef class uvm_comparer;
typedef class uvm_copier;
typedef class uvm_packer;
typedef class uvm_printer;
typedef class uvm_table_printer;
typedef class uvm_phase_hopper;
typedef class uvm_tr_database;
typedef class uvm_text_tr_database;
typedef class uvm_resource_pool;
typedef class uvm_resource_base;
typedef class uvm_default_coreservice_t;
virtual class uvm_coreservice_t extends uvm_void;
    pure virtual function uvm_factory get_factory();
    pure virtual function void set_factory(uvm_factory f);
    pure virtual function uvm_report_server get_report_server();
    pure virtual function void set_report_server(uvm_report_server server);
    pure virtual function uvm_tr_database get_default_tr_database();
    pure virtual function void set_default_tr_database(uvm_tr_database db);
    pure virtual function void set_component_visitor(uvm_visitor#(uvm_component) v);
    pure virtual function uvm_visitor#(uvm_component) get_component_visitor();
    pure virtual function uvm_root get_root();
    pure virtual function void set_phase_max_ready_to_end(int max);
    pure virtual function int get_phase_max_ready_to_end();
    pure virtual function void set_default_printer(uvm_printer printer);
    pure virtual function uvm_printer get_default_printer();
    pure virtual function void set_default_packer(uvm_packer packer);
    pure virtual function uvm_packer get_default_packer();
    pure virtual function void set_default_comparer(uvm_comparer comparer);
    pure virtual function uvm_comparer get_default_comparer();
    pure virtual function int unsigned get_global_seed();
    pure virtual function void set_default_copier(uvm_copier copier);
    pure virtual function uvm_copier get_default_copier();
        pure virtual function bit get_uvm_seeding();
        pure virtual function void set_uvm_seeding(bit enable);
    pure virtual function void set_resource_pool (uvm_resource_pool pool);
    pure virtual function uvm_resource_pool get_resource_pool();
    pure virtual function void set_resource_pool_default_precedence(int unsigned precedence);
    pure virtual function int unsigned get_resource_pool_default_precedence();
        pure virtual function uvm_phase_hopper get_phase_hopper();
    local static uvm_coreservice_t inst;
    static function uvm_coreservice_t get();
        if(inst==null) begin
          uvm_init(null);
        end
        return inst;
    endfunction
    static function void set(uvm_coreservice_t cs);
        inst=cs;
    endfunction
endclass
class uvm_default_coreservice_t extends uvm_coreservice_t;
    local uvm_factory factory;
    virtual function uvm_factory get_factory();
        if(factory==null) begin
          uvm_default_factory f;
          f=new;
          factory=f;
        end
        return factory;
    endfunction
    virtual function void set_factory(uvm_factory f);
        factory = f;
    endfunction
    local uvm_tr_database tr_database;
    virtual function uvm_tr_database get_default_tr_database();
        if (tr_database == null) begin
          process p = process::self();
          uvm_text_tr_database tx_db;
          string s;
          if(p != null) begin
            s = p.get_randstate();
          end
          tx_db = new("default_tr_database");
          tr_database = tx_db;
          if(p != null) begin
            p.set_randstate(s);
          end
        end
        return tr_database;
    endfunction : get_default_tr_database
    virtual function void set_default_tr_database(uvm_tr_database db);
        tr_database = db;
    endfunction : set_default_tr_database
    local uvm_report_server report_server;
    virtual function uvm_report_server get_report_server();
        if(report_server==null) begin
          uvm_default_report_server f;
          f=new;
          report_server=f;
        end
        return report_server;
    endfunction
    virtual function void set_report_server(uvm_report_server server);
        report_server=server;
    endfunction
    virtual function uvm_root get_root();
        return uvm_root::m_uvm_get_root();
    endfunction
    local uvm_visitor#(uvm_component) _visitor;
    virtual function void set_component_visitor(uvm_visitor#(uvm_component) v);
        _visitor=v;
    endfunction
    virtual function uvm_visitor#(uvm_component) get_component_visitor();
        if(_visitor==null) begin
          uvm_component_name_check_visitor v = new("name-check-visitor");
          _visitor=v;
        end
        return _visitor;
    endfunction
    virtual function void set_default_printer(uvm_printer printer);
        uvm_default_printer = printer ;
    endfunction
    virtual function uvm_printer get_default_printer();
        if (uvm_default_printer == null) begin
          uvm_default_printer =  uvm_table_printer::get_default() ;
        end
        return uvm_default_printer ;
    endfunction
    virtual function void set_default_packer(uvm_packer packer);
       uvm_default_packer = packer ;
    endfunction
    virtual function uvm_packer get_default_packer();
       if (uvm_default_packer == null) begin
         uvm_default_packer =  new("uvm_default_packer") ;
       end
       return uvm_default_packer ;
    endfunction
    virtual function void set_default_comparer(uvm_comparer comparer);
       uvm_default_comparer = comparer ;
    endfunction
    virtual function uvm_comparer get_default_comparer();
       if (uvm_default_comparer == null) begin
         uvm_default_comparer =  new("uvm_default_comparer") ;
       end
       return uvm_default_comparer ;
    endfunction
    local int m_default_max_ready_to_end_iters = 20;
    virtual function void set_phase_max_ready_to_end(int max);
        m_default_max_ready_to_end_iters = max;
    endfunction
    virtual function int get_phase_max_ready_to_end();
        return m_default_max_ready_to_end_iters;
    endfunction
    local uvm_resource_pool m_rp ;
    virtual function void set_resource_pool (uvm_resource_pool pool);
        m_rp = pool;
    endfunction
    virtual function uvm_resource_pool get_resource_pool();
        if(m_rp == null) begin
          m_rp = new();
        end
        return m_rp;
    endfunction
    virtual function void set_resource_pool_default_precedence(int unsigned precedence);
        uvm_resource_base::default_precedence = precedence;
    endfunction
    virtual function int unsigned get_resource_pool_default_precedence();
        return uvm_resource_base::default_precedence;
    endfunction
        local uvm_phase_hopper m_hopper;
        virtual function uvm_phase_hopper get_phase_hopper();
          if (m_hopper == null) begin
            m_hopper = uvm_phase_hopper::type_id::create("default_hopper");
          end
          return m_hopper;
        endfunction
    local int unsigned m_uvm_global_seed = $urandom;
    virtual function int unsigned get_global_seed();
        return m_uvm_global_seed;
    endfunction
   virtual function bit get_uvm_seeding();
      return uvm_object::use_uvm_seeding;
   endfunction : get_uvm_seeding
   virtual function void set_uvm_seeding(bit enable);
      uvm_object::use_uvm_seeding = enable;
   endfunction : set_uvm_seeding
    local uvm_copier m_copier ;
    virtual function void set_default_copier(uvm_copier copier);
        m_copier = copier ;
    endfunction
    virtual function uvm_copier get_default_copier();
        if (m_copier == null) begin
          m_copier =  new("uvm_default_copier") ;
        end
        return m_copier ;
    endfunction
endclass
typedef class uvm_root;
typedef class uvm_report_object;
typedef class uvm_report_message;
task run_test (string test_name="");
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.run_test(test_name);
endtask
function uvm_report_object uvm_get_report_object();
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  return top;
endfunction
function int uvm_report_enabled (int verbosity,
                                 uvm_severity severity=UVM_INFO, string id="");
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  return top.uvm_report_enabled(verbosity,severity,id);
endfunction
function void uvm_report( uvm_severity severity,
                          string id,
                          string message,
                          int verbosity = (severity == uvm_severity'(UVM_ERROR)) ? UVM_LOW :
                                          (severity == uvm_severity'(UVM_FATAL)) ? UVM_NONE : UVM_MEDIUM,
                          string filename = "",
                          int line = 0,
                          string context_name = "",
                          bit report_enabled_checked = 0);
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.uvm_report(severity, id, message, verbosity, filename, line, context_name, report_enabled_checked);
endfunction
export "DPI-C" function m__uvm_report_dpi;
function void m__uvm_report_dpi(int severity,
                                string id,
                                string message,
                                int    verbosity,
                                string filename,
                                int    line);
   uvm_report(uvm_severity'(severity), id, message, verbosity, filename, line);
endfunction : m__uvm_report_dpi
function void uvm_report_info(string id,
                  string message,
                              int verbosity = UVM_MEDIUM,
                  string filename = "",
                  int line = 0,
                              string context_name = "",
                              bit report_enabled_checked = 0);
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.uvm_report_info(id, message, verbosity, filename, line, context_name,
    report_enabled_checked);
endfunction
function void uvm_report_warning(string id,
                                 string message,
                                 int verbosity = UVM_MEDIUM,
                 string filename = "",
                 int line = 0,
                                 string context_name = "",
                                 bit report_enabled_checked = 0);
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.uvm_report_warning(id, message, verbosity, filename, line, context_name,
    report_enabled_checked);
endfunction
function void uvm_report_error(string id,
                               string message,
                               int verbosity = UVM_NONE,
                   string filename = "",
                   int line = 0,
                               string context_name = "",
                               bit report_enabled_checked = 0);
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.uvm_report_error(id, message, verbosity, filename, line, context_name,
    report_enabled_checked);
endfunction
function void uvm_report_fatal(string id,
                           string message,
                               int verbosity = UVM_NONE,
                   string filename = "",
                   int line = 0,
                               string context_name = "",
                               bit report_enabled_checked = 0);
  uvm_root top;
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.uvm_report_fatal(id, message, verbosity, filename, line, context_name,
    report_enabled_checked);
endfunction
function void uvm_process_report_message(uvm_report_message report_message);
  uvm_root top;
  uvm_coreservice_t cs;
  process p;
  p = process::self();
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  top.uvm_process_report_message(report_message);
endfunction
function bit uvm_string_to_severity (string sev_str, output uvm_severity sev);
  case (sev_str)
    "UVM_INFO": begin
      sev = UVM_INFO;
    end
    "UVM_WARNING": begin
      sev = UVM_WARNING;
    end
    "UVM_ERROR": begin
      sev = UVM_ERROR;
    end
    "UVM_FATAL": begin
      sev = UVM_FATAL;
    end
    default: begin
      return 0;
    end
  endcase
  return 1;
endfunction
function automatic bit uvm_string_to_action (string action_str, output uvm_action action);
  string actions[$];
  uvm_string_split(action_str,"|",actions);
  uvm_string_to_action = 1;
  action = 0;
  foreach(actions[i]) begin
    case (actions[i])
      "UVM_NO_ACTION": begin
        action |= UVM_NO_ACTION;
      end
      "UVM_DISPLAY":   begin
        action |= UVM_DISPLAY;
      end
      "UVM_LOG":       begin
        action |= UVM_LOG;
      end
      "UVM_COUNT":     begin
        action |= UVM_COUNT;
      end
      "UVM_EXIT":      begin
        action |= UVM_EXIT;
      end
      "UVM_CALL_HOOK": begin
        action |= UVM_CALL_HOOK;
      end
      "UVM_STOP":      begin
        action |= UVM_STOP;
      end
      "UVM_RM_RECORD": begin
        action |= UVM_RM_RECORD;
      end
      default: begin
        uvm_string_to_action = 0;
      end
    endcase
  end
endfunction
function automatic bit uvm_string_to_verbosity(string verb_str, output uvm_verbosity verb_enum);
    case (verb_str)
      "NONE"       : begin verb_enum = UVM_NONE;   return 1; end
      "UVM_NONE"   : begin verb_enum = UVM_NONE;   return 1; end
      "LOW"        : begin verb_enum = UVM_LOW;    return 1; end
      "UVM_LOW"    : begin verb_enum = UVM_LOW;    return 1; end
      "MEDIUM"     : begin verb_enum = UVM_MEDIUM; return 1; end
      "UVM_MEDIUM" : begin verb_enum = UVM_MEDIUM; return 1; end
      "HIGH"       : begin verb_enum = UVM_HIGH;   return 1; end
      "UVM_HIGH"   : begin verb_enum = UVM_HIGH;   return 1; end
      "FULL"       : begin verb_enum = UVM_FULL;   return 1; end
      "UVM_FULL"   : begin verb_enum = UVM_FULL;   return 1; end
      "DEBUG"      : begin verb_enum = UVM_DEBUG;  return 1; end
      "UVM_DEBUG"  : begin verb_enum = UVM_DEBUG;  return 1; end
      default      : begin                         return 0; end
    endcase
endfunction
function bit uvm_is_match (string expr, string str);
  return (uvm_re_match(.re(expr), .str(str), .deglob(1)) == 0);
endfunction
parameter UVM_LINE_WIDTH = 120;
parameter UVM_NUM_LINES = 120;
parameter UVM_SMALL_STRING = UVM_LINE_WIDTH*8-1;
parameter UVM_LARGE_STRING = UVM_LINE_WIDTH*UVM_NUM_LINES*8-1;
function logic[UVM_LARGE_STRING:0] uvm_string_to_bits(string str);
  $swrite(uvm_string_to_bits, "%0s", str);
endfunction
function uvm_core_state get_core_state();
   if (m_uvm_core_state.size() == 0) begin
     return UVM_CORE_UNINITIALIZED;
   end
   else begin
     return m_uvm_core_state[0];
   end
endfunction
function void uvm_init(uvm_coreservice_t cs=null);
  uvm_default_coreservice_t dcs;
  if(get_core_state()!=UVM_CORE_UNINITIALIZED) begin
    if (get_core_state() == UVM_CORE_PRE_INIT) begin
      dcs = new();
      uvm_coreservice_t::set(dcs);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "UVM/INIT/MULTI") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "UVM/INIT/MULTI") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("UVM/INIT/MULTI", "Non-recoverable race during uvm_init", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_globals.svh", 411, "", 1);
     end
   end
    end
    else begin
      uvm_coreservice_t actual;
      actual = uvm_coreservice_t::get();
      if ((cs != actual) && (cs != null)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/INIT/MULTI") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/INIT/MULTI") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/INIT/MULTI", "uvm_init() called after library has already completed initialization, subsequent calls are ignored!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_globals.svh", 420, "", 1);
     end
   end
      end
    end
    return;
  end
  m_uvm_core_state.push_front(UVM_CORE_PRE_INIT);
  if(cs == null) begin
    dcs = new();
    cs = dcs;
  end
  uvm_coreservice_t::set(cs);
  m_uvm_core_state.push_front(UVM_CORE_INITIALIZING);
  foreach(uvm_deferred_init[idx]) begin
    uvm_deferred_init[idx].initialize();
  end
  uvm_deferred_init.delete();
  begin
    uvm_root top;
    top = uvm_root::get();
    top.report_header();
    top.m_check_uvm_field_flag_size();
    top.m_check_verbosity();
  end
  m_uvm_core_state.push_front(UVM_CORE_INITIALIZED);
  uvm_default_table_printer = new();
  uvm_default_tree_printer = new();
  uvm_default_line_printer = new();
  uvm_default_printer = uvm_default_table_printer;
  uvm_default_packer = new();
  uvm_default_comparer = new();
endfunction
function string uvm_bits_to_string(logic [UVM_LARGE_STRING:0] str);
  $swrite(uvm_bits_to_string, "%0s", str);
endfunction
task uvm_wait_for_nba_region;
  static int nba;
  static int next_nba;
  next_nba++;
  nba <= next_nba;
  @(nba);
endtask
function automatic void uvm_split_string (string str, byte sep, ref string values[$]);
  int s = 0, e = 0;
  values.delete();
  while(e < str.len()) begin
    for(s=e; e<str.len(); ++e) begin
      if(str[e] == sep) begin
        break;
      end
    end
    if(s != e) begin
      values.push_back(str.substr(s,e-1));
    end
    e++;
  end
endfunction
function automatic void uvm_string_split (string str, byte sep, ref string values[$]);
  int s = 0, e = 0, limit;
  values.delete();
  limit = str.len() + 1;
  do begin
    for(s=e; e<str.len(); ++e) begin
      if(str[e] == sep) begin
        break;
      end
    end
    values.push_back(str.substr(s,e-1));
    e++;
  end
  while(e < limit);
endfunction
class uvm_enum_wrapper#(type T=uvm_active_passive_enum) extends uvm_void;
    protected static T map[string];
    static function bit from_name(string name, ref T value);
        if (map.size() == 0) begin
          m_init_map();
        end
        if (map.exists(name)) begin
          value = map[name];
          return 1;
        end
        else begin
          return 0;
        end
    endfunction : from_name
    protected static function void m_init_map();
        T e = e.first();
        do begin
          map[e.name()] = e;
          e = e.next();
        end
        while (e != e.first());
    endfunction : m_init_map
    protected function new();
    endfunction : new
endclass : uvm_enum_wrapper
class uvm_shared#(type T=int) extends uvm_void;
  T value;
endclass : uvm_shared
typedef class uvm_report_object;
typedef class uvm_object_wrapper;
typedef class uvm_objection;
typedef class uvm_component;
typedef class uvm_resource_base;
typedef class uvm_resource;
typedef class uvm_field_op;
virtual class uvm_object extends uvm_void;
  extern function new (string name="");
  static bit use_uvm_seeding = 1;
  extern static function bit get_uvm_seeding();
  extern static function void set_uvm_seeding(bit enable);
  extern function void reseed ();
  extern virtual function void set_name (string name);
  extern virtual function string get_name ();
  extern virtual function string get_full_name ();
  extern virtual function int get_inst_id ();
  extern static  function int get_inst_count();
  extern static function uvm_object_wrapper get_type ();
  extern virtual function uvm_object_wrapper get_object_type ();
  virtual function string get_type_name (); return "<unknown>"; endfunction
  virtual function uvm_object create (string name=""); return null; endfunction
  extern virtual function uvm_object clone ();
  extern function void print (uvm_printer printer=null);
  extern function string sprint (uvm_printer printer=null);
  extern virtual function void do_print (uvm_printer printer);
  extern virtual function string convert2string();
  extern function void record (uvm_recorder recorder=null);
  extern virtual function void do_record (uvm_recorder recorder);
  extern function void copy (uvm_object rhs, uvm_copier copier=null);
  extern virtual function void do_copy (uvm_object rhs);
  extern function bit compare (uvm_object rhs, uvm_comparer comparer=null);
  extern virtual function bit do_compare (uvm_object  rhs,
                                          uvm_comparer comparer);
  extern function int pack (ref bit bitstream[],
                            input uvm_packer packer=null);
  extern function int pack_bytes (ref byte unsigned bytestream[],
                                  input uvm_packer packer=null);
  extern function int pack_ints (ref int unsigned intstream[],
                                 input uvm_packer packer=null);
  extern function int pack_longints (ref longint unsigned longintstream[],
                                     input uvm_packer packer=null);
  extern virtual function void do_pack (uvm_packer packer);
  extern function int unpack (ref   bit        bitstream[],
                              input uvm_packer packer=null);
  extern function int unpack_bytes (ref byte unsigned bytestream[],
                                    input uvm_packer packer=null);
  extern function int unpack_ints (ref   int unsigned intstream[],
                                   input uvm_packer packer=null);
  extern function int unpack_longints (ref   longint unsigned longintstream[],
                                       input uvm_packer packer=null);
  extern virtual function void do_unpack (uvm_packer packer);
  extern virtual function void do_execute_op ( uvm_field_op op);
  extern virtual function void  set_local(uvm_resource_base rsrc) ;
  extern local function void m_pack        (inout uvm_packer packer);
  extern local function void m_unpack_pre  (inout uvm_packer packer);
  extern local function int m_unpack_post (uvm_packer packer);
  extern virtual function void m_unsupported_set_local(uvm_resource_base rsrc);
  local string m_leaf_name;
  local int m_inst_id;
  static protected int m_inst_count;
  extern virtual function void __m_uvm_field_automation (uvm_object tmp_data__,
                                                   uvm_field_flag_t what__,
                                                   string           str__);
  extern protected virtual function uvm_report_object m_get_report_object();
  extern virtual function void  set_int_local    (string      field_name,
                                                  uvm_bitstream_t value,
                                                  bit         recurse=1);
  extern virtual function void  set_string_local (string field_name,
                                                  string value,
                                                  bit    recurse=1);
  extern virtual function void  set_object_local (string      field_name,
                                                  uvm_object  value,
                                                  bit         clone=1,
                                                  bit         recurse=1);
endclass
function uvm_object::new (string name="");
  m_inst_id = m_inst_count++;
  m_leaf_name = name;
endfunction
function bit uvm_object::get_uvm_seeding();
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  return cs.get_uvm_seeding();
endfunction
function void uvm_object::set_uvm_seeding(bit enable);
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  cs.set_uvm_seeding(enable);
endfunction
function void uvm_object::reseed ();
  if(get_uvm_seeding()) begin
    this.srandom(uvm_create_random_seed(get_type_name(), get_full_name()));
  end
endfunction
function uvm_object_wrapper uvm_object::get_type();
  uvm_report_error("NOTYPID", "get_type not implemented in derived class.", UVM_NONE);
  return null;
endfunction
function int uvm_object::get_inst_id();
  return m_inst_id;
endfunction
function uvm_object_wrapper uvm_object::get_object_type();
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
  if(get_type_name() == "<unknown>") begin
    return null;
  end
  return factory.find_wrapper_by_name(get_type_name());
endfunction
function int uvm_object::get_inst_count();
  return m_inst_count;
endfunction
function string uvm_object::get_name ();
  return m_leaf_name;
endfunction
function string uvm_object::get_full_name ();
  return get_name();
endfunction
function void uvm_object::set_name (string name);
  m_leaf_name = name;
endfunction
function void uvm_object::print(uvm_printer printer=null);
  if (printer==null) begin
    printer = uvm_printer::get_default();
  end
  $fwrite(printer.get_file(),sprint(printer));
endfunction
function string uvm_object::sprint(uvm_printer printer=null);
  string name;
  if(printer==null) begin
    printer = uvm_printer::get_default();
  end
  if (printer.get_active_object_depth() == 0) begin
    printer.flush() ;
    name  = printer.get_root_enabled() ? get_full_name() : get_name();
  end
  else begin
    name  = get_name();
  end
  printer.print_object(name,this);
  return printer.emit();
endfunction
function string uvm_object::convert2string();
  return "";
endfunction
function void  uvm_object::set_local(uvm_resource_base rsrc) ;
  if(rsrc==null) begin
    return ;
  end
  else begin
    begin
      uvm_field_op op;
      op  = uvm_field_op::m_get_available_op();
      op.set(UVM_SET,null,rsrc);
      this.do_execute_op(op);
      op.m_recycle();
    end
  end
endfunction
function void uvm_object::m_unsupported_set_local(uvm_resource_base rsrc);
  return;
endfunction
function uvm_object uvm_object::clone();
  uvm_object tmp;
  tmp = this.create(get_name());
  if(tmp == null) begin
    uvm_report_warning("CRFLD", $sformatf("The create method failed for %s, object cannot be cloned", get_name()), UVM_NONE);
  end
  else begin
    tmp.copy(this);
  end
  return(tmp);
endfunction
function void uvm_object::copy (uvm_object rhs, uvm_copier copier=null);
uvm_coreservice_t coreservice ;
uvm_copier m_copier;
  if(rhs == null)  begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "OBJ/COPY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "OBJ/COPY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("OBJ/COPY", "Passing a null object to be copied", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_object.svh", 986, "", 1);
     end
   end
    return;
  end
  if(copier == null) begin
    coreservice = uvm_coreservice_t::get() ;
    m_copier = coreservice.get_default_copier() ;
  end
   else begin
     m_copier = copier;
   end
    if(m_copier.get_active_object_depth() == 0) begin
      m_copier.flush();
    end
  m_copier.copy_object(this,rhs);
endfunction
function void uvm_object::do_copy (uvm_object rhs);
  return;
endfunction
function bit  uvm_object::compare (uvm_object rhs,
                                   uvm_comparer comparer=null);
  if (comparer == null) begin
    comparer = uvm_comparer::get_default();
  end
  if (comparer.get_active_object_depth() == 0) begin
    comparer.flush() ;
  end
  compare = comparer.compare_object(get_name(),this,rhs);
endfunction
function bit  uvm_object::do_compare (uvm_object rhs,
                                      uvm_comparer comparer);
  return 1;
endfunction
function void uvm_object::__m_uvm_field_automation (uvm_object tmp_data__,
                                              uvm_field_flag_t what__,
                                              string           str__ );
  return;
endfunction
function void uvm_object::do_print(uvm_printer printer);
  return;
endfunction
function void uvm_object::m_pack (inout uvm_packer packer);
  if (packer == null) begin
    packer  = uvm_packer::get_default();
  end
  if(packer.get_active_object_depth() == 0) begin
    packer.flush();
  end
  packer.pack_object(this);
endfunction
function int uvm_object::pack (ref bit bitstream [],
                               input uvm_packer packer =null );
  m_pack(packer);
  packer.get_packed_bits(bitstream);
  return packer.get_packed_size();
endfunction
function int uvm_object::pack_bytes (ref byte unsigned bytestream [],
                                     input uvm_packer packer=null );
  m_pack(packer);
  packer.get_packed_bytes(bytestream);
  return packer.get_packed_size();
endfunction
function int uvm_object::pack_ints (ref int unsigned intstream [],
                                    input uvm_packer packer=null );
  m_pack(packer);
  packer.get_packed_ints(intstream);
  return packer.get_packed_size();
endfunction
function int uvm_object::pack_longints (ref longint unsigned longintstream [],
                                        input uvm_packer packer=null );
  m_pack(packer);
  packer.get_packed_longints(longintstream);
  return packer.get_packed_size();
endfunction
function void uvm_object::do_pack (uvm_packer packer );
  if (packer == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/OBJ/PACK/NULL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/OBJ/PACK/NULL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/OBJ/PACK/NULL", "uvm_object::do_pack called with null packer!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_object.svh", 1131, "", 1);
     end
   end
  end
  return;
endfunction
function void uvm_object::m_unpack_pre (inout uvm_packer packer);
  if (packer == null) begin
    packer  = uvm_packer::get_default();
  end
  if(packer.get_active_object_depth() == 0) begin
    packer.flush();
  end
endfunction
function int uvm_object::m_unpack_post (uvm_packer packer);
  int size_before_unpack = packer.get_packed_size();
  packer.unpack_object(this);
  return size_before_unpack - packer.get_packed_size();
endfunction
function int uvm_object::unpack (ref    bit        bitstream [],
                                 input  uvm_packer packer=null);
  m_unpack_pre(packer);
  packer.set_packed_bits(bitstream);
  return m_unpack_post(packer);
endfunction
function int uvm_object::unpack_bytes (ref    byte unsigned bytestream [],
                                       input  uvm_packer packer=null);
  m_unpack_pre(packer);
  packer.set_packed_bytes(bytestream);
  return m_unpack_post(packer);
endfunction
function int uvm_object::unpack_ints (ref    int unsigned intstream [],
                                      input  uvm_packer packer=null);
  m_unpack_pre(packer);
  packer.set_packed_ints(intstream);
  return m_unpack_post(packer);
endfunction
function int uvm_object::unpack_longints (ref    longint unsigned longintstream [],
                                          input  uvm_packer packer=null);
  m_unpack_pre(packer);
  packer.set_packed_longints(longintstream);
  return m_unpack_post(packer);
endfunction
function void uvm_object::do_execute_op ( uvm_field_op op);
endfunction
function void uvm_object::do_unpack (uvm_packer packer);
  if (packer == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/OBJ/UNPACK/NULL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/OBJ/UNPACK/NULL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/OBJ/UNPACK/NULL", "uvm_object::do_unpack called with null packer!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_object.svh", 1218, "", 1);
     end
   end
  end
  return;
endfunction
function void uvm_object::record (uvm_recorder recorder=null);
  if(recorder == null) begin
    return;
  end
  recorder.record_object(get_name(), this);
endfunction
function void uvm_object::do_record (uvm_recorder recorder);
  return;
endfunction
function uvm_report_object uvm_object::m_get_report_object();
  return null;
endfunction
uvm_resource_base m_set_local_rsrc;
function void  uvm_object::set_int_local (string      field_name,
                                          uvm_bitstream_t value,
                                          bit         recurse=1);
  uvm_field_op field_op = uvm_field_op::m_get_available_op();
  uvm_resource_base rsrc_base  = m_set_local_rsrc;
  if (rsrc_base == null) begin
    uvm_resource#(uvm_bitstream_t) rsrc = new(field_name);
    rsrc.write(value);
    rsrc_base = rsrc;
  end
  field_op.set(UVM_SET, null, rsrc_base);
  do_execute_op(field_op);
  field_op.m_recycle();
  m_set_local_rsrc = null;
endfunction
function void  uvm_object::set_object_local (string     field_name,
                                             uvm_object value,
                                             bit        clone=1,
                                             bit        recurse=1);
  uvm_field_op field_op = uvm_field_op::m_get_available_op();
  uvm_resource_base rsrc_base  = m_set_local_rsrc;
  if (rsrc_base == null) begin
    uvm_resource#(uvm_object) rsrc  = new(field_name);
    if (clone && (value != null)) begin
      uvm_object cc  = value.clone();
      if (cc != null) begin
        cc.set_name(field_name);
      end
      rsrc.write(cc);
    end
    else begin
      rsrc.write(value);
    end
    rsrc_base = rsrc;
  end
  field_op.set(UVM_SET, null, rsrc_base);
  do_execute_op(field_op);
  field_op.m_recycle();
  m_set_local_rsrc = null;
endfunction
function void  uvm_object::set_string_local (string field_name,
                                             string value,
                                             bit    recurse=1);
  uvm_field_op field_op = uvm_field_op::m_get_available_op();
  uvm_resource_base rsrc_base  = m_set_local_rsrc;
  if (rsrc_base == null) begin
    uvm_resource#(string) rsrc = new(field_name);
    rsrc.write(value);
    rsrc_base = rsrc;
  end
  field_op.set(UVM_SET, null, rsrc_base);
  do_execute_op(field_op);
  field_op.m_recycle();
  m_set_local_rsrc = null;
endfunction
typedef class uvm_object;
typedef class uvm_component;
typedef class uvm_object_wrapper;
typedef class uvm_factory_override;
typedef struct {uvm_object_wrapper m_type;
                string             m_type_name;} m_uvm_factory_type_pair_t;
class uvm_factory_queue_class;
  uvm_factory_override queue[$];
endclass
virtual class uvm_factory extends uvm_void;
  static function uvm_factory get();
          uvm_coreservice_t s;
          s = uvm_coreservice_t::get();
          return s.get_factory();
  endfunction
  static function void set(uvm_factory f);
          uvm_coreservice_t s;
          s = uvm_coreservice_t::get();
          s.set_factory(f);
  endfunction
  pure virtual function void register (uvm_object_wrapper obj);
  pure virtual function
      void set_inst_override_by_type (uvm_object_wrapper original_type,
                                      uvm_object_wrapper override_type,
                                      string full_inst_path);
  pure virtual function
      void set_inst_override_by_name (string original_type_name,
                                      string override_type_name,
                                      string full_inst_path);
  pure virtual function
      void set_type_override_by_type (uvm_object_wrapper original_type,
                                      uvm_object_wrapper override_type,
                                      bit replace=1);
  pure virtual function
      void set_type_override_by_name (string original_type_name,
                                      string override_type_name,
                                      bit replace=1);
  pure virtual function
      uvm_object    create_object_by_type    (uvm_object_wrapper requested_type,
                                              string parent_inst_path="",
                                              string name="");
  pure virtual function
      uvm_component create_component_by_type (uvm_object_wrapper requested_type,
                                              string parent_inst_path="",
                                              string name,
                                              uvm_component parent);
  pure virtual function
      uvm_object    create_object_by_name    (string requested_type_name,
                                              string parent_inst_path="",
                                              string name="");
     pure virtual
        function bit is_type_name_registered  (string type_name);
     pure virtual
        function bit is_type_registered     (uvm_object_wrapper obj);
  pure virtual function
      uvm_component create_component_by_name (string requested_type_name,
                                              string parent_inst_path="",
                                              string name,
                                              uvm_component parent);
  pure virtual function
      void set_type_alias(string alias_type_name,
                          uvm_object_wrapper original_type);
  pure virtual function
      void set_inst_alias(string alias_type_name,
                          uvm_object_wrapper original_type, string full_inst_path);
  pure virtual function
      void debug_create_by_type (uvm_object_wrapper requested_type,
                                 string parent_inst_path="",
                                 string name="");
  pure virtual function
      void debug_create_by_name (string requested_type_name,
                                 string parent_inst_path="",
                                 string name="");
  pure virtual function
      uvm_object_wrapper find_override_by_type (uvm_object_wrapper requested_type,
                                                string full_inst_path);
  pure virtual function
      uvm_object_wrapper find_override_by_name (string requested_type_name,
                                                string full_inst_path);
  pure virtual
    function uvm_object_wrapper find_wrapper_by_name            (string type_name);
  pure  virtual function void print (int all_types=1);
endclass
class uvm_default_factory extends uvm_factory;
  extern virtual function void register (uvm_object_wrapper obj);
  extern virtual function
      void set_inst_override_by_type (uvm_object_wrapper original_type,
                                      uvm_object_wrapper override_type,
                                      string full_inst_path);
  extern virtual function
      void set_inst_override_by_name (string original_type_name,
                                      string override_type_name,
                                      string full_inst_path);
  extern virtual function
      void set_type_override_by_type (uvm_object_wrapper original_type,
                                      uvm_object_wrapper override_type,
                                      bit replace=1);
  extern virtual function
      void set_type_override_by_name (string original_type_name,
                                      string override_type_name,
                                      bit replace=1);
  extern virtual function
      void set_type_alias(string alias_type_name,
                          uvm_object_wrapper original_type);
  extern virtual function
      void set_inst_alias(string alias_type_name,
                          uvm_object_wrapper original_type, string full_inst_path);
  extern virtual function
      uvm_object    create_object_by_type    (uvm_object_wrapper requested_type,
                                              string parent_inst_path="",
                                              string name="");
  extern virtual function
      uvm_component create_component_by_type (uvm_object_wrapper requested_type,
                                              string parent_inst_path="",
                                              string name,
                                              uvm_component parent);
  extern virtual function
      uvm_object    create_object_by_name    (string requested_type_name,
                                              string parent_inst_path="",
                                              string name="");
  extern virtual function
      uvm_component create_component_by_name (string requested_type_name,
                                              string parent_inst_path="",
                                              string name,
                                              uvm_component parent);
  extern virtual
      function bit is_type_name_registered    (string type_name);
  extern virtual
      function bit is_type_registered    (uvm_object_wrapper obj);
  extern virtual function
      void debug_create_by_type (uvm_object_wrapper requested_type,
                                 string parent_inst_path="",
                                 string name="");
  extern virtual function
      void debug_create_by_name (string requested_type_name,
                                 string parent_inst_path="",
                                 string name="");
  extern virtual function
      uvm_object_wrapper find_override_by_type (uvm_object_wrapper requested_type,
                                                string full_inst_path);
  extern function
      uvm_object_wrapper m_find_override_by_type (uvm_object_wrapper requested_type,
                                                string full_inst_path, ref uvm_factory_override override_info[$]);
  extern virtual function
      uvm_object_wrapper find_override_by_name (string requested_type_name,
                                                string full_inst_path);
  extern virtual
    function uvm_object_wrapper find_wrapper_by_name            (string type_name);
  extern  virtual function void print (int all_types=1);
  extern protected
      function void  m_debug_create (string requested_type_name,
                                     uvm_object_wrapper requested_type,
                                     string parent_inst_path,
                                     string name);
  extern protected
      function void  m_debug_display(string requested_type_name,
                                     uvm_object_wrapper result,
                                     string full_inst_path);
  extern
      function uvm_object_wrapper m_resolve_type_name(string requested_type_name);
  extern
      function uvm_object_wrapper m_resolve_type_name_by_inst(string requested_type_name,
                                                              string full_inst_path);
  extern
      function bit m_matches_type_pair(m_uvm_factory_type_pair_t match_type_pair,
                                       uvm_object_wrapper requested_type,
                                       string requested_type_name);
  extern
      function bit m_matches_type_override(uvm_factory_override override,
                                           uvm_object_wrapper requested_type,
                                           string requested_type_name,
                                           string full_inst_path="",
                                           bit match_original_type = 1,
                                           bit resolve_null_type_by_inst=0);
  extern
      function bit m_matches_inst_override(uvm_factory_override override,
                                           uvm_object_wrapper requested_type,
                                           string requested_type_name,
                                           string full_inst_path="");
  typedef struct  {
    m_uvm_factory_type_pair_t orig;
    string alias_type_name;
    string full_inst_path;
  } m_inst_typename_alias_t;
  protected bit                      m_types[uvm_object_wrapper];
  protected bit                      m_lookup_strs[string];
  protected uvm_object_wrapper       m_type_names[string];
  protected m_inst_typename_alias_t  m_inst_aliases[$];
  protected uvm_factory_override m_type_overrides[$];
  protected uvm_factory_override m_inst_overrides[$];
  local uvm_factory_override     m_override_info[$];
  local static bit m_debug_pass;
  extern function bit check_inst_override_exists
                                      (uvm_object_wrapper original_type,
                                       string original_type_name,
                                       uvm_object_wrapper override_type,
                                       string override_type_name,
                                       string full_inst_path);
endclass
virtual class uvm_object_wrapper extends uvm_void;
  virtual function uvm_object create_object (string name="");
    return null;
  endfunction
  virtual function uvm_component create_component (string name,
                                                   uvm_component parent);
    return null;
  endfunction
  pure virtual function string get_type_name();
  virtual function void initialize(); endfunction
endclass
class uvm_factory_override;
  string full_inst_path;
  m_uvm_factory_type_pair_t orig;
  m_uvm_factory_type_pair_t ovrd;
  bit replace;
  bit selected;
  int unsigned used;
  bit has_wildcard;
  function new (string full_inst_path="",
                string orig_type_name="",
                uvm_object_wrapper orig_type=null,
                uvm_object_wrapper ovrd_type,
                string ovrd_type_name="",
                bit replace=0);
    this.full_inst_path= full_inst_path;
    this.orig.m_type_name = orig_type_name;
    this.orig.m_type      = orig_type;
    this.ovrd.m_type_name = ovrd_type_name;
    this.ovrd.m_type      = ovrd_type;
    this.replace          = replace;
    this.has_wildcard     = m_has_wildcard(full_inst_path);
  endfunction
  function bit m_has_wildcard(string nm);
    foreach (nm[i]) begin
      if(nm[i] == "*" || nm[i] == "?") begin
        return 1;
      end
    end
    return 0;
  endfunction
endclass
function void uvm_default_factory::register (uvm_object_wrapper obj);
  if (obj == null) begin
    uvm_report_fatal ("NULLWR", "Attempting to register a null object with the factory", UVM_NONE);
  end
  if (obj.get_type_name() != "" && obj.get_type_name() != "<unknown>") begin
    if (m_type_names.exists(obj.get_type_name())) begin
      uvm_report_warning("TPRGED", {"Type name '",obj.get_type_name(),
        "' already registered with factory. No string-based lookup ",
        "support for multiple types with the same type name."}, UVM_NONE);
    end
    else begin
      m_type_names[obj.get_type_name()] = obj;
    end
  end
  if (m_types.exists(obj)) begin
    if (obj.get_type_name() != "" && obj.get_type_name() != "<unknown>") begin
      uvm_report_warning("TPRGED", {"Object type '",obj.get_type_name(),
                         "' already registered with factory. "}, UVM_NONE);
    end
  end
  else begin
    uvm_factory_override overrides[$];
    m_types[obj] = 1;
    overrides = {m_type_overrides, m_inst_overrides};
    foreach (overrides[index]) begin
      if(m_matches_type_pair(.match_type_pair(overrides[index].orig),
      .requested_type(null),
      .requested_type_name(obj.get_type_name()))) begin
        overrides[index].orig.m_type = obj;
      end
      if(m_matches_type_pair(.match_type_pair(overrides[index].ovrd),
      .requested_type(null),
      .requested_type_name(obj.get_type_name()))) begin
        overrides[index].ovrd.m_type = obj;
      end
    end
  end
endfunction
function void uvm_default_factory::set_type_override_by_type (uvm_object_wrapper original_type,
                                                      uvm_object_wrapper override_type,
                                                      bit replace=1);
  bit replaced;
  if (original_type == override_type) begin
    if (original_type.get_type_name() == "" || original_type.get_type_name() == "<unknown>") begin
      uvm_report_warning("TYPDUP", {"Original and override type ",
                                    "arguments are identical"}, UVM_NONE);
    end
    else begin
      uvm_report_warning("TYPDUP", {"Original and override type ",
                                    "arguments are identical: ",
                                    original_type.get_type_name()}, UVM_NONE);
    end
  end
  if (!m_types.exists(original_type)) begin
    register(original_type);
  end
  if (!m_types.exists(override_type)) begin
    register(override_type);
  end
  foreach (m_type_overrides[index]) begin
    if(m_matches_type_override(.override(m_type_overrides[index]),
    .requested_type(original_type),
    .requested_type_name(original_type.get_type_name()))) begin
      string msg;
      msg = {"Original object type '",original_type.get_type_name(),
             "' already registered to produce '",
             m_type_overrides[index].ovrd.m_type_name,"'"};
      if (!replace) begin
        msg = {msg, ".  Set 'replace' argument to replace the existing entry."};
        uvm_report_info("TPREGD", msg, UVM_MEDIUM);
        return;
      end
      msg = {msg, ".  Replacing with override to produce type '",
                  override_type.get_type_name(),"'."};
      uvm_report_info("TPREGR", msg, UVM_MEDIUM);
      replaced = 1;
      m_type_overrides[index].orig.m_type = original_type;
      m_type_overrides[index].orig.m_type_name = original_type.get_type_name();
      m_type_overrides[index].ovrd.m_type = override_type;
      m_type_overrides[index].ovrd.m_type_name = override_type.get_type_name();
      m_type_overrides[index].replace = replace;
    end
    else if (m_type_overrides[index].orig.m_type == null) begin
      break;
    end
  end
  if (!replaced) begin
    uvm_factory_override override;
    override = new(.orig_type(original_type),
                   .orig_type_name(original_type.get_type_name()),
                   .ovrd_type(override_type),
                   .ovrd_type_name(override_type.get_type_name()),
                   .replace(replace));
    m_type_overrides.push_front(override);
  end
endfunction
function void uvm_default_factory::set_type_override_by_name (string original_type_name,
                                                      string override_type_name,
                                                      bit replace=1);
  bit replaced;
  uvm_object_wrapper original_type;
  uvm_object_wrapper override_type;
  if(m_type_names.exists(original_type_name)) begin
    original_type = m_type_names[original_type_name];
  end
  if(m_type_names.exists(override_type_name)) begin
    override_type = m_type_names[override_type_name];
  end
  if (original_type_name == override_type_name) begin
    uvm_report_warning("TYPDUP", {"Requested and actual type name ",
      " arguments are identical: ",original_type_name,". Ignoring this override."}, UVM_NONE);
    return;
  end
  foreach (m_type_overrides[index]) begin
    if(m_matches_type_override(.override(m_type_overrides[index]),
    .requested_type(original_type),
    .requested_type_name(original_type_name))) begin
      if (!replace) begin
        uvm_report_info("TPREGD", {"Original type '",original_type_name, "'/'",m_type_overrides[index].orig.m_type_name,
          "' already registered to produce '",m_type_overrides[index].ovrd.m_type_name,
          "'.  Set 'replace' argument to replace the existing entry."}, UVM_MEDIUM);
        return;
      end
      uvm_report_info("TPREGR", {"Original object type '",original_type_name, "'/'",m_type_overrides[index].orig.m_type_name,
        "' already registered to produce '",m_type_overrides[index].ovrd.m_type_name,
        "'.  Replacing with override to produce type '",override_type_name,"'."}, UVM_MEDIUM);
      replaced = 1;
      m_type_overrides[index].ovrd.m_type = override_type;
      m_type_overrides[index].ovrd.m_type_name = override_type_name;
      m_type_overrides[index].replace = replace;
    end
    else if ((m_type_overrides[index].orig.m_type == null) || (original_type == null)) begin
      break;
    end
  end
  if (original_type == null) begin
    m_lookup_strs[original_type_name] = 1;
  end
  if (!replaced) begin
    uvm_factory_override override;
    override = new(.orig_type(original_type),
                   .orig_type_name(original_type_name),
                   .ovrd_type(override_type),
                   .ovrd_type_name(override_type_name),
                   .replace(replace)
                   );
    m_type_overrides.push_front(override);
  end
endfunction
function bit uvm_default_factory::check_inst_override_exists (uvm_object_wrapper original_type,
                                      string original_type_name,
                                      uvm_object_wrapper override_type,
                                      string override_type_name,
                                      string full_inst_path);
  uvm_factory_override override;
  foreach (m_inst_overrides[i]) begin
    override = m_inst_overrides[i];
    if (override.full_inst_path == full_inst_path &&
    override.orig.m_type == original_type &&
    override.orig.m_type_name == original_type_name &&
    override.ovrd.m_type == override_type &&
    override.ovrd.m_type_name == override_type_name) begin
      uvm_report_info("DUPOVRD",{"Instance override for '",
       original_type_name,"' already exists: override type '",
       override_type_name,"' with full_inst_path '",
       full_inst_path,"'"},UVM_HIGH);
      return 1;
    end
  end
  return 0;
endfunction
function void uvm_default_factory::set_inst_override_by_type (uvm_object_wrapper original_type,
                                                      uvm_object_wrapper override_type,
                                                      string full_inst_path);
  uvm_factory_override override;
  if (!m_types.exists(original_type)) begin
    register(original_type);
  end
  if (!m_types.exists(override_type)) begin
    register(override_type);
  end
  if (check_inst_override_exists(original_type,
                                 original_type.get_type_name(),
                                 override_type,
                                 override_type.get_type_name(),
                                 full_inst_path)) begin
    return;
  end
  override = new(.full_inst_path(full_inst_path),
                 .orig_type(original_type),
                 .orig_type_name(original_type.get_type_name()),
                 .ovrd_type(override_type),
                 .ovrd_type_name(override_type.get_type_name()));
  m_inst_overrides.push_back(override);
endfunction
function void uvm_default_factory::set_inst_override_by_name (string original_type_name,
                                                      string override_type_name,
                                                      string full_inst_path);
  uvm_factory_override override;
  uvm_object_wrapper original_type;
  uvm_object_wrapper override_type;
  if(m_type_names.exists(original_type_name)) begin
    original_type = m_type_names[original_type_name];
  end
  if(m_type_names.exists(override_type_name)) begin
    override_type = m_type_names[override_type_name];
  end
  if (original_type == null) begin
    m_lookup_strs[original_type_name] = 1;
  end
  override = new(.full_inst_path(full_inst_path),
                 .orig_type(original_type),
                 .orig_type_name(original_type_name),
                 .ovrd_type(override_type),
                 .ovrd_type_name(override_type_name));
  if (check_inst_override_exists(original_type,
                                 original_type_name,
                                 override_type,
                                 override_type_name,
                                 full_inst_path)) begin
    return;
  end
  m_inst_overrides.push_back(override);
endfunction
function void uvm_default_factory::set_type_alias(string alias_type_name,
                          uvm_object_wrapper original_type);
    if (!is_type_registered(original_type)) begin
      uvm_report_warning("BDTYP",{"Cannot define alias of type '",
       original_type.get_type_name(),"' because it is not registered with the factory."}, UVM_NONE);
    end
    else begin
      if (!m_type_names.exists(alias_type_name)) begin
        uvm_factory_override overrides[$];
        m_type_names[alias_type_name] = original_type;
        overrides = {m_type_overrides, m_inst_overrides};
        foreach (overrides[index]) begin
          if(m_matches_type_pair(.match_type_pair(overrides[index].orig),
          .requested_type(null),
          .requested_type_name(alias_type_name))) begin
            overrides[index].orig.m_type = original_type;
          end
          if(m_matches_type_pair(.match_type_pair(overrides[index].ovrd),
          .requested_type(null),
          .requested_type_name(alias_type_name))) begin
            overrides[index].ovrd.m_type = original_type;
          end
        end
      end
    end
endfunction
function void uvm_default_factory::set_inst_alias(string alias_type_name,
                          uvm_object_wrapper original_type, string full_inst_path);
    string original_type_name;
    m_inst_typename_alias_t  orig_type_alias_per_inst;
    original_type_name = original_type.get_type_name();
    if (!is_type_registered(original_type)) begin
      uvm_report_warning("BDTYP",{"Cannot define alias of type '",
       original_type_name,"' because it is not registered with the factory."}, UVM_NONE);
    end
    else begin
      orig_type_alias_per_inst.alias_type_name = alias_type_name;
      orig_type_alias_per_inst.full_inst_path = full_inst_path;
      orig_type_alias_per_inst.orig.m_type_name = original_type_name;
      orig_type_alias_per_inst.orig.m_type = original_type;
      m_inst_aliases.push_back(orig_type_alias_per_inst);
    end
endfunction
function uvm_object uvm_default_factory::create_object_by_name (string requested_type_name,
                                                        string parent_inst_path="",
                                                        string name="");
  uvm_object_wrapper wrapper;
  string inst_path;
  if (parent_inst_path == "") begin
    inst_path = name;
  end
  else if (name != "") begin
    inst_path = {parent_inst_path,".",name};
  end
  else begin
    inst_path = parent_inst_path;
  end
  m_override_info.delete();
  wrapper = find_override_by_name(requested_type_name, inst_path);
  if (wrapper==null) begin
    wrapper = m_resolve_type_name_by_inst(requested_type_name,inst_path);
    if(wrapper == null) begin
      uvm_report_warning("BDTYP",{"Cannot create an object of type '",
      requested_type_name,"' because it is not registered with the factory."}, UVM_NONE);
      return null;
    end
  end
  return wrapper.create_object(name);
endfunction
function uvm_object uvm_default_factory::create_object_by_type (uvm_object_wrapper requested_type,
                                                        string parent_inst_path="",
                                                        string name="");
  string full_inst_path;
  if (parent_inst_path == "") begin
    full_inst_path = name;
  end
  else if (name != "") begin
    full_inst_path = {parent_inst_path,".",name};
  end
  else begin
    full_inst_path = parent_inst_path;
  end
  requested_type = find_override_by_type(requested_type, full_inst_path);
  return requested_type.create_object(name);
endfunction
function bit uvm_default_factory::is_type_name_registered (string type_name);
  return (m_type_names.exists(type_name));
endfunction
function bit uvm_default_factory::is_type_registered (uvm_object_wrapper obj);
  return (m_types.exists(obj));
endfunction
function uvm_component uvm_default_factory::create_component_by_name (string requested_type_name,
                                                              string parent_inst_path="",
                                                              string name,
                                                              uvm_component parent);
  uvm_object_wrapper wrapper;
  string inst_path;
  if (parent_inst_path == "") begin
    inst_path = name;
  end
  else if (name != "") begin
    inst_path = {parent_inst_path,".",name};
  end
  else begin
    inst_path = parent_inst_path;
  end
  m_override_info.delete();
  wrapper = find_override_by_name(requested_type_name, inst_path);
  if (wrapper == null) begin
    if(!m_type_names.exists(requested_type_name)) begin
      uvm_report_warning("BDTYP",{"Cannot create a component of type '",
      requested_type_name,"' because it is not registered with the factory."}, UVM_NONE);
      return null;
    end
    wrapper = m_type_names[requested_type_name];
  end
  return wrapper.create_component(name, parent);
endfunction
function uvm_component uvm_default_factory::create_component_by_type (uvm_object_wrapper requested_type,
                                                            string parent_inst_path="",
                                                            string name,
                                                            uvm_component parent);
  string full_inst_path;
  if (parent_inst_path == "") begin
    full_inst_path = name;
  end
  else if (name != "") begin
    full_inst_path = {parent_inst_path,".",name};
  end
  else begin
    full_inst_path = parent_inst_path;
  end
  requested_type = find_override_by_type(requested_type, full_inst_path);
  return requested_type.create_component(name, parent);
endfunction
function uvm_object_wrapper uvm_default_factory::find_wrapper_by_name(string type_name);
  uvm_object_wrapper wrapper = m_resolve_type_name(type_name);
  if (wrapper != null) begin
    return wrapper;
  end
  uvm_report_warning("UnknownTypeName", {"find_wrapper_by_name: Type name '",type_name,
      "' not registered with the factory."}, UVM_NONE);
endfunction
function uvm_object_wrapper uvm_default_factory::find_override_by_name (string requested_type_name,
                                                                string full_inst_path);
  uvm_object_wrapper rtype;
  uvm_factory_override lindex;
  rtype = m_resolve_type_name_by_inst(requested_type_name,full_inst_path);
  if(full_inst_path != "") begin
    foreach(m_inst_overrides[i]) begin
      if(m_matches_inst_override(.override(m_inst_overrides[i]),
      .requested_type(rtype),
      .requested_type_name(requested_type_name),
      .full_inst_path(full_inst_path))) begin
        m_override_info.push_back(m_inst_overrides[i]);
        if (lindex == null) begin
          lindex = m_inst_overrides[i];
          if (!m_debug_pass) begin
            break;
          end
        end
      end
    end
  end
  if ((lindex == null) || m_debug_pass) begin
    uvm_factory_override matched_overrides[$];
    foreach (m_type_overrides[index]) begin
      if(m_matches_type_override(.override(m_type_overrides[index]),
      .requested_type(rtype),
      .requested_type_name(requested_type_name),
      .full_inst_path(full_inst_path),
      .resolve_null_type_by_inst(1))) begin
        matched_overrides.push_back(m_type_overrides[index]);
        if ((lindex == null) || (lindex.replace == 0)) begin
          lindex = m_type_overrides[index];
          if (!m_debug_pass && lindex.replace) begin
            break;
          end
        end
      end
    end
    if(matched_overrides.size() != 0) begin
      if (m_debug_pass) begin
        m_override_info = {m_override_info,matched_overrides};
      end
      else begin
        m_override_info.push_back(matched_overrides[$]);
      end
    end
  end
  if (lindex != null) begin
    uvm_object_wrapper override = lindex.ovrd.m_type;
    lindex.used++;
    if (m_debug_pass) begin
      lindex.selected = 1;
    end
    if(!m_matches_type_override(.override(lindex),
    .requested_type(rtype),
    .requested_type_name(requested_type_name),
    .full_inst_path(full_inst_path),
    .match_original_type(0),
    .resolve_null_type_by_inst(1))) begin
      if(override == null) begin
        override = find_override_by_name(lindex.ovrd.m_type_name,full_inst_path);
      end
      else begin
        override = find_override_by_type(override,full_inst_path);
      end
    end
    else if(override == null) begin
      override = m_resolve_type_name_by_inst(lindex.ovrd.m_type_name,full_inst_path);
    end
    if(override == null) begin
      uvm_report_error("TYPNTF", {"Cannot resolve override for original type '",
        lindex.orig.m_type_name,"' because the override type '",
        lindex.ovrd.m_type_name, "' is not registered with the factory."}, UVM_NONE);
    end
    return override;
  end
  return null;
endfunction
function uvm_object_wrapper uvm_default_factory::find_override_by_type(uvm_object_wrapper requested_type,
                                                               string full_inst_path);
   uvm_factory_override override_info[$];
   return m_find_override_by_type(requested_type, full_inst_path, override_info);
endfunction
function uvm_object_wrapper uvm_default_factory::m_find_override_by_type(uvm_object_wrapper requested_type,
                                                               string full_inst_path, ref uvm_factory_override override_info[$]);
  uvm_object_wrapper override;
  uvm_factory_override lindex;
  uvm_factory_queue_class qc;
  foreach (override_info[index]) begin
    if (
    override_info[index].orig.m_type == requested_type) begin
      uvm_report_error("OVRDLOOP", "Recursive loop detected while finding override.", UVM_NONE);
      override_info[index].used++;
      if (!m_debug_pass) begin
        debug_create_by_type (requested_type, full_inst_path);
      end
      return requested_type;
    end
  end
  if(full_inst_path != "") begin
    foreach(m_inst_overrides[i]) begin
      if(m_matches_inst_override(.override(m_inst_overrides[i]),
      .requested_type(requested_type),
      .requested_type_name(requested_type.get_type_name()),
      .full_inst_path(full_inst_path))) begin
        override_info.push_back(m_inst_overrides[i]);
        if (lindex == null) begin
          lindex = m_inst_overrides[i];
          if (!m_debug_pass) begin
            break;
          end
        end
      end
    end
  end
  if ((lindex == null) || m_debug_pass) begin
    uvm_factory_override matched_overrides[$];
    foreach (m_type_overrides[index]) begin
      if(m_matches_type_override(.override(m_type_overrides[index]),
      .requested_type(requested_type),
      .requested_type_name(requested_type.get_type_name()),
      .full_inst_path(full_inst_path),
      .resolve_null_type_by_inst(1))) begin
        matched_overrides.push_back(m_type_overrides[index]);
        if ((lindex == null) || (lindex.replace == 0)) begin
          lindex = m_type_overrides[index];
          if (!m_debug_pass && lindex.replace) begin
            break;
          end
        end
      end
    end
    if(matched_overrides.size() != 0) begin
      if (m_debug_pass) begin
        override_info = {override_info,matched_overrides};
      end
      else begin
        override_info.push_back(matched_overrides[$]);
      end
    end
  end
  if (lindex != null) begin
    uvm_object_wrapper override = lindex.ovrd.m_type;
    lindex.used++;
    if (m_debug_pass) begin
      lindex.selected = 1;
    end
    if(!m_matches_type_override(.override(lindex),
    .requested_type(requested_type),
    .requested_type_name(requested_type.get_type_name()),
    .full_inst_path(full_inst_path),
    .match_original_type(0),
    .resolve_null_type_by_inst(1))) begin
      if(override == null) begin
        override = find_override_by_name(lindex.ovrd.m_type_name,full_inst_path);
      end
      else begin
        override = find_override_by_type(override,full_inst_path);
      end
    end
    else if(override == null) begin
      override = m_resolve_type_name_by_inst(lindex.ovrd.m_type_name,full_inst_path);
    end
    if(override == null) begin
      uvm_report_error("TYPNTF", {"Cannot resolve override for original type '",
        lindex.orig.m_type_name,"' because the override type '",
        lindex.ovrd.m_type_name, "' is not registered with the factory."}, UVM_NONE);
    end
    return override;
  end
  return requested_type;
endfunction
function void uvm_default_factory::print (int all_types=1);
  string key;
  string qs[$];
  qs.push_back("\n#### Factory Configuration (*)\n\n");
  if(!m_type_overrides.size() && !m_inst_overrides.size()) begin
    qs.push_back("  No instance or type overrides are registered with this factory\n");
  end
  else begin
    int max1,max2,max3;
    string dash = "---------------------------------------------------------------------------------------------------";
    string space= "                                                                                                   ";
    if(!m_inst_overrides.size()) begin
      qs.push_back("No instance overrides are registered with this factory\n");
    end
    else begin
      foreach(m_inst_overrides[j]) begin
        if (m_inst_overrides[j].orig.m_type_name.len() > max1) begin
          max1=m_inst_overrides[j].orig.m_type_name.len();
        end
        if (m_inst_overrides[j].full_inst_path.len() > max2) begin
          max2=m_inst_overrides[j].full_inst_path.len();
        end
        if (m_inst_overrides[j].ovrd.m_type_name.len() > max3) begin
          max3=m_inst_overrides[j].ovrd.m_type_name.len();
        end
      end
      if (max1 < 14) begin
        max1 = 14;
      end
      if (max2 < 13) begin
        max2 = 13;
      end
      if (max3 < 13) begin
        max3 = 13;
      end
      qs.push_back("Instance Overrides:\n\n");
      qs.push_back($sformatf("  %0s%0s  %0s%0s  %0s%0s\n","Requested Type",space.substr(1,max1-14),
                                          "Override Path", space.substr(1,max2-13),
                                          "Override Type", space.substr(1,max3-13)));
      qs.push_back($sformatf("  %0s  %0s  %0s\n",dash.substr(1,max1),
                                 dash.substr(1,max2),
                                 dash.substr(1,max3)));
      foreach(m_inst_overrides[j]) begin
        qs.push_back($sformatf("  %0s%0s  %0s%0s",m_inst_overrides[j].orig.m_type_name,
               space.substr(1,max1-m_inst_overrides[j].orig.m_type_name.len()),
               m_inst_overrides[j].full_inst_path,
               space.substr(1,max2-m_inst_overrides[j].full_inst_path.len())));
        qs.push_back($sformatf("  %0s\n", m_inst_overrides[j].ovrd.m_type_name));
      end
    end
    if (!m_type_overrides.size()) begin
      qs.push_back("\nNo type overrides are registered with this factory\n");
    end
    else begin
      if (max1 < 14) begin
        max1 = 14;
      end
      if (max2 < 13) begin
        max2 = 13;
      end
      if (max3 < 13) begin
        max3 = 13;
      end
      foreach (m_type_overrides[i]) begin
        if (m_type_overrides[i].orig.m_type_name.len() > max1) begin
          max1=m_type_overrides[i].orig.m_type_name.len();
        end
        if (m_type_overrides[i].ovrd.m_type_name.len() > max2) begin
          max2=m_type_overrides[i].ovrd.m_type_name.len();
        end
      end
      if (max1 < 14) begin
        max1 = 14;
      end
      if (max2 < 13) begin
        max2 = 13;
      end
      qs.push_back("\nType Overrides:\n\n");
      qs.push_back($sformatf("  %0s%0s  %0s%0s\n","Requested Type",space.substr(1,max1-14),
                                  "Override Type", space.substr(1,max2-13)));
      qs.push_back($sformatf("  %0s  %0s\n",dash.substr(1,max1),
                            dash.substr(1,max2)));
      for (int index=m_type_overrides.size()-1; index>=0; index--) begin
        qs.push_back($sformatf("  %0s%0s  %0s\n",
                 m_type_overrides[index].orig.m_type_name,
                 space.substr(1,max1-m_type_overrides[index].orig.m_type_name.len()),
                 m_type_overrides[index].ovrd.m_type_name));
      end
    end
  end
  if (all_types >= 1 && m_type_names.first(key)) begin
    bit banner;
    qs.push_back($sformatf("\nAll types registered with the factory: %0d total\n",m_types.num()));
    do begin
      if (!(all_types < 2 && uvm_is_match("uvm_*",
      m_type_names[key].get_type_name())) &&
      key == m_type_names[key].get_type_name()) begin
        if (!banner) begin
          qs.push_back("  Type Name\n");
          qs.push_back("  ---------\n");
          banner=1;
        end
        qs.push_back($sformatf("  %s\n", m_type_names[key].get_type_name()));
      end
    end while(m_type_names.next(key));
  end
  qs.push_back("(*) Types with no associated type name will be printed as <unknown>\n\n####\n\n");
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/FACTORY/PRINT") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/FACTORY/PRINT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/FACTORY/PRINT", uvm_pkg::m_uvm_string_queue_join(qs), UVM_NONE, "t/uvm/src/base/uvm_factory.svh", 2050, "", 1);
     end
   end
endfunction
function void  uvm_default_factory::debug_create_by_name (string requested_type_name,
                                                  string parent_inst_path="",
                                                  string name="");
  m_debug_create(requested_type_name, null, parent_inst_path, name);
endfunction
function void  uvm_default_factory::debug_create_by_type (uvm_object_wrapper requested_type,
                                                  string parent_inst_path="",
                                                  string name="");
  m_debug_create("", requested_type, parent_inst_path, name);
endfunction
function void  uvm_default_factory::m_debug_create (string requested_type_name,
                                            uvm_object_wrapper requested_type,
                                            string parent_inst_path,
                                            string name);
  string full_inst_path;
  uvm_object_wrapper result;
  if (parent_inst_path == "") begin
    full_inst_path = name;
  end
  else if (name != "") begin
    full_inst_path = {parent_inst_path,".",name};
  end
  else begin
    full_inst_path = parent_inst_path;
  end
  m_override_info.delete();
  if (requested_type == null) begin
    if (!m_type_names.exists(requested_type_name) &&
    !m_lookup_strs.exists(requested_type_name)) begin
      uvm_report_warning("Factory Warning", {"The factory does not recognize '",
        requested_type_name,"' as a registered type."}, UVM_NONE);
      return;
    end
    m_debug_pass = 1;
    result = find_override_by_name(requested_type_name,full_inst_path);
  end
  else begin
    m_debug_pass = 1;
    if (!m_types.exists(requested_type)) begin
      register(requested_type);
    end
    result = find_override_by_type(requested_type,full_inst_path);
    if (requested_type_name == "") begin
      requested_type_name = requested_type.get_type_name();
    end
  end
  m_debug_display(requested_type_name, result, full_inst_path);
  m_debug_pass = 0;
  foreach (m_override_info[index]) begin
    m_override_info[index].selected = 0;
  end
endfunction
function void  uvm_default_factory::m_debug_display (string requested_type_name,
                                             uvm_object_wrapper result,
                                             string full_inst_path);
  int    max1,max2,max3;
  string dash = "---------------------------------------------------------------------------------------------------";
  string space= "                                                                                                   ";
  string qs[$];
  qs.push_back("\n#### Factory Override Information (*)\n\n");
  qs.push_back(
      $sformatf("Given a request for an object of type '%s' with an instance\npath of '%s' the factory encountered\n\n",
          requested_type_name,full_inst_path));
  if (m_override_info.size() == 0) begin
    qs.push_back("no relevant overrides.\n\n");
  end
  else begin
    qs.push_back("the following relevant overrides. An 'x' next to a match indicates a\nmatch that was ignored.\n\n");
    foreach (m_override_info[i]) begin
      if (m_override_info[i].orig.m_type_name.len() > max1) begin
        max1=m_override_info[i].orig.m_type_name.len();
      end
      if (m_override_info[i].full_inst_path.len() > max2) begin
        max2=m_override_info[i].full_inst_path.len();
      end
      if (m_override_info[i].ovrd.m_type_name.len() > max3) begin
        max3=m_override_info[i].ovrd.m_type_name.len();
      end
    end
    if (max1 < 13) begin
      max1 = 13;
    end
    if (max2 < 13) begin
      max2 = 13;
    end
    if (max3 < 13) begin
      max3 = 13;
    end
    qs.push_back($sformatf("Original Type%0s  Instance Path%0s  Override Type%0s\n",
        space.substr(1,max1-13),space.substr(1,max2-13),space.substr(1,max3-13)));
    qs.push_back($sformatf("  %0s  %0s  %0s\n",dash.substr(1,max1),
                               dash.substr(1,max2),
                               dash.substr(1,max3)));
    foreach (m_override_info[i]) begin
      qs.push_back($sformatf("%s%0s%0s\n",
             m_override_info[i].selected ? "  " : "x ",
             m_override_info[i].orig.m_type_name,
             space.substr(1,max1-m_override_info[i].orig.m_type_name.len())));
      qs.push_back($sformatf("  %0s%0s", m_override_info[i].full_inst_path,
             space.substr(1,max2-m_override_info[i].full_inst_path.len())));
      qs.push_back($sformatf("  %0s%0s", m_override_info[i].ovrd.m_type_name,
             space.substr(1,max3-m_override_info[i].ovrd.m_type_name.len())));
      if (m_override_info[i].full_inst_path == "*") begin
        qs.push_back("  <type override>");
      end
      else begin
        qs.push_back("\n");
      end
    end
    qs.push_back("\n");
  end
  qs.push_back("Result:\n\n");
  qs.push_back($sformatf("  The factory will produce an object of type '%0s'\n",
           result == null ? requested_type_name : result.get_type_name()));
  qs.push_back("\n(*) Types with no associated type name will be printed as <unknown>\n\n####\n\n");
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/FACTORY/DUMP") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/FACTORY/DUMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/FACTORY/DUMP", uvm_pkg::m_uvm_string_queue_join(qs), UVM_NONE, "t/uvm/src/base/uvm_factory.svh", 2235, "", 1);
     end
   end
endfunction
function uvm_object_wrapper uvm_default_factory::m_resolve_type_name(string requested_type_name);
  uvm_object_wrapper wrapper=null;
  if(m_type_names.exists(requested_type_name)) begin
    wrapper = m_type_names[requested_type_name];
  end
  return wrapper;
endfunction
function uvm_object_wrapper uvm_default_factory::m_resolve_type_name_by_inst(string requested_type_name,
                                                                             string full_inst_path);
  uvm_object_wrapper wrapper=null;
  m_inst_typename_alias_t  type_alias_inst[$];
  type_alias_inst = m_inst_aliases.find(i) with ((i.alias_type_name == requested_type_name) && uvm_is_match(i.full_inst_path,full_inst_path));
  if (type_alias_inst.size() > 0) begin
    wrapper = type_alias_inst[0].orig.m_type;
  end
  else begin
    wrapper = m_resolve_type_name(requested_type_name);
  end
  return wrapper;
endfunction
function bit uvm_default_factory::m_matches_type_pair(m_uvm_factory_type_pair_t match_type_pair,
                                                      uvm_object_wrapper requested_type,
                                                      string requested_type_name);
  return ((match_type_pair.m_type != null) &&
          (match_type_pair.m_type == requested_type) ||
          (match_type_pair.m_type_name != "<unknown>" &&
           match_type_pair.m_type_name != "" &&
           match_type_pair.m_type_name == requested_type_name));
endfunction
function bit uvm_default_factory::m_matches_inst_override(uvm_factory_override override,
                                                          uvm_object_wrapper requested_type,
                                                          string requested_type_name,
                                                          string full_inst_path="");
  m_uvm_factory_type_pair_t match_type_pair = override.orig ;
  if(match_type_pair.m_type == null) begin
    match_type_pair.m_type = m_resolve_type_name_by_inst(match_type_pair.m_type_name, full_inst_path);
  end
  if (m_matches_type_pair(.match_type_pair(match_type_pair),
                          .requested_type(requested_type),
                          .requested_type_name(requested_type_name))) begin
    if(override.has_wildcard) begin
      return (override.full_inst_path == "*" ||
              uvm_is_match(override.full_inst_path,full_inst_path));
    end
    else begin
      return (override.full_inst_path == full_inst_path);
    end
  end
  return 0;
endfunction
function bit uvm_default_factory::m_matches_type_override(uvm_factory_override override,
                                                          uvm_object_wrapper requested_type,
                                                          string requested_type_name,
                                                          string full_inst_path="",
                                                          bit match_original_type = 1,
                                                          bit resolve_null_type_by_inst=0);
  m_uvm_factory_type_pair_t match_type_pair = match_original_type ? override.orig : override.ovrd;
  if(match_type_pair.m_type == null) begin
    if(resolve_null_type_by_inst) begin
      match_type_pair.m_type = m_resolve_type_name_by_inst(match_type_pair.m_type_name,full_inst_path);
    end
    else begin
      match_type_pair.m_type = m_resolve_type_name(match_type_pair.m_type_name);
    end
  end
  return m_matches_type_pair(.match_type_pair(match_type_pair),
                             .requested_type(requested_type),
                             .requested_type_name(requested_type_name));
endfunction
`define UVM_REGISTRY_SVH
typedef class uvm_registry_common;
typedef class uvm_registry_component_creator;
typedef class uvm_registry_object_creator;
class uvm_component_registry #(type T=uvm_component, string Tname="<unknown>")
                                           extends uvm_object_wrapper;
  typedef uvm_component_registry #(T,Tname) this_type;
  typedef uvm_registry_common#( this_type, uvm_registry_component_creator, T, Tname ) common_type;
  virtual function uvm_component create_component (string name,
                                                   uvm_component parent);
    T obj;
    obj = new(name, parent);
    return obj;
  endfunction
   static function string type_name();
     return common_type::type_name();
   endfunction : type_name
  virtual function string get_type_name();
     common_type common = common_type::get();
     return common.get_type_name();
  endfunction
  static function this_type get();
     static this_type m_inst;
     if (m_inst == null) begin
       m_inst = new();
     end
    return m_inst;
  endfunction
  virtual function void initialize();
     common_type common = common_type::get();
     common.initialize();
  endfunction
  static function T create(string name, uvm_component parent, string contxt="");
    return common_type::create( name, parent, contxt );
  endfunction
  static function void set_type_override (uvm_object_wrapper override_type,
                                          bit replace=1);
    common_type::set_type_override( override_type, replace );
  endfunction
  static function void set_inst_override(uvm_object_wrapper override_type,
                                         string inst_path,
                                         uvm_component parent=null);
    common_type::set_inst_override( override_type, inst_path, parent );
  endfunction
  static function bit set_type_alias(string alias_name);
     common_type::set_type_alias( alias_name );
     return 1;
  endfunction
endclass
class uvm_object_registry #(type T=uvm_object, string Tname="<unknown>")
                                        extends uvm_object_wrapper;
  typedef uvm_object_registry #(T,Tname) this_type;
  typedef uvm_registry_common#( this_type, uvm_registry_object_creator, T, Tname ) common_type;
  virtual function uvm_object create_object(string name="");
    T obj;
    if (name=="") begin
      obj = new();
    end
    else begin
      obj = new(name);
    end
    return obj;
  endfunction
  static function string type_name();
     return common_type::type_name();
  endfunction : type_name
  virtual function string get_type_name();
     common_type common = common_type::get();
     return common.get_type_name();
  endfunction
  static function this_type get();
     static this_type m_inst;
     if (m_inst == null) begin
       m_inst = new();
     end
    return m_inst;
  endfunction
  static function T create (string name="", uvm_component parent=null,
                            string contxt="");
    return common_type::create( name, parent, contxt );
  endfunction
  static function void set_type_override (uvm_object_wrapper override_type,
                                          bit replace=1);
    common_type::set_type_override( override_type, replace );
  endfunction
  static function void set_inst_override(uvm_object_wrapper override_type,
                                         string inst_path,
                                         uvm_component parent=null);
    common_type::set_inst_override( override_type, inst_path, parent );
  endfunction
  static function bit set_type_alias(string alias_name);
     common_type::set_type_alias( alias_name );
     return 1;
  endfunction
  virtual function void initialize();
     common_type common = common_type::get();
     common.initialize();
  endfunction
endclass
class uvm_abstract_component_registry #(type T=uvm_component, string Tname="<unknown>")
                                           extends uvm_object_wrapper;
  typedef uvm_abstract_component_registry #(T,Tname) this_type;
  typedef uvm_registry_common#( this_type, uvm_registry_component_creator, T, Tname ) common_type;
  virtual function uvm_component create_component (string name,
                                                   uvm_component parent);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/ABST_RGTRY/CREATE_ABSTRACT_CMPNT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/ABST_RGTRY/CREATE_ABSTRACT_CMPNT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/ABST_RGTRY/CREATE_ABSTRACT_CMPNT", $sformatf( "Cannot create an instance of abstract class %s (with name %s and parent %s). Check for missing factory overrides for %s.", this.get_type_name(), name, parent.get_full_name(), this.get_type_name() ), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_registry.svh", 330, "", 1);
     end
   end
    return null;
  endfunction
  static function string type_name();
     return common_type::type_name();
  endfunction : type_name
  virtual function string get_type_name();
     common_type common = common_type::get();
     return common.get_type_name();
  endfunction
  static function this_type get();
    static this_type m_inst;
     if (m_inst == null) begin
       m_inst = new();
     end
    return m_inst;
  endfunction
  static function T create(string name, uvm_component parent, string contxt="");
    return common_type::create( name, parent, contxt );
  endfunction
  static function void set_type_override (uvm_object_wrapper override_type,
                                          bit replace=1);
    common_type::set_type_override( override_type, replace );
  endfunction
  static function void set_inst_override(uvm_object_wrapper override_type,
                                         string inst_path,
                                         uvm_component parent=null);
    common_type::set_inst_override( override_type, inst_path, parent );
  endfunction
  static function bit set_type_alias(string alias_name);
     common_type::set_type_alias( alias_name );
     return 1;
  endfunction
  virtual function void initialize();
     common_type common = common_type::get();
     common.initialize();
  endfunction
endclass
class uvm_abstract_object_registry #(type T=uvm_object, string Tname="<unknown>")
                                        extends uvm_object_wrapper;
  typedef uvm_abstract_object_registry #(T,Tname) this_type;
  typedef uvm_registry_common#( this_type, uvm_registry_object_creator, T, Tname ) common_type;
  virtual function uvm_object create_object(string name="");
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/ABST_RGTRY/CREATE_ABSTRACT_OBJ") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/ABST_RGTRY/CREATE_ABSTRACT_OBJ") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/ABST_RGTRY/CREATE_ABSTRACT_OBJ", $sformatf( "Cannot create an instance of abstract class %s (with name %s). Check for missing factory overrides for %s.", this.get_type_name(), name, this.get_type_name() ), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_registry.svh", 453, "", 1);
     end
   end
    return null;
  endfunction
  static function string type_name();
     return common_type::type_name();
  endfunction : type_name
  virtual function string get_type_name();
     common_type common = common_type::get();
     return common.get_type_name();
  endfunction
  static function this_type get();
    static this_type m_inst;
     if (m_inst == null) begin
       m_inst = new();
     end
    return m_inst;
  endfunction
  static function T create (string name="", uvm_component parent=null,
                            string contxt="");
    return common_type::create( name, parent, contxt );
  endfunction
  static function void set_type_override (uvm_object_wrapper override_type,
                                          bit replace=1);
    common_type::set_type_override( override_type, replace );
  endfunction
  static function void set_inst_override(uvm_object_wrapper override_type,
                                         string inst_path,
                                         uvm_component parent=null);
    common_type::set_inst_override( override_type, inst_path, parent );
  endfunction
  static function bit set_type_alias(string alias_name);
     common_type::set_type_alias( alias_name );
     return 1;
  endfunction
  virtual function void initialize();
     common_type common = common_type::get();
     common.initialize();
  endfunction
endclass
class uvm_registry_common #( type Tregistry=int, type Tcreator=int, type Tcreated=int, string Tname="<unknown>" );
  typedef uvm_registry_common#(Tregistry,Tcreator,Tcreated,Tname) this_type;
  local static string m__type_aliases[$];
  static function string type_name();
     if((Tname == "<unknown>") && (m__type_aliases.size() != 0)) begin
       return m__type_aliases[0];
     end
     return Tname;
  endfunction : type_name
  virtual function string get_type_name();
    return type_name();
  endfunction
  static function this_type get();
     static this_type m_inst;
     if (m_inst == null) begin
       m_inst = new();
     end
     return m_inst;
  endfunction : get
  static function Tcreated create(string name, uvm_component parent, string contxt);
    uvm_object obj;
    if (contxt == "" && parent != null) begin
      contxt = parent.get_full_name();
    end
    obj = Tcreator::create_by_type( Tregistry::get(), contxt, name, parent );
    if (!$cast(create, obj)) begin
      string msg;
      msg = {"Factory did not return a ", Tcreator::base_type_name(), " of type '",Tregistry::type_name,
        "'. A component of type '",obj == null ? "null" : obj.get_type_name(),
        "' was returned instead. Name=",name," Parent=",
        parent==null?"null":parent.get_type_name()," contxt=",contxt};
      uvm_report_fatal("FCTTYP", msg, UVM_NONE);
    end
  endfunction
  static function void set_type_override (uvm_object_wrapper override_type,
                                          bit replace);
    uvm_factory factory=uvm_factory::get();
    factory.set_type_override_by_type(Tregistry::get(),override_type,replace);
  endfunction
  static function void set_inst_override(uvm_object_wrapper override_type,
                                         string inst_path,
                                         uvm_component parent);
    string full_inst_path;
    uvm_factory factory=uvm_factory::get();
    if (parent != null) begin
      if (inst_path == "") begin
        inst_path = parent.get_full_name();
      end
      else begin
        inst_path = {parent.get_full_name(),".",inst_path};
      end
    end
    factory.set_inst_override_by_type(Tregistry::get(),override_type,inst_path);
  endfunction
  static function void set_type_alias(string alias_name);
     m__type_aliases.push_back(alias_name);
     m__type_aliases.sort();
     if (uvm_pkg::get_core_state() != UVM_CORE_UNINITIALIZED) begin
       uvm_factory factory = uvm_factory::get();
       Tregistry rgtry = Tregistry::get();
       if (factory.is_type_registered(rgtry)) begin
         factory.set_type_alias(alias_name,rgtry);
       end
     end
  endfunction
  static function bit __deferred_init();
     Tregistry rgtry = Tregistry::get();
     if (uvm_pkg::get_core_state() == UVM_CORE_UNINITIALIZED) begin
       uvm_pkg::uvm_deferred_init.push_back(rgtry);
     end
     else begin
       rgtry.initialize();
     end
     return 1;
  endfunction
  local static bit m__initialized=__deferred_init();
  virtual function void initialize();
     uvm_factory factory =uvm_factory::get();
     Tregistry rgtry = Tregistry::get();
     factory.register(rgtry);
     foreach(m__type_aliases[i]) begin
       factory.set_type_alias(m__type_aliases[i],rgtry);
     end
  endfunction
endclass
virtual class uvm_registry_component_creator;
  static function uvm_component create_by_type(
    uvm_object_wrapper obj_wrpr,
    string contxt,
    string name,
    uvm_component parent
  );
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_factory factory = cs.get_factory();
    return factory.create_component_by_type( obj_wrpr, contxt, name, parent );
  endfunction
  static function string base_type_name();  return "component"; endfunction
endclass
virtual class uvm_registry_object_creator;
  static function uvm_object create_by_type(
    uvm_object_wrapper obj_wrpr,
    string contxt,
    string name,
    uvm_object unused
  );
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_factory factory = cs.get_factory();
    unused = unused;
    return factory.create_object_by_type( obj_wrpr, contxt, name );
  endfunction
  static function string base_type_name();  return "object"; endfunction
endclass
class uvm_pool #(type KEY=int, T=uvm_void) extends uvm_object;
  typedef uvm_pool #(KEY,T) this_type;
  static protected this_type m_global_pool;
  protected T pool[KEY];
   typedef uvm_object_registry #(uvm_pool #(KEY,T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_pool #(KEY,T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_pool";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_pool";
     endfunction : get_type_name
  function new (string name="");
    super.new(name);
  endfunction
  static function this_type get_global_pool ();
    if (m_global_pool==null)
      begin
        m_global_pool = new("pool");
      end
    return m_global_pool;
  endfunction
  static function T get_global (KEY key);
    this_type gpool;
    gpool = get_global_pool();
    return gpool.get(key);
  endfunction
  virtual function T get (KEY key);
    if (!pool.exists(key))
      begin
        T default_value;
        pool[key] = default_value;
      end
    return pool[key];
  endfunction
  virtual function void add (KEY key, T item);
    pool[key] = item;
  endfunction
  virtual function int num ();
    return pool.num();
  endfunction
  virtual function void delete (KEY key);
    if (!exists(key))
      begin
        uvm_report_warning("POOLDEL",
        $sformatf("delete: pool key doesn't exist. Ignoring delete request"));
        return;
      end
    pool.delete(key);
  endfunction
  virtual function int exists (KEY key);
    return pool.exists(key);
  endfunction
  virtual function int first (ref KEY key);
    return pool.first(key);
  endfunction
  virtual function int last (ref KEY key);
    return pool.last(key);
  endfunction
  virtual function int next (ref KEY key);
    return pool.next(key);
  endfunction
  virtual function int prev (ref KEY key);
    return pool.prev(key);
  endfunction
  virtual function void do_copy (uvm_object rhs);
    this_type p;
    KEY key;
    super.do_copy(rhs);
    if (rhs==null || !$cast(p, rhs))
      begin
        return;
      end
    pool = p.pool;
  endfunction
  virtual function void do_print (uvm_printer printer);
    string v;
    int cnt;
    string item;
    KEY key;
    printer.print_array_header("pool",pool.num(),"aa_object_string");
    if (pool.first(key))
      begin
        do
        begin
          item.itoa(cnt);
          item = {"[-key",item,"--]"};
          $swrite(v,pool[key]);
          printer.print_generic(item,"",-1,v,"[");
        end
        while (pool.next(key));
      end
    printer.print_array_footer();
  endfunction
endclass
class uvm_object_string_pool #(type T=uvm_object) extends uvm_pool #(string,T);
  typedef uvm_object_string_pool #(T) this_type;
  static protected this_type m_global_pool;
   typedef uvm_object_registry #(uvm_object_string_pool#(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_object_string_pool#(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_obj_str_pool";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_obj_str_pool";
     endfunction : get_type_name
  function new (string name="");
    super.new(name);
  endfunction
  static function this_type get_global_pool ();
    if (m_global_pool==null)
      begin
        m_global_pool = new("global_pool");
      end
    return m_global_pool;
  endfunction
  static function T get_global (string key);
    this_type gpool;
    gpool = get_global_pool();
    return gpool.get(key);
  endfunction
  virtual function T get (string key);
    if (!pool.exists(key))
      begin
        pool[key] = new (key);
      end
    return pool[key];
  endfunction
  virtual function void delete (string key);
    if (!exists(key))
      begin
        uvm_report_warning("POOLDEL",
        $sformatf("delete: key '%s' doesn't exist", key));
        return;
      end
    pool.delete(key);
  endfunction
  virtual function void do_print (uvm_printer printer);
    string key;
    printer.print_array_header("pool",pool.num(),"aa_object_string");
    if (pool.first(key))
      begin
        do
        begin
          printer.print_object({"[",key,"]"}, pool[key],"[");
        end
        while (pool.next(key));
      end
    printer.print_array_footer();
  endfunction
endclass
typedef class uvm_barrier;
typedef class uvm_event;
typedef uvm_object_string_pool #(uvm_barrier) uvm_barrier_pool   ;
typedef uvm_object_string_pool #(uvm_event#(uvm_object)) uvm_event_pool   ;
`define UVM_QUEUE_SVH
class uvm_queue #(type T=int) extends uvm_object;
  typedef uvm_queue #(T) this_type;
   typedef uvm_object_registry #(uvm_queue#(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_queue#(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_queue";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_queue";
     endfunction : get_type_name
  static local this_type m_global_queue;
  protected T queue[$];
  function new (string name="");
    super.new(name);
  endfunction
  static function this_type get_global_queue ();
    if (m_global_queue==null)
      begin
        m_global_queue = new("global_queue");
      end
    return m_global_queue;
  endfunction
  static function T get_global (int index);
    this_type gqueue;
    gqueue = get_global_queue();
    return gqueue.get(index);
  endfunction
  virtual function T get (int index);
    T default_value;
    if (index >= size() || index < 0)
      begin
        uvm_report_warning("QUEUEGET",
        $sformatf("get: given index out of range for queue of size %0d. Ignoring get request",size()));
        return default_value;
      end
    return queue[index];
  endfunction
  virtual function int size ();
    return queue.size();
  endfunction
  virtual function void insert (int index, T item);
    if (index >= size() || index < 0)
      begin
        uvm_report_warning("QUEUEINS",
        $sformatf("insert: given index out of range for queue of size %0d. Ignoring insert request",size()));
        return;
      end
    queue.insert(index,item);
  endfunction
  virtual function void delete (int index=-1);
    if (index >= size() || index < -1)
      begin
        uvm_report_warning("QUEUEDEL",
        $sformatf("delete: given index out of range for queue of size %0d. Ignoring delete request",size()));
        return;
      end
    if (index == -1)
      begin
        queue.delete();
      end
    else
      begin
        queue.delete(index);
      end
  endfunction
  virtual function T pop_front();
    return queue.pop_front();
  endfunction
  virtual function T pop_back();
    return queue.pop_back();
  endfunction
  virtual function void push_front(T item);
    queue.push_front(item);
  endfunction
  virtual function void push_back(T item);
    queue.push_back(item);
  endfunction
  virtual task wait_until_not_empty();
      wait(queue.size() > 0);
  endtask
  virtual function void do_copy (uvm_object rhs);
    this_type p;
    super.do_copy(rhs);
    if (rhs == null || !$cast(p, rhs))
      begin
        return;
      end
    queue = p.queue;
  endfunction
  virtual function string convert2string();
      return $sformatf("%p",queue);
  endfunction
endclass
class uvm_spell_chkr #(type T=int);
  typedef T tab_t[string];
  localparam int unsigned max = '1;
  static function bit check (   ref tab_t strtab, input string s);
    string key;
    int distance;
    int unsigned min;
    string min_key[$];
    if(strtab.exists(s)) begin
      return 1;
    end
    min = max;
    foreach(strtab[key]) begin
      distance = levenshtein_distance(key, s);
      if(distance < 0) begin
        continue;
      end
      if(distance < min) begin
        min = distance;
        min_key.delete();
        min_key.push_back(key);
        continue;
      end
      if(distance == min) begin
        min_key.push_back(key);
      end
    end
    if(min == max) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/CONFIGDB/SPELLCHK") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/CONFIGDB/SPELLCHK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/CONFIGDB/SPELLCHK", $sformatf("%s not located, no alternatives to suggest", s), UVM_NONE, "t/uvm/src/base/uvm_spell_chkr.svh", 123, "", 1);
     end
   end
    end
    else begin
      string q[$];
      foreach(min_key[i]) begin
        q.push_back(min_key[i]);
        q.push_back("|");
      end
      if(q.size()) begin
        void'(q.pop_back());
      end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/CONFIGDB/SPELLCHK") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/CONFIGDB/SPELLCHK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/CONFIGDB/SPELLCHK", $sformatf("%s not located, did you mean %s", s, uvm_pkg::m_uvm_string_queue_join(q)), UVM_NONE, "t/uvm/src/base/uvm_spell_chkr.svh", 140, "", 1);
     end
   end
    end
    return 0;
  endfunction
  static local function int levenshtein_distance(string s, string t);
    int k, i, j, n, m, cost, distance;
    int d[];
    n = s.len() + 1;
    m = t.len() + 1;
    if(n == 1 || m == 1) begin
      return -1;
    end
    d = new[m*n];
    for(k = 0; k < n; k++) begin
      d[k] = k;
    end
    for(k = 0; k < m; k++) begin
      d[k*n] = k;
    end
    for(i = 1; i < n; i++) begin
      for(j = 1; j < m; j++) begin
        cost = !(s[i-1] == t[j-1]);
        d[j*n+i] = minimum(d[(j-1)*n+i]+1, d[j*n+i-1]+1, d[(j-1)*n+i-1]+cost);
      end
    end
    distance = d[n*m-1];
    return distance;
  endfunction
  static local function int minimum(int a, int b, int c);
    int min = a;
    if(b < min) begin
      min = b;
    end
    if(c < min) begin
      min = c;
    end
    return min;
  endfunction
endclass
typedef class uvm_resource_base;
class uvm_resource_types;
  typedef bit[1:0] override_t;
  typedef enum override_t { TYPE_OVERRIDE = 2'b01,
                            NAME_OVERRIDE = 2'b10 } override_e;
  typedef uvm_queue#(uvm_resource_base) rsrc_q_t;
  typedef uvm_resource_base rsrc_sv_q_t[$];
  typedef uvm_shared#(rsrc_sv_q_t) rsrc_shared_q_t;
  typedef enum { PRI_HIGH, PRI_LOW } priority_e;
  typedef struct
  {
    time read_time;
    time write_time;
    int unsigned read_count;
    int unsigned write_count;
  } access_t;
endclass
class uvm_resource_options;
  static local bit auditing = 1;
  static function void turn_on_auditing();
    auditing = 1;
  endfunction
  static function void turn_off_auditing();
    auditing = 0;
  endfunction
  static function bit is_auditing();
    return auditing;
  endfunction
endclass
class uvm_resource_debug extends uvm_object ;
  uvm_resource_types::access_t access[string];
   typedef uvm_object_registry#(uvm_resource_debug,"uvm_resource_debug") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_resource_debug tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_resource_debug";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_resource_debug";
     endfunction : get_type_name
  function new(string name = "");
    super.new(name);
  endfunction
  virtual function void record_read_access(uvm_object accessor = null);
    string str;
    uvm_resource_types::access_t access_record;
    if(accessor != null) begin
      str = accessor.get_full_name();
    end
    else begin
      str = "<empty>";
    end
    if(access.exists(str)) begin
      access_record = access[str];
    end
    else begin
      init_access_record(access_record);
    end
    access_record.read_count++;
    access_record.read_time = $realtime;
    access[str] = access_record;
  endfunction
  virtual function void record_write_access(uvm_object accessor = null);
    string str;
      if(accessor != null) begin
        uvm_resource_types::access_t access_record;
        string str;
        str = accessor.get_full_name();
        if(access.exists(str)) begin
          access_record = access[str];
        end
        else begin
          init_access_record(access_record);
        end
        access_record.write_count++;
        access_record.write_time = $realtime;
        access[str] = access_record;
      end
  endfunction
  virtual function void print_accessors();
    string str;
    uvm_component comp;
    uvm_resource_types::access_t access_record;
    string qs[$];
    if(access.num() == 0) begin
      return;
    end
    foreach (access[i]) begin
      str = i;
      access_record = access[str];
      qs.push_back($sformatf("%s reads: %0d @ %0t  writes: %0d @ %0t\n",str,
               access_record.read_count,
               access_record.read_time,
               access_record.write_count,
               access_record.write_time));
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/RESOURCE/ACCESSOR") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/RESOURCE/ACCESSOR") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/RESOURCE/ACCESSOR", uvm_pkg::m_uvm_string_queue_join(qs), UVM_NONE, "t/uvm/src/base/uvm_resource_base.svh", 330, "", 1);
     end
   end
  endfunction
  function void init_access_record (inout uvm_resource_types::access_t access_record);
    access_record.read_time = 0;
    access_record.write_time = 0;
    access_record.read_count = 0;
    access_record.write_count = 0;
  endfunction
endclass
virtual class uvm_resource_base extends uvm_object;
  protected bit modified;
  protected bit read_only;
  uvm_resource_debug dbg ;
  protected string scope;
  int unsigned precedence;
  static int unsigned default_precedence = 1000;
  function new(string name = "",string s = "<not provided>");
    super.new(name);
    modified = 0;
    read_only = 0;
    if (s == "<not provided>") begin
      scope = s;
    end
    else begin
      scope = uvm_glob_to_re(s) ;
    end
    precedence = default_precedence ;
  endfunction
  pure virtual function uvm_resource_base get_type_handle();
  function void set_read_only();
    read_only = 1;
  endfunction
  function void set_read_write();
    read_only = 0;
  endfunction
  function bit is_read_only();
    return read_only;
  endfunction
  task wait_modified();
    wait (modified == 1);
    modified = 0;
  endtask
  function string convert2string();
    return $sformatf("(%s) %s", m_value_type_name(), m_value_as_string());
  endfunction
  pure virtual function string m_value_type_name();
  pure virtual function string m_value_as_string();
  function void do_print(uvm_printer printer);
    super.do_print(printer);
    printer.print_generic_element("val", m_value_type_name(), "", m_value_as_string());
  endfunction : do_print
  function void record_read_access(uvm_object accessor = null);
     if (dbg==null) begin
       dbg = uvm_resource_debug::type_id::create("dbg") ;
     end
     dbg.record_read_access(accessor);
  endfunction
  function void record_write_access(uvm_object accessor = null);
     if (dbg==null) begin
       dbg = uvm_resource_debug::type_id::create("dbg") ;
     end
     dbg.record_write_access(accessor);
  endfunction
  virtual function void print_accessors();
     if (dbg != null) begin
       dbg.print_accessors();
     end
  endfunction
  function void init_access_record (inout uvm_resource_types::access_t access_record);
     if (dbg==null) begin
       dbg = uvm_resource_debug::type_id::create("dbg") ;
     end
     dbg.init_access_record(access_record);
  endfunction
  function void set_scope(string s);
    scope = uvm_glob_to_re(s);
  endfunction
  function void m_set_scope(string s);
    scope = s;
  endfunction
  function string get_scope();
    return scope;
  endfunction
  function bit match_scope(string s);
    return uvm_is_match(scope, s);
  endfunction
  pure virtual function void set_priority (uvm_resource_types::priority_e pri);
endclass
class get_t;
  string name;
  string scope;
  uvm_resource_base rsrc;
  time t;
endclass
typedef class uvm_tree_printer ;
class uvm_resource_pool extends uvm_void;
  typedef uvm_resource_types::rsrc_shared_q_t table_q_t;
`define M__TABLE_Q(QUEUE_NAME) QUEUE_NAME``.value
`define M__TABLE_GET(QUEUE_NAME, ITER) QUEUE_NAME``.value[ITER]
`define M__TABLE_NAME "uvm_shared#(uvm_resource_base[$])"
  table_q_t rtab [string];
  table_q_t ttab [uvm_resource_base];
  get_t get_record [$];
  function new();
  endfunction
  static function uvm_resource_pool get();
    uvm_resource_pool t_rp;
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    t_rp = cs.get_resource_pool();
    return t_rp;
  endfunction
  function bit spell_check(string s);
    return uvm_spell_chkr#(table_q_t)::check(rtab, s);
  endfunction
  function void set (uvm_resource_base rsrc,
                     uvm_resource_types::override_t override = 0);
    if (rsrc == null) begin
      return ;
    end
    if (override) begin
      set_override(rsrc, rsrc.get_scope()) ;
    end
    else begin
      set_scope(rsrc, rsrc.get_scope()) ;
    end
  endfunction
  function void set_scope (uvm_resource_base rsrc, string scope);
    table_q_t rq;
    string name;
    uvm_resource_base type_handle;
    uvm_resource_base r;
    int unsigned i;
    if(rsrc == null) begin
      uvm_report_warning("NULLRASRC", "attempting to set scope of a null resource");
      return;
    end
    name = rsrc.get_name();
    if ((name != "") && rtab.exists(name)) begin
      rq = rtab[name];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        if (rq.value[iter] == rsrc) begin
          rsrc.m_set_scope(scope);
          return;
        end
      end
    end
    if (rq == null) begin
      rq = new();
      rtab[name] = rq;
    end
    rq.value.push_back(rsrc);
    type_handle = rsrc.get_type_handle();
    if(ttab.exists(type_handle)) begin
      rq = ttab[type_handle];
    end
    else begin
      rq = new();
      ttab[type_handle] = rq;
    end
    rq.value.push_back(rsrc);
    rsrc.m_set_scope(scope);
    rsrc.precedence = get_default_precedence();
  endfunction
  function void set_override(uvm_resource_base rsrc, string scope="<not provided>");
     string s ;
     if (rsrc == null) begin
       uvm_report_warning("NULLRASRC", "attempting to change the search priority of a null resource");
       return;
     end
     if (scope == "<not provided>") begin
       s = rsrc.get_scope();
     end
     else begin
       s = scope ;
     end
     set_scope(rsrc, s);
     set_priority(rsrc, uvm_resource_types::PRI_HIGH);
  endfunction
  function void set_name_override(uvm_resource_base rsrc, string scope="<not provided>");
    string s ;
    if (rsrc == null) begin
      uvm_report_warning("NULLRASRC", "attempting to change the search priority of a null resource");
      return;
    end
    if (scope == "<not provided>") begin
      s = rsrc.get_scope();
    end
    else begin
      s = scope ;
    end
    set_scope(rsrc, s);
    set_priority_name(rsrc, uvm_resource_types::PRI_HIGH);
  endfunction
  function void set_type_override(uvm_resource_base rsrc, string scope="<not provided>");
    string s ;
    if (rsrc == null) begin
      uvm_report_warning("NULLRASRC", "attempting to change the search priority of a null resource");
      return;
    end
    if (scope == "<not provided>") begin
      s = rsrc.get_scope();
    end
    else begin
      s = scope ;
    end
    set_scope(rsrc, s);
    set_priority_type(rsrc, uvm_resource_types::PRI_HIGH);
  endfunction
  virtual function bit get_scope(uvm_resource_base rsrc,
                                 output string scope);
    table_q_t rq;
    string name;
    uvm_resource_base r, type_handle;
    int unsigned i;
    if(rsrc == null) begin
      return 0;
    end
    name = rsrc.get_name();
    if((name != "") && rtab.exists(name)) begin
      rq = rtab[name];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        if (rq.value[iter] == rsrc) begin
          scope = rsrc.get_scope();
          return 1;
        end
      end
    end
    type_handle = rsrc.get_type_handle();
    if (ttab.exists(type_handle)) begin
      rq = ttab[type_handle];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        if (rq.value[iter] == rsrc) begin
          scope = rsrc.get_scope();
          return 1;
        end
      end
    end
    scope = "";
    return 0;
  endfunction
  virtual function void delete ( uvm_resource_base rsrc );
    string name;
    table_q_t rq;
    uvm_resource_base type_handle;
    int    iter;
    if (rsrc != null) begin
      name = rsrc.get_name();
      if(name != "") begin
        if(rtab.exists(name)) begin
          rq = rtab[name];
          iter = 0;
          while (iter < rq.value.size()) begin
            if (rq.value[iter] == rsrc) begin
              rq.value.delete(iter);
              break;
            end
            iter++;
          end
        end
      end
      type_handle = rsrc.get_type_handle();
      if(ttab.exists(type_handle)) begin
        rq = ttab[type_handle];
        iter = 0;
        while (iter < rq.value.size()) begin
          if (rq.value[iter] == rsrc) begin
            rq.value.delete(iter);
            break;
          end
          iter++;
        end
      end
    end
  endfunction
  function void push_get_record(string name, string scope,
                                  uvm_resource_base rsrc);
    get_t impt;
    if(!uvm_resource_options::is_auditing()) begin
      return;
    end
    impt = new();
    impt.name  = name;
    impt.scope = scope;
    impt.rsrc  = rsrc;
    impt.t     = $realtime;
    get_record.push_back(impt);
  endfunction
  function void dump_get_records();
    get_t record;
    bit success;
    string qs[$];
    qs.push_back("--- resource get records ---\n");
    foreach (get_record[i]) begin
      record = get_record[i];
      success = (record.rsrc != null);
      qs.push_back($sformatf("get: name=%s  scope=%s  %s @ %0t\n",
               record.name, record.scope,
               ((success)?"success":"fail"),
               record.t));
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/RESOURCE/GETRECORD") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/RESOURCE/GETRECORD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/RESOURCE/GETRECORD", uvm_pkg::m_uvm_string_queue_join(qs), UVM_NONE, "t/uvm/src/base/uvm_resource_pool.svh", 515, "", 1);
     end
   end
  endfunction
  function uvm_resource_types::rsrc_q_t lookup_name(string scope = "",
                                                    string name,
                                                    uvm_resource_base type_handle = null,
                                                    bit rpterr = 1);
    table_q_t rq;
    uvm_resource_types::rsrc_q_t q;
    uvm_resource_base rsrc;
    uvm_resource_base r;
    string rsrcs;
     begin
       process p = process::self();
       string s;
       if(p!=null) begin
         s=p.get_randstate();
       end
       q=new();
       if(p!=null) begin
         p.set_randstate(s);
       end
     end
    if(name == "") begin
      return q;
    end
    if(!rtab.exists(name)) begin
      if(rpterr) begin
        void'(spell_check(name));
      end
      return q;
    end
    rsrc = null;
    rq = rtab[name];
    for (int iter=0; iter < rq.value.size(); iter++) begin
      uvm_resource_base rsrc_iter;
      rsrc_iter = rq.value[iter];
      rsrcs = rsrc_iter != null ? rsrc_iter.get_scope(): "";
      if(((type_handle == null) || (rsrc_iter.get_type_handle() == type_handle))
      && uvm_is_match(rsrcs, scope)) begin
        q.push_back(rsrc_iter);
      end
    end
    return q;
  endfunction
  static function uvm_resource_base get_highest_precedence(ref uvm_resource_types::rsrc_q_t q);
    uvm_resource_base rsrc;
    uvm_resource_base r;
    int unsigned i;
    int unsigned prec;
    int unsigned c_prec;
    if(q.size() == 0) begin
      return null;
    end
    rsrc = q.get(0);
    prec = (rsrc != null) ? rsrc.precedence: 0;
    for(int i = 1; i < q.size(); ++i) begin
      r = q.get(i);
      c_prec = (r != null) ? r.precedence: 0;
      if(c_prec > prec) begin
        rsrc = r;
        prec = c_prec;
      end
    end
    return rsrc;
  endfunction
  static function void sort_by_precedence(ref uvm_resource_types::rsrc_q_t q);
    uvm_resource_types::rsrc_sv_q_t all[int];
    uvm_resource_base r;
    int unsigned prec;
    for(int i=0; i<q.size(); ++i) begin
      r = q.get(i);
      prec = (r != null) ? r.precedence: 0;
      all[prec].push_front(r);
    end
    q.delete();
    foreach(all[aa_iter,q_iter]) begin
      q.push_front(all[aa_iter][q_iter]);
    end
  endfunction
  static function void sort_by_precedence_q(ref uvm_resource_types::rsrc_sv_q_t q);
    uvm_resource_types::rsrc_sv_q_t all[int];
    uvm_resource_base r;
    int unsigned prec;
    for(int i=0; i<q.size(); ++i) begin
      r = q[i];
      prec = (r != null) ? r.precedence: 0;
      all[prec].push_back(r);
    end
    q.delete();
    foreach(all[iter]) begin
      q = {q, all[iter]};
    end
  endfunction
  function uvm_resource_base get_by_name(string scope = "",
                                         string name,
                                         uvm_resource_base type_handle,
                                         bit rpterr = 1);
    uvm_resource_types::rsrc_sv_q_t svq;
    table_q_t rq;
    uvm_resource_base rsrc;
    string rsrcs;
    if (name == "") begin
      push_get_record(name, scope, null);
      return null;
    end
    if(!rtab.exists(name)) begin
      if(rpterr) begin
        void'(spell_check(name));
      end
      push_get_record(name, scope, null);
      return null;
    end
    rq = rtab[name];
    for (int iter=0; iter < rq.value.size(); iter++) begin
      uvm_resource_base rsrc_iter;
      rsrc_iter = rq.value[iter];
      if ((type_handle == null) || (type_handle == rsrc_iter.get_type_handle())) begin
        svq.push_back(rsrc_iter);
      end
    end
    sort_by_precedence_q(svq);
    foreach (svq[iter]) begin
      rsrc = svq[iter];
      rsrcs = (rsrc != null) ? rsrc.get_scope(): "";
      if (uvm_is_match(rsrcs, scope)) begin
        break;
      end
      else begin
        rsrc = null;
      end
    end
    push_get_record(name, scope, rsrc);
    return rsrc;
  endfunction
  function uvm_resource_types::rsrc_q_t lookup_type(string scope = "",
                                                    uvm_resource_base type_handle);
    uvm_resource_types::rsrc_q_t q = new();
    table_q_t rq;
    uvm_resource_base r;
    int unsigned i;
    if(type_handle == null || !ttab.exists(type_handle)) begin
      return q;
    end
    rq = ttab[type_handle];
    for (int iter=0; iter < rq.value.size(); iter++) begin
      uvm_resource_base rsrc_iter;
      rsrc_iter = rq.value[iter];
      if(rsrc_iter != null && uvm_is_match(rsrc_iter.get_scope(), scope)) begin
        q.push_back(rsrc_iter);
      end
    end
    return q;
  endfunction
  function uvm_resource_base get_by_type(string scope = "",
                                         uvm_resource_base type_handle);
    table_q_t rq;
    uvm_resource_base r;
    int unsigned i;
    if(type_handle == null || !ttab.exists(type_handle)) begin
      push_get_record("<type>", scope, null);
      return null;
    end
    rq = ttab[type_handle];
    for (int iter=0; iter < rq.value.size(); iter++) begin
      uvm_resource_base rsrc_iter;
      rsrc_iter = rq.value[iter];
      if(rsrc_iter != null && uvm_is_match(rsrc_iter.get_scope(), scope)) begin
        push_get_record("<type>", scope, rsrc_iter);
        return rsrc_iter;
      end
    end
    push_get_record("<type>", scope, null);
    return null;
  endfunction
  function uvm_resource_types::rsrc_q_t lookup_regex_names(string scope,
                                                           string name,
                                                           uvm_resource_base type_handle = null);
      return lookup_name(scope, name, type_handle, 0);
  endfunction
  function uvm_resource_types::rsrc_q_t lookup_regex(string re, scope);
    table_q_t rq;
    uvm_resource_types::rsrc_q_t result_q;
    int unsigned i;
    uvm_resource_base r;
    string s;
    result_q = new();
    foreach (rtab[name]) begin
      if ( ! uvm_is_match(re, name) ) begin
        continue;
      end
      rq = rtab[name];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        uvm_resource_base rsrc_iter;
        rsrc_iter = rq.value[iter];
        if(rsrc_iter != null && uvm_is_match(rsrc_iter.get_scope(), scope)) begin
          result_q.push_back(rsrc_iter);
        end
      end
    end
    return result_q;
  endfunction
  function uvm_resource_types::rsrc_q_t lookup_scope(string scope);
    table_q_t rq;
    uvm_resource_base r;
    int unsigned i;
    int unsigned err;
    uvm_resource_types::rsrc_q_t q = new();
    string name;
    if(rtab.last(name)) begin
      do begin
        rq = rtab[name];
        for (int iter=0; iter < rq.value.size(); iter++) begin
          uvm_resource_base rsrc_iter;
          rsrc_iter = rq.value[iter];
          if(rsrc_iter != null && uvm_is_match(rsrc_iter.get_scope(), scope)) begin
            q.push_back(rsrc_iter);
          end
        end
      end while(rtab.prev(name));
    end
    return q;
  endfunction
  local function void set_priority_queue(uvm_resource_base rsrc,
                                         table_q_t rq,
                                         uvm_resource_types::priority_e pri);
    uvm_resource_base r;
    int unsigned i;
    string msg;
    string name = rsrc.get_name();
    for (int iter=0; iter < rq.value.size(); iter++) begin
      r = rq.value[iter];
      if (r == rsrc) begin
        i = iter;
        break;
      end
    end
    if(r != rsrc) begin
      $sformat(msg, "Handle for resource named %s is not in the name table; cannot change its priority", name);
      uvm_report_error("NORSRC", msg);
      return;
    end
    rq.value.delete(i);
    case(pri)
      uvm_resource_types::PRI_HIGH: begin
        rq.value.push_front(rsrc);
      end
      uvm_resource_types::PRI_LOW: begin
        rq.value.push_back(rsrc);
      end
    endcase
 endfunction
  function void set_priority_type(uvm_resource_base rsrc,
                                  uvm_resource_types::priority_e pri);
    uvm_resource_base type_handle;
    string msg;
    table_q_t rq;
    if(rsrc == null) begin
      uvm_report_warning("NULLRASRC", "attempting to change the search priority of a null resource");
      return;
    end
    type_handle = rsrc.get_type_handle();
    if(!ttab.exists(type_handle)) begin
      $sformat(msg, "Type handle for resrouce named %s not found in type map; cannot change its search priority", rsrc.get_name());
      uvm_report_error("RNFTYPE", msg);
      return;
    end
    rq = ttab[type_handle];
    set_priority_queue(rsrc, rq, pri);
  endfunction
  function void set_priority_name(uvm_resource_base rsrc,
                                  uvm_resource_types::priority_e pri);
    string name;
    string msg;
    if(rsrc == null) begin
      uvm_report_warning("NULLRASRC", "attempting to change the search priority of a null resource");
      return;
    end
    name = rsrc.get_name();
    if(!rtab.exists(name)) begin
      $sformat(msg, "Resrouce named %s not found in name map; cannot change its search priority", name);
      uvm_report_error("RNFNAME", msg);
      return;
    end
    set_priority_queue(rsrc, rtab[name], pri);
  endfunction
  function void set_priority (uvm_resource_base rsrc,
                              uvm_resource_types::priority_e pri);
    set_priority_type(rsrc, pri);
    set_priority_name(rsrc, pri);
  endfunction
  static function void set_default_precedence( int unsigned precedence);
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    cs.set_resource_pool_default_precedence(precedence);
  endfunction
  static function int unsigned get_default_precedence();
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    return cs.get_resource_pool_default_precedence();
  endfunction
  virtual function void set_precedence(uvm_resource_base r,
                                       int unsigned p=uvm_resource_pool::get_default_precedence());
    table_q_t rq;
    string name;
    int unsigned i;
    uvm_resource_base rsrc;
    if(r == null) begin
      uvm_report_warning("NULLRASRC", "attempting to set precedence of a null resource");
      return;
    end
    name = r.get_name();
    if(rtab.exists(name)) begin
      rq = rtab[name];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        rsrc = rq.value[iter];
        if (rsrc == r) begin
          break;
        end
      end
    end
    if(r != rsrc) begin
      uvm_report_warning("NORSRC", $sformatf("resource named %s is not placed within the pool", name));
      return;
    end
    r.precedence = p;
  endfunction
  virtual function int unsigned get_precedence(uvm_resource_base r);
    table_q_t rq;
    string name;
    int unsigned i;
    uvm_resource_base rsrc;
    if(r == null) begin
      uvm_report_warning("NULLRASRC", "attempting to get precedence of a null resource");
      return uvm_resource_pool::get_default_precedence();
    end
    name = r.get_name();
    if(rtab.exists(name)) begin
      rq = rtab[name];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        rsrc = rq.value[iter];
        if(rsrc == r) begin
          break;
        end
      end
    end
    if(r != rsrc) begin
      uvm_report_warning("NORSRC", $sformatf("resource named %s is not placed within the pool", name));
      return uvm_resource_pool::get_default_precedence();
    end
    return r.precedence;
  endfunction
  function uvm_resource_types::rsrc_q_t find_unused_resources();
    table_q_t rq;
    uvm_resource_types::rsrc_q_t q = new;
    int unsigned i;
    uvm_resource_base r;
    uvm_resource_types::access_t a;
    int reads;
    int writes;
    foreach (rtab[name]) begin
      rq = rtab[name];
      for (int iter=0; iter < rq.value.size(); iter++) begin
        uvm_resource_base rsrc_iter;
        rsrc_iter = rq.value[iter];
        reads = 0;
        writes = 0;
        foreach(rsrc_iter.dbg.access[str]) begin
          a = rsrc_iter.dbg.access[str];
          reads += a.read_count;
          writes += a.write_count;
        end
        if(writes > 0 && reads == 0) begin
          q.push_back(rsrc_iter);
        end
      end
    end
    return q;
  endfunction
  function void m_print_resource_element(uvm_printer printer,
                                         int unsigned iter,
                                         uvm_resource_base r,
                                         bit audit=0);
    string scope;
    printer.push_element($sformatf("[%0d]", iter),
                         "uvm_resource",
                         "-",
                         "-");
    void'(get_scope(r, scope));
    printer.print_string("name", r.get_name());
    printer.print_generic_element("value",
                                  r.m_value_type_name(),
                                  "",
                                  r.m_value_as_string());
    printer.print_string("scope", scope);
    printer.print_field_int("precedence", get_precedence(r), 32, UVM_UNSIGNED);
    if (audit && (r.dbg!=null)) begin
      if (r.dbg.access.size()) begin
        printer.print_array_header("accesses",
                                   r.dbg.access.size(),
                                   "queue");
        foreach(r.dbg.access[i]) begin
          printer.print_string($sformatf("[%s]", i),
                               $sformatf("reads: %0d @ %0t  writes: %0d @ %0t",
                                         r.dbg.access[i].read_count,
                                         r.dbg.access[i].read_time,
                                         r.dbg.access[i].write_count,
                                         r.dbg.access[i].write_time));
        end
        printer.print_array_footer(r.dbg.access.size());
      end
    end
    printer.pop_element();
  endfunction : m_print_resource_element
  function void m_print_resources(uvm_printer printer,
                                  string name,
                                  table_q_t rq,
                                  bit audit = 0);
    printer.push_element(name,
                         "uvm_shared#(uvm_resource_base[$])",
                         $sformatf("%0d", rq.value.size()));
    for (int iter=0; iter < rq.value.size(); iter++) begin
      m_print_resource_element(printer, iter, rq.value[iter], audit);
    end
    printer.pop_element();
  endfunction : m_print_resources
  function void print_resources(uvm_resource_types::rsrc_q_t rq, bit audit = 0);
    int unsigned i;
    string id;
    static uvm_tree_printer printer = new();
    printer.flush();
    if (rq == null) begin
      printer.print_generic_element("",
                                    "uvm_queue#(uvm_resource_base)",
                                    "",
                                    "<null>");
    end
    else begin
      printer.push_element(rq.get_name(),
                           "uvm_queue#(uvm_resource_base)",
                           $sformatf("%0d",rq.size()),
                           uvm_object_value_str(rq));
      for (int i = 0; i < rq.size(); i++) begin
        m_print_resource_element(printer, i, rq.get(i), audit);
      end
      printer.pop_element();
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/RESOURCE_POOL/PRINT_QUEUE") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/RESOURCE_POOL/PRINT_QUEUE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/RESOURCE_POOL/PRINT_QUEUE", printer.emit(), UVM_NONE, "t/uvm/src/base/uvm_resource_pool.svh", 1292, "", 1);
     end
   end
  endfunction
  function void dump(bit audit = 0, uvm_printer printer = null);
    string name;
    static uvm_tree_printer m_printer;
    if (m_printer == null) begin
      m_printer = new();
      m_printer.set_type_name_enabled(1);
    end
    if (printer == null) begin
      printer = m_printer;
    end
    printer.flush();
    printer.push_element("uvm_resource_pool",
                         "",
                         $sformatf("%0d",rtab.size()),
                         "");
    foreach (rtab[name]) begin
      m_print_resources(printer, name, rtab[name], audit);
    end
    printer.pop_element();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/RESOURCE/DUMP") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/RESOURCE/DUMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/RESOURCE/DUMP", printer.emit(), UVM_NONE, "t/uvm/src/base/uvm_resource_pool.svh", 1332, "", 1);
     end
   end
  endfunction
endclass
 `undef M__TABLE_Q
 `undef M__TABLE_GET
 `undef M__TABLE_NAME
class uvm_resource #(type T=int) extends uvm_resource_base;
  typedef uvm_resource#(T) this_type;
  static this_type my_type = get_type();
  protected T val;
  typedef uvm_object_registry#(this_type) type_id;
  virtual function uvm_object_wrapper get_object_type();
    return type_id::get();
  endfunction : get_object_type
  virtual function uvm_object create (string name="");
    this_type tmp;
    if (name=="") begin
      tmp = new();
    end
    else begin
      tmp = new(name);
    end
    return tmp;
  endfunction : create
     static function string type_name();
       return $sformatf("uvm_resource#(%s)", $typename(T));
     endfunction : type_name
     virtual function string get_type_name();
       return $sformatf("uvm_resource#(%s)", $typename(T));
     endfunction : get_type_name
  function new(string name="", string scope="<not provided>");
    super.new(name,scope);
  endfunction
  virtual function string m_value_type_name();
    return $typename(T);
  endfunction : m_value_type_name
  virtual function string m_value_as_string();
    return $sformatf("%p", val);
  endfunction : m_value_as_string
  static function this_type get_type();
    if(my_type == null) begin
      my_type = new();
    end
    return my_type;
  endfunction
  function uvm_resource_base get_type_handle();
    return get_type();
  endfunction
  function T read(uvm_object accessor = null);
    return do_read(accessor);
  endfunction
  virtual function T do_read(uvm_object accessor);
    if (uvm_resource_options::is_auditing()) begin
      record_read_access(accessor);
    end
    return val;
  endfunction : do_read
  function void write(T t, uvm_object accessor = null);
    do_write(t, accessor);
  endfunction
  virtual function void do_write(T t, uvm_object accessor);
    if(is_read_only()) begin
      uvm_report_error("resource", $sformatf("resource %s is read only -- cannot modify", get_name()));
      return;
    end
    if(val == t) begin
      return;
    end
    if (uvm_resource_options::is_auditing()) begin
      record_write_access(accessor);
    end
    val = t;
    modified = 1;
  endfunction : do_write
  static function this_type get_highest_precedence(ref uvm_resource_types::rsrc_q_t q);
    this_type rsrc;
    this_type r;
    uvm_resource_types::rsrc_q_t tq;
    uvm_resource_base rb;
    uvm_resource_pool rp = uvm_resource_pool::get();
    if(q.size() == 0) begin
      return null;
    end
    tq = new();
    rsrc = null;
    for(int i = 0; i < q.size(); ++i) begin
      if($cast(r, q.get(i))) begin
        tq.push_back(r) ;
      end
    end
    rb = rp.get_highest_precedence(tq);
    if (!$cast(rsrc, rb)) begin
      return null;
    end
    return rsrc;
  endfunction
  function void set_priority (uvm_resource_types::priority_e pri);
    uvm_resource_pool rp = uvm_resource_pool::get();
    rp.set_priority(this, pri);
  endfunction
  static function this_type get_by_name(string scope,
                                        string name,
                                        bit rpterr = 1);
    uvm_resource_pool rp = uvm_resource_pool::get();
    uvm_resource_base rsrc_base;
    this_type rsrc;
    string msg;
    rsrc_base = rp.get_by_name(scope, name, my_type, rpterr);
    if(rsrc_base == null)
      return null;
    if(!$cast(rsrc, rsrc_base)) begin
      if(rpterr) begin
        $sformat(msg, "Resource with name %s in scope %s has incorrect type", name, scope);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "RSRCTYPE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "RSRCTYPE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("RSRCTYPE", msg, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_resource.svh", 290, "", 1);
     end
   end;
      end
      return null;
    end
    return rsrc;
  endfunction
  static function this_type get_by_type(string scope = "",
                                        uvm_resource_base type_handle);
    uvm_resource_pool rp = uvm_resource_pool::get();
    uvm_resource_base rsrc_base;
    this_type rsrc;
    string msg;
    if(type_handle == null)
      return null;
    rsrc_base = rp.get_by_type(scope, type_handle);
    if(rsrc_base == null)
      return null;
    if(!$cast(rsrc, rsrc_base)) begin
      $sformat(msg, "Resource with specified type handle in scope %s was not located", scope);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "RSRCNF") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "RSRCNF") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("RSRCNF", msg, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_resource.svh", 317, "", 1);
     end
   end;
      return null;
    end
    return rsrc;
  endfunction
endclass
`define UVM_RESOURCE_GET_FCNS(base_type) \
  static function this_subtype get_by_name(string scope, string name, bit rpterr = 1); \
    this_subtype t;                                                                    \
    uvm_resource_base b = uvm_resource#(base_type)::get_by_name(scope, name, rpterr);  \
    if(!$cast(t, b))                                                                   \
      `uvm_fatal("BADCAST", "cannot cast resource to resource subtype")               \
    return t;                                                                          \
  endfunction                                                                          \
                                                                                       \
  static function this_subtype get_by_type(string scope = "", \
                                           uvm_resource_base type_handle);             \
    this_subtype t;                                                                    \
    uvm_resource_base b = uvm_resource#(base_type)::get_by_type(scope, type_handle);   \
    if(!$cast(t, b))                                                                   \
      `uvm_fatal("BADCAST", "cannot cast resource to resource subtype")               \
    return t;                                                                          \
  endfunction
class uvm_int_rsrc extends uvm_resource #(int);
  typedef uvm_int_rsrc this_subtype;
  function new(string name, string s = "*");
    uvm_resource_pool rp;
    super.new(name);
    rp = uvm_resource_pool::get();
    rp.set_scope(this, s);
  endfunction
  function string convert2string();
    string s;
    $sformat(s, "%0d", read());
    return s;
  endfunction
endclass
class uvm_string_rsrc extends uvm_resource #(string);
  typedef uvm_string_rsrc this_subtype;
  function new(string name, string s = "*");
    uvm_resource_pool rp;
    super.new(name);
    rp = uvm_resource_pool::get();
    rp.set_scope(this, s);
  endfunction
  function string convert2string();
    return read();
  endfunction
endclass
class uvm_obj_rsrc extends uvm_resource #(uvm_object);
  typedef uvm_obj_rsrc this_subtype;
  function new(string name, string s = "*");
    uvm_resource_pool rp;
    super.new(name);
    rp = uvm_resource_pool::get();
    rp.set_scope(this, s);
  endfunction
endclass
class uvm_bit_rsrc #(int unsigned N=1) extends uvm_resource #(bit[N-1:0]);
  typedef uvm_bit_rsrc#(N) this_subtype;
  function new(string name, string s = "*");
    uvm_resource_pool rp;
    super.new(name);
    rp = uvm_resource_pool::get();
    rp.set_scope(this, s);
  endfunction
  function string convert2string();
    string s;
    $sformat(s, "%0b", read());
    return s;
  endfunction
endclass
class uvm_byte_rsrc #(int unsigned N=1) extends uvm_resource #(bit[7:0][N-1:0]);
  typedef uvm_byte_rsrc#(N) this_subtype;
  function new(string name, string s = "*");
    uvm_resource_pool rp;
    super.new(name);
    rp = uvm_resource_pool::get();
    rp.set_scope(this, s);
  endfunction
  function string convert2string();
    string s;
    $sformat(s, "%0x", read());
    return s;
  endfunction
endclass
typedef class uvm_resource_db_options;
typedef class uvm_cmdline_processor;
typedef class uvm_resource_db_default_implementation_t;
virtual class uvm_resource_db_implementation_t #(type T=uvm_object) extends uvm_object;
    typedef uvm_resource #(T) rsrc_t;
   typedef uvm_abstract_object_registry #(uvm_resource_db_implementation_t #(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
    local static uvm_resource_db_implementation_t #(T) m_rsrc_db_imp;
    static function void set_imp(uvm_resource_db_implementation_t #(T) imp = null);
      if (imp == null)
        begin
          uvm_coreservice_t cs = uvm_coreservice_t::get();
          uvm_factory factory = cs.get_factory();
          if (factory.find_override_by_type(uvm_resource_db_implementation_t#(T)::get_type(),"") == uvm_resource_db_implementation_t#(T)::get_type())
          begin
            imp = uvm_resource_db_default_implementation_t #(T)::type_id::create();
          end
          else
          begin
            imp = uvm_resource_db_implementation_t #(T)::type_id::create();
          end
        end
      m_rsrc_db_imp = imp;
    endfunction : set_imp
    static function uvm_resource_db_implementation_t #(T) get_imp ();
        if (m_rsrc_db_imp == null)
          begin
            set_imp();
          end
        return m_rsrc_db_imp;
    endfunction : get_imp
    pure virtual function rsrc_t get_by_type(string scope);
    pure virtual function rsrc_t get_by_name(string scope,
                                             string name,
                                             bit    rpterr);
    pure virtual function rsrc_t set_default(string scope, string name);
    pure virtual function void show_msg(string id,
                                        string rtype,
                                        string action,
                                        string scope,
                                        string name,
                                        uvm_object accessor,
                                        rsrc_t rsrc);
    pure virtual function void set(string scope,
                                   string name,
                                   T val,
                                   uvm_object accessor);
    pure virtual function void set_anonymous(string scope,
                                             T val,
                                             uvm_object accessor);
    pure virtual function void set_override(string scope,
                                            string name,
                                            T val,
                                            uvm_object accessor);
    pure virtual function void set_override_type(string scope,
                                                 string name,
                                                 T val,
                                                 uvm_object accessor);
    pure virtual function void set_override_name(string scope,
                                                 string name,
                                                 T val,
                                                 uvm_object accessor);
    pure virtual function bit read_by_name(string scope,
                                           string name,
                                           inout T val,
                                           input uvm_object accessor);
    pure virtual function bit read_by_type(string scope,
                                           inout T val,
                                           input uvm_object accessor);
    pure virtual function bit write_by_name(string scope,
                                            string name,
                                            T val,
                                            uvm_object accessor);
    pure virtual function bit write_by_type(string scope,
                                            T val,
                                            uvm_object accessor);
endclass
class uvm_resource_db_default_implementation_t #(type T=uvm_object) extends uvm_resource_db_implementation_t #(T);
    typedef uvm_resource #(T) rsrc_t;
   typedef uvm_object_registry #(uvm_resource_db_default_implementation_t #(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_resource_db_default_implementation_t #(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
    function new(string name = "uvm_resource_db_default_implementation_t");
        super.new();
    endfunction : new
    virtual function rsrc_t get_by_type(string scope);
      uvm_resource_pool rp = uvm_resource_pool::get();
      uvm_resource_base rsrc_base;
      rsrc_t rsrc;
      string msg;
      uvm_resource_base type_handle = rsrc_t::get_type();
      if(type_handle == null)
        begin
          return null;
        end
      rsrc_base = rp.get_by_type(scope, type_handle);
      if(!$cast(rsrc, rsrc_base))
        begin
          $sformat(msg, "Resource with specified type handle in scope %s was not located", scope);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "RSRCNF") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "RSRCNF") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("RSRCNF", msg, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_resource_db_implementation.svh", 246, "", 1);
     end
   end
          return null;
        end
      return rsrc;
    endfunction : get_by_type
    virtual function rsrc_t get_by_name(string scope,
                                        string name,
                                        bit    rpterr);
      uvm_resource_pool rp = uvm_resource_pool::get();
      uvm_resource_base rsrc_base;
      rsrc_t rsrc;
      string msg;
      rsrc_base = rp.get_by_name(scope, name, rsrc_t::get_type(), rpterr);
      if(rsrc_base == null)
        begin
          return null;
        end
      if(!$cast(rsrc, rsrc_base))
        begin
          if(rpterr)
          begin
            $sformat(msg, "Resource with name %s in scope %s has incorrect type", name, scope);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "RSRCTYPE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "RSRCTYPE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("RSRCTYPE", msg, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_resource_db_implementation.svh", 280, "", 1);
     end
   end
          end
          return null;
        end
      return rsrc;
    endfunction : get_by_name
    virtual function rsrc_t set_default(string scope, string name);
      rsrc_t r;
      uvm_resource_pool rp = uvm_resource_pool::get();
      r = new(name);
      rp.set_scope(r, scope);
      return r;
    endfunction : set_default
    virtual function void show_msg(string id,
                                   string rtype,
                                   string action,
                                   string scope,
                                   string name,
                                   uvm_object accessor,
                                   rsrc_t rsrc);
        T foo;
        string msg=$typename(foo);
        $sformat(msg, "%s scope='%s' name='%s' (type %s) %s accessor=%s = %s",
                 rtype,scope,name, msg,action,
                 (accessor != null) ? accessor.get_full_name() : "<unknown>",
                 rsrc==null?"null (failed lookup)":rsrc.convert2string());
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, id) >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, id) != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info(id, msg, UVM_LOW, "t/uvm/src/base/uvm_resource_db_implementation.svh", 323, "", 1);
     end
   end
    endfunction : show_msg
    virtual function void set(string scope,
                              string name,
                              T val,
                              uvm_object accessor);
      uvm_resource_pool rp = uvm_resource_pool::get();
      rsrc_t rsrc = new(name);
      rsrc.write(val, accessor);
      rp.set_scope(rsrc, scope);
      if(uvm_resource_db_options::is_tracing())
        begin
          show_msg("RSRCDB/SET", "Resource","set", scope, name, accessor, rsrc);
        end
    endfunction : set
    virtual function void set_anonymous(string scope,
                                        T val,
                                        uvm_object accessor);
      uvm_resource_pool rp = uvm_resource_pool::get();
      rsrc_t rsrc = new("");
      rsrc.write(val, accessor);
      rp.set_scope(rsrc, scope);
      if(uvm_resource_db_options::is_tracing())
        begin
          show_msg("RSRCDB/SETANON","Resource", "set", scope, "", accessor, rsrc);
        end
    endfunction : set_anonymous
    virtual function void set_override(string scope,
                                       string name,
                                       T val,
                                       uvm_object accessor);
      uvm_resource_pool rp = uvm_resource_pool::get();
      rsrc_t rsrc = new(name);
      rsrc.write(val, accessor);
      rp.set_override(rsrc, scope);
      if(uvm_resource_db_options::is_tracing())
        begin
          show_msg("RSRCDB/SETOVRD", "Resource","set", scope, name, accessor, rsrc);
        end
    endfunction : set_override
    virtual function void set_override_type(string scope,
                                            string name,
                                            T val,
                                            uvm_object accessor);
      uvm_resource_pool rp = uvm_resource_pool::get();
      rsrc_t rsrc = new(name);
      rsrc.write(val, accessor);
      rp.set_type_override(rsrc, scope);
      if(uvm_resource_db_options::is_tracing())
        begin
          show_msg("RSRCDB/SETOVRDTYP","Resource", "set", scope, name, accessor, rsrc);
        end
    endfunction : set_override_type
    virtual function void set_override_name(string scope,
                                                           string name,
                                                           T val,
                                                           uvm_object accessor);
      uvm_resource_pool rp = uvm_resource_pool::get();
      rsrc_t rsrc = new(name);
      rsrc.write(val, accessor);
      rp.set_name_override(rsrc, scope);
      if(uvm_resource_db_options::is_tracing())
        begin
          show_msg("RSRCDB/SETOVRDNAM","Resource", "set", scope, name, accessor, rsrc);
        end
    endfunction : set_override_name
    virtual function bit read_by_name(string scope,
                                      string name,
                                      inout T val,
                                      input uvm_object accessor);
        rsrc_t rsrc = get_by_name(scope, name, 1);
        if(uvm_resource_db_options::is_tracing())
          begin
            show_msg("RSRCDB/RDBYNAM","Resource", "read", scope, name, accessor, rsrc);
          end
        if(rsrc == null)
          begin
            return 0;
          end
        val = rsrc.read(accessor);
        return 1;
    endfunction : read_by_name
    virtual function bit read_by_type(input string scope,
                                      inout T val,
                                      input uvm_object accessor);
        rsrc_t rsrc = get_by_type(scope);
        if(uvm_resource_db_options::is_tracing())
          begin
            show_msg("RSRCDB/RDBYTYP", "Resource","read", scope, "", accessor, rsrc);
          end
        if(rsrc == null)
          begin
            return 0;
          end
        val = rsrc.read(accessor);
        return 1;
    endfunction : read_by_type
    virtual function bit write_by_name(string scope,
                                                      string name,
                                                      T val,
                                                      uvm_object accessor);
        rsrc_t rsrc = get_by_name(scope, name, 1);
        if(uvm_resource_db_options::is_tracing())
          begin
            show_msg("RSRCDB/WR","Resource", "written", scope, name, accessor, rsrc);
          end
        if(rsrc == null)
          begin
            return 0;
          end
        rsrc.write(val, accessor);
        return 1;
    endfunction : write_by_name
    virtual function bit write_by_type(string scope,
                                                      T val,
                                                      uvm_object accessor);
        rsrc_t rsrc = get_by_type(scope);
        if(uvm_resource_db_options::is_tracing())
          begin
            show_msg("RSRCDB/WRTYP", "Resource","written", scope, "", accessor, rsrc);
          end
        if(rsrc == null)
          begin
            return 0;
          end
        rsrc.write(val, accessor);
        return 1;
    endfunction : write_by_type
endclass
class uvm_resource_db #(type T=uvm_object) extends uvm_void;
  typedef uvm_resource #(T) rsrc_t;
  protected function new();
  endfunction
  static function rsrc_t get_by_type(string scope);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    return imp.get_by_type(scope);
  endfunction
  static function rsrc_t get_by_name(string scope,
                                     string name,
                                     bit rpterr=1);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    return imp.get_by_name(scope, name, rpterr);
  endfunction
  static function rsrc_t set_default(string scope, string name);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    return imp.set_default(scope, name);
  endfunction
  static function void set(input string scope, input string name,
                           T val, input uvm_object accessor = null);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    imp.set(scope, name, val, accessor);
  endfunction
  static function void set_anonymous(input string scope,
                                     T val, input uvm_object accessor = null);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    imp.set_anonymous(scope, val, accessor);
  endfunction
  static function void set_override(input string scope, input string name,
                                    T val, uvm_object accessor = null);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    imp.set_override(scope, name, val, accessor);
  endfunction
  static function void set_override_type(input string scope, input string name,
                                         T val, uvm_object accessor = null);
    uvm_resource_db_implementation_t #(T) imp;
    imp = uvm_resource_db_implementation_t #(T)::get_imp();
    imp.set_override_type(scope, name, val, accessor);
  endfunction
  static function void set_override_name(input string scope, input string name,
                                  T val, uvm_object accessor = null);
     uvm_resource_db_implementation_t #(T) imp;
     imp = uvm_resource_db_implementation_t #(T)::get_imp();
     imp.set_override_name(scope, name, val, accessor);
  endfunction
  static function bit read_by_name(input string scope,
                                   input string name,
                                   inout T val, input uvm_object accessor = null);
     uvm_resource_db_implementation_t #(T) imp;
     imp = uvm_resource_db_implementation_t #(T)::get_imp();
     return imp.read_by_name(scope, name, val, accessor);
  endfunction
  static function bit read_by_type(input string scope,
                                   inout T val,
                                   input uvm_object accessor = null);
     uvm_resource_db_implementation_t #(T) imp;
     imp = uvm_resource_db_implementation_t #(T)::get_imp();
     return imp.read_by_type(scope, val, accessor);
  endfunction
  static function bit write_by_name(input string scope, input string name,
                                    input T val, input uvm_object accessor = null);
     uvm_resource_db_implementation_t #(T) imp;
     imp = uvm_resource_db_implementation_t #(T)::get_imp();
     return imp.write_by_name(scope, name, val, accessor);
  endfunction
  static function bit write_by_type(input string scope,
                                    input T val, input uvm_object accessor = null);
     uvm_resource_db_implementation_t #(T) imp;
     imp = uvm_resource_db_implementation_t #(T)::get_imp();
     return imp.write_by_type(scope, val, accessor);
  endfunction
  static function void dump();
    uvm_resource_pool rp = uvm_resource_pool::get();
    rp.dump();
  endfunction
endclass
class uvm_resource_db_options;
  static local bit ready;
  static local bit tracing;
  static function void turn_on_tracing();
     if (!ready) begin
       init();
     end
    tracing = 1;
  endfunction
  static function void turn_off_tracing();
     if (!ready) begin
       init();
     end
    tracing = 0;
  endfunction
  static function bit is_tracing();
    if (!ready) begin
      init();
    end
    return tracing;
  endfunction
  static local function void init();
     uvm_cmdline_processor clp;
     string trace_args[$];
     clp = uvm_cmdline_processor::get_inst();
     if (clp.get_arg_matches("+UVM_RESOURCE_DB_TRACE", trace_args)) begin
       tracing = 1;
     end
     ready = 1;
  endfunction
endclass
typedef class uvm_phase;
class m_uvm_waiter;
  string inst_name;
  string field_name;
  event trigger;
  function new (string inst_name, string field_name);
    this.inst_name = inst_name;
    this.field_name = field_name;
  endfunction
endclass
typedef class uvm_root;
typedef class uvm_config_db_options;
typedef class uvm_config_db_default_implementation_t;
virtual class uvm_config_db_implementation_t #(type T=int) extends uvm_object;
   typedef uvm_resource #(T) rsrc_t;
   typedef uvm_abstract_object_registry #(uvm_config_db_implementation_t #(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   local static uvm_config_db_implementation_t #(T) m_config_db_imp;
   static function void set_imp(uvm_config_db_implementation_t #(T) imp = null);
      if (imp == null)
        begin
          uvm_coreservice_t cs = uvm_coreservice_t::get();
          uvm_factory factory = cs.get_factory();
          if (factory.find_override_by_type(uvm_config_db_implementation_t#(T)::get_type(),"") == uvm_config_db_implementation_t#(T)::get_type())
          begin
            imp = uvm_config_db_default_implementation_t #(T)::type_id::create();
          end
          else
          begin
            imp = uvm_config_db_implementation_t #(T)::type_id::create();
          end
        end
      m_config_db_imp = imp ;
   endfunction : set_imp
   static function uvm_config_db_implementation_t #(T) get_imp();
      if (m_config_db_imp == null)
        begin
          set_imp();
        end
      return m_config_db_imp;
   endfunction : get_imp
   pure virtual function bit get (uvm_component     cntxt,
                                        string            inst_name,
                                        string            field_name,
                                        inout T           value);
   pure virtual function void set(string                              cntxt_name,
                                        string                              inst_name,
                                        string                              field_name,
                                        T                                   value,
                                        int                                 cntxt_depth,
                                        uvm_pool#(string, uvm_resource#(T)) pool,
                                        uvm_component                       cntxt);
   pure virtual function bit exists(uvm_component cntxt,
                                    string        inst_name,
                                    string        field_name,
                                    bit           rpterr);
   pure virtual task wait_modified(uvm_component cntxt,
                                   string inst_name,
                                   string field_name);
   pure virtual function void trigger_modified(string inst_name,
                                               string field_name);
   pure virtual function void show_msg(string id,
                                       string rtype,
                                       string action,
                                       string scope,
                                       string name,
                                       uvm_object accessor,
                                       rsrc_t rsrc);
endclass
class uvm_config_db_default_implementation_t #(type T=int) extends uvm_config_db_implementation_t#(T);
  function new (string name = "uvm_config_db_default_implementation");
     super.new();
  endfunction : new
   typedef uvm_object_registry #(uvm_config_db_default_implementation_t #(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_config_db_default_implementation_t #(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
  virtual function bit get (uvm_component     cntxt,
                                  string            inst_name,
                                  string            field_name,
                                  inout T           value);
    uvm_resource#(T) r;
    uvm_resource_pool rp = uvm_resource_pool::get();
    uvm_resource_types::rsrc_q_t rq;
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    if(cntxt == null)
      begin
        cntxt = cs.get_root();
      end
    if(inst_name == "")
      begin
        inst_name = cntxt.get_full_name();
      end
    else if(cntxt.get_full_name() != "")
      begin
        inst_name = {cntxt.get_full_name(), ".", inst_name};
      end
    rq = rp.lookup_name(inst_name, field_name, uvm_resource#(T)::get_type(), 0);
    r = uvm_resource#(T)::get_highest_precedence(rq);
    if(uvm_config_db_options::is_tracing())
      begin
        show_msg("CFGDB/GET", "Configuration","read", inst_name, field_name, cntxt, r);
      end
    if(r == null)
      begin
        return 0;
      end
    value = r.read(cntxt);
    return 1;
  endfunction : get
  static local uvm_queue#(m_uvm_waiter) m_waiters[string];
  virtual task wait_modified(uvm_component cntxt, string inst_name,
                                              string field_name);
    process p = process::self();
    string rstate;
    m_uvm_waiter waiter;
    uvm_coreservice_t cs;
    if (p != null)
      begin
        rstate = p.get_randstate();
      end
    cs = uvm_coreservice_t::get();
    if(cntxt == null)
      begin
        cntxt = cs.get_root();
      end
    if(cntxt != cs.get_root())
      begin
        if(inst_name != "")
        begin
          inst_name = {cntxt.get_full_name(),".",inst_name};
        end
        else
        begin
          inst_name = cntxt.get_full_name();
        end
      end
    waiter = new(inst_name, field_name);
    if(!m_waiters.exists(field_name))
      begin
        m_waiters[field_name] = new;
      end
    m_waiters[field_name].push_back(waiter);
    if (p != null)
      begin
        p.set_randstate(rstate);
      end
    @waiter.trigger;
    for(int i=0; i<m_waiters[field_name].size(); ++i)
      begin
        if(m_waiters[field_name].get(i) == waiter)
        begin
          m_waiters[field_name].delete(i);
          break;
        end
      end
  endtask : wait_modified
  virtual function void trigger_modified(string inst_name,
                                         string field_name);
    if(m_waiters.exists(field_name))
      begin
        m_uvm_waiter w;
        for(int i=0; i<m_waiters[field_name].size(); ++i)
        begin
          w = m_waiters[field_name].get(i);
          if(uvm_is_match(inst_name,w.inst_name) )
            begin
              ->w.trigger;
            end
        end
      end
  endfunction : trigger_modified
  virtual function void set(string                              cntxt_name,
                                  string                              inst_name,
                                  string                              field_name,
                                  T                                   value,
                                  int                                 cntxt_depth,
                                  uvm_pool#(string, uvm_resource#(T)) pool,
                                  uvm_component                       cntxt);
    uvm_root top;
    uvm_phase curr_phase;
    uvm_resource#(T) r;
    string lookup;
    string rstate;
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_resource_pool rp = cs.get_resource_pool();
    int unsigned precedence;
    process p = process::self();
    if (p != null)
      begin
        rstate = p.get_randstate();
      end
    top = cs.get_root();
    curr_phase = top.m_current_phase;
    if (cntxt == null)
      begin
        cntxt = top;
      end
    if (inst_name == "")
      begin
        inst_name = cntxt.get_full_name();
      end
    else if(cntxt.get_full_name() != "")
      begin
        string slash_or_blank = "" ;
        string close_or_blank = "" ;
        string separator = "." ;
        if (inst_name[0] == "/" && inst_name.len()>2 && inst_name[inst_name.len()-1] == "/")
          begin
            slash_or_blank = "/";
            close_or_blank = ")/" ;
            separator = "\.(" ;
            inst_name = inst_name.substr(1,inst_name.len()-2);
          end
        inst_name = {slash_or_blank,
                   cntxt.get_full_name(),
                   separator,
                   inst_name,
                   close_or_blank};
      end
    lookup = {inst_name, "__M_UVM__", field_name};
    if(!pool.exists(lookup))
      begin
        r = new(field_name);
        rp.set_scope(r, inst_name);
        pool.add(lookup, r);
      end
    else
      begin
        r = pool.get(lookup);
      end
    if(curr_phase != null && curr_phase.get_name() == "build")
      begin
        precedence = cs.get_resource_pool_default_precedence() - (cntxt.get_depth());
      end
    else
      begin
        precedence = cs.get_resource_pool_default_precedence();
      end
    rp.set_precedence(r, precedence);
    r.write(value, cntxt);
    rp.set_priority_name(r, uvm_resource_types::PRI_HIGH);
    trigger_modified(inst_name, field_name);
    if (p != null)
      begin
        p.set_randstate(rstate);
      end
    if(uvm_config_db_options::is_tracing())
      begin
        show_msg("CFGDB/SET", "Configuration","set", inst_name, field_name, cntxt, r);
      end
  endfunction : set
  virtual function bit exists(uvm_component cntxt,
                                               string        inst_name,
                                               string        field_name,
                                               bit           rpterr);
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    if(cntxt == null)
      begin
        cntxt = cs.get_root();
      end
    if(inst_name == "")
      begin
        inst_name = cntxt.get_full_name();
      end
    else if(cntxt.get_full_name() != "")
      begin
        inst_name = {cntxt.get_full_name(), ".", inst_name};
      end
    return (uvm_resource_db#(T)::get_by_name(inst_name,field_name,rpterr) != null);
  endfunction : exists
  virtual function void show_msg(string id,
                                 string rtype,
                                 string action,
                                 string scope,
                                 string name,
                                 uvm_object accessor,
                                 rsrc_t rsrc);
      T foo;
      string msg=$typename(foo);
      $sformat(msg, "%s scope='%s' name='%s' (type %s) %s accessor=%s = %s",
               rtype,scope,name, msg,action,
               (accessor != null) ? accessor.get_full_name() : "<unknown>",
               rsrc==null?"null (failed lookup)":rsrc.convert2string());
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, id) >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, id) != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info(id, msg, UVM_LOW, "t/uvm/src/base/uvm_config_db_implementation.svh", 485, "", 1);
     end
   end
  endfunction : show_msg
endclass : uvm_config_db_default_implementation_t
typedef class uvm_phase;
typedef class uvm_config_db_options;
class uvm_config_db#(type T=int) extends uvm_resource_db#(T);
  static uvm_pool#(string,uvm_resource#(T)) m_rsc[uvm_component];
  static function bit get(uvm_component cntxt,
                          string inst_name,
                          string field_name,
                          inout T value);
    uvm_config_db_implementation_t #(T) imp;
    imp = uvm_config_db_implementation_t #(T)::get_imp();
    return imp.get(cntxt, inst_name, field_name, value);
  endfunction
  static function void set(uvm_component cntxt,
                           string inst_name,
                           string field_name,
                           T value);
    uvm_pool#(string,uvm_resource#(T)) pool;
    uvm_config_db_implementation_t #(T) imp;
    uvm_coreservice_t cs ;
    imp = uvm_config_db_implementation_t #(T)::get_imp();
    cs = uvm_coreservice_t::get();
    if(cntxt == null) begin
      cntxt = cs.get_root();
    end
    if(!m_rsc.exists(cntxt)) begin
      m_rsc[cntxt] = new;
    end
    pool = m_rsc[cntxt];
    imp.set(cntxt.get_full_name(), inst_name, field_name, value, cntxt.get_depth(), pool, cntxt);
  endfunction
  static function bit exists(uvm_component cntxt, string inst_name,
                             string field_name, bit spell_chk=0);
    uvm_config_db_implementation_t #(T) imp;
    imp = uvm_config_db_implementation_t #(T)::get_imp();
    return imp.exists(cntxt, inst_name, field_name, spell_chk);
  endfunction
  static task wait_modified(uvm_component cntxt, string inst_name,
                            string field_name);
    uvm_config_db_implementation_t #(T) imp;
    imp = uvm_config_db_implementation_t #(T)::get_imp();
    imp.wait_modified(cntxt, inst_name, field_name);
  endtask
endclass
typedef uvm_config_db#(uvm_bitstream_t) uvm_config_int   ;
typedef uvm_config_db#(string) uvm_config_string   ;
typedef uvm_config_db#(uvm_object) uvm_config_object   ;
typedef uvm_config_db#(uvm_object_wrapper) uvm_config_wrapper   ;
class uvm_config_db_options;
  static local bit ready;
  static local bit tracing;
  static function void turn_on_tracing();
     if (!ready) begin
       init();
     end
    tracing = 1;
  endfunction
  static function void turn_off_tracing();
     if (!ready) begin
       init();
     end
    tracing = 0;
  endfunction
  static function bit is_tracing();
    if (!ready) begin
      init();
    end
    return tracing;
  endfunction
  static local function void init();
     uvm_cmdline_processor clp;
     string trace_args[$];
     clp = uvm_cmdline_processor::get_inst();
     if (clp.get_arg_matches("+UVM_CONFIG_DB_TRACE", trace_args)) begin
       tracing = 1;
     end
     ready = 1;
  endfunction
endclass
typedef class uvm_root;
virtual class uvm_policy extends uvm_object;
typedef enum {
        NEVER,
        STARTED,
        FINISHED
} recursion_state_e;
local uvm_object  m_extensions[uvm_object_wrapper];
local uvm_object m_policy_stack[$];
function new (string name="");
    super.new(name);
endfunction
virtual function void flush();
    m_policy_stack.delete();
endfunction
virtual function bit extension_exists( uvm_object_wrapper ext_type );
    if (m_extensions.exists(ext_type)) begin
      extension_exists = 1;
    end
   else begin
     extension_exists = 0;
   end
endfunction
virtual function uvm_object set_extension( uvm_object extension );
uvm_object m_set_extension;
     if ( extension  == null) begin
       uvm_report_fatal("NULLEXT", "Attempting to set  null extension ", UVM_NONE);
     end
    if(m_extensions.exists(extension.get_object_type())) begin
      m_set_extension = m_extensions[extension.get_object_type()] ;
      m_extensions[extension.get_object_type()] = extension;
      return m_set_extension;
    end
    else  begin
      m_extensions[extension.get_object_type()] = extension;
      return null;
    end
endfunction
virtual function uvm_object get_extension(uvm_object_wrapper ext_type );
    if (m_extensions.exists(ext_type)) begin
      return m_extensions[ext_type];
    end
   else begin
     return null;
   end
endfunction
virtual function void clear_extension( uvm_object_wrapper ext_type );
    m_extensions.delete(ext_type);
endfunction
virtual function void clear_extensions();
        m_extensions.delete();
endfunction
virtual function void push_active_object( uvm_object obj );
    if(obj != null) begin
      m_policy_stack.push_front(obj);
    end
    else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM_POLICY_PUSHNULL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM_POLICY_PUSHNULL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM_POLICY_PUSHNULL", "Attempting to push an null object push_active_object onto the policy stack", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_policy.svh", 176, "", 1);
     end
   end
    end
endfunction
virtual function uvm_object pop_active_object();
uvm_object  m_tmp;
    if(m_policy_stack.size() != 0) begin
      m_tmp = m_policy_stack.pop_front();
      return m_tmp;
    end
    else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM_POLICY_EMPTY_POPACTIVE_OBJECT") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM_POLICY_EMPTY_POPACTIVE_OBJECT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM_POLICY_EMPTY_POPACTIVE_OBJECT", "Attempting to pop an empty policy stack", UVM_DEBUG, "t/uvm/src/base/uvm_policy.svh", 193, "", 1);
     end
   end
    end
endfunction
virtual function uvm_object get_active_object();
    if(m_policy_stack.size() != 0) begin
      return m_policy_stack[0];
    end
endfunction
virtual function int unsigned get_active_object_depth();
    return m_policy_stack.size();
endfunction
endclass
class uvm_field_op extends uvm_object;
   typedef uvm_object_registry#(uvm_field_op,"uvm_field_op") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_field_op tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_field_op";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_field_op";
     endfunction : get_type_name
   local uvm_policy m_policy;
   local bit m_user_hook;
   local uvm_object m_object;
   local bit m_is_set;
   local  uvm_field_flag_t m_op_type;
   function new (string name="");
      super.new(name);
      m_is_set = 1'b0;
      m_user_hook = 1'b1;
   endfunction
   virtual function void set( uvm_field_flag_t op_type, uvm_policy policy = null, uvm_object rhs = null);
     string matching_ops[$];
     if (op_type & UVM_COPY) begin
       matching_ops.push_back("UVM_COPY");
     end
     if (op_type & UVM_COMPARE) begin
       matching_ops.push_back("UVM_COMPARE");
     end
     if (op_type & UVM_PRINT) begin
       matching_ops.push_back("UVM_PRINT");
     end
     if (op_type & UVM_RECORD) begin
       matching_ops.push_back("UVM_RECORD");
     end
     if (op_type & UVM_PACK) begin
       matching_ops.push_back("UVM_PACK");
     end
     if (op_type & UVM_UNPACK) begin
       matching_ops.push_back("UVM_UNPACK");
     end
     if (op_type & UVM_SET) begin
       matching_ops.push_back("UVM_SET");
     end
     if (matching_ops.size() > 1) begin
       string msg_queue[$];
       msg_queue.push_back("(");
       foreach (matching_ops[i]) begin
         msg_queue.push_back(matching_ops[i]);
         if (i != matching_ops.size() - 1) begin
           msg_queue.push_back(",");
         end
       end
       msg_queue.push_back(")");
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/SET_BAD_OP_TYPE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/SET_BAD_OP_TYPE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/FIELD_OP/SET_BAD_OP_TYPE", {"set() was passed op_type matching multiple operations: ", uvm_pkg::m_uvm_string_queue_join(msg_queue)}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_field_op.svh", 117, "", 1);
     end
   end
     end
     if(m_is_set == 0) begin
       m_op_type = op_type;
       m_policy = policy;
       m_object = rhs;
       m_is_set = 1'b1;
     end
     else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/SET") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/SET") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/FIELD_OP/SET", "Attempting to set values in policy without flushing", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_field_op.svh", 127, "", 1);
     end
   end
     end
   endfunction
   virtual function string get_op_name();
      case(m_op_type)
        UVM_COPY : begin
          return "copy";
        end
        UVM_COMPARE : begin
          return "compare";
        end
        UVM_PRINT : begin
          return "print";
        end
        UVM_RECORD : begin
          return "record";
        end
        UVM_PACK : begin
          return "pack";
        end
        UVM_UNPACK : begin
          return "unpack";
        end
        UVM_SET : begin
          return "set";
        end
        default: begin
          return "";
        end
      endcase
   endfunction
   virtual function uvm_field_flag_t get_op_type();
      if(m_is_set == 1'b1) begin
        return m_op_type;
      end
      else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_OP_TYPE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_OP_TYPE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/FIELD_OP/GET_OP_TYPE", "Calling get_op_type() before calling set() is not allowed", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_field_op.svh", 177, "", 1);
     end
   end
      end
   endfunction
   virtual function uvm_policy get_policy();
      if(m_is_set == 1'b1) begin
        return m_policy;
      end
      else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_POLICY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_POLICY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/FIELD_OP/GET_POLICY", "Attempting to call get_policy() before calling set() is not allowed", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_field_op.svh", 190, "", 1);
     end
   end
      end
   endfunction
   virtual function uvm_object get_rhs();
      if(m_is_set == 1'b1) begin
        return m_object;
      end
      else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_RHS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_RHS") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/FIELD_OP/GET_RHS", "Calling get_rhs() before calling set() is not allowed", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_field_op.svh", 202, "", 1);
     end
   end
      end
   endfunction
   function bit user_hook_enabled();
      if(m_is_set == 1'b1) begin
        return m_user_hook;
      end
      else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_USER_HOOK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/FIELD_OP/GET_USER_HOOK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/FIELD_OP/GET_USER_HOOK", "Attempting to get_user_hook before calling set() is not allowed", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_field_op.svh", 214, "", 1);
     end
   end
      end
   endfunction
   function void disable_user_hook();
      m_user_hook = 1'b0;
   endfunction
   static uvm_field_op m_recycled_op[$] ;
   virtual function void flush();
      m_policy = null;
      m_object = null;
      m_user_hook = 1'b1;
      m_is_set = 0;
   endfunction
   function void m_recycle();
     this.flush();
     m_recycled_op.push_back(this);
   endfunction : m_recycle
   static function uvm_field_op m_get_available_op() ;
      uvm_field_op field_op ;
      if (m_recycled_op.size() > 0) begin
        field_op = m_recycled_op.pop_back() ;
      end
      else begin
        field_op = uvm_field_op::type_id::create("field_op");
      end
      return field_op ;
   endfunction
endclass
class uvm_copier extends uvm_policy;
   typedef uvm_object_registry#(uvm_copier,"uvm_copier") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_copier tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_copier";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_copier";
     endfunction : get_type_name
    uvm_recursion_policy_enum policy = UVM_DEFAULT_POLICY;
   function new(string name="uvm_copier") ;
    super.new(name);
   endfunction
   recursion_state_e m_recur_states[uvm_object  ][uvm_object  ][uvm_recursion_policy_enum  ];
  virtual function void copy_object (
                                       uvm_object lhs,
                                       uvm_object rhs);
    uvm_field_op field_op;
    if (get_recursion_policy() == UVM_REFERENCE) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM_COPY_POLICY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM_COPY_POLICY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM_COPY_POLICY", "Attempting to make a copy of a object which is a reference", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_copier.svh", 92, "", 1);
     end
   end
      return;
    end
    if (rhs == null || lhs == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM_COPY_NULL_OBJ") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM_COPY_NULL_OBJ") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM_COPY_NULL_OBJ", "Attempting to make a copy of a object with null src/target", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_copier.svh", 97, "", 1);
     end
   end
      return;
    end
    push_active_object(lhs);
    m_recur_states[rhs][lhs][get_recursion_policy()] = uvm_policy::STARTED;
    field_op = uvm_field_op::m_get_available_op() ;
    field_op.set(UVM_COPY,this,rhs);
    lhs.do_execute_op(field_op);
    if (field_op.user_hook_enabled()) begin
      lhs.do_copy(rhs);
    end
    field_op.m_recycle();
    m_recur_states[rhs][lhs][get_recursion_policy()] = uvm_policy::FINISHED;
    void'(pop_active_object());
  endfunction
   virtual function recursion_state_e object_copied(
                 uvm_object lhs,
                  uvm_object rhs,
                  uvm_recursion_policy_enum recursion
  );
  if (!m_recur_states.exists(rhs)) begin
    return NEVER ;
  end
  else if (!m_recur_states[rhs].exists(lhs)) begin
    return NEVER ;
  end
  else if (!m_recur_states[rhs][lhs].exists(recursion)) begin
    return NEVER ;
  end
  else begin
    return m_recur_states[rhs][lhs][recursion];
  end
endfunction
function void flush();
  m_recur_states.delete();
endfunction
virtual function void set_recursion_policy (uvm_recursion_policy_enum policy);
    this.policy = policy;
endfunction
virtual function uvm_recursion_policy_enum get_recursion_policy();
      return policy;
endfunction
function int unsigned get_num_copies(uvm_object rhs);
  if (m_recur_states.exists(rhs)) begin
    return m_recur_states[rhs].size();
  end
  return 0;
endfunction : get_num_copies
function int get_first_copy(uvm_object rhs, ref uvm_object lhs);
  if (m_recur_states.exists(rhs))
    return m_recur_states[rhs].first(lhs);
  return 0;
endfunction : get_first_copy
function int get_next_copy(uvm_object rhs, ref uvm_object lhs);
  if (m_recur_states.exists(rhs))
    return m_recur_states[rhs].next(lhs);
  return 0;
endfunction : get_next_copy
function int get_last_copy(uvm_object rhs, ref uvm_object lhs);
  if (m_recur_states.exists(rhs))
    return m_recur_states[rhs].last(lhs);
  return 0;
endfunction : get_last_copy
function int get_prev_copy(uvm_object rhs, ref uvm_object lhs);
  if (m_recur_states.exists(rhs))
    return m_recur_states[rhs].prev(lhs);
  return 0;
endfunction : get_prev_copy
static function void set_default (uvm_copier copier) ;
     uvm_coreservice_t coreservice ;
     coreservice = uvm_coreservice_t::get() ;
     coreservice.set_default_copier(copier) ;
endfunction
static function uvm_copier get_default () ;
     uvm_coreservice_t coreservice ;
     coreservice = uvm_coreservice_t::get() ;
     return coreservice.get_default_copier() ;
endfunction
endclass
typedef class m_uvm_printer_knobs;
typedef class uvm_printer_element;
typedef class uvm_structure_proxy;
typedef struct {
  int    level;
  string name;
  string type_name;
  string size;
  string val;
} uvm_printer_row_info;
virtual class uvm_printer extends uvm_policy;
   typedef uvm_abstract_object_registry#(uvm_printer,"uvm_printer") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
     static function string type_name();
       return "uvm_printer";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_printer";
     endfunction : get_type_name
  extern function new(string name="") ;
  bit m_flushed ;
  m_uvm_printer_knobs knobs ;
protected function m_uvm_printer_knobs get_knobs() ; return knobs; endfunction
  extern static function void set_default(uvm_printer printer) ;
  extern static function uvm_printer get_default() ;
  extern virtual function void print_field (string          name,
                                            uvm_bitstream_t value,
                                            int    size,
                                            uvm_radix_enum radix=UVM_NORADIX,
                                            byte   scope_separator=".",
                                            string type_name="");
  virtual function void print_int (string          name,
                                   uvm_bitstream_t value,
                                   int    size,
                                   uvm_radix_enum radix=UVM_NORADIX,
                                   byte   scope_separator=".",
                                   string type_name="");
    print_field (name, value, size, radix, scope_separator, type_name);
  endfunction
  extern virtual function void print_field_int (string name,
                                                uvm_integral_t value,
                                                int    size,
                                                uvm_radix_enum radix=UVM_NORADIX,
                                                byte   scope_separator=".",
                                                string type_name="");
  extern virtual function void print_object (string     name,
                                             uvm_object value,
                                             byte       scope_separator=".");
  extern virtual function void print_object_header (string name,
                                                    uvm_object value,
                                                    byte scope_separator=".");
  extern virtual function void print_string (string name,
                                             string value,
                                             byte   scope_separator=".");
  uvm_policy::recursion_state_e m_recur_states[uvm_object][uvm_recursion_policy_enum  ] ;
  extern virtual function uvm_policy::recursion_state_e object_printed ( uvm_object value,
                                                                         uvm_recursion_policy_enum recursion);
  extern virtual function void print_time (string name,
                                           time   value,
                                           byte   scope_separator=".");
  extern virtual function void print_real (string  name,
                                           real    value,
                                           byte    scope_separator=".");
  extern virtual function void print_generic (string  name,
                                              string  type_name,
                                              int     size,
                                              string  value,
                                              byte    scope_separator=".");
  extern virtual function void print_generic_element (string  name,
                                                      string  type_name,
                                                      string  size,
                                                      string  value);
  extern virtual function string emit ();
  extern virtual function void flush ();
  extern virtual function void set_name_enabled (bit enabled);
  extern virtual function bit get_name_enabled ();
  extern virtual function void set_type_name_enabled (bit enabled);
  extern virtual function bit get_type_name_enabled ();
  extern virtual function void set_size_enabled (bit enabled);
  extern virtual function bit get_size_enabled ();
  extern virtual function void set_id_enabled (bit enabled);
  extern virtual function bit get_id_enabled ();
  extern virtual function void set_radix_enabled (bit enabled);
  extern virtual function bit get_radix_enabled ();
  extern virtual function void set_radix_string (uvm_radix_enum radix, string prefix);
  extern virtual function string get_radix_string (uvm_radix_enum radix);
  extern virtual function void set_default_radix (uvm_radix_enum radix);
  extern virtual function uvm_radix_enum get_default_radix ();
  extern virtual function void set_root_enabled (bit enabled);
  extern virtual function bit get_root_enabled ();
  extern virtual function void set_recursion_policy (uvm_recursion_policy_enum policy);
  extern virtual function uvm_recursion_policy_enum get_recursion_policy ();
  extern virtual function void set_max_depth (int depth);
  extern virtual function int get_max_depth ();
  extern virtual function void set_file (UVM_FILE fl);
  extern virtual function UVM_FILE get_file ();
  extern virtual function void set_line_prefix (string prefix);
  extern virtual function string get_line_prefix ();
  extern virtual function void set_begin_elements (int elements = 5);
  extern virtual function int get_begin_elements ();
  extern virtual function void set_end_elements (int elements = 5);
  extern virtual function int get_end_elements ();
  local uvm_printer_element m_element_stack[$] ;
  protected function int m_get_stack_size(); return m_element_stack.size(); endfunction
  extern protected virtual function uvm_printer_element get_bottom_element ();
  extern protected virtual function uvm_printer_element get_top_element ();
  extern virtual function void push_element ( string name,
                                              string type_name,
                                              string size,
                                              string value=""
  );
  extern virtual function void pop_element ();
  extern function uvm_printer_element get_unused_element() ;
  uvm_printer_element m_recycled_elements[$];
  extern virtual  function void print_array_header(string name,
                                                   int    size,
                                                   string arraytype="array",
                                                   byte   scope_separator=".");
  extern virtual function void print_array_range (int min, int max);
  extern virtual  function void print_array_footer (int size = 0);
  virtual function string format_row (uvm_printer_row_info row);
    return "";
  endfunction
  virtual function string format_header();
    return "";
  endfunction
  virtual function string format_footer();
    return "";
  endfunction
  virtual protected function string adjust_name (string id,
                                                 byte scope_separator=".");
    if (get_root_enabled() &&
        istop() ||
        knobs.full_name ||
        id == "...") begin
      return id;
    end
    return uvm_leaf_scope(id, scope_separator);
  endfunction
  extern  function bit istop ();
  extern  function string index_string (int index, string name="");
  string m_string;
  extern function string get_radix_str(uvm_radix_enum radix);
endclass
class uvm_printer_element extends uvm_object;
   extern function new (string name="");
   extern virtual function void set (string element_name = "",
                                     string element_type_name = "",
                                     string element_size = "",
                                     string element_value = ""
   );
   extern virtual function void set_element_name (string element_name);
   extern virtual function string get_element_name ();
   extern virtual function void set_element_type_name (string element_type_name);
   extern virtual function string get_element_type_name ();
   extern virtual function void set_element_size (string element_size);
   extern virtual function string get_element_size ();
   extern virtual function void set_element_value (string element_value);
   extern virtual function string get_element_value ();
   extern function void add_child(uvm_printer_element child) ;
   extern function void get_children(ref uvm_printer_element children[$], input bit recurse) ;
   extern function void clear_children() ;
   local string m_name ;
   local string m_type_name ;
   local string m_size ;
   local string m_value ;
   local uvm_printer_element m_children[$] ;
endclass
class uvm_printer_element_proxy extends uvm_structure_proxy#(uvm_printer_element);
   extern function new (string name="");
   extern virtual function void get_immediate_children(uvm_printer_element s, ref uvm_printer_element children[$]);
endclass : uvm_printer_element_proxy
class uvm_table_printer extends uvm_printer;
   typedef uvm_object_registry#(uvm_table_printer,"uvm_table_printer") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_table_printer tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_table_printer";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_table_printer";
     endfunction : get_type_name
  extern function new(string name="");
  extern virtual function string emit();
  extern virtual function string m_emit_element(uvm_printer_element element, int unsigned level);
  local static string m_space ;
  extern static function void set_default(uvm_table_printer printer) ;
  extern static function uvm_table_printer get_default() ;
  extern virtual function void set_indent(int indent) ;
  extern virtual function int get_indent() ;
  extern virtual function void flush() ;
  protected int m_max_name=4;
  protected int m_max_type=4;
  protected int m_max_size=4;
  protected int m_max_value=5;
  extern virtual function void pop_element();
endclass
class uvm_tree_printer extends uvm_printer;
  protected string m_newline = "\n";
  protected string m_linefeed ;
   typedef uvm_object_registry#(uvm_tree_printer,"uvm_tree_printer") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_tree_printer tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_tree_printer";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_tree_printer";
     endfunction : get_type_name
  extern function new(string name="");
  extern static function void set_default(uvm_tree_printer printer) ;
  extern static function uvm_tree_printer get_default() ;
  extern virtual function void set_indent(int indent) ;
  extern virtual function int get_indent() ;
  extern virtual function void set_separators(string separators) ;
  extern virtual function string get_separators() ;
  extern virtual function void flush() ;
  extern virtual function string emit();
  extern virtual function string m_emit_element(uvm_printer_element element, int unsigned level);
endclass
class uvm_line_printer extends uvm_tree_printer;
   typedef uvm_object_registry#(uvm_line_printer,"uvm_line_printer") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_line_printer tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_line_printer";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_line_printer";
     endfunction : get_type_name
  extern function new(string name="");
  extern static function void set_default(uvm_line_printer printer) ;
  extern static function uvm_line_printer get_default() ;
  extern virtual function void set_separators(string separators) ;
  extern virtual function string get_separators() ;
  extern virtual function void flush() ;
endclass
class m_uvm_printer_knobs;
  bit identifier = 1;
  bit type_name = 1;
  bit size = 1;
  int depth = -1;
  bit reference = 1;
  int begin_elements = 5;
  int end_elements = 5;
  string prefix = "";
  int indent = 2;
  bit show_root = 0;
  int mcd = UVM_STDOUT;
  string separator = "{}";
  bit show_radix = 1;
  uvm_radix_enum default_radix = UVM_HEX;
  string dec_radix = "'d";
  string bin_radix = "'b";
  string oct_radix = "'o";
  string unsigned_radix = "'d";
  string hex_radix = "'h";
  uvm_recursion_policy_enum recursion_policy ;
  bit header = 1;
  bit footer = 1;
  bit full_name = 0;
endclass
function uvm_printer::new(string name="");
   super.new(name);
   knobs = new ;
   flush();
endfunction
function void uvm_printer::set_default(uvm_printer printer) ;
   uvm_coreservice_t coreservice ;
   coreservice = uvm_coreservice_t::get() ;
   coreservice.set_default_printer(printer) ;
endfunction
function uvm_printer uvm_printer::get_default() ;
   uvm_coreservice_t coreservice ;
   coreservice = uvm_coreservice_t::get() ;
   return coreservice.get_default_printer() ;
endfunction
function void uvm_printer::print_field (string name,
                                      uvm_bitstream_t value,
                                      int size,
                                      uvm_radix_enum radix=UVM_NORADIX,
                                      byte scope_separator=".",
                                      string type_name="");
  string sz_str, val_str;
  if(type_name == "") begin
    if(radix == UVM_TIME) begin
      type_name ="time";
    end
    else if(radix == UVM_STRING) begin
      type_name ="string";
    end
    else begin
      type_name ="integral";
    end
  end
  sz_str.itoa(size);
  if(radix == UVM_NORADIX) begin
    radix = get_default_radix();
  end
  val_str = uvm_bit_vector_utils#(uvm_bitstream_t)::to_string(value, size, radix, get_radix_string(radix));
  name = adjust_name(name,scope_separator);
  push_element(name,type_name,sz_str,val_str);
  pop_element() ;
endfunction
function void uvm_printer::print_field_int (string name,
                                            uvm_integral_t value,
                                            int          size,
                                            uvm_radix_enum radix=UVM_NORADIX,
                                            byte         scope_separator=".",
                                            string       type_name="");
  string sz_str, val_str;
  if(type_name == "") begin
    if(radix == UVM_TIME) begin
      type_name ="time";
    end
    else if(radix == UVM_STRING) begin
      type_name ="string";
    end
    else begin
      type_name ="integral";
    end
  end
  sz_str.itoa(size);
  if(radix == UVM_NORADIX) begin
    radix = get_default_radix();
  end
  val_str = uvm_bit_vector_utils#(uvm_integral_t)::to_string(value, size, radix, get_radix_string(radix));
  name = adjust_name(name,scope_separator);
  push_element(name,type_name,sz_str,val_str);
  pop_element() ;
endfunction
function string uvm_printer::emit ();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "NO_OVERRIDE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "NO_OVERRIDE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("NO_OVERRIDE", "emit() method not overridden in printer subtype", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_printer.svh", 918, "", 1);
     end
   end
  return "";
endfunction
function void uvm_printer::flush ();
   uvm_printer_element element = get_bottom_element() ;
   uvm_printer_element all_descendent_elements[$] ;
   element = get_bottom_element() ;
   if (element != null) begin
     element.get_children(all_descendent_elements,1) ;
     foreach (all_descendent_elements[i]) begin
       m_recycled_elements.push_back(all_descendent_elements[i]) ;
       all_descendent_elements[i].clear_children() ;
     end
     element.clear_children();
     m_recycled_elements.push_back(element) ;
     m_element_stack.delete() ;
   end
   m_recur_states.delete();
   m_flushed = 1 ;
endfunction
function void uvm_printer::set_name_enabled (bit enabled);
   knobs.identifier = enabled ;
endfunction
function bit uvm_printer::get_name_enabled ();
   return knobs.identifier ;
endfunction
function void uvm_printer::set_type_name_enabled (bit enabled);
   knobs.type_name = enabled ;
endfunction
function bit uvm_printer::get_type_name_enabled ();
   return knobs.type_name ;
endfunction
function void uvm_printer::set_size_enabled (bit enabled);
   knobs.size = enabled ;
endfunction
function bit uvm_printer::get_size_enabled ();
   return knobs.size ;
endfunction
function void uvm_printer::set_id_enabled (bit enabled);
   knobs.reference = enabled ;
endfunction
function bit uvm_printer::get_id_enabled ();
   return knobs.reference ;
endfunction
function void uvm_printer::set_radix_enabled (bit enabled);
   knobs.show_radix = enabled ;
endfunction
function bit uvm_printer::get_radix_enabled ();
   return knobs.show_radix ;
endfunction
function void uvm_printer::set_radix_string (uvm_radix_enum radix, string prefix);
   if (radix == UVM_DEC) begin
     knobs.dec_radix = prefix ;
   end
   else if (radix == UVM_BIN) begin
     knobs.bin_radix = prefix ;
   end
   else if (radix == UVM_OCT) begin
     knobs.oct_radix = prefix ;
   end
   else if (radix == UVM_UNSIGNED) begin
     knobs.unsigned_radix = prefix ;
   end
   else if (radix == UVM_HEX) begin
     knobs.hex_radix = prefix ;
   end
   else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "PRINTER_UNKNOWN_RADIX") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "PRINTER_UNKNOWN_RADIX") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("PRINTER_UNKNOWN_RADIX", $sformatf("set_radix_string called with unsupported radix %s",radix), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_printer.svh", 1000, "", 1);
     end
   end
   end
endfunction
function string uvm_printer::get_radix_string (uvm_radix_enum radix);
   if (radix == UVM_DEC) begin
     return knobs.dec_radix ;
   end
   else if (radix == UVM_BIN) begin
     return knobs.bin_radix ;
   end
   else if (radix == UVM_OCT) begin
     return knobs.oct_radix ;
   end
   else if (radix == UVM_UNSIGNED) begin
     return knobs.unsigned_radix ;
   end
   else if (radix == UVM_HEX) begin
     return knobs.hex_radix ;
   end
   else begin
     return "";
   end
endfunction
function void uvm_printer::set_default_radix (uvm_radix_enum radix);
   knobs.default_radix = radix ;
endfunction
function uvm_radix_enum uvm_printer::get_default_radix ();
   return knobs.default_radix ;
endfunction
function void uvm_printer::set_root_enabled (bit enabled);
   knobs.show_root = enabled ;
endfunction
function bit uvm_printer::get_root_enabled ();
   return knobs.show_root ;
endfunction
function void uvm_printer::set_recursion_policy (uvm_recursion_policy_enum policy);
   knobs.recursion_policy = policy ;
endfunction
function uvm_recursion_policy_enum uvm_printer::get_recursion_policy ();
   return knobs.recursion_policy ;
endfunction
function void uvm_printer::set_max_depth (int depth);
   knobs.depth = depth ;
endfunction
function int uvm_printer::get_max_depth ();
   return knobs.depth ;
endfunction
function void uvm_printer::set_file (UVM_FILE fl);
   knobs.mcd = fl ;
endfunction
function UVM_FILE uvm_printer::get_file ();
   return knobs.mcd ;
endfunction
function void uvm_printer::set_line_prefix (string prefix);
   knobs.prefix = prefix ;
endfunction
function string uvm_printer::get_line_prefix ();
   return knobs.prefix ;
endfunction
function void uvm_printer::set_begin_elements (int elements = 5);
   knobs.begin_elements = elements ;
endfunction
function int uvm_printer::get_begin_elements ();
   return knobs.begin_elements ;
endfunction
function void uvm_printer::set_end_elements (int elements = 5);
   knobs.end_elements = elements ;
endfunction
function int uvm_printer::get_end_elements ();
   return knobs.end_elements ;
endfunction
function uvm_printer_element uvm_printer::get_bottom_element ();
   if (m_element_stack.size() > 0) begin
     return m_element_stack[0] ;
   end
   else begin
     return null ;
   end
endfunction
function uvm_printer_element uvm_printer::get_top_element ();
   if (m_element_stack.size() > 0) begin
     return m_element_stack[$] ;
   end
   else begin
     return null ;
   end
endfunction
function uvm_printer_element_proxy::new (string name="");
   super.new(name) ;
endfunction
function void uvm_printer_element_proxy::get_immediate_children(uvm_printer_element s,
                                                                ref uvm_printer_element children[$]);
   s.get_children(children,0) ;
endfunction
function void uvm_printer::push_element ( string name,
                                          string type_name,
                                          string size,
                                          string value="");
   uvm_printer_element element ;
   uvm_printer_element parent ;
   element = get_unused_element() ;
   parent = get_top_element() ;
   if (knobs.full_name && (parent != null)) begin
     name = $sformatf("%s.%s",parent.get_element_name(),name);
   end
   element.set(name,type_name,size,value);
   if (parent != null) begin
     parent.add_child(element) ;
   end
   m_element_stack.push_back(element) ;
endfunction
function void uvm_printer::pop_element ();
   if (m_element_stack.size() > 1) begin
     void'(m_element_stack.pop_back());
   end
endfunction
function uvm_printer_element uvm_printer::get_unused_element() ;
   uvm_printer_element element ;
   if (m_recycled_elements.size() > 0) begin
     element = m_recycled_elements.pop_back() ;
   end
   else begin
     element = new() ;
   end
   return element ;
endfunction
function void uvm_printer::print_array_header (string name,
                                               int size,
                                               string arraytype="array",
                                               byte scope_separator=".");
  push_element(name,arraytype,$sformatf("%0d",size),"-");
endfunction
function void  uvm_printer::print_array_footer (int size=0);
  pop_element() ;
endfunction
function void uvm_printer::print_array_range(int min, int max);
  string tmpstr;
  if(min == -1 && max == -1) begin
    return;
  end
  if(min == -1) begin
    min = max;
  end
  if(max == -1) begin
    max = min;
  end
  if(max < min) begin
    return;
  end
  print_generic_element("...", "...", "...", "...");
endfunction
function void uvm_printer::print_object_header (string name,
                                                uvm_object value,
                                                byte scope_separator=".");
  if(name == "") begin
    name = "<unnamed>";
  end
  push_element(name,
               (value != null) ?  value.get_type_name() : "object",
               "-",
               get_id_enabled() ? uvm_object_value_str(value) : "-");
endfunction
function void uvm_printer::print_object (string name, uvm_object value,
                                         byte scope_separator=".");
  uvm_component comp, child_comp;
  uvm_field_op field_op ;
  uvm_recursion_policy_enum recursion_policy;
  recursion_policy = get_recursion_policy();
  if ((value == null) ||
      (recursion_policy == UVM_REFERENCE) ||
      (get_max_depth() == get_active_object_depth())) begin
    print_object_header(name,value,scope_separator);
    pop_element();
  end
  else begin
    push_active_object(value);
    m_recur_states[value][recursion_policy] = uvm_policy::STARTED ;
    print_object_header(name,value,scope_separator);
    field_op = uvm_field_op::m_get_available_op() ;
    field_op.set(UVM_PRINT,this,null);
    value.do_execute_op(field_op);
    if (field_op.user_hook_enabled()) begin
      value.do_print(this);
    end
    field_op.m_recycle();
    pop_element() ;
    m_recur_states[value][recursion_policy] = uvm_policy::FINISHED ;
    void'(pop_active_object());
  end
endfunction
function bit uvm_printer::istop ();
  return (get_active_object_depth() == 0);
endfunction
function void uvm_printer::print_generic (string name,
                                          string type_name,
                                          int size,
                                          string value,
                                          byte scope_separator=".");
  push_element(name,
               type_name,
               (size == -2 ? "..." : $sformatf("%0d",size)),
               value);
  pop_element();
endfunction
function void uvm_printer::print_generic_element (string  name,
                                                  string  type_name,
                                                  string  size,
                                                  string  value);
  push_element(name,type_name,size,value);
  pop_element() ;
endfunction
function void uvm_printer::print_time (string name,
                                       time value,
                                       byte scope_separator=".");
  print_field_int(name, value, 64, UVM_TIME, scope_separator);
endfunction
function void uvm_printer::print_string (string name,
                                         string value,
                                         byte scope_separator=".");
  push_element(name,
               "string",
               $sformatf("%0d",value.len()),
               (value == "" ? "\"\"" : value));
  pop_element() ;
endfunction
function uvm_policy::recursion_state_e uvm_printer::object_printed (uvm_object value,
                                                                    uvm_recursion_policy_enum recursion);
   if (!m_recur_states.exists(value)) begin
     return NEVER ;
   end
   if (!m_recur_states[value].exists(recursion)) begin
     return NEVER ;
   end
   else begin
     return m_recur_states[value][recursion] ;
   end
endfunction
function void uvm_printer::print_real (string name,
                                       real value,
                                       byte scope_separator=".");
  push_element(name,"real","64",$sformatf("%f",value));
  pop_element() ;
endfunction
function string uvm_printer::index_string(int index, string name="");
  index_string.itoa(index);
  index_string = { name, "[", index_string, "]" };
endfunction
function uvm_printer_element::new (string name = "");
   super.new(name) ;
endfunction
function void uvm_printer_element::set (string element_name = "",
                                        string element_type_name = "",
                                        string element_size = "",
                                        string element_value = ""
   );
   m_name = element_name ;
   m_type_name = element_type_name ;
   m_size = element_size ;
   m_value = element_value ;
endfunction
function void uvm_printer_element::set_element_name (string element_name);
   m_name = element_name ;
endfunction
function string uvm_printer_element::get_element_name ();
   return m_name ;
endfunction
function void uvm_printer_element::set_element_type_name (string element_type_name);
   m_type_name = element_type_name ;
endfunction
function string uvm_printer_element::get_element_type_name ();
   return m_type_name ;
endfunction
function void uvm_printer_element::set_element_size (string element_size);
   m_size = element_size ;
endfunction
function string uvm_printer_element::get_element_size ();
   return m_size ;
endfunction
function void uvm_printer_element::set_element_value (string element_value);
   m_value = element_value ;
endfunction
function string uvm_printer_element::get_element_value ();
   return m_value ;
endfunction
function void uvm_printer_element::add_child(uvm_printer_element child) ;
   m_children.push_back(child) ;
endfunction
function void uvm_printer_element::get_children(ref uvm_printer_element children[$], input bit recurse) ;
   foreach (m_children[i]) begin
     children.push_back(m_children[i]) ;
     if (recurse) begin
       m_children[i].get_children(children,1) ;
     end
   end
endfunction
function void uvm_printer_element::clear_children() ;
   m_children.delete() ;
endfunction
function uvm_table_printer::new(string name="");
  super.new(name);
endfunction
function void uvm_table_printer::pop_element();
   int name_len;
   int level ;
   uvm_printer_element popped ;
   string name_str ;
   string type_name_str ;
   string size_str ;
   string value_str ;
   popped = get_top_element() ;
   level = m_get_stack_size() - 1 ;
   name_str = popped.get_element_name() ;
   type_name_str = popped.get_element_type_name() ;
   size_str = popped.get_element_size() ;
   value_str = popped.get_element_value() ;
   if ((name_str.len() + (get_indent() * level)) > m_max_name) begin
     m_max_name = (name_str.len() + (get_indent() * level));
   end
   if (type_name_str.len() > m_max_type) begin
     m_max_type = type_name_str.len();
   end
   if (size_str.len() > m_max_size) begin
     m_max_size = size_str.len();
   end
   if (value_str.len() > m_max_value) begin
     m_max_value = value_str.len();
   end
   super.pop_element() ;
endfunction
function string uvm_table_printer::emit();
  string s;
  string user_format;
  static string dash;
  string dashes;
  string linefeed;
  if (!m_flushed) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/PRINT/NO_FLUSH") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/PRINT/NO_FLUSH") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/PRINT/NO_FLUSH", "printer emit() method called twice without intervening uvm_printer::flush()", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_printer.svh", 1484, "", 1);
     end
   end
  end
  else begin
    m_flushed = 0 ;
  end
  linefeed = {"\n", get_line_prefix()};
   begin
     int q[5];
     int m;
     int qq[$];
     q = '{m_max_name,m_max_type,m_max_size,m_max_value,100};
     qq = q.max;
     m = qq[0];
     if(dash.len()<m) begin
       dash = {m{"-"}};
       m_space = {m{" "}};
     end
   end
  if (knobs.header) begin
    user_format = format_header();
    if (user_format != "") begin
      s = {s, user_format, linefeed};
    end
    else begin
      string header;
      string dash_id, dash_typ, dash_sz;
      string head_id, head_typ, head_sz;
      if (get_name_enabled()) begin
        dashes = {dash.substr(1,m_max_name+2)};
        header = {"Name",m_space.substr(1,m_max_name-2)};
      end
      if (get_type_name_enabled()) begin
        dashes = {dashes, dash.substr(1,m_max_type+2)};
        header = {header, "Type",m_space.substr(1,m_max_type-2)};
      end
      if (get_size_enabled()) begin
        dashes = {dashes, dash.substr(1,m_max_size+2)};
        header = {header, "Size",m_space.substr(1,m_max_size-2)};
      end
      dashes = {dashes, dash.substr(1,m_max_value), linefeed};
      header = {header, "Value", m_space.substr(1,m_max_value-5), linefeed};
      s = {s, dashes, header, dashes};
    end
  end
  s = {s, m_emit_element(get_bottom_element(),0)} ;
  if (knobs.footer) begin
    user_format = format_footer();
    if (user_format != "") begin
      s = {s, user_format, linefeed};
    end
    else begin
      s = {s, dashes};
    end
  end
  emit = {get_line_prefix(), s};
endfunction
function string uvm_table_printer::m_emit_element(uvm_printer_element element, int unsigned level) ;
  string result ;
  static uvm_printer_element_proxy proxy = new("proxy") ;
  uvm_printer_element element_children[$];
  string linefeed = {"\n", get_line_prefix()};
    uvm_printer_row_info row ;
    string user_format ;
    row.level = level ;
    row.name = element.get_element_name() ;
    row.type_name = element.get_element_type_name() ;
    row.size = element.get_element_size() ;
    row.val = element.get_element_value() ;
    user_format = format_row(row);
    if (user_format != "") begin
      result = {user_format, linefeed};
    end
    else begin
      string row_str;
      string name_str ;
      string value_str ;
      string type_name_str ;
      string size_str ;
      name_str = element.get_element_name() ;
      value_str = element.get_element_value() ;
      type_name_str = element.get_element_type_name() ;
      size_str = element.get_element_size() ;
      if (get_name_enabled()) begin
        result = {result, m_space.substr(1,level * get_indent()), name_str,
                   m_space.substr(1,m_max_name-name_str.len()-(level*get_indent())+2)};
      end
      if (get_type_name_enabled()) begin
        result = {result, type_name_str, m_space.substr(1,m_max_type-type_name_str.len()+2)};
      end
      if (get_size_enabled()) begin
        result = {result, size_str, m_space.substr(1,m_max_size-size_str.len()+2)};
      end
      result = {result, row_str, value_str, m_space.substr(1,m_max_value-value_str.len()), linefeed};
    end
  proxy.get_immediate_children(element,element_children) ;
  foreach (element_children[i]) begin
    result = {result, m_emit_element(element_children[i],level+1)} ;
  end
  return result ;
endfunction
function uvm_tree_printer::new(string name="");
  super.new(name);
  set_size_enabled(0);
  set_type_name_enabled(0);
  knobs.header = 0;
  knobs.footer = 0;
endfunction
function void uvm_tree_printer::set_indent(int indent) ;
   m_uvm_printer_knobs _knobs = get_knobs();
   _knobs.indent = indent ;
endfunction
function int uvm_tree_printer::get_indent() ;
   m_uvm_printer_knobs _knobs = get_knobs();
   return _knobs.indent ;
endfunction
function void uvm_tree_printer::set_separators(string separators) ;
   m_uvm_printer_knobs _knobs = get_knobs();
   _knobs.separator = separators ;
endfunction
function string uvm_tree_printer::get_separators() ;
   m_uvm_printer_knobs _knobs = get_knobs();
   return _knobs.separator ;
endfunction
function void uvm_tree_printer::flush() ;
   super.flush() ;
endfunction
function string uvm_tree_printer::emit();
  string s ;
  string user_format;
  int unsigned level ;
  uvm_printer_element element ;
  if (!m_flushed) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/PRINT/NO_FLUSH") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/PRINT/NO_FLUSH") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/PRINT/NO_FLUSH", "printer emit() method called twice without intervening uvm_printer::flush()", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_printer.svh", 1663, "", 1);
     end
   end
  end
  else begin
    m_flushed = 0 ;
  end
  s = get_line_prefix() ;
  m_linefeed = m_newline == "" || m_newline == " " ? m_newline : {m_newline, get_line_prefix()};
  if (knobs.header) begin
    user_format = format_header();
    if (user_format != "") begin
      s = {s, user_format, m_linefeed};
    end
  end
  s = {s,m_emit_element(get_bottom_element(),0)} ;
  if (knobs.footer) begin
    user_format = format_footer();
    if (user_format != "") begin
      s = {s, user_format, m_linefeed};
    end
  end
  if (m_newline == "" || m_newline == " ") begin
    s = {s, "\n"};
  end
  return(s);
endfunction
function string uvm_tree_printer::m_emit_element(uvm_printer_element element, int unsigned level) ;
   string result ;
   string space= "                                                                                                   ";
   static uvm_printer_element_proxy proxy = new("proxy") ;
   uvm_printer_element element_children[$];
   string separators;
   string indent_str;
   string user_format ;
   separators=get_separators() ;
   indent_str = space.substr(1,level * get_indent());
   proxy.get_immediate_children(element,element_children) ;
    begin
      uvm_printer_row_info row ;
      row.level = level ;
      row.name = element.get_element_name() ;
      row.type_name = element.get_element_type_name() ;
      row.size = element.get_element_size() ;
      row.val = element.get_element_value() ;
      user_format = format_row(row);
    end
    if (user_format != "") begin
      result = user_format;
    end
    else begin
      string value_str ;
      if (get_name_enabled()) begin
        result = {result,indent_str, element.get_element_name()};
        if (element.get_element_name() != "" && element.get_element_name() != "...") begin
          result = {result, ": "};
        end
      end
      value_str = element.get_element_value();
      if ((value_str.len() > 0) && (value_str[0] == "@")) begin
        result = {result,"(",element.get_element_type_name(),value_str,") "};
      end
      else
        if (get_type_name_enabled() &&
        (element.get_element_type_name() != "" ||
        element.get_element_type_name() != "-" ||
        element.get_element_type_name() != "...")) begin
          result = {result,"(",element.get_element_type_name(),") "};
        end
      if (get_size_enabled()) begin
        if (element.get_element_size() != "" || element.get_element_size() != "-") begin
          result = {result,"(",element.get_element_size(),") "};
        end
      end
      if (element_children.size() > 0) begin
        result = {result, string'(separators[0]), m_linefeed};
      end
      else begin
        result = {result, value_str, " ", m_linefeed};
      end
    end
    foreach (element_children[i]) begin
      result = {result, m_emit_element(element_children[i],level+1)} ;
    end
    if ((user_format == "") && (element_children.size() > 0)) begin
      result = {result, indent_str, string'(separators[1]), m_linefeed};
    end
    return result ;
endfunction : m_emit_element
function void uvm_table_printer::set_default(uvm_table_printer printer) ;
   uvm_default_table_printer = printer ;
endfunction
function uvm_table_printer uvm_table_printer::get_default() ;
   if (uvm_default_table_printer == null) begin
     uvm_default_table_printer = new() ;
   end
   return uvm_default_table_printer ;
endfunction
function void uvm_table_printer::set_indent(int indent) ;
   m_uvm_printer_knobs _knobs = get_knobs();
   _knobs.indent = indent ;
endfunction
function int uvm_table_printer::get_indent() ;
   m_uvm_printer_knobs _knobs = get_knobs();
   return _knobs.indent ;
endfunction
function void uvm_table_printer::flush() ;
   super.flush() ;
   m_max_name=4;
   m_max_type=4;
   m_max_size=4;
   m_max_value=5;
endfunction
function void uvm_tree_printer::set_default(uvm_tree_printer printer) ;
   uvm_default_tree_printer = printer ;
endfunction
function uvm_tree_printer uvm_tree_printer::get_default() ;
   if (uvm_default_tree_printer == null) begin
     uvm_default_tree_printer = new() ;
   end
   return uvm_default_tree_printer ;
endfunction
function uvm_line_printer::new(string name="") ;
  super.new(name);
  m_newline = " ";
  set_indent(0);
endfunction
function void uvm_line_printer::set_default(uvm_line_printer printer) ;
   uvm_default_line_printer = printer ;
endfunction
function uvm_line_printer uvm_line_printer::get_default() ;
   if (uvm_default_line_printer == null) begin
     uvm_default_line_printer = new() ;
   end
   return uvm_default_line_printer ;
endfunction
function void uvm_line_printer::set_separators(string separators) ;
   m_uvm_printer_knobs _knobs = get_knobs();
   if (separators.len() < 2) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/PRINT/SHORT_SEP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/PRINT/SHORT_SEP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/PRINT/SHORT_SEP", $sformatf("Bad call: set_separators(%s) (Argument must have at least 2 characters)",separators), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_printer.svh", 1856, "", 1);
     end
   end
   end
   _knobs.separator = separators ;
endfunction
function string uvm_line_printer::get_separators() ;
   m_uvm_printer_knobs _knobs = get_knobs();
   return _knobs.separator ;
endfunction
function void uvm_line_printer::flush() ;
   super.flush() ;
endfunction
function string uvm_printer::get_radix_str(uvm_radix_enum radix);
    if(knobs.show_radix == 0) begin
      return "";
    end
    if(radix == UVM_NORADIX) begin
      radix = knobs.default_radix;
    end
    return get_radix_string(radix);
endfunction
class uvm_comparer extends uvm_policy;
   typedef uvm_object_registry#(uvm_comparer,"uvm_comparer") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_comparer tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_comparer";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_comparer";
     endfunction : get_type_name
  extern virtual function void flush();
  extern virtual function uvm_policy::recursion_state_e object_compared(
     uvm_object lhs,
     uvm_object rhs,
     uvm_recursion_policy_enum recursion,
     output bit ret_val
  );
  extern virtual function string get_miscompares();
  extern virtual function int unsigned get_result();
  extern virtual function void set_result(int unsigned result) ;
  extern virtual function void set_recursion_policy( uvm_recursion_policy_enum policy);
  extern virtual function uvm_recursion_policy_enum get_recursion_policy();
  extern virtual function void set_check_type( bit enabled );
  extern virtual function bit get_check_type();
  extern virtual function void set_show_max (int unsigned show_max);
  extern virtual function int unsigned get_show_max ();
  extern virtual function void set_verbosity (int unsigned verbosity);
  extern virtual function int unsigned get_verbosity ();
  extern virtual function void set_severity (uvm_severity severity);
  extern virtual function uvm_severity get_severity ();
  extern virtual function void set_threshold (int unsigned threshold);
  extern virtual function int unsigned get_threshold ();
  bit physical = 1;
  bit abstract = 1 ;
  typedef struct {
     recursion_state_e state;
     bit ret_val;
  } state_info_t ;
  state_info_t m_recur_states[uvm_object  ][uvm_object  ][uvm_recursion_policy_enum  ];
  uvm_recursion_policy_enum policy = UVM_DEFAULT_POLICY;
  int unsigned show_max = 1;
  int unsigned verbosity = UVM_LOW;
  uvm_severity sev = UVM_INFO;
  string miscompares = "";
  bit check_type = 1;
  int unsigned result = 0;
  local int unsigned m_threshold;
    function new(string name="");
       super.new(name);
       m_threshold = 1;
    endfunction
  static function void set_default (uvm_comparer comparer) ;
     uvm_coreservice_t coreservice ;
     coreservice = uvm_coreservice_t::get() ;
     coreservice.set_default_comparer(comparer) ;
  endfunction
  static function uvm_comparer get_default () ;
     uvm_coreservice_t coreservice ;
     coreservice = uvm_coreservice_t::get() ;
     return coreservice.get_default_comparer() ;
  endfunction
  virtual function bit compare_field (string name,
                                      uvm_bitstream_t lhs,
                                      uvm_bitstream_t rhs,
                                      int size,
                                      uvm_radix_enum radix=UVM_NORADIX);
    uvm_bitstream_t mask;
    string msg;
    if(size <= 64) begin
      return compare_field_int(name, lhs, rhs, size, radix);
    end
    mask = -1;
    mask >>= (UVM_STREAMBITS-size);
    if((lhs & mask) !== (rhs & mask)) begin
      case (radix)
        UVM_BIN: begin
          $swrite(msg, "%s: lhs = 'b%0b : rhs = 'b%0b",
                       name, lhs&mask, rhs&mask);
        end
        UVM_OCT: begin
          $swrite(msg, "%s: lhs = 'o%0o : rhs = 'o%0o",
                       name, lhs&mask, rhs&mask);
        end
        UVM_DEC: begin
          $swrite(msg, "%s: lhs = %0d : rhs = %0d",
                       name, lhs&mask, rhs&mask);
        end
        UVM_TIME: begin
          $swrite(msg, "%s: lhs = %0t : rhs = %0t",
               name, lhs&mask, rhs&mask);
        end
        UVM_STRING: begin
          $swrite(msg, "%s: lhs = %0s : rhs = %0s",
                       name, lhs&mask, rhs&mask);
        end
        UVM_ENUM: begin
          $swrite(msg, "%s: lhs = %0d : rhs = %0d",
                       name, lhs&mask, rhs&mask);
        end
        default: begin
          $swrite(msg, "%s: lhs = 'h%0x : rhs = 'h%0x",
                       name, lhs&mask, rhs&mask);
        end
      endcase
      print_msg(msg);
      return 0;
    end
    return 1;
  endfunction
  virtual function bit compare_field_int (string name,
                                          uvm_integral_t lhs,
                                          uvm_integral_t rhs,
                                          int size,
                                          uvm_radix_enum radix=UVM_NORADIX);
    logic [63:0] mask;
    string msg;
    if(size > 64) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/COMPARER/INT/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/COMPARER/INT/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/COMPARER/INT/BAD_SIZE", $sformatf("compare_field_int cannot be called with operand size of more than 64 bits. Input argument size=%0d",size), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_comparer.svh", 295, "", 1);
     end
   end
      return 0;
    end
    mask = -1;
    mask >>= (64-size);
    if((lhs & mask) !== (rhs & mask)) begin
      case (radix)
        UVM_BIN: begin
          $swrite(msg, "%s: lhs = 'b%0b : rhs = 'b%0b",
                       name, lhs&mask, rhs&mask);
        end
        UVM_OCT: begin
          $swrite(msg, "%s: lhs = 'o%0o : rhs = 'o%0o",
                       name, lhs&mask, rhs&mask);
        end
        UVM_DEC: begin
          $swrite(msg, "%s: lhs = %0d : rhs = %0d",
                       name, lhs&mask, rhs&mask);
        end
        UVM_TIME: begin
          $swrite(msg, "%s: lhs = %0t : rhs = %0t",
               name, lhs&mask, rhs&mask);
        end
        UVM_STRING: begin
          $swrite(msg, "%s: lhs = %0s : rhs = %0s",
                       name, lhs&mask, rhs&mask);
        end
        UVM_ENUM: begin
          $swrite(msg, "%s: lhs = %0d : rhs = %0d",
                       name, lhs&mask, rhs&mask);
        end
        default: begin
          $swrite(msg, "%s: lhs = 'h%0x : rhs = 'h%0x",
                       name, lhs&mask, rhs&mask);
        end
      endcase
      print_msg(msg);
      return 0;
    end
    return 1;
  endfunction
  virtual function bit compare_field_real (string name,
                                          real lhs,
                                          real rhs);
    string msg;
    if(lhs != rhs) begin
      $swrite(msg, name, ": lhs = ", lhs, " : rhs = ", rhs);
      print_msg(msg);
      return 0;
    end
    return 1;
  endfunction
  local string m_object_names[$];
  local function string m_current_context(string name="");
    if (m_object_names.size()  == 0) begin
      return name;
    end
    else if ((m_object_names.size() == 1) && (name=="")) begin
      return m_object_names[0];
    end
    else begin
      string     full_name;
      foreach(m_object_names[i]) begin
        if (i == m_object_names.size() - 1) begin
          full_name = {full_name, m_object_names[i]};
        end
        else begin
          full_name  = {full_name, m_object_names[i], "."};
        end
      end
      if (name != "") begin
        return {full_name, ".", name};
      end
      else begin
        return full_name;
      end
    end
  endfunction : m_current_context
  virtual function bit compare_object (string name,
                                       uvm_object lhs,
                                       uvm_object rhs);
    int old_result ;
    uvm_field_op field_op ;
    uvm_policy::recursion_state_e prev_state;
    bit ret_val = 1;
    if (rhs == lhs) begin
      return ret_val;
    end
    m_object_names.push_back(name);
    if (policy == UVM_REFERENCE && lhs != rhs) begin
      print_msg_object(lhs, rhs);
      ret_val = 0;
    end
    if (ret_val && (rhs == null || lhs == null)) begin
      print_msg_object(lhs, rhs);
      ret_val = 0;
    end
    if (ret_val) begin
      prev_state      = object_compared(lhs,rhs,get_recursion_policy(),ret_val);
      if (prev_state != uvm_policy::NEVER) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/COPIER/LOOP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/COPIER/LOOP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/COPIER/LOOP", {"Possible loop when comparing '", lhs.get_full_name(), "' to '", rhs.get_full_name(), "'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_comparer.svh", 458, "", 1);
     end
   end
      end
      push_active_object(lhs);
      m_recur_states[lhs][rhs][get_recursion_policy()]  = '{uvm_policy::STARTED,0};
      old_result = get_result();
      if (get_check_type() && (lhs.get_object_type() != rhs.get_object_type())) begin
        if(lhs.get_type_name() != rhs.get_type_name()) begin
          print_msg({"type: lhs = \"", lhs.get_type_name(), "\" : rhs = \"", rhs.get_type_name(), "\""});
        end
        else begin
          print_msg({"get_object_type() for ",lhs.get_name()," does not match get_object_type() for ",rhs.get_name()});
        end
      end
      field_op = uvm_field_op::m_get_available_op();
      field_op.set(UVM_COMPARE,this,rhs);
      lhs.do_execute_op(field_op);
      if (field_op.user_hook_enabled()) begin
        ret_val = lhs.do_compare(rhs,this);
      end
      field_op.m_recycle();
      if (ret_val && (get_result() > old_result)) begin
        ret_val = 0;
      end
      m_recur_states[lhs][rhs][get_recursion_policy()]  = '{uvm_policy::FINISHED,ret_val};
      void'(pop_active_object());
    end
    void'(m_object_names.pop_back());
    if (!ret_val && (get_active_object_depth() == 0)) begin
      string msg ;
      if(get_result()) begin
        if (get_show_max() && (get_show_max() < get_result())) begin
          $swrite(msg, "%0d Miscompare(s) (%0d shown) for object ",
                  result, show_max);
        end
        else begin
          $swrite(msg, "%0d Miscompare(s) for object ", result);
        end
      end
      uvm_pkg::uvm_report(sev, "MISCMP", $sformatf("%s%s@%0d vs. %s@%0d", msg,
                                                   (lhs == null) ? "<null>" : lhs.get_name(),
                                                   (lhs == null) ? 0 : lhs.get_inst_id(),
                                                   (rhs == null) ? "<null>" : rhs.get_name(),
                                                   (rhs == null) ? 0 : rhs.get_inst_id()),
              get_verbosity(), "t/uvm/src/base/uvm_comparer.svh", 527);
    end
    return ret_val;
  endfunction
  virtual function bit compare_string (string name,
                                       string lhs,
                                       string rhs);
    string msg;
    if(lhs != rhs) begin
      msg = { name, ": lhs = \"", lhs, "\" : rhs = \"", rhs, "\""};
      print_msg(msg);
      return 0;
    end
    return 1;
  endfunction
  function void print_msg (string msg);
    string tmp = m_current_context(msg);
    result++;
    if((get_show_max() == 0) ||
       (get_result() <= get_show_max())) begin
      msg = {"Miscompare for ", tmp};
      uvm_pkg::uvm_report(sev, "MISCMP", msg, get_verbosity(), "t/uvm/src/base/uvm_comparer.svh", 575);
    end
    miscompares = { miscompares, tmp, "\n" };
  endfunction
  function void print_msg_object(uvm_object lhs, uvm_object rhs);
    string tmp = $sformatf("%s: lhs = @%0d : rhs = @%0d",
                           m_current_context(),
                           (lhs != null ? lhs.get_inst_id() : 0),
                           (rhs != null ? rhs.get_inst_id() : 0));
    result++;
    if((get_show_max() == 0) ||
       (get_result() <= get_show_max())) begin
      uvm_pkg::uvm_report(sev,
                           "MISCMP",
                           {"Miscompare for ", tmp},
                           get_verbosity(),
                           "t/uvm/src/base/uvm_comparer.svh",
                           601);
    end
    miscompares = { miscompares, tmp, "\n" };
  endfunction
  int depth;
  bit compare_map[uvm_object][uvm_object];
endclass
function void uvm_comparer::flush();
  miscompares = "" ;
  check_type = 1 ;
  result = 0 ;
  m_recur_states.delete();
endfunction
function uvm_policy::recursion_state_e uvm_comparer::object_compared(
  uvm_object lhs,
  uvm_object rhs,
  uvm_recursion_policy_enum recursion,
  output bit ret_val
);
  if (!m_recur_states.exists(lhs)) begin
    return NEVER ;
  end
  else if (!m_recur_states[lhs].exists(rhs)) begin
    return NEVER ;
  end
  else if (!m_recur_states[lhs][rhs].exists(recursion)) begin
    return NEVER ;
  end
  else begin
    if (m_recur_states[lhs][rhs][recursion].state == FINISHED) begin
      ret_val = m_recur_states[lhs][rhs][recursion].ret_val;
    end
    return m_recur_states[lhs][rhs][recursion].state ;
  end
endfunction
function string uvm_comparer::get_miscompares();
   return miscompares ;
endfunction
function int unsigned uvm_comparer::get_result();
   return result ;
endfunction
function void uvm_comparer::set_result(int unsigned result);
   this.result = result ;
endfunction
function void uvm_comparer::set_recursion_policy( uvm_recursion_policy_enum policy);
   this.policy = policy ;
endfunction
function uvm_recursion_policy_enum uvm_comparer::get_recursion_policy();
   return policy ;
endfunction
function void uvm_comparer::set_check_type( bit enabled );
   check_type = enabled ;
endfunction
function bit uvm_comparer::get_check_type();
   return check_type ;
endfunction
function void uvm_comparer::set_show_max (int unsigned show_max);
   this.show_max = show_max ;
endfunction
function int unsigned uvm_comparer::get_show_max();
   return show_max ;
endfunction
function void uvm_comparer::set_verbosity (int unsigned verbosity);
   this.verbosity = verbosity ;
endfunction
function int unsigned uvm_comparer::get_verbosity();
   return verbosity ;
endfunction
function void uvm_comparer::set_severity (uvm_severity severity);
   sev = severity ;
endfunction
function uvm_severity uvm_comparer::get_severity();
   return sev ;
endfunction
function void uvm_comparer::set_threshold (int unsigned threshold);
   m_threshold = threshold;
endfunction
function int unsigned uvm_comparer::get_threshold();
   return m_threshold;
endfunction
typedef bit signed [(4096*8)-1:0] uvm_pack_bitstream_t;
class uvm_packer extends uvm_policy;
   typedef uvm_object_registry#(uvm_packer,"uvm_packer") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_packer tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_packer";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_packer";
     endfunction : get_type_name
    uvm_factory m_factory;
    local uvm_object m_object_references[int];
  extern virtual function void set_packed_bits (ref bit unsigned stream[]);
  extern virtual function void set_packed_bytes (ref byte unsigned stream[]);
  extern virtual function void set_packed_ints (ref int unsigned stream[]);
  extern virtual function void set_packed_longints (ref longint unsigned stream[]);
  extern virtual function void get_packed_bits (ref bit unsigned stream[]);
  extern virtual function void get_packed_bytes (ref byte unsigned stream[]);
  extern virtual function void get_packed_ints (ref int unsigned stream[]);
  extern virtual function void get_packed_longints (ref longint unsigned stream[]);
  static function void set_default (uvm_packer packer) ;
     uvm_coreservice_t coreservice ;
     coreservice = uvm_coreservice_t::get() ;
     coreservice.set_default_packer(packer) ;
  endfunction
  static function uvm_packer get_default () ;
     uvm_coreservice_t coreservice ;
     coreservice = uvm_coreservice_t::get() ;
     return coreservice.get_default_packer() ;
  endfunction
  extern virtual function void flush ();
  extern virtual function void pack_field (uvm_bitstream_t value, int size);
  extern function new(string name="");
  extern virtual function void pack_field_int (uvm_integral_t value, int size);
  extern virtual function void pack_bits(ref bit value[], input int size = -1);
  extern virtual function void pack_bytes(ref byte value[], input int size = -1);
  extern virtual function void pack_ints(ref int value[], input int size = -1);
  extern virtual function void pack_string (string value);
  extern virtual function void pack_time (time value);
  extern virtual function void pack_real (real value);
  extern virtual function void pack_object (uvm_object value);
  extern virtual function void pack_object_with_meta (uvm_object value);
  extern virtual function void pack_object_wrapper (uvm_object_wrapper value);
  extern virtual function bit is_null ();
  extern virtual function bit is_object_wrapper();
  extern virtual function uvm_bitstream_t unpack_field (int size);
  extern virtual function uvm_integral_t unpack_field_int (int size);
  extern virtual function void unpack_bits(ref bit value[], input int size = -1);
  extern virtual function void unpack_bytes(ref byte value[], input int size = -1);
  extern virtual function void unpack_ints(ref int value[], input int size = -1);
  extern virtual function string unpack_string ();
  extern virtual function time unpack_time ();
  extern virtual function real unpack_real ();
  extern virtual function void unpack_object (uvm_object value);
  extern virtual function void unpack_object_with_meta (inout uvm_object value);
  extern virtual function uvm_object_wrapper unpack_object_wrapper();
  extern virtual function int get_packed_size();
  static bit bitstream[];
  static bit fabitstream[];
  int        m_pack_iter;
  int        m_unpack_iter;
  bit   reverse_order;
  byte  byte_size     = 8;
  int   word_size     = 16;
  bit   nopack;
  uvm_pack_bitstream_t m_bits;
  bit physical = 1;
  bit abstract = 1 ;
  extern function void index_error(int index, string id, int sz);
  extern function bit enough_bits(int needed, string id);
  function string unpack_string_with_size (int num_chars=-1);
     return unpack_string();
  endfunction
endclass
function void uvm_packer::index_error(int index, string id, int sz);
    uvm_report_error("PCKIDX",
        $sformatf("index %0d for get_%0s too large; valid index range is 0-%0d.",
                  index,id,((m_pack_iter+sz-1)/sz)-1), UVM_NONE);
endfunction
function bit uvm_packer::enough_bits(int needed, string id);
  if ((m_pack_iter - m_unpack_iter) < needed) begin
    uvm_report_error("PCKSZ",
        $sformatf("%0d bits needed to unpack %0s, yet only %0d available.",
                  needed, id, (m_pack_iter - m_unpack_iter)), UVM_NONE);
    return 0;
  end
  return 1;
endfunction
function int uvm_packer::get_packed_size();
  return m_pack_iter - m_unpack_iter;
endfunction
function void uvm_packer::flush();
  m_pack_iter = 64;
  m_unpack_iter = 64;
  m_bits       = 0;
  m_object_references.delete();
  m_object_references[0] = null;
  m_factory = null;
  super.flush();
endfunction : flush
function void uvm_packer::get_packed_bits(ref bit unsigned stream[]);
  stream        = new[m_pack_iter];
  m_bits[31:0]  = m_pack_iter;
  m_bits[63:32] = m_unpack_iter;
  for (int i=0;i<m_pack_iter;i++) begin
    stream[i] = m_bits[i];
  end
endfunction
`define M__UVM_GET_PACKED(T) \
function void uvm_packer::get_packed_``T``s (ref T unsigned stream[] ); \
   int sz;                                                              \
   T v;                                                                 \
   sz = (m_pack_iter + $high(v)) / $bits(T);                            \
   m_bits[31:0] = m_pack_iter; /* Reserved Bits */                      \
   m_bits[63:32] = m_unpack_iter; /* Reserved Bits */                   \
   stream = new[sz];                                                    \
   foreach (stream[i]) begin                                            \
      if (i != sz-1 || (m_pack_iter % $bits(T)) == 0) begin             \
    v = m_bits[ i* $bits(T) +: $bits(T) ];                          \
      end                                                               \
      else begin                                                        \
    v = m_bits[ i* $bits(T) +: $bits(T) ] & ({$bits(T){1'b1}} >> ($bits(T)-(m_pack_iter%$bits(T)))); \
      end                                                               \
      stream[i] = v;                                                    \
   end                                                                  \
endfunction
function void uvm_packer::get_packed_bytes (ref byte unsigned stream[] );
   int sz;
   byte v;
   sz = (m_pack_iter + $high(v)) / $bits(byte);
   m_bits[31:0] = m_pack_iter;
   m_bits[63:32] = m_unpack_iter;
   stream = new[sz];
   foreach (stream[i]) begin
      if (i != sz-1 || (m_pack_iter % $bits(byte)) == 0) begin
    v = m_bits[ i* $bits(byte) +: $bits(byte) ];
      end
      else begin
    v = m_bits[ i* $bits(byte) +: $bits(byte) ] & ({$bits(byte){1'b1}} >> ($bits(byte)-(m_pack_iter%$bits(byte))));
      end
      stream[i] = v;
   end
endfunction
function void uvm_packer::get_packed_ints (ref int unsigned stream[] );
   int sz;
   int v;
   sz = (m_pack_iter + $high(v)) / $bits(int);
   m_bits[31:0] = m_pack_iter;
   m_bits[63:32] = m_unpack_iter;
   stream = new[sz];
   foreach (stream[i]) begin
      if (i != sz-1 || (m_pack_iter % $bits(int)) == 0) begin
    v = m_bits[ i* $bits(int) +: $bits(int) ];
      end
      else begin
    v = m_bits[ i* $bits(int) +: $bits(int) ] & ({$bits(int){1'b1}} >> ($bits(int)-(m_pack_iter%$bits(int))));
      end
      stream[i] = v;
   end
endfunction
function void uvm_packer::get_packed_longints (ref longint unsigned stream[] );
   int sz;
   longint v;
   sz = (m_pack_iter + $high(v)) / $bits(longint);
   m_bits[31:0] = m_pack_iter;
   m_bits[63:32] = m_unpack_iter;
   stream = new[sz];
   foreach (stream[i]) begin
      if (i != sz-1 || (m_pack_iter % $bits(longint)) == 0) begin
    v = m_bits[ i* $bits(longint) +: $bits(longint) ];
      end
      else begin
    v = m_bits[ i* $bits(longint) +: $bits(longint) ] & ({$bits(longint){1'b1}} >> ($bits(longint)-(m_pack_iter%$bits(longint))));
      end
      stream[i] = v;
   end
endfunction
 `undef M__UVM_GET_PACKED
function void uvm_packer::set_packed_bits (ref bit stream []);
  int bit_size;
  bit_size = stream.size();
    for (int i=0;i<bit_size;i++) begin
      m_bits[i] = stream[i];
    end
  m_pack_iter = m_bits[31:0];
  m_unpack_iter = m_bits[63:32];
endfunction
`define M__UVM_SET_PACKED(T) \
function void uvm_packer::set_packed_``T``s (ref T unsigned stream []); \
   int count;                                                           \
   foreach(stream[i]) begin                                             \
     m_bits[count +: $bits(T)] = stream[i];                             \
     count += $bits(T);                                                 \
   end                                                                  \
  m_pack_iter = m_bits[31:0]; /* Reserved Bits */                       \
  m_unpack_iter = m_bits[63:32]; /* Reserved Bits */                    \
endfunction
function void uvm_packer::set_packed_bytes (ref byte unsigned stream []);
   int count;
   foreach(stream[i]) begin
     m_bits[count +: $bits(byte)] = stream[i];
     count += $bits(byte);
   end
  m_pack_iter = m_bits[31:0];
  m_unpack_iter = m_bits[63:32];
endfunction
function void uvm_packer::set_packed_ints (ref int unsigned stream []);
   int count;
   foreach(stream[i]) begin
     m_bits[count +: $bits(int)] = stream[i];
     count += $bits(int);
   end
  m_pack_iter = m_bits[31:0];
  m_unpack_iter = m_bits[63:32];
endfunction
function void uvm_packer::set_packed_longints (ref longint unsigned stream []);
   int count;
   foreach(stream[i]) begin
     m_bits[count +: $bits(longint)] = stream[i];
     count += $bits(longint);
   end
  m_pack_iter = m_bits[31:0];
  m_unpack_iter = m_bits[63:32];
endfunction
 `undef M__UVM_SET_PACKED
function void uvm_packer::pack_object(uvm_object value);
  uvm_field_op field_op;
  if (value == null ) begin
    m_bits[m_pack_iter +: 4] = 0;
    m_pack_iter += 4;
    return ;
  end
  else begin
    m_bits[m_pack_iter +: 4]  = 4'hF;
    m_pack_iter += 4;
  end
  push_active_object(value);
  field_op = uvm_field_op::m_get_available_op() ;
  field_op.set(UVM_PACK,this,value);
  value.do_execute_op(field_op);
  if (field_op.user_hook_enabled()) begin
    value.do_pack(this);
  end
  field_op.m_recycle();
  void'(pop_active_object());
endfunction
function void uvm_packer::pack_object_with_meta(uvm_object value);
  int reference_id;
  foreach(m_object_references[i]) begin
    if (m_object_references[i] == value) begin
      pack_field_int(i,32);
      return;
    end
  end
  reference_id = m_object_references.size();
  pack_field_int(reference_id,32);
  m_object_references[reference_id] = value;
  pack_object_wrapper(value.get_object_type());
  pack_object(value);
endfunction
function void uvm_packer::pack_object_wrapper(uvm_object_wrapper value);
  string type_name;
  if (value != null) begin
    pack_string(value.get_type_name());
  end
endfunction
function void uvm_packer::pack_real(real value);
  pack_field_int($realtobits(value), 64);
endfunction
function void uvm_packer::pack_time(time value);
  pack_field_int(value, 64);
endfunction
function void uvm_packer::pack_field(uvm_bitstream_t value, int size);
  for (int i=0; i<size; i++) begin
    m_bits[m_pack_iter+i] = value[i];
  end
  m_pack_iter += size;
endfunction
function void uvm_packer::pack_field_int(uvm_integral_t value, int size);
  for (int i=0; i<size; i++) begin
    m_bits[m_pack_iter+i] = value[i];
  end
  m_pack_iter += size;
endfunction
function void uvm_packer::pack_bits(ref bit value[], input int size = -1);
   if (size < 0) begin
     size = value.size();
   end
   if (size > value.size()) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/BAD_SIZE", $sformatf("pack_bits called with size '%0d', which exceeds value.size() of '%0d'", size, value.size()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 639, "", 1);
     end
   end
     return;
   end
   for (int i=0; i<size; i++) begin
     m_bits[m_pack_iter+i] = value[i];
   end
   m_pack_iter += size;
endfunction
function void uvm_packer::pack_bytes(ref byte value[], input int size = -1);
   int max_size = value.size() * $bits(byte);
   if (size < 0) begin
     size = max_size;
   end
   if (size > max_size) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/BAD_SIZE", $sformatf("pack_bytes called with size '%0d', which exceeds value size of '%0d'", size, max_size), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 667, "", 1);
     end
   end
     return;
   end
   else begin
     int idx_select;
     for (int i=0; i<size; i++) begin
       idx_select = i;
       m_bits[m_pack_iter+i] = value[idx_select / $bits(byte)][idx_select % $bits(byte)];
     end
     m_pack_iter += size;
   end
endfunction
function void uvm_packer::pack_ints(ref int value[], input int size = -1);
   int max_size = value.size() * $bits(int);
   if (size < 0) begin
     size = max_size;
   end
   if (size > max_size) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/BAD_SIZE", $sformatf("pack_ints called with size '%0d', which exceeds value size of '%0d'", size, max_size), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 699, "", 1);
     end
   end
     return;
   end
   else begin
     int idx_select;
     for (int i=0; i<size; i++) begin
       idx_select = i;
       m_bits[m_pack_iter+i] = value[idx_select / $bits(int)][idx_select % $bits(int)];
     end
     m_pack_iter += size;
   end
endfunction
function void uvm_packer::pack_string(string value);
  byte b;
  foreach (value[index]) begin
    m_bits[m_pack_iter +: 8] = value[index];
    m_pack_iter += 8;
  end
   m_bits[m_pack_iter +: 8] = 0;
   m_pack_iter += 8;
endfunction
function bit uvm_packer::is_null();
    return (m_bits[m_unpack_iter+:4]==0);
endfunction
function bit uvm_packer::is_object_wrapper();
    return (m_bits[m_unpack_iter+:4]==1);
endfunction
function void uvm_packer::unpack_object(uvm_object value);
  uvm_field_op field_op;
  if (is_null()) begin
    if (value != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/UNPACK/N2NN") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/UNPACK/N2NN") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/UNPACK/N2NN", "attempt to unpack a null object into a not-null object!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 752, "", 1);
     end
   end
      return;
    end
    m_unpack_iter += 4;
    return;
  end
  else begin
    if (value == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/UNPACK/NN2N") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/UNPACK/NN2N") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/UNPACK/NN2N", "attempt to unpack a non-null object into a null object!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 760, "", 1);
     end
   end
      return;
    end
    m_unpack_iter += 4;
    push_active_object(value);
    field_op = uvm_field_op::m_get_available_op() ;
    field_op.set(UVM_UNPACK,this,value);
    value.do_execute_op(field_op);
    if (field_op.user_hook_enabled()) begin
      value.do_unpack(this);
    end
    field_op.m_recycle();
    void'(pop_active_object());
  end
endfunction
function void uvm_packer::unpack_object_with_meta(inout uvm_object value);
  int reference_id;
  reference_id = unpack_field_int(32);
  if (m_object_references.exists(reference_id)) begin
    value = m_object_references[reference_id];
    return;
  end
  else begin
    uvm_object_wrapper __wrapper = unpack_object_wrapper();
    if ((__wrapper != null) &&
    ((value == null) || (value.get_object_type() != __wrapper))) begin
      value = __wrapper.create_object("");
      if (value == null) begin
        value = __wrapper.create_component("",null);
      end
    end
  end
  m_object_references[reference_id] = value;
  unpack_object(value);
endfunction
function uvm_object_wrapper uvm_packer::unpack_object_wrapper();
  string type_name;
  type_name = unpack_string();
  if (m_factory == null) begin
    m_factory = uvm_factory::get();
  end
  if (m_factory.is_type_name_registered(type_name)) begin
    return m_factory.find_wrapper_by_name(type_name);
  end
  return null;
endfunction
function real uvm_packer::unpack_real();
  if (enough_bits(64,"real")) begin
    return $bitstoreal(unpack_field_int(64));
  end
endfunction
function time uvm_packer::unpack_time();
  if (enough_bits(64,"time")) begin
    return unpack_field_int(64);
  end
endfunction
function uvm_bitstream_t uvm_packer::unpack_field(int size);
  unpack_field = 'b0;
  if (enough_bits(size,"integral")) begin
    m_unpack_iter += size;
    for (int i=0; i<size; i++) begin
      unpack_field[i] = m_bits[m_unpack_iter-size+i];
    end
  end
endfunction
function uvm_integral_t uvm_packer::unpack_field_int(int size);
  unpack_field_int = 'b0;
  if (enough_bits(size,"integral")) begin
    m_unpack_iter += size;
    for (int i=0; i<size; i++) begin
      unpack_field_int[i] = m_bits[m_unpack_iter-size+i];
    end
  end
endfunction
function void uvm_packer::unpack_bits(ref bit value[], input int size = -1);
   if (size < 0) begin
     size = value.size();
   end
   if (size > value.size()) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/BAD_SIZE", $sformatf("unpack_bits called with size '%0d', which exceeds value.size() of '%0d'", size, value.size()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 901, "", 1);
     end
   end
     return;
   end
   if (enough_bits(size, "integral")) begin
     m_unpack_iter += size;
     for (int i=0; i<size; i++) begin
       value[i] = m_bits[m_unpack_iter-size+i];
     end
   end
endfunction
function void uvm_packer::unpack_bytes(ref byte value[], input int size = -1);
   int max_size = value.size() * $bits(byte);
   if (size < 0) begin
     size = max_size;
   end
   if (size > max_size) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/BAD_SIZE", $sformatf("unpack_bytes called with size '%0d', which exceeds value size of '%0d'", size, value.size()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 930, "", 1);
     end
   end
     return;
   end
   else begin
     if (enough_bits(size, "integral")) begin
       m_unpack_iter += size;
       for (int i=0; i<size; i++) begin
         value[ i / $bits(byte) ][ i % $bits(byte) ] = m_bits[m_unpack_iter-size+i];
       end
     end
   end
endfunction
function void uvm_packer::unpack_ints(ref int value[], input int size = -1);
   int max_size = value.size() * $bits(int);
   if (size < 0) begin
     size = max_size;
   end
   if (size > max_size) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/PACKER/BAD_SIZE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/PACKER/BAD_SIZE", $sformatf("unpack_ints called with size '%0d', which exceeds value size of '%0d'", size, value.size()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_packer.svh", 960, "", 1);
     end
   end
     return;
   end
   else begin
     if (enough_bits(size, "integral")) begin
       m_unpack_iter += size;
       for (int i=0; i<size; i++) begin
         value[ i / $bits(int) ][ i % $bits(int) ] = m_bits[m_unpack_iter-size+i];
       end
     end
   end
endfunction
function string uvm_packer::unpack_string();
  byte b;
  int i; i=0;
  while(enough_bits(8,"string") &&
        (m_bits[m_unpack_iter+:8] != 0) ) begin
    unpack_string = {unpack_string," "};
    unpack_string[i] = m_bits[m_unpack_iter +: 8];
    m_unpack_iter += 8;
    ++i;
  end
  if(enough_bits(8,"string")) begin
    m_unpack_iter += 8;
  end
endfunction
function uvm_packer::new(string name="");
  super.new(name);
  flush();
endfunction
class uvm_packer_array_extension extends uvm_object;
   typedef uvm_object_registry#(uvm_packer_array_extension,"uvm_packer_array_extension") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_packer_array_extension tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_packer_array_extension";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_packer_array_extension";
     endfunction : get_type_name
    extern function new(string name="unnamed-uvm_packer_array_extension");
    extern static function uvm_packer_array_extension get();
endclass
function uvm_packer_array_extension::new(string name="unnamed-uvm_packer_array_extension");
    super.new(name);
endfunction
function uvm_packer_array_extension uvm_packer_array_extension::get();
    static uvm_packer_array_extension singleton;
    if ( singleton == null )
        singleton = new("uvm_packer_array_extension");
    return singleton;
endfunction
virtual class uvm_link_base extends uvm_object;
   function new(string name="unnamed-uvm_link_base");
      super.new(name);
   endfunction : new
   function void set_lhs(uvm_object lhs);
      do_set_lhs(lhs);
   endfunction : set_lhs
   function uvm_object get_lhs();
      return do_get_lhs();
   endfunction : get_lhs
   function void set_rhs(uvm_object rhs);
      do_set_rhs(rhs);
   endfunction : set_rhs
   function uvm_object get_rhs();
      return do_get_rhs();
   endfunction : get_rhs
   function void set(uvm_object lhs, rhs);
      do_set_lhs(lhs);
      do_set_rhs(rhs);
   endfunction : set
   pure virtual function void do_set_lhs(uvm_object lhs);
   pure virtual function uvm_object do_get_lhs();
   pure virtual function void do_set_rhs(uvm_object rhs);
   pure virtual function uvm_object do_get_rhs();
endclass : uvm_link_base
class uvm_parent_child_link extends uvm_link_base;
   local uvm_object m_lhs;
   local uvm_object m_rhs;
   typedef uvm_object_registry#(uvm_parent_child_link,"uvm_parent_child_link") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_parent_child_link tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_parent_child_link";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_parent_child_link";
     endfunction : get_type_name
   function new(string name="unnamed-uvm_parent_child_link");
      super.new(name);
   endfunction : new
   static function uvm_parent_child_link get_link(uvm_object lhs,
                                                  uvm_object rhs,
                                                  string name="pc_link");
      process p_;
      string s_;
      p_ = process::self();
      if (p_ != null)
        begin
          s_ = p_.get_randstate();
        end
      get_link = new(name);
      if (p_ != null)
        begin
          p_.set_randstate(s_);
        end
      get_link.set(lhs, rhs);
   endfunction : get_link
   virtual function void do_set_lhs(uvm_object lhs);
      m_lhs = lhs;
   endfunction : do_set_lhs
   virtual function uvm_object do_get_lhs();
      return m_lhs;
   endfunction : do_get_lhs
   virtual function void do_set_rhs(uvm_object rhs);
      m_rhs = rhs;
   endfunction : do_set_rhs
   virtual function uvm_object do_get_rhs();
      return m_rhs;
   endfunction : do_get_rhs
endclass : uvm_parent_child_link
class uvm_cause_effect_link extends uvm_link_base;
   local uvm_object m_lhs;
   local uvm_object m_rhs;
   typedef uvm_object_registry#(uvm_cause_effect_link,"uvm_cause_effect_link") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_cause_effect_link tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_cause_effect_link";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_cause_effect_link";
     endfunction : get_type_name
   function new(string name="unnamed-uvm_cause_effect_link");
      super.new(name);
   endfunction : new
   static function uvm_cause_effect_link get_link(uvm_object lhs,
                                                 uvm_object rhs,
                                                 string name="ce_link");
      process p_;
      string s_;
      p_ = process::self();
      if (p_ != null)
        begin
          s_ = p_.get_randstate();
        end
      get_link = new(name);
      if (p_ != null)
        begin
          p_.set_randstate(s_);
        end
      get_link.set(lhs, rhs);
   endfunction : get_link
   virtual function void do_set_lhs(uvm_object lhs);
      m_lhs = lhs;
   endfunction : do_set_lhs
   virtual function uvm_object do_get_lhs();
      return m_lhs;
   endfunction : do_get_lhs
   virtual function void do_set_rhs(uvm_object rhs);
      m_rhs = rhs;
   endfunction : do_set_rhs
   virtual function uvm_object do_get_rhs();
      return m_rhs;
   endfunction : do_get_rhs
endclass : uvm_cause_effect_link
class uvm_related_link extends uvm_link_base;
   local uvm_object m_lhs;
   local uvm_object m_rhs;
   typedef uvm_object_registry#(uvm_related_link,"uvm_related_link") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_related_link tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_related_link";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_related_link";
     endfunction : get_type_name
   function new(string name="unnamed-uvm_related_link");
      super.new(name);
   endfunction : new
   static function uvm_related_link get_link(uvm_object lhs,
                                                 uvm_object rhs,
                                                 string name="ce_link");
      process p_;
      string s_;
      p_ = process::self();
      if (p_ != null)
        begin
          s_ = p_.get_randstate();
        end
      get_link = new(name);
      if (p_ != null)
        begin
          p_.set_randstate(s_);
        end
      get_link.set(lhs, rhs);
   endfunction : get_link
   virtual function void do_set_lhs(uvm_object lhs);
      m_lhs = lhs;
   endfunction : do_set_lhs
   virtual function uvm_object do_get_lhs();
      return m_lhs;
   endfunction : do_get_lhs
   virtual function void do_set_rhs(uvm_object rhs);
      m_rhs = rhs;
   endfunction : do_set_rhs
   virtual function uvm_object do_get_rhs();
      return m_rhs;
   endfunction : do_get_rhs
endclass : uvm_related_link
typedef class uvm_recorder;
typedef class uvm_tr_stream;
typedef class uvm_link_base;
virtual class uvm_tr_database extends uvm_object;
   local bit m_is_opened;
   local bit m_streams[uvm_tr_stream];
   function new(string name="unnamed-uvm_tr_database");
      super.new(name);
   endfunction : new
   function bit open_db();
      if (!m_is_opened) begin
        m_is_opened = do_open_db();
      end
      return m_is_opened;
   endfunction : open_db
   function bit close_db();
      if (m_is_opened) begin
        if (do_close_db()) begin
          m_is_opened = 0;
        end
      end
      return (m_is_opened == 0);
   endfunction : close_db
   function bit is_open();
      return m_is_opened;
   endfunction : is_open
   function uvm_tr_stream open_stream(string name,
                                      string scope="",
                                      string type_name="");
      if (!open_db()) begin
        return null;
      end
      else begin
        process p = process::self();
        string s;
        if (p != null) begin
          s = p.get_randstate();
        end
        open_stream = do_open_stream(name, scope, type_name);
        if (open_stream != null) begin
          m_streams[open_stream] = 1;
          open_stream.m_do_open(this, scope, type_name);
        end
        if (p != null) begin
          p.set_randstate(s);
        end
      end
   endfunction : open_stream
   function void m_free_stream(uvm_tr_stream stream);
      if (m_streams.exists(stream)) begin
        m_streams.delete(stream);
      end
   endfunction : m_free_stream
   function unsigned get_streams(ref uvm_tr_stream q[$]);
      q.delete();
      foreach (m_streams[idx]) begin
        q.push_back(idx);
      end
      return q.size();
   endfunction : get_streams
   function void establish_link(uvm_link_base link);
      uvm_tr_stream s_lhs, s_rhs;
      uvm_recorder r_lhs, r_rhs;
      uvm_object lhs = link.get_lhs();
      uvm_object rhs = link.get_rhs();
      uvm_tr_database db;
      if (lhs == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TR_DB/BAD_LINK", "left hand side '<null>' is not supported in links for 'uvm_tr_database'", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_database.svh", 186, "", 1);
     end
   end
        return;
      end
      if (rhs == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TR_DB/BAD_LINK", "right hand side '<null>' is not supported in links for 'uvm_tr_database'", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_database.svh", 191, "", 1);
     end
   end
        return;
      end
      if (!$cast(s_lhs, lhs) &&
          !$cast(r_lhs, lhs)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TR_DB/BAD_LINK", $sformatf("left hand side of type '%s' not supported in links for 'uvm_tr_database'", lhs.get_type_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_database.svh", 199, "", 1);
     end
   end
        return;
      end
      if (!$cast(s_rhs, rhs) &&
          !$cast(r_rhs, rhs)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TR_DB/BAD_LINK", $sformatf("right hand side of type '%s' not supported in links for 'uvm_record_datbasae'", rhs.get_type_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_database.svh", 206, "", 1);
     end
   end
        return;
      end
      if (r_lhs != null) begin
        s_lhs = r_lhs.get_stream();
      end
      if (r_rhs != null) begin
        s_rhs = r_rhs.get_stream();
      end
      if ((s_lhs != null) && (s_lhs.get_db() != this)) begin
        db = s_lhs.get_db();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TR_DB/BAD_LINK", $sformatf("attempt to link stream from '%s' into '%s'", db.get_name(), this.get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_database.svh", 221, "", 1);
     end
   end
        return;
      end
      if ((s_rhs != null) && (s_rhs.get_db() != this)) begin
        db = s_rhs.get_db();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TR_DB/BAD_LINK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TR_DB/BAD_LINK", $sformatf("attempt to link stream from '%s' into '%s'", db.get_name(), this.get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_database.svh", 228, "", 1);
     end
   end
        return;
      end
      do_establish_link(link);
   endfunction : establish_link
   pure virtual protected function bit do_open_db();
   pure virtual protected function bit do_close_db();
   pure virtual protected function uvm_tr_stream do_open_stream(string name,
                                                                string scope,
                                                                string type_name);
   pure virtual protected function void do_establish_link(uvm_link_base link);
endclass : uvm_tr_database
typedef class uvm_recorder;
typedef class uvm_tr_stream;
typedef class uvm_link_base;
typedef class uvm_simple_lock_dap;
typedef class uvm_text_tr_stream;
class uvm_text_tr_database extends uvm_tr_database;
   local uvm_simple_lock_dap#(string) m_filename_dap;
   UVM_FILE m_file;
   typedef uvm_object_registry#(uvm_text_tr_database,"uvm_text_tr_database") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_text_tr_database tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_text_tr_database";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_text_tr_database";
     endfunction : get_type_name
   function new(string name="unnamed-uvm_text_tr_database");
      super.new(name);
      m_filename_dap = new("filename_dap");
      m_filename_dap.set("tr_db.log");
   endfunction : new
   protected virtual function bit do_open_db();
      if (m_file == 0) begin
        m_file = $fopen(m_filename_dap.get(), "a+");
        if (m_file != 0) begin
          m_filename_dap.lock();
        end
      end
      return (m_file != 0);
   endfunction : do_open_db
   protected virtual function bit do_close_db();
      if (m_file != 0) begin
        fork
          begin
            $fclose(m_file);
          end
        join_none
        m_filename_dap.unlock();
      end
      return 1;
   endfunction : do_close_db
   protected virtual function uvm_tr_stream do_open_stream(string name,
                                                           string scope,
                                                           string type_name);
      uvm_text_tr_stream m_stream = uvm_text_tr_stream::type_id::create(name);
      return m_stream;
   endfunction : do_open_stream
   protected virtual function void do_establish_link(uvm_link_base link);
      uvm_recorder r_lhs, r_rhs;
      uvm_object lhs = link.get_lhs();
      uvm_object rhs = link.get_rhs();
      void'($cast(r_lhs, lhs));
      void'($cast(r_rhs, rhs));
      if ((r_lhs == null) ||
          (r_rhs == null)) begin
        return;
      end
      else begin
        uvm_parent_child_link pc_link;
        uvm_related_link re_link;
        if ($cast(pc_link, link)) begin
          $fdisplay(m_file,"  LINK @%0t {TXH1:%0d TXH2:%0d RELATION=%0s}",
                      $time,
                      r_lhs.get_handle(),
                      r_rhs.get_handle(),
                      "child");
        end
        else if ($cast(re_link, link)) begin
          $fdisplay(m_file,"  LINK @%0t {TXH1:%0d TXH2:%0d RELATION=%0s}",
                      $time,
                         r_lhs.get_handle(),
                      r_rhs.get_handle(),
                      "");
        end
      end
   endfunction : do_establish_link
   function void set_file_name(string filename);
      if (filename == "") begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TXT_DB/EMPTY_NAME") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TXT_DB/EMPTY_NAME") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TXT_DB/EMPTY_NAME", "Ignoring attempt to set file name to ''!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_text_tr_database.svh", 210, "", 1);
     end
   end
        return;
      end
      if (!m_filename_dap.try_set(filename)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/TXT_DB/SET_AFTER_OPEN") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/TXT_DB/SET_AFTER_OPEN") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/TXT_DB/SET_AFTER_OPEN", "Ignoring attempt to change file name after opening the db!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_text_tr_database.svh", 216, "", 1);
     end
   end
        return;
      end
   endfunction : set_file_name
endclass : uvm_text_tr_database
class m_uvm_tr_stream_cfg;
   uvm_tr_database db;
   string scope;
   string stream_type_name;
endclass : m_uvm_tr_stream_cfg
typedef class uvm_set_before_get_dap;
typedef class uvm_text_recorder;
virtual class uvm_tr_stream extends uvm_object;
   local uvm_set_before_get_dap#(m_uvm_tr_stream_cfg) m_cfg_dap;
   local bit m_records[uvm_recorder];
   local bit m_warn_null_cfg;
   local bit m_is_opened;
   local bit m_is_closed;
   function new(string name="unnamed-uvm_tr_stream");
      super.new(name);
      m_cfg_dap = new("cfg_dap");
   endfunction : new
   local static int m_ids_by_stream[uvm_tr_stream];
   function uvm_tr_database get_db();
      m_uvm_tr_stream_cfg m_cfg;
      if (!m_cfg_dap.try_get(m_cfg))
        begin
          if (m_warn_null_cfg == 1)
          begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/REC_STR/NO_CFG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/REC_STR/NO_CFG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/REC_STR/NO_CFG", $sformatf("attempt to retrieve DB from '%s' before it was set!", get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_stream.svh", 106, "", 1);
     end
   end
          end
          m_warn_null_cfg = 0;
          return null;
        end
      return m_cfg.db;
   endfunction : get_db
   function string get_scope();
      m_uvm_tr_stream_cfg m_cfg;
      if (!m_cfg_dap.try_get(m_cfg))
        begin
          if (m_warn_null_cfg == 1)
          begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/REC_STR/NO_CFG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/REC_STR/NO_CFG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/REC_STR/NO_CFG", $sformatf("attempt to retrieve scope from '%s' before it was set!", get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_stream.svh", 124, "", 1);
     end
   end
          end
          m_warn_null_cfg = 0;
          return "";
        end
      return m_cfg.scope;
   endfunction : get_scope
   function string get_stream_type_name();
      m_uvm_tr_stream_cfg m_cfg;
      if (!m_cfg_dap.try_get(m_cfg))
        begin
          if (m_warn_null_cfg == 1)
          begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/REC_STR/NO_CFG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/REC_STR/NO_CFG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/REC_STR/NO_CFG", $sformatf("attempt to retrieve STREAM_TYPE_NAME from '%s' before it was set!", get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_stream.svh", 142, "", 1);
     end
   end
          end
          m_warn_null_cfg = 0;
          return "";
        end
      return m_cfg.stream_type_name;
   endfunction : get_stream_type_name
   function void close();
      if (!is_open())
        begin
          return;
        end
      do_close();
      foreach (m_records[idx])
        begin
          if (idx.is_open())
          begin
            idx.close();
          end
        end
      m_is_opened = 0;
      m_is_closed = 1;
   endfunction : close
   function void free();
       process p;
       string s;
      uvm_tr_database db;
      if (!is_open() && !is_closed())
        begin
          return;
        end
      if (is_open())
        begin
          close();
        end
      do_free();
      foreach (m_records[idx])
        begin
          idx.free();
        end
      db = get_db();
      m_is_closed = 0;
      p = process::self();
      if(p != null)
        begin
          s = p.get_randstate();
        end
      m_cfg_dap = new("cfg_dap");
      if(p != null)
        begin
          p.set_randstate(s);
        end
      m_warn_null_cfg = 1;
      if (m_ids_by_stream.exists(this))
        begin
          m_free_id(m_ids_by_stream[this]);
        end
      if (db != null)
        begin
          db.m_free_stream(this);
        end
   endfunction : free
   function void m_do_open(uvm_tr_database db,
                           string scope="",
                           string stream_type_name="");
      m_uvm_tr_stream_cfg m_cfg;
      uvm_tr_database m_db;
      if (db == null)
        begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/REC_STR/NULL_DB") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/REC_STR/NULL_DB") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/REC_STR/NULL_DB", $sformatf("Illegal attempt to set DB for '%s' to '<null>'", this.get_full_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_stream.svh", 267, "", 1);
     end
   end
          return;
        end
      if (m_cfg_dap.try_get(m_cfg))
        begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/REC_STR/RE_CFG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/REC_STR/RE_CFG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/REC_STR/RE_CFG", $sformatf("Illegal attempt to re-open '%s'", this.get_full_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_tr_stream.svh", 275, "", 1);
     end
   end
        end
      else
        begin
          m_cfg = new();
          m_cfg.db = db;
          m_cfg.scope = scope;
          m_cfg.stream_type_name = stream_type_name;
          m_cfg_dap.set(m_cfg);
          m_is_opened = 1;
          do_open(db, scope, stream_type_name);
        end
   endfunction : m_do_open
   function bit is_open();
      return m_is_opened;
   endfunction : is_open
   function bit is_closed();
      return m_is_closed;
   endfunction : is_closed
   function uvm_recorder open_recorder(string name,
                                      time   open_time = 0,
                                      string type_name="");
      time m_time = (open_time == 0) ? $time : open_time;
      if (!is_open())
        begin
          return null;
        end
      else
        begin
          process p = process::self();
          string s;
          if (p != null)
          begin
            s = p.get_randstate();
          end
          open_recorder = do_open_recorder(name,
                                          m_time,
                                          type_name);
          if (open_recorder != null)
          begin
            m_records[open_recorder] = 1;
            open_recorder.m_do_open(this, m_time, type_name);
          end
          if (p != null)
          begin
            p.set_randstate(s);
          end
        end
   endfunction : open_recorder
   function void m_free_recorder(uvm_recorder recorder);
      if (m_records.exists(recorder))
        begin
          m_records.delete(recorder);
        end
   endfunction : m_free_recorder
   function unsigned get_recorders(ref uvm_recorder q[$]);
      q.delete();
      foreach (m_records[idx])
        begin
          q.push_back(idx);
        end
      return q.size();
   endfunction : get_recorders
   local static uvm_tr_stream m_streams_by_id[int];
   function int get_handle();
      if (!is_open() && !is_closed())
        begin
          return 0;
        end
      else
        begin
          int handle = get_inst_id();
          if (m_ids_by_stream.exists(this) && m_ids_by_stream[this] != handle)
          begin
            m_streams_by_id.delete(m_ids_by_stream[this]);
          end
          m_streams_by_id[handle] = this;
          m_ids_by_stream[this] = handle;
          return handle;
        end
   endfunction : get_handle
   static function uvm_tr_stream get_stream_from_handle(int id);
      if (id == 0)
        begin
          return null;
        end
      if ($isunknown(id) || !m_streams_by_id.exists(id))
        begin
          return null;
        end
      return m_streams_by_id[id];
   endfunction : get_stream_from_handle
   static function void m_free_id(int id);
      uvm_tr_stream stream;
      if (!$isunknown(id) && m_streams_by_id.exists(id))
        begin
          stream = m_streams_by_id[id];
        end
      if (stream != null)
        begin
          m_streams_by_id.delete(id);
          m_ids_by_stream.delete(stream);
        end
   endfunction : m_free_id
   protected virtual function void do_open(uvm_tr_database db,
                                           string scope,
                                           string stream_type_name);
   endfunction : do_open
   protected virtual function void do_close();
   endfunction : do_close
   protected virtual function void do_free();
   endfunction : do_free
   protected virtual function uvm_recorder do_open_recorder(string name,
                                                            time   open_time,
                                                            string type_name);
      return null;
   endfunction : do_open_recorder
endclass : uvm_tr_stream
class uvm_text_tr_stream extends uvm_tr_stream;
   local uvm_text_tr_database m_text_db;
   typedef uvm_object_registry#(uvm_text_tr_stream,"uvm_text_tr_stream") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_text_tr_stream tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_text_tr_stream";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_text_tr_stream";
     endfunction : get_type_name
function void do_execute_op( uvm_field_op op );
  super.do_execute_op(op);
  __m_uvm_execute_field_op(op);
endfunction : do_execute_op
local function void __m_uvm_execute_field_op( uvm_field_op __local_op__ );
   uvm_field_flag_t local_op_type__;
   uvm_text_tr_stream local_rhs__;
   uvm_resource_base local_rsrc__;
   string local_rsrc_name__;
   uvm_object local_obj__;
   bit local_success__;
   typedef uvm_text_tr_stream __local_type__;
   int local_size__;
   uvm_printer __local_printer__;
   uvm_comparer __local_comparer__;
   uvm_recorder __local_recorder__;
   uvm_packer __local_packer__;
   uvm_copier __local_copier__;
   uvm_queue#(uvm_acs_name_struct) __local_field_names__;
   void'($cast(local_rhs__, __local_op__.get_rhs()));
   if (($cast(local_rsrc__, __local_op__.get_rhs())) &&
       (local_rsrc__ != null))
     local_rsrc_name__ = local_rsrc__.get_name();
   local_op_type__ = __local_op__.get_op_type();
   case (local_op_type__)
     UVM_PRINT: begin
       $cast(__local_printer__, __local_op__.get_policy());
     end
     UVM_COMPARE: begin
       if (local_rhs__ == null) return;
       $cast(__local_comparer__, __local_op__.get_policy());
     end
     UVM_RECORD: begin
       $cast(__local_recorder__, __local_op__.get_policy());
     end
     UVM_PACK, UVM_UNPACK: begin
       $cast(__local_packer__, __local_op__.get_policy());
     end
     UVM_COPY: begin
       if (local_rhs__ == null) return;
       $cast(__local_copier__, __local_op__.get_policy());
     end
     UVM_SET: begin
       if (local_rsrc__ == null) return;
     end
     UVM_CHECK_FIELDS: begin
       $cast(__local_field_names__, __local_op__.get_rhs());
     end
     default:
       return;
   endcase
endfunction : __m_uvm_execute_field_op
   function new(string name="unnamed-uvm_text_tr_stream");
      super.new(name);
   endfunction : new
   protected virtual function void do_open(uvm_tr_database db,
                                           string scope,
                                           string stream_type_name);
      $cast(m_text_db, db);
      if (m_text_db.open_db())
        begin
          $fdisplay(m_text_db.m_file,
                  "  CREATE_STREAM @%0t {NAME:%s T:%s SCOPE:%s STREAM:%0d}",
                  $time,
                  this.get_name(),
                  stream_type_name,
                  scope,
                  this.get_handle());
        end
   endfunction : do_open
   protected virtual function void do_close();
      if (m_text_db.open_db())
        begin
          $fdisplay(m_text_db.m_file,
                  "  CLOSE_STREAM @%0t {NAME:%s T:%s SCOPE:%s STREAM:%0d}",
                  $time,
                  this.get_name(),
                  this.get_stream_type_name(),
                  this.get_scope(),
                  this.get_handle());
        end
   endfunction : do_close
   protected virtual function void do_free();
      if (m_text_db.open_db())
        begin
          $fdisplay(m_text_db.m_file,
                  "  FREE_STREAM @%0t {NAME:%s T:%s SCOPE:%s STREAM:%0d}",
                  $time,
                  this.get_name(),
                  this.get_stream_type_name(),
                  this.get_scope(),
                  this.get_handle());
        end
      m_text_db = null;
      return;
   endfunction : do_free
   protected virtual function uvm_recorder do_open_recorder(string name,
                                                           time   open_time,
                                                           string type_name);
      if (m_text_db.open_db())
        begin
          return uvm_text_recorder::type_id::create(name);
        end
      return null;
   endfunction : do_open_recorder
endclass : uvm_text_tr_stream
typedef class uvm_report_message;
virtual class uvm_recorder extends uvm_policy;
   typedef uvm_abstract_object_registry#(uvm_recorder,"uvm_recorder") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
     static function string type_name();
       return "uvm_recorder";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_recorder";
     endfunction : get_type_name
  local uvm_set_before_get_dap#(uvm_tr_stream) m_stream_dap;
  local bit m_warn_null_stream;
  local bit m_is_opened;
  local bit m_is_closed;
  local time m_open_time;
  local time m_close_time;
  int recording_depth;
  uvm_radix_enum default_radix = UVM_HEX;
  bit identifier = 1;
  bit physical = 1;
  bit abstract = 1 ;
  integer tr_handle;
   uvm_policy::recursion_state_e m_recur_states[uvm_object][uvm_recursion_policy_enum  ] ;
  uvm_recursion_policy_enum policy = UVM_DEFAULT_POLICY;
  virtual function void set_recursion_policy(uvm_recursion_policy_enum policy);
    this.policy  = policy;
  endfunction : set_recursion_policy
  virtual function uvm_recursion_policy_enum get_recursion_policy();
    return this.policy;
  endfunction : get_recursion_policy
  virtual function void set_id_enabled(bit enabled);
    this.identifier = enabled;
  endfunction : set_id_enabled
  virtual function bit get_id_enabled();
    return this.identifier;
  endfunction : get_id_enabled
  virtual function void set_default_radix(uvm_radix_enum radix);
    this.default_radix = radix;
  endfunction : set_default_radix
  virtual function uvm_radix_enum get_default_radix();
    return this.default_radix;
  endfunction : get_default_radix
  virtual function void flush();
    policy      = UVM_DEFAULT_POLICY;
    identifier  = 1;
    free();
    m_recur_states.delete();
  endfunction : flush
   local static int m_ids_by_recorder[uvm_recorder];
  function new(string name = "uvm_recorder");
     super.new(name);
     m_stream_dap = new("stream_dap");
     m_warn_null_stream = 1;
  endfunction
   function uvm_tr_stream get_stream();
      if (!m_stream_dap.try_get(get_stream)) begin
        if (m_warn_null_stream == 1) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM/REC/NO_CFG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM/REC/NO_CFG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM/REC/NO_CFG", $sformatf("attempt to retrieve STREAM from '%s' before it was set!", get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_recorder.svh", 192, "", 1);
     end
   end
        end
        m_warn_null_stream = 0;
      end
   endfunction : get_stream
   function void close(time close_time = 0);
      if (close_time == 0) begin
        close_time = $realtime;
      end
      if (!is_open()) begin
        return;
      end
      do_close(close_time);
      m_is_opened = 0;
      m_is_closed = 1;
      m_close_time = close_time;
   endfunction : close
   function void free(time close_time = 0);
       process p=process::self();
       string s;
       uvm_tr_stream stream;
      if (!is_open() && !is_closed()) begin
        return;
      end
      if (is_open()) begin
        close(close_time);
      end
      do_free();
      stream = get_stream();
      m_is_closed = 0;
      if(p != null) begin
        s=p.get_randstate();
      end
      m_stream_dap = new("stream_dap");
      if(p != null) begin
        p.set_randstate(s);
      end
      m_warn_null_stream = 1;
      if (m_ids_by_recorder.exists(this)) begin
        m_free_id(m_ids_by_recorder[this]);
      end
      if (stream != null) begin
        stream.m_free_recorder(this);
      end
   endfunction : free
   function bit is_open();
      return m_is_opened;
   endfunction : is_open
   function time get_open_time();
      return m_open_time;
   endfunction : get_open_time
   function bit is_closed();
      return m_is_closed;
   endfunction : is_closed
   function time get_close_time();
      return m_close_time;
   endfunction : get_close_time
  function void m_do_open(uvm_tr_stream stream, time open_time, string type_name);
     uvm_tr_stream m_stream;
     if (stream == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/REC/NULL_STREAM") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/REC/NULL_STREAM") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/REC/NULL_STREAM", $sformatf("Illegal attempt to set STREAM for '%s' to '<null>'", this.get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_recorder.svh", 323, "", 1);
     end
   end
       return;
     end
     if (m_stream_dap.try_get(m_stream)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/REC/RE_INIT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/REC/RE_INIT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/REC/RE_INIT", $sformatf("Illegal attempt to re-initialize '%s'", this.get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_recorder.svh", 330, "", 1);
     end
   end
       return;
     end
     m_stream_dap.set(stream);
     m_open_time = open_time;
     m_is_opened = 1;
     do_open(stream, open_time, type_name);
  endfunction : m_do_open
   local static uvm_recorder m_recorders_by_id[int];
   local static int m_id;
   static function void m_free_id(int id);
      uvm_recorder recorder;
      if ((!$isunknown(id)) && (m_recorders_by_id.exists(id))) begin
        recorder = m_recorders_by_id[id];
      end
      if (recorder != null) begin
        m_recorders_by_id.delete(id);
        m_ids_by_recorder.delete(recorder);
      end
   endfunction : m_free_id
   function int get_handle();
      if (!is_open() && !is_closed()) begin
        return 0;
      end
      else begin
        int handle = get_inst_id();
        if (m_ids_by_recorder.exists(this) && m_ids_by_recorder[this] != handle) begin
          m_recorders_by_id.delete(m_ids_by_recorder[this]);
        end
        m_recorders_by_id[handle] = this;
        m_ids_by_recorder[this] = handle;
        return handle;
      end
   endfunction : get_handle
   static function uvm_recorder get_recorder_from_handle(int id);
      if (id == 0) begin
        return null;
      end
      if (($isunknown(id)) || (!m_recorders_by_id.exists(id))) begin
        return null;
      end
      return m_recorders_by_id[id];
   endfunction : get_recorder_from_handle
   function void record_field(string name,
                              uvm_bitstream_t value,
                              int size,
                              uvm_radix_enum radix=UVM_NORADIX);
      if (get_stream() == null) begin
        return;
      end
      do_record_field(name, value, size, radix);
   endfunction : record_field
   function void record_field_int(string name,
                                  uvm_integral_t value,
                                  int size,
                                  uvm_radix_enum radix=UVM_NORADIX);
        if (get_stream() == null) begin
          return;
        end
      do_record_field_int(name, value, size, radix);
   endfunction : record_field_int
   function void record_field_real(string name,
                                   real value);
      if (get_stream() == null) begin
        return;
      end
      do_record_field_real(name, value);
   endfunction : record_field_real
   function void record_object(string name,
                               uvm_object value);
      if (get_stream() == null) begin
        return;
      end
      if (value == null) begin
        do_record_object(name, value);
      end
      else begin
        push_active_object(value);
        m_recur_states[value][get_recursion_policy()] = uvm_policy::STARTED ;
        do_record_object(name, value);
        m_recur_states[value][get_recursion_policy()] = uvm_policy::FINISHED ;
        void'(pop_active_object());
      end
   endfunction : record_object
   function void record_string(string name,
                               string value);
      if (get_stream() == null) begin
        return;
      end
      do_record_string(name, value);
   endfunction : record_string
   function void record_time(string name,
                             time value);
      if (get_stream() == null) begin
        return;
      end
      do_record_time(name, value);
   endfunction : record_time
   function void record_generic(string name,
                                string value,
                                string type_name="");
      if (get_stream() == null) begin
        return;
      end
      do_record_generic(name, value, type_name);
   endfunction : record_generic
  virtual function bit use_record_attribute();
     return 0;
  endfunction : use_record_attribute
   virtual function int get_record_attribute_handle();
      return get_handle();
   endfunction : get_record_attribute_handle
   protected virtual function void do_open(uvm_tr_stream stream,
                                             time open_time,
                                             string type_name);
   endfunction : do_open
   protected virtual function void do_close(time close_time);
   endfunction : do_close
   protected virtual function void do_free();
   endfunction : do_free
   pure virtual protected function void do_record_field(string name,
                                                        uvm_bitstream_t value,
                                                        int size,
                                                        uvm_radix_enum radix);
   pure virtual protected function void do_record_field_int(string name,
                                                            uvm_integral_t value,
                                                            int          size,
                                                            uvm_radix_enum radix);
   pure virtual protected function void do_record_field_real(string name,
                                                             real value);
   virtual protected function void do_record_object(string name,
                                                    uvm_object value);
     if ((get_recursion_policy() != UVM_REFERENCE) &&
         (value != null)) begin
       uvm_field_op field_op = uvm_field_op::m_get_available_op();
       field_op.set(UVM_RECORD, this, null);
       value.do_execute_op(field_op);
       if (field_op.user_hook_enabled()) begin
         value.do_record(this);
       end
       field_op.m_recycle();
     end
   endfunction : do_record_object
   virtual function uvm_policy::recursion_state_e object_recorded ( uvm_object value,
                                                                    uvm_recursion_policy_enum recursion);
      if (!m_recur_states.exists(value)) begin
        return NEVER ;
      end
      if (!m_recur_states[value].exists(recursion)) begin
        return NEVER ;
      end
      else begin
        return m_recur_states[value][recursion] ;
      end
   endfunction
   pure virtual protected function void do_record_string(string name,
                                                         string value);
   pure virtual protected function void do_record_time(string name,
                                                       time value);
   pure virtual protected function void do_record_generic(string name,
                                                          string value,
                                                          string type_name);
  virtual function bit open_file();
     return 0;
  endfunction
  virtual function integer create_stream (string name,
                                          string t,
                                          string scope);
     return -1;
  endfunction
  virtual function void m_set_attribute (int txh,
                                 string nm,
                                 string value);
  endfunction
  virtual function void set_attribute (int txh,
                               string nm,
                               logic [1023:0] value,
                               uvm_radix_enum radix,
                               int numbits=1024);
  endfunction
  virtual function int check_handle_kind (string htype, int handle);
     return 0;
  endfunction
  virtual function int begin_tr(string txtype,
                                     int stream,
                                     string nm,
                                     string label="",
                                     string desc="",
                                     time begin_time=0);
    return -1;
  endfunction
  virtual function void end_tr (int handle, time end_time=0);
  endfunction
  virtual function void link_tr(int h1,
                                 int h2,
                                 string relation="");
  endfunction
  virtual function void free_tr(int handle);
  endfunction
endclass
class uvm_text_recorder extends uvm_recorder;
   typedef uvm_object_registry#(uvm_text_recorder,"uvm_text_recorder") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_text_recorder tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_text_recorder";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_text_recorder";
     endfunction : get_type_name
   uvm_text_tr_database m_text_db;
   function new(string name="unnamed-uvm_text_recorder");
      super.new(name);
   endfunction : new
   protected virtual function void do_open(uvm_tr_stream stream,
                                             time open_time,
                                             string type_name);
      $cast(m_text_db, stream.get_db());
      if (m_text_db.open_db()) begin
        $fdisplay(m_text_db.m_file,
                  "    OPEN_RECORDER @%0t {TXH:%0d STREAM:%0d NAME:%s TIME:%0t TYPE=\"%0s\"}",
                  $realtime,
                  this.get_handle(),
                  stream.get_handle(),
                  this.get_name(),
                  open_time,
                  type_name);
      end
   endfunction : do_open
   protected virtual function void do_close(time close_time);
      if (m_text_db.open_db()) begin
        $fdisplay(m_text_db.m_file,
                   "    CLOSE_RECORDER @%0t {TXH:%0d TIME=%0t}",
                   $realtime,
                   this.get_handle(),
                   close_time);
      end
   endfunction : do_close
   protected virtual function void do_free();
      if (m_text_db.open_db()) begin
        $fdisplay(m_text_db.m_file,
                   "    FREE_RECORDER @%0t {TXH:%0d}",
                   $realtime,
                   this.get_handle());
      end
      m_text_db = null;
   endfunction : do_free
   protected virtual function void do_record_field(string name,
                                                   uvm_bitstream_t value,
                                                   int size,
                                                   uvm_radix_enum radix);
      if(radix == UVM_NORADIX) begin
        radix = get_default_radix();
      end
      write_attribute(m_current_context(name),
                      value,
                      radix,
                      size);
   endfunction : do_record_field
   protected virtual function void do_record_field_int(string name,
                                                       uvm_integral_t value,
                                                       int          size,
                                                       uvm_radix_enum radix);
      if(radix == UVM_NORADIX) begin
        radix = get_default_radix();
      end
      write_attribute_int(m_current_context(name),
                          value,
                          radix,
                          size);
   endfunction : do_record_field_int
   protected virtual function void do_record_field_real(string name,
                                                        real value);
      bit [63:0] ival = $realtobits(value);
      write_attribute_int(m_current_context(name),
                          ival,
                          UVM_REAL,
                          64);
   endfunction : do_record_field_real
  local string m_object_names[$];
  local function string m_current_context(string name="");
    if (m_object_names.size()  == 0) begin
      return name;
    end
    else if ((m_object_names.size() == 1) && (name=="")) begin
      return m_object_names[0];
    end
    else begin
      string     full_name;
      foreach(m_object_names[i]) begin
        if (i == m_object_names.size() - 1) begin
          full_name = {full_name, m_object_names[i]};
        end
        else begin
          full_name  = {full_name, m_object_names[i], "."};
        end
      end
      if (name != "") begin
        return {full_name, ".", name};
      end
      else begin
        return full_name;
      end
    end
  endfunction : m_current_context
   protected virtual function void do_record_object(string name,
                                                    uvm_object value);
      int            v;
      string         str;
      if(get_id_enabled()) begin
        if(value != null) begin
          v = value.get_inst_id();
        end
        write_attribute_int("inst_id",
                             v,
                             UVM_DEC,
                             32);
      end
      if (get_active_object_depth() > 1) begin
        m_object_names.push_back(name);
      end
      super.do_record_object(name, value);
      if (get_active_object_depth() > 1) begin
        void'(m_object_names.pop_back());
      end
   endfunction : do_record_object
   protected virtual function void do_record_string(string name,
                                                    string value);
      if (m_text_db.open_db()) begin
        $fdisplay(m_text_db.m_file,
                   "      SET_ATTR @%0t {TXH:%0d NAME:%s VALUE:%s   RADIX:%s BITS=%0d}",
                   $realtime,
                   this.get_handle(),
                   m_current_context(name),
                   value,
                   "UVM_STRING",
                   8+value.len());
      end
   endfunction : do_record_string
   protected virtual function void do_record_time(string name,
                                                    time value);
      write_attribute_int(m_current_context(name),
                          value,
                          UVM_TIME,
                          64);
   endfunction : do_record_time
   protected virtual function void do_record_generic(string name,
                                                     string value,
                                                     string type_name);
      write_attribute(m_current_context(name),
                      uvm_string_to_bits(value),
                      UVM_STRING,
                      8+value.len());
   endfunction : do_record_generic
   function void write_attribute(string nm,
                                 uvm_bitstream_t value,
                                 uvm_radix_enum radix,
                                 int numbits=$bits(uvm_bitstream_t));
      if (m_text_db.open_db()) begin
        $fdisplay(m_text_db.m_file,
                   "      SET_ATTR @%0t {TXH:%0d NAME:%s VALUE:%s   RADIX:%s BITS=%0d}",
                   $realtime,
                   this.get_handle(),
                   nm,
                   uvm_bit_vector_utils#(uvm_bitstream_t)::to_string(value, numbits, radix),
                   radix.name(),
                   numbits);
      end
   endfunction : write_attribute
   function void write_attribute_int(string  nm,
                                     uvm_integral_t value,
                                     uvm_radix_enum radix,
                                     int numbits=$bits(uvm_bitstream_t));
      if (m_text_db.open_db()) begin
        $fdisplay(m_text_db.m_file,
                   "      SET_ATTR @%0t {TXH:%0d NAME:%s VALUE:%s   RADIX:%s BITS=%0d}",
                   $realtime,
                   this.get_handle(),
                   nm,
                   uvm_bit_vector_utils#(uvm_integral_t)::to_string(value, numbits, radix),
                   radix.name(),
                   numbits);
      end
   endfunction : write_attribute_int
   string                                                   filename;
   bit                                                      filename_set;
  virtual function bit open_file();
     if (!filename_set) begin
       m_text_db.set_file_name(filename);
     end
     return m_text_db.open_db();
  endfunction
  virtual function integer create_stream (string name,
                                          string t,
                                          string scope);
     uvm_text_tr_stream stream;
     if (open_file()) begin
       $cast(stream,m_text_db.open_stream(name, scope, t));
       return stream.get_handle();
     end
     return 0;
  endfunction
  virtual function void m_set_attribute (int txh,
                                 string nm,
                                 string value);
     if (open_file()) begin
       UVM_FILE file = m_text_db.m_file;
       $fdisplay(file,"      SET_ATTR @%0t {TXH:%0d NAME:%s VALUE:%s}", $realtime,txh,nm,value);
     end
  endfunction
  virtual function void set_attribute (int txh,
                               string nm,
                               logic [1023:0] value,
                               uvm_radix_enum radix,
                               int numbits=1024);
     if (open_file()) begin
       UVM_FILE file = m_text_db.m_file;
       $fdisplay(file,
                   "      SET_ATTR @%0t {TXH:%0d NAME:%s VALUE:%s   RADIX:%s BITS=%0d}",
                   $realtime,
                   txh,
                   nm,
                   uvm_bit_vector_utils#(uvm_bitstream_t)::to_string(value, numbits, radix),
                   radix.name(),
                   numbits);
     end
  endfunction
  virtual function int check_handle_kind (string htype, int handle);
     return ((uvm_recorder::get_recorder_from_handle(handle) != null) ||
             (uvm_tr_stream::get_stream_from_handle(handle) != null));
  endfunction
  virtual function int begin_tr(string txtype,
                                     int stream,
                                     string nm,
                                     string label="",
                                     string desc="",
                                     time begin_time=0);
     if (open_file()) begin
       uvm_tr_stream stream_obj = uvm_tr_stream::get_stream_from_handle(stream);
       uvm_recorder recorder;
       if (stream_obj == null) begin
         return -1;
       end
       recorder = stream_obj.open_recorder(nm, begin_time, txtype);
       return recorder.get_handle();
     end
     return -1;
  endfunction
  virtual function void end_tr (int handle, time end_time=0);
     if (open_file()) begin
       uvm_recorder record = uvm_recorder::get_recorder_from_handle(handle);
       if (record != null) begin
         record.close(end_time);
       end
     end
  endfunction
  virtual function void link_tr(int h1,
                                 int h2,
                                 string relation="");
    if (open_file()) begin
      $fdisplay(m_text_db.m_file,"  LINK @%0t {TXH1:%0d TXH2:%0d RELATION=%0s}", $realtime,h1,h2,relation);
    end
  endfunction
  virtual function void free_tr(int handle);
     if (open_file()) begin
       uvm_recorder record = uvm_recorder::get_recorder_from_handle(handle);
       if (record != null) begin
         record.free();
       end
     end
  endfunction
endclass : uvm_text_recorder
typedef class uvm_object;
typedef class uvm_event;
typedef class uvm_callback;
typedef class uvm_callbacks;
virtual class uvm_event_callback#(type T=uvm_object) extends uvm_callback;
  function new (string name="");
    super.new(name);
  endfunction
  virtual function bit pre_trigger (uvm_event#(T) e, T data);
    return 0;
  endfunction
  virtual function void post_trigger (uvm_event#(T) e, T data);
    return;
  endfunction
  virtual function uvm_object create (string name="");
    return null;
  endfunction
endclass
virtual class uvm_event_base extends uvm_object;
   typedef uvm_abstract_object_registry#(uvm_event_base,"uvm_event_base") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
     static function string type_name();
       return "uvm_event_base";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_event_base";
     endfunction : get_type_name
    protected event      m_event;
    protected int        num_waiters;
    protected bit        on;
    protected time       trigger_time=0;
    function new (string name="");
        super.new(name);
    endfunction
    virtual task wait_on (bit delta = 0);
        if (on)
          begin
            if (delta)
            begin
              #0;
            end
            return;
          end
        num_waiters++;
        @on;
    endtask
    virtual task wait_off (bit delta = 0);
        if (!on)
          begin
            if (delta)
            begin
              #0;
            end
            return;
          end
        num_waiters++;
        @on;
    endtask
    virtual task wait_trigger ();
        num_waiters++;
        @m_event;
    endtask
    virtual task wait_ptrigger ();
        if (m_event.triggered)
          begin
            return;
          end
        num_waiters++;
        @m_event;
    endtask
    virtual function time get_trigger_time ();
        return trigger_time;
    endfunction
    virtual function bit is_on ();
        return (on == 1);
    endfunction
    virtual function bit is_off ();
        return (on == 0);
    endfunction
    virtual function void reset (bit wakeup = 0);
      event e;
      if (wakeup)
        begin
          ->m_event;
        end
      m_event = e;
      num_waiters = 0;
      on = 0;
      trigger_time = 0;
    endfunction
    virtual function void cancel ();
        if (num_waiters > 0)
          begin
            num_waiters--;
          end
    endfunction
    virtual function int get_num_waiters ();
        return num_waiters;
    endfunction
    virtual function void do_print (uvm_printer printer);
        printer.print_field_int("num_waiters", num_waiters, $bits(num_waiters), UVM_DEC, ".", "int");
        printer.print_field_int("on", on, $bits(on), UVM_BIN, ".", "bit");
        printer.print_time("trigger_time", trigger_time);
    endfunction
    virtual function void do_copy (uvm_object rhs);
        uvm_event_base e;
        super.do_copy(rhs);
        if(!$cast(e, rhs) || (e==null))
          begin
            return;
          end
        m_event = e.m_event;
        num_waiters = e.num_waiters;
        on = e.on;
        trigger_time = e.trigger_time;
    endfunction
endclass
class uvm_event#(type T=uvm_object) extends uvm_event_base;
    typedef uvm_event#(T) this_type;
    typedef uvm_event_callback#(T) cb_type;
    typedef uvm_callbacks#(this_type, cb_type) cbs_type;
    static local function bit m_register_cb();
        return cbs_type::m_register_pair("uvm_pkg::uvm_event#(T)",
                                         "uvm_pkg::uvm_event_callback#(T)"
                                        );
    endfunction : m_register_cb
    static local bit m_cb_registered = m_register_cb();
   typedef uvm_object_registry #(this_type) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     this_type tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
    virtual function string get_type_name();
        return "uvm_pkg::uvm_event#(T)";
    endfunction : get_type_name
    local T trigger_data;
    local T default_data;
    function new (string name="");
        super.new(name);
    endfunction
    virtual function void reset (bit wakeup = 0);
        trigger_data = get_default_data();
        super.reset(wakeup);
    endfunction : reset
    virtual task wait_trigger_data (output T data);
        wait_trigger();
        data = get_trigger_data();
    endtask
    virtual task wait_ptrigger_data (output T data);
        wait_ptrigger();
        data = get_trigger_data();
    endtask
    virtual function void trigger (T data=get_default_data());
      int   skip;
      cb_type cb_q[$];
      skip=0;
      cbs_type::get_all(cb_q, this);
      foreach (cb_q[i])
        begin
          skip += cb_q[i].pre_trigger(this, data);
        end
      if (skip==0)
        begin
          on = 1;
          trigger_time = $realtime;
          trigger_data = data;
          ->m_event;
          foreach (cb_q[i])
          begin
            cb_q[i].post_trigger(this, data);
          end
          num_waiters = 0;
        end
    endfunction
    virtual function T get_trigger_data ();
        return trigger_data;
    endfunction
        virtual function T get_default_data();
       return default_data;
    endfunction : get_default_data
        virtual function void set_default_data(T data);
       default_data = data;
    endfunction : set_default_data
    virtual function void do_print (uvm_printer printer);
       uvm_event#(uvm_object) oe;
       cb_type cb_q[$];
       super.do_print(printer);
       cbs_type::get_all(cb_q, this);
           printer.print_array_header("callbacks", cb_q.size(), "queue");
       foreach(cb_q[e])
         begin
           printer.print_object($sformatf("[%0d]", e), cb_q[e], "[");
         end
           printer.print_array_footer(cb_q.size());
       if ($cast(oe, this))
         begin
           printer.print_object("trigger_data", oe.get_trigger_data());
         end
       else
         begin
           uvm_event#(string) se;
           if ($cast(se, this))
           begin
             printer.print_string("trigger_data", se.get_trigger_data());
           end
         end
    endfunction
    virtual function void do_copy (uvm_object rhs);
       this_type e;
       cb_type cb_q[$];
       super.do_copy(rhs);
       if(!$cast(e, rhs) || (e==null))
         begin
           return;
         end
       trigger_data = e.trigger_data;
       begin
         cbs_type::get_all(cb_q, this);
         foreach(cb_q[i])
           begin
             cbs_type::delete(this, cb_q[i]);
           end
         cb_q.delete();
         cbs_type::get_all(cb_q, e);
         foreach(cb_q[i])
           begin
             cbs_type::add(this, cb_q[i]);
           end
       end
    endfunction
    virtual function void add_callback(cb_type cb, bit append=1);
        uvm_apprepend ordering;
        ordering = (append) ? UVM_APPEND : UVM_PREPEND;
        cbs_type::add(this, cb, ordering);
    endfunction
    virtual function void delete_callback(cb_type cb);
        cbs_type::delete(this, cb);
    endfunction
endclass
class uvm_barrier extends uvm_object;
  local  int       threshold;
  local  int       num_waiters;
  local  bit       at_threshold;
  local  bit       auto_reset;
  local  uvm_event#(uvm_object) m_event;
   typedef uvm_object_registry#(uvm_barrier,"uvm_barrier") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_barrier tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_barrier";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_barrier";
     endfunction : get_type_name
  function new (string name="", int threshold=0);
    super.new(name);
    m_event = new({"barrier_",name});
    this.threshold = threshold;
    num_waiters = 0;
    auto_reset = 1;
    at_threshold = 0;
  endfunction
  virtual task wait_for();
    if (at_threshold)
      begin
        return;
      end
    num_waiters++;
    if (num_waiters >= threshold)
      begin
        if (!auto_reset)
        begin
          at_threshold=1;
        end
        m_trigger();
        return;
      end
    m_event.wait_trigger();
  endtask
  virtual function void reset (bit wakeup=1);
    at_threshold = 0;
    if (num_waiters)
      begin
        if (wakeup)
        begin
          m_event.trigger();
        end
        else
        begin
          m_event.reset();
        end
      end
    num_waiters = 0;
  endfunction
  virtual function void set_auto_reset (bit value=1);
    at_threshold = 0;
    auto_reset = value;
  endfunction
  virtual function void set_threshold (int threshold);
    this.threshold = threshold;
    if (threshold <= num_waiters)
      begin
        reset(1);
      end
  endfunction
  virtual function int get_threshold ();
    return threshold;
  endfunction
  virtual function int get_num_waiters ();
    return num_waiters;
  endfunction
  virtual function void cancel ();
    m_event.cancel();
    num_waiters = m_event.get_num_waiters();
  endfunction
  local task m_trigger();
    m_event.trigger();
    num_waiters=0;
    #0;
  endtask
  virtual function void do_print (uvm_printer printer);
    printer.print_field_int("threshold", threshold, $bits(threshold), UVM_DEC, ".", "int");
    printer.print_field_int("num_waiters", num_waiters, $bits(num_waiters), UVM_DEC, ".", "int");
    printer.print_field_int("at_threshold", at_threshold, $bits(at_threshold), UVM_BIN, ".", "bit");
    printer.print_field_int("auto_reset", auto_reset, $bits(auto_reset), UVM_BIN, ".", "bit");
  endfunction
  virtual function void do_copy (uvm_object rhs);
    uvm_barrier b;
    super.do_copy(rhs);
    if(!$cast(b, rhs) || (b==null))
      begin
        return;
      end
    threshold = b.threshold;
    num_waiters = b.num_waiters;
    at_threshold = b.at_threshold;
    auto_reset = b.auto_reset;
    m_event = b.m_event;
  endfunction
endclass
typedef class uvm_root;
typedef class uvm_callback;
typedef class uvm_callbacks_base;
class uvm_typeid_base;
  static string typename;
  static uvm_callbacks_base typeid_map[uvm_typeid_base];
  static uvm_typeid_base type_map[uvm_callbacks_base];
endclass
class uvm_typeid#(type T=uvm_object) extends uvm_typeid_base;
  static uvm_typeid#(T) m_b_inst;
  static function uvm_typeid#(T) get();
    if(m_b_inst == null) begin
      m_b_inst = new;
    end
    return m_b_inst;
  endfunction
endclass
class uvm_callbacks_base extends uvm_object;
  typedef uvm_callbacks_base this_type;
    static bit m_tracing = 1;
  static this_type m_b_inst;
  static uvm_pool#(uvm_object,uvm_queue#(uvm_callback)) m_pool;
  static function this_type m_initialize();
    if(m_b_inst == null) begin
      m_b_inst = new;
      m_pool = new;
    end
    return m_b_inst;
  endfunction
  this_type       m_this_type[$];
  uvm_typeid_base m_super_type;
  uvm_typeid_base m_derived_types[$];
  virtual function bit m_am_i_a(uvm_object obj);
    return 0;
  endfunction
  virtual function bit m_is_for_me(uvm_callback cb);
    return 0;
  endfunction
  virtual function bit m_is_registered(uvm_object obj, uvm_callback cb);
    return 0;
  endfunction
  virtual function uvm_queue#(uvm_callback) m_get_tw_cb_q(uvm_object obj);
    return null;
  endfunction
  virtual function void m_add_tw_cbs(uvm_callback cb, uvm_apprepend ordering);
  endfunction
  virtual function bit m_delete_tw_cbs(uvm_callback cb);
    return 0;
  endfunction
  function bit check_registration(uvm_object obj, uvm_callback cb);
    this_type dt;
    if (m_is_registered(obj,cb)) begin
      return 1;
    end
    foreach(m_this_type[i]) begin
      if(m_b_inst != m_this_type[i] && m_this_type[i].m_is_registered(obj,cb)) begin
        return 1;
      end
    end
    if(obj == null) begin
      foreach(m_derived_types[i]) begin
        dt = uvm_typeid_base::typeid_map[m_derived_types[i] ];
        if(dt != null && dt.check_registration(null,cb)) begin
          return 1;
        end
      end
    end
    return 0;
  endfunction
endclass
class uvm_typed_callbacks#(type T=uvm_object) extends uvm_callbacks_base;
  static uvm_queue#(uvm_callback) m_tw_cb_q;
  static string m_typename;
  typedef uvm_typed_callbacks#(T) this_type;
  typedef uvm_callbacks_base      super_type;
  static this_type m_t_inst;
  static function this_type m_initialize();
    if(m_t_inst == null) begin
      void'(super_type::m_initialize());
      m_t_inst = new;
      m_t_inst.m_tw_cb_q = new("typewide_queue");
    end
    return m_t_inst;
  endfunction
  virtual function bit m_am_i_a(uvm_object obj);
    T this_type_inst;
    if (obj == null) begin
      return 1;
    end
    return($cast(this_type_inst,obj));
  endfunction
  virtual function uvm_queue#(uvm_callback) m_get_tw_cb_q(uvm_object obj);
    if(m_am_i_a(obj)) begin
      foreach(m_derived_types[i]) begin
        super_type dt;
        dt = uvm_typeid_base::typeid_map[m_derived_types[i] ];
        if(dt != null && dt != this) begin
          m_get_tw_cb_q = dt.m_get_tw_cb_q(obj);
          if(m_get_tw_cb_q != null) begin
            return m_get_tw_cb_q;
          end
        end
      end
      return m_t_inst.m_tw_cb_q;
    end
    else begin
      return null;
    end
  endfunction
  static function int m_cb_find(uvm_queue#(uvm_callback) q, uvm_callback cb);
    for(int i=0; i<q.size(); ++i) begin
      if(q.get(i) == cb) begin
        return i;
      end
    end
    return -1;
  endfunction
  virtual function void m_add_tw_cbs(uvm_callback cb, uvm_apprepend ordering);
    super_type cb_pair;
    uvm_object obj;
    T me;
    uvm_queue#(uvm_callback) q;
    if(m_cb_find(m_t_inst.m_tw_cb_q,cb) == -1) begin
      if(ordering == UVM_APPEND) begin
        m_t_inst.m_tw_cb_q.push_back(cb);
      end
      else begin
        m_t_inst.m_tw_cb_q.push_front(cb);
      end
    end
    if(m_t_inst.m_pool.first(obj)) begin
      do begin
        if($cast(me,obj)) begin
          q = m_t_inst.m_pool.get(obj);
          if(q==null) begin
            q=new;
            m_t_inst.m_pool.add(obj,q);
          end
          if(m_cb_find(q,cb) == -1) begin
            if(ordering == UVM_APPEND) begin
              q.push_back(cb);
            end
            else begin
              q.push_front(cb);
            end
          end
        end
      end
      while(m_t_inst.m_pool.next(obj));
    end
    foreach(m_derived_types[i]) begin
      cb_pair = uvm_typeid_base::typeid_map[m_derived_types[i] ];
      if(cb_pair != this) begin
        cb_pair.m_add_tw_cbs(cb,ordering);
      end
    end
  endfunction
  virtual function bit m_delete_tw_cbs(uvm_callback cb);
    super_type cb_pair;
    uvm_object obj;
    uvm_queue#(uvm_callback) q;
    int pos = m_cb_find(m_t_inst.m_tw_cb_q,cb);
    if(pos != -1) begin
      m_t_inst.m_tw_cb_q.delete(pos);
      m_delete_tw_cbs = 1;
    end
    if(m_t_inst.m_pool.first(obj)) begin
      do begin
        q = m_t_inst.m_pool.get(obj);
        if(q==null) begin
          q=new;
          m_t_inst.m_pool.add(obj,q);
        end
        pos = m_cb_find(q,cb);
        if(pos != -1) begin
          q.delete(pos);
          m_delete_tw_cbs = 1;
        end
      end
      while(m_t_inst.m_pool.next(obj));
    end
    foreach(m_derived_types[i]) begin
      cb_pair = uvm_typeid_base::typeid_map[m_derived_types[i] ];
      if(cb_pair != this) begin
        m_delete_tw_cbs |= cb_pair.m_delete_tw_cbs(cb);
      end
    end
  endfunction
  static function void display(T obj=null);
    T me;
    string cbq[$];
    string inst_q[$];
    string mode_q[$];
    uvm_callback cb;
    string blanks = "                             ";
    uvm_object bobj = obj;
    string qs[$];
    uvm_queue#(uvm_callback) q;
    string tname, str;
    int max_cb_name=0, max_inst_name=0;
    m_tracing = 0;
    if(m_typename != "") begin
      tname = m_typename;
    end
    else if(obj != null) begin
      tname = obj.get_type_name();
    end
    else begin
      tname = "*";
    end
    q = m_t_inst.m_tw_cb_q;
    for(int i=0; i<q.size(); ++i) begin
      cb = q.get(i);
      cbq.push_back(cb.get_name());
      inst_q.push_back("(*)");
      if(cb.is_enabled()) begin
        mode_q.push_back("ON");
      end
      else begin
        mode_q.push_back("OFF");
      end
      str = cb.get_name();
      max_cb_name = max_cb_name > str.len() ? max_cb_name : str.len();
      str = "(*)";
      max_inst_name = max_inst_name > str.len() ? max_inst_name : str.len();
    end
    if(obj ==null) begin
      if(m_t_inst.m_pool.first(bobj)) begin
        do begin
          if($cast(me,bobj)) begin
            break;
          end
        end
        while(m_t_inst.m_pool.next(bobj));
      end
      if(me != null || m_t_inst.m_tw_cb_q.size()) begin
        qs.push_back($sformatf("Registered callbacks for all instances of %s\n", tname));
        qs.push_back("---------------------------------------------------------------\n");
      end
      if(me != null) begin
        do begin
          if($cast(me,bobj)) begin
            q = m_t_inst.m_pool.get(bobj);
            if (q==null) begin
              q=new;
              m_t_inst.m_pool.add(bobj,q);
            end
            for(int i=0; i<q.size(); ++i) begin
              cb = q.get(i);
              cbq.push_back(cb.get_name());
              inst_q.push_back(bobj.get_full_name());
              if(cb.is_enabled()) begin
                mode_q.push_back("ON");
              end
              else begin
                mode_q.push_back("OFF");
              end
              str = cb.get_name();
              max_cb_name = max_cb_name > str.len() ? max_cb_name : str.len();
              str = bobj.get_full_name();
              max_inst_name = max_inst_name > str.len() ? max_inst_name : str.len();
            end
          end
        end
        while (m_t_inst.m_pool.next(bobj));
      end
      else begin
        qs.push_back($sformatf("No callbacks registered for any instances of type %s\n", tname));
      end
    end
    else begin
      if(m_t_inst.m_pool.exists(bobj) || m_t_inst.m_tw_cb_q.size()) begin
        qs.push_back($sformatf("Registered callbacks for instance %s of %s\n", obj.get_full_name(), tname));
        qs.push_back("---------------------------------------------------------------\n");
      end
      if(m_t_inst.m_pool.exists(bobj)) begin
        q = m_t_inst.m_pool.get(bobj);
        if(q==null) begin
          q=new;
          m_t_inst.m_pool.add(bobj,q);
        end
        for(int i=0; i<q.size(); ++i) begin
          cb = q.get(i);
          cbq.push_back(cb.get_name());
          inst_q.push_back(bobj.get_full_name());
          if(cb.is_enabled()) begin
            mode_q.push_back("ON");
          end
          else begin
            mode_q.push_back("OFF");
          end
          str = cb.get_name();
          max_cb_name = max_cb_name > str.len() ? max_cb_name : str.len();
          str = bobj.get_full_name();
          max_inst_name = max_inst_name > str.len() ? max_inst_name : str.len();
        end
      end
    end
    if(!cbq.size()) begin
      if(obj == null) begin
        str = "*";
      end
      else begin
        str = obj.get_full_name();
      end
      qs.push_back($sformatf("No callbacks registered for instance %s of type %s\n", str, tname));
    end
    foreach (cbq[i]) begin
      qs.push_back($sformatf("%s  %s %s on %s  %s\n", cbq[i], blanks.substr(0,max_cb_name-cbq[i].len()-1), inst_q[i], blanks.substr(0,max_inst_name - inst_q[i].len()-1), mode_q[i]));
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/CB/DISPLAY") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/CB/DISPLAY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/CB/DISPLAY", uvm_pkg::m_uvm_string_queue_join(qs), UVM_NONE, "t/uvm/src/base/uvm_callback.svh", 511, "", 1);
     end
   end
    m_tracing = 1;
  endfunction
endclass
class uvm_callbacks #(type T=uvm_object, type CB=uvm_callback)
    extends uvm_typed_callbacks#(T);
  typedef uvm_typed_callbacks#(T) super_type;
  typedef uvm_callbacks#(T,CB) this_type;
  local static this_type m_inst;
  static uvm_typeid_base m_typeid;
  static uvm_typeid_base m_cb_typeid;
  static string m_typename;
  static string m_cb_typename;
  static uvm_callbacks#(T,uvm_callback) m_base_inst;
  bit m_registered;
  static function this_type get();
    if (m_inst == null) begin
      uvm_typeid_base cb_base_type;
      void'(super_type::m_initialize());
      cb_base_type = uvm_typeid#(uvm_callback)::get();
      m_cb_typeid  = uvm_typeid#(CB)::get();
      m_typeid     = uvm_typeid#(T)::get();
      m_inst = new;
      if (cb_base_type == m_cb_typeid) begin
        $cast(m_base_inst, m_inst);
        m_t_inst = m_base_inst;
        uvm_typeid_base::typeid_map[m_typeid] = m_inst;
        uvm_typeid_base::type_map[m_b_inst] = m_typeid;
      end
      else begin
        m_base_inst = uvm_callbacks#(T,uvm_callback)::get();
        m_base_inst.m_this_type.push_back(m_inst);
      end
      if (m_inst == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "CB/INTERNAL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "CB/INTERNAL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("CB/INTERNAL", "get(): m_inst is null", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_callback.svh", 617, "", 1);
     end
   end
      end
    end
    return m_inst;
  endfunction
  static function bit m_register_pair(string tname="", cbname="");
    this_type inst = get();
    m_typename = tname;
    super_type::m_typename = tname;
    m_typeid.typename = tname;
    m_cb_typename = cbname;
    m_cb_typeid.typename = cbname;
    inst.m_registered = 1;
    return 1;
  endfunction
  virtual function bit m_is_registered(uvm_object obj, uvm_callback cb);
    if(m_is_for_me(cb) && m_am_i_a(obj)) begin
      return m_registered;
    end
  endfunction
  virtual function bit m_is_for_me(uvm_callback cb);
    CB this_cb;
    return($cast(this_cb,cb));
  endfunction
  static function void add(T obj, uvm_callback cb, uvm_apprepend ordering=UVM_APPEND);
    uvm_queue#(uvm_callback) q;
    string nm,tnm;
    void'(get());
    if (cb==null) begin
      if (obj==null) begin
        nm = "(*)";
      end
      else begin
        nm = obj.get_full_name();
      end
      if (m_base_inst.m_typename!="") begin
        tnm = m_base_inst.m_typename;
      end
      else if (obj != null) begin
        tnm = obj.get_type_name();
      end
      else begin
        tnm = "uvm_object";
      end
      uvm_report_error("CBUNREG",
                       {"Null callback object cannot be registered with object ",
                        nm, " (", tnm, ")"}, UVM_NONE);
      return;
    end
    if (!m_base_inst.check_registration(obj,cb)) begin
      if (obj==null) begin
        nm = "(*)";
      end
      else begin
        nm = obj.get_full_name();
      end
      if (m_base_inst.m_typename!="") begin
        tnm = m_base_inst.m_typename;
      end
      else if(obj != null) begin
        tnm = obj.get_type_name();
      end
      else begin
        tnm = "uvm_object";
      end
      uvm_report_warning("CBUNREG",
                          {"Callback ", cb.get_name(), " cannot be registered with object ",
                          nm, " because callback type ", cb.get_type_name(),
                          " is not registered with object type ", tnm }, UVM_NONE);
    end
    if(obj == null) begin
      if (m_cb_find(m_t_inst.m_tw_cb_q,cb) != -1) begin
        if (m_base_inst.m_typename!="") begin
          tnm = m_base_inst.m_typename;
        end
        else begin
          tnm = "uvm_object";
        end
        uvm_report_warning("CBPREG",
                           {"Callback object ", cb.get_name(),
                           " is already registered with type ", tnm }, UVM_NONE);
      end
      else begin
        m_t_inst.m_add_tw_cbs(cb,ordering);
      end
    end
    else begin
      q = m_base_inst.m_pool.get(obj);
      if (q==null) begin
        q=new;
        m_base_inst.m_pool.add(obj,q);
      end
      if(q.size() == 0) begin
        uvm_report_object o;
        if($cast(o,obj)) begin
          uvm_queue#(uvm_callback) qr;
          void'(uvm_callbacks#(uvm_report_object, uvm_callback)::get());
          qr = uvm_callbacks#(uvm_report_object,uvm_callback)::m_t_inst.m_tw_cb_q;
          for(int i=0; i<qr.size(); ++i) begin
            q.push_back(qr.get(i));
          end
        end
        for(int i=0; i<m_t_inst.m_tw_cb_q.size(); ++i) begin
          q.push_back(m_t_inst.m_tw_cb_q.get(i));
        end
      end
      if(m_cb_find(q,cb) != -1) begin
        uvm_report_warning("CBPREG", { "Callback object ", cb.get_name(), " is already registered",
                           " with object ", obj.get_full_name() }, UVM_NONE);
      end
      else begin
        if(ordering == UVM_APPEND) begin
          q.push_back(cb);
        end
        else begin
          q.push_front(cb);
        end
      end
    end
  endfunction
  static function void add_by_name(string name,
                                   uvm_callback cb,
                                   uvm_component root,
                                   uvm_apprepend ordering=UVM_APPEND);
    uvm_component cq[$];
    uvm_root top;
    uvm_coreservice_t cs;
    T t;
    void'(get());
    cs = uvm_coreservice_t::get();
    top = cs.get_root();
    if(cb==null) begin
      uvm_report_error("CBUNREG", { "Null callback object cannot be registered with object(s) ",
         name }, UVM_NONE);
      return;
    end
    top.find_all(name,cq,root);
    if(cq.size() == 0) begin
      uvm_report_warning("CBNOMTC", { "add_by_name failed to find any components matching the name ",
        name, ", callback ", cb.get_name(), " will not be registered." }, UVM_NONE);
    end
    foreach(cq[i]) begin
      if($cast(t,cq[i])) begin
        add(t,cb,ordering);
      end
    end
  endfunction
  static function void delete(T obj, uvm_callback cb);
    uvm_object b_obj = obj;
    uvm_queue#(uvm_callback) q;
    bit found;
    int pos;
    void'(get());
    if(obj == null) begin
      found = m_t_inst.m_delete_tw_cbs(cb);
    end
    else begin
      q = m_base_inst.m_pool.get(b_obj);
      pos = m_cb_find(q,cb);
      if(pos != -1) begin
        q.delete(pos);
        found = 1;
      end
    end
    if(!found) begin
      string nm;
      if(obj==null) begin
        nm = "(*)";
      end
      else begin
        nm = obj.get_full_name();
      end
      uvm_report_warning("CBUNREG", { "Callback ", cb.get_name(), " cannot be removed from object ",
        nm, " because it is not currently registered to that object." }, UVM_NONE);
    end
  endfunction
  static function void delete_by_name(string name, uvm_callback cb,
     uvm_component root);
    uvm_component cq[$];
    uvm_root top;
    T t;
    uvm_coreservice_t cs;
    void'(get());
    cs = uvm_coreservice_t::get();
    top = cs.get_root();
    top.find_all(name,cq,root);
    if(cq.size() == 0) begin
      uvm_report_warning("CBNOMTC", { "delete_by_name failed to find any components matching the name ",
        name, ", callback ", cb.get_name(), " will not be unregistered." }, UVM_NONE);
    end
    foreach(cq[i]) begin
      if($cast(t,cq[i])) begin
        delete(t,cb);
      end
    end
  endfunction
  static function void m_get_q (ref uvm_queue #(uvm_callback) q, input T obj);
    if(!m_base_inst.m_pool.exists(obj)) begin
      q = (obj == null) ? m_t_inst.m_tw_cb_q : m_t_inst.m_get_tw_cb_q(obj);
    end
    else begin
      q = m_base_inst.m_pool.get(obj);
      if(q==null) begin
        q=new;
        m_base_inst.m_pool.add(obj,q);
      end
    end
  endfunction
  static function CB get_first (ref int itr, input T obj);
    uvm_queue#(uvm_callback) q;
    CB cb;
    void'(get());
    m_get_q(q,obj);
    for(itr = 0; itr<q.size(); ++itr) begin
      if($cast(cb, q.get(itr)) && cb.callback_mode()) begin
        return cb;
      end
    end
    return null;
  endfunction
  static function CB get_last (ref int itr, input T obj);
    uvm_queue#(uvm_callback) q;
    CB cb;
    void'(get());
    m_get_q(q,obj);
    for(itr = q.size()-1; itr>=0; --itr) begin
      if ($cast(cb, q.get(itr)) && cb.callback_mode()) begin
        return cb;
      end
    end
    return null;
  endfunction
  static function CB get_next (ref int itr, input T obj);
    uvm_queue#(uvm_callback) q;
    CB cb;
    void'(get());
    m_get_q(q,obj);
    for(itr = itr+1; itr<q.size(); ++itr) begin
      if ($cast(cb, q.get(itr)) && cb.callback_mode()) begin
        return cb;
      end
    end
    return null;
  endfunction
  static function CB get_prev (ref int itr, input T obj);
    uvm_queue#(uvm_callback) q;
    CB cb;
    void'(get());
    m_get_q(q,obj);
    for(itr = itr-1; itr>= 0; --itr) begin
      if($cast(cb, q.get(itr)) && cb.callback_mode()) begin
        return cb;
      end
    end
    return null;
  endfunction
  static function void get_all ( ref CB all_callbacks[$], input T obj=null );
    uvm_queue#(uvm_callback) q;
    CB cb;
    CB callbacks_to_append[$];
    CB unique_callbacks_to_append[$];
    void'( get() );
    if ((obj == null) || (!m_pool.exists(obj))) begin
      for (int qi=0; qi<m_t_inst.m_tw_cb_q.size(); ++qi) begin
        if ($cast(cb, m_t_inst.m_tw_cb_q.get(qi))) begin
          callbacks_to_append.push_back( cb );
        end
      end
    end
    else begin
      q = m_pool.get(obj);
      for (int qi=0; qi < q.size(); qi++) begin
        if ($cast(cb, q.get( qi ))) begin
          callbacks_to_append.push_back( cb );
        end
      end
    end
    unique_callbacks_to_append = callbacks_to_append.unique( cb_ ) with ( cb_.get_inst_id );
    all_callbacks = { all_callbacks, unique_callbacks_to_append };
  endfunction
  static function void display(T obj=null);
    void'(get());
    super_type::display(obj);
  endfunction
endclass
class uvm_derived_callbacks#(type T=uvm_object, type ST=uvm_object, type CB=uvm_callback)
    extends uvm_callbacks#(T,CB);
  typedef uvm_derived_callbacks#(T,ST,CB) this_type;
  typedef uvm_callbacks#(T)            this_user_type;
  typedef uvm_callbacks#(ST)           this_super_type;
  static this_type m_d_inst;
  static this_user_type m_user_inst;
  static this_super_type m_super_inst;
  static uvm_typeid_base m_s_typeid;
  static function this_type get();
    m_user_inst = this_user_type::get();
    m_super_inst = this_super_type::get();
    m_s_typeid = uvm_typeid#(ST)::get();
    if(m_d_inst == null) begin
      m_d_inst = new;
    end
    return m_d_inst;
  endfunction
  static function bit register_super_type(string tname="", sname="");
    this_user_type u_inst = this_user_type::get();
    uvm_callbacks_base s_obj;
    void'(this_type::get());
    this_user_type::m_t_inst.m_typename = tname;
    if(sname != "") begin
      m_s_typeid.typename = sname;
    end
    if(u_inst.m_super_type != null) begin
      if(u_inst.m_super_type == m_s_typeid) begin
        return 1;
      end
      uvm_report_warning("CBTPREG", { "Type ", tname, " is already registered to super type ",
        this_super_type::m_t_inst.m_typename, ". Ignoring attempt to register to super type ",
        sname}, UVM_NONE);
      return 1;
    end
    if(this_super_type::m_t_inst.m_typename == "") begin
      this_super_type::m_t_inst.m_typename = sname;
    end
    u_inst.m_super_type = m_s_typeid;
    u_inst.m_base_inst.m_super_type = m_s_typeid;
    s_obj = uvm_typeid_base::typeid_map[m_s_typeid];
    s_obj.m_derived_types.push_back(m_typeid);
    return 1;
  endfunction
endclass
class uvm_callback_iter#(type T = uvm_object, type CB = uvm_callback) extends uvm_void;
   local int m_i;
   local T   m_obj;
   local CB  m_cb;
   function new(T obj);
      m_obj = obj;
   endfunction
   function CB first();
      m_cb = uvm_callbacks#(T,CB)::get_first(m_i, m_obj);
      return m_cb;
   endfunction
   function CB last();
      m_cb = uvm_callbacks#(T,CB)::get_last(m_i, m_obj);
      return m_cb;
   endfunction
   function CB next();
      m_cb = uvm_callbacks#(T,CB)::get_next(m_i, m_obj);
      return m_cb;
   endfunction
   function CB prev();
      m_cb = uvm_callbacks#(T,CB)::get_prev(m_i, m_obj);
      return m_cb;
   endfunction
   function CB get_cb();
      return m_cb;
   endfunction
endclass
class uvm_callback extends uvm_object;
  protected bit m_enabled = 1;
   typedef uvm_object_registry#(uvm_callback,"uvm_callback") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_callback tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_callback";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_callback";
     endfunction : get_type_name
  function new(string name="uvm_callback");
    super.new(name);
  endfunction
  function bit callback_mode(int on=-1);
    if(on == 0 || on == 1) begin
    end
    else begin
    end
    callback_mode = m_enabled;
    if(on==0) begin
      m_enabled=0;
    end
    if(on==1) begin
      m_enabled=1;
    end
  endfunction
  function bit is_enabled();
    return callback_mode();
  endfunction
endclass
`define UVM_REPORT_MESSAGE_SVH
typedef class uvm_report_server;
typedef class uvm_report_handler;
typedef class uvm_root;
virtual class uvm_report_message_element_base;
   protected uvm_action _action;
   protected string          _name;
   virtual function string get_name();
     return _name;
   endfunction
   virtual function void set_name(string name);
     _name = name;
   endfunction
   virtual function uvm_action get_action();
     return _action;
   endfunction
   virtual function void set_action(uvm_action action);
     _action = action;
   endfunction
   function void print(uvm_printer printer);
      if (_action & (UVM_LOG | UVM_DISPLAY))
        begin
          do_print(printer);
        end
   endfunction : print
   function void record(uvm_recorder recorder);
      if (_action & UVM_RM_RECORD)
        begin
          do_record(recorder);
        end
   endfunction : record
   function void copy(uvm_report_message_element_base rhs);
      do_copy(rhs);
   endfunction : copy
   function uvm_report_message_element_base clone();
      return do_clone();
   endfunction : clone
   pure virtual function void do_print(uvm_printer printer);
   pure virtual function void do_record(uvm_recorder recorder);
   pure virtual function void do_copy(uvm_report_message_element_base rhs);
   pure virtual function uvm_report_message_element_base do_clone();
endclass : uvm_report_message_element_base
class uvm_report_message_int_element extends uvm_report_message_element_base;
   typedef uvm_report_message_int_element this_type;
   protected uvm_bitstream_t _val;
   protected int             _size;
   protected uvm_radix_enum  _radix;
   virtual function uvm_bitstream_t get_value(output int size,
                                              output uvm_radix_enum radix);
     size = _size;
     radix = _radix;
     return _val;
   endfunction
   virtual function void set_value(uvm_bitstream_t value,
                              int size,
                              uvm_radix_enum radix);
     _size = size;
     _radix = radix;
     _val = value;
   endfunction
   virtual function void do_print(uvm_printer printer);
      printer.print_field(_name, _val, _size, _radix);
   endfunction : do_print
   virtual function void do_record(uvm_recorder recorder);
      recorder.record_field(_name, _val, _size, _radix);
   endfunction : do_record
   virtual function void do_copy(uvm_report_message_element_base rhs);
      this_type _rhs;
      $cast(_rhs, rhs);
      _name = _rhs._name;
      _val = _rhs._val;
      _size = _rhs._size;
      _radix = _rhs._radix;
      _action = rhs._action;
   endfunction : do_copy
   virtual function uvm_report_message_element_base do_clone();
     this_type tmp = new;
     tmp.copy(this);
     return tmp;
   endfunction : do_clone
endclass : uvm_report_message_int_element
class uvm_report_message_string_element extends uvm_report_message_element_base;
   typedef uvm_report_message_string_element this_type;
   protected string  _val;
   virtual function string get_value();
     return _val;
   endfunction
   virtual function void set_value(string value);
     _val = value;
   endfunction
   virtual function void do_print(uvm_printer printer);
      printer.print_string(_name, _val);
   endfunction : do_print
   virtual function void do_record(uvm_recorder recorder);
      recorder.record_string(_name, _val);
   endfunction : do_record
   virtual function void do_copy(uvm_report_message_element_base rhs);
      this_type _rhs;
      $cast(_rhs, rhs);
      _name = _rhs._name;
      _val = _rhs._val;
      _action = rhs._action;
   endfunction : do_copy
   virtual function uvm_report_message_element_base do_clone();
     this_type tmp = new;
     tmp.copy(this);
     return tmp;
   endfunction : do_clone
endclass : uvm_report_message_string_element
class uvm_report_message_object_element extends uvm_report_message_element_base;
   typedef uvm_report_message_object_element this_type;
   protected uvm_object _val;
   virtual function uvm_object get_value();
     return _val;
   endfunction
   virtual function void set_value(uvm_object value);
     _val = value;
   endfunction
   virtual function void do_print(uvm_printer printer);
      printer.print_object(_name, _val);
   endfunction : do_print
   virtual function void do_record(uvm_recorder recorder);
      recorder.record_object(_name, _val);
   endfunction : do_record
   virtual function void do_copy(uvm_report_message_element_base rhs);
      this_type _rhs;
      $cast(_rhs, rhs);
      _name = _rhs._name;
      _val = _rhs._val;
      _action = rhs._action;
   endfunction : do_copy
   virtual function uvm_report_message_element_base do_clone();
     this_type tmp = new;
     tmp.copy(this);
     return tmp;
   endfunction : do_clone
endclass : uvm_report_message_object_element
class uvm_report_message_element_container extends uvm_object;
  protected uvm_report_message_element_base elements[$];
   typedef uvm_object_registry#(uvm_report_message_element_container,"uvm_report_message_element_container") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_report_message_element_container tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_report_message_element_container";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_report_message_element_container";
     endfunction : get_type_name
  function new(string name = "element_container");
    super.new(name);
  endfunction
  virtual function int size();
    return elements.size();
  endfunction
  virtual function void delete(int index);
    elements.delete(index);
  endfunction
  virtual function void delete_elements();
    elements.delete();
  endfunction
  typedef uvm_report_message_element_base queue_of_element[$];
  virtual function queue_of_element get_elements();
    return elements;
  endfunction
  virtual function void add_int(string name, uvm_bitstream_t value,
                                int size, uvm_radix_enum radix,
                    uvm_action action = (UVM_LOG|UVM_RM_RECORD));
     process p;
     string rand_state;
     uvm_report_message_int_element urme;
     p = process::self();
     if (p != null)
       begin
         rand_state = p.get_randstate();
       end
     urme = new();
     if (p != null)
       begin
         p.set_randstate(rand_state);
       end
     urme.set_name(name);
     urme.set_value(value, size, radix);
     urme.set_action(action);
     elements.push_back(urme);
  endfunction
  virtual function void add_string(string name, string value,
                                   uvm_action action = (UVM_LOG|UVM_RM_RECORD));
     process p;
     string rand_state;
     uvm_report_message_string_element urme;
     p = process::self();
     if (p != null)
       begin
         rand_state = p.get_randstate();
       end
     urme = new();
     if (p != null)
       begin
         p.set_randstate(rand_state);
       end
     urme.set_name(name);
     urme.set_value(value);
     urme.set_action(action);
     elements.push_back(urme);
  endfunction
  virtual function void add_object(string name, uvm_object obj,
                                   uvm_action action = (UVM_LOG|UVM_RM_RECORD));
     process p;
     string rand_state;
     uvm_report_message_object_element urme;
     p = process::self();
     if (p != null)
       begin
         rand_state = p.get_randstate();
       end
     urme = new();
     if (p != null)
       begin
         p.set_randstate(rand_state);
       end
     urme.set_name(name);
     urme.set_value(obj);
     urme.set_action(action);
     elements.push_back(urme);
  endfunction
  virtual function void do_print(uvm_printer printer);
    super.do_print(printer);
    for(int i = 0; i < elements.size(); i++)
      begin
        elements[i].print(printer);
      end
  endfunction
  virtual function void do_record(uvm_recorder recorder);
    super.do_record(recorder);
    for(int i = 0; i < elements.size(); i++)
      begin
        elements[i].record(recorder);
      end
  endfunction
  virtual function void do_copy(uvm_object rhs);
    uvm_report_message_element_container urme_container;
    super.do_copy(rhs);
    if(!$cast(urme_container, rhs) || (rhs==null))
      begin
        return;
      end
    delete_elements();
    foreach (urme_container.elements[i])
      begin
        elements.push_back(urme_container.elements[i].clone());
      end
  endfunction
endclass
class uvm_report_message extends uvm_object;
  protected uvm_report_object _report_object;
  protected uvm_report_handler _report_handler;
  protected uvm_report_server _report_server;
  protected uvm_severity _severity;
  protected string _id;
  protected string _message;
  protected int _verbosity;
  protected string _filename;
  protected int _line;
  protected string _context_name;
  protected uvm_action _action;
  protected UVM_FILE _file;
  protected uvm_report_message_element_container _report_message_element_container;
  function new(string name = "uvm_report_message");
    super.new(name);
    _report_message_element_container = new();
  endfunction
  static function uvm_report_message new_report_message(string name = "uvm_report_message");
    process p;
    string rand_state;
    p = process::self();
    if (p != null)
      begin
        rand_state = p.get_randstate();
      end
    new_report_message = new(name);
    if (p != null)
      begin
        p.set_randstate(rand_state);
      end
  endfunction
  virtual function void do_print(uvm_printer printer);
    uvm_verbosity l_verbosity;
    super.do_print(printer);
    printer.print_generic("severity", "uvm_severity",
                          $bits(_severity), _severity.name());
    printer.print_string("id", _id);
    printer.print_string("message",_message);
    if ($cast(l_verbosity, _verbosity))
      begin
        printer.print_generic("verbosity", "uvm_verbosity",
                            $bits(l_verbosity), l_verbosity.name());
      end
    else
      begin
        printer.print_field("verbosity", _verbosity, $bits(_verbosity), UVM_HEX);
      end
    printer.print_string("filename", _filename);
    printer.print_field("line", _line, $bits(_line), UVM_UNSIGNED);
    printer.print_string("context_name", _context_name);
    if (_report_message_element_container.size() != 0)
      begin
        uvm_report_message_element_base elements[$];
        elements  = _report_message_element_container.get_elements();
        foreach (elements[i])
        begin
          elements[i].print(printer);
        end
      end
  endfunction
   typedef uvm_object_registry#(uvm_report_message,"uvm_report_message") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_report_message tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_report_message";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_report_message";
     endfunction : get_type_name
  virtual function void do_copy (uvm_object rhs);
    uvm_report_message report_message;
    super.do_copy(rhs);
    if(!$cast(report_message, rhs) || (rhs==null))
      begin
        return;
      end
    _report_object = report_message.get_report_object();
    _report_handler = report_message.get_report_handler();
    _report_server = report_message.get_report_server();
    _context_name = report_message.get_context();
    _file = report_message.get_file();
    _filename = report_message.get_filename();
    _line = report_message.get_line();
    _action = report_message.get_action();
    _severity = report_message.get_severity();
    _id = report_message.get_id();
    _message = report_message.get_message();
    _verbosity = report_message.get_verbosity();
    _report_message_element_container.copy(report_message._report_message_element_container);
  endfunction
  virtual function uvm_report_object get_report_object();
    return _report_object;
  endfunction
  virtual function void set_report_object(uvm_report_object ro);
    _report_object = ro;
  endfunction
  virtual function uvm_report_handler get_report_handler();
    return _report_handler;
  endfunction
  virtual function void set_report_handler(uvm_report_handler rh);
    _report_handler = rh;
  endfunction
  virtual function uvm_report_server get_report_server();
    return _report_server;
  endfunction
  virtual function void set_report_server(uvm_report_server rs);
    _report_server = rs;
  endfunction
  virtual function uvm_severity get_severity();
    return _severity;
  endfunction
  virtual function void set_severity(uvm_severity sev);
    _severity = sev;
  endfunction
  virtual function string get_id();
    return _id;
  endfunction
  virtual function void set_id(string id);
    _id = id;
  endfunction
  virtual function string get_message();
    return _message;
  endfunction
  virtual function void set_message(string msg);
    _message = msg;
  endfunction
  virtual function int get_verbosity();
    return _verbosity;
  endfunction
  virtual function void set_verbosity(int ver);
    _verbosity = ver;
  endfunction
  virtual function string get_filename();
    return _filename;
  endfunction
  virtual function void set_filename(string fname);
    _filename = fname;
  endfunction
  virtual function int get_line();
    return _line;
  endfunction
  virtual function void set_line(int ln);
    _line = ln;
  endfunction
  virtual function string get_context();
    return _context_name;
  endfunction
  virtual function void set_context(string cn);
    _context_name = cn;
  endfunction
  virtual function uvm_action get_action();
    return _action;
  endfunction
  virtual function void set_action(uvm_action act);
    _action = act;
  endfunction
  virtual function UVM_FILE get_file();
    return _file;
  endfunction
  virtual function void set_file(UVM_FILE fl);
    _file = fl;
  endfunction
  virtual function uvm_report_message_element_container get_element_container();
    return _report_message_element_container;
  endfunction
  virtual function void set_report_message(uvm_severity severity,
                           string id,
                       string message,
                       int verbosity,
                           string filename,
                       int line,
                       string context_name);
    this._context_name = context_name;
    this._filename = filename;
    this._line = line;
    this._severity = severity;
    this._id = id;
    this._message = message;
    this._verbosity = verbosity;
  endfunction
  virtual function void m_record_message(uvm_recorder recorder);
    recorder.record_string("message", _message);
  endfunction
  virtual function void m_record_core_properties(uvm_recorder recorder);
    string l_string;
    uvm_verbosity l_verbosity;
    if (_context_name != "")
      begin
        recorder.record_string("context_name", _context_name);
      end
    recorder.record_string("filename", _filename);
    recorder.record_field("line", _line, $bits(_line), UVM_UNSIGNED);
    recorder.record_string("severity", _severity.name());
    if ($cast(l_verbosity, _verbosity))
      begin
        recorder.record_string("verbosity", l_verbosity.name());
      end
    else
      begin
        l_string.itoa(_verbosity);
        recorder.record_string("verbosity", l_string);
      end
    recorder.record_string("id", _id);
    m_record_message(recorder);
  endfunction
  virtual function void do_record(uvm_recorder recorder);
    super.do_record(recorder);
    m_record_core_properties(recorder);
    _report_message_element_container.record(recorder);
  endfunction
  virtual function void add_int(string name, uvm_bitstream_t value,
                                int size, uvm_radix_enum radix,
                                uvm_action action = (UVM_LOG|UVM_RM_RECORD));
    _report_message_element_container.add_int(name, value, size, radix, action);
  endfunction
  virtual function void add_string(string name, string value,
                                   uvm_action action = (UVM_LOG|UVM_RM_RECORD));
    _report_message_element_container.add_string(name, value, action);
  endfunction
  virtual function void add_object(string name, uvm_object obj,
                                   uvm_action action = (UVM_LOG|UVM_RM_RECORD));
    _report_message_element_container.add_object(name, obj, action);
  endfunction
endclass
`define UVM_REPORT_CATCHER_SVH
typedef class uvm_report_object;
typedef class uvm_report_handler;
typedef class uvm_report_server;
typedef class uvm_report_catcher;
typedef uvm_callbacks    #(uvm_report_object, uvm_report_catcher) uvm_report_cb;
typedef uvm_callback_iter#(uvm_report_object, uvm_report_catcher) uvm_report_cb_iter   ;
class sev_id_struct;
  bit sev_specified ;
  bit id_specified ;
  uvm_severity sev ;
  string  id ;
  bit is_on ;
endclass
virtual class uvm_report_catcher extends uvm_callback;
  static local bit m_register_cb_uvm_report_catcher = uvm_callbacks#(uvm_report_object,uvm_report_catcher)::m_register_pair("uvm_report_object","uvm_report_catcher");
  typedef enum { UNKNOWN_ACTION, THROW, CAUGHT} action_e;
  local static uvm_report_message m_modified_report_message;
  local static uvm_report_message m_orig_report_message;
  local static bit m_set_action_called;
  local static int m_demoted_fatal;
  local static int m_demoted_error;
  local static int m_demoted_warning;
  local static int m_caught_fatal;
  local static int m_caught_error;
  local static int m_caught_warning;
  localparam   int DO_NOT_CATCH      = 1;
  localparam   int DO_NOT_MODIFY     = 2;
  local static int m_debug_flags;
  local static  bit do_report;
  function new(string name = "uvm_report_catcher");
    super.new(name);
    do_report = 1;
  endfunction
  function uvm_report_object get_client();
    return m_modified_report_message.get_report_object();
  endfunction
  function uvm_severity get_severity();
    return this.m_modified_report_message.get_severity();
  endfunction
  function string get_context();
    string context_str;
    context_str = this.m_modified_report_message.get_context();
    if (context_str == "") begin
      uvm_report_handler rh = this.m_modified_report_message.get_report_handler();
      context_str = rh.get_full_name();
    end
    return context_str;
  endfunction
  function int get_verbosity();
    return this.m_modified_report_message.get_verbosity();
  endfunction
  function string get_id();
    return this.m_modified_report_message.get_id();
  endfunction
  function string get_message();
     return this.m_modified_report_message.get_message();
  endfunction
  function uvm_action get_action();
    return this.m_modified_report_message.get_action();
  endfunction
  function string get_fname();
    return this.m_modified_report_message.get_filename();
  endfunction
  function int get_line();
    return this.m_modified_report_message.get_line();
  endfunction
  function uvm_report_message_element_container get_element_container();
    return this.m_modified_report_message.get_element_container();
  endfunction
  protected function void set_severity(uvm_severity severity);
    this.m_modified_report_message.set_severity(severity);
  endfunction
  protected function void set_verbosity(int verbosity);
    this.m_modified_report_message.set_verbosity(verbosity);
  endfunction
  protected function void set_id(string id);
    this.m_modified_report_message.set_id(id);
  endfunction
  protected function void set_message(string message);
    this.m_modified_report_message.set_message(message);
  endfunction
  protected function void set_action(uvm_action action);
    this.m_modified_report_message.set_action(action);
    this.m_set_action_called = 1;
  endfunction
  protected function void set_context(string context_str);
    this.m_modified_report_message.set_context(context_str);
  endfunction
  protected function void add_int(string name,
                  uvm_bitstream_t value,
                  int size,
                  uvm_radix_enum radix,
                  uvm_action action = (UVM_LOG|UVM_RM_RECORD));
    this.m_modified_report_message.add_int(name, value, size, radix, action);
  endfunction
  protected function void add_string(string name,
                     string value,
                                     uvm_action action = (UVM_LOG|UVM_RM_RECORD));
    this.m_modified_report_message.add_string(name, value, action);
  endfunction
  protected function void add_object(string name,
                     uvm_object obj,
                                     uvm_action action = (UVM_LOG|UVM_RM_RECORD));
    this.m_modified_report_message.add_object(name, obj, action);
  endfunction
  static function void print_catcher(UVM_FILE file = 0);
      string msg;
      string enabled;
      uvm_report_catcher catcher;
      static uvm_report_cb_iter iter = new(null);
      string q[$];
      q.push_back("-------------UVM REPORT CATCHERS----------------------------\n");
      catcher = iter.first();
      while(catcher != null) begin
        if(catcher.callback_mode()) begin
          enabled = "ON";
        end
        else begin
          enabled = "OFF";
        end
        q.push_back($sformatf("%20s : %s\n", catcher.get_name(),enabled));
        catcher = iter.next();
      end
      q.push_back("--------------------------------------------------------------\n");
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_root::get().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/REPORT/CATCHER") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/REPORT/CATCHER") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_info("UVM/REPORT/CATCHER", uvm_pkg::m_uvm_string_queue_join(q), UVM_LOW, "t/uvm/src/base/uvm_report_catcher.svh", 369, "", 1);
     end
   end
  endfunction
  static function void debug_report_catcher(int what= 0);
    m_debug_flags = what;
  endfunction
  pure virtual function action_e catch();
   protected function void uvm_report_fatal(string id,
                        string message,
                        int verbosity,
                        string fname = "",
                        int line = 0,
                        string context_name = "",
                        bit report_enabled_checked = 0);
     this.uvm_report(UVM_FATAL, id, message, UVM_NONE, fname, line,
                     context_name, report_enabled_checked);
   endfunction
   protected function void uvm_report_error(string id,
                        string message,
                        int verbosity,
                        string fname = "",
                        int line = 0,
                        string context_name = "",
                        bit report_enabled_checked = 0);
     this.uvm_report(UVM_ERROR, id, message, UVM_NONE, fname, line,
                     context_name, report_enabled_checked);
   endfunction
   protected function void uvm_report_warning(string id,
                          string message,
                          int verbosity,
                          string fname = "",
                          int line = 0,
                          string context_name = "",
                          bit report_enabled_checked = 0);
     this.uvm_report(UVM_WARNING, id, message, UVM_NONE, fname, line,
                     context_name, report_enabled_checked);
   endfunction
   protected function void uvm_report_info(string id,
                       string message,
                       int verbosity,
                       string fname = "",
                       int line = 0,
                       string context_name = "",
                       bit report_enabled_checked = 0);
     this.uvm_report(UVM_INFO, id, message, verbosity, fname, line,
                     context_name, report_enabled_checked);
   endfunction
   protected function void uvm_report(uvm_severity severity,
                      string id,
                      string message,
                      int verbosity,
                      string fname = "",
                      int line = 0,
                      string context_name = "",
                      bit report_enabled_checked = 0);
     uvm_report_message l_report_message;
     if (report_enabled_checked == 0) begin
       if (!uvm_report_enabled(verbosity, severity, id)) begin
         return;
       end
     end
     l_report_message = uvm_report_message::new_report_message();
     l_report_message.set_report_message(severity, id, message,
                     verbosity, fname, line, context_name);
     this.uvm_process_report_message(l_report_message);
   endfunction
   protected function void uvm_process_report_message(uvm_report_message msg);
     uvm_report_object ro = m_modified_report_message.get_report_object();
     uvm_action a = ro.get_report_action(msg.get_severity(), msg.get_id());
     if(a) begin
       string composed_message;
       uvm_report_server rs = m_modified_report_message.get_report_server();
       msg.set_report_object(ro);
       msg.set_report_handler(m_modified_report_message.get_report_handler());
       msg.set_report_server(rs);
       msg.set_file(ro.get_report_file_handle(msg.get_severity(), msg.get_id()));
       msg.set_action(a);
       if (a & (UVM_LOG|UVM_DISPLAY)) begin
         composed_message = rs.compose_report_message(msg);
       end
       rs.execute_report_message(msg, composed_message);
     end
   endfunction
  protected function void issue();
     string composed_message;
     uvm_report_server rs = m_modified_report_message.get_report_server();
     if(uvm_action_type'(m_modified_report_message.get_action()) != UVM_NO_ACTION) begin
       if (m_modified_report_message.get_action() & (UVM_LOG|UVM_DISPLAY)) begin
         composed_message = rs.compose_report_message(m_modified_report_message);
       end
       rs.execute_report_message(m_modified_report_message, composed_message);
     end
  endfunction
  static function int process_all_report_catchers(uvm_report_message rm);
    int iter;
    uvm_report_catcher catcher;
    int thrown = 1;
    uvm_severity orig_severity;
    static bit in_catcher;
    uvm_report_object l_report_object = rm.get_report_object();
    if(in_catcher == 1) begin
      return 1;
    end
    in_catcher = 1;
    uvm_callbacks_base::m_tracing = 0;
    orig_severity = uvm_severity'(rm.get_severity());
    m_modified_report_message = rm;
    catcher = uvm_report_cb::get_first(iter,l_report_object);
    if (catcher != null) begin
      if(m_debug_flags & DO_NOT_MODIFY) begin
        process p = process::self();
        string randstate;
        if (p != null) begin
          randstate = p.get_randstate();
        end
        $cast(m_orig_report_message, rm.clone());
        if (p != null) begin
          p.set_randstate(randstate);
        end
      end
    end
    while(catcher != null) begin
      uvm_severity prev_sev;
      if (!catcher.callback_mode()) begin
        catcher = uvm_report_cb::get_next(iter,l_report_object);
        continue;
      end
      prev_sev = m_modified_report_message.get_severity();
      m_set_action_called = 0;
      thrown = catcher.process_report_catcher();
      if (!m_set_action_called &&
      m_modified_report_message.get_severity() != prev_sev &&
      m_modified_report_message.get_action() ==
      l_report_object.get_report_action(prev_sev, "*@&*^*^*#")) begin
        m_modified_report_message.set_action(
           l_report_object.get_report_action(m_modified_report_message.get_severity(), "*@&*^*^*#"));
      end
      if(thrown == 0) begin
        case(orig_severity)
          UVM_FATAL:   begin
            m_caught_fatal++;
          end
          UVM_ERROR:   begin
            m_caught_error++;
          end
          UVM_WARNING: begin
            m_caught_warning++;
          end
        endcase
        break;
      end
      catcher = uvm_report_cb::get_next(iter,l_report_object);
    end
    case(orig_severity)
      UVM_FATAL: begin
        if(m_modified_report_message.get_severity() < orig_severity) begin
          m_demoted_fatal++;
        end
      end
      UVM_ERROR: begin
        if(m_modified_report_message.get_severity() < orig_severity) begin
          m_demoted_error++;
        end
      end
      UVM_WARNING: begin
        if(m_modified_report_message.get_severity() < orig_severity) begin
          m_demoted_warning++;
        end
      end
    endcase
    in_catcher = 0;
    uvm_callbacks_base::m_tracing = 1;
    return thrown;
  endfunction
  local function int process_report_catcher();
    action_e act;
    act = this.catch();
    if(act == UNKNOWN_ACTION) begin
      this.uvm_report_error("RPTCTHR", {"uvm_report_this.catch() in catcher instance ",
        this.get_name(), " must return THROW or CAUGHT"}, UVM_NONE, "t/uvm/src/base/uvm_report_catcher.svh", 683);
    end
    if(m_debug_flags & DO_NOT_MODIFY) begin
      m_modified_report_message.copy(m_orig_report_message);
    end
    if(act == CAUGHT  && !(m_debug_flags & DO_NOT_CATCH)) begin
      return 0;
    end
    return 1;
  endfunction
  static function void summarize(UVM_FILE file = UVM_STDOUT);
    string s;
    uvm_root root = uvm_root::get();
    uvm_action action;
    string q[$];
    if(do_report) begin
      q.push_back("\n--- UVM Report catcher Summary ---\n\n\n");
      q.push_back($sformatf("Number of demoted UVM_FATAL reports  :%5d\n", m_demoted_fatal));
      q.push_back($sformatf("Number of demoted UVM_ERROR reports  :%5d\n", m_demoted_error));
      q.push_back($sformatf("Number of demoted UVM_WARNING reports:%5d\n", m_demoted_warning));
      q.push_back($sformatf("Number of caught UVM_FATAL reports   :%5d\n", m_caught_fatal));
      q.push_back($sformatf("Number of caught UVM_ERROR reports   :%5d\n", m_caught_error));
      q.push_back($sformatf("Number of caught UVM_WARNING reports :%5d\n", m_caught_warning));
      if(file == UVM_STDOUT) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = root.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/REPORT/CATCHER") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/REPORT/CATCHER") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_info("UVM/REPORT/CATCHER", uvm_pkg::m_uvm_string_queue_join(q), UVM_LOW, "t/uvm/src/base/uvm_report_catcher.svh", 720, "", 1);
     end
   end
      end
      else begin
        action = root.get_report_action(UVM_INFO, "UVM/REPORT/CATCHER");
        root.set_report_id_action("UVM/REPORT/CATCHER", UVM_LOG);
        root.set_report_id_file("UVM/REPORT/CATCHER", file);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = root.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/REPORT/CATCHER") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/REPORT/CATCHER") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_info("UVM/REPORT/CATCHER", uvm_pkg::m_uvm_string_queue_join(q), UVM_LOW, "t/uvm/src/base/uvm_report_catcher.svh", 727, "", 1);
     end
   end
        root.set_report_id_action("UVM/REPORT/CATCHER", action);
      end
    end
  endfunction
  static function uvm_report_catcher get_report_catcher(string name);
    static uvm_report_cb_iter iter = new(null);
    get_report_catcher = iter.first();
    while(get_report_catcher != null) begin
      if(get_report_catcher.get_name() == name) begin
        return get_report_catcher;
      end
      get_report_catcher = iter.next();
    end
    return null;
  endfunction
endclass
`define UVM_REPORT_SERVER_SVH
typedef class uvm_report_object;
typedef class uvm_default_report_server;
virtual class uvm_report_server extends uvm_object;
        function string get_type_name();
                return "uvm_report_server";
        endfunction
        function new(string name="base");
                super.new(name);
        endfunction
        pure virtual  function void set_max_quit_count(int count, bit overridable = 1);
        pure virtual  function int get_max_quit_count();
        pure virtual  function void set_quit_count(int quit_count);
        pure virtual  function int get_quit_count();
        pure virtual  function void set_severity_count(uvm_severity severity, int count);
        pure virtual  function int get_severity_count(uvm_severity severity);
        pure virtual  function void set_id_count(string id, int count);
        pure virtual  function int get_id_count(string id);
        pure virtual function void get_id_set(output string q[$]);
        pure virtual function void get_severity_set(output uvm_severity q[$]);
        pure virtual function void set_message_database(uvm_tr_database database);
        pure virtual function uvm_tr_database get_message_database();
        function void do_copy (uvm_object rhs);
                uvm_report_server rhs_;
                super.do_copy(rhs);
                if(!$cast(rhs_,rhs)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/REPORT/SERVER/RPTCOPY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/REPORT/SERVER/RPTCOPY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/REPORT/SERVER/RPTCOPY", "cannot copy to report_server from the given datatype", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_report_server.svh", 129, "", 1);
     end
   end
                end
                begin
                  uvm_severity q[$];
                  rhs_.get_severity_set(q);
                  foreach(q[s]) begin
                    set_severity_count(q[s],rhs_.get_severity_count(q[s]));
                  end
                end
                begin
                  string q[$];
                  rhs_.get_id_set(q);
                  foreach(q[s]) begin
                    set_id_count(q[s],rhs_.get_id_count(q[s]));
                  end
                end
                set_message_database(rhs_.get_message_database());
                set_max_quit_count(rhs_.get_max_quit_count());
                set_quit_count(rhs_.get_quit_count());
        endfunction
        pure virtual function void process_report_message(uvm_report_message report_message);
        pure virtual function void execute_report_message(uvm_report_message report_message,
                                                          string composed_message);
        pure virtual function string compose_report_message(uvm_report_message report_message,
                                                            string report_object_name = "");
        pure virtual function void report_summarize(UVM_FILE file = UVM_STDOUT);
        static function void set_server(uvm_report_server server);
            uvm_coreservice_t cs = uvm_coreservice_t::get();
                server.copy(cs.get_report_server());
                cs.set_report_server(server);
        endfunction
        static function uvm_report_server get_server();
            uvm_coreservice_t cs = uvm_coreservice_t::get();
                return cs.get_report_server();
        endfunction
        function void dump_server_state();
          this.report_summarize();
        endfunction : dump_server_state
endclass
class uvm_default_report_server extends uvm_report_server;
  local int m_quit_count;
  local int m_max_quit_count;
  bit max_quit_overridable = 1;
  local int m_severity_count[uvm_severity];
  protected int m_id_count[string];
   protected uvm_tr_database m_message_db;
   protected uvm_tr_stream m_streams[string][string];
  bit enable_report_id_count_summary=1;
  bit record_all_messages = 0;
  bit show_verbosity = 0;
  bit show_terminator = 0;
  function string get_type_name();
    return "uvm_default_report_server";
  endfunction
  function new(string name = "uvm_report_server");
    super.new(name);
    set_max_quit_count(0);
    reset_quit_count();
    reset_severity_counts();
  endfunction
  virtual function void do_print (uvm_printer printer);
    uvm_severity l_severity_count_index;
    string l_id_count_index;
    printer.print_field("quit_count", m_quit_count, $bits(m_quit_count), UVM_DEC,
      ".", "int");
    printer.print_field("max_quit_count", m_max_quit_count,
      $bits(m_max_quit_count), UVM_DEC, ".", "int");
    printer.print_field("max_quit_overridable", max_quit_overridable,
      $bits(max_quit_overridable), UVM_BIN, ".", "bit");
    if (m_severity_count.first(l_severity_count_index)) begin
      printer.print_array_header("severity_count",m_severity_count.size(),"severity counts");
      do begin
        printer.print_field($sformatf("[%s]",l_severity_count_index.name()),
          m_severity_count[l_severity_count_index], 32, UVM_DEC);
      end
      while (m_severity_count.next(l_severity_count_index));
      printer.print_array_footer();
    end
    if (m_id_count.first(l_id_count_index)) begin
      printer.print_array_header("id_count",m_id_count.size(),"id counts");
      do begin
        printer.print_field($sformatf("[%s]",l_id_count_index),
          m_id_count[l_id_count_index], 32, UVM_DEC);
      end
      while (m_id_count.next(l_id_count_index));
      printer.print_array_footer();
    end
    printer.print_field("enable_report_id_count_summary", enable_report_id_count_summary,
      $bits(enable_report_id_count_summary), UVM_BIN, ".", "bit");
    printer.print_field("record_all_messages", record_all_messages,
      $bits(record_all_messages), UVM_BIN, ".", "bit");
    printer.print_field("show_verbosity", show_verbosity,
      $bits(show_verbosity), UVM_BIN, ".", "bit");
    printer.print_field("show_terminator", show_terminator,
      $bits(show_terminator), UVM_BIN, ".", "bit");
  endfunction
  function int get_max_quit_count();
    return m_max_quit_count;
  endfunction
  function void set_max_quit_count(int count, bit overridable = 1);
    if (max_quit_overridable == 0) begin
      uvm_report_info("NOMAXQUITOVR",
        $sformatf("The max quit count setting of %0d is not overridable to %0d due to a previous setting.",
        m_max_quit_count, count), UVM_NONE);
      return;
    end
    max_quit_overridable = overridable;
    m_max_quit_count = count < 0 ? 0 : count;
  endfunction
  function int get_quit_count();
    return m_quit_count;
  endfunction
  function void set_quit_count(int quit_count);
    m_quit_count = quit_count < 0 ? 0 : quit_count;
  endfunction
  function void incr_quit_count();
    m_quit_count++;
  endfunction
  function void reset_quit_count();
    m_quit_count = 0;
  endfunction
  function bit is_quit_count_reached();
    return (m_quit_count >= m_max_quit_count);
  endfunction
  function int get_severity_count(uvm_severity severity);
    return m_severity_count[severity];
  endfunction
  function void set_severity_count(uvm_severity severity, int count);
    m_severity_count[severity] = count < 0 ? 0 : count;
  endfunction
  function void incr_severity_count(uvm_severity severity);
    m_severity_count[severity]++;
  endfunction
  function void reset_severity_counts();
    uvm_severity s;
    s = s.first();
    forever begin
      m_severity_count[s] = 0;
      if(s == s.last()) begin
        break;
      end
      s = s.next();
    end
  endfunction
  function int get_id_count(string id);
    if(m_id_count.exists(id)) begin
      return m_id_count[id];
    end
    return 0;
  endfunction
  function void set_id_count(string id, int count);
    m_id_count[id] = count < 0 ? 0 : count;
  endfunction
  function void incr_id_count(string id);
    if(m_id_count.exists(id)) begin
      m_id_count[id]++;
    end
    else begin
      m_id_count[id] = 1;
    end
  endfunction
   virtual function void set_message_database(uvm_tr_database database);
      m_message_db = database;
   endfunction : set_message_database
   virtual function uvm_tr_database get_message_database();
      return m_message_db;
   endfunction : get_message_database
  virtual function void get_severity_set(output uvm_severity q[$]);
    foreach(m_severity_count[idx]) begin
      q.push_back(idx);
    end
  endfunction
  virtual function void get_id_set(output string q[$]);
    foreach(m_id_count[idx]) begin
      q.push_back(idx);
    end
  endfunction
  function void f_display(UVM_FILE file, string str);
    if (file == 0) begin
      $display("%s", str);
    end
    else begin
      $fdisplay(file, "%s", str);
    end
  endfunction
  virtual function void process_report_message(uvm_report_message report_message);
    uvm_report_handler l_report_handler = report_message.get_report_handler();
        process p = process::self();
    bit report_ok = 1;
    report_message.set_report_server(this);
    if(report_message.get_action() & UVM_CALL_HOOK) begin
      report_ok = l_report_handler.run_hooks(
        report_message.get_report_object(),
        report_message.get_severity(),
        report_message.get_id(),
        report_message.get_message(),
        report_message.get_verbosity(),
        report_message.get_filename(),
        report_message.get_line());
    end
    if(report_ok) begin
      report_ok = uvm_report_catcher::process_all_report_catchers(report_message);
    end
    if(uvm_action_type'(report_message.get_action()) == UVM_NO_ACTION) begin
      report_ok = 0;
    end
    if(report_ok) begin
      string m;
      uvm_coreservice_t cs = uvm_coreservice_t::get();
      uvm_report_server svr = cs.get_report_server();
      if (report_message.get_action() & (UVM_LOG|UVM_DISPLAY)) begin
        m = svr.compose_report_message(report_message);
      end
      svr.execute_report_message(report_message, m);
    end
  endfunction
  virtual function void execute_report_message(uvm_report_message report_message,
                                               string composed_message);
                                               process p = process::self();
    incr_severity_count(report_message.get_severity());
    incr_id_count(report_message.get_id());
    if (record_all_messages) begin
      report_message.set_action(report_message.get_action() | UVM_RM_RECORD);
    end
    if(report_message.get_action() & UVM_RM_RECORD) begin
      uvm_tr_stream stream;
      uvm_report_object ro = report_message.get_report_object();
      uvm_report_handler rh = report_message.get_report_handler();
      if (m_streams.exists(ro.get_name()) && (m_streams[ro.get_name()].exists(rh.get_name()))) begin
        stream = m_streams[ro.get_name()][rh.get_name()];
      end
      if (stream == null) begin
        uvm_tr_database db;
        db = get_message_database();
        if (db == null) begin
          uvm_coreservice_t cs = uvm_coreservice_t::get();
          db = cs.get_default_tr_database();
        end
        if (db != null) begin
          stream = db.open_stream(ro.get_name(), rh.get_name(), "MESSAGES");
          m_streams[ro.get_name()][rh.get_name()] = stream;
        end
      end
      if (stream != null) begin
        uvm_recorder recorder = stream.open_recorder(report_message.get_name(),,report_message.get_type_name());
        if (recorder != null) begin
          report_message.record(recorder);
          recorder.free();
        end
      end
    end
    if(report_message.get_action() & UVM_DISPLAY) begin
      $display("%s", composed_message);
    end
    if(report_message.get_action() & UVM_LOG) begin
      if( (report_message.get_file() == 0) ||
      (report_message.get_file() != 32'h8000_0001) ) begin
        UVM_FILE tmp_file = report_message.get_file();
        if((report_message.get_file() & 32'h8000_0000) == 0) begin
          tmp_file = report_message.get_file() & 32'hffff_fffe;
        end
        f_display(tmp_file, composed_message);
      end
    end
    if(report_message.get_action() & UVM_COUNT) begin
      if(get_max_quit_count() != 0) begin
        incr_quit_count();
        if(is_quit_count_reached()) begin
          report_message.set_action(report_message.get_action() | UVM_EXIT);
        end
      end
    end
    if(report_message.get_action() & UVM_EXIT) begin
      uvm_root l_root;
      uvm_coreservice_t cs;
      cs = uvm_coreservice_t::get();
      l_root = cs.get_root();
      l_root.die();
    end
    if (report_message.get_action() & UVM_STOP) begin
      $stop;
    end
  endfunction
  virtual function string compose_report_message(uvm_report_message report_message,
                                                 string report_object_name = "");
    string sev_string;
    uvm_severity l_severity;
    uvm_verbosity l_verbosity;
    string filename_line_string;
    string time_str;
    string line_str;
    string context_str;
    string verbosity_str;
    string terminator_str;
    string msg_body_str;
    uvm_report_message_element_container el_container;
    string prefix;
    uvm_report_handler l_report_handler;
    l_severity = report_message.get_severity();
    sev_string = l_severity.name();
    if (report_message.get_filename() != "") begin
      line_str.itoa(report_message.get_line());
      filename_line_string = {report_message.get_filename(), "(", line_str, ") "};
    end
    $swrite(time_str, "%0t", $realtime);
    if (report_message.get_context() != "") begin
      context_str = {"@@", report_message.get_context()};
    end
    if (show_verbosity) begin
      if ($cast(l_verbosity, report_message.get_verbosity())) begin
        verbosity_str = l_verbosity.name();
      end
      else begin
        verbosity_str.itoa(report_message.get_verbosity());
      end
      verbosity_str = {"(", verbosity_str, ")"};
    end
    if (show_terminator) begin
      terminator_str = {" -",sev_string};
    end
    el_container = report_message.get_element_container();
    if (el_container.size() == 0) begin
      msg_body_str = report_message.get_message();
    end
    else begin
      uvm_printer uvm_default_printer = uvm_printer::get_default() ;
      prefix = uvm_default_printer.get_line_prefix();
      uvm_default_printer.set_line_prefix(" +");
      msg_body_str = {report_message.get_message(), "\n", el_container.sprint()};
      uvm_default_printer.set_line_prefix(prefix);
    end
    if (report_object_name == "") begin
      l_report_handler = report_message.get_report_handler();
      report_object_name = l_report_handler.get_full_name();
    end
    compose_report_message = {sev_string, verbosity_str, " ", filename_line_string, "@ ",
      time_str, ": ", report_object_name, context_str,
      " [", report_message.get_id(), "] ", msg_body_str, terminator_str};
  endfunction
  protected bit m_report_summarize_in_stack = 0 ;
  virtual function void report_summarize(UVM_FILE file = UVM_STDOUT);
     m_report_summarize_in_stack = 1 ;
     summarize(file);
     m_report_summarize_in_stack = 0 ;
  endfunction
  virtual function void summarize(UVM_FILE file = UVM_STDOUT);
     if (!m_report_summarize_in_stack) begin
       report_summarize(file);
     end
     else begin
       m_report_summarize(file);
     end
  endfunction
  virtual function void m_report_summarize(UVM_FILE file = UVM_STDOUT);
    string id;
    string name;
    uvm_root root;
    uvm_action action;
    string output_str;
    string q[$];
    uvm_report_catcher::summarize(file);
    q.push_back("\n--- UVM Report Summary ---\n\n");
    if(m_max_quit_count != 0) begin
      if ( m_quit_count >= m_max_quit_count ) begin
        q.push_back("Quit count reached!\n");
      end
      q.push_back($sformatf("Quit count : %5d of %5d\n",m_quit_count, m_max_quit_count));
    end
    q.push_back("** Report counts by severity\n");
    foreach(m_severity_count[s]) begin
      q.push_back($sformatf("%s :%5d\n", s.name(), m_severity_count[s]));
    end
    if (enable_report_id_count_summary) begin
      q.push_back("** Report counts by id\n");
      foreach(m_id_count[id]) begin
        q.push_back($sformatf("[%s] %5d\n", id, m_id_count[id]));
      end
    end
    if(file == UVM_STDOUT) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/REPORT/SERVER") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/REPORT/SERVER") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/REPORT/SERVER", uvm_pkg::m_uvm_string_queue_join(q), UVM_NONE, "t/uvm/src/base/uvm_report_server.svh", 1009, "", 1);
     end
   end
    end
    else begin
      root = uvm_root::get();
      action = root.get_report_action(UVM_INFO, "UVM/REPORT/SERVER");
      root.set_report_id_action("UVM/REPORT/SERVER", UVM_LOG);
      root.set_report_id_file("UVM/REPORT/SERVER", file);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/REPORT/SERVER") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/REPORT/SERVER") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/REPORT/SERVER", uvm_pkg::m_uvm_string_queue_join(q), UVM_NONE, "t/uvm/src/base/uvm_report_server.svh", 1017, "", 1);
     end
   end
      root.set_report_id_action("UVM/REPORT/SERVER", action);
    end
  endfunction
endclass
`define UVM_REPORT_HANDLER_SVH
typedef class uvm_report_object;
typedef class uvm_report_server;
typedef uvm_pool#(string, uvm_action) uvm_id_actions_array;
typedef uvm_pool#(string, UVM_FILE) uvm_id_file_array;
typedef uvm_pool#(string, int) uvm_id_verbosities_array;
typedef uvm_pool#(uvm_severity, uvm_severity) uvm_sev_override_array;
class uvm_report_handler extends uvm_object;
  int m_max_verbosity_level;
  uvm_id_verbosities_array id_verbosities;
  uvm_id_verbosities_array severity_id_verbosities[uvm_severity];
  uvm_id_actions_array id_actions;
  uvm_action severity_actions[uvm_severity];
  uvm_id_actions_array severity_id_actions[uvm_severity];
  uvm_sev_override_array sev_overrides;
  uvm_sev_override_array sev_id_overrides [string];
  UVM_FILE default_file_handle;
  uvm_id_file_array id_file_handles;
  UVM_FILE severity_file_handles[uvm_severity];
  uvm_id_file_array severity_id_file_handles[uvm_severity];
   typedef uvm_object_registry#(uvm_report_handler,"uvm_report_handler") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_report_handler tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_report_handler";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_report_handler";
     endfunction : get_type_name
  function new(string name = "uvm_report_handler");
    super.new(name);
    initialize();
  endfunction
  virtual function void do_print (uvm_printer printer);
    uvm_verbosity l_verbosity;
    uvm_severity l_severity;
    string idx;
    int l_int;
    if ($cast(l_verbosity, m_max_verbosity_level)) begin
      printer.print_generic("max_verbosity_level", "uvm_verbosity", 32,
        l_verbosity.name());
    end
    else begin
      printer.print_field("max_verbosity_level", m_max_verbosity_level, 32, UVM_DEC,
        ".", "int");
    end
    if(id_verbosities.first(idx)) begin
      printer.print_array_header("id_verbosities",id_verbosities.num(),
        "uvm_pool");
      do begin
        l_int = id_verbosities.get(idx);
        if ($cast(l_verbosity, l_int)) begin
          printer.print_generic($sformatf("[%s]", idx), "uvm_verbosity", 32,
            l_verbosity.name());
        end
        else begin
          string l_str;
          l_str.itoa(l_int);
          printer.print_generic($sformatf("[%s]", idx), "int", 32,
            l_str);
        end
      end while(id_verbosities.next(idx));
      printer.print_array_footer();
    end
    if(severity_id_verbosities.size() != 0) begin
      int _total_cnt;
      foreach (severity_id_verbosities[l_severity]) begin
        _total_cnt += severity_id_verbosities[l_severity].num();
      end
      printer.print_array_header("severity_id_verbosities", _total_cnt,
        "array");
      if(severity_id_verbosities.first(l_severity)) begin
        do begin
          uvm_id_verbosities_array id_v_ary = severity_id_verbosities[l_severity];
          if(id_v_ary.first(idx)) begin
            do begin
              l_int = id_v_ary.get(idx);
              if ($cast(l_verbosity, l_int)) begin
                printer.print_generic($sformatf("[%s:%s]", l_severity.name(), idx),
                    "uvm_verbosity", 32, l_verbosity.name());
              end
              else begin
                string l_str;
                l_str.itoa(l_int);
                printer.print_generic($sformatf("[%s:%s]", l_severity.name(), idx),
                    "int", 32, l_str);
              end
            end while(id_v_ary.next(idx));
          end
        end while(severity_id_verbosities.next(l_severity));
      end
      printer.print_array_footer();
    end
    if(id_actions.first(idx)) begin
      printer.print_array_header("id_actions",id_actions.num(),
        "uvm_pool");
      do begin
        l_int = id_actions.get(idx);
        printer.print_generic($sformatf("[%s]", idx), "uvm_action", 32,
          format_action(l_int));
      end while(id_actions.next(idx));
      printer.print_array_footer();
    end
    if(severity_actions.first(l_severity)) begin
      printer.print_array_header("severity_actions",4,"array");
      do begin
        printer.print_generic($sformatf("[%s]", l_severity.name()), "uvm_action", 32,
          format_action(severity_actions[l_severity]));
      end while(severity_actions.next(l_severity));
      printer.print_array_footer();
    end
    if(severity_id_actions.size() != 0) begin
      int _total_cnt;
      foreach (severity_id_actions[l_severity]) begin
        _total_cnt += severity_id_actions[l_severity].num();
      end
      printer.print_array_header("severity_id_actions", _total_cnt,
        "array");
      if(severity_id_actions.first(l_severity)) begin
        do begin
          uvm_id_actions_array id_a_ary = severity_id_actions[l_severity];
          if(id_a_ary.first(idx)) begin
            do begin
              printer.print_generic($sformatf("[%s:%s]", l_severity.name(), idx),
                  "uvm_action", 32, format_action(id_a_ary.get(idx)));
            end while(id_a_ary.next(idx));
          end
        end while(severity_id_actions.next(l_severity));
      end
      printer.print_array_footer();
    end
    if(sev_overrides.first(l_severity)) begin
      printer.print_array_header("sev_overrides",sev_overrides.num(),
        "uvm_pool");
      do begin
        uvm_severity l_severity_new = sev_overrides.get(l_severity);
        printer.print_generic($sformatf("[%s]", l_severity.name()),
          "uvm_severity", 32, l_severity_new.name());
      end while(sev_overrides.next(l_severity));
      printer.print_array_footer();
    end
    if(sev_id_overrides.size() != 0) begin
      int _total_cnt;
      foreach (sev_id_overrides[idx]) begin
        _total_cnt += sev_id_overrides[idx].num();
      end
      printer.print_array_header("sev_id_overrides", _total_cnt,
        "array");
      if(sev_id_overrides.first(idx)) begin
        do begin
          uvm_sev_override_array sev_o_ary = sev_id_overrides[idx];
          if(sev_o_ary.first(l_severity)) begin
            do begin
              uvm_severity new_sev = sev_o_ary.get(l_severity);
              printer.print_generic($sformatf("[%s:%s]", l_severity.name(), idx),
              "uvm_severity", 32, new_sev.name());
            end while(sev_o_ary.next(l_severity));
          end
        end while(sev_id_overrides.next(idx));
      end
      printer.print_array_footer();
    end
    printer.print_field("default_file_handle", default_file_handle, 32, UVM_HEX,
      ".", "int");
    if(id_file_handles.first(idx)) begin
      printer.print_array_header("id_file_handles",id_file_handles.num(),
        "uvm_pool");
      do begin
        printer.print_field($sformatf("[%s]", idx), id_file_handles.get(idx), 32,
          UVM_HEX, ".", "UVM_FILE");
      end while(id_file_handles.next(idx));
      printer.print_array_footer();
    end
    if(severity_file_handles.first(l_severity)) begin
      printer.print_array_header("severity_file_handles",4,"array");
      do begin
        printer.print_field($sformatf("[%s]", l_severity.name()),
          severity_file_handles[l_severity], 32, UVM_HEX, ".", "UVM_FILE");
      end while(severity_file_handles.next(l_severity));
      printer.print_array_footer();
    end
    if(severity_id_file_handles.size() != 0) begin
      int _total_cnt;
      foreach (severity_id_file_handles[l_severity]) begin
        _total_cnt += severity_id_file_handles[l_severity].num();
      end
      printer.print_array_header("severity_id_file_handles", _total_cnt,
        "array");
      if(severity_id_file_handles.first(l_severity)) begin
        do begin
          uvm_id_file_array id_f_ary = severity_id_file_handles[l_severity];
          if(id_f_ary.first(idx)) begin
            do begin
              printer.print_field($sformatf("[%s:%s]", l_severity.name(), idx),
              id_f_ary.get(idx), 32, UVM_HEX, ".", "UVM_FILE");
            end while(id_f_ary.next(idx));
          end
        end while(severity_id_file_handles.next(l_severity));
      end
      printer.print_array_footer();
    end
  endfunction
  virtual function void process_report_message(uvm_report_message report_message);
    uvm_report_server srvr = uvm_report_server::get_server();
    string id = report_message.get_id();
    uvm_severity severity = report_message.get_severity();
    if(sev_id_overrides.exists(id)) begin
      if(sev_id_overrides[id].exists(uvm_severity'(severity))) begin
        severity = sev_id_overrides[id].get(severity);
        report_message.set_severity(severity);
      end
    end
    else begin
      if(sev_overrides.exists(severity)) begin
        severity = sev_overrides.get(severity);
        report_message.set_severity(severity);
      end
    end
    report_message.set_file(get_file_handle(severity, id));
    report_message.set_report_handler(this);
    report_message.set_action(get_action(severity, id));
    srvr.process_report_message(report_message);
  endfunction
  static function string format_action(uvm_action action);
    string s;
    if(uvm_action_type'(action) == UVM_NO_ACTION) begin
      s = "NO ACTION";
    end
    else begin
      s = "";
      if(action & UVM_DISPLAY)   begin
        s = {s, "DISPLAY "};
      end
      if(action & UVM_LOG)       begin
        s = {s, "LOG "};
      end
      if(action & UVM_RM_RECORD) begin
        s = {s, "RM_RECORD "};
      end
      if(action & UVM_COUNT)     begin
        s = {s, "COUNT "};
      end
      if(action & UVM_CALL_HOOK) begin
        s = {s, "CALL_HOOK "};
      end
      if(action & UVM_EXIT)      begin
        s = {s, "EXIT "};
      end
      if(action & UVM_STOP)      begin
        s = {s, "STOP "};
      end
    end
    return s;
  endfunction
  function void initialize();
    set_default_file(0);
    m_max_verbosity_level = UVM_MEDIUM;
    id_actions=new();
    id_verbosities=new();
    id_file_handles=new();
    sev_overrides=new();
    set_severity_action(UVM_INFO, UVM_DISPLAY);
    set_severity_action(UVM_WARNING, UVM_DISPLAY);
    set_severity_action(UVM_ERROR, UVM_DISPLAY | UVM_COUNT);
    set_severity_action(UVM_FATAL, UVM_DISPLAY | UVM_EXIT);
    set_severity_file(UVM_INFO, default_file_handle);
    set_severity_file(UVM_WARNING, default_file_handle);
    set_severity_file(UVM_ERROR, default_file_handle);
    set_severity_file(UVM_FATAL, default_file_handle);
  endfunction
  local function UVM_FILE get_severity_id_file(uvm_severity severity, string id);
    uvm_id_file_array array;
    if(severity_id_file_handles.exists(severity)) begin
      array = severity_id_file_handles[severity];
      if(array.exists(id)) begin
        return array.get(id);
      end
    end
    if(id_file_handles.exists(id)) begin
      return id_file_handles.get(id);
    end
    if(severity_file_handles.exists(severity)) begin
      return severity_file_handles[severity];
    end
    return default_file_handle;
  endfunction
  function void set_verbosity_level(int verbosity_level);
    m_max_verbosity_level = verbosity_level;
  endfunction
  function int get_verbosity_level(uvm_severity severity=UVM_INFO, string id="" );
    uvm_id_verbosities_array array;
    if(severity_id_verbosities.exists(severity)) begin
      array = severity_id_verbosities[severity];
      if(array.exists(id)) begin
        return array.get(id);
      end
    end
    if(id_verbosities.exists(id)) begin
      return id_verbosities.get(id);
    end
    return m_max_verbosity_level;
  endfunction
  function uvm_action get_action(uvm_severity severity, string id);
    uvm_id_actions_array array;
    if(severity_id_actions.exists(severity)) begin
      array = severity_id_actions[severity];
      if(array.exists(id)) begin
        return array.get(id);
      end
    end
    if(id_actions.exists(id)) begin
      return id_actions.get(id);
    end
    return severity_actions[severity];
  endfunction
  function UVM_FILE get_file_handle(uvm_severity severity, string id);
    UVM_FILE file;
    file = get_severity_id_file(severity, id);
    if (file != 0) begin
      return file;
    end
    if (id_file_handles.exists(id)) begin
      file = id_file_handles.get(id);
      if (file != 0) begin
        return file;
      end
    end
    if (severity_file_handles.exists(severity)) begin
      file = severity_file_handles[severity];
      if(file != 0) begin
        return file;
      end
    end
    return default_file_handle;
  endfunction
  function void set_severity_action(input uvm_severity severity,
                                    input uvm_action action);
    severity_actions[severity] = action;
  endfunction
  function void set_id_action(input string id, input uvm_action action);
    id_actions.add(id, action);
  endfunction
  function void set_severity_id_action(uvm_severity severity,
                                       string id,
                                       uvm_action action);
    if(!severity_id_actions.exists(severity)) begin
      severity_id_actions[severity] = new;
    end
    severity_id_actions[severity].add(id,action);
  endfunction
  function void set_id_verbosity(input string id, input int verbosity);
    id_verbosities.add(id, verbosity);
  endfunction
  function void set_severity_id_verbosity(uvm_severity severity,
                                       string id,
                                       int verbosity);
    if(!severity_id_verbosities.exists(severity)) begin
      severity_id_verbosities[severity] = new;
    end
    severity_id_verbosities[severity].add(id,verbosity);
  endfunction
  function void set_default_file (UVM_FILE file);
    default_file_handle = file;
  endfunction
  function void set_severity_file (uvm_severity severity, UVM_FILE file);
    severity_file_handles[severity] = file;
  endfunction
  function void set_id_file (string id, UVM_FILE file);
    id_file_handles.add(id, file);
  endfunction
  function void set_severity_id_file(uvm_severity severity,
                                     string id, UVM_FILE file);
    if(!severity_id_file_handles.exists(severity)) begin
      severity_id_file_handles[severity] = new;
    end
    severity_id_file_handles[severity].add(id, file);
  endfunction
  function void set_severity_override(uvm_severity cur_severity,
                                      uvm_severity new_severity);
    sev_overrides.add(cur_severity, new_severity);
  endfunction
  function void set_severity_id_override(uvm_severity cur_severity,
                                         string id,
                                         uvm_severity new_severity);
    uvm_sev_override_array arr;
    if(!sev_id_overrides.exists(id)) begin
      sev_id_overrides[id] = new;
    end
    sev_id_overrides[id].add(cur_severity, new_severity);
  endfunction
  virtual function void report(
      uvm_severity severity,
      string name,
      string id,
      string message,
      int verbosity_level=UVM_MEDIUM,
      string filename="",
      int line=0,
      uvm_report_object client=null
      );
    bit l_report_enabled = 0;
    uvm_report_message l_report_message;
    uvm_coreservice_t cs;
    cs = uvm_coreservice_t::get();
    if (!uvm_report_enabled(verbosity_level, UVM_INFO, id)) begin
      return;
    end
    if (client==null) begin
      client = cs.get_root();
    end
    l_report_message = uvm_report_message::new_report_message();
    l_report_message.set_report_message(severity, id, message,
                    verbosity_level, filename, line, name);
    l_report_message.set_report_object(client);
    l_report_message.set_action(get_action(severity,id));
    process_report_message(l_report_message);
  endfunction
  function void dump_state();
    string s;
    UVM_FILE file;
    uvm_action a;
    string idx;
    string q[$];
    uvm_id_actions_array id_a_ary;
    uvm_id_verbosities_array id_v_ary;
    uvm_id_file_array id_f_ary;
    q.push_back("\n----------------------------------------------------------------------\n");
    q.push_back("report handler state dump \n\n");
    q.push_back("\n+-----------------+\n");
    q.push_back("|   Verbosities   |\n");
    q.push_back("+-----------------+\n\n");
    q.push_back($sformatf("max verbosity level = %d\n", m_max_verbosity_level));
    q.push_back("*** verbosities by id\n");
    if(id_verbosities.first(idx)) begin
      do begin
        uvm_verbosity v = uvm_verbosity'(id_verbosities.get(idx));
        q.push_back($sformatf("[%s] --> %s\n", idx, v.name()));
      end while(id_verbosities.next(idx));
    end
    q.push_back("*** verbosities by id and severity\n");
    foreach( severity_id_verbosities[severity] ) begin
      uvm_severity sev = uvm_severity'(severity);
      id_v_ary = severity_id_verbosities[severity];
      if(id_v_ary.first(idx)) begin
        do begin
          uvm_verbosity v = uvm_verbosity'(id_v_ary.get(idx));
          q.push_back($sformatf("%s:%s --> %s\n",sev.name(), idx, v.name()));
        end while(id_v_ary.next(idx));
      end
    end
    q.push_back("\n+-------------+\n");
    q.push_back("|   actions   |\n");
    q.push_back("+-------------+\n\n");
    q.push_back("*** actions by severity\n");
    foreach( severity_actions[severity] ) begin
      uvm_severity sev = uvm_severity'(severity);
      q.push_back($sformatf("%s = %s\n",sev.name(), format_action(severity_actions[severity])));
    end
    q.push_back("\n*** actions by id\n");
    if(id_actions.first(idx)) begin
      do begin
        q.push_back($sformatf("[%s] --> %s\n", idx, format_action(id_actions.get(idx))));
      end while(id_actions.next(idx));
    end
    q.push_back("\n*** actions by id and severity\n");
    foreach( severity_id_actions[severity] ) begin
      uvm_severity sev = uvm_severity'(severity);
      id_a_ary = severity_id_actions[severity];
      if(id_a_ary.first(idx)) begin
        do begin
          q.push_back($sformatf("%s:%s --> %s\n",sev.name(), idx, format_action(id_a_ary.get(idx))));
        end while(id_a_ary.next(idx));
      end
    end
    q.push_back("\n+-------------+\n");
    q.push_back("|    files    |\n");
    q.push_back("+-------------+\n\n");
    q.push_back($sformatf("default file handle = %d\n\n", default_file_handle));
    q.push_back("*** files by severity\n");
    foreach( severity_file_handles[severity] ) begin
      uvm_severity sev = uvm_severity'(severity);
      file = severity_file_handles[severity];
      q.push_back($sformatf("%s = %d\n", sev.name(), file));
    end
    q.push_back("\n*** files by id\n");
    if(id_file_handles.first(idx)) begin
      do begin
        file = id_file_handles.get(idx);
        q.push_back($sformatf("id %s --> %d\n", idx, file));
      end while (id_file_handles.next(idx));
    end
    q.push_back("\n*** files by id and severity\n");
    foreach( severity_id_file_handles[severity] ) begin
      uvm_severity sev = uvm_severity'(severity);
      id_f_ary = severity_id_file_handles[severity];
      if(id_f_ary.first(idx)) begin
        do begin
          q.push_back($sformatf("%s:%s --> %d\n", sev.name(), idx, id_f_ary.get(idx)));
        end while(id_f_ary.next(idx));
      end
    end
    q.push_back("----------------------------------------------------------------------\n");
    begin
      uvm_report_server srvr;
      srvr=uvm_report_server::get_server();
      srvr.report_summarize();
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/REPORT/HANDLER") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/REPORT/HANDLER") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/REPORT/HANDLER", uvm_pkg::m_uvm_string_queue_join(q), UVM_LOW, "t/uvm/src/base/uvm_report_handler.svh", 899, "", 1);
     end
   end
  endfunction
  virtual function bit run_hooks(uvm_report_object client,
                                 uvm_severity severity,
                                 string id,
                                 string message,
                                 int verbosity,
                                 string filename,
                                 int line);
    bit ok;
    ok = client.report_hook(id, message, verbosity, filename, line);
    case(severity)
      UVM_INFO: begin
        ok &= client.report_info_hook   (id, message, verbosity, filename, line);
      end
      UVM_WARNING: begin
        ok &= client.report_warning_hook(id, message, verbosity, filename, line);
      end
      UVM_ERROR: begin
        ok &= client.report_error_hook  (id, message, verbosity, filename, line);
      end
      UVM_FATAL: begin
        ok &= client.report_fatal_hook  (id, message, verbosity, filename, line);
      end
    endcase
    return ok;
  endfunction
endclass : uvm_report_handler
`define UVM_REPORT_CLIENT_SVH
typedef class uvm_component;
typedef class uvm_env;
typedef class uvm_root;
class uvm_report_object extends uvm_object;
  uvm_report_handler m_rh;
  local bit m_rh_set;
  local function void m_rh_init();
    if (!m_rh_set)
      begin
        set_report_handler(uvm_report_handler::type_id::create(get_name()));
      end
  endfunction : m_rh_init
  function new(string name = "");
    super.new(name);
  endfunction
  function uvm_report_object uvm_get_report_object();
    return this;
  endfunction
  function int uvm_report_enabled(int verbosity,
                    uvm_severity severity = UVM_INFO, string id = "");
    if (get_report_verbosity_level(severity, id) < verbosity)
      begin
        return 0;
      end
    return 1;
  endfunction
  virtual function void uvm_report( uvm_severity severity,
                                    string id,
                                    string message,
                                    int verbosity = (severity == uvm_severity'(UVM_ERROR)) ? UVM_NONE :
                                                    (severity == uvm_severity'(UVM_FATAL)) ? UVM_NONE :
                                                    (severity == uvm_severity'(UVM_WARNING)) ? UVM_NONE : UVM_MEDIUM,
                                    string filename = "",
                                    int line = 0,
                                    string context_name = "",
                                    bit report_enabled_checked =0);
    uvm_report_message l_report_message;
    if ((severity == UVM_INFO) && (report_enabled_checked == 0))
      begin
        if (!uvm_report_enabled(verbosity, severity, id))
        begin
          return;
        end
      end
    l_report_message = uvm_report_message::new_report_message();
    l_report_message.set_report_message(severity, id, message,
                    verbosity, filename, line, context_name);
    uvm_process_report_message(l_report_message);
  endfunction
  virtual function void uvm_report_info( string id,
                     string message,
                     int verbosity = UVM_MEDIUM,
                     string filename = "",
                     int line = 0,
                         string context_name = "",
                     bit report_enabled_checked = 0);
    uvm_report (UVM_INFO, id, message, verbosity,
                filename, line, context_name, report_enabled_checked);
  endfunction
  virtual function void uvm_report_warning( string id,
                        string message,
                        int verbosity = UVM_NONE,
                        string filename = "",
                        int line = 0,
                            string context_name = "",
                        bit report_enabled_checked = 0);
    uvm_report (UVM_WARNING, id, message, verbosity,
                filename, line, context_name, report_enabled_checked);
  endfunction
  virtual function void uvm_report_error( string id,
                      string message,
                         int verbosity = UVM_NONE,
                      string filename = "",
                      int line = 0,
                         string context_name = "",
                      bit report_enabled_checked = 0);
    uvm_report (UVM_ERROR, id, message, verbosity,
                filename, line, context_name, report_enabled_checked);
  endfunction
  virtual function void uvm_report_fatal( string id,
                      string message,
                         int verbosity = UVM_NONE,
                      string filename = "",
                      int line = 0,
                         string context_name = "",
                      bit report_enabled_checked = 0);
    uvm_report (UVM_FATAL, id, message, verbosity,
                filename, line, context_name, report_enabled_checked);
  endfunction
  virtual function void uvm_process_report_message(uvm_report_message report_message);
    m_rh_init();
    report_message.set_report_object(this);
    m_rh.process_report_message(report_message);
  endfunction
  function int get_report_verbosity_level(uvm_severity severity=UVM_INFO, string id="");
    m_rh_init();
    return m_rh.get_verbosity_level(severity, id);
  endfunction
  function int get_report_max_verbosity_level();
    m_rh_init();
    return m_rh.m_max_verbosity_level;
  endfunction
  function void set_report_verbosity_level (int verbosity_level);
    m_rh_init();
    m_rh.set_verbosity_level(verbosity_level);
  endfunction
  function void set_report_id_verbosity (string id, int verbosity);
    m_rh_init();
    m_rh.set_id_verbosity(id, verbosity);
  endfunction
  function void set_report_severity_id_verbosity (uvm_severity severity,
                                               string id, int verbosity);
    m_rh_init();
    m_rh.set_severity_id_verbosity(severity, id, verbosity);
  endfunction
  function int get_report_action(uvm_severity severity, string id);
    m_rh_init();
    return m_rh.get_action(severity,id);
  endfunction
  function void set_report_severity_action (uvm_severity severity,
                                            uvm_action action);
    m_rh_init();
    m_rh.set_severity_action(severity, action);
  endfunction
  function void set_report_id_action (string id, uvm_action action);
    m_rh_init();
    m_rh.set_id_action(id, action);
  endfunction
  function void set_report_severity_id_action (uvm_severity severity,
                                               string id, uvm_action action);
    m_rh_init();
    m_rh.set_severity_id_action(severity, id, action);
  endfunction
  function int get_report_file_handle(uvm_severity severity, string id);
    m_rh_init();
    return m_rh.get_file_handle(severity,id);
  endfunction
  function void set_report_default_file (UVM_FILE file);
    m_rh_init();
    m_rh.set_default_file(file);
  endfunction
  function void set_report_id_file (string id, UVM_FILE file);
    m_rh_init();
    m_rh.set_id_file(id, file);
  endfunction
  function void set_report_severity_file (uvm_severity severity, UVM_FILE file);
    m_rh_init();
    m_rh.set_severity_file(severity, file);
  endfunction
  function void set_report_severity_id_file (uvm_severity severity, string id,
                                             UVM_FILE file);
    m_rh_init();
    m_rh.set_severity_id_file(severity, id, file);
  endfunction
  function void set_report_severity_override(uvm_severity cur_severity,
                                             uvm_severity new_severity);
    m_rh_init();
    m_rh.set_severity_override(cur_severity, new_severity);
  endfunction
  function void set_report_severity_id_override(uvm_severity cur_severity,
                                                string id,
                                                uvm_severity new_severity);
    m_rh_init();
    m_rh.set_severity_id_override(cur_severity, id, new_severity);
  endfunction
  function void set_report_handler(uvm_report_handler handler);
    m_rh = handler;
    m_rh_set = 1;
  endfunction
  function uvm_report_handler get_report_handler();
    m_rh_init();
    return m_rh;
  endfunction
  function void reset_report_handler;
    m_rh_init();
    m_rh.initialize();
  endfunction
  virtual function void report_header(UVM_FILE file = 0);
    uvm_root top = uvm_root::get();
    if (this == top)
      begin
        return;
      end
    top.report_header(file);
  endfunction : report_header
  virtual function void die();
    uvm_root top = uvm_root::get();
    if (this == top)
      begin
        return;
      end
    top.die();
  endfunction : die
  virtual function void report_summarize(UVM_FILE file = 0);
    uvm_report_server svr = uvm_report_server::get_server();
    svr.report_summarize(file);
  endfunction : report_summarize
  function void set_report_max_quit_count(int max_count);
    uvm_report_server svr = uvm_report_server::get_server();
    svr.set_max_quit_count(max_count);
  endfunction : set_report_max_quit_count
  function void dump_report_state();
    m_rh.dump_state();
  endfunction
  virtual function bit report_info_hook(
           string id, string message, int verbosity, string filename, int line);
    return 1;
  endfunction
  virtual function bit report_error_hook(
           string id, string message, int verbosity, string filename, int line);
    return 1;
  endfunction
  virtual function bit report_warning_hook(
           string id, string message, int verbosity, string filename, int line);
    return 1;
  endfunction
  virtual function bit report_fatal_hook(
           string id, string message, int verbosity, string filename, int line);
    return 1;
  endfunction
  virtual function bit report_hook(
           string id, string message, int verbosity, string filename, int line);
    return 1;
  endfunction
  function uvm_report_server get_report_server();
      return uvm_report_server::get_server();
  endfunction
endclass
typedef class uvm_event;
typedef class uvm_event_pool;
typedef class uvm_component;
typedef class uvm_parent_child_link;
virtual class uvm_transaction extends uvm_object;
  extern function new (string name="", uvm_component initiator=null);
  extern function void accept_tr (time accept_time = 0);
  extern virtual protected function void do_accept_tr ();
  extern function uvm_tr_handle_t begin_tr (
     time begin_time = 0
     , uvm_tr_handle_t parent_handle = 0
  );
  extern function uvm_tr_handle_t begin_child_tr (time begin_time = 0,
                                               uvm_tr_handle_t parent_handle = 0);
  extern virtual protected function void do_begin_tr ();
  extern function void end_tr (time end_time=0, bit free_handle=1);
  extern virtual protected function void do_end_tr ();
  extern function uvm_tr_handle_t get_tr_handle ();
  extern function void disable_recording ();
  extern function void enable_recording (uvm_tr_stream stream);
  extern function bit is_recording_enabled();
  extern function bit is_active ();
  extern function uvm_event_pool get_event_pool ();
  extern function void set_initiator (uvm_component initiator);
  extern function uvm_component get_initiator ();
  extern function time   get_accept_time    ();
  extern function time   get_begin_time     ();
  extern function time   get_end_time       ();
  extern function void set_transaction_id(uvm_transaction_id_t id);
  extern function uvm_transaction_id_t get_transaction_id();
  const local uvm_event_pool events = new("events");
  extern virtual function void do_print  (uvm_printer printer);
  extern virtual function void do_record (uvm_recorder recorder);
  extern virtual function void do_copy   (uvm_object rhs);
  extern protected function uvm_tr_handle_t m_begin_tr (time    begin_time=0,
                                                uvm_tr_handle_t parent_handle=0);
  local uvm_transaction_id_t m_transaction_id = -1;
  local time    begin_time=-1;
  local time    end_time=-1;
  local time    accept_time=-1;
  local uvm_component initiator;
  local uvm_tr_stream stream_handle;
  local uvm_recorder      tr_recorder;
  uvm_event#(uvm_object) begin_event;
  uvm_event#(uvm_object) end_event;
endclass
function uvm_transaction::new (string name="",
                               uvm_component initiator = null);
  super.new(name);
  this.initiator = initiator;
  m_transaction_id = -1;
endfunction
function void uvm_transaction::set_transaction_id(uvm_transaction_id_t id);
    m_transaction_id = id;
endfunction
function uvm_transaction_id_t uvm_transaction::get_transaction_id();
    return (m_transaction_id);
endfunction
function void uvm_transaction::set_initiator(uvm_component initiator);
  this.initiator = initiator;
endfunction
function uvm_component uvm_transaction::get_initiator();
  return initiator;
endfunction
function uvm_event_pool uvm_transaction::get_event_pool();
  return events;
endfunction
function bit uvm_transaction::is_active();
  return (end_time == -1);
endfunction
function time uvm_transaction::get_begin_time ();
  return begin_time;
endfunction
function time uvm_transaction::get_end_time ();
  return end_time;
endfunction
function time uvm_transaction::get_accept_time ();
  return accept_time;
endfunction
function void uvm_transaction::do_accept_tr();
  return;
endfunction
function void uvm_transaction::do_begin_tr();
  return;
endfunction
function void uvm_transaction::do_end_tr();
  return;
endfunction
function void uvm_transaction::do_print (uvm_printer printer);
  string str;
  uvm_component tmp_initiator;
  super.do_print(printer);
  if(accept_time != -1)
    begin
      printer.print_time("accept_time", accept_time);
    end
  if(begin_time != -1)
    begin
      printer.print_time("begin_time", begin_time);
    end
  if(end_time != -1)
    begin
      printer.print_time("end_time", end_time);
    end
  if(initiator != null)
    begin
      tmp_initiator = initiator;
      $swrite(str,"@%0d", tmp_initiator.get_inst_id());
      printer.print_generic("initiator", initiator.get_type_name(), -1, str);
    end
endfunction
function void uvm_transaction::do_copy (uvm_object rhs);
  uvm_transaction txn;
  super.do_copy(rhs);
  if(rhs == null)
    begin
      return;
    end
  if(!$cast(txn, rhs) )
    begin
      return;
    end
  accept_time = txn.accept_time;
  begin_time = txn.begin_time;
  end_time = txn.end_time;
  initiator = txn.initiator;
  stream_handle = txn.stream_handle;
  tr_recorder = txn.tr_recorder;
endfunction
function void uvm_transaction::do_record (uvm_recorder recorder);
  string s;
  super.do_record(recorder);
  if(accept_time != -1)
    begin
      recorder.record_field("accept_time", accept_time, $bits(accept_time), UVM_TIME);
    end
  if(initiator != null)
    begin
      uvm_recursion_policy_enum p = recorder.get_recursion_policy();
      recorder.set_recursion_policy(UVM_REFERENCE);
      recorder.record_object("initiator", initiator);
      recorder.set_recursion_policy(p);
    end
endfunction
function uvm_tr_handle_t uvm_transaction::get_tr_handle ();
   if (tr_recorder != null)
     begin
       return tr_recorder.get_handle();
     end
   else
     begin
       return 0;
     end
endfunction
function void uvm_transaction::disable_recording ();
   this.stream_handle = null;
endfunction
function void uvm_transaction::enable_recording (uvm_tr_stream stream);
   this.stream_handle = stream;
endfunction : enable_recording
function bit uvm_transaction::is_recording_enabled ();
  return (this.stream_handle != null);
endfunction
function void uvm_transaction::accept_tr (time accept_time = 0);
  uvm_event#(uvm_object) e;
  if(accept_time != 0)
    begin
      this.accept_time = accept_time;
    end
  else
    begin
      this.accept_time = $realtime;
    end
  do_accept_tr();
  e = events.get("accept");
  if(e!=null)
    begin
      e.trigger();
    end
endfunction
function uvm_tr_handle_t uvm_transaction::begin_tr (
     time begin_time = 0
     , uvm_tr_handle_t parent_handle = 0
);
   return m_begin_tr(
      begin_time
      , parent_handle
   );
endfunction
function uvm_tr_handle_t uvm_transaction::begin_child_tr (time begin_time=0,
                                                  uvm_tr_handle_t parent_handle=0);
  return m_begin_tr(begin_time, parent_handle);
endfunction
function uvm_tr_handle_t uvm_transaction::m_begin_tr (time begin_time=0,
                                              uvm_tr_handle_t parent_handle=0);
   time tmp_time = (begin_time == 0) ? $realtime : begin_time;
   uvm_recorder parent_recorder;
   if (parent_handle != 0)
     begin
       parent_recorder = uvm_recorder::get_recorder_from_handle(parent_handle);
     end
   if (tr_recorder != null)
     begin
       end_tr(tmp_time);
     end
   if(is_recording_enabled())
     begin
       uvm_tr_database db = stream_handle.get_db();
       this.end_time = -1;
       this.begin_time = tmp_time;
       if(parent_recorder == null)
       begin
         tr_recorder = stream_handle.open_recorder(get_type_name(),
                                                  this.begin_time,
                                                  "Begin_No_Parent, Link");
       end
       else
       begin
         tr_recorder = stream_handle.open_recorder(get_type_name(),
                                                   this.begin_time,
                                                   "Begin_End, Link");
         if (tr_recorder != null)
         begin
           db.establish_link(uvm_parent_child_link::get_link(parent_recorder, tr_recorder));
         end
       end
       if (tr_recorder != null)
       begin
         m_begin_tr = tr_recorder.get_handle();
       end
       else
       begin
         m_begin_tr = 0;
       end
     end
   else
     begin
       tr_recorder = null;
       this.end_time = -1;
       this.begin_time = tmp_time;
       m_begin_tr = 0;
     end
   do_begin_tr();
   begin
     begin_event = events.get("begin");
     begin_event.trigger();
   end
endfunction
function void uvm_transaction::end_tr (time end_time=0, bit free_handle=1);
   this.end_time = (end_time == 0) ? $realtime : end_time;
   do_end_tr();
   if(is_recording_enabled() && (tr_recorder != null))
     begin
       record(tr_recorder);
       tr_recorder.close(this.end_time);
       if(free_handle)
       begin
         tr_recorder.free();
       end
     end
   tr_recorder = null;
   begin
     end_event = events.get("end") ;
     end_event.trigger();
   end
endfunction
typedef class uvm_sequencer_base;
typedef class uvm_domain;
typedef class uvm_task_phase;
typedef class uvm_phase_cb;
typedef class uvm_phase_state_change;
class uvm_phase extends uvm_object;
  static local bit m_register_cb_uvm_phase_cb = uvm_callbacks#(uvm_phase,uvm_phase_cb)::m_register_pair("uvm_phase","uvm_phase_cb");
  extern function new(string name="uvm_phase",
                      uvm_phase_type phase_type=UVM_PHASE_SCHEDULE,
                      uvm_phase parent=null);
  extern function uvm_phase_type get_phase_type();
  extern virtual function void set_max_ready_to_end_iterations(int max);
  extern virtual function int get_max_ready_to_end_iterations();
  extern static function void set_default_max_ready_to_end_iterations(int max);
  extern static function int get_default_max_ready_to_end_iterations();
  extern function void set_state(uvm_phase_state state);
  extern function uvm_phase_state get_state();
  extern function int get_run_count();
  extern function uvm_phase find_by_name(string name, bit stay_in_scope=1);
  extern function uvm_phase find(uvm_phase phase, bit stay_in_scope=1);
  extern function bit is(uvm_phase phase);
  extern function bit is_before(uvm_phase phase);
  extern function bit is_after(uvm_phase phase);
  virtual function void exec_func(uvm_component comp, uvm_phase phase); endfunction
  virtual task exec_task(uvm_component comp, uvm_phase phase); endtask
  extern function void add(uvm_phase phase,
                           uvm_phase with_phase=null,
                           uvm_phase after_phase=null,
                           uvm_phase before_phase=null,
                           uvm_phase start_with_phase=null,
                           uvm_phase end_with_phase=null
                        );
  extern function uvm_phase get_parent();
  extern virtual function string get_full_name();
  extern function uvm_phase get_schedule(bit hier = 0);
  extern function string get_schedule_name(bit hier = 0);
  extern function uvm_domain get_domain();
  extern function uvm_phase get_imp();
  extern function string get_domain_name();
  extern function void get_adjacent_predecessor_nodes(ref uvm_phase pred[]);
  extern function void get_adjacent_successor_nodes(ref uvm_phase succ[]);
  extern function void m_report_null_objection(uvm_object obj,
                                               string description,
                                               int count,
                                               string action);
  extern virtual function void raise_objection (uvm_object obj,
                                                string description="",
                                                int count=1);
  extern virtual function void drop_objection (uvm_object obj,
                                               string description="",
                                               int count=1);
  extern virtual function int get_objection_count( uvm_object obj=null );
  extern virtual function int get_objection_total( uvm_object obj=null );
  extern function void sync(uvm_domain target,
                            uvm_phase phase=null,
                            uvm_phase with_phase=null);
  extern function void unsync(uvm_domain target,
                              uvm_phase phase=null,
                              uvm_phase with_phase=null);
  extern task wait_for_state(uvm_phase_state state, uvm_wait_op op=UVM_EQ);
  extern function void jump(uvm_phase phase);
  extern function void set_jump_phase(uvm_phase phase) ;
  extern function bit is_jumping_forward();
  extern function bit is_jumping_backward();
  extern function void end_prematurely() ;
  extern function bit is_ending_prematurely();
  extern static function void jump_all(uvm_phase phase);
  extern function uvm_phase get_jump_target();
  typedef bit edges_t[uvm_phase];
  protected uvm_phase_type m_phase_type;
  protected uvm_phase      m_parent;
  uvm_phase                m_imp;
  local uvm_phase_state    m_state;
  local int                m_run_count;
  protected uvm_phase_state_change m_state_chg;
    process            m_phase_proc;
  local static int         m_default_max_ready_to_end_iters = 20;
  local int                      max_ready_to_end_iters = get_default_max_ready_to_end_iterations();
  int                      m_num_procs_not_yet_returned;
  extern function uvm_phase m_find_predecessor(uvm_phase phase, bit stay_in_scope=1, uvm_phase orig_phase=null);
  extern function uvm_phase m_find_successor(uvm_phase phase, bit stay_in_scope=1, uvm_phase orig_phase=null);
  extern function uvm_phase m_find_predecessor_by_name(string name, bit stay_in_scope=1, uvm_phase orig_phase=null);
  extern function uvm_phase m_find_successor_by_name(string name, bit stay_in_scope=1, uvm_phase orig_phase=null);
  extern function void m_print_successors();
  virtual function void traverse(uvm_component comp,
                                 uvm_phase phase,
                                 uvm_phase_state state);
  endfunction
  virtual function void execute(uvm_component comp,
                                 uvm_phase phase);
  endfunction
  protected edges_t m_predecessors;
  protected edges_t m_successors;
  protected uvm_phase m_end_node;
  static protected edges_t m_executing_phases;
  function uvm_phase get_begin_node(); if (m_imp != null) begin
    return this;
  end
 return null; endfunction
  function uvm_phase get_end_node();   return m_end_node; endfunction
  local uvm_phase m_sync[$];
  uvm_objection phase_done;
  extern function void get_predecessors(ref edges_t predecessors);
  extern function void get_successors(ref edges_t successors);
  extern function void get_sync_relationships(ref edges_t relationships);
  extern local function void get_predecessors_for_successors(output edges_t pred_of_succ);
  extern   task m_wait_for_pred();
  local bit                m_jump_bkwd;
  local bit                m_jump_fwd;
  local uvm_phase          m_jump_phase;
    bit                m_premature_end;
  extern function void clear(uvm_phase_state state = UVM_PHASE_DORMANT);
  extern function void clear_successors(
                             uvm_phase_state state = UVM_PHASE_DORMANT,
                             uvm_phase end_state=null);
  local static mailbox #(uvm_phase) m_phase_hopper = new();
  extern local function void m_terminate_phase();
  extern local function void m_print_termination_state();
  extern   task wait_for_self_and_siblings_to_drop();
  extern function void kill();
  extern function void kill_successors();
    static bit m_phase_trace;
    static bit m_use_ovm_run_semantic;
  function string convert2string();
  string s;
    s = $sformatf("phase: %s parent=%s  pred=%s  succ=%s",get_name(),
                     (m_parent==null) ? "null" : get_schedule_name(),
                     m_aa2string(m_predecessors),
                     m_aa2string(m_successors));
    return s;
  endfunction
  local function string m_aa2string(edges_t aa);
    string s;
    int i;
    s = "'{ ";
    foreach (aa[ph]) begin
      uvm_phase n = ph;
      s = {s, (n == null) ? "null" : n.get_name(),
        (i == aa.num()-1) ? "" : ", "};
      i++;
    end
    s = {s, " }"};
    return s;
  endfunction
  function bit is_domain();
    return (m_phase_type == UVM_PHASE_DOMAIN);
  endfunction
  virtual function void m_get_transitive_children(ref uvm_phase phases[$]);
    foreach (m_successors[succ]) begin
      phases.push_back(succ);
      succ.m_get_transitive_children(phases);
    end
  endfunction
  function uvm_objection get_objection();
     uvm_phase imp;
     uvm_task_phase tp;
     imp = get_imp();
     if ((get_phase_type() != UVM_PHASE_NODE) || (imp == null) || !$cast(tp, imp)) begin
       return null;
     end
     if (phase_done == null) begin
       phase_done = uvm_objection::type_id::create({get_name(), "_objection"});
     end
     return phase_done;
  endfunction
endclass
class uvm_phase_state_change extends uvm_object;
   typedef uvm_object_registry#(uvm_phase_state_change,"uvm_phase_state_change") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_phase_state_change tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_phase_state_change";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_phase_state_change";
     endfunction : get_type_name
    uvm_phase       m_phase;
    uvm_phase_state m_prev_state;
    uvm_phase       m_jump_to;
  function new(string name = "uvm_phase_state_change");
    super.new(name);
  endfunction
  virtual function uvm_phase_state get_state();
    return m_phase.get_state();
  endfunction
  virtual function uvm_phase_state get_prev_state();
    return m_prev_state;
  endfunction
  function uvm_phase jump_to();
    return m_jump_to;
  endfunction
endclass
class uvm_phase_cb extends uvm_callback;
  function new(string name="unnamed-uvm_phase_cb");
     super.new(name);
  endfunction : new
  virtual function void phase_state_change(uvm_phase phase,
                                           uvm_phase_state_change change);
  endfunction
endclass
typedef uvm_callbacks#(uvm_phase, uvm_phase_cb) uvm_phase_cb_pool   ;
typedef class uvm_cmdline_processor;
`define UVM_PH_TRACE(ID,MSG,PH,VERB) \
  if (uvm_phase::m_phase_trace) \
   `uvm_info(ID, {$sformatf("Phase '%0s' (id=%0d) ", \
       PH.get_full_name(), PH.get_inst_id()),MSG}, VERB)
function uvm_phase::new(string name="uvm_phase",
                        uvm_phase_type phase_type=UVM_PHASE_SCHEDULE,
                        uvm_phase parent=null);
  super.new(name);
  m_state_chg = uvm_phase_state_change::type_id::create(name);
  m_state_chg.m_phase = this;
  m_phase_type = phase_type;
  if ((name == "common") &&
      (phase_type == UVM_PHASE_DOMAIN)) begin
    m_state = UVM_PHASE_DORMANT;
  end
  m_run_count = 0;
  m_parent = parent;
  begin
    uvm_cmdline_processor clp = uvm_cmdline_processor::get_inst();
    string val;
    if (clp.get_arg_value("+UVM_PHASE_TRACE", val)) begin
      m_phase_trace = 1;
    end
    else begin
      m_phase_trace = 0;
    end
    if (clp.get_arg_value("+UVM_USE_OVM_RUN_SEMANTIC", val)) begin
      m_use_ovm_run_semantic = 1;
    end
    else begin
      m_use_ovm_run_semantic = 0;
    end
  end
  if (parent == null && (phase_type == UVM_PHASE_SCHEDULE ||
                         phase_type == UVM_PHASE_DOMAIN )) begin
    m_end_node = new({name,"_end"}, UVM_PHASE_TERMINAL, this);
    this.m_successors[m_end_node] = 1;
    m_end_node.m_predecessors[this] = 1;
  end
endfunction
function void uvm_phase::add(uvm_phase phase,
                             uvm_phase with_phase=null,
                             uvm_phase after_phase=null,
                             uvm_phase before_phase=null,
                             uvm_phase start_with_phase=null,
                             uvm_phase end_with_phase=null
                          );
  uvm_phase new_node, begin_node, end_node, tmp_node;
  uvm_phase_state_change state_chg;
  if (phase == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH/NULL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH/NULL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH/NULL", "add: phase argument is null", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 775, "", 1);
     end
   end
  end
  if (with_phase != null && with_phase.get_phase_type() == UVM_PHASE_IMP) begin
    string nm = with_phase.get_name();
    with_phase = find(with_phase);
    if (with_phase == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"cannot find with_phase '",nm,"' within node '",get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 783, "", 1);
     end
   end
    end
  end
  if (before_phase != null && before_phase.get_phase_type() == UVM_PHASE_IMP) begin
    string nm = before_phase.get_name();
    before_phase = find(before_phase);
    if (before_phase == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"cannot find before_phase '",nm,"' within node '",get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 792, "", 1);
     end
   end
    end
  end
  if (after_phase != null && after_phase.get_phase_type() == UVM_PHASE_IMP) begin
    string nm = after_phase.get_name();
    after_phase = find(after_phase);
    if (after_phase == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"cannot find after_phase '",nm,"' within node '",get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 801, "", 1);
     end
   end
    end
  end
  if (start_with_phase != null && start_with_phase.get_phase_type() == UVM_PHASE_IMP) begin
    string nm = start_with_phase.get_name();
    start_with_phase = find(start_with_phase);
    if (start_with_phase == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"cannot find start_with_phase '",nm,"' within node '",get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 810, "", 1);
     end
   end
    end
  end
  if (end_with_phase != null && end_with_phase.get_phase_type() == UVM_PHASE_IMP) begin
    string nm = end_with_phase.get_name();
    end_with_phase = find(end_with_phase);
    if (end_with_phase == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"cannot find end_with_phase '",nm,"' within node '",get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 819, "", 1);
     end
   end
    end
  end
  if (((with_phase != null) + (after_phase != null) + (start_with_phase != null)) > 1) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", "only one of with_phase/after_phase/start_with_phase may be specified as they all specify predecessor", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 825, "", 1);
     end
   end
  end
  if (((with_phase != null) + (before_phase != null) + (end_with_phase != null)) > 1) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", "only one of with_phase/before_phase/end_with_phase may be specified as they all specify successor", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 830, "", 1);
     end
   end
  end
  if (before_phase == this ||
     after_phase == m_end_node ||
     with_phase == m_end_node ||
     start_with_phase == m_end_node ||
     end_with_phase == m_end_node) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", "cannot add before begin node, after end node, or with end nodes", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 839, "", 1);
     end
   end
  end
  if (before_phase != null && after_phase != null) begin
    if (!after_phase.is_before(before_phase)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"Phase '",before_phase.get_name(), "' is not before phase '",after_phase.get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 845, "", 1);
     end
   end
    end
  end
  if (before_phase != null && start_with_phase != null) begin
    if (!start_with_phase.is_before(before_phase)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"Phase '",before_phase.get_name(), "' is not before phase '",start_with_phase.get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 852, "", 1);
     end
   end
    end
  end
  if (end_with_phase != null && after_phase != null) begin
    if (!after_phase.is_before(end_with_phase)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BAD_ADD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BAD_ADD", {"Phase '",end_with_phase.get_name(), "' is not before phase '",after_phase.get_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 859, "", 1);
     end
   end
    end
  end
  if (phase.get_phase_type() == UVM_PHASE_IMP) begin
    uvm_task_phase tp;
    new_node = new(phase.get_name(),UVM_PHASE_NODE,this);
    new_node.m_imp = phase;
    begin_node = new_node;
    end_node = new_node;
  end
  else begin
    begin_node = phase;
    end_node   = phase.m_end_node;
    phase.m_parent = this;
  end
  if (with_phase==null && after_phase==null && before_phase==null &&
     start_with_phase==null && end_with_phase==null) begin
    before_phase = m_end_node;
  end
  if (m_phase_trace) begin
    uvm_phase_type typ = phase.get_phase_type();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/ADD_PH") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/ADD_PH") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/ADD_PH", {get_name()," (",m_phase_type.name(),") ADD_PHASE: phase=",phase.get_full_name()," (", typ.name(),", inst_id=",$sformatf("%0d",phase.get_inst_id()),")", " with_phase=", (with_phase == null)   ? "null" : with_phase.get_name(), " start_with_phase=", (start_with_phase == null)   ? "null" : start_with_phase.get_name(), " end_with_phase=", (end_with_phase == null)   ? "null" : end_with_phase.get_name(), " after_phase=", (after_phase == null)  ? "null" : after_phase.get_name(), " before_phase=", (before_phase == null) ? "null" : before_phase.get_name(), " new_node=", (new_node == null)     ? "null" : {new_node.get_name(), " inst_id=", $sformatf("%0d",new_node.get_inst_id())}, " begin_node=", (begin_node == null)   ? "null" : begin_node.get_name(), " end_node=", (end_node == null)     ? "null" : end_node.get_name()}, UVM_DEBUG, "t/uvm/src/base/uvm_phase.svh", 908, "", 1);
     end
   end
  end
  if (with_phase != null) begin
    begin_node.m_predecessors = with_phase.m_predecessors;
    foreach (with_phase.m_predecessors[pred]) begin
      pred.m_successors[begin_node] = 1;
    end
    end_node.m_successors = with_phase.m_successors;
    foreach (with_phase.m_successors[succ]) begin
      succ.m_predecessors[end_node] = 1;
    end
  end
  if (start_with_phase != null) begin
    begin_node.m_predecessors = start_with_phase.m_predecessors;
    foreach (start_with_phase.m_predecessors[pred]) begin
      pred.m_successors[begin_node] = 1;
    end
    if (before_phase == null && end_with_phase == null) begin
      end_node.m_successors = m_end_node.m_successors ;
      foreach (m_end_node.m_successors[succ]) begin
        succ.m_predecessors[end_node] = 1;
      end
    end
  end
  if (end_with_phase != null) begin
    end_node.m_successors = end_with_phase.m_successors;
    foreach (end_with_phase.m_successors[succ]) begin
      succ.m_predecessors[end_node] = 1;
    end
    if (after_phase == null && start_with_phase == null) begin
      begin_node.m_predecessors = this.m_predecessors ;
      foreach (this.m_predecessors[pred]) begin
        pred.m_successors[begin_node] = 1;
      end
    end
  end
  if (before_phase != null) begin
    if (after_phase == null && start_with_phase == null) begin
      foreach (before_phase.m_predecessors[pred]) begin
        pred.m_successors.delete(before_phase);
        pred.m_successors[begin_node] = 1;
      end
      begin_node.m_predecessors = before_phase.m_predecessors;
      before_phase.m_predecessors.delete();
    end
    else if (before_phase.m_predecessors.exists(after_phase)) begin
      before_phase.m_predecessors.delete(after_phase);
    end
    before_phase.m_predecessors[end_node] = 1;
    end_node.m_successors.delete() ;
    end_node.m_successors[before_phase] = 1;
  end
  if (after_phase != null) begin
    if (before_phase == null && end_with_phase == null) begin
      foreach (after_phase.m_successors[succ]) begin
        succ.m_predecessors.delete(after_phase);
        succ.m_predecessors[end_node] = 1;
      end
      end_node.m_successors = after_phase.m_successors;
      after_phase.m_successors.delete();
    end
    else if (after_phase.m_successors.exists(before_phase)) begin
      after_phase.m_successors.delete(before_phase);
    end
    after_phase.m_successors[begin_node] = 1;
    begin_node.m_predecessors.delete();
    begin_node.m_predecessors[after_phase] = 1;
  end
  if (new_node == null) begin
    tmp_node = phase;
  end
  else begin
    tmp_node = new_node;
  end
  state_chg = uvm_phase_state_change::type_id::create(tmp_node.get_name());
  state_chg.m_phase = tmp_node;
  state_chg.m_jump_to = null;
  state_chg.m_prev_state = tmp_node.m_state;
  tmp_node.m_state = UVM_PHASE_DORMANT;
   begin
     uvm_callback_iter#(uvm_phase,uvm_phase_cb) iter = new(this);
     uvm_phase_cb cb = iter.first();
     while(cb != null) begin
       cb.phase_state_change(tmp_node, state_chg);
       cb = iter.next();
     end
   end
endfunction
function uvm_phase uvm_phase::get_parent();
  return m_parent;
endfunction
function uvm_phase uvm_phase::get_imp();
  return m_imp;
endfunction
function uvm_phase uvm_phase::get_schedule(bit hier=0);
  uvm_phase sched;
  sched = this;
  if (hier) begin
    while (sched.m_parent != null && (sched.m_parent.get_phase_type() == UVM_PHASE_SCHEDULE)) begin
      sched = sched.m_parent;
    end
  end
  if (sched.m_phase_type == UVM_PHASE_SCHEDULE) begin
    return sched;
  end
  if (sched.m_phase_type == UVM_PHASE_NODE) begin
    if (m_parent != null && m_parent.m_phase_type != UVM_PHASE_DOMAIN) begin
      return m_parent;
    end
  end
  return null;
endfunction
function uvm_domain uvm_phase::get_domain();
  uvm_phase phase;
  phase = this;
  while (phase != null && phase.m_phase_type != UVM_PHASE_DOMAIN) begin
    phase = phase.m_parent;
  end
  if (phase == null) begin
    return null;
  end
  if(!$cast(get_domain,phase)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH/INTERNAL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH/INTERNAL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH/INTERNAL", "get_domain: m_phase_type is DOMAIN but $cast to uvm_domain fails", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1098, "", 1);
     end
   end
  end
endfunction
function string uvm_phase::get_domain_name();
  uvm_domain domain;
  domain = get_domain();
  if (domain == null) begin
    return "unknown";
  end
  return domain.get_name();
endfunction
function string uvm_phase::get_schedule_name(bit hier=0);
  uvm_phase sched;
  string s;
  sched = get_schedule(hier);
  if (sched == null) begin
    return "";
  end
  s = sched.get_name();
  while (sched.m_parent != null && sched.m_parent != sched &&
          (sched.m_parent.get_phase_type() == UVM_PHASE_SCHEDULE)) begin
    sched = sched.m_parent;
    s = {sched.get_name(),(s.len()>0?".":""),s};
  end
  return s;
endfunction
function string uvm_phase::get_full_name();
  string dom, sch;
  if (m_phase_type == UVM_PHASE_IMP) begin
    return get_name();
  end
  get_full_name = get_domain_name();
  sch = get_schedule_name();
  if (sch != "") begin
    get_full_name = {get_full_name, ".", sch};
  end
  if (m_phase_type != UVM_PHASE_DOMAIN && m_phase_type != UVM_PHASE_SCHEDULE) begin
    get_full_name = {get_full_name, ".", get_name()};
  end
endfunction
function uvm_phase_type uvm_phase::get_phase_type();
  return m_phase_type;
endfunction
function void uvm_phase::set_max_ready_to_end_iterations(int max);
  max_ready_to_end_iters = max;
endfunction
function int uvm_phase::get_max_ready_to_end_iterations();
  return max_ready_to_end_iters;
endfunction
function void uvm_phase::set_default_max_ready_to_end_iterations(int max);
  m_default_max_ready_to_end_iters = max;
endfunction
function int uvm_phase::get_default_max_ready_to_end_iterations();
  return m_default_max_ready_to_end_iters;
endfunction
function void uvm_phase::set_state(uvm_phase_state state);
  if (m_state == state) begin
    return;
  end
  if (state == UVM_PHASE_STARTED) begin
    m_run_count++;
  end
  m_state_chg.m_jump_to = m_jump_phase;
  m_state_chg.m_prev_state = m_state;
  m_state = state;
   begin
     uvm_callback_iter#(uvm_phase,uvm_phase_cb) iter = new(this);
     uvm_phase_cb cb = iter.first();
     while(cb != null) begin
       cb.phase_state_change(this, m_state_chg);
       cb = iter.next();
     end
   end
endfunction : set_state
function uvm_phase_state uvm_phase::get_state();
  return m_state;
endfunction
function int uvm_phase::get_run_count();
  return m_run_count;
endfunction
function void uvm_phase::m_print_successors();
  uvm_phase found;
  static string spaces = "                                                 ";
  static int level;
  if (m_phase_type == UVM_PHASE_DOMAIN) begin
    level = 0;
  end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/PHASE/SUCC") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/PHASE/SUCC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/PHASE/SUCC", $sformatf("%s%s (%s) id=%0d",spaces.substr(0,level*2),get_name(), m_phase_type.name(),get_inst_id()), UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1252, "", 1);
     end
   end
  level++;
  foreach (m_successors[succ]) begin
    succ.m_print_successors();
  end
  level--;
endfunction
function uvm_phase uvm_phase::m_find_predecessor(uvm_phase phase, bit stay_in_scope=1, uvm_phase orig_phase=null);
  uvm_phase found;
  if (phase == null) begin
    return null ;
  end
  if (phase == m_imp || phase == this) begin
    return this;
  end
  foreach (m_predecessors[pred]) begin
    uvm_phase orig;
    orig = (orig_phase==null) ? this : orig_phase;
    if (!stay_in_scope ||
    (pred.get_schedule() == orig.get_schedule()) ||
    (pred.get_domain() == orig.get_domain())) begin
      found = pred.m_find_predecessor(phase,stay_in_scope,orig);
      if (found != null) begin
        return found;
      end
    end
  end
  return null;
endfunction
function uvm_phase uvm_phase::m_find_predecessor_by_name(string name, bit stay_in_scope=1, uvm_phase orig_phase=null);
  uvm_phase found;
  if (get_name() == name) begin
    return this;
  end
  foreach (m_predecessors[pred]) begin
    uvm_phase orig;
    orig = (orig_phase==null) ? this : orig_phase;
    if (!stay_in_scope ||
    (pred.get_schedule() == orig.get_schedule()) ||
    (pred.get_domain() == orig.get_domain())) begin
      found = pred.m_find_predecessor_by_name(name,stay_in_scope,orig);
      if (found != null) begin
        return found;
      end
    end
  end
  return null;
endfunction
function uvm_phase uvm_phase::m_find_successor(uvm_phase phase, bit stay_in_scope=1, uvm_phase orig_phase=null);
  uvm_phase found;
  if (phase == null) begin
    return null ;
  end
  if (phase == m_imp || phase == this) begin
    return this;
  end
  foreach (m_successors[succ]) begin
    uvm_phase orig;
    orig = (orig_phase==null) ? this : orig_phase;
    if (!stay_in_scope ||
    (succ.get_schedule() == orig.get_schedule()) ||
    (succ.get_domain() == orig.get_domain())) begin
      found = succ.m_find_successor(phase,stay_in_scope,orig);
      if (found != null) begin
        return found;
      end
    end
  end
  return null;
endfunction
function uvm_phase uvm_phase::m_find_successor_by_name(string name, bit stay_in_scope=1, uvm_phase orig_phase=null);
  uvm_phase found;
  if (get_name() == name) begin
    return this;
  end
  foreach (m_successors[succ]) begin
    uvm_phase orig;
    orig = (orig_phase==null) ? this : orig_phase;
    if (!stay_in_scope ||
    (succ.get_schedule() == orig.get_schedule()) ||
    (succ.get_domain() == orig.get_domain())) begin
      found = succ.m_find_successor_by_name(name,stay_in_scope,orig);
      if (found != null) begin
        return found;
      end
    end
  end
  return null;
endfunction
function uvm_phase uvm_phase::find(uvm_phase phase, bit stay_in_scope=1);
  if (phase == m_imp || phase == this) begin
    return phase;
  end
  find = m_find_predecessor(phase,stay_in_scope,this);
  if (find == null) begin
    find = m_find_successor(phase,stay_in_scope,this);
  end
endfunction
function uvm_phase uvm_phase::find_by_name(string name, bit stay_in_scope=1);
  if (get_name() == name) begin
    return this;
  end
  find_by_name = m_find_predecessor_by_name(name,stay_in_scope,this);
  if (find_by_name == null) begin
    find_by_name = m_find_successor_by_name(name,stay_in_scope,this);
  end
endfunction
function bit uvm_phase::is(uvm_phase phase);
  return (m_imp == phase || this == phase);
endfunction
function bit uvm_phase::is_before(uvm_phase phase);
  return (!is(phase) && m_find_successor(phase,0,this) != null);
endfunction
function bit uvm_phase::is_after(uvm_phase phase);
  return (!is(phase) && m_find_predecessor(phase,0,this) != null);
endfunction
function void uvm_phase::get_adjacent_predecessor_nodes(ref uvm_phase pred[]);
   bit done;
   edges_t predecessors;
   int idx;
   foreach (m_predecessors[p]) begin
     predecessors[p] = 1;
   end
   do begin
     done = 1;
     foreach (predecessors[p]) begin
       if (p.get_phase_type() != UVM_PHASE_NODE) begin
         predecessors.delete(p);
         foreach (p.m_predecessors[next_p]) begin
           predecessors[next_p] = 1;
         end
         done = 0;
       end
     end
   end while (!done);
   pred = new [predecessors.size()];
   foreach (predecessors[p]) begin
     pred[idx++] = p;
   end
endfunction : get_adjacent_predecessor_nodes
function void uvm_phase::get_adjacent_successor_nodes(ref uvm_phase succ[]);
   bit done;
   edges_t successors;
   int idx;
   foreach (m_successors[s]) begin
     successors[s] = 1;
   end
   do begin
     done = 1;
     foreach (successors[s]) begin
       if (s.get_phase_type() != UVM_PHASE_NODE) begin
         successors.delete(s);
         foreach (s.m_successors[next_s]) begin
           successors[next_s] = 1;
         end
         done = 0;
       end
     end
   end while (!done);
   succ = new [successors.size()];
   foreach (successors[s]) begin
     succ[idx++] = s;
   end
endfunction : get_adjacent_successor_nodes
function void uvm_phase::get_predecessors(ref edges_t predecessors);
  foreach (m_predecessors[p]) begin
    predecessors[p] = 1;
  end
endfunction : get_predecessors
function void uvm_phase::get_successors(ref edges_t successors);
  foreach (m_successors[p]) begin
    successors[p] = 1;
  end
endfunction : get_successors
function void uvm_phase::get_sync_relationships(ref edges_t relationships);
  foreach (m_sync[i]) begin
    relationships[m_sync[i]] = 1;
  end
endfunction : get_sync_relationships
function void uvm_phase::get_predecessors_for_successors(output edges_t pred_of_succ);
    bit done;
    uvm_phase successors[];
    get_adjacent_successor_nodes(successors);
    foreach (successors[s]) begin
      foreach (successors[s].m_predecessors[pred]) begin
        pred_of_succ[pred] = 1;
      end
    end
    do begin
      done=1;
      foreach (pred_of_succ[pred]) begin
        if (pred.get_phase_type() != UVM_PHASE_NODE) begin
          pred_of_succ.delete(pred);
          foreach (pred.m_predecessors[next_pred]) begin
            pred_of_succ[next_pred] = 1;
          end
          done =0;
        end
      end
    end while (!done);
    pred_of_succ.delete(this);
endfunction
task uvm_phase::m_wait_for_pred();
    edges_t pred_of_succ;
    get_predecessors_for_successors(pred_of_succ);
    foreach (pred_of_succ[sibling]) begin
      if (m_phase_trace) begin
        string s;
        s = $sformatf("Waiting for phase '%s' (%0d) to be READY_TO_END. Current state is %s",
            sibling.get_name(),sibling.get_inst_id(),sibling.m_state.name());
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_PRED_OF_SUCC", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),s}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 1597, "", 1);
     end
   end
      end
      sibling.wait_for_state(UVM_PHASE_READY_TO_END, UVM_GTE);
      if (m_phase_trace) begin
        string s;
        s = $sformatf("Phase '%s' (%0d) is now READY_TO_END. Releasing phase",
            sibling.get_name(),sibling.get_inst_id());
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_PRED_OF_SUCC", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),s}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 1606, "", 1);
     end
   end
      end
    end
    if (m_phase_trace) begin
      if (pred_of_succ.num()) begin
        string s = "( ";
        foreach (pred_of_succ[pred]) begin
          s = {s, pred.get_full_name()," "};
        end
        s = {s, ")"};
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_PRED_OF_SUCC", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),{"*** All pred to succ ",s," in READY_TO_END state, so ending phase ***"}}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 1621, "", 1);
     end
   end
      end
      else begin
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_PRED_OF_SUCC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_PRED_OF_SUCC", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),"*** No pred to succ other than myself, so ending phase ***"}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 1625, "", 1);
     end
   end
      end
    end
  #0;
endtask
function void uvm_phase::m_report_null_objection(uvm_object obj,
                                               string description,
                                               int count,
                                               string action);
   string m_action;
   string m_addon;
   string m_obj_name = (obj == null) ? "uvm_top" : obj.get_full_name();
   if ((action == "raise") || (action == "drop")) begin
     if (count != 1) begin
       m_action = $sformatf("%s %0d objections", action, count);
     end
     else begin
       m_action = $sformatf("%s an objection", action);
     end
   end
   else if (action == "get_objection_count") begin
     m_action = "call get_objection_count";
   end
   if (this.get_phase_type() == UVM_PHASE_IMP) begin
     m_addon = " (This is a UVM_PHASE_IMP, you have to query the schedule to find the UVM_PHASE_NODE)";
   end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/PH/NULL_OBJECTION") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/PH/NULL_OBJECTION") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/PH/NULL_OBJECTION", $sformatf("'%s' attempted to %s on '%s', however '%s' is not a task-based phase node! %s", m_obj_name, m_action, get_name(), get_name(), m_addon), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1672, "", 1);
     end
   end
endfunction : m_report_null_objection
function void uvm_phase::raise_objection (uvm_object obj,
                                                   string description="",
                                                   int count=1);
  uvm_objection phase_done;
  phase_done = get_objection();
  if (phase_done != null) begin
    phase_done.raise_objection(obj,description,count);
  end
  else begin
    m_report_null_objection(obj, description, count, "raise");
  end
endfunction
function void uvm_phase::drop_objection (uvm_object obj,
                                                  string description="",
                                                  int count=1);
  uvm_objection phase_done;
  phase_done = get_objection();
  if (phase_done != null) begin
    phase_done.drop_objection(obj,description,count);
  end
  else begin
    m_report_null_objection(obj, description, count, "drop");
  end
endfunction
function int uvm_phase::get_objection_count (uvm_object obj=null);
  uvm_objection phase_done;
  phase_done = get_objection();
  if (phase_done != null) begin
    return phase_done.get_objection_count(obj);
  end
  else begin
    m_report_null_objection(obj, "" , 0, "get_objection_count");
    return 0;
  end
endfunction : get_objection_count
function int uvm_phase::get_objection_total (uvm_object obj=null);
  uvm_objection phase_done;
  phase_done = get_objection();
  if (phase_done != null) begin
    return phase_done.get_objection_total(obj);
  end
  else begin
    m_report_null_objection(obj, "" , 0, "get_objection_total");
    return 0;
  end
endfunction : get_objection_total
function void uvm_phase::sync(uvm_domain target,
                              uvm_phase phase=null,
                              uvm_phase with_phase=null);
  if (!this.is_domain()) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "sync() called from a non-domain phase schedule node", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1758, "", 1);
     end
   end
  end
  else if (target == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "sync() called with a null target domain", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1761, "", 1);
     end
   end
  end
  else if (!target.is_domain()) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "sync() called with a non-domain phase schedule node as target", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1764, "", 1);
     end
   end
  end
  else if (phase == null && with_phase != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "sync() called with null phase and non-null with phase", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1767, "", 1);
     end
   end
  end
  else if (phase == null) begin
    edges_t visited;
    uvm_phase queue[$];
    queue.push_back(this);
    visited[this] = 1;
    while (queue.size()) begin
      uvm_phase node;
      node = queue.pop_front();
      if (node.m_imp != null) begin
        sync(target, node.m_imp);
      end
      foreach (node.m_successors[succ]) begin
        if (!visited.exists(succ)) begin
          queue.push_back(succ);
          visited[succ] = 1;
        end
      end
    end
  end else begin
    uvm_phase from_node, to_node;
    int found_to[$], found_from[$];
    if(with_phase == null) begin
      with_phase = phase;
    end
    from_node = find(phase);
    to_node = target.find(with_phase);
    if(from_node == null || to_node == null) begin
      return;
    end
    found_to = from_node.m_sync.find_index(node) with (node == to_node);
    found_from = to_node.m_sync.find_index(node) with (node == from_node);
    if (found_to.size() == 0) begin
      from_node.m_sync.push_back(to_node);
    end
    if (found_from.size() == 0) begin
      to_node.m_sync.push_back(from_node);
    end
  end
endfunction
function void uvm_phase::unsync(uvm_domain target,
                                uvm_phase phase=null,
                                uvm_phase with_phase=null);
  if (!this.is_domain()) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "unsync() called from a non-domain phase schedule node", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1824, "", 1);
     end
   end
  end else if (target == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "unsync() called with a null target domain", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1826, "", 1);
     end
   end
  end else if (!target.is_domain()) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "unsync() called with a non-domain phase schedule node as target", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1828, "", 1);
     end
   end
  end else if (phase == null && with_phase != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADSYNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADSYNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADSYNC", "unsync() called with null phase and non-null with phase", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1830, "", 1);
     end
   end
  end else if (phase == null) begin
    edges_t visited;
    uvm_phase queue[$];
    queue.push_back(this);
    visited[this] = 1;
    while (queue.size()) begin
      uvm_phase node;
      node = queue.pop_front();
      if (node.m_imp != null) begin
        unsync(target,node.m_imp);
      end
      foreach (node.m_successors[succ]) begin
        if (!visited.exists(succ)) begin
          queue.push_back(succ);
          visited[succ] = 1;
        end
      end
    end
  end else begin
    uvm_phase from_node, to_node;
    int found_to[$], found_from[$];
    if(with_phase == null) begin
      with_phase = phase;
    end
    from_node = find(phase);
    to_node = target.find(with_phase);
    if(from_node == null || to_node == null) begin
      return;
    end
    found_to = from_node.m_sync.find_index(node) with (node == to_node);
    found_from = to_node.m_sync.find_index(node) with (node == from_node);
    if (found_to.size()) begin
      from_node.m_sync.delete(found_to[0]);
    end
    if (found_from.size()) begin
      to_node.m_sync.delete(found_from[0]);
    end
  end
endfunction
task uvm_phase::wait_for_state(uvm_phase_state state, uvm_wait_op op=UVM_EQ);
  case (op)
    UVM_EQ:  begin
      wait((state&m_state) != 0);
    end
    UVM_NE:  begin
      wait((state&m_state) == 0);
    end
    UVM_LT:  begin
      wait(m_state <  state);
    end
    UVM_LTE: begin
      wait(m_state <= state);
    end
    UVM_GT:  begin
      wait(m_state >  state);
    end
    UVM_GTE: begin
      wait(m_state >= state);
    end
  endcase
endtask
function void uvm_phase::set_jump_phase(uvm_phase phase) ;
  uvm_phase d;
  bit active;
  uvm_phase_state state;
  state = get_state();
  active = (state >= UVM_PHASE_STARTED) && (state <= UVM_PHASE_ENDED);
  if (!active) begin
    if (phase == null) begin
      m_jump_phase = null;
      m_jump_fwd = 0;
      m_jump_bkwd = 0;
      m_premature_end = 0;
      return;
    end
    else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "JMPPHIDL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "JMPPHIDL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("JMPPHIDL", { "Attempting to jump from phase \"", get_name(), "\" which is not currently active (current state is ", state.name(), "). The jump will not happen until the phase becomes ", "active."}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1942, "", 1);
     end
   end
    end
  end
  d = m_find_predecessor(phase,0);
  if (d == null) begin
    d = m_find_successor(phase,0);
    if (d == null) begin
      string msg;
      $sformat(msg,{"phase %s is neither a predecessor or successor of ",
                    "phase %s or is non-existant, so we cannot jump to it.  ",
                    "Phase control flow is now undefined so the simulation ",
                    "must terminate"}, phase.get_name(), get_name());
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADJUMP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADJUMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADJUMP", msg, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 1967, "", 1);
     end
   end
    end
    else begin
      m_jump_fwd = 1;
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_JUMPF") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_JUMPF") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_JUMPF", $sformatf("jumping forward to phase %s", phase.get_name()), UVM_DEBUG, "t/uvm/src/base/uvm_phase.svh", 1972, "", 1);
     end
   end
    end
  end
  else begin
    m_jump_bkwd = 1;
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_JUMPB") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_JUMPB") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_JUMPB", $sformatf("jumping backward to phase %s", phase.get_name()), UVM_DEBUG, "t/uvm/src/base/uvm_phase.svh", 1978, "", 1);
     end
   end
  end
  m_jump_phase = d;
endfunction
function bit uvm_phase::is_jumping_forward();
  return m_jump_fwd;
endfunction : is_jumping_forward
function bit uvm_phase::is_jumping_backward();
  return m_jump_bkwd;
endfunction : is_jumping_backward
function void uvm_phase::end_prematurely() ;
   m_premature_end = 1 ;
endfunction
function bit uvm_phase::is_ending_prematurely();
  return m_premature_end;
endfunction : is_ending_prematurely
function void uvm_phase::jump(uvm_phase phase);
   set_jump_phase(phase) ;
   end_prematurely() ;
endfunction
function void uvm_phase::jump_all(uvm_phase phase);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "NOTIMPL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "NOTIMPL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("NOTIMPL", "uvm_phase::jump_all is not implemented and has been replaced by uvm_domain::jump_all", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase.svh", 2026, "", 1);
     end
   end
endfunction
function uvm_phase uvm_phase::get_jump_target();
  return m_jump_phase;
endfunction
function void uvm_phase::clear(uvm_phase_state state = UVM_PHASE_DORMANT);
  uvm_objection phase_done;
  phase_done = get_objection();
  set_state(state);
  m_phase_proc = null;
  if (phase_done != null) begin
    phase_done.clear(this);
  end
endfunction
function void uvm_phase::clear_successors(uvm_phase_state state = UVM_PHASE_DORMANT,
    uvm_phase end_state=null);
  if(this == end_state) begin
    return;
  end
  clear(state);
  foreach(m_successors[succ]) begin
    succ.clear_successors(state, end_state);
  end
endfunction
task uvm_phase::wait_for_self_and_siblings_to_drop() ;
  bit need_to_check_all = 1 ;
  uvm_root top;
  uvm_coreservice_t cs;
  edges_t siblings;
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_SELF_AND_SIBLINGS") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_SELF_AND_SIBLINGS") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_SELF_AND_SIBLINGS", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),"WAITING FOR SELF AND SIBLINGS TO DROP"}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 2087, "", 1);
     end
   end
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  get_predecessors_for_successors(siblings);
  foreach (m_sync[i]) begin
    siblings[m_sync[i]] = 1;
  end
  siblings[this] = 1;
  while (need_to_check_all) begin
    uvm_objection phase_done;
    string msg;
    phase_done = get_objection();
    need_to_check_all = 0 ;
    foreach(siblings[sib]) begin
      phase_done = sib.get_objection();
      sib.wait_for_state(UVM_PHASE_EXECUTING, UVM_GTE);
      if ((phase_done != null) && (phase_done.get_objection_total(top) != 0)) begin
        if (m_phase_trace) begin
          msg = $sformatf("Waiting for phase '%s' (%0d) to be READY_TO_END. Current state is %s",
                          sib.get_name(),sib.get_inst_id(),sib.m_state.name());
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_SELF_AND_SIBLINGS") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_SELF_AND_SIBLINGS") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_SELF_AND_SIBLINGS", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),msg}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 2114, "", 1);
     end
   end
        end
        m_state = UVM_PHASE_EXECUTING ;
        phase_done.wait_for(UVM_ALL_DROPPED, top);
        if (m_phase_trace) begin
          msg = $sformatf("Phase '%s' (%0d) is now READY_TO_END. Releasing phase",
                          sib.get_name(),sib.get_inst_id());
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_SELF_AND_SIBLINGS") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/WAIT_SELF_AND_SIBLINGS") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/WAIT_SELF_AND_SIBLINGS", {$sformatf("Phase '%0s' (id=%0d) ", this.get_full_name(), this.get_inst_id()),msg}, UVM_HIGH, "t/uvm/src/base/uvm_phase.svh", 2121, "", 1);
     end
   end
        end
        need_to_check_all = 1 ;
      end
    end
  end
endtask
function void uvm_phase::kill();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_KILL") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_KILL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_KILL", {"killing phase '", get_name(),"'"}, UVM_DEBUG, "t/uvm/src/base/uvm_phase.svh", 2134, "", 1);
     end
   end
  if (m_phase_proc != null) begin
    m_phase_proc.kill();
    m_phase_proc = null;
  end
endfunction
function void uvm_phase::kill_successors();
  foreach (m_successors[succ]) begin
    succ.kill_successors();
  end
  kill();
endfunction
function void uvm_phase::m_terminate_phase();
  uvm_objection phase_done;
  phase_done = get_objection();
  if (phase_done != null) begin
    phase_done.clear(this);
  end
endfunction
function void uvm_phase::m_print_termination_state();
  uvm_root top;
  uvm_coreservice_t cs;
  uvm_objection phase_done;
  phase_done = get_objection();
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  if (phase_done != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_TERMSTATE") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_TERMSTATE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_TERMSTATE", $sformatf("phase %s outstanding objections = %0d", get_name(), phase_done.get_objection_total(top)), UVM_DEBUG, "t/uvm/src/base/uvm_phase.svh", 2187, "", 1);
     end
   end
  end
  else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_TERMSTATE") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_TERMSTATE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_TERMSTATE", $sformatf("phase %s has no outstanding objections", get_name()), UVM_DEBUG, "t/uvm/src/base/uvm_phase.svh", 2193, "", 1);
     end
   end
  end
endfunction
typedef class uvm_build_phase;
typedef class uvm_connect_phase;
typedef class uvm_end_of_elaboration_phase;
typedef class uvm_start_of_simulation_phase;
typedef class uvm_run_phase;
typedef class uvm_extract_phase;
typedef class uvm_check_phase;
typedef class uvm_report_phase;
typedef class uvm_final_phase;
typedef class uvm_pre_reset_phase;
typedef class uvm_reset_phase;
typedef class uvm_post_reset_phase;
typedef class uvm_pre_configure_phase;
typedef class uvm_configure_phase;
typedef class uvm_post_configure_phase;
typedef class uvm_pre_main_phase;
typedef class uvm_main_phase;
typedef class uvm_post_main_phase;
typedef class uvm_pre_shutdown_phase;
typedef class uvm_shutdown_phase;
typedef class uvm_post_shutdown_phase;
uvm_phase build_ph;
uvm_phase connect_ph;
uvm_phase end_of_elaboration_ph;
uvm_phase start_of_simulation_ph;
uvm_phase run_ph;
uvm_phase extract_ph;
uvm_phase check_ph;
uvm_phase report_ph;
class uvm_domain extends uvm_phase;
  static local uvm_domain m_uvm_domain;
  static local uvm_domain m_domains[string];
  static local uvm_phase m_uvm_schedule;
  static function void get_domains(output uvm_domain domains[string]);
    domains = m_domains;
  endfunction
  static function uvm_phase get_uvm_schedule();
    void'(get_uvm_domain());
    return m_uvm_schedule;
  endfunction
  static function uvm_domain get_common_domain();
    uvm_domain domain;
    if(m_domains.exists("common"))
      begin
        domain = m_domains["common"];
      end
    if (domain != null)
      begin
        return domain;
      end
    domain = new("common");
    domain.add(uvm_build_phase::get());
    domain.add(uvm_connect_phase::get());
    domain.add(uvm_end_of_elaboration_phase::get());
    domain.add(uvm_start_of_simulation_phase::get());
    domain.add(uvm_run_phase::get());
    domain.add(uvm_extract_phase::get());
    domain.add(uvm_check_phase::get());
    domain.add(uvm_report_phase::get());
    domain.add(uvm_final_phase::get());
    build_ph               = domain.find(uvm_build_phase::get());
    connect_ph             = domain.find(uvm_connect_phase::get());
    end_of_elaboration_ph  = domain.find(uvm_end_of_elaboration_phase::get());
    start_of_simulation_ph = domain.find(uvm_start_of_simulation_phase::get());
    run_ph                 = domain.find(uvm_run_phase::get());
    extract_ph             = domain.find(uvm_extract_phase::get());
    check_ph               = domain.find(uvm_check_phase::get());
    report_ph              = domain.find(uvm_report_phase::get());
    domain = get_uvm_domain();
    m_domains["common"].add(domain,
                     .with_phase(m_domains["common"].find(uvm_run_phase::get())));
    return m_domains["common"];
  endfunction
  static function void add_uvm_phases(uvm_phase schedule);
    schedule.add(uvm_pre_reset_phase::get());
    schedule.add(uvm_reset_phase::get());
    schedule.add(uvm_post_reset_phase::get());
    schedule.add(uvm_pre_configure_phase::get());
    schedule.add(uvm_configure_phase::get());
    schedule.add(uvm_post_configure_phase::get());
    schedule.add(uvm_pre_main_phase::get());
    schedule.add(uvm_main_phase::get());
    schedule.add(uvm_post_main_phase::get());
    schedule.add(uvm_pre_shutdown_phase::get());
    schedule.add(uvm_shutdown_phase::get());
    schedule.add(uvm_post_shutdown_phase::get());
  endfunction
  static function uvm_domain get_uvm_domain();
    if (m_uvm_domain == null)
      begin
        m_uvm_domain = new("uvm");
        m_uvm_schedule = new("uvm_sched", UVM_PHASE_SCHEDULE);
        add_uvm_phases(m_uvm_schedule);
        m_uvm_domain.add(m_uvm_schedule);
      end
    return m_uvm_domain;
  endfunction
  function new(string name);
    super.new(name,UVM_PHASE_DOMAIN);
    if (m_domains.exists(name))
      begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UNIQDOMNAM") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UNIQDOMNAM") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UNIQDOMNAM", $sformatf("Domain created with non-unique name '%s'", name), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_domain.svh", 201, "", 1);
     end
   end
      end
    m_domains[name] = this;
  endfunction
  function void jump(uvm_phase phase);
    uvm_phase phases[$];
    m_get_transitive_children(phases);
    phases = phases.find(item) with (item.get_state() inside {[UVM_PHASE_STARTED:UVM_PHASE_CLEANUP]});
    foreach(phases[idx])
      begin
        if(phases[idx].is_before(phase) || phases[idx].is_after(phase))
        begin
          phases[idx].jump(phase);
        end
      end
  endfunction
  static function void jump_all(uvm_phase phase);
    uvm_domain domains[string];
    uvm_domain::get_domains(domains);
    foreach(domains[idx])
      begin
        domains[idx].jump(phase);
      end
   endfunction
endclass
virtual class uvm_bottomup_phase extends uvm_phase;
  function new(string name);
    super.new(name,UVM_PHASE_IMP);
  endfunction
  virtual function void traverse(uvm_component comp,
                                 uvm_phase phase,
                                 uvm_phase_state state);
    string name;
    uvm_domain phase_domain =phase.get_domain();
    uvm_domain comp_domain = comp.get_domain();
    uvm_phase_hopper hopper;
    hopper = uvm_phase_hopper::get_global_hopper();
    if (comp.get_first_child(name)) begin
      do begin
        hopper.traverse_on(this, comp.get_child(name), phase, state);
      end
      while(comp.get_next_child(name));
    end
    if (m_phase_trace) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_TRACE") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_TRACE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_TRACE", $sformatf("bottomup-phase phase=%s state=%s comp=%s comp.domain=%s phase.domain=%s", phase.get_name(), state.name(), comp.get_full_name(),comp_domain.get_name(),phase_domain.get_name()), UVM_DEBUG, "t/uvm/src/base/uvm_bottomup_phase.svh", 82, "", 1);
     end
   end
    end
    if (phase_domain == uvm_domain::get_common_domain() ||
        phase_domain == comp_domain) begin
      case (state)
        UVM_PHASE_STARTED: begin
          comp.m_current_phase = phase;
          comp.m_apply_verbosity_settings(phase);
          comp.phase_started(phase);
        end
        UVM_PHASE_EXECUTING: begin
          uvm_phase ph = this;
          if (comp.m_phase_imps.exists(this)) begin
            ph = comp.m_phase_imps[this];
          end
          hopper.execute_on(ph, comp, phase);
        end
        UVM_PHASE_READY_TO_END: begin
          comp.phase_ready_to_end(phase);
        end
        UVM_PHASE_ENDED: begin
          comp.phase_ended(phase);
          comp.m_current_phase = null;
        end
        default: begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADEXEC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADEXEC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADEXEC", "bottomup phase traverse internal error", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_bottomup_phase.svh", 110, "", 1);
     end
   end
        end
      endcase
    end
  endfunction
  virtual function void execute(uvm_component comp,
                                          uvm_phase phase);
    process proc = process::self();
    proc.srandom(uvm_create_random_seed(phase.get_type_name(), comp.get_full_name()));
    comp.m_current_phase = phase;
    exec_func(comp,phase);
  endfunction
endclass
virtual class uvm_topdown_phase extends uvm_phase;
  function new(string name);
    super.new(name,UVM_PHASE_IMP);
  endfunction
  virtual function void traverse(uvm_component comp,
                                 uvm_phase phase,
                                 uvm_phase_state state);
    string name;
    uvm_domain phase_domain = phase.get_domain();
    uvm_domain comp_domain = comp.get_domain();
    uvm_phase_hopper hopper;
    hopper = uvm_phase_hopper::get_global_hopper();
    if (m_phase_trace) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_TRACE") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_TRACE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_TRACE", $sformatf("topdown-phase phase=%s state=%s comp=%s comp.domain=%s phase.domain=%s", phase.get_name(), state.name(), comp.get_full_name(),comp_domain.get_name(),phase_domain.get_name()), UVM_DEBUG, "t/uvm/src/base/uvm_topdown_phase.svh", 71, "", 1);
     end
   end
    end
    if (phase_domain == uvm_domain::get_common_domain() ||
        phase_domain == comp_domain) begin
      case (state)
        UVM_PHASE_STARTED: begin
          comp.m_current_phase = phase;
          comp.m_apply_verbosity_settings(phase);
          comp.phase_started(phase);
        end
        UVM_PHASE_EXECUTING: begin
          if (!(phase.get_name() == "build" && comp.m_build_done)) begin
            uvm_phase ph = this;
            comp.m_phasing_active++;
            if (comp.m_phase_imps.exists(this)) begin
              ph = comp.m_phase_imps[this];
            end
            hopper.execute_on(ph, comp, phase);
            comp.m_phasing_active--;
          end
        end
        UVM_PHASE_READY_TO_END: begin
          comp.phase_ready_to_end(phase);
        end
        UVM_PHASE_ENDED: begin
          comp.phase_ended(phase);
          comp.m_current_phase = null;
        end
        default: begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADEXEC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADEXEC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADEXEC", "topdown phase traverse internal error", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_topdown_phase.svh", 103, "", 1);
     end
   end
        end
        endcase
    end
    if(comp.get_first_child(name)) begin
      do begin
        hopper.traverse_on(this, comp.get_child(name), phase, state);
      end
      while(comp.get_next_child(name));
    end
  endfunction
  virtual function void execute(uvm_component comp,
                                          uvm_phase phase);
    process proc = process::self();
    proc.srandom(uvm_create_random_seed(phase.get_type_name(), comp.get_full_name()));
    comp.m_current_phase = phase;
    exec_func(comp,phase);
  endfunction
endclass
virtual class uvm_task_phase extends uvm_phase;
  function new(string name);
    super.new(name,UVM_PHASE_IMP);
  endfunction
  virtual function void traverse(uvm_component comp,
                                 uvm_phase phase,
                                 uvm_phase_state state);
    phase.m_num_procs_not_yet_returned = 0;
    m_traverse(comp, phase, state);
  endfunction
  function void m_traverse(uvm_component comp,
                           uvm_phase phase,
                           uvm_phase_state state);
    string name;
    uvm_domain phase_domain =phase.get_domain();
    uvm_domain comp_domain = comp.get_domain();
    uvm_sequencer_base seqr;
    uvm_phase_hopper hopper;
    hopper = uvm_phase_hopper::get_global_hopper();
    if (comp.get_first_child(name)) begin
      do begin
        hopper.traverse_on(this, comp.get_child(name), phase, state);
      end
      while(comp.get_next_child(name));
    end
    if (m_phase_trace) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_TRACE") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_TRACE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_TRACE", $sformatf("topdown-phase phase=%s state=%s comp=%s comp.domain=%s phase.domain=%s", phase.get_name(), state.name(), comp.get_full_name(),comp_domain.get_name(),phase_domain.get_name()), UVM_DEBUG, "t/uvm/src/base/uvm_task_phase.svh", 111, "", 1);
     end
   end
    end
    if (phase_domain == uvm_domain::get_common_domain() ||
        phase_domain == comp_domain) begin
      case (state)
        UVM_PHASE_STARTED: begin
          comp.m_current_phase = phase;
          comp.m_apply_verbosity_settings(phase);
          comp.phase_started(phase);
          if ($cast(seqr, comp)) begin
            seqr.start_phase_sequence(phase);
          end
        end
        UVM_PHASE_EXECUTING: begin
          uvm_phase ph = this;
          if (comp.m_phase_imps.exists(this)) begin
            ph = comp.m_phase_imps[this];
          end
          hopper.execute_on(ph, comp, phase);
        end
        UVM_PHASE_READY_TO_END: begin
          comp.phase_ready_to_end(phase);
        end
        UVM_PHASE_ENDED: begin
          if ($cast(seqr, comp)) begin
            seqr.stop_phase_sequence(phase);
          end
          comp.phase_ended(phase);
          comp.m_current_phase = null;
        end
        default: begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_BADEXEC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_BADEXEC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_BADEXEC", "task phase traverse internal error", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_task_phase.svh", 149, "", 1);
     end
   end
        end
      endcase
    end
  endfunction
  virtual function void execute(uvm_component comp,
                                          uvm_phase phase);
    fork
      begin
        process proc;
        proc = process::self();
        proc.srandom(uvm_create_random_seed(phase.get_type_name(), comp.get_full_name()));
        phase.m_num_procs_not_yet_returned++;
        exec_task(comp,phase);
        phase.m_num_procs_not_yet_returned--;
      end
    join_none
  endfunction
endclass
class uvm_build_phase extends uvm_topdown_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.build_phase(phase);
   endfunction
   local static uvm_build_phase m_inst;
     static function string type_name();
       return "uvm_build_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_build_phase";
     endfunction : get_type_name
   static function uvm_build_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="build");
      super.new(name);
   endfunction
endclass
class uvm_connect_phase extends uvm_bottomup_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.connect_phase(phase);
   endfunction
   local static uvm_connect_phase m_inst;
     static function string type_name();
       return "uvm_connect_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_connect_phase";
     endfunction : get_type_name
   static function uvm_connect_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="connect");
      super.new(name);
   endfunction
endclass
class uvm_end_of_elaboration_phase extends uvm_bottomup_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.end_of_elaboration_phase(phase);
   endfunction
   local static uvm_end_of_elaboration_phase m_inst;
     static function string type_name();
       return "uvm_end_of_elaboration_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_end_of_elaboration_phase";
     endfunction : get_type_name
   static function uvm_end_of_elaboration_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="end_of_elaboration");
      super.new(name);
   endfunction
endclass
class uvm_start_of_simulation_phase extends uvm_bottomup_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.start_of_simulation_phase(phase);
   endfunction
   local static uvm_start_of_simulation_phase m_inst;
     static function string type_name();
       return "uvm_start_of_simulation_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_start_of_simulation_phase";
     endfunction : get_type_name
   static function uvm_start_of_simulation_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="start_of_simulation");
      super.new(name);
   endfunction
endclass
class uvm_run_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.run_phase(phase);
   endtask
   local static uvm_run_phase m_inst;
     static function string type_name();
       return "uvm_run_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_run_phase";
     endfunction : get_type_name
   static function uvm_run_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="run");
      super.new(name);
   endfunction
endclass
class uvm_extract_phase extends uvm_bottomup_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.extract_phase(phase);
   endfunction
   local static uvm_extract_phase m_inst;
     static function string type_name();
       return "uvm_extract_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_extract_phase";
     endfunction : get_type_name
   static function uvm_extract_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="extract");
      super.new(name);
   endfunction
endclass
class uvm_check_phase extends uvm_bottomup_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.check_phase(phase);
   endfunction
   local static uvm_check_phase m_inst;
     static function string type_name();
       return "uvm_check_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_check_phase";
     endfunction : get_type_name
   static function uvm_check_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="check");
      super.new(name);
   endfunction
endclass
class uvm_report_phase extends uvm_bottomup_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.report_phase(phase);
   endfunction
   local static uvm_report_phase m_inst;
     static function string type_name();
       return "uvm_report_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_report_phase";
     endfunction : get_type_name
   static function uvm_report_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="report");
      super.new(name);
   endfunction
endclass
class uvm_final_phase extends uvm_topdown_phase;
   virtual function void exec_func(uvm_component comp, uvm_phase phase);
      comp.final_phase(phase);
   endfunction
   local static uvm_final_phase m_inst;
     static function string type_name();
       return "uvm_final_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_final_phase";
     endfunction : get_type_name
   static function uvm_final_phase get();
      if(m_inst == null)
        begin
          m_inst = new();
        end
      return m_inst;
   endfunction
   protected function new(string name="final");
      super.new(name);
   endfunction
endclass
class uvm_pre_reset_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.pre_reset_phase(phase);
   endtask
   local static uvm_pre_reset_phase m_inst;
     static function string type_name();
       return "uvm_pre_reset_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_pre_reset_phase";
     endfunction : get_type_name
   static function uvm_pre_reset_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="pre_reset");
      super.new(name);
   endfunction
endclass
class uvm_reset_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.reset_phase(phase);
   endtask
   local static uvm_reset_phase m_inst;
     static function string type_name();
       return "uvm_reset_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_reset_phase";
     endfunction : get_type_name
   static function uvm_reset_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="reset");
      super.new(name);
   endfunction
endclass
class uvm_post_reset_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.post_reset_phase(phase);
   endtask
   local static uvm_post_reset_phase m_inst;
     static function string type_name();
       return "uvm_post_reset_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_post_reset_phase";
     endfunction : get_type_name
   static function uvm_post_reset_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="post_reset");
      super.new(name);
   endfunction
endclass
class uvm_pre_configure_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.pre_configure_phase(phase);
   endtask
   local static uvm_pre_configure_phase m_inst;
     static function string type_name();
       return "uvm_pre_configure_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_pre_configure_phase";
     endfunction : get_type_name
   static function uvm_pre_configure_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="pre_configure");
      super.new(name);
   endfunction
endclass
class uvm_configure_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.configure_phase(phase);
   endtask
   local static uvm_configure_phase m_inst;
     static function string type_name();
       return "uvm_configure_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_configure_phase";
     endfunction : get_type_name
   static function uvm_configure_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="configure");
      super.new(name);
   endfunction
endclass
class uvm_post_configure_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.post_configure_phase(phase);
   endtask
   local static uvm_post_configure_phase m_inst;
     static function string type_name();
       return "uvm_post_configure_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_post_configure_phase";
     endfunction : get_type_name
   static function uvm_post_configure_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="post_configure");
      super.new(name);
   endfunction
endclass
class uvm_pre_main_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.pre_main_phase(phase);
   endtask
   local static uvm_pre_main_phase m_inst;
     static function string type_name();
       return "uvm_pre_main_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_pre_main_phase";
     endfunction : get_type_name
   static function uvm_pre_main_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="pre_main");
      super.new(name);
   endfunction
endclass
class uvm_main_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.main_phase(phase);
   endtask
   local static uvm_main_phase m_inst;
     static function string type_name();
       return "uvm_main_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_main_phase";
     endfunction : get_type_name
   static function uvm_main_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="main");
      super.new(name);
   endfunction
endclass
class uvm_post_main_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.post_main_phase(phase);
   endtask
   local static uvm_post_main_phase m_inst;
     static function string type_name();
       return "uvm_post_main_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_post_main_phase";
     endfunction : get_type_name
   static function uvm_post_main_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="post_main");
      super.new(name);
   endfunction
endclass
class uvm_pre_shutdown_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.pre_shutdown_phase(phase);
   endtask
   local static uvm_pre_shutdown_phase m_inst;
     static function string type_name();
       return "uvm_pre_shutdown_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_pre_shutdown_phase";
     endfunction : get_type_name
   static function uvm_pre_shutdown_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="pre_shutdown");
      super.new(name);
   endfunction
endclass
class uvm_shutdown_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.shutdown_phase(phase);
   endtask
   local static uvm_shutdown_phase m_inst;
     static function string type_name();
       return "uvm_shutdown_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_shutdown_phase";
     endfunction : get_type_name
   static function uvm_shutdown_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="shutdown");
      super.new(name);
   endfunction
endclass
class uvm_post_shutdown_phase extends uvm_task_phase;
   virtual task exec_task(uvm_component comp, uvm_phase phase);
      comp.post_shutdown_phase(phase);
   endtask
   local static uvm_post_shutdown_phase m_inst;
     static function string type_name();
       return "uvm_post_shutdown_phase";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_post_shutdown_phase";
     endfunction : get_type_name
   static function uvm_post_shutdown_phase get();
      if(m_inst == null)
        begin
          m_inst = new;
        end
      return m_inst;
   endfunction
   protected function new(string name="post_shutdown");
      super.new(name);
   endfunction
endclass
class uvm_phase_hopper extends uvm_object;
   typedef uvm_object_registry#(uvm_phase_hopper,"uvm_phase_hopper") type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_phase_hopper tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_phase_hopper";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_phase_hopper";
     endfunction : get_type_name
  extern function new(string name="uvm_phase_hopper");
  extern static function uvm_phase_hopper get_global_hopper();
  extern virtual function bit try_put(uvm_phase phase);
  extern protected virtual task get(output uvm_phase phase);
  extern protected virtual function bit try_get(inout uvm_phase phase);
  extern protected virtual task peek(output uvm_phase phase);
  extern protected virtual function bit try_peek(inout uvm_phase phase);
  extern protected virtual function uvm_objection get_objection();
  extern protected virtual function void raise_objection(uvm_object obj,
                                                         string description = "",
                                                         int count=1);
  extern protected virtual function void drop_objection(uvm_object obj,
                                                        string description = "",
                                                        int count=1);
  extern virtual function int get_objection_count( uvm_object obj = null );
  extern virtual function int get_objection_total( uvm_object obj = null );
  extern virtual task wait_for_objection( uvm_objection_event objt_event,
                                          uvm_object obj = null );
  extern virtual task run_phases();
  extern protected virtual task schedule_phase(uvm_phase phase, uvm_phase from_phase = null);
  extern protected virtual task process_phase(uvm_phase phase);
  extern protected virtual task sync_phase(uvm_phase phase);
  extern protected virtual task start_phase(uvm_phase phase);
  extern protected virtual task execute_phase(uvm_phase phase);
  extern protected virtual task end_phase(uvm_phase phase);
  extern protected virtual task cleanup_phase(uvm_phase phase);
  extern protected virtual task finish_phase(uvm_phase phase);
  extern protected virtual task wait_for_waiters(uvm_phase phase, uvm_phase_state prev_state);
  extern virtual function void traverse_on(uvm_phase imp,
                                           uvm_component comp,
                                           uvm_phase node,
                                           uvm_phase_state state);
  extern virtual function void execute_on(uvm_phase imp,
                                          uvm_component comp,
                                          uvm_phase node);
  local uvm_phase m_queue[$];
  local uvm_objection m_objection;
endclass
function uvm_phase_hopper::new(string name = "uvm_phase_hopper");
  super.new(name);
  m_objection = new("phase_hopper_objection");
endfunction : new
function uvm_phase_hopper uvm_phase_hopper::get_global_hopper();
  uvm_coreservice_t cs;
  cs = uvm_coreservice_t::get();
  return cs.get_phase_hopper();
endfunction : get_global_hopper
function bit uvm_phase_hopper::try_put(uvm_phase phase);
  raise_objection(phase, "phase scheduled");
  m_queue.push_back(phase);
  return 1;
endfunction : try_put
task uvm_phase_hopper::get(output uvm_phase phase);
  wait (m_queue.size() != 0);
  phase = m_queue.pop_front();
endtask : get
function bit uvm_phase_hopper::try_get(inout uvm_phase phase);
  if (m_queue.size() > 0) begin
    phase = m_queue.pop_front();
    return 1;
  end
  else begin
    return 0;
  end
endfunction : try_get
task uvm_phase_hopper::peek(output uvm_phase phase);
  wait (m_queue.size() != 0);
  phase = m_queue[0];
endtask : peek
function bit uvm_phase_hopper::try_peek(inout uvm_phase phase);
  if (m_queue.size() > 0) begin
    phase = m_queue[0];
    return 1;
  end
  else begin
    return 0;
  end
endfunction : try_peek
function uvm_objection uvm_phase_hopper::get_objection();
  if (m_objection == null) begin
    m_objection = new("phase_hopper_objection");
  end
  return m_objection;
endfunction : get_objection
function void uvm_phase_hopper::raise_objection(uvm_object obj,
                                                string description = "",
                                                int count=1);
  uvm_objection objection;
  objection = get_objection();
  objection.raise_objection(obj, description, count);
endfunction : raise_objection
function void uvm_phase_hopper::drop_objection(uvm_object obj,
                                               string description = "",
                                               int count=1);
  uvm_objection objection;
  objection = get_objection();
  objection.drop_objection(obj, description, count);
endfunction : drop_objection
function int uvm_phase_hopper::get_objection_count(uvm_object obj = null);
  uvm_objection objection;
  objection = get_objection();
  return objection.get_objection_count(obj);
endfunction : get_objection_count
function int uvm_phase_hopper::get_objection_total(uvm_object obj = null);
  uvm_objection objection;
  objection = get_objection();
  return objection.get_objection_total(obj);
endfunction : get_objection_total
task uvm_phase_hopper::wait_for_objection( uvm_objection_event objt_event,
                                           uvm_object obj = null );
  uvm_objection objection;
  objection = get_objection();
  objection.wait_for(objt_event, obj);
endtask : wait_for_objection
task uvm_phase_hopper::run_phases();
  uvm_phase ph;
  ph = uvm_domain::get_common_domain();
  schedule_phase(ph);
  fork
    begin
      forever begin
        this.get(ph);
        fork
          automatic uvm_phase phase = ph;
          begin
            this.process_phase(phase);
            drop_objection(phase, "phase done");
          end
        join_none
      end
    end
  join_none
  wait_for_objection(UVM_ALL_DROPPED);
endtask : run_phases
task uvm_phase_hopper::schedule_phase(uvm_phase phase, uvm_phase from_phase = null);
  uvm_phase_state prev_state;
  prev_state = phase.get_state();
  if(prev_state < UVM_PHASE_SCHEDULED) begin
    phase.set_state(UVM_PHASE_SCHEDULED);
    wait_for_waiters(phase, prev_state);
    void'(this.try_put(phase));
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/SCHEDULED") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/SCHEDULED") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/SCHEDULED", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),{"Scheduled from ", (from_phase != null) ? {"phase ",from_phase.get_full_name()}:"run_test"}}, UVM_LOW, "t/uvm/src/base/uvm_phase_hopper.svh", 405, "", 1);
     end
   end
  end
endtask : schedule_phase
task uvm_phase_hopper::sync_phase(uvm_phase phase);
  uvm_phase::edges_t edges;
  uvm_phase_state prev_state;
  phase.get_predecessors(edges);
  foreach(edges[p]) begin
    p.wait_for_state(UVM_PHASE_DONE);
  end
  prev_state = phase.get_state();
  phase.set_state(UVM_PHASE_SYNCING);
  wait_for_waiters(phase, prev_state);
  phase.get_sync_relationships(edges);
  foreach (edges[s]) begin
    s.wait_for_state(UVM_PHASE_SYNCING, UVM_GTE);
  end
endtask : sync_phase
task uvm_phase_hopper::start_phase(uvm_phase phase);
  uvm_phase_state prev_state;
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/STRT") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/STRT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/STRT", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"Starting phase"}, UVM_LOW, "t/uvm/src/base/uvm_phase_hopper.svh", 436, "", 1);
     end
   end
  prev_state = phase.get_state();
  phase.set_state(UVM_PHASE_STARTED);
  if (phase.get_phase_type() == UVM_PHASE_NODE) begin
    uvm_phase imp;
    imp = phase.get_imp();
    traverse_on(imp, null, phase, UVM_PHASE_STARTED);
  end
  wait_for_waiters(phase, prev_state);
endtask : start_phase
task uvm_phase_hopper::execute_phase(uvm_phase phase);
  uvm_phase_state prev_state;
  prev_state = phase.get_state();
  phase.set_state(UVM_PHASE_EXECUTING);
  if (phase.get_phase_type() != UVM_PHASE_NODE) begin
    wait_for_waiters(phase, prev_state);
    return;
  end
  else begin
    uvm_root top;
    uvm_phase imp;
    uvm_task_phase task_phase;
    top = uvm_root::get();
    imp = phase.get_imp();
    if (!$cast(task_phase, imp)) begin
      wait_for_waiters(phase, prev_state);
      traverse_on(imp, null, phase, UVM_PHASE_EXECUTING);
    end
    else begin
      fork : master_phase_process
        begin
          phase.m_phase_proc = process::self();
          traverse_on(task_phase, null, phase, UVM_PHASE_EXECUTING);
          wait(0);
        end
      join_none
      uvm_wait_for_nba_region();
      fork
        begin
          fork
            begin
              wait (phase.m_premature_end);
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/EXE/JUMP") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/EXE/JUMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/EXE/JUMP", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"PHASE EXIT ON JUMP REQUEST"}, UVM_DEBUG, "t/uvm/src/base/uvm_phase_hopper.svh", 499, "", 1);
     end
   end
            end
            begin
              int unsigned ready_to_end_count;
              bit do_ready_to_end;
              uvm_objection phase_done;
              phase_done = phase.get_objection();
              if (phase_done.get_objection_total(top) ||
              phase.m_use_ovm_run_semantic && imp.get_name() == "run") begin
                if (!phase_done.m_top_all_dropped) begin
                  phase_done.wait_for(UVM_ALL_DROPPED, top);
                end
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/EXE/ALLDROP") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/EXE/ALLDROP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/EXE/ALLDROP", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"PHASE EXIT ALL_DROPPED"}, UVM_DEBUG, "t/uvm/src/base/uvm_phase_hopper.svh", 515, "", 1);
     end
   end
              end
              else begin
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/SKIP") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/SKIP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/SKIP", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"No objections raised, skipping phase"}, UVM_LOW, "t/uvm/src/base/uvm_phase_hopper.svh", 518, "", 1);
     end
   end
              end
              phase.wait_for_self_and_siblings_to_drop() ;
              do_ready_to_end = 1;
              while (do_ready_to_end) begin
                uvm_wait_for_nba_region();
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_READY_TO_END") >= UVM_DEBUG) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_READY_TO_END") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_READY_TO_END", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"PHASE READY TO END"}, UVM_DEBUG, "t/uvm/src/base/uvm_phase_hopper.svh", 530, "", 1);
     end
   end
                ready_to_end_count++;
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_READY_TO_END_CB") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_READY_TO_END_CB") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_READY_TO_END_CB", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"CALLING READY_TO_END CB"}, UVM_HIGH, "t/uvm/src/base/uvm_phase_hopper.svh", 532, "", 1);
     end
   end
                phase.set_state(UVM_PHASE_READY_TO_END);
                if (imp != null) begin
                  traverse_on(imp, null, phase, UVM_PHASE_READY_TO_END);
                end
                uvm_wait_for_nba_region();
                phase.wait_for_self_and_siblings_to_drop();
                do_ready_to_end = (phase.get_state() == UVM_PHASE_EXECUTING) &&
                (ready_to_end_count < phase.get_max_ready_to_end_iterations()) ;
              end
            end
            begin
              if (phase.get_name() == "run") begin
                string delay_type;
                time   delay_time;
                uvm_object objectors[$];
                if (top.phase_timeout == 0) begin
                  wait(top.phase_timeout != 0);
                end
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/TO_WAIT") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/TO_WAIT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/TO_WAIT", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),$sformatf("STARTING PHASE TIMEOUT WATCHDOG (timeout == %t)", top.phase_timeout)}, UVM_HIGH, "t/uvm/src/base/uvm_phase_hopper.svh", 560, "", 1);
     end
   end
                #(top.phase_timeout);
                if ($time == 9200s) begin
                  delay_type = "Default";
                  delay_time = 9200s;
                end
                else begin
                  delay_type = "Explicit";
                  delay_time = top.phase_timeout;
                end
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/TIMEOUT") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/TIMEOUT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/TIMEOUT", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"PHASE TIMEOUT WATCHDOG EXPIRED"}, UVM_LOW, "t/uvm/src/base/uvm_phase_hopper.svh", 571, "", 1);
     end
   end
                m_objection.get_objectors(objectors);
                foreach (objectors[i]) begin
                  uvm_phase p;
                  if ($cast(p, objectors[i])) begin
                    uvm_objection p_done;
                    p_done = p.get_objection();
                    if ((p_done != null) && (p_done.get_objection_total() > 0)) begin
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/TIMEOUT/OBJCTN") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/TIMEOUT/OBJCTN") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/TIMEOUT/OBJCTN", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),$sformatf("Phase '%s' has outstanding objections:\n%s", p.get_full_name(), p_done.convert2string())}, UVM_LOW, "t/uvm/src/base/uvm_phase_hopper.svh", 582, "", 1);
     end
   end
                    end
                  end
                end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "PH_TIMEOUT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "PH_TIMEOUT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("PH_TIMEOUT", $sformatf("%s timeout of %0t hit, indicating a probable testbench issue", delay_type, delay_time), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_phase_hopper.svh", 590, "", 1);
     end
   end
              end
              else begin
                wait (0);
              end
            end
          join_any
          disable fork;
        end
      join
    end
  end
endtask : execute_phase
task uvm_phase_hopper::end_phase(uvm_phase phase);
  if (phase.get_phase_type() == UVM_PHASE_NODE) begin
    uvm_phase_state prev_state;
    uvm_phase imp;
    prev_state = phase.get_state();
    imp = phase.get_imp();
    if(phase.m_premature_end) begin
      uvm_phase jump_phase;
      jump_phase = phase.get_jump_target();
      if(jump_phase != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_JUMP") >= UVM_MEDIUM) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_JUMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_JUMP", $sformatf("phase %s (schedule %s, domain %s) is jumping to phase %s", phase.get_name(), phase.get_schedule_name(), phase.get_domain_name(), jump_phase.get_name()), UVM_MEDIUM, "t/uvm/src/base/uvm_phase_hopper.svh", 628, "", 1);
     end
   end
      end
      else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_JUMP") >= UVM_MEDIUM) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_JUMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_JUMP", $sformatf("phase %s (schedule %s, domain %s) is ending prematurely", phase.get_name(), phase.get_schedule_name(), phase.get_domain_name()), UVM_MEDIUM, "t/uvm/src/base/uvm_phase_hopper.svh", 636, "", 1);
     end
   end
      end
      wait_for_waiters(phase, prev_state);
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_END") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_END") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_END", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"ENDING PHASE PREMATURELY"}, UVM_HIGH, "t/uvm/src/base/uvm_phase_hopper.svh", 640, "", 1);
     end
   end
    end
    else begin
      uvm_task_phase task_phase;
      if (!$cast(task_phase, phase.get_imp())) begin
        phase.m_wait_for_pred();
      end
    end
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH_END") >= UVM_HIGH) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH_END") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH_END", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"ENDING PHASE"}, UVM_HIGH, "t/uvm/src/base/uvm_phase_hopper.svh", 658, "", 1);
     end
   end
    phase.set_state(UVM_PHASE_ENDED);
    if (imp != null) begin
      traverse_on(imp, null, phase, UVM_PHASE_ENDED);
    end
    wait_for_waiters(phase, prev_state);
  end
endtask : end_phase
task uvm_phase_hopper::cleanup_phase(uvm_phase phase);
  if (phase.get_phase_type() == UVM_PHASE_NODE) begin
    uvm_objection phase_done;
    uvm_phase_state prev_state;
    prev_state = phase.get_state();
    if(phase.m_premature_end) begin
      phase.set_state(UVM_PHASE_JUMPING);
    end
    else begin
      phase.set_state(UVM_PHASE_CLEANUP);
    end
    if (phase.m_phase_proc != null) begin
      phase.m_phase_proc.kill();
      phase.m_phase_proc = null;
    end
    wait_for_waiters(phase, prev_state);
    phase_done = phase.get_objection();
    if (phase_done != null) begin
      phase_done.clear();
    end
  end
endtask : cleanup_phase
task uvm_phase_hopper::finish_phase(uvm_phase phase);
  uvm_objection phase_done;
  uvm_phase jump_phase;
  uvm_phase_state prev_state;
  phase_done = phase.get_objection();
  jump_phase = phase.get_jump_target();
  prev_state = phase.get_state();
  if(jump_phase != null) begin
    if(phase.is_jumping_forward()) begin
      phase.clear_successors(UVM_PHASE_DONE,jump_phase);
    end
    jump_phase.clear_successors();
    phase.set_jump_phase(null);
  end
  else begin
  if (uvm_phase::m_phase_trace)
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "PH/TRC/DONE") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "PH/TRC/DONE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("PH/TRC/DONE", {$sformatf("Phase '%0s' (id=%0d) ", phase.get_full_name(), phase.get_inst_id()),"Completed phase"}, UVM_LOW, "t/uvm/src/base/uvm_phase_hopper.svh", 730, "", 1);
     end
   end
    phase.set_state(UVM_PHASE_DONE);
    phase.m_phase_proc = null;
  end
  wait_for_waiters(phase, prev_state);
  begin
    if (phase_done != null) begin
      phase_done.clear();
    end
  end
  if(jump_phase != null) begin
    schedule_phase(jump_phase, phase);
  end
  else begin
    uvm_phase::edges_t edges;
    uvm_phase succ_q[$];
    phase.get_successors(edges);
    if (edges.size() != 0) begin
      uvm_phase succ;
      foreach (edges[succ]) begin
        succ_q.push_back(succ);
      end
      succ_q.sort with ( item.get_full_name() );
      foreach (succ_q[i]) begin
        schedule_phase(succ_q[i], phase);
      end
    end
  end
endtask : finish_phase
task uvm_phase_hopper::process_phase(uvm_phase phase);
    sync_phase(phase);
    start_phase(phase);
    execute_phase(phase);
    end_phase(phase);
    cleanup_phase(phase);
    finish_phase(phase);
endtask : process_phase
task uvm_phase_hopper::wait_for_waiters(uvm_phase phase, uvm_phase_state prev_state);
  #0;
endtask : wait_for_waiters
function void uvm_phase_hopper::traverse_on(uvm_phase imp,
                                            uvm_component comp,
                                            uvm_phase node,
                                            uvm_phase_state state);
  if (comp == null) begin
    comp = uvm_root::get();
  end
  imp.traverse(comp, node, state);
endfunction : traverse_on
function void uvm_phase_hopper::execute_on(uvm_phase imp,
                                           uvm_component comp,
                                           uvm_phase node);
  imp.execute(comp, node);
endfunction : execute_on
virtual class uvm_run_test_callback extends uvm_callback;
  extern function new( string name="uvm_run_test_callback");
  virtual function void pre_run_test();
  endfunction
  virtual function void post_run_test();
  endfunction
  virtual function void pre_abort();
  endfunction
  extern static function bit add( uvm_run_test_callback cb );
  extern static function bit delete( uvm_run_test_callback cb );
  extern static function void m_do_pre_run_test();
  extern static function void m_do_post_run_test();
  extern static function void m_do_pre_abort();
  local static uvm_run_test_callback   m_registered_cbs[$];
endclass : uvm_run_test_callback
function uvm_run_test_callback::new( string name="uvm_run_test_callback");
  super.new( name );
endfunction
function bit uvm_run_test_callback::add( uvm_run_test_callback cb );
  bit found;
  int unsigned i;
  if ( cb == null ) begin
    return 0;
  end
  found = 0;
  i = 0;
  while ( ! found && ( i < m_registered_cbs.size() ) ) begin
    if ( m_registered_cbs[ i ] == cb ) begin
      found = 1;
    end
    ++i;
  end
  if ( ! found ) begin
    m_registered_cbs.push_back( cb );
  end
  return ! found;
endfunction
function bit uvm_run_test_callback::delete( uvm_run_test_callback cb );
  int cb_idxs[$];
  if ( cb == null ) begin
    return 0;
  end
  cb_idxs = m_registered_cbs.find_index( item ) with ( item == cb );
  foreach ( cb_idxs[ i ] ) begin
    m_registered_cbs.delete( i );
  end
  return ( cb_idxs.size() > 0 );
endfunction
function void uvm_run_test_callback::m_do_pre_run_test();
  foreach ( m_registered_cbs[ i ] ) begin
    m_registered_cbs[ i ].pre_run_test();
  end
endfunction
function void uvm_run_test_callback::m_do_post_run_test();
  foreach ( m_registered_cbs[ i ] ) begin
    m_registered_cbs[ i ].post_run_test();
  end
endfunction
function void uvm_run_test_callback::m_do_pre_abort();
  foreach ( m_registered_cbs[ i ] ) begin
    m_registered_cbs[ i ].pre_abort();
  end
endfunction
typedef class uvm_objection;
typedef class uvm_sequence_base;
typedef class uvm_sequence_item;
typedef class uvm_cmdline_set_verbosity;
typedef class uvm_cmdline_set_action;
typedef class uvm_cmdline_set_severity;
virtual class uvm_component extends uvm_report_object;
  extern function new (string name, uvm_component parent);
  extern virtual function uvm_component get_parent ();
  extern virtual function string get_full_name ();
  extern function void get_children(ref uvm_component children[$]);
  extern function uvm_component get_child (string name);
  extern function int get_next_child (ref string name);
  extern function int get_first_child (ref string name);
  extern function int get_num_children ();
  extern function int has_child (string name);
  extern virtual function void set_name (string name);
  extern function uvm_component lookup (string name);
  extern function int unsigned get_depth();
  extern virtual function void build_phase(uvm_phase phase);
  extern virtual function void connect_phase(uvm_phase phase);
  extern virtual function void end_of_elaboration_phase(uvm_phase phase);
  extern virtual function void start_of_simulation_phase(uvm_phase phase);
  extern virtual task run_phase(uvm_phase phase);
  extern virtual task pre_reset_phase(uvm_phase phase);
  extern virtual task reset_phase(uvm_phase phase);
  extern virtual task post_reset_phase(uvm_phase phase);
  extern virtual task pre_configure_phase(uvm_phase phase);
  extern virtual task configure_phase(uvm_phase phase);
  extern virtual task post_configure_phase(uvm_phase phase);
  extern virtual task pre_main_phase(uvm_phase phase);
  extern virtual task main_phase(uvm_phase phase);
  extern virtual task post_main_phase(uvm_phase phase);
  extern virtual task pre_shutdown_phase(uvm_phase phase);
  extern virtual task shutdown_phase(uvm_phase phase);
  extern virtual task post_shutdown_phase(uvm_phase phase);
  extern virtual function void extract_phase(uvm_phase phase);
  extern virtual function void check_phase(uvm_phase phase);
  extern virtual function void report_phase(uvm_phase phase);
  extern virtual function void final_phase(uvm_phase phase);
  extern virtual function void phase_started (uvm_phase phase);
  extern virtual function void phase_ready_to_end (uvm_phase phase);
  extern virtual function void phase_ended (uvm_phase phase);
  extern function void set_domain(uvm_domain domain, int hier=1);
  extern function uvm_domain get_domain();
  extern virtual protected function void define_domain(uvm_domain domain);
  extern function void set_phase_imp(uvm_phase phase, uvm_phase imp, int hier=1);
  extern virtual function void build();
  extern virtual function void connect();
  extern virtual function void end_of_elaboration();
  extern virtual function void start_of_simulation();
  extern virtual task run();
  extern virtual function void extract();
  extern virtual function void check();
  extern virtual function void report();
  extern virtual task suspend ();
  extern virtual task resume ();
  extern virtual function void resolve_bindings ();
  extern function string massage_scope(string scope);
  extern function void check_config_usage (bit recurse=1);
  extern virtual function void set_config_int (string inst_name,
                                               string field_name,
                                               uvm_bitstream_t value);
  extern virtual function void set_config_string (string inst_name,
                                                  string field_name,
                                                  string value);
  extern virtual function void set_config_object (string inst_name,
                                                  string field_name,
                                                  uvm_object value,
                                                  bit clone=1);
  extern virtual function bit get_config_int (string field_name,
                                              inout uvm_bitstream_t value);
  extern virtual function bit get_config_string (string field_name,
                                                 inout string value);
  extern virtual function bit get_config_object (string field_name,
                                                 inout uvm_object value,
                                                 input bit clone=1);
  extern virtual function void apply_config_settings (bit verbose = 0);
  extern virtual function bit use_automatic_config();
  extern function void print_config(bit recurse = 0, bit audit = 0);
  extern function void print_config_settings(string field="",
                                             uvm_component comp=null,
                                             bit recurse=0);
  extern function void print_config_with_audit(bit recurse = 0);
  static bit print_config_matches;
  static function bit get_print_config_matches() ;
     return print_config_matches;
  endfunction
   static function void set_print_config_matches(bit val) ;
     print_config_matches = val;
  endfunction
  virtual function void raised (uvm_objection objection, uvm_object source_obj,
      string description, int count);
  endfunction
  virtual function void dropped (uvm_objection objection, uvm_object source_obj,
      string description, int count);
  endfunction
  virtual task all_dropped (uvm_objection objection, uvm_object source_obj,
      string description, int count);
  endtask
  extern function uvm_component create_component (string requested_type_name,
                                                  string name);
  extern function uvm_object create_object (string requested_type_name,
                                            string name="");
  extern static function void set_type_override_by_type
                                             (uvm_object_wrapper original_type,
                                              uvm_object_wrapper override_type,
                                              bit replace=1);
  extern function void set_inst_override_by_type(string relative_inst_path,
                                                 uvm_object_wrapper original_type,
                                                 uvm_object_wrapper override_type);
  extern static function void set_type_override(string original_type_name,
                                                string override_type_name,
                                                bit    replace=1);
  extern function void set_inst_override(string relative_inst_path,
                                         string original_type_name,
                                         string override_type_name);
  extern function void print_override_info(string requested_type_name,
                                           string name="");
  extern function void set_report_id_verbosity_hier (string id,
                                                  int verbosity);
  extern function void set_report_severity_id_verbosity_hier(uvm_severity severity,
                                                          string id,
                                                          int verbosity);
  extern function void set_report_severity_action_hier (uvm_severity severity,
                                                        uvm_action action);
  extern function void set_report_id_action_hier (string id,
                                                  uvm_action action);
  extern function void set_report_severity_id_action_hier(uvm_severity severity,
                                                          string id,
                                                          uvm_action action);
  extern function void set_report_default_file_hier (UVM_FILE file);
  extern function void set_report_severity_file_hier (uvm_severity severity,
                                                      UVM_FILE file);
  extern function void set_report_id_file_hier (string id,
                                                UVM_FILE file);
  extern function void set_report_severity_id_file_hier(uvm_severity severity,
                                                        string id,
                                                        UVM_FILE file);
    extern function void set_report_verbosity_level_hier (int verbosity);
  virtual function void pre_abort;
  endfunction
  extern function void accept_tr (uvm_transaction tr, time accept_time = 0);
  extern virtual protected function void do_accept_tr (uvm_transaction tr);
   extern function int begin_tr (uvm_transaction tr,
                                     string stream_name="main",
                                     string label="",
                                     string desc="",
                                     time begin_time=0,
                                     int parent_handle=0);
  extern virtual protected
    function void do_begin_tr (uvm_transaction tr,
                               string stream_name,
                               int tr_handle);
  extern function void end_tr (uvm_transaction tr,
                               time end_time=0,
                               bit free_handle=1);
  extern virtual protected function void do_end_tr (uvm_transaction tr,
                                                    int tr_handle);
  extern function int record_error_tr (string stream_name="main",
                                           uvm_object info=null,
                                           string label="error_tr",
                                           string desc="",
                                           time   error_time=0,
                                           bit    keep_active=0);
  extern function int record_event_tr (string stream_name="main",
                                           uvm_object info=null,
                                           string label="event_tr",
                                           string desc="",
                                           time   event_time=0,
                                           bit    keep_active=0);
  extern virtual function uvm_tr_stream get_tr_stream(string name,
                                                      string stream_type_name="");
  extern virtual function void free_tr_stream(uvm_tr_stream stream);
  bit print_enabled = 1;
  extern virtual function void do_execute_op( uvm_field_op op );
  typedef bit [1:0] config_mode_t;
  typedef enum config_mode_t {CONFIG_STRICT=2'b00,
                              CONFIG_HIGHEST_PRECEDENCE=2'b01,
                              CONFIG_CHECK_NAMES=2'b10} config_mode_e;
  localparam config_mode_t CONFIG_DEFAULT = CONFIG_CHECK_NAMES;
  extern virtual function config_mode_t apply_config_settings_mode();
  uvm_tr_database tr_database;
  extern virtual function uvm_tr_database get_tr_database();
  extern virtual function void set_tr_database(uvm_tr_database db);
  protected uvm_domain m_domain;
    uvm_phase  m_phase_imps[uvm_phase];
  uvm_phase            m_current_phase;
  protected process    m_phase_process;
    bit  m_build_done;
    int  m_phasing_active;
  extern                   function void set_local(uvm_resource_base rsrc) ;
    uvm_component m_parent;
  protected     uvm_component m_children[string];
  protected     uvm_component m_children_by_handle[uvm_component];
  extern protected virtual function bit  m_add_child(uvm_component child);
  extern local     virtual function void m_set_full_name();
  extern                   function void do_resolve_bindings();
  extern                   function void do_flush();
  extern virtual           function void flush ();
  extern local             function void m_extract_name(string name ,
                                                        output string leaf ,
                                                        output string remainder );
  extern virtual function uvm_object create (string name="");
  extern virtual function uvm_object clone  ();
  local uvm_tr_stream m_streams[string][string];
  local uvm_recorder m_tr_h[uvm_transaction];
  extern protected function int m_begin_tr (uvm_transaction tr,
                                                int parent_handle=0,
                                                string stream_name="main", string label="",
                                                string desc="", time begin_time=0);
  string m_name;
  typedef uvm_abstract_component_registry#(uvm_component, "uvm_component") type_id;
     static function string type_name();
       return "uvm_component";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_component";
     endfunction : get_type_name
  protected uvm_event_pool event_pool;
  int unsigned recording_detail = UVM_NONE;
  extern virtual function bit get_recording_enabled();
  extern virtual function void set_recording_enabled(bit enabled);
  extern virtual function void set_recording_enabled_hier (bit enabled);
  extern         function void   do_print(uvm_printer printer);
  extern function void m_set_cl_msg_args;
  extern function void m_set_cl_verb;
  extern function void m_set_cl_action;
  extern function void m_set_cl_sev;
  extern function void m_apply_verbosity_settings(uvm_phase phase);
  uvm_cmdline_set_verbosity m_verbosity_settings[$];
  extern   function void m_do_pre_abort;
  uvm_resource_base m_unsupported_resource_base = null;
  extern function void m_unsupported_set_local(uvm_resource_base rsrc);
  extern function int begin_child_tr (uvm_transaction tr,
                                          int parent_handle=0,
                                          string stream_name="main",
                                          string label="",
                                          string desc="",
                                          time begin_time=0);
endclass : uvm_component
typedef class uvm_cmdline_processor;
typedef class uvm_component_proxy;
typedef class uvm_top_down_visitor_adapter;
typedef class uvm_process_guard_base;
typedef class uvm_report_message;
typedef class uvm_report_object;
typedef class uvm_report_handler;
typedef class uvm_default_report_server;
typedef class uvm_cmdline_verbosity;
class uvm_root extends uvm_component;
    extern static function uvm_root get();
    uvm_cmdline_processor clp;
    virtual function string get_type_name();
        return "uvm_root";
    endfunction
    extern virtual task run_test (string test_name="");
    virtual function void die();
      uvm_report_server l_rs;
          if (get_core_state() inside {UVM_CORE_PRE_ABORT,UVM_CORE_ABORTED}) begin
            return;
          end
          l_rs = uvm_report_server::get_server();
          m_uvm_core_state.push_front(UVM_CORE_PRE_ABORT);
      m_do_pre_abort();
          uvm_run_test_callback::m_do_pre_abort();
          m_do_cmdline_checks();
      l_rs.report_summarize();
          m_uvm_core_state.push_front(UVM_CORE_ABORTED);
      $finish;
    endfunction
    extern function void set_timeout(time timeout, bit overridable=1);
  bit finish_on_completion = 1;
  virtual  function bit get_finish_on_completion();
     return finish_on_completion;
  endfunction : get_finish_on_completion
  virtual  function void set_finish_on_completion(bit f);
     finish_on_completion = f;
  endfunction : set_finish_on_completion
        uvm_component top_levels[$];
    extern function uvm_component find (string comp_match);
    extern function void find_all (string comp_match,
        ref uvm_component comps[$],
        input uvm_component comp=null);
    extern function void print_topology  (uvm_printer printer=null);
    bit  enable_print_topology = 0;
    extern function void set_enable_print_topology  (bit enable);
    extern function bit get_enable_print_topology  ();
    time phase_timeout = 9200s;
    extern function void m_find_all_recurse(string comp_match,
        ref uvm_component comps[$],
        input uvm_component comp=null);
    extern protected function new ();
    extern protected virtual function bit m_add_child (uvm_component child);
    extern function void build_phase(uvm_phase phase);
        extern local function void m_do_cl_init();
    extern local function void m_do_verbosity_settings();
        extern local function void m_do_cmdline_checks();
    extern local function void m_do_timeout_settings();
    extern local function void m_do_factory_settings();
    extern local function void m_process_inst_override(string ovr);
    extern local function void m_process_type_override(string ovr);
    extern local function void m_do_config_settings();
    extern local function void m_do_max_quit_settings();
    extern local function void m_do_dump_args();
    extern local function void m_process_config(string cfg, bit is_int, is_bitstream);
    extern local function void m_process_default_sequence(string cfg);
        local string m_uvm_verbosity_settings[$];
        local uvm_cmdline_set_verbosity m_time_settings[$];
    extern function void m_check_verbosity();
    extern function void m_check_uvm_field_flag_size();
    extern virtual function void report_header(UVM_FILE file = 0);
    static local uvm_root m_inst;
    extern virtual task run_phase (uvm_phase phase);
    function void phase_started(uvm_phase phase);
        if (phase == end_of_elaboration_ph) begin
          do_resolve_bindings();
          if (enable_print_topology) begin
            print_topology();
          end
          begin
            uvm_report_server srvr;
            srvr = uvm_report_server::get_server();
            if(srvr.get_severity_count(UVM_ERROR) > 0) begin
              uvm_report_fatal("BUILDERR", "stopping due to build errors", UVM_NONE);
            end
          end
        end
    endfunction
    bit m_phase_all_done;
        extern static function uvm_root m_uvm_get_root();
    static local bit m_relnotes_done=0;
    function void end_of_elaboration_phase(uvm_phase phase);
        uvm_component_proxy p = new("proxy");
        uvm_top_down_visitor_adapter#(uvm_component) adapter = new("adapter");
        uvm_coreservice_t cs = uvm_coreservice_t::get();
        uvm_visitor#(uvm_component) v = cs.get_component_visitor();
        adapter.accept(this, v, p);
    endfunction
endclass
  uvm_root uvm_top;
function uvm_root uvm_root::get();
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    return cs.get_root();
endfunction
function uvm_root::new();
  uvm_report_handler rh;
  super.new("__top__", null);
  rh = new("reporter");
  set_report_handler(rh);
  if (m_inst != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = m_inst.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "UVM/ROOT/MULTI") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "UVM/ROOT/MULTI") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_fatal("UVM/ROOT/MULTI", "Attempting to construct multiple roots", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_root.svh", 401, "", 1);
     end
   end
    return;
  end
  m_inst = this;
  clp = uvm_cmdline_processor::get_inst();
  m_do_cl_init();
  m_set_cl_msg_args();
endfunction
function uvm_root uvm_root::m_uvm_get_root();
  if (m_inst == null) begin
    uvm_root top;
    top = new();
    uvm_top = top;
    if (top != m_inst) begin
      return null;
    end
    top.m_domain = uvm_domain::get_uvm_domain();
  end
  if (m_inst != uvm_top) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = m_inst.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "UVM/BAD_TOP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "UVM/BAD_TOP") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_fatal("UVM/BAD_TOP", "The uvm_top variable has been overwritten outside of uvm_root!", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_root.svh", 433, "", 1);
     end
   end
  end
  return m_inst;
endfunction
function void uvm_root::report_header(UVM_FILE file = 0);
    string q[$];
    uvm_report_server srvr;
    uvm_cmdline_processor clp;
    string args[$];
    srvr = uvm_report_server::get_server();
    clp = uvm_cmdline_processor::get_inst();
    if (clp.get_arg_matches("+UVM_NO_RELNOTES", args)) begin
      return;
    end
    if (!m_relnotes_done) begin
      q.push_back("\n  ***********       IMPORTANT RELEASE NOTES         ************\n");
      m_relnotes_done = 1;
      q.push_back("\n  This implementation of the UVM Library deviates from the 1800.2-2020\n");
      q.push_back("  standard.  See the DEVIATIONS.md file contained in the release\n");
      q.push_back("  for more details.\n");
    end
    q.push_back("\n----------------------------------------------------------------\n");
    q.push_back({uvm_revision_string(),"\n"});
    q.push_back("\n");
        q.push_back("All copyright owners for this kit are listed in NOTICE.txt\n");
        q.push_back("All Rights Reserved Worldwide\n");
    q.push_back("----------------------------------------------------------------\n");
    if(m_relnotes_done) begin
      q.push_back("\n      (Specify +UVM_NO_RELNOTES to turn off this notice)\n");
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/RELNOTES") >= UVM_LOW) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/RELNOTES") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/RELNOTES", uvm_pkg::m_uvm_string_queue_join(q), UVM_LOW, "t/uvm/src/base/uvm_root.svh", 476, "", 1);
     end
   end
endfunction
task uvm_root::run_test(string test_name="");
    uvm_report_server l_rs;
    uvm_factory factory;
    bit testname_plusarg;
    int test_name_count;
    string test_names[$];
    string msg;
    uvm_component uvm_test_top;
    process phase_runner_proc;
      uvm_run_test_callback::m_do_pre_run_test();
    factory=uvm_factory::get();
        m_uvm_core_state.push_front(UVM_CORE_PRE_RUN);
    testname_plusarg = 0;
    uvm_objection::m_init_objections();
    uvm_process_guard_base::m_init_process_guards();
    m_do_dump_args();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "NO_DPI_USED") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "NO_DPI_USED") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("NO_DPI_USED", "We are thinking of removing support for UVM_NO_DPI.  Please try this test without it and evaluate the impact", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_root.svh", 549, "", 1);
     end
   end
    if ($value$plusargs("UVM_TESTNAME=%s", test_name)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "NO_DPI_TSTNAME") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "NO_DPI_TSTNAME") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("NO_DPI_TSTNAME", "UVM_NO_DPI defined--getting UVM_TESTNAME directly, without DPI", UVM_NONE, "t/uvm/src/base/uvm_root.svh", 552, "", 1);
     end
   end
        testname_plusarg = 1;
    end
    if (test_name != "") begin
      if(m_children.exists("uvm_test_top")) begin
        uvm_report_fatal("TTINST",
                "An uvm_test_top already exists via a previous call to run_test", UVM_NONE);
        #0;
      end
      $cast(uvm_test_top, factory.create_component_by_name(test_name,
                "", "uvm_test_top", null));
      if (uvm_test_top == null) begin
        msg = testname_plusarg ? {"command line +UVM_TESTNAME=",test_name} :
            {"call to run_test(",test_name,")"};
        uvm_report_fatal("INVTST",
                {"Requested test from ",msg, " not found." }, UVM_NONE);
      end
    end
    if (m_children.num() == 0) begin
      uvm_report_fatal("NOCOMP",
            {"No components instantiated. You must either instantiate",
                " at least one component before calling run_test or use",
                " run_test to do so. To run a test using run_test,",
                " use +UVM_TESTNAME or supply the test name in",
                " the argument to run_test(). Exiting simulation."}, UVM_NONE);
      return;
    end
    begin
      if(test_name=="") begin
        uvm_report_info("RNTST", "Running test ...", UVM_LOW);
      end
      else if (test_name == uvm_test_top.get_type_name()) begin
        uvm_report_info("RNTST", {"Running test ",test_name,"..."}, UVM_LOW);
      end
      else begin
        uvm_report_info("RNTST", {"Running test ",uvm_test_top.get_type_name()," (via factory override for test \"",test_name,"\")..."}, UVM_LOW);
      end
    end
    fork
      begin
        uvm_phase_hopper hopper;
        hopper = uvm_phase_hopper::get_global_hopper();
        m_uvm_core_state.push_front(UVM_CORE_RUNNING);
        hopper.run_phases();
      end
    join
        m_uvm_core_state.push_front(UVM_CORE_POST_RUN);
    l_rs = uvm_report_server::get_server();
        uvm_run_test_callback::m_do_post_run_test();
        m_do_cmdline_checks();
    l_rs.report_summarize();
        m_uvm_core_state.push_front(UVM_CORE_FINISHED);
      if (get_finish_on_completion()) begin
        $finish;
      end
endtask
function void uvm_root::find_all(string comp_match, ref uvm_component comps[$],
        input uvm_component comp=null);
    if (comp==null) begin
      comp = this;
    end
    m_find_all_recurse(comp_match, comps, comp);
endfunction
function uvm_component uvm_root::find (string comp_match);
    uvm_component comp_list[$];
    find_all(comp_match,comp_list);
    if (comp_list.size() > 1) begin
      uvm_report_warning("MMATCH",
            $sformatf("Found %0d components matching '%s'. Returning first match, %0s.",
                comp_list.size(),comp_match,comp_list[0].get_full_name()), UVM_NONE);
    end
    if (comp_list.size() == 0) begin
      uvm_report_warning("CMPNFD",
            {"Component matching '",comp_match,
                "' was not found in the list of uvm_components"}, UVM_NONE);
      return null;
    end
    return comp_list[0];
endfunction
function void uvm_root::print_topology(uvm_printer printer=null);
    if (m_children.num()==0) begin
      uvm_report_warning("EMTCOMP", "print_topology - No UVM components to print.", UVM_NONE);
      return;
    end
    if (printer==null) begin
      printer = uvm_printer::get_default();
    end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVMTOP") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVMTOP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVMTOP", "UVM testbench topology:", UVM_NONE, "t/uvm/src/base/uvm_root.svh", 699, "", 1);
     end
   end
   print(printer) ;
endfunction
function void uvm_root::set_timeout(time timeout, bit overridable=1);
    static bit m_uvm_timeout_overridable = 1;
    if (m_uvm_timeout_overridable == 0) begin
      uvm_report_info("NOTIMOUTOVR",
            $sformatf("The global timeout setting of %0d is not overridable to %0d due to a previous setting.",
                phase_timeout, timeout), UVM_NONE);
      return;
    end
    m_uvm_timeout_overridable = overridable;
    phase_timeout = timeout;
endfunction
function void uvm_root::m_find_all_recurse(string comp_match, ref uvm_component comps[$],
        input uvm_component comp=null);
    string name;
    if (comp.get_first_child(name)) begin
      do begin
        this.m_find_all_recurse(comp_match, comps, comp.get_child(name));
      end
      while (comp.get_next_child(name));
    end
    if (uvm_is_match(comp_match, comp.get_full_name()) &&
            comp.get_name() != "") begin
      comps.push_back(comp);
    end
endfunction
function bit uvm_root::m_add_child (uvm_component child);
    if(super.m_add_child(child)) begin
      if(child.get_name() == "uvm_test_top") begin
        top_levels.push_front(child);
      end
      else begin
        top_levels.push_back(child);
      end
      return 1;
    end
    else begin
      return 0;
    end
endfunction
function void uvm_root::build_phase(uvm_phase phase);
  super.build_phase(phase);
  m_do_verbosity_settings();
  m_do_timeout_settings();
  m_do_factory_settings();
  m_do_config_settings();
  m_do_max_quit_settings();
endfunction
function void uvm_root::m_do_cl_init();
  string values[$];
  string args[$];
  string message;
  uvm_cmdline_set_verbosity::init(this);
  foreach(uvm_cmdline_set_verbosity::settings[i]) begin
    if (uvm_cmdline_set_verbosity::settings[i].phase == "time" && uvm_cmdline_set_verbosity::settings[i].offset != 0) begin
      m_time_settings.push_back(uvm_cmdline_set_verbosity::settings[i]);
    end
  end
  uvm_cmdline_set_action::init(this);
  uvm_cmdline_set_severity::init(this);
endfunction : m_do_cl_init
function void uvm_root::m_do_verbosity_settings();
  string set_verbosity_settings[$];
  string split_vals[$];
  uvm_verbosity tmp_verb;
  fork
    begin
      time last_time = 0;
      if (m_time_settings.size() > 0) begin
        m_time_settings.sort() with ( item.offset );
      end
      foreach(m_time_settings[i]) begin
        uvm_component comps[$];
        #(m_time_settings[i].offset - last_time);
        find_all(m_time_settings[i].comp,comps);
        last_time = m_time_settings[i].offset;
        if(m_time_settings[i].id == "_ALL_") begin
          foreach(comps[j]) begin
            m_time_settings[i].used[comps[j]] = 1;
            comps[j].set_report_verbosity_level(m_time_settings[i].verbosity);
          end
        end
        else begin
          foreach(comps[j]) begin
            m_time_settings[i].used[comps[j]] = 1;
            comps[j].set_report_id_verbosity(m_time_settings[i].id, m_time_settings[i].verbosity);
          end
        end
      end
    end
  join_none
endfunction
function void uvm_root::m_do_cmdline_checks();
  string dump_args[$];
  uvm_cmdline_set_verbosity::check(this);
  if(clp.get_arg_matches("+UVM_DUMP_REPORT_ARGS", dump_args)) begin
    string msgs[$];
    msgs.push_back("\n!!! UVM_CMDLINE_NO_DPI IS DEFINED !!!");
    msgs.push_back(uvm_cmdline_verbosity::dump());
    msgs.push_back(uvm_cmdline_set_verbosity::dump());
    msgs.push_back(uvm_cmdline_set_action::dump());
    msgs.push_back(uvm_cmdline_set_severity::dump());
    uvm_report_info("REPORTARGS",
                    $sformatf("\n--- UVM Reporting Argument Summary ---\n%s\n",
                              uvm_pkg::m_uvm_string_queue_join(msgs)),
                    UVM_NONE);
  end
endfunction
function void uvm_root::m_do_timeout_settings();
    string timeout_settings[$];
    string timeout;
    string split_timeout[$];
    int timeout_count;
    time timeout_int;
    string override_spec;
    timeout_count = clp.get_arg_values("+UVM_TIMEOUT=", timeout_settings);
    if (timeout_count ==  0) begin
      return;
    end
    else begin
      timeout = timeout_settings[0];
      if (timeout_count > 1) begin
        string timeout_list;
        string sep;
        for (int i = 0; i < timeout_settings.size(); i++) begin
          if (i != 0) begin
            sep = "; ";
          end
          timeout_list = {timeout_list, sep, timeout_settings[i]};
        end
        uvm_report_warning("MULTTIMOUT",
                $sformatf("Multiple (%0d) +UVM_TIMEOUT arguments provided on the command line.  '%s' will be used.  Provided list: %s.",
                    timeout_count, timeout, timeout_list), UVM_NONE);
      end
      uvm_report_info("TIMOUTSET",
            $sformatf("'+UVM_TIMEOUT=%s' provided on the command line is being applied.", timeout), UVM_NONE);
      void'($sscanf(timeout,"%d,%s",timeout_int,override_spec));
      case(override_spec)
        "YES"   : begin
          set_timeout(timeout_int, 1);
        end
        "NO"    : begin
          set_timeout(timeout_int, 0);
        end
        default : begin
          set_timeout(timeout_int, 1);
        end
        endcase
    end
endfunction
function void uvm_root::m_do_factory_settings();
    string args[$];
    void'(clp.get_arg_matches("/^\\+(UVM_SET_INST_OVERRIDE|uvm_set_inst_override)=/",args));
    foreach(args[i]) begin
      m_process_inst_override(args[i].substr(23, args[i].len()-1));
    end
    void'(clp.get_arg_matches("/^\\+(UVM_SET_TYPE_OVERRIDE|uvm_set_type_override)=/",args));
    foreach(args[i]) begin
      m_process_type_override(args[i].substr(23, args[i].len()-1));
    end
endfunction
function void uvm_root::m_process_inst_override(string ovr);
    string split_val[$];
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_factory factory=cs.get_factory();
    uvm_string_split(ovr, ",", split_val);
    if(split_val.size() != 3 ) begin
      uvm_report_error("UVM_CMDLINE_PROC", {"Invalid setting for +uvm_set_inst_override=", ovr,
                ", setting must specify <requested_type>,<override_type>,<instance_path>"}, UVM_NONE);
      return;
    end
    uvm_report_info("INSTOVR", {"Applying instance override from the command line: +uvm_set_inst_override=", ovr}, UVM_NONE);
    factory.set_inst_override_by_name(split_val[0], split_val[1], split_val[2]);
endfunction
function void uvm_root::m_process_type_override(string ovr);
    string split_val[$];
    int replace=1;
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_factory factory=cs.get_factory();
    uvm_string_split(ovr, ",", split_val);
    if(split_val.size() > 3 || split_val.size() < 2) begin
      uvm_report_error("UVM_CMDLINE_PROC", {"Invalid setting for +uvm_set_type_override=", ovr,
                ", setting must specify <requested_type>,<override_type>[,<replace>]"}, UVM_NONE);
      return;
    end
    if(split_val.size() == 3) begin
      if(split_val[2]=="0") begin
        replace =  0;
      end
      else if (split_val[2] == "1") begin
        replace = 1;
      end
      else begin
        uvm_report_error("UVM_CMDLINE_PROC", {"Invalid replace arg for +uvm_set_type_override=", ovr ," value must be 0 or 1"}, UVM_NONE);
        return;
      end
    end
    uvm_report_info("UVM_CMDLINE_PROC", {"Applying type override from the command line: +uvm_set_type_override=", ovr}, UVM_NONE);
    factory.set_type_override_by_name(split_val[0], split_val[1], replace);
endfunction
function void uvm_root::m_process_config(string cfg, bit is_int, is_bitstream);
    uvm_bitstream_t v;
    string split_val[$];
    uvm_root m_uvm_top;
    uvm_coreservice_t cs;
    cs = uvm_coreservice_t::get();
    m_uvm_top = cs.get_root();
    uvm_string_split(cfg, ",", split_val);
    if(split_val.size() == 1) begin
      uvm_report_error("UVM_CMDLINE_PROC", {"Invalid +uvm_set_config command\"", cfg,
                "\" missing field and value: component is \"", split_val[0], "\""}, UVM_NONE);
      return;
    end
    if(split_val.size() == 2) begin
      uvm_report_error("UVM_CMDLINE_PROC", {"Invalid +uvm_set_config command\"", cfg,
                "\" missing value: component is \"", split_val[0], "\"  field is \"", split_val[1], "\""}, UVM_NONE);
      return;
    end
    if(split_val.size() > 3) begin
      uvm_report_error("UVM_CMDLINE_PROC",
            $sformatf("Invalid +uvm_set_config command\"%s\" : expected only 3 fields (component, field and value).", cfg), UVM_NONE);
      return;
    end
    if(is_int) begin
      if(split_val[2].len() > 2) begin
        string base, extval;
        base = split_val[2].substr(0,1);
        extval = split_val[2].substr(2,split_val[2].len()-1);
        case(base)
          "'b" : begin
            v = extval.atobin();
          end
          "0b" : begin
            v = extval.atobin();
          end
          "'o" : begin
            v = extval.atooct();
          end
          "'d" : begin
            v = extval.atoi();
          end
          "'h" : begin
            v = extval.atohex();
          end
          "'x" : begin
            v = extval.atohex();
          end
          "0x" : begin
            v = extval.atohex();
          end
          default : begin
            v = split_val[2].atoi();
          end
        endcase
      end
      else begin
        v = split_val[2].atoi();
      end
      uvm_report_info("UVM_CMDLINE_PROC", {"Applying config setting from the command line: +uvm_set_config_int=", cfg}, UVM_NONE);
      uvm_config_int::set(m_uvm_top, split_val[0], split_val[1], v);
    end
        else if(is_bitstream) begin
          int    success ;
          success = uvm_bit_vector_utils#(uvm_bitstream_t)::from_string(split_val[2], v);
          if (success == 1) begin
            uvm_report_info("UVM_CMDLINE_PROC", {"Applying config setting from the command line: +uvm_set_config_bitstream=", cfg}, UVM_NONE);
            uvm_config_int::set(m_uvm_top, split_val[0], split_val[1], v);
          end
        end
    else begin
      uvm_report_info("UVM_CMDLINE_PROC", {"Applying config setting from the command line: +uvm_set_config_string=", cfg}, UVM_NONE);
      uvm_config_string::set(m_uvm_top, split_val[0], split_val[1], split_val[2]);
    end
endfunction
function void uvm_root::m_process_default_sequence(string cfg);
    string split_val[$];
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    uvm_root m_uvm_top = cs.get_root();
    uvm_factory f = cs.get_factory();
    uvm_object_wrapper w;
    uvm_string_split(cfg, ",", split_val);
    if(split_val.size() == 1) begin
      uvm_report_error("UVM_CMDLINE_PROC", {"Invalid +uvm_set_default_sequence command\"", cfg,
                "\" missing phase and type: sequencer is \"", split_val[0], "\""}, UVM_NONE);
      return;
    end
    if(split_val.size() == 2) begin
      uvm_report_error("UVM_CMDLINE_PROC", {"Invalid +uvm_set_default_sequence command\"", cfg,
                "\" missing type: sequencer is \"", split_val[0], "\"  phase is \"", split_val[1], "\""}, UVM_NONE);
      return;
    end
    if(split_val.size() > 3) begin
      uvm_report_error("UVM_CMDLINE_PROC",
            $sformatf("Invalid +uvm_set_default_sequence command\"%s\" : expected only 3 fields (sequencer, phase and type).", cfg), UVM_NONE);
      return;
    end
    w = f.find_wrapper_by_name(split_val[2]);
    if (w == null) begin
      uvm_report_error("UVM_CMDLINE_PROC",
            $sformatf("Invalid type '%s' provided to +uvm_set_default_sequence", split_val[2]),
            UVM_NONE);
      return;
    end
    else begin
      uvm_report_info("UVM_CMDLINE_PROC", {"Setting default sequence from the command line: +uvm_set_default_sequence=", cfg}, UVM_NONE);
      uvm_config_db#(uvm_object_wrapper)::set(this, {split_val[0], ".", split_val[1]}, "default_sequence", w);
    end
endfunction : m_process_default_sequence
function void uvm_root::m_do_config_settings();
    string args[$];
    void'(clp.get_arg_matches("/^\\+(UVM_SET_CONFIG_INT|uvm_set_config_int)=/",args));
    foreach(args[i]) begin
      m_process_config(args[i].substr(20, args[i].len()-1), 1, 0);
    end
    void'(clp.get_arg_matches("/^\\+(UVM_SET_CONFIG_BITSTREAM|uvm_set_config_bitstream)=/",args));
    foreach(args[i]) begin
      m_process_config(args[i].substr(26, args[i].len()-1), 0, 1);
    end
    void'(clp.get_arg_matches("/^\\+(UVM_SET_CONFIG_STRING|uvm_set_config_string)=/",args));
    foreach(args[i]) begin
      m_process_config(args[i].substr(23, args[i].len()-1), 0, 0);
    end
    void'(clp.get_arg_matches("/^\\+(UVM_SET_DEFAULT_SEQUENCE|uvm_set_default_sequence)=/", args));
    foreach(args[i]) begin
      m_process_default_sequence(args[i].substr(26, args[i].len()-1));
    end
endfunction
function void uvm_root::m_do_max_quit_settings();
    uvm_report_server srvr;
    string max_quit_settings[$];
    int max_quit_count;
    string max_quit;
    string split_max_quit[$];
    int max_quit_int;
        int i;
        string tmp;
    srvr = uvm_report_server::get_server();
    max_quit_count = clp.get_arg_values("+UVM_MAX_QUIT_COUNT=", max_quit_settings);
    if (max_quit_count ==  0) begin
      return;
    end
    else begin
      max_quit = max_quit_settings[0];
      if (max_quit_count > 1) begin
        string max_quit_list;
        string sep;
        for (int i = 0; i < max_quit_settings.size(); i++) begin
          if (i != 0) begin
            sep = "; ";
          end
          max_quit_list = {max_quit_list, sep, max_quit_settings[i]};
        end
        uvm_report_warning("MULTMAXQUIT",
                $sformatf("Multiple (%0d) +UVM_MAX_QUIT_COUNT arguments provided on the command line.  '%s' will be used.  Provided list: %s.",
                    max_quit_count, max_quit, max_quit_list), UVM_NONE);
      end
      uvm_report_info("MAXQUITSET",
            $sformatf("'+UVM_MAX_QUIT_COUNT=%s' provided on the command line is being applied.", max_quit), UVM_NONE);
      uvm_string_split(max_quit, ",", split_max_quit);
      tmp = split_max_quit[0];
      i = $sscanf(tmp,"%d", max_quit_int);
      case(split_max_quit[1])
        "YES"   : begin
          srvr.set_max_quit_count(max_quit_int, 1);
        end
        "NO"    : begin
          srvr.set_max_quit_count(max_quit_int, 0);
        end
        default : begin
          srvr.set_max_quit_count(max_quit_int, 1);
        end
        endcase
    end
endfunction
function void uvm_root::m_do_dump_args();
    string dump_args[$];
    string all_args[$];
    string out_string;
    if(clp.get_arg_matches("+UVM_DUMP_CMDLINE_ARGS", dump_args)) begin
      clp.get_args(all_args);
      foreach (all_args[idx]) begin
        uvm_report_info("DUMPARGS", $sformatf("idx=%0d arg=[%s]",idx,all_args[idx]), UVM_NONE);
      end
    end
endfunction
function void uvm_root::m_check_verbosity();
  int    verbosity = UVM_MEDIUM;
  uvm_cmdline_verbosity::init(this);
  uvm_cmdline_verbosity::check(this);
  if (uvm_cmdline_verbosity::settings.size() > 0) begin
    verbosity = uvm_cmdline_verbosity::settings[0].verbosity;
  end
  set_report_verbosity_level_hier(verbosity);
endfunction
function void uvm_root::m_check_uvm_field_flag_size();
    if ( (UVM_FIELD_FLAG_RESERVED_BITS) < UVM_FIELD_FLAG_RESERVED_BITS ) begin
      uvm_report_fatal( "BAD_FIELD_FLAG_SZ",
            $sformatf(
                "Macro UVM_FIELD_FLAG_SIZE is set to %0d which is less than the required minimum of UVM_FIELD_FLAG_RESERVED_BITS (%0d).",
                UVM_FIELD_FLAG_RESERVED_BITS, UVM_FIELD_FLAG_RESERVED_BITS
            )
        );
    end
endfunction
task uvm_root::run_phase (uvm_phase phase);
  uvm_cmdline_set_action::check(this);
  uvm_cmdline_set_severity::check(this);
  if($time > 0) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "RUNPHSTIME") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "RUNPHSTIME") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("RUNPHSTIME", {"The run phase must start at time 0, current time is ", $sformatf("%0t", $realtime), ". No non-zero delays are allowed before ", "run_test(), and pre-run user defined phases may not consume ", "simulation time before the start of the run phase."}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_root.svh", 1291, "", 1);
     end
   end
  end
endtask
function void uvm_root::set_enable_print_topology  (bit enable);
    enable_print_topology = enable;
endfunction
function bit uvm_root::get_enable_print_topology();
    return enable_print_topology;
endfunction
function uvm_component::new (string name, uvm_component parent);
  string error_str;
  uvm_root top;
  uvm_coreservice_t cs;
  uvm_resource_pool rp;
  uvm_resource_types::rsrc_q_t rq;
  super.new(name);
  if (parent==null && name == "__top__") begin
    set_name("");
    event_pool = new("event_pool");
    return;
  end
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  begin
    uvm_phase bld;
    uvm_domain common;
    common = uvm_domain::get_common_domain();
    bld = common.find(uvm_build_phase::get());
    if (bld == null) begin
      uvm_report_fatal("COMP/INTERNAL",
                       "attempt to find build phase object failed",UVM_NONE);
    end
    if (bld.get_state() == UVM_PHASE_DONE) begin
      uvm_report_fatal("ILLCRT", {"It is illegal to create a component ('",
                name,"' under '",
                (parent == null ? top.get_full_name() : parent.get_full_name()),
               "') after the build phase has ended."},
                       UVM_NONE);
    end
  end
  if (name == "") begin
    name.itoa(m_inst_count);
    name = {"COMP_", name};
  end
  if(parent == this) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "THISPARENT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "THISPARENT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("THISPARENT", "cannot set the parent of a component to itself", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1735, "", 1);
     end
   end
  end
  if (parent == null) begin
    parent = top;
  end
  if(uvm_report_enabled(UVM_MEDIUM+1, UVM_INFO, "NEWCOMP")) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "NEWCOMP") >= UVM_MEDIUM+1) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "NEWCOMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("NEWCOMP", {"Creating ", (parent==top?"uvm_top":parent.get_full_name()),".",name}, UVM_MEDIUM+1, "t/uvm/src/base/uvm_component.svh", 1746, "", 1);
     end
   end
  end
  if (parent.has_child(name) && this != parent.get_child(name)) begin
    if (parent == top) begin
      error_str = {"Name '",name,"' is not unique to other top-level ",
      "instances. If parent is a module, build a unique name by combining the ",
      "the module name and component name: $sformatf(\"\%m.\%s\",\"",name,"\")."};
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "CLDEXT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "CLDEXT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("CLDEXT", error_str, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1754, "", 1);
     end
   end
    end
    else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_FATAL, "CLDEXT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_FATAL, "CLDEXT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_fatal("CLDEXT", $sformatf("Cannot set '%s' as a child of '%s', %s", name, parent.get_full_name(), "which already has a child by that name."), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1760, "", 1);
     end
   end
    end
    return;
  end
  m_parent = parent;
  set_name(name);
  if (!m_parent.m_add_child(this)) begin
    m_parent = null;
  end
  event_pool = new("event_pool");
  m_domain = parent.m_domain;
  reseed();
  rp = cs.get_resource_pool();
  rq = rp.lookup_name(.scope(get_full_name()),
                      .name("recording_detail"),
                      .type_handle(null),
                      .rpterr(0));
  if (rq.size() > 0) begin
    uvm_resource_base rsrc;
    bit found;
    rp.sort_by_precedence(rq);
    do begin
      rsrc = rq.pop_front();
begin
begin
  uvm_resource#(uvm_integral_t) __tmp_rsrc__;
  found = $cast(__tmp_rsrc__, rsrc);
  if (found) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
  if (!found)
begin
  uvm_resource#(uvm_bitstream_t) __tmp_rsrc__;
  found = $cast(__tmp_rsrc__, rsrc);
  if (found) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
  if (!found)
begin
  uvm_resource#(int) __tmp_rsrc__;
  found = $cast(__tmp_rsrc__, rsrc);
  if (found) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
  if (!found)
begin
  uvm_resource#(int unsigned) __tmp_rsrc__;
  found = $cast(__tmp_rsrc__, rsrc);
  if (found) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
end;
    end
    while (!found && (rq.size() > 0));
  end
  m_rh.set_name(get_full_name());
  set_report_verbosity_level(parent.get_report_verbosity_level());
  m_set_cl_msg_args();
endfunction
function bit uvm_component::m_add_child(uvm_component child);
  if (m_children.exists(child.get_name()) &&
      m_children[child.get_name()] != child) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "BDCLD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "BDCLD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("BDCLD", $sformatf("A child with the name '%0s' (type=%0s) already exists.", child.get_name(), m_children[child.get_name()].get_type_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1817, "", 1);
     end
   end
    return 0;
  end
  if (m_children_by_handle.exists(child)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "BDCHLD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "BDCHLD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("BDCHLD", $sformatf("A child with the name '%0s' %0s %0s'", child.get_name(), "already exists in parent under name '", m_children_by_handle[child].get_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1826, "", 1);
     end
   end
    return 0;
  end
  m_children[child.get_name()] = child;
  m_children_by_handle[child] = child;
  return 1;
endfunction
function void uvm_component::get_children(ref uvm_component children[$]);
  foreach(m_children[i]) begin
    children.push_back(m_children[i]);
  end
endfunction
function int uvm_component::get_first_child(ref string name);
  return m_children.first(name);
endfunction
function int uvm_component::get_next_child(ref string name);
  return m_children.next(name);
endfunction
function uvm_component uvm_component::get_child(string name);
  if (m_children.exists(name)) begin
    return m_children[name];
  end
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "NOCHILD") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "NOCHILD") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("NOCHILD", {"Component with name '",name, "' is not a child of component '",get_full_name(),"'"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1882, "", 1);
     end
   end
  return null;
endfunction
function int uvm_component::has_child(string name);
  return m_children.exists(name);
endfunction
function int uvm_component::get_num_children();
  return m_children.num();
endfunction
function string uvm_component::get_full_name ();
  if(m_name == "") begin
    return get_name();
  end
  else begin
    return m_name;
  end
endfunction
function uvm_component uvm_component::get_parent ();
  return  m_parent;
endfunction
function void uvm_component::set_name (string name);
  if(m_name != "") begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "INVSTNM") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "INVSTNM") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("INVSTNM", $sformatf("It is illegal to change the name of a component. The component name will not be changed to \"%s\"", name), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1935, "", 1);
     end
   end
    return;
  end
  super.set_name(name);
  m_set_full_name();
endfunction
function void uvm_component::m_set_full_name();
  uvm_root top;
  if ($cast(top, m_parent) || m_parent==null) begin
    m_name = get_name();
  end
  else begin
    m_name = {m_parent.get_full_name(), ".", get_name()};
  end
  foreach (m_children[c]) begin
    uvm_component tmp;
    tmp = m_children[c];
    tmp.m_set_full_name();
  end
endfunction
function uvm_component uvm_component::lookup( string name );
  string leaf , remainder;
  uvm_component comp;
  uvm_root top;
  uvm_coreservice_t cs;
  int name_length;
  cs = uvm_coreservice_t::get();
  top = cs.get_root();
  comp = this;
  name_length = name.len();
  for(int i = 0; i < name_length; i++) begin
    if((name.substr(i, (i+1)) == "..") || (name[i] == "*") || (name[i] == "?")) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "Lookup String Error") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "Lookup String Error") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("Lookup String Error", $sformatf("Malformed look up string: %s", name), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 1989, "", 1);
     end
   end
      return null;
    end
  end
  m_extract_name(name, leaf, remainder);
  if (leaf == "") begin
    comp = top;
    m_extract_name(remainder, leaf, remainder);
  end
  if (!comp.has_child(leaf)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "Lookup Error") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "Lookup Error") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("Lookup Error", $sformatf("Cannot find child %0s",leaf), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2003, "", 1);
     end
   end
    return null;
  end
  if( remainder != "" ) begin
    return comp.m_children[leaf].lookup(remainder);
  end
  return comp.m_children[leaf];
endfunction
function int unsigned uvm_component::get_depth();
  if(m_name == "") begin
    return 0;
  end
  get_depth = 1;
  foreach(m_name[i]) begin
    if(m_name[i] == ".") begin
      ++get_depth;
    end
  end
endfunction
function void uvm_component::m_extract_name(input string name ,
                                            output string leaf ,
                                            output string remainder );
  int i , len;
  len = name.len();
  for( i = 0; i < name.len(); i++ ) begin
    if( name[i] == "." ) begin
      break;
    end
  end
  if( i == len ) begin
    leaf = name;
    remainder = "";
    return;
  end
  leaf = name.substr( 0 , i - 1 );
  remainder = name.substr( i + 1 , len - 1 );
  return;
endfunction
function void uvm_component::flush();
  return;
endfunction
function void uvm_component::do_flush();
  foreach( m_children[s] ) begin
    m_children[s].do_flush();
  end
  flush();
endfunction
function uvm_object  uvm_component::create (string name ="");
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "ILLCRT") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "ILLCRT") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("ILLCRT", "create cannot be called on a uvm_component. Use create_component instead.", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2100, "", 1);
     end
   end
  return null;
endfunction
function uvm_object  uvm_component::clone ();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "ILLCLN") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "ILLCLN") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("ILLCLN", $sformatf("Attempting to clone '%s'.  Clone cannot be called on a uvm_component.  The clone target variable will be set to null.", get_full_name()), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2109, "", 1);
     end
   end
  return null;
endfunction
function void  uvm_component::print_override_info (string requested_type_name,
                                                   string name="");
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
  factory.debug_create_by_name(requested_type_name, get_full_name(), name);
endfunction
function uvm_component uvm_component::create_component (string requested_type_name,
                                                        string name);
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
  return factory.create_component_by_name(requested_type_name, get_full_name(),
                                          name, this);
endfunction
function uvm_object uvm_component::create_object (string requested_type_name,
                                                  string name="");
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
  return factory.create_object_by_name(requested_type_name,
                                       get_full_name(), name);
endfunction
function void uvm_component::set_type_override (string original_type_name,
                                                string override_type_name,
                                                bit    replace=1);
   uvm_coreservice_t cs = uvm_coreservice_t::get();
   uvm_factory factory=cs.get_factory();
   factory.set_type_override_by_name(original_type_name,override_type_name, replace);
endfunction
function void uvm_component::set_type_override_by_type (uvm_object_wrapper original_type,
                                                        uvm_object_wrapper override_type,
                                                        bit    replace=1);
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
   factory.set_type_override_by_type(original_type, override_type, replace);
endfunction
function void  uvm_component::set_inst_override (string relative_inst_path,
                                                 string original_type_name,
                                                 string override_type_name);
  string full_inst_path;
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
  if (relative_inst_path == "") begin
    full_inst_path = get_full_name();
  end
  else begin
    full_inst_path = {get_full_name(), ".", relative_inst_path};
  end
  factory.set_inst_override_by_name(
                            original_type_name,
                            override_type_name,
                            full_inst_path);
endfunction
function void uvm_component::set_inst_override_by_type (string relative_inst_path,
                                                        uvm_object_wrapper original_type,
                                                        uvm_object_wrapper override_type);
  string full_inst_path;
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  uvm_factory factory=cs.get_factory();
  if (relative_inst_path == "") begin
    full_inst_path = get_full_name();
  end
  else begin
    full_inst_path = {get_full_name(), ".", relative_inst_path};
  end
  factory.set_inst_override_by_type(original_type, override_type, full_inst_path);
endfunction
function void uvm_component::set_report_id_verbosity_hier( string id, int verbosity);
  set_report_id_verbosity(id, verbosity);
  foreach( m_children[c] ) begin
    m_children[c].set_report_id_verbosity_hier(id, verbosity);
  end
endfunction
function void uvm_component::set_report_severity_id_verbosity_hier( uvm_severity severity,
                                                                 string id,
                                                                 int verbosity);
  set_report_severity_id_verbosity(severity, id, verbosity);
  foreach( m_children[c] ) begin
    m_children[c].set_report_severity_id_verbosity_hier(severity, id, verbosity);
  end
endfunction
function void uvm_component::set_report_severity_action_hier( uvm_severity severity,
                                                           uvm_action action);
  set_report_severity_action(severity, action);
  foreach( m_children[c] ) begin
    m_children[c].set_report_severity_action_hier(severity, action);
  end
endfunction
function void uvm_component::set_report_id_action_hier( string id, uvm_action action);
  set_report_id_action(id, action);
  foreach( m_children[c] ) begin
    m_children[c].set_report_id_action_hier(id, action);
  end
endfunction
function void uvm_component::set_report_severity_id_action_hier( uvm_severity severity,
                                                                 string id,
                                                                 uvm_action action);
  set_report_severity_id_action(severity, id, action);
  foreach( m_children[c] ) begin
    m_children[c].set_report_severity_id_action_hier(severity, id, action);
  end
endfunction
function void uvm_component::set_report_severity_file_hier( uvm_severity severity,
                                                            UVM_FILE file);
  set_report_severity_file(severity, file);
  foreach( m_children[c] ) begin
    m_children[c].set_report_severity_file_hier(severity, file);
  end
endfunction
function void uvm_component::set_report_default_file_hier( UVM_FILE file);
  set_report_default_file(file);
  foreach( m_children[c] ) begin
    m_children[c].set_report_default_file_hier(file);
  end
endfunction
function void uvm_component::set_report_id_file_hier( string id, UVM_FILE file);
  set_report_id_file(id, file);
  foreach( m_children[c] ) begin
    m_children[c].set_report_id_file_hier(id, file);
  end
endfunction
function void uvm_component::set_report_severity_id_file_hier ( uvm_severity severity,
                                                                string id,
                                                                UVM_FILE file);
  set_report_severity_id_file(severity, id, file);
  foreach( m_children[c] ) begin
    m_children[c].set_report_severity_id_file_hier(severity, id, file);
  end
endfunction
function void uvm_component::set_report_verbosity_level_hier(int verbosity);
  set_report_verbosity_level(verbosity);
  foreach( m_children[c] ) begin
    m_children[c].set_report_verbosity_level_hier(verbosity);
  end
endfunction
function void uvm_component::build_phase(uvm_phase phase);
  build();
endfunction
function void uvm_component::connect_phase(uvm_phase phase);
  connect();
  return;
endfunction
function void uvm_component::start_of_simulation_phase(uvm_phase phase);
  start_of_simulation();
  return;
endfunction
function void uvm_component::end_of_elaboration_phase(uvm_phase phase);
  end_of_elaboration();
  return;
endfunction
task          uvm_component::run_phase(uvm_phase phase);
  run();
  return;
endtask
function void uvm_component::extract_phase(uvm_phase phase);
  extract();
  return;
endfunction
function void uvm_component::check_phase(uvm_phase phase);
  check();
  return;
endfunction
function void uvm_component::report_phase(uvm_phase phase);
  report();
  return;
endfunction
function void uvm_component::final_phase(uvm_phase phase);         return; endfunction
task uvm_component::pre_reset_phase(uvm_phase phase);      return; endtask
task uvm_component::reset_phase(uvm_phase phase);          return; endtask
task uvm_component::post_reset_phase(uvm_phase phase);     return; endtask
task uvm_component::pre_configure_phase(uvm_phase phase);  return; endtask
task uvm_component::configure_phase(uvm_phase phase);      return; endtask
task uvm_component::post_configure_phase(uvm_phase phase); return; endtask
task uvm_component::pre_main_phase(uvm_phase phase);       return; endtask
task uvm_component::main_phase(uvm_phase phase);           return; endtask
task uvm_component::post_main_phase(uvm_phase phase);      return; endtask
task uvm_component::pre_shutdown_phase(uvm_phase phase);   return; endtask
task uvm_component::shutdown_phase(uvm_phase phase);       return; endtask
task uvm_component::post_shutdown_phase(uvm_phase phase);  return; endtask
function void uvm_component::phase_started(uvm_phase phase);
endfunction
function void uvm_component::phase_ended(uvm_phase phase);
endfunction
function void uvm_component::phase_ready_to_end (uvm_phase phase);
endfunction
function void uvm_component::define_domain(uvm_domain domain);
  int num_children;
  uvm_phase succ[];
  domain.get_adjacent_successor_nodes(succ);
  num_children = succ.size();
  foreach(succ[iter]) begin
    if (succ[iter].get_parent() != domain) begin
      num_children--;
    end
  end
  if (num_children == 0) begin
    uvm_phase schedule;
    schedule = domain.find_by_name("uvm_sched");
    if (schedule == null) begin
      uvm_domain common;
      schedule = new("uvm_sched", UVM_PHASE_SCHEDULE);
      uvm_domain::add_uvm_phases(schedule);
      domain.add(schedule);
      common = uvm_domain::get_common_domain();
      if (common.find(domain,0) == null) begin
        common.add(domain,.with_phase(uvm_run_phase::get()));
      end
    end
  end
endfunction
function void uvm_component::set_domain(uvm_domain domain, int hier=1);
  m_domain = domain;
  define_domain(domain);
  if (hier) begin
    foreach (m_children[c]) begin
      m_children[c].set_domain(domain);
    end
  end
endfunction
function uvm_domain uvm_component::get_domain();
  return m_domain;
endfunction
function void uvm_component::set_phase_imp(uvm_phase phase, uvm_phase imp, int hier=1);
  m_phase_imps[phase] = imp;
  if (hier) begin
    foreach (m_children[c]) begin
      m_children[c].set_phase_imp(phase,imp,hier);
    end
  end
endfunction
task uvm_component::suspend();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "COMP/SPND/UNIMP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "COMP/SPND/UNIMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("COMP/SPND/UNIMP", "suspend() not implemented", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2569, "", 1);
     end
   end
endtask
task uvm_component::resume();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "COMP/RSUM/UNIMP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "COMP/RSUM/UNIMP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("COMP/RSUM/UNIMP", "resume() not implemented", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2577, "", 1);
     end
   end
endtask
function void uvm_component::resolve_bindings();
  return;
endfunction
function void uvm_component::do_resolve_bindings();
  foreach( m_children[s] ) begin
    m_children[s].do_resolve_bindings();
  end
  resolve_bindings();
endfunction
class uvm_config_object_wrapper;
   uvm_object obj;
   bit clone;
endclass : uvm_config_object_wrapper
function void uvm_component::set_config_int(string inst_name,
                                           string field_name,
                                           uvm_bitstream_t value);
  uvm_config_int::set(this, inst_name, field_name, value);
endfunction
function void uvm_component::set_config_string(string inst_name,
                                               string field_name,
                                               string value);
  uvm_config_string::set(this, inst_name, field_name, value);
endfunction
function void uvm_component::set_config_object(string inst_name,
                                               string field_name,
                                               uvm_object value,
                                               bit clone = 1);
  uvm_object tmp;
  uvm_config_object_wrapper wrapper;
  if(value == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "NULLCFG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "NULLCFG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("NULLCFG", {"A null object was provided as a ", $sformatf("configuration object for set_config_object(\"%s\",\"%s\")", inst_name, field_name), ". Verify that this is intended."}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2641, "", 1);
     end
   end
  end
  if(clone && (value != null)) begin
    tmp = value.clone();
    if(tmp == null) begin
      uvm_component comp;
      if ($cast(comp,value)) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "INVCLNC") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "INVCLNC") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("INVCLNC", {"Clone failed during set_config_object ", "with an object that is an uvm_component. Components cannot be cloned."}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2650, "", 1);
     end
   end
        return;
      end
      else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVCLN") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVCLN") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("INVCLN", {"Clone failed during set_config_object, ", "the original reference will be used for configuration. Check that ", "the create method for the object type is defined properly."}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2656, "", 1);
     end
   end
      end
    end
    else begin
      value = tmp;
    end
  end
  uvm_config_object::set(this, inst_name, field_name, value);
  wrapper = new;
  wrapper.obj = value;
  wrapper.clone = clone;
  uvm_config_db#(uvm_config_object_wrapper)::set(this, inst_name, field_name, wrapper);
endfunction
function bit uvm_component::get_config_int (string field_name,
                                            inout uvm_bitstream_t value);
  return uvm_config_int::get(this, "", field_name, value);
endfunction
function bit uvm_component::get_config_string(string field_name,
                                              inout string value);
  return uvm_config_string::get(this, "", field_name, value);
endfunction
function bit uvm_component::get_config_object (string field_name,
                                               inout uvm_object value,
                                               input bit clone=1);
  if(!uvm_config_object::get(this, "", field_name, value)) begin
    return 0;
  end
  if(clone && value != null) begin
    value = value.clone();
  end
  return 1;
endfunction
function void uvm_component::accept_tr (uvm_transaction tr,
                                        time accept_time=0);
  uvm_event#(uvm_object) e;
  if(tr == null) begin
    return;
  end
  tr.accept_tr(accept_time);
  do_accept_tr(tr);
  e = event_pool.get("accept_tr");
  if(e!=null) begin
    e.trigger();
  end
endfunction
function int uvm_component::begin_tr (uvm_transaction tr,
                                          string stream_name="main",
                                          string label="",
                                          string desc="",
                                          time begin_time=0,
                                          int parent_handle=0);
   return m_begin_tr(tr, parent_handle, stream_name, label, desc, begin_time);
endfunction
   function uvm_tr_database uvm_component::get_tr_database();
     if (tr_database == null) begin
       uvm_coreservice_t cs = uvm_coreservice_t::get();
       tr_database = cs.get_default_tr_database();
     end
     return tr_database;
   endfunction : get_tr_database
   function void uvm_component::set_tr_database(uvm_tr_database db);
      tr_database = db;
   endfunction : set_tr_database
function uvm_tr_stream uvm_component::get_tr_stream( string name,
                                                      string stream_type_name="" );
   uvm_tr_database db = get_tr_database();
   if (!m_streams.exists(name) || !m_streams[name].exists(stream_type_name)) begin
     m_streams[name][stream_type_name] = db.open_stream(name, this.get_full_name(), stream_type_name);
   end
   return m_streams[name][stream_type_name];
endfunction : get_tr_stream
function void uvm_component::free_tr_stream(uvm_tr_stream stream);
   if (stream == null) begin
     return;
   end
   if (!m_streams.exists(stream.get_name()) ||
       !m_streams[stream.get_name()].exists(stream.get_stream_type_name())) begin
     return;
   end
   if (m_streams[stream.get_name()][stream.get_stream_type_name()] != stream) begin
     return;
   end
   m_streams[stream.get_name()].delete(stream.get_type_name());
   if (m_streams[stream.get_name()].size() == 0) begin
     m_streams.delete(stream.get_name());
   end
   if (stream.is_open() || stream.is_closed()) begin
     stream.free();
   end
endfunction : free_tr_stream
function int uvm_component::m_begin_tr (uvm_transaction tr,
                                            int parent_handle=0,
                                            string stream_name="main",
                                            string label="",
                                            string desc="",
                                            time begin_time=0);
   uvm_event#(uvm_object) e;
   string    name;
   string    kind;
   uvm_tr_database db;
   int   handle, link_handle;
   uvm_tr_stream stream;
   uvm_recorder recorder, parent_recorder, link_recorder;
   if (tr == null) begin
     return 0;
   end
   db = get_tr_database();
   if (parent_handle != 0) begin
     parent_recorder = uvm_recorder::get_recorder_from_handle(parent_handle);
     if (parent_recorder == null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "ILLHNDL") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "ILLHNDL") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("ILLHNDL", "begin_tr was passed a non-0 parent handle that corresponds to a null recorder", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 2852, "", 1);
     end
   end
     end
   end
   else begin
     uvm_sequence_item seq;
     if ($cast(seq,tr)) begin
       uvm_sequence_base parent_seq = seq.get_parent_sequence();
       if (parent_seq != null) begin
         parent_recorder = parent_seq.m_tr_recorder;
       end
     end
   end
   if(parent_recorder != null) begin
     link_handle = tr.begin_tr(begin_time, parent_recorder.get_handle());
   end
   else begin
     link_handle = tr.begin_tr(begin_time);
   end
   if (link_handle != 0) begin
     link_recorder = uvm_recorder::get_recorder_from_handle(link_handle);
   end
   if (tr.get_name() != "") begin
     name = tr.get_name();
   end
   else begin
     name = tr.get_type_name();
   end
   if (get_recording_enabled()) begin
     if (stream_name == "") begin
       stream_name = "main";
     end
     stream = get_tr_stream(stream_name, "TVM");
     if (stream != null ) begin
       kind = (parent_recorder == null) ? "Begin_No_Parent, Link" : "Begin_End, Link";
       recorder = stream.open_recorder(name, begin_time, kind);
       if (recorder != null) begin
         if (label != "") begin
           recorder.record_string("label", label);
         end
         if (desc != "") begin
           recorder.record_string("desc", desc);
         end
         if (parent_recorder != null) begin
           tr_database.establish_link(uvm_parent_child_link::get_link(parent_recorder,
                                                                          recorder));
         end
         if (link_recorder != null) begin
           tr_database.establish_link(uvm_related_link::get_link(recorder,
                                                                     link_recorder));
         end
         m_tr_h[tr] = recorder;
       end
     end
     handle = (recorder == null) ? 0 : recorder.get_handle();
   end
   do_begin_tr(tr, stream_name, handle);
   e = event_pool.get("begin_tr");
   if (e!=null) begin
     e.trigger(tr);
   end
   return handle;
endfunction
function void uvm_component::end_tr (uvm_transaction tr,
                                     time end_time=0,
                                     bit free_handle=1);
   uvm_event#(uvm_object) e;
   uvm_recorder recorder;
   if (tr == null) begin
     return;
   end
   tr.end_tr(end_time,free_handle);
   if (get_recording_enabled()) begin
     if (m_tr_h.exists(tr)) begin
       recorder = m_tr_h[tr];
     end
   end
   do_end_tr(tr, (recorder == null) ? 0: recorder.get_handle());
   if (recorder != null) begin
     m_tr_h.delete(tr);
     tr.record(recorder);
     recorder.close(end_time);
     if (free_handle) begin
       recorder.free();
     end
   end
   e = event_pool.get("end_tr");
   if(e!=null) begin
     e.trigger();
   end
endfunction
function int uvm_component::record_error_tr (string stream_name="main",
                                                 uvm_object info=null,
                                                 string label="error_tr",
                                                 string desc="",
                                                 time   error_time=0,
                                                 bit    keep_active=0);
   uvm_recorder recorder;
   string etype;
   uvm_tr_stream stream;
   int handle;
   if(keep_active) begin
     etype = "Error, Link";
   end
   else begin
     etype = "Error";
   end
   if(error_time == 0) begin
     error_time = $realtime;
   end
   if (stream_name == "") begin
     stream_name = "main";
   end
   stream = get_tr_stream(stream_name, "TVM");
   handle = 0;
   if (stream != null) begin
     recorder = stream.open_recorder(label,
                                    error_time,
                                    etype);
     if (recorder != null) begin
       if (label != "") begin
         recorder.record_string("label", label);
       end
       if (desc != "") begin
         recorder.record_string("desc", desc);
       end
       if (info!=null) begin
         info.record(recorder);
       end
       recorder.close(error_time);
       if (keep_active == 0) begin
         recorder.free();
       end
       else begin
         handle = recorder.get_handle();
       end
     end
   end
   return handle;
endfunction
function int uvm_component::record_event_tr (string stream_name="main",
                                                 uvm_object info=null,
                                                 string label="event_tr",
                                                 string desc="",
                                                 time   event_time=0,
                                                 bit    keep_active=0);
   uvm_recorder recorder;
   string etype;
   int handle;
   uvm_tr_stream stream;
  if(keep_active) begin
    etype = "Event, Link";
  end
  else begin
    etype = "Event";
  end
   if(event_time == 0) begin
     event_time = $realtime;
   end
   if (stream_name == "") begin
     stream_name = "main";
   end
   stream = get_tr_stream(stream_name, "TVM");
   handle = 0;
   if (stream != null) begin
     recorder = stream.open_recorder(label,
                                    event_time,
                                    etype);
     if (recorder != null) begin
       if (label != "") begin
         recorder.record_string("label", label);
       end
       if (desc != "") begin
         recorder.record_string("desc", desc);
       end
       if (info!=null) begin
         info.record(recorder);
       end
       recorder.close(event_time);
       if (keep_active == 0) begin
         recorder.free();
       end
       else begin
         handle = recorder.get_handle();
       end
     end
   end
   return handle;
endfunction
function void uvm_component::do_accept_tr (uvm_transaction tr);
  return;
endfunction
function void uvm_component::do_begin_tr (uvm_transaction tr,
                                          string stream_name,
                                          int tr_handle);
  return;
endfunction
function void uvm_component::do_end_tr (uvm_transaction tr,
                                        int tr_handle);
  return;
endfunction
function string uvm_component::massage_scope(string scope);
  if(scope == "") begin
    return "^$";
  end
  if(scope == "*") begin
    return {get_full_name(), ".*"};
  end
  if(scope == "uvm_test_top") begin
    return "uvm_test_top";
  end
  if(scope[0] == ".") begin
    return {get_full_name(), scope};
  end
  return {get_full_name(), ".", scope};
endfunction
function uvm_component::config_mode_t uvm_component::apply_config_settings_mode();
  return CONFIG_DEFAULT;
endfunction : apply_config_settings_mode
function bit uvm_component::use_automatic_config();
  return 1;
endfunction
function void uvm_component::check_config_usage ( bit recurse=1 );
  uvm_resource_pool rp = uvm_resource_pool::get();
  uvm_queue#(uvm_resource_base) rq;
  rq = rp.find_unused_resources();
  if(rq.size() == 0) begin
    return;
  end
  uvm_report_info("CFGNRD"," ::: The following resources have at least one write and no reads :::",UVM_INFO);
  rp.print_resources(rq, 1);
endfunction
function void uvm_component::apply_config_settings (bit verbose=0);
  uvm_resource_types::rsrc_q_t all[string];
  string name_order[$];
  uvm_resource_pool rp = uvm_resource_pool::get();
  uvm_queue#(uvm_resource_base) rq;
  uvm_resource_base r;
  config_mode_t mode;
  mode = apply_config_settings_mode();
  if (mode & CONFIG_CHECK_NAMES) begin
    uvm_queue#(uvm_acs_name_struct) names;
    uvm_field_op op;
    names = new("names");
    op = uvm_field_op::m_get_available_op();
    op.set(UVM_CHECK_FIELDS, null, names);
    this.do_execute_op(op);
    op.m_recycle();
    while (names.size()) begin
      uvm_acs_name_struct s;
      s = names.pop_front();
      if (s.name != "") begin
        name_order.push_back(s.name);
        all[s.name] = rp.lookup_name(.scope(get_full_name()),
                                     .name(s.name),
                                     .type_handle(null),
                                     .rpterr(0));
        if(verbose) begin
          uvm_report_info("CFGAPL",$sformatf("looking up configuration for field %s (%0d resources)", s.name, all[s.name].size()),UVM_NONE);
        end
      end
      if (s.regex != "") begin
        rq = rp.lookup_regex(.re(s.regex),
                             .scope(get_full_name()));
        if(verbose) begin
          uvm_report_info("CFGAPL",$sformatf("looking up configuration for regex field %s (%0d resources)", s.regex, rq.size()),UVM_NONE);
        end
        for (int iter = 0; iter < rq.size(); iter++) begin
          string r_name;
          r = rq.get(iter);
          r_name = r.get_name();
          if (!all.exists(r_name)) begin
            all[r_name] = new(r_name);
            name_order.push_back(r_name);
          end
          all[r_name].push_back(r);
        end
      end
    end
  end
  else begin
    rq = rp.lookup_scope(get_full_name());
    while (rq.size()) begin
      string name;
      r = rq.pop_front();
      name = r.get_name();
      if (!all.exists(name)) begin
        name_order.push_back(name);
        all[name] = new(name);
      end
      all[name].push_back(r);
    end
  end
  foreach (name_order[iter]) begin
    rq = all[name_order[iter]];
    rp.sort_by_precedence(rq);
    if (mode & CONFIG_HIGHEST_PRECEDENCE) begin
      int unsigned precedence_by_handle[uvm_resource_base];
      uvm_resource_base type_handle;
      int idx;
      while (idx < rq.size()) begin
        r = rq.get(idx);
        type_handle = r.get_type_handle();
        if (type_handle == null) begin
          idx++;
        end
        else if (!precedence_by_handle.exists(type_handle)) begin
          if(verbose) begin
            uvm_report_info("CFGAPL",$sformatf("found high precedence (%0d) configuration to field %s", rp.get_precedence(r), r.get_name()),UVM_NONE);
          end
          precedence_by_handle[type_handle] = rp.get_precedence(r);
          idx++;
        end
        else begin
          if (rp.get_precedence(r) < precedence_by_handle[type_handle]) begin
            if(verbose) begin
              uvm_report_info("CFGAPL",$sformatf("skipping low precedence (%0d<%0d) configuration to field %s", rp.get_precedence(r), precedence_by_handle[type_handle], r.get_name()),UVM_NONE);
            end
            rq.delete(idx);
          end
          else begin
            if(verbose) begin
              uvm_report_info("CFGAPL",$sformatf("found matching high precedence (%0d) configuration to field %s", rp.get_precedence(r), r.get_name()),UVM_NONE);
            end
            idx++;
          end
        end
      end
    end
    for (int i=rq.size()-1; i>=0; --i) begin
      r = rq.get(i);
      if(verbose) begin
        uvm_report_info("CFGAPL",$sformatf("applying configuration to field %s", r.get_name()),UVM_NONE);
      end
      set_local(r);
    end
  end
endfunction
function void uvm_component::print_config(bit recurse = 0, audit = 0);
  uvm_resource_pool rp = uvm_resource_pool::get();
  uvm_report_info("CFGPRT","visible resources:",UVM_INFO);
  rp.print_resources(rp.lookup_scope(get_full_name()), audit);
  if(recurse) begin
    uvm_component c;
    foreach(m_children[name]) begin
      c = m_children[name];
      c.print_config(recurse, audit);
    end
  end
endfunction
function void uvm_component::print_config_with_audit(bit recurse = 0);
  print_config(recurse, 1);
endfunction
function bit uvm_component::get_recording_enabled();
   return (uvm_verbosity'(recording_detail) != UVM_NONE);
endfunction
function void uvm_component::print_config_settings (string field="",
                                                    uvm_component comp=null,
                                                    bit recurse=0);
  print_config(recurse, 1);
endfunction
function void uvm_component::set_recording_enabled(bit enabled);
   if (get_recording_enabled() != enabled) begin
     recording_detail = enabled ? UVM_LOW : UVM_NONE;
   end
endfunction
function void uvm_component::set_recording_enabled_hier(bit enabled);
  set_recording_enabled(enabled);
  foreach( m_children[c] ) begin
    m_children[c].set_recording_enabled_hier(enabled);
  end
endfunction
function void uvm_component::do_print(uvm_printer printer);
  super.do_print(printer);
  if(uvm_verbosity'(recording_detail) != UVM_NONE) begin
    case (recording_detail)
      UVM_LOW : begin
        printer.print_generic("recording_detail", "uvm_verbosity",
        $bits(recording_detail), "UVM_LOW");
      end
      UVM_MEDIUM : begin
        printer.print_generic("recording_detail", "uvm_verbosity",
        $bits(recording_detail), "UVM_MEDIUM");
      end
      UVM_HIGH : begin
        printer.print_generic("recording_detail", "uvm_verbosity",
        $bits(recording_detail), "UVM_HIGH");
      end
      UVM_FULL : begin
        printer.print_generic("recording_detail", "uvm_verbosity",
        $bits(recording_detail), "UVM_FULL");
      end
      default : begin
        printer.print_field_int("recording_detail", recording_detail,
        $bits(recording_detail), UVM_DEC, , "integral");
      end
    endcase
  end
endfunction
function void uvm_component::do_execute_op( uvm_field_op op );
    if (op.get_op_type == UVM_PRINT) begin
      uvm_component child_comp;
      string name;
      uvm_printer printer;
      if (!$cast(printer,op.get_policy())) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "INVPRINTOP") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "INVPRINTOP") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("INVPRINTOP", "do_execute_op() called with a field_op that has op_type UVM_PRINT but a policy that does not derive from uvm_printer", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 3500, "", 1);
     end
   end
      end
      else if (get_first_child(name)) begin
        do begin
          child_comp = get_child(name);
          if(child_comp.print_enabled) begin
            printer.print_object(name,child_comp);
          end
        end while (get_next_child(name));
      end
    end
    super.do_execute_op(op);
endfunction
function void uvm_component::set_local(uvm_resource_base rsrc) ;
  bit success;
  if((rsrc != null) && (rsrc.get_name() == "recording_detail")) begin
begin
begin
  uvm_resource#(uvm_integral_t) __tmp_rsrc__;
  success = $cast(__tmp_rsrc__, rsrc);
  if (success) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
  if (!success)
begin
  uvm_resource#(uvm_bitstream_t) __tmp_rsrc__;
  success = $cast(__tmp_rsrc__, rsrc);
  if (success) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
  if (!success)
begin
  uvm_resource#(int) __tmp_rsrc__;
  success = $cast(__tmp_rsrc__, rsrc);
  if (success) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
  if (!success)
begin
  uvm_resource#(int unsigned) __tmp_rsrc__;
  success = $cast(__tmp_rsrc__, rsrc);
  if (success) begin
    recording_detail = __tmp_rsrc__.read(this);
  end
end
end
  end
  if (!success) begin
    super.set_local(rsrc);
  end
endfunction
function void uvm_component::m_unsupported_set_local(uvm_resource_base rsrc);
  m_unsupported_resource_base = rsrc;
endfunction
typedef class uvm_cmdline_processor;
function void uvm_component::m_set_cl_msg_args;
  string s_;
  process p_;
  p_=process::self();
  if(p_!=null) begin
    s_=p_.get_randstate();
  end
  else begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "UVM") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "UVM") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("UVM", "run_test() invoked from a non process context", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_component.svh", 3570, "", 1);
     end
   end
  end
  m_set_cl_verb();
  m_set_cl_action();
  m_set_cl_sev();
  if(p_!=null) begin
    p_.set_randstate(s_);
  end
endfunction
function void uvm_component::m_set_cl_verb;
  string args[$];
  foreach(uvm_cmdline_set_verbosity::settings[i]) begin
    uvm_cmdline_set_verbosity setting;
    setting = uvm_cmdline_set_verbosity::settings[i];
    if (uvm_is_match(setting.comp, get_full_name()) ) begin
      if((setting.phase == "" || setting.phase == "build" ) ||
      (setting.phase == "time" && setting.offset == 0) ) begin
        setting.used[this] = 1;
        if(setting.id == "_ALL_") begin
          set_report_verbosity_level(setting.verbosity);
        end
        else begin
          set_report_id_verbosity(setting.id, setting.verbosity);
        end
      end
      else begin
        setting.used[this] = 0;
        if(setting.phase != "time") begin
          m_verbosity_settings.push_back(setting);
        end
      end
    end
  end
endfunction
function void uvm_component::m_set_cl_action;
  uvm_cmdline_set_action setting;
  foreach(uvm_cmdline_set_action::settings[i]) begin
    setting = uvm_cmdline_set_action::settings[i];
    if (!uvm_is_match(setting.comp, get_full_name()) ) begin
      continue;
    end
    setting.used[this] = 1;
    if(setting.id == "_ALL_") begin
      if(setting.all_sev) begin
        set_report_severity_action(UVM_INFO, setting.action);
        set_report_severity_action(UVM_WARNING, setting.action);
        set_report_severity_action(UVM_ERROR, setting.action);
        set_report_severity_action(UVM_FATAL, setting.action);
      end
      else begin
        set_report_severity_action(setting.sev, setting.action);
      end
    end
    else begin
      if(setting.all_sev) begin
        set_report_id_action(setting.id, setting.action);
      end
      else begin
        set_report_severity_id_action(setting.sev, setting.id, setting.action);
      end
    end
  end
endfunction
function void uvm_component::m_set_cl_sev;
  uvm_cmdline_set_severity setting;
  foreach(uvm_cmdline_set_severity::settings[i]) begin
    setting = uvm_cmdline_set_severity::settings[i];
    if (!uvm_is_match(setting.comp, get_full_name()) ) begin
      continue;
    end
    setting.used[this] = 1;
    if(setting.id == "_ALL_" && setting.all_sev) begin
      set_report_severity_override(UVM_INFO,setting.sev);
      set_report_severity_override(UVM_WARNING,setting.sev);
      set_report_severity_override(UVM_ERROR,setting.sev);
      set_report_severity_override(UVM_FATAL,setting.sev);
    end
    else if(setting.id == "_ALL_") begin
      set_report_severity_override(setting.orig_sev,setting.sev);
    end
    else if(setting.all_sev) begin
      set_report_severity_id_override(UVM_INFO,setting.id,setting.sev);
      set_report_severity_id_override(UVM_WARNING,setting.id,setting.sev);
      set_report_severity_id_override(UVM_ERROR,setting.id,setting.sev);
      set_report_severity_id_override(UVM_FATAL,setting.id,setting.sev);
    end
    else begin
      set_report_severity_id_override(setting.orig_sev,setting.id,setting.sev);
    end
  end
endfunction
function void uvm_component::m_apply_verbosity_settings(uvm_phase phase);
  uvm_cmdline_set_verbosity setting;
  uvm_cmdline_set_verbosity remaining_settings[$];
  foreach (m_verbosity_settings[i]) begin
    setting = m_verbosity_settings[i];
    if(phase.get_name() == setting.phase) begin
      setting.used[this] = 1;
      if(m_verbosity_settings[i].id == "_ALL_") begin
        set_report_verbosity_level(m_verbosity_settings[i].verbosity);
      end
      else begin
        set_report_id_verbosity(m_verbosity_settings[i].id, m_verbosity_settings[i].verbosity);
      end
    end
    else begin
      remaining_settings.push_back(setting);
    end
  end
  m_verbosity_settings = remaining_settings;
endfunction
function void uvm_component::m_do_pre_abort;
  foreach(m_children[i]) begin
    m_children[i].m_do_pre_abort();
  end
  pre_abort();
endfunction
function int uvm_component::begin_child_tr (uvm_transaction tr,
                                                int parent_handle=0,
                                                string stream_name="main",
                                                string label="",
                                                string desc="",
                                                time begin_time=0);
  return begin_tr(tr, stream_name, label, desc, begin_time, parent_handle);
endfunction
function void uvm_component::build();
  m_build_done = 1;
  if (use_automatic_config()) begin
    apply_config_settings(get_print_config_matches());
  end
endfunction
function void uvm_component::connect();             return; endfunction
function void uvm_component::start_of_simulation(); return; endfunction
function void uvm_component::end_of_elaboration();  return; endfunction
task          uvm_component::run();                 return; endtask
function void uvm_component::extract();             return; endfunction
function void uvm_component::check();               return; endfunction
function void uvm_component::report();              return; endfunction
`define UVM_OBJECTION_SVH
typedef class uvm_objection_context_object;
typedef class uvm_objection;
typedef class uvm_sequence_base;
typedef class uvm_objection_callback;
typedef uvm_callbacks #(uvm_objection,uvm_objection_callback) uvm_objection_cbs_t   ;
typedef class uvm_cmdline_processor;
class uvm_objection_events;
  int waiters;
  event raised;
  event dropped;
  event all_dropped;
endclass
class uvm_objection extends uvm_report_object;
  static local bit m_register_cb_uvm_objection_callback = uvm_callbacks#(uvm_objection,uvm_objection_callback)::m_register_pair("uvm_objection","uvm_objection_callback");
  protected bit     m_trace_mode;
  protected int     m_source_count[uvm_object];
  protected int     m_total_count [uvm_object];
  protected time    m_drain_time  [uvm_object];
  protected uvm_objection_events m_events [uvm_object];
    bit     m_top_all_dropped;
  protected uvm_root m_top;
  static uvm_objection m_objections[$];
  local static uvm_objection_context_object m_context_pool[$];
  local process m_drain_proc[uvm_object];
  local static uvm_objection_context_object m_scheduled_list[$];
  local uvm_objection_context_object m_scheduled_contexts[uvm_object];
  local uvm_objection_context_object m_forked_list[$];
  local uvm_objection_context_object m_forked_contexts[uvm_object];
  protected bit m_prop_mode = 1;
  protected bit m_cleared;
  function new(string name="");
    uvm_cmdline_processor clp;
    uvm_coreservice_t cs_ ;
    string trace_args[$];
    super.new(name);
    cs_ = uvm_coreservice_t::get();
    m_top  = cs_.get_root();
    set_report_verbosity_level(m_top.get_report_verbosity_level());
    clp = uvm_cmdline_processor::get_inst();
    if(clp.get_arg_matches("+UVM_OBJECTION_TRACE", trace_args))
      begin
        m_trace_mode=1;
      end
    m_objections.push_back(this);
  endfunction
   function bit trace_mode (int mode=-1);
    trace_mode = m_trace_mode;
    if(mode == 0)
      begin
        m_trace_mode = 0;
      end
    else if(mode == 1)
      begin
        m_trace_mode = 1;
      end
   endfunction
  function void m_report(uvm_object obj, uvm_object source_obj, string description, int count, string action);
    int _count = m_source_count.exists(obj) ? m_source_count[obj] : 0;
    int _total = m_total_count.exists(obj) ? m_total_count[obj] : 0;
    if (!uvm_report_enabled(UVM_NONE,UVM_INFO,"OBJTN_TRC") || !m_trace_mode)
      begin
        return;
      end
    if (source_obj == obj)
      begin
        uvm_report_info("OBJTN_TRC",
        $sformatf("Object %0s %0s %0d %0s objection(s)%s: count=%0d  total=%0d",
           obj.get_full_name()==""?"uvm_top":obj.get_full_name(), action,
           count, get_full_name(), description != ""? {" (",description,")"}:"", _count, _total), UVM_NONE);
      end
    else
      begin
        int cpath = 0, last_dot=0;
        string sname = source_obj.get_full_name(), nm = obj.get_full_name();
        int max = sname.len() > nm.len() ? nm.len() : sname.len();
        while((sname[cpath] == nm[cpath]) && (cpath < max))
        begin
          if(sname[cpath] == ".")
            begin
              last_dot = cpath;
            end
          cpath++;
        end
        if(last_dot)
          begin
            sname = sname.substr(last_dot+1, sname.len());
          end
        uvm_report_info("OBJTN_TRC",
        $sformatf("Object %0s %0s %0d %0s objection(s) %0s its total (%s from source object %s%s): count=%0d  total=%0d",
           obj.get_full_name()==""?"uvm_top":obj.get_full_name(), action=="raised"?"added":"subtracted",
            count, get_full_name(), action=="raised"?"to":"from", action, sname,
            description != ""?{", ",description}:"", _count, _total), UVM_NONE);
      end
  endfunction
  function uvm_object m_get_parent(uvm_object obj);
    uvm_component comp;
    uvm_sequence_base seq;
    if ($cast(comp, obj))
      begin
        obj = comp.get_parent();
      end
    else if ($cast(seq, obj))
      begin
        obj = seq.get_sequencer();
      end
    else
      begin
        obj = m_top;
      end
    if (obj == null)
      begin
        obj = m_top;
      end
    return obj;
  endfunction
  function void m_propagate (uvm_object obj,
                             uvm_object source_obj,
                             string description,
                             int count,
                             bit raise,
                             int in_top_thread);
    if (obj != null && obj != m_top)
      begin
        obj = m_get_parent(obj);
        if(raise)
        begin
          m_raise(obj, source_obj, description, count);
        end
        else
        begin
          m_drop(obj, source_obj, description, count, in_top_thread);
        end
      end
  endfunction
  function void set_propagate_mode (bit prop_mode);
     if (!m_top_all_dropped && (get_objection_total() != 0))
       begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/BASE/OBJTN/PROP_MODE") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/BASE/OBJTN/PROP_MODE") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/BASE/OBJTN/PROP_MODE", {"The propagation mode of '", this.get_full_name(), "' cannot be changed while the objection is raised ", "or draining!"}, uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_objection.svh", 318, "", 1);
     end
   end
         return;
       end
     m_prop_mode = prop_mode;
  endfunction : set_propagate_mode
  function bit get_propagate_mode();
     return m_prop_mode;
  endfunction : get_propagate_mode
  virtual function void raise_objection (uvm_object obj=null,
                                         string description="",
                                         int count=1);
    if(obj == null)
      begin
        obj = m_top;
      end
    m_cleared = 0;
    m_top_all_dropped = 0;
    m_raise (obj, obj, description, count);
  endfunction
  function void m_raise (uvm_object obj,
                         uvm_object source_obj,
                         string description="",
                         int count=1);
    int idx;
    uvm_objection_context_object ctxt;
    if (count == 0)
      begin
        return;
      end
    if (m_total_count.exists(obj))
      begin
        m_total_count[obj] += count;
      end
    else
      begin
        m_total_count[obj] = count;
      end
    if (source_obj==obj)
      begin
        if (m_source_count.exists(obj))
        begin
          m_source_count[obj] += count;
        end
        else
        begin
          m_source_count[obj] = count;
        end
      end
    if (m_trace_mode)
      begin
        m_report(obj,source_obj,description,count,"raised");
      end
    raised(obj, source_obj, description, count);
    idx = 0;
    while (idx < m_scheduled_list.size())
      begin
        if ((m_scheduled_list[idx].obj == obj) &&
        (m_scheduled_list[idx].objection == this))
        begin
          ctxt = m_scheduled_list[idx];
          m_scheduled_list.delete(idx);
          break;
        end
        idx++;
      end
    if (ctxt == null)
      begin
        idx = 0;
        while (idx < m_forked_list.size())
        begin
          if (m_forked_list[idx].obj == obj)
          begin
            ctxt = m_forked_list[idx];
            m_forked_list.delete(idx);
            m_scheduled_contexts.delete(ctxt.obj);
            break;
          end
          idx++;
        end
      end
    if (ctxt == null)
      begin
        if (m_forked_contexts.exists(obj))
        begin
          ctxt = m_forked_contexts[obj];
          m_forked_contexts.delete(obj);
          m_drain_proc[obj].kill();
          m_drain_proc.delete(obj);
        end
      end
    if (ctxt == null)
      begin
        if (!m_prop_mode && obj != m_top)
        begin
          m_raise(m_top,source_obj,description,count);
        end
        else if (obj != m_top)
        begin
          m_propagate(obj, source_obj, description, count, 1, 0);
        end
      end
    else
      begin
        int diff_count;
        diff_count = count - ctxt.count;
        if (diff_count != 0)
        begin
          if (diff_count > 0)
          begin
            if (!m_prop_mode && obj != m_top)
            begin
              m_raise(m_top, source_obj, description, diff_count);
            end
            else if (obj != m_top)
            begin
              m_propagate(obj, source_obj, description, diff_count, 1, 0);
            end
          end
          else
          begin
            diff_count = -diff_count;
            if (!m_prop_mode && obj != m_top)
            begin
              m_drop(m_top, source_obj, description, diff_count);
            end
            else if (obj != m_top)
            begin
              m_propagate(obj, source_obj, description, diff_count, 0, 0);
            end
          end
        end
        ctxt.clear();
        m_context_pool.push_back(ctxt);
      end
  endfunction
  virtual function void drop_objection (uvm_object obj=null,
                                        string description="",
                                        int count=1);
    if(obj == null)
      begin
        obj = m_top;
      end
    m_drop (obj, obj, description, count, 0);
  endfunction
  function void m_drop (uvm_object obj,
                        uvm_object source_obj,
                        string description="",
                        int count=1,
                        int in_top_thread=0);
    if (count == 0)
      begin
        return;
      end
    if (!m_total_count.exists(obj) || (count > m_total_count[obj]))
      begin
        if(m_cleared)
        begin
          return;
        end
        uvm_report_fatal("OBJTN_ZERO", {"Object \"", obj.get_full_name(),
        "\" attempted to drop objection '",this.get_name(),"' count below zero"});
        return;
      end
    if (obj == source_obj)
      begin
        if (!m_source_count.exists(obj) || (count > m_source_count[obj]))
        begin
          if(m_cleared)
          begin
            return;
          end
          uvm_report_fatal("OBJTN_ZERO", {"Object \"", obj.get_full_name(),
          "\" attempted to drop objection '",this.get_name(),"' count below zero"});
          return;
        end
        m_source_count[obj] -= count;
      end
    m_total_count[obj] -= count;
    if (m_trace_mode)
      begin
        m_report(obj,source_obj,description,count,"dropped");
      end
    dropped(obj, source_obj, description, count);
    if (m_total_count[obj] != 0)
      begin
        if (!m_prop_mode && obj != m_top)
        begin
          m_drop(m_top,source_obj,description, count, in_top_thread);
        end
        else if (obj != m_top)
        begin
          this.m_propagate(obj, source_obj, description, count, 0, in_top_thread);
        end
      end
    else
      begin
        uvm_objection_context_object ctxt;
        if (m_context_pool.size())
        begin
          ctxt = m_context_pool.pop_front();
        end
        else
        begin
          ctxt = new;
        end
        ctxt.obj = obj;
        ctxt.source_obj = source_obj;
        ctxt.description = description;
        ctxt.count = count;
        ctxt.objection = this;
        m_scheduled_list.push_back(ctxt);
      end
  endfunction
  virtual function void clear(uvm_object obj=null);
    string name;
    int  idx;
    if (obj==null)
      begin
        obj=m_top;
      end
    name = obj.get_full_name();
    if (name == "")
      begin
        name = "uvm_top";
      end
    else
      begin
        name = obj.get_full_name();
      end
    if (!m_top_all_dropped && get_objection_total(m_top))
      begin
        uvm_report_warning("OBJTN_CLEAR",{"Object '",name,
            "' cleared objection counts for ",get_name()});
      end
    m_source_count.delete();
    m_total_count.delete();
    idx = 0;
    while (idx < m_scheduled_list.size())
      begin
        if (m_scheduled_list[idx].objection == this)
        begin
          m_scheduled_list[idx].clear();
          m_context_pool.push_back(m_scheduled_list[idx]);
          m_scheduled_list.delete(idx);
        end
        else
        begin
          idx++;
        end
      end
    m_scheduled_contexts.delete();
    while (m_forked_list.size())
      begin
        m_forked_list[0].clear();
        m_context_pool.push_back(m_forked_list[0]);
        void'(m_forked_list.pop_front());
      end
    foreach (m_forked_contexts[o])
      begin
        m_drain_proc[o].kill();
        m_drain_proc.delete(o);
        m_forked_contexts[o].clear();
        m_context_pool.push_back(m_forked_contexts[o]);
        m_forked_contexts.delete(o);
      end
    m_top_all_dropped = 0;
    m_cleared = 1;
    if (m_events.exists(m_top))
      begin
        ->m_events[m_top].all_dropped;
      end
  endfunction
  static task m_execute_scheduled_forks();
    while(1)
      begin
        wait(m_scheduled_list.size() != 0);
        if(m_scheduled_list.size() != 0)
          begin
            uvm_objection_context_object c;
            c = m_scheduled_list.pop_front();
            c.objection.m_scheduled_contexts[c.obj] = c;
            c.objection.m_forked_list.push_back(c);
            fork : guard
              automatic uvm_objection objection = c.objection;
              begin
                if (objection.m_forked_list.size() > 0)
                  begin
                    uvm_objection_context_object ctxt;
                    ctxt = objection.m_forked_list.pop_front();
                    objection.m_scheduled_contexts.delete(ctxt.obj);
                    objection.m_forked_contexts[ctxt.obj] = ctxt;
                    objection.m_drain_proc[ctxt.obj] = process::self();
                    objection.m_forked_drain(ctxt.obj, ctxt.source_obj, ctxt.description, ctxt.count, 1);
                    objection.m_drain_proc.delete(ctxt.obj);
                    objection.m_forked_contexts.delete(ctxt.obj);
                    ctxt.clear();
                    m_context_pool.push_back(ctxt);
                  end
              end
            join_none : guard
          end
      end
  endtask
  task m_forked_drain (uvm_object obj,
                       uvm_object source_obj,
                       string description="",
                       int count=1,
                       int in_top_thread=0);
      if (m_drain_time.exists(obj))
        begin
          #(m_drain_time[obj]);
        end
      if (m_trace_mode)
        begin
          m_report(obj,source_obj,description,count,"all_dropped");
        end
      all_dropped(obj,source_obj,description, count);
      wait fork;
      if (m_source_count.exists(obj) && m_source_count[obj] == 0)
        begin
          m_source_count.delete(obj);
        end
      if (m_total_count.exists(obj) && m_total_count[obj] == 0)
        begin
          m_total_count.delete(obj);
        end
      if (!m_prop_mode && obj != m_top)
        begin
          m_drop(m_top,source_obj,description, count, 1);
        end
      else if (obj != m_top)
        begin
          m_propagate(obj, source_obj, description, count, 0, 1);
        end
  endtask
  static function void m_init_objections();
    fork
      begin
        uvm_objection::m_execute_scheduled_forks();
      end
    join_none
  endfunction
  function void set_drain_time (uvm_object obj=null, time drain);
    if (obj==null)
      begin
        obj = m_top;
      end
    m_drain_time[obj] = drain;
  endfunction
  virtual function void raised (uvm_object obj,
                                uvm_object source_obj,
                                string description,
                                int count);
    uvm_component comp;
    if ($cast(comp,obj))
      begin
        comp.raised(this, source_obj, description, count);
      end
   begin
     uvm_callback_iter#(uvm_objection,uvm_objection_callback) iter = new(this);
     uvm_objection_callback cb = iter.first();
     while(cb != null) begin
       cb.raised(this,obj,source_obj,description,count);
       cb = iter.next();
     end
   end
    if (m_events.exists(obj))
      begin
        ->m_events[obj].raised;
      end
  endfunction
  virtual function void dropped (uvm_object obj,
                                 uvm_object source_obj,
                                 string description,
                                 int count);
    uvm_component comp;
    if($cast(comp,obj))
      begin
        comp.dropped(this, source_obj, description, count);
      end
   begin
     uvm_callback_iter#(uvm_objection,uvm_objection_callback) iter = new(this);
     uvm_objection_callback cb = iter.first();
     while(cb != null) begin
       cb.dropped(this,obj,source_obj,description,count);
       cb = iter.next();
     end
   end
    if (m_events.exists(obj))
      begin
        ->m_events[obj].dropped;
      end
  endfunction
  virtual task all_dropped (uvm_object obj,
                            uvm_object source_obj,
                            string description,
                            int count);
    uvm_component comp;
    if($cast(comp,obj))
      begin
        comp.all_dropped(this, source_obj, description, count);
      end
   begin
     uvm_callback_iter#(uvm_objection,uvm_objection_callback) iter = new(this);
     uvm_objection_callback cb = iter.first();
     while(cb != null) begin
       cb.all_dropped(this,obj,source_obj,description,count);
       cb = iter.next();
     end
   end
    if (m_events.exists(obj))
      begin
        ->m_events[obj].all_dropped;
      end
    if (obj == m_top)
      begin
        m_top_all_dropped = 1;
      end
  endtask
  function void get_objectors(ref uvm_object list[$]);
    list.delete();
    foreach (m_source_count[obj])
      begin
        list.push_back(obj);
      end
  endfunction
  task wait_for(uvm_objection_event objt_event, uvm_object obj=null);
     if (obj==null)
       begin
         obj = m_top;
       end
     if (!m_events.exists(obj))
       begin
         m_events[obj] = new;
       end
     m_events[obj].waiters++;
     case (objt_event)
       UVM_RAISED:
         begin
           @(m_events[obj].raised);
         end
       UVM_DROPPED:
         begin
           @(m_events[obj].dropped);
         end
       UVM_ALL_DROPPED:
         begin
           @(m_events[obj].all_dropped);
         end
     endcase
     m_events[obj].waiters--;
     if (m_events[obj].waiters == 0)
       begin
         m_events.delete(obj);
       end
   endtask
   task wait_for_total_count(uvm_object obj=null, int count=0);
     if (obj==null)
       begin
         obj = m_top;
       end
     if(!m_total_count.exists(obj) && count == 0)
       begin
         return;
       end
     if (count == 0)
       begin
         wait (!m_total_count.exists(obj) && count == 0);
       end
     else
       begin
         wait (m_total_count.exists(obj) && m_total_count[obj] == count);
       end
   endtask
  function int get_objection_count (uvm_object obj=null);
    if (obj==null)
      begin
        obj = m_top;
      end
    if (!m_source_count.exists(obj))
      begin
        return 0;
      end
    return m_source_count[obj];
  endfunction
  function int get_objection_total (uvm_object obj=null);
    if (obj==null)
      begin
        obj = m_top;
      end
    if (!m_total_count.exists(obj))
      begin
        return 0;
      end
    else
      begin
        return m_total_count[obj];
      end
  endfunction
  function time get_drain_time (uvm_object obj=null);
    if (obj==null)
      begin
        obj = m_top;
      end
    if (!m_drain_time.exists(obj))
      begin
        return 0;
      end
    return m_drain_time[obj];
  endfunction
  protected function string m_display_objections(uvm_object obj=null, bit show_header=1);
    static string blank="                                                                                   ";
    string s;
    int total;
    uvm_object list[string];
    uvm_object curr_obj;
    int depth;
    string name;
    string this_obj_name;
    string curr_obj_name;
    foreach (m_total_count[o])
      begin
        uvm_object theobj = o;
        if ( m_total_count[o] > 0)
        begin
          list[theobj.get_full_name()] = theobj;
        end
      end
    if (obj==null)
      begin
        obj = m_top;
      end
    total = get_objection_total(obj);
    s = $sformatf("The total objection count is %0d\n",total);
    if (total == 0)
      begin
        return s;
      end
    s = {s,"---------------------------------------------------------\n"};
    s = {s,"Source  Total   \n"};
    s = {s,"Count   Count   Object\n"};
    s = {s,"---------------------------------------------------------\n"};
    this_obj_name = obj.get_full_name();
    curr_obj_name = this_obj_name;
    do
      begin
        curr_obj = list[curr_obj_name];
        depth=0;
        foreach (curr_obj_name[i])
        begin
          if (curr_obj_name[i] == ".")
          begin
            depth++;
          end
        end
        name = curr_obj_name;
        for (int i=curr_obj_name.len()-1;i >= 0; i--)
        begin
          if (curr_obj_name[i] == ".")
            begin
              name = curr_obj_name.substr(i+1,curr_obj_name.len()-1);
              break;
            end
        end
        if (curr_obj_name == "")
        begin
          name = "uvm_top";
        end
        else
        begin
          depth++;
        end
        s = {s, $sformatf("%-6d  %-6d %s%s\n",
         m_source_count.exists(curr_obj) ? m_source_count[curr_obj] : 0,
         m_total_count.exists(curr_obj) ? m_total_count[curr_obj] : 0,
         blank.substr(0,2*depth), name)};
      end while (list.next(curr_obj_name) &&
        curr_obj_name.substr(0,this_obj_name.len()-1) == this_obj_name);
    s = {s,"---------------------------------------------------------\n"};
    return s;
  endfunction
  function string convert2string();
    return m_display_objections(m_top,1);
  endfunction
  function void display_objections(uvm_object obj=null, bit show_header=1);
    string m = m_display_objections(obj,show_header);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/OBJ/DISPLAY") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/OBJ/DISPLAY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/OBJ/DISPLAY", m, UVM_NONE, "t/uvm/src/base/uvm_objection.svh", 1319, "", 1);
     end
   end
  endfunction
  typedef uvm_object_registry#(uvm_objection,"uvm_objection") type_id;
  static function type_id get_type();
    return type_id::get();
  endfunction
  function uvm_object create (string name="");
    uvm_objection tmp = new(name);
    return tmp;
  endfunction
  virtual function string get_type_name ();
    return "uvm_objection";
  endfunction
  function void do_copy (uvm_object rhs);
    uvm_objection _rhs;
    $cast(_rhs, rhs);
    m_source_count = _rhs.m_source_count;
    m_total_count  = _rhs.m_total_count;
    m_drain_time   = _rhs.m_drain_time;
    m_prop_mode    = _rhs.m_prop_mode;
  endfunction
  function void m_set_hier_mode (uvm_object obj);
  endfunction
endclass
typedef class uvm_cmdline_processor;
class uvm_objection_context_object;
    uvm_object obj;
    uvm_object source_obj;
    string description;
    int    count;
    uvm_objection objection;
    function void clear();
        obj = null;
        source_obj = null;
        description = "";
        count = 0;
        objection = null;
    endfunction : clear
endclass
typedef uvm_objection uvm_callbacks_objection;
class uvm_objection_callback extends uvm_callback;
  function new(string name);
    super.new(name);
  endfunction
  virtual function void raised (uvm_objection objection, uvm_object obj,
      uvm_object source_obj, string description, int count);
  endfunction
  virtual function void dropped (uvm_objection objection, uvm_object obj,
      uvm_object source_obj, string description, int count);
  endfunction
  virtual task all_dropped (uvm_objection objection, uvm_object obj,
      uvm_object source_obj, string description, int count);
  endtask
endclass
class uvm_test_done_objection extends uvm_objection;
   protected static uvm_test_done_objection m_inst;
  protected bit m_forced;
  local  bit m_executing_stop_processes;
  local  int m_n_stop_threads;
  function new(string name="uvm_test_done");
    super.new(name);
  endfunction
  virtual function void qualify(uvm_object obj=null,
                                bit is_raise,
                                string description);
    uvm_component c;
    uvm_sequence_base s;
    string nm = is_raise ? "raise_objection" : "drop_objection";
    string desc = description == "" ? "" : {" (\"", description, "\")"};
    if(! ($cast(c,obj) || $cast(s,obj)))
      begin
        uvm_report_error("TEST_DONE_NOHIER", {"A non-hierarchical object, '",
        obj.get_full_name(), "' (", obj.get_type_name(),") was used in a call ",
        "to uvm_test_done.", nm,"(). For this objection, a sequence ",
        "or component is required.", desc });
      end
  endfunction
  typedef uvm_object_registry#(uvm_test_done_objection,"uvm_test_done") type_id;
  static function type_id get_type();
    return type_id::get();
  endfunction
  function uvm_object create (string name="");
    uvm_test_done_objection tmp = new(name);
    return tmp;
  endfunction
  virtual function string get_type_name ();
    return "uvm_test_done";
  endfunction
  static function uvm_test_done_objection get();
    if(m_inst == null)
      begin
        m_inst = uvm_test_done_objection::type_id::create("run");
      end
    return m_inst;
  endfunction
endclass
`define UVM_HEARTBEAT_SVH
typedef enum {
  UVM_ALL_ACTIVE,
  UVM_ONE_ACTIVE,
  UVM_ANY_ACTIVE,
  UVM_NO_HB_MODE
} uvm_heartbeat_modes;
typedef class uvm_heartbeat_callback;
typedef uvm_callbacks #(uvm_objection,uvm_heartbeat_callback) uvm_heartbeat_cbs_t;
typedef class uvm_objection_callback;
class uvm_heartbeat extends uvm_object;
  protected uvm_objection m_objection;
  protected uvm_heartbeat_callback m_cb;
  protected uvm_component   m_cntxt;
  protected uvm_heartbeat_modes   m_mode;
  protected uvm_component   m_hblist[$];
  protected uvm_event#(uvm_object)       m_event;
  protected bit             m_started;
  protected event           m_stop_event;
  function new(string name, uvm_component cntxt, uvm_objection objection=null);
     uvm_coreservice_t cs;
    super.new(name);
    m_objection = objection;
    cs  = uvm_coreservice_t::get();
    if(cntxt != null) begin
      m_cntxt = cntxt;
    end
    else begin
      m_cntxt = cs.get_root();
    end
    m_cb = new({name,"_cb"},m_cntxt);
  endfunction
  function uvm_heartbeat_modes set_mode (uvm_heartbeat_modes mode = UVM_NO_HB_MODE);
    set_mode = m_mode;
    if(mode == UVM_ANY_ACTIVE || mode == UVM_ONE_ACTIVE || mode == UVM_ALL_ACTIVE) begin
      m_mode = mode;
    end
  endfunction
  function void set_heartbeat (uvm_event#(uvm_object) e, ref uvm_component comps[$]);
    uvm_object c;
    foreach(comps[i]) begin
      c = comps[i];
      if(!m_cb.cnt.exists(c)) begin
        m_cb.cnt[c]=0;
      end
      if(!m_cb.last_trigger.exists(c)) begin
        m_cb.last_trigger[c]=0;
      end
    end
    if(e==null && m_event==null) begin
      return;
    end
    start(e);
  endfunction
  function void add (uvm_component comp);
    uvm_object c = comp;
    if(m_cb.cnt.exists(c)) begin
      return;
    end
    m_cb.cnt[c]=0;
    m_cb.last_trigger[c]=0;
  endfunction
  function void remove (uvm_component comp);
    uvm_object c = comp;
    if(m_cb.cnt.exists(c)) begin
      m_cb.cnt.delete(c);
    end
    if(m_cb.last_trigger.exists(c)) begin
      m_cb.last_trigger.delete(c);
    end
  endfunction
  function void start (uvm_event#(uvm_object) e=null);
    if(m_event == null && e == null) begin
      m_cntxt.uvm_report_warning("NOEVNT", { "start() was called for: ",
        get_name(), " with a null trigger and no currently set trigger" },
        UVM_NONE);
      return;
    end
    if((m_event != null) && (e != m_event) && m_started) begin
      m_cntxt.uvm_report_error("ILHBVNT", { "start() was called for: ",
        get_name(), " with trigger ", e.get_name(), " which is different ",
        "from the original trigger ", m_event.get_name() }, UVM_NONE);
      return;
    end
    if(e != null) begin
      m_event = e;
    end
    m_enable_cb();
    m_start_hb_process();
  endfunction
  function void stop ();
    m_started = 0;
    ->m_stop_event;
    m_disable_cb();
  endfunction
  function void m_start_hb_process();
    if(m_started) begin
      return;
    end
    m_started = 1;
    fork
      begin
        m_hb_process;
      end
    join_none
  endfunction
  protected bit m_added;
  function void m_enable_cb;
    void'(m_cb.callback_mode(1));
    if(m_objection == null) begin
      return;
    end
    if(!m_added) begin
      uvm_heartbeat_cbs_t::add(m_objection, m_cb);
    end
    m_added = 1;
  endfunction
  function void m_disable_cb;
    void'(m_cb.callback_mode(0));
  endfunction
  task m_hb_process;
    uvm_object obj;
    bit  triggered;
    time last_trigger=0;
    fork
      begin
        while(1) begin
          m_event.wait_trigger();
          if(triggered) begin
            case (m_mode)
              UVM_ALL_ACTIVE: begin
                foreach(m_cb.cnt[idx]) begin
                  obj = idx;
                  if(!m_cb.cnt[obj]) begin
                    m_cntxt.uvm_report_fatal("HBFAIL", $sformatf("Did not recieve an update of %s for component %s since last event trigger at time %0t : last update time was %0t",
                        m_objection.get_name(), obj.get_full_name(),
                        last_trigger, m_cb.last_trigger[obj]), UVM_NONE);
                  end
                end
              end
              UVM_ANY_ACTIVE: begin
                if(m_cb.cnt.num() && !m_cb.objects_triggered()) begin
                  string s;
                  foreach(m_cb.cnt[idx]) begin
                    obj = idx;
                    s={s,"\n  ",obj.get_full_name()};
                  end
                  m_cntxt.uvm_report_fatal("HBFAIL", $sformatf("Did not recieve an update of %s on any component since last event trigger at time %0t. The list of registered components is:%s",
                      m_objection.get_name(), last_trigger, s), UVM_NONE);
                end
              end
              UVM_ONE_ACTIVE: begin
                if(m_cb.objects_triggered() > 1) begin
                  string s;
                  foreach(m_cb.cnt[idx])  begin
                    obj = idx;
                    if(m_cb.cnt[obj]) begin
                      $swrite(s,"%s\n  %s (updated: %0t)",
                         s, obj.get_full_name(), m_cb.last_trigger[obj]);
                    end
                  end
                  m_cntxt.uvm_report_fatal("HBFAIL", $sformatf("Recieved update of %s from more than one component since last event trigger at time %0t. The list of triggered components is:%s",
                      m_objection.get_name(), last_trigger, s), UVM_NONE);
                end
                if(m_cb.cnt.num() && !m_cb.objects_triggered()) begin
                  string s;
                  foreach(m_cb.cnt[idx]) begin
                    obj = idx;
                    s={s,"\n  ",obj.get_full_name()};
                  end
                  m_cntxt.uvm_report_fatal("HBFAIL", $sformatf("Did not recieve an update of %s on any component since last event trigger at time %0t. The list of registered components is:%s",
                      m_objection.get_name(), last_trigger, s), UVM_NONE);
                end
              end
            endcase
          end
          m_cb.reset_counts();
          last_trigger = $realtime;
          triggered = 1;
        end
      end
      begin
        @(m_stop_event);
      end
    join_any
    disable fork;
  endtask
endclass
class uvm_heartbeat_callback extends uvm_objection_callback;
  int  cnt [uvm_object];
  time last_trigger [uvm_object];
  uvm_object target;
  uvm_coreservice_t cs = uvm_coreservice_t::get();
  function new(string name, uvm_object target);
    super.new(name);
    if (target != null) begin
      this.target = target;
    end
    else begin
      this.target = cs.get_root();
    end
  endfunction
  virtual function void raised (uvm_objection objection,
                                uvm_object obj,
                                uvm_object source_obj,
                                string description,
                                int count);
    if(obj == target) begin
      if(!cnt.exists(source_obj)) begin
        cnt[source_obj] = 0;
      end
      cnt[source_obj] = cnt[source_obj]+1;
      last_trigger[source_obj] = $realtime;
    end
  endfunction
  virtual function void dropped (uvm_objection objection,
                                 uvm_object obj,
                                 uvm_object source_obj,
                                 string description,
                                 int count);
    raised(objection,obj,source_obj,description,count);
  endfunction
  function void reset_counts;
    foreach(cnt[i]) begin
      cnt[i] = 0;
    end
  endfunction
  function int objects_triggered;
    objects_triggered = 0;
    foreach(cnt[i]) begin
      if (cnt[i] != 0) begin
        objects_triggered++;
      end
    end
  endfunction
endclass
class uvm_cmd_line_verb;
  string comp_path;
  string id;
  uvm_verbosity verb;
  int exec_time;
endclass
typedef class uvm_cmdline_processor;
uvm_cmdline_processor uvm_cmdline_proc;
class uvm_cmdline_processor extends uvm_report_object;
  static local uvm_cmdline_processor m_inst;
  static function uvm_cmdline_processor get_inst();
    if(m_inst == null) begin
      m_inst = new("uvm_cmdline_proc");
    end
    uvm_cmdline_proc = m_inst;
    return m_inst;
  endfunction
  protected string m_argv[$];
  protected string m_plus_argv[$];
  protected string m_uvm_argv[$];
  function void get_args (output string args[$]);
    args = m_argv;
  endfunction
  function void get_plusargs (output string args[$]);
    args = m_plus_argv;
  endfunction
  function void get_uvm_args (output string args[$]);
    args = m_uvm_argv;
  endfunction
  function int get_arg_matches (string match, ref string args[$]);
    bit match_is_regex = (match.len() > 2) && (match[0] == "/") && (match[match.len()-1] == "/");
    int len = match.len();
    args.delete();
    foreach (m_argv[i]) begin
      if ( match_is_regex && uvm_is_match( match, m_argv[i] ) ) begin
        args.push_back( m_argv[i] );
      end
      else if((m_argv[i].len() >= len) && (m_argv[i].substr(0,len - 1) == match)) begin
        args.push_back(m_argv[i]);
      end
    end
    return args.size();
  endfunction
  function int get_arg_value (string match, ref string value);
    int chars = match.len();
    get_arg_value = 0;
    foreach (m_argv[i]) begin
      if(m_argv[i].len() >= chars) begin
        if(m_argv[i].substr(0,chars-1) == match) begin
          get_arg_value++;
          if(get_arg_value == 1) begin
            value = m_argv[i].substr(chars,m_argv[i].len()-1);
          end
        end
      end
    end
  endfunction
  function int get_arg_values (string match, ref string values[$]);
    int chars = match.len();
    values.delete();
    foreach (m_argv[i]) begin
      if(m_argv[i].len() >= chars) begin
        if(m_argv[i].substr(0,chars-1) == match) begin
          values.push_back(m_argv[i].substr(chars,m_argv[i].len()-1));
        end
      end
    end
    return values.size();
  endfunction
  function string get_tool_name ();
    return uvm_dpi_get_tool_name();
  endfunction
  function string  get_tool_version ();
    return uvm_dpi_get_tool_version();
  endfunction
  function new(string name = "");
    string s;
    string sub;
    int doInit=1;
    super.new(name);
    do
      begin
        s = uvm_dpi_get_next_arg(doInit);
        doInit=0;
        if(s!="") begin
          m_argv.push_back(s);
          if(s[0] == "+") begin
            m_plus_argv.push_back(s);
          end
          if(s.len() >= 4 && (s[0]=="-" || s[0]=="+")) begin
            sub = s.substr(1,3);
            sub = sub.toupper();
            if(sub == "UVM") begin
              m_uvm_argv.push_back(s);
            end
          end
        end
      end
    while(s!="");
  endfunction
endclass
class uvm_cmdline_setting_base;
  string    arg;
  bit used[uvm_component];
endclass : uvm_cmdline_setting_base
class uvm_cmdline_verbosity extends uvm_cmdline_setting_base;
  int verbosity;
  enum {STANDARD, NON_STANDARD, ILLEGAL} src;
  localparam  string prefix = "+UVM_VERBOSITY=";
  static uvm_cmdline_verbosity settings[$];
  static function void init(input uvm_report_object ro);
    string  setting_str[$];
    int     verbosity;
    int     verb_count;
    string  verb_string;
    bit     skip;
    uvm_cmdline_processor clp = uvm_cmdline_processor::get_inst();
    verb_count = $value$plusargs("UVM_VERBOSITY=%s", verb_string);
    if (verb_count)
      setting_str.push_back(verb_string);
    foreach(setting_str[i]) begin
      uvm_cmdline_verbosity setting;
      uvm_verbosity temp_verb;
      setting = new();
      setting.arg = setting_str[i];
      setting.src = STANDARD;
      if (!uvm_string_to_verbosity(setting_str[i], temp_verb)) begin
        int code;
        code = $sscanf(setting_str[i], "%d", setting.verbosity);
        if (code > 0) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "NSTVERB") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "NSTVERB") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_info("NSTVERB", $sformatf("Non-standard verbosity value '%s', converted to '%0d'.", setting_str[i], verbosity), UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 86, "", 1);
     end
   end
          setting.src = NON_STANDARD;
        end
        else begin
          setting.verbosity = UVM_MEDIUM;
          setting.src = ILLEGAL;
        end
      end
      else begin
        setting.verbosity = temp_verb;
      end
      settings.push_back(setting);
    end
  endfunction : init
  static function void check(uvm_report_object ro);
    string verb_q[$];
    foreach (settings[i]) begin
      if (settings[i].src == ILLEGAL) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "ILLVERB") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "ILLVERB") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("ILLVERB", $sformatf("Illegal verbosity value '%s', converted to default of UVM_MEDIUM.", settings[i].arg), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 115, "", 1);
     end
   end
      end
      if (i != 0) begin
        verb_q.push_back(", ");
      end
      verb_q.push_back(settings[i].arg);
    end
    if (settings.size() > 1) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "MULTVERB") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "MULTVERB") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("MULTVERB", $sformatf("Multiple (%0d) +UVM_VERBOSITY arguments provided on the command line.  '%s' will be used.  Provided list: %s.", settings.size(), settings[0].arg, uvm_pkg::m_uvm_string_queue_join(verb_q)), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 131, "", 1);
     end
   end;
    end
  endfunction : check
  static function string dump();
    string msgs[$];
    int    tmp_verb;
    foreach (settings[i]) begin
      msgs.push_back($sformatf("\n%s%s: ", prefix, settings[i].arg));
      if (i == 0) begin
        msgs.push_back("Applied");
      end
      else begin
        msgs.push_back("Not applied (not first on command line)");
      end
      if (settings[i].src == NON_STANDARD) begin
        msgs.push_back($sformatf(", converted as non-standard to '%0d'", settings[i].verbosity));
      end
      else if (settings[i].src == ILLEGAL) begin
        msgs.push_back(", converted as ILLEGAL to UVM_MEDIUM");
      end
    end
    return uvm_pkg::m_uvm_string_queue_join(msgs);
  endfunction : dump
endclass : uvm_cmdline_verbosity
class uvm_cmdline_set_verbosity extends uvm_cmdline_setting_base;
  string    comp;
  string    id;
  int       verbosity;
  string    phase;
  time      offset;
  localparam  string prefix = "+uvm_set_verbosity=";
  static uvm_cmdline_set_verbosity settings[$];
  static function void init(input uvm_report_object ro);
    string  setting_str[$];
    uvm_cmdline_processor clp = uvm_cmdline_processor::get_inst();
    if (clp.get_arg_values(prefix, setting_str) > 0) begin
      uvm_verbosity temp_verb;
      string  args[$];
      string  message;
      bit     skip;
      foreach(setting_str[i]) begin
        skip = 0;
        uvm_string_split(setting_str[i], ",", args);
        if (args.size() < 4 || args.size() > 5) begin
          message = "Invalid number of arguments found, expected 4 or 5";
          skip = 1;
        end
        if (args.size() == 5 && args[3] != "time") begin
          message = "Too many arguments found for <phase>, expected only 4";
          skip = 1;
        end
        if (args.size() == 4 && args[3] == "time") begin
          message = "Too few arguments found for <time>, expected 5";
          skip = 1;
        end
        if (!uvm_string_to_verbosity(args[2], temp_verb)) begin
          message = "Invalid verbosity found";
          skip = 1;
        end
        if (!skip) begin
          int rt_val;
          uvm_cmdline_set_verbosity setting;
          setting = new();
          setting.arg = setting_str[i];
          setting.comp = args[0];
          setting.id = args[1];
          setting.verbosity = temp_verb;
          setting.phase = args[3];
          if (setting.phase == "time") begin
            rt_val = $sscanf(args[4], "%d", setting.offset);
          end
          else begin
            setting.offset = 0;
          end
          settings.push_back(setting);
        end
        else if (ro != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("%s, setting '%s%s' will be ignored.", message, prefix, setting_str[i]), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 246, "", 1);
     end
   end
        end
      end
    end
  endfunction : init
  static function void check(uvm_report_object ro);
    foreach (settings[i]) begin
      if (settings[i].used.size() == 0) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("\"%s%s\" never took effect due to either a mismatching component pattern.", prefix, settings[i].arg), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 268, "", 1);
     end
   end
      end
      else begin
        if (settings[i].phase == "time") begin
          if ($time < settings[i].offset) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("\"%s%s\" never took effect due to test ending before offset was reached.", prefix, settings[i].arg), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 278, "", 1);
     end
   end
          end
        end
        else begin
          bit hit;
          uvm_cmdline_set_verbosity setting;
          setting = settings[i];
          foreach (setting.used[i]) begin
            if (setting.used[i]) begin
              hit = 1;
              break;
            end
          end
          if (!hit) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("\"%s%s\" never took effect due to phase never occurring for matching component(s).", prefix, settings[i].arg), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 298, "", 1);
     end
   end
          end
        end
      end
    end
  endfunction : check
  static function string dump();
    string msgs[$];
    uvm_component sorted_list[$];
    foreach (settings[i]) begin
      uvm_cmdline_set_verbosity setting;
      setting = settings[i];
      msgs.push_back($sformatf("\n%s%s", prefix, setting.arg));
      msgs.push_back("\n  matching components:");
      if (setting.used.size() == 0) begin
        msgs.push_back("\n    <none>");
      end
      else begin
        sorted_list.delete();
        foreach (setting.used[j]) begin
          sorted_list.push_back(j);
        end
        sorted_list.sort() with ( item.get_full_name() );
        foreach (sorted_list[j]) begin
          string full_name;
          full_name = sorted_list[j].get_full_name();
          if (full_name == "") begin
            full_name = "<uvm_root>";
          end
          msgs.push_back("\n    ");
          msgs.push_back(full_name);
          msgs.push_back(": ");
          if ((setting.phase == "time" && setting.used[sorted_list[j]]) ||
          (setting.phase != "time" && setting.used[sorted_list[j]])) begin
            msgs.push_back("Applied");
          end
          else begin
            msgs.push_back("Not applied ");
            if (setting.phase == "time") begin
              msgs.push_back("(component never reached offset)");
            end
            else begin
              msgs.push_back("(component never saw phase)");
            end
          end
        end
      end
    end
    return uvm_pkg::m_uvm_string_queue_join(msgs);
  endfunction : dump
endclass
class uvm_cmdline_set_action extends uvm_cmdline_setting_base;
  string    comp;
  string    id;
  bit       all_sev;
  uvm_severity sev;
  uvm_action action;
  localparam  string prefix = "+uvm_set_action=";
  static uvm_cmdline_set_action settings[$];
  static function void init(input uvm_report_object ro);
    string  setting_str[$];
    uvm_cmdline_processor clp = uvm_cmdline_processor::get_inst();
    if (clp.get_arg_values(prefix, setting_str) > 0) begin
      uvm_action action;
      uvm_severity sev;
      string  args[$];
      string  message;
      bit     skip;
      foreach(setting_str[i]) begin
        skip = 0;
        uvm_string_split(setting_str[i], ",", args);
        if (args.size() != 4) begin
          message = "Invalid number of arguments found, expected 4";
          skip = 1;
        end
        if (args[2] != "_ALL_" && !uvm_string_to_severity(args[2], sev)) begin
          message = $sformatf("Bad severity argument '%s'", args[2]);
          skip = 1;
        end
        if (!uvm_string_to_action(args[3], action)) begin
          message = $sformatf("Bad action argument '%s'", args[3]);
          skip = 1;
        end
        if (!skip) begin
          uvm_cmdline_set_action setting;
          setting = new();
          setting.arg = setting_str[i];
          setting.comp = args[0];
          setting.id = args[1];
          setting.all_sev = (args[2] == "_ALL_");
          setting.sev = sev;
          setting.action = action;
          settings.push_back(setting);
        end
        else if (ro != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("%s, setting '%s%s' will be ignored.", message, prefix, setting_str[i]), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 432, "", 1);
     end
   end
        end
      end
    end
  endfunction : init
  static function void check(uvm_report_object ro);
    foreach(settings[i]) begin
      if (settings[i].used.size() == 0) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("\"%s%s\" never took effect due to a mismatching component pattern", prefix, settings[i].arg), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 451, "", 1);
     end
   end
      end
    end
  endfunction : check
  static function string dump();
    string msgs[$];
    uvm_component sorted_list[$];
    foreach (settings[i]) begin
      uvm_cmdline_set_action setting;
      setting = settings[i];
      msgs.push_back($sformatf("\n%s%s", prefix, setting.arg));
      msgs.push_back("\n  matching components:");
      if (setting.used.size() == 0) begin
        msgs.push_back("\n    <none>");
      end
      else begin
        sorted_list.delete();
        foreach (setting.used[j]) begin
          sorted_list.push_back(j);
        end
        sorted_list.sort() with ( item.get_full_name() );
        foreach (sorted_list[j]) begin
          string full_name;
          full_name = sorted_list[j].get_full_name();
          if (full_name == "") begin
            full_name = "<uvm_root>";
          end
          msgs.push_back("\n    ");
          msgs.push_back(full_name);
          msgs.push_back(": Applied");
        end
      end
    end
    return uvm_pkg::m_uvm_string_queue_join(msgs);
  endfunction : dump
endclass : uvm_cmdline_set_action
class uvm_cmdline_set_severity extends uvm_cmdline_setting_base;
  string    comp;
  string    id;
  bit       all_sev;
  uvm_severity orig_sev;
  uvm_severity sev;
  localparam string prefix="+uvm_set_severity=";
  static uvm_cmdline_set_severity settings[$];
  static function void init(input uvm_report_object ro);
    string  setting_str[$];
    uvm_cmdline_processor clp = uvm_cmdline_processor::get_inst();
    if (clp.get_arg_values(prefix, setting_str) > 0) begin
      uvm_severity orig_sev, sev;
      string  args[$];
      string  message;
      bit     skip;
      foreach(setting_str[i]) begin
        skip = 0;
        uvm_string_split(setting_str[i], ",", args);
        if (args.size() != 4) begin
          message = "Invalid number of arguments found, expected 4";
          skip = 1;
        end
        if (args[2] != "_ALL_" && !uvm_string_to_severity(args[2], orig_sev)) begin
          message = $sformatf("Bad severity argument '%s'", args[2]);
          skip = 1;
        end
        if (!uvm_string_to_severity(args[3], sev)) begin
          message = $sformatf("Bad severity argument '%s'", args[3]);
          skip = 1;
        end
        if (!skip) begin
          uvm_cmdline_set_severity setting;
          setting = new();
          setting.arg = setting_str[i];
          setting.comp = args[0];
          setting.id = args[1];
          setting.all_sev = (args[2] == "_ALL_");
          setting.orig_sev = orig_sev;
          setting.sev = sev;
          settings.push_back(setting);
        end
        else if (ro != null) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("%s, setting '%s%s' will be ignored.", message, prefix, setting_str[i]), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 561, "", 1);
     end
   end
        end
      end
    end
  endfunction : init
  static function void check(uvm_report_object ro);
    foreach(settings[i]) begin
      if (settings[i].used.size() == 0) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = ro.uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "INVLCMDARGS") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "INVLCMDARGS") != uvm_pkg::UVM_NO_ACTION)) begin
   _local_report_object_.uvm_report_warning("INVLCMDARGS", $sformatf("\"%s%s\" never took effect due to a mismatching component pattern", prefix, settings[i].arg), uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_cmdline_report.svh", 580, "", 1);
     end
   end
      end
    end
  endfunction : check
  static function string dump();
    string msgs[$];
    uvm_component sorted_list[$];
    foreach (settings[i]) begin
      uvm_cmdline_set_severity setting;
      setting = settings[i];
      msgs.push_back($sformatf("\n%s%s", prefix, setting.arg));
      msgs.push_back("\n  matching components:");
      if (setting.used.size() == 0) begin
        msgs.push_back("\n    <none>");
      end
      else begin
        sorted_list.delete();
        foreach (setting.used[j]) begin
          sorted_list.push_back(j);
        end
        sorted_list.sort() with ( item.get_full_name() );
        foreach (sorted_list[j]) begin
          string full_name;
          full_name = sorted_list[j].get_full_name();
          if (full_name == "") begin
            full_name = "<uvm_root>";
          end
          msgs.push_back("\n    ");
          msgs.push_back(full_name);
          msgs.push_back(": Applied");
        end
      end
    end
    return uvm_pkg::m_uvm_string_queue_join(msgs);
  endfunction : dump
endclass : uvm_cmdline_set_severity
virtual class uvm_visitor#(type NODE=uvm_component) extends uvm_object;
  function new (string name = "");
    super.new(name);
  endfunction
  virtual function void begin_v(); endfunction
  virtual function void end_v(); endfunction
  pure virtual function void visit(NODE node);
endclass
virtual class uvm_structure_proxy#(type STRUCTURE=uvm_component) extends uvm_object;
  function new (string name = "");
    super.new(name);
  endfunction
  pure virtual function void get_immediate_children(STRUCTURE s, ref STRUCTURE children[$]);
endclass
virtual class uvm_visitor_adapter#(type STRUCTURE=uvm_component,VISITOR=uvm_visitor#(STRUCTURE)) extends uvm_object;
  pure virtual function void accept(STRUCTURE s, VISITOR v,uvm_structure_proxy#(STRUCTURE) p, bit invoke_begin_end=1);
  function new (string name = "");
    super.new(name);
  endfunction
endclass
class uvm_top_down_visitor_adapter#(type STRUCTURE=uvm_component,VISITOR=uvm_visitor#(STRUCTURE)) extends
  uvm_visitor_adapter#(STRUCTURE,VISITOR);
  function new (string name = "");
    super.new(name);
  endfunction
  virtual function void accept(STRUCTURE s, VISITOR v,uvm_structure_proxy#(STRUCTURE) p, bit invoke_begin_end=1);
    STRUCTURE c[$];
    if(invoke_begin_end)
      begin
        v.begin_v();
      end
    v.visit(s);
    p.get_immediate_children(s, c);
    foreach(c[idx])
      begin
        accept(c[idx],v,p,0);
      end
    if(invoke_begin_end)
      begin
        v.end_v();
      end
  endfunction
endclass
class uvm_bottom_up_visitor_adapter#(type STRUCTURE=uvm_component,VISITOR=uvm_visitor#(STRUCTURE)) extends
  uvm_visitor_adapter#(STRUCTURE,VISITOR);
  function new (string name = "");
    super.new(name);
  endfunction
  virtual function void accept(STRUCTURE s, VISITOR v,uvm_structure_proxy#(STRUCTURE) p, bit invoke_begin_end=1);
    STRUCTURE c[$];
    if(invoke_begin_end)
      begin
        v.begin_v();
      end
    p.get_immediate_children(s, c);
    foreach(c[idx])
      begin
        accept(c[idx],v,p,0);
      end
    v.visit(s);
    if(invoke_begin_end)
      begin
        v.end_v();
      end
  endfunction
endclass
class uvm_by_level_visitor_adapter#(type STRUCTURE=uvm_component,VISITOR=uvm_visitor#(STRUCTURE)) extends
  uvm_visitor_adapter#(STRUCTURE,VISITOR);
  function new (string name = "");
    super.new(name);
  endfunction
  virtual function void accept(STRUCTURE s, VISITOR v,uvm_structure_proxy#(STRUCTURE) p, bit invoke_begin_end=1);
    STRUCTURE c[$];
    c.push_back(s);
    if(invoke_begin_end)
      begin
        v.begin_v();
      end
    while(c.size() > 0)
      begin
        STRUCTURE q[$];
        foreach(c[idx])
        begin
          STRUCTURE t[$];
          v.visit(c[idx]);
          p.get_immediate_children(c[idx], t);
          q = {q,t};
        end
        c=q;
      end
    if(invoke_begin_end)
      begin
        v.end_v();
      end
  endfunction
endclass
class uvm_component_proxy extends uvm_structure_proxy#(uvm_component);
  virtual function void get_immediate_children(STRUCTURE s, ref STRUCTURE children[$]);
    s.get_children(children);
  endfunction
  function new (string name = "");
    super.new(name);
  endfunction
endclass
class uvm_component_name_check_visitor extends uvm_visitor#(uvm_component);
  local uvm_root _root;
  virtual function string get_name_constraint();
    return "/^[][[:alnum:](){}_:-]([][[:alnum:](){} _:-]*[][[:alnum:](){}_:-])?$/";
  endfunction
  virtual function void visit(NODE node);
    if(_root != node)
      begin
        static bit warned ;
        if (!warned) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_WARNING, "NO_VISIT_CHECK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_WARNING, "NO_VISIT_CHECK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_warning("NO_VISIT_CHECK", "Because UVM_REGEX_NO_DPI is defined, no uvm component name constraints will be checked", uvm_pkg::UVM_NONE, "t/uvm/src/base/uvm_traversal.svh", 314, "", 1);
     end
   end
        warned = 1;
      end
      end
  endfunction
  function new (string name = "");
    super.new(name);
  endfunction
  virtual function void begin_v();
    uvm_coreservice_t cs = uvm_coreservice_t::get();
    _root =  cs.get_root();
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_INFO, "UVM/COMP/NAMECHECK") >= UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_INFO, "UVM/COMP/NAMECHECK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_info("UVM/COMP/NAMECHECK", "This implementation of the component name checks requires DPI to be enabled", UVM_NONE, "t/uvm/src/base/uvm_traversal.svh", 345, "", 1);
     end
   end
  endfunction
endclass
`define UVM_CACHE_SVH
virtual class uvm_cache#(type KEY_T=int, type DATA_T=int) extends uvm_object;
  typedef uvm_cache#(KEY_T, DATA_T) this_type;
  typedef DATA_T optional_data[$];
  typedef KEY_T optional_keys[$];
  typedef int unsigned size_t;
   typedef uvm_abstract_object_registry #(uvm_cache#(KEY_T, DATA_T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
     static function string type_name();
       return "uvm_cache";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_cache";
     endfunction : get_type_name
  extern function new(string name="unnamed-uvm_cache", size_t max_size = 256);
  extern virtual function void set_max_size(size_t max_size=256);
  extern virtual function size_t get_max_size();
  pure virtual function size_t size();
  pure virtual function bit exists(KEY_T key);
  pure virtual function optional_data get(KEY_T key);
  pure virtual function void put(KEY_T key, DATA_T data);
  pure virtual function optional_data evict(KEY_T key);
  pure virtual protected function void evict_to_max();
  pure virtual function optional_keys keys();
  extern virtual function void flush();
  protected size_t m_max_size;
endclass : uvm_cache
function uvm_cache::new(string name="unnamed-uvm_cache", uvm_cache::size_t max_size = 256);
  super.new(name);
  this.m_max_size = max_size;
endfunction : new
function void uvm_cache::flush();
  optional_keys m_keys;
  m_keys = keys();
  foreach (m_keys[key])
    begin
      void'(evict(m_keys[key]));
    end
endfunction : flush
function void uvm_cache::set_max_size(uvm_cache::size_t max_size=256);
  m_max_size = max_size;
  evict_to_max();
endfunction : set_max_size
function uvm_cache::size_t uvm_cache::get_max_size();
  return m_max_size;
endfunction : get_max_size
`define UVM_LRU_CACHE_SVH
  class uvm_lru_cache_node#(type KEY_T=int, type DATA_T=int);
    KEY_T key;
    DATA_T data;
    uvm_lru_cache_node#(KEY_T,DATA_T) prev, next;
  endclass : uvm_lru_cache_node
class uvm_lru_cache#(type KEY_T=int, type DATA_T=int) extends uvm_cache#(KEY_T, DATA_T);
  typedef uvm_lru_cache#(KEY_T,DATA_T) this_type;
   typedef uvm_object_registry #(uvm_lru_cache#(KEY_T, DATA_T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_lru_cache#(KEY_T, DATA_T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
     static function string type_name();
       return "uvm_lru_cache";
     endfunction : type_name
     virtual function string get_type_name();
       return "uvm_lru_cache";
     endfunction : get_type_name
  extern function new(string name="unnamed-uvm_lru_cache", size_t max_size = 256);
  extern virtual function size_t size();
  extern virtual function bit exists(KEY_T key);
  extern virtual function optional_data get(KEY_T key);
  extern virtual function void put(KEY_T key, DATA_T data);
  extern virtual function optional_data evict(KEY_T key);
  extern protected virtual function void evict_to_max();
  extern virtual function optional_keys keys();
  typedef uvm_lru_cache_node#(KEY_T,DATA_T) node_type;
  protected node_type m_hash[KEY_T];
  protected node_type m_begin;
  protected node_type m_end;
  extern virtual function void m_update(node_type node);
endclass : uvm_lru_cache
function uvm_lru_cache::new(string name="unnamed-uvm_lru_cache", uvm_lru_cache::size_t max_size = 256);
  super.new(name, max_size);
endfunction : new
function uvm_lru_cache::size_t uvm_lru_cache::size();
  return m_hash.size();
endfunction : size
function bit uvm_lru_cache::exists(uvm_lru_cache::KEY_T key);
  return m_hash.exists(key);
endfunction : exists
function void uvm_lru_cache::m_update(uvm_lru_cache::node_type node);
  if (m_begin != node)
    begin
      node.prev.next = node.next;
      if (node.next != null)
      begin
        node.next.prev = node.prev;
      end
      node.next = m_begin;
      m_begin.prev = node;
      node.prev = null;
      m_begin = node;
    end
endfunction : m_update
function void uvm_lru_cache::evict_to_max();
  size_t max_size;
  max_size = get_max_size();
  while (max_size && (max_size < m_hash.size()))
    begin
      void'(evict(m_end.key));
    end
endfunction : evict_to_max
function uvm_lru_cache::optional_data uvm_lru_cache::get(uvm_lru_cache::KEY_T key);
  if (m_hash.exists(key))
    begin
      node_type node;
      node = m_hash[key];
      m_update(node);
      return '{node.data};
    end
  return '{};
endfunction : get
function void uvm_lru_cache::put(uvm_lru_cache::KEY_T key, uvm_lru_cache::DATA_T data);
  node_type node;
  if (!m_hash.exists(key))
    begin
      node = new();
      node.key = key;
      node.data = data;
      node.next = m_begin;
      m_begin = node;
      if (node.next == null)
      begin
        m_end = node;
      end
      else
      begin
        node.next.prev = node;
      end
      m_hash[key] = node;
    end
  else
    begin
      node = m_hash[key];
      m_update(node);
      node.data = data;
    end
endfunction : put
function uvm_lru_cache::optional_data uvm_lru_cache::evict(uvm_lru_cache::KEY_T key);
  if (m_hash.exists(key))
    begin
      node_type tmp;
      tmp = m_hash[key];
      m_hash.delete(key);
      if (m_begin == tmp)
      begin
        m_begin = tmp.next;
      end
      else
      begin
        tmp.prev.next = tmp.next;
      end
      if (m_end == tmp)
      begin
        m_end = tmp.prev;
      end
      else
      begin
        tmp.next.prev = tmp.prev;
      end
      return '{tmp.data};
    end
  return '{};
endfunction : evict
function uvm_lru_cache::optional_keys uvm_lru_cache::keys();
  foreach(m_hash[key])
    begin
      keys.push_back(key);
    end
  return keys;
endfunction : keys
virtual class uvm_process_guard_base extends uvm_object;
  extern function new(string name);
  extern function process clear();
  extern function process get_process();
  extern function bit is_terminated();
  pure virtual function void do_trigger();
  extern static function void m_init_process_guards();
  extern static function void m_process_guard(uvm_process_guard_base guard);
  protected static uvm_process_guard_base m_pending_guards[$];
  protected process m_target_process;
  protected process m_guard_process;
endclass : uvm_process_guard_base
function uvm_process_guard_base::new(string name);
  super.new(name);
  m_target_process = process::self();
endfunction : new
function process uvm_process_guard_base::get_process();
  return this.m_target_process;
endfunction : get_process
function bit uvm_process_guard_base::is_terminated();
  return ((m_target_process != null) &&
          ((m_target_process.status() == process::FINISHED) ||
           (m_target_process.status() == process::KILLED))
          );
endfunction : is_terminated
function process uvm_process_guard_base::clear();
  if (this.m_guard_process != null) begin
    this.m_guard_process.kill();
  end
  if (is_terminated()) begin
    return null;
  end
  clear = this.m_target_process;
  this.m_target_process = null;
endfunction : clear
function void uvm_process_guard_base::m_init_process_guards();
  fork
    begin
      forever
        begin
          uvm_process_guard_base next_guard;
          wait(m_pending_guards.size() != 0);
          next_guard = m_pending_guards.pop_front();
          if (next_guard.m_target_process != null) begin
            uvm_process_guard_base::m_process_guard(next_guard);
          end
        end
    end
  join_none
endfunction : m_init_process_guards
function void uvm_process_guard_base::m_process_guard(uvm_process_guard_base guard);
  fork
    begin
      if (guard.m_target_process != null) begin
        guard.m_guard_process = process::self();
        guard.m_target_process.await();
        guard.do_trigger();
      end
    end
  join_none
endfunction : m_process_guard
class uvm_process_guard#(type T=int) extends uvm_process_guard_base;
  typedef uvm_process_guard#(T) this_type;
  extern function new(string name, T ctxt);
  extern function T get_context();
  extern virtual function void do_trigger();
  protected T m_context;
endclass : uvm_process_guard
function uvm_process_guard::new(string name, uvm_process_guard::T ctxt);
  super.new(name);
  this.m_context = ctxt;
  m_pending_guards.push_back(this);
endfunction : new
function uvm_process_guard::T uvm_process_guard::get_context();
  return this.m_context;
endfunction : get_context
function void uvm_process_guard::do_trigger();
  m_context.process_guard_triggered(this);
endfunction : do_trigger
`define UVM_DAP_SVH
virtual class uvm_set_get_dap_base#(type T=int) extends uvm_object;
   typedef uvm_set_get_dap_base#(T) this_type;
   function new(string name="unnamed-uvm_set_get_dap_base#(T)");
      super.new(name);
   endfunction : new
   pure virtual function void set(T value);
   pure virtual function bit try_set(T value);
   pure virtual function T get();
   pure virtual function bit try_get(output T value);
endclass : uvm_set_get_dap_base
class uvm_simple_lock_dap#(type T=int) extends uvm_set_get_dap_base#(T);
   typedef uvm_simple_lock_dap#(T) this_type;
   typedef uvm_object_registry #(uvm_simple_lock_dap#(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_simple_lock_dap#(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
   local T m_value;
   local bit m_locked;
   function new(string name="unnamed-uvm_simple_lock_dap#(T)");
      super.new(name);
      m_locked = 0;
   endfunction : new
   virtual function void set(T value);
      if (m_locked) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/SAG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/SAG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SIMPLE_LOCK_DAP/SAG", $sformatf("Attempt to set new value on '%s', but the data access policy forbids setting while locked!", get_full_name()), uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_simple_lock_dap.svh", 78, "", 1);
     end
   end
      end
      else begin
        m_value = value;
      end
   endfunction : set
   virtual function bit try_set(T value);
      if (m_locked) begin
        return 0;
      end
      else begin
        m_value = value;
        return 1;
      end
   endfunction : try_set
   virtual  function T get();
      return m_value;
   endfunction : get
   virtual function bit try_get(output T value);
      value = get();
      return 1;
   endfunction : try_get
   function void lock();
      m_locked = 1;
   endfunction : lock
   function void unlock();
      m_locked = 0;
   endfunction : unlock
   function bit is_locked();
      return m_locked;
   endfunction : is_locked
   virtual function void do_copy(uvm_object rhs);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/CPY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/CPY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SIMPLE_LOCK_DAP/CPY", "'copy()' is not supported for 'uvm_simple_lock_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_simple_lock_dap.svh", 158, "", 1);
     end
   end
   endfunction : do_copy
   virtual function void do_pack(uvm_packer packer);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/PCK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/PCK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SIMPLE_LOCK_DAP/PCK", "'pack()' is not supported for 'uvm_simple_lock_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_simple_lock_dap.svh", 163, "", 1);
     end
   end
   endfunction : do_pack
   virtual function void do_unpack(uvm_packer packer);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/UPK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SIMPLE_LOCK_DAP/UPK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SIMPLE_LOCK_DAP/UPK", "'unpack()' is not supported for 'uvm_simple_lock_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_simple_lock_dap.svh", 168, "", 1);
     end
   end
   endfunction : do_unpack
   virtual function string convert2string();
      if (m_locked) begin
        return $sformatf("(%s) %0p [LOCKED]", $typename(m_value), m_value);
      end
      else begin
        return $sformatf("(%s) %0p [UNLOCKED]", $typename(m_value), m_value);
      end
   endfunction : convert2string
   virtual function void do_print(uvm_printer printer);
      super.do_print(printer);
      printer.print_field("lock_state", m_locked, $bits(m_locked));
      printer.print_generic("value",
                            $typename(m_value),
                            0,
                            $sformatf("%0p", m_value));
   endfunction : do_print
endclass
class uvm_get_to_lock_dap#(type T=int) extends uvm_set_get_dap_base#(T);
   typedef uvm_get_to_lock_dap#(T) this_type;
   typedef uvm_object_registry #(uvm_get_to_lock_dap#(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_get_to_lock_dap#(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
   local T m_value;
   local bit m_locked;
   function new(string name="unnamed-uvm_get_to_lock_dap#(T)");
      super.new(name);
      m_locked = 0;
   endfunction : new
   virtual function void set(T value);
      if (m_locked) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/SAG") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/SAG") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/GET_TO_LOCK_DAP/SAG", $sformatf("Attempt to set new value on '%s', but the data access policy forbids setting after a get!", get_full_name()), uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_get_to_lock_dap.svh", 77, "", 1);
     end
   end
      end
      else begin
        m_value = value;
      end
   endfunction : set
   virtual function bit try_set(T value);
      if (m_locked) begin
        return 0;
      end
      else begin
        m_value = value;
        return 1;
      end
   endfunction : try_set
   virtual  function T get();
      m_locked = 1;
      return m_value;
   endfunction : get
   virtual function bit try_get(output T value);
      value = get();
      return 1;
   endfunction : try_get
   function bit is_locked();
      return m_locked;
   endfunction : is_locked
   virtual function void do_copy(uvm_object rhs);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/CPY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/CPY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/GET_TO_LOCK_DAP/CPY", "'copy()' is not supported for 'uvm_get_to_lock_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_get_to_lock_dap.svh", 143, "", 1);
     end
   end
   endfunction : do_copy
   virtual function void do_pack(uvm_packer packer);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/PCK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/PCK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/GET_TO_LOCK_DAP/PCK", "'pack()' is not supported for 'uvm_get_to_lock_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_get_to_lock_dap.svh", 148, "", 1);
     end
   end
   endfunction : do_pack
   virtual function void do_unpack(uvm_packer packer);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/UPK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/GET_TO_LOCK_DAP/UPK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/GET_TO_LOCK_DAP/UPK", "'unpack()' is not supported for 'uvm_get_to_lock_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_get_to_lock_dap.svh", 153, "", 1);
     end
   end
   endfunction : do_unpack
   virtual function string convert2string();
      if (m_locked) begin
        return $sformatf("(%s) %0p [LOCKED]", $typename(m_value), m_value);
      end
      else begin
        return $sformatf("(%s) %0p [UNLOCKED]", $typename(m_value), m_value);
      end
   endfunction : convert2string
   virtual function void do_print(uvm_printer printer);
      super.do_print(printer);
      printer.print_field_int("lock_state", m_locked, $bits(m_locked));
      printer.print_generic("value",
                            $typename(m_value),
                            0,
                            $sformatf("%0p", m_value));
   endfunction : do_print
endclass
class uvm_set_before_get_dap#(type T=int) extends uvm_set_get_dap_base#(T);
   typedef uvm_set_before_get_dap#(T) this_type;
   typedef uvm_object_registry #(uvm_set_before_get_dap#(T)) type_id;
   static function type_id get_type();
     return type_id::get();
   endfunction
   virtual function uvm_object_wrapper get_object_type();
     return type_id::get();
   endfunction
   function uvm_object create (string name="");
     uvm_set_before_get_dap#(T) tmp;
     if (name=="") tmp = new();
     else tmp = new(name);
     return tmp;
   endfunction
   local T m_value;
   local bit m_set;
   function new(string name="unnamed-uvm_set_before_get_dap#(T)");
      super.new(name);
      m_set = 0;
   endfunction : new
   virtual function void set(T value);
      m_set = 1;
      m_value = value;
   endfunction : set
   virtual function bit try_set(T value);
      set(value);
      return 1;
   endfunction : try_set
   virtual  function T get();
      if (!m_set) begin
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/NO_SET") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/NO_SET") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SET_BEFORE_GET_DAP/NO_SET", $sformatf("Attempt to get value on '%s', but the data access policy forbits calling 'get' prior to calling 'set' or 'try_set'!", get_full_name()), uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_set_before_get_dap.svh", 127, "", 1);
     end
   end
      end
      return m_value;
   endfunction : get
   virtual function bit try_get(output T value);
      if (!m_set) begin
        return 0;
      end
      else begin
        value = m_value;
        return 1;
      end
   endfunction : try_get
   virtual function void do_copy(uvm_object rhs);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/CPY") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/CPY") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SET_BEFORE_GET_DAP/CPY", "'copy()' is not supported for 'uvm_set_before_get_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_set_before_get_dap.svh", 159, "", 1);
     end
   end
   endfunction : do_copy
   virtual function void do_pack(uvm_packer packer);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/PCK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/PCK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SET_BEFORE_GET_DAP/PCK", "'pack()' is not supported for 'uvm_set_before_get_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_set_before_get_dap.svh", 164, "", 1);
     end
   end
   endfunction : do_pack
   virtual function void do_unpack(uvm_packer packer);
   begin
     uvm_pkg::uvm_report_object _local_report_object_;
     _local_report_object_ = uvm_get_report_object().uvm_get_report_object() ;
     if ((_local_report_object_.get_report_verbosity_level(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/UPK") >= uvm_pkg::UVM_NONE) &&
         (_local_report_object_.get_report_action(uvm_pkg::UVM_ERROR, "UVM/SET_BEFORE_GET_DAP/UPK") != uvm_pkg::UVM_NO_ACTION)) begin
  uvm_report_error("UVM/SET_BEFORE_GET_DAP/UPK", "'unpack()' is not supported for 'uvm_set_before_get_dap#(T)'", uvm_pkg::UVM_NONE, "t/uvm/src/dap/uvm_set_before_get_dap.svh", 169, "", 1);
     end
   end
   endfunction : do_unpack
   virtual function string convert2string();
      if (m_set) begin
        return $sformatf("(%s) %0p [SET]", $typename(m_value), m_value);
      end
      else begin
        return $sformatf("(%s) %0p [UNSET]", $typename(m_value), m_value);
      end
   endfunction : convert2string
   virtual function void do_print(uvm_printer printer);
      super.do_print(printer);
      printer.print_field_int("set_state", m_set, $bits(m_set));
      printer.print_generic("value",
                            $typename(m_value),
                            0,
                            $sformatf("%0p", m_value));
   endfunction : do_print
endclass
`define UVM_TASK_ERROR "UVM TLM interface task not implemented"
`define UVM_FUNCTION_ERROR "UVM TLM interface function not implemented"
virtual class uvm_tlm_if_base #(type T1=int, type T2=int) extends uvm_void;
  virtual task put( input T1 t );
    uvm_report_error("put", "UVM TLM interface task not implemented", UVM_NONE);
  endtask
  virtual task get( output T2 t );
    uvm_report_error("get", "UVM TLM interface task not implemented", UVM_NONE);
  endtask
  virtual task peek( output T2 t );
    uvm_report_error("peek", "UVM TLM interface task not implemented", UVM_NONE);
  endtask
  virtual function bit try_put( input T1 t );
    uvm_report_error("try_put", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual function bit can_put();
    uvm_report_error("can_put", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual function bit try_get( output T2 t );
    uvm_report_error("try_get", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual function bit can_get();
    uvm_report_error("can_get", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual function bit try_peek( output T2 t );
    uvm_report_error("try_peek", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual function bit can_peek();
    uvm_report_error("can_ppeek", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual task transport( input T1 req , output T2 rsp );
    uvm_report_error("transport", "UVM TLM interface task not implemented", UVM_NONE);
  endtask
  virtual function bit nb_transport(input T1 req, output T2 rsp);
    uvm_report_error("nb_transport", "UVM TLM interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual function void write( input T1 t );
    uvm_report_error("write", "UVM TLM interface function not implemented", UVM_NONE);
  endfunction
endclass
`define UVM_SEQ_ITEM_TASK_ERROR "Sequencer interface task not implemented"
`define UVM_SEQ_ITEM_FUNCTION_ERROR "Sequencer interface function not implemented"
virtual class uvm_sqr_if_base #(type T1=uvm_object, T2=T1) extends uvm_void;
  virtual task get_next_item(output T1 t);
    uvm_report_error("get_next_item", "Sequencer interface task not implemented", UVM_NONE);
  endtask
  virtual task try_next_item(output T1 t);
    uvm_report_error("try_next_item", "Sequencer interface task not implemented", UVM_NONE);
  endtask
  virtual function void item_done(input T2 t = null);
    uvm_report_error("item_done", "Sequencer interface function not implemented", UVM_NONE);
  endfunction
  virtual task wait_for_sequences();
    uvm_report_error("wait_for_sequences", "Sequencer interface task not implemented", UVM_NONE);
  endtask
  virtual function bit has_do_available();
    uvm_report_error("has_do_available", "Sequencer interface function not implemented", UVM_NONE);
    return 0;
  endfunction
  virtual task get(output T1 t);
    uvm_report_error("get", "Sequencer interface task not implemented", UVM_NONE);
  endtask
  virtual task peek(output T1 t);
    uvm_report_error("peek", "Sequencer interface task not implemented", UVM_NONE);
  endtask
  virtual task put(input T2 t);
    uvm_report_error("put", "Sequencer interface task not implemented", UVM_NONE);
  endtask
  virtual function void put_response(input T2 t);
    uvm_report_error("put_response", "Sequencer interface function not implemented", UVM_NONE);
  endfunction
  virtual function void disable_auto_item_recording();
    uvm_report_error("disable_auto_item_recording", "Sequencer interface function not implemented", UVM_NONE);
  endfunction
  virtual function bit is_auto_item_recording_enabled();
    uvm_report_error("is_auto_item_recording_enabled", "Sequencer interface function not implemented", UVM_NONE);
    return 0;
  endfunction
endclass
const int UVM_UNBOUNDED_CONNECTIONS = -1;
const string s_connection_error_id = "Connection Error";
const string s_connection_warning_id = "Connection Warning";
const string s_spaces = "                       ";
typedef class uvm_port_component_base;
typedef uvm_port_component_base uvm_port_list[string];
virtual class uvm_port_component_base extends uvm_component;
  function new (string name, uvm_component parent);
    super.new(name,parent);
  endfunction
  pure virtual function void get_connected_to(ref uvm_port_list list);
  pure virtual function void get_provided_to(ref uvm_port_list list);
  pure virtual function bit is_port();
  pure virtual function bit is_export();
  pure virtual function bit is_imp();
  virtual function bit use_automatic_config();
    return 0;
  endfunction : use_automatic_config
  virtual task do_task_phase (uvm_phase phase);
  endtask
endclass
class uvm_port_component #(type PORT=uvm_object) extends uvm_port_component_base;
  PORT m_port;
  function new (string name, uvm_component parent, PORT port);
    super.new(name,parent);
    if (port == null) begin
      uvm_report_fatal("Bad usage", "Null handle to port", UVM_NONE);
    end
    m_port = port;
  endfunction
  virtual function string get_type_name();
    if(m_port == null) begin
      return "uvm_port_component";
    end
    return m_port.get_type_name();
  endfunction
  virtual function void resolve_bindings();
    m_port.resolve_bindings();
  endfunction
  function PORT get_port();
    return m_port;
  endfunction
  virtual function void get_connected_to(ref uvm_port_list list);
    PORT list1[string];
    m_port.get_connected_to(list1);
    list.delete();
    foreach(list1[name]) begin
      list[name] = list1[name].get_comp();
    end
  endfunction
  virtual function void get_provided_to(ref uvm_port_list list);
    PORT list1[string];
    m_port.get_provided_to(list1);
    list.delete();
    foreach(list1[name]) begin
      list[name] = list1[name].get_comp();
    end
  endfunction
  function bit is_port ();
    return m_port.is_port();
  endfunction
  function bit is_export ();
    return m_port.is_export();
  endfunction
  function bit is_imp ();
    return m_port.is_imp();
  endfunction
endclass
virtual class uvm_port_base #(type IF=uvm_void) extends IF;
  typedef uvm_port_base #(IF) this_type;
  protected int unsigned  m_if_mask;
  protected this_type     m_if;
  protected int unsigned  m_def_index;
  uvm_port_component #(this_type) m_comp;
  local this_type m_provided_by[string];
  local this_type m_provided_to[string];
  local uvm_port_type_e   m_port_type;
  local int               m_min_size;
  local int               m_max_size;
  local bit               m_resolved;
  local this_type         m_imp_list[string];
  function new (string name,
                uvm_component parent,
                uvm_port_type_e port_type,
                int min_size=0,
                int max_size=1);
    uvm_component comp;
    int tmp;
    m_port_type = port_type;
    m_min_size  = min_size;
    m_max_size  = max_size;
    m_comp = new(name, parent, this);
    if (!uvm_config_int::get(m_comp, "", "check_connection_relationships",tmp)) begin
      m_comp.set_report_id_action(s_connection_warning_id, UVM_NO_ACTION);
    end
  endfunction
  function string get_name();
    return m_comp.get_name();
  endfunction
  virtual function string get_full_name();
    return m_comp.get_full_name();
  endfunction
  virtual function uvm_component get_parent();
    return m_comp.get_parent();
  endfunction
  virtual function uvm_port_component_base get_comp();
    return m_comp;
  endfunction
  virtual function string get_type_name();
    case( m_port_type )
      UVM_PORT : begin
        return "port";
      end
      UVM_EXPORT : begin
        return "export";
      end
      UVM_IMPLEMENTATION : begin
        return "implementation";
      end
    endcase
  endfunction
  function int max_size ();
    return m_max_size;
  endfunction
  function int min_size ();
    return m_min_size;
  endfunction
  function bit is_unbounded ();
    return (m_max_size ==  UVM_UNBOUNDED_CONNECTIONS);
  endfunction
  function bit is_port ();
    return m_port_type == UVM_PORT;
  endfunction
  function bit is_export ();
    return m_port_type == UVM_EXPORT;
  endfunction
  function bit is_imp ();
    return m_port_type == UVM_IMPLEMENTATION;
  endfunction
  function int size ();
    return m_imp_list.num();
  endfunction
  function void set_if (int index=0);
    m_if = get_if(index);
    if (m_if != null) begin
      m_def_index = index;
    end
  endfunction
  function int m_get_if_mask();
    return m_if_mask;
  endfunction
  function void set_default_index (int index);
    m_def_index = index;
  endfunction
  virtual function void connect (this_type provider);
     uvm_root top;
     uvm_coreservice_t cs;
     cs = uvm_coreservice_t::get();
     top = cs.get_root();
    if (end_of_elaboration_ph.get_state() == UVM_PHASE_EXECUTING ||
        end_of_elaboration_ph.get_state() == UVM_PHASE_DONE ) begin
      m_comp.uvm_report_warning("Late Connection",
         {"Attempt to connect ",this.get_full_name()," (of type ",this.get_type_name(),
          ") at or after end_of_elaboration phase.  Ignoring."});
      return;
    end
    if (provider == null) begin
      m_comp.uvm_report_error(s_connection_error_id,
                       "Cannot connect to null port handle", UVM_NONE);
      return;
    end
    if (provider == this) begin
      m_comp.uvm_report_error(s_connection_error_id,
                       "Cannot connect a port instance to itself", UVM_NONE);
      return;
    end
    if ((provider.m_if_mask & m_if_mask) != m_if_mask) begin
      m_comp.uvm_report_error(s_connection_error_id,
        {provider.get_full_name(),
         " (of type ",provider.get_type_name(),
         ") does not provide the complete interface required of this port (type ",
         get_type_name(),")"}, UVM_NONE);
      return;
    end
    if (is_imp()) begin
      m_comp.uvm_report_error(s_connection_error_id,
        $sformatf(
"Cannot call an imp port's connect method. An imp is connected only to the component passed in its constructor. (You attempted to bind this imp to %s)", provider.get_full_name()), UVM_NONE);
      return;
    end
    if (is_export() && provider.is_port()) begin
      m_comp.uvm_report_error(s_connection_error_id,
        $sformatf(
"Cannot connect exports to ports Try calling port.connect(export) instead. (You attempted to bind this export to %s).", provider.get_full_name()), UVM_NONE);
      return;
    end
    void'(m_check_relationship(provider));
    m_provided_by[provider.get_full_name()] = provider;
    provider.m_provided_to[get_full_name()] = this;
  endfunction
  function void debug_connected_to (int level=0, int max_level=-1);
    int sz, num, curr_num;
    string s_sz;
    static string indent, save;
    this_type port;
    if (level <  0) begin
      level = 0;
    end
    if (level == 0) begin save = ""; indent="  "; end
    if (max_level != -1 && level >= max_level) begin
      return;
    end
    num = m_provided_by.num();
    if (m_provided_by.num() != 0) begin
      foreach (m_provided_by[nm]) begin
        curr_num++;
        port = m_provided_by[nm];
        save = {save, indent, "  | \n"};
        save = {save, indent, "  |_",nm," (",port.get_type_name(),")\n"};
        indent = (num > 1 && curr_num != num) ?  {indent,"  | "}:{indent, "    "};
        port.debug_connected_to(level+1, max_level);
        indent = indent.substr(0,indent.len()-4-1);
      end
    end
    if (level == 0) begin
      if (save != "") begin
        save = {"This port's fanout network:\n\n  ",
               get_full_name()," (",get_type_name(),")\n",save,"\n"};
      end
      if (m_imp_list.num() == 0) begin
        uvm_root top;
        uvm_coreservice_t cs;
        cs = uvm_coreservice_t::get();
        top = cs.get_root();
        if (end_of_elaboration_ph.get_state() == UVM_PHASE_EXECUTING ||
        end_of_elaboration_ph.get_state() == UVM_PHASE_DONE ) begin
          save = {save,"  Connected implementations: none\n"};
        end
        else begin
          save = {save,
                 "  Connected implementations: not resolved until end-of-elab\n"};
        end
      end
      else begin
        save = {save,"  Resolved implementation list:\n"};
        foreach (m_imp_list[nm]) begin
          port = m_imp_list[nm];
          s_sz.itoa(sz);
          save = {save, indent, s_sz, ": ",nm," (",port.get_type_name(),")\n"};
          sz++;
        end
      end
      m_comp.uvm_report_info("debug_connected_to", save);
    end
  endfunction
  function void debug_provided_to  (int level=0, int max_level=-1);
    string nm;
    int num,curr_num;
    this_type port;
    static string indent, save;
    if (level <  0) begin
      level = 0;
    end
    if (level == 0) begin save = ""; indent = "  "; end
    if (max_level != -1 && level > max_level) begin
      return;
    end
    num = m_provided_to.num();
    if (num != 0) begin
      foreach (m_provided_to[nm]) begin
        curr_num++;
        port = m_provided_to[nm];
        save = {save, indent, "  | \n"};
        save = {save, indent, "  |_",nm," (",port.get_type_name(),")\n"};
        indent = (num > 1 && curr_num != num) ?  {indent,"  | "}:{indent, "    "};
        port.debug_provided_to(level+1, max_level);
        indent = indent.substr(0,indent.len()-4-1);
      end
    end
    if (level == 0) begin
      if (save != "") begin
        save = {"This port's fanin network:\n\n  ",
               get_full_name()," (",get_type_name(),")\n",save,"\n"};
      end
      if (m_provided_to.num() == 0) begin
        save = {save,indent,"This port has not been bound\n"};
      end
      m_comp.uvm_report_info("debug_provided_to", save);
    end
  endfunction
  function void get_connected_to (ref uvm_port_base #(IF) list[string]);
    this_type port;
    list.delete();
    foreach (m_provided_by[name]) begin
      port = m_provided_by[name];
      list[name] = port;
    end
  endfunction
  function void get_provided_to (ref uvm_port_base #(IF) list[string]);
    this_type port;
    list.delete();
    foreach (m_provided_to[name]) begin
      port = m_provided_to[name];
      list[name] = port;
    end
  endfunction
  local function bit  m_check_relationship (this_type provider);
    string s;
    this_type from;
    uvm_component from_parent;
    uvm_component to_parent;
    uvm_component from_gparent;
    uvm_component to_gparent;
    if (get_type_name() == "uvm_analysis_port") begin
      return 1;
    end
    from         = this;
    from_parent  = get_parent();
    to_parent    = provider.get_parent();
    if (from_parent == null || to_parent == null) begin
      return 1;
    end
    from_gparent = from_parent.get_parent();
    to_gparent   = to_parent.get_parent();
    if (from.is_port() && provider.is_port() && from_gparent != to_parent) begin
      s = {provider.get_full_name(),
           " (of type ",provider.get_type_name(),
           ") is not up one level of hierarchy from this port. ",
           "A port-to-port connection takes the form ",
           "child_component.child_port.connect(parent_port)"};
      m_comp.uvm_report_warning(s_connection_warning_id, s, UVM_NONE);
      return 0;
    end
    else if (from.is_port() && (provider.is_export() || provider.is_imp()) &&
             from_gparent != to_gparent) begin
      s = {provider.get_full_name(),
           " (of type ",provider.get_type_name(),
           ") is not at the same level of hierarchy as this port. ",
           "A port-to-export connection takes the form ",
           "component1.port.connect(component2.export)"};
      m_comp.uvm_report_warning(s_connection_warning_id, s, UVM_NONE);
      return 0;
    end
    else if (from.is_export() && (provider.is_export() || provider.is_imp()) &&
             from_parent != to_gparent) begin
      s = {provider.get_full_name(),
           " (of type ",provider.get_type_name(),
           ") is not down one level of hierarchy from this export. ",
           "An export-to-export or export-to-imp connection takes the form ",
           "parent_export.connect(child_component.child_export)"};
      m_comp.uvm_report_warning(s_connection_warning_id, s, UVM_NONE);
      return 0;
    end
    return 1;
  endfunction
  local function void m_add_list           (this_type provider);
    string sz;
    this_type imp;
    for (int i = 0; i < provider.size(); i++) begin
      imp = provider.get_if(i);
      if (!m_imp_list.exists(imp.get_full_name())) begin
        m_imp_list[imp.get_full_name()] = imp;
      end
    end
  endfunction
  virtual function void resolve_bindings();
    if (m_resolved) begin
      return;
    end
    if (is_imp()) begin
      m_imp_list[get_full_name()] = this;
    end
    else begin
      foreach (m_provided_by[nm]) begin
        this_type port;
        port = m_provided_by[nm];
        port.resolve_bindings();
        m_add_list(port);
      end
    end
    m_resolved = 1;
    if (size() < min_size() ) begin
      m_comp.uvm_report_error(s_connection_error_id,
        $sformatf("connection count of %0d does not meet required minimum of %0d",
        size(), min_size()), UVM_NONE);
    end
    if (max_size() != UVM_UNBOUNDED_CONNECTIONS && size() > max_size() ) begin
      m_comp.uvm_report_error(s_connection_error_id,
        $sformatf("connection count of %0d exceeds maximum of %0d",
        size(), max_size()), UVM_NONE);
    end
    if (size()) begin
      set_if(0);
    end
  endfunction
  function uvm_port_base #(IF) get_if(int index=0);
    string s;
    if (size()==0) begin
      m_comp.uvm_report_warning("get_if",
        "Port size is zero; cannot get interface at any index", UVM_NONE);
      return null;
    end
    if (index < 0 || index >= size()) begin
      $sformat(s, "Index %0d out of range [0,%0d]", index, size()-1);
      m_comp.uvm_report_warning(s_connection_error_id, s, UVM_NONE);
      return null;
    end
    foreach (m_imp_list[nm]) begin
      if (index == 0) begin
        return m_imp_list[nm];
      end
      index--;
    end
  endfunction
endclass
class uvm_blocking_put_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<0);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_put_imp";
  endfunction
  task put (T t);
    m_imp.put(t);
  endtask
endclass
class uvm_nonblocking_put_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<4);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_put_imp";
  endfunction
  function bit try_put (T t);
    return m_imp.try_put(t);
  endfunction
  function bit can_put();
    return m_imp.can_put();
  endfunction
endclass
class uvm_put_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = ((1<<0)    | (1<<4));
  endfunction
  virtual function string get_type_name();
    return "uvm_put_imp";
  endfunction
  task put (T t);
    m_imp.put(t);
  endtask
  function bit try_put (T t);
    return m_imp.try_put(t);
  endfunction
  function bit can_put();
    return m_imp.can_put();
  endfunction
endclass
class uvm_blocking_get_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<1);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_get_imp";
  endfunction
  task get (output T t);
    m_imp.get(t);
  endtask
endclass
class uvm_nonblocking_get_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<5);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_get_imp";
  endfunction
  function bit try_get (output T t);
    return m_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_imp.can_get();
  endfunction
endclass
class uvm_get_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = ((1<<1)    | (1<<5));
  endfunction
  virtual function string get_type_name();
    return "uvm_get_imp";
  endfunction
  task get (output T t);
    m_imp.get(t);
  endtask
  function bit try_get (output T t);
    return m_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_imp.can_get();
  endfunction
endclass
class uvm_blocking_peek_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<2);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_peek_imp";
  endfunction
  task peek (output T t);
    m_imp.peek(t);
  endtask
endclass
class uvm_nonblocking_peek_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<6);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_peek_imp";
  endfunction
  function bit try_peek (output T t);
    return m_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_imp.can_peek();
  endfunction
endclass
class uvm_peek_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = ((1<<2)   | (1<<6));
  endfunction
  virtual function string get_type_name();
    return "uvm_peek_imp";
  endfunction
  task peek (output T t);
    m_imp.peek(t);
  endtask
  function bit try_peek (output T t);
    return m_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_imp.can_peek();
  endfunction
endclass
class uvm_blocking_get_peek_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = ((1<<1)    | (1<<2));
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_get_peek_imp";
  endfunction
  task get (output T t);
    m_imp.get(t);
  endtask
  task peek (output T t);
    m_imp.peek(t);
  endtask
endclass
class uvm_nonblocking_get_peek_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = ((1<<5) | (1<<6));
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_get_peek_imp";
  endfunction
  function bit try_get (output T t);
    return m_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_imp.can_get();
  endfunction
  function bit try_peek (output T t);
    return m_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_imp.can_peek();
  endfunction
endclass
class uvm_get_peek_imp #(type T=int, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (((1<<1)    | (1<<5)) | ((1<<2)   | (1<<6)));
  endfunction
  virtual function string get_type_name();
    return "uvm_get_peek_imp";
  endfunction
  task get (output T t);
    m_imp.get(t);
  endtask
  task peek (output T t);
    m_imp.peek(t);
  endtask
  function bit try_get (output T t);
    return m_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_imp.can_get();
  endfunction
  function bit try_peek (output T t);
    return m_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_imp.can_peek();
  endfunction
endclass
class uvm_blocking_master_imp #(type REQ=int, type RSP=REQ, type IMP=int,
                                type REQ_IMP=IMP, type RSP_IMP=IMP)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  typedef IMP     this_imp_type;
  typedef REQ_IMP this_req_type;
  typedef RSP_IMP this_rsp_type;
  local this_req_type m_req_imp;
  local this_rsp_type m_rsp_imp;
  function new (string name, this_imp_type imp,
                this_req_type req_imp = null, this_rsp_type rsp_imp = null);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    if(req_imp==null) begin
      $cast(req_imp, imp);
    end
    if(rsp_imp==null) begin
      $cast(rsp_imp, imp);
    end
    m_req_imp = req_imp;
    m_rsp_imp = rsp_imp;
    m_if_mask = ((1<<0)       | (1<<1) | (1<<2) | (1<<9));
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_master_imp";
  endfunction
  task put (REQ t);
    m_req_imp.put(t);
  endtask
  task get (output RSP t);
    m_rsp_imp.get(t);
  endtask
  task peek (output RSP t);
    m_rsp_imp.peek(t);
  endtask
endclass
class uvm_nonblocking_master_imp #(type REQ=int, type RSP=REQ, type IMP=int,
                                   type REQ_IMP=IMP, type RSP_IMP=IMP)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  typedef IMP     this_imp_type;
  typedef REQ_IMP this_req_type;
  typedef RSP_IMP this_rsp_type;
  local this_req_type m_req_imp;
  local this_rsp_type m_rsp_imp;
  function new (string name, this_imp_type imp,
                this_req_type req_imp = null, this_rsp_type rsp_imp = null);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    if(req_imp==null) begin
      $cast(req_imp, imp);
    end
    if(rsp_imp==null) begin
      $cast(rsp_imp, imp);
    end
    m_req_imp = req_imp;
    m_rsp_imp = rsp_imp;
    m_if_mask = ((1<<4)    | (1<<5) | (1<<6) | (1<<9));
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_master_imp";
  endfunction
  function bit try_put (REQ t);
    return m_req_imp.try_put(t);
  endfunction
  function bit can_put();
    return m_req_imp.can_put();
  endfunction
  function bit try_get (output RSP t);
    return m_rsp_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_rsp_imp.can_get();
  endfunction
  function bit try_peek (output RSP t);
    return m_rsp_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_rsp_imp.can_peek();
  endfunction
endclass
class uvm_master_imp #(type REQ=int, type RSP=REQ, type IMP=int,
                       type REQ_IMP=IMP, type RSP_IMP=IMP)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  typedef IMP     this_imp_type;
  typedef REQ_IMP this_req_type;
  typedef RSP_IMP this_rsp_type;
  local this_req_type m_req_imp;
  local this_rsp_type m_rsp_imp;
  function new (string name, this_imp_type imp,
                this_req_type req_imp = null, this_rsp_type rsp_imp = null);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    if(req_imp==null) begin
      $cast(req_imp, imp);
    end
    if(rsp_imp==null) begin
      $cast(rsp_imp, imp);
    end
    m_req_imp = req_imp;
    m_rsp_imp = rsp_imp;
    m_if_mask = (((1<<0)       | (1<<1) | (1<<2) | (1<<9))    | ((1<<4)    | (1<<5) | (1<<6) | (1<<9)));
  endfunction
  virtual function string get_type_name();
    return "uvm_master_imp";
  endfunction
  task put (REQ t);
    m_req_imp.put(t);
  endtask
  function bit try_put (REQ t);
    return m_req_imp.try_put(t);
  endfunction
  function bit can_put();
    return m_req_imp.can_put();
  endfunction
  task get (output RSP t);
    m_rsp_imp.get(t);
  endtask
  task peek (output RSP t);
    m_rsp_imp.peek(t);
  endtask
  function bit try_get (output RSP t);
    return m_rsp_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_rsp_imp.can_get();
  endfunction
  function bit try_peek (output RSP t);
    return m_rsp_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_rsp_imp.can_peek();
  endfunction
endclass
class uvm_blocking_slave_imp #(type REQ=int, type RSP=REQ, type IMP=int,
                               type REQ_IMP=IMP, type RSP_IMP=IMP)
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ));
  typedef IMP     this_imp_type;
  typedef REQ_IMP this_req_type;
  typedef RSP_IMP this_rsp_type;
  local this_req_type m_req_imp;
  local this_rsp_type m_rsp_imp;
  function new (string name, this_imp_type imp,
                this_req_type req_imp = null, this_rsp_type rsp_imp = null);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    if(req_imp==null) begin
      $cast(req_imp, imp);
    end
    if(rsp_imp==null) begin
      $cast(rsp_imp, imp);
    end
    m_req_imp = req_imp;
    m_rsp_imp = rsp_imp;
    m_if_mask = ((1<<0)       | (1<<1) | (1<<2) | (1<<10));
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_slave_imp";
  endfunction
  task put (RSP t);
    m_rsp_imp.put(t);
  endtask
  task get (output REQ t);
    m_req_imp.get(t);
  endtask
  task peek (output REQ t);
    m_req_imp.peek(t);
  endtask
endclass
class uvm_nonblocking_slave_imp #(type REQ=int, type RSP=REQ, type IMP=int,
                                  type REQ_IMP=IMP, type RSP_IMP=IMP)
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ));
  typedef IMP     this_imp_type;
  typedef REQ_IMP this_req_type;
  typedef RSP_IMP this_rsp_type;
  local this_req_type m_req_imp;
  local this_rsp_type m_rsp_imp;
  function new (string name, this_imp_type imp,
                this_req_type req_imp = null, this_rsp_type rsp_imp = null);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    if(req_imp==null) begin
      $cast(req_imp, imp);
    end
    if(rsp_imp==null) begin
      $cast(rsp_imp, imp);
    end
    m_req_imp = req_imp;
    m_rsp_imp = rsp_imp;
    m_if_mask = ((1<<4)    | (1<<5) | (1<<6) | (1<<10));
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_slave_imp";
  endfunction
  function bit try_put (RSP t);
    return m_rsp_imp.try_put(t);
  endfunction
  function bit can_put();
    return m_rsp_imp.can_put();
  endfunction
  function bit try_get (output REQ t);
    return m_req_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_req_imp.can_get();
  endfunction
  function bit try_peek (output REQ t);
    return m_req_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_req_imp.can_peek();
  endfunction
endclass
class uvm_slave_imp #(type REQ=int, type RSP=REQ, type IMP=int,
                      type REQ_IMP=IMP, type RSP_IMP=IMP)
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ));
  typedef IMP     this_imp_type;
  typedef REQ_IMP this_req_type;
  typedef RSP_IMP this_rsp_type;
  local this_req_type m_req_imp;
  local this_rsp_type m_rsp_imp;
  function new (string name, this_imp_type imp,
                this_req_type req_imp = null, this_rsp_type rsp_imp = null);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    if(req_imp==null) begin
      $cast(req_imp, imp);
    end
    if(rsp_imp==null) begin
      $cast(rsp_imp, imp);
    end
    m_req_imp = req_imp;
    m_rsp_imp = rsp_imp;
    m_if_mask = (((1<<0)       | (1<<1) | (1<<2) | (1<<10))    | ((1<<4)    | (1<<5) | (1<<6) | (1<<10)));
  endfunction
  virtual function string get_type_name();
    return "uvm_slave_imp";
  endfunction
  task put (RSP t);
    m_rsp_imp.put(t);
  endtask
  function bit try_put (RSP t);
    return m_rsp_imp.try_put(t);
  endfunction
  function bit can_put();
    return m_rsp_imp.can_put();
  endfunction
  task get (output REQ t);
    m_req_imp.get(t);
  endtask
  task peek (output REQ t);
    m_req_imp.peek(t);
  endtask
  function bit try_get (output REQ t);
    return m_req_imp.try_get(t);
  endfunction
  function bit can_get();
    return m_req_imp.can_get();
  endfunction
  function bit try_peek (output REQ t);
    return m_req_imp.try_peek(t);
  endfunction
  function bit can_peek();
    return m_req_imp.can_peek();
  endfunction
endclass
class uvm_blocking_transport_imp #(type REQ=int, type RSP=REQ, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<3);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_transport_imp";
  endfunction
  task transport (REQ req, output RSP rsp);
    m_imp.transport(req, rsp);
  endtask
endclass
class uvm_nonblocking_transport_imp #(type REQ=int, type RSP=REQ, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = (1<<7);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_transport_imp";
  endfunction
  function bit nb_transport (REQ req, output RSP rsp);
    return m_imp.nb_transport(req, rsp);
  endfunction
endclass
class uvm_transport_imp #(type REQ=int, type RSP=REQ, type IMP=int)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  local IMP m_imp;
  function new (string name, IMP imp);
    super.new (name, imp, UVM_IMPLEMENTATION, 1, 1);
    m_imp = imp;
    m_if_mask = ((1<<3) | (1<<7));
  endfunction
  virtual function string get_type_name();
    return "uvm_transport_imp";
  endfunction
  task transport (REQ req, output RSP rsp);
    m_imp.transport(req, rsp);
  endtask
  function bit nb_transport (REQ req, output RSP rsp);
    return m_imp.nb_transport(req, rsp);
  endfunction
endclass
class uvm_blocking_put_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (1<<0);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_put_port";
  endfunction
  task put (T t);
    this.m_if.put(t);
  endtask
endclass
class uvm_nonblocking_put_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (1<<4);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_put_port";
  endfunction
  function bit try_put (T t);
    return this.m_if.try_put(t);
  endfunction
  function bit can_put();
    return this.m_if.can_put();
  endfunction
endclass
class uvm_put_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<0)    | (1<<4));
  endfunction
  virtual function string get_type_name();
    return "uvm_put_port";
  endfunction
  task put (T t);
    this.m_if.put(t);
  endtask
  function bit try_put (T t);
    return this.m_if.try_put(t);
  endfunction
  function bit can_put();
    return this.m_if.can_put();
  endfunction
endclass
class uvm_blocking_get_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (1<<1);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_get_port";
  endfunction
  task get (output T t);
    this.m_if.get(t);
  endtask
endclass
class uvm_nonblocking_get_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (1<<5);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_get_port";
  endfunction
  function bit try_get (output T t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_get();
  endfunction
endclass
class uvm_get_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<1)    | (1<<5));
  endfunction
  virtual function string get_type_name();
    return "uvm_get_port";
  endfunction
  task get (output T t);
    this.m_if.get(t);
  endtask
  function bit try_get (output T t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_get();
  endfunction
endclass
class uvm_blocking_peek_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (1<<2);
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_peek_port";
  endfunction
  task peek (output T t);
    this.m_if.peek(t);
  endtask
endclass
class uvm_nonblocking_peek_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (1<<6);
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_peek_port";
  endfunction
  function bit try_peek (output T t);
    return this.m_if.try_peek(t);
  endfunction
  function bit can_peek();
    return this.m_if.can_peek();
  endfunction
endclass
class uvm_peek_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<2)   | (1<<6));
  endfunction
  virtual function string get_type_name();
    return "uvm_peek_port";
  endfunction
  task peek (output T t);
    this.m_if.peek(t);
  endtask
  function bit try_peek (output T t);
    return this.m_if.try_peek(t);
  endfunction
  function bit can_peek();
    return this.m_if.can_peek();
  endfunction
endclass
class uvm_blocking_get_peek_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<1)    | (1<<2));
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_get_peek_port";
  endfunction
  task get (output T t);
    this.m_if.get(t);
  endtask
  task peek (output T t);
    this.m_if.peek(t);
  endtask
endclass
class uvm_nonblocking_get_peek_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<5) | (1<<6));
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_get_peek_port";
  endfunction
  function bit try_get (output T t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_get();
  endfunction
  function bit try_peek (output T t);
    return this.m_if.try_peek(t);
  endfunction
  function bit can_peek();
    return this.m_if.can_peek();
  endfunction
endclass
class uvm_get_peek_port #(type T=int)
  extends uvm_port_base #(uvm_tlm_if_base #(T,T));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (((1<<1)    | (1<<5)) | ((1<<2)   | (1<<6)));
  endfunction
  virtual function string get_type_name();
    return "uvm_get_peek_port";
  endfunction
  task get (output T t);
    this.m_if.get(t);
  endtask
  task peek (output T t);
    this.m_if.peek(t);
  endtask
  function bit try_get (output T t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_get();
  endfunction
  function bit try_peek (output T t);
    return this.m_if.try_peek(t);
  endfunction
  function bit can_peek();
    return this.m_if.can_peek();
  endfunction
endclass
class uvm_blocking_master_port #(type REQ=int, type RSP=REQ)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<0)       | (1<<1) | (1<<2) | (1<<9));
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_master_port";
  endfunction
  task put (REQ t);
    this.m_if.put(t);
  endtask
  task get (output RSP t);
    this.m_if.get(t);
  endtask
  task peek (output RSP t);
    this.m_if.peek(t);
  endtask
endclass
class uvm_nonblocking_master_port #(type REQ=int, type RSP=REQ)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<4)    | (1<<5) | (1<<6) | (1<<9));
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_master_port";
  endfunction
  function bit try_put (REQ t);
    return this.m_if.try_put(t);
  endfunction
  function bit can_put();
    return this.m_if.can_put();
  endfunction
  function bit try_get (output RSP t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_get();
  endfunction
  function bit try_peek (output RSP t);
    return this.m_if.try_peek(t);
  endfunction
  function bit can_peek();
    return this.m_if.can_peek();
  endfunction
endclass
class uvm_master_port #(type REQ=int, type RSP=REQ)
  extends uvm_port_base #(uvm_tlm_if_base #(REQ, RSP));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = (((1<<0)       | (1<<1) | (1<<2) | (1<<9))    | ((1<<4)    | (1<<5) | (1<<6) | (1<<9)));
  endfunction
  virtual function string get_type_name();
    return "uvm_master_port";
  endfunction
  task put (REQ t);
    this.m_if.put(t);
  endtask
  function bit try_put (REQ t);
    return this.m_if.try_put(t);
  endfunction
  function bit can_put();
    return this.m_if.can_put();
  endfunction
  task get (output RSP t);
    this.m_if.get(t);
  endtask
  task peek (output RSP t);
    this.m_if.peek(t);
  endtask
  function bit try_get (output RSP t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_get();
  endfunction
  function bit try_peek (output RSP t);
    return this.m_if.try_peek(t);
  endfunction
  function bit can_peek();
    return this.m_if.can_peek();
  endfunction
endclass
class uvm_blocking_slave_port #(type REQ=int, type RSP=REQ)
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<0)       | (1<<1) | (1<<2) | (1<<10));
  endfunction
  virtual function string get_type_name();
    return "uvm_blocking_slave_port";
  endfunction
  task put (RSP t);
    this.m_if.put(t);
  endtask
  task get (output REQ t);
    this.m_if.get(t);
  endtask
  task peek (output REQ t);
    this.m_if.peek(t);
  endtask
endclass
class uvm_nonblocking_slave_port #(type REQ=int, type RSP=REQ)
  extends uvm_port_base #(uvm_tlm_if_base #(RSP, REQ));
  function new (string name, uvm_component parent,
                int min_size=1, int max_size=1);
    super.new (name, parent, UVM_PORT, min_size, max_size);
    m_if_mask = ((1<<4)    | (1<<5) | (1<<6) | (1<<10));
  endfunction
  virtual function string get_type_name();
    return "uvm_nonblocking_slave_port";
  endfunction
  function bit try_put (RSP t);
    return this.m_if.try_put(t);
  endfunction
  function bit can_put();
    return this.m_if.can_put();
  endfunction
  function bit try_get (output REQ t);
    return this.m_if.try_get(t);
  endfunction
  function bit can_get();
    return this.m_if.can_