---
myst:
  html_meta:
    keywords: LaTeX, domaines spécialisés, mathématiques, structures, 
              opérateurs
---

# Comment déclarer de nouveaux opérateurs mathématiques ?

## Avec l'extension <ctanpkg:mathtools>

Pour cela, vous pouvez utiliser la commande `\mathop`. Par exemple :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\newcommand{\diag}{\mathop{\mathrm{diag}}}
\[  \diag_1^n  \]
\end{document}
```

Les indices et les exposants associés à `\diag` seront placés en dessous 
et au-dessus du nom de la fonction, comme ils le sont pour la commande `\sum`.
Si vous voulez que vos indices et exposants soient toujours placés à droite,
utilisez la commande `\nolimits`. Pour plus d'information, vous pouvez 
consulter la question 
"[](/4_domaines_specialises/mathematiques/structures/operateurs/changer_la_position_des_limites_autour_des_sommes_et_integrales)".

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

\begin{document}
\newcommand{\diag}{\mathop{\mathrm{diag}}\nolimits}
\[  \diag_1^n  \]
\end{document}
```

L'extension <ctanpkg:mathtools> charge l'extension <ctanpkg:amsmath> qui,
elle-même, charge l'extension <ctanpkg:amsopn>. Cette dernière
fournit une commande `\DeclareMathOperator` qui effectue le même travail
que la deuxième définition ci-dessus :

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \DeclareMathOperator{\diag}{diag}

\begin{document}
\[  \diag_1^n  \]
\end{document}
```

Pour créer notre commande `\diag` originale, il faut utiliser 
la commande étoilée `\DeclareMathOperator*` qui génère un opérateur 
qui a toujours ses exposants et exposants.

```
\documentclass{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \pagestyle{empty}           % N'affiche pas de numéro de page
  \usepackage{mathtools}

  \DeclareMathOperator*{\diag}{diag}

\begin{document}
\[  \diag_1^n  \]
\end{document}
```

La commande `\operatorname` de l'extension <ctanpkg:amsopn> vous permet 
d'introduire des opérateurs *ad hoc* directement dans vos mathématiques. 
Vous pouvez donc saisir :

```{noedit}
\[  \operatorname{truc}(bidule)  \]
```

Ceci sera équivalent à :

```{noedit}
% Dans le préambule
\DeclareMathOperator{\truc}{truc}
% (...)
% Dans le document
\[  \truc(bidule)  \]
```

Comme pour `\DeclareMathOperator`, il existe une version étoilée 
`\operatorname*` pour gérer la position des indices et exposants.