---
myst:
  html_meta:
    keywords: LaTeX, composition, texte, symboles, polices, italique, romain, glyphe, caractère, 
              commande, bascule, vocabulaire typographique
---

# Comment mettre du texte en italique ?

"Le caractère italique est utilisé principalement pour attirer l’attention 
du lecteur sur un mot, une phrase ou un passage que l’auteur tient à [mettre en évidence].\
Il est donc évident que tout abus de l’italique en diminue l’efficacité." — Imprimerie nationale

Plusieurs commandes de mise en forme du texte sont disponibles pour obtenir de l'italique :

- la commande `\emph{}` prend en argument le texte à composer en italique. 
  Elle est limitée à la composition d'un paragraphe ;

- la bascule `{\itshape ...}` compose le texte qui suit en italique.
  La bascule et le texte concerné sont alors mis entre accolades. 
  Exemple : `{\itshape ⟨ce texte sera composé en italique⟩}.` ;

- la commande `\textit{}`.

Si la phrase est elle-même écrite en italique, 
le romain est alors utilisé pour *mettre en évidence* un mot, un passage.
La commande `\emph{}` tient compte du contexte pour décider si l'italique 
ou le romain doit s'appliquer.

```
\documentclass[french]{article}
  \usepackage[T1]{fontenc}    % Encodage T1 (adapté au français)
  \usepackage{lmodern}        % Caractères plus lisibles
  \usepackage{babel}          % Réglages linguistiques (avec french)
  \pagestyle{empty}           % N'affiche pas de numéro de page

\begin{document}
\og{}Les lettres italiques du début de la Renaissance sont dites 
\emph{aldines}, en hommage à l'éditeur et érudit Alde Manuce, qui commanda
le premier caractère incliné à Francesco Griffo en 1499.\fg{}

— Robert \textsc{Bringhurst}, \emph{Principes élémentaires de la 
typographie}, p.~150.

\vskip20pt
{\itshape
  \centerline{AU LECTEUR}
  \vskip10pt
C'est icy un livre de bonne foy, lecteur. Il t'advertit dés l'entrée, 
que je ne m'y suis proposé aucune fin, que domestique et privée. 
Je n'y ay eu nulle consideration de ton service, ny de ma gloire. 
Mes forces ne sont pas capables d'un tel dessein. Je l'ay voué à la 
commodité particuliere de mes parens et amis : à ce que m'ayant perdu 
(ce qu'ils ont à faire bien tost) ils y puissent retrouver aucuns traits
 de mes conditions et humeurs, et que par ce moyen ils nourrissent 
 plus entiere et plus vifve la connoissance qu'ils ont eu de moy. 
 Si c'eust esté pour rechercher la faveur du monde, je me fusse 
 mieux paré et me presenterois en une marche estudiée. Je veus qu'on 
 m'y voie en ma façon simple, naturelle et ordinaire, sans contantion 
 et artifice : car c'est moy que je peins. Mes defauts s'y liront au vif,
 et ma forme naïfve, autant que la reverence publique me l'a permis. 
 Que si j'eusse esté entre ces nations qu'on dict vivre encore sous la
 douce liberté des premieres loix de nature, je t'asseure que je m'y fusse
 très-volontiers peint tout entier, et tout nud. Ainsi, lecteur, je suis
 moy-mesmes la matiere de mon livre : ce n'est pas raison que tu employes
 ton loisir en un subjet si frivole et si vain. A Dieu donq ; de Montaigne,
 ce premier de Mars mille cing cens quatre ving. 
}

— \textsc{Montaigne}, \emph{Essais}, \og{}préface\fg{}.

\vskip20pt
\emph{Une phrase en italique avec \emph{a posteriori} une locution 
étrangère en romain.}
\end{document}
```

:::{seealso}
Des commandes et des bascules sont disponibles pour mettre en petites capitales, 
avec une police sans empattement, à chasse fixe, en gras, etc. 
Voir la page "[](/3_composition/texte/symboles/polices/changer_la_forme_d_une_fonte)".
:::
