% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{expandDoubleVert}
\alias{expandDoubleVert}
\alias{RHSForm<-}
\alias{sumTerms}
\alias{reOnly}
\alias{makeOp}
\alias{addForm0}
\alias{addForm}
\alias{expandAllGrpVar}
\alias{findbars_x}
\alias{findbars}
\alias{inForm}
\alias{extractForm}
\alias{dropHead}
\alias{drop.special}
\alias{replaceForm}
\title{expand double-bar RE notation by splitting}
\usage{
expandDoubleVert(term)

RHSForm(formula) <- value

sumTerms(termList)

reOnly(f, response = FALSE, bracket = TRUE, doublevert_split = TRUE)

makeOp(x, y, op = NULL)

addForm0(f1, f2)

addForm(...)

expandAllGrpVar(bb)

findbars_x(
  term,
  debug = FALSE,
  specials = character(0),
  default.special = "us",
  target = "|",
  expand_doublevert_method = c("diag_special", "split")
)

findbars(term)

inForm(form, value)

extractForm(term, value)

dropHead(term, value)

drop.special(x, value = quote(offset), preserve = NULL)

replaceForm(term, target, repl)
}
\arguments{
\item{term}{expression/formula}

\item{formula}{a formula object}

\item{value}{term to remove from formula}

\item{termList}{a list of formula terms}

\item{f}{a formula}

\item{response}{include response variable?}

\item{bracket}{bracket-protect terms?}

\item{doublevert_split}{(logical) TRUE for lme4 back-compatibility; FALSE to make double vertical bars into \code{diag()} eterms}

\item{x}{formula}

\item{y}{a formula term (or an operator)}

\item{op}{an operator}

\item{f1}{formula #1}

\item{f2}{formula #2}

\item{...}{arguments to pass through to \code{addForm0}}

\item{bb}{a list of naked grouping variables, i.e. 1 | f}

\item{debug}{(logical) debug?}

\item{specials}{list of special terms}

\item{default.special}{character: special to use for parenthesized terms - i.e. random effects terms with unspecified structure}

\item{expand_doublevert_method}{method for handling \code{||} operator: split into separate terms or replace by \code{diag}? Inherited from \emph{previous call where it was specified}.
\enumerate{
\item atom (not a call or an expression): NULL
\item special, i.e. foo(...) where "foo" is in specials: return term
\item parenthesized term: \emph{if} the head of the head is | (i.e.
it is of the form (xx|gg), then convert it to the default
special type; we won't allow pathological cases like
((xx|gg)) ... can we detect them?
}}

\item{preserve}{(integer) retain the specified occurrence of "value"}
}
\value{
a list of expressions
}
\description{
Modeled after lme4:::expandSlash, by Doug Bates. However,
all formula operators that apply to factors (\code{*}, \code{/}, \code{+})
are applicable: the results are expanded into a list of independent (additive)
random effect terms
}
\examples{
f <- y ~ 1 + x
RHSForm(f) <- quote(2+x^2)
print(f)
reOnly(~ 1 + x + y + (1|f) + (1|g))
addForm0(y~x,~1)
addForm0(~x,~y)
ff <- findbars_x(y~1+(x|f/g))
expandAllGrpVar(ff)
expandAllGrpVar(quote(1|(f/g)/h))
expandAllGrpVar(quote(1|f/g/h))
expandAllGrpVar(quote(1|f*g))
expandAllGrpVar(quote(1|f+g))
expandAllGrpVar(quote(a+b|f+g+h*i))
expandAllGrpVar(quote(s(log(d), k = 4)))
expandAllGrpVar(quote(s(log(d+1))))
splitForm(quote(us(1|x,n=2)))
findbars_x(~ 1 + (x + y || g), expand_doublevert_method = "diag_special")
findbars_x(~ 1 + (x + y || g), expand_doublevert_method = "split")
findbars_x(~ 1 + (1 | f) + (1 | g))
findbars_x(~ 1 + (1 | f) + (1 | g))
findbars_x(~ 1 + (1|h) + (x + y || g), expand_doublevert_method = "split")
findbars_x(~ 1 + (1|Subject))
findbars_x(~ (1||Subject))
findbars_x(~ (1|Subject))
findbars_x(~ (1|Subject), default.special = NULL)
findbars_x(~ 1 + x)
findbars_x(~ s(x, bs = "tp"))
findbars_x(y ~ a + log(b) + s(x, bs = "tp") + s(y, bs = "gp"),
   target = "s", default.special = NULL)
findbars(~ 1 + (x + y || g))
findbars(~ 1 + (1 | f) + (1 | g))
findbars(~ 1 + (1|h) + (x + y || g))
findbars(~ 1 + (1|Subject))
findbars(~  1 + (1||Subject))
findbars(~ (1||Subject))
findbars(~ 1 + x)
inForm(z~.,quote(.))
inForm(z~y,quote(.))
inForm(z~a+b+c,quote(c))
inForm(z~a+b+(d+e),quote(c))
f <- ~ a + offset(x)
f2 <- z ~ a
inForm(f,quote(offset))
inForm(f2,quote(offset))
extractForm(~a+offset(b),quote(offset))
extractForm(~c,quote(offset))
extractForm(~a+offset(b)+offset(c),quote(offset))
extractForm(~offset(x),quote(offset))
dropHead(~a+offset(b),quote(offset))
dropHead(~a+poly(x+z,3)+offset(b),quote(offset))
drop.special(x~a + b+ offset(z))
replaceForm(quote(a(b+x*c(y,z))),quote(y),quote(R))
ss <- ~(1 | cask:batch) + (1 | batch)
replaceForm(ss,quote(cask:batch),quote(batch:cask))
replaceForm(ss, quote(`:`), quote(`\%:\%`))
}
\keyword{internal}
