% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backend-oracle.R
\name{backend-oracle}
\alias{simulate_oracle}
\title{Backend: Oracle}
\usage{
simulate_oracle()
}
\description{
See \code{vignette("translation-function")} and \code{vignette("translation-verb")} for
details of overall translation technology. Key differences for this backend
are:
\itemize{
\item Use \verb{FETCH FIRST} instead of \code{LIMIT}
\item Custom types
\item \code{paste()} uses \code{||}
\item Custom subquery generation (no \code{AS})
\item \code{setdiff()} uses \code{MINUS} instead of \code{EXCEPT}
}

Note that versions of Oracle prior to 23c have limited supported for
\code{TRUE} and \code{FALSE} and you may need to use \code{1} and \code{0} instead.
See \url{https://oracle-base.com/articles/23/boolean-data-type-23} for
more details.

Use \code{simulate_oracle()} with \code{lazy_frame()} to see simulated SQL without
converting to live access database.
}
\examples{
library(dplyr, warn.conflicts = FALSE)

lf <- lazy_frame(a = TRUE, b = 1, c = 2, d = "z", con = simulate_oracle())
lf \%>\% transmute(x = paste0(c, " times"))
lf \%>\% setdiff(lf)
}
