# Use these commands to generate the LAMMPS input script and data file
# (and other auxilliary files):


# Create LAMMPS input files this way:
cd moltemplate_files

  # First, rescale and interpolate the positions
  # where the monomers will be located.  (This step is
  # not needed if the coords_orig.raw file already has correct coordinates.)

  ./interpolate_coords.py 32768 1.6198059 < coords_orig.raw > coords.raw

  # Then, build the "system.lt" file

  ./generate_system_lt.py 32768 51 < coords.raw > system.lt

  # 32768 is the number of monomers in the polymer
  # (which may be different from the number of coordinates
  # in the "coords_orig.raw" file)  This number will vary
  # depending on how long you want the polymer to be.
  # The second argument "51" is the average interval between
  # condensin anchors (IE the "loop size" in monomers.)


  # Run moltemplate

  moltemplate.sh system.lt -a "@bond:stage1 1" \
                           -a "@bond:stage2 2" \
                           -a "@atom:Monomer/A 1"

  # This will generate various files with names ending in *.in* and *.data.
  # These files are the input files directly read by LAMMPS.  Move them to
  # the parent directory (or wherever you plan to run the simulation).
  #
  # We used the "-a" command to set the variable @bond:condensin to "2"
  # because we will refer to it later in the "run.in" LAMMPS input script.
  # (Of coarse, LAMMPS knows nothing about moltemplate variables,
  #  so in that file we refer to it as dihedral type "1")

  mv -f system.in* system.data ../

  # We also need the table of bond forces used during "stage 2".
  # (Like the system.data and the various input scripts, this file is needed by
  #  LAMMPS, so we need to copy it to the directory where we will run the sim.)
  cp -f table_bonds_stage2.dat ../

  # Optional:
  # The "./output_ttree/" directory is full of temporary files generated by
  # moltemplate.  They can be useful for debugging, but are usually thrown away.
  rm -rf output_ttree/

  # Optional:
  # Remove the "system.lt" file created by "generate_system_lt.py"
  #rm -f system.lt

cd ../

