cleanup_moltemplate.sh
===========

## Description
**cleanum_moltemplate.sh** is a simple script which attempts to discard
sections of the LAMMPS DATA file and INPUT scripts which contain definitions
of atom types, bond types, angle types, dihedral types, or improper types
which are not needed in the current simulation.

It is assumed that the LAMMPS DATA and INPUT files that you are simplifying
were created by moltemplate.sh.  However this is not required.
(Read the [*Limitations*](#Limitations) below.)

For most files, this process is automatic.
However sometimes additional manual editing is necessary.
Again, be sure to read the [*Limitations*](#Limitations) below.


## Usage

```
cleanup_moltemplate.sh [-base BASE_NAME] [-ignore-comments]
```

## Typical usage
```
cleanup_moltemplate.sh  # (no arguments)
```


## Optional Arguments

### -base BASE_NAME
By default, this script assumes that your LAMMPS DATA file is named
"system.data", and your LAMMPS INPUT scripts have names beginning
with "system.in.".
If these files begin with a different string (eg \"BASE_NAME\"),
then you run cleanup_moltemplate.sh with the "-base BASE_NAME" argument
*(Note that the beginning of all of these file names must agree.)*

### -ignore-comments

By default, this program will attempt to infer atom type names from comments
that are added to the "Masses" section of the DATA file (which are usually
automatically generated by moltemplate.sh by default).
This might cause problems if you have placed your own comments in the
"Data Masses" section of your LT files because spaces in atom type names
will often confuse moltemplate.sh
You can get around this issue by using the "-ignore-comments" argument,
which will replace all of the atom type names with "type1", "type2", ...

```
cleanup_moltemplate.sh -ignore-comments
```

## Limitations

If there are multiple input scripts, then the input script which specifies
the atom_style, pair_style, bond_style, angle_style, dihedral_style,
and improper_style (if applicable) should appear first when listed
alphabetically.  IE. The name of that file must be earlier than the
names of the other files, lexicographically.

This program uses "ltemplify.py" to parse these files and discard unused
atom types.  Consequently is subject to the same limitations that
"ltemplify.py" has.  As of 2020-10-10, this includes the inability to
understand many-body pair styles.
It also sometimes has difficulty understanding "*" wildcards when they
appear inside "coeff" commands.
(See the [ltemplify.py documentation](doc_ltemplify.md) for details.)
