[Setup]
AppName=MineXpert3

; Set version number below
#define version "10.2.0-build-20251130-fd49b84f"
AppVersion={#version}

#define public buildtype "Release"

#define public arch "vcrt64"
#define public platform "win10"
#define public buildsystem "MXE"

;;;;;; On Wine, z: drive is configured to point to /home/rusconi
;;;;;; Check the winecfg window's Drives tab

#define sourceDir "z:/devel/minexpert/development"

#define buildDir "z:/devel/minexpert/build-area/mxe"

#define docBuildDir "z:/devel/minexpert/build-area/unix/doc/user-manual"

;;;;; When a documentation set (PDF, HTML) has been successfully built, that set
;;;;; is copied to this directory for MXE winpackage target consumption.
#define localDocStore "z:/devel/msxpertsuite-store/docs/minexpert"

#define mxeDllDir "z:/devel/mxe/dll-set-for-packages"


; Set version number below
AppVerName=MineXpert3 version {#version}
DefaultDirName={commonpf}\MineXpert3
DefaultGroupName=MineXpert3
OutputDir="{#sourceDir}\winInstaller"

OutputBaseFilename=MineXpert3-{#platform}-{#buildsystem}-{#arch}-v{#version}-{#buildtype}-setup
OutputManifestFile=MineXpert3-{#platform}-{#buildsystem}-{#arch}-v{#version}-{#buildtype}-setup-manifest.txt
ArchitecturesAllowed=x64
ArchitecturesInstallIn64BitMode=x64

LicenseFile="{#sourceDir}/LICENSE"
AppCopyright="Copyright (C) 2009-2025 Filippo Rusconi"

SetupIconFile={#sourceDir}/images/icons/MineXpert3.ico

AllowNoIcons=yes
AlwaysShowComponentsList=yes
AllowRootDirectory=no
AllowCancelDuringInstall=yes
AppComments=MineXpert3, by Filippo Rusconi"
AppContact="Filippo Rusconi, PhD, Researcher at CNRS, France"
CloseApplications=yes
CreateUninstallRegKey=yes
DirExistsWarning=yes
WindowResizable=yes
WizardImageFile="{#sourceDir}\images\splashscreen.png"
WizardImageStretch=yes

[Dirs]
;; Name: "{app}\data"
Name: "{app}\doc"

[Files]
Source: "{#mxeDllDir}/*"; DestDir: {app}; Flags: ignoreversion recursesubdirs;

Source: "{#sourceDir}/doc/history.html"; DestDir: {app}\doc;

Source: "{#buildDir}/src/MineXpert3.exe"; DestDir: {app};

;; Source: "{#sourceDir}/data/*"; DestDir: {app}\data; Flags: recursesubdirs;

;; The icon (multi-resolution icon file)
Source: {#sourceDir}/images/icons/MineXpert3.ico; DestDir: {app}

Source: "{#localDocStore}/MineXpert3-doc.pdf"; DestDir: {app}\doc;
Source: "{#localDocStore}/html/user-manual/*"; Flags: recursesubdirs; DestDir: {app}\doc\html;

[Icons]
Name: "{group}\MineXpert3"; Filename: "{app}\MineXpert3.exe"; WorkingDir: "{app}"
Name: "{group}\Uninstall MineXpert3"; Filename: "{uninstallexe}"

[Run]
Filename: "{app}\MineXpert3.exe"; Description: "Launch MineXpert3"; Flags: postinstall nowait unchecked
