// test.qml
import QtQuick 2.15
import QtQuick.Controls 2.15
import QtQuick.Dialogs
import QtQuick.Controls.Basic
import Ellipse
import PappsoMS 1.0

ApplicationWindow {
    width: 640
    height: 480
    visible: true
    title: qsTr("QML Integrations Basics")

    footer: Button {
        text: qsTr("Call Q_INVOKABLE method to reset ellipse's properties")
        onClicked: {
            slider.value = dp1.x
            ellipse.setProperties(slider.value, "blue")
        }
    }

    DataPoint {
        id: dp1
        x : 1234.1234
        //y : 4567.4567

        Component.onCompleted: {
            console.log("Property test for DataPoint:",
                typeof dp1.x,
                dp1.x);

            Qt.callLater(() => {
                dp1.x = 123.456; // Test async setter
            });
        }
    }


    MzIntegrationParams {
        id: params
        smallestMz : 40
        greatestMz : 1200

        onSmallestMzChanged: console.log("QML received signal!")

        Component.onCompleted: {
            console.log("Property test for MzIntegrationParams:",
                typeof params.smallestMz,
                params.smallestMz);

            Qt.callLater(() => {
                params.smallestMz = 123.456; // Test async setter
            });
        }
    }

    // params.updateSmallestMz(123.123)

    Trace {
        id: trace1
    }

    header: Column {
        width: parent.width

        Button {
            width: parent.width
            text: qsTr("Select ellipse's color")
            onClicked: { colorDialog.open() }
        }

        Label {
            width: parent.width
            text: qsTr("Resize ellipse's border")
        }

        Slider {
            id: slider

            width: parent.width
            value: 25
            from: 0
            to: Math.min(ellipse.width, ellipse.height) / 2
        }
    }

    Column {
        anchors.centerIn: parent
        spacing: 10

        Text {
            text: "MzIntegrationParams Test"
            font.pixelSize: 20
        }

        // Add UI elements to interact with your class
        Button {
            text: "Test Function"
            onClicked: {
                console.log("Current params:", params)
                // Call methods or access properties here
            }
        }
    }

    Ellipse {
        id: ellipse

        anchors.centerIn: parent
        width: 200
        height: 200
        color: "blue"
        border: slider.value

        onColorChanged: { ellipseInfo() }
    }

    ColorDialog {
        id: colorDialog

        selectedColor: ellipse.color
        onAccepted: { ellipse.color = selectedColor
        }
    }
}
