message("WIN10-MINGW64 environment https://www.msys2.org/")
message("Please run the configuration like this:")
message("cmake -G \"Unix Makefiles\" -DCMAKE_BUILD_TYPE=Debug ../development")

# Comment out these two lines that make the build fail with #include_next math.h
# file not found error.
# set(CMAKE_C_IMPLICIT_INCLUDE_DIRECTORIES "c:/msys64/mingw64/include")
# set(CMAKE_CXX_IMPLICIT_INCLUDE_DIRECTORIES "c:/msys64/mingw64/include")

# This is used throughout all the build system files
set(TARGET ${CMAKE_PROJECT_NAME})

set(SHIPPED_DLLS_DIR "${HOME_DEVEL_DIR}/dll-set-for-packages")


configure_file(${CMAKE_SOURCE_DIR}/CMakeStuff/${LOWCASE_PROJECT_NAME}-win10-ucrt64.iss.in
  ${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-win10-ucrt64.iss @ONLY)

configure_file(${CMAKE_SOURCE_DIR}/CMakeStuff/${LOWCASE_PROJECT_NAME}-win10-ucrt64.nsis.in
  ${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-win10-ucrt64.nsis @ONLY)

find_package(
    Qt6 REQUIRED
    COMPONENTS Widgets
               Xml
               Svg
               SvgWidgets
               PrintSupport
               Network
               Qml
               Sql
               Concurrent
               Core5Compat
               GLOBAL
)


find_package(SQLite3 REQUIRED)

set(QCustomPlotQt6_FOUND 1)
set(QCustomPlotQt6_INCLUDE_DIRS "${HOME_DEVEL_DIR}/qcustomplot/development")
# Note the QCustomPlotQt6_LIBRARIES (plural) because on Debian, the
# QCustomPlotQt6Config.cmake file has this variable name (see the unix-specific
# toolchain file.
set(QCustomPlotQt6_LIBRARIES "${SHIPPED_DLLS_DIR}/libQCustomPlotQt6.dll")
# Per instructions of the lib author:
# https://www.qcustomplot.com/index.php/tutorials/settingup
message(STATUS "Setting definition -DQCUSTOMPLOT_USE_LIBRARY.")
if(NOT TARGET QCustomPlotQt6::QCustomPlotQt6)
	add_library(QCustomPlotQt6::QCustomPlotQt6 UNKNOWN IMPORTED)
	set_target_properties(QCustomPlotQt6::QCustomPlotQt6 PROPERTIES
		IMPORTED_LOCATION             "${QCustomPlotQt6_LIBRARIES}"
		INTERFACE_INCLUDE_DIRECTORIES "${QCustomPlotQt6_INCLUDE_DIRS}"
		INTERFACE_COMPILE_DEFINITIONS QCUSTOMPLOT_USE_LIBRARY
		)
endif()

find_package(ZLIB REQUIRED)

set(IsoSpec++_FOUND 1)
set(IsoSpec++_INCLUDE_DIRS "${HOME_DEVEL_DIR}/isospec/development")
set(IsoSpec++_LIBRARIES "${SHIPPED_DLLS_DIR}/libIsoSpec++.dll")
if(NOT TARGET IsoSpec++::IsoSpec++)
  add_library(IsoSpec++::IsoSpec++ UNKNOWN IMPORTED)
  set_target_properties(IsoSpec++::IsoSpec++ PROPERTIES
    IMPORTED_LOCATION             "${IsoSpec++_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${IsoSpec++_INCLUDE_DIRS}")
endif()


set(QScintilla_FOUND 1)
set(QScintilla_INCLUDE_DIRS "c:/msys64/ucrt64/include/qt6/Qsci")
set(QScintilla_LIBRARIES "${SHIPPED_DLLS_DIR}/qscintilla2_qt6.dll")
if(NOT TARGET QScintilla::QScintilla)
    add_library(QScintilla::QScintilla UNKNOWN IMPORTED)
    set_target_properties(
        QScintilla::QScintilla PROPERTIES IMPORTED_LOCATION "${QScintilla_LIBRARIES}" INTERFACE_INCLUDE_DIRECTORIES
                                                                                      "${QScintilla_INCLUDE_DIRS}"
    )
endif()


# find_package(QuaZip-Qt6 REQUIRED)


set(PwizLite_FOUND 1)
set(PwizLite_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pwizlite/development/src")
set(PwizLite_LIBRARIES "${HOME_DEVEL_DIR}/pwizlite/build-area/mingw64/src/libpwizlite.dll")
if(NOT TARGET PwizLite::PwizLite)

  add_library(PwizLite::PwizLite UNKNOWN IMPORTED)

  set_target_properties(PwizLite::PwizLite PROPERTIES
    IMPORTED_LOCATION             "${PwizLite_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${PwizLite_INCLUDE_DIRS}"
    )
endif()


set(PappsoMSpp_FOUND 1)
set(PappsoMSpp_INCLUDE_DIRS "${HOME_DEVEL_DIR}/pappsomspp/development/src")
set(PappsoMSpp_LIBRARIES
  "${SHIPPED_DLLS_DIR}/libpappsomspp-core.dll")
if(NOT TARGET PappsoMSpp::Core)

  add_library(PappsoMSpp::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Core PROPERTIES
    IMPORTED_LOCATION ${PappsoMSpp_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()

set(PappsoMSppGui_FOUND 1)
set(PappsoMSppGui_LIBRARIES
  "${SHIPPED_DLLS_DIR}/libpappsomspp-gui.dll")
if(NOT TARGET PappsoMSpp::Gui)

  add_library(PappsoMSpp::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(PappsoMSpp::Gui PROPERTIES
    IMPORTED_LOCATION ${PappsoMSppGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${PappsoMSpp_INCLUDE_DIRS})

endif()

include_directories(${include_directories} ${PappsoMSpp_INCLUDE_DIRS} ${PappsoMSpp_INCLUDE_DIRS})


set(XpertMass_FOUND 1)
set(XpertMass_INCLUDE_DIRS "${HOME_DEVEL_DIR}/xpertmass/development/source/XpertMassCore/includes")
set(XpertMass_LIBRARIES "${SHIPPED_DLLS_DIR}/libXpertMassCore.dll")
if(NOT TARGET XpertMass::Core)

  add_library(XpertMass::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(XpertMass::Core PROPERTIES
    IMPORTED_LOCATION ${XpertMass_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${XpertMass_INCLUDE_DIRS})

endif()

set(XpertMassGui_INCLUDE_DIRS "${HOME_DEVEL_DIR}/xpertmass/development/source/XpertMassGui/includes")
set(XpertMassGui_LIBRARIES "${SHIPPED_DLLS_DIR}/libXpertMassGui.dll")
if(NOT TARGET XpertMass::Gui)

  add_library(XpertMass::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(XpertMass::Gui PROPERTIES
    IMPORTED_LOCATION ${XpertMassGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${XpertMassGui_INCLUDE_DIRS})

endif()

include_directories(${include_directories} ${XpertMass_INCLUDE_DIRS} ${XpertMassGui_INCLUDE_DIRS})


#OPENMP
message(STATUS "${BoldYellow}OpenMP support is compulsory.${ColourReset}")
#message(STATUS "CMAKE_MODULE_PATH: ${CMAKE_MODULE_PATH}")
#set(OpenMP_DIR ${CMAKE_MODULE_PATH})

# Unfortunately that does not work as it does not find the
# include directories. So we need to do the work manually.

find_package(OpenMP REQUIRED)

set(OpenMP_FOUND 1)
set(OpenMP_INCLUDE_DIRS "C:/msys64/ucrt64/lib/gcc/x86_64-w64-mingw32/13.2.0/include/omp.h")
set(OpenMP_LIBRARIES "C:/msys64/ucrt64/bin/libgomp-1.dll")
if(NOT TARGET OpenMP::OpenMP_CXX)

  add_library(OpenMP::OpenMP UNKNOWN IMPORTED)

  set_target_properties(OpenMP::OpenMP_CXX PROPERTIES
    IMPORTED_LOCATION             "${OpenMP_LIBRARIES}"
    INTERFACE_INCLUDE_DIRECTORIES "${OpenMP_INCLUDE_DIRS}"
    )
endif()

message(STATUS "OpenMP libraries: ${OpenMP_LIBRARIES}")
message(STATUS "OpenMP include dirs: ${OpenMP_INCLUDE_DIRS}")


# Build the WindRes resource file for the icon into an object file
# that will then be added to the target_link_libaries.
execute_process(COMMAND ${CMAKE_RC_COMPILER}
  -D GCC_WINDRES
  -I "${CMAKE_CURRENT_SOURCE_DIR}"
  -i "${CMAKE_SOURCE_DIR}/${PROJECT_NAME}.rc"
  -o "${CMAKE_BINARY_DIR}/${PROJECT_NAME}.obj"
  WORKING_DIRECTORY	${CMAKE_CURRENT_SOURCE_DIR})

# We add this to the target_link_libraries()
set(PLATFORM_SPECIFIC_LIB_FILES "${CMAKE_BINARY_DIR}/${PROJECT_NAME}.obj" ${PLATFORM_SPECIFIC_LIB_FILES})


################## MS WINDOWS package creation ###################
################## MS WINDOWS package creation ###################
################## MS WINDOWS package creation ###################

# There are two solutions:
# 1. NSIS, used from Debian on Linux and from MS Windows
# 2. InnoSetup, used from wine on Linux and from MS Windows

######################### NSIS ############################
######################### NSIS ############################

## We can build the package setup executable with this specific command.
# The NSIS file is in "${CMAKE_SOURCE_DIR}/winInstaller/
add_custom_target(winpackage
      COMMAND "c:/Program Files (x86)/NSIS/makensis.exe" "-V4"
      "${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-win10-ucrt64.nsis"
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}/winInstaller
      COMMENT "Build of the Windows Package Setup executable"
      DEPENDS ${TARGET}
      VERBATIM)


######################### InnoSetup ############################
######################### InnoSetup ############################

## We can build the package setup executable with this specific command.
# The InnoSetup file is in "${CMAKE_SOURCE_DIR}/winInstaller/
add_custom_target(winpackage_innosetup
      COMMAND "c:\\Program\\ Files\\ \\(x86\\)\\Inno\\ Setup\\ 6\\ISCC.exe"
      "${CMAKE_SOURCE_DIR}/winInstaller/${LOWCASE_PROJECT_NAME}-win10-ucrt64.iss"
      WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}/winInstaller
      COMMENT "Build of the Windows Package Setup executable"
      DEPENDS ${TARGET}
      VERBATIM)


# We want to move the locally created MS-Windows package to an out-of-source directory

# On the VirtualBox MS Windows development machine, W:
# points to $HOME/devel/msxpertsuite-store
set(WIN_PACKAGE_STORE_PATH "W:/win-packages/${LOWCASE_PROJECT_NAME_NO_VER}")

add_custom_command(
    TARGET winpackage
    POST_BUILD

    # Create destination directory first
    COMMAND ${CMAKE_COMMAND} -E make_directory ${WIN_PACKAGE_STORE_PATH}

    COMMAND cp ${CMAKE_SOURCE_DIR}/winInstaller/*-setup.exe ${WIN_PACKAGE_STORE_PATH}

    WORKING_DIRECTORY ${CMAKE_SOURCE_DIR}

    COMMENT "Copy the MS-Windows package files to ${WIN_PACKAGE_STORE_PATH}"
)


################# INSTALL directories #################
################# INSTALL directories #################
################# INSTALL directories #################

# This is the default on windows, but set it nonetheless.
set(CMAKE_INSTALL_PREFIX "C:/Program Files")
set(PROJECT_INSTALL_PREFIX ${CMAKE_INSTALL_PREFIX})
message("The project install prefix: ${PROJECT_INSTALL_PREFIX}")

#### These directories do not include the CMAKE_INSTALL_PREFIX path.
#### In the install actions of this CMake-based configuration, only use
#### PROJECT_INSTALL_<VARIABLE>

### The directory where the binary is to be installed
set(PROJECT_INSTALL_BIN_DIR ${CMAKE_PROJECT_NAME})
message(STATUS "The project install bin dir: ${PROJECT_INSTALL_BIN_DIR}")

set(PROJECT_INSTALL_LIB_DIR ${CMAKE_PROJECT_NAME})
message(STATUS "The project install lib dir: ${PROJECT_INSTALL_LIB_DIR}")

set(PROJECT_INSTALL_DATA_DIR ${CMAKE_PROJECT_NAME})
message(STATUS "The project install data dir: ${PROJECT_INSTALL_DATA_DIR}")

set(PROJECT_INSTALL_DOC_DIR "${PROJECT_INSTALL_DATA_DIR}/doc")
message(STATUS "The project install doc dir: ${PROJECT_INSTALL_DOC_DIR}")


# On Win10 all the code is relocatable.
remove_definitions(-fPIC)


