
message("BEGIN - UNIX toolchain with local XPERTMASS libraries")

message("")

set(XpertMass_FOUND 1)
set(XpertMass_INCLUDE_DIRS
"$ENV{HOME}/devel/xpertmass/development/source/XpertMassCore/includes/")
set(XpertMass_LIBRARIES
"$ENV{HOME}/devel/xpertmass/build-area/unix/source/XpertMassCore/libXpertMassCore.so" )

if(NOT TARGET XpertMass::Core)

  add_library(XpertMass::Core UNKNOWN IMPORTED GLOBAL)
  set_target_properties(XpertMass::Core PROPERTIES
    IMPORTED_LOCATION ${XpertMass_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${XpertMass_INCLUDE_DIRS})

  get_target_property(CORE_IMPORTED_LOCATION XpertMass::Core IMPORTED_LOCATION)
  message(STATUS "Imported XpertMass::Core: ${CORE_IMPORTED_LOCATION}")

endif()

set(XpertMassGui_FOUND 1)
set(XpertMassGui_INCLUDE_DIRS
  "$ENV{HOME}/devel/xpertmass/development/source/XpertMassGui/includes")
set(XpertMassGui_LIBRARIES
  "$ENV{HOME}/devel/xpertmass/build-area/unix/source/XpertMassGui/libXpertMassGui.so")

if(NOT TARGET XpertMass::Gui)

  add_library(XpertMass::Gui UNKNOWN IMPORTED GLOBAL)
  set_target_properties(XpertMass::Gui PROPERTIES
    IMPORTED_LOCATION ${XpertMassGui_LIBRARIES}
    INTERFACE_INCLUDE_DIRECTORIES ${XpertMassGui_INCLUDE_DIRS})

  get_target_property(GUI_IMPORTED_LOCATION XpertMass::Gui IMPORTED_LOCATION)
  message(STATUS "Imported XpertMass::Gui: ${GUI_IMPORTED_LOCATION}")

endif()

message("")
message("END - UNIX toolchain with local XPERTMASS libraries")
