# Ask that uname -s be performed and store the value in SYSTEM_UNAME_S for
# later reference.

macro(get_uname_string)

execute_process(COMMAND uname -s OUTPUT_VARIABLE SYSTEM_UNAME_S)

if(${SYSTEM_UNAME_S} MATCHES "MSYS_NT-10.0-*")
	message(STATUS "System detected as Windows10 with UCRT64, setting WIN32 AND WIN10UCRT64")
	# Note that WIN32 is set even on 64 bits systems.
	set(WIN32 1)
	set(WIN10UCRT64 1)
#else()
	#message(STATUS "System is not Windows.")
endif()

endmacro()

get_uname_string()

macro(get_deb_triplet_string OUTPUT_VAR)

    find_program(DPKG_CMD dpkg)

    if(DPKG_CMD)
        execute_process(
            COMMAND dpkg-architecture -qDEB_HOST_MULTIARCH
            OUTPUT_VARIABLE DEB_MULTI_ARCH
            OUTPUT_STRIP_TRAILING_WHITESPACE
        )
        message(STATUS "Got the triplet: ${DEB_MULTI_ARCH}")
        set(${OUTPUT_VAR} ${DEB_MULTI_ARCH})
    endif()

endmacro()

