/************************************************************************
 FAUST Architecture File
 Copyright (C) 2017-2019 GRAME, Centre National de Creation Musicale
 ---------------------------------------------------------------------
 This Architecture section is free software; you can redistribute it
 and/or modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation; either version 3 of
 the License, or (at your option) any later version.

 This program is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program; If not, see <http://www.gnu.org/licenses/>.

 EXCEPTION : As a special exception, you may create a larger work
 that contains this FAUST architecture section and distribute
 that work under terms of your choice, so long as this FAUST
 architecture section is not modified.

 Code taken and adapted from the OWL project: https://hoxtonowl.com
 ************************************************************************/

#include <stdint.h>

#ifdef __cplusplus
#include <cmath>
#else
#include <math.h>
#endif

#ifdef _WIN32
#define EXPORT __declspec(dllexport) __attribute__((always_inline)) static
#else
#define EXPORT __attribute__((visibility("default"))) __attribute__((always_inline)) static
#endif

#ifdef __cplusplus
extern "C" {
#endif

// float version
EXPORT float fast_fabsf(float x)
{
    return fabsf(x);
}
EXPORT float fast_acosf(float x)
{
    return acosf(x);
}
EXPORT float fast_asinf(float x)
{
    return asinf(x);
}
EXPORT float fast_atanf(float x)
{
    return atanf(x);
}
EXPORT float fast_atan2f(float x, float y)
{
    return atan2f(x, y);
}
EXPORT float fast_ceilf(float x)
{
    return ceilf(x);
}
EXPORT float fast_cosf(float x)
{
    return cosf(x);
}
EXPORT float fast_expf(float x);
EXPORT float fast_exp2f(float x);
EXPORT float fast_exp10f(float x);
EXPORT float fast_floorf(float x)
{
    return floorf(x);
}
EXPORT float fast_fmodf(float x, float y)
{
    return fmodf(x, y);
}
EXPORT float fast_logf(float x);
EXPORT float fast_log2f(float x);
EXPORT float fast_log10f(float x);
EXPORT float fast_powf(float x, float y);
EXPORT float fast_remainderf(float x, float y)
{
    return remainderf(x, y);
}
EXPORT float fast_rintf(float x)
{
    return rintf(x);
}
EXPORT float fast_roundf(float x)
{
    return roundf(x);
}
EXPORT float fast_sinf(float x)
{
    return sinf(x);
}
EXPORT float fast_sqrtf(float x)
{
    return sqrtf(x);
}
EXPORT float fast_tanf(float x)
{
    return tanf(x);
}

// double version
EXPORT double fast_fabs(double x)
{
    return fabs(x);
}
EXPORT double fast_acos(double x)
{
    return acos(x);
}
EXPORT double fast_asin(double x)
{
    return asin(x);
}
EXPORT double fast_atan(double x)
{
    return atan(x);
}
EXPORT double fast_atan2(double x, double y)
{
    return atan2(x, y);
}
EXPORT double fast_ceil(double x)
{
    return ceil(x);
}
EXPORT double fast_cos(double x)
{
    return cos(x);
}
EXPORT double fast_exp(double x);
EXPORT double fast_exp2(double x);
EXPORT double fast_exp10(double x);
EXPORT double fast_floor(double x)
{
    return floor(x);
}
EXPORT double fast_fmod(double x, double y)
{
    return fmod(x, y);
}
EXPORT double fast_log(double x);
EXPORT double fast_log2(double x);
EXPORT double fast_log10(double x);
EXPORT double fast_pow(double x, double y);
EXPORT double fast_remainder(double x, double y)
{
    return remainder(x, y);
}
EXPORT double fast_rint(double x)
{
    return rint(x);
}
EXPORT double fast_round(double x)
{
    return round(x);
}
EXPORT double fast_sin(double x)
{
    return sin(x);
}
EXPORT double fast_sqrt(double x)
{
    return sqrt(x);
}
EXPORT double fast_tan(double x)
{
    return tan(x);
}

#ifdef __cplusplus
}
#endif

const float fast_log_table[65536] = {
    1.100685e-05, 3.302029e-05, 5.503340e-05, 7.704617e-05, 9.905860e-05, 1.210707e-04,
    1.430825e-04, 1.650939e-04, 1.871050e-04, 2.091158e-04, 2.311262e-04, 2.531362e-04,
    2.751460e-04, 2.971554e-04, 3.191645e-04, 3.411732e-04, 3.631816e-04, 3.851897e-04,
    4.071974e-04, 4.292048e-04, 4.512119e-04, 4.732186e-04, 4.952250e-04, 5.172311e-04,
    5.392368e-04, 5.612422e-04, 5.832472e-04, 6.052519e-04, 6.272563e-04, 6.492604e-04,
    6.712641e-04, 6.932674e-04, 7.152705e-04, 7.372731e-04, 7.592755e-04, 7.812775e-04,
    8.032792e-04, 8.252807e-04, 8.472817e-04, 8.692823e-04, 8.912827e-04, 9.132827e-04,
    9.352824e-04, 9.572817e-04, 9.792807e-04, 1.001279e-03, 1.023278e-03, 1.045276e-03,
    1.067273e-03, 1.089271e-03, 1.111268e-03, 1.133264e-03, 1.155261e-03, 1.177257e-03,
    1.199252e-03, 1.221248e-03, 1.243243e-03, 1.265237e-03, 1.287232e-03, 1.309226e-03,
    1.331219e-03, 1.353213e-03, 1.375205e-03, 1.397198e-03, 1.419190e-03, 1.441183e-03,
    1.463174e-03, 1.485165e-03, 1.507156e-03, 1.529147e-03, 1.551137e-03, 1.573127e-03,
    1.595117e-03, 1.617106e-03, 1.639095e-03, 1.661084e-03, 1.683072e-03, 1.705060e-03,
    1.727048e-03, 1.749035e-03, 1.771022e-03, 1.793008e-03, 1.814994e-03, 1.836981e-03,
    1.858966e-03, 1.880951e-03, 1.902936e-03, 1.924921e-03, 1.946905e-03, 1.968889e-03,
    1.990873e-03, 2.012856e-03, 2.034839e-03, 2.056821e-03, 2.078804e-03, 2.100786e-03,
    2.122767e-03, 2.144748e-03, 2.166729e-03, 2.188710e-03, 2.210690e-03, 2.232670e-03,
    2.254650e-03, 2.276629e-03, 2.298608e-03, 2.320586e-03, 2.342565e-03, 2.364542e-03,
    2.386520e-03, 2.408497e-03, 2.430474e-03, 2.452451e-03, 2.474427e-03, 2.496403e-03,
    2.518378e-03, 2.540353e-03, 2.562328e-03, 2.584303e-03, 2.606277e-03, 2.628251e-03,
    2.650225e-03, 2.672198e-03, 2.694171e-03, 2.716143e-03, 2.738115e-03, 2.760087e-03,
    2.782059e-03, 2.804030e-03, 2.826001e-03, 2.847972e-03, 2.869942e-03, 2.891911e-03,
    2.913881e-03, 2.935850e-03, 2.957819e-03, 2.979788e-03, 3.001756e-03, 3.023724e-03,
    3.045691e-03, 3.067659e-03, 3.089625e-03, 3.111592e-03, 3.133558e-03, 3.155524e-03,
    3.177489e-03, 3.199455e-03, 3.221419e-03, 3.243384e-03, 3.265348e-03, 3.287312e-03,
    3.309275e-03, 3.331239e-03, 3.353202e-03, 3.375164e-03, 3.397126e-03, 3.419088e-03,
    3.441049e-03, 3.463011e-03, 3.484971e-03, 3.506932e-03, 3.528892e-03, 3.550852e-03,
    3.572812e-03, 3.594771e-03, 3.616729e-03, 3.638688e-03, 3.660646e-03, 3.682604e-03,
    3.704561e-03, 3.726519e-03, 3.748475e-03, 3.770432e-03, 3.792388e-03, 3.814344e-03,
    3.836300e-03, 3.858255e-03, 3.880210e-03, 3.902164e-03, 3.924118e-03, 3.946071e-03,
    3.968026e-03, 3.989978e-03, 4.011931e-03, 4.033884e-03, 4.055836e-03, 4.077788e-03,
    4.099739e-03, 4.121690e-03, 4.143641e-03, 4.165591e-03, 4.187542e-03, 4.209492e-03,
    4.231441e-03, 4.253390e-03, 4.275339e-03, 4.297288e-03, 4.319235e-03, 4.341183e-03,
    4.363131e-03, 4.385078e-03, 4.407025e-03, 4.428971e-03, 4.450917e-03, 4.472863e-03,
    4.494809e-03, 4.516754e-03, 4.538699e-03, 4.560643e-03, 4.582587e-03, 4.604531e-03,
    4.626474e-03, 4.648418e-03, 4.670361e-03, 4.692303e-03, 4.714245e-03, 4.736187e-03,
    4.758128e-03, 4.780069e-03, 4.802010e-03, 4.823951e-03, 4.845891e-03, 4.867830e-03,
    4.889770e-03, 4.911709e-03, 4.933648e-03, 4.955587e-03, 4.977525e-03, 4.999463e-03,
    5.021400e-03, 5.043337e-03, 5.065273e-03, 5.087210e-03, 5.109146e-03, 5.131082e-03,
    5.153018e-03, 5.174953e-03, 5.196888e-03, 5.218822e-03, 5.240756e-03, 5.262690e-03,
    5.284623e-03, 5.306556e-03, 5.328489e-03, 5.350422e-03, 5.372354e-03, 5.394286e-03,
    5.416217e-03, 5.438148e-03, 5.460079e-03, 5.482010e-03, 5.503939e-03, 5.525869e-03,
    5.547799e-03, 5.569728e-03, 5.591657e-03, 5.613585e-03, 5.635513e-03, 5.657441e-03,
    5.679369e-03, 5.701296e-03, 5.723223e-03, 5.745149e-03, 5.767075e-03, 5.789001e-03,
    5.810926e-03, 5.832851e-03, 5.854776e-03, 5.876700e-03, 5.898625e-03, 5.920548e-03,
    5.942472e-03, 5.964395e-03, 5.986318e-03, 6.008240e-03, 6.030162e-03, 6.052084e-03,
    6.074006e-03, 6.095927e-03, 6.117847e-03, 6.139768e-03, 6.161688e-03, 6.183608e-03,
    6.205528e-03, 6.227447e-03, 6.249365e-03, 6.271284e-03, 6.293202e-03, 6.315120e-03,
    6.337037e-03, 6.358955e-03, 6.380871e-03, 6.402788e-03, 6.424704e-03, 6.446620e-03,
    6.468535e-03, 6.490450e-03, 6.512365e-03, 6.534279e-03, 6.556194e-03, 6.578107e-03,
    6.600021e-03, 6.621934e-03, 6.643847e-03, 6.665759e-03, 6.687671e-03, 6.709583e-03,
    6.731494e-03, 6.753406e-03, 6.775316e-03, 6.797227e-03, 6.819137e-03, 6.841047e-03,
    6.862956e-03, 6.884866e-03, 6.906774e-03, 6.928683e-03, 6.950591e-03, 6.972499e-03,
    6.994406e-03, 7.016314e-03, 7.038220e-03, 7.060127e-03, 7.082033e-03, 7.103939e-03,
    7.125845e-03, 7.147749e-03, 7.169655e-03, 7.191559e-03, 7.213463e-03, 7.235366e-03,
    7.257270e-03, 7.279173e-03, 7.301076e-03, 7.322978e-03, 7.344881e-03, 7.366783e-03,
    7.388684e-03, 7.410585e-03, 7.432486e-03, 7.454386e-03, 7.476286e-03, 7.498186e-03,
    7.520086e-03, 7.541985e-03, 7.563884e-03, 7.585783e-03, 7.607681e-03, 7.629578e-03,
    7.651476e-03, 7.673373e-03, 7.695270e-03, 7.717167e-03, 7.739063e-03, 7.760958e-03,
    7.782854e-03, 7.804750e-03, 7.826644e-03, 7.848538e-03, 7.870433e-03, 7.892326e-03,
    7.914220e-03, 7.936114e-03, 7.958006e-03, 7.979899e-03, 8.001791e-03, 8.023683e-03,
    8.045574e-03, 8.067465e-03, 8.089356e-03, 8.111247e-03, 8.133137e-03, 8.155027e-03,
    8.176916e-03, 8.198805e-03, 8.220694e-03, 8.242583e-03, 8.264471e-03, 8.286359e-03,
    8.308247e-03, 8.330134e-03, 8.352021e-03, 8.373907e-03, 8.395793e-03, 8.417679e-03,
    8.439565e-03, 8.461449e-03, 8.483335e-03, 8.505220e-03, 8.527104e-03, 8.548987e-03,
    8.570871e-03, 8.592755e-03, 8.614637e-03, 8.636520e-03, 8.658402e-03, 8.680284e-03,
    8.702165e-03, 8.724046e-03, 8.745927e-03, 8.767808e-03, 8.789688e-03, 8.811568e-03,
    8.833448e-03, 8.855327e-03, 8.877206e-03, 8.899084e-03, 8.920962e-03, 8.942841e-03,
    8.964718e-03, 8.986595e-03, 9.008473e-03, 9.030349e-03, 9.052225e-03, 9.074101e-03,
    9.095977e-03, 9.117852e-03, 9.139727e-03, 9.161602e-03, 9.183476e-03, 9.205350e-03,
    9.227224e-03, 9.249097e-03, 9.270969e-03, 9.292842e-03, 9.314715e-03, 9.336586e-03,
    9.358458e-03, 9.380329e-03, 9.402201e-03, 9.424071e-03, 9.445941e-03, 9.467810e-03,
    9.489681e-03, 9.511550e-03, 9.533419e-03, 9.555288e-03, 9.577155e-03, 9.599023e-03,
    9.620892e-03, 9.642758e-03, 9.664626e-03, 9.686492e-03, 9.708359e-03, 9.730224e-03,
    9.752090e-03, 9.773956e-03, 9.795820e-03, 9.817685e-03, 9.839550e-03, 9.861413e-03,
    9.883277e-03, 9.905141e-03, 9.927003e-03, 9.948866e-03, 9.970728e-03, 9.992590e-03,
    1.001445e-02, 1.003631e-02, 1.005817e-02, 1.008003e-02, 1.010190e-02, 1.012376e-02,
    1.014561e-02, 1.016747e-02, 1.018933e-02, 1.021119e-02, 1.023305e-02, 1.025491e-02,
    1.027677e-02, 1.029862e-02, 1.032048e-02, 1.034234e-02, 1.036419e-02, 1.038605e-02,
    1.040791e-02, 1.042976e-02, 1.045162e-02, 1.047347e-02, 1.049533e-02, 1.051718e-02,
    1.053903e-02, 1.056089e-02, 1.058274e-02, 1.060459e-02, 1.062644e-02, 1.064830e-02,
    1.067015e-02, 1.069200e-02, 1.071385e-02, 1.073570e-02, 1.075755e-02, 1.077940e-02,
    1.080125e-02, 1.082310e-02, 1.084495e-02, 1.086680e-02, 1.088865e-02, 1.091050e-02,
    1.093234e-02, 1.095419e-02, 1.097604e-02, 1.099788e-02, 1.101973e-02, 1.104158e-02,
    1.106342e-02, 1.108527e-02, 1.110711e-02, 1.112896e-02, 1.115080e-02, 1.117265e-02,
    1.119449e-02, 1.121633e-02, 1.123818e-02, 1.126002e-02, 1.128186e-02, 1.130371e-02,
    1.132555e-02, 1.134739e-02, 1.136923e-02, 1.139107e-02, 1.141291e-02, 1.143475e-02,
    1.145659e-02, 1.147843e-02, 1.150027e-02, 1.152211e-02, 1.154395e-02, 1.156578e-02,
    1.158762e-02, 1.160946e-02, 1.163130e-02, 1.165313e-02, 1.167497e-02, 1.169681e-02,
    1.171864e-02, 1.174048e-02, 1.176231e-02, 1.178415e-02, 1.180598e-02, 1.182782e-02,
    1.184965e-02, 1.187148e-02, 1.189332e-02, 1.191515e-02, 1.193698e-02, 1.195882e-02,
    1.198065e-02, 1.200248e-02, 1.202431e-02, 1.204614e-02, 1.206797e-02, 1.208980e-02,
    1.211163e-02, 1.213346e-02, 1.215529e-02, 1.217712e-02, 1.219895e-02, 1.222078e-02,
    1.224260e-02, 1.226443e-02, 1.228626e-02, 1.230808e-02, 1.232991e-02, 1.235174e-02,
    1.237356e-02, 1.239539e-02, 1.241721e-02, 1.243904e-02, 1.246086e-02, 1.248269e-02,
    1.250451e-02, 1.252634e-02, 1.254816e-02, 1.256998e-02, 1.259181e-02, 1.261363e-02,
    1.263545e-02, 1.265727e-02, 1.267909e-02, 1.270091e-02, 1.272274e-02, 1.274456e-02,
    1.276637e-02, 1.278819e-02, 1.281001e-02, 1.283183e-02, 1.285365e-02, 1.287547e-02,
    1.289729e-02, 1.291911e-02, 1.294092e-02, 1.296274e-02, 1.298456e-02, 1.300637e-02,
    1.302819e-02, 1.305000e-02, 1.307182e-02, 1.309364e-02, 1.311545e-02, 1.313726e-02,
    1.315908e-02, 1.318089e-02, 1.320271e-02, 1.322452e-02, 1.324633e-02, 1.326814e-02,
    1.328996e-02, 1.331177e-02, 1.333358e-02, 1.335539e-02, 1.337720e-02, 1.339901e-02,
    1.342082e-02, 1.344263e-02, 1.346444e-02, 1.348625e-02, 1.350806e-02, 1.352987e-02,
    1.355168e-02, 1.357348e-02, 1.359529e-02, 1.361710e-02, 1.363890e-02, 1.366071e-02,
    1.368252e-02, 1.370432e-02, 1.372613e-02, 1.374793e-02, 1.376974e-02, 1.379154e-02,
    1.381335e-02, 1.383515e-02, 1.385695e-02, 1.387876e-02, 1.390056e-02, 1.392236e-02,
    1.394416e-02, 1.396597e-02, 1.398777e-02, 1.400957e-02, 1.403137e-02, 1.405317e-02,
    1.407497e-02, 1.409677e-02, 1.411857e-02, 1.414037e-02, 1.416217e-02, 1.418397e-02,
    1.420577e-02, 1.422756e-02, 1.424936e-02, 1.427116e-02, 1.429296e-02, 1.431475e-02,
    1.433655e-02, 1.435834e-02, 1.438014e-02, 1.440194e-02, 1.442373e-02, 1.444552e-02,
    1.446732e-02, 1.448911e-02, 1.451091e-02, 1.453270e-02, 1.455449e-02, 1.457629e-02,
    1.459808e-02, 1.461987e-02, 1.464166e-02, 1.466345e-02, 1.468524e-02, 1.470703e-02,
    1.472883e-02, 1.475061e-02, 1.477240e-02, 1.479419e-02, 1.481598e-02, 1.483777e-02,
    1.485956e-02, 1.488135e-02, 1.490314e-02, 1.492492e-02, 1.494671e-02, 1.496850e-02,
    1.499028e-02, 1.501207e-02, 1.503386e-02, 1.505564e-02, 1.507743e-02, 1.509921e-02,
    1.512100e-02, 1.514278e-02, 1.516456e-02, 1.518635e-02, 1.520813e-02, 1.522991e-02,
    1.525169e-02, 1.527348e-02, 1.529526e-02, 1.531704e-02, 1.533882e-02, 1.536060e-02,
    1.538238e-02, 1.540416e-02, 1.542594e-02, 1.544772e-02, 1.546950e-02, 1.549128e-02,
    1.551306e-02, 1.553484e-02, 1.555661e-02, 1.557839e-02, 1.560017e-02, 1.562195e-02,
    1.564372e-02, 1.566550e-02, 1.568727e-02, 1.570905e-02, 1.573083e-02, 1.575260e-02,
    1.577437e-02, 1.579615e-02, 1.581792e-02, 1.583970e-02, 1.586147e-02, 1.588324e-02,
    1.590502e-02, 1.592679e-02, 1.594856e-02, 1.597033e-02, 1.599210e-02, 1.601387e-02,
    1.603564e-02, 1.605741e-02, 1.607918e-02, 1.610095e-02, 1.612272e-02, 1.614449e-02,
    1.616626e-02, 1.618803e-02, 1.620980e-02, 1.623156e-02, 1.625333e-02, 1.627510e-02,
    1.629687e-02, 1.631863e-02, 1.634040e-02, 1.636216e-02, 1.638393e-02, 1.640569e-02,
    1.642746e-02, 1.644922e-02, 1.647099e-02, 1.649275e-02, 1.651451e-02, 1.653628e-02,
    1.655804e-02, 1.657980e-02, 1.660156e-02, 1.662333e-02, 1.664509e-02, 1.666685e-02,
    1.668861e-02, 1.671037e-02, 1.673213e-02, 1.675389e-02, 1.677565e-02, 1.679741e-02,
    1.681917e-02, 1.684093e-02, 1.686268e-02, 1.688444e-02, 1.690620e-02, 1.692796e-02,
    1.694971e-02, 1.697147e-02, 1.699322e-02, 1.701498e-02, 1.703674e-02, 1.705849e-02,
    1.708025e-02, 1.710200e-02, 1.712376e-02, 1.714551e-02, 1.716726e-02, 1.718902e-02,
    1.721077e-02, 1.723252e-02, 1.725427e-02, 1.727603e-02, 1.729778e-02, 1.731953e-02,
    1.734128e-02, 1.736303e-02, 1.738478e-02, 1.740653e-02, 1.742828e-02, 1.745003e-02,
    1.747178e-02, 1.749353e-02, 1.751528e-02, 1.753702e-02, 1.755877e-02, 1.758052e-02,
    1.760226e-02, 1.762401e-02, 1.764576e-02, 1.766750e-02, 1.768925e-02, 1.771099e-02,
    1.773274e-02, 1.775449e-02, 1.777623e-02, 1.779797e-02, 1.781972e-02, 1.784146e-02,
    1.786320e-02, 1.788495e-02, 1.790669e-02, 1.792843e-02, 1.795017e-02, 1.797191e-02,
    1.799366e-02, 1.801540e-02, 1.803714e-02, 1.805888e-02, 1.808061e-02, 1.810236e-02,
    1.812409e-02, 1.814583e-02, 1.816757e-02, 1.818931e-02, 1.821105e-02, 1.823279e-02,
    1.825452e-02, 1.827626e-02, 1.829800e-02, 1.831973e-02, 1.834147e-02, 1.836320e-02,
    1.838494e-02, 1.840667e-02, 1.842841e-02, 1.845014e-02, 1.847188e-02, 1.849361e-02,
    1.851534e-02, 1.853708e-02, 1.855881e-02, 1.858054e-02, 1.860227e-02, 1.862400e-02,
    1.864574e-02, 1.866747e-02, 1.868920e-02, 1.871093e-02, 1.873266e-02, 1.875439e-02,
    1.877612e-02, 1.879784e-02, 1.881957e-02, 1.884130e-02, 1.886303e-02, 1.888476e-02,
    1.890648e-02, 1.892821e-02, 1.894994e-02, 1.897166e-02, 1.899339e-02, 1.901512e-02,
    1.903684e-02, 1.905857e-02, 1.908029e-02, 1.910202e-02, 1.912374e-02, 1.914546e-02,
    1.916719e-02, 1.918891e-02, 1.921063e-02, 1.923236e-02, 1.925408e-02, 1.927580e-02,
    1.929752e-02, 1.931924e-02, 1.934096e-02, 1.936268e-02, 1.938440e-02, 1.940612e-02,
    1.942784e-02, 1.944956e-02, 1.947128e-02, 1.949300e-02, 1.951472e-02, 1.953644e-02,
    1.955815e-02, 1.957987e-02, 1.960159e-02, 1.962330e-02, 1.964502e-02, 1.966674e-02,
    1.968845e-02, 1.971017e-02, 1.973188e-02, 1.975360e-02, 1.977531e-02, 1.979702e-02,
    1.981874e-02, 1.984045e-02, 1.986216e-02, 1.988388e-02, 1.990559e-02, 1.992730e-02,
    1.994901e-02, 1.997072e-02, 1.999244e-02, 2.001414e-02, 2.003586e-02, 2.005756e-02,
    2.007928e-02, 2.010098e-02, 2.012269e-02, 2.014440e-02, 2.016611e-02, 2.018782e-02,
    2.020953e-02, 2.023123e-02, 2.025294e-02, 2.027465e-02, 2.029635e-02, 2.031806e-02,
    2.033977e-02, 2.036147e-02, 2.038318e-02, 2.040488e-02, 2.042658e-02, 2.044829e-02,
    2.046999e-02, 2.049170e-02, 2.051340e-02, 2.053510e-02, 2.055681e-02, 2.057851e-02,
    2.060021e-02, 2.062191e-02, 2.064361e-02, 2.066531e-02, 2.068701e-02, 2.070871e-02,
    2.073041e-02, 2.075211e-02, 2.077381e-02, 2.079551e-02, 2.081721e-02, 2.083891e-02,
    2.086061e-02, 2.088230e-02, 2.090400e-02, 2.092570e-02, 2.094739e-02, 2.096909e-02,
    2.099079e-02, 2.101248e-02, 2.103418e-02, 2.105587e-02, 2.107757e-02, 2.109926e-02,
    2.112096e-02, 2.114265e-02, 2.116434e-02, 2.118604e-02, 2.120773e-02, 2.122942e-02,
    2.125111e-02, 2.127280e-02, 2.129450e-02, 2.131619e-02, 2.133788e-02, 2.135957e-02,
    2.138126e-02, 2.140295e-02, 2.142464e-02, 2.144633e-02, 2.146802e-02, 2.148970e-02,
    2.151139e-02, 2.153308e-02, 2.155477e-02, 2.157645e-02, 2.159814e-02, 2.161983e-02,
    2.164152e-02, 2.166320e-02, 2.168489e-02, 2.170657e-02, 2.172826e-02, 2.174994e-02,
    2.177162e-02, 2.179331e-02, 2.181499e-02, 2.183667e-02, 2.185836e-02, 2.188004e-02,
    2.190172e-02, 2.192340e-02, 2.194509e-02, 2.196677e-02, 2.198845e-02, 2.201013e-02,
    2.203181e-02, 2.205349e-02, 2.207517e-02, 2.209685e-02, 2.211853e-02, 2.214021e-02,
    2.216188e-02, 2.218356e-02, 2.220524e-02, 2.222692e-02, 2.224859e-02, 2.227027e-02,
    2.229195e-02, 2.231362e-02, 2.233530e-02, 2.235698e-02, 2.237865e-02, 2.240033e-02,
    2.242200e-02, 2.244367e-02, 2.246535e-02, 2.248702e-02, 2.250869e-02, 2.253037e-02,
    2.255204e-02, 2.257371e-02, 2.259539e-02, 2.261705e-02, 2.263873e-02, 2.266040e-02,
    2.268207e-02, 2.270374e-02, 2.272541e-02, 2.274708e-02, 2.276875e-02, 2.279042e-02,
    2.281209e-02, 2.283375e-02, 2.285542e-02, 2.287709e-02, 2.289876e-02, 2.292042e-02,
    2.294209e-02, 2.296375e-02, 2.298542e-02, 2.300709e-02, 2.302875e-02, 2.305042e-02,
    2.307208e-02, 2.309375e-02, 2.311541e-02, 2.313707e-02, 2.315874e-02, 2.318040e-02,
    2.320206e-02, 2.322373e-02, 2.324539e-02, 2.326705e-02, 2.328871e-02, 2.331037e-02,
    2.333203e-02, 2.335369e-02, 2.337535e-02, 2.339701e-02, 2.341867e-02, 2.344033e-02,
    2.346199e-02, 2.348365e-02, 2.350531e-02, 2.352697e-02, 2.354862e-02, 2.357028e-02,
    2.359194e-02, 2.361359e-02, 2.363525e-02, 2.365691e-02, 2.367856e-02, 2.370022e-02,
    2.372187e-02, 2.374353e-02, 2.376518e-02, 2.378683e-02, 2.380849e-02, 2.383014e-02,
    2.385180e-02, 2.387345e-02, 2.389510e-02, 2.391675e-02, 2.393840e-02, 2.396005e-02,
    2.398170e-02, 2.400335e-02, 2.402501e-02, 2.404666e-02, 2.406831e-02, 2.408996e-02,
    2.411160e-02, 2.413325e-02, 2.415490e-02, 2.417655e-02, 2.419820e-02, 2.421985e-02,
    2.424149e-02, 2.426314e-02, 2.428479e-02, 2.430643e-02, 2.432808e-02, 2.434972e-02,
    2.437137e-02, 2.439301e-02, 2.441466e-02, 2.443630e-02, 2.445795e-02, 2.447959e-02,
    2.450123e-02, 2.452287e-02, 2.454452e-02, 2.456616e-02, 2.458780e-02, 2.460944e-02,
    2.463109e-02, 2.465273e-02, 2.467437e-02, 2.469601e-02, 2.471765e-02, 2.473929e-02,
    2.476093e-02, 2.478257e-02, 2.480420e-02, 2.482584e-02, 2.484748e-02, 2.486912e-02,
    2.489076e-02, 2.491239e-02, 2.493403e-02, 2.495567e-02, 2.497730e-02, 2.499894e-02,
    2.502057e-02, 2.504221e-02, 2.506384e-02, 2.508548e-02, 2.510711e-02, 2.512874e-02,
    2.515038e-02, 2.517201e-02, 2.519364e-02, 2.521528e-02, 2.523691e-02, 2.525854e-02,
    2.528017e-02, 2.530180e-02, 2.532344e-02, 2.534507e-02, 2.536670e-02, 2.538833e-02,
    2.540996e-02, 2.543158e-02, 2.545322e-02, 2.547484e-02, 2.549647e-02, 2.551810e-02,
    2.553973e-02, 2.556135e-02, 2.558298e-02, 2.560461e-02, 2.562623e-02, 2.564786e-02,
    2.566949e-02, 2.569111e-02, 2.571274e-02, 2.573436e-02, 2.575598e-02, 2.577761e-02,
    2.579923e-02, 2.582086e-02, 2.584248e-02, 2.586410e-02, 2.588572e-02, 2.590735e-02,
    2.592897e-02, 2.595059e-02, 2.597221e-02, 2.599383e-02, 2.601545e-02, 2.603707e-02,
    2.605869e-02, 2.608031e-02, 2.610193e-02, 2.612355e-02, 2.614517e-02, 2.616679e-02,
    2.618841e-02, 2.621002e-02, 2.623164e-02, 2.625326e-02, 2.627487e-02, 2.629649e-02,
    2.631811e-02, 2.633972e-02, 2.636134e-02, 2.638295e-02, 2.640457e-02, 2.642618e-02,
    2.644780e-02, 2.646941e-02, 2.649102e-02, 2.651264e-02, 2.653425e-02, 2.655586e-02,
    2.657747e-02, 2.659908e-02, 2.662070e-02, 2.664231e-02, 2.666392e-02, 2.668553e-02,
    2.670714e-02, 2.672875e-02, 2.675036e-02, 2.677197e-02, 2.679358e-02, 2.681519e-02,
    2.683679e-02, 2.685840e-02, 2.688001e-02, 2.690162e-02, 2.692322e-02, 2.694483e-02,
    2.696644e-02, 2.698804e-02, 2.700965e-02, 2.703125e-02, 2.705286e-02, 2.707446e-02,
    2.709607e-02, 2.711767e-02, 2.713927e-02, 2.716088e-02, 2.718248e-02, 2.720408e-02,
    2.722569e-02, 2.724729e-02, 2.726889e-02, 2.729049e-02, 2.731209e-02, 2.733369e-02,
    2.735529e-02, 2.737689e-02, 2.739850e-02, 2.742009e-02, 2.744169e-02, 2.746329e-02,
    2.748489e-02, 2.750649e-02, 2.752809e-02, 2.754968e-02, 2.757128e-02, 2.759288e-02,
    2.761447e-02, 2.763607e-02, 2.765767e-02, 2.767926e-02, 2.770086e-02, 2.772245e-02,
    2.774405e-02, 2.776564e-02, 2.778723e-02, 2.780883e-02, 2.783042e-02, 2.785202e-02,
    2.787361e-02, 2.789520e-02, 2.791679e-02, 2.793838e-02, 2.795997e-02, 2.798157e-02,
    2.800316e-02, 2.802475e-02, 2.804634e-02, 2.806793e-02, 2.808952e-02, 2.811111e-02,
    2.813270e-02, 2.815428e-02, 2.817587e-02, 2.819746e-02, 2.821905e-02, 2.824063e-02,
    2.826222e-02, 2.828381e-02, 2.830539e-02, 2.832698e-02, 2.834857e-02, 2.837015e-02,
    2.839174e-02, 2.841332e-02, 2.843490e-02, 2.845649e-02, 2.847807e-02, 2.849966e-02,
    2.852124e-02, 2.854282e-02, 2.856440e-02, 2.858599e-02, 2.860757e-02, 2.862915e-02,
    2.865073e-02, 2.867231e-02, 2.869389e-02, 2.871547e-02, 2.873705e-02, 2.875863e-02,
    2.878021e-02, 2.880179e-02, 2.882337e-02, 2.884495e-02, 2.886652e-02, 2.888810e-02,
    2.890968e-02, 2.893125e-02, 2.895283e-02, 2.897441e-02, 2.899599e-02, 2.901756e-02,
    2.903913e-02, 2.906071e-02, 2.908229e-02, 2.910386e-02, 2.912543e-02, 2.914701e-02,
    2.916858e-02, 2.919015e-02, 2.921173e-02, 2.923330e-02, 2.925487e-02, 2.927644e-02,
    2.929801e-02, 2.931958e-02, 2.934115e-02, 2.936273e-02, 2.938429e-02, 2.940587e-02,
    2.942744e-02, 2.944900e-02, 2.947057e-02, 2.949214e-02, 2.951371e-02, 2.953528e-02,
    2.955684e-02, 2.957841e-02, 2.959998e-02, 2.962155e-02, 2.964311e-02, 2.966468e-02,
    2.968624e-02, 2.970781e-02, 2.972937e-02, 2.975094e-02, 2.977250e-02, 2.979407e-02,
    2.981563e-02, 2.983719e-02, 2.985875e-02, 2.988032e-02, 2.990188e-02, 2.992344e-02,
    2.994500e-02, 2.996657e-02, 2.998812e-02, 3.000969e-02, 3.003125e-02, 3.005281e-02,
    3.007437e-02, 3.009593e-02, 3.011749e-02, 3.013905e-02, 3.016060e-02, 3.018216e-02,
    3.020372e-02, 3.022528e-02, 3.024684e-02, 3.026839e-02, 3.028995e-02, 3.031150e-02,
    3.033306e-02, 3.035462e-02, 3.037617e-02, 3.039773e-02, 3.041928e-02, 3.044084e-02,
    3.046239e-02, 3.048394e-02, 3.050550e-02, 3.052705e-02, 3.054860e-02, 3.057016e-02,
    3.059171e-02, 3.061326e-02, 3.063481e-02, 3.065636e-02, 3.067791e-02, 3.069946e-02,
    3.072101e-02, 3.074256e-02, 3.076411e-02, 3.078566e-02, 3.080721e-02, 3.082876e-02,
    3.085031e-02, 3.087185e-02, 3.089340e-02, 3.091495e-02, 3.093649e-02, 3.095804e-02,
    3.097959e-02, 3.100114e-02, 3.102268e-02, 3.104423e-02, 3.106577e-02, 3.108731e-02,
    3.110886e-02, 3.113040e-02, 3.115195e-02, 3.117349e-02, 3.119503e-02, 3.121658e-02,
    3.123812e-02, 3.125966e-02, 3.128120e-02, 3.130275e-02, 3.132429e-02, 3.134583e-02,
    3.136737e-02, 3.138890e-02, 3.141044e-02, 3.143199e-02, 3.145352e-02, 3.147506e-02,
    3.149660e-02, 3.151814e-02, 3.153968e-02, 3.156121e-02, 3.158275e-02, 3.160429e-02,
    3.162583e-02, 3.164736e-02, 3.166890e-02, 3.169043e-02, 3.171197e-02, 3.173351e-02,
    3.175504e-02, 3.177657e-02, 3.179811e-02, 3.181964e-02, 3.184117e-02, 3.186271e-02,
    3.188424e-02, 3.190577e-02, 3.192731e-02, 3.194884e-02, 3.197037e-02, 3.199190e-02,
    3.201343e-02, 3.203496e-02, 3.205649e-02, 3.207802e-02, 3.209955e-02, 3.212108e-02,
    3.214261e-02, 3.216414e-02, 3.218567e-02, 3.220719e-02, 3.222872e-02, 3.225025e-02,
    3.227178e-02, 3.229330e-02, 3.231483e-02, 3.233635e-02, 3.235788e-02, 3.237941e-02,
    3.240093e-02, 3.242246e-02, 3.244398e-02, 3.246550e-02, 3.248703e-02, 3.250855e-02,
    3.253007e-02, 3.255160e-02, 3.257312e-02, 3.259464e-02, 3.261616e-02, 3.263769e-02,
    3.265921e-02, 3.268073e-02, 3.270225e-02, 3.272377e-02, 3.274529e-02, 3.276681e-02,
    3.278833e-02, 3.280985e-02, 3.283136e-02, 3.285288e-02, 3.287440e-02, 3.289592e-02,
    3.291744e-02, 3.293895e-02, 3.296047e-02, 3.298199e-02, 3.300350e-02, 3.302502e-02,
    3.304653e-02, 3.306805e-02, 3.308956e-02, 3.311108e-02, 3.313259e-02, 3.315411e-02,
    3.317562e-02, 3.319713e-02, 3.321864e-02, 3.324016e-02, 3.326167e-02, 3.328318e-02,
    3.330469e-02, 3.332620e-02, 3.334771e-02, 3.336923e-02, 3.339074e-02, 3.341225e-02,
    3.343375e-02, 3.345527e-02, 3.347677e-02, 3.349828e-02, 3.351979e-02, 3.354130e-02,
    3.356281e-02, 3.358432e-02, 3.360582e-02, 3.362733e-02, 3.364884e-02, 3.367034e-02,
    3.369185e-02, 3.371335e-02, 3.373486e-02, 3.375636e-02, 3.377787e-02, 3.379937e-02,
    3.382087e-02, 3.384238e-02, 3.386388e-02, 3.388539e-02, 3.390689e-02, 3.392839e-02,
    3.394989e-02, 3.397140e-02, 3.399289e-02, 3.401440e-02, 3.403590e-02, 3.405740e-02,
    3.407890e-02, 3.410040e-02, 3.412190e-02, 3.414340e-02, 3.416489e-02, 3.418639e-02,
    3.420789e-02, 3.422939e-02, 3.425089e-02, 3.427238e-02, 3.429388e-02, 3.431538e-02,
    3.433687e-02, 3.435837e-02, 3.437986e-02, 3.440136e-02, 3.442286e-02, 3.444435e-02,
    3.446584e-02, 3.448734e-02, 3.450883e-02, 3.453032e-02, 3.455182e-02, 3.457331e-02,
    3.459480e-02, 3.461630e-02, 3.463778e-02, 3.465928e-02, 3.468077e-02, 3.470226e-02,
    3.472375e-02, 3.474524e-02, 3.476673e-02, 3.478822e-02, 3.480971e-02, 3.483120e-02,
    3.485268e-02, 3.487417e-02, 3.489566e-02, 3.491715e-02, 3.493864e-02, 3.496012e-02,
    3.498161e-02, 3.500310e-02, 3.502458e-02, 3.504607e-02, 3.506755e-02, 3.508904e-02,
    3.511052e-02, 3.513201e-02, 3.515349e-02, 3.517497e-02, 3.519646e-02, 3.521794e-02,
    3.523942e-02, 3.526090e-02, 3.528238e-02, 3.530387e-02, 3.532535e-02, 3.534683e-02,
    3.536831e-02, 3.538979e-02, 3.541127e-02, 3.543275e-02, 3.545423e-02, 3.547571e-02,
    3.549719e-02, 3.551867e-02, 3.554015e-02, 3.556162e-02, 3.558310e-02, 3.560458e-02,
    3.562606e-02, 3.564753e-02, 3.566901e-02, 3.569049e-02, 3.571196e-02, 3.573344e-02,
    3.575492e-02, 3.577639e-02, 3.579786e-02, 3.581933e-02, 3.584081e-02, 3.586228e-02,
    3.588375e-02, 3.590523e-02, 3.592670e-02, 3.594817e-02, 3.596964e-02, 3.599112e-02,
    3.601259e-02, 3.603406e-02, 3.605553e-02, 3.607700e-02, 3.609847e-02, 3.611994e-02,
    3.614141e-02, 3.616288e-02, 3.618434e-02, 3.620581e-02, 3.622728e-02, 3.624875e-02,
    3.627022e-02, 3.629168e-02, 3.631315e-02, 3.633462e-02, 3.635608e-02, 3.637755e-02,
    3.639901e-02, 3.642048e-02, 3.644195e-02, 3.646341e-02, 3.648487e-02, 3.650634e-02,
    3.652780e-02, 3.654927e-02, 3.657073e-02, 3.659219e-02, 3.661365e-02, 3.663512e-02,
    3.665658e-02, 3.667804e-02, 3.669950e-02, 3.672096e-02, 3.674242e-02, 3.676388e-02,
    3.678534e-02, 3.680680e-02, 3.682826e-02, 3.684972e-02, 3.687118e-02, 3.689263e-02,
    3.691409e-02, 3.693555e-02, 3.695701e-02, 3.697846e-02, 3.699992e-02, 3.702138e-02,
    3.704283e-02, 3.706429e-02, 3.708574e-02, 3.710720e-02, 3.712865e-02, 3.715011e-02,
    3.717156e-02, 3.719302e-02, 3.721447e-02, 3.723592e-02, 3.725737e-02, 3.727882e-02,
    3.730028e-02, 3.732173e-02, 3.734318e-02, 3.736463e-02, 3.738608e-02, 3.740753e-02,
    3.742899e-02, 3.745043e-02, 3.747188e-02, 3.749333e-02, 3.751478e-02, 3.753623e-02,
    3.755768e-02, 3.757913e-02, 3.760057e-02, 3.762202e-02, 3.764347e-02, 3.766492e-02,
    3.768636e-02, 3.770781e-02, 3.772925e-02, 3.775070e-02, 3.777215e-02, 3.779359e-02,
    3.781503e-02, 3.783648e-02, 3.785792e-02, 3.787936e-02, 3.790081e-02, 3.792225e-02,
    3.794369e-02, 3.796513e-02, 3.798658e-02, 3.800802e-02, 3.802946e-02, 3.805090e-02,
    3.807234e-02, 3.809378e-02, 3.811522e-02, 3.813666e-02, 3.815810e-02, 3.817954e-02,
    3.820098e-02, 3.822242e-02, 3.824386e-02, 3.826529e-02, 3.828673e-02, 3.830817e-02,
    3.832960e-02, 3.835104e-02, 3.837248e-02, 3.839391e-02, 3.841535e-02, 3.843678e-02,
    3.845822e-02, 3.847965e-02, 3.850108e-02, 3.852252e-02, 3.854395e-02, 3.856539e-02,
    3.858682e-02, 3.860825e-02, 3.862968e-02, 3.865112e-02, 3.867255e-02, 3.869398e-02,
    3.871541e-02, 3.873684e-02, 3.875827e-02, 3.877970e-02, 3.880113e-02, 3.882256e-02,
    3.884399e-02, 3.886542e-02, 3.888685e-02, 3.890827e-02, 3.892970e-02, 3.895113e-02,
    3.897256e-02, 3.899398e-02, 3.901541e-02, 3.903684e-02, 3.905826e-02, 3.907969e-02,
    3.910112e-02, 3.912254e-02, 3.914396e-02, 3.916539e-02, 3.918681e-02, 3.920824e-02,
    3.922966e-02, 3.925108e-02, 3.927251e-02, 3.929393e-02, 3.931535e-02, 3.933677e-02,
    3.935819e-02, 3.937962e-02, 3.940104e-02, 3.942246e-02, 3.944388e-02, 3.946530e-02,
    3.948672e-02, 3.950813e-02, 3.952955e-02, 3.955097e-02, 3.957239e-02, 3.959381e-02,
    3.961523e-02, 3.963665e-02, 3.965806e-02, 3.967948e-02, 3.970090e-02, 3.972231e-02,
    3.974373e-02, 3.976514e-02, 3.978656e-02, 3.980797e-02, 3.982939e-02, 3.985080e-02,
    3.987221e-02, 3.989363e-02, 3.991504e-02, 3.993645e-02, 3.995787e-02, 3.997928e-02,
    4.000069e-02, 4.002210e-02, 4.004351e-02, 4.006492e-02, 4.008633e-02, 4.010775e-02,
    4.012915e-02, 4.015056e-02, 4.017197e-02, 4.019338e-02, 4.021479e-02, 4.023620e-02,
    4.025761e-02, 4.027902e-02, 4.030043e-02, 4.032183e-02, 4.034324e-02, 4.036465e-02,
    4.038605e-02, 4.040746e-02, 4.042886e-02, 4.045027e-02, 4.047167e-02, 4.049308e-02,
    4.051448e-02, 4.053589e-02, 4.055729e-02, 4.057869e-02, 4.060010e-02, 4.062150e-02,
    4.064290e-02, 4.066430e-02, 4.068571e-02, 4.070711e-02, 4.072851e-02, 4.074991e-02,
    4.077131e-02, 4.079271e-02, 4.081411e-02, 4.083551e-02, 4.085691e-02, 4.087831e-02,
    4.089971e-02, 4.092110e-02, 4.094250e-02, 4.096390e-02, 4.098530e-02, 4.100670e-02,
    4.102809e-02, 4.104949e-02, 4.107088e-02, 4.109228e-02, 4.111367e-02, 4.113507e-02,
    4.115646e-02, 4.117786e-02, 4.119925e-02, 4.122065e-02, 4.124204e-02, 4.126344e-02,
    4.128483e-02, 4.130622e-02, 4.132761e-02, 4.134900e-02, 4.137040e-02, 4.139179e-02,
    4.141318e-02, 4.143457e-02, 4.145596e-02, 4.147735e-02, 4.149874e-02, 4.152013e-02,
    4.154152e-02, 4.156290e-02, 4.158429e-02, 4.160568e-02, 4.162707e-02, 4.164846e-02,
    4.166985e-02, 4.169123e-02, 4.171262e-02, 4.173401e-02, 4.175539e-02, 4.177678e-02,
    4.179816e-02, 4.181955e-02, 4.184093e-02, 4.186232e-02, 4.188370e-02, 4.190508e-02,
    4.192647e-02, 4.194785e-02, 4.196923e-02, 4.199062e-02, 4.201200e-02, 4.203338e-02,
    4.205476e-02, 4.207614e-02, 4.209752e-02, 4.211890e-02, 4.214028e-02, 4.216166e-02,
    4.218304e-02, 4.220442e-02, 4.222580e-02, 4.224718e-02, 4.226856e-02, 4.228994e-02,
    4.231131e-02, 4.233269e-02, 4.235407e-02, 4.237545e-02, 4.239682e-02, 4.241820e-02,
    4.243957e-02, 4.246095e-02, 4.248232e-02, 4.250370e-02, 4.252507e-02, 4.254645e-02,
    4.256782e-02, 4.258920e-02, 4.261057e-02, 4.263194e-02, 4.265331e-02, 4.267469e-02,
    4.269606e-02, 4.271743e-02, 4.273880e-02, 4.276017e-02, 4.278154e-02, 4.280291e-02,
    4.282428e-02, 4.284566e-02, 4.286702e-02, 4.288839e-02, 4.290976e-02, 4.293113e-02,
    4.295250e-02, 4.297386e-02, 4.299523e-02, 4.301660e-02, 4.303797e-02, 4.305933e-02,
    4.308070e-02, 4.310207e-02, 4.312343e-02, 4.314480e-02, 4.316616e-02, 4.318753e-02,
    4.320889e-02, 4.323025e-02, 4.325162e-02, 4.327298e-02, 4.329434e-02, 4.331571e-02,
    4.333707e-02, 4.335843e-02, 4.337979e-02, 4.340116e-02, 4.342252e-02, 4.344388e-02,
    4.346524e-02, 4.348660e-02, 4.350796e-02, 4.352932e-02, 4.355068e-02, 4.357204e-02,
    4.359340e-02, 4.361476e-02, 4.363611e-02, 4.365747e-02, 4.367883e-02, 4.370018e-02,
    4.372154e-02, 4.374290e-02, 4.376425e-02, 4.378561e-02, 4.380697e-02, 4.382832e-02,
    4.384967e-02, 4.387103e-02, 4.389239e-02, 4.391374e-02, 4.393509e-02, 4.395645e-02,
    4.397780e-02, 4.399915e-02, 4.402050e-02, 4.404185e-02, 4.406321e-02, 4.408456e-02,
    4.410591e-02, 4.412726e-02, 4.414861e-02, 4.416996e-02, 4.419131e-02, 4.421266e-02,
    4.423401e-02, 4.425536e-02, 4.427671e-02, 4.429806e-02, 4.431941e-02, 4.434075e-02,
    4.436210e-02, 4.438345e-02, 4.440479e-02, 4.442614e-02, 4.444749e-02, 4.446883e-02,
    4.449018e-02, 4.451152e-02, 4.453287e-02, 4.455421e-02, 4.457555e-02, 4.459690e-02,
    4.461824e-02, 4.463959e-02, 4.466093e-02, 4.468227e-02, 4.470361e-02, 4.472496e-02,
    4.474629e-02, 4.476764e-02, 4.478898e-02, 4.481032e-02, 4.483166e-02, 4.485300e-02,
    4.487434e-02, 4.489568e-02, 4.491702e-02, 4.493836e-02, 4.495970e-02, 4.498103e-02,
    4.500237e-02, 4.502371e-02, 4.504504e-02, 4.506639e-02, 4.508772e-02, 4.510906e-02,
    4.513039e-02, 4.515173e-02, 4.517306e-02, 4.519439e-02, 4.521573e-02, 4.523707e-02,
    4.525840e-02, 4.527974e-02, 4.530107e-02, 4.532240e-02, 4.534374e-02, 4.536507e-02,
    4.538640e-02, 4.540773e-02, 4.542906e-02, 4.545039e-02, 4.547172e-02, 4.549306e-02,
    4.551439e-02, 4.553572e-02, 4.555704e-02, 4.557838e-02, 4.559971e-02, 4.562103e-02,
    4.564236e-02, 4.566369e-02, 4.568502e-02, 4.570635e-02, 4.572767e-02, 4.574900e-02,
    4.577032e-02, 4.579165e-02, 4.581298e-02, 4.583430e-02, 4.585563e-02, 4.587695e-02,
    4.589828e-02, 4.591960e-02, 4.594092e-02, 4.596225e-02, 4.598357e-02, 4.600490e-02,
    4.602622e-02, 4.604754e-02, 4.606886e-02, 4.609019e-02, 4.611151e-02, 4.613283e-02,
    4.615415e-02, 4.617546e-02, 4.619678e-02, 4.621811e-02, 4.623943e-02, 4.626075e-02,
    4.628207e-02, 4.630338e-02, 4.632470e-02, 4.634602e-02, 4.636734e-02, 4.638866e-02,
    4.640998e-02, 4.643129e-02, 4.645260e-02, 4.647392e-02, 4.649524e-02, 4.651656e-02,
    4.653787e-02, 4.655918e-02, 4.658050e-02, 4.660181e-02, 4.662313e-02, 4.664444e-02,
    4.666575e-02, 4.668707e-02, 4.670838e-02, 4.672969e-02, 4.675100e-02, 4.677232e-02,
    4.679362e-02, 4.681493e-02, 4.683625e-02, 4.685756e-02, 4.687887e-02, 4.690018e-02,
    4.692149e-02, 4.694280e-02, 4.696410e-02, 4.698541e-02, 4.700672e-02, 4.702803e-02,
    4.704934e-02, 4.707064e-02, 4.709195e-02, 4.711326e-02, 4.713456e-02, 4.715587e-02,
    4.717718e-02, 4.719848e-02, 4.721979e-02, 4.724109e-02, 4.726240e-02, 4.728370e-02,
    4.730501e-02, 4.732631e-02, 4.734761e-02, 4.736891e-02, 4.739022e-02, 4.741152e-02,
    4.743282e-02, 4.745413e-02, 4.747542e-02, 4.749672e-02, 4.751803e-02, 4.753933e-02,
    4.756062e-02, 4.758192e-02, 4.760322e-02, 4.762452e-02, 4.764582e-02, 4.766712e-02,
    4.768842e-02, 4.770972e-02, 4.773102e-02, 4.775231e-02, 4.777361e-02, 4.779491e-02,
    4.781620e-02, 4.783750e-02, 4.785879e-02, 4.788009e-02, 4.790138e-02, 4.792268e-02,
    4.794398e-02, 4.796527e-02, 4.798656e-02, 4.800785e-02, 4.802915e-02, 4.805044e-02,
    4.807173e-02, 4.809302e-02, 4.811432e-02, 4.813560e-02, 4.815690e-02, 4.817819e-02,
    4.819948e-02, 4.822077e-02, 4.824206e-02, 4.826335e-02, 4.828464e-02, 4.830593e-02,
    4.832722e-02, 4.834851e-02, 4.836979e-02, 4.839108e-02, 4.841237e-02, 4.843366e-02,
    4.845494e-02, 4.847623e-02, 4.849752e-02, 4.851880e-02, 4.854009e-02, 4.856138e-02,
    4.858266e-02, 4.860394e-02, 4.862523e-02, 4.864651e-02, 4.866780e-02, 4.868908e-02,
    4.871036e-02, 4.873164e-02, 4.875293e-02, 4.877421e-02, 4.879549e-02, 4.881677e-02,
    4.883805e-02, 4.885934e-02, 4.888061e-02, 4.890190e-02, 4.892317e-02, 4.894445e-02,
    4.896573e-02, 4.898701e-02, 4.900829e-02, 4.902957e-02, 4.905085e-02, 4.907213e-02,
    4.909340e-02, 4.911468e-02, 4.913596e-02, 4.915724e-02, 4.917851e-02, 4.919979e-02,
    4.922106e-02, 4.924234e-02, 4.926361e-02, 4.928489e-02, 4.930616e-02, 4.932744e-02,
    4.934871e-02, 4.936998e-02, 4.939126e-02, 4.941253e-02, 4.943380e-02, 4.945507e-02,
    4.947634e-02, 4.949762e-02, 4.951888e-02, 4.954015e-02, 4.956143e-02, 4.958270e-02,
    4.960397e-02, 4.962524e-02, 4.964650e-02, 4.966778e-02, 4.968904e-02, 4.971031e-02,
    4.973158e-02, 4.975285e-02, 4.977412e-02, 4.979539e-02, 4.981665e-02, 4.983792e-02,
    4.985918e-02, 4.988045e-02, 4.990171e-02, 4.992298e-02, 4.994424e-02, 4.996551e-02,
    4.998677e-02, 5.000804e-02, 5.002930e-02, 5.005056e-02, 5.007182e-02, 5.009309e-02,
    5.011435e-02, 5.013561e-02, 5.015688e-02, 5.017814e-02, 5.019940e-02, 5.022066e-02,
    5.024192e-02, 5.026318e-02, 5.028444e-02, 5.030570e-02, 5.032696e-02, 5.034821e-02,
    5.036948e-02, 5.039074e-02, 5.041199e-02, 5.043325e-02, 5.045451e-02, 5.047576e-02,
    5.049702e-02, 5.051827e-02, 5.053953e-02, 5.056079e-02, 5.058204e-02, 5.060330e-02,
    5.062456e-02, 5.064581e-02, 5.066706e-02, 5.068832e-02, 5.070957e-02, 5.073082e-02,
    5.075207e-02, 5.077333e-02, 5.079458e-02, 5.081583e-02, 5.083709e-02, 5.085834e-02,
    5.087959e-02, 5.090084e-02, 5.092209e-02, 5.094334e-02, 5.096459e-02, 5.098584e-02,
    5.100709e-02, 5.102834e-02, 5.104959e-02, 5.107084e-02, 5.109208e-02, 5.111333e-02,
    5.113458e-02, 5.115582e-02, 5.117707e-02, 5.119831e-02, 5.121956e-02, 5.124081e-02,
    5.126206e-02, 5.128330e-02, 5.130455e-02, 5.132579e-02, 5.134703e-02, 5.136828e-02,
    5.138952e-02, 5.141076e-02, 5.143201e-02, 5.145325e-02, 5.147449e-02, 5.149573e-02,
    5.151698e-02, 5.153822e-02, 5.155946e-02, 5.158070e-02, 5.160194e-02, 5.162318e-02,
    5.164442e-02, 5.166566e-02, 5.168690e-02, 5.170814e-02, 5.172938e-02, 5.175062e-02,
    5.177185e-02, 5.179309e-02, 5.181433e-02, 5.183557e-02, 5.185680e-02, 5.187804e-02,
    5.189927e-02, 5.192051e-02, 5.194174e-02, 5.196298e-02, 5.198422e-02, 5.200545e-02,
    5.202668e-02, 5.204792e-02, 5.206915e-02, 5.209038e-02, 5.211162e-02, 5.213285e-02,
    5.215408e-02, 5.217532e-02, 5.219655e-02, 5.221777e-02, 5.223901e-02, 5.226024e-02,
    5.228147e-02, 5.230270e-02, 5.232393e-02, 5.234516e-02, 5.236639e-02, 5.238762e-02,
    5.240885e-02, 5.243007e-02, 5.245130e-02, 5.247253e-02, 5.249376e-02, 5.251498e-02,
    5.253621e-02, 5.255743e-02, 5.257867e-02, 5.259989e-02, 5.262111e-02, 5.264234e-02,
    5.266356e-02, 5.268479e-02, 5.270601e-02, 5.272724e-02, 5.274846e-02, 5.276968e-02,
    5.279091e-02, 5.281213e-02, 5.283336e-02, 5.285458e-02, 5.287580e-02, 5.289701e-02,
    5.291824e-02, 5.293946e-02, 5.296068e-02, 5.298190e-02, 5.300312e-02, 5.302434e-02,
    5.304556e-02, 5.306678e-02, 5.308800e-02, 5.310921e-02, 5.313043e-02, 5.315165e-02,
    5.317286e-02, 5.319408e-02, 5.321530e-02, 5.323652e-02, 5.325773e-02, 5.327895e-02,
    5.330016e-02, 5.332138e-02, 5.334260e-02, 5.336381e-02, 5.338502e-02, 5.340624e-02,
    5.342745e-02, 5.344867e-02, 5.346988e-02, 5.349109e-02, 5.351231e-02, 5.353351e-02,
    5.355472e-02, 5.357594e-02, 5.359715e-02, 5.361836e-02, 5.363957e-02, 5.366078e-02,
    5.368199e-02, 5.370320e-02, 5.372441e-02, 5.374562e-02, 5.376683e-02, 5.378804e-02,
    5.380924e-02, 5.383045e-02, 5.385166e-02, 5.387286e-02, 5.389407e-02, 5.391528e-02,
    5.393649e-02, 5.395769e-02, 5.397889e-02, 5.400010e-02, 5.402130e-02, 5.404251e-02,
    5.406372e-02, 5.408492e-02, 5.410612e-02, 5.412732e-02, 5.414853e-02, 5.416973e-02,
    5.419093e-02, 5.421213e-02, 5.423333e-02, 5.425454e-02, 5.427574e-02, 5.429694e-02,
    5.431814e-02, 5.433934e-02, 5.436054e-02, 5.438174e-02, 5.440294e-02, 5.442414e-02,
    5.444534e-02, 5.446653e-02, 5.448774e-02, 5.450893e-02, 5.453013e-02, 5.455133e-02,
    5.457252e-02, 5.459372e-02, 5.461492e-02, 5.463611e-02, 5.465731e-02, 5.467850e-02,
    5.469970e-02, 5.472089e-02, 5.474209e-02, 5.476328e-02, 5.478447e-02, 5.480567e-02,
    5.482686e-02, 5.484805e-02, 5.486925e-02, 5.489044e-02, 5.491163e-02, 5.493282e-02,
    5.495401e-02, 5.497520e-02, 5.499639e-02, 5.501758e-02, 5.503878e-02, 5.505996e-02,
    5.508115e-02, 5.510234e-02, 5.512353e-02, 5.514472e-02, 5.516591e-02, 5.518709e-02,
    5.520828e-02, 5.522947e-02, 5.525066e-02, 5.527184e-02, 5.529303e-02, 5.531422e-02,
    5.533540e-02, 5.535659e-02, 5.537777e-02, 5.539896e-02, 5.542014e-02, 5.544132e-02,
    5.546251e-02, 5.548369e-02, 5.550487e-02, 5.552606e-02, 5.554724e-02, 5.556842e-02,
    5.558960e-02, 5.561078e-02, 5.563197e-02, 5.565314e-02, 5.567433e-02, 5.569551e-02,
    5.571669e-02, 5.573787e-02, 5.575905e-02, 5.578022e-02, 5.580141e-02, 5.582258e-02,
    5.584376e-02, 5.586494e-02, 5.588612e-02, 5.590729e-02, 5.592847e-02, 5.594965e-02,
    5.597083e-02, 5.599200e-02, 5.601317e-02, 5.603435e-02, 5.605552e-02, 5.607670e-02,
    5.609788e-02, 5.611905e-02, 5.614022e-02, 5.616140e-02, 5.618257e-02, 5.620374e-02,
    5.622491e-02, 5.624609e-02, 5.626726e-02, 5.628843e-02, 5.630960e-02, 5.633077e-02,
    5.635194e-02, 5.637311e-02, 5.639428e-02, 5.641545e-02, 5.643662e-02, 5.645779e-02,
    5.647896e-02, 5.650013e-02, 5.652130e-02, 5.654246e-02, 5.656363e-02, 5.658480e-02,
    5.660596e-02, 5.662713e-02, 5.664830e-02, 5.666947e-02, 5.669063e-02, 5.671180e-02,
    5.673296e-02, 5.675412e-02, 5.677529e-02, 5.679645e-02, 5.681762e-02, 5.683878e-02,
    5.685994e-02, 5.688111e-02, 5.690227e-02, 5.692343e-02, 5.694459e-02, 5.696575e-02,
    5.698692e-02, 5.700808e-02, 5.702924e-02, 5.705040e-02, 5.707156e-02, 5.709272e-02,
    5.711388e-02, 5.713504e-02, 5.715620e-02, 5.717736e-02, 5.719851e-02, 5.721967e-02,
    5.724083e-02, 5.726198e-02, 5.728314e-02, 5.730430e-02, 5.732546e-02, 5.734661e-02,
    5.736777e-02, 5.738892e-02, 5.741008e-02, 5.743123e-02, 5.745239e-02, 5.747354e-02,
    5.749470e-02, 5.751585e-02, 5.753700e-02, 5.755815e-02, 5.757931e-02, 5.760046e-02,
    5.762161e-02, 5.764277e-02, 5.766392e-02, 5.768507e-02, 5.770621e-02, 5.772737e-02,
    5.774852e-02, 5.776967e-02, 5.779082e-02, 5.781197e-02, 5.783312e-02, 5.785426e-02,
    5.787541e-02, 5.789656e-02, 5.791771e-02, 5.793886e-02, 5.796000e-02, 5.798115e-02,
    5.800229e-02, 5.802344e-02, 5.804459e-02, 5.806573e-02, 5.808688e-02, 5.810802e-02,
    5.812917e-02, 5.815031e-02, 5.817145e-02, 5.819260e-02, 5.821374e-02, 5.823489e-02,
    5.825603e-02, 5.827717e-02, 5.829831e-02, 5.831946e-02, 5.834059e-02, 5.836174e-02,
    5.838288e-02, 5.840402e-02, 5.842516e-02, 5.844630e-02, 5.846744e-02, 5.848858e-02,
    5.850972e-02, 5.853086e-02, 5.855199e-02, 5.857313e-02, 5.859427e-02, 5.861541e-02,
    5.863654e-02, 5.865768e-02, 5.867882e-02, 5.869995e-02, 5.872109e-02, 5.874223e-02,
    5.876336e-02, 5.878450e-02, 5.880563e-02, 5.882677e-02, 5.884790e-02, 5.886903e-02,
    5.889016e-02, 5.891130e-02, 5.893243e-02, 5.895357e-02, 5.897470e-02, 5.899583e-02,
    5.901696e-02, 5.903809e-02, 5.905923e-02, 5.908035e-02, 5.910148e-02, 5.912261e-02,
    5.914374e-02, 5.916487e-02, 5.918600e-02, 5.920713e-02, 5.922826e-02, 5.924939e-02,
    5.927052e-02, 5.929164e-02, 5.931277e-02, 5.933389e-02, 5.935502e-02, 5.937615e-02,
    5.939728e-02, 5.941840e-02, 5.943953e-02, 5.946065e-02, 5.948178e-02, 5.950290e-02,
    5.952403e-02, 5.954515e-02, 5.956627e-02, 5.958740e-02, 5.960852e-02, 5.962964e-02,
    5.965076e-02, 5.967189e-02, 5.969300e-02, 5.971413e-02, 5.973525e-02, 5.975637e-02,
    5.977749e-02, 5.979861e-02, 5.981973e-02, 5.984085e-02, 5.986197e-02, 5.988309e-02,
    5.990421e-02, 5.992533e-02, 5.994644e-02, 5.996756e-02, 5.998868e-02, 6.000979e-02,
    6.003091e-02, 6.005203e-02, 6.007315e-02, 6.009426e-02, 6.011537e-02, 6.013649e-02,
    6.015761e-02, 6.017872e-02, 6.019983e-02, 6.022095e-02, 6.024206e-02, 6.026318e-02,
    6.028429e-02, 6.030541e-02, 6.032652e-02, 6.034763e-02, 6.036874e-02, 6.038985e-02,
    6.041096e-02, 6.043207e-02, 6.045318e-02, 6.047429e-02, 6.049540e-02, 6.051651e-02,
    6.053762e-02, 6.055873e-02, 6.057984e-02, 6.060095e-02, 6.062206e-02, 6.064316e-02,
    6.066427e-02, 6.068538e-02, 6.070649e-02, 6.072759e-02, 6.074870e-02, 6.076981e-02,
    6.079091e-02, 6.081202e-02, 6.083312e-02, 6.085422e-02, 6.087533e-02, 6.089643e-02,
    6.091753e-02, 6.093864e-02, 6.095975e-02, 6.098085e-02, 6.100195e-02, 6.102305e-02,
    6.104415e-02, 6.106526e-02, 6.108636e-02, 6.110746e-02, 6.112856e-02, 6.114966e-02,
    6.117076e-02, 6.119186e-02, 6.121296e-02, 6.123406e-02, 6.125515e-02, 6.127625e-02,
    6.129735e-02, 6.131845e-02, 6.133955e-02, 6.136064e-02, 6.138174e-02, 6.140283e-02,
    6.142393e-02, 6.144503e-02, 6.146613e-02, 6.148722e-02, 6.150832e-02, 6.152941e-02,
    6.155051e-02, 6.157160e-02, 6.159269e-02, 6.161379e-02, 6.163488e-02, 6.165597e-02,
    6.167707e-02, 6.169816e-02, 6.171925e-02, 6.174034e-02, 6.176143e-02, 6.178253e-02,
    6.180362e-02, 6.182471e-02, 6.184579e-02, 6.186688e-02, 6.188798e-02, 6.190906e-02,
    6.193015e-02, 6.195124e-02, 6.197233e-02, 6.199342e-02, 6.201451e-02, 6.203559e-02,
    6.205668e-02, 6.207777e-02, 6.209886e-02, 6.211994e-02, 6.214102e-02, 6.216211e-02,
    6.218320e-02, 6.220428e-02, 6.222536e-02, 6.224645e-02, 6.226753e-02, 6.228862e-02,
    6.230970e-02, 6.233079e-02, 6.235187e-02, 6.237295e-02, 6.239403e-02, 6.241512e-02,
    6.243619e-02, 6.245728e-02, 6.247836e-02, 6.249944e-02, 6.252052e-02, 6.254160e-02,
    6.256267e-02, 6.258376e-02, 6.260484e-02, 6.262591e-02, 6.264700e-02, 6.266808e-02,
    6.268915e-02, 6.271023e-02, 6.273130e-02, 6.275238e-02, 6.277346e-02, 6.279454e-02,
    6.281561e-02, 6.283669e-02, 6.285776e-02, 6.287884e-02, 6.289991e-02, 6.292099e-02,
    6.294206e-02, 6.296314e-02, 6.298421e-02, 6.300528e-02, 6.302635e-02, 6.304742e-02,
    6.306850e-02, 6.308957e-02, 6.311065e-02, 6.313171e-02, 6.315279e-02, 6.317385e-02,
    6.319493e-02, 6.321599e-02, 6.323707e-02, 6.325813e-02, 6.327920e-02, 6.330027e-02,
    6.332134e-02, 6.334241e-02, 6.336349e-02, 6.338455e-02, 6.340561e-02, 6.342668e-02,
    6.344775e-02, 6.346881e-02, 6.348988e-02, 6.351095e-02, 6.353202e-02, 6.355308e-02,
    6.357414e-02, 6.359521e-02, 6.361627e-02, 6.363734e-02, 6.365840e-02, 6.367946e-02,
    6.370053e-02, 6.372159e-02, 6.374265e-02, 6.376372e-02, 6.378478e-02, 6.380584e-02,
    6.382690e-02, 6.384796e-02, 6.386902e-02, 6.389008e-02, 6.391114e-02, 6.393220e-02,
    6.395326e-02, 6.397431e-02, 6.399538e-02, 6.401644e-02, 6.403749e-02, 6.405855e-02,
    6.407961e-02, 6.410066e-02, 6.412172e-02, 6.414278e-02, 6.416383e-02, 6.418489e-02,
    6.420595e-02, 6.422700e-02, 6.424806e-02, 6.426912e-02, 6.429017e-02, 6.431122e-02,
    6.433228e-02, 6.435332e-02, 6.437438e-02, 6.439544e-02, 6.441649e-02, 6.443754e-02,
    6.445859e-02, 6.447964e-02, 6.450070e-02, 6.452174e-02, 6.454280e-02, 6.456385e-02,
    6.458490e-02, 6.460595e-02, 6.462699e-02, 6.464805e-02, 6.466909e-02, 6.469014e-02,
    6.471119e-02, 6.473224e-02, 6.475329e-02, 6.477433e-02, 6.479538e-02, 6.481643e-02,
    6.483748e-02, 6.485852e-02, 6.487957e-02, 6.490061e-02, 6.492166e-02, 6.494270e-02,
    6.496375e-02, 6.498479e-02, 6.500584e-02, 6.502688e-02, 6.504792e-02, 6.506897e-02,
    6.509001e-02, 6.511105e-02, 6.513209e-02, 6.515314e-02, 6.517418e-02, 6.519522e-02,
    6.521626e-02, 6.523731e-02, 6.525835e-02, 6.527938e-02, 6.530042e-02, 6.532146e-02,
    6.534250e-02, 6.536354e-02, 6.538458e-02, 6.540561e-02, 6.542666e-02, 6.544769e-02,
    6.546873e-02, 6.548977e-02, 6.551080e-02, 6.553184e-02, 6.555288e-02, 6.557391e-02,
    6.559495e-02, 6.561598e-02, 6.563701e-02, 6.565805e-02, 6.567908e-02, 6.570012e-02,
    6.572115e-02, 6.574219e-02, 6.576322e-02, 6.578425e-02, 6.580528e-02, 6.582632e-02,
    6.584734e-02, 6.586838e-02, 6.588941e-02, 6.591044e-02, 6.593148e-02, 6.595250e-02,
    6.597354e-02, 6.599456e-02, 6.601559e-02, 6.603662e-02, 6.605765e-02, 6.607868e-02,
    6.609970e-02, 6.612074e-02, 6.614176e-02, 6.616279e-02, 6.618381e-02, 6.620484e-02,
    6.622586e-02, 6.624690e-02, 6.626792e-02, 6.628895e-02, 6.630997e-02, 6.633099e-02,
    6.635202e-02, 6.637304e-02, 6.639406e-02, 6.641509e-02, 6.643611e-02, 6.645713e-02,
    6.647816e-02, 6.649917e-02, 6.652020e-02, 6.654122e-02, 6.656224e-02, 6.658327e-02,
    6.660429e-02, 6.662530e-02, 6.664632e-02, 6.666735e-02, 6.668837e-02, 6.670938e-02,
    6.673040e-02, 6.675142e-02, 6.677244e-02, 6.679346e-02, 6.681447e-02, 6.683549e-02,
    6.685651e-02, 6.687753e-02, 6.689854e-02, 6.691957e-02, 6.694058e-02, 6.696159e-02,
    6.698261e-02, 6.700362e-02, 6.702464e-02, 6.704565e-02, 6.706667e-02, 6.708768e-02,
    6.710869e-02, 6.712970e-02, 6.715072e-02, 6.717173e-02, 6.719274e-02, 6.721375e-02,
    6.723477e-02, 6.725578e-02, 6.727678e-02, 6.729780e-02, 6.731881e-02, 6.733982e-02,
    6.736083e-02, 6.738184e-02, 6.740285e-02, 6.742386e-02, 6.744487e-02, 6.746588e-02,
    6.748688e-02, 6.750789e-02, 6.752890e-02, 6.754991e-02, 6.757091e-02, 6.759192e-02,
    6.761292e-02, 6.763393e-02, 6.765493e-02, 6.767593e-02, 6.769694e-02, 6.771795e-02,
    6.773895e-02, 6.775995e-02, 6.778096e-02, 6.780196e-02, 6.782296e-02, 6.784397e-02,
    6.786497e-02, 6.788597e-02, 6.790698e-02, 6.792798e-02, 6.794897e-02, 6.796998e-02,
    6.799097e-02, 6.801198e-02, 6.803298e-02, 6.805398e-02, 6.807498e-02, 6.809597e-02,
    6.811698e-02, 6.813797e-02, 6.815897e-02, 6.817997e-02, 6.820097e-02, 6.822196e-02,
    6.824296e-02, 6.826396e-02, 6.828495e-02, 6.830595e-02, 6.832694e-02, 6.834795e-02,
    6.836893e-02, 6.838993e-02, 6.841093e-02, 6.843192e-02, 6.845291e-02, 6.847391e-02,
    6.849490e-02, 6.851590e-02, 6.853689e-02, 6.855788e-02, 6.857887e-02, 6.859986e-02,
    6.862085e-02, 6.864184e-02, 6.866283e-02, 6.868383e-02, 6.870481e-02, 6.872580e-02,
    6.874679e-02, 6.876779e-02, 6.878877e-02, 6.880976e-02, 6.883075e-02, 6.885174e-02,
    6.887273e-02, 6.889372e-02, 6.891470e-02, 6.893568e-02, 6.895667e-02, 6.897765e-02,
    6.899864e-02, 6.901963e-02, 6.904061e-02, 6.906160e-02, 6.908259e-02, 6.910357e-02,
    6.912455e-02, 6.914554e-02, 6.916652e-02, 6.918750e-02, 6.920849e-02, 6.922947e-02,
    6.925046e-02, 6.927144e-02, 6.929242e-02, 6.931339e-02, 6.933437e-02, 6.935535e-02,
    6.937634e-02, 6.939732e-02, 6.941830e-02, 6.943928e-02, 6.946026e-02, 6.948124e-02,
    6.950221e-02, 6.952319e-02, 6.954417e-02, 6.956515e-02, 6.958613e-02, 6.960710e-02,
    6.962808e-02, 6.964906e-02, 6.967003e-02, 6.969101e-02, 6.971198e-02, 6.973296e-02,
    6.975393e-02, 6.977491e-02, 6.979588e-02, 6.981686e-02, 6.983783e-02, 6.985880e-02,
    6.987978e-02, 6.990074e-02, 6.992172e-02, 6.994270e-02, 6.996366e-02, 6.998464e-02,
    7.000561e-02, 7.002658e-02, 7.004755e-02, 7.006852e-02, 7.008949e-02, 7.011046e-02,
    7.013143e-02, 7.015240e-02, 7.017337e-02, 7.019433e-02, 7.021530e-02, 7.023627e-02,
    7.025724e-02, 7.027820e-02, 7.029917e-02, 7.032014e-02, 7.034111e-02, 7.036208e-02,
    7.038304e-02, 7.040401e-02, 7.042497e-02, 7.044593e-02, 7.046690e-02, 7.048786e-02,
    7.050882e-02, 7.052979e-02, 7.055075e-02, 7.057171e-02, 7.059268e-02, 7.061365e-02,
    7.063460e-02, 7.065556e-02, 7.067653e-02, 7.069749e-02, 7.071845e-02, 7.073941e-02,
    7.076037e-02, 7.078133e-02, 7.080229e-02, 7.082325e-02, 7.084420e-02, 7.086517e-02,
    7.088613e-02, 7.090708e-02, 7.092804e-02, 7.094900e-02, 7.096995e-02, 7.099091e-02,
    7.101187e-02, 7.103282e-02, 7.105378e-02, 7.107474e-02, 7.109569e-02, 7.111665e-02,
    7.113760e-02, 7.115856e-02, 7.117952e-02, 7.120046e-02, 7.122142e-02, 7.124237e-02,
    7.126332e-02, 7.128428e-02, 7.130523e-02, 7.132618e-02, 7.134713e-02, 7.136808e-02,
    7.138903e-02, 7.140999e-02, 7.143094e-02, 7.145189e-02, 7.147283e-02, 7.149378e-02,
    7.151473e-02, 7.153568e-02, 7.155664e-02, 7.157759e-02, 7.159853e-02, 7.161947e-02,
    7.164042e-02, 7.166137e-02, 7.168232e-02, 7.170326e-02, 7.172421e-02, 7.174516e-02,
    7.176610e-02, 7.178704e-02, 7.180800e-02, 7.182894e-02, 7.184988e-02, 7.187083e-02,
    7.189178e-02, 7.191272e-02, 7.193366e-02, 7.195460e-02, 7.197554e-02, 7.199649e-02,
    7.201743e-02, 7.203837e-02, 7.205931e-02, 7.208025e-02, 7.210120e-02, 7.212213e-02,
    7.214307e-02, 7.216401e-02, 7.218496e-02, 7.220589e-02, 7.222683e-02, 7.224777e-02,
    7.226871e-02, 7.228965e-02, 7.231058e-02, 7.233153e-02, 7.235246e-02, 7.237340e-02,
    7.239433e-02, 7.241527e-02, 7.243621e-02, 7.245714e-02, 7.247807e-02, 7.249901e-02,
    7.251994e-02, 7.254088e-02, 7.256182e-02, 7.258274e-02, 7.260368e-02, 7.262462e-02,
    7.264555e-02, 7.266648e-02, 7.268742e-02, 7.270834e-02, 7.272927e-02, 7.275021e-02,
    7.277114e-02, 7.279207e-02, 7.281300e-02, 7.283393e-02, 7.285486e-02, 7.287579e-02,
    7.289672e-02, 7.291765e-02, 7.293858e-02, 7.295951e-02, 7.298043e-02, 7.300135e-02,
    7.302228e-02, 7.304321e-02, 7.306414e-02, 7.308507e-02, 7.310599e-02, 7.312692e-02,
    7.314784e-02, 7.316877e-02, 7.318970e-02, 7.321062e-02, 7.323155e-02, 7.325247e-02,
    7.327339e-02, 7.329432e-02, 7.331524e-02, 7.333616e-02, 7.335709e-02, 7.337800e-02,
    7.339893e-02, 7.341985e-02, 7.344078e-02, 7.346170e-02, 7.348261e-02, 7.350354e-02,
    7.352445e-02, 7.354537e-02, 7.356630e-02, 7.358721e-02, 7.360813e-02, 7.362905e-02,
    7.364997e-02, 7.367089e-02, 7.369180e-02, 7.371272e-02, 7.373364e-02, 7.375456e-02,
    7.377547e-02, 7.379639e-02, 7.381731e-02, 7.383822e-02, 7.385914e-02, 7.388005e-02,
    7.390097e-02, 7.392188e-02, 7.394280e-02, 7.396371e-02, 7.398462e-02, 7.400553e-02,
    7.402645e-02, 7.404736e-02, 7.406827e-02, 7.408918e-02, 7.411010e-02, 7.413101e-02,
    7.415192e-02, 7.417282e-02, 7.419374e-02, 7.421465e-02, 7.423556e-02, 7.425647e-02,
    7.427738e-02, 7.429829e-02, 7.431920e-02, 7.434011e-02, 7.436101e-02, 7.438192e-02,
    7.440283e-02, 7.442374e-02, 7.444464e-02, 7.446555e-02, 7.448646e-02, 7.450736e-02,
    7.452827e-02, 7.454917e-02, 7.457007e-02, 7.459098e-02, 7.461188e-02, 7.463279e-02,
    7.465369e-02, 7.467460e-02, 7.469550e-02, 7.471640e-02, 7.473730e-02, 7.475821e-02,
    7.477911e-02, 7.480001e-02, 7.482091e-02, 7.484181e-02, 7.486271e-02, 7.488362e-02,
    7.490451e-02, 7.492542e-02, 7.494631e-02, 7.496721e-02, 7.498811e-02, 7.500901e-02,
    7.502991e-02, 7.505080e-02, 7.507171e-02, 7.509260e-02, 7.511350e-02, 7.513440e-02,
    7.515529e-02, 7.517619e-02, 7.519709e-02, 7.521798e-02, 7.523888e-02, 7.525977e-02,
    7.528067e-02, 7.530156e-02, 7.532245e-02, 7.534335e-02, 7.536424e-02, 7.538513e-02,
    7.540602e-02, 7.542692e-02, 7.544781e-02, 7.546870e-02, 7.548960e-02, 7.551049e-02,
    7.553138e-02, 7.555227e-02, 7.557316e-02, 7.559405e-02, 7.561494e-02, 7.563583e-02,
    7.565671e-02, 7.567760e-02, 7.569849e-02, 7.571938e-02, 7.574027e-02, 7.576115e-02,
    7.578205e-02, 7.580293e-02, 7.582382e-02, 7.584471e-02, 7.586560e-02, 7.588648e-02,
    7.590736e-02, 7.592825e-02, 7.594913e-02, 7.597002e-02, 7.599091e-02, 7.601179e-02,
    7.603267e-02, 7.605355e-02, 7.607444e-02, 7.609532e-02, 7.611620e-02, 7.613709e-02,
    7.615797e-02, 7.617885e-02, 7.619973e-02, 7.622062e-02, 7.624149e-02, 7.626238e-02,
    7.628325e-02, 7.630413e-02, 7.632501e-02, 7.634589e-02, 7.636677e-02, 7.638765e-02,
    7.640853e-02, 7.642940e-02, 7.645029e-02, 7.647116e-02, 7.649204e-02, 7.651292e-02,
    7.653379e-02, 7.655467e-02, 7.657555e-02, 7.659642e-02, 7.661730e-02, 7.663817e-02,
    7.665905e-02, 7.667992e-02, 7.670080e-02, 7.672167e-02, 7.674254e-02, 7.676341e-02,
    7.678429e-02, 7.680516e-02, 7.682603e-02, 7.684691e-02, 7.686777e-02, 7.688865e-02,
    7.690952e-02, 7.693039e-02, 7.695126e-02, 7.697213e-02, 7.699300e-02, 7.701387e-02,
    7.703473e-02, 7.705560e-02, 7.707647e-02, 7.709734e-02, 7.711821e-02, 7.713908e-02,
    7.715995e-02, 7.718082e-02, 7.720169e-02, 7.722255e-02, 7.724342e-02, 7.726428e-02,
    7.728515e-02, 7.730601e-02, 7.732688e-02, 7.734774e-02, 7.736861e-02, 7.738947e-02,
    7.741034e-02, 7.743120e-02, 7.745206e-02, 7.747293e-02, 7.749379e-02, 7.751465e-02,
    7.753551e-02, 7.755637e-02, 7.757723e-02, 7.759810e-02, 7.761896e-02, 7.763982e-02,
    7.766068e-02, 7.768153e-02, 7.770240e-02, 7.772326e-02, 7.774412e-02, 7.776497e-02,
    7.778583e-02, 7.780669e-02, 7.782755e-02, 7.784841e-02, 7.786926e-02, 7.789012e-02,
    7.791097e-02, 7.793184e-02, 7.795269e-02, 7.797354e-02, 7.799440e-02, 7.801526e-02,
    7.803611e-02, 7.805696e-02, 7.807782e-02, 7.809868e-02, 7.811953e-02, 7.814038e-02,
    7.816123e-02, 7.818209e-02, 7.820294e-02, 7.822379e-02, 7.824464e-02, 7.826550e-02,
    7.828635e-02, 7.830720e-02, 7.832805e-02, 7.834890e-02, 7.836974e-02, 7.839060e-02,
    7.841145e-02, 7.843229e-02, 7.845315e-02, 7.847399e-02, 7.849485e-02, 7.851569e-02,
    7.853654e-02, 7.855739e-02, 7.857823e-02, 7.859907e-02, 7.861992e-02, 7.864077e-02,
    7.866162e-02, 7.868246e-02, 7.870331e-02, 7.872415e-02, 7.874500e-02, 7.876584e-02,
    7.878668e-02, 7.880753e-02, 7.882837e-02, 7.884921e-02, 7.887006e-02, 7.889090e-02,
    7.891174e-02, 7.893258e-02, 7.895342e-02, 7.897427e-02, 7.899511e-02, 7.901595e-02,
    7.903679e-02, 7.905763e-02, 7.907847e-02, 7.909930e-02, 7.912014e-02, 7.914099e-02,
    7.916182e-02, 7.918266e-02, 7.920350e-02, 7.922434e-02, 7.924518e-02, 7.926601e-02,
    7.928685e-02, 7.930769e-02, 7.932852e-02, 7.934935e-02, 7.937019e-02, 7.939103e-02,
    7.941186e-02, 7.943270e-02, 7.945354e-02, 7.947437e-02, 7.949520e-02, 7.951603e-02,
    7.953686e-02, 7.955770e-02, 7.957853e-02, 7.959937e-02, 7.962020e-02, 7.964103e-02,
    7.966186e-02, 7.968269e-02, 7.970352e-02, 7.972435e-02, 7.974518e-02, 7.976601e-02,
    7.978684e-02, 7.980768e-02, 7.982850e-02, 7.984933e-02, 7.987016e-02, 7.989098e-02,
    7.991181e-02, 7.993264e-02, 7.995347e-02, 7.997429e-02, 7.999512e-02, 8.001594e-02,
    8.003677e-02, 8.005760e-02, 8.007842e-02, 8.009925e-02, 8.012007e-02, 8.014090e-02,
    8.016172e-02, 8.018254e-02, 8.020337e-02, 8.022419e-02, 8.024501e-02, 8.026584e-02,
    8.028666e-02, 8.030748e-02, 8.032830e-02, 8.034912e-02, 8.036995e-02, 8.039077e-02,
    8.041159e-02, 8.043241e-02, 8.045322e-02, 8.047405e-02, 8.049487e-02, 8.051569e-02,
    8.053650e-02, 8.055732e-02, 8.057814e-02, 8.059896e-02, 8.061977e-02, 8.064060e-02,
    8.066141e-02, 8.068223e-02, 8.070304e-02, 8.072386e-02, 8.074468e-02, 8.076549e-02,
    8.078631e-02, 8.080712e-02, 8.082794e-02, 8.084875e-02, 8.086956e-02, 8.089038e-02,
    8.091119e-02, 8.093201e-02, 8.095282e-02, 8.097363e-02, 8.099444e-02, 8.101525e-02,
    8.103606e-02, 8.105687e-02, 8.107769e-02, 8.109850e-02, 8.111931e-02, 8.114012e-02,
    8.116093e-02, 8.118173e-02, 8.120254e-02, 8.122335e-02, 8.124416e-02, 8.126497e-02,
    8.128577e-02, 8.130658e-02, 8.132739e-02, 8.134820e-02, 8.136901e-02, 8.138981e-02,
    8.141062e-02, 8.143143e-02, 8.145223e-02, 8.147304e-02, 8.149384e-02, 8.151464e-02,
    8.153545e-02, 8.155625e-02, 8.157706e-02, 8.159786e-02, 8.161866e-02, 8.163947e-02,
    8.166027e-02, 8.168107e-02, 8.170187e-02, 8.172267e-02, 8.174348e-02, 8.176427e-02,
    8.178508e-02, 8.180588e-02, 8.182668e-02, 8.184748e-02, 8.186828e-02, 8.188908e-02,
    8.190987e-02, 8.193067e-02, 8.195148e-02, 8.197227e-02, 8.199307e-02, 8.201387e-02,
    8.203466e-02, 8.205546e-02, 8.207626e-02, 8.209705e-02, 8.211785e-02, 8.213864e-02,
    8.215944e-02, 8.218023e-02, 8.220103e-02, 8.222182e-02, 8.224262e-02, 8.226341e-02,
    8.228420e-02, 8.230499e-02, 8.232579e-02, 8.234658e-02, 8.236738e-02, 8.238816e-02,
    8.240896e-02, 8.242975e-02, 8.245054e-02, 8.247133e-02, 8.249212e-02, 8.251292e-02,
    8.253370e-02, 8.255450e-02, 8.257528e-02, 8.259607e-02, 8.261686e-02, 8.263765e-02,
    8.265843e-02, 8.267923e-02, 8.270001e-02, 8.272080e-02, 8.274158e-02, 8.276238e-02,
    8.278316e-02, 8.280394e-02, 8.282473e-02, 8.284552e-02, 8.286630e-02, 8.288708e-02,
    8.290787e-02, 8.292865e-02, 8.294944e-02, 8.297022e-02, 8.299100e-02, 8.301179e-02,
    8.303257e-02, 8.305335e-02, 8.307414e-02, 8.309492e-02, 8.311570e-02, 8.313648e-02,
    8.315726e-02, 8.317804e-02, 8.319882e-02, 8.321960e-02, 8.324038e-02, 8.326116e-02,
    8.328194e-02, 8.330272e-02, 8.332350e-02, 8.334427e-02, 8.336505e-02, 8.338583e-02,
    8.340661e-02, 8.342738e-02, 8.344816e-02, 8.346894e-02, 8.348972e-02, 8.351049e-02,
    8.353126e-02, 8.355204e-02, 8.357282e-02, 8.359359e-02, 8.361436e-02, 8.363514e-02,
    8.365592e-02, 8.367669e-02, 8.369746e-02, 8.371823e-02, 8.373901e-02, 8.375978e-02,
    8.378055e-02, 8.380132e-02, 8.382209e-02, 8.384287e-02, 8.386364e-02, 8.388440e-02,
    8.390518e-02, 8.392594e-02, 8.394671e-02, 8.396748e-02, 8.398826e-02, 8.400902e-02,
    8.402979e-02, 8.405056e-02, 8.407133e-02, 8.409210e-02, 8.411286e-02, 8.413363e-02,
    8.415440e-02, 8.417516e-02, 8.419593e-02, 8.421669e-02, 8.423746e-02, 8.425822e-02,
    8.427899e-02, 8.429975e-02, 8.432052e-02, 8.434128e-02, 8.436204e-02, 8.438280e-02,
    8.440357e-02, 8.442433e-02, 8.444510e-02, 8.446585e-02, 8.448662e-02, 8.450738e-02,
    8.452814e-02, 8.454890e-02, 8.456966e-02, 8.459043e-02, 8.461118e-02, 8.463194e-02,
    8.465271e-02, 8.467346e-02, 8.469422e-02, 8.471498e-02, 8.473574e-02, 8.475649e-02,
    8.477725e-02, 8.479801e-02, 8.481877e-02, 8.483952e-02, 8.486028e-02, 8.488104e-02,
    8.490179e-02, 8.492254e-02, 8.494330e-02, 8.496406e-02, 8.498481e-02, 8.500557e-02,
    8.502632e-02, 8.504707e-02, 8.506782e-02, 8.508858e-02, 8.510933e-02, 8.513009e-02,
    8.515084e-02, 8.517159e-02, 8.519235e-02, 8.521309e-02, 8.523384e-02, 8.525459e-02,
    8.527534e-02, 8.529609e-02, 8.531684e-02, 8.533759e-02, 8.535834e-02, 8.537909e-02,
    8.539984e-02, 8.542059e-02, 8.544134e-02, 8.546209e-02, 8.548283e-02, 8.550359e-02,
    8.552433e-02, 8.554507e-02, 8.556582e-02, 8.558656e-02, 8.560731e-02, 8.562806e-02,
    8.564880e-02, 8.566955e-02, 8.569029e-02, 8.571104e-02, 8.573177e-02, 8.575252e-02,
    8.577327e-02, 8.579401e-02, 8.581475e-02, 8.583549e-02, 8.585624e-02, 8.587698e-02,
    8.589772e-02, 8.591846e-02, 8.593921e-02, 8.595994e-02, 8.598068e-02, 8.600143e-02,
    8.602216e-02, 8.604290e-02, 8.606364e-02, 8.608438e-02, 8.610512e-02, 8.612585e-02,
    8.614659e-02, 8.616734e-02, 8.618807e-02, 8.620881e-02, 8.622954e-02, 8.625028e-02,
    8.627102e-02, 8.629175e-02, 8.631249e-02, 8.633322e-02, 8.635396e-02, 8.637469e-02,
    8.639543e-02, 8.641616e-02, 8.643690e-02, 8.645763e-02, 8.647836e-02, 8.649909e-02,
    8.651982e-02, 8.654056e-02, 8.656129e-02, 8.658202e-02, 8.660275e-02, 8.662348e-02,
    8.664422e-02, 8.666494e-02, 8.668567e-02, 8.670640e-02, 8.672713e-02, 8.674787e-02,
    8.676859e-02, 8.678932e-02, 8.681004e-02, 8.683078e-02, 8.685151e-02, 8.687223e-02,
    8.689296e-02, 8.691368e-02, 8.693441e-02, 8.695514e-02, 8.697587e-02, 8.699659e-02,
    8.701731e-02, 8.703804e-02, 8.705877e-02, 8.707950e-02, 8.710022e-02, 8.712094e-02,
    8.714166e-02, 8.716239e-02, 8.718311e-02, 8.720383e-02, 8.722455e-02, 8.724528e-02,
    8.726600e-02, 8.728672e-02, 8.730745e-02, 8.732817e-02, 8.734888e-02, 8.736961e-02,
    8.739033e-02, 8.741104e-02, 8.743176e-02, 8.745248e-02, 8.747321e-02, 8.749392e-02,
    8.751463e-02, 8.753535e-02, 8.755607e-02, 8.757679e-02, 8.759751e-02, 8.761822e-02,
    8.763894e-02, 8.765966e-02, 8.768037e-02, 8.770109e-02, 8.772180e-02, 8.774251e-02,
    8.776323e-02, 8.778395e-02, 8.780466e-02, 8.782537e-02, 8.784609e-02, 8.786680e-02,
    8.788752e-02, 8.790823e-02, 8.792894e-02, 8.794966e-02, 8.797036e-02, 8.799107e-02,
    8.801179e-02, 8.803250e-02, 8.805321e-02, 8.807392e-02, 8.809463e-02, 8.811533e-02,
    8.813605e-02, 8.815675e-02, 8.817746e-02, 8.819818e-02, 8.821888e-02, 8.823959e-02,
    8.826030e-02, 8.828101e-02, 8.830171e-02, 8.832242e-02, 8.834312e-02, 8.836383e-02,
    8.838453e-02, 8.840524e-02, 8.842594e-02, 8.844665e-02, 8.846735e-02, 8.848806e-02,
    8.850876e-02, 8.852947e-02, 8.855017e-02, 8.857087e-02, 8.859158e-02, 8.861228e-02,
    8.863299e-02, 8.865368e-02, 8.867438e-02, 8.869509e-02, 8.871579e-02, 8.873648e-02,
    8.875719e-02, 8.877789e-02, 8.879859e-02, 8.881929e-02, 8.883999e-02, 8.886068e-02,
    8.888139e-02, 8.890209e-02, 8.892278e-02, 8.894347e-02, 8.896417e-02, 8.898487e-02,
    8.900557e-02, 8.902626e-02, 8.904696e-02, 8.906766e-02, 8.908836e-02, 8.910905e-02,
    8.912975e-02, 8.915044e-02, 8.917113e-02, 8.919183e-02, 8.921252e-02, 8.923321e-02,
    8.925391e-02, 8.927460e-02, 8.929530e-02, 8.931599e-02, 8.933668e-02, 8.935737e-02,
    8.937806e-02, 8.939876e-02, 8.941945e-02, 8.944014e-02, 8.946083e-02, 8.948152e-02,
    8.950221e-02, 8.952290e-02, 8.954358e-02, 8.956428e-02, 8.958496e-02, 8.960565e-02,
    8.962634e-02, 8.964702e-02, 8.966772e-02, 8.968840e-02, 8.970909e-02, 8.972977e-02,
    8.975045e-02, 8.977114e-02, 8.979183e-02, 8.981252e-02, 8.983320e-02, 8.985388e-02,
    8.987457e-02, 8.989526e-02, 8.991594e-02, 8.993662e-02, 8.995730e-02, 8.997799e-02,
    8.999867e-02, 9.001935e-02, 9.004004e-02, 9.006071e-02, 9.008140e-02, 9.010208e-02,
    9.012276e-02, 9.014343e-02, 9.016412e-02, 9.018480e-02, 9.020548e-02, 9.022616e-02,
    9.024684e-02, 9.026751e-02, 9.028819e-02, 9.030887e-02, 9.032956e-02, 9.035023e-02,
    9.037091e-02, 9.039158e-02, 9.041226e-02, 9.043294e-02, 9.045361e-02, 9.047429e-02,
    9.049496e-02, 9.051564e-02, 9.053631e-02, 9.055699e-02, 9.057766e-02, 9.059833e-02,
    9.061901e-02, 9.063968e-02, 9.066036e-02, 9.068103e-02, 9.070171e-02, 9.072237e-02,
    9.074304e-02, 9.076372e-02, 9.078439e-02, 9.080507e-02, 9.082574e-02, 9.084640e-02,
    9.086708e-02, 9.088775e-02, 9.090842e-02, 9.092908e-02, 9.094974e-02, 9.097042e-02,
    9.099109e-02, 9.101176e-02, 9.103243e-02, 9.105308e-02, 9.107376e-02, 9.109443e-02,
    9.111509e-02, 9.113576e-02, 9.115642e-02, 9.117708e-02, 9.119776e-02, 9.121841e-02,
    9.123909e-02, 9.125975e-02, 9.128042e-02, 9.130108e-02, 9.132174e-02, 9.134240e-02,
    9.136306e-02, 9.138373e-02, 9.140439e-02, 9.142505e-02, 9.144571e-02, 9.146638e-02,
    9.148704e-02, 9.150770e-02, 9.152836e-02, 9.154902e-02, 9.156968e-02, 9.159034e-02,
    9.161100e-02, 9.163166e-02, 9.165232e-02, 9.167298e-02, 9.169363e-02, 9.171429e-02,
    9.173495e-02, 9.175561e-02, 9.177626e-02, 9.179692e-02, 9.181758e-02, 9.183824e-02,
    9.185889e-02, 9.187955e-02, 9.190021e-02, 9.192086e-02, 9.194151e-02, 9.196217e-02,
    9.198283e-02, 9.200347e-02, 9.202413e-02, 9.204478e-02, 9.206544e-02, 9.208609e-02,
    9.210674e-02, 9.212740e-02, 9.214804e-02, 9.216870e-02, 9.218934e-02, 9.221000e-02,
    9.223065e-02, 9.225130e-02, 9.227195e-02, 9.229260e-02, 9.231324e-02, 9.233390e-02,
    9.235454e-02, 9.237519e-02, 9.239584e-02, 9.241649e-02, 9.243714e-02, 9.245779e-02,
    9.247844e-02, 9.249908e-02, 9.251972e-02, 9.254037e-02, 9.256102e-02, 9.258167e-02,
    9.260231e-02, 9.262296e-02, 9.264360e-02, 9.266424e-02, 9.268489e-02, 9.270553e-02,
    9.272618e-02, 9.274682e-02, 9.276746e-02, 9.278810e-02, 9.280875e-02, 9.282938e-02,
    9.285004e-02, 9.287068e-02, 9.289131e-02, 9.291195e-02, 9.293260e-02, 9.295323e-02,
    9.297387e-02, 9.299451e-02, 9.301515e-02, 9.303580e-02, 9.305644e-02, 9.307708e-02,
    9.309771e-02, 9.311835e-02, 9.313899e-02, 9.315962e-02, 9.318026e-02, 9.320089e-02,
    9.322153e-02, 9.324217e-02, 9.326281e-02, 9.328344e-02, 9.330407e-02, 9.332471e-02,
    9.334534e-02, 9.336598e-02, 9.338661e-02, 9.340725e-02, 9.342787e-02, 9.344851e-02,
    9.346915e-02, 9.348978e-02, 9.351040e-02, 9.353104e-02, 9.355167e-02, 9.357231e-02,
    9.359293e-02, 9.361356e-02, 9.363420e-02, 9.365483e-02, 9.367546e-02, 9.369610e-02,
    9.371672e-02, 9.373735e-02, 9.375797e-02, 9.377860e-02, 9.379923e-02, 9.381986e-02,
    9.384049e-02, 9.386111e-02, 9.388174e-02, 9.390236e-02, 9.392300e-02, 9.394362e-02,
    9.396425e-02, 9.398487e-02, 9.400550e-02, 9.402613e-02, 9.404674e-02, 9.406737e-02,
    9.408800e-02, 9.410862e-02, 9.412924e-02, 9.414987e-02, 9.417049e-02, 9.419111e-02,
    9.421173e-02, 9.423236e-02, 9.425297e-02, 9.427360e-02, 9.429422e-02, 9.431484e-02,
    9.433546e-02, 9.435609e-02, 9.437671e-02, 9.439732e-02, 9.441794e-02, 9.443857e-02,
    9.445918e-02, 9.447980e-02, 9.450042e-02, 9.452103e-02, 9.454165e-02, 9.456228e-02,
    9.458289e-02, 9.460351e-02, 9.462412e-02, 9.464474e-02, 9.466536e-02, 9.468597e-02,
    9.470658e-02, 9.472720e-02, 9.474781e-02, 9.476843e-02, 9.478904e-02, 9.480965e-02,
    9.483027e-02, 9.485088e-02, 9.487150e-02, 9.489211e-02, 9.491272e-02, 9.493332e-02,
    9.495395e-02, 9.497455e-02, 9.499516e-02, 9.501577e-02, 9.503639e-02, 9.505700e-02,
    9.507761e-02, 9.509821e-02, 9.511882e-02, 9.513944e-02, 9.516004e-02, 9.518065e-02,
    9.520126e-02, 9.522187e-02, 9.524248e-02, 9.526308e-02, 9.528369e-02, 9.530430e-02,
    9.532490e-02, 9.534550e-02, 9.536611e-02, 9.538671e-02, 9.540732e-02, 9.542793e-02,
    9.544853e-02, 9.546914e-02, 9.548975e-02, 9.551035e-02, 9.553096e-02, 9.555155e-02,
    9.557216e-02, 9.559276e-02, 9.561336e-02, 9.563396e-02, 9.565457e-02, 9.567516e-02,
    9.569577e-02, 9.571636e-02, 9.573697e-02, 9.575757e-02, 9.577817e-02, 9.579877e-02,
    9.581937e-02, 9.583996e-02, 9.586056e-02, 9.588116e-02, 9.590176e-02, 9.592236e-02,
    9.594296e-02, 9.596356e-02, 9.598415e-02, 9.600475e-02, 9.602534e-02, 9.604593e-02,
    9.606654e-02, 9.608714e-02, 9.610773e-02, 9.612833e-02, 9.614892e-02, 9.616952e-02,
    9.619010e-02, 9.621070e-02, 9.623129e-02, 9.625188e-02, 9.627248e-02, 9.629308e-02,
    9.631366e-02, 9.633426e-02, 9.635485e-02, 9.637544e-02, 9.639603e-02, 9.641662e-02,
    9.643721e-02, 9.645780e-02, 9.647839e-02, 9.649898e-02, 9.651957e-02, 9.654016e-02,
    9.656075e-02, 9.658134e-02, 9.660193e-02, 9.662250e-02, 9.664311e-02, 9.666368e-02,
    9.668427e-02, 9.670486e-02, 9.672545e-02, 9.674603e-02, 9.676662e-02, 9.678720e-02,
    9.680779e-02, 9.682837e-02, 9.684896e-02, 9.686954e-02, 9.689012e-02, 9.691071e-02,
    9.693129e-02, 9.695188e-02, 9.697246e-02, 9.699304e-02, 9.701363e-02, 9.703422e-02,
    9.705479e-02, 9.707537e-02, 9.709595e-02, 9.711653e-02, 9.713712e-02, 9.715769e-02,
    9.717827e-02, 9.719885e-02, 9.721944e-02, 9.724001e-02, 9.726059e-02, 9.728117e-02,
    9.730174e-02, 9.732233e-02, 9.734290e-02, 9.736349e-02, 9.738406e-02, 9.740463e-02,
    9.742521e-02, 9.744579e-02, 9.746636e-02, 9.748694e-02, 9.750751e-02, 9.752809e-02,
    9.754866e-02, 9.756924e-02, 9.758981e-02, 9.761038e-02, 9.763096e-02, 9.765153e-02,
    9.767210e-02, 9.769268e-02, 9.771325e-02, 9.773382e-02, 9.775439e-02, 9.777496e-02,
    9.779554e-02, 9.781611e-02, 9.783667e-02, 9.785724e-02, 9.787782e-02, 9.789839e-02,
    9.791896e-02, 9.793953e-02, 9.796009e-02, 9.798066e-02, 9.800123e-02, 9.802181e-02,
    9.804236e-02, 9.806294e-02, 9.808350e-02, 9.810406e-02, 9.812464e-02, 9.814520e-02,
    9.816577e-02, 9.818634e-02, 9.820690e-02, 9.822746e-02, 9.824802e-02, 9.826858e-02,
    9.828916e-02, 9.830973e-02, 9.833028e-02, 9.835085e-02, 9.837141e-02, 9.839197e-02,
    9.841254e-02, 9.843310e-02, 9.845366e-02, 9.847423e-02, 9.849478e-02, 9.851534e-02,
    9.853590e-02, 9.855647e-02, 9.857703e-02, 9.859758e-02, 9.861814e-02, 9.863871e-02,
    9.865925e-02, 9.867982e-02, 9.870038e-02, 9.872093e-02, 9.874149e-02, 9.876205e-02,
    9.878261e-02, 9.880316e-02, 9.882371e-02, 9.884427e-02, 9.886483e-02, 9.888539e-02,
    9.890594e-02, 9.892649e-02, 9.894705e-02, 9.896761e-02, 9.898816e-02, 9.900872e-02,
    9.902927e-02, 9.904981e-02, 9.907037e-02, 9.909092e-02, 9.911148e-02, 9.913204e-02,
    9.915259e-02, 9.917313e-02, 9.919368e-02, 9.921423e-02, 9.923478e-02, 9.925534e-02,
    9.927589e-02, 9.929644e-02, 9.931698e-02, 9.933753e-02, 9.935808e-02, 9.937864e-02,
    9.939918e-02, 9.941973e-02, 9.944027e-02, 9.946083e-02, 9.948137e-02, 9.950192e-02,
    9.952247e-02, 9.954301e-02, 9.956356e-02, 9.958410e-02, 9.960464e-02, 9.962519e-02,
    9.964573e-02, 9.966628e-02, 9.968683e-02, 9.970737e-02, 9.972791e-02, 9.974845e-02,
    9.976900e-02, 9.978954e-02, 9.981009e-02, 9.983063e-02, 9.985117e-02, 9.987171e-02,
    9.989225e-02, 9.991279e-02, 9.993333e-02, 9.995387e-02, 9.997442e-02, 9.999496e-02,
    1.000155e-01, 1.000360e-01, 1.000566e-01, 1.000771e-01, 1.000977e-01, 1.001182e-01,
    1.001387e-01, 1.001593e-01, 1.001798e-01, 1.002003e-01, 1.002209e-01, 1.002414e-01,
    1.002619e-01, 1.002825e-01, 1.003030e-01, 1.003236e-01, 1.003441e-01, 1.003646e-01,
    1.003852e-01, 1.004057e-01, 1.004262e-01, 1.004468e-01, 1.004673e-01, 1.004878e-01,
    1.005084e-01, 1.005289e-01, 1.005494e-01, 1.005699e-01, 1.005905e-01, 1.006110e-01,
    1.006315e-01, 1.006521e-01, 1.006726e-01, 1.006931e-01, 1.007137e-01, 1.007342e-01,
    1.007547e-01, 1.007753e-01, 1.007958e-01, 1.008163e-01, 1.008368e-01, 1.008574e-01,
    1.008779e-01, 1.008984e-01, 1.009189e-01, 1.009395e-01, 1.009600e-01, 1.009805e-01,
    1.010010e-01, 1.010216e-01, 1.010421e-01, 1.010626e-01, 1.010831e-01, 1.011037e-01,
    1.011242e-01, 1.011447e-01, 1.011652e-01, 1.011858e-01, 1.012063e-01, 1.012268e-01,
    1.012473e-01, 1.012679e-01, 1.012884e-01, 1.013089e-01, 1.013294e-01, 1.013499e-01,
    1.013705e-01, 1.013910e-01, 1.014115e-01, 1.014320e-01, 1.014525e-01, 1.014731e-01,
    1.014936e-01, 1.015141e-01, 1.015346e-01, 1.015551e-01, 1.015756e-01, 1.015962e-01,
    1.016167e-01, 1.016372e-01, 1.016577e-01, 1.016782e-01, 1.016987e-01, 1.017193e-01,
    1.017398e-01, 1.017603e-01, 1.017808e-01, 1.018013e-01, 1.018218e-01, 1.018423e-01,
    1.018629e-01, 1.018834e-01, 1.019039e-01, 1.019244e-01, 1.019449e-01, 1.019654e-01,
    1.019859e-01, 1.020064e-01, 1.020269e-01, 1.020475e-01, 1.020680e-01, 1.020885e-01,
    1.021090e-01, 1.021295e-01, 1.021500e-01, 1.021705e-01, 1.021910e-01, 1.022115e-01,
    1.022320e-01, 1.022526e-01, 1.022731e-01, 1.022936e-01, 1.023141e-01, 1.023346e-01,
    1.023551e-01, 1.023756e-01, 1.023961e-01, 1.024166e-01, 1.024371e-01, 1.024576e-01,
    1.024781e-01, 1.024986e-01, 1.025191e-01, 1.025396e-01, 1.025601e-01, 1.025806e-01,
    1.026011e-01, 1.026216e-01, 1.026421e-01, 1.026626e-01, 1.026831e-01, 1.027036e-01,
    1.027241e-01, 1.027446e-01, 1.027652e-01, 1.027856e-01, 1.028061e-01, 1.028266e-01,
    1.028471e-01, 1.028676e-01, 1.028881e-01, 1.029086e-01, 1.029291e-01, 1.029496e-01,
    1.029701e-01, 1.029906e-01, 1.030111e-01, 1.030316e-01, 1.030521e-01, 1.030726e-01,
    1.030931e-01, 1.031136e-01, 1.031341e-01, 1.031546e-01, 1.031751e-01, 1.031956e-01,
    1.032161e-01, 1.032366e-01, 1.032571e-01, 1.032776e-01, 1.032981e-01, 1.033185e-01,
    1.033390e-01, 1.033595e-01, 1.033800e-01, 1.034005e-01, 1.034210e-01, 1.034415e-01,
    1.034620e-01, 1.034825e-01, 1.035030e-01, 1.035234e-01, 1.035440e-01, 1.035644e-01,
    1.035849e-01, 1.036054e-01, 1.036259e-01, 1.036464e-01, 1.036669e-01, 1.036874e-01,
    1.037078e-01, 1.037283e-01, 1.037488e-01, 1.037693e-01, 1.037898e-01, 1.038103e-01,
    1.038308e-01, 1.038513e-01, 1.038717e-01, 1.038922e-01, 1.039127e-01, 1.039332e-01,
    1.039537e-01, 1.039742e-01, 1.039946e-01, 1.040151e-01, 1.040356e-01, 1.040561e-01,
    1.040766e-01, 1.040970e-01, 1.041175e-01, 1.041380e-01, 1.041585e-01, 1.041790e-01,
    1.041995e-01, 1.042199e-01, 1.042404e-01, 1.042609e-01, 1.042814e-01, 1.043018e-01,
    1.043223e-01, 1.043428e-01, 1.043633e-01, 1.043838e-01, 1.044042e-01, 1.044247e-01,
    1.044452e-01, 1.044657e-01, 1.044861e-01, 1.045066e-01, 1.045271e-01, 1.045476e-01,
    1.045680e-01, 1.045885e-01, 1.046090e-01, 1.046295e-01, 1.046499e-01, 1.046704e-01,
    1.046909e-01, 1.047114e-01, 1.047318e-01, 1.047523e-01, 1.047728e-01, 1.047932e-01,
    1.048137e-01, 1.048342e-01, 1.048547e-01, 1.048751e-01, 1.048956e-01, 1.049161e-01,
    1.049365e-01, 1.049570e-01, 1.049775e-01, 1.049979e-01, 1.050184e-01, 1.050389e-01,
    1.050594e-01, 1.050798e-01, 1.051003e-01, 1.051207e-01, 1.051412e-01, 1.051617e-01,
    1.051821e-01, 1.052026e-01, 1.052231e-01, 1.052435e-01, 1.052640e-01, 1.052845e-01,
    1.053049e-01, 1.053254e-01, 1.053459e-01, 1.053663e-01, 1.053868e-01, 1.054073e-01,
    1.054277e-01, 1.054482e-01, 1.054686e-01, 1.054891e-01, 1.055096e-01, 1.055300e-01,
    1.055505e-01, 1.055709e-01, 1.055914e-01, 1.056119e-01, 1.056323e-01, 1.056528e-01,
    1.056732e-01, 1.056937e-01, 1.057142e-01, 1.057346e-01, 1.057551e-01, 1.057755e-01,
    1.057960e-01, 1.058165e-01, 1.058369e-01, 1.058574e-01, 1.058778e-01, 1.058983e-01,
    1.059187e-01, 1.059392e-01, 1.059597e-01, 1.059801e-01, 1.060006e-01, 1.060210e-01,
    1.060415e-01, 1.060619e-01, 1.060824e-01, 1.061028e-01, 1.061233e-01, 1.061437e-01,
    1.061642e-01, 1.061846e-01, 1.062051e-01, 1.062255e-01, 1.062460e-01, 1.062664e-01,
    1.062869e-01, 1.063073e-01, 1.063278e-01, 1.063482e-01, 1.063687e-01, 1.063891e-01,
    1.064096e-01, 1.064300e-01, 1.064505e-01, 1.064709e-01, 1.064914e-01, 1.065118e-01,
    1.065323e-01, 1.065527e-01, 1.065732e-01, 1.065936e-01, 1.066141e-01, 1.066345e-01,
    1.066549e-01, 1.066754e-01, 1.066958e-01, 1.067163e-01, 1.067367e-01, 1.067572e-01,
    1.067776e-01, 1.067981e-01, 1.068185e-01, 1.068389e-01, 1.068594e-01, 1.068798e-01,
    1.069003e-01, 1.069207e-01, 1.069411e-01, 1.069616e-01, 1.069820e-01, 1.070025e-01,
    1.070229e-01, 1.070433e-01, 1.070638e-01, 1.070842e-01, 1.071047e-01, 1.071251e-01,
    1.071455e-01, 1.071660e-01, 1.071864e-01, 1.072069e-01, 1.072273e-01, 1.072477e-01,
    1.072682e-01, 1.072886e-01, 1.073090e-01, 1.073295e-01, 1.073499e-01, 1.073703e-01,
    1.073908e-01, 1.074112e-01, 1.074317e-01, 1.074521e-01, 1.074725e-01, 1.074930e-01,
    1.075134e-01, 1.075338e-01, 1.075542e-01, 1.075747e-01, 1.075951e-01, 1.076155e-01,
    1.076360e-01, 1.076564e-01, 1.076768e-01, 1.076973e-01, 1.077177e-01, 1.077381e-01,
    1.077586e-01, 1.077790e-01, 1.077994e-01, 1.078198e-01, 1.078403e-01, 1.078607e-01,
    1.078811e-01, 1.079016e-01, 1.079220e-01, 1.079424e-01, 1.079628e-01, 1.079833e-01,
    1.080037e-01, 1.080241e-01, 1.080445e-01, 1.080650e-01, 1.080854e-01, 1.081058e-01,
    1.081262e-01, 1.081467e-01, 1.081671e-01, 1.081875e-01, 1.082079e-01, 1.082284e-01,
    1.082488e-01, 1.082692e-01, 1.082896e-01, 1.083100e-01, 1.083305e-01, 1.083509e-01,
    1.083713e-01, 1.083917e-01, 1.084122e-01, 1.084326e-01, 1.084530e-01, 1.084734e-01,
    1.084938e-01, 1.085142e-01, 1.085347e-01, 1.085551e-01, 1.085755e-01, 1.085959e-01,
    1.086163e-01, 1.086368e-01, 1.086572e-01, 1.086776e-01, 1.086980e-01, 1.087184e-01,
    1.087388e-01, 1.087592e-01, 1.087797e-01, 1.088001e-01, 1.088205e-01, 1.088409e-01,
    1.088613e-01, 1.088817e-01, 1.089022e-01, 1.089226e-01, 1.089430e-01, 1.089634e-01,
    1.089838e-01, 1.090042e-01, 1.090246e-01, 1.090450e-01, 1.090654e-01, 1.090859e-01,
    1.091063e-01, 1.091267e-01, 1.091471e-01, 1.091675e-01, 1.091879e-01, 1.092083e-01,
    1.092287e-01, 1.092491e-01, 1.092695e-01, 1.092900e-01, 1.093104e-01, 1.093308e-01,
    1.093512e-01, 1.093716e-01, 1.093920e-01, 1.094124e-01, 1.094328e-01, 1.094532e-01,
    1.094736e-01, 1.094940e-01, 1.095144e-01, 1.095348e-01, 1.095552e-01, 1.095756e-01,
    1.095960e-01, 1.096164e-01, 1.096368e-01, 1.096572e-01, 1.096777e-01, 1.096980e-01,
    1.097184e-01, 1.097388e-01, 1.097592e-01, 1.097797e-01, 1.098001e-01, 1.098205e-01,
    1.098409e-01, 1.098612e-01, 1.098816e-01, 1.099021e-01, 1.099225e-01, 1.099429e-01,
    1.099632e-01, 1.099836e-01, 1.100040e-01, 1.100244e-01, 1.100448e-01, 1.100652e-01,
    1.100856e-01, 1.101060e-01, 1.101264e-01, 1.101468e-01, 1.101672e-01, 1.101876e-01,
    1.102080e-01, 1.102284e-01, 1.102488e-01, 1.102692e-01, 1.102896e-01, 1.103100e-01,
    1.103304e-01, 1.103508e-01, 1.103712e-01, 1.103915e-01, 1.104119e-01, 1.104323e-01,
    1.104527e-01, 1.104731e-01, 1.104935e-01, 1.105139e-01, 1.105343e-01, 1.105547e-01,
    1.105751e-01, 1.105954e-01, 1.106158e-01, 1.106362e-01, 1.106566e-01, 1.106770e-01,
    1.106974e-01, 1.107178e-01, 1.107382e-01, 1.107586e-01, 1.107790e-01, 1.107993e-01,
    1.108197e-01, 1.108401e-01, 1.108605e-01, 1.108809e-01, 1.109013e-01, 1.109217e-01,
    1.109420e-01, 1.109624e-01, 1.109828e-01, 1.110032e-01, 1.110236e-01, 1.110440e-01,
    1.110643e-01, 1.110847e-01, 1.111051e-01, 1.111255e-01, 1.111459e-01, 1.111662e-01,
    1.111866e-01, 1.112070e-01, 1.112274e-01, 1.112478e-01, 1.112681e-01, 1.112885e-01,
    1.113089e-01, 1.113293e-01, 1.113497e-01, 1.113700e-01, 1.113904e-01, 1.114108e-01,
    1.114312e-01, 1.114516e-01, 1.114719e-01, 1.114923e-01, 1.115127e-01, 1.115331e-01,
    1.115534e-01, 1.115738e-01, 1.115942e-01, 1.116146e-01, 1.116349e-01, 1.116553e-01,
    1.116757e-01, 1.116961e-01, 1.117164e-01, 1.117368e-01, 1.117572e-01, 1.117775e-01,
    1.117979e-01, 1.118183e-01, 1.118387e-01, 1.118590e-01, 1.118794e-01, 1.118998e-01,
    1.119201e-01, 1.119405e-01, 1.119609e-01, 1.119813e-01, 1.120016e-01, 1.120220e-01,
    1.120424e-01, 1.120627e-01, 1.120831e-01, 1.121035e-01, 1.121238e-01, 1.121442e-01,
    1.121646e-01, 1.121849e-01, 1.122053e-01, 1.122257e-01, 1.122460e-01, 1.122664e-01,
    1.122868e-01, 1.123071e-01, 1.123275e-01, 1.123479e-01, 1.123682e-01, 1.123886e-01,
    1.124090e-01, 1.124293e-01, 1.124497e-01, 1.124701e-01, 1.124904e-01, 1.125108e-01,
    1.125311e-01, 1.125515e-01, 1.125719e-01, 1.125922e-01, 1.126126e-01, 1.126329e-01,
    1.126533e-01, 1.126737e-01, 1.126940e-01, 1.127144e-01, 1.127347e-01, 1.127551e-01,
    1.127755e-01, 1.127958e-01, 1.128162e-01, 1.128365e-01, 1.128569e-01, 1.128773e-01,
    1.128976e-01, 1.129180e-01, 1.129383e-01, 1.129587e-01, 1.129790e-01, 1.129994e-01,
    1.130197e-01, 1.130401e-01, 1.130605e-01, 1.130808e-01, 1.131012e-01, 1.131215e-01,
    1.131419e-01, 1.131622e-01, 1.131826e-01, 1.132029e-01, 1.132233e-01, 1.132436e-01,
    1.132640e-01, 1.132843e-01, 1.133047e-01, 1.133250e-01, 1.133454e-01, 1.133657e-01,
    1.133861e-01, 1.134064e-01, 1.134268e-01, 1.134471e-01, 1.134675e-01, 1.134878e-01,
    1.135082e-01, 1.135285e-01, 1.135489e-01, 1.135692e-01, 1.135896e-01, 1.136099e-01,
    1.136303e-01, 1.136506e-01, 1.136710e-01, 1.136913e-01, 1.137116e-01, 1.137320e-01,
    1.137523e-01, 1.137727e-01, 1.137930e-01, 1.138134e-01, 1.138337e-01, 1.138541e-01,
    1.138744e-01, 1.138947e-01, 1.139151e-01, 1.139354e-01, 1.139558e-01, 1.139761e-01,
    1.139965e-01, 1.140168e-01, 1.140371e-01, 1.140575e-01, 1.140778e-01, 1.140982e-01,
    1.141185e-01, 1.141388e-01, 1.141592e-01, 1.141795e-01, 1.141999e-01, 1.142202e-01,
    1.142405e-01, 1.142609e-01, 1.142812e-01, 1.143015e-01, 1.143219e-01, 1.143422e-01,
    1.143626e-01, 1.143829e-01, 1.144032e-01, 1.144236e-01, 1.144439e-01, 1.144642e-01,
    1.144846e-01, 1.145049e-01, 1.145252e-01, 1.145456e-01, 1.145659e-01, 1.145862e-01,
    1.146066e-01, 1.146269e-01, 1.146472e-01, 1.146676e-01, 1.146879e-01, 1.147082e-01,
    1.147285e-01, 1.147489e-01, 1.147692e-01, 1.147896e-01, 1.148099e-01, 1.148302e-01,
    1.148505e-01, 1.148709e-01, 1.148912e-01, 1.149115e-01, 1.149318e-01, 1.149522e-01,
    1.149725e-01, 1.149928e-01, 1.150132e-01, 1.150335e-01, 1.150538e-01, 1.150741e-01,
    1.150945e-01, 1.151148e-01, 1.151351e-01, 1.151554e-01, 1.151758e-01, 1.151961e-01,
    1.152164e-01, 1.152367e-01, 1.152571e-01, 1.152774e-01, 1.152977e-01, 1.153180e-01,
    1.153384e-01, 1.153587e-01, 1.153790e-01, 1.153993e-01, 1.154196e-01, 1.154400e-01,
    1.154603e-01, 1.154806e-01, 1.155009e-01, 1.155212e-01, 1.155416e-01, 1.155619e-01,
    1.155822e-01, 1.156025e-01, 1.156228e-01, 1.156432e-01, 1.156635e-01, 1.156838e-01,
    1.157041e-01, 1.157244e-01, 1.157447e-01, 1.157651e-01, 1.157854e-01, 1.158057e-01,
    1.158260e-01, 1.158463e-01, 1.158666e-01, 1.158869e-01, 1.159073e-01, 1.159276e-01,
    1.159479e-01, 1.159682e-01, 1.159885e-01, 1.160088e-01, 1.160292e-01, 1.160495e-01,
    1.160698e-01, 1.160901e-01, 1.161104e-01, 1.161307e-01, 1.161510e-01, 1.161713e-01,
    1.161916e-01, 1.162120e-01, 1.162323e-01, 1.162526e-01, 1.162729e-01, 1.162932e-01,
    1.163135e-01, 1.163338e-01, 1.163541e-01, 1.163744e-01, 1.163947e-01, 1.164150e-01,
    1.164353e-01, 1.164557e-01, 1.164760e-01, 1.164963e-01, 1.165166e-01, 1.165369e-01,
    1.165572e-01, 1.165775e-01, 1.165978e-01, 1.166181e-01, 1.166384e-01, 1.166587e-01,
    1.166790e-01, 1.166993e-01, 1.167196e-01, 1.167399e-01, 1.167602e-01, 1.167805e-01,
    1.168008e-01, 1.168211e-01, 1.168414e-01, 1.168617e-01, 1.168820e-01, 1.169023e-01,
    1.169226e-01, 1.169429e-01, 1.169632e-01, 1.169835e-01, 1.170038e-01, 1.170241e-01,
    1.170444e-01, 1.170647e-01, 1.170850e-01, 1.171053e-01, 1.171256e-01, 1.171459e-01,
    1.171662e-01, 1.171865e-01, 1.172068e-01, 1.172271e-01, 1.172474e-01, 1.172677e-01,
    1.172880e-01, 1.173083e-01, 1.173286e-01, 1.173489e-01, 1.173692e-01, 1.173895e-01,
    1.174098e-01, 1.174300e-01, 1.174503e-01, 1.174706e-01, 1.174909e-01, 1.175112e-01,
    1.175315e-01, 1.175518e-01, 1.175721e-01, 1.175924e-01, 1.176127e-01, 1.176329e-01,
    1.176532e-01, 1.176735e-01, 1.176938e-01, 1.177141e-01, 1.177344e-01, 1.177547e-01,
    1.177750e-01, 1.177953e-01, 1.178156e-01, 1.178358e-01, 1.178561e-01, 1.178764e-01,
    1.178967e-01, 1.179170e-01, 1.179373e-01, 1.179576e-01, 1.179778e-01, 1.179981e-01,
    1.180184e-01, 1.180387e-01, 1.180590e-01, 1.180793e-01, 1.180995e-01, 1.181198e-01,
    1.181401e-01, 1.181604e-01, 1.181807e-01, 1.182010e-01, 1.182213e-01, 1.182415e-01,
    1.182618e-01, 1.182821e-01, 1.183024e-01, 1.183227e-01, 1.183429e-01, 1.183632e-01,
    1.183835e-01, 1.184038e-01, 1.184241e-01, 1.184443e-01, 1.184646e-01, 1.184849e-01,
    1.185052e-01, 1.185254e-01, 1.185457e-01, 1.185660e-01, 1.185863e-01, 1.186066e-01,
    1.186268e-01, 1.186471e-01, 1.186674e-01, 1.186877e-01, 1.187079e-01, 1.187282e-01,
    1.187485e-01, 1.187688e-01, 1.187890e-01, 1.188093e-01, 1.188296e-01, 1.188498e-01,
    1.188701e-01, 1.188904e-01, 1.189107e-01, 1.189309e-01, 1.189512e-01, 1.189715e-01,
    1.189918e-01, 1.190120e-01, 1.190323e-01, 1.190526e-01, 1.190728e-01, 1.190931e-01,
    1.191134e-01, 1.191336e-01, 1.191539e-01, 1.191742e-01, 1.191944e-01, 1.192147e-01,
    1.192350e-01, 1.192553e-01, 1.192755e-01, 1.192958e-01, 1.193160e-01, 1.193363e-01,
    1.193566e-01, 1.193768e-01, 1.193971e-01, 1.194174e-01, 1.194376e-01, 1.194579e-01,
    1.194782e-01, 1.194984e-01, 1.195187e-01, 1.195390e-01, 1.195592e-01, 1.195795e-01,
    1.195998e-01, 1.196200e-01, 1.196403e-01, 1.196605e-01, 1.196808e-01, 1.197011e-01,
    1.197213e-01, 1.197416e-01, 1.197618e-01, 1.197821e-01, 1.198024e-01, 1.198226e-01,
    1.198429e-01, 1.198631e-01, 1.198834e-01, 1.199037e-01, 1.199239e-01, 1.199442e-01,
    1.199644e-01, 1.199847e-01, 1.200049e-01, 1.200252e-01, 1.200455e-01, 1.200657e-01,
    1.200860e-01, 1.201062e-01, 1.201265e-01, 1.201467e-01, 1.201670e-01, 1.201872e-01,
    1.202075e-01, 1.202277e-01, 1.202480e-01, 1.202683e-01, 1.202885e-01, 1.203088e-01,
    1.203290e-01, 1.203493e-01, 1.203695e-01, 1.203898e-01, 1.204100e-01, 1.204303e-01,
    1.204505e-01, 1.204708e-01, 1.204910e-01, 1.205113e-01, 1.205315e-01, 1.205518e-01,
    1.205720e-01, 1.205923e-01, 1.206125e-01, 1.206328e-01, 1.206530e-01, 1.206733e-01,
    1.206935e-01, 1.207137e-01, 1.207340e-01, 1.207542e-01, 1.207745e-01, 1.207947e-01,
    1.208150e-01, 1.208352e-01, 1.208555e-01, 1.208757e-01, 1.208960e-01, 1.209162e-01,
    1.209364e-01, 1.209567e-01, 1.209769e-01, 1.209972e-01, 1.210174e-01, 1.210377e-01,
    1.210579e-01, 1.210781e-01, 1.210984e-01, 1.211186e-01, 1.211389e-01, 1.211591e-01,
    1.211793e-01, 1.211996e-01, 1.212198e-01, 1.212401e-01, 1.212603e-01, 1.212806e-01,
    1.213008e-01, 1.213210e-01, 1.213413e-01, 1.213615e-01, 1.213817e-01, 1.214020e-01,
    1.214222e-01, 1.214425e-01, 1.214627e-01, 1.214829e-01, 1.215032e-01, 1.215234e-01,
    1.215436e-01, 1.215639e-01, 1.215841e-01, 1.216043e-01, 1.216246e-01, 1.216448e-01,
    1.216650e-01, 1.216853e-01, 1.217055e-01, 1.217257e-01, 1.217460e-01, 1.217662e-01,
    1.217864e-01, 1.218067e-01, 1.218269e-01, 1.218471e-01, 1.218674e-01, 1.218876e-01,
    1.219078e-01, 1.219280e-01, 1.219483e-01, 1.219685e-01, 1.219887e-01, 1.220090e-01,
    1.220292e-01, 1.220494e-01, 1.220696e-01, 1.220899e-01, 1.221101e-01, 1.221303e-01,
    1.221506e-01, 1.221708e-01, 1.221910e-01, 1.222112e-01, 1.222315e-01, 1.222517e-01,
    1.222719e-01, 1.222921e-01, 1.223124e-01, 1.223326e-01, 1.223528e-01, 1.223730e-01,
    1.223933e-01, 1.224135e-01, 1.224337e-01, 1.224539e-01, 1.224742e-01, 1.224944e-01,
    1.225146e-01, 1.225348e-01, 1.225550e-01, 1.225753e-01, 1.225955e-01, 1.226157e-01,
    1.226359e-01, 1.226561e-01, 1.226764e-01, 1.226966e-01, 1.227168e-01, 1.227370e-01,
    1.227572e-01, 1.227774e-01, 1.227977e-01, 1.228179e-01, 1.228381e-01, 1.228583e-01,
    1.228785e-01, 1.228988e-01, 1.229190e-01, 1.229392e-01, 1.229594e-01, 1.229796e-01,
    1.229998e-01, 1.230201e-01, 1.230403e-01, 1.230605e-01, 1.230807e-01, 1.231009e-01,
    1.231211e-01, 1.231413e-01, 1.231615e-01, 1.231817e-01, 1.232020e-01, 1.232222e-01,
    1.232424e-01, 1.232626e-01, 1.232828e-01, 1.233030e-01, 1.233232e-01, 1.233434e-01,
    1.233637e-01, 1.233839e-01, 1.234041e-01, 1.234243e-01, 1.234445e-01, 1.234647e-01,
    1.234849e-01, 1.235051e-01, 1.235253e-01, 1.235455e-01, 1.235657e-01, 1.235859e-01,
    1.236061e-01, 1.236264e-01, 1.236466e-01, 1.236668e-01, 1.236870e-01, 1.237072e-01,
    1.237274e-01, 1.237476e-01, 1.237678e-01, 1.237880e-01, 1.238082e-01, 1.238284e-01,
    1.238486e-01, 1.238688e-01, 1.238890e-01, 1.239092e-01, 1.239294e-01, 1.239496e-01,
    1.239698e-01, 1.239900e-01, 1.240102e-01, 1.240304e-01, 1.240506e-01, 1.240708e-01,
    1.240910e-01, 1.241112e-01, 1.241314e-01, 1.241516e-01, 1.241718e-01, 1.241920e-01,
    1.242122e-01, 1.242324e-01, 1.242526e-01, 1.242728e-01, 1.242930e-01, 1.243132e-01,
    1.243334e-01, 1.243536e-01, 1.243738e-01, 1.243940e-01, 1.244142e-01, 1.244344e-01,
    1.244546e-01, 1.244748e-01, 1.244949e-01, 1.245151e-01, 1.245353e-01, 1.245555e-01,
    1.245757e-01, 1.245959e-01, 1.246161e-01, 1.246363e-01, 1.246565e-01, 1.246767e-01,
    1.246969e-01, 1.247171e-01, 1.247373e-01, 1.247574e-01, 1.247776e-01, 1.247978e-01,
    1.248180e-01, 1.248382e-01, 1.248584e-01, 1.248786e-01, 1.248988e-01, 1.249190e-01,
    1.249391e-01, 1.249593e-01, 1.249795e-01, 1.249997e-01, 1.250199e-01, 1.250401e-01,
    1.250603e-01, 1.250805e-01, 1.251006e-01, 1.251208e-01, 1.251410e-01, 1.251612e-01,
    1.251814e-01, 1.252016e-01, 1.252217e-01, 1.252419e-01, 1.252621e-01, 1.252823e-01,
    1.253025e-01, 1.253227e-01, 1.253428e-01, 1.253630e-01, 1.253832e-01, 1.254034e-01,
    1.254236e-01, 1.254437e-01, 1.254639e-01, 1.254841e-01, 1.255043e-01, 1.255245e-01,
    1.255446e-01, 1.255648e-01, 1.255850e-01, 1.256052e-01, 1.256254e-01, 1.256455e-01,
    1.256657e-01, 1.256859e-01, 1.257061e-01, 1.257262e-01, 1.257464e-01, 1.257666e-01,
    1.257868e-01, 1.258069e-01, 1.258271e-01, 1.258473e-01, 1.258675e-01, 1.258876e-01,
    1.259078e-01, 1.259280e-01, 1.259482e-01, 1.259683e-01, 1.259885e-01, 1.260087e-01,
    1.260289e-01, 1.260490e-01, 1.260692e-01, 1.260894e-01, 1.261095e-01, 1.261297e-01,
    1.261499e-01, 1.261701e-01, 1.261902e-01, 1.262104e-01, 1.262306e-01, 1.262507e-01,
    1.262709e-01, 1.262911e-01, 1.263112e-01, 1.263314e-01, 1.263516e-01, 1.263717e-01,
    1.263919e-01, 1.264121e-01, 1.264323e-01, 1.264524e-01, 1.264726e-01, 1.264927e-01,
    1.265129e-01, 1.265331e-01, 1.265532e-01, 1.265734e-01, 1.265936e-01, 1.266137e-01,
    1.266339e-01, 1.266541e-01, 1.266742e-01, 1.266944e-01, 1.267145e-01, 1.267347e-01,
    1.267549e-01, 1.267750e-01, 1.267952e-01, 1.268154e-01, 1.268355e-01, 1.268557e-01,
    1.268758e-01, 1.268960e-01, 1.269162e-01, 1.269363e-01, 1.269565e-01, 1.269767e-01,
    1.269968e-01, 1.270170e-01, 1.270371e-01, 1.270573e-01, 1.270774e-01, 1.270976e-01,
    1.271178e-01, 1.271379e-01, 1.271581e-01, 1.271782e-01, 1.271984e-01, 1.272185e-01,
    1.272387e-01, 1.272588e-01, 1.272790e-01, 1.272991e-01, 1.273193e-01, 1.273395e-01,
    1.273596e-01, 1.273798e-01, 1.273999e-01, 1.274201e-01, 1.274402e-01, 1.274604e-01,
    1.274805e-01, 1.275007e-01, 1.275208e-01, 1.275410e-01, 1.275611e-01, 1.275813e-01,
    1.276014e-01, 1.276216e-01, 1.276417e-01, 1.276619e-01, 1.276820e-01, 1.277022e-01,
    1.277223e-01, 1.277425e-01, 1.277626e-01, 1.277828e-01, 1.278029e-01, 1.278231e-01,
    1.278432e-01, 1.278634e-01, 1.278835e-01, 1.279037e-01, 1.279238e-01, 1.279440e-01,
    1.279641e-01, 1.279842e-01, 1.280044e-01, 1.280245e-01, 1.280447e-01, 1.280648e-01,
    1.280850e-01, 1.281051e-01, 1.281253e-01, 1.281454e-01, 1.281655e-01, 1.281857e-01,
    1.282058e-01, 1.282260e-01, 1.282461e-01, 1.282662e-01, 1.282864e-01, 1.283065e-01,
    1.283267e-01, 1.283468e-01, 1.283669e-01, 1.283871e-01, 1.284072e-01, 1.284274e-01,
    1.284475e-01, 1.284676e-01, 1.284878e-01, 1.285079e-01, 1.285281e-01, 1.285482e-01,
    1.285683e-01, 1.285885e-01, 1.286086e-01, 1.286287e-01, 1.286489e-01, 1.286690e-01,
    1.286891e-01, 1.287093e-01, 1.287294e-01, 1.287495e-01, 1.287697e-01, 1.287898e-01,
    1.288100e-01, 1.288301e-01, 1.288502e-01, 1.288704e-01, 1.288905e-01, 1.289106e-01,
    1.289307e-01, 1.289509e-01, 1.289710e-01, 1.289911e-01, 1.290113e-01, 1.290314e-01,
    1.290515e-01, 1.290717e-01, 1.290918e-01, 1.291119e-01, 1.291321e-01, 1.291522e-01,
    1.291723e-01, 1.291924e-01, 1.292126e-01, 1.292327e-01, 1.292528e-01, 1.292730e-01,
    1.292931e-01, 1.293132e-01, 1.293333e-01, 1.293535e-01, 1.293736e-01, 1.293937e-01,
    1.294138e-01, 1.294340e-01, 1.294541e-01, 1.294742e-01, 1.294943e-01, 1.295145e-01,
    1.295346e-01, 1.295547e-01, 1.295748e-01, 1.295950e-01, 1.296151e-01, 1.296352e-01,
    1.296553e-01, 1.296754e-01, 1.296955e-01, 1.297157e-01, 1.297358e-01, 1.297559e-01,
    1.297760e-01, 1.297962e-01, 1.298163e-01, 1.298364e-01, 1.298565e-01, 1.298766e-01,
    1.298968e-01, 1.299169e-01, 1.299370e-01, 1.299571e-01, 1.299772e-01, 1.299973e-01,
    1.300175e-01, 1.300376e-01, 1.300577e-01, 1.300778e-01, 1.300979e-01, 1.301180e-01,
    1.301382e-01, 1.301583e-01, 1.301784e-01, 1.301985e-01, 1.302186e-01, 1.302387e-01,
    1.302588e-01, 1.302790e-01, 1.302991e-01, 1.303192e-01, 1.303393e-01, 1.303594e-01,
    1.303795e-01, 1.303996e-01, 1.304197e-01, 1.304398e-01, 1.304599e-01, 1.304801e-01,
    1.305002e-01, 1.305203e-01, 1.305404e-01, 1.305605e-01, 1.305806e-01, 1.306007e-01,
    1.306208e-01, 1.306409e-01, 1.306610e-01, 1.306812e-01, 1.307013e-01, 1.307214e-01,
    1.307415e-01, 1.307616e-01, 1.307817e-01, 1.308018e-01, 1.308219e-01, 1.308420e-01,
    1.308621e-01, 1.308822e-01, 1.309023e-01, 1.309224e-01, 1.309425e-01, 1.309626e-01,
    1.309827e-01, 1.310028e-01, 1.310229e-01, 1.310430e-01, 1.310631e-01, 1.310833e-01,
    1.311034e-01, 1.311235e-01, 1.311436e-01, 1.311637e-01, 1.311838e-01, 1.312039e-01,
    1.312240e-01, 1.312440e-01, 1.312642e-01, 1.312843e-01, 1.313044e-01, 1.313244e-01,
    1.313445e-01, 1.313646e-01, 1.313847e-01, 1.314048e-01, 1.314249e-01, 1.314450e-01,
    1.314651e-01, 1.314852e-01, 1.315053e-01, 1.315254e-01, 1.315455e-01, 1.315656e-01,
    1.315857e-01, 1.316058e-01, 1.316259e-01, 1.316460e-01, 1.316661e-01, 1.316862e-01,
    1.317063e-01, 1.317264e-01, 1.317465e-01, 1.317665e-01, 1.317866e-01, 1.318067e-01,
    1.318268e-01, 1.318469e-01, 1.318670e-01, 1.318871e-01, 1.319072e-01, 1.319273e-01,
    1.319474e-01, 1.319675e-01, 1.319875e-01, 1.320076e-01, 1.320277e-01, 1.320478e-01,
    1.320679e-01, 1.320880e-01, 1.321081e-01, 1.321282e-01, 1.321483e-01, 1.321683e-01,
    1.321884e-01, 1.322085e-01, 1.322286e-01, 1.322487e-01, 1.322688e-01, 1.322888e-01,
    1.323089e-01, 1.323290e-01, 1.323491e-01, 1.323692e-01, 1.323893e-01, 1.324094e-01,
    1.324294e-01, 1.324495e-01, 1.324696e-01, 1.324897e-01, 1.325098e-01, 1.325299e-01,
    1.325499e-01, 1.325700e-01, 1.325901e-01, 1.326102e-01, 1.326303e-01, 1.326503e-01,
    1.326704e-01, 1.326905e-01, 1.327106e-01, 1.327306e-01, 1.327507e-01, 1.327708e-01,
    1.327909e-01, 1.328110e-01, 1.328311e-01, 1.328511e-01, 1.328712e-01, 1.328913e-01,
    1.329114e-01, 1.329314e-01, 1.329515e-01, 1.329716e-01, 1.329917e-01, 1.330117e-01,
    1.330318e-01, 1.330519e-01, 1.330720e-01, 1.330920e-01, 1.331121e-01, 1.331322e-01,
    1.331522e-01, 1.331723e-01, 1.331924e-01, 1.332125e-01, 1.332325e-01, 1.332526e-01,
    1.332727e-01, 1.332927e-01, 1.333128e-01, 1.333329e-01, 1.333530e-01, 1.333730e-01,
    1.333931e-01, 1.334132e-01, 1.334332e-01, 1.334533e-01, 1.334734e-01, 1.334935e-01,
    1.335135e-01, 1.335336e-01, 1.335537e-01, 1.335737e-01, 1.335938e-01, 1.336139e-01,
    1.336339e-01, 1.336540e-01, 1.336741e-01, 1.336941e-01, 1.337142e-01, 1.337342e-01,
    1.337543e-01, 1.337744e-01, 1.337944e-01, 1.338145e-01, 1.338346e-01, 1.338546e-01,
    1.338747e-01, 1.338948e-01, 1.339148e-01, 1.339349e-01, 1.339549e-01, 1.339750e-01,
    1.339951e-01, 1.340151e-01, 1.340352e-01, 1.340553e-01, 1.340753e-01, 1.340954e-01,
    1.341154e-01, 1.341355e-01, 1.341556e-01, 1.341756e-01, 1.341957e-01, 1.342157e-01,
    1.342358e-01, 1.342558e-01, 1.342759e-01, 1.342960e-01, 1.343160e-01, 1.343361e-01,
    1.343561e-01, 1.343762e-01, 1.343962e-01, 1.344163e-01, 1.344363e-01, 1.344564e-01,
    1.344765e-01, 1.344965e-01, 1.345166e-01, 1.345366e-01, 1.345567e-01, 1.345767e-01,
    1.345968e-01, 1.346168e-01, 1.346369e-01, 1.346569e-01, 1.346770e-01, 1.346970e-01,
    1.347171e-01, 1.347371e-01, 1.347572e-01, 1.347772e-01, 1.347973e-01, 1.348173e-01,
    1.348374e-01, 1.348574e-01, 1.348775e-01, 1.348975e-01, 1.349176e-01, 1.349376e-01,
    1.349577e-01, 1.349777e-01, 1.349978e-01, 1.350178e-01, 1.350379e-01, 1.350579e-01,
    1.350780e-01, 1.350980e-01, 1.351181e-01, 1.351381e-01, 1.351582e-01, 1.351782e-01,
    1.351982e-01, 1.352183e-01, 1.352383e-01, 1.352584e-01, 1.352784e-01, 1.352985e-01,
    1.353185e-01, 1.353385e-01, 1.353586e-01, 1.353786e-01, 1.353987e-01, 1.354187e-01,
    1.354388e-01, 1.354588e-01, 1.354788e-01, 1.354989e-01, 1.355189e-01, 1.355390e-01,
    1.355590e-01, 1.355790e-01, 1.355991e-01, 1.356191e-01, 1.356391e-01, 1.356592e-01,
    1.356792e-01, 1.356993e-01, 1.357193e-01, 1.357393e-01, 1.357594e-01, 1.357794e-01,
    1.357995e-01, 1.358195e-01, 1.358395e-01, 1.358595e-01, 1.358796e-01, 1.358996e-01,
    1.359197e-01, 1.359397e-01, 1.359597e-01, 1.359798e-01, 1.359998e-01, 1.360198e-01,
    1.360399e-01, 1.360599e-01, 1.360799e-01, 1.361000e-01, 1.361200e-01, 1.361400e-01,
    1.361601e-01, 1.361801e-01, 1.362001e-01, 1.362201e-01, 1.362402e-01, 1.362602e-01,
    1.362802e-01, 1.363003e-01, 1.363203e-01, 1.363403e-01, 1.363604e-01, 1.363804e-01,
    1.364004e-01, 1.364204e-01, 1.364405e-01, 1.364605e-01, 1.364805e-01, 1.365005e-01,
    1.365206e-01, 1.365406e-01, 1.365606e-01, 1.365807e-01, 1.366007e-01, 1.366207e-01,
    1.366407e-01, 1.366607e-01, 1.366808e-01, 1.367008e-01, 1.367208e-01, 1.367408e-01,
    1.367609e-01, 1.367809e-01, 1.368009e-01, 1.368209e-01, 1.368410e-01, 1.368610e-01,
    1.368810e-01, 1.369010e-01, 1.369210e-01, 1.369411e-01, 1.369611e-01, 1.369811e-01,
    1.370011e-01, 1.370211e-01, 1.370412e-01, 1.370612e-01, 1.370812e-01, 1.371012e-01,
    1.371212e-01, 1.371413e-01, 1.371613e-01, 1.371813e-01, 1.372013e-01, 1.372213e-01,
    1.372413e-01, 1.372613e-01, 1.372814e-01, 1.373014e-01, 1.373214e-01, 1.373414e-01,
    1.373614e-01, 1.373814e-01, 1.374014e-01, 1.374215e-01, 1.374415e-01, 1.374615e-01,
    1.374815e-01, 1.375015e-01, 1.375215e-01, 1.375415e-01, 1.375616e-01, 1.375816e-01,
    1.376016e-01, 1.376216e-01, 1.376416e-01, 1.376616e-01, 1.376816e-01, 1.377016e-01,
    1.377216e-01, 1.377417e-01, 1.377617e-01, 1.377817e-01, 1.378017e-01, 1.378217e-01,
    1.378417e-01, 1.378617e-01, 1.378817e-01, 1.379017e-01, 1.379217e-01, 1.379417e-01,
    1.379617e-01, 1.379817e-01, 1.380018e-01, 1.380218e-01, 1.380417e-01, 1.380618e-01,
    1.380818e-01, 1.381018e-01, 1.381218e-01, 1.381418e-01, 1.381618e-01, 1.381818e-01,
    1.382018e-01, 1.382218e-01, 1.382418e-01, 1.382618e-01, 1.382818e-01, 1.383018e-01,
    1.383218e-01, 1.383418e-01, 1.383618e-01, 1.383818e-01, 1.384018e-01, 1.384218e-01,
    1.384418e-01, 1.384618e-01, 1.384818e-01, 1.385018e-01, 1.385218e-01, 1.385418e-01,
    1.385618e-01, 1.385818e-01, 1.386018e-01, 1.386218e-01, 1.386418e-01, 1.386618e-01,
    1.386818e-01, 1.387018e-01, 1.387218e-01, 1.387418e-01, 1.387618e-01, 1.387818e-01,
    1.388018e-01, 1.388218e-01, 1.388417e-01, 1.388617e-01, 1.388817e-01, 1.389017e-01,
    1.389217e-01, 1.389417e-01, 1.389617e-01, 1.389817e-01, 1.390017e-01, 1.390217e-01,
    1.390417e-01, 1.390617e-01, 1.390816e-01, 1.391016e-01, 1.391216e-01, 1.391416e-01,
    1.391616e-01, 1.391816e-01, 1.392016e-01, 1.392216e-01, 1.392416e-01, 1.392616e-01,
    1.392815e-01, 1.393015e-01, 1.393215e-01, 1.393415e-01, 1.393615e-01, 1.393815e-01,
    1.394015e-01, 1.394214e-01, 1.394414e-01, 1.394614e-01, 1.394814e-01, 1.395014e-01,
    1.395214e-01, 1.395414e-01, 1.395613e-01, 1.395813e-01, 1.396013e-01, 1.396213e-01,
    1.396413e-01, 1.396613e-01, 1.396812e-01, 1.397012e-01, 1.397212e-01, 1.397412e-01,
    1.397612e-01, 1.397812e-01, 1.398011e-01, 1.398211e-01, 1.398411e-01, 1.398611e-01,
    1.398811e-01, 1.399010e-01, 1.399210e-01, 1.399410e-01, 1.399610e-01, 1.399809e-01,
    1.400009e-01, 1.400209e-01, 1.400409e-01, 1.400609e-01, 1.400808e-01, 1.401008e-01,
    1.401208e-01, 1.401408e-01, 1.401607e-01, 1.401807e-01, 1.402007e-01, 1.402207e-01,
    1.402406e-01, 1.402606e-01, 1.402806e-01, 1.403006e-01, 1.403205e-01, 1.403405e-01,
    1.403605e-01, 1.403805e-01, 1.404004e-01, 1.404204e-01, 1.404404e-01, 1.404603e-01,
    1.404803e-01, 1.405003e-01, 1.405203e-01, 1.405402e-01, 1.405602e-01, 1.405802e-01,
    1.406001e-01, 1.406201e-01, 1.406401e-01, 1.406600e-01, 1.406800e-01, 1.407000e-01,
    1.407200e-01, 1.407399e-01, 1.407599e-01, 1.407799e-01, 1.407998e-01, 1.408198e-01,
    1.408398e-01, 1.408597e-01, 1.408797e-01, 1.408997e-01, 1.409196e-01, 1.409396e-01,
    1.409595e-01, 1.409795e-01, 1.409995e-01, 1.410194e-01, 1.410394e-01, 1.410594e-01,
    1.410793e-01, 1.410993e-01, 1.411193e-01, 1.411392e-01, 1.411592e-01, 1.411791e-01,
    1.411991e-01, 1.412191e-01, 1.412390e-01, 1.412590e-01, 1.412789e-01, 1.412989e-01,
    1.413189e-01, 1.413388e-01, 1.413588e-01, 1.413787e-01, 1.413987e-01, 1.414187e-01,
    1.414386e-01, 1.414586e-01, 1.414785e-01, 1.414985e-01, 1.415184e-01, 1.415384e-01,
    1.415584e-01, 1.415783e-01, 1.415983e-01, 1.416182e-01, 1.416382e-01, 1.416581e-01,
    1.416781e-01, 1.416980e-01, 1.417180e-01, 1.417380e-01, 1.417579e-01, 1.417779e-01,
    1.417978e-01, 1.418178e-01, 1.418377e-01, 1.418577e-01, 1.418776e-01, 1.418976e-01,
    1.419175e-01, 1.419375e-01, 1.419574e-01, 1.419774e-01, 1.419973e-01, 1.420173e-01,
    1.420372e-01, 1.420572e-01, 1.420771e-01, 1.420971e-01, 1.421170e-01, 1.421370e-01,
    1.421569e-01, 1.421769e-01, 1.421968e-01, 1.422168e-01, 1.422367e-01, 1.422567e-01,
    1.422766e-01, 1.422966e-01, 1.423165e-01, 1.423365e-01, 1.423564e-01, 1.423763e-01,
    1.423963e-01, 1.424162e-01, 1.424362e-01, 1.424561e-01, 1.424761e-01, 1.424960e-01,
    1.425159e-01, 1.425359e-01, 1.425558e-01, 1.425758e-01, 1.425957e-01, 1.426157e-01,
    1.426356e-01, 1.426556e-01, 1.426755e-01, 1.426954e-01, 1.427154e-01, 1.427353e-01,
    1.427552e-01, 1.427752e-01, 1.427951e-01, 1.428151e-01, 1.428350e-01, 1.428549e-01,
    1.428749e-01, 1.428948e-01, 1.429148e-01, 1.429347e-01, 1.429546e-01, 1.429746e-01,
    1.429945e-01, 1.430144e-01, 1.430344e-01, 1.430543e-01, 1.430742e-01, 1.430942e-01,
    1.431141e-01, 1.431341e-01, 1.431540e-01, 1.431739e-01, 1.431939e-01, 1.432138e-01,
    1.432337e-01, 1.432537e-01, 1.432736e-01, 1.432935e-01, 1.433135e-01, 1.433334e-01,
    1.433533e-01, 1.433733e-01, 1.433932e-01, 1.434131e-01, 1.434330e-01, 1.434530e-01,
    1.434729e-01, 1.434928e-01, 1.435128e-01, 1.435327e-01, 1.435526e-01, 1.435725e-01,
    1.435925e-01, 1.436124e-01, 1.436323e-01, 1.436523e-01, 1.436722e-01, 1.436921e-01,
    1.437120e-01, 1.437320e-01, 1.437519e-01, 1.437718e-01, 1.437918e-01, 1.438117e-01,
    1.438316e-01, 1.438515e-01, 1.438714e-01, 1.438914e-01, 1.439113e-01, 1.439312e-01,
    1.439511e-01, 1.439711e-01, 1.439910e-01, 1.440109e-01, 1.440308e-01, 1.440508e-01,
    1.440707e-01, 1.440906e-01, 1.441105e-01, 1.441304e-01, 1.441504e-01, 1.441703e-01,
    1.441902e-01, 1.442101e-01, 1.442300e-01, 1.442500e-01, 1.442699e-01, 1.442898e-01,
    1.443097e-01, 1.443296e-01, 1.443496e-01, 1.443695e-01, 1.443894e-01, 1.444093e-01,
    1.444292e-01, 1.444491e-01, 1.444691e-01, 1.444890e-01, 1.445089e-01, 1.445288e-01,
    1.445487e-01, 1.445686e-01, 1.445885e-01, 1.446085e-01, 1.446284e-01, 1.446483e-01,
    1.446682e-01, 1.446881e-01, 1.447080e-01, 1.447279e-01, 1.447479e-01, 1.447678e-01,
    1.447877e-01, 1.448076e-01, 1.448275e-01, 1.448474e-01, 1.448673e-01, 1.448872e-01,
    1.449071e-01, 1.449271e-01, 1.449470e-01, 1.449669e-01, 1.449868e-01, 1.450067e-01,
    1.450266e-01, 1.450465e-01, 1.450664e-01, 1.450863e-01, 1.451062e-01, 1.451261e-01,
    1.451460e-01, 1.451660e-01, 1.451859e-01, 1.452058e-01, 1.452257e-01, 1.452456e-01,
    1.452655e-01, 1.452854e-01, 1.453053e-01, 1.453252e-01, 1.453451e-01, 1.453650e-01,
    1.453849e-01, 1.454048e-01, 1.454247e-01, 1.454446e-01, 1.454645e-01, 1.454844e-01,
    1.455043e-01, 1.455242e-01, 1.455441e-01, 1.455640e-01, 1.455839e-01, 1.456038e-01,
    1.456237e-01, 1.456436e-01, 1.456635e-01, 1.456834e-01, 1.457033e-01, 1.457232e-01,
    1.457431e-01, 1.457630e-01, 1.457829e-01, 1.458028e-01, 1.458227e-01, 1.458426e-01,
    1.458625e-01, 1.458824e-01, 1.459023e-01, 1.459222e-01, 1.459421e-01, 1.459620e-01,
    1.459819e-01, 1.460018e-01, 1.460217e-01, 1.460416e-01, 1.460615e-01, 1.460814e-01,
    1.461013e-01, 1.461211e-01, 1.461410e-01, 1.461609e-01, 1.461808e-01, 1.462007e-01,
    1.462206e-01, 1.462405e-01, 1.462604e-01, 1.462803e-01, 1.463002e-01, 1.463201e-01,
    1.463400e-01, 1.463598e-01, 1.463797e-01, 1.463996e-01, 1.464195e-01, 1.464394e-01,
    1.464593e-01, 1.464792e-01, 1.464991e-01, 1.465189e-01, 1.465389e-01, 1.465587e-01,
    1.465786e-01, 1.465985e-01, 1.466184e-01, 1.466383e-01, 1.466582e-01, 1.466780e-01,
    1.466979e-01, 1.467178e-01, 1.467377e-01, 1.467576e-01, 1.467775e-01, 1.467974e-01,
    1.468173e-01, 1.468371e-01, 1.468570e-01, 1.468769e-01, 1.468968e-01, 1.469167e-01,
    1.469365e-01, 1.469564e-01, 1.469763e-01, 1.469962e-01, 1.470161e-01, 1.470359e-01,
    1.470558e-01, 1.470757e-01, 1.470956e-01, 1.471155e-01, 1.471353e-01, 1.471552e-01,
    1.471751e-01, 1.471950e-01, 1.472149e-01, 1.472347e-01, 1.472546e-01, 1.472745e-01,
    1.472944e-01, 1.473143e-01, 1.473341e-01, 1.473540e-01, 1.473739e-01, 1.473937e-01,
    1.474136e-01, 1.474335e-01, 1.474534e-01, 1.474733e-01, 1.474931e-01, 1.475130e-01,
    1.475329e-01, 1.475528e-01, 1.475726e-01, 1.475925e-01, 1.476124e-01, 1.476323e-01,
    1.476521e-01, 1.476720e-01, 1.476919e-01, 1.477117e-01, 1.477316e-01, 1.477515e-01,
    1.477714e-01, 1.477912e-01, 1.478111e-01, 1.478309e-01, 1.478508e-01, 1.478707e-01,
    1.478906e-01, 1.479104e-01, 1.479303e-01, 1.479502e-01, 1.479700e-01, 1.479899e-01,
    1.480098e-01, 1.480296e-01, 1.480495e-01, 1.480694e-01, 1.480892e-01, 1.481091e-01,
    1.481290e-01, 1.481488e-01, 1.481687e-01, 1.481886e-01, 1.482084e-01, 1.482283e-01,
    1.482482e-01, 1.482680e-01, 1.482879e-01, 1.483078e-01, 1.483276e-01, 1.483475e-01,
    1.483673e-01, 1.483872e-01, 1.484071e-01, 1.484269e-01, 1.484468e-01, 1.484667e-01,
    1.484865e-01, 1.485064e-01, 1.485262e-01, 1.485461e-01, 1.485659e-01, 1.485858e-01,
    1.486057e-01, 1.486255e-01, 1.486454e-01, 1.486652e-01, 1.486851e-01, 1.487050e-01,
    1.487248e-01, 1.487447e-01, 1.487645e-01, 1.487844e-01, 1.488042e-01, 1.488241e-01,
    1.488440e-01, 1.488638e-01, 1.488837e-01, 1.489035e-01, 1.489234e-01, 1.489432e-01,
    1.489631e-01, 1.489829e-01, 1.490028e-01, 1.490227e-01, 1.490425e-01, 1.490624e-01,
    1.490822e-01, 1.491021e-01, 1.491219e-01, 1.491418e-01, 1.491616e-01, 1.491815e-01,
    1.492013e-01, 1.492212e-01, 1.492410e-01, 1.492609e-01, 1.492807e-01, 1.493006e-01,
    1.493204e-01, 1.493403e-01, 1.493601e-01, 1.493800e-01, 1.493998e-01, 1.494197e-01,
    1.494395e-01, 1.494594e-01, 1.494792e-01, 1.494991e-01, 1.495189e-01, 1.495388e-01,
    1.495586e-01, 1.495784e-01, 1.495983e-01, 1.496181e-01, 1.496380e-01, 1.496578e-01,
    1.496777e-01, 1.496975e-01, 1.497174e-01, 1.497372e-01, 1.497570e-01, 1.497769e-01,
    1.497967e-01, 1.498166e-01, 1.498364e-01, 1.498563e-01, 1.498761e-01, 1.498959e-01,
    1.499158e-01, 1.499356e-01, 1.499555e-01, 1.499753e-01, 1.499951e-01, 1.500150e-01,
    1.500348e-01, 1.500547e-01, 1.500745e-01, 1.500943e-01, 1.501142e-01, 1.501340e-01,
    1.501538e-01, 1.501737e-01, 1.501935e-01, 1.502134e-01, 1.502332e-01, 1.502530e-01,
    1.502729e-01, 1.502927e-01, 1.503125e-01, 1.503324e-01, 1.503522e-01, 1.503721e-01,
    1.503919e-01, 1.504117e-01, 1.504316e-01, 1.504514e-01, 1.504712e-01, 1.504911e-01,
    1.505109e-01, 1.505307e-01, 1.505505e-01, 1.505704e-01, 1.505902e-01, 1.506100e-01,
    1.506299e-01, 1.506497e-01, 1.506695e-01, 1.506894e-01, 1.507092e-01, 1.507290e-01,
    1.507489e-01, 1.507687e-01, 1.507885e-01, 1.508083e-01, 1.508282e-01, 1.508480e-01,
    1.508678e-01, 1.508877e-01, 1.509075e-01, 1.509273e-01, 1.509471e-01, 1.509670e-01,
    1.509868e-01, 1.510066e-01, 1.510264e-01, 1.510463e-01, 1.510661e-01, 1.510859e-01,
    1.511057e-01, 1.511256e-01, 1.511454e-01, 1.511652e-01, 1.511851e-01, 1.512049e-01,
    1.512247e-01, 1.512445e-01, 1.512643e-01, 1.512842e-01, 1.513040e-01, 1.513238e-01,
    1.513436e-01, 1.513634e-01, 1.513833e-01, 1.514031e-01, 1.514229e-01, 1.514427e-01,
    1.514626e-01, 1.514824e-01, 1.515022e-01, 1.515220e-01, 1.515418e-01, 1.515616e-01,
    1.515815e-01, 1.516013e-01, 1.516211e-01, 1.516409e-01, 1.516607e-01, 1.516805e-01,
    1.517004e-01, 1.517202e-01, 1.517400e-01, 1.517598e-01, 1.517796e-01, 1.517995e-01,
    1.518193e-01, 1.518391e-01, 1.518589e-01, 1.518787e-01, 1.518985e-01, 1.519183e-01,
    1.519381e-01, 1.519580e-01, 1.519778e-01, 1.519976e-01, 1.520174e-01, 1.520372e-01,
    1.520570e-01, 1.520768e-01, 1.520966e-01, 1.521165e-01, 1.521363e-01, 1.521561e-01,
    1.521759e-01, 1.521957e-01, 1.522155e-01, 1.522353e-01, 1.522551e-01, 1.522749e-01,
    1.522947e-01, 1.523146e-01, 1.523344e-01, 1.523542e-01, 1.523740e-01, 1.523938e-01,
    1.524136e-01, 1.524334e-01, 1.524532e-01, 1.524730e-01, 1.524928e-01, 1.525126e-01,
    1.525324e-01, 1.525522e-01, 1.525720e-01, 1.525918e-01, 1.526116e-01, 1.526314e-01,
    1.526513e-01, 1.526711e-01, 1.526909e-01, 1.527107e-01, 1.527305e-01, 1.527503e-01,
    1.527701e-01, 1.527899e-01, 1.528097e-01, 1.528295e-01, 1.528493e-01, 1.528691e-01,
    1.528889e-01, 1.529087e-01, 1.529285e-01, 1.529483e-01, 1.529681e-01, 1.529879e-01,
    1.530077e-01, 1.530275e-01, 1.530473e-01, 1.530671e-01, 1.530869e-01, 1.531067e-01,
    1.531265e-01, 1.531463e-01, 1.531661e-01, 1.531858e-01, 1.532056e-01, 1.532254e-01,
    1.532452e-01, 1.532650e-01, 1.532848e-01, 1.533046e-01, 1.533244e-01, 1.533442e-01,
    1.533640e-01, 1.533838e-01, 1.534036e-01, 1.534234e-01, 1.534432e-01, 1.534630e-01,
    1.534828e-01, 1.535026e-01, 1.535223e-01, 1.535421e-01, 1.535619e-01, 1.535817e-01,
    1.536015e-01, 1.536213e-01, 1.536411e-01, 1.536609e-01, 1.536807e-01, 1.537005e-01,
    1.537202e-01, 1.537400e-01, 1.537598e-01, 1.537796e-01, 1.537994e-01, 1.538192e-01,
    1.538390e-01, 1.538588e-01, 1.538786e-01, 1.538983e-01, 1.539181e-01, 1.539379e-01,
    1.539577e-01, 1.539775e-01, 1.539973e-01, 1.540170e-01, 1.540368e-01, 1.540566e-01,
    1.540764e-01, 1.540962e-01, 1.541160e-01, 1.541357e-01, 1.541555e-01, 1.541753e-01,
    1.541951e-01, 1.542149e-01, 1.542347e-01, 1.542544e-01, 1.542742e-01, 1.542940e-01,
    1.543138e-01, 1.543336e-01, 1.543534e-01, 1.543731e-01, 1.543929e-01, 1.544127e-01,
    1.544325e-01, 1.544522e-01, 1.544720e-01, 1.544918e-01, 1.545116e-01, 1.545314e-01,
    1.545511e-01, 1.545709e-01, 1.545907e-01, 1.546105e-01, 1.546302e-01, 1.546500e-01,
    1.546698e-01, 1.546896e-01, 1.547094e-01, 1.547291e-01, 1.547489e-01, 1.547687e-01,
    1.547884e-01, 1.548082e-01, 1.548280e-01, 1.548478e-01, 1.548675e-01, 1.548873e-01,
    1.549071e-01, 1.549269e-01, 1.549466e-01, 1.549664e-01, 1.549862e-01, 1.550059e-01,
    1.550257e-01, 1.550455e-01, 1.550653e-01, 1.550850e-01, 1.551048e-01, 1.551246e-01,
    1.551443e-01, 1.551641e-01, 1.551839e-01, 1.552036e-01, 1.552234e-01, 1.552432e-01,
    1.552629e-01, 1.552827e-01, 1.553025e-01, 1.553223e-01, 1.553420e-01, 1.553618e-01,
    1.553815e-01, 1.554013e-01, 1.554211e-01, 1.554408e-01, 1.554606e-01, 1.554804e-01,
    1.555001e-01, 1.555199e-01, 1.555397e-01, 1.555594e-01, 1.555792e-01, 1.555990e-01,
    1.556187e-01, 1.556385e-01, 1.556582e-01, 1.556780e-01, 1.556978e-01, 1.557175e-01,
    1.557373e-01, 1.557571e-01, 1.557768e-01, 1.557966e-01, 1.558163e-01, 1.558361e-01,
    1.558559e-01, 1.558756e-01, 1.558954e-01, 1.559151e-01, 1.559349e-01, 1.559547e-01,
    1.559744e-01, 1.559942e-01, 1.560139e-01, 1.560337e-01, 1.560534e-01, 1.560732e-01,
    1.560930e-01, 1.561127e-01, 1.561325e-01, 1.561522e-01, 1.561720e-01, 1.561917e-01,
    1.562115e-01, 1.562312e-01, 1.562510e-01, 1.562707e-01, 1.562905e-01, 1.563103e-01,
    1.563300e-01, 1.563498e-01, 1.563695e-01, 1.563893e-01, 1.564090e-01, 1.564288e-01,
    1.564485e-01, 1.564683e-01, 1.564880e-01, 1.565078e-01, 1.565275e-01, 1.565473e-01,
    1.565670e-01, 1.565868e-01, 1.566065e-01, 1.566263e-01, 1.566460e-01, 1.566658e-01,
    1.566855e-01, 1.567053e-01, 1.567250e-01, 1.567448e-01, 1.567645e-01, 1.567843e-01,
    1.568040e-01, 1.568238e-01, 1.568435e-01, 1.568632e-01, 1.568830e-01, 1.569027e-01,
    1.569225e-01, 1.569422e-01, 1.569620e-01, 1.569817e-01, 1.570015e-01, 1.570212e-01,
    1.570410e-01, 1.570607e-01, 1.570804e-01, 1.571002e-01, 1.571199e-01, 1.571397e-01,
    1.571594e-01, 1.571791e-01, 1.571989e-01, 1.572186e-01, 1.572384e-01, 1.572581e-01,
    1.572778e-01, 1.572976e-01, 1.573173e-01, 1.573371e-01, 1.573568e-01, 1.573765e-01,
    1.573963e-01, 1.574160e-01, 1.574358e-01, 1.574555e-01, 1.574752e-01, 1.574950e-01,
    1.575147e-01, 1.575344e-01, 1.575542e-01, 1.575739e-01, 1.575937e-01, 1.576134e-01,
    1.576331e-01, 1.576529e-01, 1.576726e-01, 1.576923e-01, 1.577121e-01, 1.577318e-01,
    1.577515e-01, 1.577713e-01, 1.577910e-01, 1.578107e-01, 1.578305e-01, 1.578502e-01,
    1.578699e-01, 1.578897e-01, 1.579094e-01, 1.579291e-01, 1.579489e-01, 1.579686e-01,
    1.579883e-01, 1.580081e-01, 1.580278e-01, 1.580475e-01, 1.580672e-01, 1.580870e-01,
    1.581067e-01, 1.581264e-01, 1.581462e-01, 1.581659e-01, 1.581856e-01, 1.582053e-01,
    1.582251e-01, 1.582448e-01, 1.582645e-01, 1.582842e-01, 1.583040e-01, 1.583237e-01,
    1.583434e-01, 1.583631e-01, 1.583829e-01, 1.584026e-01, 1.584223e-01, 1.584420e-01,
    1.584618e-01, 1.584815e-01, 1.585012e-01, 1.585209e-01, 1.585407e-01, 1.585604e-01,
    1.585801e-01, 1.585998e-01, 1.586195e-01, 1.586393e-01, 1.586590e-01, 1.586787e-01,
    1.586984e-01, 1.587182e-01, 1.587379e-01, 1.587576e-01, 1.587773e-01, 1.587970e-01,
    1.588168e-01, 1.588365e-01, 1.588562e-01, 1.588759e-01, 1.588956e-01, 1.589153e-01,
    1.589351e-01, 1.589548e-01, 1.589745e-01, 1.589942e-01, 1.590139e-01, 1.590336e-01,
    1.590534e-01, 1.590731e-01, 1.590928e-01, 1.591125e-01, 1.591322e-01, 1.591519e-01,
    1.591717e-01, 1.591914e-01, 1.592111e-01, 1.592308e-01, 1.592505e-01, 1.592702e-01,
    1.592899e-01, 1.593096e-01, 1.593294e-01, 1.593491e-01, 1.593688e-01, 1.593885e-01,
    1.594082e-01, 1.594279e-01, 1.594476e-01, 1.594673e-01, 1.594871e-01, 1.595068e-01,
    1.595265e-01, 1.595462e-01, 1.595659e-01, 1.595856e-01, 1.596053e-01, 1.596250e-01,
    1.596447e-01, 1.596644e-01, 1.596841e-01, 1.597038e-01, 1.597236e-01, 1.597432e-01,
    1.597630e-01, 1.597827e-01, 1.598024e-01, 1.598221e-01, 1.598418e-01, 1.598615e-01,
    1.598812e-01, 1.599009e-01, 1.599206e-01, 1.599403e-01, 1.599600e-01, 1.599797e-01,
    1.599994e-01, 1.600191e-01, 1.600388e-01, 1.600585e-01, 1.600782e-01, 1.600979e-01,
    1.601176e-01, 1.601373e-01, 1.601570e-01, 1.601767e-01, 1.601964e-01, 1.602161e-01,
    1.602358e-01, 1.602555e-01, 1.602752e-01, 1.602949e-01, 1.603146e-01, 1.603343e-01,
    1.603540e-01, 1.603737e-01, 1.603934e-01, 1.604131e-01, 1.604328e-01, 1.604525e-01,
    1.604722e-01, 1.604919e-01, 1.605116e-01, 1.605313e-01, 1.605510e-01, 1.605707e-01,
    1.605904e-01, 1.606101e-01, 1.606298e-01, 1.606494e-01, 1.606692e-01, 1.606888e-01,
    1.607085e-01, 1.607282e-01, 1.607479e-01, 1.607676e-01, 1.607873e-01, 1.608070e-01,
    1.608267e-01, 1.608464e-01, 1.608661e-01, 1.608858e-01, 1.609055e-01, 1.609251e-01,
    1.609448e-01, 1.609645e-01, 1.609842e-01, 1.610039e-01, 1.610236e-01, 1.610433e-01,
    1.610630e-01, 1.610827e-01, 1.611024e-01, 1.611220e-01, 1.611417e-01, 1.611614e-01,
    1.611811e-01, 1.612008e-01, 1.612205e-01, 1.612402e-01, 1.612598e-01, 1.612795e-01,
    1.612992e-01, 1.613189e-01, 1.613386e-01, 1.613583e-01, 1.613780e-01, 1.613976e-01,
    1.614173e-01, 1.614370e-01, 1.614567e-01, 1.614764e-01, 1.614961e-01, 1.615157e-01,
    1.615354e-01, 1.615551e-01, 1.615748e-01, 1.615945e-01, 1.616141e-01, 1.616338e-01,
    1.616535e-01, 1.616732e-01, 1.616929e-01, 1.617125e-01, 1.617322e-01, 1.617519e-01,
    1.617716e-01, 1.617913e-01, 1.618109e-01, 1.618306e-01, 1.618503e-01, 1.618700e-01,
    1.618896e-01, 1.619093e-01, 1.619290e-01, 1.619487e-01, 1.619684e-01, 1.619880e-01,
    1.620077e-01, 1.620274e-01, 1.620471e-01, 1.620667e-01, 1.620864e-01, 1.621061e-01,
    1.621258e-01, 1.621454e-01, 1.621651e-01, 1.621848e-01, 1.622044e-01, 1.622241e-01,
    1.622438e-01, 1.622635e-01, 1.622831e-01, 1.623028e-01, 1.623225e-01, 1.623421e-01,
    1.623618e-01, 1.623815e-01, 1.624012e-01, 1.624208e-01, 1.624405e-01, 1.624602e-01,
    1.624798e-01, 1.624995e-01, 1.625192e-01, 1.625388e-01, 1.625585e-01, 1.625782e-01,
    1.625978e-01, 1.626175e-01, 1.626372e-01, 1.626568e-01, 1.626765e-01, 1.626962e-01,
    1.627159e-01, 1.627355e-01, 1.627552e-01, 1.627748e-01, 1.627945e-01, 1.628142e-01,
    1.628338e-01, 1.628535e-01, 1.628732e-01, 1.628928e-01, 1.629125e-01, 1.629322e-01,
    1.629518e-01, 1.629715e-01, 1.629912e-01, 1.630108e-01, 1.630305e-01, 1.630501e-01,
    1.630698e-01, 1.630895e-01, 1.631091e-01, 1.631288e-01, 1.631484e-01, 1.631681e-01,
    1.631878e-01, 1.632074e-01, 1.632271e-01, 1.632467e-01, 1.632664e-01, 1.632860e-01,
    1.633057e-01, 1.633254e-01, 1.633450e-01, 1.633647e-01, 1.633843e-01, 1.634040e-01,
    1.634236e-01, 1.634433e-01, 1.634630e-01, 1.634826e-01, 1.635023e-01, 1.635219e-01,
    1.635416e-01, 1.635612e-01, 1.635809e-01, 1.636005e-01, 1.636202e-01, 1.636398e-01,
    1.636595e-01, 1.636792e-01, 1.636988e-01, 1.637185e-01, 1.637381e-01, 1.637578e-01,
    1.637774e-01, 1.637971e-01, 1.638167e-01, 1.638364e-01, 1.638560e-01, 1.638757e-01,
    1.638953e-01, 1.639150e-01, 1.639346e-01, 1.639543e-01, 1.639739e-01, 1.639936e-01,
    1.640132e-01, 1.640329e-01, 1.640525e-01, 1.640722e-01, 1.640918e-01, 1.641115e-01,
    1.641311e-01, 1.641507e-01, 1.641704e-01, 1.641900e-01, 1.642097e-01, 1.642293e-01,
    1.642490e-01, 1.642686e-01, 1.642883e-01, 1.643079e-01, 1.643275e-01, 1.643472e-01,
    1.643668e-01, 1.643865e-01, 1.644061e-01, 1.644258e-01, 1.644454e-01, 1.644651e-01,
    1.644847e-01, 1.645043e-01, 1.645240e-01, 1.645436e-01, 1.645633e-01, 1.645829e-01,
    1.646025e-01, 1.646222e-01, 1.646418e-01, 1.646615e-01, 1.646811e-01, 1.647007e-01,
    1.647204e-01, 1.647400e-01, 1.647597e-01, 1.647793e-01, 1.647989e-01, 1.648186e-01,
    1.648382e-01, 1.648578e-01, 1.648775e-01, 1.648971e-01, 1.649167e-01, 1.649364e-01,
    1.649560e-01, 1.649756e-01, 1.649953e-01, 1.650149e-01, 1.650345e-01, 1.650542e-01,
    1.650738e-01, 1.650935e-01, 1.651131e-01, 1.651327e-01, 1.651524e-01, 1.651720e-01,
    1.651916e-01, 1.652112e-01, 1.652309e-01, 1.652505e-01, 1.652701e-01, 1.652898e-01,
    1.653094e-01, 1.653290e-01, 1.653487e-01, 1.653683e-01, 1.653879e-01, 1.654076e-01,
    1.654272e-01, 1.654468e-01, 1.654664e-01, 1.654861e-01, 1.655057e-01, 1.655253e-01,
    1.655450e-01, 1.655646e-01, 1.655842e-01, 1.656038e-01, 1.656235e-01, 1.656431e-01,
    1.656627e-01, 1.656823e-01, 1.657020e-01, 1.657216e-01, 1.657412e-01, 1.657608e-01,
    1.657805e-01, 1.658001e-01, 1.658197e-01, 1.658393e-01, 1.658590e-01, 1.658786e-01,
    1.658982e-01, 1.659178e-01, 1.659375e-01, 1.659571e-01, 1.659767e-01, 1.659963e-01,
    1.660159e-01, 1.660355e-01, 1.660552e-01, 1.660748e-01, 1.660944e-01, 1.661140e-01,
    1.661336e-01, 1.661533e-01, 1.661729e-01, 1.661925e-01, 1.662121e-01, 1.662318e-01,
    1.662514e-01, 1.662710e-01, 1.662906e-01, 1.663102e-01, 1.663298e-01, 1.663494e-01,
    1.663691e-01, 1.663887e-01, 1.664083e-01, 1.664279e-01, 1.664475e-01, 1.664671e-01,
    1.664868e-01, 1.665064e-01, 1.665260e-01, 1.665456e-01, 1.665652e-01, 1.665848e-01,
    1.666044e-01, 1.666241e-01, 1.666437e-01, 1.666633e-01, 1.666829e-01, 1.667025e-01,
    1.667221e-01, 1.667417e-01, 1.667613e-01, 1.667809e-01, 1.668006e-01, 1.668202e-01,
    1.668398e-01, 1.668594e-01, 1.668790e-01, 1.668986e-01, 1.669182e-01, 1.669378e-01,
    1.669574e-01, 1.669770e-01, 1.669966e-01, 1.670163e-01, 1.670359e-01, 1.670555e-01,
    1.670751e-01, 1.670947e-01, 1.671143e-01, 1.671339e-01, 1.671535e-01, 1.671731e-01,
    1.671927e-01, 1.672123e-01, 1.672319e-01, 1.672515e-01, 1.672711e-01, 1.672907e-01,
    1.673103e-01, 1.673299e-01, 1.673495e-01, 1.673691e-01, 1.673888e-01, 1.674083e-01,
    1.674279e-01, 1.674475e-01, 1.674671e-01, 1.674868e-01, 1.675064e-01, 1.675260e-01,
    1.675456e-01, 1.675652e-01, 1.675847e-01, 1.676043e-01, 1.676240e-01, 1.676435e-01,
    1.676631e-01, 1.676828e-01, 1.677023e-01, 1.677219e-01, 1.677415e-01, 1.677611e-01,
    1.677807e-01, 1.678003e-01, 1.678199e-01, 1.678395e-01, 1.678591e-01, 1.678787e-01,
    1.678983e-01, 1.679179e-01, 1.679375e-01, 1.679571e-01, 1.679767e-01, 1.679963e-01,
    1.680159e-01, 1.680355e-01, 1.680551e-01, 1.680747e-01, 1.680942e-01, 1.681138e-01,
    1.681334e-01, 1.681530e-01, 1.681726e-01, 1.681922e-01, 1.682118e-01, 1.682314e-01,
    1.682510e-01, 1.682706e-01, 1.682902e-01, 1.683098e-01, 1.683293e-01, 1.683489e-01,
    1.683685e-01, 1.683881e-01, 1.684077e-01, 1.684273e-01, 1.684469e-01, 1.684665e-01,
    1.684860e-01, 1.685056e-01, 1.685252e-01, 1.685448e-01, 1.685644e-01, 1.685840e-01,
    1.686036e-01, 1.686231e-01, 1.686427e-01, 1.686623e-01, 1.686819e-01, 1.687015e-01,
    1.687211e-01, 1.687407e-01, 1.687602e-01, 1.687798e-01, 1.687994e-01, 1.688190e-01,
    1.688386e-01, 1.688582e-01, 1.688777e-01, 1.688973e-01, 1.689169e-01, 1.689365e-01,
    1.689561e-01, 1.689757e-01, 1.689952e-01, 1.690148e-01, 1.690344e-01, 1.690540e-01,
    1.690736e-01, 1.690931e-01, 1.691127e-01, 1.691323e-01, 1.691519e-01, 1.691714e-01,
    1.691910e-01, 1.692106e-01, 1.692302e-01, 1.692497e-01, 1.692693e-01, 1.692889e-01,
    1.693085e-01, 1.693280e-01, 1.693476e-01, 1.693672e-01, 1.693868e-01, 1.694064e-01,
    1.694259e-01, 1.694455e-01, 1.694651e-01, 1.694847e-01, 1.695042e-01, 1.695238e-01,
    1.695434e-01, 1.695630e-01, 1.695825e-01, 1.696021e-01, 1.696217e-01, 1.696412e-01,
    1.696608e-01, 1.696804e-01, 1.697000e-01, 1.697195e-01, 1.697391e-01, 1.697587e-01,
    1.697782e-01, 1.697978e-01, 1.698174e-01, 1.698369e-01, 1.698565e-01, 1.698761e-01,
    1.698956e-01, 1.699152e-01, 1.699348e-01, 1.699543e-01, 1.699739e-01, 1.699935e-01,
    1.700131e-01, 1.700326e-01, 1.700522e-01, 1.700718e-01, 1.700913e-01, 1.701109e-01,
    1.701304e-01, 1.701500e-01, 1.701696e-01, 1.701891e-01, 1.702087e-01, 1.702283e-01,
    1.702478e-01, 1.702674e-01, 1.702870e-01, 1.703065e-01, 1.703261e-01, 1.703456e-01,
    1.703652e-01, 1.703848e-01, 1.704043e-01, 1.704239e-01, 1.704435e-01, 1.704630e-01,
    1.704826e-01, 1.705021e-01, 1.705217e-01, 1.705413e-01, 1.705608e-01, 1.705804e-01,
    1.705999e-01, 1.706195e-01, 1.706391e-01, 1.706586e-01, 1.706782e-01, 1.706977e-01,
    1.707173e-01, 1.707368e-01, 1.707564e-01, 1.707759e-01, 1.707955e-01, 1.708151e-01,
    1.708346e-01, 1.708542e-01, 1.708737e-01, 1.708933e-01, 1.709128e-01, 1.709324e-01,
    1.709519e-01, 1.709715e-01, 1.709910e-01, 1.710106e-01, 1.710302e-01, 1.710497e-01,
    1.710693e-01, 1.710888e-01, 1.711084e-01, 1.711279e-01, 1.711475e-01, 1.711670e-01,
    1.711866e-01, 1.712061e-01, 1.712257e-01, 1.712452e-01, 1.712648e-01, 1.712843e-01,
    1.713039e-01, 1.713234e-01, 1.713430e-01, 1.713625e-01, 1.713821e-01, 1.714016e-01,
    1.714212e-01, 1.714407e-01, 1.714603e-01, 1.714798e-01, 1.714993e-01, 1.715189e-01,
    1.715384e-01, 1.715580e-01, 1.715775e-01, 1.715971e-01, 1.716166e-01, 1.716362e-01,
    1.716557e-01, 1.716752e-01, 1.716948e-01, 1.717144e-01, 1.717339e-01, 1.717534e-01,
    1.717730e-01, 1.717925e-01, 1.718121e-01, 1.718316e-01, 1.718511e-01, 1.718707e-01,
    1.718902e-01, 1.719098e-01, 1.719293e-01, 1.719489e-01, 1.719684e-01, 1.719879e-01,
    1.720075e-01, 1.720270e-01, 1.720465e-01, 1.720661e-01, 1.720856e-01, 1.721052e-01,
    1.721247e-01, 1.721442e-01, 1.721638e-01, 1.721833e-01, 1.722029e-01, 1.722224e-01,
    1.722419e-01, 1.722615e-01, 1.722810e-01, 1.723005e-01, 1.723201e-01, 1.723396e-01,
    1.723591e-01, 1.723787e-01, 1.723982e-01, 1.724177e-01, 1.724373e-01, 1.724568e-01,
    1.724763e-01, 1.724959e-01, 1.725154e-01, 1.725349e-01, 1.725545e-01, 1.725740e-01,
    1.725935e-01, 1.726131e-01, 1.726326e-01, 1.726521e-01, 1.726717e-01, 1.726912e-01,
    1.727107e-01, 1.727303e-01, 1.727498e-01, 1.727693e-01, 1.727888e-01, 1.728084e-01,
    1.728279e-01, 1.728474e-01, 1.728670e-01, 1.728865e-01, 1.729060e-01, 1.729255e-01,
    1.729451e-01, 1.729646e-01, 1.729841e-01, 1.730036e-01, 1.730232e-01, 1.730427e-01,
    1.730622e-01, 1.730818e-01, 1.731013e-01, 1.731208e-01, 1.731403e-01, 1.731598e-01,
    1.731794e-01, 1.731989e-01, 1.732184e-01, 1.732379e-01, 1.732575e-01, 1.732770e-01,
    1.732965e-01, 1.733160e-01, 1.733356e-01, 1.733551e-01, 1.733746e-01, 1.733941e-01,
    1.734136e-01, 1.734332e-01, 1.734527e-01, 1.734722e-01, 1.734917e-01, 1.735112e-01,
    1.735308e-01, 1.735503e-01, 1.735698e-01, 1.735893e-01, 1.736088e-01, 1.736283e-01,
    1.736479e-01, 1.736674e-01, 1.736869e-01, 1.737064e-01, 1.737259e-01, 1.737454e-01,
    1.737650e-01, 1.737845e-01, 1.738040e-01, 1.738235e-01, 1.738430e-01, 1.738625e-01,
    1.738821e-01, 1.739016e-01, 1.739211e-01, 1.739406e-01, 1.739601e-01, 1.739796e-01,
    1.739991e-01, 1.740187e-01, 1.740382e-01, 1.740577e-01, 1.740772e-01, 1.740967e-01,
    1.741162e-01, 1.741357e-01, 1.741552e-01, 1.741747e-01, 1.741942e-01, 1.742138e-01,
    1.742333e-01, 1.742528e-01, 1.742723e-01, 1.742918e-01, 1.743113e-01, 1.743308e-01,
    1.743503e-01, 1.743698e-01, 1.743893e-01, 1.744088e-01, 1.744283e-01, 1.744478e-01,
    1.744674e-01, 1.744869e-01, 1.745064e-01, 1.745259e-01, 1.745454e-01, 1.745649e-01,
    1.745844e-01, 1.746039e-01, 1.746234e-01, 1.746429e-01, 1.746624e-01, 1.746819e-01,
    1.747014e-01, 1.747209e-01, 1.747404e-01, 1.747599e-01, 1.747794e-01, 1.747989e-01,
    1.748184e-01, 1.748379e-01, 1.748574e-01, 1.748769e-01, 1.748964e-01, 1.749159e-01,
    1.749354e-01, 1.749549e-01, 1.749744e-01, 1.749939e-01, 1.750134e-01, 1.750329e-01,
    1.750524e-01, 1.750719e-01, 1.750914e-01, 1.751109e-01, 1.751304e-01, 1.751499e-01,
    1.751694e-01, 1.751889e-01, 1.752084e-01, 1.752279e-01, 1.752474e-01, 1.752669e-01,
    1.752864e-01, 1.753059e-01, 1.753254e-01, 1.753449e-01, 1.753644e-01, 1.753839e-01,
    1.754034e-01, 1.754228e-01, 1.754423e-01, 1.754618e-01, 1.754813e-01, 1.755008e-01,
    1.755203e-01, 1.755398e-01, 1.755593e-01, 1.755788e-01, 1.755983e-01, 1.756178e-01,
    1.756373e-01, 1.756568e-01, 1.756762e-01, 1.756957e-01, 1.757152e-01, 1.757347e-01,
    1.757542e-01, 1.757737e-01, 1.757932e-01, 1.758127e-01, 1.758322e-01, 1.758516e-01,
    1.758711e-01, 1.758906e-01, 1.759101e-01, 1.759296e-01, 1.759491e-01, 1.759686e-01,
    1.759880e-01, 1.760075e-01, 1.760270e-01, 1.760465e-01, 1.760660e-01, 1.760855e-01,
    1.761050e-01, 1.761244e-01, 1.761439e-01, 1.761634e-01, 1.761829e-01, 1.762024e-01,
    1.762218e-01, 1.762413e-01, 1.762608e-01, 1.762803e-01, 1.762998e-01, 1.763193e-01,
    1.763387e-01, 1.763582e-01, 1.763777e-01, 1.763972e-01, 1.764167e-01, 1.764362e-01,
    1.764556e-01, 1.764751e-01, 1.764946e-01, 1.765141e-01, 1.765336e-01, 1.765530e-01,
    1.765725e-01, 1.765920e-01, 1.766115e-01, 1.766309e-01, 1.766504e-01, 1.766699e-01,
    1.766894e-01, 1.767088e-01, 1.767283e-01, 1.767478e-01, 1.767673e-01, 1.767867e-01,
    1.768062e-01, 1.768257e-01, 1.768452e-01, 1.768646e-01, 1.768841e-01, 1.769036e-01,
    1.769231e-01, 1.769425e-01, 1.769620e-01, 1.769815e-01, 1.770010e-01, 1.770204e-01,
    1.770399e-01, 1.770594e-01, 1.770788e-01, 1.770983e-01, 1.771178e-01, 1.771373e-01,
    1.771567e-01, 1.771762e-01, 1.771957e-01, 1.772151e-01, 1.772346e-01, 1.772541e-01,
    1.772735e-01, 1.772930e-01, 1.773125e-01, 1.773319e-01, 1.773514e-01, 1.773709e-01,
    1.773903e-01, 1.774098e-01, 1.774293e-01, 1.774487e-01, 1.774682e-01, 1.774877e-01,
    1.775071e-01, 1.775266e-01, 1.775461e-01, 1.775655e-01, 1.775850e-01, 1.776045e-01,
    1.776239e-01, 1.776434e-01, 1.776628e-01, 1.776823e-01, 1.777018e-01, 1.777212e-01,
    1.777407e-01, 1.777602e-01, 1.777796e-01, 1.777991e-01, 1.778186e-01, 1.778380e-01,
    1.778575e-01, 1.778769e-01, 1.778964e-01, 1.779158e-01, 1.779353e-01, 1.779548e-01,
    1.779742e-01, 1.779937e-01, 1.780131e-01, 1.780326e-01, 1.780521e-01, 1.780715e-01,
    1.780910e-01, 1.781104e-01, 1.781299e-01, 1.781493e-01, 1.781688e-01, 1.781883e-01,
    1.782077e-01, 1.782272e-01, 1.782466e-01, 1.782661e-01, 1.782855e-01, 1.783050e-01,
    1.783244e-01, 1.783439e-01, 1.783634e-01, 1.783828e-01, 1.784023e-01, 1.784217e-01,
    1.784412e-01, 1.784606e-01, 1.784801e-01, 1.784995e-01, 1.785190e-01, 1.785384e-01,
    1.785579e-01, 1.785773e-01, 1.785968e-01, 1.786162e-01, 1.786357e-01, 1.786551e-01,
    1.786746e-01, 1.786940e-01, 1.787135e-01, 1.787329e-01, 1.787524e-01, 1.787718e-01,
    1.787913e-01, 1.788107e-01, 1.788302e-01, 1.788496e-01, 1.788691e-01, 1.788885e-01,
    1.789079e-01, 1.789274e-01, 1.789468e-01, 1.789663e-01, 1.789857e-01, 1.790052e-01,
    1.790246e-01, 1.790441e-01, 1.790635e-01, 1.790830e-01, 1.791024e-01, 1.791218e-01,
    1.791413e-01, 1.791607e-01, 1.791802e-01, 1.791996e-01, 1.792191e-01, 1.792385e-01,
    1.792579e-01, 1.792774e-01, 1.792968e-01, 1.793163e-01, 1.793357e-01, 1.793551e-01,
    1.793746e-01, 1.793940e-01, 1.794135e-01, 1.794329e-01, 1.794523e-01, 1.794718e-01,
    1.794912e-01, 1.795107e-01, 1.795301e-01, 1.795495e-01, 1.795690e-01, 1.795884e-01,
    1.796078e-01, 1.796273e-01, 1.796467e-01, 1.796662e-01, 1.796856e-01, 1.797050e-01,
    1.797245e-01, 1.797439e-01, 1.797633e-01, 1.797828e-01, 1.798022e-01, 1.798216e-01,
    1.798411e-01, 1.798605e-01, 1.798799e-01, 1.798994e-01, 1.799188e-01, 1.799382e-01,
    1.799577e-01, 1.799771e-01, 1.799965e-01, 1.800160e-01, 1.800354e-01, 1.800548e-01,
    1.800743e-01, 1.800937e-01, 1.801131e-01, 1.801326e-01, 1.801520e-01, 1.801714e-01,
    1.801908e-01, 1.802103e-01, 1.802297e-01, 1.802491e-01, 1.802686e-01, 1.802880e-01,
    1.803074e-01, 1.803268e-01, 1.803463e-01, 1.803657e-01, 1.803851e-01, 1.804045e-01,
    1.804240e-01, 1.804434e-01, 1.804628e-01, 1.804823e-01, 1.805017e-01, 1.805211e-01,
    1.805405e-01, 1.805599e-01, 1.805794e-01, 1.805988e-01, 1.806182e-01, 1.806376e-01,
    1.806571e-01, 1.806765e-01, 1.806959e-01, 1.807153e-01, 1.807347e-01, 1.807542e-01,
    1.807736e-01, 1.807930e-01, 1.808124e-01, 1.808318e-01, 1.808513e-01, 1.808707e-01,
    1.808901e-01, 1.809095e-01, 1.809289e-01, 1.809484e-01, 1.809678e-01, 1.809872e-01,
    1.810066e-01, 1.810260e-01, 1.810455e-01, 1.810649e-01, 1.810843e-01, 1.811037e-01,
    1.811231e-01, 1.811426e-01, 1.811620e-01, 1.811814e-01, 1.812008e-01, 1.812202e-01,
    1.812396e-01, 1.812591e-01, 1.812785e-01, 1.812979e-01, 1.813173e-01, 1.813367e-01,
    1.813561e-01, 1.813755e-01, 1.813949e-01, 1.814144e-01, 1.814338e-01, 1.814532e-01,
    1.814726e-01, 1.814920e-01, 1.815114e-01, 1.815308e-01, 1.815502e-01, 1.815697e-01,
    1.815890e-01, 1.816085e-01, 1.816279e-01, 1.816473e-01, 1.816667e-01, 1.816861e-01,
    1.817055e-01, 1.817249e-01, 1.817443e-01, 1.817637e-01, 1.817831e-01, 1.818026e-01,
    1.818220e-01, 1.818414e-01, 1.818608e-01, 1.818802e-01, 1.818996e-01, 1.819190e-01,
    1.819384e-01, 1.819578e-01, 1.819772e-01, 1.819966e-01, 1.820160e-01, 1.820354e-01,
    1.820548e-01, 1.820742e-01, 1.820936e-01, 1.821130e-01, 1.821324e-01, 1.821518e-01,
    1.821712e-01, 1.821906e-01, 1.822100e-01, 1.822294e-01, 1.822489e-01, 1.822682e-01,
    1.822877e-01, 1.823070e-01, 1.823265e-01, 1.823459e-01, 1.823652e-01, 1.823847e-01,
    1.824040e-01, 1.824235e-01, 1.824428e-01, 1.824622e-01, 1.824816e-01, 1.825010e-01,
    1.825204e-01, 1.825399e-01, 1.825592e-01, 1.825786e-01, 1.825980e-01, 1.826174e-01,
    1.826368e-01, 1.826562e-01, 1.826756e-01, 1.826950e-01, 1.827144e-01, 1.827338e-01,
    1.827532e-01, 1.827726e-01, 1.827920e-01, 1.828114e-01, 1.828308e-01, 1.828502e-01,
    1.828696e-01, 1.828890e-01, 1.829083e-01, 1.829277e-01, 1.829471e-01, 1.829665e-01,
    1.829859e-01, 1.830053e-01, 1.830247e-01, 1.830441e-01, 1.830635e-01, 1.830829e-01,
    1.831023e-01, 1.831217e-01, 1.831410e-01, 1.831604e-01, 1.831798e-01, 1.831992e-01,
    1.832186e-01, 1.832380e-01, 1.832574e-01, 1.832768e-01, 1.832961e-01, 1.833155e-01,
    1.833349e-01, 1.833543e-01, 1.833737e-01, 1.833931e-01, 1.834125e-01, 1.834319e-01,
    1.834512e-01, 1.834706e-01, 1.834900e-01, 1.835094e-01, 1.835288e-01, 1.835482e-01,
    1.835675e-01, 1.835869e-01, 1.836063e-01, 1.836257e-01, 1.836451e-01, 1.836645e-01,
    1.836838e-01, 1.837032e-01, 1.837226e-01, 1.837420e-01, 1.837614e-01, 1.837807e-01,
    1.838001e-01, 1.838195e-01, 1.838389e-01, 1.838583e-01, 1.838776e-01, 1.838970e-01,
    1.839164e-01, 1.839358e-01, 1.839552e-01, 1.839745e-01, 1.839939e-01, 1.840133e-01,
    1.840327e-01, 1.840521e-01, 1.840714e-01, 1.840908e-01, 1.841102e-01, 1.841296e-01,
    1.841489e-01, 1.841683e-01, 1.841877e-01, 1.842071e-01, 1.842264e-01, 1.842458e-01,
    1.842652e-01, 1.842846e-01, 1.843039e-01, 1.843233e-01, 1.843427e-01, 1.843621e-01,
    1.843814e-01, 1.844008e-01, 1.844202e-01, 1.844395e-01, 1.844589e-01, 1.844783e-01,
    1.844977e-01, 1.845170e-01, 1.845364e-01, 1.845558e-01, 1.845751e-01, 1.845945e-01,
    1.846139e-01, 1.846332e-01, 1.846526e-01, 1.846720e-01, 1.846914e-01, 1.847107e-01,
    1.847301e-01, 1.847495e-01, 1.847688e-01, 1.847882e-01, 1.848076e-01, 1.848269e-01,
    1.848463e-01, 1.848657e-01, 1.848850e-01, 1.849044e-01, 1.849238e-01, 1.849431e-01,
    1.849625e-01, 1.849819e-01, 1.850012e-01, 1.850206e-01, 1.850399e-01, 1.850593e-01,
    1.850787e-01, 1.850980e-01, 1.851174e-01, 1.851368e-01, 1.851561e-01, 1.851755e-01,
    1.851948e-01, 1.852142e-01, 1.852336e-01, 1.852529e-01, 1.852723e-01, 1.852917e-01,
    1.853110e-01, 1.853304e-01, 1.853497e-01, 1.853691e-01, 1.853885e-01, 1.854078e-01,
    1.854272e-01, 1.854465e-01, 1.854659e-01, 1.854852e-01, 1.855046e-01, 1.855240e-01,
    1.855433e-01, 1.855627e-01, 1.855820e-01, 1.856014e-01, 1.856207e-01, 1.856401e-01,
    1.856595e-01, 1.856788e-01, 1.856982e-01, 1.857175e-01, 1.857369e-01, 1.857562e-01,
    1.857756e-01, 1.857949e-01, 1.858143e-01, 1.858336e-01, 1.858530e-01, 1.858724e-01,
    1.858917e-01, 1.859111e-01, 1.859304e-01, 1.859498e-01, 1.859691e-01, 1.859885e-01,
    1.860078e-01, 1.860272e-01, 1.860465e-01, 1.860659e-01, 1.860852e-01, 1.861046e-01,
    1.861239e-01, 1.861433e-01, 1.861626e-01, 1.861820e-01, 1.862013e-01, 1.862207e-01,
    1.862400e-01, 1.862594e-01, 1.862787e-01, 1.862981e-01, 1.863174e-01, 1.863367e-01,
    1.863561e-01, 1.863754e-01, 1.863948e-01, 1.864141e-01, 1.864335e-01, 1.864528e-01,
    1.864722e-01, 1.864915e-01, 1.865108e-01, 1.865302e-01, 1.865495e-01, 1.865689e-01,
    1.865882e-01, 1.866076e-01, 1.866269e-01, 1.866463e-01, 1.866656e-01, 1.866849e-01,
    1.867043e-01, 1.867236e-01, 1.867429e-01, 1.867623e-01, 1.867816e-01, 1.868010e-01,
    1.868203e-01, 1.868397e-01, 1.868590e-01, 1.868784e-01, 1.868977e-01, 1.869170e-01,
    1.869363e-01, 1.869557e-01, 1.869750e-01, 1.869944e-01, 1.870137e-01, 1.870330e-01,
    1.870524e-01, 1.870717e-01, 1.870911e-01, 1.871104e-01, 1.871297e-01, 1.871491e-01,
    1.871684e-01, 1.871877e-01, 1.872071e-01, 1.872264e-01, 1.872457e-01, 1.872651e-01,
    1.872844e-01, 1.873038e-01, 1.873231e-01, 1.873424e-01, 1.873617e-01, 1.873811e-01,
    1.874004e-01, 1.874197e-01, 1.874391e-01, 1.874584e-01, 1.874777e-01, 1.874970e-01,
    1.875164e-01, 1.875357e-01, 1.875551e-01, 1.875744e-01, 1.875937e-01, 1.876130e-01,
    1.876324e-01, 1.876517e-01, 1.876710e-01, 1.876904e-01, 1.877097e-01, 1.877290e-01,
    1.877483e-01, 1.877677e-01, 1.877870e-01, 1.878063e-01, 1.878256e-01, 1.878450e-01,
    1.878643e-01, 1.878836e-01, 1.879030e-01, 1.879223e-01, 1.879416e-01, 1.879609e-01,
    1.879803e-01, 1.879996e-01, 1.880189e-01, 1.880382e-01, 1.880575e-01, 1.880769e-01,
    1.880962e-01, 1.881155e-01, 1.881348e-01, 1.881542e-01, 1.881735e-01, 1.881928e-01,
    1.882121e-01, 1.882314e-01, 1.882508e-01, 1.882701e-01, 1.882894e-01, 1.883087e-01,
    1.883281e-01, 1.883474e-01, 1.883667e-01, 1.883860e-01, 1.884053e-01, 1.884246e-01,
    1.884440e-01, 1.884633e-01, 1.884826e-01, 1.885019e-01, 1.885212e-01, 1.885406e-01,
    1.885599e-01, 1.885792e-01, 1.885985e-01, 1.886178e-01, 1.886371e-01, 1.886564e-01,
    1.886758e-01, 1.886951e-01, 1.887144e-01, 1.887337e-01, 1.887530e-01, 1.887723e-01,
    1.887916e-01, 1.888110e-01, 1.888303e-01, 1.888496e-01, 1.888689e-01, 1.888882e-01,
    1.889075e-01, 1.889268e-01, 1.889462e-01, 1.889655e-01, 1.889848e-01, 1.890041e-01,
    1.890234e-01, 1.890427e-01, 1.890620e-01, 1.890813e-01, 1.891006e-01, 1.891199e-01,
    1.891392e-01, 1.891586e-01, 1.891779e-01, 1.891972e-01, 1.892165e-01, 1.892358e-01,
    1.892551e-01, 1.892744e-01, 1.892937e-01, 1.893130e-01, 1.893323e-01, 1.893516e-01,
    1.893709e-01, 1.893902e-01, 1.894095e-01, 1.894289e-01, 1.894481e-01, 1.894675e-01,
    1.894868e-01, 1.895061e-01, 1.895254e-01, 1.895447e-01, 1.895640e-01, 1.895833e-01,
    1.896026e-01, 1.896219e-01, 1.896412e-01, 1.896605e-01, 1.896798e-01, 1.896991e-01,
    1.897184e-01, 1.897377e-01, 1.897570e-01, 1.897763e-01, 1.897956e-01, 1.898149e-01,
    1.898342e-01, 1.898535e-01, 1.898728e-01, 1.898921e-01, 1.899114e-01, 1.899307e-01,
    1.899500e-01, 1.899693e-01, 1.899886e-01, 1.900079e-01, 1.900272e-01, 1.900465e-01,
    1.900658e-01, 1.900851e-01, 1.901044e-01, 1.901237e-01, 1.901430e-01, 1.901623e-01,
    1.901816e-01, 1.902009e-01, 1.902201e-01, 1.902394e-01, 1.902587e-01, 1.902780e-01,
    1.902973e-01, 1.903166e-01, 1.903359e-01, 1.903552e-01, 1.903745e-01, 1.903938e-01,
    1.904131e-01, 1.904324e-01, 1.904517e-01, 1.904710e-01, 1.904902e-01, 1.905095e-01,
    1.905288e-01, 1.905481e-01, 1.905674e-01, 1.905867e-01, 1.906060e-01, 1.906253e-01,
    1.906446e-01, 1.906639e-01, 1.906831e-01, 1.907024e-01, 1.907217e-01, 1.907410e-01,
    1.907603e-01, 1.907796e-01, 1.907989e-01, 1.908181e-01, 1.908374e-01, 1.908567e-01,
    1.908760e-01, 1.908953e-01, 1.909146e-01, 1.909339e-01, 1.909532e-01, 1.909724e-01,
    1.909917e-01, 1.910110e-01, 1.910303e-01, 1.910496e-01, 1.910689e-01, 1.910881e-01,
    1.911074e-01, 1.911267e-01, 1.911460e-01, 1.911653e-01, 1.911846e-01, 1.912038e-01,
    1.912231e-01, 1.912424e-01, 1.912617e-01, 1.912809e-01, 1.913002e-01, 1.913195e-01,
    1.913388e-01, 1.913581e-01, 1.913773e-01, 1.913966e-01, 1.914159e-01, 1.914352e-01,
    1.914545e-01, 1.914738e-01, 1.914930e-01, 1.915123e-01, 1.915316e-01, 1.915509e-01,
    1.915701e-01, 1.915894e-01, 1.916087e-01, 1.916279e-01, 1.916472e-01, 1.916665e-01,
    1.916858e-01, 1.917051e-01, 1.917243e-01, 1.917436e-01, 1.917629e-01, 1.917821e-01,
    1.918014e-01, 1.918207e-01, 1.918400e-01, 1.918592e-01, 1.918785e-01, 1.918978e-01,
    1.919171e-01, 1.919363e-01, 1.919556e-01, 1.919749e-01, 1.919941e-01, 1.920134e-01,
    1.920327e-01, 1.920519e-01, 1.920712e-01, 1.920905e-01, 1.921098e-01, 1.921290e-01,
    1.921483e-01, 1.921676e-01, 1.921868e-01, 1.922061e-01, 1.922254e-01, 1.922446e-01,
    1.922639e-01, 1.922832e-01, 1.923025e-01, 1.923217e-01, 1.923410e-01, 1.923603e-01,
    1.923795e-01, 1.923988e-01, 1.924180e-01, 1.924373e-01, 1.924566e-01, 1.924758e-01,
    1.924951e-01, 1.925144e-01, 1.925336e-01, 1.925529e-01, 1.925722e-01, 1.925914e-01,
    1.926107e-01, 1.926299e-01, 1.926492e-01, 1.926685e-01, 1.926877e-01, 1.927070e-01,
    1.927263e-01, 1.927455e-01, 1.927648e-01, 1.927840e-01, 1.928033e-01, 1.928226e-01,
    1.928418e-01, 1.928611e-01, 1.928803e-01, 1.928996e-01, 1.929189e-01, 1.929381e-01,
    1.929574e-01, 1.929766e-01, 1.929959e-01, 1.930151e-01, 1.930344e-01, 1.930536e-01,
    1.930729e-01, 1.930922e-01, 1.931114e-01, 1.931307e-01, 1.931499e-01, 1.931692e-01,
    1.931884e-01, 1.932077e-01, 1.932270e-01, 1.932462e-01, 1.932655e-01, 1.932847e-01,
    1.933040e-01, 1.933232e-01, 1.933425e-01, 1.933617e-01, 1.933810e-01, 1.934002e-01,
    1.934195e-01, 1.934387e-01, 1.934580e-01, 1.934772e-01, 1.934965e-01, 1.935157e-01,
    1.935350e-01, 1.935542e-01, 1.935735e-01, 1.935927e-01, 1.936120e-01, 1.936312e-01,
    1.936505e-01, 1.936697e-01, 1.936890e-01, 1.937082e-01, 1.937275e-01, 1.937467e-01,
    1.937660e-01, 1.937852e-01, 1.938045e-01, 1.938237e-01, 1.938430e-01, 1.938622e-01,
    1.938814e-01, 1.939007e-01, 1.939199e-01, 1.939392e-01, 1.939584e-01, 1.939777e-01,
    1.939969e-01, 1.940162e-01, 1.940354e-01, 1.940546e-01, 1.940739e-01, 1.940931e-01,
    1.941124e-01, 1.941316e-01, 1.941509e-01, 1.941701e-01, 1.941894e-01, 1.942086e-01,
    1.942278e-01, 1.942471e-01, 1.942663e-01, 1.942856e-01, 1.943048e-01, 1.943240e-01,
    1.943433e-01, 1.943625e-01, 1.943817e-01, 1.944010e-01, 1.944202e-01, 1.944395e-01,
    1.944587e-01, 1.944779e-01, 1.944972e-01, 1.945164e-01, 1.945356e-01, 1.945549e-01,
    1.945741e-01, 1.945934e-01, 1.946126e-01, 1.946318e-01, 1.946511e-01, 1.946703e-01,
    1.946895e-01, 1.947088e-01, 1.947280e-01, 1.947472e-01, 1.947665e-01, 1.947857e-01,
    1.948049e-01, 1.948242e-01, 1.948434e-01, 1.948626e-01, 1.948819e-01, 1.949011e-01,
    1.949203e-01, 1.949396e-01, 1.949588e-01, 1.949780e-01, 1.949973e-01, 1.950165e-01,
    1.950357e-01, 1.950549e-01, 1.950742e-01, 1.950934e-01, 1.951126e-01, 1.951319e-01,
    1.951511e-01, 1.951703e-01, 1.951896e-01, 1.952088e-01, 1.952280e-01, 1.952472e-01,
    1.952665e-01, 1.952857e-01, 1.953049e-01, 1.953241e-01, 1.953434e-01, 1.953626e-01,
    1.953818e-01, 1.954011e-01, 1.954203e-01, 1.954395e-01, 1.954587e-01, 1.954779e-01,
    1.954972e-01, 1.955164e-01, 1.955356e-01, 1.955548e-01, 1.955741e-01, 1.955933e-01,
    1.956125e-01, 1.956317e-01, 1.956510e-01, 1.956702e-01, 1.956894e-01, 1.957086e-01,
    1.957278e-01, 1.957471e-01, 1.957663e-01, 1.957855e-01, 1.958047e-01, 1.958239e-01,
    1.958432e-01, 1.958624e-01, 1.958816e-01, 1.959008e-01, 1.959200e-01, 1.959393e-01,
    1.959585e-01, 1.959777e-01, 1.959969e-01, 1.960161e-01, 1.960354e-01, 1.960546e-01,
    1.960738e-01, 1.960930e-01, 1.961122e-01, 1.961314e-01, 1.961506e-01, 1.961699e-01,
    1.961891e-01, 1.962083e-01, 1.962275e-01, 1.962467e-01, 1.962659e-01, 1.962851e-01,
    1.963044e-01, 1.963236e-01, 1.963428e-01, 1.963620e-01, 1.963812e-01, 1.964004e-01,
    1.964196e-01, 1.964388e-01, 1.964580e-01, 1.964773e-01, 1.964965e-01, 1.965157e-01,
    1.965349e-01, 1.965541e-01, 1.965733e-01, 1.965925e-01, 1.966117e-01, 1.966309e-01,
    1.966501e-01, 1.966694e-01, 1.966886e-01, 1.967078e-01, 1.967270e-01, 1.967462e-01,
    1.967654e-01, 1.967846e-01, 1.968038e-01, 1.968230e-01, 1.968422e-01, 1.968614e-01,
    1.968806e-01, 1.968998e-01, 1.969190e-01, 1.969383e-01, 1.969575e-01, 1.969766e-01,
    1.969959e-01, 1.970151e-01, 1.970343e-01, 1.970535e-01, 1.970727e-01, 1.970919e-01,
    1.971111e-01, 1.971303e-01, 1.971495e-01, 1.971687e-01, 1.971879e-01, 1.972071e-01,
    1.972263e-01, 1.972455e-01, 1.972647e-01, 1.972839e-01, 1.973031e-01, 1.973223e-01,
    1.973415e-01, 1.973607e-01, 1.973799e-01, 1.973991e-01, 1.974183e-01, 1.974375e-01,
    1.974567e-01, 1.974759e-01, 1.974951e-01, 1.975143e-01, 1.975335e-01, 1.975527e-01,
    1.975719e-01, 1.975911e-01, 1.976103e-01, 1.976295e-01, 1.976487e-01, 1.976679e-01,
    1.976870e-01, 1.977063e-01, 1.977254e-01, 1.977446e-01, 1.977638e-01, 1.977830e-01,
    1.978022e-01, 1.978214e-01, 1.978406e-01, 1.978598e-01, 1.978790e-01, 1.978982e-01,
    1.979174e-01, 1.979365e-01, 1.979557e-01, 1.979750e-01, 1.979941e-01, 1.980133e-01,
    1.980325e-01, 1.980517e-01, 1.980709e-01, 1.980901e-01, 1.981093e-01, 1.981285e-01,
    1.981476e-01, 1.981668e-01, 1.981860e-01, 1.982052e-01, 1.982244e-01, 1.982436e-01,
    1.982628e-01, 1.982820e-01, 1.983012e-01, 1.983203e-01, 1.983395e-01, 1.983587e-01,
    1.983779e-01, 1.983971e-01, 1.984162e-01, 1.984355e-01, 1.984546e-01, 1.984738e-01,
    1.984930e-01, 1.985122e-01, 1.985314e-01, 1.985506e-01, 1.985697e-01, 1.985889e-01,
    1.986081e-01, 1.986273e-01, 1.986465e-01, 1.986656e-01, 1.986848e-01, 1.987040e-01,
    1.987232e-01, 1.987424e-01, 1.987616e-01, 1.987807e-01, 1.987999e-01, 1.988191e-01,
    1.988383e-01, 1.988575e-01, 1.988766e-01, 1.988958e-01, 1.989150e-01, 1.989342e-01,
    1.989534e-01, 1.989725e-01, 1.989917e-01, 1.990109e-01, 1.990301e-01, 1.990492e-01,
    1.990684e-01, 1.990876e-01, 1.991068e-01, 1.991259e-01, 1.991451e-01, 1.991643e-01,
    1.991835e-01, 1.992026e-01, 1.992218e-01, 1.992410e-01, 1.992602e-01, 1.992793e-01,
    1.992985e-01, 1.993177e-01, 1.993369e-01, 1.993560e-01, 1.993752e-01, 1.993944e-01,
    1.994135e-01, 1.994327e-01, 1.994519e-01, 1.994711e-01, 1.994902e-01, 1.995094e-01,
    1.995286e-01, 1.995478e-01, 1.995669e-01, 1.995861e-01, 1.996053e-01, 1.996244e-01,
    1.996436e-01, 1.996628e-01, 1.996819e-01, 1.997011e-01, 1.997203e-01, 1.997394e-01,
    1.997586e-01, 1.997778e-01, 1.997969e-01, 1.998161e-01, 1.998353e-01, 1.998544e-01,
    1.998736e-01, 1.998928e-01, 1.999119e-01, 1.999311e-01, 1.999502e-01, 1.999694e-01,
    1.999886e-01, 2.000078e-01, 2.000269e-01, 2.000461e-01, 2.000652e-01, 2.000844e-01,
    2.001036e-01, 2.001227e-01, 2.001419e-01, 2.001611e-01, 2.001802e-01, 2.001994e-01,
    2.002185e-01, 2.002377e-01, 2.002569e-01, 2.002760e-01, 2.002952e-01, 2.003143e-01,
    2.003335e-01, 2.003527e-01, 2.003718e-01, 2.003910e-01, 2.004101e-01, 2.004293e-01,
    2.004485e-01, 2.004676e-01, 2.004868e-01, 2.005059e-01, 2.005251e-01, 2.005442e-01,
    2.005634e-01, 2.005826e-01, 2.006017e-01, 2.006209e-01, 2.006400e-01, 2.006592e-01,
    2.006783e-01, 2.006975e-01, 2.007166e-01, 2.007358e-01, 2.007550e-01, 2.007741e-01,
    2.007933e-01, 2.008124e-01, 2.008316e-01, 2.008507e-01, 2.008699e-01, 2.008890e-01,
    2.009082e-01, 2.009273e-01, 2.009465e-01, 2.009656e-01, 2.009848e-01, 2.010039e-01,
    2.010231e-01, 2.010422e-01, 2.010614e-01, 2.010805e-01, 2.010997e-01, 2.011188e-01,
    2.011380e-01, 2.011571e-01, 2.011763e-01, 2.011954e-01, 2.012146e-01, 2.012337e-01,
    2.012529e-01, 2.012720e-01, 2.012912e-01, 2.013103e-01, 2.013295e-01, 2.013486e-01,
    2.013678e-01, 2.013869e-01, 2.014060e-01, 2.014252e-01, 2.014443e-01, 2.014635e-01,
    2.014826e-01, 2.015018e-01, 2.015209e-01, 2.015401e-01, 2.015592e-01, 2.015783e-01,
    2.015975e-01, 2.016166e-01, 2.016358e-01, 2.016549e-01, 2.016741e-01, 2.016932e-01,
    2.017123e-01, 2.017315e-01, 2.017506e-01, 2.017698e-01, 2.017889e-01, 2.018081e-01,
    2.018272e-01, 2.018463e-01, 2.018655e-01, 2.018846e-01, 2.019037e-01, 2.019229e-01,
    2.019420e-01, 2.019612e-01, 2.019803e-01, 2.019994e-01, 2.020186e-01, 2.020377e-01,
    2.020569e-01, 2.020760e-01, 2.020951e-01, 2.021143e-01, 2.021334e-01, 2.021525e-01,
    2.021717e-01, 2.021908e-01, 2.022099e-01, 2.022291e-01, 2.022482e-01, 2.022673e-01,
    2.022865e-01, 2.023056e-01, 2.023247e-01, 2.023439e-01, 2.023630e-01, 2.023821e-01,
    2.024013e-01, 2.024204e-01, 2.024395e-01, 2.024587e-01, 2.024778e-01, 2.024969e-01,
    2.025161e-01, 2.025352e-01, 2.025543e-01, 2.025734e-01, 2.025926e-01, 2.026117e-01,
    2.026308e-01, 2.026500e-01, 2.026691e-01, 2.026882e-01, 2.027074e-01, 2.027265e-01,
    2.027456e-01, 2.027647e-01, 2.027839e-01, 2.028030e-01, 2.028221e-01, 2.028412e-01,
    2.028604e-01, 2.028795e-01, 2.028986e-01, 2.029178e-01, 2.029369e-01, 2.029560e-01,
    2.029751e-01, 2.029942e-01, 2.030134e-01, 2.030325e-01, 2.030516e-01, 2.030707e-01,
    2.030899e-01, 2.031090e-01, 2.031281e-01, 2.031472e-01, 2.031664e-01, 2.031855e-01,
    2.032046e-01, 2.032237e-01, 2.032428e-01, 2.032620e-01, 2.032811e-01, 2.033002e-01,
    2.033193e-01, 2.033384e-01, 2.033575e-01, 2.033767e-01, 2.033958e-01, 2.034149e-01,
    2.034340e-01, 2.034532e-01, 2.034723e-01, 2.034914e-01, 2.035105e-01, 2.035296e-01,
    2.035488e-01, 2.035679e-01, 2.035870e-01, 2.036061e-01, 2.036252e-01, 2.036443e-01,
    2.036634e-01, 2.036826e-01, 2.037017e-01, 2.037208e-01, 2.037399e-01, 2.037590e-01,
    2.037781e-01, 2.037973e-01, 2.038164e-01, 2.038355e-01, 2.038546e-01, 2.038737e-01,
    2.038928e-01, 2.039119e-01, 2.039310e-01, 2.039501e-01, 2.039693e-01, 2.039884e-01,
    2.040075e-01, 2.040266e-01, 2.040457e-01, 2.040648e-01, 2.040839e-01, 2.041030e-01,
    2.041221e-01, 2.041413e-01, 2.041604e-01, 2.041795e-01, 2.041986e-01, 2.042177e-01,
    2.042368e-01, 2.042559e-01, 2.042750e-01, 2.042941e-01, 2.043132e-01, 2.043323e-01,
    2.043514e-01, 2.043706e-01, 2.043896e-01, 2.044087e-01, 2.044279e-01, 2.044470e-01,
    2.044661e-01, 2.044852e-01, 2.045043e-01, 2.045234e-01, 2.045425e-01, 2.045616e-01,
    2.045807e-01, 2.045998e-01, 2.046189e-01, 2.046380e-01, 2.046571e-01, 2.046762e-01,
    2.046953e-01, 2.047144e-01, 2.047335e-01, 2.047526e-01, 2.047717e-01, 2.047908e-01,
    2.048099e-01, 2.048290e-01, 2.048481e-01, 2.048672e-01, 2.048863e-01, 2.049054e-01,
    2.049245e-01, 2.049436e-01, 2.049627e-01, 2.049818e-01, 2.050009e-01, 2.050200e-01,
    2.050391e-01, 2.050582e-01, 2.050773e-01, 2.050964e-01, 2.051155e-01, 2.051346e-01,
    2.051537e-01, 2.051728e-01, 2.051919e-01, 2.052110e-01, 2.052301e-01, 2.052492e-01,
    2.052683e-01, 2.052874e-01, 2.053064e-01, 2.053255e-01, 2.053446e-01, 2.053637e-01,
    2.053828e-01, 2.054019e-01, 2.054210e-01, 2.054401e-01, 2.054592e-01, 2.054783e-01,
    2.054974e-01, 2.055165e-01, 2.055355e-01, 2.055546e-01, 2.055737e-01, 2.055928e-01,
    2.056119e-01, 2.056310e-01, 2.056501e-01, 2.056692e-01, 2.056883e-01, 2.057074e-01,
    2.057264e-01, 2.057455e-01, 2.057646e-01, 2.057837e-01, 2.058028e-01, 2.058219e-01,
    2.058410e-01, 2.058600e-01, 2.058791e-01, 2.058982e-01, 2.059173e-01, 2.059364e-01,
    2.059555e-01, 2.059746e-01, 2.059937e-01, 2.060127e-01, 2.060318e-01, 2.060509e-01,
    2.060700e-01, 2.060891e-01, 2.061082e-01, 2.061272e-01, 2.061463e-01, 2.061654e-01,
    2.061845e-01, 2.062036e-01, 2.062227e-01, 2.062417e-01, 2.062608e-01, 2.062799e-01,
    2.062990e-01, 2.063181e-01, 2.063371e-01, 2.063562e-01, 2.063753e-01, 2.063944e-01,
    2.064134e-01, 2.064325e-01, 2.064516e-01, 2.064707e-01, 2.064898e-01, 2.065089e-01,
    2.065279e-01, 2.065470e-01, 2.065661e-01, 2.065852e-01, 2.066042e-01, 2.066233e-01,
    2.066424e-01, 2.066615e-01, 2.066805e-01, 2.066996e-01, 2.067187e-01, 2.067378e-01,
    2.067568e-01, 2.067759e-01, 2.067950e-01, 2.068141e-01, 2.068331e-01, 2.068522e-01,
    2.068713e-01, 2.068904e-01, 2.069094e-01, 2.069285e-01, 2.069476e-01, 2.069666e-01,
    2.069857e-01, 2.070048e-01, 2.070239e-01, 2.070429e-01, 2.070620e-01, 2.070811e-01,
    2.071001e-01, 2.071192e-01, 2.071383e-01, 2.071573e-01, 2.071764e-01, 2.071955e-01,
    2.072145e-01, 2.072336e-01, 2.072527e-01, 2.072718e-01, 2.072908e-01, 2.073099e-01,
    2.073290e-01, 2.073480e-01, 2.073671e-01, 2.073862e-01, 2.074052e-01, 2.074243e-01,
    2.074434e-01, 2.074624e-01, 2.074815e-01, 2.075005e-01, 2.075196e-01, 2.075387e-01,
    2.075577e-01, 2.075768e-01, 2.075959e-01, 2.076149e-01, 2.076340e-01, 2.076531e-01,
    2.076721e-01, 2.076912e-01, 2.077102e-01, 2.077293e-01, 2.077484e-01, 2.077674e-01,
    2.077865e-01, 2.078056e-01, 2.078246e-01, 2.078437e-01, 2.078627e-01, 2.078818e-01,
    2.079009e-01, 2.079199e-01, 2.079390e-01, 2.079580e-01, 2.079771e-01, 2.079961e-01,
    2.080152e-01, 2.080343e-01, 2.080533e-01, 2.080724e-01, 2.080914e-01, 2.081105e-01,
    2.081296e-01, 2.081486e-01, 2.081677e-01, 2.081867e-01, 2.082058e-01, 2.082248e-01,
    2.082439e-01, 2.082630e-01, 2.082820e-01, 2.083010e-01, 2.083201e-01, 2.083392e-01,
    2.083582e-01, 2.083773e-01, 2.083963e-01, 2.084154e-01, 2.084344e-01, 2.084535e-01,
    2.084725e-01, 2.084916e-01, 2.085106e-01, 2.085297e-01, 2.085487e-01, 2.085678e-01,
    2.085868e-01, 2.086059e-01, 2.086249e-01, 2.086440e-01, 2.086630e-01, 2.086821e-01,
    2.087011e-01, 2.087202e-01, 2.087392e-01, 2.087583e-01, 2.087773e-01, 2.087964e-01,
    2.088154e-01, 2.088345e-01, 2.088535e-01, 2.088726e-01, 2.088916e-01, 2.089107e-01,
    2.089297e-01, 2.089487e-01, 2.089678e-01, 2.089868e-01, 2.090059e-01, 2.090249e-01,
    2.090440e-01, 2.090630e-01, 2.090821e-01, 2.091011e-01, 2.091202e-01, 2.091392e-01,
    2.091582e-01, 2.091773e-01, 2.091963e-01, 2.092154e-01, 2.092344e-01, 2.092534e-01,
    2.092725e-01, 2.092915e-01, 2.093106e-01, 2.093296e-01, 2.093486e-01, 2.093677e-01,
    2.093867e-01, 2.094058e-01, 2.094248e-01, 2.094439e-01, 2.094629e-01, 2.094819e-01,
    2.095010e-01, 2.095200e-01, 2.095390e-01, 2.095581e-01, 2.095771e-01, 2.095962e-01,
    2.096152e-01, 2.096342e-01, 2.096533e-01, 2.096723e-01, 2.096913e-01, 2.097104e-01,
    2.097294e-01, 2.097484e-01, 2.097675e-01, 2.097865e-01, 2.098055e-01, 2.098246e-01,
    2.098436e-01, 2.098626e-01, 2.098817e-01, 2.099007e-01, 2.099198e-01, 2.099388e-01,
    2.099578e-01, 2.099768e-01, 2.099959e-01, 2.100149e-01, 2.100339e-01, 2.100530e-01,
    2.100720e-01, 2.100910e-01, 2.101101e-01, 2.101291e-01, 2.101481e-01, 2.101671e-01,
    2.101862e-01, 2.102052e-01, 2.102242e-01, 2.102433e-01, 2.102623e-01, 2.102813e-01,
    2.103003e-01, 2.103194e-01, 2.103384e-01, 2.103574e-01, 2.103765e-01, 2.103955e-01,
    2.104145e-01, 2.104335e-01, 2.104526e-01, 2.104716e-01, 2.104906e-01, 2.105096e-01,
    2.105287e-01, 2.105477e-01, 2.105667e-01, 2.105857e-01, 2.106048e-01, 2.106238e-01,
    2.106428e-01, 2.106618e-01, 2.106809e-01, 2.106999e-01, 2.107189e-01, 2.107379e-01,
    2.107569e-01, 2.107760e-01, 2.107950e-01, 2.108140e-01, 2.108330e-01, 2.108520e-01,
    2.108711e-01, 2.108901e-01, 2.109091e-01, 2.109281e-01, 2.109471e-01, 2.109662e-01,
    2.109852e-01, 2.110042e-01, 2.110232e-01, 2.110422e-01, 2.110613e-01, 2.110803e-01,
    2.110993e-01, 2.111183e-01, 2.111373e-01, 2.111563e-01, 2.111754e-01, 2.111944e-01,
    2.112134e-01, 2.112324e-01, 2.112514e-01, 2.112704e-01, 2.112895e-01, 2.113085e-01,
    2.113275e-01, 2.113465e-01, 2.113655e-01, 2.113845e-01, 2.114035e-01, 2.114225e-01,
    2.114416e-01, 2.114606e-01, 2.114796e-01, 2.114986e-01, 2.115176e-01, 2.115366e-01,
    2.115556e-01, 2.115746e-01, 2.115937e-01, 2.116127e-01, 2.116317e-01, 2.116507e-01,
    2.116697e-01, 2.116887e-01, 2.117077e-01, 2.117267e-01, 2.117457e-01, 2.117648e-01,
    2.117838e-01, 2.118028e-01, 2.118218e-01, 2.118408e-01, 2.118598e-01, 2.118788e-01,
    2.118978e-01, 2.119168e-01, 2.119358e-01, 2.119548e-01, 2.119738e-01, 2.119928e-01,
    2.120118e-01, 2.120308e-01, 2.120498e-01, 2.120688e-01, 2.120878e-01, 2.121069e-01,
    2.121259e-01, 2.121449e-01, 2.121639e-01, 2.121829e-01, 2.122019e-01, 2.122209e-01,
    2.122399e-01, 2.122589e-01, 2.122779e-01, 2.122969e-01, 2.123159e-01, 2.123349e-01,
    2.123539e-01, 2.123729e-01, 2.123919e-01, 2.124109e-01, 2.124299e-01, 2.124489e-01,
    2.124679e-01, 2.124869e-01, 2.125059e-01, 2.125249e-01, 2.125439e-01, 2.125629e-01,
    2.125819e-01, 2.126009e-01, 2.126199e-01, 2.126389e-01, 2.126579e-01, 2.126769e-01,
    2.126959e-01, 2.127149e-01, 2.127338e-01, 2.127528e-01, 2.127718e-01, 2.127908e-01,
    2.128098e-01, 2.128288e-01, 2.128478e-01, 2.128668e-01, 2.128858e-01, 2.129048e-01,
    2.129238e-01, 2.129428e-01, 2.129618e-01, 2.129808e-01, 2.129998e-01, 2.130188e-01,
    2.130377e-01, 2.130568e-01, 2.130757e-01, 2.130947e-01, 2.131137e-01, 2.131327e-01,
    2.131517e-01, 2.131707e-01, 2.131897e-01, 2.132087e-01, 2.132277e-01, 2.132466e-01,
    2.132656e-01, 2.132846e-01, 2.133036e-01, 2.133226e-01, 2.133416e-01, 2.133606e-01,
    2.133796e-01, 2.133985e-01, 2.134175e-01, 2.134365e-01, 2.134555e-01, 2.134745e-01,
    2.134935e-01, 2.135125e-01, 2.135314e-01, 2.135504e-01, 2.135694e-01, 2.135884e-01,
    2.136074e-01, 2.136264e-01, 2.136454e-01, 2.136643e-01, 2.136833e-01, 2.137023e-01,
    2.137213e-01, 2.137403e-01, 2.137593e-01, 2.137782e-01, 2.137972e-01, 2.138162e-01,
    2.138352e-01, 2.138542e-01, 2.138731e-01, 2.138921e-01, 2.139111e-01, 2.139301e-01,
    2.139491e-01, 2.139680e-01, 2.139870e-01, 2.140060e-01, 2.140250e-01, 2.140440e-01,
    2.140629e-01, 2.140819e-01, 2.141009e-01, 2.141199e-01, 2.141389e-01, 2.141578e-01,
    2.141768e-01, 2.141958e-01, 2.142148e-01, 2.142337e-01, 2.142527e-01, 2.142717e-01,
    2.142907e-01, 2.143096e-01, 2.143286e-01, 2.143476e-01, 2.143666e-01, 2.143855e-01,
    2.144045e-01, 2.144235e-01, 2.144425e-01, 2.144614e-01, 2.144804e-01, 2.144994e-01,
    2.145183e-01, 2.145373e-01, 2.145563e-01, 2.145752e-01, 2.145942e-01, 2.146132e-01,
    2.146322e-01, 2.146511e-01, 2.146701e-01, 2.146891e-01, 2.147080e-01, 2.147270e-01,
    2.147460e-01, 2.147650e-01, 2.147839e-01, 2.148029e-01, 2.148219e-01, 2.148408e-01,
    2.148598e-01, 2.148788e-01, 2.148977e-01, 2.149167e-01, 2.149357e-01, 2.149546e-01,
    2.149736e-01, 2.149926e-01, 2.150115e-01, 2.150305e-01, 2.150495e-01, 2.150684e-01,
    2.150874e-01, 2.151064e-01, 2.151253e-01, 2.151443e-01, 2.151633e-01, 2.151822e-01,
    2.152012e-01, 2.152201e-01, 2.152391e-01, 2.152581e-01, 2.152770e-01, 2.152960e-01,
    2.153150e-01, 2.153339e-01, 2.153529e-01, 2.153718e-01, 2.153908e-01, 2.154098e-01,
    2.154287e-01, 2.154477e-01, 2.154666e-01, 2.154856e-01, 2.155046e-01, 2.155235e-01,
    2.155425e-01, 2.155614e-01, 2.155804e-01, 2.155994e-01, 2.156183e-01, 2.156373e-01,
    2.156562e-01, 2.156752e-01, 2.156941e-01, 2.157131e-01, 2.157321e-01, 2.157510e-01,
    2.157700e-01, 2.157889e-01, 2.158079e-01, 2.158268e-01, 2.158458e-01, 2.158647e-01,
    2.158837e-01, 2.159027e-01, 2.159216e-01, 2.159405e-01, 2.159595e-01, 2.159785e-01,
    2.159974e-01, 2.160164e-01, 2.160353e-01, 2.160543e-01, 2.160732e-01, 2.160922e-01,
    2.161111e-01, 2.161301e-01, 2.161490e-01, 2.161680e-01, 2.161869e-01, 2.162059e-01,
    2.162248e-01, 2.162438e-01, 2.162627e-01, 2.162817e-01, 2.163006e-01, 2.163196e-01,
    2.163385e-01, 2.163575e-01, 2.163764e-01, 2.163954e-01, 2.164143e-01, 2.164333e-01,
    2.164522e-01, 2.164712e-01, 2.164901e-01, 2.165090e-01, 2.165280e-01, 2.165469e-01,
    2.165659e-01, 2.165848e-01, 2.166038e-01, 2.166227e-01, 2.166417e-01, 2.166606e-01,
    2.166796e-01, 2.166985e-01, 2.167175e-01, 2.167364e-01, 2.167553e-01, 2.167743e-01,
    2.167932e-01, 2.168122e-01, 2.168311e-01, 2.168500e-01, 2.168690e-01, 2.168879e-01,
    2.169069e-01, 2.169258e-01, 2.169447e-01, 2.169637e-01, 2.169826e-01, 2.170016e-01,
    2.170205e-01, 2.170394e-01, 2.170584e-01, 2.170773e-01, 2.170963e-01, 2.171152e-01,
    2.171341e-01, 2.171531e-01, 2.171720e-01, 2.171910e-01, 2.172099e-01, 2.172288e-01,
    2.172478e-01, 2.172667e-01, 2.172856e-01, 2.173046e-01, 2.173235e-01, 2.173424e-01,
    2.173614e-01, 2.173803e-01, 2.173993e-01, 2.174182e-01, 2.174371e-01, 2.174560e-01,
    2.174750e-01, 2.174939e-01, 2.175128e-01, 2.175318e-01, 2.175507e-01, 2.175696e-01,
    2.175886e-01, 2.176075e-01, 2.176264e-01, 2.176454e-01, 2.176643e-01, 2.176832e-01,
    2.177022e-01, 2.177211e-01, 2.177400e-01, 2.177590e-01, 2.177779e-01, 2.177968e-01,
    2.178157e-01, 2.178347e-01, 2.178536e-01, 2.178725e-01, 2.178914e-01, 2.179104e-01,
    2.179293e-01, 2.179482e-01, 2.179672e-01, 2.179861e-01, 2.180050e-01, 2.180239e-01,
    2.180429e-01, 2.180618e-01, 2.180807e-01, 2.180997e-01, 2.181186e-01, 2.181375e-01,
    2.181564e-01, 2.181753e-01, 2.181943e-01, 2.182132e-01, 2.182321e-01, 2.182510e-01,
    2.182700e-01, 2.182889e-01, 2.183078e-01, 2.183267e-01, 2.183456e-01, 2.183646e-01,
    2.183835e-01, 2.184024e-01, 2.184213e-01, 2.184403e-01, 2.184592e-01, 2.184781e-01,
    2.184970e-01, 2.185159e-01, 2.185349e-01, 2.185538e-01, 2.185727e-01, 2.185916e-01,
    2.186105e-01, 2.186295e-01, 2.186484e-01, 2.186673e-01, 2.186862e-01, 2.187051e-01,
    2.187240e-01, 2.187430e-01, 2.187619e-01, 2.187808e-01, 2.187997e-01, 2.188186e-01,
    2.188375e-01, 2.188565e-01, 2.188754e-01, 2.188943e-01, 2.189132e-01, 2.189321e-01,
    2.189510e-01, 2.189699e-01, 2.189889e-01, 2.190078e-01, 2.190267e-01, 2.190456e-01,
    2.190645e-01, 2.190834e-01, 2.191023e-01, 2.191212e-01, 2.191401e-01, 2.191591e-01,
    2.191780e-01, 2.191969e-01, 2.192158e-01, 2.192347e-01, 2.192536e-01, 2.192725e-01,
    2.192914e-01, 2.193103e-01, 2.193293e-01, 2.193482e-01, 2.193671e-01, 2.193860e-01,
    2.194049e-01, 2.194238e-01, 2.194427e-01, 2.194616e-01, 2.194805e-01, 2.194994e-01,
    2.195183e-01, 2.195372e-01, 2.195562e-01, 2.195750e-01, 2.195940e-01, 2.196129e-01,
    2.196318e-01, 2.196507e-01, 2.196696e-01, 2.196885e-01, 2.197074e-01, 2.197263e-01,
    2.197452e-01, 2.197641e-01, 2.197830e-01, 2.198019e-01, 2.198208e-01, 2.198397e-01,
    2.198586e-01, 2.198775e-01, 2.198964e-01, 2.199153e-01, 2.199342e-01, 2.199531e-01,
    2.199720e-01, 2.199909e-01, 2.200098e-01, 2.200287e-01, 2.200476e-01, 2.200665e-01,
    2.200854e-01, 2.201043e-01, 2.201232e-01, 2.201421e-01, 2.201610e-01, 2.201799e-01,
    2.201988e-01, 2.202177e-01, 2.202366e-01, 2.202555e-01, 2.202744e-01, 2.202933e-01,
    2.203122e-01, 2.203311e-01, 2.203500e-01, 2.203689e-01, 2.203878e-01, 2.204067e-01,
    2.204256e-01, 2.204445e-01, 2.204634e-01, 2.204822e-01, 2.205012e-01, 2.205200e-01,
    2.205389e-01, 2.205578e-01, 2.205767e-01, 2.205956e-01, 2.206145e-01, 2.206334e-01,
    2.206523e-01, 2.206712e-01, 2.206901e-01, 2.207090e-01, 2.207278e-01, 2.207467e-01,
    2.207656e-01, 2.207845e-01, 2.208034e-01, 2.208223e-01, 2.208412e-01, 2.208601e-01,
    2.208790e-01, 2.208979e-01, 2.209167e-01, 2.209356e-01, 2.209545e-01, 2.209734e-01,
    2.209923e-01, 2.210112e-01, 2.210301e-01, 2.210490e-01, 2.210678e-01, 2.210867e-01,
    2.211056e-01, 2.211245e-01, 2.211434e-01, 2.211623e-01, 2.211811e-01, 2.212000e-01,
    2.212189e-01, 2.212378e-01, 2.212567e-01, 2.212756e-01, 2.212945e-01, 2.213133e-01,
    2.213322e-01, 2.213511e-01, 2.213700e-01, 2.213889e-01, 2.214078e-01, 2.214266e-01,
    2.214455e-01, 2.214644e-01, 2.214833e-01, 2.215022e-01, 2.215210e-01, 2.215399e-01,
    2.215588e-01, 2.215777e-01, 2.215966e-01, 2.216154e-01, 2.216343e-01, 2.216532e-01,
    2.216721e-01, 2.216910e-01, 2.217098e-01, 2.217287e-01, 2.217476e-01, 2.217665e-01,
    2.217853e-01, 2.218042e-01, 2.218231e-01, 2.218420e-01, 2.218608e-01, 2.218797e-01,
    2.218986e-01, 2.219175e-01, 2.219363e-01, 2.219552e-01, 2.219741e-01, 2.219930e-01,
    2.220118e-01, 2.220307e-01, 2.220496e-01, 2.220685e-01, 2.220873e-01, 2.221062e-01,
    2.221251e-01, 2.221439e-01, 2.221628e-01, 2.221817e-01, 2.222006e-01, 2.222195e-01,
    2.222383e-01, 2.222572e-01, 2.222760e-01, 2.222949e-01, 2.223138e-01, 2.223327e-01,
    2.223515e-01, 2.223704e-01, 2.223893e-01, 2.224081e-01, 2.224270e-01, 2.224459e-01,
    2.224647e-01, 2.224836e-01, 2.225025e-01, 2.225213e-01, 2.225402e-01, 2.225591e-01,
    2.225779e-01, 2.225968e-01, 2.226157e-01, 2.226346e-01, 2.226534e-01, 2.226723e-01,
    2.226911e-01, 2.227100e-01, 2.227289e-01, 2.227477e-01, 2.227666e-01, 2.227855e-01,
    2.228043e-01, 2.228232e-01, 2.228421e-01, 2.228609e-01, 2.228798e-01, 2.228986e-01,
    2.229175e-01, 2.229364e-01, 2.229552e-01, 2.229741e-01, 2.229930e-01, 2.230118e-01,
    2.230307e-01, 2.230496e-01, 2.230684e-01, 2.230873e-01, 2.231061e-01, 2.231250e-01,
    2.231438e-01, 2.231627e-01, 2.231816e-01, 2.232004e-01, 2.232193e-01, 2.232381e-01,
    2.232570e-01, 2.232759e-01, 2.232947e-01, 2.233136e-01, 2.233324e-01, 2.233513e-01,
    2.233701e-01, 2.233890e-01, 2.234078e-01, 2.234267e-01, 2.234455e-01, 2.234644e-01,
    2.234833e-01, 2.235021e-01, 2.235210e-01, 2.235398e-01, 2.235587e-01, 2.235775e-01,
    2.235964e-01, 2.236152e-01, 2.236341e-01, 2.236529e-01, 2.236718e-01, 2.236907e-01,
    2.237095e-01, 2.237284e-01, 2.237472e-01, 2.237660e-01, 2.237849e-01, 2.238038e-01,
    2.238226e-01, 2.238415e-01, 2.238603e-01, 2.238792e-01, 2.238980e-01, 2.239169e-01,
    2.239357e-01, 2.239546e-01, 2.239734e-01, 2.239922e-01, 2.240111e-01, 2.240300e-01,
    2.240488e-01, 2.240676e-01, 2.240865e-01, 2.241053e-01, 2.241242e-01, 2.241430e-01,
    2.241619e-01, 2.241807e-01, 2.241996e-01, 2.242184e-01, 2.242373e-01, 2.242561e-01,
    2.242749e-01, 2.242938e-01, 2.243126e-01, 2.243315e-01, 2.243503e-01, 2.243692e-01,
    2.243880e-01, 2.244069e-01, 2.244257e-01, 2.244445e-01, 2.244634e-01, 2.244822e-01,
    2.245011e-01, 2.245199e-01, 2.245387e-01, 2.245576e-01, 2.245764e-01, 2.245953e-01,
    2.246141e-01, 2.246329e-01, 2.246518e-01, 2.246706e-01, 2.246895e-01, 2.247083e-01,
    2.247271e-01, 2.247460e-01, 2.247648e-01, 2.247836e-01, 2.248025e-01, 2.248213e-01,
    2.248402e-01, 2.248590e-01, 2.248778e-01, 2.248967e-01, 2.249155e-01, 2.249343e-01,
    2.249532e-01, 2.249720e-01, 2.249908e-01, 2.250097e-01, 2.250285e-01, 2.250474e-01,
    2.250662e-01, 2.250850e-01, 2.251039e-01, 2.251227e-01, 2.251415e-01, 2.251603e-01,
    2.251792e-01, 2.251980e-01, 2.252169e-01, 2.252357e-01, 2.252545e-01, 2.252733e-01,
    2.252922e-01, 2.253110e-01, 2.253298e-01, 2.253487e-01, 2.253675e-01, 2.253863e-01,
    2.254052e-01, 2.254240e-01, 2.254428e-01, 2.254616e-01, 2.254805e-01, 2.254993e-01,
    2.255181e-01, 2.255370e-01, 2.255558e-01, 2.255746e-01, 2.255934e-01, 2.256123e-01,
    2.256311e-01, 2.256499e-01, 2.256688e-01, 2.256876e-01, 2.257064e-01, 2.257252e-01,
    2.257441e-01, 2.257629e-01, 2.257817e-01, 2.258005e-01, 2.258193e-01, 2.258382e-01,
    2.258570e-01, 2.258758e-01, 2.258947e-01, 2.259135e-01, 2.259323e-01, 2.259511e-01,
    2.259699e-01, 2.259887e-01, 2.260076e-01, 2.260264e-01, 2.260452e-01, 2.260640e-01,
    2.260829e-01, 2.261017e-01, 2.261205e-01, 2.261393e-01, 2.261582e-01, 2.261770e-01,
    2.261958e-01, 2.262146e-01, 2.262334e-01, 2.262522e-01, 2.262711e-01, 2.262899e-01,
    2.263087e-01, 2.263275e-01, 2.263463e-01, 2.263651e-01, 2.263840e-01, 2.264028e-01,
    2.264216e-01, 2.264404e-01, 2.264592e-01, 2.264780e-01, 2.264969e-01, 2.265157e-01,
    2.265345e-01, 2.265533e-01, 2.265721e-01, 2.265909e-01, 2.266098e-01, 2.266286e-01,
    2.266474e-01, 2.266662e-01, 2.266850e-01, 2.267038e-01, 2.267226e-01, 2.267414e-01,
    2.267603e-01, 2.267791e-01, 2.267979e-01, 2.268167e-01, 2.268355e-01, 2.268543e-01,
    2.268731e-01, 2.268919e-01, 2.269108e-01, 2.269296e-01, 2.269484e-01, 2.269672e-01,
    2.269860e-01, 2.270048e-01, 2.270236e-01, 2.270424e-01, 2.270612e-01, 2.270800e-01,
    2.270988e-01, 2.271176e-01, 2.271364e-01, 2.271552e-01, 2.271741e-01, 2.271929e-01,
    2.272117e-01, 2.272305e-01, 2.272493e-01, 2.272681e-01, 2.272869e-01, 2.273057e-01,
    2.273245e-01, 2.273433e-01, 2.273621e-01, 2.273809e-01, 2.273997e-01, 2.274185e-01,
    2.274373e-01, 2.274561e-01, 2.274749e-01, 2.274937e-01, 2.275125e-01, 2.275313e-01,
    2.275501e-01, 2.275690e-01, 2.275877e-01, 2.276065e-01, 2.276253e-01, 2.276441e-01,
    2.276629e-01, 2.276817e-01, 2.277005e-01, 2.277194e-01, 2.277381e-01, 2.277569e-01,
    2.277757e-01, 2.277945e-01, 2.278133e-01, 2.278321e-01, 2.278509e-01, 2.278697e-01,
    2.278885e-01, 2.279073e-01, 2.279261e-01, 2.279449e-01, 2.279637e-01, 2.279825e-01,
    2.280013e-01, 2.280201e-01, 2.280389e-01, 2.280577e-01, 2.280765e-01, 2.280953e-01,
    2.281141e-01, 2.281329e-01, 2.281517e-01, 2.281705e-01, 2.281892e-01, 2.282080e-01,
    2.282268e-01, 2.282456e-01, 2.282644e-01, 2.282832e-01, 2.283020e-01, 2.283208e-01,
    2.283396e-01, 2.283584e-01, 2.283772e-01, 2.283960e-01, 2.284148e-01, 2.284335e-01,
    2.284523e-01, 2.284711e-01, 2.284899e-01, 2.285087e-01, 2.285275e-01, 2.285463e-01,
    2.285651e-01, 2.285839e-01, 2.286026e-01, 2.286214e-01, 2.286402e-01, 2.286590e-01,
    2.286778e-01, 2.286966e-01, 2.287154e-01, 2.287342e-01, 2.287529e-01, 2.287717e-01,
    2.287905e-01, 2.288093e-01, 2.288281e-01, 2.288469e-01, 2.288657e-01, 2.288844e-01,
    2.289032e-01, 2.289220e-01, 2.289408e-01, 2.289596e-01, 2.289784e-01, 2.289971e-01,
    2.290159e-01, 2.290347e-01, 2.290535e-01, 2.290723e-01, 2.290910e-01, 2.291098e-01,
    2.291286e-01, 2.291474e-01, 2.291662e-01, 2.291850e-01, 2.292037e-01, 2.292225e-01,
    2.292413e-01, 2.292601e-01, 2.292788e-01, 2.292976e-01, 2.293164e-01, 2.293352e-01,
    2.293539e-01, 2.293727e-01, 2.293915e-01, 2.294103e-01, 2.294291e-01, 2.294479e-01,
    2.294666e-01, 2.294854e-01, 2.295042e-01, 2.295229e-01, 2.295417e-01, 2.295605e-01,
    2.295793e-01, 2.295981e-01, 2.296168e-01, 2.296356e-01, 2.296544e-01, 2.296732e-01,
    2.296919e-01, 2.297107e-01, 2.297295e-01, 2.297482e-01, 2.297670e-01, 2.297858e-01,
    2.298046e-01, 2.298233e-01, 2.298421e-01, 2.298609e-01, 2.298797e-01, 2.298984e-01,
    2.299172e-01, 2.299360e-01, 2.299547e-01, 2.299735e-01, 2.299923e-01, 2.300111e-01,
    2.300298e-01, 2.300486e-01, 2.300674e-01, 2.300861e-01, 2.301049e-01, 2.301237e-01,
    2.301424e-01, 2.301612e-01, 2.301800e-01, 2.301987e-01, 2.302175e-01, 2.302363e-01,
    2.302550e-01, 2.302738e-01, 2.302926e-01, 2.303113e-01, 2.303301e-01, 2.303489e-01,
    2.303676e-01, 2.303864e-01, 2.304052e-01, 2.304239e-01, 2.304427e-01, 2.304615e-01,
    2.304802e-01, 2.304990e-01, 2.305177e-01, 2.305365e-01, 2.305553e-01, 2.305740e-01,
    2.305928e-01, 2.306116e-01, 2.306303e-01, 2.306491e-01, 2.306678e-01, 2.306866e-01,
    2.307054e-01, 2.307241e-01, 2.307429e-01, 2.307616e-01, 2.307804e-01, 2.307992e-01,
    2.308179e-01, 2.308367e-01, 2.308554e-01, 2.308742e-01, 2.308929e-01, 2.309117e-01,
    2.309305e-01, 2.309492e-01, 2.309680e-01, 2.309867e-01, 2.310055e-01, 2.310243e-01,
    2.310430e-01, 2.310618e-01, 2.310805e-01, 2.310993e-01, 2.311180e-01, 2.311368e-01,
    2.311555e-01, 2.311743e-01, 2.311931e-01, 2.312118e-01, 2.312306e-01, 2.312493e-01,
    2.312681e-01, 2.312868e-01, 2.313056e-01, 2.313243e-01, 2.313431e-01, 2.313618e-01,
    2.313806e-01, 2.313993e-01, 2.314181e-01, 2.314368e-01, 2.314556e-01, 2.314743e-01,
    2.314931e-01, 2.315118e-01, 2.315306e-01, 2.315493e-01, 2.315681e-01, 2.315868e-01,
    2.316056e-01, 2.316243e-01, 2.316431e-01, 2.316618e-01, 2.316806e-01, 2.316993e-01,
    2.317181e-01, 2.317368e-01, 2.317556e-01, 2.317743e-01, 2.317931e-01, 2.318118e-01,
    2.318306e-01, 2.318493e-01, 2.318680e-01, 2.318868e-01, 2.319055e-01, 2.319243e-01,
    2.319430e-01, 2.319618e-01, 2.319805e-01, 2.319993e-01, 2.320180e-01, 2.320367e-01,
    2.320555e-01, 2.320742e-01, 2.320930e-01, 2.321117e-01, 2.321305e-01, 2.321492e-01,
    2.321679e-01, 2.321867e-01, 2.322054e-01, 2.322242e-01, 2.322429e-01, 2.322616e-01,
    2.322804e-01, 2.322991e-01, 2.323179e-01, 2.323366e-01, 2.323553e-01, 2.323741e-01,
    2.323928e-01, 2.324115e-01, 2.324303e-01, 2.324490e-01, 2.324678e-01, 2.324865e-01,
    2.325052e-01, 2.325240e-01, 2.325427e-01, 2.325615e-01, 2.325802e-01, 2.325989e-01,
    2.326177e-01, 2.326364e-01, 2.326551e-01, 2.326739e-01, 2.326926e-01, 2.327113e-01,
    2.327301e-01, 2.327488e-01, 2.327675e-01, 2.327863e-01, 2.328050e-01, 2.328237e-01,
    2.328425e-01, 2.328612e-01, 2.328799e-01, 2.328987e-01, 2.329174e-01, 2.329361e-01,
    2.329549e-01, 2.329736e-01, 2.329923e-01, 2.330111e-01, 2.330298e-01, 2.330485e-01,
    2.330673e-01, 2.330860e-01, 2.331047e-01, 2.331235e-01, 2.331422e-01, 2.331609e-01,
    2.331796e-01, 2.331983e-01, 2.332171e-01, 2.332358e-01, 2.332545e-01, 2.332733e-01,
    2.332920e-01, 2.333107e-01, 2.333294e-01, 2.333482e-01, 2.333669e-01, 2.333856e-01,
    2.334043e-01, 2.334231e-01, 2.334418e-01, 2.334605e-01, 2.334792e-01, 2.334980e-01,
    2.335167e-01, 2.335354e-01, 2.335541e-01, 2.335729e-01, 2.335916e-01, 2.336103e-01,
    2.336290e-01, 2.336478e-01, 2.336665e-01, 2.336852e-01, 2.337039e-01, 2.337226e-01,
    2.337414e-01, 2.337601e-01, 2.337788e-01, 2.337975e-01, 2.338163e-01, 2.338350e-01,
    2.338537e-01, 2.338724e-01, 2.338911e-01, 2.339098e-01, 2.339286e-01, 2.339473e-01,
    2.339660e-01, 2.339847e-01, 2.340034e-01, 2.340222e-01, 2.340409e-01, 2.340596e-01,
    2.340783e-01, 2.340970e-01, 2.341157e-01, 2.341345e-01, 2.341532e-01, 2.341719e-01,
    2.341906e-01, 2.342093e-01, 2.342280e-01, 2.342468e-01, 2.342655e-01, 2.342842e-01,
    2.343029e-01, 2.343216e-01, 2.343403e-01, 2.343590e-01, 2.343777e-01, 2.343965e-01,
    2.344152e-01, 2.344339e-01, 2.344526e-01, 2.344713e-01, 2.344900e-01, 2.345087e-01,
    2.345274e-01, 2.345462e-01, 2.345649e-01, 2.345836e-01, 2.346023e-01, 2.346210e-01,
    2.346397e-01, 2.346584e-01, 2.346771e-01, 2.346958e-01, 2.347146e-01, 2.347333e-01,
    2.347520e-01, 2.347707e-01, 2.347894e-01, 2.348081e-01, 2.348268e-01, 2.348455e-01,
    2.348642e-01, 2.348829e-01, 2.349016e-01, 2.349203e-01, 2.349390e-01, 2.349577e-01,
    2.349764e-01, 2.349951e-01, 2.350138e-01, 2.350325e-01, 2.350512e-01, 2.350699e-01,
    2.350886e-01, 2.351074e-01, 2.351261e-01, 2.351448e-01, 2.351635e-01, 2.351822e-01,
    2.352009e-01, 2.352196e-01, 2.352383e-01, 2.352570e-01, 2.352757e-01, 2.352944e-01,
    2.353131e-01, 2.353318e-01, 2.353505e-01, 2.353692e-01, 2.353879e-01, 2.354066e-01,
    2.354253e-01, 2.354440e-01, 2.354627e-01, 2.354814e-01, 2.355001e-01, 2.355188e-01,
    2.355375e-01, 2.355562e-01, 2.355749e-01, 2.355936e-01, 2.356123e-01, 2.356310e-01,
    2.356497e-01, 2.356684e-01, 2.356870e-01, 2.357057e-01, 2.357244e-01, 2.357431e-01,
    2.357618e-01, 2.357805e-01, 2.357992e-01, 2.358179e-01, 2.358366e-01, 2.358553e-01,
    2.358740e-01, 2.358927e-01, 2.359114e-01, 2.359301e-01, 2.359488e-01, 2.359675e-01,
    2.359861e-01, 2.360048e-01, 2.360235e-01, 2.360422e-01, 2.360609e-01, 2.360796e-01,
    2.360983e-01, 2.361170e-01, 2.361357e-01, 2.361544e-01, 2.361731e-01, 2.361917e-01,
    2.362104e-01, 2.362291e-01, 2.362478e-01, 2.362665e-01, 2.362852e-01, 2.363039e-01,
    2.363226e-01, 2.363413e-01, 2.363600e-01, 2.363786e-01, 2.363973e-01, 2.364160e-01,
    2.364347e-01, 2.364534e-01, 2.364721e-01, 2.364907e-01, 2.365094e-01, 2.365281e-01,
    2.365468e-01, 2.365655e-01, 2.365842e-01, 2.366029e-01, 2.366215e-01, 2.366402e-01,
    2.366589e-01, 2.366776e-01, 2.366963e-01, 2.367150e-01, 2.367336e-01, 2.367523e-01,
    2.367710e-01, 2.367897e-01, 2.368084e-01, 2.368271e-01, 2.368457e-01, 2.368644e-01,
    2.368831e-01, 2.369018e-01, 2.369205e-01, 2.369391e-01, 2.369578e-01, 2.369765e-01,
    2.369952e-01, 2.370138e-01, 2.370325e-01, 2.370512e-01, 2.370699e-01, 2.370885e-01,
    2.371072e-01, 2.371259e-01, 2.371446e-01, 2.371633e-01, 2.371819e-01, 2.372006e-01,
    2.372193e-01, 2.372380e-01, 2.372566e-01, 2.372753e-01, 2.372940e-01, 2.373127e-01,
    2.373313e-01, 2.373500e-01, 2.373687e-01, 2.373874e-01, 2.374061e-01, 2.374247e-01,
    2.374434e-01, 2.374621e-01, 2.374807e-01, 2.374994e-01, 2.375181e-01, 2.375368e-01,
    2.375554e-01, 2.375741e-01, 2.375928e-01, 2.376114e-01, 2.376301e-01, 2.376488e-01,
    2.376674e-01, 2.376861e-01, 2.377048e-01, 2.377235e-01, 2.377421e-01, 2.377608e-01,
    2.377795e-01, 2.377981e-01, 2.378168e-01, 2.378355e-01, 2.378541e-01, 2.378728e-01,
    2.378915e-01, 2.379101e-01, 2.379288e-01, 2.379475e-01, 2.379661e-01, 2.379848e-01,
    2.380035e-01, 2.380221e-01, 2.380408e-01, 2.380595e-01, 2.380781e-01, 2.380968e-01,
    2.381155e-01, 2.381341e-01, 2.381528e-01, 2.381715e-01, 2.381901e-01, 2.382088e-01,
    2.382274e-01, 2.382461e-01, 2.382648e-01, 2.382834e-01, 2.383021e-01, 2.383208e-01,
    2.383394e-01, 2.383581e-01, 2.383768e-01, 2.383954e-01, 2.384141e-01, 2.384327e-01,
    2.384514e-01, 2.384700e-01, 2.384887e-01, 2.385074e-01, 2.385260e-01, 2.385447e-01,
    2.385633e-01, 2.385820e-01, 2.386007e-01, 2.386193e-01, 2.386380e-01, 2.386566e-01,
    2.386753e-01, 2.386940e-01, 2.387126e-01, 2.387313e-01, 2.387499e-01, 2.387686e-01,
    2.387872e-01, 2.388059e-01, 2.388245e-01, 2.388432e-01, 2.388618e-01, 2.388805e-01,
    2.388992e-01, 2.389178e-01, 2.389365e-01, 2.389551e-01, 2.389738e-01, 2.389924e-01,
    2.390111e-01, 2.390297e-01, 2.390484e-01, 2.390670e-01, 2.390857e-01, 2.391043e-01,
    2.391230e-01, 2.391416e-01, 2.391603e-01, 2.391790e-01, 2.391976e-01, 2.392163e-01,
    2.392349e-01, 2.392536e-01, 2.392722e-01, 2.392908e-01, 2.393095e-01, 2.393282e-01,
    2.393468e-01, 2.393655e-01, 2.393841e-01, 2.394027e-01, 2.394214e-01, 2.394400e-01,
    2.394587e-01, 2.394773e-01, 2.394960e-01, 2.395146e-01, 2.395333e-01, 2.395519e-01,
    2.395706e-01, 2.395892e-01, 2.396078e-01, 2.396265e-01, 2.396451e-01, 2.396638e-01,
    2.396824e-01, 2.397011e-01, 2.397197e-01, 2.397384e-01, 2.397570e-01, 2.397757e-01,
    2.397943e-01, 2.398129e-01, 2.398316e-01, 2.398502e-01, 2.398689e-01, 2.398875e-01,
    2.399061e-01, 2.399248e-01, 2.399434e-01, 2.399621e-01, 2.399807e-01, 2.399993e-01,
    2.400180e-01, 2.400366e-01, 2.400553e-01, 2.400739e-01, 2.400925e-01, 2.401112e-01,
    2.401298e-01, 2.401485e-01, 2.401671e-01, 2.401857e-01, 2.402044e-01, 2.402230e-01,
    2.402416e-01, 2.402603e-01, 2.402789e-01, 2.402976e-01, 2.403162e-01, 2.403348e-01,
    2.403535e-01, 2.403721e-01, 2.403907e-01, 2.404094e-01, 2.404280e-01, 2.404466e-01,
    2.404653e-01, 2.404839e-01, 2.405025e-01, 2.405212e-01, 2.405398e-01, 2.405584e-01,
    2.405771e-01, 2.405957e-01, 2.406144e-01, 2.406330e-01, 2.406516e-01, 2.406702e-01,
    2.406889e-01, 2.407075e-01, 2.407261e-01, 2.407448e-01, 2.407634e-01, 2.407820e-01,
    2.408006e-01, 2.408193e-01, 2.408379e-01, 2.408565e-01, 2.408752e-01, 2.408938e-01,
    2.409124e-01, 2.409310e-01, 2.409497e-01, 2.409683e-01, 2.409869e-01, 2.410056e-01,
    2.410242e-01, 2.410428e-01, 2.410614e-01, 2.410801e-01, 2.410987e-01, 2.411173e-01,
    2.411360e-01, 2.411546e-01, 2.411732e-01, 2.411918e-01, 2.412104e-01, 2.412291e-01,
    2.412477e-01, 2.412663e-01, 2.412849e-01, 2.413036e-01, 2.413222e-01, 2.413408e-01,
    2.413594e-01, 2.413781e-01, 2.413967e-01, 2.414153e-01, 2.414339e-01, 2.414525e-01,
    2.414712e-01, 2.414898e-01, 2.415084e-01, 2.415270e-01, 2.415456e-01, 2.415643e-01,
    2.415829e-01, 2.416015e-01, 2.416201e-01, 2.416387e-01, 2.416574e-01, 2.416760e-01,
    2.416946e-01, 2.417132e-01, 2.417318e-01, 2.417504e-01, 2.417691e-01, 2.417877e-01,
    2.418063e-01, 2.418249e-01, 2.418435e-01, 2.418621e-01, 2.418808e-01, 2.418994e-01,
    2.419180e-01, 2.419366e-01, 2.419552e-01, 2.419738e-01, 2.419925e-01, 2.420111e-01,
    2.420297e-01, 2.420483e-01, 2.420669e-01, 2.420855e-01, 2.421041e-01, 2.421227e-01,
    2.421414e-01, 2.421600e-01, 2.421786e-01, 2.421972e-01, 2.422158e-01, 2.422344e-01,
    2.422530e-01, 2.422716e-01, 2.422903e-01, 2.423089e-01, 2.423275e-01, 2.423461e-01,
    2.423647e-01, 2.423833e-01, 2.424019e-01, 2.424205e-01, 2.424391e-01, 2.424577e-01,
    2.424763e-01, 2.424950e-01, 2.425136e-01, 2.425322e-01, 2.425508e-01, 2.425694e-01,
    2.425880e-01, 2.426066e-01, 2.426252e-01, 2.426438e-01, 2.426624e-01, 2.426810e-01,
    2.426996e-01, 2.427182e-01, 2.427368e-01, 2.427554e-01, 2.427740e-01, 2.427927e-01,
    2.428112e-01, 2.428298e-01, 2.428485e-01, 2.428671e-01, 2.428857e-01, 2.429043e-01,
    2.429229e-01, 2.429415e-01, 2.429601e-01, 2.429787e-01, 2.429973e-01, 2.430159e-01,
    2.430345e-01, 2.430531e-01, 2.430717e-01, 2.430903e-01, 2.431089e-01, 2.431275e-01,
    2.431461e-01, 2.431647e-01, 2.431833e-01, 2.432019e-01, 2.432205e-01, 2.432391e-01,
    2.432577e-01, 2.432763e-01, 2.432949e-01, 2.433135e-01, 2.433321e-01, 2.433507e-01,
    2.433693e-01, 2.433878e-01, 2.434064e-01, 2.434250e-01, 2.434436e-01, 2.434622e-01,
    2.434808e-01, 2.434994e-01, 2.435180e-01, 2.435366e-01, 2.435552e-01, 2.435738e-01,
    2.435924e-01, 2.436110e-01, 2.436296e-01, 2.436482e-01, 2.436668e-01, 2.436854e-01,
    2.437039e-01, 2.437225e-01, 2.437411e-01, 2.437597e-01, 2.437783e-01, 2.437969e-01,
    2.438155e-01, 2.438341e-01, 2.438527e-01, 2.438713e-01, 2.438899e-01, 2.439085e-01,
    2.439271e-01, 2.439456e-01, 2.439642e-01, 2.439828e-01, 2.440014e-01, 2.440200e-01,
    2.440386e-01, 2.440572e-01, 2.440758e-01, 2.440944e-01, 2.441129e-01, 2.441315e-01,
    2.441501e-01, 2.441687e-01, 2.441873e-01, 2.442059e-01, 2.442245e-01, 2.442430e-01,
    2.442616e-01, 2.442802e-01, 2.442988e-01, 2.443174e-01, 2.443360e-01, 2.443545e-01,
    2.443731e-01, 2.443917e-01, 2.444103e-01, 2.444289e-01, 2.444475e-01, 2.444661e-01,
    2.444846e-01, 2.445032e-01, 2.445218e-01, 2.445404e-01, 2.445589e-01, 2.445775e-01,
    2.445961e-01, 2.446147e-01, 2.446333e-01, 2.446519e-01, 2.446704e-01, 2.446890e-01,
    2.447076e-01, 2.447262e-01, 2.447447e-01, 2.447633e-01, 2.447819e-01, 2.448005e-01,
    2.448191e-01, 2.448376e-01, 2.448562e-01, 2.448748e-01, 2.448934e-01, 2.449120e-01,
    2.449305e-01, 2.449491e-01, 2.449677e-01, 2.449863e-01, 2.450048e-01, 2.450234e-01,
    2.450420e-01, 2.450605e-01, 2.450791e-01, 2.450977e-01, 2.451163e-01, 2.451348e-01,
    2.451534e-01, 2.451720e-01, 2.451906e-01, 2.452091e-01, 2.452277e-01, 2.452463e-01,
    2.452649e-01, 2.452834e-01, 2.453020e-01, 2.453206e-01, 2.453392e-01, 2.453577e-01,
    2.453763e-01, 2.453949e-01, 2.454134e-01, 2.454320e-01, 2.454506e-01, 2.454691e-01,
    2.454877e-01, 2.455063e-01, 2.455249e-01, 2.455434e-01, 2.455620e-01, 2.455806e-01,
    2.455991e-01, 2.456177e-01, 2.456363e-01, 2.456548e-01, 2.456734e-01, 2.456920e-01,
    2.457105e-01, 2.457291e-01, 2.457477e-01, 2.457662e-01, 2.457848e-01, 2.458034e-01,
    2.458219e-01, 2.458405e-01, 2.458590e-01, 2.458776e-01, 2.458962e-01, 2.459147e-01,
    2.459333e-01, 2.459519e-01, 2.459704e-01, 2.459890e-01, 2.460075e-01, 2.460261e-01,
    2.460447e-01, 2.460632e-01, 2.460818e-01, 2.461004e-01, 2.461189e-01, 2.461375e-01,
    2.461561e-01, 2.461746e-01, 2.461932e-01, 2.462117e-01, 2.462303e-01, 2.462489e-01,
    2.462674e-01, 2.462860e-01, 2.463045e-01, 2.463231e-01, 2.463416e-01, 2.463602e-01,
    2.463787e-01, 2.463973e-01, 2.464159e-01, 2.464344e-01, 2.464530e-01, 2.464716e-01,
    2.464901e-01, 2.465087e-01, 2.465272e-01, 2.465458e-01, 2.465643e-01, 2.465829e-01,
    2.466014e-01, 2.466200e-01, 2.466386e-01, 2.466571e-01, 2.466757e-01, 2.466942e-01,
    2.467128e-01, 2.467313e-01, 2.467499e-01, 2.467684e-01, 2.467870e-01, 2.468055e-01,
    2.468241e-01, 2.468426e-01, 2.468612e-01, 2.468797e-01, 2.468983e-01, 2.469168e-01,
    2.469354e-01, 2.469539e-01, 2.469725e-01, 2.469910e-01, 2.470096e-01, 2.470281e-01,
    2.470467e-01, 2.470652e-01, 2.470838e-01, 2.471023e-01, 2.471209e-01, 2.471394e-01,
    2.471580e-01, 2.471765e-01, 2.471951e-01, 2.472136e-01, 2.472322e-01, 2.472507e-01,
    2.472693e-01, 2.472878e-01, 2.473064e-01, 2.473249e-01, 2.473435e-01, 2.473620e-01,
    2.473805e-01, 2.473991e-01, 2.474176e-01, 2.474362e-01, 2.474547e-01, 2.474733e-01,
    2.474918e-01, 2.475104e-01, 2.475289e-01, 2.475474e-01, 2.475660e-01, 2.475845e-01,
    2.476031e-01, 2.476216e-01, 2.476401e-01, 2.476587e-01, 2.476772e-01, 2.476958e-01,
    2.477143e-01, 2.477329e-01, 2.477514e-01, 2.477699e-01, 2.477885e-01, 2.478070e-01,
    2.478256e-01, 2.478441e-01, 2.478626e-01, 2.478812e-01, 2.478997e-01, 2.479182e-01,
    2.479368e-01, 2.479553e-01, 2.479738e-01, 2.479924e-01, 2.480109e-01, 2.480295e-01,
    2.480480e-01, 2.480665e-01, 2.480851e-01, 2.481036e-01, 2.481221e-01, 2.481407e-01,
    2.481592e-01, 2.481778e-01, 2.481963e-01, 2.482148e-01, 2.482333e-01, 2.482519e-01,
    2.482704e-01, 2.482890e-01, 2.483075e-01, 2.483260e-01, 2.483446e-01, 2.483631e-01,
    2.483816e-01, 2.484002e-01, 2.484187e-01, 2.484372e-01, 2.484557e-01, 2.484743e-01,
    2.484928e-01, 2.485113e-01, 2.485299e-01, 2.485484e-01, 2.485669e-01, 2.485855e-01,
    2.486040e-01, 2.486225e-01, 2.486410e-01, 2.486596e-01, 2.486781e-01, 2.486966e-01,
    2.487152e-01, 2.487337e-01, 2.487522e-01, 2.487707e-01, 2.487893e-01, 2.488078e-01,
    2.488263e-01, 2.488449e-01, 2.488634e-01, 2.488819e-01, 2.489004e-01, 2.489190e-01,
    2.489375e-01, 2.489560e-01, 2.489745e-01, 2.489930e-01, 2.490116e-01, 2.490301e-01,
    2.490486e-01, 2.490671e-01, 2.490857e-01, 2.491042e-01, 2.491227e-01, 2.491412e-01,
    2.491598e-01, 2.491783e-01, 2.491968e-01, 2.492153e-01, 2.492338e-01, 2.492524e-01,
    2.492709e-01, 2.492894e-01, 2.493079e-01, 2.493265e-01, 2.493450e-01, 2.493635e-01,
    2.493820e-01, 2.494005e-01, 2.494190e-01, 2.494376e-01, 2.494561e-01, 2.494746e-01,
    2.494931e-01, 2.495116e-01, 2.495301e-01, 2.495487e-01, 2.495672e-01, 2.495857e-01,
    2.496042e-01, 2.496227e-01, 2.496412e-01, 2.496598e-01, 2.496783e-01, 2.496968e-01,
    2.497153e-01, 2.497338e-01, 2.497523e-01, 2.497708e-01, 2.497894e-01, 2.498079e-01,
    2.498264e-01, 2.498449e-01, 2.498634e-01, 2.498819e-01, 2.499004e-01, 2.499190e-01,
    2.499375e-01, 2.499560e-01, 2.499745e-01, 2.499930e-01, 2.500115e-01, 2.500300e-01,
    2.500485e-01, 2.500671e-01, 2.500856e-01, 2.501041e-01, 2.501226e-01, 2.501411e-01,
    2.501596e-01, 2.501781e-01, 2.501966e-01, 2.502151e-01, 2.502337e-01, 2.502522e-01,
    2.502707e-01, 2.502892e-01, 2.503077e-01, 2.503262e-01, 2.503447e-01, 2.503632e-01,
    2.503817e-01, 2.504002e-01, 2.504187e-01, 2.504372e-01, 2.504557e-01, 2.504742e-01,
    2.504927e-01, 2.505112e-01, 2.505297e-01, 2.505482e-01, 2.505668e-01, 2.505853e-01,
    2.506038e-01, 2.506222e-01, 2.506407e-01, 2.506593e-01, 2.506778e-01, 2.506963e-01,
    2.507148e-01, 2.507333e-01, 2.507518e-01, 2.507703e-01, 2.507888e-01, 2.508073e-01,
    2.508258e-01, 2.508443e-01, 2.508628e-01, 2.508813e-01, 2.508998e-01, 2.509183e-01,
    2.509368e-01, 2.509553e-01, 2.509738e-01, 2.509923e-01, 2.510108e-01, 2.510293e-01,
    2.510478e-01, 2.510663e-01, 2.510848e-01, 2.511033e-01, 2.511218e-01, 2.511403e-01,
    2.511587e-01, 2.511773e-01, 2.511958e-01, 2.512142e-01, 2.512327e-01, 2.512513e-01,
    2.512697e-01, 2.512882e-01, 2.513067e-01, 2.513252e-01, 2.513437e-01, 2.513622e-01,
    2.513807e-01, 2.513992e-01, 2.514177e-01, 2.514362e-01, 2.514547e-01, 2.514732e-01,
    2.514916e-01, 2.515101e-01, 2.515287e-01, 2.515471e-01, 2.515656e-01, 2.515841e-01,
    2.516026e-01, 2.516211e-01, 2.516396e-01, 2.516581e-01, 2.516766e-01, 2.516951e-01,
    2.517135e-01, 2.517321e-01, 2.517505e-01, 2.517690e-01, 2.517875e-01, 2.518060e-01,
    2.518245e-01, 2.518430e-01, 2.518615e-01, 2.518799e-01, 2.518984e-01, 2.519169e-01,
    2.519354e-01, 2.519539e-01, 2.519724e-01, 2.519909e-01, 2.520093e-01, 2.520278e-01,
    2.520463e-01, 2.520648e-01, 2.520833e-01, 2.521018e-01, 2.521203e-01, 2.521387e-01,
    2.521572e-01, 2.521757e-01, 2.521942e-01, 2.522127e-01, 2.522312e-01, 2.522496e-01,
    2.522681e-01, 2.522866e-01, 2.523051e-01, 2.523236e-01, 2.523420e-01, 2.523605e-01,
    2.523790e-01, 2.523975e-01, 2.524160e-01, 2.524345e-01, 2.524529e-01, 2.524714e-01,
    2.524899e-01, 2.525084e-01, 2.525268e-01, 2.525453e-01, 2.525638e-01, 2.525823e-01,
    2.526008e-01, 2.526192e-01, 2.526377e-01, 2.526562e-01, 2.526747e-01, 2.526931e-01,
    2.527116e-01, 2.527301e-01, 2.527486e-01, 2.527671e-01, 2.527855e-01, 2.528040e-01,
    2.528225e-01, 2.528410e-01, 2.528594e-01, 2.528779e-01, 2.528964e-01, 2.529148e-01,
    2.529333e-01, 2.529518e-01, 2.529703e-01, 2.529887e-01, 2.530072e-01, 2.530257e-01,
    2.530442e-01, 2.530626e-01, 2.530811e-01, 2.530996e-01, 2.531180e-01, 2.531365e-01,
    2.531550e-01, 2.531735e-01, 2.531919e-01, 2.532104e-01, 2.532289e-01, 2.532474e-01,
    2.532658e-01, 2.532843e-01, 2.533028e-01, 2.533212e-01, 2.533397e-01, 2.533582e-01,
    2.533766e-01, 2.533951e-01, 2.534136e-01, 2.534320e-01, 2.534505e-01, 2.534690e-01,
    2.534874e-01, 2.535059e-01, 2.535244e-01, 2.535428e-01, 2.535613e-01, 2.535798e-01,
    2.535982e-01, 2.536167e-01, 2.536352e-01, 2.536536e-01, 2.536721e-01, 2.536905e-01,
    2.537090e-01, 2.537275e-01, 2.537459e-01, 2.537644e-01, 2.537829e-01, 2.538013e-01,
    2.538198e-01, 2.538382e-01, 2.538567e-01, 2.538752e-01, 2.538936e-01, 2.539121e-01,
    2.539306e-01, 2.539490e-01, 2.539675e-01, 2.539859e-01, 2.540044e-01, 2.540229e-01,
    2.540413e-01, 2.540598e-01, 2.540782e-01, 2.540967e-01, 2.541152e-01, 2.541336e-01,
    2.541521e-01, 2.541705e-01, 2.541890e-01, 2.542075e-01, 2.542259e-01, 2.542444e-01,
    2.542628e-01, 2.542813e-01, 2.542997e-01, 2.543182e-01, 2.543367e-01, 2.543551e-01,
    2.543736e-01, 2.543920e-01, 2.544105e-01, 2.544289e-01, 2.544474e-01, 2.544658e-01,
    2.544843e-01, 2.545027e-01, 2.545212e-01, 2.545397e-01, 2.545581e-01, 2.545765e-01,
    2.545950e-01, 2.546135e-01, 2.546319e-01, 2.546504e-01, 2.546688e-01, 2.546872e-01,
    2.547057e-01, 2.547242e-01, 2.547426e-01, 2.547611e-01, 2.547795e-01, 2.547980e-01,
    2.548164e-01, 2.548349e-01, 2.548533e-01, 2.548718e-01, 2.548902e-01, 2.549087e-01,
    2.549271e-01, 2.549455e-01, 2.549640e-01, 2.549824e-01, 2.550009e-01, 2.550193e-01,
    2.550378e-01, 2.550562e-01, 2.550747e-01, 2.550931e-01, 2.551116e-01, 2.551300e-01,
    2.551485e-01, 2.551669e-01, 2.551854e-01, 2.552038e-01, 2.552223e-01, 2.552407e-01,
    2.552592e-01, 2.552776e-01, 2.552960e-01, 2.553145e-01, 2.553329e-01, 2.553513e-01,
    2.553698e-01, 2.553882e-01, 2.554067e-01, 2.554251e-01, 2.554436e-01, 2.554620e-01,
    2.554804e-01, 2.554989e-01, 2.555173e-01, 2.555358e-01, 2.555542e-01, 2.555726e-01,
    2.555911e-01, 2.556095e-01, 2.556280e-01, 2.556464e-01, 2.556649e-01, 2.556833e-01,
    2.557017e-01, 2.557202e-01, 2.557386e-01, 2.557570e-01, 2.557755e-01, 2.557939e-01,
    2.558123e-01, 2.558308e-01, 2.558492e-01, 2.558677e-01, 2.558861e-01, 2.559045e-01,
    2.559230e-01, 2.559414e-01, 2.559598e-01, 2.559783e-01, 2.559967e-01, 2.560151e-01,
    2.560336e-01, 2.560520e-01, 2.560705e-01, 2.560889e-01, 2.561073e-01, 2.561257e-01,
    2.561442e-01, 2.561626e-01, 2.561810e-01, 2.561995e-01, 2.562179e-01, 2.562363e-01,
    2.562548e-01, 2.562732e-01, 2.562916e-01, 2.563101e-01, 2.563285e-01, 2.563469e-01,
    2.563654e-01, 2.563838e-01, 2.564022e-01, 2.564206e-01, 2.564391e-01, 2.564575e-01,
    2.564759e-01, 2.564943e-01, 2.565128e-01, 2.565312e-01, 2.565496e-01, 2.565681e-01,
    2.565865e-01, 2.566049e-01, 2.566234e-01, 2.566418e-01, 2.566602e-01, 2.566786e-01,
    2.566971e-01, 2.567155e-01, 2.567339e-01, 2.567523e-01, 2.567707e-01, 2.567892e-01,
    2.568076e-01, 2.568260e-01, 2.568444e-01, 2.568628e-01, 2.568813e-01, 2.568997e-01,
    2.569181e-01, 2.569366e-01, 2.569550e-01, 2.569734e-01, 2.569918e-01, 2.570103e-01,
    2.570287e-01, 2.570471e-01, 2.570655e-01, 2.570840e-01, 2.571023e-01, 2.571208e-01,
    2.571392e-01, 2.571576e-01, 2.571760e-01, 2.571944e-01, 2.572129e-01, 2.572313e-01,
    2.572497e-01, 2.572681e-01, 2.572865e-01, 2.573050e-01, 2.573234e-01, 2.573418e-01,
    2.573602e-01, 2.573786e-01, 2.573971e-01, 2.574155e-01, 2.574339e-01, 2.574523e-01,
    2.574707e-01, 2.574891e-01, 2.575075e-01, 2.575260e-01, 2.575444e-01, 2.575628e-01,
    2.575812e-01, 2.575996e-01, 2.576180e-01, 2.576364e-01, 2.576549e-01, 2.576733e-01,
    2.576917e-01, 2.577101e-01, 2.577285e-01, 2.577469e-01, 2.577654e-01, 2.577837e-01,
    2.578022e-01, 2.578206e-01, 2.578390e-01, 2.578574e-01, 2.578758e-01, 2.578942e-01,
    2.579126e-01, 2.579311e-01, 2.579494e-01, 2.579679e-01, 2.579863e-01, 2.580047e-01,
    2.580231e-01, 2.580415e-01, 2.580599e-01, 2.580783e-01, 2.580967e-01, 2.581151e-01,
    2.581335e-01, 2.581519e-01, 2.581703e-01, 2.581887e-01, 2.582072e-01, 2.582256e-01,
    2.582440e-01, 2.582624e-01, 2.582808e-01, 2.582992e-01, 2.583176e-01, 2.583360e-01,
    2.583544e-01, 2.583728e-01, 2.583912e-01, 2.584096e-01, 2.584280e-01, 2.584464e-01,
    2.584648e-01, 2.584832e-01, 2.585016e-01, 2.585200e-01, 2.585384e-01, 2.585568e-01,
    2.585752e-01, 2.585936e-01, 2.586120e-01, 2.586304e-01, 2.586488e-01, 2.586672e-01,
    2.586856e-01, 2.587040e-01, 2.587225e-01, 2.587408e-01, 2.587593e-01, 2.587776e-01,
    2.587960e-01, 2.588144e-01, 2.588328e-01, 2.588512e-01, 2.588696e-01, 2.588880e-01,
    2.589064e-01, 2.589248e-01, 2.589432e-01, 2.589616e-01, 2.589800e-01, 2.589984e-01,
    2.590168e-01, 2.590352e-01, 2.590536e-01, 2.590720e-01, 2.590904e-01, 2.591088e-01,
    2.591272e-01, 2.591456e-01, 2.591640e-01, 2.591824e-01, 2.592008e-01, 2.592191e-01,
    2.592375e-01, 2.592559e-01, 2.592743e-01, 2.592927e-01, 2.593111e-01, 2.593295e-01,
    2.593479e-01, 2.593663e-01, 2.593847e-01, 2.594031e-01, 2.594215e-01, 2.594399e-01,
    2.594582e-01, 2.594766e-01, 2.594950e-01, 2.595134e-01, 2.595318e-01, 2.595502e-01,
    2.595686e-01, 2.595870e-01, 2.596053e-01, 2.596237e-01, 2.596422e-01, 2.596605e-01,
    2.596789e-01, 2.596973e-01, 2.597157e-01, 2.597341e-01, 2.597525e-01, 2.597708e-01,
    2.597892e-01, 2.598076e-01, 2.598260e-01, 2.598444e-01, 2.598628e-01, 2.598812e-01,
    2.598995e-01, 2.599179e-01, 2.599363e-01, 2.599547e-01, 2.599731e-01, 2.599915e-01,
    2.600099e-01, 2.600282e-01, 2.600466e-01, 2.600650e-01, 2.600834e-01, 2.601018e-01,
    2.601202e-01, 2.601385e-01, 2.601569e-01, 2.601753e-01, 2.601937e-01, 2.602121e-01,
    2.602304e-01, 2.602488e-01, 2.602672e-01, 2.602856e-01, 2.603039e-01, 2.603223e-01,
    2.603407e-01, 2.603591e-01, 2.603775e-01, 2.603958e-01, 2.604142e-01, 2.604326e-01,
    2.604510e-01, 2.604693e-01, 2.604877e-01, 2.605061e-01, 2.605245e-01, 2.605429e-01,
    2.605612e-01, 2.605796e-01, 2.605980e-01, 2.606164e-01, 2.606348e-01, 2.606531e-01,
    2.606715e-01, 2.606899e-01, 2.607082e-01, 2.607266e-01, 2.607450e-01, 2.607634e-01,
    2.607817e-01, 2.608001e-01, 2.608185e-01, 2.608369e-01, 2.608552e-01, 2.608736e-01,
    2.608920e-01, 2.609103e-01, 2.609287e-01, 2.609471e-01, 2.609655e-01, 2.609838e-01,
    2.610022e-01, 2.610206e-01, 2.610389e-01, 2.610573e-01, 2.610757e-01, 2.610941e-01,
    2.611124e-01, 2.611308e-01, 2.611492e-01, 2.611675e-01, 2.611859e-01, 2.612043e-01,
    2.612226e-01, 2.612410e-01, 2.612593e-01, 2.612777e-01, 2.612961e-01, 2.613145e-01,
    2.613328e-01, 2.613512e-01, 2.613696e-01, 2.613879e-01, 2.614063e-01, 2.614247e-01,
    2.614430e-01, 2.614614e-01, 2.614798e-01, 2.614981e-01, 2.615165e-01, 2.615349e-01,
    2.615532e-01, 2.615716e-01, 2.615899e-01, 2.616083e-01, 2.616267e-01, 2.616450e-01,
    2.616634e-01, 2.616817e-01, 2.617001e-01, 2.617185e-01, 2.617368e-01, 2.617552e-01,
    2.617736e-01, 2.617919e-01, 2.618103e-01, 2.618286e-01, 2.618470e-01, 2.618653e-01,
    2.618837e-01, 2.619021e-01, 2.619205e-01, 2.619388e-01, 2.619572e-01, 2.619755e-01,
    2.619939e-01, 2.620122e-01, 2.620306e-01, 2.620490e-01, 2.620673e-01, 2.620857e-01,
    2.621040e-01, 2.621224e-01, 2.621407e-01, 2.621591e-01, 2.621774e-01, 2.621958e-01,
    2.622142e-01, 2.622325e-01, 2.622509e-01, 2.622692e-01, 2.622876e-01, 2.623059e-01,
    2.623243e-01, 2.623426e-01, 2.623610e-01, 2.623793e-01, 2.623977e-01, 2.624161e-01,
    2.624344e-01, 2.624528e-01, 2.624711e-01, 2.624895e-01, 2.625078e-01, 2.625262e-01,
    2.625445e-01, 2.625629e-01, 2.625812e-01, 2.625996e-01, 2.626179e-01, 2.626363e-01,
    2.626546e-01, 2.626730e-01, 2.626913e-01, 2.627097e-01, 2.627280e-01, 2.627464e-01,
    2.627647e-01, 2.627831e-01, 2.628014e-01, 2.628198e-01, 2.628381e-01, 2.628565e-01,
    2.628748e-01, 2.628931e-01, 2.629115e-01, 2.629298e-01, 2.629482e-01, 2.629665e-01,
    2.629849e-01, 2.630032e-01, 2.630216e-01, 2.630399e-01, 2.630582e-01, 2.630766e-01,
    2.630950e-01, 2.631133e-01, 2.631316e-01, 2.631500e-01, 2.631683e-01, 2.631867e-01,
    2.632050e-01, 2.632234e-01, 2.632417e-01, 2.632600e-01, 2.632784e-01, 2.632967e-01,
    2.633151e-01, 2.633334e-01, 2.633517e-01, 2.633701e-01, 2.633884e-01, 2.634068e-01,
    2.634251e-01, 2.634434e-01, 2.634618e-01, 2.634801e-01, 2.634985e-01, 2.635168e-01,
    2.635351e-01, 2.635535e-01, 2.635718e-01, 2.635902e-01, 2.636085e-01, 2.636268e-01,
    2.636452e-01, 2.636635e-01, 2.636818e-01, 2.637002e-01, 2.637185e-01, 2.637368e-01,
    2.637552e-01, 2.637735e-01, 2.637919e-01, 2.638102e-01, 2.638285e-01, 2.638469e-01,
    2.638652e-01, 2.638835e-01, 2.639019e-01, 2.639202e-01, 2.639385e-01, 2.639569e-01,
    2.639752e-01, 2.639935e-01, 2.640119e-01, 2.640302e-01, 2.640485e-01, 2.640668e-01,
    2.640852e-01, 2.641035e-01, 2.641218e-01, 2.641402e-01, 2.641585e-01, 2.641768e-01,
    2.641952e-01, 2.642135e-01, 2.642318e-01, 2.642502e-01, 2.642685e-01, 2.642868e-01,
    2.643051e-01, 2.643235e-01, 2.643418e-01, 2.643601e-01, 2.643785e-01, 2.643968e-01,
    2.644151e-01, 2.644334e-01, 2.644518e-01, 2.644701e-01, 2.644884e-01, 2.645067e-01,
    2.645251e-01, 2.645434e-01, 2.645617e-01, 2.645800e-01, 2.645984e-01, 2.646167e-01,
    2.646350e-01, 2.646534e-01, 2.646717e-01, 2.646900e-01, 2.647083e-01, 2.647266e-01,
    2.647450e-01, 2.647633e-01, 2.647816e-01, 2.647999e-01, 2.648183e-01, 2.648366e-01,
    2.648549e-01, 2.648732e-01, 2.648915e-01, 2.649099e-01, 2.649282e-01, 2.649465e-01,
    2.649648e-01, 2.649831e-01, 2.650015e-01, 2.650198e-01, 2.650381e-01, 2.650564e-01,
    2.650747e-01, 2.650931e-01, 2.651114e-01, 2.651297e-01, 2.651480e-01, 2.651663e-01,
    2.651846e-01, 2.652030e-01, 2.652213e-01, 2.652396e-01, 2.652579e-01, 2.652762e-01,
    2.652946e-01, 2.653129e-01, 2.653312e-01, 2.653495e-01, 2.653678e-01, 2.653861e-01,
    2.654044e-01, 2.654228e-01, 2.654411e-01, 2.654594e-01, 2.654777e-01, 2.654960e-01,
    2.655143e-01, 2.655326e-01, 2.655509e-01, 2.655693e-01, 2.655876e-01, 2.656059e-01,
    2.656242e-01, 2.656425e-01, 2.656608e-01, 2.656792e-01, 2.656974e-01, 2.657157e-01,
    2.657341e-01, 2.657524e-01, 2.657707e-01, 2.657890e-01, 2.658073e-01, 2.658256e-01,
    2.658439e-01, 2.658622e-01, 2.658806e-01, 2.658989e-01, 2.659172e-01, 2.659355e-01,
    2.659538e-01, 2.659721e-01, 2.659904e-01, 2.660087e-01, 2.660270e-01, 2.660453e-01,
    2.660636e-01, 2.660819e-01, 2.661002e-01, 2.661185e-01, 2.661369e-01, 2.661552e-01,
    2.661735e-01, 2.661918e-01, 2.662101e-01, 2.662284e-01, 2.662467e-01, 2.662650e-01,
    2.662833e-01, 2.663016e-01, 2.663199e-01, 2.663382e-01, 2.663565e-01, 2.663748e-01,
    2.663931e-01, 2.664114e-01, 2.664297e-01, 2.664480e-01, 2.664663e-01, 2.664846e-01,
    2.665029e-01, 2.665212e-01, 2.665395e-01, 2.665578e-01, 2.665761e-01, 2.665944e-01,
    2.666127e-01, 2.666310e-01, 2.666493e-01, 2.666676e-01, 2.666859e-01, 2.667042e-01,
    2.667225e-01, 2.667408e-01, 2.667591e-01, 2.667774e-01, 2.667957e-01, 2.668140e-01,
    2.668323e-01, 2.668506e-01, 2.668689e-01, 2.668872e-01, 2.669055e-01, 2.669238e-01,
    2.669421e-01, 2.669604e-01, 2.669787e-01, 2.669969e-01, 2.670152e-01, 2.670335e-01,
    2.670518e-01, 2.670701e-01, 2.670884e-01, 2.671067e-01, 2.671250e-01, 2.671433e-01,
    2.671616e-01, 2.671799e-01, 2.671981e-01, 2.672164e-01, 2.672347e-01, 2.672530e-01,
    2.672713e-01, 2.672896e-01, 2.673079e-01, 2.673262e-01, 2.673445e-01, 2.673628e-01,
    2.673811e-01, 2.673993e-01, 2.674176e-01, 2.674359e-01, 2.674542e-01, 2.674725e-01,
    2.674908e-01, 2.675091e-01, 2.675274e-01, 2.675457e-01, 2.675640e-01, 2.675822e-01,
    2.676005e-01, 2.676188e-01, 2.676371e-01, 2.676554e-01, 2.676737e-01, 2.676920e-01,
    2.677103e-01, 2.677285e-01, 2.677468e-01, 2.677651e-01, 2.677834e-01, 2.678017e-01,
    2.678200e-01, 2.678382e-01, 2.678565e-01, 2.678748e-01, 2.678931e-01, 2.679114e-01,
    2.679297e-01, 2.679479e-01, 2.679662e-01, 2.679845e-01, 2.680028e-01, 2.680211e-01,
    2.680393e-01, 2.680576e-01, 2.680759e-01, 2.680942e-01, 2.681125e-01, 2.681307e-01,
    2.681490e-01, 2.681673e-01, 2.681856e-01, 2.682039e-01, 2.682222e-01, 2.682404e-01,
    2.682587e-01, 2.682770e-01, 2.682953e-01, 2.683136e-01, 2.683318e-01, 2.683501e-01,
    2.683684e-01, 2.683867e-01, 2.684049e-01, 2.684232e-01, 2.684415e-01, 2.684598e-01,
    2.684780e-01, 2.684963e-01, 2.685146e-01, 2.685329e-01, 2.685511e-01, 2.685694e-01,
    2.685877e-01, 2.686060e-01, 2.686242e-01, 2.686425e-01, 2.686608e-01, 2.686791e-01,
    2.686973e-01, 2.687156e-01, 2.687339e-01, 2.687522e-01, 2.687704e-01, 2.687887e-01,
    2.688070e-01, 2.688252e-01, 2.688435e-01, 2.688618e-01, 2.688800e-01, 2.688983e-01,
    2.689166e-01, 2.689348e-01, 2.689531e-01, 2.689714e-01, 2.689897e-01, 2.690079e-01,
    2.690262e-01, 2.690445e-01, 2.690628e-01, 2.690810e-01, 2.690993e-01, 2.691175e-01,
    2.691358e-01, 2.691541e-01, 2.691723e-01, 2.691906e-01, 2.692089e-01, 2.692271e-01,
    2.692454e-01, 2.692637e-01, 2.692820e-01, 2.693002e-01, 2.693185e-01, 2.693367e-01,
    2.693550e-01, 2.693733e-01, 2.693915e-01, 2.694098e-01, 2.694281e-01, 2.694463e-01,
    2.694646e-01, 2.694829e-01, 2.695011e-01, 2.695194e-01, 2.695376e-01, 2.695559e-01,
    2.695742e-01, 2.695924e-01, 2.696107e-01, 2.696289e-01, 2.696472e-01, 2.696654e-01,
    2.696837e-01, 2.697020e-01, 2.697202e-01, 2.697385e-01, 2.697568e-01, 2.697750e-01,
    2.697933e-01, 2.698115e-01, 2.698298e-01, 2.698481e-01, 2.698663e-01, 2.698846e-01,
    2.699029e-01, 2.699211e-01, 2.699393e-01, 2.699576e-01, 2.699759e-01, 2.699941e-01,
    2.700124e-01, 2.700306e-01, 2.700489e-01, 2.700672e-01, 2.700854e-01, 2.701037e-01,
    2.701219e-01, 2.701402e-01, 2.701584e-01, 2.701767e-01, 2.701949e-01, 2.702132e-01,
    2.702314e-01, 2.702497e-01, 2.702679e-01, 2.702862e-01, 2.703044e-01, 2.703227e-01,
    2.703409e-01, 2.703592e-01, 2.703775e-01, 2.703957e-01, 2.704140e-01, 2.704322e-01,
    2.704504e-01, 2.704687e-01, 2.704870e-01, 2.705052e-01, 2.705235e-01, 2.705417e-01,
    2.705600e-01, 2.705782e-01, 2.705965e-01, 2.706147e-01, 2.706330e-01, 2.706512e-01,
    2.706695e-01, 2.706877e-01, 2.707060e-01, 2.707242e-01, 2.707424e-01, 2.707607e-01,
    2.707790e-01, 2.707972e-01, 2.708154e-01, 2.708337e-01, 2.708519e-01, 2.708702e-01,
    2.708884e-01, 2.709067e-01, 2.709249e-01, 2.709431e-01, 2.709614e-01, 2.709796e-01,
    2.709979e-01, 2.710161e-01, 2.710344e-01, 2.710526e-01, 2.710709e-01, 2.710891e-01,
    2.711073e-01, 2.711256e-01, 2.711438e-01, 2.711621e-01, 2.711803e-01, 2.711986e-01,
    2.712168e-01, 2.712350e-01, 2.712533e-01, 2.712715e-01, 2.712898e-01, 2.713080e-01,
    2.713262e-01, 2.713445e-01, 2.713627e-01, 2.713810e-01, 2.713992e-01, 2.714174e-01,
    2.714356e-01, 2.714539e-01, 2.714722e-01, 2.714904e-01, 2.715086e-01, 2.715268e-01,
    2.715451e-01, 2.715633e-01, 2.715816e-01, 2.715998e-01, 2.716180e-01, 2.716363e-01,
    2.716545e-01, 2.716727e-01, 2.716910e-01, 2.717092e-01, 2.717274e-01, 2.717457e-01,
    2.717639e-01, 2.717822e-01, 2.718004e-01, 2.718186e-01, 2.718368e-01, 2.718551e-01,
    2.718733e-01, 2.718916e-01, 2.719098e-01, 2.719280e-01, 2.719463e-01, 2.719645e-01,
    2.719827e-01, 2.720009e-01, 2.720192e-01, 2.720374e-01, 2.720556e-01, 2.720739e-01,
    2.720921e-01, 2.721103e-01, 2.721286e-01, 2.721468e-01, 2.721650e-01, 2.721832e-01,
    2.722015e-01, 2.722197e-01, 2.722379e-01, 2.722562e-01, 2.722744e-01, 2.722926e-01,
    2.723108e-01, 2.723291e-01, 2.723473e-01, 2.723655e-01, 2.723837e-01, 2.724020e-01,
    2.724202e-01, 2.724384e-01, 2.724566e-01, 2.724749e-01, 2.724931e-01, 2.725113e-01,
    2.725295e-01, 2.725478e-01, 2.725660e-01, 2.725842e-01, 2.726025e-01, 2.726206e-01,
    2.726389e-01, 2.726571e-01, 2.726753e-01, 2.726936e-01, 2.727118e-01, 2.727300e-01,
    2.727482e-01, 2.727665e-01, 2.727847e-01, 2.728029e-01, 2.728211e-01, 2.728393e-01,
    2.728575e-01, 2.728758e-01, 2.728940e-01, 2.729122e-01, 2.729304e-01, 2.729487e-01,
    2.729669e-01, 2.729851e-01, 2.730033e-01, 2.730215e-01, 2.730397e-01, 2.730580e-01,
    2.730762e-01, 2.730944e-01, 2.731126e-01, 2.731308e-01, 2.731491e-01, 2.731673e-01,
    2.731855e-01, 2.732037e-01, 2.732219e-01, 2.732401e-01, 2.732584e-01, 2.732766e-01,
    2.732948e-01, 2.733130e-01, 2.733312e-01, 2.733494e-01, 2.733676e-01, 2.733859e-01,
    2.734041e-01, 2.734223e-01, 2.734405e-01, 2.734587e-01, 2.734769e-01, 2.734951e-01,
    2.735133e-01, 2.735316e-01, 2.735498e-01, 2.735680e-01, 2.735862e-01, 2.736044e-01,
    2.736226e-01, 2.736408e-01, 2.736590e-01, 2.736772e-01, 2.736954e-01, 2.737136e-01,
    2.737319e-01, 2.737501e-01, 2.737683e-01, 2.737865e-01, 2.738047e-01, 2.738229e-01,
    2.738411e-01, 2.738593e-01, 2.738775e-01, 2.738957e-01, 2.739139e-01, 2.739322e-01,
    2.739504e-01, 2.739686e-01, 2.739868e-01, 2.740050e-01, 2.740232e-01, 2.740414e-01,
    2.740596e-01, 2.740778e-01, 2.740960e-01, 2.741142e-01, 2.741324e-01, 2.741506e-01,
    2.741688e-01, 2.741870e-01, 2.742052e-01, 2.742234e-01, 2.742417e-01, 2.742598e-01,
    2.742780e-01, 2.742963e-01, 2.743145e-01, 2.743326e-01, 2.743509e-01, 2.743691e-01,
    2.743872e-01, 2.744054e-01, 2.744237e-01, 2.744418e-01, 2.744600e-01, 2.744783e-01,
    2.744965e-01, 2.745147e-01, 2.745329e-01, 2.745511e-01, 2.745692e-01, 2.745875e-01,
    2.746056e-01, 2.746238e-01, 2.746421e-01, 2.746603e-01, 2.746784e-01, 2.746966e-01,
    2.747148e-01, 2.747330e-01, 2.747512e-01, 2.747694e-01, 2.747876e-01, 2.748058e-01,
    2.748240e-01, 2.748422e-01, 2.748604e-01, 2.748786e-01, 2.748968e-01, 2.749150e-01,
    2.749332e-01, 2.749514e-01, 2.749695e-01, 2.749878e-01, 2.750060e-01, 2.750241e-01,
    2.750424e-01, 2.750605e-01, 2.750787e-01, 2.750969e-01, 2.751151e-01, 2.751333e-01,
    2.751515e-01, 2.751697e-01, 2.751879e-01, 2.752061e-01, 2.752243e-01, 2.752424e-01,
    2.752606e-01, 2.752788e-01, 2.752970e-01, 2.753152e-01, 2.753334e-01, 2.753516e-01,
    2.753698e-01, 2.753880e-01, 2.754062e-01, 2.754243e-01, 2.754425e-01, 2.754607e-01,
    2.754789e-01, 2.754971e-01, 2.755153e-01, 2.755335e-01, 2.755516e-01, 2.755699e-01,
    2.755880e-01, 2.756062e-01, 2.756244e-01, 2.756426e-01, 2.756608e-01, 2.756789e-01,
    2.756971e-01, 2.757153e-01, 2.757335e-01, 2.757517e-01, 2.757699e-01, 2.757880e-01,
    2.758062e-01, 2.758244e-01, 2.758426e-01, 2.758608e-01, 2.758790e-01, 2.758971e-01,
    2.759153e-01, 2.759335e-01, 2.759517e-01, 2.759699e-01, 2.759881e-01, 2.760062e-01,
    2.760244e-01, 2.760426e-01, 2.760608e-01, 2.760790e-01, 2.760971e-01, 2.761153e-01,
    2.761335e-01, 2.761517e-01, 2.761698e-01, 2.761880e-01, 2.762062e-01, 2.762244e-01,
    2.762426e-01, 2.762607e-01, 2.762789e-01, 2.762971e-01, 2.763153e-01, 2.763335e-01,
    2.763516e-01, 2.763698e-01, 2.763880e-01, 2.764061e-01, 2.764243e-01, 2.764425e-01,
    2.764607e-01, 2.764789e-01, 2.764970e-01, 2.765152e-01, 2.765334e-01, 2.765515e-01,
    2.765697e-01, 2.765879e-01, 2.766061e-01, 2.766242e-01, 2.766424e-01, 2.766606e-01,
    2.766788e-01, 2.766969e-01, 2.767151e-01, 2.767333e-01, 2.767515e-01, 2.767696e-01,
    2.767878e-01, 2.768060e-01, 2.768241e-01, 2.768423e-01, 2.768605e-01, 2.768786e-01,
    2.768968e-01, 2.769150e-01, 2.769332e-01, 2.769513e-01, 2.769695e-01, 2.769876e-01,
    2.770058e-01, 2.770240e-01, 2.770422e-01, 2.770603e-01, 2.770785e-01, 2.770967e-01,
    2.771148e-01, 2.771330e-01, 2.771512e-01, 2.771693e-01, 2.771875e-01, 2.772056e-01,
    2.772238e-01, 2.772420e-01, 2.772602e-01, 2.772783e-01, 2.772965e-01, 2.773147e-01,
    2.773328e-01, 2.773510e-01, 2.773691e-01, 2.773873e-01, 2.774055e-01, 2.774236e-01,
    2.774418e-01, 2.774599e-01, 2.774781e-01, 2.774963e-01, 2.775144e-01, 2.775326e-01,
    2.775508e-01, 2.775689e-01, 2.775871e-01, 2.776052e-01, 2.776234e-01, 2.776416e-01,
    2.776597e-01, 2.776779e-01, 2.776960e-01, 2.777142e-01, 2.777323e-01, 2.777505e-01,
    2.777687e-01, 2.777868e-01, 2.778050e-01, 2.778232e-01, 2.778413e-01, 2.778595e-01,
    2.778776e-01, 2.778958e-01, 2.779140e-01, 2.779321e-01, 2.779503e-01, 2.779684e-01,
    2.779866e-01, 2.780047e-01, 2.780229e-01, 2.780410e-01, 2.780592e-01, 2.780773e-01,
    2.780955e-01, 2.781136e-01, 2.781318e-01, 2.781500e-01, 2.781681e-01, 2.781863e-01,
    2.782044e-01, 2.782226e-01, 2.782407e-01, 2.782589e-01, 2.782770e-01, 2.782952e-01,
    2.783133e-01, 2.783315e-01, 2.783496e-01, 2.783678e-01, 2.783859e-01, 2.784041e-01,
    2.784222e-01, 2.784404e-01, 2.784585e-01, 2.784767e-01, 2.784948e-01, 2.785130e-01,
    2.785311e-01, 2.785493e-01, 2.785674e-01, 2.785856e-01, 2.786037e-01, 2.786219e-01,
    2.786400e-01, 2.786582e-01, 2.786763e-01, 2.786945e-01, 2.787126e-01, 2.787308e-01,
    2.787489e-01, 2.787670e-01, 2.787852e-01, 2.788033e-01, 2.788215e-01, 2.788396e-01,
    2.788578e-01, 2.788759e-01, 2.788941e-01, 2.789122e-01, 2.789303e-01, 2.789485e-01,
    2.789666e-01, 2.789848e-01, 2.790029e-01, 2.790211e-01, 2.790392e-01, 2.790574e-01,
    2.790755e-01, 2.790937e-01, 2.791118e-01, 2.791299e-01, 2.791480e-01, 2.791662e-01,
    2.791843e-01, 2.792025e-01, 2.792206e-01, 2.792388e-01, 2.792569e-01, 2.792750e-01,
    2.792932e-01, 2.793113e-01, 2.793294e-01, 2.793476e-01, 2.793657e-01, 2.793839e-01,
    2.794020e-01, 2.794201e-01, 2.794383e-01, 2.794564e-01, 2.794746e-01, 2.794927e-01,
    2.795108e-01, 2.795290e-01, 2.795471e-01, 2.795652e-01, 2.795834e-01, 2.796015e-01,
    2.796196e-01, 2.796378e-01, 2.796559e-01, 2.796741e-01, 2.796922e-01, 2.797103e-01,
    2.797284e-01, 2.797466e-01, 2.797647e-01, 2.797829e-01, 2.798010e-01, 2.798191e-01,
    2.798373e-01, 2.798554e-01, 2.798735e-01, 2.798917e-01, 2.799098e-01, 2.799279e-01,
    2.799461e-01, 2.799642e-01, 2.799823e-01, 2.800004e-01, 2.800186e-01, 2.800367e-01,
    2.800548e-01, 2.800730e-01, 2.800911e-01, 2.801092e-01, 2.801273e-01, 2.801455e-01,
    2.801636e-01, 2.801817e-01, 2.801999e-01, 2.802180e-01, 2.802361e-01, 2.802542e-01,
    2.802724e-01, 2.802905e-01, 2.803086e-01, 2.803268e-01, 2.803449e-01, 2.803630e-01,
    2.803811e-01, 2.803992e-01, 2.804174e-01, 2.804355e-01, 2.804536e-01, 2.804717e-01,
    2.804899e-01, 2.805080e-01, 2.805261e-01, 2.805443e-01, 2.805624e-01, 2.805805e-01,
    2.805986e-01, 2.806167e-01, 2.806349e-01, 2.806530e-01, 2.806711e-01, 2.806892e-01,
    2.807074e-01, 2.807255e-01, 2.807436e-01, 2.807617e-01, 2.807798e-01, 2.807980e-01,
    2.808161e-01, 2.808342e-01, 2.808523e-01, 2.808704e-01, 2.808886e-01, 2.809066e-01,
    2.809248e-01, 2.809429e-01, 2.809610e-01, 2.809792e-01, 2.809972e-01, 2.810154e-01,
    2.810335e-01, 2.810516e-01, 2.810697e-01, 2.810878e-01, 2.811060e-01, 2.811241e-01,
    2.811422e-01, 2.811603e-01, 2.811784e-01, 2.811965e-01, 2.812147e-01, 2.812328e-01,
    2.812509e-01, 2.812690e-01, 2.812871e-01, 2.813052e-01, 2.813233e-01, 2.813415e-01,
    2.813596e-01, 2.813777e-01, 2.813958e-01, 2.814139e-01, 2.814320e-01, 2.814502e-01,
    2.814682e-01, 2.814864e-01, 2.815045e-01, 2.815226e-01, 2.815407e-01, 2.815588e-01,
    2.815769e-01, 2.815950e-01, 2.816131e-01, 2.816312e-01, 2.816494e-01, 2.816675e-01,
    2.816856e-01, 2.817037e-01, 2.817218e-01, 2.817399e-01, 2.817580e-01, 2.817761e-01,
    2.817942e-01, 2.818123e-01, 2.818304e-01, 2.818485e-01, 2.818666e-01, 2.818848e-01,
    2.819029e-01, 2.819210e-01, 2.819391e-01, 2.819572e-01, 2.819753e-01, 2.819934e-01,
    2.820115e-01, 2.820296e-01, 2.820477e-01, 2.820658e-01, 2.820839e-01, 2.821020e-01,
    2.821201e-01, 2.821382e-01, 2.821563e-01, 2.821744e-01, 2.821926e-01, 2.822106e-01,
    2.822288e-01, 2.822469e-01, 2.822649e-01, 2.822831e-01, 2.823012e-01, 2.823192e-01,
    2.823374e-01, 2.823555e-01, 2.823736e-01, 2.823917e-01, 2.824098e-01, 2.824279e-01,
    2.824460e-01, 2.824641e-01, 2.824821e-01, 2.825002e-01, 2.825184e-01, 2.825364e-01,
    2.825546e-01, 2.825727e-01, 2.825907e-01, 2.826089e-01, 2.826269e-01, 2.826450e-01,
    2.826631e-01, 2.826812e-01, 2.826993e-01, 2.827174e-01, 2.827355e-01, 2.827536e-01,
    2.827717e-01, 2.827898e-01, 2.828079e-01, 2.828260e-01, 2.828441e-01, 2.828622e-01,
    2.828803e-01, 2.828984e-01, 2.829165e-01, 2.829346e-01, 2.829526e-01, 2.829708e-01,
    2.829888e-01, 2.830069e-01, 2.830250e-01, 2.830431e-01, 2.830612e-01, 2.830793e-01,
    2.830974e-01, 2.831155e-01, 2.831336e-01, 2.831517e-01, 2.831697e-01, 2.831879e-01,
    2.832059e-01, 2.832240e-01, 2.832421e-01, 2.832602e-01, 2.832783e-01, 2.832964e-01,
    2.833145e-01, 2.833326e-01, 2.833506e-01, 2.833687e-01, 2.833869e-01, 2.834049e-01,
    2.834230e-01, 2.834411e-01, 2.834592e-01, 2.834772e-01, 2.834954e-01, 2.835135e-01,
    2.835315e-01, 2.835496e-01, 2.835677e-01, 2.835858e-01, 2.836039e-01, 2.836220e-01,
    2.836401e-01, 2.836581e-01, 2.836762e-01, 2.836943e-01, 2.837124e-01, 2.837305e-01,
    2.837485e-01, 2.837666e-01, 2.837847e-01, 2.838028e-01, 2.838209e-01, 2.838390e-01,
    2.838570e-01, 2.838751e-01, 2.838932e-01, 2.839113e-01, 2.839293e-01, 2.839474e-01,
    2.839655e-01, 2.839836e-01, 2.840017e-01, 2.840198e-01, 2.840378e-01, 2.840559e-01,
    2.840740e-01, 2.840921e-01, 2.841102e-01, 2.841282e-01, 2.841463e-01, 2.841644e-01,
    2.841825e-01, 2.842005e-01, 2.842186e-01, 2.842367e-01, 2.842548e-01, 2.842729e-01,
    2.842909e-01, 2.843090e-01, 2.843271e-01, 2.843452e-01, 2.843632e-01, 2.843813e-01,
    2.843994e-01, 2.844175e-01, 2.844355e-01, 2.844536e-01, 2.844717e-01, 2.844898e-01,
    2.845078e-01, 2.845259e-01, 2.845440e-01, 2.845621e-01, 2.845801e-01, 2.845982e-01,
    2.846163e-01, 2.846344e-01, 2.846524e-01, 2.846705e-01, 2.846886e-01, 2.847066e-01,
    2.847247e-01, 2.847428e-01, 2.847609e-01, 2.847789e-01, 2.847970e-01, 2.848151e-01,
    2.848331e-01, 2.848512e-01, 2.848693e-01, 2.848873e-01, 2.849054e-01, 2.849235e-01,
    2.849416e-01, 2.849596e-01, 2.849777e-01, 2.849958e-01, 2.850138e-01, 2.850319e-01,
    2.850499e-01, 2.850680e-01, 2.850861e-01, 2.851042e-01, 2.851222e-01, 2.851403e-01,
    2.851583e-01, 2.851764e-01, 2.851945e-01, 2.852125e-01, 2.852306e-01, 2.852487e-01,
    2.852667e-01, 2.852848e-01, 2.853029e-01, 2.853209e-01, 2.853390e-01, 2.853571e-01,
    2.853751e-01, 2.853932e-01, 2.854112e-01, 2.854293e-01, 2.854474e-01, 2.854654e-01,
    2.854835e-01, 2.855016e-01, 2.855196e-01, 2.855377e-01, 2.855558e-01, 2.855738e-01,
    2.855918e-01, 2.856099e-01, 2.856280e-01, 2.856461e-01, 2.856641e-01, 2.856822e-01,
    2.857002e-01, 2.857183e-01, 2.857364e-01, 2.857544e-01, 2.857724e-01, 2.857905e-01,
    2.858086e-01, 2.858266e-01, 2.858447e-01, 2.858627e-01, 2.858808e-01, 2.858989e-01,
    2.859169e-01, 2.859350e-01, 2.859530e-01, 2.859711e-01, 2.859891e-01, 2.860072e-01,
    2.860253e-01, 2.860433e-01, 2.860613e-01, 2.860794e-01, 2.860975e-01, 2.861155e-01,
    2.861336e-01, 2.861516e-01, 2.861697e-01, 2.861877e-01, 2.862058e-01, 2.862238e-01,
    2.862419e-01, 2.862599e-01, 2.862780e-01, 2.862960e-01, 2.863141e-01, 2.863322e-01,
    2.863502e-01, 2.863683e-01, 2.863863e-01, 2.864043e-01, 2.864224e-01, 2.864404e-01,
    2.864585e-01, 2.864765e-01, 2.864946e-01, 2.865126e-01, 2.865307e-01, 2.865487e-01,
    2.865668e-01, 2.865848e-01, 2.866029e-01, 2.866209e-01, 2.866390e-01, 2.866570e-01,
    2.866751e-01, 2.866931e-01, 2.867112e-01, 2.867292e-01, 2.867472e-01, 2.867653e-01,
    2.867833e-01, 2.868014e-01, 2.868195e-01, 2.868375e-01, 2.868555e-01, 2.868736e-01,
    2.868916e-01, 2.869096e-01, 2.869277e-01, 2.869457e-01, 2.869638e-01, 2.869819e-01,
    2.869999e-01, 2.870179e-01, 2.870359e-01, 2.870540e-01, 2.870720e-01, 2.870901e-01,
    2.871081e-01, 2.871262e-01, 2.871442e-01, 2.871622e-01, 2.871803e-01, 2.871983e-01,
    2.872164e-01, 2.872344e-01, 2.872525e-01, 2.872705e-01, 2.872885e-01, 2.873066e-01,
    2.873246e-01, 2.873426e-01, 2.873607e-01, 2.873787e-01, 2.873968e-01, 2.874148e-01,
    2.874328e-01, 2.874509e-01, 2.874689e-01, 2.874869e-01, 2.875050e-01, 2.875230e-01,
    2.875410e-01, 2.875591e-01, 2.875771e-01, 2.875952e-01, 2.876132e-01, 2.876312e-01,
    2.876493e-01, 2.876673e-01, 2.876853e-01, 2.877034e-01, 2.877214e-01, 2.877394e-01,
    2.877575e-01, 2.877755e-01, 2.877935e-01, 2.878116e-01, 2.878296e-01, 2.878476e-01,
    2.878657e-01, 2.878837e-01, 2.879017e-01, 2.879198e-01, 2.879378e-01, 2.879558e-01,
    2.879738e-01, 2.879919e-01, 2.880099e-01, 2.880279e-01, 2.880460e-01, 2.880640e-01,
    2.880820e-01, 2.881000e-01, 2.881181e-01, 2.881361e-01, 2.881541e-01, 2.881722e-01,
    2.881902e-01, 2.882082e-01, 2.882262e-01, 2.882443e-01, 2.882623e-01, 2.882803e-01,
    2.882984e-01, 2.883164e-01, 2.883344e-01, 2.883524e-01, 2.883705e-01, 2.883885e-01,
    2.884065e-01, 2.884245e-01, 2.884426e-01, 2.884606e-01, 2.884786e-01, 2.884966e-01,
    2.885146e-01, 2.885327e-01, 2.885507e-01, 2.885687e-01, 2.885867e-01, 2.886048e-01,
    2.886228e-01, 2.886408e-01, 2.886588e-01, 2.886769e-01, 2.886949e-01, 2.887129e-01,
    2.887309e-01, 2.887489e-01, 2.887670e-01, 2.887850e-01, 2.888030e-01, 2.888210e-01,
    2.888390e-01, 2.888571e-01, 2.888751e-01, 2.888931e-01, 2.889111e-01, 2.889291e-01,
    2.889471e-01, 2.889652e-01, 2.889832e-01, 2.890012e-01, 2.890192e-01, 2.890373e-01,
    2.890553e-01, 2.890733e-01, 2.890913e-01, 2.891093e-01, 2.891273e-01, 2.891454e-01,
    2.891634e-01, 2.891814e-01, 2.891994e-01, 2.892174e-01, 2.892354e-01, 2.892534e-01,
    2.892714e-01, 2.892894e-01, 2.893075e-01, 2.893255e-01, 2.893435e-01, 2.893615e-01,
    2.893795e-01, 2.893975e-01, 2.894156e-01, 2.894336e-01, 2.894516e-01, 2.894696e-01,
    2.894876e-01, 2.895056e-01, 2.895236e-01, 2.895416e-01, 2.895596e-01, 2.895777e-01,
    2.895957e-01, 2.896137e-01, 2.896317e-01, 2.896497e-01, 2.896677e-01, 2.896857e-01,
    2.897037e-01, 2.897217e-01, 2.897398e-01, 2.897578e-01, 2.897758e-01, 2.897938e-01,
    2.898118e-01, 2.898298e-01, 2.898478e-01, 2.898658e-01, 2.898838e-01, 2.899018e-01,
    2.899198e-01, 2.899378e-01, 2.899558e-01, 2.899739e-01, 2.899918e-01, 2.900099e-01,
    2.900279e-01, 2.900459e-01, 2.900639e-01, 2.900819e-01, 2.900999e-01, 2.901179e-01,
    2.901359e-01, 2.901539e-01, 2.901719e-01, 2.901899e-01, 2.902079e-01, 2.902259e-01,
    2.902439e-01, 2.902619e-01, 2.902799e-01, 2.902979e-01, 2.903159e-01, 2.903339e-01,
    2.903519e-01, 2.903699e-01, 2.903879e-01, 2.904059e-01, 2.904239e-01, 2.904419e-01,
    2.904599e-01, 2.904779e-01, 2.904959e-01, 2.905139e-01, 2.905319e-01, 2.905499e-01,
    2.905679e-01, 2.905859e-01, 2.906039e-01, 2.906219e-01, 2.906399e-01, 2.906579e-01,
    2.906759e-01, 2.906939e-01, 2.907118e-01, 2.907299e-01, 2.907479e-01, 2.907659e-01,
    2.907839e-01, 2.908019e-01, 2.908199e-01, 2.908379e-01, 2.908558e-01, 2.908738e-01,
    2.908918e-01, 2.909098e-01, 2.909278e-01, 2.909458e-01, 2.909638e-01, 2.909818e-01,
    2.909998e-01, 2.910178e-01, 2.910358e-01, 2.910538e-01, 2.910717e-01, 2.910897e-01,
    2.911077e-01, 2.911257e-01, 2.911437e-01, 2.911617e-01, 2.911797e-01, 2.911977e-01,
    2.912157e-01, 2.912337e-01, 2.912517e-01, 2.912696e-01, 2.912876e-01, 2.913056e-01,
    2.913236e-01, 2.913416e-01, 2.913596e-01, 2.913776e-01, 2.913955e-01, 2.914135e-01,
    2.914315e-01, 2.914495e-01, 2.914675e-01, 2.914855e-01, 2.915035e-01, 2.915215e-01,
    2.915395e-01, 2.915574e-01, 2.915754e-01, 2.915934e-01, 2.916114e-01, 2.916294e-01,
    2.916474e-01, 2.916653e-01, 2.916833e-01, 2.917013e-01, 2.917193e-01, 2.917373e-01,
    2.917553e-01, 2.917733e-01, 2.917913e-01, 2.918092e-01, 2.918272e-01, 2.918452e-01,
    2.918631e-01, 2.918811e-01, 2.918991e-01, 2.919171e-01, 2.919351e-01, 2.919531e-01,
    2.919711e-01, 2.919890e-01, 2.920070e-01, 2.920250e-01, 2.920430e-01, 2.920610e-01,
    2.920789e-01, 2.920969e-01, 2.921149e-01, 2.921329e-01, 2.921509e-01, 2.921688e-01,
    2.921868e-01, 2.922048e-01, 2.922227e-01, 2.922407e-01, 2.922587e-01, 2.922767e-01,
    2.922947e-01, 2.923126e-01, 2.923306e-01, 2.923486e-01, 2.923666e-01, 2.923845e-01,
    2.924025e-01, 2.924205e-01, 2.924385e-01, 2.924564e-01, 2.924744e-01, 2.924924e-01,
    2.925104e-01, 2.925283e-01, 2.925463e-01, 2.925643e-01, 2.925823e-01, 2.926002e-01,
    2.926182e-01, 2.926362e-01, 2.926542e-01, 2.926721e-01, 2.926901e-01, 2.927081e-01,
    2.927260e-01, 2.927440e-01, 2.927620e-01, 2.927800e-01, 2.927979e-01, 2.928159e-01,
    2.928339e-01, 2.928518e-01, 2.928698e-01, 2.928878e-01, 2.929057e-01, 2.929237e-01,
    2.929417e-01, 2.929597e-01, 2.929776e-01, 2.929956e-01, 2.930135e-01, 2.930315e-01,
    2.930495e-01, 2.930675e-01, 2.930854e-01, 2.931034e-01, 2.931213e-01, 2.931393e-01,
    2.931573e-01, 2.931753e-01, 2.931932e-01, 2.932112e-01, 2.932292e-01, 2.932471e-01,
    2.932651e-01, 2.932830e-01, 2.933010e-01, 2.933190e-01, 2.933369e-01, 2.933549e-01,
    2.933729e-01, 2.933908e-01, 2.934088e-01, 2.934267e-01, 2.934447e-01, 2.934627e-01,
    2.934806e-01, 2.934986e-01, 2.935165e-01, 2.935345e-01, 2.935525e-01, 2.935704e-01,
    2.935884e-01, 2.936063e-01, 2.936243e-01, 2.936423e-01, 2.936602e-01, 2.936782e-01,
    2.936961e-01, 2.937141e-01, 2.937321e-01, 2.937500e-01, 2.937680e-01, 2.937859e-01,
    2.938039e-01, 2.938219e-01, 2.938398e-01, 2.938578e-01, 2.938758e-01, 2.938937e-01,
    2.939116e-01, 2.939296e-01, 2.939476e-01, 2.939655e-01, 2.939835e-01, 2.940014e-01,
    2.940194e-01, 2.940373e-01, 2.940553e-01, 2.940733e-01, 2.940912e-01, 2.941091e-01,
    2.941271e-01, 2.941451e-01, 2.941630e-01, 2.941810e-01, 2.941989e-01, 2.942169e-01,
    2.942348e-01, 2.942528e-01, 2.942707e-01, 2.942887e-01, 2.943066e-01, 2.943246e-01,
    2.943425e-01, 2.943605e-01, 2.943785e-01, 2.943964e-01, 2.944143e-01, 2.944323e-01,
    2.944502e-01, 2.944682e-01, 2.944861e-01, 2.945041e-01, 2.945220e-01, 2.945400e-01,
    2.945579e-01, 2.945759e-01, 2.945938e-01, 2.946118e-01, 2.946297e-01, 2.946477e-01,
    2.946656e-01, 2.946836e-01, 2.947015e-01, 2.947195e-01, 2.947374e-01, 2.947553e-01,
    2.947733e-01, 2.947913e-01, 2.948092e-01, 2.948271e-01, 2.948451e-01, 2.948630e-01,
    2.948810e-01, 2.948989e-01, 2.949169e-01, 2.949348e-01, 2.949528e-01, 2.949707e-01,
    2.949886e-01, 2.950066e-01, 2.950245e-01, 2.950425e-01, 2.950604e-01, 2.950783e-01,
    2.950963e-01, 2.951142e-01, 2.951322e-01, 2.951501e-01, 2.951680e-01, 2.951860e-01,
    2.952039e-01, 2.952219e-01, 2.952398e-01, 2.952577e-01, 2.952757e-01, 2.952936e-01,
    2.953116e-01, 2.953295e-01, 2.953475e-01, 2.953654e-01, 2.953833e-01, 2.954012e-01,
    2.954192e-01, 2.954371e-01, 2.954551e-01, 2.954730e-01, 2.954910e-01, 2.955089e-01,
    2.955268e-01, 2.955447e-01, 2.955627e-01, 2.955806e-01, 2.955986e-01, 2.956165e-01,
    2.956344e-01, 2.956524e-01, 2.956703e-01, 2.956882e-01, 2.957062e-01, 2.957241e-01,
    2.957420e-01, 2.957600e-01, 2.957779e-01, 2.957958e-01, 2.958138e-01, 2.958317e-01,
    2.958496e-01, 2.958676e-01, 2.958855e-01, 2.959034e-01, 2.959214e-01, 2.959393e-01,
    2.959572e-01, 2.959751e-01, 2.959931e-01, 2.960110e-01, 2.960289e-01, 2.960469e-01,
    2.960648e-01, 2.960827e-01, 2.961006e-01, 2.961186e-01, 2.961365e-01, 2.961544e-01,
    2.961724e-01, 2.961903e-01, 2.962082e-01, 2.962262e-01, 2.962441e-01, 2.962620e-01,
    2.962799e-01, 2.962978e-01, 2.963158e-01, 2.963337e-01, 2.963516e-01, 2.963696e-01,
    2.963875e-01, 2.964054e-01, 2.964233e-01, 2.964413e-01, 2.964592e-01, 2.964771e-01,
    2.964951e-01, 2.965130e-01, 2.965309e-01, 2.965488e-01, 2.965668e-01, 2.965847e-01,
    2.966026e-01, 2.966205e-01, 2.966384e-01, 2.966564e-01, 2.966743e-01, 2.966922e-01,
    2.967101e-01, 2.967280e-01, 2.967460e-01, 2.967639e-01, 2.967818e-01, 2.967997e-01,
    2.968177e-01, 2.968356e-01, 2.968535e-01, 2.968714e-01, 2.968893e-01, 2.969072e-01,
    2.969252e-01, 2.969431e-01, 2.969610e-01, 2.969789e-01, 2.969968e-01, 2.970147e-01,
    2.970327e-01, 2.970506e-01, 2.970685e-01, 2.970864e-01, 2.971044e-01, 2.971223e-01,
    2.971402e-01, 2.971581e-01, 2.971760e-01, 2.971939e-01, 2.972118e-01, 2.972297e-01,
    2.972477e-01, 2.972656e-01, 2.972835e-01, 2.973014e-01, 2.973193e-01, 2.973372e-01,
    2.973552e-01, 2.973731e-01, 2.973910e-01, 2.974089e-01, 2.974268e-01, 2.974447e-01,
    2.974626e-01, 2.974806e-01, 2.974984e-01, 2.975164e-01, 2.975343e-01, 2.975522e-01,
    2.975701e-01, 2.975880e-01, 2.976059e-01, 2.976238e-01, 2.976418e-01, 2.976597e-01,
    2.976776e-01, 2.976955e-01, 2.977134e-01, 2.977313e-01, 2.977492e-01, 2.977671e-01,
    2.977850e-01, 2.978029e-01, 2.978208e-01, 2.978387e-01, 2.978567e-01, 2.978745e-01,
    2.978925e-01, 2.979104e-01, 2.979283e-01, 2.979462e-01, 2.979641e-01, 2.979820e-01,
    2.979999e-01, 2.980178e-01, 2.980357e-01, 2.980536e-01, 2.980715e-01, 2.980894e-01,
    2.981073e-01, 2.981252e-01, 2.981431e-01, 2.981610e-01, 2.981789e-01, 2.981969e-01,
    2.982148e-01, 2.982326e-01, 2.982506e-01, 2.982685e-01, 2.982864e-01, 2.983043e-01,
    2.983222e-01, 2.983401e-01, 2.983580e-01, 2.983759e-01, 2.983938e-01, 2.984117e-01,
    2.984295e-01, 2.984475e-01, 2.984654e-01, 2.984833e-01, 2.985012e-01, 2.985190e-01,
    2.985370e-01, 2.985549e-01, 2.985727e-01, 2.985907e-01, 2.986085e-01, 2.986265e-01,
    2.986443e-01, 2.986622e-01, 2.986801e-01, 2.986980e-01, 2.987159e-01, 2.987338e-01,
    2.987517e-01, 2.987696e-01, 2.987875e-01, 2.988054e-01, 2.988233e-01, 2.988412e-01,
    2.988591e-01, 2.988770e-01, 2.988949e-01, 2.989128e-01, 2.989307e-01, 2.989486e-01,
    2.989665e-01, 2.989844e-01, 2.990023e-01, 2.990201e-01, 2.990380e-01, 2.990559e-01,
    2.990738e-01, 2.990917e-01, 2.991096e-01, 2.991275e-01, 2.991454e-01, 2.991633e-01,
    2.991812e-01, 2.991991e-01, 2.992170e-01, 2.992348e-01, 2.992527e-01, 2.992706e-01,
    2.992885e-01, 2.993064e-01, 2.993243e-01, 2.993422e-01, 2.993601e-01, 2.993779e-01,
    2.993959e-01, 2.994137e-01, 2.994317e-01, 2.994495e-01, 2.994674e-01, 2.994853e-01,
    2.995032e-01, 2.995211e-01, 2.995390e-01, 2.995569e-01, 2.995747e-01, 2.995926e-01,
    2.996105e-01, 2.996284e-01, 2.996463e-01, 2.996642e-01, 2.996821e-01, 2.996999e-01,
    2.997178e-01, 2.997357e-01, 2.997536e-01, 2.997715e-01, 2.997893e-01, 2.998072e-01,
    2.998251e-01, 2.998430e-01, 2.998609e-01, 2.998787e-01, 2.998966e-01, 2.999145e-01,
    2.999324e-01, 2.999503e-01, 2.999682e-01, 2.999860e-01, 3.000039e-01, 3.000218e-01,
    3.000397e-01, 3.000576e-01, 3.000755e-01, 3.000933e-01, 3.001112e-01, 3.001291e-01,
    3.001470e-01, 3.001648e-01, 3.001827e-01, 3.002006e-01, 3.002185e-01, 3.002364e-01,
    3.002542e-01, 3.002721e-01, 3.002900e-01, 3.003079e-01, 3.003257e-01, 3.003436e-01,
    3.003615e-01, 3.003794e-01, 3.003972e-01, 3.004151e-01, 3.004330e-01, 3.004509e-01,
    3.004688e-01, 3.004866e-01, 3.005045e-01, 3.005224e-01, 3.005402e-01, 3.005581e-01,
    3.005760e-01, 3.005939e-01, 3.006117e-01, 3.006296e-01, 3.006475e-01, 3.006653e-01,
    3.006832e-01, 3.007011e-01, 3.007190e-01, 3.007369e-01, 3.007547e-01, 3.007726e-01,
    3.007905e-01, 3.008083e-01, 3.008262e-01, 3.008441e-01, 3.008620e-01, 3.008798e-01,
    3.008977e-01, 3.009155e-01, 3.009334e-01, 3.009513e-01, 3.009692e-01, 3.009870e-01,
    3.010049e-01, 3.010228e-01, 3.010406e-01, 3.010585e-01, 3.010764e-01, 3.010942e-01,
    3.011121e-01, 3.011300e-01, 3.011478e-01, 3.011657e-01, 3.011836e-01, 3.012014e-01,
    3.012193e-01, 3.012372e-01, 3.012550e-01, 3.012729e-01, 3.012908e-01, 3.013086e-01,
    3.013265e-01, 3.013444e-01, 3.013622e-01, 3.013801e-01, 3.013979e-01, 3.014158e-01,
    3.014337e-01, 3.014515e-01, 3.014694e-01, 3.014873e-01, 3.015051e-01, 3.015230e-01,
    3.015409e-01, 3.015587e-01, 3.015766e-01, 3.015944e-01, 3.016123e-01, 3.016302e-01,
    3.016480e-01, 3.016659e-01, 3.016837e-01, 3.017016e-01, 3.017195e-01, 3.017373e-01,
    3.017552e-01, 3.017730e-01, 3.017909e-01, 3.018087e-01, 3.018266e-01, 3.018445e-01,
    3.018623e-01, 3.018802e-01, 3.018980e-01, 3.019159e-01, 3.019338e-01, 3.019516e-01,
    3.019695e-01, 3.019873e-01, 3.020052e-01, 3.020230e-01, 3.020409e-01, 3.020587e-01,
    3.020766e-01, 3.020945e-01, 3.021123e-01, 3.021302e-01, 3.021480e-01, 3.021659e-01,
    3.021837e-01, 3.022016e-01, 3.022195e-01, 3.022373e-01, 3.022552e-01, 3.022730e-01,
    3.022909e-01, 3.023087e-01, 3.023265e-01, 3.023444e-01, 3.023622e-01, 3.023801e-01,
    3.023980e-01, 3.024158e-01, 3.024337e-01, 3.024515e-01, 3.024693e-01, 3.024872e-01,
    3.025050e-01, 3.025229e-01, 3.025407e-01, 3.025586e-01, 3.025765e-01, 3.025943e-01,
    3.026122e-01, 3.026300e-01, 3.026479e-01, 3.026657e-01, 3.026836e-01, 3.027014e-01,
    3.027192e-01, 3.027371e-01, 3.027549e-01, 3.027728e-01, 3.027906e-01, 3.028085e-01,
    3.028263e-01, 3.028442e-01, 3.028620e-01, 3.028798e-01, 3.028977e-01, 3.029155e-01,
    3.029334e-01, 3.029512e-01, 3.029691e-01, 3.029869e-01, 3.030047e-01, 3.030226e-01,
    3.030404e-01, 3.030583e-01, 3.030761e-01, 3.030940e-01, 3.031118e-01, 3.031296e-01,
    3.031475e-01, 3.031653e-01, 3.031832e-01, 3.032010e-01, 3.032189e-01, 3.032367e-01,
    3.032545e-01, 3.032724e-01, 3.032902e-01, 3.033081e-01, 3.033259e-01, 3.033437e-01,
    3.033616e-01, 3.033794e-01, 3.033973e-01, 3.034151e-01, 3.034329e-01, 3.034508e-01,
    3.034686e-01, 3.034865e-01, 3.035043e-01, 3.035221e-01, 3.035400e-01, 3.035578e-01,
    3.035756e-01, 3.035935e-01, 3.036113e-01, 3.036292e-01, 3.036470e-01, 3.036648e-01,
    3.036827e-01, 3.037005e-01, 3.037183e-01, 3.037362e-01, 3.037540e-01, 3.037718e-01,
    3.037896e-01, 3.038075e-01, 3.038253e-01, 3.038432e-01, 3.038610e-01, 3.038788e-01,
    3.038967e-01, 3.039145e-01, 3.039323e-01, 3.039502e-01, 3.039680e-01, 3.039858e-01,
    3.040037e-01, 3.040215e-01, 3.040393e-01, 3.040572e-01, 3.040750e-01, 3.040928e-01,
    3.041106e-01, 3.041285e-01, 3.041463e-01, 3.041641e-01, 3.041820e-01, 3.041998e-01,
    3.042176e-01, 3.042354e-01, 3.042533e-01, 3.042711e-01, 3.042889e-01, 3.043067e-01,
    3.043246e-01, 3.043424e-01, 3.043602e-01, 3.043781e-01, 3.043959e-01, 3.044137e-01,
    3.044315e-01, 3.044493e-01, 3.044672e-01, 3.044850e-01, 3.045028e-01, 3.045207e-01,
    3.045385e-01, 3.045563e-01, 3.045741e-01, 3.045920e-01, 3.046098e-01, 3.046276e-01,
    3.046454e-01, 3.046633e-01, 3.046811e-01, 3.046989e-01, 3.047167e-01, 3.047346e-01,
    3.047524e-01, 3.047702e-01, 3.047880e-01, 3.048058e-01, 3.048237e-01, 3.048415e-01,
    3.048593e-01, 3.048771e-01, 3.048950e-01, 3.049127e-01, 3.049306e-01, 3.049484e-01,
    3.049662e-01, 3.049840e-01, 3.050019e-01, 3.050197e-01, 3.050375e-01, 3.050553e-01,
    3.050731e-01, 3.050909e-01, 3.051088e-01, 3.051266e-01, 3.051444e-01, 3.051622e-01,
    3.051800e-01, 3.051979e-01, 3.052157e-01, 3.052335e-01, 3.052513e-01, 3.052691e-01,
    3.052869e-01, 3.053047e-01, 3.053226e-01, 3.053404e-01, 3.053582e-01, 3.053760e-01,
    3.053938e-01, 3.054116e-01, 3.054295e-01, 3.054473e-01, 3.054651e-01, 3.054829e-01,
    3.055007e-01, 3.055185e-01, 3.055363e-01, 3.055542e-01, 3.055719e-01, 3.055898e-01,
    3.056076e-01, 3.056254e-01, 3.056432e-01, 3.056610e-01, 3.056788e-01, 3.056966e-01,
    3.057144e-01, 3.057323e-01, 3.057500e-01, 3.057679e-01, 3.057857e-01, 3.058035e-01,
    3.058213e-01, 3.058391e-01, 3.058569e-01, 3.058747e-01, 3.058925e-01, 3.059103e-01,
    3.059281e-01, 3.059460e-01, 3.059638e-01, 3.059815e-01, 3.059994e-01, 3.060172e-01,
    3.060350e-01, 3.060528e-01, 3.060706e-01, 3.060884e-01, 3.061062e-01, 3.061240e-01,
    3.061418e-01, 3.061596e-01, 3.061774e-01, 3.061952e-01, 3.062130e-01, 3.062308e-01,
    3.062486e-01, 3.062665e-01, 3.062842e-01, 3.063020e-01, 3.063198e-01, 3.063377e-01,
    3.063554e-01, 3.063732e-01, 3.063911e-01, 3.064089e-01, 3.064267e-01, 3.064445e-01,
    3.064623e-01, 3.064801e-01, 3.064979e-01, 3.065157e-01, 3.065335e-01, 3.065513e-01,
    3.065691e-01, 3.065869e-01, 3.066047e-01, 3.066225e-01, 3.066402e-01, 3.066581e-01,
    3.066759e-01, 3.066936e-01, 3.067115e-01, 3.067293e-01, 3.067470e-01, 3.067648e-01,
    3.067827e-01, 3.068004e-01, 3.068182e-01, 3.068360e-01, 3.068538e-01, 3.068716e-01,
    3.068894e-01, 3.069072e-01, 3.069250e-01, 3.069428e-01, 3.069606e-01, 3.069784e-01,
    3.069962e-01, 3.070140e-01, 3.070318e-01, 3.070496e-01, 3.070674e-01, 3.070852e-01,
    3.071029e-01, 3.071207e-01, 3.071385e-01, 3.071563e-01, 3.071741e-01, 3.071919e-01,
    3.072097e-01, 3.072275e-01, 3.072453e-01, 3.072631e-01, 3.072809e-01, 3.072987e-01,
    3.073165e-01, 3.073342e-01, 3.073520e-01, 3.073698e-01, 3.073876e-01, 3.074054e-01,
    3.074232e-01, 3.074410e-01, 3.074588e-01, 3.074766e-01, 3.074943e-01, 3.075121e-01,
    3.075299e-01, 3.075477e-01, 3.075655e-01, 3.075833e-01, 3.076011e-01, 3.076189e-01,
    3.076366e-01, 3.076544e-01, 3.076722e-01, 3.076900e-01, 3.077078e-01, 3.077256e-01,
    3.077433e-01, 3.077611e-01, 3.077789e-01, 3.077967e-01, 3.078145e-01, 3.078323e-01,
    3.078501e-01, 3.078679e-01, 3.078856e-01, 3.079034e-01, 3.079212e-01, 3.079390e-01,
    3.079568e-01, 3.079745e-01, 3.079923e-01, 3.080101e-01, 3.080279e-01, 3.080457e-01,
    3.080634e-01, 3.080812e-01, 3.080990e-01, 3.081168e-01, 3.081346e-01, 3.081523e-01,
    3.081701e-01, 3.081879e-01, 3.082057e-01, 3.082235e-01, 3.082412e-01, 3.082590e-01,
    3.082768e-01, 3.082946e-01, 3.083124e-01, 3.083301e-01, 3.083479e-01, 3.083657e-01,
    3.083835e-01, 3.084013e-01, 3.084190e-01, 3.084368e-01, 3.084546e-01, 3.084724e-01,
    3.084901e-01, 3.085079e-01, 3.085257e-01, 3.085434e-01, 3.085612e-01, 3.085790e-01,
    3.085968e-01, 3.086146e-01, 3.086323e-01, 3.086501e-01, 3.086679e-01, 3.086857e-01,
    3.087034e-01, 3.087212e-01, 3.087390e-01, 3.087568e-01, 3.087745e-01, 3.087923e-01,
    3.088101e-01, 3.088278e-01, 3.088456e-01, 3.088634e-01, 3.088811e-01, 3.088989e-01,
    3.089167e-01, 3.089345e-01, 3.089522e-01, 3.089700e-01, 3.089878e-01, 3.090056e-01,
    3.090233e-01, 3.090411e-01, 3.090588e-01, 3.090766e-01, 3.090944e-01, 3.091122e-01,
    3.091299e-01, 3.091477e-01, 3.091654e-01, 3.091832e-01, 3.092010e-01, 3.092188e-01,
    3.092365e-01, 3.092543e-01, 3.092721e-01, 3.092898e-01, 3.093076e-01, 3.093253e-01,
    3.093431e-01, 3.093609e-01, 3.093787e-01, 3.093964e-01, 3.094142e-01, 3.094319e-01,
    3.094497e-01, 3.094675e-01, 3.094852e-01, 3.095030e-01, 3.095208e-01, 3.095385e-01,
    3.095563e-01, 3.095741e-01, 3.095918e-01, 3.096096e-01, 3.096273e-01, 3.096451e-01,
    3.096629e-01, 3.096806e-01, 3.096984e-01, 3.097161e-01, 3.097339e-01, 3.097517e-01,
    3.097694e-01, 3.097872e-01, 3.098049e-01, 3.098227e-01, 3.098405e-01, 3.098582e-01,
    3.098760e-01, 3.098937e-01, 3.099115e-01, 3.099293e-01, 3.099470e-01, 3.099648e-01,
    3.099825e-01, 3.100003e-01, 3.100181e-01, 3.100358e-01, 3.100536e-01, 3.100713e-01,
    3.100891e-01, 3.101068e-01, 3.101246e-01, 3.101423e-01, 3.101601e-01, 3.101778e-01,
    3.101956e-01, 3.102134e-01, 3.102311e-01, 3.102489e-01, 3.102666e-01, 3.102844e-01,
    3.103021e-01, 3.103199e-01, 3.103376e-01, 3.103554e-01, 3.103731e-01, 3.103909e-01,
    3.104087e-01, 3.104264e-01, 3.104441e-01, 3.104619e-01, 3.104796e-01, 3.104974e-01,
    3.105151e-01, 3.105329e-01, 3.105507e-01, 3.105684e-01, 3.105862e-01, 3.106039e-01,
    3.106216e-01, 3.106394e-01, 3.106572e-01, 3.106749e-01, 3.106927e-01, 3.107104e-01,
    3.107282e-01, 3.107459e-01, 3.107636e-01, 3.107814e-01, 3.107991e-01, 3.108169e-01,
    3.108346e-01, 3.108524e-01, 3.108701e-01, 3.108879e-01, 3.109056e-01, 3.109234e-01,
    3.109411e-01, 3.109589e-01, 3.109766e-01, 3.109944e-01, 3.110121e-01, 3.110298e-01,
    3.110476e-01, 3.110653e-01, 3.110831e-01, 3.111008e-01, 3.111185e-01, 3.111363e-01,
    3.111540e-01, 3.111718e-01, 3.111895e-01, 3.112073e-01, 3.112250e-01, 3.112428e-01,
    3.112605e-01, 3.112782e-01, 3.112960e-01, 3.113137e-01, 3.113315e-01, 3.113492e-01,
    3.113669e-01, 3.113847e-01, 3.114024e-01, 3.114202e-01, 3.114379e-01, 3.114556e-01,
    3.114734e-01, 3.114911e-01, 3.115089e-01, 3.115266e-01, 3.115443e-01, 3.115621e-01,
    3.115798e-01, 3.115976e-01, 3.116153e-01, 3.116330e-01, 3.116508e-01, 3.116685e-01,
    3.116862e-01, 3.117040e-01, 3.117217e-01, 3.117394e-01, 3.117572e-01, 3.117749e-01,
    3.117927e-01, 3.118104e-01, 3.118281e-01, 3.118459e-01, 3.118636e-01, 3.118813e-01,
    3.118990e-01, 3.119168e-01, 3.119345e-01, 3.119523e-01, 3.119700e-01, 3.119877e-01,
    3.120055e-01, 3.120232e-01, 3.120409e-01, 3.120587e-01, 3.120764e-01, 3.120941e-01,
    3.121119e-01, 3.121296e-01, 3.121473e-01, 3.121651e-01, 3.121828e-01, 3.122005e-01,
    3.122182e-01, 3.122360e-01, 3.122537e-01, 3.122714e-01, 3.122891e-01, 3.123069e-01,
    3.123246e-01, 3.123423e-01, 3.123601e-01, 3.123778e-01, 3.123955e-01, 3.124132e-01,
    3.124310e-01, 3.124487e-01, 3.124664e-01, 3.124841e-01, 3.125019e-01, 3.125196e-01,
    3.125373e-01, 3.125550e-01, 3.125728e-01, 3.125905e-01, 3.126082e-01, 3.126259e-01,
    3.126437e-01, 3.126614e-01, 3.126791e-01, 3.126968e-01, 3.127146e-01, 3.127323e-01,
    3.127500e-01, 3.127677e-01, 3.127855e-01, 3.128032e-01, 3.128209e-01, 3.128386e-01,
    3.128564e-01, 3.128741e-01, 3.128918e-01, 3.129095e-01, 3.129272e-01, 3.129450e-01,
    3.129627e-01, 3.129804e-01, 3.129981e-01, 3.130158e-01, 3.130336e-01, 3.130513e-01,
    3.130690e-01, 3.130867e-01, 3.131045e-01, 3.131222e-01, 3.131399e-01, 3.131576e-01,
    3.131753e-01, 3.131931e-01, 3.132108e-01, 3.132285e-01, 3.132462e-01, 3.132639e-01,
    3.132816e-01, 3.132994e-01, 3.133171e-01, 3.133348e-01, 3.133525e-01, 3.133702e-01,
    3.133880e-01, 3.134057e-01, 3.134234e-01, 3.134411e-01, 3.134588e-01, 3.134765e-01,
    3.134942e-01, 3.135119e-01, 3.135297e-01, 3.135474e-01, 3.135651e-01, 3.135828e-01,
    3.136005e-01, 3.136182e-01, 3.136359e-01, 3.136536e-01, 3.136714e-01, 3.136891e-01,
    3.137068e-01, 3.137245e-01, 3.137422e-01, 3.137599e-01, 3.137776e-01, 3.137953e-01,
    3.138130e-01, 3.138308e-01, 3.138485e-01, 3.138662e-01, 3.138839e-01, 3.139016e-01,
    3.139193e-01, 3.139370e-01, 3.139547e-01, 3.139724e-01, 3.139901e-01, 3.140078e-01,
    3.140256e-01, 3.140433e-01, 3.140610e-01, 3.140787e-01, 3.140964e-01, 3.141141e-01,
    3.141318e-01, 3.141495e-01, 3.141672e-01, 3.141849e-01, 3.142026e-01, 3.142203e-01,
    3.142380e-01, 3.142557e-01, 3.142734e-01, 3.142911e-01, 3.143089e-01, 3.143266e-01,
    3.143443e-01, 3.143620e-01, 3.143797e-01, 3.143974e-01, 3.144151e-01, 3.144328e-01,
    3.144505e-01, 3.144682e-01, 3.144859e-01, 3.145036e-01, 3.145213e-01, 3.145390e-01,
    3.145567e-01, 3.145744e-01, 3.145921e-01, 3.146098e-01, 3.146275e-01, 3.146452e-01,
    3.146629e-01, 3.146806e-01, 3.146983e-01, 3.147160e-01, 3.147337e-01, 3.147514e-01,
    3.147691e-01, 3.147868e-01, 3.148045e-01, 3.148222e-01, 3.148399e-01, 3.148576e-01,
    3.148753e-01, 3.148930e-01, 3.149107e-01, 3.149284e-01, 3.149461e-01, 3.149638e-01,
    3.149815e-01, 3.149991e-01, 3.150169e-01, 3.150345e-01, 3.150522e-01, 3.150699e-01,
    3.150876e-01, 3.151053e-01, 3.151230e-01, 3.151407e-01, 3.151584e-01, 3.151761e-01,
    3.151938e-01, 3.152115e-01, 3.152292e-01, 3.152469e-01, 3.152646e-01, 3.152823e-01,
    3.152999e-01, 3.153176e-01, 3.153353e-01, 3.153530e-01, 3.153707e-01, 3.153884e-01,
    3.154061e-01, 3.154238e-01, 3.154415e-01, 3.154592e-01, 3.154769e-01, 3.154946e-01,
    3.155122e-01, 3.155299e-01, 3.155476e-01, 3.155653e-01, 3.155830e-01, 3.156007e-01,
    3.156184e-01, 3.156361e-01, 3.156537e-01, 3.156714e-01, 3.156891e-01, 3.157068e-01,
    3.157245e-01, 3.157422e-01, 3.157599e-01, 3.157776e-01, 3.157952e-01, 3.158129e-01,
    3.158306e-01, 3.158483e-01, 3.158660e-01, 3.158837e-01, 3.159014e-01, 3.159190e-01,
    3.159367e-01, 3.159544e-01, 3.159721e-01, 3.159898e-01, 3.160075e-01, 3.160251e-01,
    3.160428e-01, 3.160605e-01, 3.160782e-01, 3.160959e-01, 3.161136e-01, 3.161312e-01,
    3.161489e-01, 3.161666e-01, 3.161843e-01, 3.162020e-01, 3.162196e-01, 3.162373e-01,
    3.162550e-01, 3.162727e-01, 3.162904e-01, 3.163081e-01, 3.163257e-01, 3.163434e-01,
    3.163611e-01, 3.163788e-01, 3.163964e-01, 3.164141e-01, 3.164318e-01, 3.164495e-01,
    3.164672e-01, 3.164848e-01, 3.165025e-01, 3.165202e-01, 3.165379e-01, 3.165555e-01,
    3.165732e-01, 3.165909e-01, 3.166086e-01, 3.166263e-01, 3.166439e-01, 3.166616e-01,
    3.166793e-01, 3.166970e-01, 3.167146e-01, 3.167323e-01, 3.167500e-01, 3.167676e-01,
    3.167853e-01, 3.168030e-01, 3.168207e-01, 3.168384e-01, 3.168560e-01, 3.168737e-01,
    3.168914e-01, 3.169090e-01, 3.169267e-01, 3.169444e-01, 3.169620e-01, 3.169797e-01,
    3.169974e-01, 3.170151e-01, 3.170327e-01, 3.170504e-01, 3.170681e-01, 3.170857e-01,
    3.171034e-01, 3.171211e-01, 3.171388e-01, 3.171564e-01, 3.171741e-01, 3.171918e-01,
    3.172095e-01, 3.172271e-01, 3.172448e-01, 3.172624e-01, 3.172801e-01, 3.172978e-01,
    3.173155e-01, 3.173331e-01, 3.173508e-01, 3.173684e-01, 3.173861e-01, 3.174038e-01,
    3.174215e-01, 3.174391e-01, 3.174568e-01, 3.174745e-01, 3.174921e-01, 3.175098e-01,
    3.175274e-01, 3.175451e-01, 3.175628e-01, 3.175804e-01, 3.175981e-01, 3.176157e-01,
    3.176334e-01, 3.176511e-01, 3.176687e-01, 3.176864e-01, 3.177041e-01, 3.177217e-01,
    3.177394e-01, 3.177571e-01, 3.177747e-01, 3.177924e-01, 3.178101e-01, 3.178277e-01,
    3.178454e-01, 3.178630e-01, 3.178807e-01, 3.178983e-01, 3.179160e-01, 3.179336e-01,
    3.179513e-01, 3.179690e-01, 3.179867e-01, 3.180043e-01, 3.180220e-01, 3.180396e-01,
    3.180573e-01, 3.180749e-01, 3.180926e-01, 3.181103e-01, 3.181279e-01, 3.181456e-01,
    3.181632e-01, 3.181809e-01, 3.181985e-01, 3.182162e-01, 3.182338e-01, 3.182515e-01,
    3.182692e-01, 3.182868e-01, 3.183045e-01, 3.183221e-01, 3.183398e-01, 3.183574e-01,
    3.183751e-01, 3.183928e-01, 3.184104e-01, 3.184281e-01, 3.184457e-01, 3.184634e-01,
    3.184810e-01, 3.184987e-01, 3.185163e-01, 3.185340e-01, 3.185516e-01, 3.185693e-01,
    3.185869e-01, 3.186046e-01, 3.186222e-01, 3.186399e-01, 3.186575e-01, 3.186752e-01,
    3.186928e-01, 3.187105e-01, 3.187281e-01, 3.187458e-01, 3.187635e-01, 3.187811e-01,
    3.187987e-01, 3.188164e-01, 3.188340e-01, 3.188517e-01, 3.188693e-01, 3.188870e-01,
    3.189046e-01, 3.189223e-01, 3.189399e-01, 3.189576e-01, 3.189752e-01, 3.189929e-01,
    3.190105e-01, 3.190282e-01, 3.190458e-01, 3.190635e-01, 3.190811e-01, 3.190988e-01,
    3.191164e-01, 3.191340e-01, 3.191517e-01, 3.191693e-01, 3.191870e-01, 3.192046e-01,
    3.192223e-01, 3.192399e-01, 3.192576e-01, 3.192752e-01, 3.192928e-01, 3.193105e-01,
    3.193281e-01, 3.193458e-01, 3.193634e-01, 3.193811e-01, 3.193987e-01, 3.194163e-01,
    3.194340e-01, 3.194516e-01, 3.194692e-01, 3.194869e-01, 3.195046e-01, 3.195222e-01,
    3.195398e-01, 3.195575e-01, 3.195751e-01, 3.195927e-01, 3.196104e-01, 3.196280e-01,
    3.196457e-01, 3.196633e-01, 3.196809e-01, 3.196986e-01, 3.197162e-01, 3.197339e-01,
    3.197515e-01, 3.197691e-01, 3.197868e-01, 3.198044e-01, 3.198220e-01, 3.198397e-01,
    3.198573e-01, 3.198750e-01, 3.198926e-01, 3.199102e-01, 3.199279e-01, 3.199455e-01,
    3.199631e-01, 3.199808e-01, 3.199984e-01, 3.200160e-01, 3.200337e-01, 3.200513e-01,
    3.200689e-01, 3.200866e-01, 3.201042e-01, 3.201219e-01, 3.201395e-01, 3.201571e-01,
    3.201747e-01, 3.201924e-01, 3.202100e-01, 3.202276e-01, 3.202453e-01, 3.202629e-01,
    3.202805e-01, 3.202981e-01, 3.203158e-01, 3.203334e-01, 3.203511e-01, 3.203687e-01,
    3.203863e-01, 3.204039e-01, 3.204216e-01, 3.204392e-01, 3.204568e-01, 3.204744e-01,
    3.204921e-01, 3.205097e-01, 3.205273e-01, 3.205450e-01, 3.205626e-01, 3.205802e-01,
    3.205979e-01, 3.206155e-01, 3.206331e-01, 3.206507e-01, 3.206684e-01, 3.206860e-01,
    3.207036e-01, 3.207212e-01, 3.207389e-01, 3.207565e-01, 3.207741e-01, 3.207917e-01,
    3.208094e-01, 3.208270e-01, 3.208446e-01, 3.208622e-01, 3.208798e-01, 3.208975e-01,
    3.209151e-01, 3.209327e-01, 3.209504e-01, 3.209680e-01, 3.209856e-01, 3.210032e-01,
    3.210208e-01, 3.210385e-01, 3.210561e-01, 3.210737e-01, 3.210913e-01, 3.211090e-01,
    3.211266e-01, 3.211442e-01, 3.211618e-01, 3.211794e-01, 3.211971e-01, 3.212147e-01,
    3.212323e-01, 3.212499e-01, 3.212675e-01, 3.212852e-01, 3.213028e-01, 3.213204e-01,
    3.213380e-01, 3.213556e-01, 3.213732e-01, 3.213909e-01, 3.214085e-01, 3.214261e-01,
    3.214437e-01, 3.214613e-01, 3.214789e-01, 3.214966e-01, 3.215142e-01, 3.215318e-01,
    3.215494e-01, 3.215670e-01, 3.215846e-01, 3.216023e-01, 3.216199e-01, 3.216375e-01,
    3.216551e-01, 3.216727e-01, 3.216903e-01, 3.217079e-01, 3.217255e-01, 3.217432e-01,
    3.217608e-01, 3.217784e-01, 3.217960e-01, 3.218136e-01, 3.218312e-01, 3.218488e-01,
    3.218665e-01, 3.218841e-01, 3.219017e-01, 3.219193e-01, 3.219369e-01, 3.219545e-01,
    3.219721e-01, 3.219897e-01, 3.220074e-01, 3.220250e-01, 3.220426e-01, 3.220602e-01,
    3.220778e-01, 3.220954e-01, 3.221130e-01, 3.221306e-01, 3.221482e-01, 3.221658e-01,
    3.221834e-01, 3.222010e-01, 3.222187e-01, 3.222363e-01, 3.222539e-01, 3.222715e-01,
    3.222891e-01, 3.223067e-01, 3.223243e-01, 3.223419e-01, 3.223595e-01, 3.223771e-01,
    3.223947e-01, 3.224123e-01, 3.224299e-01, 3.224475e-01, 3.224651e-01, 3.224827e-01,
    3.225003e-01, 3.225180e-01, 3.225355e-01, 3.225532e-01, 3.225707e-01, 3.225884e-01,
    3.226060e-01, 3.226236e-01, 3.226412e-01, 3.226587e-01, 3.226764e-01, 3.226940e-01,
    3.227116e-01, 3.227292e-01, 3.227468e-01, 3.227644e-01, 3.227820e-01, 3.227996e-01,
    3.228172e-01, 3.228348e-01, 3.228524e-01, 3.228700e-01, 3.228876e-01, 3.229052e-01,
    3.229228e-01, 3.229404e-01, 3.229580e-01, 3.229756e-01, 3.229932e-01, 3.230108e-01,
    3.230284e-01, 3.230460e-01, 3.230636e-01, 3.230811e-01, 3.230987e-01, 3.231163e-01,
    3.231339e-01, 3.231516e-01, 3.231691e-01, 3.231867e-01, 3.232043e-01, 3.232219e-01,
    3.232395e-01, 3.232571e-01, 3.232747e-01, 3.232923e-01, 3.233099e-01, 3.233275e-01,
    3.233451e-01, 3.233627e-01, 3.233803e-01, 3.233979e-01, 3.234155e-01, 3.234330e-01,
    3.234507e-01, 3.234682e-01, 3.234858e-01, 3.235034e-01, 3.235210e-01, 3.235386e-01,
    3.235562e-01, 3.235738e-01, 3.235914e-01, 3.236090e-01, 3.236266e-01, 3.236442e-01,
    3.236617e-01, 3.236793e-01, 3.236969e-01, 3.237145e-01, 3.237321e-01, 3.237497e-01,
    3.237673e-01, 3.237849e-01, 3.238024e-01, 3.238201e-01, 3.238376e-01, 3.238552e-01,
    3.238728e-01, 3.238904e-01, 3.239080e-01, 3.239256e-01, 3.239431e-01, 3.239607e-01,
    3.239783e-01, 3.239959e-01, 3.240135e-01, 3.240311e-01, 3.240487e-01, 3.240663e-01,
    3.240838e-01, 3.241014e-01, 3.241190e-01, 3.241366e-01, 3.241542e-01, 3.241718e-01,
    3.241893e-01, 3.242069e-01, 3.242245e-01, 3.242421e-01, 3.242597e-01, 3.242773e-01,
    3.242948e-01, 3.243124e-01, 3.243300e-01, 3.243476e-01, 3.243652e-01, 3.243827e-01,
    3.244003e-01, 3.244179e-01, 3.244355e-01, 3.244531e-01, 3.244706e-01, 3.244882e-01,
    3.245058e-01, 3.245234e-01, 3.245409e-01, 3.245586e-01, 3.245761e-01, 3.245937e-01,
    3.246113e-01, 3.246289e-01, 3.246464e-01, 3.246640e-01, 3.246816e-01, 3.246992e-01,
    3.247167e-01, 3.247343e-01, 3.247519e-01, 3.247695e-01, 3.247871e-01, 3.248046e-01,
    3.248222e-01, 3.248398e-01, 3.248574e-01, 3.248749e-01, 3.248925e-01, 3.249101e-01,
    3.249277e-01, 3.249452e-01, 3.249628e-01, 3.249804e-01, 3.249980e-01, 3.250155e-01,
    3.250331e-01, 3.250507e-01, 3.250682e-01, 3.250858e-01, 3.251034e-01, 3.251210e-01,
    3.251385e-01, 3.251561e-01, 3.251737e-01, 3.251913e-01, 3.252088e-01, 3.252264e-01,
    3.252439e-01, 3.252615e-01, 3.252791e-01, 3.252967e-01, 3.253142e-01, 3.253318e-01,
    3.253494e-01, 3.253669e-01, 3.253845e-01, 3.254021e-01, 3.254197e-01, 3.254372e-01,
    3.254548e-01, 3.254724e-01, 3.254899e-01, 3.255075e-01, 3.255251e-01, 3.255426e-01,
    3.255602e-01, 3.255778e-01, 3.255953e-01, 3.256129e-01, 3.256305e-01, 3.256480e-01,
    3.256656e-01, 3.256831e-01, 3.257007e-01, 3.257183e-01, 3.257358e-01, 3.257534e-01,
    3.257710e-01, 3.257885e-01, 3.258061e-01, 3.258237e-01, 3.258412e-01, 3.258588e-01,
    3.258764e-01, 3.258939e-01, 3.259115e-01, 3.259290e-01, 3.259466e-01, 3.259642e-01,
    3.259817e-01, 3.259993e-01, 3.260168e-01, 3.260344e-01, 3.260520e-01, 3.260695e-01,
    3.260871e-01, 3.261047e-01, 3.261222e-01, 3.261398e-01, 3.261573e-01, 3.261749e-01,
    3.261925e-01, 3.262100e-01, 3.262276e-01, 3.262451e-01, 3.262627e-01, 3.262803e-01,
    3.262978e-01, 3.263154e-01, 3.263329e-01, 3.263505e-01, 3.263680e-01, 3.263856e-01,
    3.264031e-01, 3.264207e-01, 3.264383e-01, 3.264558e-01, 3.264734e-01, 3.264909e-01,
    3.265085e-01, 3.265260e-01, 3.265436e-01, 3.265612e-01, 3.265787e-01, 3.265963e-01,
    3.266138e-01, 3.266314e-01, 3.266489e-01, 3.266665e-01, 3.266840e-01, 3.267016e-01,
    3.267191e-01, 3.267367e-01, 3.267542e-01, 3.267718e-01, 3.267893e-01, 3.268069e-01,
    3.268245e-01, 3.268420e-01, 3.268595e-01, 3.268771e-01, 3.268946e-01, 3.269122e-01,
    3.269297e-01, 3.269473e-01, 3.269649e-01, 3.269824e-01, 3.269999e-01, 3.270175e-01,
    3.270350e-01, 3.270526e-01, 3.270701e-01, 3.270877e-01, 3.271053e-01, 3.271228e-01,
    3.271403e-01, 3.271579e-01, 3.271754e-01, 3.271930e-01, 3.272105e-01, 3.272281e-01,
    3.272456e-01, 3.272632e-01, 3.272807e-01, 3.272983e-01, 3.273158e-01, 3.273334e-01,
    3.273509e-01, 3.273684e-01, 3.273860e-01, 3.274035e-01, 3.274211e-01, 3.274386e-01,
    3.274561e-01, 3.274737e-01, 3.274912e-01, 3.275088e-01, 3.275263e-01, 3.275439e-01,
    3.275614e-01, 3.275790e-01, 3.275965e-01, 3.276140e-01, 3.276316e-01, 3.276491e-01,
    3.276667e-01, 3.276842e-01, 3.277017e-01, 3.277193e-01, 3.277368e-01, 3.277544e-01,
    3.277719e-01, 3.277895e-01, 3.278070e-01, 3.278245e-01, 3.278421e-01, 3.278596e-01,
    3.278771e-01, 3.278947e-01, 3.279122e-01, 3.279298e-01, 3.279473e-01, 3.279648e-01,
    3.279824e-01, 3.279999e-01, 3.280174e-01, 3.280350e-01, 3.280525e-01, 3.280701e-01,
    3.280876e-01, 3.281051e-01, 3.281227e-01, 3.281402e-01, 3.281577e-01, 3.281753e-01,
    3.281928e-01, 3.282103e-01, 3.282279e-01, 3.282454e-01, 3.282630e-01, 3.282805e-01,
    3.282980e-01, 3.283156e-01, 3.283331e-01, 3.283506e-01, 3.283681e-01, 3.283857e-01,
    3.284032e-01, 3.284207e-01, 3.284383e-01, 3.284558e-01, 3.284733e-01, 3.284909e-01,
    3.285084e-01, 3.285259e-01, 3.285435e-01, 3.285610e-01, 3.285785e-01, 3.285961e-01,
    3.286136e-01, 3.286311e-01, 3.286486e-01, 3.286662e-01, 3.286837e-01, 3.287012e-01,
    3.287188e-01, 3.287363e-01, 3.287538e-01, 3.287713e-01, 3.287889e-01, 3.288064e-01,
    3.288239e-01, 3.288414e-01, 3.288590e-01, 3.288765e-01, 3.288940e-01, 3.289115e-01,
    3.289291e-01, 3.289466e-01, 3.289641e-01, 3.289817e-01, 3.289992e-01, 3.290167e-01,
    3.290342e-01, 3.290517e-01, 3.290693e-01, 3.290868e-01, 3.291043e-01, 3.291219e-01,
    3.291394e-01, 3.291569e-01, 3.291744e-01, 3.291919e-01, 3.292094e-01, 3.292270e-01,
    3.292445e-01, 3.292620e-01, 3.292795e-01, 3.292971e-01, 3.293146e-01, 3.293321e-01,
    3.293496e-01, 3.293672e-01, 3.293847e-01, 3.294022e-01, 3.294197e-01, 3.294372e-01,
    3.294547e-01, 3.294722e-01, 3.294898e-01, 3.295073e-01, 3.295248e-01, 3.295423e-01,
    3.295599e-01, 3.295774e-01, 3.295949e-01, 3.296124e-01, 3.296299e-01, 3.296475e-01,
    3.296650e-01, 3.296825e-01, 3.297000e-01, 3.297175e-01, 3.297350e-01, 3.297525e-01,
    3.297701e-01, 3.297876e-01, 3.298051e-01, 3.298226e-01, 3.298401e-01, 3.298576e-01,
    3.298751e-01, 3.298927e-01, 3.299102e-01, 3.299277e-01, 3.299452e-01, 3.299627e-01,
    3.299802e-01, 3.299977e-01, 3.300152e-01, 3.300328e-01, 3.300503e-01, 3.300678e-01,
    3.300853e-01, 3.301028e-01, 3.301203e-01, 3.301378e-01, 3.301553e-01, 3.301729e-01,
    3.301904e-01, 3.302079e-01, 3.302254e-01, 3.302429e-01, 3.302604e-01, 3.302779e-01,
    3.302954e-01, 3.303130e-01, 3.303305e-01, 3.303480e-01, 3.303655e-01, 3.303830e-01,
    3.304005e-01, 3.304180e-01, 3.304355e-01, 3.304530e-01, 3.304705e-01, 3.304880e-01,
    3.305055e-01, 3.305230e-01, 3.305405e-01, 3.305581e-01, 3.305756e-01, 3.305931e-01,
    3.306106e-01, 3.306281e-01, 3.306456e-01, 3.306631e-01, 3.306806e-01, 3.306981e-01,
    3.307156e-01, 3.307331e-01, 3.307506e-01, 3.307681e-01, 3.307856e-01, 3.308031e-01,
    3.308206e-01, 3.308381e-01, 3.308556e-01, 3.308731e-01, 3.308906e-01, 3.309081e-01,
    3.309256e-01, 3.309431e-01, 3.309606e-01, 3.309781e-01, 3.309956e-01, 3.310131e-01,
    3.310306e-01, 3.310481e-01, 3.310656e-01, 3.310831e-01, 3.311006e-01, 3.311181e-01,
    3.311356e-01, 3.311531e-01, 3.311706e-01, 3.311881e-01, 3.312056e-01, 3.312231e-01,
    3.312406e-01, 3.312581e-01, 3.312756e-01, 3.312931e-01, 3.313106e-01, 3.313281e-01,
    3.313456e-01, 3.313631e-01, 3.313806e-01, 3.313981e-01, 3.314156e-01, 3.314331e-01,
    3.314506e-01, 3.314681e-01, 3.314856e-01, 3.315031e-01, 3.315206e-01, 3.315381e-01,
    3.315555e-01, 3.315730e-01, 3.315905e-01, 3.316080e-01, 3.316255e-01, 3.316430e-01,
    3.316605e-01, 3.316780e-01, 3.316955e-01, 3.317130e-01, 3.317305e-01, 3.317480e-01,
    3.317654e-01, 3.317830e-01, 3.318004e-01, 3.318179e-01, 3.318354e-01, 3.318529e-01,
    3.318704e-01, 3.318879e-01, 3.319054e-01, 3.319229e-01, 3.319404e-01, 3.319578e-01,
    3.319753e-01, 3.319928e-01, 3.320103e-01, 3.320278e-01, 3.320453e-01, 3.320628e-01,
    3.320803e-01, 3.320977e-01, 3.321152e-01, 3.321327e-01, 3.321502e-01, 3.321677e-01,
    3.321852e-01, 3.322027e-01, 3.322202e-01, 3.322377e-01, 3.322551e-01, 3.322726e-01,
    3.322901e-01, 3.323076e-01, 3.323251e-01, 3.323426e-01, 3.323600e-01, 3.323775e-01,
    3.323950e-01, 3.324125e-01, 3.324300e-01, 3.324474e-01, 3.324650e-01, 3.324824e-01,
    3.324999e-01, 3.325174e-01, 3.325348e-01, 3.325524e-01, 3.325698e-01, 3.325873e-01,
    3.326048e-01, 3.326223e-01, 3.326398e-01, 3.326572e-01, 3.326747e-01, 3.326922e-01,
    3.327097e-01, 3.327272e-01, 3.327446e-01, 3.327621e-01, 3.327796e-01, 3.327971e-01,
    3.328145e-01, 3.328320e-01, 3.328495e-01, 3.328670e-01, 3.328845e-01, 3.329019e-01,
    3.329194e-01, 3.329369e-01, 3.329544e-01, 3.329718e-01, 3.329893e-01, 3.330068e-01,
    3.330243e-01, 3.330418e-01, 3.330592e-01, 3.330767e-01, 3.330942e-01, 3.331117e-01,
    3.331291e-01, 3.331466e-01, 3.331641e-01, 3.331816e-01, 3.331990e-01, 3.332165e-01,
    3.332340e-01, 3.332514e-01, 3.332689e-01, 3.332864e-01, 3.333039e-01, 3.333213e-01,
    3.333388e-01, 3.333563e-01, 3.333738e-01, 3.333912e-01, 3.334087e-01, 3.334262e-01,
    3.334437e-01, 3.334611e-01, 3.334786e-01, 3.334961e-01, 3.335135e-01, 3.335310e-01,
    3.335485e-01, 3.335660e-01, 3.335834e-01, 3.336009e-01, 3.336183e-01, 3.336358e-01,
    3.336533e-01, 3.336708e-01, 3.336882e-01, 3.337057e-01, 3.337232e-01, 3.337406e-01,
    3.337581e-01, 3.337756e-01, 3.337930e-01, 3.338105e-01, 3.338279e-01, 3.338454e-01,
    3.338629e-01, 3.338804e-01, 3.338978e-01, 3.339153e-01, 3.339328e-01, 3.339502e-01,
    3.339677e-01, 3.339851e-01, 3.340026e-01, 3.340201e-01, 3.340375e-01, 3.340550e-01,
    3.340725e-01, 3.340899e-01, 3.341074e-01, 3.341249e-01, 3.341423e-01, 3.341598e-01,
    3.341773e-01, 3.341947e-01, 3.342122e-01, 3.342296e-01, 3.342471e-01, 3.342645e-01,
    3.342820e-01, 3.342995e-01, 3.343169e-01, 3.343344e-01, 3.343519e-01, 3.343693e-01,
    3.343868e-01, 3.344042e-01, 3.344217e-01, 3.344392e-01, 3.344566e-01, 3.344741e-01,
    3.344915e-01, 3.345090e-01, 3.345264e-01, 3.345439e-01, 3.345613e-01, 3.345788e-01,
    3.345963e-01, 3.346137e-01, 3.346312e-01, 3.346487e-01, 3.346661e-01, 3.346836e-01,
    3.347010e-01, 3.347185e-01, 3.347359e-01, 3.347534e-01, 3.347708e-01, 3.347883e-01,
    3.348057e-01, 3.348232e-01, 3.348407e-01, 3.348581e-01, 3.348756e-01, 3.348930e-01,
    3.349105e-01, 3.349279e-01, 3.349454e-01, 3.349628e-01, 3.349803e-01, 3.349977e-01,
    3.350152e-01, 3.350326e-01, 3.350501e-01, 3.350675e-01, 3.350850e-01, 3.351024e-01,
    3.351199e-01, 3.351373e-01, 3.351548e-01, 3.351722e-01, 3.351897e-01, 3.352071e-01,
    3.352246e-01, 3.352420e-01, 3.352595e-01, 3.352769e-01, 3.352944e-01, 3.353118e-01,
    3.353293e-01, 3.353467e-01, 3.353642e-01, 3.353816e-01, 3.353991e-01, 3.354165e-01,
    3.354340e-01, 3.354514e-01, 3.354689e-01, 3.354863e-01, 3.355038e-01, 3.355212e-01,
    3.355387e-01, 3.355561e-01, 3.355735e-01, 3.355910e-01, 3.356084e-01, 3.356259e-01,
    3.356433e-01, 3.356608e-01, 3.356782e-01, 3.356957e-01, 3.357131e-01, 3.357305e-01,
    3.357480e-01, 3.357654e-01, 3.357829e-01, 3.358003e-01, 3.358178e-01, 3.358352e-01,
    3.358527e-01, 3.358701e-01, 3.358875e-01, 3.359050e-01, 3.359224e-01, 3.359398e-01,
    3.359573e-01, 3.359747e-01, 3.359922e-01, 3.360096e-01, 3.360271e-01, 3.360445e-01,
    3.360619e-01, 3.360794e-01, 3.360968e-01, 3.361143e-01, 3.361317e-01, 3.361491e-01,
    3.361666e-01, 3.361840e-01, 3.362014e-01, 3.362189e-01, 3.362363e-01, 3.362538e-01,
    3.362712e-01, 3.362886e-01, 3.363061e-01, 3.363235e-01, 3.363409e-01, 3.363584e-01,
    3.363758e-01, 3.363932e-01, 3.364107e-01, 3.364281e-01, 3.364455e-01, 3.364630e-01,
    3.364804e-01, 3.364978e-01, 3.365153e-01, 3.365327e-01, 3.365501e-01, 3.365676e-01,
    3.365850e-01, 3.366024e-01, 3.366199e-01, 3.366373e-01, 3.366548e-01, 3.366722e-01,
    3.366896e-01, 3.367070e-01, 3.367245e-01, 3.367419e-01, 3.367593e-01, 3.367768e-01,
    3.367942e-01, 3.368116e-01, 3.368291e-01, 3.368465e-01, 3.368639e-01, 3.368813e-01,
    3.368988e-01, 3.369162e-01, 3.369336e-01, 3.369510e-01, 3.369685e-01, 3.369859e-01,
    3.370034e-01, 3.370208e-01, 3.370382e-01, 3.370556e-01, 3.370731e-01, 3.370905e-01,
    3.371079e-01, 3.371253e-01, 3.371427e-01, 3.371602e-01, 3.371776e-01, 3.371950e-01,
    3.372125e-01, 3.372299e-01, 3.372473e-01, 3.372647e-01, 3.372822e-01, 3.372996e-01,
    3.373170e-01, 3.373344e-01, 3.373519e-01, 3.373693e-01, 3.373867e-01, 3.374041e-01,
    3.374216e-01, 3.374390e-01, 3.374564e-01, 3.374738e-01, 3.374912e-01, 3.375087e-01,
    3.375261e-01, 3.375435e-01, 3.375609e-01, 3.375784e-01, 3.375958e-01, 3.376132e-01,
    3.376306e-01, 3.376480e-01, 3.376654e-01, 3.376829e-01, 3.377003e-01, 3.377177e-01,
    3.377351e-01, 3.377526e-01, 3.377700e-01, 3.377874e-01, 3.378048e-01, 3.378222e-01,
    3.378396e-01, 3.378571e-01, 3.378745e-01, 3.378919e-01, 3.379093e-01, 3.379267e-01,
    3.379441e-01, 3.379616e-01, 3.379790e-01, 3.379964e-01, 3.380138e-01, 3.380312e-01,
    3.380486e-01, 3.380661e-01, 3.380835e-01, 3.381009e-01, 3.381183e-01, 3.381357e-01,
    3.381531e-01, 3.381705e-01, 3.381880e-01, 3.382054e-01, 3.382228e-01, 3.382402e-01,
    3.382576e-01, 3.382750e-01, 3.382924e-01, 3.383099e-01, 3.383273e-01, 3.383447e-01,
    3.383621e-01, 3.383795e-01, 3.383969e-01, 3.384143e-01, 3.384317e-01, 3.384491e-01,
    3.384666e-01, 3.384840e-01, 3.385014e-01, 3.385188e-01, 3.385362e-01, 3.385536e-01,
    3.385710e-01, 3.385884e-01, 3.386058e-01, 3.386232e-01, 3.386406e-01, 3.386580e-01,
    3.386755e-01, 3.386929e-01, 3.387103e-01, 3.387277e-01, 3.387451e-01, 3.387625e-01,
    3.387799e-01, 3.387973e-01, 3.388147e-01, 3.388321e-01, 3.388495e-01, 3.388669e-01,
    3.388843e-01, 3.389018e-01, 3.389191e-01, 3.389365e-01, 3.389540e-01, 3.389713e-01,
    3.389888e-01, 3.390062e-01, 3.390236e-01, 3.390410e-01, 3.390584e-01, 3.390758e-01,
    3.390932e-01, 3.391106e-01, 3.391280e-01, 3.391454e-01, 3.391628e-01, 3.391802e-01,
    3.391976e-01, 3.392150e-01, 3.392324e-01, 3.392498e-01, 3.392672e-01, 3.392846e-01,
    3.393020e-01, 3.393194e-01, 3.393368e-01, 3.393542e-01, 3.393716e-01, 3.393890e-01,
    3.394064e-01, 3.394238e-01, 3.394412e-01, 3.394586e-01, 3.394760e-01, 3.394934e-01,
    3.395108e-01, 3.395282e-01, 3.395456e-01, 3.395630e-01, 3.395804e-01, 3.395978e-01,
    3.396152e-01, 3.396326e-01, 3.396499e-01, 3.396674e-01, 3.396848e-01, 3.397022e-01,
    3.397195e-01, 3.397369e-01, 3.397543e-01, 3.397717e-01, 3.397891e-01, 3.398065e-01,
    3.398239e-01, 3.398413e-01, 3.398587e-01, 3.398761e-01, 3.398935e-01, 3.399109e-01,
    3.399283e-01, 3.399456e-01, 3.399630e-01, 3.399805e-01, 3.399978e-01, 3.400152e-01,
    3.400326e-01, 3.400500e-01, 3.400674e-01, 3.400848e-01, 3.401022e-01, 3.401196e-01,
    3.401370e-01, 3.401543e-01, 3.401718e-01, 3.401891e-01, 3.402065e-01, 3.402239e-01,
    3.402413e-01, 3.402587e-01, 3.402761e-01, 3.402935e-01, 3.403109e-01, 3.403282e-01,
    3.403456e-01, 3.403630e-01, 3.403804e-01, 3.403978e-01, 3.404152e-01, 3.404326e-01,
    3.404500e-01, 3.404673e-01, 3.404847e-01, 3.405021e-01, 3.405195e-01, 3.405369e-01,
    3.405543e-01, 3.405716e-01, 3.405890e-01, 3.406064e-01, 3.406238e-01, 3.406412e-01,
    3.406586e-01, 3.406760e-01, 3.406934e-01, 3.407107e-01, 3.407281e-01, 3.407455e-01,
    3.407629e-01, 3.407803e-01, 3.407976e-01, 3.408150e-01, 3.408324e-01, 3.408498e-01,
    3.408672e-01, 3.408846e-01, 3.409019e-01, 3.409193e-01, 3.409367e-01, 3.409541e-01,
    3.409714e-01, 3.409888e-01, 3.410062e-01, 3.410236e-01, 3.410410e-01, 3.410583e-01,
    3.410757e-01, 3.410931e-01, 3.411105e-01, 3.411279e-01, 3.411452e-01, 3.411626e-01,
    3.411800e-01, 3.411974e-01, 3.412147e-01, 3.412321e-01, 3.412495e-01, 3.412669e-01,
    3.412843e-01, 3.413016e-01, 3.413190e-01, 3.413364e-01, 3.413538e-01, 3.413711e-01,
    3.413885e-01, 3.414059e-01, 3.414233e-01, 3.414406e-01, 3.414580e-01, 3.414754e-01,
    3.414928e-01, 3.415101e-01, 3.415275e-01, 3.415449e-01, 3.415622e-01, 3.415796e-01,
    3.415970e-01, 3.416144e-01, 3.416317e-01, 3.416491e-01, 3.416665e-01, 3.416839e-01,
    3.417012e-01, 3.417186e-01, 3.417360e-01, 3.417533e-01, 3.417707e-01, 3.417881e-01,
    3.418055e-01, 3.418228e-01, 3.418402e-01, 3.418576e-01, 3.418749e-01, 3.418923e-01,
    3.419097e-01, 3.419271e-01, 3.419444e-01, 3.419618e-01, 3.419791e-01, 3.419965e-01,
    3.420139e-01, 3.420312e-01, 3.420486e-01, 3.420660e-01, 3.420834e-01, 3.421007e-01,
    3.421181e-01, 3.421355e-01, 3.421528e-01, 3.421702e-01, 3.421875e-01, 3.422049e-01,
    3.422223e-01, 3.422396e-01, 3.422570e-01, 3.422744e-01, 3.422917e-01, 3.423091e-01,
    3.423265e-01, 3.423438e-01, 3.423612e-01, 3.423786e-01, 3.423959e-01, 3.424133e-01,
    3.424306e-01, 3.424480e-01, 3.424654e-01, 3.424827e-01, 3.425001e-01, 3.425174e-01,
    3.425348e-01, 3.425522e-01, 3.425695e-01, 3.425869e-01, 3.426042e-01, 3.426216e-01,
    3.426390e-01, 3.426563e-01, 3.426737e-01, 3.426911e-01, 3.427084e-01, 3.427258e-01,
    3.427431e-01, 3.427605e-01, 3.427778e-01, 3.427952e-01, 3.428126e-01, 3.428299e-01,
    3.428473e-01, 3.428646e-01, 3.428820e-01, 3.428994e-01, 3.429167e-01, 3.429341e-01,
    3.429514e-01, 3.429688e-01, 3.429861e-01, 3.430035e-01, 3.430209e-01, 3.430382e-01,
    3.430555e-01, 3.430729e-01, 3.430903e-01, 3.431076e-01, 3.431250e-01, 3.431423e-01,
    3.431597e-01, 3.431771e-01, 3.431944e-01, 3.432117e-01, 3.432291e-01, 3.432465e-01,
    3.432638e-01, 3.432811e-01, 3.432985e-01, 3.433158e-01, 3.433332e-01, 3.433506e-01,
    3.433679e-01, 3.433853e-01, 3.434026e-01, 3.434200e-01, 3.434373e-01, 3.434547e-01,
    3.434720e-01, 3.434893e-01, 3.435067e-01, 3.435241e-01, 3.435414e-01, 3.435588e-01,
    3.435761e-01, 3.435934e-01, 3.436108e-01, 3.436281e-01, 3.436455e-01, 3.436629e-01,
    3.436802e-01, 3.436975e-01, 3.437149e-01, 3.437322e-01, 3.437496e-01, 3.437669e-01,
    3.437843e-01, 3.438016e-01, 3.438190e-01, 3.438363e-01, 3.438537e-01, 3.438710e-01,
    3.438884e-01, 3.439057e-01, 3.439231e-01, 3.439404e-01, 3.439577e-01, 3.439751e-01,
    3.439924e-01, 3.440098e-01, 3.440271e-01, 3.440444e-01, 3.440618e-01, 3.440791e-01,
    3.440965e-01, 3.441138e-01, 3.441311e-01, 3.441485e-01, 3.441659e-01, 3.441832e-01,
    3.442005e-01, 3.442179e-01, 3.442352e-01, 3.442526e-01, 3.442699e-01, 3.442872e-01,
    3.443046e-01, 3.443219e-01, 3.443393e-01, 3.443566e-01, 3.443739e-01, 3.443913e-01,
    3.444086e-01, 3.444259e-01, 3.444433e-01, 3.444606e-01, 3.444780e-01, 3.444953e-01,
    3.445126e-01, 3.445300e-01, 3.445473e-01, 3.445646e-01, 3.445820e-01, 3.445993e-01,
    3.446167e-01, 3.446340e-01, 3.446513e-01, 3.446687e-01, 3.446860e-01, 3.447033e-01,
    3.447207e-01, 3.447380e-01, 3.447554e-01, 3.447727e-01, 3.447900e-01, 3.448074e-01,
    3.448247e-01, 3.448420e-01, 3.448594e-01, 3.448767e-01, 3.448940e-01, 3.449114e-01,
    3.449287e-01, 3.449460e-01, 3.449633e-01, 3.449807e-01, 3.449980e-01, 3.450153e-01,
    3.450327e-01, 3.450500e-01, 3.450674e-01, 3.450847e-01, 3.451020e-01, 3.451193e-01,
    3.451366e-01, 3.451540e-01, 3.451713e-01, 3.451886e-01, 3.452060e-01, 3.452233e-01,
    3.452407e-01, 3.452580e-01, 3.452753e-01, 3.452926e-01, 3.453099e-01, 3.453273e-01,
    3.453446e-01, 3.453619e-01, 3.453793e-01, 3.453966e-01, 3.454139e-01, 3.454312e-01,
    3.454486e-01, 3.454659e-01, 3.454832e-01, 3.455006e-01, 3.455179e-01, 3.455352e-01,
    3.455525e-01, 3.455698e-01, 3.455872e-01, 3.456045e-01, 3.456218e-01, 3.456391e-01,
    3.456565e-01, 3.456738e-01, 3.456911e-01, 3.457084e-01, 3.457257e-01, 3.457431e-01,
    3.457604e-01, 3.457777e-01, 3.457950e-01, 3.458124e-01, 3.458297e-01, 3.458470e-01,
    3.458643e-01, 3.458817e-01, 3.458990e-01, 3.459163e-01, 3.459336e-01, 3.459509e-01,
    3.459682e-01, 3.459856e-01, 3.460029e-01, 3.460202e-01, 3.460375e-01, 3.460549e-01,
    3.460722e-01, 3.460895e-01, 3.461068e-01, 3.461241e-01, 3.461414e-01, 3.461588e-01,
    3.461761e-01, 3.461934e-01, 3.462107e-01, 3.462280e-01, 3.462453e-01, 3.462627e-01,
    3.462800e-01, 3.462973e-01, 3.463146e-01, 3.463319e-01, 3.463492e-01, 3.463666e-01,
    3.463839e-01, 3.464012e-01, 3.464185e-01, 3.464358e-01, 3.464531e-01, 3.464704e-01,
    3.464878e-01, 3.465051e-01, 3.465224e-01, 3.465397e-01, 3.465570e-01, 3.465743e-01,
    3.465917e-01, 3.466090e-01, 3.466263e-01, 3.466436e-01, 3.466609e-01, 3.466782e-01,
    3.466955e-01, 3.467128e-01, 3.467301e-01, 3.467474e-01, 3.467647e-01, 3.467821e-01,
    3.467994e-01, 3.468167e-01, 3.468340e-01, 3.468513e-01, 3.468686e-01, 3.468859e-01,
    3.469032e-01, 3.469205e-01, 3.469378e-01, 3.469552e-01, 3.469725e-01, 3.469898e-01,
    3.470071e-01, 3.470244e-01, 3.470417e-01, 3.470590e-01, 3.470763e-01, 3.470936e-01,
    3.471109e-01, 3.471282e-01, 3.471455e-01, 3.471628e-01, 3.471802e-01, 3.471974e-01,
    3.472148e-01, 3.472321e-01, 3.472494e-01, 3.472667e-01, 3.472840e-01, 3.473013e-01,
    3.473186e-01, 3.473359e-01, 3.473532e-01, 3.473705e-01, 3.473878e-01, 3.474051e-01,
    3.474224e-01, 3.474397e-01, 3.474570e-01, 3.474743e-01, 3.474916e-01, 3.475089e-01,
    3.475262e-01, 3.475435e-01, 3.475608e-01, 3.475781e-01, 3.475954e-01, 3.476127e-01,
    3.476300e-01, 3.476473e-01, 3.476646e-01, 3.476819e-01, 3.476992e-01, 3.477165e-01,
    3.477338e-01, 3.477511e-01, 3.477684e-01, 3.477857e-01, 3.478030e-01, 3.478203e-01,
    3.478376e-01, 3.478549e-01, 3.478722e-01, 3.478895e-01, 3.479068e-01, 3.479241e-01,
    3.479414e-01, 3.479587e-01, 3.479760e-01, 3.479933e-01, 3.480106e-01, 3.480279e-01,
    3.480452e-01, 3.480625e-01, 3.480797e-01, 3.480970e-01, 3.481143e-01, 3.481316e-01,
    3.481489e-01, 3.481662e-01, 3.481835e-01, 3.482008e-01, 3.482181e-01, 3.482354e-01,
    3.482527e-01, 3.482700e-01, 3.482873e-01, 3.483045e-01, 3.483219e-01, 3.483391e-01,
    3.483565e-01, 3.483737e-01, 3.483910e-01, 3.484083e-01, 3.484256e-01, 3.484429e-01,
    3.484602e-01, 3.484775e-01, 3.484948e-01, 3.485121e-01, 3.485293e-01, 3.485467e-01,
    3.485639e-01, 3.485812e-01, 3.485985e-01, 3.486158e-01, 3.486331e-01, 3.486504e-01,
    3.486677e-01, 3.486849e-01, 3.487022e-01, 3.487195e-01, 3.487368e-01, 3.487541e-01,
    3.487714e-01, 3.487886e-01, 3.488059e-01, 3.488232e-01, 3.488405e-01, 3.488578e-01,
    3.488751e-01, 3.488924e-01, 3.489096e-01, 3.489269e-01, 3.489442e-01, 3.489615e-01,
    3.489788e-01, 3.489961e-01, 3.490134e-01, 3.490306e-01, 3.490479e-01, 3.490652e-01,
    3.490825e-01, 3.490998e-01, 3.491171e-01, 3.491344e-01, 3.491516e-01, 3.491689e-01,
    3.491862e-01, 3.492035e-01, 3.492208e-01, 3.492380e-01, 3.492553e-01, 3.492726e-01,
    3.492899e-01, 3.493071e-01, 3.493244e-01, 3.493417e-01, 3.493590e-01, 3.493763e-01,
    3.493935e-01, 3.494108e-01, 3.494281e-01, 3.494454e-01, 3.494627e-01, 3.494799e-01,
    3.494972e-01, 3.495145e-01, 3.495318e-01, 3.495490e-01, 3.495663e-01, 3.495836e-01,
    3.496009e-01, 3.496182e-01, 3.496355e-01, 3.496527e-01, 3.496700e-01, 3.496872e-01,
    3.497045e-01, 3.497218e-01, 3.497391e-01, 3.497564e-01, 3.497736e-01, 3.497909e-01,
    3.498082e-01, 3.498255e-01, 3.498427e-01, 3.498600e-01, 3.498773e-01, 3.498946e-01,
    3.499118e-01, 3.499291e-01, 3.499463e-01, 3.499636e-01, 3.499809e-01, 3.499982e-01,
    3.500155e-01, 3.500327e-01, 3.500500e-01, 3.500673e-01, 3.500845e-01, 3.501018e-01,
    3.501191e-01, 3.501363e-01, 3.501536e-01, 3.501709e-01, 3.501881e-01, 3.502054e-01,
    3.502227e-01, 3.502400e-01, 3.502572e-01, 3.502745e-01, 3.502918e-01, 3.503090e-01,
    3.503263e-01, 3.503436e-01, 3.503608e-01, 3.503781e-01, 3.503954e-01, 3.504126e-01,
    3.504299e-01, 3.504472e-01, 3.504644e-01, 3.504817e-01, 3.504990e-01, 3.505163e-01,
    3.505335e-01, 3.505508e-01, 3.505680e-01, 3.505853e-01, 3.506026e-01, 3.506198e-01,
    3.506371e-01, 3.506544e-01, 3.506716e-01, 3.506889e-01, 3.507061e-01, 3.507234e-01,
    3.507407e-01, 3.507579e-01, 3.507752e-01, 3.507925e-01, 3.508097e-01, 3.508270e-01,
    3.508442e-01, 3.508615e-01, 3.508788e-01, 3.508960e-01, 3.509133e-01, 3.509305e-01,
    3.509478e-01, 3.509651e-01, 3.509823e-01, 3.509996e-01, 3.510168e-01, 3.510341e-01,
    3.510514e-01, 3.510686e-01, 3.510859e-01, 3.511031e-01, 3.511204e-01, 3.511377e-01,
    3.511549e-01, 3.511722e-01, 3.511894e-01, 3.512067e-01, 3.512239e-01, 3.512412e-01,
    3.512585e-01, 3.512757e-01, 3.512930e-01, 3.513102e-01, 3.513275e-01, 3.513448e-01,
    3.513620e-01, 3.513792e-01, 3.513965e-01, 3.514138e-01, 3.514310e-01, 3.514483e-01,
    3.514655e-01, 3.514828e-01, 3.515000e-01, 3.515173e-01, 3.515345e-01, 3.515518e-01,
    3.515690e-01, 3.515863e-01, 3.516035e-01, 3.516208e-01, 3.516380e-01, 3.516553e-01,
    3.516726e-01, 3.516898e-01, 3.517071e-01, 3.517243e-01, 3.517416e-01, 3.517588e-01,
    3.517761e-01, 3.517933e-01, 3.518106e-01, 3.518278e-01, 3.518451e-01, 3.518623e-01,
    3.518796e-01, 3.518968e-01, 3.519140e-01, 3.519313e-01, 3.519486e-01, 3.519658e-01,
    3.519831e-01, 3.520003e-01, 3.520176e-01, 3.520348e-01, 3.520521e-01, 3.520693e-01,
    3.520865e-01, 3.521038e-01, 3.521211e-01, 3.521383e-01, 3.521555e-01, 3.521728e-01,
    3.521900e-01, 3.522073e-01, 3.522245e-01, 3.522418e-01, 3.522590e-01, 3.522762e-01,
    3.522935e-01, 3.523107e-01, 3.523280e-01, 3.523452e-01, 3.523625e-01, 3.523797e-01,
    3.523969e-01, 3.524142e-01, 3.524314e-01, 3.524487e-01, 3.524659e-01, 3.524832e-01,
    3.525004e-01, 3.525177e-01, 3.525349e-01, 3.525521e-01, 3.525694e-01, 3.525866e-01,
    3.526039e-01, 3.526211e-01, 3.526383e-01, 3.526556e-01, 3.526728e-01, 3.526900e-01,
    3.527073e-01, 3.527245e-01, 3.527418e-01, 3.527590e-01, 3.527763e-01, 3.527935e-01,
    3.528107e-01, 3.528280e-01, 3.528452e-01, 3.528624e-01, 3.528797e-01, 3.528969e-01,
    3.529141e-01, 3.529314e-01, 3.529486e-01, 3.529659e-01, 3.529831e-01, 3.530003e-01,
    3.530176e-01, 3.530348e-01, 3.530520e-01, 3.530693e-01, 3.530865e-01, 3.531038e-01,
    3.531210e-01, 3.531382e-01, 3.531555e-01, 3.531727e-01, 3.531899e-01, 3.532071e-01,
    3.532244e-01, 3.532416e-01, 3.532588e-01, 3.532761e-01, 3.532933e-01, 3.533105e-01,
    3.533278e-01, 3.533450e-01, 3.533622e-01, 3.533795e-01, 3.533967e-01, 3.534139e-01,
    3.534312e-01, 3.534484e-01, 3.534656e-01, 3.534828e-01, 3.535001e-01, 3.535173e-01,
    3.535345e-01, 3.535518e-01, 3.535690e-01, 3.535862e-01, 3.536035e-01, 3.536207e-01,
    3.536379e-01, 3.536552e-01, 3.536724e-01, 3.536896e-01, 3.537068e-01, 3.537241e-01,
    3.537413e-01, 3.537585e-01, 3.537757e-01, 3.537929e-01, 3.538102e-01, 3.538274e-01,
    3.538446e-01, 3.538618e-01, 3.538791e-01, 3.538963e-01, 3.539135e-01, 3.539307e-01,
    3.539480e-01, 3.539652e-01, 3.539824e-01, 3.539996e-01, 3.540169e-01, 3.540341e-01,
    3.540513e-01, 3.540685e-01, 3.540858e-01, 3.541030e-01, 3.541202e-01, 3.541375e-01,
    3.541547e-01, 3.541719e-01, 3.541891e-01, 3.542063e-01, 3.542235e-01, 3.542408e-01,
    3.542580e-01, 3.542752e-01, 3.542924e-01, 3.543096e-01, 3.543269e-01, 3.543441e-01,
    3.543613e-01, 3.543785e-01, 3.543957e-01, 3.544130e-01, 3.544302e-01, 3.544474e-01,
    3.544646e-01, 3.544818e-01, 3.544991e-01, 3.545163e-01, 3.545335e-01, 3.545507e-01,
    3.545679e-01, 3.545851e-01, 3.546024e-01, 3.546196e-01, 3.546368e-01, 3.546540e-01,
    3.546712e-01, 3.546884e-01, 3.547057e-01, 3.547229e-01, 3.547401e-01, 3.547573e-01,
    3.547745e-01, 3.547917e-01, 3.548090e-01, 3.548262e-01, 3.548434e-01, 3.548606e-01,
    3.548778e-01, 3.548950e-01, 3.549122e-01, 3.549294e-01, 3.549466e-01, 3.549639e-01,
    3.549811e-01, 3.549983e-01, 3.550155e-01, 3.550327e-01, 3.550499e-01, 3.550671e-01,
    3.550843e-01, 3.551016e-01, 3.551188e-01, 3.551360e-01, 3.551532e-01, 3.551704e-01,
    3.551876e-01, 3.552048e-01, 3.552220e-01, 3.552392e-01, 3.552565e-01, 3.552737e-01,
    3.552909e-01, 3.553081e-01, 3.553253e-01, 3.553425e-01, 3.553597e-01, 3.553769e-01,
    3.553941e-01, 3.554113e-01, 3.554285e-01, 3.554457e-01, 3.554629e-01, 3.554801e-01,
    3.554974e-01, 3.555146e-01, 3.555318e-01, 3.555490e-01, 3.555662e-01, 3.555834e-01,
    3.556006e-01, 3.556178e-01, 3.556350e-01, 3.556522e-01, 3.556694e-01, 3.556866e-01,
    3.557038e-01, 3.557210e-01, 3.557382e-01, 3.557554e-01, 3.557726e-01, 3.557898e-01,
    3.558070e-01, 3.558242e-01, 3.558414e-01, 3.558586e-01, 3.558758e-01, 3.558930e-01,
    3.559102e-01, 3.559274e-01, 3.559446e-01, 3.559618e-01, 3.559791e-01, 3.559963e-01,
    3.560134e-01, 3.560306e-01, 3.560478e-01, 3.560650e-01, 3.560822e-01, 3.560994e-01,
    3.561166e-01, 3.561338e-01, 3.561510e-01, 3.561682e-01, 3.561854e-01, 3.562026e-01,
    3.562198e-01, 3.562370e-01, 3.562542e-01, 3.562714e-01, 3.562886e-01, 3.563058e-01,
    3.563230e-01, 3.563402e-01, 3.563574e-01, 3.563746e-01, 3.563918e-01, 3.564090e-01,
    3.564262e-01, 3.564434e-01, 3.564606e-01, 3.564778e-01, 3.564949e-01, 3.565122e-01,
    3.565294e-01, 3.565466e-01, 3.565637e-01, 3.565809e-01, 3.565981e-01, 3.566153e-01,
    3.566325e-01, 3.566497e-01, 3.566669e-01, 3.566841e-01, 3.567013e-01, 3.567185e-01,
    3.567356e-01, 3.567528e-01, 3.567700e-01, 3.567872e-01, 3.568044e-01, 3.568216e-01,
    3.568388e-01, 3.568560e-01, 3.568732e-01, 3.568904e-01, 3.569075e-01, 3.569247e-01,
    3.569419e-01, 3.569591e-01, 3.569763e-01, 3.569935e-01, 3.570107e-01, 3.570279e-01,
    3.570451e-01, 3.570623e-01, 3.570794e-01, 3.570966e-01, 3.571138e-01, 3.571310e-01,
    3.571482e-01, 3.571654e-01, 3.571826e-01, 3.571997e-01, 3.572169e-01, 3.572341e-01,
    3.572513e-01, 3.572685e-01, 3.572856e-01, 3.573028e-01, 3.573200e-01, 3.573372e-01,
    3.573544e-01, 3.573716e-01, 3.573888e-01, 3.574060e-01, 3.574231e-01, 3.574403e-01,
    3.574575e-01, 3.574747e-01, 3.574919e-01, 3.575090e-01, 3.575262e-01, 3.575434e-01,
    3.575606e-01, 3.575778e-01, 3.575949e-01, 3.576121e-01, 3.576293e-01, 3.576465e-01,
    3.576637e-01, 3.576809e-01, 3.576980e-01, 3.577152e-01, 3.577324e-01, 3.577496e-01,
    3.577667e-01, 3.577839e-01, 3.578011e-01, 3.578183e-01, 3.578355e-01, 3.578526e-01,
    3.578698e-01, 3.578870e-01, 3.579042e-01, 3.579214e-01, 3.579385e-01, 3.579557e-01,
    3.579729e-01, 3.579901e-01, 3.580072e-01, 3.580244e-01, 3.580416e-01, 3.580588e-01,
    3.580759e-01, 3.580931e-01, 3.581103e-01, 3.581275e-01, 3.581446e-01, 3.581618e-01,
    3.581790e-01, 3.581962e-01, 3.582133e-01, 3.582305e-01, 3.582477e-01, 3.582649e-01,
    3.582820e-01, 3.582992e-01, 3.583164e-01, 3.583336e-01, 3.583507e-01, 3.583679e-01,
    3.583851e-01, 3.584022e-01, 3.584194e-01, 3.584366e-01, 3.584538e-01, 3.584709e-01,
    3.584881e-01, 3.585052e-01, 3.585224e-01, 3.585396e-01, 3.585567e-01, 3.585739e-01,
    3.585911e-01, 3.586083e-01, 3.586254e-01, 3.586426e-01, 3.586598e-01, 3.586769e-01,
    3.586941e-01, 3.587113e-01, 3.587285e-01, 3.587456e-01, 3.587628e-01, 3.587799e-01,
    3.587971e-01, 3.588143e-01, 3.588315e-01, 3.588486e-01, 3.588658e-01, 3.588829e-01,
    3.589001e-01, 3.589173e-01, 3.589345e-01, 3.589516e-01, 3.589688e-01, 3.589859e-01,
    3.590031e-01, 3.590203e-01, 3.590374e-01, 3.590546e-01, 3.590718e-01, 3.590889e-01,
    3.591061e-01, 3.591233e-01, 3.591404e-01, 3.591576e-01, 3.591747e-01, 3.591919e-01,
    3.592091e-01, 3.592262e-01, 3.592434e-01, 3.592606e-01, 3.592777e-01, 3.592949e-01,
    3.593120e-01, 3.593292e-01, 3.593464e-01, 3.593635e-01, 3.593807e-01, 3.593978e-01,
    3.594150e-01, 3.594322e-01, 3.594493e-01, 3.594665e-01, 3.594836e-01, 3.595008e-01,
    3.595180e-01, 3.595351e-01, 3.595523e-01, 3.595694e-01, 3.595866e-01, 3.596037e-01,
    3.596209e-01, 3.596380e-01, 3.596552e-01, 3.596724e-01, 3.596895e-01, 3.597067e-01,
    3.597238e-01, 3.597410e-01, 3.597581e-01, 3.597753e-01, 3.597924e-01, 3.598096e-01,
    3.598268e-01, 3.598439e-01, 3.598610e-01, 3.598782e-01, 3.598954e-01, 3.599125e-01,
    3.599297e-01, 3.599468e-01, 3.599640e-01, 3.599811e-01, 3.599983e-01, 3.600155e-01,
    3.600326e-01, 3.600498e-01, 3.600669e-01, 3.600841e-01, 3.601012e-01, 3.601183e-01,
    3.601355e-01, 3.601527e-01, 3.601698e-01, 3.601870e-01, 3.602041e-01, 3.602212e-01,
    3.602384e-01, 3.602556e-01, 3.602727e-01, 3.602898e-01, 3.603070e-01, 3.603241e-01,
    3.603413e-01, 3.603584e-01, 3.603756e-01, 3.603927e-01, 3.604099e-01, 3.604270e-01,
    3.604442e-01, 3.604613e-01, 3.604785e-01, 3.604956e-01, 3.605128e-01, 3.605299e-01,
    3.605471e-01, 3.605642e-01, 3.605814e-01, 3.605985e-01, 3.606156e-01, 3.606328e-01,
    3.606499e-01, 3.606671e-01, 3.606842e-01, 3.607014e-01, 3.607185e-01, 3.607357e-01,
    3.607528e-01, 3.607699e-01, 3.607871e-01, 3.608042e-01, 3.608214e-01, 3.608385e-01,
    3.608557e-01, 3.608728e-01, 3.608899e-01, 3.609071e-01, 3.609242e-01, 3.609414e-01,
    3.609585e-01, 3.609756e-01, 3.609928e-01, 3.610100e-01, 3.610271e-01, 3.610442e-01,
    3.610614e-01, 3.610785e-01, 3.610956e-01, 3.611127e-01, 3.611299e-01, 3.611470e-01,
    3.611642e-01, 3.611813e-01, 3.611985e-01, 3.612156e-01, 3.612328e-01, 3.612499e-01,
    3.612670e-01, 3.612841e-01, 3.613013e-01, 3.613184e-01, 3.613355e-01, 3.613527e-01,
    3.613698e-01, 3.613870e-01, 3.614041e-01, 3.614212e-01, 3.614384e-01, 3.614555e-01,
    3.614727e-01, 3.614898e-01, 3.615069e-01, 3.615240e-01, 3.615412e-01, 3.615583e-01,
    3.615755e-01, 3.615926e-01, 3.616097e-01, 3.616268e-01, 3.616440e-01, 3.616611e-01,
    3.616782e-01, 3.616954e-01, 3.617125e-01, 3.617297e-01, 3.617468e-01, 3.617639e-01,
    3.617810e-01, 3.617982e-01, 3.618153e-01, 3.618324e-01, 3.618496e-01, 3.618667e-01,
    3.618838e-01, 3.619010e-01, 3.619181e-01, 3.619352e-01, 3.619523e-01, 3.619695e-01,
    3.619866e-01, 3.620037e-01, 3.620209e-01, 3.620380e-01, 3.620551e-01, 3.620722e-01,
    3.620893e-01, 3.621065e-01, 3.621236e-01, 3.621407e-01, 3.621579e-01, 3.621750e-01,
    3.621921e-01, 3.622093e-01, 3.622264e-01, 3.622435e-01, 3.622606e-01, 3.622777e-01,
    3.622949e-01, 3.623120e-01, 3.623291e-01, 3.623463e-01, 3.623634e-01, 3.623805e-01,
    3.623976e-01, 3.624147e-01, 3.624319e-01, 3.624490e-01, 3.624661e-01, 3.624832e-01,
    3.625004e-01, 3.625175e-01, 3.625346e-01, 3.625517e-01, 3.625688e-01, 3.625860e-01,
    3.626031e-01, 3.626202e-01, 3.626373e-01, 3.626545e-01, 3.626716e-01, 3.626887e-01,
    3.627058e-01, 3.627229e-01, 3.627400e-01, 3.627572e-01, 3.627743e-01, 3.627914e-01,
    3.628085e-01, 3.628257e-01, 3.628428e-01, 3.628599e-01, 3.628770e-01, 3.628941e-01,
    3.629113e-01, 3.629284e-01, 3.629455e-01, 3.629626e-01, 3.629797e-01, 3.629968e-01,
    3.630140e-01, 3.630311e-01, 3.630482e-01, 3.630653e-01, 3.630824e-01, 3.630995e-01,
    3.631167e-01, 3.631338e-01, 3.631509e-01, 3.631680e-01, 3.631851e-01, 3.632022e-01,
    3.632193e-01, 3.632365e-01, 3.632536e-01, 3.632707e-01, 3.632878e-01, 3.633049e-01,
    3.633220e-01, 3.633392e-01, 3.633563e-01, 3.633734e-01, 3.633905e-01, 3.634076e-01,
    3.634247e-01, 3.634418e-01, 3.634589e-01, 3.634760e-01, 3.634931e-01, 3.635103e-01,
    3.635274e-01, 3.635445e-01, 3.635616e-01, 3.635787e-01, 3.635958e-01, 3.636129e-01,
    3.636300e-01, 3.636471e-01, 3.636642e-01, 3.636813e-01, 3.636985e-01, 3.637156e-01,
    3.637327e-01, 3.637498e-01, 3.637669e-01, 3.637840e-01, 3.638011e-01, 3.638182e-01,
    3.638353e-01, 3.638524e-01, 3.638695e-01, 3.638867e-01, 3.639037e-01, 3.639208e-01,
    3.639379e-01, 3.639551e-01, 3.639722e-01, 3.639893e-01, 3.640063e-01, 3.640235e-01,
    3.640406e-01, 3.640577e-01, 3.640748e-01, 3.640919e-01, 3.641090e-01, 3.641261e-01,
    3.641432e-01, 3.641603e-01, 3.641774e-01, 3.641945e-01, 3.642116e-01, 3.642287e-01,
    3.642458e-01, 3.642629e-01, 3.642800e-01, 3.642971e-01, 3.643143e-01, 3.643313e-01,
    3.643484e-01, 3.643655e-01, 3.643827e-01, 3.643997e-01, 3.644168e-01, 3.644339e-01,
    3.644510e-01, 3.644681e-01, 3.644852e-01, 3.645023e-01, 3.645194e-01, 3.645365e-01,
    3.645536e-01, 3.645707e-01, 3.645878e-01, 3.646049e-01, 3.646220e-01, 3.646391e-01,
    3.646562e-01, 3.646733e-01, 3.646904e-01, 3.647075e-01, 3.647246e-01, 3.647417e-01,
    3.647588e-01, 3.647759e-01, 3.647930e-01, 3.648101e-01, 3.648272e-01, 3.648443e-01,
    3.648614e-01, 3.648784e-01, 3.648956e-01, 3.649127e-01, 3.649297e-01, 3.649468e-01,
    3.649639e-01, 3.649810e-01, 3.649981e-01, 3.650152e-01, 3.650323e-01, 3.650494e-01,
    3.650665e-01, 3.650836e-01, 3.651007e-01, 3.651178e-01, 3.651349e-01, 3.651519e-01,
    3.651690e-01, 3.651861e-01, 3.652032e-01, 3.652203e-01, 3.652374e-01, 3.652545e-01,
    3.652716e-01, 3.652886e-01, 3.653058e-01, 3.653228e-01, 3.653399e-01, 3.653570e-01,
    3.653741e-01, 3.653912e-01, 3.654083e-01, 3.654254e-01, 3.654425e-01, 3.654596e-01,
    3.654766e-01, 3.654937e-01, 3.655108e-01, 3.655279e-01, 3.655450e-01, 3.655621e-01,
    3.655792e-01, 3.655962e-01, 3.656133e-01, 3.656304e-01, 3.656475e-01, 3.656646e-01,
    3.656817e-01, 3.656988e-01, 3.657159e-01, 3.657329e-01, 3.657500e-01, 3.657671e-01,
    3.657842e-01, 3.658012e-01, 3.658184e-01, 3.658354e-01, 3.658525e-01, 3.658696e-01,
    3.658867e-01, 3.659038e-01, 3.659208e-01, 3.659379e-01, 3.659550e-01, 3.659721e-01,
    3.659892e-01, 3.660063e-01, 3.660233e-01, 3.660404e-01, 3.660575e-01, 3.660746e-01,
    3.660916e-01, 3.661087e-01, 3.661258e-01, 3.661429e-01, 3.661600e-01, 3.661770e-01,
    3.661942e-01, 3.662112e-01, 3.662283e-01, 3.662454e-01, 3.662624e-01, 3.662795e-01,
    3.662966e-01, 3.663137e-01, 3.663307e-01, 3.663478e-01, 3.663649e-01, 3.663820e-01,
    3.663990e-01, 3.664161e-01, 3.664332e-01, 3.664503e-01, 3.664674e-01, 3.664845e-01,
    3.665015e-01, 3.665186e-01, 3.665357e-01, 3.665527e-01, 3.665698e-01, 3.665869e-01,
    3.666040e-01, 3.666210e-01, 3.666381e-01, 3.666552e-01, 3.666722e-01, 3.666893e-01,
    3.667064e-01, 3.667235e-01, 3.667405e-01, 3.667576e-01, 3.667747e-01, 3.667918e-01,
    3.668089e-01, 3.668259e-01, 3.668430e-01, 3.668601e-01, 3.668771e-01, 3.668942e-01,
    3.669113e-01, 3.669283e-01, 3.669454e-01, 3.669625e-01, 3.669795e-01, 3.669966e-01,
    3.670137e-01, 3.670307e-01, 3.670478e-01, 3.670649e-01, 3.670820e-01, 3.670990e-01,
    3.671161e-01, 3.671332e-01, 3.671502e-01, 3.671673e-01, 3.671844e-01, 3.672014e-01,
    3.672185e-01, 3.672355e-01, 3.672526e-01, 3.672697e-01, 3.672867e-01, 3.673038e-01,
    3.673209e-01, 3.673380e-01, 3.673550e-01, 3.673721e-01, 3.673892e-01, 3.674062e-01,
    3.674233e-01, 3.674403e-01, 3.674574e-01, 3.674745e-01, 3.674915e-01, 3.675086e-01,
    3.675257e-01, 3.675427e-01, 3.675598e-01, 3.675768e-01, 3.675939e-01, 3.676110e-01,
    3.676280e-01, 3.676451e-01, 3.676621e-01, 3.676792e-01, 3.676963e-01, 3.677134e-01,
    3.677304e-01, 3.677475e-01, 3.677645e-01, 3.677816e-01, 3.677987e-01, 3.678157e-01,
    3.678328e-01, 3.678498e-01, 3.678669e-01, 3.678840e-01, 3.679010e-01, 3.679180e-01,
    3.679351e-01, 3.679522e-01, 3.679692e-01, 3.679863e-01, 3.680034e-01, 3.680204e-01,
    3.680375e-01, 3.680545e-01, 3.680716e-01, 3.680886e-01, 3.681057e-01, 3.681228e-01,
    3.681398e-01, 3.681569e-01, 3.681739e-01, 3.681910e-01, 3.682080e-01, 3.682251e-01,
    3.682421e-01, 3.682592e-01, 3.682762e-01, 3.682933e-01, 3.683104e-01, 3.683274e-01,
    3.683445e-01, 3.683615e-01, 3.683786e-01, 3.683956e-01, 3.684127e-01, 3.684298e-01,
    3.684468e-01, 3.684638e-01, 3.684809e-01, 3.684979e-01, 3.685150e-01, 3.685320e-01,
    3.685491e-01, 3.685661e-01, 3.685832e-01, 3.686002e-01, 3.686173e-01, 3.686343e-01,
    3.686514e-01, 3.686685e-01, 3.686855e-01, 3.687026e-01, 3.687196e-01, 3.687367e-01,
    3.687537e-01, 3.687707e-01, 3.687878e-01, 3.688048e-01, 3.688219e-01, 3.688389e-01,
    3.688560e-01, 3.688730e-01, 3.688900e-01, 3.689071e-01, 3.689241e-01, 3.689412e-01,
    3.689582e-01, 3.689753e-01, 3.689924e-01, 3.690094e-01, 3.690265e-01, 3.690435e-01,
    3.690605e-01, 3.690776e-01, 3.690946e-01, 3.691117e-01, 3.691287e-01, 3.691458e-01,
    3.691628e-01, 3.691798e-01, 3.691969e-01, 3.692139e-01, 3.692310e-01, 3.692480e-01,
    3.692651e-01, 3.692821e-01, 3.692991e-01, 3.693162e-01, 3.693332e-01, 3.693503e-01,
    3.693673e-01, 3.693843e-01, 3.694014e-01, 3.694184e-01, 3.694355e-01, 3.694525e-01,
    3.694696e-01, 3.694866e-01, 3.695036e-01, 3.695207e-01, 3.695377e-01, 3.695547e-01,
    3.695718e-01, 3.695888e-01, 3.696058e-01, 3.696229e-01, 3.696399e-01, 3.696570e-01,
    3.696740e-01, 3.696911e-01, 3.697081e-01, 3.697251e-01, 3.697422e-01, 3.697592e-01,
    3.697762e-01, 3.697933e-01, 3.698103e-01, 3.698274e-01, 3.698444e-01, 3.698614e-01,
    3.698784e-01, 3.698955e-01, 3.699125e-01, 3.699296e-01, 3.699466e-01, 3.699636e-01,
    3.699806e-01, 3.699977e-01, 3.700147e-01, 3.700318e-01, 3.700488e-01, 3.700658e-01,
    3.700829e-01, 3.700999e-01, 3.701169e-01, 3.701340e-01, 3.701510e-01, 3.701680e-01,
    3.701850e-01, 3.702021e-01, 3.702191e-01, 3.702362e-01, 3.702532e-01, 3.702702e-01,
    3.702872e-01, 3.703043e-01, 3.703213e-01, 3.703383e-01, 3.703553e-01, 3.703724e-01,
    3.703894e-01, 3.704065e-01, 3.704235e-01, 3.704405e-01, 3.704576e-01, 3.704746e-01,
    3.704916e-01, 3.705086e-01, 3.705257e-01, 3.705427e-01, 3.705597e-01, 3.705767e-01,
    3.705938e-01, 3.706108e-01, 3.706278e-01, 3.706448e-01, 3.706619e-01, 3.706789e-01,
    3.706959e-01, 3.707129e-01, 3.707300e-01, 3.707470e-01, 3.707640e-01, 3.707811e-01,
    3.707981e-01, 3.708151e-01, 3.708321e-01, 3.708492e-01, 3.708662e-01, 3.708832e-01,
    3.709002e-01, 3.709172e-01, 3.709342e-01, 3.709513e-01, 3.709683e-01, 3.709853e-01,
    3.710023e-01, 3.710194e-01, 3.710364e-01, 3.710534e-01, 3.710704e-01, 3.710874e-01,
    3.711045e-01, 3.711215e-01, 3.711385e-01, 3.711555e-01, 3.711726e-01, 3.711896e-01,
    3.712066e-01, 3.712236e-01, 3.712406e-01, 3.712577e-01, 3.712747e-01, 3.712917e-01,
    3.713087e-01, 3.713257e-01, 3.713427e-01, 3.713598e-01, 3.713768e-01, 3.713938e-01,
    3.714108e-01, 3.714278e-01, 3.714449e-01, 3.714619e-01, 3.714789e-01, 3.714959e-01,
    3.715129e-01, 3.715299e-01, 3.715469e-01, 3.715640e-01, 3.715810e-01, 3.715980e-01,
    3.716150e-01, 3.716320e-01, 3.716491e-01, 3.716661e-01, 3.716831e-01, 3.717001e-01,
    3.717171e-01, 3.717341e-01, 3.717511e-01, 3.717681e-01, 3.717851e-01, 3.718022e-01,
    3.718192e-01, 3.718362e-01, 3.718532e-01, 3.718702e-01, 3.718872e-01, 3.719042e-01,
    3.719212e-01, 3.719382e-01, 3.719553e-01, 3.719723e-01, 3.719893e-01, 3.720063e-01,
    3.720233e-01, 3.720403e-01, 3.720573e-01, 3.720743e-01, 3.720914e-01, 3.721084e-01,
    3.721254e-01, 3.721424e-01, 3.721594e-01, 3.721764e-01, 3.721934e-01, 3.722104e-01,
    3.722274e-01, 3.722444e-01, 3.722614e-01, 3.722784e-01, 3.722954e-01, 3.723125e-01,
    3.723294e-01, 3.723465e-01, 3.723634e-01, 3.723805e-01, 3.723975e-01, 3.724145e-01,
    3.724315e-01, 3.724485e-01, 3.724655e-01, 3.724825e-01, 3.724995e-01, 3.725165e-01,
    3.725335e-01, 3.725505e-01, 3.725675e-01, 3.725846e-01, 3.726015e-01, 3.726186e-01,
    3.726355e-01, 3.726525e-01, 3.726695e-01, 3.726865e-01, 3.727036e-01, 3.727205e-01,
    3.727376e-01, 3.727545e-01, 3.727715e-01, 3.727885e-01, 3.728055e-01, 3.728226e-01,
    3.728395e-01, 3.728566e-01, 3.728736e-01, 3.728905e-01, 3.729076e-01, 3.729246e-01,
    3.729416e-01, 3.729586e-01, 3.729756e-01, 3.729926e-01, 3.730096e-01, 3.730265e-01,
    3.730436e-01, 3.730606e-01, 3.730775e-01, 3.730946e-01, 3.731115e-01, 3.731285e-01,
    3.731456e-01, 3.731625e-01, 3.731795e-01, 3.731965e-01, 3.732135e-01, 3.732305e-01,
    3.732475e-01, 3.732645e-01, 3.732815e-01, 3.732985e-01, 3.733155e-01, 3.733325e-01,
    3.733495e-01, 3.733665e-01, 3.733835e-01, 3.734005e-01, 3.734175e-01, 3.734345e-01,
    3.734514e-01, 3.734685e-01, 3.734854e-01, 3.735024e-01, 3.735194e-01, 3.735364e-01,
    3.735534e-01, 3.735704e-01, 3.735874e-01, 3.736044e-01, 3.736213e-01, 3.736384e-01,
    3.736553e-01, 3.736723e-01, 3.736893e-01, 3.737063e-01, 3.737233e-01, 3.737403e-01,
    3.737573e-01, 3.737743e-01, 3.737913e-01, 3.738082e-01, 3.738252e-01, 3.738422e-01,
    3.738592e-01, 3.738762e-01, 3.738932e-01, 3.739102e-01, 3.739272e-01, 3.739442e-01,
    3.739612e-01, 3.739781e-01, 3.739951e-01, 3.740121e-01, 3.740291e-01, 3.740461e-01,
    3.740631e-01, 3.740801e-01, 3.740970e-01, 3.741140e-01, 3.741310e-01, 3.741480e-01,
    3.741650e-01, 3.741820e-01, 3.741989e-01, 3.742159e-01, 3.742329e-01, 3.742499e-01,
    3.742669e-01, 3.742839e-01, 3.743008e-01, 3.743178e-01, 3.743348e-01, 3.743518e-01,
    3.743688e-01, 3.743858e-01, 3.744028e-01, 3.744197e-01, 3.744367e-01, 3.744537e-01,
    3.744707e-01, 3.744877e-01, 3.745047e-01, 3.745216e-01, 3.745386e-01, 3.745556e-01,
    3.745725e-01, 3.745895e-01, 3.746065e-01, 3.746235e-01, 3.746405e-01, 3.746575e-01,
    3.746744e-01, 3.746914e-01, 3.747084e-01, 3.747254e-01, 3.747423e-01, 3.747593e-01,
    3.747763e-01, 3.747933e-01, 3.748102e-01, 3.748272e-01, 3.748442e-01, 3.748612e-01,
    3.748781e-01, 3.748951e-01, 3.749121e-01, 3.749291e-01, 3.749461e-01, 3.749630e-01,
    3.749800e-01, 3.749970e-01, 3.750140e-01, 3.750310e-01, 3.750479e-01, 3.750649e-01,
    3.750819e-01, 3.750989e-01, 3.751158e-01, 3.751328e-01, 3.751498e-01, 3.751667e-01,
    3.751837e-01, 3.752007e-01, 3.752176e-01, 3.752346e-01, 3.752516e-01, 3.752685e-01,
    3.752855e-01, 3.753025e-01, 3.753195e-01, 3.753364e-01, 3.753534e-01, 3.753704e-01,
    3.753873e-01, 3.754043e-01, 3.754213e-01, 3.754382e-01, 3.754552e-01, 3.754722e-01,
    3.754892e-01, 3.755061e-01, 3.755231e-01, 3.755401e-01, 3.755571e-01, 3.755740e-01,
    3.755910e-01, 3.756080e-01, 3.756250e-01, 3.756419e-01, 3.756589e-01, 3.756759e-01,
    3.756928e-01, 3.757098e-01, 3.757267e-01, 3.757437e-01, 3.757607e-01, 3.757776e-01,
    3.757946e-01, 3.758115e-01, 3.758285e-01, 3.758455e-01, 3.758624e-01, 3.758794e-01,
    3.758964e-01, 3.759134e-01, 3.759303e-01, 3.759473e-01, 3.759643e-01, 3.759812e-01,
    3.759982e-01, 3.760151e-01, 3.760321e-01, 3.760490e-01, 3.760660e-01, 3.760830e-01,
    3.760999e-01, 3.761169e-01, 3.761339e-01, 3.761508e-01, 3.761678e-01, 3.761847e-01,
    3.762017e-01, 3.762187e-01, 3.762357e-01, 3.762526e-01, 3.762696e-01, 3.762865e-01,
    3.763035e-01, 3.763205e-01, 3.763374e-01, 3.763544e-01, 3.763713e-01, 3.763883e-01,
    3.764052e-01, 3.764222e-01, 3.764392e-01, 3.764561e-01, 3.764731e-01, 3.764900e-01,
    3.765070e-01, 3.765239e-01, 3.765409e-01, 3.765579e-01, 3.765748e-01, 3.765917e-01,
    3.766087e-01, 3.766257e-01, 3.766426e-01, 3.766596e-01, 3.766765e-01, 3.766935e-01,
    3.767104e-01, 3.767274e-01, 3.767444e-01, 3.767613e-01, 3.767782e-01, 3.767952e-01,
    3.768122e-01, 3.768291e-01, 3.768461e-01, 3.768630e-01, 3.768800e-01, 3.768969e-01,
    3.769139e-01, 3.769309e-01, 3.769478e-01, 3.769647e-01, 3.769817e-01, 3.769987e-01,
    3.770156e-01, 3.770325e-01, 3.770495e-01, 3.770665e-01, 3.770834e-01, 3.771003e-01,
    3.771173e-01, 3.771343e-01, 3.771512e-01, 3.771681e-01, 3.771851e-01, 3.772021e-01,
    3.772190e-01, 3.772359e-01, 3.772529e-01, 3.772699e-01, 3.772868e-01, 3.773037e-01,
    3.773207e-01, 3.773376e-01, 3.773546e-01, 3.773715e-01, 3.773885e-01, 3.774054e-01,
    3.774224e-01, 3.774393e-01, 3.774562e-01, 3.774732e-01, 3.774902e-01, 3.775071e-01,
    3.775240e-01, 3.775410e-01, 3.775579e-01, 3.775749e-01, 3.775918e-01, 3.776088e-01,
    3.776257e-01, 3.776426e-01, 3.776596e-01, 3.776766e-01, 3.776935e-01, 3.777104e-01,
    3.777274e-01, 3.777443e-01, 3.777613e-01, 3.777782e-01, 3.777952e-01, 3.778121e-01,
    3.778290e-01, 3.778460e-01, 3.778629e-01, 3.778799e-01, 3.778968e-01, 3.779137e-01,
    3.779307e-01, 3.779476e-01, 3.779646e-01, 3.779815e-01, 3.779984e-01, 3.780154e-01,
    3.780323e-01, 3.780493e-01, 3.780662e-01, 3.780831e-01, 3.781001e-01, 3.781170e-01,
    3.781340e-01, 3.781509e-01, 3.781678e-01, 3.781848e-01, 3.782017e-01, 3.782187e-01,
    3.782356e-01, 3.782525e-01, 3.782694e-01, 3.782864e-01, 3.783033e-01, 3.783202e-01,
    3.783372e-01, 3.783541e-01, 3.783711e-01, 3.783880e-01, 3.784049e-01, 3.784218e-01,
    3.784388e-01, 3.784557e-01, 3.784727e-01, 3.784896e-01, 3.785065e-01, 3.785235e-01,
    3.785404e-01, 3.785573e-01, 3.785743e-01, 3.785912e-01, 3.786082e-01, 3.786251e-01,
    3.786420e-01, 3.786589e-01, 3.786759e-01, 3.786928e-01, 3.787098e-01, 3.787267e-01,
    3.787436e-01, 3.787605e-01, 3.787775e-01, 3.787944e-01, 3.788113e-01, 3.788283e-01,
    3.788452e-01, 3.788621e-01, 3.788790e-01, 3.788960e-01, 3.789129e-01, 3.789298e-01,
    3.789468e-01, 3.789637e-01, 3.789806e-01, 3.789975e-01, 3.790145e-01, 3.790314e-01,
    3.790483e-01, 3.790652e-01, 3.790822e-01, 3.790991e-01, 3.791160e-01, 3.791330e-01,
    3.791499e-01, 3.791668e-01, 3.791837e-01, 3.792007e-01, 3.792176e-01, 3.792345e-01,
    3.792515e-01, 3.792683e-01, 3.792853e-01, 3.793022e-01, 3.793191e-01, 3.793361e-01,
    3.793530e-01, 3.793699e-01, 3.793868e-01, 3.794037e-01, 3.794207e-01, 3.794376e-01,
    3.794545e-01, 3.794715e-01, 3.794883e-01, 3.795053e-01, 3.795222e-01, 3.795391e-01,
    3.795560e-01, 3.795730e-01, 3.795899e-01, 3.796068e-01, 3.796237e-01, 3.796406e-01,
    3.796576e-01, 3.796745e-01, 3.796914e-01, 3.797083e-01, 3.797253e-01, 3.797422e-01,
    3.797591e-01, 3.797760e-01, 3.797929e-01, 3.798098e-01, 3.798268e-01, 3.798437e-01,
    3.798606e-01, 3.798775e-01, 3.798945e-01, 3.799114e-01, 3.799283e-01, 3.799452e-01,
    3.799621e-01, 3.799790e-01, 3.799959e-01, 3.800129e-01, 3.800298e-01, 3.800467e-01,
    3.800636e-01, 3.800806e-01, 3.800974e-01, 3.801143e-01, 3.801313e-01, 3.801482e-01,
    3.801651e-01, 3.801820e-01, 3.801989e-01, 3.802159e-01, 3.802328e-01, 3.802497e-01,
    3.802666e-01, 3.802835e-01, 3.803004e-01, 3.803173e-01, 3.803342e-01, 3.803512e-01,
    3.803681e-01, 3.803850e-01, 3.804019e-01, 3.804188e-01, 3.804357e-01, 3.804526e-01,
    3.804695e-01, 3.804864e-01, 3.805034e-01, 3.805203e-01, 3.805372e-01, 3.805541e-01,
    3.805710e-01, 3.805879e-01, 3.806048e-01, 3.806217e-01, 3.806386e-01, 3.806555e-01,
    3.806724e-01, 3.806894e-01, 3.807063e-01, 3.807231e-01, 3.807400e-01, 3.807570e-01,
    3.807739e-01, 3.807908e-01, 3.808077e-01, 3.808246e-01, 3.808415e-01, 3.808584e-01,
    3.808753e-01, 3.808922e-01, 3.809091e-01, 3.809260e-01, 3.809429e-01, 3.809598e-01,
    3.809767e-01, 3.809936e-01, 3.810106e-01, 3.810275e-01, 3.810444e-01, 3.810613e-01,
    3.810782e-01, 3.810951e-01, 3.811119e-01, 3.811289e-01, 3.811458e-01, 3.811627e-01,
    3.811796e-01, 3.811965e-01, 3.812134e-01, 3.812303e-01, 3.812472e-01, 3.812641e-01,
    3.812810e-01, 3.812979e-01, 3.813148e-01, 3.813317e-01, 3.813486e-01, 3.813655e-01,
    3.813824e-01, 3.813993e-01, 3.814162e-01, 3.814331e-01, 3.814500e-01, 3.814669e-01,
    3.814838e-01, 3.815007e-01, 3.815176e-01, 3.815345e-01, 3.815514e-01, 3.815683e-01,
    3.815852e-01, 3.816021e-01, 3.816190e-01, 3.816359e-01, 3.816528e-01, 3.816697e-01,
    3.816866e-01, 3.817035e-01, 3.817204e-01, 3.817373e-01, 3.817542e-01, 3.817710e-01,
    3.817879e-01, 3.818048e-01, 3.818217e-01, 3.818386e-01, 3.818555e-01, 3.818724e-01,
    3.818893e-01, 3.819062e-01, 3.819231e-01, 3.819400e-01, 3.819569e-01, 3.819738e-01,
    3.819907e-01, 3.820076e-01, 3.820245e-01, 3.820414e-01, 3.820583e-01, 3.820752e-01,
    3.820921e-01, 3.821090e-01, 3.821258e-01, 3.821427e-01, 3.821596e-01, 3.821765e-01,
    3.821934e-01, 3.822103e-01, 3.822272e-01, 3.822441e-01, 3.822609e-01, 3.822778e-01,
    3.822947e-01, 3.823116e-01, 3.823285e-01, 3.823454e-01, 3.823623e-01, 3.823792e-01,
    3.823961e-01, 3.824129e-01, 3.824298e-01, 3.824467e-01, 3.824636e-01, 3.824805e-01,
    3.824974e-01, 3.825143e-01, 3.825312e-01, 3.825480e-01, 3.825649e-01, 3.825818e-01,
    3.825987e-01, 3.826156e-01, 3.826325e-01, 3.826494e-01, 3.826663e-01, 3.826831e-01,
    3.827000e-01, 3.827169e-01, 3.827338e-01, 3.827507e-01, 3.827676e-01, 3.827844e-01,
    3.828013e-01, 3.828182e-01, 3.828351e-01, 3.828520e-01, 3.828689e-01, 3.828857e-01,
    3.829026e-01, 3.829195e-01, 3.829364e-01, 3.829533e-01, 3.829702e-01, 3.829870e-01,
    3.830039e-01, 3.830208e-01, 3.830377e-01, 3.830546e-01, 3.830714e-01, 3.830883e-01,
    3.831052e-01, 3.831221e-01, 3.831390e-01, 3.831558e-01, 3.831727e-01, 3.831896e-01,
    3.832065e-01, 3.832234e-01, 3.832402e-01, 3.832571e-01, 3.832740e-01, 3.832909e-01,
    3.833077e-01, 3.833246e-01, 3.833415e-01, 3.833584e-01, 3.833753e-01, 3.833921e-01,
    3.834090e-01, 3.834259e-01, 3.834428e-01, 3.834596e-01, 3.834765e-01, 3.834934e-01,
    3.835103e-01, 3.835271e-01, 3.835440e-01, 3.835609e-01, 3.835777e-01, 3.835946e-01,
    3.836115e-01, 3.836284e-01, 3.836452e-01, 3.836621e-01, 3.836790e-01, 3.836959e-01,
    3.837127e-01, 3.837296e-01, 3.837465e-01, 3.837633e-01, 3.837802e-01, 3.837971e-01,
    3.838140e-01, 3.838308e-01, 3.838477e-01, 3.838646e-01, 3.838814e-01, 3.838983e-01,
    3.839152e-01, 3.839321e-01, 3.839490e-01, 3.839658e-01, 3.839827e-01, 3.839996e-01,
    3.840164e-01, 3.840333e-01, 3.840502e-01, 3.840670e-01, 3.840839e-01, 3.841008e-01,
    3.841176e-01, 3.841345e-01, 3.841514e-01, 3.841682e-01, 3.841851e-01, 3.842020e-01,
    3.842188e-01, 3.842357e-01, 3.842525e-01, 3.842694e-01, 3.842863e-01, 3.843032e-01,
    3.843200e-01, 3.843369e-01, 3.843538e-01, 3.843706e-01, 3.843875e-01, 3.844044e-01,
    3.844212e-01, 3.844381e-01, 3.844549e-01, 3.844718e-01, 3.844887e-01, 3.845055e-01,
    3.845224e-01, 3.845393e-01, 3.845561e-01, 3.845730e-01, 3.845899e-01, 3.846067e-01,
    3.846236e-01, 3.846405e-01, 3.846573e-01, 3.846742e-01, 3.846910e-01, 3.847079e-01,
    3.847247e-01, 3.847416e-01, 3.847585e-01, 3.847753e-01, 3.847922e-01, 3.848090e-01,
    3.848259e-01, 3.848428e-01, 3.848596e-01, 3.848765e-01, 3.848934e-01, 3.849102e-01,
    3.849271e-01, 3.849439e-01, 3.849608e-01, 3.849776e-01, 3.849945e-01, 3.850113e-01,
    3.850282e-01, 3.850451e-01, 3.850619e-01, 3.850788e-01, 3.850956e-01, 3.851125e-01,
    3.851294e-01, 3.851462e-01, 3.851631e-01, 3.851799e-01, 3.851968e-01, 3.852136e-01,
    3.852305e-01, 3.852473e-01, 3.852642e-01, 3.852810e-01, 3.852979e-01, 3.853147e-01,
    3.853316e-01, 3.853484e-01, 3.853653e-01, 3.853822e-01, 3.853990e-01, 3.854159e-01,
    3.854327e-01, 3.854496e-01, 3.854664e-01, 3.854833e-01, 3.855001e-01, 3.855170e-01,
    3.855338e-01, 3.855507e-01, 3.855675e-01, 3.855844e-01, 3.856012e-01, 3.856181e-01,
    3.856349e-01, 3.856518e-01, 3.856686e-01, 3.856855e-01, 3.857023e-01, 3.857192e-01,
    3.857360e-01, 3.857529e-01, 3.857697e-01, 3.857866e-01, 3.858034e-01, 3.858203e-01,
    3.858371e-01, 3.858540e-01, 3.858708e-01, 3.858877e-01, 3.859045e-01, 3.859214e-01,
    3.859382e-01, 3.859551e-01, 3.859719e-01, 3.859887e-01, 3.860056e-01, 3.860224e-01,
    3.860393e-01, 3.860561e-01, 3.860730e-01, 3.860898e-01, 3.861067e-01, 3.861235e-01,
    3.861403e-01, 3.861572e-01, 3.861741e-01, 3.861909e-01, 3.862077e-01, 3.862246e-01,
    3.862414e-01, 3.862583e-01, 3.862751e-01, 3.862920e-01, 3.863088e-01, 3.863256e-01,
    3.863425e-01, 3.863593e-01, 3.863762e-01, 3.863930e-01, 3.864098e-01, 3.864267e-01,
    3.864435e-01, 3.864604e-01, 3.864772e-01, 3.864940e-01, 3.865109e-01, 3.865277e-01,
    3.865446e-01, 3.865614e-01, 3.865783e-01, 3.865951e-01, 3.866119e-01, 3.866288e-01,
    3.866456e-01, 3.866625e-01, 3.866793e-01, 3.866961e-01, 3.867130e-01, 3.867298e-01,
    3.867466e-01, 3.867635e-01, 3.867803e-01, 3.867972e-01, 3.868140e-01, 3.868308e-01,
    3.868477e-01, 3.868645e-01, 3.868813e-01, 3.868982e-01, 3.869150e-01, 3.869318e-01,
    3.869487e-01, 3.869655e-01, 3.869823e-01, 3.869992e-01, 3.870160e-01, 3.870329e-01,
    3.870497e-01, 3.870665e-01, 3.870833e-01, 3.871002e-01, 3.871170e-01, 3.871338e-01,
    3.871507e-01, 3.871675e-01, 3.871843e-01, 3.872012e-01, 3.872180e-01, 3.872348e-01,
    3.872516e-01, 3.872685e-01, 3.872853e-01, 3.873021e-01, 3.873190e-01, 3.873358e-01,
    3.873526e-01, 3.873695e-01, 3.873863e-01, 3.874031e-01, 3.874199e-01, 3.874368e-01,
    3.874536e-01, 3.874705e-01, 3.874873e-01, 3.875041e-01, 3.875209e-01, 3.875377e-01,
    3.875546e-01, 3.875714e-01, 3.875882e-01, 3.876051e-01, 3.876219e-01, 3.876387e-01,
    3.876556e-01, 3.876724e-01, 3.876892e-01, 3.877060e-01, 3.877228e-01, 3.877397e-01,
    3.877565e-01, 3.877733e-01, 3.877902e-01, 3.878070e-01, 3.878238e-01, 3.878407e-01,
    3.878575e-01, 3.878743e-01, 3.878911e-01, 3.879080e-01, 3.879248e-01, 3.879416e-01,
    3.879584e-01, 3.879752e-01, 3.879921e-01, 3.880089e-01, 3.880257e-01, 3.880425e-01,
    3.880593e-01, 3.880762e-01, 3.880930e-01, 3.881098e-01, 3.881266e-01, 3.881434e-01,
    3.881603e-01, 3.881771e-01, 3.881939e-01, 3.882107e-01, 3.882275e-01, 3.882444e-01,
    3.882612e-01, 3.882780e-01, 3.882948e-01, 3.883116e-01, 3.883285e-01, 3.883453e-01,
    3.883621e-01, 3.883789e-01, 3.883957e-01, 3.884125e-01, 3.884294e-01, 3.884462e-01,
    3.884630e-01, 3.884798e-01, 3.884966e-01, 3.885134e-01, 3.885303e-01, 3.885471e-01,
    3.885639e-01, 3.885807e-01, 3.885975e-01, 3.886144e-01, 3.886312e-01, 3.886480e-01,
    3.886648e-01, 3.886816e-01, 3.886984e-01, 3.887152e-01, 3.887320e-01, 3.887489e-01,
    3.887657e-01, 3.887825e-01, 3.887993e-01, 3.888161e-01, 3.888330e-01, 3.888498e-01,
    3.888666e-01, 3.888834e-01, 3.889002e-01, 3.889170e-01, 3.889338e-01, 3.889506e-01,
    3.889675e-01, 3.889843e-01, 3.890011e-01, 3.890179e-01, 3.890347e-01, 3.890515e-01,
    3.890683e-01, 3.890851e-01, 3.891019e-01, 3.891187e-01, 3.891356e-01, 3.891524e-01,
    3.891692e-01, 3.891860e-01, 3.892028e-01, 3.892196e-01, 3.892364e-01, 3.892532e-01,
    3.892700e-01, 3.892868e-01, 3.893036e-01, 3.893204e-01, 3.893372e-01, 3.893541e-01,
    3.893709e-01, 3.893877e-01, 3.894044e-01, 3.894213e-01, 3.894381e-01, 3.894549e-01,
    3.894717e-01, 3.894885e-01, 3.895053e-01, 3.895221e-01, 3.895389e-01, 3.895557e-01,
    3.895725e-01, 3.895893e-01, 3.896061e-01, 3.896230e-01, 3.896397e-01, 3.896565e-01,
    3.896734e-01, 3.896902e-01, 3.897070e-01, 3.897237e-01, 3.897406e-01, 3.897574e-01,
    3.897742e-01, 3.897910e-01, 3.898078e-01, 3.898246e-01, 3.898414e-01, 3.898582e-01,
    3.898750e-01, 3.898918e-01, 3.899086e-01, 3.899254e-01, 3.899421e-01, 3.899590e-01,
    3.899758e-01, 3.899926e-01, 3.900093e-01, 3.900262e-01, 3.900430e-01, 3.900597e-01,
    3.900765e-01, 3.900934e-01, 3.901102e-01, 3.901269e-01, 3.901438e-01, 3.901606e-01,
    3.901773e-01, 3.901941e-01, 3.902110e-01, 3.902277e-01, 3.902445e-01, 3.902614e-01,
    3.902781e-01, 3.902949e-01, 3.903117e-01, 3.903285e-01, 3.903453e-01, 3.903621e-01,
    3.903789e-01, 3.903957e-01, 3.904125e-01, 3.904293e-01, 3.904461e-01, 3.904629e-01,
    3.904797e-01, 3.904965e-01, 3.905133e-01, 3.905300e-01, 3.905469e-01, 3.905637e-01,
    3.905804e-01, 3.905972e-01, 3.906140e-01, 3.906308e-01, 3.906476e-01, 3.906644e-01,
    3.906812e-01, 3.906980e-01, 3.907148e-01, 3.907315e-01, 3.907484e-01, 3.907651e-01,
    3.907819e-01, 3.907987e-01, 3.908155e-01, 3.908323e-01, 3.908491e-01, 3.908659e-01,
    3.908827e-01, 3.908994e-01, 3.909163e-01, 3.909330e-01, 3.909498e-01, 3.909666e-01,
    3.909834e-01, 3.910002e-01, 3.910170e-01, 3.910338e-01, 3.910505e-01, 3.910674e-01,
    3.910841e-01, 3.911009e-01, 3.911177e-01, 3.911345e-01, 3.911513e-01, 3.911681e-01,
    3.911849e-01, 3.912016e-01, 3.912184e-01, 3.912352e-01, 3.912520e-01, 3.912688e-01,
    3.912855e-01, 3.913023e-01, 3.913191e-01, 3.913359e-01, 3.913527e-01, 3.913695e-01,
    3.913862e-01, 3.914030e-01, 3.914198e-01, 3.914366e-01, 3.914534e-01, 3.914702e-01,
    3.914869e-01, 3.915037e-01, 3.915205e-01, 3.915373e-01, 3.915541e-01, 3.915709e-01,
    3.915876e-01, 3.916044e-01, 3.916212e-01, 3.916380e-01, 3.916548e-01, 3.916715e-01,
    3.916883e-01, 3.917051e-01, 3.917219e-01, 3.917387e-01, 3.917555e-01, 3.917722e-01,
    3.917890e-01, 3.918058e-01, 3.918226e-01, 3.918393e-01, 3.918561e-01, 3.918729e-01,
    3.918896e-01, 3.919064e-01, 3.919232e-01, 3.919400e-01, 3.919567e-01, 3.919735e-01,
    3.919903e-01, 3.920071e-01, 3.920239e-01, 3.920406e-01, 3.920574e-01, 3.920742e-01,
    3.920910e-01, 3.921078e-01, 3.921245e-01, 3.921413e-01, 3.921581e-01, 3.921748e-01,
    3.921916e-01, 3.922084e-01, 3.922252e-01, 3.922420e-01, 3.922587e-01, 3.922755e-01,
    3.922923e-01, 3.923090e-01, 3.923258e-01, 3.923426e-01, 3.923594e-01, 3.923761e-01,
    3.923929e-01, 3.924097e-01, 3.924264e-01, 3.924432e-01, 3.924600e-01, 3.924767e-01,
    3.924935e-01, 3.925103e-01, 3.925270e-01, 3.925438e-01, 3.925606e-01, 3.925774e-01,
    3.925941e-01, 3.926109e-01, 3.926277e-01, 3.926444e-01, 3.926612e-01, 3.926780e-01,
    3.926947e-01, 3.927115e-01, 3.927283e-01, 3.927450e-01, 3.927618e-01, 3.927786e-01,
    3.927954e-01, 3.928121e-01, 3.928289e-01, 3.928457e-01, 3.928624e-01, 3.928792e-01,
    3.928960e-01, 3.929127e-01, 3.929295e-01, 3.929463e-01, 3.929630e-01, 3.929798e-01,
    3.929966e-01, 3.930133e-01, 3.930300e-01, 3.930468e-01, 3.930636e-01, 3.930804e-01,
    3.930971e-01, 3.931139e-01, 3.931307e-01, 3.931474e-01, 3.931642e-01, 3.931809e-01,
    3.931977e-01, 3.932145e-01, 3.932312e-01, 3.932480e-01, 3.932648e-01, 3.932815e-01,
    3.932983e-01, 3.933150e-01, 3.933318e-01, 3.933486e-01, 3.933653e-01, 3.933821e-01,
    3.933988e-01, 3.934156e-01, 3.934324e-01, 3.934491e-01, 3.934659e-01, 3.934826e-01,
    3.934994e-01, 3.935162e-01, 3.935329e-01, 3.935497e-01, 3.935664e-01, 3.935832e-01,
    3.935999e-01, 3.936167e-01, 3.936335e-01, 3.936502e-01, 3.936670e-01, 3.936837e-01,
    3.937005e-01, 3.937173e-01, 3.937340e-01, 3.937508e-01, 3.937675e-01, 3.937843e-01,
    3.938010e-01, 3.938178e-01, 3.938345e-01, 3.938513e-01, 3.938681e-01, 3.938848e-01,
    3.939015e-01, 3.939183e-01, 3.939350e-01, 3.939518e-01, 3.939686e-01, 3.939853e-01,
    3.940021e-01, 3.940188e-01, 3.940355e-01, 3.940523e-01, 3.940691e-01, 3.940858e-01,
    3.941026e-01, 3.941193e-01, 3.941361e-01, 3.941528e-01, 3.941696e-01, 3.941863e-01,
    3.942031e-01, 3.942198e-01, 3.942366e-01, 3.942533e-01, 3.942701e-01, 3.942868e-01,
    3.943036e-01, 3.943203e-01, 3.943371e-01, 3.943538e-01, 3.943706e-01, 3.943873e-01,
    3.944041e-01, 3.944208e-01, 3.944376e-01, 3.944543e-01, 3.944710e-01, 3.944878e-01,
    3.945045e-01, 3.945213e-01, 3.945380e-01, 3.945548e-01, 3.945715e-01, 3.945883e-01,
    3.946050e-01, 3.946218e-01, 3.946385e-01, 3.946553e-01, 3.946720e-01, 3.946888e-01,
    3.947055e-01, 3.947223e-01, 3.947390e-01, 3.947557e-01, 3.947725e-01, 3.947892e-01,
    3.948060e-01, 3.948227e-01, 3.948394e-01, 3.948562e-01, 3.948729e-01, 3.948897e-01,
    3.949064e-01, 3.949232e-01, 3.949399e-01, 3.949566e-01, 3.949734e-01, 3.949901e-01,
    3.950069e-01, 3.950236e-01, 3.950404e-01, 3.950571e-01, 3.950739e-01, 3.950906e-01,
    3.951073e-01, 3.951241e-01, 3.951408e-01, 3.951575e-01, 3.951743e-01, 3.951910e-01,
    3.952077e-01, 3.952245e-01, 3.952412e-01, 3.952580e-01, 3.952747e-01, 3.952914e-01,
    3.953082e-01, 3.953249e-01, 3.953417e-01, 3.953584e-01, 3.953751e-01, 3.953919e-01,
    3.954086e-01, 3.954253e-01, 3.954421e-01, 3.954588e-01, 3.954756e-01, 3.954923e-01,
    3.955090e-01, 3.955258e-01, 3.955425e-01, 3.955592e-01, 3.955760e-01, 3.955927e-01,
    3.956095e-01, 3.956262e-01, 3.956429e-01, 3.956596e-01, 3.956763e-01, 3.956931e-01,
    3.957098e-01, 3.957266e-01, 3.957433e-01, 3.957600e-01, 3.957767e-01, 3.957935e-01,
    3.958102e-01, 3.958270e-01, 3.958437e-01, 3.958604e-01, 3.958772e-01, 3.958939e-01,
    3.959107e-01, 3.959274e-01, 3.959441e-01, 3.959608e-01, 3.959775e-01, 3.959943e-01,
    3.960110e-01, 3.960277e-01, 3.960444e-01, 3.960612e-01, 3.960779e-01, 3.960947e-01,
    3.961114e-01, 3.961281e-01, 3.961448e-01, 3.961616e-01, 3.961783e-01, 3.961950e-01,
    3.962117e-01, 3.962285e-01, 3.962452e-01, 3.962619e-01, 3.962786e-01, 3.962954e-01,
    3.963121e-01, 3.963288e-01, 3.963455e-01, 3.963623e-01, 3.963790e-01, 3.963957e-01,
    3.964124e-01, 3.964292e-01, 3.964459e-01, 3.964626e-01, 3.964793e-01, 3.964961e-01,
    3.965128e-01, 3.965295e-01, 3.965462e-01, 3.965630e-01, 3.965797e-01, 3.965964e-01,
    3.966132e-01, 3.966299e-01, 3.966466e-01, 3.966633e-01, 3.966801e-01, 3.966968e-01,
    3.967135e-01, 3.967302e-01, 3.967469e-01, 3.967636e-01, 3.967803e-01, 3.967971e-01,
    3.968138e-01, 3.968305e-01, 3.968472e-01, 3.968639e-01, 3.968807e-01, 3.968974e-01,
    3.969141e-01, 3.969308e-01, 3.969476e-01, 3.969643e-01, 3.969810e-01, 3.969977e-01,
    3.970144e-01, 3.970312e-01, 3.970479e-01, 3.970646e-01, 3.970813e-01, 3.970980e-01,
    3.971147e-01, 3.971315e-01, 3.971482e-01, 3.971649e-01, 3.971816e-01, 3.971983e-01,
    3.972150e-01, 3.972317e-01, 3.972484e-01, 3.972652e-01, 3.972819e-01, 3.972986e-01,
    3.973153e-01, 3.973320e-01, 3.973488e-01, 3.973655e-01, 3.973822e-01, 3.973989e-01,
    3.974156e-01, 3.974323e-01, 3.974490e-01, 3.974657e-01, 3.974824e-01, 3.974991e-01,
    3.975159e-01, 3.975326e-01, 3.975493e-01, 3.975660e-01, 3.975827e-01, 3.975994e-01,
    3.976161e-01, 3.976329e-01, 3.976496e-01, 3.976663e-01, 3.976830e-01, 3.976997e-01,
    3.977164e-01, 3.977331e-01, 3.977498e-01, 3.977666e-01, 3.977832e-01, 3.978000e-01,
    3.978167e-01, 3.978334e-01, 3.978501e-01, 3.978668e-01, 3.978835e-01, 3.979002e-01,
    3.979169e-01, 3.979336e-01, 3.979503e-01, 3.979670e-01, 3.979837e-01, 3.980004e-01,
    3.980172e-01, 3.980339e-01, 3.980506e-01, 3.980673e-01, 3.980840e-01, 3.981007e-01,
    3.981174e-01, 3.981341e-01, 3.981508e-01, 3.981675e-01, 3.981842e-01, 3.982009e-01,
    3.982176e-01, 3.982343e-01, 3.982510e-01, 3.982677e-01, 3.982844e-01, 3.983011e-01,
    3.983178e-01, 3.983345e-01, 3.983513e-01, 3.983679e-01, 3.983847e-01, 3.984013e-01,
    3.984181e-01, 3.984347e-01, 3.984515e-01, 3.984681e-01, 3.984848e-01, 3.985015e-01,
    3.985182e-01, 3.985350e-01, 3.985516e-01, 3.985684e-01, 3.985851e-01, 3.986017e-01,
    3.986185e-01, 3.986351e-01, 3.986519e-01, 3.986686e-01, 3.986852e-01, 3.987020e-01,
    3.987187e-01, 3.987353e-01, 3.987521e-01, 3.987687e-01, 3.987854e-01, 3.988021e-01,
    3.988188e-01, 3.988355e-01, 3.988522e-01, 3.988689e-01, 3.988856e-01, 3.989023e-01,
    3.989190e-01, 3.989357e-01, 3.989524e-01, 3.989691e-01, 3.989858e-01, 3.990025e-01,
    3.990192e-01, 3.990359e-01, 3.990526e-01, 3.990693e-01, 3.990860e-01, 3.991026e-01,
    3.991194e-01, 3.991360e-01, 3.991527e-01, 3.991694e-01, 3.991861e-01, 3.992028e-01,
    3.992195e-01, 3.992362e-01, 3.992529e-01, 3.992696e-01, 3.992863e-01, 3.993030e-01,
    3.993196e-01, 3.993364e-01, 3.993531e-01, 3.993697e-01, 3.993864e-01, 3.994031e-01,
    3.994198e-01, 3.994365e-01, 3.994532e-01, 3.994699e-01, 3.994865e-01, 3.995032e-01,
    3.995200e-01, 3.995366e-01, 3.995533e-01, 3.995700e-01, 3.995867e-01, 3.996034e-01,
    3.996201e-01, 3.996367e-01, 3.996535e-01, 3.996701e-01, 3.996868e-01, 3.997035e-01,
    3.997202e-01, 3.997369e-01, 3.997535e-01, 3.997702e-01, 3.997869e-01, 3.998036e-01,
    3.998203e-01, 3.998370e-01, 3.998537e-01, 3.998704e-01, 3.998871e-01, 3.999037e-01,
    3.999204e-01, 3.999371e-01, 3.999538e-01, 3.999705e-01, 3.999871e-01, 4.000038e-01,
    4.000205e-01, 4.000372e-01, 4.000539e-01, 4.000705e-01, 4.000872e-01, 4.001039e-01,
    4.001206e-01, 4.001373e-01, 4.001540e-01, 4.001707e-01, 4.001873e-01, 4.002040e-01,
    4.002207e-01, 4.002374e-01, 4.002541e-01, 4.002707e-01, 4.002874e-01, 4.003041e-01,
    4.003208e-01, 4.003375e-01, 4.003541e-01, 4.003708e-01, 4.003875e-01, 4.004042e-01,
    4.004208e-01, 4.004375e-01, 4.004542e-01, 4.004709e-01, 4.004876e-01, 4.005043e-01,
    4.005209e-01, 4.005376e-01, 4.005543e-01, 4.005709e-01, 4.005876e-01, 4.006043e-01,
    4.006210e-01, 4.006377e-01, 4.006543e-01, 4.006710e-01, 4.006877e-01, 4.007044e-01,
    4.007210e-01, 4.007377e-01, 4.007544e-01, 4.007711e-01, 4.007877e-01, 4.008044e-01,
    4.008211e-01, 4.008378e-01, 4.008544e-01, 4.008711e-01, 4.008878e-01, 4.009044e-01,
    4.009211e-01, 4.009378e-01, 4.009545e-01, 4.009711e-01, 4.009878e-01, 4.010045e-01,
    4.010212e-01, 4.010378e-01, 4.010545e-01, 4.010712e-01, 4.010878e-01, 4.011045e-01,
    4.011212e-01, 4.011378e-01, 4.011545e-01, 4.011712e-01, 4.011878e-01, 4.012045e-01,
    4.012212e-01, 4.012378e-01, 4.012545e-01, 4.012712e-01, 4.012879e-01, 4.013045e-01,
    4.013212e-01, 4.013379e-01, 4.013545e-01, 4.013712e-01, 4.013879e-01, 4.014045e-01,
    4.014212e-01, 4.014378e-01, 4.014545e-01, 4.014712e-01, 4.014879e-01, 4.015045e-01,
    4.015212e-01, 4.015379e-01, 4.015546e-01, 4.015712e-01, 4.015879e-01, 4.016046e-01,
    4.016212e-01, 4.016379e-01, 4.016545e-01, 4.016712e-01, 4.016878e-01, 4.017045e-01,
    4.017212e-01, 4.017378e-01, 4.017545e-01, 4.017712e-01, 4.017878e-01, 4.018045e-01,
    4.018212e-01, 4.018378e-01, 4.018545e-01, 4.018711e-01, 4.018878e-01, 4.019045e-01,
    4.019211e-01, 4.019378e-01, 4.019544e-01, 4.019711e-01, 4.019878e-01, 4.020044e-01,
    4.020211e-01, 4.020377e-01, 4.020544e-01, 4.020711e-01, 4.020877e-01, 4.021044e-01,
    4.021211e-01, 4.021377e-01, 4.021544e-01, 4.021710e-01, 4.021877e-01, 4.022043e-01,
    4.022210e-01, 4.022377e-01, 4.022543e-01, 4.022710e-01, 4.022876e-01, 4.023043e-01,
    4.023210e-01, 4.023376e-01, 4.023543e-01, 4.023709e-01, 4.023876e-01, 4.024042e-01,
    4.024209e-01, 4.024376e-01, 4.024542e-01, 4.024708e-01, 4.024875e-01, 4.025041e-01,
    4.025208e-01, 4.025375e-01, 4.025541e-01, 4.025708e-01, 4.025874e-01, 4.026041e-01,
    4.026207e-01, 4.026374e-01, 4.026540e-01, 4.026707e-01, 4.026874e-01, 4.027040e-01,
    4.027206e-01, 4.027373e-01, 4.027539e-01, 4.027706e-01, 4.027872e-01, 4.028039e-01,
    4.028206e-01, 4.028372e-01, 4.028538e-01, 4.028705e-01, 4.028872e-01, 4.029038e-01,
    4.029204e-01, 4.029371e-01, 4.029538e-01, 4.029704e-01, 4.029870e-01, 4.030037e-01,
    4.030204e-01, 4.030370e-01, 4.030536e-01, 4.030703e-01, 4.030870e-01, 4.031036e-01,
    4.031202e-01, 4.031369e-01, 4.031535e-01, 4.031702e-01, 4.031868e-01, 4.032035e-01,
    4.032201e-01, 4.032367e-01, 4.032534e-01, 4.032700e-01, 4.032867e-01, 4.033034e-01,
    4.033200e-01, 4.033366e-01, 4.033533e-01, 4.033699e-01, 4.033866e-01, 4.034032e-01,
    4.034199e-01, 4.034365e-01, 4.034531e-01, 4.034698e-01, 4.034864e-01, 4.035031e-01,
    4.035197e-01, 4.035363e-01, 4.035530e-01, 4.035696e-01, 4.035863e-01, 4.036029e-01,
    4.036196e-01, 4.036362e-01, 4.036529e-01, 4.036695e-01, 4.036861e-01, 4.037028e-01,
    4.037194e-01, 4.037361e-01, 4.037527e-01, 4.037693e-01, 4.037860e-01, 4.038026e-01,
    4.038193e-01, 4.038359e-01, 4.038526e-01, 4.038692e-01, 4.038858e-01, 4.039025e-01,
    4.039191e-01, 4.039357e-01, 4.039524e-01, 4.039690e-01, 4.039856e-01, 4.040022e-01,
    4.040189e-01, 4.040355e-01, 4.040522e-01, 4.040688e-01, 4.040855e-01, 4.041021e-01,
    4.041187e-01, 4.041354e-01, 4.041520e-01, 4.041686e-01, 4.041853e-01, 4.042019e-01,
    4.042185e-01, 4.042352e-01, 4.042518e-01, 4.042684e-01, 4.042851e-01, 4.043017e-01,
    4.043184e-01, 4.043350e-01, 4.043516e-01, 4.043682e-01, 4.043849e-01, 4.044015e-01,
    4.044181e-01, 4.044348e-01, 4.044514e-01, 4.044680e-01, 4.044847e-01, 4.045013e-01,
    4.045179e-01, 4.045346e-01, 4.045512e-01, 4.045678e-01, 4.045845e-01, 4.046011e-01,
    4.046177e-01, 4.046343e-01, 4.046510e-01, 4.046676e-01, 4.046842e-01, 4.047008e-01,
    4.047175e-01, 4.047341e-01, 4.047508e-01, 4.047674e-01, 4.047840e-01, 4.048006e-01,
    4.048173e-01, 4.048339e-01, 4.048505e-01, 4.048671e-01, 4.048837e-01, 4.049004e-01,
    4.049170e-01, 4.049337e-01, 4.049503e-01, 4.049669e-01, 4.049836e-01, 4.050002e-01,
    4.050168e-01, 4.050334e-01, 4.050500e-01, 4.050666e-01, 4.050833e-01, 4.050999e-01,
    4.051165e-01, 4.051332e-01, 4.051498e-01, 4.051664e-01, 4.051830e-01, 4.051996e-01,
    4.052163e-01, 4.052329e-01, 4.052495e-01, 4.052662e-01, 4.052827e-01, 4.052994e-01,
    4.053160e-01, 4.053326e-01, 4.053493e-01, 4.053659e-01, 4.053825e-01, 4.053991e-01,
    4.054157e-01, 4.054324e-01, 4.054490e-01, 4.054656e-01, 4.054822e-01, 4.054988e-01,
    4.055154e-01, 4.055321e-01, 4.055487e-01, 4.055653e-01, 4.055819e-01, 4.055986e-01,
    4.056152e-01, 4.056318e-01, 4.056484e-01, 4.056650e-01, 4.056816e-01, 4.056983e-01,
    4.057148e-01, 4.057315e-01, 4.057481e-01, 4.057647e-01, 4.057813e-01, 4.057980e-01,
    4.058146e-01, 4.058312e-01, 4.058478e-01, 4.058644e-01, 4.058810e-01, 4.058977e-01,
    4.059143e-01, 4.059309e-01, 4.059475e-01, 4.059641e-01, 4.059807e-01, 4.059973e-01,
    4.060140e-01, 4.060306e-01, 4.060472e-01, 4.060638e-01, 4.060804e-01, 4.060971e-01,
    4.061136e-01, 4.061302e-01, 4.061469e-01, 4.061635e-01, 4.061801e-01, 4.061967e-01,
    4.062133e-01, 4.062299e-01, 4.062465e-01, 4.062631e-01, 4.062798e-01, 4.062964e-01,
    4.063130e-01, 4.063296e-01, 4.063462e-01, 4.063628e-01, 4.063794e-01, 4.063960e-01,
    4.064126e-01, 4.064292e-01, 4.064459e-01, 4.064625e-01, 4.064791e-01, 4.064957e-01,
    4.065123e-01, 4.065289e-01, 4.065455e-01, 4.065621e-01, 4.065787e-01, 4.065953e-01,
    4.066119e-01, 4.066285e-01, 4.066451e-01, 4.066617e-01, 4.066783e-01, 4.066950e-01,
    4.067116e-01, 4.067282e-01, 4.067448e-01, 4.067614e-01, 4.067780e-01, 4.067946e-01,
    4.068112e-01, 4.068278e-01, 4.068444e-01, 4.068610e-01, 4.068776e-01, 4.068942e-01,
    4.069108e-01, 4.069274e-01, 4.069441e-01, 4.069607e-01, 4.069772e-01, 4.069938e-01,
    4.070104e-01, 4.070270e-01, 4.070436e-01, 4.070603e-01, 4.070769e-01, 4.070935e-01,
    4.071101e-01, 4.071267e-01, 4.071433e-01, 4.071599e-01, 4.071764e-01, 4.071930e-01,
    4.072097e-01, 4.072263e-01, 4.072429e-01, 4.072595e-01, 4.072761e-01, 4.072927e-01,
    4.073093e-01, 4.073259e-01, 4.073425e-01, 4.073591e-01, 4.073756e-01, 4.073922e-01,
    4.074088e-01, 4.074254e-01, 4.074420e-01, 4.074586e-01, 4.074752e-01, 4.074918e-01,
    4.075084e-01, 4.075250e-01, 4.075416e-01, 4.075582e-01, 4.075748e-01, 4.075914e-01,
    4.076080e-01, 4.076246e-01, 4.076412e-01, 4.076578e-01, 4.076744e-01, 4.076910e-01,
    4.077076e-01, 4.077242e-01, 4.077408e-01, 4.077574e-01, 4.077740e-01, 4.077905e-01,
    4.078071e-01, 4.078237e-01, 4.078403e-01, 4.078569e-01, 4.078735e-01, 4.078901e-01,
    4.079067e-01, 4.079233e-01, 4.079399e-01, 4.079565e-01, 4.079731e-01, 4.079897e-01,
    4.080063e-01, 4.080229e-01, 4.080394e-01, 4.080560e-01, 4.080726e-01, 4.080892e-01,
    4.081058e-01, 4.081224e-01, 4.081390e-01, 4.081556e-01, 4.081721e-01, 4.081887e-01,
    4.082053e-01, 4.082219e-01, 4.082385e-01, 4.082551e-01, 4.082717e-01, 4.082883e-01,
    4.083049e-01, 4.083215e-01, 4.083380e-01, 4.083546e-01, 4.083712e-01, 4.083878e-01,
    4.084044e-01, 4.084210e-01, 4.084376e-01, 4.084541e-01, 4.084707e-01, 4.084873e-01,
    4.085039e-01, 4.085205e-01, 4.085371e-01, 4.085536e-01, 4.085702e-01, 4.085868e-01,
    4.086034e-01, 4.086200e-01, 4.086366e-01, 4.086531e-01, 4.086697e-01, 4.086863e-01,
    4.087029e-01, 4.087195e-01, 4.087361e-01, 4.087527e-01, 4.087692e-01, 4.087858e-01,
    4.088024e-01, 4.088190e-01, 4.088356e-01, 4.088522e-01, 4.088687e-01, 4.088853e-01,
    4.089019e-01, 4.089185e-01, 4.089351e-01, 4.089516e-01, 4.089682e-01, 4.089848e-01,
    4.090014e-01, 4.090180e-01, 4.090345e-01, 4.090511e-01, 4.090677e-01, 4.090843e-01,
    4.091009e-01, 4.091174e-01, 4.091340e-01, 4.091506e-01, 4.091671e-01, 4.091837e-01,
    4.092003e-01, 4.092169e-01, 4.092335e-01, 4.092501e-01, 4.092666e-01, 4.092832e-01,
    4.092998e-01, 4.093163e-01, 4.093329e-01, 4.093495e-01, 4.093661e-01, 4.093826e-01,
    4.093992e-01, 4.094158e-01, 4.094324e-01, 4.094490e-01, 4.094656e-01, 4.094821e-01,
    4.094987e-01, 4.095152e-01, 4.095318e-01, 4.095484e-01, 4.095649e-01, 4.095815e-01,
    4.095981e-01, 4.096147e-01, 4.096313e-01, 4.096479e-01, 4.096644e-01, 4.096810e-01,
    4.096975e-01, 4.097141e-01, 4.097307e-01, 4.097472e-01, 4.097638e-01, 4.097804e-01,
    4.097970e-01, 4.098136e-01, 4.098301e-01, 4.098467e-01, 4.098632e-01, 4.098798e-01,
    4.098964e-01, 4.099129e-01, 4.099295e-01, 4.099461e-01, 4.099627e-01, 4.099793e-01,
    4.099958e-01, 4.100124e-01, 4.100290e-01, 4.100455e-01, 4.100621e-01, 4.100786e-01,
    4.100952e-01, 4.101118e-01, 4.101283e-01, 4.101449e-01, 4.101615e-01, 4.101780e-01,
    4.101946e-01, 4.102112e-01, 4.102277e-01, 4.102443e-01, 4.102609e-01, 4.102774e-01,
    4.102940e-01, 4.103106e-01, 4.103271e-01, 4.103437e-01, 4.103602e-01, 4.103768e-01,
    4.103934e-01, 4.104099e-01, 4.104265e-01, 4.104431e-01, 4.104596e-01, 4.104762e-01,
    4.104927e-01, 4.105093e-01, 4.105259e-01, 4.105425e-01, 4.105590e-01, 4.105756e-01,
    4.105921e-01, 4.106087e-01, 4.106252e-01, 4.106418e-01, 4.106584e-01, 4.106749e-01,
    4.106915e-01, 4.107081e-01, 4.107246e-01, 4.107412e-01, 4.107577e-01, 4.107743e-01,
    4.107908e-01, 4.108074e-01, 4.108240e-01, 4.108405e-01, 4.108571e-01, 4.108737e-01,
    4.108902e-01, 4.109068e-01, 4.109233e-01, 4.109399e-01, 4.109564e-01, 4.109730e-01,
    4.109896e-01, 4.110061e-01, 4.110227e-01, 4.110392e-01, 4.110558e-01, 4.110723e-01,
    4.110889e-01, 4.111054e-01, 4.111220e-01, 4.111385e-01, 4.111551e-01, 4.111716e-01,
    4.111882e-01, 4.112048e-01, 4.112213e-01, 4.112379e-01, 4.112544e-01, 4.112710e-01,
    4.112875e-01, 4.113041e-01, 4.113206e-01, 4.113372e-01, 4.113537e-01, 4.113703e-01,
    4.113868e-01, 4.114034e-01, 4.114200e-01, 4.114365e-01, 4.114531e-01, 4.114696e-01,
    4.114861e-01, 4.115027e-01, 4.115193e-01, 4.115358e-01, 4.115524e-01, 4.115689e-01,
    4.115855e-01, 4.116020e-01, 4.116186e-01, 4.116351e-01, 4.116516e-01, 4.116682e-01,
    4.116848e-01, 4.117013e-01, 4.117179e-01, 4.117344e-01, 4.117510e-01, 4.117675e-01,
    4.117840e-01, 4.118006e-01, 4.118171e-01, 4.118337e-01, 4.118502e-01, 4.118668e-01,
    4.118833e-01, 4.118999e-01, 4.119164e-01, 4.119330e-01, 4.119495e-01, 4.119661e-01,
    4.119826e-01, 4.119991e-01, 4.120157e-01, 4.120322e-01, 4.120488e-01, 4.120653e-01,
    4.120819e-01, 4.120984e-01, 4.121150e-01, 4.121315e-01, 4.121480e-01, 4.121646e-01,
    4.121811e-01, 4.121977e-01, 4.122142e-01, 4.122308e-01, 4.122473e-01, 4.122639e-01,
    4.122804e-01, 4.122969e-01, 4.123135e-01, 4.123300e-01, 4.123465e-01, 4.123631e-01,
    4.123797e-01, 4.123962e-01, 4.124127e-01, 4.124293e-01, 4.124458e-01, 4.124623e-01,
    4.124789e-01, 4.124954e-01, 4.125119e-01, 4.125285e-01, 4.125450e-01, 4.125616e-01,
    4.125781e-01, 4.125946e-01, 4.126112e-01, 4.126277e-01, 4.126442e-01, 4.126608e-01,
    4.126773e-01, 4.126939e-01, 4.127104e-01, 4.127270e-01, 4.127435e-01, 4.127600e-01,
    4.127766e-01, 4.127931e-01, 4.128096e-01, 4.128262e-01, 4.128427e-01, 4.128592e-01,
    4.128758e-01, 4.128923e-01, 4.129089e-01, 4.129254e-01, 4.129419e-01, 4.129585e-01,
    4.129750e-01, 4.129915e-01, 4.130080e-01, 4.130246e-01, 4.130411e-01, 4.130577e-01,
    4.130742e-01, 4.130907e-01, 4.131073e-01, 4.131238e-01, 4.131403e-01, 4.131568e-01,
    4.131734e-01, 4.131899e-01, 4.132065e-01, 4.132230e-01, 4.132395e-01, 4.132560e-01,
    4.132726e-01, 4.132891e-01, 4.133056e-01, 4.133222e-01, 4.133387e-01, 4.133552e-01,
    4.133717e-01, 4.133883e-01, 4.134048e-01, 4.134213e-01, 4.134379e-01, 4.134544e-01,
    4.134709e-01, 4.134874e-01, 4.135040e-01, 4.135205e-01, 4.135370e-01, 4.135536e-01,
    4.135701e-01, 4.135866e-01, 4.136031e-01, 4.136196e-01, 4.136362e-01, 4.136527e-01,
    4.136692e-01, 4.136858e-01, 4.137023e-01, 4.137188e-01, 4.137354e-01, 4.137519e-01,
    4.137684e-01, 4.137849e-01, 4.138014e-01, 4.138180e-01, 4.138345e-01, 4.138510e-01,
    4.138676e-01, 4.138841e-01, 4.139006e-01, 4.139171e-01, 4.139336e-01, 4.139501e-01,
    4.139667e-01, 4.139832e-01, 4.139997e-01, 4.140162e-01, 4.140328e-01, 4.140493e-01,
    4.140658e-01, 4.140823e-01, 4.140988e-01, 4.141154e-01, 4.141319e-01, 4.141484e-01,
    4.141649e-01, 4.141815e-01, 4.141980e-01, 4.142145e-01, 4.142310e-01, 4.142476e-01,
    4.142641e-01, 4.142806e-01, 4.142971e-01, 4.143136e-01, 4.143302e-01, 4.143467e-01,
    4.143632e-01, 4.143797e-01, 4.143962e-01, 4.144127e-01, 4.144292e-01, 4.144458e-01,
    4.144623e-01, 4.144788e-01, 4.144953e-01, 4.145118e-01, 4.145283e-01, 4.145449e-01,
    4.145614e-01, 4.145779e-01, 4.145944e-01, 4.146109e-01, 4.146274e-01, 4.146439e-01,
    4.146605e-01, 4.146770e-01, 4.146935e-01, 4.147100e-01, 4.147265e-01, 4.147430e-01,
    4.147595e-01, 4.147761e-01, 4.147926e-01, 4.148091e-01, 4.148256e-01, 4.148421e-01,
    4.148586e-01, 4.148751e-01, 4.148916e-01, 4.149081e-01, 4.149247e-01, 4.149412e-01,
    4.149577e-01, 4.149742e-01, 4.149908e-01, 4.150073e-01, 4.150238e-01, 4.150403e-01,
    4.150568e-01, 4.150733e-01, 4.150898e-01, 4.151063e-01, 4.151228e-01, 4.151393e-01,
    4.151558e-01, 4.151723e-01, 4.151888e-01, 4.152053e-01, 4.152218e-01, 4.152384e-01,
    4.152549e-01, 4.152714e-01, 4.152879e-01, 4.153044e-01, 4.153209e-01, 4.153374e-01,
    4.153539e-01, 4.153704e-01, 4.153869e-01, 4.154034e-01, 4.154199e-01, 4.154364e-01,
    4.154529e-01, 4.154694e-01, 4.154859e-01, 4.155025e-01, 4.155190e-01, 4.155355e-01,
    4.155520e-01, 4.155685e-01, 4.155850e-01, 4.156015e-01, 4.156180e-01, 4.156345e-01,
    4.156510e-01, 4.156675e-01, 4.156840e-01, 4.157005e-01, 4.157170e-01, 4.157335e-01,
    4.157500e-01, 4.157665e-01, 4.157830e-01, 4.157995e-01, 4.158160e-01, 4.158325e-01,
    4.158490e-01, 4.158655e-01, 4.158821e-01, 4.158986e-01, 4.159150e-01, 4.159315e-01,
    4.159480e-01, 4.159645e-01, 4.159810e-01, 4.159975e-01, 4.160140e-01, 4.160306e-01,
    4.160470e-01, 4.160635e-01, 4.160800e-01, 4.160965e-01, 4.161130e-01, 4.161295e-01,
    4.161460e-01, 4.161625e-01, 4.161790e-01, 4.161955e-01, 4.162120e-01, 4.162285e-01,
    4.162450e-01, 4.162615e-01, 4.162780e-01, 4.162945e-01, 4.163110e-01, 4.163275e-01,
    4.163440e-01, 4.163604e-01, 4.163769e-01, 4.163935e-01, 4.164099e-01, 4.164265e-01,
    4.164430e-01, 4.164594e-01, 4.164760e-01, 4.164924e-01, 4.165089e-01, 4.165254e-01,
    4.165419e-01, 4.165584e-01, 4.165749e-01, 4.165914e-01, 4.166079e-01, 4.166244e-01,
    4.166409e-01, 4.166573e-01, 4.166738e-01, 4.166903e-01, 4.167068e-01, 4.167233e-01,
    4.167398e-01, 4.167563e-01, 4.167728e-01, 4.167893e-01, 4.168057e-01, 4.168223e-01,
    4.168387e-01, 4.168552e-01, 4.168717e-01, 4.168882e-01, 4.169047e-01, 4.169212e-01,
    4.169377e-01, 4.169542e-01, 4.169706e-01, 4.169872e-01, 4.170036e-01, 4.170201e-01,
    4.170366e-01, 4.170531e-01, 4.170696e-01, 4.170861e-01, 4.171025e-01, 4.171191e-01,
    4.171355e-01, 4.171520e-01, 4.171685e-01, 4.171850e-01, 4.172015e-01, 4.172180e-01,
    4.172345e-01, 4.172509e-01, 4.172674e-01, 4.172839e-01, 4.173004e-01, 4.173169e-01,
    4.173334e-01, 4.173498e-01, 4.173663e-01, 4.173828e-01, 4.173993e-01, 4.174158e-01,
    4.174322e-01, 4.174488e-01, 4.174652e-01, 4.174817e-01, 4.174982e-01, 4.175147e-01,
    4.175311e-01, 4.175476e-01, 4.175641e-01, 4.175806e-01, 4.175971e-01, 4.176136e-01,
    4.176300e-01, 4.176465e-01, 4.176630e-01, 4.176795e-01, 4.176960e-01, 4.177125e-01,
    4.177289e-01, 4.177454e-01, 4.177619e-01, 4.177784e-01, 4.177948e-01, 4.178113e-01,
    4.178278e-01, 4.178443e-01, 4.178607e-01, 4.178772e-01, 4.178937e-01, 4.179102e-01,
    4.179267e-01, 4.179431e-01, 4.179596e-01, 4.179761e-01, 4.179926e-01, 4.180090e-01,
    4.180256e-01, 4.180420e-01, 4.180585e-01, 4.180749e-01, 4.180914e-01, 4.181079e-01,
    4.181244e-01, 4.181409e-01, 4.181573e-01, 4.181738e-01, 4.181903e-01, 4.182068e-01,
    4.182232e-01, 4.182397e-01, 4.182562e-01, 4.182726e-01, 4.182891e-01, 4.183056e-01,
    4.183221e-01, 4.183386e-01, 4.183550e-01, 4.183715e-01, 4.183879e-01, 4.184044e-01,
    4.184209e-01, 4.184374e-01, 4.184538e-01, 4.184703e-01, 4.184868e-01, 4.185033e-01,
    4.185197e-01, 4.185362e-01, 4.185527e-01, 4.185691e-01, 4.185856e-01, 4.186021e-01,
    4.186185e-01, 4.186350e-01, 4.186515e-01, 4.186679e-01, 4.186844e-01, 4.187009e-01,
    4.187174e-01, 4.187338e-01, 4.187503e-01, 4.187667e-01, 4.187832e-01, 4.187997e-01,
    4.188161e-01, 4.188326e-01, 4.188491e-01, 4.188656e-01, 4.188820e-01, 4.188985e-01,
    4.189149e-01, 4.189314e-01, 4.189479e-01, 4.189644e-01, 4.189808e-01, 4.189973e-01,
    4.190138e-01, 4.190302e-01, 4.190467e-01, 4.190632e-01, 4.190796e-01, 4.190961e-01,
    4.191126e-01, 4.191290e-01, 4.191455e-01, 4.191619e-01, 4.191784e-01, 4.191948e-01,
    4.192113e-01, 4.192278e-01, 4.192443e-01, 4.192607e-01, 4.192772e-01, 4.192936e-01,
    4.193101e-01, 4.193265e-01, 4.193430e-01, 4.193595e-01, 4.193760e-01, 4.193924e-01,
    4.194089e-01, 4.194253e-01, 4.194418e-01, 4.194582e-01, 4.194747e-01, 4.194911e-01,
    4.195076e-01, 4.195241e-01, 4.195406e-01, 4.195570e-01, 4.195735e-01, 4.195899e-01,
    4.196064e-01, 4.196228e-01, 4.196393e-01, 4.196557e-01, 4.196722e-01, 4.196887e-01,
    4.197051e-01, 4.197215e-01, 4.197380e-01, 4.197545e-01, 4.197710e-01, 4.197874e-01,
    4.198039e-01, 4.198203e-01, 4.198368e-01, 4.198532e-01, 4.198697e-01, 4.198861e-01,
    4.199026e-01, 4.199190e-01, 4.199355e-01, 4.199520e-01, 4.199684e-01, 4.199848e-01,
    4.200013e-01, 4.200177e-01, 4.200342e-01, 4.200507e-01, 4.200671e-01, 4.200836e-01,
    4.201000e-01, 4.201165e-01, 4.201329e-01, 4.201494e-01, 4.201658e-01, 4.201823e-01,
    4.201988e-01, 4.202152e-01, 4.202316e-01, 4.202481e-01, 4.202645e-01, 4.202810e-01,
    4.202974e-01, 4.203139e-01, 4.203303e-01, 4.203468e-01, 4.203632e-01, 4.203797e-01,
    4.203961e-01, 4.204126e-01, 4.204291e-01, 4.204455e-01, 4.204619e-01, 4.204784e-01,
    4.204948e-01, 4.205113e-01, 4.205277e-01, 4.205442e-01, 4.205606e-01, 4.205771e-01,
    4.205935e-01, 4.206100e-01, 4.206264e-01, 4.206429e-01, 4.206593e-01, 4.206758e-01,
    4.206922e-01, 4.207087e-01, 4.207251e-01, 4.207415e-01, 4.207579e-01, 4.207744e-01,
    4.207909e-01, 4.208073e-01, 4.208238e-01, 4.208402e-01, 4.208566e-01, 4.208731e-01,
    4.208895e-01, 4.209060e-01, 4.209224e-01, 4.209388e-01, 4.209553e-01, 4.209718e-01,
    4.209882e-01, 4.210046e-01, 4.210211e-01, 4.210375e-01, 4.210539e-01, 4.210704e-01,
    4.210868e-01, 4.211033e-01, 4.211197e-01, 4.211361e-01, 4.211526e-01, 4.211690e-01,
    4.211855e-01, 4.212019e-01, 4.212184e-01, 4.212348e-01, 4.212512e-01, 4.212677e-01,
    4.212841e-01, 4.213006e-01, 4.213170e-01, 4.213335e-01, 4.213499e-01, 4.213663e-01,
    4.213828e-01, 4.213992e-01, 4.214156e-01, 4.214320e-01, 4.214485e-01, 4.214649e-01,
    4.214814e-01, 4.214978e-01, 4.215142e-01, 4.215307e-01, 4.215471e-01, 4.215636e-01,
    4.215800e-01, 4.215964e-01, 4.216129e-01, 4.216293e-01, 4.216457e-01, 4.216622e-01,
    4.216786e-01, 4.216951e-01, 4.217115e-01, 4.217279e-01, 4.217443e-01, 4.217608e-01,
    4.217772e-01, 4.217936e-01, 4.218101e-01, 4.218265e-01, 4.218430e-01, 4.218594e-01,
    4.218758e-01, 4.218922e-01, 4.219086e-01, 4.219251e-01, 4.219415e-01, 4.219580e-01,
    4.219744e-01, 4.219908e-01, 4.220072e-01, 4.220237e-01, 4.220401e-01, 4.220566e-01,
    4.220730e-01, 4.220894e-01, 4.221058e-01, 4.221223e-01, 4.221387e-01, 4.221551e-01,
    4.221716e-01, 4.221880e-01, 4.222044e-01, 4.222209e-01, 4.222373e-01, 4.222537e-01,
    4.222701e-01, 4.222865e-01, 4.223030e-01, 4.223194e-01, 4.223358e-01, 4.223523e-01,
    4.223687e-01, 4.223851e-01, 4.224015e-01, 4.224180e-01, 4.224344e-01, 4.224508e-01,
    4.224673e-01, 4.224837e-01, 4.225001e-01, 4.225165e-01, 4.225329e-01, 4.225494e-01,
    4.225658e-01, 4.225822e-01, 4.225987e-01, 4.226151e-01, 4.226315e-01, 4.226479e-01,
    4.226643e-01, 4.226808e-01, 4.226972e-01, 4.227136e-01, 4.227301e-01, 4.227465e-01,
    4.227629e-01, 4.227793e-01, 4.227957e-01, 4.228121e-01, 4.228286e-01, 4.228450e-01,
    4.228614e-01, 4.228778e-01, 4.228942e-01, 4.229107e-01, 4.229271e-01, 4.229435e-01,
    4.229600e-01, 4.229764e-01, 4.229927e-01, 4.230092e-01, 4.230256e-01, 4.230420e-01,
    4.230585e-01, 4.230749e-01, 4.230913e-01, 4.231077e-01, 4.231241e-01, 4.231405e-01,
    4.231569e-01, 4.231734e-01, 4.231898e-01, 4.232062e-01, 4.232226e-01, 4.232390e-01,
    4.232554e-01, 4.232719e-01, 4.232883e-01, 4.233047e-01, 4.233211e-01, 4.233375e-01,
    4.233539e-01, 4.233704e-01, 4.233868e-01, 4.234032e-01, 4.234196e-01, 4.234360e-01,
    4.234525e-01, 4.234688e-01, 4.234852e-01, 4.235017e-01, 4.235181e-01, 4.235345e-01,
    4.235509e-01, 4.235674e-01, 4.235838e-01, 4.236001e-01, 4.236166e-01, 4.236330e-01,
    4.236494e-01, 4.236658e-01, 4.236822e-01, 4.236987e-01, 4.237150e-01, 4.237314e-01,
    4.237479e-01, 4.237643e-01, 4.237807e-01, 4.237971e-01, 4.238135e-01, 4.238299e-01,
    4.238463e-01, 4.238627e-01, 4.238791e-01, 4.238956e-01, 4.239120e-01, 4.239284e-01,
    4.239448e-01, 4.239612e-01, 4.239776e-01, 4.239940e-01, 4.240104e-01, 4.240268e-01,
    4.240432e-01, 4.240596e-01, 4.240761e-01, 4.240924e-01, 4.241089e-01, 4.241253e-01,
    4.241417e-01, 4.241581e-01, 4.241745e-01, 4.241909e-01, 4.242073e-01, 4.242237e-01,
    4.242401e-01, 4.242565e-01, 4.242730e-01, 4.242893e-01, 4.243057e-01, 4.243221e-01,
    4.243385e-01, 4.243549e-01, 4.243714e-01, 4.243878e-01, 4.244042e-01, 4.244205e-01,
    4.244370e-01, 4.244533e-01, 4.244698e-01, 4.244862e-01, 4.245026e-01, 4.245190e-01,
    4.245354e-01, 4.245518e-01, 4.245682e-01, 4.245846e-01, 4.246010e-01, 4.246174e-01,
    4.246338e-01, 4.246502e-01, 4.246666e-01, 4.246830e-01, 4.246994e-01, 4.247158e-01,
    4.247322e-01, 4.247486e-01, 4.247650e-01, 4.247814e-01, 4.247978e-01, 4.248142e-01,
    4.248306e-01, 4.248470e-01, 4.248634e-01, 4.248798e-01, 4.248962e-01, 4.249126e-01,
    4.249290e-01, 4.249454e-01, 4.249618e-01, 4.249782e-01, 4.249946e-01, 4.250109e-01,
    4.250273e-01, 4.250438e-01, 4.250602e-01, 4.250765e-01, 4.250930e-01, 4.251093e-01,
    4.251257e-01, 4.251421e-01, 4.251585e-01, 4.251749e-01, 4.251913e-01, 4.252077e-01,
    4.252241e-01, 4.252405e-01, 4.252569e-01, 4.252733e-01, 4.252897e-01, 4.253061e-01,
    4.253225e-01, 4.253388e-01, 4.253552e-01, 4.253716e-01, 4.253880e-01, 4.254044e-01,
    4.254208e-01, 4.254372e-01, 4.254536e-01, 4.254700e-01, 4.254864e-01, 4.255028e-01,
    4.255192e-01, 4.255356e-01, 4.255519e-01, 4.255683e-01, 4.255847e-01, 4.256011e-01,
    4.256175e-01, 4.256339e-01, 4.256503e-01, 4.256667e-01, 4.256831e-01, 4.256994e-01,
    4.257158e-01, 4.257322e-01, 4.257486e-01, 4.257650e-01, 4.257814e-01, 4.257978e-01,
    4.258142e-01, 4.258305e-01, 4.258469e-01, 4.258633e-01, 4.258797e-01, 4.258961e-01,
    4.259125e-01, 4.259289e-01, 4.259453e-01, 4.259616e-01, 4.259780e-01, 4.259944e-01,
    4.260108e-01, 4.260272e-01, 4.260436e-01, 4.260600e-01, 4.260764e-01, 4.260927e-01,
    4.261091e-01, 4.261255e-01, 4.261419e-01, 4.261582e-01, 4.261746e-01, 4.261910e-01,
    4.262074e-01, 4.262238e-01, 4.262402e-01, 4.262565e-01, 4.262729e-01, 4.262893e-01,
    4.263057e-01, 4.263221e-01, 4.263385e-01, 4.263548e-01, 4.263712e-01, 4.263876e-01,
    4.264040e-01, 4.264204e-01, 4.264368e-01, 4.264531e-01, 4.264695e-01, 4.264859e-01,
    4.265023e-01, 4.265186e-01, 4.265350e-01, 4.265514e-01, 4.265678e-01, 4.265842e-01,
    4.266005e-01, 4.266169e-01, 4.266333e-01, 4.266497e-01, 4.266661e-01, 4.266825e-01,
    4.266988e-01, 4.267152e-01, 4.267316e-01, 4.267479e-01, 4.267643e-01, 4.267807e-01,
    4.267971e-01, 4.268135e-01, 4.268298e-01, 4.268462e-01, 4.268626e-01, 4.268790e-01,
    4.268953e-01, 4.269117e-01, 4.269281e-01, 4.269445e-01, 4.269608e-01, 4.269772e-01,
    4.269936e-01, 4.270100e-01, 4.270263e-01, 4.270427e-01, 4.270591e-01, 4.270754e-01,
    4.270918e-01, 4.271082e-01, 4.271246e-01, 4.271409e-01, 4.271573e-01, 4.271737e-01,
    4.271901e-01, 4.272065e-01, 4.272228e-01, 4.272392e-01, 4.272555e-01, 4.272719e-01,
    4.272883e-01, 4.273047e-01, 4.273210e-01, 4.273374e-01, 4.273537e-01, 4.273701e-01,
    4.273865e-01, 4.274029e-01, 4.274192e-01, 4.274356e-01, 4.274520e-01, 4.274683e-01,
    4.274847e-01, 4.275011e-01, 4.275174e-01, 4.275338e-01, 4.275502e-01, 4.275666e-01,
    4.275829e-01, 4.275993e-01, 4.276157e-01, 4.276320e-01, 4.276484e-01, 4.276648e-01,
    4.276811e-01, 4.276975e-01, 4.277138e-01, 4.277302e-01, 4.277466e-01, 4.277630e-01,
    4.277793e-01, 4.277957e-01, 4.278120e-01, 4.278284e-01, 4.278448e-01, 4.278612e-01,
    4.278775e-01, 4.278939e-01, 4.279102e-01, 4.279266e-01, 4.279430e-01, 4.279594e-01,
    4.279757e-01, 4.279921e-01, 4.280084e-01, 4.280248e-01, 4.280411e-01, 4.280575e-01,
    4.280739e-01, 4.280902e-01, 4.281066e-01, 4.281229e-01, 4.281393e-01, 4.281557e-01,
    4.281721e-01, 4.281884e-01, 4.282048e-01, 4.282211e-01, 4.282375e-01, 4.282538e-01,
    4.282702e-01, 4.282866e-01, 4.283029e-01, 4.283193e-01, 4.283356e-01, 4.283520e-01,
    4.283684e-01, 4.283847e-01, 4.284011e-01, 4.284174e-01, 4.284338e-01, 4.284501e-01,
    4.284665e-01, 4.284829e-01, 4.284992e-01, 4.285156e-01, 4.285319e-01, 4.285483e-01,
    4.285646e-01, 4.285810e-01, 4.285974e-01, 4.286137e-01, 4.286301e-01, 4.286464e-01,
    4.286627e-01, 4.286791e-01, 4.286955e-01, 4.287119e-01, 4.287282e-01, 4.287445e-01,
    4.287609e-01, 4.287772e-01, 4.287936e-01, 4.288100e-01, 4.288263e-01, 4.288427e-01,
    4.288590e-01, 4.288754e-01, 4.288917e-01, 4.289081e-01, 4.289244e-01, 4.289408e-01,
    4.289571e-01, 4.289735e-01, 4.289898e-01, 4.290062e-01, 4.290226e-01, 4.290389e-01,
    4.290552e-01, 4.290716e-01, 4.290879e-01, 4.291043e-01, 4.291207e-01, 4.291370e-01,
    4.291533e-01, 4.291697e-01, 4.291860e-01, 4.292024e-01, 4.292187e-01, 4.292351e-01,
    4.292515e-01, 4.292678e-01, 4.292841e-01, 4.293005e-01, 4.293168e-01, 4.293332e-01,
    4.293495e-01, 4.293659e-01, 4.293822e-01, 4.293986e-01, 4.294149e-01, 4.294313e-01,
    4.294476e-01, 4.294640e-01, 4.294803e-01, 4.294966e-01, 4.295130e-01, 4.295293e-01,
    4.295457e-01, 4.295620e-01, 4.295784e-01, 4.295947e-01, 4.296111e-01, 4.296274e-01,
    4.296438e-01, 4.296601e-01, 4.296764e-01, 4.296928e-01, 4.297091e-01, 4.297255e-01,
    4.297418e-01, 4.297582e-01, 4.297745e-01, 4.297908e-01, 4.298072e-01, 4.298235e-01,
    4.298398e-01, 4.298562e-01, 4.298725e-01, 4.298889e-01, 4.299052e-01, 4.299216e-01,
    4.299379e-01, 4.299543e-01, 4.299706e-01, 4.299869e-01, 4.300033e-01, 4.300196e-01,
    4.300359e-01, 4.300523e-01, 4.300686e-01, 4.300850e-01, 4.301013e-01, 4.301176e-01,
    4.301340e-01, 4.301503e-01, 4.301667e-01, 4.301830e-01, 4.301993e-01, 4.302157e-01,
    4.302320e-01, 4.302483e-01, 4.302647e-01, 4.302810e-01, 4.302974e-01, 4.303137e-01,
    4.303300e-01, 4.303464e-01, 4.303627e-01, 4.303791e-01, 4.303954e-01, 4.304117e-01,
    4.304280e-01, 4.304444e-01, 4.304607e-01, 4.304771e-01, 4.304934e-01, 4.305097e-01,
    4.305260e-01, 4.305424e-01, 4.305587e-01, 4.305751e-01, 4.305914e-01, 4.306077e-01,
    4.306240e-01, 4.306404e-01, 4.306567e-01, 4.306731e-01, 4.306894e-01, 4.307057e-01,
    4.307220e-01, 4.307384e-01, 4.307547e-01, 4.307711e-01, 4.307874e-01, 4.308037e-01,
    4.308200e-01, 4.308363e-01, 4.308527e-01, 4.308690e-01, 4.308854e-01, 4.309017e-01,
    4.309180e-01, 4.309343e-01, 4.309507e-01, 4.309670e-01, 4.309833e-01, 4.309997e-01,
    4.310160e-01, 4.310323e-01, 4.310486e-01, 4.310650e-01, 4.310813e-01, 4.310977e-01,
    4.311139e-01, 4.311303e-01, 4.311466e-01, 4.311630e-01, 4.311793e-01, 4.311956e-01,
    4.312119e-01, 4.312283e-01, 4.312446e-01, 4.312609e-01, 4.312772e-01, 4.312935e-01,
    4.313099e-01, 4.313262e-01, 4.313425e-01, 4.313588e-01, 4.313752e-01, 4.313915e-01,
    4.314078e-01, 4.314241e-01, 4.314405e-01, 4.314568e-01, 4.314731e-01, 4.314894e-01,
    4.315058e-01, 4.315221e-01, 4.315384e-01, 4.315547e-01, 4.315711e-01, 4.315874e-01,
    4.316037e-01, 4.316200e-01, 4.316363e-01, 4.316527e-01, 4.316690e-01, 4.316853e-01,
    4.317017e-01, 4.317179e-01, 4.317343e-01, 4.317506e-01, 4.317669e-01, 4.317832e-01,
    4.317996e-01, 4.318159e-01, 4.318322e-01, 4.318485e-01, 4.318648e-01, 4.318812e-01,
    4.318975e-01, 4.319138e-01, 4.319301e-01, 4.319464e-01, 4.319627e-01, 4.319791e-01,
    4.319954e-01, 4.320117e-01, 4.320280e-01, 4.320443e-01, 4.320606e-01, 4.320770e-01,
    4.320933e-01, 4.321096e-01, 4.321259e-01, 4.321422e-01, 4.321585e-01, 4.321749e-01,
    4.321912e-01, 4.322075e-01, 4.322238e-01, 4.322401e-01, 4.322564e-01, 4.322728e-01,
    4.322891e-01, 4.323053e-01, 4.323217e-01, 4.323380e-01, 4.323543e-01, 4.323706e-01,
    4.323869e-01, 4.324032e-01, 4.324195e-01, 4.324359e-01, 4.324522e-01, 4.324685e-01,
    4.324848e-01, 4.325011e-01, 4.325174e-01, 4.325337e-01, 4.325500e-01, 4.325664e-01,
    4.325827e-01, 4.325990e-01, 4.326153e-01, 4.326316e-01, 4.326479e-01, 4.326642e-01,
    4.326805e-01, 4.326969e-01, 4.327132e-01, 4.327295e-01, 4.327458e-01, 4.327621e-01,
    4.327784e-01, 4.327947e-01, 4.328110e-01, 4.328273e-01, 4.328436e-01, 4.328600e-01,
    4.328763e-01, 4.328925e-01, 4.329088e-01, 4.329252e-01, 4.329415e-01, 4.329578e-01,
    4.329741e-01, 4.329904e-01, 4.330067e-01, 4.330230e-01, 4.330393e-01, 4.330556e-01,
    4.330719e-01, 4.330882e-01, 4.331045e-01, 4.331208e-01, 4.331371e-01, 4.331535e-01,
    4.331697e-01, 4.331860e-01, 4.332024e-01, 4.332187e-01, 4.332350e-01, 4.332513e-01,
    4.332676e-01, 4.332839e-01, 4.333002e-01, 4.333165e-01, 4.333328e-01, 4.333491e-01,
    4.333654e-01, 4.333817e-01, 4.333980e-01, 4.334143e-01, 4.334306e-01, 4.334469e-01,
    4.334632e-01, 4.334795e-01, 4.334958e-01, 4.335121e-01, 4.335284e-01, 4.335447e-01,
    4.335610e-01, 4.335773e-01, 4.335936e-01, 4.336099e-01, 4.336262e-01, 4.336425e-01,
    4.336588e-01, 4.336751e-01, 4.336914e-01, 4.337077e-01, 4.337240e-01, 4.337403e-01,
    4.337566e-01, 4.337729e-01, 4.337892e-01, 4.338055e-01, 4.338218e-01, 4.338381e-01,
    4.338543e-01, 4.338706e-01, 4.338869e-01, 4.339032e-01, 4.339195e-01, 4.339358e-01,
    4.339521e-01, 4.339684e-01, 4.339847e-01, 4.340010e-01, 4.340173e-01, 4.340336e-01,
    4.340499e-01, 4.340662e-01, 4.340825e-01, 4.340988e-01, 4.341151e-01, 4.341314e-01,
    4.341477e-01, 4.341640e-01, 4.341803e-01, 4.341966e-01, 4.342129e-01, 4.342291e-01,
    4.342454e-01, 4.342617e-01, 4.342780e-01, 4.342943e-01, 4.343106e-01, 4.343269e-01,
    4.343432e-01, 4.343595e-01, 4.343758e-01, 4.343920e-01, 4.344083e-01, 4.344246e-01,
    4.344409e-01, 4.344572e-01, 4.344735e-01, 4.344898e-01, 4.345061e-01, 4.345223e-01,
    4.345386e-01, 4.345549e-01, 4.345712e-01, 4.345875e-01, 4.346038e-01, 4.346201e-01,
    4.346364e-01, 4.346527e-01, 4.346690e-01, 4.346853e-01, 4.347015e-01, 4.347178e-01,
    4.347341e-01, 4.347504e-01, 4.347667e-01, 4.347829e-01, 4.347992e-01, 4.348155e-01,
    4.348318e-01, 4.348481e-01, 4.348644e-01, 4.348807e-01, 4.348969e-01, 4.349132e-01,
    4.349295e-01, 4.349458e-01, 4.349621e-01, 4.349783e-01, 4.349946e-01, 4.350109e-01,
    4.350272e-01, 4.350435e-01, 4.350598e-01, 4.350761e-01, 4.350923e-01, 4.351086e-01,
    4.351249e-01, 4.351412e-01, 4.351575e-01, 4.351737e-01, 4.351901e-01, 4.352063e-01,
    4.352226e-01, 4.352389e-01, 4.352551e-01, 4.352714e-01, 4.352877e-01, 4.353040e-01,
    4.353203e-01, 4.353365e-01, 4.353528e-01, 4.353691e-01, 4.353854e-01, 4.354017e-01,
    4.354180e-01, 4.354342e-01, 4.354505e-01, 4.354668e-01, 4.354831e-01, 4.354994e-01,
    4.355156e-01, 4.355319e-01, 4.355482e-01, 4.355645e-01, 4.355808e-01, 4.355970e-01,
    4.356133e-01, 4.356295e-01, 4.356458e-01, 4.356621e-01, 4.356784e-01, 4.356947e-01,
    4.357109e-01, 4.357272e-01, 4.357435e-01, 4.357598e-01, 4.357761e-01, 4.357923e-01,
    4.358086e-01, 4.358249e-01, 4.358411e-01, 4.358574e-01, 4.358737e-01, 4.358900e-01,
    4.359062e-01, 4.359225e-01, 4.359388e-01, 4.359551e-01, 4.359713e-01, 4.359876e-01,
    4.360039e-01, 4.360201e-01, 4.360364e-01, 4.360527e-01, 4.360690e-01, 4.360852e-01,
    4.361015e-01, 4.361178e-01, 4.361340e-01, 4.361503e-01, 4.361666e-01, 4.361829e-01,
    4.361991e-01, 4.362154e-01, 4.362317e-01, 4.362479e-01, 4.362642e-01, 4.362805e-01,
    4.362968e-01, 4.363130e-01, 4.363293e-01, 4.363456e-01, 4.363618e-01, 4.363781e-01,
    4.363944e-01, 4.364106e-01, 4.364269e-01, 4.364432e-01, 4.364594e-01, 4.364757e-01,
    4.364920e-01, 4.365082e-01, 4.365245e-01, 4.365408e-01, 4.365570e-01, 4.365733e-01,
    4.365896e-01, 4.366058e-01, 4.366221e-01, 4.366384e-01, 4.366546e-01, 4.366709e-01,
    4.366871e-01, 4.367034e-01, 4.367197e-01, 4.367359e-01, 4.367522e-01, 4.367685e-01,
    4.367847e-01, 4.368010e-01, 4.368173e-01, 4.368335e-01, 4.368498e-01, 4.368660e-01,
    4.368823e-01, 4.368986e-01, 4.369148e-01, 4.369311e-01, 4.369473e-01, 4.369636e-01,
    4.369799e-01, 4.369961e-01, 4.370124e-01, 4.370286e-01, 4.370449e-01, 4.370612e-01,
    4.370774e-01, 4.370937e-01, 4.371099e-01, 4.371262e-01, 4.371425e-01, 4.371587e-01,
    4.371750e-01, 4.371912e-01, 4.372075e-01, 4.372238e-01, 4.372400e-01, 4.372563e-01,
    4.372725e-01, 4.372888e-01, 4.373051e-01, 4.373213e-01, 4.373375e-01, 4.373538e-01,
    4.373701e-01, 4.373864e-01, 4.374026e-01, 4.374189e-01, 4.374351e-01, 4.374514e-01,
    4.374676e-01, 4.374839e-01, 4.375001e-01, 4.375164e-01, 4.375326e-01, 4.375489e-01,
    4.375651e-01, 4.375814e-01, 4.375977e-01, 4.376139e-01, 4.376302e-01, 4.376464e-01,
    4.376627e-01, 4.376789e-01, 4.376952e-01, 4.377114e-01, 4.377277e-01, 4.377440e-01,
    4.377602e-01, 4.377765e-01, 4.377927e-01, 4.378090e-01, 4.378252e-01, 4.378415e-01,
    4.378577e-01, 4.378740e-01, 4.378902e-01, 4.379065e-01, 4.379227e-01, 4.379389e-01,
    4.379552e-01, 4.379714e-01, 4.379877e-01, 4.380040e-01, 4.380202e-01, 4.380365e-01,
    4.380527e-01, 4.380690e-01, 4.380852e-01, 4.381015e-01, 4.381177e-01, 4.381340e-01,
    4.381502e-01, 4.381664e-01, 4.381827e-01, 4.381989e-01, 4.382152e-01, 4.382314e-01,
    4.382477e-01, 4.382640e-01, 4.382802e-01, 4.382964e-01, 4.383126e-01, 4.383289e-01,
    4.383452e-01, 4.383614e-01, 4.383777e-01, 4.383939e-01, 4.384101e-01, 4.384264e-01,
    4.384426e-01, 4.384589e-01, 4.384751e-01, 4.384913e-01, 4.385076e-01, 4.385239e-01,
    4.385401e-01, 4.385564e-01, 4.385726e-01, 4.385888e-01, 4.386051e-01, 4.386213e-01,
    4.386375e-01, 4.386538e-01, 4.386700e-01, 4.386863e-01, 4.387026e-01, 4.387188e-01,
    4.387350e-01, 4.387513e-01, 4.387675e-01, 4.387837e-01, 4.388000e-01, 4.388162e-01,
    4.388324e-01, 4.388487e-01, 4.388649e-01, 4.388812e-01, 4.388974e-01, 4.389136e-01,
    4.389299e-01, 4.389461e-01, 4.389624e-01, 4.389786e-01, 4.389948e-01, 4.390111e-01,
    4.390273e-01, 4.390436e-01, 4.390598e-01, 4.390760e-01, 4.390922e-01, 4.391085e-01,
    4.391248e-01, 4.391410e-01, 4.391572e-01, 4.391735e-01, 4.391897e-01, 4.392059e-01,
    4.392222e-01, 4.392384e-01, 4.392546e-01, 4.392709e-01, 4.392871e-01, 4.393033e-01,
    4.393196e-01, 4.393358e-01, 4.393520e-01, 4.393683e-01, 4.393845e-01, 4.394008e-01,
    4.394170e-01, 4.394332e-01, 4.394495e-01, 4.394657e-01, 4.394819e-01, 4.394981e-01,
    4.395144e-01, 4.395306e-01, 4.395469e-01, 4.395631e-01, 4.395793e-01, 4.395955e-01,
    4.396118e-01, 4.396280e-01, 4.396442e-01, 4.396605e-01, 4.396767e-01, 4.396929e-01,
    4.397092e-01, 4.397254e-01, 4.397416e-01, 4.397578e-01, 4.397741e-01, 4.397903e-01,
    4.398066e-01, 4.398228e-01, 4.398390e-01, 4.398552e-01, 4.398715e-01, 4.398877e-01,
    4.399039e-01, 4.399201e-01, 4.399363e-01, 4.399526e-01, 4.399688e-01, 4.399851e-01,
    4.400013e-01, 4.400175e-01, 4.400337e-01, 4.400499e-01, 4.400662e-01, 4.400824e-01,
    4.400986e-01, 4.401149e-01, 4.401311e-01, 4.401473e-01, 4.401636e-01, 4.401797e-01,
    4.401960e-01, 4.402122e-01, 4.402284e-01, 4.402447e-01, 4.402609e-01, 4.402771e-01,
    4.402933e-01, 4.403096e-01, 4.403258e-01, 4.403420e-01, 4.403582e-01, 4.403744e-01,
    4.403907e-01, 4.404069e-01, 4.404231e-01, 4.404393e-01, 4.404556e-01, 4.404718e-01,
    4.404880e-01, 4.405042e-01, 4.405204e-01, 4.405366e-01, 4.405529e-01, 4.405691e-01,
    4.405853e-01, 4.406015e-01, 4.406178e-01, 4.406340e-01, 4.406502e-01, 4.406664e-01,
    4.406827e-01, 4.406989e-01, 4.407151e-01, 4.407313e-01, 4.407476e-01, 4.407638e-01,
    4.407800e-01, 4.407962e-01, 4.408124e-01, 4.408287e-01, 4.408448e-01, 4.408610e-01,
    4.408773e-01, 4.408935e-01, 4.409097e-01, 4.409259e-01, 4.409421e-01, 4.409584e-01,
    4.409746e-01, 4.409908e-01, 4.410070e-01, 4.410232e-01, 4.410394e-01, 4.410557e-01,
    4.410719e-01, 4.410881e-01, 4.411043e-01, 4.411205e-01, 4.411367e-01, 4.411530e-01,
    4.411692e-01, 4.411854e-01, 4.412016e-01, 4.412178e-01, 4.412340e-01, 4.412502e-01,
    4.412664e-01, 4.412826e-01, 4.412989e-01, 4.413151e-01, 4.413313e-01, 4.413475e-01,
    4.413637e-01, 4.413799e-01, 4.413961e-01, 4.414124e-01, 4.414285e-01, 4.414448e-01,
    4.414610e-01, 4.414772e-01, 4.414934e-01, 4.415096e-01, 4.415258e-01, 4.415420e-01,
    4.415582e-01, 4.415745e-01, 4.415906e-01, 4.416068e-01, 4.416231e-01, 4.416393e-01,
    4.416555e-01, 4.416717e-01, 4.416879e-01, 4.417041e-01, 4.417203e-01, 4.417365e-01,
    4.417527e-01, 4.417689e-01, 4.417852e-01, 4.418014e-01, 4.418176e-01, 4.418338e-01,
    4.418500e-01, 4.418662e-01, 4.418824e-01, 4.418986e-01, 4.419148e-01, 4.419310e-01,
    4.419472e-01, 4.419634e-01, 4.419796e-01, 4.419958e-01, 4.420120e-01, 4.420283e-01,
    4.420444e-01, 4.420606e-01, 4.420768e-01, 4.420930e-01, 4.421093e-01, 4.421255e-01,
    4.421417e-01, 4.421578e-01, 4.421740e-01, 4.421903e-01, 4.422065e-01, 4.422227e-01,
    4.422389e-01, 4.422550e-01, 4.422713e-01, 4.422875e-01, 4.423037e-01, 4.423199e-01,
    4.423361e-01, 4.423523e-01, 4.423685e-01, 4.423847e-01, 4.424009e-01, 4.424171e-01,
    4.424333e-01, 4.424495e-01, 4.424657e-01, 4.424819e-01, 4.424981e-01, 4.425143e-01,
    4.425305e-01, 4.425467e-01, 4.425629e-01, 4.425791e-01, 4.425953e-01, 4.426115e-01,
    4.426277e-01, 4.426439e-01, 4.426601e-01, 4.426762e-01, 4.426925e-01, 4.427087e-01,
    4.427249e-01, 4.427410e-01, 4.427572e-01, 4.427735e-01, 4.427896e-01, 4.428058e-01,
    4.428220e-01, 4.428382e-01, 4.428544e-01, 4.428706e-01, 4.428868e-01, 4.429030e-01,
    4.429192e-01, 4.429354e-01, 4.429516e-01, 4.429678e-01, 4.429840e-01, 4.430002e-01,
    4.430164e-01, 4.430326e-01, 4.430488e-01, 4.430649e-01, 4.430811e-01, 4.430974e-01,
    4.431135e-01, 4.431297e-01, 4.431459e-01, 4.431621e-01, 4.431783e-01, 4.431945e-01,
    4.432107e-01, 4.432268e-01, 4.432431e-01, 4.432592e-01, 4.432754e-01, 4.432916e-01,
    4.433078e-01, 4.433240e-01, 4.433402e-01, 4.433564e-01, 4.433726e-01, 4.433888e-01,
    4.434049e-01, 4.434212e-01, 4.434373e-01, 4.434535e-01, 4.434697e-01, 4.434859e-01,
    4.435021e-01, 4.435183e-01, 4.435344e-01, 4.435506e-01, 4.435668e-01, 4.435830e-01,
    4.435992e-01, 4.436154e-01, 4.436316e-01, 4.436478e-01, 4.436640e-01, 4.436802e-01,
    4.436963e-01, 4.437125e-01, 4.437287e-01, 4.437449e-01, 4.437611e-01, 4.437772e-01,
    4.437934e-01, 4.438096e-01, 4.438258e-01, 4.438420e-01, 4.438581e-01, 4.438744e-01,
    4.438905e-01, 4.439067e-01, 4.439229e-01, 4.439391e-01, 4.439553e-01, 4.439715e-01,
    4.439876e-01, 4.440038e-01, 4.440200e-01, 4.440362e-01, 4.440524e-01, 4.440685e-01,
    4.440847e-01, 4.441009e-01, 4.441171e-01, 4.441333e-01, 4.441495e-01, 4.441656e-01,
    4.441818e-01, 4.441980e-01, 4.442142e-01, 4.442303e-01, 4.442465e-01, 4.442627e-01,
    4.442789e-01, 4.442951e-01, 4.443112e-01, 4.443274e-01, 4.443436e-01, 4.443598e-01,
    4.443760e-01, 4.443921e-01, 4.444083e-01, 4.444245e-01, 4.444407e-01, 4.444568e-01,
    4.444730e-01, 4.444892e-01, 4.445054e-01, 4.445215e-01, 4.445378e-01, 4.445539e-01,
    4.445701e-01, 4.445862e-01, 4.446024e-01, 4.446186e-01, 4.446348e-01, 4.446509e-01,
    4.446671e-01, 4.446833e-01, 4.446995e-01, 4.447156e-01, 4.447318e-01, 4.447480e-01,
    4.447642e-01, 4.447804e-01, 4.447965e-01, 4.448127e-01, 4.448289e-01, 4.448450e-01,
    4.448612e-01, 4.448774e-01, 4.448936e-01, 4.449098e-01, 4.449259e-01, 4.449421e-01,
    4.449582e-01, 4.449744e-01, 4.449906e-01, 4.450067e-01, 4.450229e-01, 4.450391e-01,
    4.450553e-01, 4.450715e-01, 4.450876e-01, 4.451038e-01, 4.451199e-01, 4.451361e-01,
    4.451523e-01, 4.451684e-01, 4.451846e-01, 4.452008e-01, 4.452170e-01, 4.452331e-01,
    4.452493e-01, 4.452655e-01, 4.452817e-01, 4.452978e-01, 4.453140e-01, 4.453301e-01,
    4.453463e-01, 4.453625e-01, 4.453787e-01, 4.453948e-01, 4.454110e-01, 4.454271e-01,
    4.454433e-01, 4.454595e-01, 4.454756e-01, 4.454918e-01, 4.455080e-01, 4.455242e-01,
    4.455403e-01, 4.455565e-01, 4.455726e-01, 4.455888e-01, 4.456050e-01, 4.456211e-01,
    4.456373e-01, 4.456534e-01, 4.456696e-01, 4.456858e-01, 4.457019e-01, 4.457181e-01,
    4.457343e-01, 4.457504e-01, 4.457666e-01, 4.457828e-01, 4.457989e-01, 4.458151e-01,
    4.458312e-01, 4.458474e-01, 4.458635e-01, 4.458797e-01, 4.458959e-01, 4.459121e-01,
    4.459282e-01, 4.459443e-01, 4.459605e-01, 4.459767e-01, 4.459929e-01, 4.460090e-01,
    4.460252e-01, 4.460413e-01, 4.460575e-01, 4.460736e-01, 4.460898e-01, 4.461060e-01,
    4.461221e-01, 4.461383e-01, 4.461544e-01, 4.461706e-01, 4.461868e-01, 4.462029e-01,
    4.462191e-01, 4.462352e-01, 4.462514e-01, 4.462675e-01, 4.462837e-01, 4.462999e-01,
    4.463160e-01, 4.463322e-01, 4.463483e-01, 4.463645e-01, 4.463806e-01, 4.463968e-01,
    4.464130e-01, 4.464291e-01, 4.464453e-01, 4.464614e-01, 4.464776e-01, 4.464937e-01,
    4.465099e-01, 4.465261e-01, 4.465422e-01, 4.465583e-01, 4.465745e-01, 4.465907e-01,
    4.466068e-01, 4.466229e-01, 4.466391e-01, 4.466552e-01, 4.466714e-01, 4.466876e-01,
    4.467037e-01, 4.467199e-01, 4.467360e-01, 4.467522e-01, 4.467683e-01, 4.467845e-01,
    4.468006e-01, 4.468168e-01, 4.468329e-01, 4.468490e-01, 4.468652e-01, 4.468814e-01,
    4.468975e-01, 4.469137e-01, 4.469298e-01, 4.469460e-01, 4.469621e-01, 4.469783e-01,
    4.469944e-01, 4.470105e-01, 4.470267e-01, 4.470429e-01, 4.470590e-01, 4.470751e-01,
    4.470913e-01, 4.471075e-01, 4.471236e-01, 4.471398e-01, 4.471559e-01, 4.471720e-01,
    4.471882e-01, 4.472043e-01, 4.472204e-01, 4.472366e-01, 4.472528e-01, 4.472689e-01,
    4.472850e-01, 4.473012e-01, 4.473173e-01, 4.473335e-01, 4.473496e-01, 4.473658e-01,
    4.473819e-01, 4.473981e-01, 4.474142e-01, 4.474304e-01, 4.474465e-01, 4.474626e-01,
    4.474788e-01, 4.474950e-01, 4.475111e-01, 4.475272e-01, 4.475434e-01, 4.475595e-01,
    4.475757e-01, 4.475918e-01, 4.476079e-01, 4.476241e-01, 4.476402e-01, 4.476564e-01,
    4.476725e-01, 4.476886e-01, 4.477048e-01, 4.477209e-01, 4.477370e-01, 4.477532e-01,
    4.477693e-01, 4.477855e-01, 4.478016e-01, 4.478177e-01, 4.478339e-01, 4.478500e-01,
    4.478662e-01, 4.478823e-01, 4.478984e-01, 4.479146e-01, 4.479308e-01, 4.479469e-01,
    4.479630e-01, 4.479792e-01, 4.479953e-01, 4.480114e-01, 4.480276e-01, 4.480437e-01,
    4.480598e-01, 4.480760e-01, 4.480921e-01, 4.481082e-01, 4.481243e-01, 4.481405e-01,
    4.481567e-01, 4.481728e-01, 4.481889e-01, 4.482051e-01, 4.482212e-01, 4.482373e-01,
    4.482535e-01, 4.482696e-01, 4.482857e-01, 4.483019e-01, 4.483180e-01, 4.483341e-01,
    4.483503e-01, 4.483664e-01, 4.483826e-01, 4.483987e-01, 4.484148e-01, 4.484309e-01,
    4.484470e-01, 4.484632e-01, 4.484793e-01, 4.484954e-01, 4.485116e-01, 4.485277e-01,
    4.485439e-01, 4.485600e-01, 4.485761e-01, 4.485922e-01, 4.486084e-01, 4.486245e-01,
    4.486406e-01, 4.486568e-01, 4.486729e-01, 4.486890e-01, 4.487051e-01, 4.487213e-01,
    4.487374e-01, 4.487536e-01, 4.487697e-01, 4.487858e-01, 4.488019e-01, 4.488181e-01,
    4.488342e-01, 4.488503e-01, 4.488664e-01, 4.488826e-01, 4.488987e-01, 4.489148e-01,
    4.489309e-01, 4.489471e-01, 4.489632e-01, 4.489793e-01, 4.489954e-01, 4.490116e-01,
    4.490277e-01, 4.490438e-01, 4.490599e-01, 4.490761e-01, 4.490922e-01, 4.491083e-01,
    4.491244e-01, 4.491406e-01, 4.491567e-01, 4.491729e-01, 4.491890e-01, 4.492051e-01,
    4.492212e-01, 4.492373e-01, 4.492535e-01, 4.492696e-01, 4.492857e-01, 4.493018e-01,
    4.493180e-01, 4.493341e-01, 4.493502e-01, 4.493663e-01, 4.493824e-01, 4.493985e-01,
    4.494147e-01, 4.494308e-01, 4.494469e-01, 4.494630e-01, 4.494792e-01, 4.494953e-01,
    4.495114e-01, 4.495275e-01, 4.495437e-01, 4.495598e-01, 4.495759e-01, 4.495920e-01,
    4.496081e-01, 4.496243e-01, 4.496403e-01, 4.496565e-01, 4.496726e-01, 4.496887e-01,
    4.497048e-01, 4.497209e-01, 4.497371e-01, 4.497532e-01, 4.497693e-01, 4.497854e-01,
    4.498015e-01, 4.498177e-01, 4.498338e-01, 4.498499e-01, 4.498660e-01, 4.498821e-01,
    4.498982e-01, 4.499144e-01, 4.499305e-01, 4.499466e-01, 4.499627e-01, 4.499788e-01,
    4.499949e-01, 4.500110e-01, 4.500272e-01, 4.500433e-01, 4.500594e-01, 4.500755e-01,
    4.500916e-01, 4.501078e-01, 4.501239e-01, 4.501399e-01, 4.501561e-01, 4.501722e-01,
    4.501883e-01, 4.502044e-01, 4.502205e-01, 4.502366e-01, 4.502528e-01, 4.502689e-01,
    4.502850e-01, 4.503011e-01, 4.503172e-01, 4.503333e-01, 4.503494e-01, 4.503655e-01,
    4.503816e-01, 4.503978e-01, 4.504139e-01, 4.504299e-01, 4.504461e-01, 4.504622e-01,
    4.504783e-01, 4.504944e-01, 4.505105e-01, 4.505267e-01, 4.505427e-01, 4.505589e-01,
    4.505750e-01, 4.505911e-01, 4.506072e-01, 4.506233e-01, 4.506394e-01, 4.506555e-01,
    4.506716e-01, 4.506877e-01, 4.507038e-01, 4.507199e-01, 4.507360e-01, 4.507522e-01,
    4.507682e-01, 4.507844e-01, 4.508004e-01, 4.508166e-01, 4.508327e-01, 4.508488e-01,
    4.508649e-01, 4.508810e-01, 4.508971e-01, 4.509132e-01, 4.509293e-01, 4.509454e-01,
    4.509615e-01, 4.509776e-01, 4.509937e-01, 4.510098e-01, 4.510259e-01, 4.510421e-01,
    4.510581e-01, 4.510742e-01, 4.510903e-01, 4.511065e-01, 4.511225e-01, 4.511386e-01,
    4.511547e-01, 4.511709e-01, 4.511869e-01, 4.512030e-01, 4.512191e-01, 4.512353e-01,
    4.512514e-01, 4.512675e-01, 4.512835e-01, 4.512997e-01, 4.513158e-01, 4.513319e-01,
    4.513479e-01, 4.513641e-01, 4.513802e-01, 4.513963e-01, 4.514123e-01, 4.514284e-01,
    4.514446e-01, 4.514607e-01, 4.514768e-01, 4.514928e-01, 4.515090e-01, 4.515251e-01,
    4.515411e-01, 4.515572e-01, 4.515733e-01, 4.515895e-01, 4.516056e-01, 4.516216e-01,
    4.516377e-01, 4.516538e-01, 4.516700e-01, 4.516860e-01, 4.517021e-01, 4.517182e-01,
    4.517343e-01, 4.517504e-01, 4.517665e-01, 4.517826e-01, 4.517987e-01, 4.518148e-01,
    4.518309e-01, 4.518470e-01, 4.518631e-01, 4.518792e-01, 4.518952e-01, 4.519114e-01,
    4.519275e-01, 4.519435e-01, 4.519597e-01, 4.519757e-01, 4.519918e-01, 4.520079e-01,
    4.520240e-01, 4.520401e-01, 4.520562e-01, 4.520723e-01, 4.520884e-01, 4.521045e-01,
    4.521205e-01, 4.521367e-01, 4.521528e-01, 4.521688e-01, 4.521849e-01, 4.522010e-01,
    4.522171e-01, 4.522332e-01, 4.522493e-01, 4.522654e-01, 4.522815e-01, 4.522976e-01,
    4.523136e-01, 4.523297e-01, 4.523458e-01, 4.523619e-01, 4.523780e-01, 4.523941e-01,
    4.524102e-01, 4.524263e-01, 4.524424e-01, 4.524584e-01, 4.524745e-01, 4.524906e-01,
    4.525067e-01, 4.525228e-01, 4.525389e-01, 4.525550e-01, 4.525711e-01, 4.525871e-01,
    4.526032e-01, 4.526193e-01, 4.526354e-01, 4.526515e-01, 4.526676e-01, 4.526837e-01,
    4.526998e-01, 4.527158e-01, 4.527319e-01, 4.527480e-01, 4.527641e-01, 4.527802e-01,
    4.527962e-01, 4.528123e-01, 4.528284e-01, 4.528445e-01, 4.528606e-01, 4.528767e-01,
    4.528928e-01, 4.529088e-01, 4.529249e-01, 4.529410e-01, 4.529571e-01, 4.529732e-01,
    4.529892e-01, 4.530053e-01, 4.530214e-01, 4.530375e-01, 4.530536e-01, 4.530696e-01,
    4.530857e-01, 4.531018e-01, 4.531179e-01, 4.531339e-01, 4.531500e-01, 4.531661e-01,
    4.531822e-01, 4.531983e-01, 4.532143e-01, 4.532304e-01, 4.532465e-01, 4.532626e-01,
    4.532787e-01, 4.532948e-01, 4.533108e-01, 4.533269e-01, 4.533430e-01, 4.533591e-01,
    4.533752e-01, 4.533912e-01, 4.534073e-01, 4.534234e-01, 4.534394e-01, 4.534555e-01,
    4.534716e-01, 4.534877e-01, 4.535038e-01, 4.535199e-01, 4.535359e-01, 4.535520e-01,
    4.535680e-01, 4.535841e-01, 4.536002e-01, 4.536163e-01, 4.536324e-01, 4.536484e-01,
    4.536645e-01, 4.536805e-01, 4.536966e-01, 4.537127e-01, 4.537288e-01, 4.537449e-01,
    4.537610e-01, 4.537770e-01, 4.537931e-01, 4.538092e-01, 4.538252e-01, 4.538413e-01,
    4.538574e-01, 4.538734e-01, 4.538895e-01, 4.539056e-01, 4.539217e-01, 4.539378e-01,
    4.539538e-01, 4.539699e-01, 4.539860e-01, 4.540020e-01, 4.540181e-01, 4.540341e-01,
    4.540502e-01, 4.540663e-01, 4.540823e-01, 4.540984e-01, 4.541145e-01, 4.541306e-01,
    4.541466e-01, 4.541627e-01, 4.541788e-01, 4.541949e-01, 4.542109e-01, 4.542270e-01,
    4.542431e-01, 4.542591e-01, 4.542752e-01, 4.542913e-01, 4.543073e-01, 4.543234e-01,
    4.543395e-01, 4.543555e-01, 4.543716e-01, 4.543877e-01, 4.544038e-01, 4.544198e-01,
    4.544359e-01, 4.544519e-01, 4.544680e-01, 4.544841e-01, 4.545001e-01, 4.545162e-01,
    4.545323e-01, 4.545483e-01, 4.545644e-01, 4.545805e-01, 4.545965e-01, 4.546126e-01,
    4.546286e-01, 4.546447e-01, 4.546608e-01, 4.546768e-01, 4.546929e-01, 4.547089e-01,
    4.547250e-01, 4.547411e-01, 4.547571e-01, 4.547732e-01, 4.547893e-01, 4.548053e-01,
    4.548213e-01, 4.548374e-01, 4.548535e-01, 4.548696e-01, 4.548856e-01, 4.549017e-01,
    4.549178e-01, 4.549338e-01, 4.549499e-01, 4.549659e-01, 4.549820e-01, 4.549980e-01,
    4.550141e-01, 4.550301e-01, 4.550462e-01, 4.550623e-01, 4.550783e-01, 4.550944e-01,
    4.551105e-01, 4.551265e-01, 4.551426e-01, 4.551586e-01, 4.551747e-01, 4.551907e-01,
    4.552068e-01, 4.552228e-01, 4.552389e-01, 4.552550e-01, 4.552710e-01, 4.552871e-01,
    4.553031e-01, 4.553192e-01, 4.553353e-01, 4.553513e-01, 4.553674e-01, 4.553834e-01,
    4.553995e-01, 4.554155e-01, 4.554316e-01, 4.554476e-01, 4.554637e-01, 4.554797e-01,
    4.554958e-01, 4.555118e-01, 4.555279e-01, 4.555439e-01, 4.555600e-01, 4.555761e-01,
    4.555921e-01, 4.556082e-01, 4.556242e-01, 4.556403e-01, 4.556563e-01, 4.556724e-01,
    4.556884e-01, 4.557045e-01, 4.557205e-01, 4.557366e-01, 4.557526e-01, 4.557687e-01,
    4.557847e-01, 4.558008e-01, 4.558168e-01, 4.558329e-01, 4.558489e-01, 4.558650e-01,
    4.558810e-01, 4.558971e-01, 4.559132e-01, 4.559292e-01, 4.559452e-01, 4.559613e-01,
    4.559774e-01, 4.559934e-01, 4.560094e-01, 4.560255e-01, 4.560415e-01, 4.560576e-01,
    4.560736e-01, 4.560896e-01, 4.561057e-01, 4.561218e-01, 4.561378e-01, 4.561538e-01,
    4.561699e-01, 4.561860e-01, 4.562020e-01, 4.562180e-01, 4.562341e-01, 4.562501e-01,
    4.562662e-01, 4.562822e-01, 4.562983e-01, 4.563143e-01, 4.563303e-01, 4.563464e-01,
    4.563625e-01, 4.563785e-01, 4.563945e-01, 4.564106e-01, 4.564266e-01, 4.564427e-01,
    4.564587e-01, 4.564748e-01, 4.564908e-01, 4.565068e-01, 4.565229e-01, 4.565389e-01,
    4.565549e-01, 4.565710e-01, 4.565870e-01, 4.566031e-01, 4.566191e-01, 4.566352e-01,
    4.566512e-01, 4.566672e-01, 4.566833e-01, 4.566993e-01, 4.567154e-01, 4.567314e-01,
    4.567474e-01, 4.567635e-01, 4.567795e-01, 4.567955e-01, 4.568116e-01, 4.568276e-01,
    4.568437e-01, 4.568597e-01, 4.568757e-01, 4.568918e-01, 4.569078e-01, 4.569238e-01,
    4.569399e-01, 4.569560e-01, 4.569720e-01, 4.569880e-01, 4.570040e-01, 4.570201e-01,
    4.570361e-01, 4.570521e-01, 4.570682e-01, 4.570842e-01, 4.571003e-01, 4.571163e-01,
    4.571323e-01, 4.571484e-01, 4.571644e-01, 4.571804e-01, 4.571965e-01, 4.572125e-01,
    4.572286e-01, 4.572446e-01, 4.572606e-01, 4.572767e-01, 4.572927e-01, 4.573087e-01,
    4.573247e-01, 4.573408e-01, 4.573568e-01, 4.573728e-01, 4.573889e-01, 4.574049e-01,
    4.574210e-01, 4.574370e-01, 4.574530e-01, 4.574690e-01, 4.574851e-01, 4.575011e-01,
    4.575171e-01, 4.575332e-01, 4.575492e-01, 4.575652e-01, 4.575813e-01, 4.575973e-01,
    4.576133e-01, 4.576294e-01, 4.576454e-01, 4.576614e-01, 4.576774e-01, 4.576935e-01,
    4.577095e-01, 4.577256e-01, 4.577416e-01, 4.577576e-01, 4.577736e-01, 4.577897e-01,
    4.578057e-01, 4.578217e-01, 4.578377e-01, 4.578538e-01, 4.578698e-01, 4.578858e-01,
    4.579018e-01, 4.579179e-01, 4.579339e-01, 4.579499e-01, 4.579659e-01, 4.579820e-01,
    4.579980e-01, 4.580140e-01, 4.580300e-01, 4.580461e-01, 4.580621e-01, 4.580781e-01,
    4.580941e-01, 4.581102e-01, 4.581262e-01, 4.581422e-01, 4.581583e-01, 4.581743e-01,
    4.581903e-01, 4.582063e-01, 4.582224e-01, 4.582384e-01, 4.582544e-01, 4.582704e-01,
    4.582864e-01, 4.583025e-01, 4.583185e-01, 4.583345e-01, 4.583505e-01, 4.583666e-01,
    4.583826e-01, 4.583986e-01, 4.584146e-01, 4.584306e-01, 4.584467e-01, 4.584627e-01,
    4.584787e-01, 4.584948e-01, 4.585107e-01, 4.585268e-01, 4.585428e-01, 4.585588e-01,
    4.585748e-01, 4.585908e-01, 4.586069e-01, 4.586229e-01, 4.586389e-01, 4.586549e-01,
    4.586709e-01, 4.586870e-01, 4.587030e-01, 4.587190e-01, 4.587350e-01, 4.587510e-01,
    4.587670e-01, 4.587831e-01, 4.587991e-01, 4.588151e-01, 4.588311e-01, 4.588471e-01,
    4.588632e-01, 4.588792e-01, 4.588952e-01, 4.589112e-01, 4.589272e-01, 4.589432e-01,
    4.589593e-01, 4.589753e-01, 4.589913e-01, 4.590073e-01, 4.590233e-01, 4.590393e-01,
    4.590553e-01, 4.590714e-01, 4.590873e-01, 4.591034e-01, 4.591194e-01, 4.591354e-01,
    4.591514e-01, 4.591675e-01, 4.591835e-01, 4.591994e-01, 4.592155e-01, 4.592315e-01,
    4.592475e-01, 4.592635e-01, 4.592795e-01, 4.592955e-01, 4.593115e-01, 4.593276e-01,
    4.593436e-01, 4.593596e-01, 4.593756e-01, 4.593916e-01, 4.594076e-01, 4.594236e-01,
    4.594396e-01, 4.594556e-01, 4.594716e-01, 4.594876e-01, 4.595037e-01, 4.595197e-01,
    4.595357e-01, 4.595517e-01, 4.595677e-01, 4.595837e-01, 4.595997e-01, 4.596157e-01,
    4.596317e-01, 4.596477e-01, 4.596637e-01, 4.596798e-01, 4.596958e-01, 4.597118e-01,
    4.597278e-01, 4.597438e-01, 4.597598e-01, 4.597758e-01, 4.597918e-01, 4.598078e-01,
    4.598238e-01, 4.598398e-01, 4.598558e-01, 4.598719e-01, 4.598878e-01, 4.599038e-01,
    4.599198e-01, 4.599358e-01, 4.599518e-01, 4.599679e-01, 4.599839e-01, 4.599999e-01,
    4.600159e-01, 4.600319e-01, 4.600479e-01, 4.600639e-01, 4.600798e-01, 4.600959e-01,
    4.601119e-01, 4.601279e-01, 4.601439e-01, 4.601599e-01, 4.601759e-01, 4.601919e-01,
    4.602079e-01, 4.602239e-01, 4.602399e-01, 4.602559e-01, 4.602719e-01, 4.602879e-01,
    4.603039e-01, 4.603199e-01, 4.603359e-01, 4.603519e-01, 4.603679e-01, 4.603839e-01,
    4.603999e-01, 4.604159e-01, 4.604319e-01, 4.604479e-01, 4.604639e-01, 4.604799e-01,
    4.604959e-01, 4.605119e-01, 4.605279e-01, 4.605439e-01, 4.605599e-01, 4.605759e-01,
    4.605919e-01, 4.606079e-01, 4.606239e-01, 4.606399e-01, 4.606559e-01, 4.606719e-01,
    4.606879e-01, 4.607038e-01, 4.607199e-01, 4.607359e-01, 4.607518e-01, 4.607678e-01,
    4.607838e-01, 4.607998e-01, 4.608158e-01, 4.608318e-01, 4.608478e-01, 4.608638e-01,
    4.608798e-01, 4.608958e-01, 4.609118e-01, 4.609278e-01, 4.609438e-01, 4.609598e-01,
    4.609758e-01, 4.609918e-01, 4.610077e-01, 4.610237e-01, 4.610398e-01, 4.610557e-01,
    4.610717e-01, 4.610877e-01, 4.611037e-01, 4.611197e-01, 4.611357e-01, 4.611517e-01,
    4.611677e-01, 4.611836e-01, 4.611996e-01, 4.612156e-01, 4.612316e-01, 4.612476e-01,
    4.612636e-01, 4.612796e-01, 4.612956e-01, 4.613115e-01, 4.613276e-01, 4.613436e-01,
    4.613595e-01, 4.613755e-01, 4.613915e-01, 4.614075e-01, 4.614235e-01, 4.614395e-01,
    4.614555e-01, 4.614715e-01, 4.614874e-01, 4.615034e-01, 4.615194e-01, 4.615354e-01,
    4.615514e-01, 4.615674e-01, 4.615834e-01, 4.615993e-01, 4.616153e-01, 4.616313e-01,
    4.616473e-01, 4.616633e-01, 4.616793e-01, 4.616953e-01, 4.617113e-01, 4.617272e-01,
    4.617432e-01, 4.617592e-01, 4.617752e-01, 4.617912e-01, 4.618072e-01, 4.618231e-01,
    4.618391e-01, 4.618551e-01, 4.618711e-01, 4.618871e-01, 4.619030e-01, 4.619190e-01,
    4.619350e-01, 4.619510e-01, 4.619670e-01, 4.619830e-01, 4.619989e-01, 4.620149e-01,
    4.620309e-01, 4.620469e-01, 4.620629e-01, 4.620789e-01, 4.620948e-01, 4.621108e-01,
    4.621268e-01, 4.621427e-01, 4.621587e-01, 4.621747e-01, 4.621907e-01, 4.622067e-01,
    4.622227e-01, 4.622386e-01, 4.622546e-01, 4.622706e-01, 4.622866e-01, 4.623026e-01,
    4.623185e-01, 4.623345e-01, 4.623505e-01, 4.623665e-01, 4.623824e-01, 4.623984e-01,
    4.624144e-01, 4.624304e-01, 4.624463e-01, 4.624623e-01, 4.624783e-01, 4.624943e-01,
    4.625103e-01, 4.625262e-01, 4.625422e-01, 4.625582e-01, 4.625742e-01, 4.625901e-01,
    4.626061e-01, 4.626221e-01, 4.626381e-01, 4.626541e-01, 4.626700e-01, 4.626860e-01,
    4.627019e-01, 4.627180e-01, 4.627339e-01, 4.627499e-01, 4.627658e-01, 4.627818e-01,
    4.627978e-01, 4.628138e-01, 4.628297e-01, 4.628457e-01, 4.628617e-01, 4.628777e-01,
    4.628936e-01, 4.629096e-01, 4.629256e-01, 4.629415e-01, 4.629575e-01, 4.629735e-01,
    4.629894e-01, 4.630054e-01, 4.630214e-01, 4.630374e-01, 4.630533e-01, 4.630693e-01,
    4.630853e-01, 4.631012e-01, 4.631172e-01, 4.631332e-01, 4.631492e-01, 4.631651e-01,
    4.631811e-01, 4.631971e-01, 4.632130e-01, 4.632290e-01, 4.632449e-01, 4.632609e-01,
    4.632769e-01, 4.632929e-01, 4.633088e-01, 4.633248e-01, 4.633408e-01, 4.633567e-01,
    4.633727e-01, 4.633887e-01, 4.634046e-01, 4.634206e-01, 4.634366e-01, 4.634525e-01,
    4.634685e-01, 4.634845e-01, 4.635004e-01, 4.635164e-01, 4.635324e-01, 4.635483e-01,
    4.635643e-01, 4.635803e-01, 4.635962e-01, 4.636122e-01, 4.636281e-01, 4.636441e-01,
    4.636601e-01, 4.636760e-01, 4.636920e-01, 4.637080e-01, 4.637239e-01, 4.637399e-01,
    4.637558e-01, 4.637718e-01, 4.637878e-01, 4.638037e-01, 4.638197e-01, 4.638357e-01,
    4.638516e-01, 4.638676e-01, 4.638835e-01, 4.638995e-01, 4.639155e-01, 4.639314e-01,
    4.639474e-01, 4.639633e-01, 4.639793e-01, 4.639952e-01, 4.640112e-01, 4.640272e-01,
    4.640431e-01, 4.640591e-01, 4.640751e-01, 4.640910e-01, 4.641070e-01, 4.641229e-01,
    4.641389e-01, 4.641549e-01, 4.641708e-01, 4.641868e-01, 4.642027e-01, 4.642187e-01,
    4.642346e-01, 4.642506e-01, 4.642665e-01, 4.642825e-01, 4.642985e-01, 4.643144e-01,
    4.643304e-01, 4.643463e-01, 4.643623e-01, 4.643782e-01, 4.643942e-01, 4.644101e-01,
    4.644261e-01, 4.644420e-01, 4.644580e-01, 4.644740e-01, 4.644899e-01, 4.645059e-01,
    4.645218e-01, 4.645378e-01, 4.645537e-01, 4.645697e-01, 4.645856e-01, 4.646016e-01,
    4.646176e-01, 4.646335e-01, 4.646494e-01, 4.646654e-01, 4.646813e-01, 4.646973e-01,
    4.647132e-01, 4.647292e-01, 4.647451e-01, 4.647611e-01, 4.647771e-01, 4.647930e-01,
    4.648089e-01, 4.648249e-01, 4.648409e-01, 4.648568e-01, 4.648727e-01, 4.648887e-01,
    4.649047e-01, 4.649206e-01, 4.649366e-01, 4.649525e-01, 4.649685e-01, 4.649844e-01,
    4.650004e-01, 4.650163e-01, 4.650322e-01, 4.650482e-01, 4.650641e-01, 4.650801e-01,
    4.650960e-01, 4.651120e-01, 4.651279e-01, 4.651439e-01, 4.651598e-01, 4.651757e-01,
    4.651917e-01, 4.652077e-01, 4.652236e-01, 4.652396e-01, 4.652555e-01, 4.652714e-01,
    4.652874e-01, 4.653033e-01, 4.653193e-01, 4.653352e-01, 4.653512e-01, 4.653671e-01,
    4.653831e-01, 4.653990e-01, 4.654149e-01, 4.654309e-01, 4.654468e-01, 4.654628e-01,
    4.654787e-01, 4.654947e-01, 4.655106e-01, 4.655266e-01, 4.655425e-01, 4.655584e-01,
    4.655744e-01, 4.655903e-01, 4.656063e-01, 4.656222e-01, 4.656381e-01, 4.656541e-01,
    4.656700e-01, 4.656860e-01, 4.657019e-01, 4.657179e-01, 4.657338e-01, 4.657497e-01,
    4.657657e-01, 4.657816e-01, 4.657975e-01, 4.658135e-01, 4.658294e-01, 4.658454e-01,
    4.658613e-01, 4.658772e-01, 4.658932e-01, 4.659091e-01, 4.659250e-01, 4.659410e-01,
    4.659569e-01, 4.659729e-01, 4.659888e-01, 4.660048e-01, 4.660207e-01, 4.660366e-01,
    4.660526e-01, 4.660685e-01, 4.660844e-01, 4.661004e-01, 4.661163e-01, 4.661322e-01,
    4.661482e-01, 4.661641e-01, 4.661801e-01, 4.661960e-01, 4.662119e-01, 4.662279e-01,
    4.662438e-01, 4.662597e-01, 4.662757e-01, 4.662916e-01, 4.663075e-01, 4.663235e-01,
    4.663394e-01, 4.663553e-01, 4.663712e-01, 4.663872e-01, 4.664031e-01, 4.664190e-01,
    4.664350e-01, 4.664509e-01, 4.664669e-01, 4.664828e-01, 4.664987e-01, 4.665146e-01,
    4.665306e-01, 4.665465e-01, 4.665624e-01, 4.665784e-01, 4.665943e-01, 4.666102e-01,
    4.666262e-01, 4.666421e-01, 4.666580e-01, 4.666739e-01, 4.666899e-01, 4.667058e-01,
    4.667217e-01, 4.667377e-01, 4.667536e-01, 4.667695e-01, 4.667855e-01, 4.668014e-01,
    4.668173e-01, 4.668332e-01, 4.668492e-01, 4.668651e-01, 4.668810e-01, 4.668970e-01,
    4.669129e-01, 4.669288e-01, 4.669447e-01, 4.669607e-01, 4.669766e-01, 4.669925e-01,
    4.670084e-01, 4.670244e-01, 4.670403e-01, 4.670562e-01, 4.670722e-01, 4.670881e-01,
    4.671040e-01, 4.671199e-01, 4.671358e-01, 4.671518e-01, 4.671677e-01, 4.671836e-01,
    4.671996e-01, 4.672154e-01, 4.672314e-01, 4.672473e-01, 4.672632e-01, 4.672791e-01,
    4.672951e-01, 4.673110e-01, 4.673269e-01, 4.673429e-01, 4.673588e-01, 4.673747e-01,
    4.673906e-01, 4.674065e-01, 4.674225e-01, 4.674384e-01, 4.674543e-01, 4.674702e-01,
    4.674862e-01, 4.675021e-01, 4.675180e-01, 4.675339e-01, 4.675498e-01, 4.675657e-01,
    4.675817e-01, 4.675976e-01, 4.676135e-01, 4.676294e-01, 4.676453e-01, 4.676613e-01,
    4.676772e-01, 4.676931e-01, 4.677090e-01, 4.677249e-01, 4.677409e-01, 4.677568e-01,
    4.677727e-01, 4.677886e-01, 4.678046e-01, 4.678205e-01, 4.678364e-01, 4.678523e-01,
    4.678682e-01, 4.678841e-01, 4.679000e-01, 4.679160e-01, 4.679319e-01, 4.679478e-01,
    4.679637e-01, 4.679796e-01, 4.679955e-01, 4.680114e-01, 4.680274e-01, 4.680433e-01,
    4.680592e-01, 4.680751e-01, 4.680910e-01, 4.681069e-01, 4.681228e-01, 4.681388e-01,
    4.681547e-01, 4.681706e-01, 4.681865e-01, 4.682024e-01, 4.682183e-01, 4.682342e-01,
    4.682502e-01, 4.682661e-01, 4.682820e-01, 4.682979e-01, 4.683138e-01, 4.683297e-01,
    4.683456e-01, 4.683615e-01, 4.683774e-01, 4.683934e-01, 4.684093e-01, 4.684252e-01,
    4.684411e-01, 4.684570e-01, 4.684729e-01, 4.684888e-01, 4.685047e-01, 4.685206e-01,
    4.685366e-01, 4.685525e-01, 4.685684e-01, 4.685843e-01, 4.686002e-01, 4.686161e-01,
    4.686320e-01, 4.686479e-01, 4.686638e-01, 4.686797e-01, 4.686956e-01, 4.687116e-01,
    4.687274e-01, 4.687434e-01, 4.687593e-01, 4.687752e-01, 4.687911e-01, 4.688070e-01,
    4.688229e-01, 4.688388e-01, 4.688547e-01, 4.688706e-01, 4.688865e-01, 4.689024e-01,
    4.689183e-01, 4.689342e-01, 4.689501e-01, 4.689660e-01, 4.689820e-01, 4.689978e-01,
    4.690138e-01, 4.690297e-01, 4.690455e-01, 4.690614e-01, 4.690773e-01, 4.690933e-01,
    4.691092e-01, 4.691251e-01, 4.691410e-01, 4.691569e-01, 4.691727e-01, 4.691887e-01,
    4.692046e-01, 4.692205e-01, 4.692364e-01, 4.692523e-01, 4.692682e-01, 4.692841e-01,
    4.693000e-01, 4.693159e-01, 4.693318e-01, 4.693477e-01, 4.693636e-01, 4.693795e-01,
    4.693954e-01, 4.694113e-01, 4.694272e-01, 4.694431e-01, 4.694590e-01, 4.694749e-01,
    4.694908e-01, 4.695067e-01, 4.695226e-01, 4.695385e-01, 4.695544e-01, 4.695703e-01,
    4.695862e-01, 4.696021e-01, 4.696180e-01, 4.696339e-01, 4.696498e-01, 4.696656e-01,
    4.696816e-01, 4.696975e-01, 4.697133e-01, 4.697292e-01, 4.697452e-01, 4.697610e-01,
    4.697769e-01, 4.697928e-01, 4.698088e-01, 4.698246e-01, 4.698405e-01, 4.698564e-01,
    4.698723e-01, 4.698882e-01, 4.699041e-01, 4.699200e-01, 4.699359e-01, 4.699518e-01,
    4.699677e-01, 4.699836e-01, 4.699995e-01, 4.700153e-01, 4.700313e-01, 4.700471e-01,
    4.700630e-01, 4.700789e-01, 4.700948e-01, 4.701107e-01, 4.701266e-01, 4.701425e-01,
    4.701584e-01, 4.701743e-01, 4.701902e-01, 4.702061e-01, 4.702219e-01, 4.702379e-01,
    4.702537e-01, 4.702696e-01, 4.702855e-01, 4.703014e-01, 4.703173e-01, 4.703332e-01,
    4.703491e-01, 4.703649e-01, 4.703808e-01, 4.703967e-01, 4.704126e-01, 4.704285e-01,
    4.704444e-01, 4.704603e-01, 4.704762e-01, 4.704921e-01, 4.705079e-01, 4.705239e-01,
    4.705397e-01, 4.705556e-01, 4.705715e-01, 4.705874e-01, 4.706033e-01, 4.706192e-01,
    4.706350e-01, 4.706509e-01, 4.706668e-01, 4.706827e-01, 4.706986e-01, 4.707145e-01,
    4.707304e-01, 4.707462e-01, 4.707621e-01, 4.707780e-01, 4.707939e-01, 4.708098e-01,
    4.708257e-01, 4.708416e-01, 4.708574e-01, 4.708733e-01, 4.708892e-01, 4.709051e-01,
    4.709210e-01, 4.709369e-01, 4.709527e-01, 4.709686e-01, 4.709845e-01, 4.710004e-01,
    4.710163e-01, 4.710321e-01, 4.710480e-01, 4.710639e-01, 4.710798e-01, 4.710957e-01,
    4.711116e-01, 4.711274e-01, 4.711433e-01, 4.711592e-01, 4.711751e-01, 4.711910e-01,
    4.712068e-01, 4.712227e-01, 4.712386e-01, 4.712545e-01, 4.712704e-01, 4.712862e-01,
    4.713021e-01, 4.713180e-01, 4.713338e-01, 4.713497e-01, 4.713656e-01, 4.713815e-01,
    4.713974e-01, 4.714133e-01, 4.714291e-01, 4.714450e-01, 4.714609e-01, 4.714768e-01,
    4.714926e-01, 4.715085e-01, 4.715244e-01, 4.715403e-01, 4.715561e-01, 4.715720e-01,
    4.715879e-01, 4.716038e-01, 4.716196e-01, 4.716356e-01, 4.716514e-01, 4.716673e-01,
    4.716831e-01, 4.716990e-01, 4.717149e-01, 4.717308e-01, 4.717467e-01, 4.717625e-01,
    4.717784e-01, 4.717943e-01, 4.718102e-01, 4.718260e-01, 4.718419e-01, 4.718578e-01,
    4.718736e-01, 4.718895e-01, 4.719054e-01, 4.719213e-01, 4.719371e-01, 4.719530e-01,
    4.719689e-01, 4.719847e-01, 4.720006e-01, 4.720165e-01, 4.720324e-01, 4.720482e-01,
    4.720641e-01, 4.720800e-01, 4.720958e-01, 4.721117e-01, 4.721276e-01, 4.721434e-01,
    4.721593e-01, 4.721752e-01, 4.721910e-01, 4.722069e-01, 4.722228e-01, 4.722387e-01,
    4.722545e-01, 4.722704e-01, 4.722863e-01, 4.723021e-01, 4.723180e-01, 4.723339e-01,
    4.723497e-01, 4.723656e-01, 4.723815e-01, 4.723974e-01, 4.724132e-01, 4.724291e-01,
    4.724450e-01, 4.724608e-01, 4.724767e-01, 4.724925e-01, 4.725084e-01, 4.725243e-01,
    4.725401e-01, 4.725560e-01, 4.725718e-01, 4.725877e-01, 4.726036e-01, 4.726195e-01,
    4.726353e-01, 4.726512e-01, 4.726671e-01, 4.726829e-01, 4.726988e-01, 4.727147e-01,
    4.727305e-01, 4.727463e-01, 4.727622e-01, 4.727781e-01, 4.727939e-01, 4.728098e-01,
    4.728257e-01, 4.728415e-01, 4.728574e-01, 4.728733e-01, 4.728891e-01, 4.729050e-01,
    4.729209e-01, 4.729367e-01, 4.729525e-01, 4.729684e-01, 4.729843e-01, 4.730001e-01,
    4.730160e-01, 4.730319e-01, 4.730477e-01, 4.730636e-01, 4.730794e-01, 4.730953e-01,
    4.731112e-01, 4.731270e-01, 4.731429e-01, 4.731587e-01, 4.731746e-01, 4.731904e-01,
    4.732063e-01, 4.732222e-01, 4.732381e-01, 4.732539e-01, 4.732697e-01, 4.732856e-01,
    4.733015e-01, 4.733173e-01, 4.733332e-01, 4.733490e-01, 4.733649e-01, 4.733807e-01,
    4.733966e-01, 4.734124e-01, 4.734283e-01, 4.734442e-01, 4.734600e-01, 4.734759e-01,
    4.734917e-01, 4.735076e-01, 4.735234e-01, 4.735393e-01, 4.735551e-01, 4.735710e-01,
    4.735869e-01, 4.736027e-01, 4.736185e-01, 4.736344e-01, 4.736503e-01, 4.736661e-01,
    4.736820e-01, 4.736978e-01, 4.737137e-01, 4.737295e-01, 4.737454e-01, 4.737613e-01,
    4.737771e-01, 4.737929e-01, 4.738088e-01, 4.738246e-01, 4.738405e-01, 4.738564e-01,
    4.738722e-01, 4.738880e-01, 4.739039e-01, 4.739197e-01, 4.739356e-01, 4.739514e-01,
    4.739673e-01, 4.739831e-01, 4.739990e-01, 4.740148e-01, 4.740307e-01, 4.740465e-01,
    4.740624e-01, 4.740782e-01, 4.740941e-01, 4.741099e-01, 4.741258e-01, 4.741416e-01,
    4.741575e-01, 4.741733e-01, 4.741891e-01, 4.742050e-01, 4.742209e-01, 4.742367e-01,
    4.742526e-01, 4.742684e-01, 4.742843e-01, 4.743001e-01, 4.743159e-01, 4.743318e-01,
    4.743476e-01, 4.743635e-01, 4.743793e-01, 4.743952e-01, 4.744110e-01, 4.744269e-01,
    4.744427e-01, 4.744585e-01, 4.744744e-01, 4.744903e-01, 4.745061e-01, 4.745219e-01,
    4.745378e-01, 4.745536e-01, 4.745694e-01, 4.745853e-01, 4.746011e-01, 4.746170e-01,
    4.746328e-01, 4.746486e-01, 4.746645e-01, 4.746803e-01, 4.746962e-01, 4.747120e-01,
    4.747279e-01, 4.747437e-01, 4.747596e-01, 4.747754e-01, 4.747912e-01, 4.748071e-01,
    4.748229e-01, 4.748388e-01, 4.748546e-01, 4.748704e-01, 4.748863e-01, 4.749021e-01,
    4.749180e-01, 4.749338e-01, 4.749496e-01, 4.749655e-01, 4.749813e-01, 4.749971e-01,
    4.750130e-01, 4.750288e-01, 4.750447e-01, 4.750605e-01, 4.750763e-01, 4.750922e-01,
    4.751080e-01, 4.751238e-01, 4.751397e-01, 4.751555e-01, 4.751713e-01, 4.751872e-01,
    4.752030e-01, 4.752189e-01, 4.752347e-01, 4.752505e-01, 4.752664e-01, 4.752822e-01,
    4.752980e-01, 4.753139e-01, 4.753297e-01, 4.753456e-01, 4.753614e-01, 4.753772e-01,
    4.753930e-01, 4.754089e-01, 4.754247e-01, 4.754405e-01, 4.754564e-01, 4.754722e-01,
    4.754880e-01, 4.755039e-01, 4.755197e-01, 4.755355e-01, 4.755514e-01, 4.755672e-01,
    4.755830e-01, 4.755989e-01, 4.756147e-01, 4.756305e-01, 4.756463e-01, 4.756622e-01,
    4.756781e-01, 4.756939e-01, 4.757097e-01, 4.757255e-01, 4.757413e-01, 4.757572e-01,
    4.757730e-01, 4.757888e-01, 4.758047e-01, 4.758205e-01, 4.758363e-01, 4.758521e-01,
    4.758680e-01, 4.758838e-01, 4.758996e-01, 4.759155e-01, 4.759313e-01, 4.759471e-01,
    4.759629e-01, 4.759788e-01, 4.759946e-01, 4.760104e-01, 4.760263e-01, 4.760421e-01,
    4.760579e-01, 4.760737e-01, 4.760896e-01, 4.761054e-01, 4.761212e-01, 4.761370e-01,
    4.761529e-01, 4.761687e-01, 4.761845e-01, 4.762003e-01, 4.762162e-01, 4.762320e-01,
    4.762478e-01, 4.762636e-01, 4.762795e-01, 4.762953e-01, 4.763111e-01, 4.763269e-01,
    4.763428e-01, 4.763586e-01, 4.763744e-01, 4.763902e-01, 4.764060e-01, 4.764219e-01,
    4.764377e-01, 4.764535e-01, 4.764693e-01, 4.764852e-01, 4.765010e-01, 4.765168e-01,
    4.765326e-01, 4.765484e-01, 4.765643e-01, 4.765801e-01, 4.765959e-01, 4.766117e-01,
    4.766276e-01, 4.766434e-01, 4.766592e-01, 4.766750e-01, 4.766909e-01, 4.767067e-01,
    4.767225e-01, 4.767383e-01, 4.767541e-01, 4.767699e-01, 4.767857e-01, 4.768016e-01,
    4.768174e-01, 4.768332e-01, 4.768490e-01, 4.768648e-01, 4.768807e-01, 4.768965e-01,
    4.769123e-01, 4.769281e-01, 4.769439e-01, 4.769597e-01, 4.769756e-01, 4.769914e-01,
    4.770072e-01, 4.770230e-01, 4.770388e-01, 4.770546e-01, 4.770705e-01, 4.770863e-01,
    4.771021e-01, 4.771179e-01, 4.771337e-01, 4.771495e-01, 4.771653e-01, 4.771812e-01,
    4.771970e-01, 4.772128e-01, 4.772286e-01, 4.772444e-01, 4.772602e-01, 4.772761e-01,
    4.772919e-01, 4.773077e-01, 4.773235e-01, 4.773393e-01, 4.773551e-01, 4.773709e-01,
    4.773867e-01, 4.774026e-01, 4.774183e-01, 4.774342e-01, 4.774500e-01, 4.774658e-01,
    4.774816e-01, 4.774974e-01, 4.775132e-01, 4.775290e-01, 4.775448e-01, 4.775606e-01,
    4.775765e-01, 4.775923e-01, 4.776081e-01, 4.776239e-01, 4.776397e-01, 4.776555e-01,
    4.776713e-01, 4.776872e-01, 4.777029e-01, 4.777187e-01, 4.777346e-01, 4.777504e-01,
    4.777662e-01, 4.777820e-01, 4.777978e-01, 4.778136e-01, 4.778294e-01, 4.778452e-01,
    4.778610e-01, 4.778768e-01, 4.778926e-01, 4.779084e-01, 4.779242e-01, 4.779401e-01,
    4.779559e-01, 4.779716e-01, 4.779875e-01, 4.780032e-01, 4.780191e-01, 4.780349e-01,
    4.780507e-01, 4.780665e-01, 4.780823e-01, 4.780981e-01, 4.781139e-01, 4.781297e-01,
    4.781455e-01, 4.781613e-01, 4.781771e-01, 4.781929e-01, 4.782087e-01, 4.782245e-01,
    4.782403e-01, 4.782561e-01, 4.782719e-01, 4.782878e-01, 4.783035e-01, 4.783193e-01,
    4.783351e-01, 4.783510e-01, 4.783667e-01, 4.783826e-01, 4.783983e-01, 4.784141e-01,
    4.784299e-01, 4.784458e-01, 4.784615e-01, 4.784774e-01, 4.784932e-01, 4.785089e-01,
    4.785247e-01, 4.785406e-01, 4.785563e-01, 4.785721e-01, 4.785880e-01, 4.786037e-01,
    4.786195e-01, 4.786353e-01, 4.786511e-01, 4.786669e-01, 4.786828e-01, 4.786985e-01,
    4.787143e-01, 4.787301e-01, 4.787459e-01, 4.787617e-01, 4.787775e-01, 4.787933e-01,
    4.788091e-01, 4.788249e-01, 4.788407e-01, 4.788565e-01, 4.788723e-01, 4.788881e-01,
    4.789039e-01, 4.789197e-01, 4.789355e-01, 4.789512e-01, 4.789671e-01, 4.789829e-01,
    4.789986e-01, 4.790145e-01, 4.790303e-01, 4.790460e-01, 4.790618e-01, 4.790776e-01,
    4.790934e-01, 4.791092e-01, 4.791250e-01, 4.791408e-01, 4.791566e-01, 4.791724e-01,
    4.791882e-01, 4.792040e-01, 4.792198e-01, 4.792356e-01, 4.792513e-01, 4.792672e-01,
    4.792829e-01, 4.792987e-01, 4.793145e-01, 4.793303e-01, 4.793461e-01, 4.793619e-01,
    4.793777e-01, 4.793935e-01, 4.794092e-01, 4.794250e-01, 4.794408e-01, 4.794566e-01,
    4.794724e-01, 4.794882e-01, 4.795040e-01, 4.795198e-01, 4.795356e-01, 4.795513e-01,
    4.795671e-01, 4.795829e-01, 4.795987e-01, 4.796145e-01, 4.796303e-01, 4.796461e-01,
    4.796619e-01, 4.796777e-01, 4.796934e-01, 4.797092e-01, 4.797250e-01, 4.797408e-01,
    4.797566e-01, 4.797724e-01, 4.797882e-01, 4.798039e-01, 4.798197e-01, 4.798355e-01,
    4.798513e-01, 4.798671e-01, 4.798828e-01, 4.798987e-01, 4.799145e-01, 4.799302e-01,
    4.799460e-01, 4.799618e-01, 4.799776e-01, 4.799933e-01, 4.800091e-01, 4.800249e-01,
    4.800407e-01, 4.800565e-01, 4.800723e-01, 4.800881e-01, 4.801039e-01, 4.801196e-01,
    4.801354e-01, 4.801512e-01, 4.801670e-01, 4.801827e-01, 4.801985e-01, 4.802143e-01,
    4.802301e-01, 4.802459e-01, 4.802616e-01, 4.802774e-01, 4.802932e-01, 4.803090e-01,
    4.803247e-01, 4.803405e-01, 4.803563e-01, 4.803721e-01, 4.803879e-01, 4.804037e-01,
    4.804194e-01, 4.804352e-01, 4.804510e-01, 4.804668e-01, 4.804825e-01, 4.804983e-01,
    4.805141e-01, 4.805299e-01, 4.805457e-01, 4.805614e-01, 4.805772e-01, 4.805930e-01,
    4.806088e-01, 4.806246e-01, 4.806404e-01, 4.806561e-01, 4.806719e-01, 4.806877e-01,
    4.807034e-01, 4.807192e-01, 4.807350e-01, 4.807508e-01, 4.807665e-01, 4.807823e-01,
    4.807981e-01, 4.808139e-01, 4.808297e-01, 4.808454e-01, 4.808612e-01, 4.808770e-01,
    4.808927e-01, 4.809085e-01, 4.809243e-01, 4.809401e-01, 4.809558e-01, 4.809716e-01,
    4.809874e-01, 4.810031e-01, 4.810189e-01, 4.810347e-01, 4.810505e-01, 4.810662e-01,
    4.810820e-01, 4.810978e-01, 4.811136e-01, 4.811293e-01, 4.811451e-01, 4.811608e-01,
    4.811766e-01, 4.811924e-01, 4.812082e-01, 4.812239e-01, 4.812397e-01, 4.812555e-01,
    4.812713e-01, 4.812870e-01, 4.813028e-01, 4.813186e-01, 4.813343e-01, 4.813501e-01,
    4.813659e-01, 4.813816e-01, 4.813974e-01, 4.814132e-01, 4.814289e-01, 4.814447e-01,
    4.814605e-01, 4.814762e-01, 4.814920e-01, 4.815078e-01, 4.815236e-01, 4.815393e-01,
    4.815551e-01, 4.815709e-01, 4.815866e-01, 4.816024e-01, 4.816181e-01, 4.816339e-01,
    4.816497e-01, 4.816654e-01, 4.816812e-01, 4.816970e-01, 4.817127e-01, 4.817285e-01,
    4.817443e-01, 4.817600e-01, 4.817758e-01, 4.817916e-01, 4.818073e-01, 4.818231e-01,
    4.818389e-01, 4.818546e-01, 4.818704e-01, 4.818861e-01, 4.819019e-01, 4.819176e-01,
    4.819334e-01, 4.819492e-01, 4.819649e-01, 4.819807e-01, 4.819965e-01, 4.820122e-01,
    4.820280e-01, 4.820438e-01, 4.820595e-01, 4.820753e-01, 4.820910e-01, 4.821068e-01,
    4.821225e-01, 4.821383e-01, 4.821541e-01, 4.821698e-01, 4.821856e-01, 4.822013e-01,
    4.822171e-01, 4.822329e-01, 4.822486e-01, 4.822644e-01, 4.822802e-01, 4.822959e-01,
    4.823117e-01, 4.823274e-01, 4.823432e-01, 4.823589e-01, 4.823747e-01, 4.823904e-01,
    4.824062e-01, 4.824220e-01, 4.824377e-01, 4.824535e-01, 4.824693e-01, 4.824850e-01,
    4.825008e-01, 4.825165e-01, 4.825322e-01, 4.825480e-01, 4.825638e-01, 4.825795e-01,
    4.825953e-01, 4.826111e-01, 4.826268e-01, 4.826425e-01, 4.826583e-01, 4.826740e-01,
    4.826898e-01, 4.827056e-01, 4.827213e-01, 4.827371e-01, 4.827528e-01, 4.827686e-01,
    4.827843e-01, 4.828001e-01, 4.828158e-01, 4.828316e-01, 4.828474e-01, 4.828631e-01,
    4.828788e-01, 4.828946e-01, 4.829103e-01, 4.829261e-01, 4.829419e-01, 4.829576e-01,
    4.829733e-01, 4.829891e-01, 4.830048e-01, 4.830206e-01, 4.830364e-01, 4.830521e-01,
    4.830678e-01, 4.830836e-01, 4.830993e-01, 4.831151e-01, 4.831309e-01, 4.831466e-01,
    4.831623e-01, 4.831781e-01, 4.831938e-01, 4.832096e-01, 4.832253e-01, 4.832411e-01,
    4.832568e-01, 4.832726e-01, 4.832883e-01, 4.833041e-01, 4.833198e-01, 4.833356e-01,
    4.833513e-01, 4.833671e-01, 4.833828e-01, 4.833986e-01, 4.834143e-01, 4.834301e-01,
    4.834458e-01, 4.834616e-01, 4.834773e-01, 4.834930e-01, 4.835088e-01, 4.835245e-01,
    4.835403e-01, 4.835560e-01, 4.835717e-01, 4.835875e-01, 4.836033e-01, 4.836190e-01,
    4.836347e-01, 4.836505e-01, 4.836662e-01, 4.836820e-01, 4.836977e-01, 4.837134e-01,
    4.837292e-01, 4.837449e-01, 4.837607e-01, 4.837764e-01, 4.837922e-01, 4.838079e-01,
    4.838237e-01, 4.838394e-01, 4.838551e-01, 4.838709e-01, 4.838866e-01, 4.839023e-01,
    4.839181e-01, 4.839339e-01, 4.839496e-01, 4.839653e-01, 4.839811e-01, 4.839968e-01,
    4.840125e-01, 4.840283e-01, 4.840440e-01, 4.840598e-01, 4.840755e-01, 4.840912e-01,
    4.841070e-01, 4.841227e-01, 4.841384e-01, 4.841542e-01, 4.841699e-01, 4.841857e-01,
    4.842014e-01, 4.842172e-01, 4.842329e-01, 4.842486e-01, 4.842644e-01, 4.842801e-01,
    4.842958e-01, 4.843116e-01, 4.843273e-01, 4.843431e-01, 4.843588e-01, 4.843745e-01,
    4.843903e-01, 4.844060e-01, 4.844217e-01, 4.844374e-01, 4.844531e-01, 4.844689e-01,
    4.844846e-01, 4.845004e-01, 4.845161e-01, 4.845318e-01, 4.845476e-01, 4.845633e-01,
    4.845791e-01, 4.845948e-01, 4.846105e-01, 4.846263e-01, 4.846420e-01, 4.846577e-01,
    4.846734e-01, 4.846891e-01, 4.847049e-01, 4.847206e-01, 4.847364e-01, 4.847521e-01,
    4.847679e-01, 4.847836e-01, 4.847993e-01, 4.848150e-01, 4.848307e-01, 4.848465e-01,
    4.848622e-01, 4.848779e-01, 4.848937e-01, 4.849094e-01, 4.849251e-01, 4.849409e-01,
    4.849566e-01, 4.849723e-01, 4.849881e-01, 4.850038e-01, 4.850195e-01, 4.850352e-01,
    4.850510e-01, 4.850667e-01, 4.850824e-01, 4.850981e-01, 4.851139e-01, 4.851296e-01,
    4.851453e-01, 4.851611e-01, 4.851768e-01, 4.851925e-01, 4.852082e-01, 4.852240e-01,
    4.852397e-01, 4.852554e-01, 4.852712e-01, 4.852869e-01, 4.853026e-01, 4.853183e-01,
    4.853340e-01, 4.853498e-01, 4.853655e-01, 4.853812e-01, 4.853970e-01, 4.854127e-01,
    4.854284e-01, 4.854441e-01, 4.854599e-01, 4.854755e-01, 4.854913e-01, 4.855070e-01,
    4.855227e-01, 4.855385e-01, 4.855542e-01, 4.855699e-01, 4.855856e-01, 4.856014e-01,
    4.856171e-01, 4.856328e-01, 4.856485e-01, 4.856642e-01, 4.856800e-01, 4.856957e-01,
    4.857114e-01, 4.857271e-01, 4.857429e-01, 4.857585e-01, 4.857743e-01, 4.857900e-01,
    4.858057e-01, 4.858215e-01, 4.858372e-01, 4.858529e-01, 4.858686e-01, 4.858843e-01,
    4.859000e-01, 4.859158e-01, 4.859315e-01, 4.859472e-01, 4.859629e-01, 4.859786e-01,
    4.859943e-01, 4.860101e-01, 4.860258e-01, 4.860415e-01, 4.860573e-01, 4.860729e-01,
    4.860887e-01, 4.861044e-01, 4.861201e-01, 4.861358e-01, 4.861515e-01, 4.861673e-01,
    4.861830e-01, 4.861987e-01, 4.862144e-01, 4.862301e-01, 4.862458e-01, 4.862615e-01,
    4.862773e-01, 4.862930e-01, 4.863087e-01, 4.863244e-01, 4.863401e-01, 4.863558e-01,
    4.863715e-01, 4.863872e-01, 4.864030e-01, 4.864187e-01, 4.864344e-01, 4.864501e-01,
    4.864658e-01, 4.864815e-01, 4.864973e-01, 4.865130e-01, 4.865287e-01, 4.865444e-01,
    4.865601e-01, 4.865758e-01, 4.865915e-01, 4.866072e-01, 4.866229e-01, 4.866387e-01,
    4.866544e-01, 4.866700e-01, 4.866858e-01, 4.867015e-01, 4.867172e-01, 4.867329e-01,
    4.867486e-01, 4.867643e-01, 4.867800e-01, 4.867957e-01, 4.868115e-01, 4.868272e-01,
    4.868428e-01, 4.868586e-01, 4.868743e-01, 4.868900e-01, 4.869057e-01, 4.869214e-01,
    4.869371e-01, 4.869528e-01, 4.869685e-01, 4.869843e-01, 4.870000e-01, 4.870157e-01,
    4.870313e-01, 4.870471e-01, 4.870628e-01, 4.870785e-01, 4.870942e-01, 4.871099e-01,
    4.871256e-01, 4.871413e-01, 4.871570e-01, 4.871727e-01, 4.871884e-01, 4.872041e-01,
    4.872198e-01, 4.872355e-01, 4.872512e-01, 4.872670e-01, 4.872827e-01, 4.872983e-01,
    4.873140e-01, 4.873298e-01, 4.873455e-01, 4.873612e-01, 4.873769e-01, 4.873925e-01,
    4.874083e-01, 4.874240e-01, 4.874397e-01, 4.874554e-01, 4.874711e-01, 4.874868e-01,
    4.875025e-01, 4.875182e-01, 4.875339e-01, 4.875496e-01, 4.875653e-01, 4.875810e-01,
    4.875967e-01, 4.876124e-01, 4.876281e-01, 4.876438e-01, 4.876595e-01, 4.876752e-01,
    4.876909e-01, 4.877066e-01, 4.877223e-01, 4.877380e-01, 4.877537e-01, 4.877694e-01,
    4.877851e-01, 4.878008e-01, 4.878165e-01, 4.878322e-01, 4.878479e-01, 4.878636e-01,
    4.878793e-01, 4.878950e-01, 4.879107e-01, 4.879264e-01, 4.879421e-01, 4.879578e-01,
    4.879735e-01, 4.879892e-01, 4.880049e-01, 4.880205e-01, 4.880362e-01, 4.880519e-01,
    4.880676e-01, 4.880833e-01, 4.880990e-01, 4.881147e-01, 4.881304e-01, 4.881461e-01,
    4.881618e-01, 4.881775e-01, 4.881932e-01, 4.882089e-01, 4.882246e-01, 4.882402e-01,
    4.882559e-01, 4.882717e-01, 4.882873e-01, 4.883030e-01, 4.883187e-01, 4.883344e-01,
    4.883501e-01, 4.883658e-01, 4.883815e-01, 4.883972e-01, 4.884129e-01, 4.884286e-01,
    4.884443e-01, 4.884600e-01, 4.884757e-01, 4.884914e-01, 4.885070e-01, 4.885227e-01,
    4.885384e-01, 4.885541e-01, 4.885698e-01, 4.885855e-01, 4.886011e-01, 4.886169e-01,
    4.886326e-01, 4.886482e-01, 4.886639e-01, 4.886796e-01, 4.886953e-01, 4.887110e-01,
    4.887267e-01, 4.887424e-01, 4.887581e-01, 4.887737e-01, 4.887894e-01, 4.888051e-01,
    4.888208e-01, 4.888365e-01, 4.888522e-01, 4.888678e-01, 4.888836e-01, 4.888993e-01,
    4.889149e-01, 4.889306e-01, 4.889463e-01, 4.889620e-01, 4.889777e-01, 4.889934e-01,
    4.890091e-01, 4.890247e-01, 4.890404e-01, 4.890561e-01, 4.890718e-01, 4.890875e-01,
    4.891031e-01, 4.891188e-01, 4.891345e-01, 4.891502e-01, 4.891659e-01, 4.891815e-01,
    4.891973e-01, 4.892130e-01, 4.892286e-01, 4.892443e-01, 4.892600e-01, 4.892757e-01,
    4.892914e-01, 4.893070e-01, 4.893227e-01, 4.893384e-01, 4.893540e-01, 4.893698e-01,
    4.893855e-01, 4.894011e-01, 4.894168e-01, 4.894325e-01, 4.894482e-01, 4.894638e-01,
    4.894795e-01, 4.894952e-01, 4.895109e-01, 4.895266e-01, 4.895422e-01, 4.895580e-01,
    4.895736e-01, 4.895893e-01, 4.896050e-01, 4.896206e-01, 4.896363e-01, 4.896520e-01,
    4.896677e-01, 4.896834e-01, 4.896990e-01, 4.897147e-01, 4.897304e-01, 4.897461e-01,
    4.897617e-01, 4.897774e-01, 4.897931e-01, 4.898088e-01, 4.898244e-01, 4.898401e-01,
    4.898558e-01, 4.898715e-01, 4.898871e-01, 4.899028e-01, 4.899185e-01, 4.899341e-01,
    4.899499e-01, 4.899656e-01, 4.899812e-01, 4.899969e-01, 4.900125e-01, 4.900282e-01,
    4.900439e-01, 4.900596e-01, 4.900752e-01, 4.900909e-01, 4.901066e-01, 4.901223e-01,
    4.901380e-01, 4.901536e-01, 4.901693e-01, 4.901850e-01, 4.902006e-01, 4.902163e-01,
    4.902320e-01, 4.902476e-01, 4.902633e-01, 4.902790e-01, 4.902947e-01, 4.903103e-01,
    4.903260e-01, 4.903417e-01, 4.903573e-01, 4.903730e-01, 4.903887e-01, 4.904044e-01,
    4.904200e-01, 4.904357e-01, 4.904514e-01, 4.904670e-01, 4.904827e-01, 4.904984e-01,
    4.905140e-01, 4.905297e-01, 4.905454e-01, 4.905610e-01, 4.905767e-01, 4.905924e-01,
    4.906080e-01, 4.906237e-01, 4.906394e-01, 4.906551e-01, 4.906707e-01, 4.906864e-01,
    4.907021e-01, 4.907177e-01, 4.907334e-01, 4.907491e-01, 4.907647e-01, 4.907804e-01,
    4.907961e-01, 4.908117e-01, 4.908274e-01, 4.908430e-01, 4.908587e-01, 4.908744e-01,
    4.908900e-01, 4.909057e-01, 4.909214e-01, 4.909370e-01, 4.909527e-01, 4.909684e-01,
    4.909840e-01, 4.909997e-01, 4.910154e-01, 4.910310e-01, 4.910467e-01, 4.910623e-01,
    4.910780e-01, 4.910937e-01, 4.911093e-01, 4.911250e-01, 4.911407e-01, 4.911563e-01,
    4.911720e-01, 4.911877e-01, 4.912033e-01, 4.912190e-01, 4.912346e-01, 4.912503e-01,
    4.912660e-01, 4.912816e-01, 4.912972e-01, 4.913130e-01, 4.913286e-01, 4.913442e-01,
    4.913599e-01, 4.913755e-01, 4.913912e-01, 4.914069e-01, 4.914225e-01, 4.914382e-01,
    4.914538e-01, 4.914695e-01, 4.914852e-01, 4.915008e-01, 4.915165e-01, 4.915321e-01,
    4.915478e-01, 4.915635e-01, 4.915791e-01, 4.915948e-01, 4.916104e-01, 4.916261e-01,
    4.916417e-01, 4.916574e-01, 4.916731e-01, 4.916887e-01, 4.917044e-01, 4.917200e-01,
    4.917357e-01, 4.917513e-01, 4.917670e-01, 4.917827e-01, 4.917983e-01, 4.918140e-01,
    4.918296e-01, 4.918453e-01, 4.918609e-01, 4.918766e-01, 4.918922e-01, 4.919079e-01,
    4.919235e-01, 4.919392e-01, 4.919548e-01, 4.919705e-01, 4.919862e-01, 4.920018e-01,
    4.920175e-01, 4.920331e-01, 4.920488e-01, 4.920644e-01, 4.920801e-01, 4.920957e-01,
    4.921114e-01, 4.921270e-01, 4.921427e-01, 4.921583e-01, 4.921740e-01, 4.921896e-01,
    4.922053e-01, 4.922209e-01, 4.922366e-01, 4.922522e-01, 4.922679e-01, 4.922835e-01,
    4.922992e-01, 4.923148e-01, 4.923305e-01, 4.923461e-01, 4.923618e-01, 4.923774e-01,
    4.923931e-01, 4.924087e-01, 4.924244e-01, 4.924400e-01, 4.924556e-01, 4.924713e-01,
    4.924869e-01, 4.925026e-01, 4.925182e-01, 4.925339e-01, 4.925495e-01, 4.925652e-01,
    4.925808e-01, 4.925965e-01, 4.926122e-01, 4.926278e-01, 4.926434e-01, 4.926591e-01,
    4.926747e-01, 4.926904e-01, 4.927060e-01, 4.927216e-01, 4.927373e-01, 4.927529e-01,
    4.927686e-01, 4.927842e-01, 4.927998e-01, 4.928155e-01, 4.928312e-01, 4.928468e-01,
    4.928624e-01, 4.928781e-01, 4.928937e-01, 4.929094e-01, 4.929250e-01, 4.929407e-01,
    4.929563e-01, 4.929719e-01, 4.929876e-01, 4.930032e-01, 4.930189e-01, 4.930345e-01,
    4.930501e-01, 4.930658e-01, 4.930815e-01, 4.930971e-01, 4.931127e-01, 4.931284e-01,
    4.931440e-01, 4.931597e-01, 4.931753e-01, 4.931909e-01, 4.932066e-01, 4.932222e-01,
    4.932378e-01, 4.932535e-01, 4.932691e-01, 4.932848e-01, 4.933004e-01, 4.933160e-01,
    4.933317e-01, 4.933473e-01, 4.933629e-01, 4.933786e-01, 4.933942e-01, 4.934098e-01,
    4.934255e-01, 4.934411e-01, 4.934568e-01, 4.934724e-01, 4.934880e-01, 4.935037e-01,
    4.935193e-01, 4.935350e-01, 4.935506e-01, 4.935662e-01, 4.935819e-01, 4.935975e-01,
    4.936131e-01, 4.936288e-01, 4.936444e-01, 4.936600e-01, 4.936757e-01, 4.936913e-01,
    4.937069e-01, 4.937226e-01, 4.937382e-01, 4.937539e-01, 4.937695e-01, 4.937851e-01,
    4.938007e-01, 4.938164e-01, 4.938320e-01, 4.938476e-01, 4.938633e-01, 4.938789e-01,
    4.938945e-01, 4.939102e-01, 4.939258e-01, 4.939414e-01, 4.939570e-01, 4.939727e-01,
    4.939883e-01, 4.940040e-01, 4.940196e-01, 4.940352e-01, 4.940509e-01, 4.940665e-01,
    4.940821e-01, 4.940977e-01, 4.941134e-01, 4.941290e-01, 4.941446e-01, 4.941602e-01,
    4.941759e-01, 4.941915e-01, 4.942071e-01, 4.942228e-01, 4.942384e-01, 4.942540e-01,
    4.942697e-01, 4.942853e-01, 4.943009e-01, 4.943165e-01, 4.943322e-01, 4.943478e-01,
    4.943634e-01, 4.943790e-01, 4.943947e-01, 4.944103e-01, 4.944259e-01, 4.944416e-01,
    4.944572e-01, 4.944728e-01, 4.944884e-01, 4.945040e-01, 4.945197e-01, 4.945353e-01,
    4.945509e-01, 4.945666e-01, 4.945821e-01, 4.945978e-01, 4.946134e-01, 4.946291e-01,
    4.946447e-01, 4.946603e-01, 4.946759e-01, 4.946916e-01, 4.947071e-01, 4.947228e-01,
    4.947384e-01, 4.947540e-01, 4.947697e-01, 4.947853e-01, 4.948009e-01, 4.948165e-01,
    4.948321e-01, 4.948478e-01, 4.948634e-01, 4.948790e-01, 4.948947e-01, 4.949103e-01,
    4.949259e-01, 4.949415e-01, 4.949571e-01, 4.949727e-01, 4.949884e-01, 4.950040e-01,
    4.950196e-01, 4.950352e-01, 4.950508e-01, 4.950665e-01, 4.950821e-01, 4.950977e-01,
    4.951133e-01, 4.951289e-01, 4.951445e-01, 4.951602e-01, 4.951758e-01, 4.951914e-01,
    4.952070e-01, 4.952227e-01, 4.952383e-01, 4.952539e-01, 4.952695e-01, 4.952851e-01,
    4.953007e-01, 4.953164e-01, 4.953320e-01, 4.953476e-01, 4.953632e-01, 4.953788e-01,
    4.953944e-01, 4.954101e-01, 4.954256e-01, 4.954413e-01, 4.954569e-01, 4.954725e-01,
    4.954881e-01, 4.955037e-01, 4.955193e-01, 4.955350e-01, 4.955506e-01, 4.955662e-01,
    4.955818e-01, 4.955974e-01, 4.956130e-01, 4.956286e-01, 4.956443e-01, 4.956599e-01,
    4.956755e-01, 4.956911e-01, 4.957067e-01, 4.957223e-01, 4.957379e-01, 4.957535e-01,
    4.957692e-01, 4.957848e-01, 4.958004e-01, 4.958160e-01, 4.958316e-01, 4.958472e-01,
    4.958628e-01, 4.958784e-01, 4.958940e-01, 4.959097e-01, 4.959252e-01, 4.959409e-01,
    4.959565e-01, 4.959721e-01, 4.959877e-01, 4.960033e-01, 4.960189e-01, 4.960346e-01,
    4.960501e-01, 4.960658e-01, 4.960814e-01, 4.960970e-01, 4.961126e-01, 4.961282e-01,
    4.961438e-01, 4.961594e-01, 4.961750e-01, 4.961906e-01, 4.962062e-01, 4.962218e-01,
    4.962375e-01, 4.962530e-01, 4.962687e-01, 4.962843e-01, 4.962999e-01, 4.963155e-01,
    4.963311e-01, 4.963467e-01, 4.963623e-01, 4.963779e-01, 4.963935e-01, 4.964091e-01,
    4.964247e-01, 4.964403e-01, 4.964559e-01, 4.964715e-01, 4.964871e-01, 4.965027e-01,
    4.965183e-01, 4.965340e-01, 4.965495e-01, 4.965652e-01, 4.965808e-01, 4.965963e-01,
    4.966120e-01, 4.966275e-01, 4.966432e-01, 4.966588e-01, 4.966744e-01, 4.966900e-01,
    4.967056e-01, 4.967211e-01, 4.967368e-01, 4.967524e-01, 4.967680e-01, 4.967836e-01,
    4.967992e-01, 4.968148e-01, 4.968304e-01, 4.968460e-01, 4.968616e-01, 4.968772e-01,
    4.968928e-01, 4.969084e-01, 4.969240e-01, 4.969396e-01, 4.969552e-01, 4.969708e-01,
    4.969864e-01, 4.970019e-01, 4.970176e-01, 4.970332e-01, 4.970488e-01, 4.970644e-01,
    4.970799e-01, 4.970956e-01, 4.971112e-01, 4.971268e-01, 4.971423e-01, 4.971579e-01,
    4.971735e-01, 4.971892e-01, 4.972047e-01, 4.972203e-01, 4.972359e-01, 4.972515e-01,
    4.972671e-01, 4.972827e-01, 4.972983e-01, 4.973139e-01, 4.973295e-01, 4.973451e-01,
    4.973607e-01, 4.973763e-01, 4.973919e-01, 4.974075e-01, 4.974231e-01, 4.974387e-01,
    4.974543e-01, 4.974698e-01, 4.974854e-01, 4.975010e-01, 4.975166e-01, 4.975322e-01,
    4.975478e-01, 4.975634e-01, 4.975790e-01, 4.975946e-01, 4.976102e-01, 4.976258e-01,
    4.976414e-01, 4.976569e-01, 4.976726e-01, 4.976881e-01, 4.977037e-01, 4.977193e-01,
    4.977349e-01, 4.977505e-01, 4.977661e-01, 4.977817e-01, 4.977973e-01, 4.978129e-01,
    4.978285e-01, 4.978440e-01, 4.978596e-01, 4.978752e-01, 4.978908e-01, 4.979064e-01,
    4.979220e-01, 4.979376e-01, 4.979531e-01, 4.979688e-01, 4.979843e-01, 4.979999e-01,
    4.980155e-01, 4.980311e-01, 4.980467e-01, 4.980623e-01, 4.980779e-01, 4.980935e-01,
    4.981090e-01, 4.981246e-01, 4.981402e-01, 4.981558e-01, 4.981714e-01, 4.981869e-01,
    4.982026e-01, 4.982181e-01, 4.982337e-01, 4.982493e-01, 4.982649e-01, 4.982805e-01,
    4.982961e-01, 4.983116e-01, 4.983272e-01, 4.983428e-01, 4.983584e-01, 4.983740e-01,
    4.983895e-01, 4.984052e-01, 4.984207e-01, 4.984363e-01, 4.984519e-01, 4.984675e-01,
    4.984831e-01, 4.984986e-01, 4.985142e-01, 4.985298e-01, 4.985454e-01, 4.985610e-01,
    4.985766e-01, 4.985921e-01, 4.986077e-01, 4.986233e-01, 4.986389e-01, 4.986545e-01,
    4.986701e-01, 4.986856e-01, 4.987012e-01, 4.987168e-01, 4.987324e-01, 4.987479e-01,
    4.987635e-01, 4.987791e-01, 4.987946e-01, 4.988103e-01, 4.988258e-01, 4.988414e-01,
    4.988570e-01, 4.988726e-01, 4.988881e-01, 4.989038e-01, 4.989193e-01, 4.989349e-01,
    4.989505e-01, 4.989660e-01, 4.989816e-01, 4.989972e-01, 4.990128e-01, 4.990284e-01,
    4.990439e-01, 4.990595e-01, 4.990751e-01, 4.990906e-01, 4.991063e-01, 4.991218e-01,
    4.991374e-01, 4.991529e-01, 4.991685e-01, 4.991841e-01, 4.991997e-01, 4.992152e-01,
    4.992308e-01, 4.992464e-01, 4.992620e-01, 4.992775e-01, 4.992931e-01, 4.993087e-01,
    4.993243e-01, 4.993398e-01, 4.993554e-01, 4.993710e-01, 4.993866e-01, 4.994021e-01,
    4.994177e-01, 4.994333e-01, 4.994488e-01, 4.994645e-01, 4.994800e-01, 4.994956e-01,
    4.995112e-01, 4.995267e-01, 4.995423e-01, 4.995578e-01, 4.995734e-01, 4.995890e-01,
    4.996046e-01, 4.996201e-01, 4.996357e-01, 4.996513e-01, 4.996668e-01, 4.996824e-01,
    4.996980e-01, 4.997136e-01, 4.997291e-01, 4.997447e-01, 4.997603e-01, 4.997758e-01,
    4.997914e-01, 4.998069e-01, 4.998225e-01, 4.998381e-01, 4.998537e-01, 4.998693e-01,
    4.998848e-01, 4.999004e-01, 4.999160e-01, 4.999315e-01, 4.999471e-01, 4.999626e-01,
    4.999782e-01, 4.999938e-01, 5.000094e-01, 5.000249e-01, 5.000405e-01, 5.000560e-01,
    5.000716e-01, 5.000871e-01, 5.001027e-01, 5.001183e-01, 5.001339e-01, 5.001494e-01,
    5.001650e-01, 5.001805e-01, 5.001961e-01, 5.002117e-01, 5.002272e-01, 5.002428e-01,
    5.002584e-01, 5.002739e-01, 5.002895e-01, 5.003051e-01, 5.003206e-01, 5.003362e-01,
    5.003517e-01, 5.003673e-01, 5.003829e-01, 5.003985e-01, 5.004140e-01, 5.004296e-01,
    5.004451e-01, 5.004607e-01, 5.004762e-01, 5.004918e-01, 5.005074e-01, 5.005229e-01,
    5.005385e-01, 5.005540e-01, 5.005696e-01, 5.005852e-01, 5.006008e-01, 5.006163e-01,
    5.006319e-01, 5.006474e-01, 5.006629e-01, 5.006785e-01, 5.006941e-01, 5.007097e-01,
    5.007252e-01, 5.007408e-01, 5.007563e-01, 5.007719e-01, 5.007874e-01, 5.008030e-01,
    5.008186e-01, 5.008341e-01, 5.008497e-01, 5.008652e-01, 5.008808e-01, 5.008963e-01,
    5.009119e-01, 5.009274e-01, 5.009430e-01, 5.009586e-01, 5.009741e-01, 5.009897e-01,
    5.010052e-01, 5.010208e-01, 5.010363e-01, 5.010519e-01, 5.010675e-01, 5.010830e-01,
    5.010985e-01, 5.011141e-01, 5.011297e-01, 5.011452e-01, 5.011607e-01, 5.011763e-01,
    5.011919e-01, 5.012074e-01, 5.012230e-01, 5.012385e-01, 5.012541e-01, 5.012696e-01,
    5.012852e-01, 5.013008e-01, 5.013162e-01, 5.013318e-01, 5.013474e-01, 5.013630e-01,
    5.013785e-01, 5.013940e-01, 5.014096e-01, 5.014251e-01, 5.014407e-01, 5.014563e-01,
    5.014718e-01, 5.014874e-01, 5.015029e-01, 5.015184e-01, 5.015340e-01, 5.015495e-01,
    5.015651e-01, 5.015807e-01, 5.015962e-01, 5.016117e-01, 5.016273e-01, 5.016428e-01,
    5.016584e-01, 5.016739e-01, 5.016895e-01, 5.017051e-01, 5.017206e-01, 5.017361e-01,
    5.017517e-01, 5.017672e-01, 5.017828e-01, 5.017983e-01, 5.018138e-01, 5.018294e-01,
    5.018449e-01, 5.018605e-01, 5.018761e-01, 5.018916e-01, 5.019072e-01, 5.019227e-01,
    5.019382e-01, 5.019538e-01, 5.019693e-01, 5.019848e-01, 5.020004e-01, 5.020159e-01,
    5.020315e-01, 5.020470e-01, 5.020626e-01, 5.020781e-01, 5.020937e-01, 5.021092e-01,
    5.021248e-01, 5.021403e-01, 5.021558e-01, 5.021714e-01, 5.021870e-01, 5.022025e-01,
    5.022180e-01, 5.022336e-01, 5.022491e-01, 5.022646e-01, 5.022802e-01, 5.022957e-01,
    5.023113e-01, 5.023268e-01, 5.023423e-01, 5.023579e-01, 5.023735e-01, 5.023890e-01,
    5.024045e-01, 5.024201e-01, 5.024356e-01, 5.024511e-01, 5.024667e-01, 5.024822e-01,
    5.024977e-01, 5.025133e-01, 5.025288e-01, 5.025443e-01, 5.025599e-01, 5.025755e-01,
    5.025910e-01, 5.026065e-01, 5.026221e-01, 5.026376e-01, 5.026531e-01, 5.026687e-01,
    5.026842e-01, 5.026997e-01, 5.027153e-01, 5.027308e-01, 5.027463e-01, 5.027619e-01,
    5.027775e-01, 5.027930e-01, 5.028085e-01, 5.028241e-01, 5.028396e-01, 5.028551e-01,
    5.028706e-01, 5.028862e-01, 5.029017e-01, 5.029172e-01, 5.029328e-01, 5.029483e-01,
    5.029638e-01, 5.029794e-01, 5.029949e-01, 5.030105e-01, 5.030260e-01, 5.030415e-01,
    5.030571e-01, 5.030726e-01, 5.030881e-01, 5.031036e-01, 5.031192e-01, 5.031347e-01,
    5.031502e-01, 5.031658e-01, 5.031813e-01, 5.031968e-01, 5.032124e-01, 5.032279e-01,
    5.032434e-01, 5.032590e-01, 5.032745e-01, 5.032901e-01, 5.033056e-01, 5.033211e-01,
    5.033366e-01, 5.033522e-01, 5.033677e-01, 5.033832e-01, 5.033987e-01, 5.034143e-01,
    5.034298e-01, 5.034453e-01, 5.034608e-01, 5.034764e-01, 5.034919e-01, 5.035074e-01,
    5.035230e-01, 5.035385e-01, 5.035540e-01, 5.035695e-01, 5.035850e-01, 5.036007e-01,
    5.036162e-01, 5.036317e-01, 5.036472e-01, 5.036627e-01, 5.036783e-01, 5.036938e-01,
    5.037093e-01, 5.037248e-01, 5.037404e-01, 5.037559e-01, 5.037714e-01, 5.037869e-01,
    5.038025e-01, 5.038180e-01, 5.038335e-01, 5.038490e-01, 5.038645e-01, 5.038801e-01,
    5.038956e-01, 5.039111e-01, 5.039267e-01, 5.039422e-01, 5.039577e-01, 5.039732e-01,
    5.039887e-01, 5.040043e-01, 5.040198e-01, 5.040353e-01, 5.040509e-01, 5.040663e-01,
    5.040819e-01, 5.040974e-01, 5.041129e-01, 5.041285e-01, 5.041440e-01, 5.041595e-01,
    5.041750e-01, 5.041905e-01, 5.042061e-01, 5.042216e-01, 5.042371e-01, 5.042526e-01,
    5.042681e-01, 5.042837e-01, 5.042992e-01, 5.043147e-01, 5.043302e-01, 5.043457e-01,
    5.043613e-01, 5.043768e-01, 5.043923e-01, 5.044078e-01, 5.044233e-01, 5.044388e-01,
    5.044544e-01, 5.044699e-01, 5.044854e-01, 5.045009e-01, 5.045164e-01, 5.045320e-01,
    5.045475e-01, 5.045630e-01, 5.045785e-01, 5.045940e-01, 5.046095e-01, 5.046250e-01,
    5.046406e-01, 5.046561e-01, 5.046716e-01, 5.046871e-01, 5.047026e-01, 5.047181e-01,
    5.047336e-01, 5.047492e-01, 5.047647e-01, 5.047802e-01, 5.047957e-01, 5.048112e-01,
    5.048267e-01, 5.048423e-01, 5.048578e-01, 5.048733e-01, 5.048888e-01, 5.049043e-01,
    5.049198e-01, 5.049353e-01, 5.049509e-01, 5.049663e-01, 5.049819e-01, 5.049974e-01,
    5.050129e-01, 5.050284e-01, 5.050439e-01, 5.050594e-01, 5.050750e-01, 5.050905e-01,
    5.051060e-01, 5.051215e-01, 5.051370e-01, 5.051525e-01, 5.051680e-01, 5.051835e-01,
    5.051990e-01, 5.052146e-01, 5.052300e-01, 5.052456e-01, 5.052611e-01, 5.052766e-01,
    5.052921e-01, 5.053076e-01, 5.053231e-01, 5.053386e-01, 5.053541e-01, 5.053697e-01,
    5.053852e-01, 5.054007e-01, 5.054162e-01, 5.054317e-01, 5.054471e-01, 5.054627e-01,
    5.054782e-01, 5.054937e-01, 5.055092e-01, 5.055248e-01, 5.055402e-01, 5.055557e-01,
    5.055712e-01, 5.055867e-01, 5.056022e-01, 5.056177e-01, 5.056332e-01, 5.056488e-01,
    5.056642e-01, 5.056798e-01, 5.056953e-01, 5.057108e-01, 5.057263e-01, 5.057418e-01,
    5.057573e-01, 5.057728e-01, 5.057883e-01, 5.058038e-01, 5.058193e-01, 5.058348e-01,
    5.058503e-01, 5.058658e-01, 5.058813e-01, 5.058968e-01, 5.059123e-01, 5.059278e-01,
    5.059434e-01, 5.059588e-01, 5.059744e-01, 5.059898e-01, 5.060053e-01, 5.060208e-01,
    5.060363e-01, 5.060518e-01, 5.060673e-01, 5.060828e-01, 5.060983e-01, 5.061138e-01,
    5.061293e-01, 5.061449e-01, 5.061603e-01, 5.061759e-01, 5.061913e-01, 5.062069e-01,
    5.062223e-01, 5.062379e-01, 5.062534e-01, 5.062689e-01, 5.062844e-01, 5.062998e-01,
    5.063154e-01, 5.063308e-01, 5.063463e-01, 5.063618e-01, 5.063773e-01, 5.063928e-01,
    5.064083e-01, 5.064238e-01, 5.064393e-01, 5.064548e-01, 5.064703e-01, 5.064858e-01,
    5.065013e-01, 5.065168e-01, 5.065323e-01, 5.065477e-01, 5.065633e-01, 5.065787e-01,
    5.065943e-01, 5.066097e-01, 5.066252e-01, 5.066408e-01, 5.066562e-01, 5.066717e-01,
    5.066872e-01, 5.067027e-01, 5.067182e-01, 5.067337e-01, 5.067492e-01, 5.067647e-01,
    5.067802e-01, 5.067957e-01, 5.068112e-01, 5.068267e-01, 5.068421e-01, 5.068577e-01,
    5.068731e-01, 5.068886e-01, 5.069042e-01, 5.069196e-01, 5.069351e-01, 5.069506e-01,
    5.069661e-01, 5.069816e-01, 5.069970e-01, 5.070126e-01, 5.070280e-01, 5.070435e-01,
    5.070590e-01, 5.070745e-01, 5.070900e-01, 5.071055e-01, 5.071210e-01, 5.071365e-01,
    5.071520e-01, 5.071675e-01, 5.071830e-01, 5.071985e-01, 5.072140e-01, 5.072294e-01,
    5.072449e-01, 5.072604e-01, 5.072759e-01, 5.072914e-01, 5.073069e-01, 5.073223e-01,
    5.073379e-01, 5.073533e-01, 5.073688e-01, 5.073843e-01, 5.073998e-01, 5.074153e-01,
    5.074308e-01, 5.074462e-01, 5.074617e-01, 5.074772e-01, 5.074927e-01, 5.075082e-01,
    5.075237e-01, 5.075392e-01, 5.075547e-01, 5.075701e-01, 5.075856e-01, 5.076011e-01,
    5.076166e-01, 5.076321e-01, 5.076476e-01, 5.076630e-01, 5.076785e-01, 5.076940e-01,
    5.077094e-01, 5.077250e-01, 5.077404e-01, 5.077559e-01, 5.077714e-01, 5.077869e-01,
    5.078024e-01, 5.078179e-01, 5.078334e-01, 5.078488e-01, 5.078643e-01, 5.078798e-01,
    5.078952e-01, 5.079108e-01, 5.079262e-01, 5.079417e-01, 5.079572e-01, 5.079727e-01,
    5.079882e-01, 5.080037e-01, 5.080191e-01, 5.080346e-01, 5.080501e-01, 5.080656e-01,
    5.080810e-01, 5.080965e-01, 5.081120e-01, 5.081275e-01, 5.081429e-01, 5.081584e-01,
    5.081739e-01, 5.081894e-01, 5.082049e-01, 5.082203e-01, 5.082358e-01, 5.082513e-01,
    5.082667e-01, 5.082822e-01, 5.082977e-01, 5.083132e-01, 5.083287e-01, 5.083442e-01,
    5.083597e-01, 5.083751e-01, 5.083905e-01, 5.084060e-01, 5.084215e-01, 5.084370e-01,
    5.084525e-01, 5.084680e-01, 5.084834e-01, 5.084989e-01, 5.085144e-01, 5.085298e-01,
    5.085453e-01, 5.085608e-01, 5.085763e-01, 5.085917e-01, 5.086072e-01, 5.086227e-01,
    5.086381e-01, 5.086536e-01, 5.086691e-01, 5.086846e-01, 5.087001e-01, 5.087155e-01,
    5.087310e-01, 5.087465e-01, 5.087619e-01, 5.087774e-01, 5.087929e-01, 5.088084e-01,
    5.088238e-01, 5.088393e-01, 5.088548e-01, 5.088702e-01, 5.088857e-01, 5.089012e-01,
    5.089167e-01, 5.089321e-01, 5.089476e-01, 5.089631e-01, 5.089785e-01, 5.089940e-01,
    5.090095e-01, 5.090250e-01, 5.090404e-01, 5.090559e-01, 5.090714e-01, 5.090868e-01,
    5.091023e-01, 5.091177e-01, 5.091332e-01, 5.091487e-01, 5.091642e-01, 5.091796e-01,
    5.091951e-01, 5.092106e-01, 5.092260e-01, 5.092415e-01, 5.092570e-01, 5.092725e-01,
    5.092879e-01, 5.093033e-01, 5.093188e-01, 5.093343e-01, 5.093498e-01, 5.093652e-01,
    5.093807e-01, 5.093961e-01, 5.094116e-01, 5.094271e-01, 5.094425e-01, 5.094580e-01,
    5.094735e-01, 5.094889e-01, 5.095044e-01, 5.095199e-01, 5.095353e-01, 5.095508e-01,
    5.095662e-01, 5.095817e-01, 5.095972e-01, 5.096127e-01, 5.096281e-01, 5.096436e-01,
    5.096591e-01, 5.096745e-01, 5.096900e-01, 5.097054e-01, 5.097209e-01, 5.097364e-01,
    5.097518e-01, 5.097673e-01, 5.097827e-01, 5.097982e-01, 5.098137e-01, 5.098291e-01,
    5.098446e-01, 5.098600e-01, 5.098755e-01, 5.098909e-01, 5.099064e-01, 5.099219e-01,
    5.099373e-01, 5.099528e-01, 5.099682e-01, 5.099837e-01, 5.099992e-01, 5.100147e-01,
    5.100301e-01, 5.100455e-01, 5.100610e-01, 5.100765e-01, 5.100919e-01, 5.101074e-01,
    5.101228e-01, 5.101383e-01, 5.101537e-01, 5.101692e-01, 5.101846e-01, 5.102001e-01,
    5.102156e-01, 5.102310e-01, 5.102465e-01, 5.102620e-01, 5.102774e-01, 5.102929e-01,
    5.103083e-01, 5.103238e-01, 5.103392e-01, 5.103547e-01, 5.103701e-01, 5.103856e-01,
    5.104010e-01, 5.104164e-01, 5.104319e-01, 5.104474e-01, 5.104629e-01, 5.104783e-01,
    5.104938e-01, 5.105092e-01, 5.105246e-01, 5.105401e-01, 5.105556e-01, 5.105711e-01,
    5.105865e-01, 5.106019e-01, 5.106174e-01, 5.106328e-01, 5.106483e-01, 5.106637e-01,
    5.106792e-01, 5.106947e-01, 5.107101e-01, 5.107255e-01, 5.107410e-01, 5.107564e-01,
    5.107719e-01, 5.107874e-01, 5.108028e-01, 5.108182e-01, 5.108337e-01, 5.108491e-01,
    5.108646e-01, 5.108801e-01, 5.108955e-01, 5.109109e-01, 5.109264e-01, 5.109419e-01,
    5.109573e-01, 5.109727e-01, 5.109882e-01, 5.110036e-01, 5.110191e-01, 5.110345e-01,
    5.110500e-01, 5.110654e-01, 5.110809e-01, 5.110963e-01, 5.111117e-01, 5.111272e-01,
    5.111427e-01, 5.111581e-01, 5.111735e-01, 5.111890e-01, 5.112045e-01, 5.112199e-01,
    5.112353e-01, 5.112507e-01, 5.112662e-01, 5.112817e-01, 5.112971e-01, 5.113125e-01,
    5.113280e-01, 5.113435e-01, 5.113589e-01, 5.113744e-01, 5.113898e-01, 5.114052e-01,
    5.114207e-01, 5.114361e-01, 5.114515e-01, 5.114670e-01, 5.114824e-01, 5.114979e-01,
    5.115134e-01, 5.115288e-01, 5.115442e-01, 5.115597e-01, 5.115751e-01, 5.115905e-01,
    5.116059e-01, 5.116214e-01, 5.116369e-01, 5.116523e-01, 5.116677e-01, 5.116832e-01,
    5.116986e-01, 5.117140e-01, 5.117295e-01, 5.117450e-01, 5.117604e-01, 5.117759e-01,
    5.117913e-01, 5.118067e-01, 5.118221e-01, 5.118375e-01, 5.118530e-01, 5.118684e-01,
    5.118839e-01, 5.118993e-01, 5.119147e-01, 5.119302e-01, 5.119457e-01, 5.119611e-01,
    5.119765e-01, 5.119920e-01, 5.120074e-01, 5.120229e-01, 5.120383e-01, 5.120537e-01,
    5.120692e-01, 5.120846e-01, 5.121000e-01, 5.121154e-01, 5.121309e-01, 5.121463e-01,
    5.121617e-01, 5.121772e-01, 5.121926e-01, 5.122080e-01, 5.122235e-01, 5.122389e-01,
    5.122544e-01, 5.122698e-01, 5.122852e-01, 5.123007e-01, 5.123161e-01, 5.123315e-01,
    5.123470e-01, 5.123624e-01, 5.123779e-01, 5.123932e-01, 5.124087e-01, 5.124241e-01,
    5.124395e-01, 5.124550e-01, 5.124704e-01, 5.124859e-01, 5.125013e-01, 5.125167e-01,
    5.125322e-01, 5.125476e-01, 5.125630e-01, 5.125784e-01, 5.125939e-01, 5.126093e-01,
    5.126247e-01, 5.126402e-01, 5.126556e-01, 5.126711e-01, 5.126865e-01, 5.127019e-01,
    5.127173e-01, 5.127327e-01, 5.127482e-01, 5.127636e-01, 5.127791e-01, 5.127945e-01,
    5.128099e-01, 5.128253e-01, 5.128407e-01, 5.128562e-01, 5.128716e-01, 5.128871e-01,
    5.129024e-01, 5.129179e-01, 5.129333e-01, 5.129488e-01, 5.129642e-01, 5.129796e-01,
    5.129950e-01, 5.130104e-01, 5.130259e-01, 5.130413e-01, 5.130567e-01, 5.130721e-01,
    5.130876e-01, 5.131030e-01, 5.131184e-01, 5.131338e-01, 5.131493e-01, 5.131647e-01,
    5.131801e-01, 5.131955e-01, 5.132110e-01, 5.132264e-01, 5.132418e-01, 5.132573e-01,
    5.132727e-01, 5.132881e-01, 5.133035e-01, 5.133190e-01, 5.133344e-01, 5.133498e-01,
    5.133652e-01, 5.133806e-01, 5.133961e-01, 5.134115e-01, 5.134269e-01, 5.134423e-01,
    5.134577e-01, 5.134732e-01, 5.134886e-01, 5.135040e-01, 5.135194e-01, 5.135348e-01,
    5.135503e-01, 5.135657e-01, 5.135811e-01, 5.135965e-01, 5.136120e-01, 5.136274e-01,
    5.136428e-01, 5.136582e-01, 5.136736e-01, 5.136890e-01, 5.137045e-01, 5.137199e-01,
    5.137353e-01, 5.137507e-01, 5.137661e-01, 5.137815e-01, 5.137970e-01, 5.138124e-01,
    5.138278e-01, 5.138432e-01, 5.138587e-01, 5.138741e-01, 5.138895e-01, 5.139049e-01,
    5.139203e-01, 5.139357e-01, 5.139511e-01, 5.139666e-01, 5.139820e-01, 5.139974e-01,
    5.140128e-01, 5.140283e-01, 5.140436e-01, 5.140591e-01, 5.140744e-01, 5.140899e-01,
    5.141053e-01, 5.141207e-01, 5.141361e-01, 5.141516e-01, 5.141670e-01, 5.141824e-01,
    5.141978e-01, 5.142132e-01, 5.142286e-01, 5.142440e-01, 5.142594e-01, 5.142748e-01,
    5.142903e-01, 5.143057e-01, 5.143211e-01, 5.143365e-01, 5.143519e-01, 5.143673e-01,
    5.143827e-01, 5.143982e-01, 5.144135e-01, 5.144290e-01, 5.144444e-01, 5.144598e-01,
    5.144752e-01, 5.144906e-01, 5.145060e-01, 5.145214e-01, 5.145369e-01, 5.145523e-01,
    5.145677e-01, 5.145831e-01, 5.145985e-01, 5.146139e-01, 5.146293e-01, 5.146447e-01,
    5.146601e-01, 5.146756e-01, 5.146909e-01, 5.147064e-01, 5.147218e-01, 5.147371e-01,
    5.147526e-01, 5.147680e-01, 5.147834e-01, 5.147988e-01, 5.148142e-01, 5.148296e-01,
    5.148450e-01, 5.148604e-01, 5.148758e-01, 5.148913e-01, 5.149066e-01, 5.149220e-01,
    5.149375e-01, 5.149528e-01, 5.149683e-01, 5.149837e-01, 5.149991e-01, 5.150145e-01,
    5.150298e-01, 5.150453e-01, 5.150607e-01, 5.150761e-01, 5.150915e-01, 5.151069e-01,
    5.151223e-01, 5.151377e-01, 5.151531e-01, 5.151685e-01, 5.151839e-01, 5.151993e-01,
    5.152147e-01, 5.152301e-01, 5.152456e-01, 5.152609e-01, 5.152764e-01, 5.152918e-01,
    5.153071e-01, 5.153226e-01, 5.153379e-01, 5.153534e-01, 5.153688e-01, 5.153841e-01,
    5.153995e-01, 5.154150e-01, 5.154304e-01, 5.154458e-01, 5.154611e-01, 5.154765e-01,
    5.154920e-01, 5.155074e-01, 5.155228e-01, 5.155382e-01, 5.155535e-01, 5.155690e-01,
    5.155843e-01, 5.155997e-01, 5.156152e-01, 5.156305e-01, 5.156459e-01, 5.156614e-01,
    5.156767e-01, 5.156921e-01, 5.157075e-01, 5.157229e-01, 5.157384e-01, 5.157537e-01,
    5.157691e-01, 5.157845e-01, 5.157999e-01, 5.158153e-01, 5.158307e-01, 5.158461e-01,
    5.158615e-01, 5.158769e-01, 5.158923e-01, 5.159077e-01, 5.159231e-01, 5.159385e-01,
    5.159539e-01, 5.159693e-01, 5.159847e-01, 5.160000e-01, 5.160155e-01, 5.160308e-01,
    5.160462e-01, 5.160616e-01, 5.160770e-01, 5.160924e-01, 5.161078e-01, 5.161232e-01,
    5.161386e-01, 5.161540e-01, 5.161694e-01, 5.161847e-01, 5.162002e-01, 5.162156e-01,
    5.162309e-01, 5.162463e-01, 5.162618e-01, 5.162771e-01, 5.162925e-01, 5.163079e-01,
    5.163233e-01, 5.163387e-01, 5.163541e-01, 5.163695e-01, 5.163849e-01, 5.164003e-01,
    5.164157e-01, 5.164310e-01, 5.164465e-01, 5.164618e-01, 5.164772e-01, 5.164926e-01,
    5.165080e-01, 5.165234e-01, 5.165387e-01, 5.165542e-01, 5.165696e-01, 5.165849e-01,
    5.166003e-01, 5.166157e-01, 5.166311e-01, 5.166464e-01, 5.166618e-01, 5.166773e-01,
    5.166926e-01, 5.167080e-01, 5.167234e-01, 5.167388e-01, 5.167542e-01, 5.167695e-01,
    5.167850e-01, 5.168003e-01, 5.168157e-01, 5.168311e-01, 5.168465e-01, 5.168619e-01,
    5.168772e-01, 5.168927e-01, 5.169080e-01, 5.169234e-01, 5.169388e-01, 5.169542e-01,
    5.169696e-01, 5.169849e-01, 5.170004e-01, 5.170158e-01, 5.170311e-01, 5.170465e-01,
    5.170619e-01, 5.170773e-01, 5.170926e-01, 5.171080e-01, 5.171234e-01, 5.171388e-01,
    5.171542e-01, 5.171695e-01, 5.171849e-01, 5.172004e-01, 5.172157e-01, 5.172310e-01,
    5.172465e-01, 5.172619e-01, 5.172772e-01, 5.172926e-01, 5.173080e-01, 5.173234e-01,
    5.173388e-01, 5.173541e-01, 5.173695e-01, 5.173849e-01, 5.174003e-01, 5.174156e-01,
    5.174310e-01, 5.174464e-01, 5.174618e-01, 5.174772e-01, 5.174925e-01, 5.175079e-01,
    5.175233e-01, 5.175387e-01, 5.175540e-01, 5.175694e-01, 5.175848e-01, 5.176002e-01,
    5.176156e-01, 5.176309e-01, 5.176463e-01, 5.176617e-01, 5.176771e-01, 5.176924e-01,
    5.177078e-01, 5.177232e-01, 5.177386e-01, 5.177540e-01, 5.177693e-01, 5.177847e-01,
    5.178001e-01, 5.178155e-01, 5.178308e-01, 5.178462e-01, 5.178616e-01, 5.178769e-01,
    5.178924e-01, 5.179077e-01, 5.179231e-01, 5.179384e-01, 5.179538e-01, 5.179692e-01,
    5.179846e-01, 5.179999e-01, 5.180153e-01, 5.180307e-01, 5.180461e-01, 5.180615e-01,
    5.180768e-01, 5.180922e-01, 5.181075e-01, 5.181229e-01, 5.181383e-01, 5.181537e-01,
    5.181690e-01, 5.181844e-01, 5.181997e-01, 5.182152e-01, 5.182305e-01, 5.182459e-01,
    5.182613e-01, 5.182766e-01, 5.182920e-01, 5.183074e-01, 5.183227e-01, 5.183381e-01,
    5.183535e-01, 5.183688e-01, 5.183842e-01, 5.183996e-01, 5.184150e-01, 5.184304e-01,
    5.184457e-01, 5.184610e-01, 5.184764e-01, 5.184918e-01, 5.185072e-01, 5.185226e-01,
    5.185379e-01, 5.185533e-01, 5.185686e-01, 5.185840e-01, 5.185994e-01, 5.186148e-01,
    5.186301e-01, 5.186455e-01, 5.186608e-01, 5.186762e-01, 5.186916e-01, 5.187069e-01,
    5.187223e-01, 5.187377e-01, 5.187531e-01, 5.187684e-01, 5.187837e-01, 5.187991e-01,
    5.188144e-01, 5.188299e-01, 5.188452e-01, 5.188606e-01, 5.188760e-01, 5.188913e-01,
    5.189067e-01, 5.189220e-01, 5.189374e-01, 5.189527e-01, 5.189682e-01, 5.189835e-01,
    5.189989e-01, 5.190142e-01, 5.190296e-01, 5.190449e-01, 5.190603e-01, 5.190757e-01,
    5.190910e-01, 5.191064e-01, 5.191218e-01, 5.191371e-01, 5.191525e-01, 5.191678e-01,
    5.191832e-01, 5.191985e-01, 5.192139e-01, 5.192292e-01, 5.192447e-01, 5.192600e-01,
    5.192754e-01, 5.192907e-01, 5.193061e-01, 5.193214e-01, 5.193368e-01, 5.193521e-01,
    5.193675e-01, 5.193829e-01, 5.193982e-01, 5.194136e-01, 5.194289e-01, 5.194443e-01,
    5.194597e-01, 5.194750e-01, 5.194904e-01, 5.195057e-01, 5.195211e-01, 5.195364e-01,
    5.195518e-01, 5.195671e-01, 5.195825e-01, 5.195978e-01, 5.196132e-01, 5.196286e-01,
    5.196440e-01, 5.196593e-01, 5.196747e-01, 5.196900e-01, 5.197054e-01, 5.197207e-01,
    5.197361e-01, 5.197514e-01, 5.197668e-01, 5.197821e-01, 5.197975e-01, 5.198128e-01,
    5.198282e-01, 5.198435e-01, 5.198589e-01, 5.198742e-01, 5.198896e-01, 5.199050e-01,
    5.199203e-01, 5.199357e-01, 5.199510e-01, 5.199664e-01, 5.199817e-01, 5.199971e-01,
    5.200124e-01, 5.200278e-01, 5.200431e-01, 5.200585e-01, 5.200738e-01, 5.200891e-01,
    5.201045e-01, 5.201198e-01, 5.201352e-01, 5.201505e-01, 5.201659e-01, 5.201812e-01,
    5.201966e-01, 5.202119e-01, 5.202273e-01, 5.202426e-01, 5.202580e-01, 5.202734e-01,
    5.202887e-01, 5.203041e-01, 5.203194e-01, 5.203348e-01, 5.203501e-01, 5.203655e-01,
    5.203808e-01, 5.203962e-01, 5.204115e-01, 5.204269e-01, 5.204422e-01, 5.204576e-01,
    5.204729e-01, 5.204883e-01, 5.205036e-01, 5.205190e-01, 5.205343e-01, 5.205496e-01,
    5.205650e-01, 5.205803e-01, 5.205957e-01, 5.206110e-01, 5.206264e-01, 5.206417e-01,
    5.206571e-01, 5.206724e-01, 5.206878e-01, 5.207031e-01, 5.207184e-01, 5.207338e-01,
    5.207491e-01, 5.207645e-01, 5.207798e-01, 5.207952e-01, 5.208105e-01, 5.208258e-01,
    5.208412e-01, 5.208565e-01, 5.208719e-01, 5.208872e-01, 5.209026e-01, 5.209179e-01,
    5.209332e-01, 5.209486e-01, 5.209639e-01, 5.209793e-01, 5.209945e-01, 5.210099e-01,
    5.210252e-01, 5.210406e-01, 5.210559e-01, 5.210713e-01, 5.210866e-01, 5.211020e-01,
    5.211173e-01, 5.211326e-01, 5.211480e-01, 5.211633e-01, 5.211787e-01, 5.211940e-01,
    5.212094e-01, 5.212247e-01, 5.212401e-01, 5.212554e-01, 5.212707e-01, 5.212860e-01,
    5.213014e-01, 5.213167e-01, 5.213320e-01, 5.213474e-01, 5.213627e-01, 5.213781e-01,
    5.213934e-01, 5.214087e-01, 5.214241e-01, 5.214394e-01, 5.214548e-01, 5.214701e-01,
    5.214854e-01, 5.215008e-01, 5.215161e-01, 5.215314e-01, 5.215468e-01, 5.215621e-01,
    5.215774e-01, 5.215927e-01, 5.216081e-01, 5.216234e-01, 5.216388e-01, 5.216541e-01,
    5.216694e-01, 5.216848e-01, 5.217001e-01, 5.217154e-01, 5.217308e-01, 5.217462e-01,
    5.217614e-01, 5.217768e-01, 5.217921e-01, 5.218074e-01, 5.218228e-01, 5.218381e-01,
    5.218534e-01, 5.218688e-01, 5.218841e-01, 5.218995e-01, 5.219148e-01, 5.219301e-01,
    5.219454e-01, 5.219608e-01, 5.219761e-01, 5.219914e-01, 5.220068e-01, 5.220221e-01,
    5.220374e-01, 5.220527e-01, 5.220681e-01, 5.220834e-01, 5.220987e-01, 5.221140e-01,
    5.221294e-01, 5.221447e-01, 5.221601e-01, 5.221754e-01, 5.221907e-01, 5.222061e-01,
    5.222214e-01, 5.222367e-01, 5.222520e-01, 5.222673e-01, 5.222827e-01, 5.222980e-01,
    5.223134e-01, 5.223286e-01, 5.223440e-01, 5.223593e-01, 5.223746e-01, 5.223899e-01,
    5.224053e-01, 5.224206e-01, 5.224360e-01, 5.224513e-01, 5.224666e-01, 5.224819e-01,
    5.224972e-01, 5.225126e-01, 5.225279e-01, 5.225433e-01, 5.225585e-01, 5.225739e-01,
    5.225892e-01, 5.226045e-01, 5.226198e-01, 5.226352e-01, 5.226505e-01, 5.226658e-01,
    5.226811e-01, 5.226964e-01, 5.227118e-01, 5.227271e-01, 5.227425e-01, 5.227577e-01,
    5.227731e-01, 5.227884e-01, 5.228037e-01, 5.228190e-01, 5.228344e-01, 5.228497e-01,
    5.228650e-01, 5.228803e-01, 5.228956e-01, 5.229110e-01, 5.229263e-01, 5.229416e-01,
    5.229569e-01, 5.229722e-01, 5.229876e-01, 5.230029e-01, 5.230182e-01, 5.230335e-01,
    5.230489e-01, 5.230641e-01, 5.230795e-01, 5.230948e-01, 5.231102e-01, 5.231254e-01,
    5.231407e-01, 5.231561e-01, 5.231714e-01, 5.231867e-01, 5.232021e-01, 5.232174e-01,
    5.232326e-01, 5.232480e-01, 5.232633e-01, 5.232787e-01, 5.232939e-01, 5.233092e-01,
    5.233246e-01, 5.233399e-01, 5.233552e-01, 5.233705e-01, 5.233858e-01, 5.234011e-01,
    5.234165e-01, 5.234318e-01, 5.234471e-01, 5.234624e-01, 5.234777e-01, 5.234931e-01,
    5.235084e-01, 5.235236e-01, 5.235389e-01, 5.235543e-01, 5.235696e-01, 5.235849e-01,
    5.236002e-01, 5.236155e-01, 5.236309e-01, 5.236462e-01, 5.236615e-01, 5.236768e-01,
    5.236921e-01, 5.237074e-01, 5.237227e-01, 5.237380e-01, 5.237534e-01, 5.237687e-01,
    5.237840e-01, 5.237993e-01, 5.238146e-01, 5.238299e-01, 5.238452e-01, 5.238605e-01,
    5.238758e-01, 5.238912e-01, 5.239065e-01, 5.239218e-01, 5.239371e-01, 5.239524e-01,
    5.239677e-01, 5.239830e-01, 5.239983e-01, 5.240136e-01, 5.240290e-01, 5.240443e-01,
    5.240595e-01, 5.240749e-01, 5.240902e-01, 5.241055e-01, 5.241208e-01, 5.241361e-01,
    5.241514e-01, 5.241668e-01, 5.241820e-01, 5.241973e-01, 5.242127e-01, 5.242280e-01,
    5.242433e-01, 5.242586e-01, 5.242739e-01, 5.242892e-01, 5.243045e-01, 5.243198e-01,
    5.243351e-01, 5.243504e-01, 5.243657e-01, 5.243810e-01, 5.243964e-01, 5.244116e-01,
    5.244269e-01, 5.244422e-01, 5.244575e-01, 5.244728e-01, 5.244882e-01, 5.245035e-01,
    5.245187e-01, 5.245340e-01, 5.245494e-01, 5.245647e-01, 5.245800e-01, 5.245953e-01,
    5.246106e-01, 5.246259e-01, 5.246412e-01, 5.246565e-01, 5.246718e-01, 5.246871e-01,
    5.247024e-01, 5.247177e-01, 5.247330e-01, 5.247483e-01, 5.247636e-01, 5.247789e-01,
    5.247942e-01, 5.248095e-01, 5.248248e-01, 5.248401e-01, 5.248554e-01, 5.248707e-01,
    5.248860e-01, 5.249013e-01, 5.249166e-01, 5.249319e-01, 5.249472e-01, 5.249625e-01,
    5.249778e-01, 5.249931e-01, 5.250084e-01, 5.250237e-01, 5.250390e-01, 5.250543e-01,
    5.250696e-01, 5.250849e-01, 5.251002e-01, 5.251155e-01, 5.251308e-01, 5.251461e-01,
    5.251614e-01, 5.251766e-01, 5.251920e-01, 5.252073e-01, 5.252225e-01, 5.252379e-01,
    5.252532e-01, 5.252684e-01, 5.252838e-01, 5.252990e-01, 5.253143e-01, 5.253296e-01,
    5.253449e-01, 5.253602e-01, 5.253755e-01, 5.253908e-01, 5.254061e-01, 5.254214e-01,
    5.254367e-01, 5.254520e-01, 5.254673e-01, 5.254826e-01, 5.254979e-01, 5.255132e-01,
    5.255284e-01, 5.255437e-01, 5.255590e-01, 5.255743e-01, 5.255896e-01, 5.256049e-01,
    5.256202e-01, 5.256355e-01, 5.256508e-01, 5.256661e-01, 5.256814e-01, 5.256966e-01,
    5.257120e-01, 5.257273e-01, 5.257425e-01, 5.257578e-01, 5.257731e-01, 5.257884e-01,
    5.258037e-01, 5.258190e-01, 5.258343e-01, 5.258496e-01, 5.258648e-01, 5.258802e-01,
    5.258954e-01, 5.259107e-01, 5.259261e-01, 5.259413e-01, 5.259566e-01, 5.259719e-01,
    5.259872e-01, 5.260025e-01, 5.260177e-01, 5.260330e-01, 5.260483e-01, 5.260636e-01,
    5.260789e-01, 5.260942e-01, 5.261095e-01, 5.261248e-01, 5.261400e-01, 5.261554e-01,
    5.261706e-01, 5.261859e-01, 5.262012e-01, 5.262164e-01, 5.262318e-01, 5.262470e-01,
    5.262623e-01, 5.262776e-01, 5.262929e-01, 5.263082e-01, 5.263235e-01, 5.263388e-01,
    5.263541e-01, 5.263693e-01, 5.263847e-01, 5.263999e-01, 5.264152e-01, 5.264305e-01,
    5.264457e-01, 5.264611e-01, 5.264763e-01, 5.264916e-01, 5.265068e-01, 5.265222e-01,
    5.265374e-01, 5.265527e-01, 5.265680e-01, 5.265833e-01, 5.265986e-01, 5.266138e-01,
    5.266291e-01, 5.266444e-01, 5.266597e-01, 5.266750e-01, 5.266902e-01, 5.267056e-01,
    5.267208e-01, 5.267361e-01, 5.267514e-01, 5.267667e-01, 5.267820e-01, 5.267972e-01,
    5.268125e-01, 5.268278e-01, 5.268431e-01, 5.268583e-01, 5.268736e-01, 5.268889e-01,
    5.269042e-01, 5.269195e-01, 5.269347e-01, 5.269500e-01, 5.269653e-01, 5.269806e-01,
    5.269958e-01, 5.270111e-01, 5.270264e-01, 5.270417e-01, 5.270569e-01, 5.270722e-01,
    5.270875e-01, 5.271028e-01, 5.271180e-01, 5.271333e-01, 5.271486e-01, 5.271639e-01,
    5.271791e-01, 5.271944e-01, 5.272097e-01, 5.272250e-01, 5.272402e-01, 5.272555e-01,
    5.272708e-01, 5.272861e-01, 5.273014e-01, 5.273166e-01, 5.273319e-01, 5.273471e-01,
    5.273625e-01, 5.273777e-01, 5.273930e-01, 5.274083e-01, 5.274236e-01, 5.274388e-01,
    5.274541e-01, 5.274694e-01, 5.274847e-01, 5.274999e-01, 5.275152e-01, 5.275305e-01,
    5.275458e-01, 5.275610e-01, 5.275763e-01, 5.275916e-01, 5.276068e-01, 5.276221e-01,
    5.276374e-01, 5.276526e-01, 5.276679e-01, 5.276832e-01, 5.276985e-01, 5.277137e-01,
    5.277290e-01, 5.277442e-01, 5.277595e-01, 5.277748e-01, 5.277901e-01, 5.278053e-01,
    5.278206e-01, 5.278358e-01, 5.278511e-01, 5.278664e-01, 5.278817e-01, 5.278969e-01,
    5.279122e-01, 5.279275e-01, 5.279428e-01, 5.279580e-01, 5.279733e-01, 5.279886e-01,
    5.280038e-01, 5.280191e-01, 5.280343e-01, 5.280496e-01, 5.280648e-01, 5.280801e-01,
    5.280954e-01, 5.281106e-01, 5.281259e-01, 5.281412e-01, 5.281565e-01, 5.281717e-01,
    5.281870e-01, 5.282023e-01, 5.282176e-01, 5.282328e-01, 5.282481e-01, 5.282633e-01,
    5.282786e-01, 5.282938e-01, 5.283091e-01, 5.283244e-01, 5.283396e-01, 5.283549e-01,
    5.283702e-01, 5.283855e-01, 5.284007e-01, 5.284160e-01, 5.284312e-01, 5.284465e-01,
    5.284618e-01, 5.284770e-01, 5.284923e-01, 5.285075e-01, 5.285228e-01, 5.285380e-01,
    5.285533e-01, 5.285686e-01, 5.285838e-01, 5.285991e-01, 5.286143e-01, 5.286296e-01,
    5.286449e-01, 5.286601e-01, 5.286754e-01, 5.286906e-01, 5.287060e-01, 5.287212e-01,
    5.287364e-01, 5.287517e-01, 5.287669e-01, 5.287822e-01, 5.287974e-01, 5.288127e-01,
    5.288280e-01, 5.288432e-01, 5.288585e-01, 5.288737e-01, 5.288890e-01, 5.289043e-01,
    5.289195e-01, 5.289348e-01, 5.289500e-01, 5.289653e-01, 5.289806e-01, 5.289958e-01,
    5.290111e-01, 5.290263e-01, 5.290416e-01, 5.290568e-01, 5.290721e-01, 5.290874e-01,
    5.291026e-01, 5.291179e-01, 5.291331e-01, 5.291483e-01, 5.291636e-01, 5.291789e-01,
    5.291941e-01, 5.292094e-01, 5.292246e-01, 5.292399e-01, 5.292552e-01, 5.292704e-01,
    5.292856e-01, 5.293009e-01, 5.293162e-01, 5.293314e-01, 5.293466e-01, 5.293619e-01,
    5.293772e-01, 5.293924e-01, 5.294077e-01, 5.294229e-01, 5.294382e-01, 5.294535e-01,
    5.294687e-01, 5.294839e-01, 5.294992e-01, 5.295144e-01, 5.295297e-01, 5.295449e-01,
    5.295602e-01, 5.295754e-01, 5.295907e-01, 5.296059e-01, 5.296212e-01, 5.296364e-01,
    5.296517e-01, 5.296669e-01, 5.296822e-01, 5.296975e-01, 5.297127e-01, 5.297279e-01,
    5.297432e-01, 5.297584e-01, 5.297737e-01, 5.297890e-01, 5.298042e-01, 5.298194e-01,
    5.298346e-01, 5.298499e-01, 5.298651e-01, 5.298804e-01, 5.298957e-01, 5.299109e-01,
    5.299261e-01, 5.299414e-01, 5.299566e-01, 5.299719e-01, 5.299872e-01, 5.300024e-01,
    5.300176e-01, 5.300329e-01, 5.300481e-01, 5.300633e-01, 5.300786e-01, 5.300938e-01,
    5.301091e-01, 5.301244e-01, 5.301396e-01, 5.301548e-01, 5.301701e-01, 5.301853e-01,
    5.302005e-01, 5.302158e-01, 5.302311e-01, 5.302463e-01, 5.302616e-01, 5.302768e-01,
    5.302920e-01, 5.303072e-01, 5.303225e-01, 5.303378e-01, 5.303530e-01, 5.303682e-01,
    5.303835e-01, 5.303987e-01, 5.304140e-01, 5.304292e-01, 5.304444e-01, 5.304597e-01,
    5.304750e-01, 5.304902e-01, 5.305054e-01, 5.305206e-01, 5.305359e-01, 5.305511e-01,
    5.305663e-01, 5.305816e-01, 5.305969e-01, 5.306121e-01, 5.306273e-01, 5.306426e-01,
    5.306578e-01, 5.306730e-01, 5.306883e-01, 5.307035e-01, 5.307187e-01, 5.307340e-01,
    5.307492e-01, 5.307645e-01, 5.307797e-01, 5.307950e-01, 5.308102e-01, 5.308254e-01,
    5.308406e-01, 5.308559e-01, 5.308712e-01, 5.308864e-01, 5.309016e-01, 5.309169e-01,
    5.309321e-01, 5.309473e-01, 5.309625e-01, 5.309778e-01, 5.309930e-01, 5.310082e-01,
    5.310235e-01, 5.310387e-01, 5.310540e-01, 5.310692e-01, 5.310844e-01, 5.310997e-01,
    5.311149e-01, 5.311301e-01, 5.311454e-01, 5.311606e-01, 5.311758e-01, 5.311911e-01,
    5.312063e-01, 5.312215e-01, 5.312367e-01, 5.312520e-01, 5.312672e-01, 5.312824e-01,
    5.312977e-01, 5.313129e-01, 5.313281e-01, 5.313433e-01, 5.313586e-01, 5.313739e-01,
    5.313891e-01, 5.314043e-01, 5.314196e-01, 5.314348e-01, 5.314500e-01, 5.314652e-01,
    5.314805e-01, 5.314957e-01, 5.315109e-01, 5.315261e-01, 5.315413e-01, 5.315566e-01,
    5.315719e-01, 5.315871e-01, 5.316023e-01, 5.316175e-01, 5.316328e-01, 5.316480e-01,
    5.316632e-01, 5.316784e-01, 5.316936e-01, 5.317089e-01, 5.317242e-01, 5.317394e-01,
    5.317546e-01, 5.317698e-01, 5.317850e-01, 5.318002e-01, 5.318155e-01, 5.318307e-01,
    5.318459e-01, 5.318612e-01, 5.318764e-01, 5.318916e-01, 5.319068e-01, 5.319220e-01,
    5.319373e-01, 5.319525e-01, 5.319678e-01, 5.319830e-01, 5.319982e-01, 5.320134e-01,
    5.320286e-01, 5.320439e-01, 5.320591e-01, 5.320743e-01, 5.320895e-01, 5.321048e-01,
    5.321200e-01, 5.321352e-01, 5.321504e-01, 5.321656e-01, 5.321809e-01, 5.321961e-01,
    5.322113e-01, 5.322266e-01, 5.322418e-01, 5.322570e-01, 5.322722e-01, 5.322874e-01,
    5.323026e-01, 5.323179e-01, 5.323331e-01, 5.323483e-01, 5.323635e-01, 5.323787e-01,
    5.323940e-01, 5.324092e-01, 5.324244e-01, 5.324396e-01, 5.324548e-01, 5.324700e-01,
    5.324853e-01, 5.325005e-01, 5.325157e-01, 5.325310e-01, 5.325462e-01, 5.325614e-01,
    5.325766e-01, 5.325918e-01, 5.326071e-01, 5.326223e-01, 5.326375e-01, 5.326527e-01,
    5.326679e-01, 5.326831e-01, 5.326984e-01, 5.327135e-01, 5.327288e-01, 5.327440e-01,
    5.327592e-01, 5.327744e-01, 5.327896e-01, 5.328048e-01, 5.328201e-01, 5.328353e-01,
    5.328506e-01, 5.328657e-01, 5.328810e-01, 5.328962e-01, 5.329114e-01, 5.329266e-01,
    5.329418e-01, 5.329570e-01, 5.329723e-01, 5.329874e-01, 5.330027e-01, 5.330179e-01,
    5.330331e-01, 5.330483e-01, 5.330635e-01, 5.330787e-01, 5.330939e-01, 5.331091e-01,
    5.331244e-01, 5.331396e-01, 5.331548e-01, 5.331700e-01, 5.331852e-01, 5.332004e-01,
    5.332156e-01, 5.332309e-01, 5.332460e-01, 5.332613e-01, 5.332765e-01, 5.332917e-01,
    5.333070e-01, 5.333221e-01, 5.333374e-01, 5.333526e-01, 5.333678e-01, 5.333830e-01,
    5.333982e-01, 5.334134e-01, 5.334286e-01, 5.334438e-01, 5.334590e-01, 5.334742e-01,
    5.334895e-01, 5.335046e-01, 5.335199e-01, 5.335351e-01, 5.335503e-01, 5.335655e-01,
    5.335807e-01, 5.335959e-01, 5.336111e-01, 5.336263e-01, 5.336415e-01, 5.336567e-01,
    5.336719e-01, 5.336872e-01, 5.337023e-01, 5.337175e-01, 5.337328e-01, 5.337479e-01,
    5.337632e-01, 5.337784e-01, 5.337936e-01, 5.338088e-01, 5.338240e-01, 5.338392e-01,
    5.338544e-01, 5.338696e-01, 5.338848e-01, 5.339000e-01, 5.339152e-01, 5.339304e-01,
    5.339456e-01, 5.339608e-01, 5.339760e-01, 5.339913e-01, 5.340064e-01, 5.340217e-01,
    5.340369e-01, 5.340521e-01, 5.340673e-01, 5.340825e-01, 5.340977e-01, 5.341129e-01,
    5.341281e-01, 5.341433e-01, 5.341585e-01, 5.341737e-01, 5.341889e-01, 5.342041e-01,
    5.342193e-01, 5.342345e-01, 5.342497e-01, 5.342649e-01, 5.342801e-01, 5.342953e-01,
    5.343105e-01, 5.343257e-01, 5.343409e-01, 5.343561e-01, 5.343713e-01, 5.343865e-01,
    5.344017e-01, 5.344169e-01, 5.344321e-01, 5.344473e-01, 5.344625e-01, 5.344777e-01,
    5.344929e-01, 5.345080e-01, 5.345233e-01, 5.345384e-01, 5.345537e-01, 5.345688e-01,
    5.345841e-01, 5.345992e-01, 5.346145e-01, 5.346296e-01, 5.346448e-01, 5.346600e-01,
    5.346752e-01, 5.346904e-01, 5.347056e-01, 5.347208e-01, 5.347360e-01, 5.347512e-01,
    5.347664e-01, 5.347816e-01, 5.347968e-01, 5.348120e-01, 5.348272e-01, 5.348424e-01,
    5.348576e-01, 5.348728e-01, 5.348880e-01, 5.349032e-01, 5.349184e-01, 5.349336e-01,
    5.349488e-01, 5.349640e-01, 5.349791e-01, 5.349944e-01, 5.350095e-01, 5.350247e-01,
    5.350399e-01, 5.350551e-01, 5.350703e-01, 5.350855e-01, 5.351007e-01, 5.351159e-01,
    5.351311e-01, 5.351462e-01, 5.351615e-01, 5.351766e-01, 5.351918e-01, 5.352070e-01,
    5.352222e-01, 5.352374e-01, 5.352526e-01, 5.352678e-01, 5.352830e-01, 5.352982e-01,
    5.353134e-01, 5.353286e-01, 5.353437e-01, 5.353589e-01, 5.353741e-01, 5.353893e-01,
    5.354045e-01, 5.354196e-01, 5.354349e-01, 5.354500e-01, 5.354652e-01, 5.354804e-01,
    5.354956e-01, 5.355108e-01, 5.355260e-01, 5.355412e-01, 5.355564e-01, 5.355716e-01,
    5.355867e-01, 5.356019e-01, 5.356171e-01, 5.356323e-01, 5.356475e-01, 5.356627e-01,
    5.356779e-01, 5.356930e-01, 5.357082e-01, 5.357234e-01, 5.357386e-01, 5.357538e-01,
    5.357689e-01, 5.357842e-01, 5.357993e-01, 5.358145e-01, 5.358297e-01, 5.358449e-01,
    5.358601e-01, 5.358753e-01, 5.358905e-01, 5.359057e-01, 5.359208e-01, 5.359360e-01,
    5.359511e-01, 5.359663e-01, 5.359815e-01, 5.359967e-01, 5.360119e-01, 5.360271e-01,
    5.360423e-01, 5.360575e-01, 5.360726e-01, 5.360878e-01, 5.361030e-01, 5.361181e-01,
    5.361333e-01, 5.361485e-01, 5.361637e-01, 5.361789e-01, 5.361941e-01, 5.362093e-01,
    5.362244e-01, 5.362396e-01, 5.362548e-01, 5.362700e-01, 5.362852e-01, 5.363004e-01,
    5.363155e-01, 5.363307e-01, 5.363458e-01, 5.363610e-01, 5.363762e-01, 5.363914e-01,
    5.364066e-01, 5.364218e-01, 5.364369e-01, 5.364521e-01, 5.364673e-01, 5.364825e-01,
    5.364977e-01, 5.365128e-01, 5.365280e-01, 5.365432e-01, 5.365583e-01, 5.365735e-01,
    5.365887e-01, 5.366039e-01, 5.366191e-01, 5.366343e-01, 5.366494e-01, 5.366646e-01,
    5.366797e-01, 5.366949e-01, 5.367101e-01, 5.367253e-01, 5.367405e-01, 5.367557e-01,
    5.367708e-01, 5.367860e-01, 5.368012e-01, 5.368163e-01, 5.368315e-01, 5.368467e-01,
    5.368618e-01, 5.368770e-01, 5.368922e-01, 5.369074e-01, 5.369226e-01, 5.369378e-01,
    5.369529e-01, 5.369681e-01, 5.369833e-01, 5.369984e-01, 5.370136e-01, 5.370288e-01,
    5.370439e-01, 5.370591e-01, 5.370743e-01, 5.370894e-01, 5.371046e-01, 5.371198e-01,
    5.371349e-01, 5.371501e-01, 5.371653e-01, 5.371805e-01, 5.371956e-01, 5.372108e-01,
    5.372260e-01, 5.372412e-01, 5.372564e-01, 5.372715e-01, 5.372866e-01, 5.373018e-01,
    5.373170e-01, 5.373322e-01, 5.373473e-01, 5.373625e-01, 5.373777e-01, 5.373929e-01,
    5.374080e-01, 5.374232e-01, 5.374383e-01, 5.374535e-01, 5.374687e-01, 5.374838e-01,
    5.374990e-01, 5.375142e-01, 5.375293e-01, 5.375445e-01, 5.375597e-01, 5.375748e-01,
    5.375900e-01, 5.376052e-01, 5.376204e-01, 5.376355e-01, 5.376506e-01, 5.376658e-01,
    5.376810e-01, 5.376961e-01, 5.377113e-01, 5.377265e-01, 5.377417e-01, 5.377568e-01,
    5.377720e-01, 5.377871e-01, 5.378023e-01, 5.378175e-01, 5.378327e-01, 5.378478e-01,
    5.378630e-01, 5.378782e-01, 5.378933e-01, 5.379084e-01, 5.379236e-01, 5.379388e-01,
    5.379540e-01, 5.379691e-01, 5.379843e-01, 5.379995e-01, 5.380146e-01, 5.380297e-01,
    5.380449e-01, 5.380601e-01, 5.380753e-01, 5.380903e-01, 5.381055e-01, 5.381207e-01,
    5.381359e-01, 5.381510e-01, 5.381662e-01, 5.381814e-01, 5.381965e-01, 5.382116e-01,
    5.382268e-01, 5.382420e-01, 5.382572e-01, 5.382723e-01, 5.382875e-01, 5.383027e-01,
    5.383178e-01, 5.383329e-01, 5.383481e-01, 5.383633e-01, 5.383784e-01, 5.383936e-01,
    5.384087e-01, 5.384239e-01, 5.384390e-01, 5.384542e-01, 5.384693e-01, 5.384845e-01,
    5.384997e-01, 5.385149e-01, 5.385299e-01, 5.385451e-01, 5.385603e-01, 5.385755e-01,
    5.385906e-01, 5.386057e-01, 5.386209e-01, 5.386361e-01, 5.386512e-01, 5.386664e-01,
    5.386815e-01, 5.386967e-01, 5.387118e-01, 5.387270e-01, 5.387421e-01, 5.387573e-01,
    5.387725e-01, 5.387876e-01, 5.388027e-01, 5.388179e-01, 5.388331e-01, 5.388482e-01,
    5.388634e-01, 5.388785e-01, 5.388936e-01, 5.389088e-01, 5.389240e-01, 5.389391e-01,
    5.389543e-01, 5.389694e-01, 5.389846e-01, 5.389997e-01, 5.390149e-01, 5.390300e-01,
    5.390452e-01, 5.390604e-01, 5.390755e-01, 5.390906e-01, 5.391058e-01, 5.391209e-01,
    5.391361e-01, 5.391513e-01, 5.391664e-01, 5.391815e-01, 5.391967e-01, 5.392118e-01,
    5.392269e-01, 5.392421e-01, 5.392573e-01, 5.392724e-01, 5.392876e-01, 5.393027e-01,
    5.393178e-01, 5.393330e-01, 5.393482e-01, 5.393633e-01, 5.393785e-01, 5.393936e-01,
    5.394087e-01, 5.394239e-01, 5.394391e-01, 5.394542e-01, 5.394693e-01, 5.394844e-01,
    5.394996e-01, 5.395148e-01, 5.395299e-01, 5.395451e-01, 5.395602e-01, 5.395753e-01,
    5.395905e-01, 5.396056e-01, 5.396208e-01, 5.396360e-01, 5.396511e-01, 5.396662e-01,
    5.396814e-01, 5.396965e-01, 5.397117e-01, 5.397268e-01, 5.397419e-01, 5.397571e-01,
    5.397722e-01, 5.397874e-01, 5.398025e-01, 5.398176e-01, 5.398328e-01, 5.398480e-01,
    5.398631e-01, 5.398782e-01, 5.398933e-01, 5.399085e-01, 5.399237e-01, 5.399388e-01,
    5.399539e-01, 5.399691e-01, 5.399842e-01, 5.399994e-01, 5.400144e-01, 5.400296e-01,
    5.400448e-01, 5.400599e-01, 5.400751e-01, 5.400902e-01, 5.401053e-01, 5.401205e-01,
    5.401356e-01, 5.401507e-01, 5.401659e-01, 5.401810e-01, 5.401962e-01, 5.402113e-01,
    5.402265e-01, 5.402416e-01, 5.402567e-01, 5.402718e-01, 5.402870e-01, 5.403021e-01,
    5.403172e-01, 5.403324e-01, 5.403475e-01, 5.403627e-01, 5.403779e-01, 5.403929e-01,
    5.404081e-01, 5.404232e-01, 5.404384e-01, 5.404535e-01, 5.404686e-01, 5.404838e-01,
    5.404989e-01, 5.405141e-01, 5.405292e-01, 5.405443e-01, 5.405595e-01, 5.405746e-01,
    5.405897e-01, 5.406048e-01, 5.406200e-01, 5.406351e-01, 5.406502e-01, 5.406654e-01,
    5.406805e-01, 5.406957e-01, 5.407108e-01, 5.407259e-01, 5.407410e-01, 5.407562e-01,
    5.407713e-01, 5.407864e-01, 5.408015e-01, 5.408167e-01, 5.408318e-01, 5.408469e-01,
    5.408621e-01, 5.408772e-01, 5.408924e-01, 5.409075e-01, 5.409226e-01, 5.409378e-01,
    5.409529e-01, 5.409680e-01, 5.409831e-01, 5.409983e-01, 5.410134e-01, 5.410285e-01,
    5.410436e-01, 5.410588e-01, 5.410739e-01, 5.410891e-01, 5.411042e-01, 5.411193e-01,
    5.411344e-01, 5.411496e-01, 5.411647e-01, 5.411798e-01, 5.411950e-01, 5.412101e-01,
    5.412252e-01, 5.412403e-01, 5.412555e-01, 5.412706e-01, 5.412858e-01, 5.413008e-01,
    5.413160e-01, 5.413311e-01, 5.413462e-01, 5.413613e-01, 5.413765e-01, 5.413916e-01,
    5.414067e-01, 5.414218e-01, 5.414370e-01, 5.414521e-01, 5.414672e-01, 5.414823e-01,
    5.414975e-01, 5.415126e-01, 5.415277e-01, 5.415428e-01, 5.415580e-01, 5.415731e-01,
    5.415882e-01, 5.416033e-01, 5.416185e-01, 5.416336e-01, 5.416487e-01, 5.416638e-01,
    5.416790e-01, 5.416941e-01, 5.417092e-01, 5.417243e-01, 5.417395e-01, 5.417546e-01,
    5.417697e-01, 5.417848e-01, 5.418000e-01, 5.418150e-01, 5.418302e-01, 5.418453e-01,
    5.418604e-01, 5.418755e-01, 5.418907e-01, 5.419058e-01, 5.419209e-01, 5.419360e-01,
    5.419511e-01, 5.419663e-01, 5.419814e-01, 5.419965e-01, 5.420116e-01, 5.420268e-01,
    5.420418e-01, 5.420570e-01, 5.420721e-01, 5.420872e-01, 5.421023e-01, 5.421175e-01,
    5.421326e-01, 5.421477e-01, 5.421628e-01, 5.421779e-01, 5.421931e-01, 5.422081e-01,
    5.422233e-01, 5.422384e-01, 5.422535e-01, 5.422686e-01, 5.422837e-01, 5.422989e-01,
    5.423140e-01, 5.423291e-01, 5.423442e-01, 5.423594e-01, 5.423744e-01, 5.423896e-01,
    5.424047e-01, 5.424198e-01, 5.424349e-01, 5.424500e-01, 5.424652e-01, 5.424802e-01,
    5.424954e-01, 5.425104e-01, 5.425256e-01, 5.425407e-01, 5.425558e-01, 5.425709e-01,
    5.425860e-01, 5.426012e-01, 5.426162e-01, 5.426314e-01, 5.426465e-01, 5.426616e-01,
    5.426767e-01, 5.426918e-01, 5.427070e-01, 5.427220e-01, 5.427372e-01, 5.427523e-01,
    5.427674e-01, 5.427825e-01, 5.427976e-01, 5.428127e-01, 5.428278e-01, 5.428429e-01,
    5.428581e-01, 5.428731e-01, 5.428883e-01, 5.429034e-01, 5.429185e-01, 5.429336e-01,
    5.429487e-01, 5.429639e-01, 5.429789e-01, 5.429940e-01, 5.430092e-01, 5.430242e-01,
    5.430394e-01, 5.430545e-01, 5.430696e-01, 5.430847e-01, 5.430998e-01, 5.431150e-01,
    5.431300e-01, 5.431451e-01, 5.431603e-01, 5.431753e-01, 5.431904e-01, 5.432056e-01,
    5.432206e-01, 5.432358e-01, 5.432509e-01, 5.432660e-01, 5.432811e-01, 5.432962e-01,
    5.433113e-01, 5.433264e-01, 5.433415e-01, 5.433566e-01, 5.433717e-01, 5.433868e-01,
    5.434020e-01, 5.434170e-01, 5.434322e-01, 5.434473e-01, 5.434623e-01, 5.434775e-01,
    5.434926e-01, 5.435076e-01, 5.435228e-01, 5.435379e-01, 5.435530e-01, 5.435681e-01,
    5.435832e-01, 5.435983e-01, 5.436134e-01, 5.436285e-01, 5.436436e-01, 5.436587e-01,
    5.436738e-01, 5.436889e-01, 5.437040e-01, 5.437191e-01, 5.437342e-01, 5.437493e-01,
    5.437644e-01, 5.437795e-01, 5.437946e-01, 5.438097e-01, 5.438248e-01, 5.438399e-01,
    5.438550e-01, 5.438701e-01, 5.438852e-01, 5.439003e-01, 5.439155e-01, 5.439305e-01,
    5.439456e-01, 5.439607e-01, 5.439758e-01, 5.439909e-01, 5.440060e-01, 5.440211e-01,
    5.440362e-01, 5.440513e-01, 5.440664e-01, 5.440814e-01, 5.440966e-01, 5.441117e-01,
    5.441268e-01, 5.441419e-01, 5.441570e-01, 5.441720e-01, 5.441872e-01, 5.442023e-01,
    5.442173e-01, 5.442325e-01, 5.442476e-01, 5.442626e-01, 5.442777e-01, 5.442929e-01,
    5.443079e-01, 5.443230e-01, 5.443381e-01, 5.443532e-01, 5.443683e-01, 5.443834e-01,
    5.443985e-01, 5.444136e-01, 5.444287e-01, 5.444438e-01, 5.444589e-01, 5.444740e-01,
    5.444891e-01, 5.445042e-01, 5.445192e-01, 5.445343e-01, 5.445495e-01, 5.445645e-01,
    5.445796e-01, 5.445947e-01, 5.446098e-01, 5.446249e-01, 5.446400e-01, 5.446551e-01,
    5.446702e-01, 5.446852e-01, 5.447004e-01, 5.447155e-01, 5.447305e-01, 5.447456e-01,
    5.447607e-01, 5.447758e-01, 5.447909e-01, 5.448060e-01, 5.448211e-01, 5.448362e-01,
    5.448512e-01, 5.448664e-01, 5.448815e-01, 5.448965e-01, 5.449116e-01, 5.449267e-01,
    5.449418e-01, 5.449569e-01, 5.449719e-01, 5.449870e-01, 5.450022e-01, 5.450172e-01,
    5.450323e-01, 5.450474e-01, 5.450625e-01, 5.450776e-01, 5.450927e-01, 5.451078e-01,
    5.451228e-01, 5.451379e-01, 5.451530e-01, 5.451681e-01, 5.451832e-01, 5.451983e-01,
    5.452134e-01, 5.452285e-01, 5.452435e-01, 5.452586e-01, 5.452737e-01, 5.452888e-01,
    5.453039e-01, 5.453190e-01, 5.453340e-01, 5.453491e-01, 5.453642e-01, 5.453793e-01,
    5.453944e-01, 5.454095e-01, 5.454246e-01, 5.454396e-01, 5.454547e-01, 5.454698e-01,
    5.454849e-01, 5.455000e-01, 5.455151e-01, 5.455301e-01, 5.455452e-01, 5.455603e-01,
    5.455754e-01, 5.455905e-01, 5.456055e-01, 5.456206e-01, 5.456357e-01, 5.456508e-01,
    5.456659e-01, 5.456809e-01, 5.456960e-01, 5.457111e-01, 5.457262e-01, 5.457413e-01,
    5.457564e-01, 5.457714e-01, 5.457865e-01, 5.458016e-01, 5.458167e-01, 5.458317e-01,
    5.458468e-01, 5.458619e-01, 5.458770e-01, 5.458921e-01, 5.459071e-01, 5.459222e-01,
    5.459373e-01, 5.459524e-01, 5.459675e-01, 5.459825e-01, 5.459976e-01, 5.460127e-01,
    5.460278e-01, 5.460429e-01, 5.460579e-01, 5.460730e-01, 5.460881e-01, 5.461032e-01,
    5.461182e-01, 5.461333e-01, 5.461484e-01, 5.461634e-01, 5.461785e-01, 5.461936e-01,
    5.462087e-01, 5.462238e-01, 5.462388e-01, 5.462539e-01, 5.462690e-01, 5.462841e-01,
    5.462992e-01, 5.463142e-01, 5.463293e-01, 5.463444e-01, 5.463594e-01, 5.463745e-01,
    5.463896e-01, 5.464047e-01, 5.464197e-01, 5.464348e-01, 5.464499e-01, 5.464649e-01,
    5.464801e-01, 5.464951e-01, 5.465102e-01, 5.465252e-01, 5.465403e-01, 5.465554e-01,
    5.465705e-01, 5.465856e-01, 5.466006e-01, 5.466157e-01, 5.466307e-01, 5.466458e-01,
    5.466609e-01, 5.466760e-01, 5.466910e-01, 5.467061e-01, 5.467212e-01, 5.467362e-01,
    5.467513e-01, 5.467664e-01, 5.467814e-01, 5.467965e-01, 5.468116e-01, 5.468267e-01,
    5.468417e-01, 5.468568e-01, 5.468718e-01, 5.468869e-01, 5.469020e-01, 5.469171e-01,
    5.469321e-01, 5.469472e-01, 5.469623e-01, 5.469773e-01, 5.469924e-01, 5.470074e-01,
    5.470225e-01, 5.470376e-01, 5.470526e-01, 5.470678e-01, 5.470828e-01, 5.470979e-01,
    5.471129e-01, 5.471280e-01, 5.471430e-01, 5.471581e-01, 5.471732e-01, 5.471883e-01,
    5.472033e-01, 5.472184e-01, 5.472335e-01, 5.472485e-01, 5.472636e-01, 5.472786e-01,
    5.472937e-01, 5.473087e-01, 5.473238e-01, 5.473389e-01, 5.473540e-01, 5.473690e-01,
    5.473841e-01, 5.473992e-01, 5.474142e-01, 5.474293e-01, 5.474443e-01, 5.474594e-01,
    5.474745e-01, 5.474895e-01, 5.475046e-01, 5.475197e-01, 5.475347e-01, 5.475498e-01,
    5.475649e-01, 5.475799e-01, 5.475950e-01, 5.476100e-01, 5.476251e-01, 5.476401e-01,
    5.476552e-01, 5.476703e-01, 5.476853e-01, 5.477004e-01, 5.477154e-01, 5.477305e-01,
    5.477456e-01, 5.477606e-01, 5.477757e-01, 5.477908e-01, 5.478058e-01, 5.478209e-01,
    5.478359e-01, 5.478510e-01, 5.478660e-01, 5.478811e-01, 5.478961e-01, 5.479112e-01,
    5.479262e-01, 5.479413e-01, 5.479563e-01, 5.479714e-01, 5.479865e-01, 5.480016e-01,
    5.480166e-01, 5.480317e-01, 5.480467e-01, 5.480617e-01, 5.480769e-01, 5.480919e-01,
    5.481070e-01, 5.481220e-01, 5.481371e-01, 5.481521e-01, 5.481672e-01, 5.481822e-01,
    5.481973e-01, 5.482123e-01, 5.482274e-01, 5.482424e-01, 5.482575e-01, 5.482726e-01,
    5.482876e-01, 5.483027e-01, 5.483177e-01, 5.483328e-01, 5.483478e-01, 5.483629e-01,
    5.483779e-01, 5.483930e-01, 5.484080e-01, 5.484231e-01, 5.484381e-01, 5.484532e-01,
    5.484682e-01, 5.484833e-01, 5.484983e-01, 5.485134e-01, 5.485284e-01, 5.485435e-01,
    5.485585e-01, 5.485736e-01, 5.485886e-01, 5.486037e-01, 5.486187e-01, 5.486338e-01,
    5.486488e-01, 5.486639e-01, 5.486789e-01, 5.486940e-01, 5.487090e-01, 5.487241e-01,
    5.487391e-01, 5.487542e-01, 5.487692e-01, 5.487843e-01, 5.487993e-01, 5.488144e-01,
    5.488294e-01, 5.488445e-01, 5.488595e-01, 5.488746e-01, 5.488896e-01, 5.489047e-01,
    5.489197e-01, 5.489348e-01, 5.489498e-01, 5.489649e-01, 5.489799e-01, 5.489950e-01,
    5.490100e-01, 5.490251e-01, 5.490401e-01, 5.490551e-01, 5.490702e-01, 5.490852e-01,
    5.491003e-01, 5.491153e-01, 5.491304e-01, 5.491454e-01, 5.491605e-01, 5.491755e-01,
    5.491905e-01, 5.492055e-01, 5.492206e-01, 5.492356e-01, 5.492507e-01, 5.492657e-01,
    5.492808e-01, 5.492958e-01, 5.493109e-01, 5.493259e-01, 5.493410e-01, 5.493560e-01,
    5.493711e-01, 5.493861e-01, 5.494012e-01, 5.494162e-01, 5.494312e-01, 5.494463e-01,
    5.494613e-01, 5.494764e-01, 5.494914e-01, 5.495064e-01, 5.495214e-01, 5.495365e-01,
    5.495515e-01, 5.495666e-01, 5.495816e-01, 5.495967e-01, 5.496117e-01, 5.496268e-01,
    5.496418e-01, 5.496569e-01, 5.496718e-01, 5.496869e-01, 5.497019e-01, 5.497170e-01,
    5.497320e-01, 5.497470e-01, 5.497621e-01, 5.497772e-01, 5.497922e-01, 5.498072e-01,
    5.498223e-01, 5.498373e-01, 5.498524e-01, 5.498673e-01, 5.498824e-01, 5.498974e-01,
    5.499125e-01, 5.499275e-01, 5.499426e-01, 5.499576e-01, 5.499726e-01, 5.499877e-01,
    5.500027e-01, 5.500178e-01, 5.500327e-01, 5.500478e-01, 5.500628e-01, 5.500779e-01,
    5.500929e-01, 5.501080e-01, 5.501230e-01, 5.501380e-01, 5.501531e-01, 5.501681e-01,
    5.501831e-01, 5.501981e-01, 5.502132e-01, 5.502282e-01, 5.502433e-01, 5.502583e-01,
    5.502733e-01, 5.502884e-01, 5.503034e-01, 5.503184e-01, 5.503334e-01, 5.503485e-01,
    5.503635e-01, 5.503786e-01, 5.503936e-01, 5.504086e-01, 5.504236e-01, 5.504387e-01,
    5.504537e-01, 5.504687e-01, 5.504838e-01, 5.504988e-01, 5.505139e-01, 5.505288e-01,
    5.505439e-01, 5.505589e-01, 5.505739e-01, 5.505890e-01, 5.506040e-01, 5.506191e-01,
    5.506341e-01, 5.506491e-01, 5.506641e-01, 5.506791e-01, 5.506942e-01, 5.507092e-01,
    5.507243e-01, 5.507393e-01, 5.507543e-01, 5.507693e-01, 5.507843e-01, 5.507994e-01,
    5.508144e-01, 5.508294e-01, 5.508445e-01, 5.508595e-01, 5.508745e-01, 5.508896e-01,
    5.509046e-01, 5.509196e-01, 5.509346e-01, 5.509496e-01, 5.509647e-01, 5.509797e-01,
    5.509947e-01, 5.510098e-01, 5.510247e-01, 5.510398e-01, 5.510548e-01, 5.510699e-01,
    5.510849e-01, 5.510999e-01, 5.511149e-01, 5.511300e-01, 5.511450e-01, 5.511600e-01,
    5.511751e-01, 5.511900e-01, 5.512051e-01, 5.512201e-01, 5.512351e-01, 5.512502e-01,
    5.512651e-01, 5.512802e-01, 5.512952e-01, 5.513102e-01, 5.513253e-01, 5.513403e-01,
    5.513553e-01, 5.513703e-01, 5.513853e-01, 5.514004e-01, 5.514154e-01, 5.514304e-01,
    5.514454e-01, 5.514604e-01, 5.514755e-01, 5.514905e-01, 5.515055e-01, 5.515205e-01,
    5.515355e-01, 5.515506e-01, 5.515656e-01, 5.515806e-01, 5.515956e-01, 5.516106e-01,
    5.516257e-01, 5.516407e-01, 5.516557e-01, 5.516707e-01, 5.516858e-01, 5.517007e-01,
    5.517158e-01, 5.517308e-01, 5.517458e-01, 5.517608e-01, 5.517759e-01, 5.517908e-01,
    5.518059e-01, 5.518209e-01, 5.518359e-01, 5.518509e-01, 5.518659e-01, 5.518810e-01,
    5.518960e-01, 5.519110e-01, 5.519260e-01, 5.519410e-01, 5.519561e-01, 5.519711e-01,
    5.519860e-01, 5.520011e-01, 5.520161e-01, 5.520311e-01, 5.520461e-01, 5.520611e-01,
    5.520762e-01, 5.520912e-01, 5.521062e-01, 5.521212e-01, 5.521362e-01, 5.521513e-01,
    5.521662e-01, 5.521812e-01, 5.521963e-01, 5.522113e-01, 5.522262e-01, 5.522413e-01,
    5.522563e-01, 5.522713e-01, 5.522863e-01, 5.523013e-01, 5.523164e-01, 5.523313e-01,
    5.523464e-01, 5.523614e-01, 5.523764e-01, 5.523914e-01, 5.524064e-01, 5.524215e-01,
    5.524364e-01, 5.524515e-01, 5.524665e-01, 5.524815e-01, 5.524965e-01, 5.525115e-01,
    5.525265e-01, 5.525415e-01, 5.525565e-01, 5.525715e-01, 5.525866e-01, 5.526015e-01,
    5.526166e-01, 5.526316e-01, 5.526466e-01, 5.526616e-01, 5.526766e-01, 5.526916e-01,
    5.527066e-01, 5.527216e-01, 5.527366e-01, 5.527517e-01, 5.527666e-01, 5.527816e-01,
    5.527967e-01, 5.528117e-01, 5.528266e-01, 5.528417e-01, 5.528567e-01, 5.528717e-01,
    5.528867e-01, 5.529017e-01, 5.529167e-01, 5.529317e-01, 5.529467e-01, 5.529617e-01,
    5.529767e-01, 5.529917e-01, 5.530067e-01, 5.530217e-01, 5.530367e-01, 5.530518e-01,
    5.530667e-01, 5.530818e-01, 5.530968e-01, 5.531118e-01, 5.531268e-01, 5.531418e-01,
    5.531568e-01, 5.531718e-01, 5.531868e-01, 5.532018e-01, 5.532168e-01, 5.532318e-01,
    5.532468e-01, 5.532618e-01, 5.532768e-01, 5.532918e-01, 5.533068e-01, 5.533218e-01,
    5.533368e-01, 5.533518e-01, 5.533668e-01, 5.533818e-01, 5.533968e-01, 5.534118e-01,
    5.534268e-01, 5.534418e-01, 5.534568e-01, 5.534718e-01, 5.534868e-01, 5.535018e-01,
    5.535168e-01, 5.535318e-01, 5.535468e-01, 5.535618e-01, 5.535768e-01, 5.535918e-01,
    5.536067e-01, 5.536218e-01, 5.536368e-01, 5.536518e-01, 5.536668e-01, 5.536818e-01,
    5.536968e-01, 5.537118e-01, 5.537268e-01, 5.537418e-01, 5.537568e-01, 5.537717e-01,
    5.537868e-01, 5.538018e-01, 5.538168e-01, 5.538318e-01, 5.538467e-01, 5.538617e-01,
    5.538768e-01, 5.538918e-01, 5.539067e-01, 5.539217e-01, 5.539367e-01, 5.539517e-01,
    5.539667e-01, 5.539817e-01, 5.539967e-01, 5.540117e-01, 5.540267e-01, 5.540417e-01,
    5.540567e-01, 5.540717e-01, 5.540866e-01, 5.541016e-01, 5.541167e-01, 5.541316e-01,
    5.541466e-01, 5.541616e-01, 5.541766e-01, 5.541916e-01, 5.542066e-01, 5.542216e-01,
    5.542366e-01, 5.542516e-01, 5.542666e-01, 5.542815e-01, 5.542966e-01, 5.543116e-01,
    5.543265e-01, 5.543416e-01, 5.543565e-01, 5.543715e-01, 5.543865e-01, 5.544015e-01,
    5.544165e-01, 5.544315e-01, 5.544465e-01, 5.544614e-01, 5.544764e-01, 5.544914e-01,
    5.545064e-01, 5.545214e-01, 5.545364e-01, 5.545514e-01, 5.545664e-01, 5.545813e-01,
    5.545964e-01, 5.546113e-01, 5.546263e-01, 5.546413e-01, 5.546563e-01, 5.546713e-01,
    5.546862e-01, 5.547013e-01, 5.547162e-01, 5.547312e-01, 5.547462e-01, 5.547612e-01,
    5.547762e-01, 5.547912e-01, 5.548061e-01, 5.548211e-01, 5.548362e-01, 5.548511e-01,
    5.548661e-01, 5.548811e-01, 5.548961e-01, 5.549111e-01, 5.549260e-01, 5.549410e-01,
    5.549560e-01, 5.549710e-01, 5.549860e-01, 5.550010e-01, 5.550160e-01, 5.550309e-01,
    5.550459e-01, 5.550609e-01, 5.550759e-01, 5.550908e-01, 5.551059e-01, 5.551208e-01,
    5.551358e-01, 5.551508e-01, 5.551658e-01, 5.551808e-01, 5.551957e-01, 5.552107e-01,
    5.552257e-01, 5.552407e-01, 5.552557e-01, 5.552707e-01, 5.552856e-01, 5.553006e-01,
    5.553156e-01, 5.553306e-01, 5.553455e-01, 5.553606e-01, 5.553755e-01, 5.553905e-01,
    5.554054e-01, 5.554205e-01, 5.554354e-01, 5.554504e-01, 5.554654e-01, 5.554804e-01,
    5.554954e-01, 5.555103e-01, 5.555253e-01, 5.555403e-01, 5.555553e-01, 5.555702e-01,
    5.555852e-01, 5.556002e-01, 5.556152e-01, 5.556301e-01, 5.556451e-01, 5.556601e-01,
    5.556751e-01, 5.556901e-01, 5.557051e-01, 5.557200e-01, 5.557350e-01, 5.557500e-01,
    5.557650e-01, 5.557799e-01, 5.557949e-01, 5.558099e-01, 5.558248e-01, 5.558398e-01,
    5.558548e-01, 5.558698e-01, 5.558847e-01, 5.558997e-01, 5.559147e-01, 5.559297e-01,
    5.559446e-01, 5.559596e-01, 5.559746e-01, 5.559896e-01, 5.560045e-01, 5.560195e-01,
    5.560345e-01, 5.560495e-01, 5.560644e-01, 5.560794e-01, 5.560943e-01, 5.561094e-01,
    5.561243e-01, 5.561393e-01, 5.561543e-01, 5.561692e-01, 5.561842e-01, 5.561991e-01,
    5.562142e-01, 5.562291e-01, 5.562441e-01, 5.562590e-01, 5.562740e-01, 5.562890e-01,
    5.563040e-01, 5.563189e-01, 5.563339e-01, 5.563489e-01, 5.563638e-01, 5.563788e-01,
    5.563938e-01, 5.564088e-01, 5.564237e-01, 5.564387e-01, 5.564536e-01, 5.564686e-01,
    5.564836e-01, 5.564986e-01, 5.565135e-01, 5.565285e-01, 5.565435e-01, 5.565584e-01,
    5.565734e-01, 5.565884e-01, 5.566034e-01, 5.566183e-01, 5.566333e-01, 5.566483e-01,
    5.566632e-01, 5.566782e-01, 5.566931e-01, 5.567081e-01, 5.567231e-01, 5.567380e-01,
    5.567530e-01, 5.567680e-01, 5.567830e-01, 5.567979e-01, 5.568129e-01, 5.568278e-01,
    5.568428e-01, 5.568578e-01, 5.568727e-01, 5.568877e-01, 5.569026e-01, 5.569176e-01,
    5.569326e-01, 5.569475e-01, 5.569625e-01, 5.569775e-01, 5.569924e-01, 5.570074e-01,
    5.570223e-01, 5.570373e-01, 5.570523e-01, 5.570672e-01, 5.570822e-01, 5.570971e-01,
    5.571121e-01, 5.571271e-01, 5.571421e-01, 5.571570e-01, 5.571720e-01, 5.571870e-01,
    5.572019e-01, 5.572169e-01, 5.572318e-01, 5.572468e-01, 5.572618e-01, 5.572767e-01,
    5.572917e-01, 5.573066e-01, 5.573216e-01, 5.573366e-01, 5.573515e-01, 5.573664e-01,
    5.573814e-01, 5.573964e-01, 5.574113e-01, 5.574263e-01, 5.574412e-01, 5.574562e-01,
    5.574712e-01, 5.574862e-01, 5.575011e-01, 5.575161e-01, 5.575310e-01, 5.575460e-01,
    5.575609e-01, 5.575759e-01, 5.575908e-01, 5.576058e-01, 5.576208e-01, 5.576357e-01,
    5.576506e-01, 5.576656e-01, 5.576805e-01, 5.576955e-01, 5.577105e-01, 5.577255e-01,
    5.577404e-01, 5.577554e-01, 5.577703e-01, 5.577853e-01, 5.578002e-01, 5.578152e-01,
    5.578301e-01, 5.578451e-01, 5.578600e-01, 5.578750e-01, 5.578899e-01, 5.579049e-01,
    5.579199e-01, 5.579348e-01, 5.579498e-01, 5.579647e-01, 5.579796e-01, 5.579946e-01,
    5.580096e-01, 5.580245e-01, 5.580395e-01, 5.580544e-01, 5.580694e-01, 5.580844e-01,
    5.580993e-01, 5.581142e-01, 5.581292e-01, 5.581442e-01, 5.581591e-01, 5.581740e-01,
    5.581890e-01, 5.582039e-01, 5.582189e-01, 5.582339e-01, 5.582488e-01, 5.582638e-01,
    5.582787e-01, 5.582936e-01, 5.583086e-01, 5.583235e-01, 5.583385e-01, 5.583535e-01,
    5.583684e-01, 5.583833e-01, 5.583983e-01, 5.584132e-01, 5.584282e-01, 5.584431e-01,
    5.584581e-01, 5.584731e-01, 5.584880e-01, 5.585029e-01, 5.585179e-01, 5.585328e-01,
    5.585477e-01, 5.585627e-01, 5.585777e-01, 5.585926e-01, 5.586076e-01, 5.586225e-01,
    5.586374e-01, 5.586524e-01, 5.586673e-01, 5.586823e-01, 5.586972e-01, 5.587122e-01,
    5.587271e-01, 5.587420e-01, 5.587570e-01, 5.587720e-01, 5.587869e-01, 5.588018e-01,
    5.588168e-01, 5.588318e-01, 5.588467e-01, 5.588616e-01, 5.588766e-01, 5.588915e-01,
    5.589064e-01, 5.589214e-01, 5.589364e-01, 5.589513e-01, 5.589662e-01, 5.589811e-01,
    5.589961e-01, 5.590110e-01, 5.590260e-01, 5.590410e-01, 5.590559e-01, 5.590708e-01,
    5.590858e-01, 5.591007e-01, 5.591156e-01, 5.591306e-01, 5.591455e-01, 5.591605e-01,
    5.591754e-01, 5.591904e-01, 5.592053e-01, 5.592203e-01, 5.592352e-01, 5.592501e-01,
    5.592651e-01, 5.592800e-01, 5.592949e-01, 5.593098e-01, 5.593248e-01, 5.593398e-01,
    5.593547e-01, 5.593696e-01, 5.593846e-01, 5.593995e-01, 5.594144e-01, 5.594294e-01,
    5.594443e-01, 5.594593e-01, 5.594742e-01, 5.594891e-01, 5.595041e-01, 5.595190e-01,
    5.595340e-01, 5.595489e-01, 5.595638e-01, 5.595787e-01, 5.595937e-01, 5.596086e-01,
    5.596235e-01, 5.596384e-01, 5.596534e-01, 5.596684e-01, 5.596833e-01, 5.596982e-01,
    5.597131e-01, 5.597281e-01, 5.597430e-01, 5.597579e-01, 5.597729e-01, 5.597878e-01,
    5.598028e-01, 5.598177e-01, 5.598326e-01, 5.598475e-01, 5.598625e-01, 5.598775e-01,
    5.598924e-01, 5.599073e-01, 5.599222e-01, 5.599372e-01, 5.599521e-01, 5.599670e-01,
    5.599819e-01, 5.599969e-01, 5.600119e-01, 5.600268e-01, 5.600417e-01, 5.600566e-01,
    5.600716e-01, 5.600865e-01, 5.601014e-01, 5.601164e-01, 5.601313e-01, 5.601462e-01,
    5.601612e-01, 5.601761e-01, 5.601910e-01, 5.602059e-01, 5.602208e-01, 5.602358e-01,
    5.602507e-01, 5.602657e-01, 5.602806e-01, 5.602955e-01, 5.603104e-01, 5.603254e-01,
    5.603403e-01, 5.603552e-01, 5.603701e-01, 5.603851e-01, 5.604000e-01, 5.604149e-01,
    5.604299e-01, 5.604448e-01, 5.604597e-01, 5.604746e-01, 5.604896e-01, 5.605045e-01,
    5.605195e-01, 5.605344e-01, 5.605493e-01, 5.605642e-01, 5.605791e-01, 5.605940e-01,
    5.606090e-01, 5.606239e-01, 5.606388e-01, 5.606537e-01, 5.606687e-01, 5.606836e-01,
    5.606985e-01, 5.607135e-01, 5.607284e-01, 5.607433e-01, 5.607582e-01, 5.607732e-01,
    5.607881e-01, 5.608030e-01, 5.608179e-01, 5.608329e-01, 5.608478e-01, 5.608627e-01,
    5.608776e-01, 5.608926e-01, 5.609075e-01, 5.609224e-01, 5.609373e-01, 5.609522e-01,
    5.609671e-01, 5.609821e-01, 5.609970e-01, 5.610119e-01, 5.610268e-01, 5.610418e-01,
    5.610567e-01, 5.610716e-01, 5.610865e-01, 5.611014e-01, 5.611163e-01, 5.611313e-01,
    5.611462e-01, 5.611611e-01, 5.611761e-01, 5.611910e-01, 5.612059e-01, 5.612208e-01,
    5.612357e-01, 5.612506e-01, 5.612655e-01, 5.612805e-01, 5.612954e-01, 5.613103e-01,
    5.613253e-01, 5.613402e-01, 5.613551e-01, 5.613700e-01, 5.613849e-01, 5.613998e-01,
    5.614147e-01, 5.614297e-01, 5.614446e-01, 5.614595e-01, 5.614744e-01, 5.614893e-01,
    5.615042e-01, 5.615192e-01, 5.615340e-01, 5.615490e-01, 5.615639e-01, 5.615788e-01,
    5.615937e-01, 5.616087e-01, 5.616236e-01, 5.616385e-01, 5.616534e-01, 5.616683e-01,
    5.616832e-01, 5.616981e-01, 5.617130e-01, 5.617279e-01, 5.617429e-01, 5.617578e-01,
    5.617727e-01, 5.617877e-01, 5.618026e-01, 5.618175e-01, 5.618324e-01, 5.618473e-01,
    5.618622e-01, 5.618771e-01, 5.618920e-01, 5.619069e-01, 5.619218e-01, 5.619367e-01,
    5.619517e-01, 5.619666e-01, 5.619815e-01, 5.619964e-01, 5.620113e-01, 5.620262e-01,
    5.620412e-01, 5.620561e-01, 5.620710e-01, 5.620859e-01, 5.621008e-01, 5.621157e-01,
    5.621306e-01, 5.621455e-01, 5.621604e-01, 5.621753e-01, 5.621902e-01, 5.622051e-01,
    5.622200e-01, 5.622350e-01, 5.622499e-01, 5.622648e-01, 5.622797e-01, 5.622946e-01,
    5.623095e-01, 5.623244e-01, 5.623393e-01, 5.623543e-01, 5.623691e-01, 5.623841e-01,
    5.623990e-01, 5.624139e-01, 5.624288e-01, 5.624437e-01, 5.624586e-01, 5.624735e-01,
    5.624884e-01, 5.625033e-01, 5.625182e-01, 5.625331e-01, 5.625480e-01, 5.625629e-01,
    5.625778e-01, 5.625927e-01, 5.626076e-01, 5.626225e-01, 5.626374e-01, 5.626523e-01,
    5.626673e-01, 5.626822e-01, 5.626971e-01, 5.627120e-01, 5.627269e-01, 5.627418e-01,
    5.627567e-01, 5.627716e-01, 5.627865e-01, 5.628014e-01, 5.628163e-01, 5.628312e-01,
    5.628461e-01, 5.628610e-01, 5.628759e-01, 5.628908e-01, 5.629057e-01, 5.629206e-01,
    5.629355e-01, 5.629504e-01, 5.629653e-01, 5.629802e-01, 5.629951e-01, 5.630100e-01,
    5.630249e-01, 5.630398e-01, 5.630547e-01, 5.630696e-01, 5.630845e-01, 5.630994e-01,
    5.631143e-01, 5.631292e-01, 5.631441e-01, 5.631590e-01, 5.631739e-01, 5.631889e-01,
    5.632037e-01, 5.632187e-01, 5.632335e-01, 5.632484e-01, 5.632633e-01, 5.632782e-01,
    5.632931e-01, 5.633080e-01, 5.633229e-01, 5.633378e-01, 5.633527e-01, 5.633676e-01,
    5.633825e-01, 5.633974e-01, 5.634123e-01, 5.634272e-01, 5.634421e-01, 5.634570e-01,
    5.634719e-01, 5.634868e-01, 5.635017e-01, 5.635166e-01, 5.635315e-01, 5.635464e-01,
    5.635613e-01, 5.635762e-01, 5.635911e-01, 5.636060e-01, 5.636208e-01, 5.636357e-01,
    5.636506e-01, 5.636655e-01, 5.636804e-01, 5.636953e-01, 5.637102e-01, 5.637251e-01,
    5.637400e-01, 5.637549e-01, 5.637698e-01, 5.637847e-01, 5.637996e-01, 5.638145e-01,
    5.638294e-01, 5.638442e-01, 5.638592e-01, 5.638740e-01, 5.638889e-01, 5.639038e-01,
    5.639187e-01, 5.639336e-01, 5.639485e-01, 5.639634e-01, 5.639783e-01, 5.639932e-01,
    5.640081e-01, 5.640229e-01, 5.640378e-01, 5.640527e-01, 5.640676e-01, 5.640825e-01,
    5.640974e-01, 5.641122e-01, 5.641271e-01, 5.641420e-01, 5.641569e-01, 5.641719e-01,
    5.641867e-01, 5.642016e-01, 5.642165e-01, 5.642314e-01, 5.642463e-01, 5.642611e-01,
    5.642760e-01, 5.642909e-01, 5.643058e-01, 5.643207e-01, 5.643356e-01, 5.643505e-01,
    5.643654e-01, 5.643802e-01, 5.643951e-01, 5.644100e-01, 5.644249e-01, 5.644398e-01,
    5.644547e-01, 5.644696e-01, 5.644845e-01, 5.644993e-01, 5.645142e-01, 5.645291e-01,
    5.645440e-01, 5.645589e-01, 5.645738e-01, 5.645887e-01, 5.646035e-01, 5.646185e-01,
    5.646333e-01, 5.646482e-01, 5.646631e-01, 5.646780e-01, 5.646928e-01, 5.647078e-01,
    5.647226e-01, 5.647375e-01, 5.647524e-01, 5.647672e-01, 5.647821e-01, 5.647970e-01,
    5.648119e-01, 5.648268e-01, 5.648417e-01, 5.648565e-01, 5.648714e-01, 5.648863e-01,
    5.649012e-01, 5.649161e-01, 5.649310e-01, 5.649459e-01, 5.649607e-01, 5.649756e-01,
    5.649905e-01, 5.650054e-01, 5.650203e-01, 5.650351e-01, 5.650500e-01, 5.650648e-01,
    5.650797e-01, 5.650946e-01, 5.651096e-01, 5.651244e-01, 5.651393e-01, 5.651542e-01,
    5.651690e-01, 5.651839e-01, 5.651988e-01, 5.652137e-01, 5.652285e-01, 5.652434e-01,
    5.652583e-01, 5.652732e-01, 5.652881e-01, 5.653029e-01, 5.653178e-01, 5.653327e-01,
    5.653476e-01, 5.653625e-01, 5.653773e-01, 5.653922e-01, 5.654070e-01, 5.654219e-01,
    5.654368e-01, 5.654517e-01, 5.654666e-01, 5.654814e-01, 5.654963e-01, 5.655112e-01,
    5.655261e-01, 5.655410e-01, 5.655558e-01, 5.655707e-01, 5.655856e-01, 5.656005e-01,
    5.656154e-01, 5.656302e-01, 5.656451e-01, 5.656599e-01, 5.656748e-01, 5.656897e-01,
    5.657045e-01, 5.657194e-01, 5.657343e-01, 5.657492e-01, 5.657641e-01, 5.657789e-01,
    5.657938e-01, 5.658087e-01, 5.658235e-01, 5.658384e-01, 5.658533e-01, 5.658681e-01,
    5.658830e-01, 5.658979e-01, 5.659128e-01, 5.659277e-01, 5.659425e-01, 5.659574e-01,
    5.659723e-01, 5.659871e-01, 5.660020e-01, 5.660169e-01, 5.660318e-01, 5.660466e-01,
    5.660614e-01, 5.660763e-01, 5.660912e-01, 5.661061e-01, 5.661210e-01, 5.661358e-01,
    5.661507e-01, 5.661656e-01, 5.661804e-01, 5.661953e-01, 5.662102e-01, 5.662250e-01,
    5.662399e-01, 5.662548e-01, 5.662696e-01, 5.662845e-01, 5.662994e-01, 5.663142e-01,
    5.663291e-01, 5.663440e-01, 5.663588e-01, 5.663737e-01, 5.663885e-01, 5.664034e-01,
    5.664183e-01, 5.664331e-01, 5.664480e-01, 5.664629e-01, 5.664777e-01, 5.664926e-01,
    5.665075e-01, 5.665224e-01, 5.665372e-01, 5.665521e-01, 5.665669e-01, 5.665818e-01,
    5.665967e-01, 5.666115e-01, 5.666264e-01, 5.666413e-01, 5.666561e-01, 5.666710e-01,
    5.666859e-01, 5.667007e-01, 5.667156e-01, 5.667304e-01, 5.667453e-01, 5.667602e-01,
    5.667750e-01, 5.667899e-01, 5.668048e-01, 5.668196e-01, 5.668344e-01, 5.668494e-01,
    5.668642e-01, 5.668791e-01, 5.668939e-01, 5.669088e-01, 5.669237e-01, 5.669385e-01,
    5.669534e-01, 5.669683e-01, 5.669830e-01, 5.669979e-01, 5.670128e-01, 5.670277e-01,
    5.670425e-01, 5.670574e-01, 5.670723e-01, 5.670871e-01, 5.671020e-01, 5.671169e-01,
    5.671316e-01, 5.671465e-01, 5.671614e-01, 5.671762e-01, 5.671911e-01, 5.672060e-01,
    5.672209e-01, 5.672356e-01, 5.672505e-01, 5.672654e-01, 5.672802e-01, 5.672951e-01,
    5.673100e-01, 5.673248e-01, 5.673397e-01, 5.673545e-01, 5.673694e-01, 5.673842e-01,
    5.673991e-01, 5.674139e-01, 5.674288e-01, 5.674437e-01, 5.674585e-01, 5.674734e-01,
    5.674883e-01, 5.675030e-01, 5.675179e-01, 5.675328e-01, 5.675476e-01, 5.675625e-01,
    5.675774e-01, 5.675922e-01, 5.676070e-01, 5.676219e-01, 5.676368e-01, 5.676516e-01,
    5.676665e-01, 5.676813e-01, 5.676962e-01, 5.677111e-01, 5.677258e-01, 5.677407e-01,
    5.677556e-01, 5.677705e-01, 5.677853e-01, 5.678002e-01, 5.678150e-01, 5.678298e-01,
    5.678447e-01, 5.678595e-01, 5.678744e-01, 5.678893e-01, 5.679041e-01, 5.679190e-01,
    5.679338e-01, 5.679486e-01, 5.679635e-01, 5.679783e-01, 5.679932e-01, 5.680081e-01,
    5.680229e-01, 5.680377e-01, 5.680526e-01, 5.680674e-01, 5.680823e-01, 5.680971e-01,
    5.681120e-01, 5.681269e-01, 5.681417e-01, 5.681565e-01, 5.681714e-01, 5.681862e-01,
    5.682011e-01, 5.682159e-01, 5.682307e-01, 5.682456e-01, 5.682605e-01, 5.682753e-01,
    5.682901e-01, 5.683050e-01, 5.683199e-01, 5.683347e-01, 5.683495e-01, 5.683644e-01,
    5.683792e-01, 5.683941e-01, 5.684090e-01, 5.684237e-01, 5.684386e-01, 5.684534e-01,
    5.684683e-01, 5.684832e-01, 5.684980e-01, 5.685129e-01, 5.685277e-01, 5.685425e-01,
    5.685574e-01, 5.685722e-01, 5.685871e-01, 5.686019e-01, 5.686167e-01, 5.686316e-01,
    5.686464e-01, 5.686613e-01, 5.686761e-01, 5.686910e-01, 5.687058e-01, 5.687206e-01,
    5.687355e-01, 5.687503e-01, 5.687652e-01, 5.687800e-01, 5.687948e-01, 5.688097e-01,
    5.688245e-01, 5.688394e-01, 5.688542e-01, 5.688691e-01, 5.688839e-01, 5.688987e-01,
    5.689136e-01, 5.689284e-01, 5.689433e-01, 5.689581e-01, 5.689729e-01, 5.689878e-01,
    5.690026e-01, 5.690175e-01, 5.690323e-01, 5.690471e-01, 5.690619e-01, 5.690768e-01,
    5.690916e-01, 5.691065e-01, 5.691214e-01, 5.691361e-01, 5.691510e-01, 5.691658e-01,
    5.691807e-01, 5.691955e-01, 5.692104e-01, 5.692252e-01, 5.692400e-01, 5.692548e-01,
    5.692697e-01, 5.692846e-01, 5.692994e-01, 5.693142e-01, 5.693290e-01, 5.693439e-01,
    5.693587e-01, 5.693735e-01, 5.693884e-01, 5.694032e-01, 5.694181e-01, 5.694329e-01,
    5.694477e-01, 5.694625e-01, 5.694774e-01, 5.694922e-01, 5.695071e-01, 5.695219e-01,
    5.695367e-01, 5.695515e-01, 5.695664e-01, 5.695812e-01, 5.695961e-01, 5.696109e-01,
    5.696257e-01, 5.696406e-01, 5.696554e-01, 5.696702e-01, 5.696850e-01, 5.696999e-01,
    5.697147e-01, 5.697296e-01, 5.697444e-01, 5.697592e-01, 5.697740e-01, 5.697889e-01,
    5.698037e-01, 5.698186e-01, 5.698333e-01, 5.698482e-01, 5.698630e-01, 5.698779e-01,
    5.698926e-01, 5.699075e-01, 5.699223e-01, 5.699372e-01, 5.699520e-01, 5.699669e-01,
    5.699817e-01, 5.699965e-01, 5.700113e-01, 5.700262e-01, 5.700409e-01, 5.700558e-01,
    5.700706e-01, 5.700855e-01, 5.701003e-01, 5.701151e-01, 5.701299e-01, 5.701448e-01,
    5.701596e-01, 5.701744e-01, 5.701892e-01, 5.702041e-01, 5.702189e-01, 5.702337e-01,
    5.702485e-01, 5.702634e-01, 5.702782e-01, 5.702931e-01, 5.703079e-01, 5.703227e-01,
    5.703375e-01, 5.703523e-01, 5.703672e-01, 5.703820e-01, 5.703968e-01, 5.704116e-01,
    5.704265e-01, 5.704413e-01, 5.704561e-01, 5.704709e-01, 5.704858e-01, 5.705006e-01,
    5.705154e-01, 5.705302e-01, 5.705450e-01, 5.705599e-01, 5.705747e-01, 5.705895e-01,
    5.706043e-01, 5.706192e-01, 5.706340e-01, 5.706488e-01, 5.706636e-01, 5.706785e-01,
    5.706933e-01, 5.707081e-01, 5.707229e-01, 5.707378e-01, 5.707526e-01, 5.707674e-01,
    5.707822e-01, 5.707970e-01, 5.708118e-01, 5.708266e-01, 5.708415e-01, 5.708563e-01,
    5.708711e-01, 5.708860e-01, 5.709007e-01, 5.709156e-01, 5.709304e-01, 5.709452e-01,
    5.709600e-01, 5.709749e-01, 5.709897e-01, 5.710045e-01, 5.710194e-01, 5.710341e-01,
    5.710490e-01, 5.710638e-01, 5.710786e-01, 5.710934e-01, 5.711082e-01, 5.711231e-01,
    5.711378e-01, 5.711527e-01, 5.711675e-01, 5.711823e-01, 5.711971e-01, 5.712119e-01,
    5.712267e-01, 5.712416e-01, 5.712564e-01, 5.712712e-01, 5.712860e-01, 5.713008e-01,
    5.713156e-01, 5.713305e-01, 5.713453e-01, 5.713601e-01, 5.713749e-01, 5.713897e-01,
    5.714045e-01, 5.714194e-01, 5.714341e-01, 5.714490e-01, 5.714638e-01, 5.714786e-01,
    5.714934e-01, 5.715082e-01, 5.715231e-01, 5.715379e-01, 5.715527e-01, 5.715675e-01,
    5.715823e-01, 5.715971e-01, 5.716119e-01, 5.716267e-01, 5.716416e-01, 5.716563e-01,
    5.716712e-01, 5.716860e-01, 5.717008e-01, 5.717156e-01, 5.717304e-01, 5.717452e-01,
    5.717601e-01, 5.717748e-01, 5.717897e-01, 5.718045e-01, 5.718193e-01, 5.718341e-01,
    5.718489e-01, 5.718637e-01, 5.718785e-01, 5.718933e-01, 5.719081e-01, 5.719230e-01,
    5.719377e-01, 5.719526e-01, 5.719674e-01, 5.719822e-01, 5.719970e-01, 5.720118e-01,
    5.720266e-01, 5.720415e-01, 5.720562e-01, 5.720711e-01, 5.720859e-01, 5.721007e-01,
    5.721155e-01, 5.721303e-01, 5.721451e-01, 5.721599e-01, 5.721747e-01, 5.721895e-01,
    5.722043e-01, 5.722191e-01, 5.722339e-01, 5.722487e-01, 5.722635e-01, 5.722783e-01,
    5.722931e-01, 5.723079e-01, 5.723227e-01, 5.723375e-01, 5.723523e-01, 5.723671e-01,
    5.723820e-01, 5.723968e-01, 5.724116e-01, 5.724264e-01, 5.724412e-01, 5.724560e-01,
    5.724708e-01, 5.724856e-01, 5.725004e-01, 5.725152e-01, 5.725300e-01, 5.725448e-01,
    5.725596e-01, 5.725744e-01, 5.725892e-01, 5.726040e-01, 5.726188e-01, 5.726336e-01,
    5.726485e-01, 5.726632e-01, 5.726780e-01, 5.726928e-01, 5.727077e-01, 5.727224e-01,
    5.727372e-01, 5.727520e-01, 5.727668e-01, 5.727816e-01, 5.727964e-01, 5.728112e-01,
    5.728260e-01, 5.728409e-01, 5.728557e-01, 5.728704e-01, 5.728852e-01, 5.729000e-01,
    5.729148e-01, 5.729296e-01, 5.729444e-01, 5.729592e-01, 5.729740e-01, 5.729888e-01,
    5.730036e-01, 5.730184e-01, 5.730332e-01, 5.730480e-01, 5.730628e-01, 5.730776e-01,
    5.730924e-01, 5.731072e-01, 5.731220e-01, 5.731368e-01, 5.731516e-01, 5.731664e-01,
    5.731812e-01, 5.731960e-01, 5.732108e-01, 5.732256e-01, 5.732403e-01, 5.732551e-01,
    5.732700e-01, 5.732847e-01, 5.732996e-01, 5.733144e-01, 5.733292e-01, 5.733439e-01,
    5.733587e-01, 5.733735e-01, 5.733883e-01, 5.734031e-01, 5.734179e-01, 5.734327e-01,
    5.734475e-01, 5.734622e-01, 5.734771e-01, 5.734919e-01, 5.735067e-01, 5.735215e-01,
    5.735363e-01, 5.735511e-01, 5.735658e-01, 5.735806e-01, 5.735954e-01, 5.736102e-01,
    5.736250e-01, 5.736398e-01, 5.736546e-01, 5.736694e-01, 5.736842e-01, 5.736989e-01,
    5.737137e-01, 5.737286e-01, 5.737433e-01, 5.737581e-01, 5.737729e-01, 5.737877e-01,
    5.738025e-01, 5.738173e-01, 5.738321e-01, 5.738469e-01, 5.738617e-01, 5.738764e-01,
    5.738912e-01, 5.739060e-01, 5.739208e-01, 5.739356e-01, 5.739504e-01, 5.739652e-01,
    5.739800e-01, 5.739948e-01, 5.740095e-01, 5.740243e-01, 5.740391e-01, 5.740539e-01,
    5.740687e-01, 5.740834e-01, 5.740982e-01, 5.741131e-01, 5.741279e-01, 5.741426e-01,
    5.741574e-01, 5.741722e-01, 5.741870e-01, 5.742018e-01, 5.742165e-01, 5.742313e-01,
    5.742461e-01, 5.742609e-01, 5.742757e-01, 5.742905e-01, 5.743052e-01, 5.743200e-01,
    5.743348e-01, 5.743496e-01, 5.743644e-01, 5.743792e-01, 5.743940e-01, 5.744087e-01,
    5.744235e-01, 5.744383e-01, 5.744531e-01, 5.744679e-01, 5.744827e-01, 5.744974e-01,
    5.745122e-01, 5.745270e-01, 5.745418e-01, 5.745566e-01, 5.745713e-01, 5.745862e-01,
    5.746009e-01, 5.746157e-01, 5.746305e-01, 5.746452e-01, 5.746601e-01, 5.746748e-01,
    5.746896e-01, 5.747044e-01, 5.747191e-01, 5.747340e-01, 5.747488e-01, 5.747635e-01,
    5.747783e-01, 5.747930e-01, 5.748078e-01, 5.748227e-01, 5.748374e-01, 5.748522e-01,
    5.748670e-01, 5.748817e-01, 5.748965e-01, 5.749113e-01, 5.749261e-01, 5.749409e-01,
    5.749556e-01, 5.749704e-01, 5.749851e-01, 5.749999e-01, 5.750148e-01, 5.750296e-01,
    5.750443e-01, 5.750591e-01, 5.750738e-01, 5.750886e-01, 5.751034e-01, 5.751182e-01,
    5.751330e-01, 5.751477e-01, 5.751625e-01, 5.751773e-01, 5.751920e-01, 5.752069e-01,
    5.752216e-01, 5.752364e-01, 5.752512e-01, 5.752659e-01, 5.752807e-01, 5.752954e-01,
    5.753102e-01, 5.753251e-01, 5.753398e-01, 5.753546e-01, 5.753694e-01, 5.753841e-01,
    5.753989e-01, 5.754136e-01, 5.754284e-01, 5.754433e-01, 5.754580e-01, 5.754728e-01,
    5.754876e-01, 5.755023e-01, 5.755171e-01, 5.755318e-01, 5.755466e-01, 5.755614e-01,
    5.755762e-01, 5.755909e-01, 5.756058e-01, 5.756205e-01, 5.756353e-01, 5.756500e-01,
    5.756648e-01, 5.756796e-01, 5.756943e-01, 5.757091e-01, 5.757239e-01, 5.757387e-01,
    5.757534e-01, 5.757682e-01, 5.757830e-01, 5.757977e-01, 5.758125e-01, 5.758273e-01,
    5.758420e-01, 5.758568e-01, 5.758716e-01, 5.758864e-01, 5.759011e-01, 5.759159e-01,
    5.759307e-01, 5.759454e-01, 5.759602e-01, 5.759749e-01, 5.759897e-01, 5.760045e-01,
    5.760192e-01, 5.760340e-01, 5.760488e-01, 5.760635e-01, 5.760784e-01, 5.760931e-01,
    5.761079e-01, 5.761226e-01, 5.761374e-01, 5.761521e-01, 5.761669e-01, 5.761817e-01,
    5.761964e-01, 5.762112e-01, 5.762260e-01, 5.762407e-01, 5.762555e-01, 5.762703e-01,
    5.762851e-01, 5.762998e-01, 5.763146e-01, 5.763294e-01, 5.763441e-01, 5.763589e-01,
    5.763736e-01, 5.763884e-01, 5.764031e-01, 5.764179e-01, 5.764326e-01, 5.764474e-01,
    5.764622e-01, 5.764769e-01, 5.764917e-01, 5.765065e-01, 5.765212e-01, 5.765360e-01,
    5.765508e-01, 5.765655e-01, 5.765803e-01, 5.765951e-01, 5.766098e-01, 5.766246e-01,
    5.766394e-01, 5.766541e-01, 5.766689e-01, 5.766836e-01, 5.766984e-01, 5.767131e-01,
    5.767279e-01, 5.767426e-01, 5.767574e-01, 5.767722e-01, 5.767869e-01, 5.768017e-01,
    5.768165e-01, 5.768312e-01, 5.768460e-01, 5.768607e-01, 5.768755e-01, 5.768903e-01,
    5.769050e-01, 5.769197e-01, 5.769346e-01, 5.769493e-01, 5.769640e-01, 5.769788e-01,
    5.769935e-01, 5.770083e-01, 5.770231e-01, 5.770378e-01, 5.770526e-01, 5.770674e-01,
    5.770821e-01, 5.770969e-01, 5.771116e-01, 5.771263e-01, 5.771412e-01, 5.771559e-01,
    5.771706e-01, 5.771854e-01, 5.772001e-01, 5.772149e-01, 5.772297e-01, 5.772444e-01,
    5.772592e-01, 5.772739e-01, 5.772887e-01, 5.773034e-01, 5.773182e-01, 5.773330e-01,
    5.773477e-01, 5.773624e-01, 5.773772e-01, 5.773919e-01, 5.774067e-01, 5.774214e-01,
    5.774362e-01, 5.774510e-01, 5.774657e-01, 5.774804e-01, 5.774952e-01, 5.775099e-01,
    5.775247e-01, 5.775394e-01, 5.775542e-01, 5.775690e-01, 5.775837e-01, 5.775985e-01,
    5.776132e-01, 5.776280e-01, 5.776427e-01, 5.776575e-01, 5.776722e-01, 5.776870e-01,
    5.777017e-01, 5.777165e-01, 5.777312e-01, 5.777460e-01, 5.777607e-01, 5.777755e-01,
    5.777902e-01, 5.778049e-01, 5.778197e-01, 5.778345e-01, 5.778492e-01, 5.778640e-01,
    5.778787e-01, 5.778935e-01, 5.779082e-01, 5.779230e-01, 5.779377e-01, 5.779524e-01,
    5.779672e-01, 5.779819e-01, 5.779967e-01, 5.780115e-01, 5.780262e-01, 5.780410e-01,
    5.780557e-01, 5.780704e-01, 5.780851e-01, 5.780999e-01, 5.781146e-01, 5.781294e-01,
    5.781441e-01, 5.781589e-01, 5.781736e-01, 5.781884e-01, 5.782031e-01, 5.782179e-01,
    5.782326e-01, 5.782474e-01, 5.782622e-01, 5.782769e-01, 5.782916e-01, 5.783063e-01,
    5.783211e-01, 5.783358e-01, 5.783505e-01, 5.783653e-01, 5.783800e-01, 5.783948e-01,
    5.784096e-01, 5.784243e-01, 5.784391e-01, 5.784538e-01, 5.784685e-01, 5.784832e-01,
    5.784980e-01, 5.785127e-01, 5.785275e-01, 5.785422e-01, 5.785570e-01, 5.785717e-01,
    5.785865e-01, 5.786012e-01, 5.786160e-01, 5.786307e-01, 5.786454e-01, 5.786601e-01,
    5.786749e-01, 5.786896e-01, 5.787044e-01, 5.787191e-01, 5.787338e-01, 5.787486e-01,
    5.787633e-01, 5.787781e-01, 5.787928e-01, 5.788075e-01, 5.788223e-01, 5.788370e-01,
    5.788518e-01, 5.788665e-01, 5.788812e-01, 5.788960e-01, 5.789107e-01, 5.789255e-01,
    5.789402e-01, 5.789549e-01, 5.789697e-01, 5.789844e-01, 5.789991e-01, 5.790139e-01,
    5.790286e-01, 5.790433e-01, 5.790581e-01, 5.790728e-01, 5.790876e-01, 5.791023e-01,
    5.791170e-01, 5.791318e-01, 5.791465e-01, 5.791612e-01, 5.791759e-01, 5.791907e-01,
    5.792055e-01, 5.792202e-01, 5.792349e-01, 5.792496e-01, 5.792643e-01, 5.792791e-01,
    5.792938e-01, 5.793086e-01, 5.793233e-01, 5.793381e-01, 5.793527e-01, 5.793675e-01,
    5.793822e-01, 5.793970e-01, 5.794117e-01, 5.794265e-01, 5.794411e-01, 5.794559e-01,
    5.794706e-01, 5.794854e-01, 5.795001e-01, 5.795148e-01, 5.795295e-01, 5.795443e-01,
    5.795590e-01, 5.795738e-01, 5.795885e-01, 5.796032e-01, 5.796180e-01, 5.796326e-01,
    5.796474e-01, 5.796621e-01, 5.796769e-01, 5.796916e-01, 5.797063e-01, 5.797210e-01,
    5.797358e-01, 5.797505e-01, 5.797653e-01, 5.797800e-01, 5.797947e-01, 5.798094e-01,
    5.798241e-01, 5.798389e-01, 5.798536e-01, 5.798683e-01, 5.798830e-01, 5.798978e-01,
    5.799125e-01, 5.799273e-01, 5.799420e-01, 5.799567e-01, 5.799714e-01, 5.799862e-01,
    5.800009e-01, 5.800156e-01, 5.800303e-01, 5.800450e-01, 5.800598e-01, 5.800745e-01,
    5.800892e-01, 5.801040e-01, 5.801187e-01, 5.801334e-01, 5.801481e-01, 5.801629e-01,
    5.801776e-01, 5.801923e-01, 5.802070e-01, 5.802217e-01, 5.802365e-01, 5.802512e-01,
    5.802659e-01, 5.802807e-01, 5.802954e-01, 5.803101e-01, 5.803248e-01, 5.803396e-01,
    5.803543e-01, 5.803690e-01, 5.803837e-01, 5.803984e-01, 5.804132e-01, 5.804279e-01,
    5.804426e-01, 5.804573e-01, 5.804721e-01, 5.804868e-01, 5.805015e-01, 5.805162e-01,
    5.805309e-01, 5.805457e-01, 5.805604e-01, 5.805750e-01, 5.805898e-01, 5.806046e-01,
    5.806192e-01, 5.806340e-01, 5.806487e-01, 5.806634e-01, 5.806782e-01, 5.806928e-01,
    5.807076e-01, 5.807223e-01, 5.807370e-01, 5.807517e-01, 5.807664e-01, 5.807812e-01,
    5.807959e-01, 5.808106e-01, 5.808253e-01, 5.808401e-01, 5.808548e-01, 5.808695e-01,
    5.808842e-01, 5.808989e-01, 5.809136e-01, 5.809283e-01, 5.809430e-01, 5.809578e-01,
    5.809725e-01, 5.809872e-01, 5.810019e-01, 5.810167e-01, 5.810313e-01, 5.810461e-01,
    5.810608e-01, 5.810755e-01, 5.810902e-01, 5.811049e-01, 5.811197e-01, 5.811344e-01,
    5.811490e-01, 5.811638e-01, 5.811785e-01, 5.811932e-01, 5.812079e-01, 5.812227e-01,
    5.812374e-01, 5.812521e-01, 5.812668e-01, 5.812815e-01, 5.812962e-01, 5.813109e-01,
    5.813257e-01, 5.813404e-01, 5.813550e-01, 5.813698e-01, 5.813845e-01, 5.813992e-01,
    5.814139e-01, 5.814286e-01, 5.814433e-01, 5.814580e-01, 5.814728e-01, 5.814875e-01,
    5.815022e-01, 5.815169e-01, 5.815316e-01, 5.815463e-01, 5.815610e-01, 5.815758e-01,
    5.815905e-01, 5.816051e-01, 5.816199e-01, 5.816346e-01, 5.816493e-01, 5.816640e-01,
    5.816787e-01, 5.816934e-01, 5.817081e-01, 5.817229e-01, 5.817376e-01, 5.817522e-01,
    5.817670e-01, 5.817817e-01, 5.817963e-01, 5.818111e-01, 5.818258e-01, 5.818405e-01,
    5.818552e-01, 5.818700e-01, 5.818846e-01, 5.818993e-01, 5.819141e-01, 5.819287e-01,
    5.819435e-01, 5.819582e-01, 5.819728e-01, 5.819876e-01, 5.820023e-01, 5.820170e-01,
    5.820317e-01, 5.820464e-01, 5.820611e-01, 5.820758e-01, 5.820905e-01, 5.821052e-01,
    5.821199e-01, 5.821346e-01, 5.821493e-01, 5.821640e-01, 5.821787e-01, 5.821934e-01,
    5.822082e-01, 5.822228e-01, 5.822375e-01, 5.822523e-01, 5.822669e-01, 5.822816e-01,
    5.822964e-01, 5.823111e-01, 5.823258e-01, 5.823405e-01, 5.823552e-01, 5.823699e-01,
    5.823846e-01, 5.823993e-01, 5.824140e-01, 5.824287e-01, 5.824434e-01, 5.824581e-01,
    5.824728e-01, 5.824875e-01, 5.825022e-01, 5.825169e-01, 5.825316e-01, 5.825463e-01,
    5.825610e-01, 5.825757e-01, 5.825904e-01, 5.826051e-01, 5.826198e-01, 5.826345e-01,
    5.826492e-01, 5.826639e-01, 5.826786e-01, 5.826933e-01, 5.827080e-01, 5.827227e-01,
    5.827374e-01, 5.827520e-01, 5.827668e-01, 5.827815e-01, 5.827962e-01, 5.828109e-01,
    5.828256e-01, 5.828403e-01, 5.828550e-01, 5.828696e-01, 5.828844e-01, 5.828991e-01,
    5.829138e-01, 5.829284e-01, 5.829431e-01, 5.829579e-01, 5.829726e-01, 5.829872e-01,
    5.830019e-01, 5.830166e-01, 5.830314e-01, 5.830460e-01, 5.830607e-01, 5.830754e-01,
    5.830901e-01, 5.831048e-01, 5.831195e-01, 5.831342e-01, 5.831489e-01, 5.831636e-01,
    5.831783e-01, 5.831930e-01, 5.832077e-01, 5.832224e-01, 5.832371e-01, 5.832517e-01,
    5.832664e-01, 5.832812e-01, 5.832958e-01, 5.833105e-01, 5.833252e-01, 5.833399e-01,
    5.833546e-01, 5.833693e-01, 5.833840e-01, 5.833987e-01, 5.834134e-01, 5.834280e-01,
    5.834427e-01, 5.834574e-01, 5.834721e-01, 5.834869e-01, 5.835015e-01, 5.835162e-01,
    5.835309e-01, 5.835456e-01, 5.835603e-01, 5.835750e-01, 5.835897e-01, 5.836043e-01,
    5.836191e-01, 5.836337e-01, 5.836484e-01, 5.836631e-01, 5.836778e-01, 5.836925e-01,
    5.837072e-01, 5.837218e-01, 5.837365e-01, 5.837513e-01, 5.837659e-01, 5.837806e-01,
    5.837952e-01, 5.838100e-01, 5.838247e-01, 5.838394e-01, 5.838541e-01, 5.838687e-01,
    5.838834e-01, 5.838981e-01, 5.839128e-01, 5.839275e-01, 5.839422e-01, 5.839568e-01,
    5.839715e-01, 5.839862e-01, 5.840009e-01, 5.840156e-01, 5.840303e-01, 5.840449e-01,
    5.840597e-01, 5.840743e-01, 5.840890e-01, 5.841037e-01, 5.841184e-01, 5.841331e-01,
    5.841478e-01, 5.841625e-01, 5.841771e-01, 5.841918e-01, 5.842065e-01, 5.842212e-01,
    5.842358e-01, 5.842506e-01, 5.842652e-01, 5.842800e-01, 5.842946e-01, 5.843093e-01,
    5.843239e-01, 5.843387e-01, 5.843533e-01, 5.843681e-01, 5.843827e-01, 5.843974e-01,
    5.844120e-01, 5.844267e-01, 5.844414e-01, 5.844561e-01, 5.844708e-01, 5.844855e-01,
    5.845001e-01, 5.845148e-01, 5.845295e-01, 5.845442e-01, 5.845588e-01, 5.845736e-01,
    5.845882e-01, 5.846029e-01, 5.846176e-01, 5.846323e-01, 5.846469e-01, 5.846616e-01,
    5.846763e-01, 5.846910e-01, 5.847057e-01, 5.847203e-01, 5.847350e-01, 5.847497e-01,
    5.847644e-01, 5.847790e-01, 5.847937e-01, 5.848084e-01, 5.848231e-01, 5.848377e-01,
    5.848524e-01, 5.848671e-01, 5.848818e-01, 5.848964e-01, 5.849112e-01, 5.849258e-01,
    5.849405e-01, 5.849552e-01, 5.849698e-01, 5.849845e-01, 5.849992e-01, 5.850139e-01,
    5.850285e-01, 5.850433e-01, 5.850579e-01, 5.850726e-01, 5.850872e-01, 5.851019e-01,
    5.851166e-01, 5.851313e-01, 5.851460e-01, 5.851606e-01, 5.851753e-01, 5.851900e-01,
    5.852047e-01, 5.852193e-01, 5.852340e-01, 5.852486e-01, 5.852633e-01, 5.852780e-01,
    5.852927e-01, 5.853074e-01, 5.853220e-01, 5.853367e-01, 5.853514e-01, 5.853660e-01,
    5.853807e-01, 5.853953e-01, 5.854100e-01, 5.854247e-01, 5.854394e-01, 5.854540e-01,
    5.854687e-01, 5.854834e-01, 5.854981e-01, 5.855128e-01, 5.855274e-01, 5.855421e-01,
    5.855567e-01, 5.855714e-01, 5.855861e-01, 5.856007e-01, 5.856154e-01, 5.856301e-01,
    5.856448e-01, 5.856594e-01, 5.856741e-01, 5.856888e-01, 5.857034e-01, 5.857181e-01,
    5.857328e-01, 5.857475e-01, 5.857621e-01, 5.857768e-01, 5.857914e-01, 5.858061e-01,
    5.858207e-01, 5.858355e-01, 5.858501e-01, 5.858648e-01, 5.858794e-01, 5.858941e-01,
    5.859088e-01, 5.859234e-01, 5.859381e-01, 5.859528e-01, 5.859675e-01, 5.859821e-01,
    5.859968e-01, 5.860115e-01, 5.860261e-01, 5.860408e-01, 5.860555e-01, 5.860701e-01,
    5.860848e-01, 5.860994e-01, 5.861140e-01, 5.861287e-01, 5.861434e-01, 5.861581e-01,
    5.861728e-01, 5.861874e-01, 5.862021e-01, 5.862167e-01, 5.862314e-01, 5.862461e-01,
    5.862607e-01, 5.862754e-01, 5.862901e-01, 5.863047e-01, 5.863194e-01, 5.863340e-01,
    5.863487e-01, 5.863634e-01, 5.863780e-01, 5.863927e-01, 5.864074e-01, 5.864220e-01,
    5.864367e-01, 5.864514e-01, 5.864660e-01, 5.864807e-01, 5.864953e-01, 5.865100e-01,
    5.865247e-01, 5.865393e-01, 5.865540e-01, 5.865687e-01, 5.865833e-01, 5.865979e-01,
    5.866126e-01, 5.866272e-01, 5.866419e-01, 5.866566e-01, 5.866712e-01, 5.866859e-01,
    5.867006e-01, 5.867152e-01, 5.867299e-01, 5.867445e-01, 5.867592e-01, 5.867739e-01,
    5.867885e-01, 5.868031e-01, 5.868178e-01, 5.868325e-01, 5.868471e-01, 5.868618e-01,
    5.868765e-01, 5.868911e-01, 5.869058e-01, 5.869204e-01, 5.869350e-01, 5.869497e-01,
    5.869644e-01, 5.869790e-01, 5.869937e-01, 5.870084e-01, 5.870230e-01, 5.870376e-01,
    5.870523e-01, 5.870669e-01, 5.870816e-01, 5.870963e-01, 5.871109e-01, 5.871255e-01,
    5.871402e-01, 5.871549e-01, 5.871695e-01, 5.871842e-01, 5.871988e-01, 5.872135e-01,
    5.872281e-01, 5.872428e-01, 5.872574e-01, 5.872721e-01, 5.872868e-01, 5.873014e-01,
    5.873160e-01, 5.873307e-01, 5.873454e-01, 5.873600e-01, 5.873747e-01, 5.873893e-01,
    5.874040e-01, 5.874186e-01, 5.874333e-01, 5.874479e-01, 5.874625e-01, 5.874772e-01,
    5.874919e-01, 5.875065e-01, 5.875211e-01, 5.875358e-01, 5.875505e-01, 5.875651e-01,
    5.875797e-01, 5.875944e-01, 5.876091e-01, 5.876237e-01, 5.876384e-01, 5.876530e-01,
    5.876676e-01, 5.876823e-01, 5.876970e-01, 5.877116e-01, 5.877262e-01, 5.877409e-01,
    5.877555e-01, 5.877702e-01, 5.877848e-01, 5.877995e-01, 5.878142e-01, 5.878288e-01,
    5.878434e-01, 5.878581e-01, 5.878727e-01, 5.878873e-01, 5.879020e-01, 5.879167e-01,
    5.879313e-01, 5.879459e-01, 5.879606e-01, 5.879752e-01, 5.879899e-01, 5.880045e-01,
    5.880192e-01, 5.880339e-01, 5.880485e-01, 5.880631e-01, 5.880777e-01, 5.880924e-01,
    5.881070e-01, 5.881217e-01, 5.881363e-01, 5.881510e-01, 5.881656e-01, 5.881803e-01,
    5.881949e-01, 5.882096e-01, 5.882242e-01, 5.882388e-01, 5.882534e-01, 5.882681e-01,
    5.882828e-01, 5.882974e-01, 5.883120e-01, 5.883267e-01, 5.883414e-01, 5.883560e-01,
    5.883706e-01, 5.883852e-01, 5.883999e-01, 5.884145e-01, 5.884292e-01, 5.884438e-01,
    5.884585e-01, 5.884731e-01, 5.884877e-01, 5.885023e-01, 5.885170e-01, 5.885316e-01,
    5.885463e-01, 5.885609e-01, 5.885756e-01, 5.885902e-01, 5.886049e-01, 5.886195e-01,
    5.886341e-01, 5.886487e-01, 5.886634e-01, 5.886781e-01, 5.886927e-01, 5.887073e-01,
    5.887219e-01, 5.887366e-01, 5.887512e-01, 5.887659e-01, 5.887805e-01, 5.887952e-01,
    5.888098e-01, 5.888244e-01, 5.888391e-01, 5.888537e-01, 5.888683e-01, 5.888830e-01,
    5.888976e-01, 5.889122e-01, 5.889269e-01, 5.889415e-01, 5.889561e-01, 5.889708e-01,
    5.889854e-01, 5.890000e-01, 5.890147e-01, 5.890293e-01, 5.890439e-01, 5.890586e-01,
    5.890732e-01, 5.890878e-01, 5.891025e-01, 5.891171e-01, 5.891317e-01, 5.891464e-01,
    5.891610e-01, 5.891756e-01, 5.891903e-01, 5.892049e-01, 5.892196e-01, 5.892342e-01,
    5.892488e-01, 5.892634e-01, 5.892781e-01, 5.892927e-01, 5.893073e-01, 5.893220e-01,
    5.893366e-01, 5.893512e-01, 5.893659e-01, 5.893805e-01, 5.893951e-01, 5.894097e-01,
    5.894244e-01, 5.894390e-01, 5.894536e-01, 5.894683e-01, 5.894829e-01, 5.894975e-01,
    5.895122e-01, 5.895268e-01, 5.895414e-01, 5.895560e-01, 5.895706e-01, 5.895853e-01,
    5.896000e-01, 5.896146e-01, 5.896292e-01, 5.896438e-01, 5.896584e-01, 5.896731e-01,
    5.896877e-01, 5.897023e-01, 5.897170e-01, 5.897316e-01, 5.897462e-01, 5.897608e-01,
    5.897754e-01, 5.897901e-01, 5.898048e-01, 5.898194e-01, 5.898340e-01, 5.898486e-01,
    5.898632e-01, 5.898779e-01, 5.898925e-01, 5.899071e-01, 5.899217e-01, 5.899364e-01,
    5.899510e-01, 5.899656e-01, 5.899802e-01, 5.899948e-01, 5.900095e-01, 5.900241e-01,
    5.900387e-01, 5.900534e-01, 5.900680e-01, 5.900826e-01, 5.900972e-01, 5.901119e-01,
    5.901265e-01, 5.901411e-01, 5.901557e-01, 5.901704e-01, 5.901850e-01, 5.901996e-01,
    5.902143e-01, 5.902289e-01, 5.902435e-01, 5.902581e-01, 5.902727e-01, 5.902873e-01,
    5.903019e-01, 5.903165e-01, 5.903312e-01, 5.903459e-01, 5.903605e-01, 5.903751e-01,
    5.903897e-01, 5.904043e-01, 5.904189e-01, 5.904335e-01, 5.904481e-01, 5.904628e-01,
    5.904774e-01, 5.904920e-01, 5.905067e-01, 5.905213e-01, 5.905359e-01, 5.905505e-01,
    5.905651e-01, 5.905797e-01, 5.905944e-01, 5.906090e-01, 5.906236e-01, 5.906382e-01,
    5.906528e-01, 5.906674e-01, 5.906821e-01, 5.906967e-01, 5.907113e-01, 5.907259e-01,
    5.907406e-01, 5.907552e-01, 5.907698e-01, 5.907844e-01, 5.907990e-01, 5.908136e-01,
    5.908282e-01, 5.908428e-01, 5.908575e-01, 5.908721e-01, 5.908867e-01, 5.909013e-01,
    5.909159e-01, 5.909305e-01, 5.909452e-01, 5.909598e-01, 5.909744e-01, 5.909890e-01,
    5.910037e-01, 5.910183e-01, 5.910329e-01, 5.910475e-01, 5.910621e-01, 5.910767e-01,
    5.910913e-01, 5.911059e-01, 5.911205e-01, 5.911351e-01, 5.911497e-01, 5.911644e-01,
    5.911790e-01, 5.911936e-01, 5.912082e-01, 5.912228e-01, 5.912374e-01, 5.912521e-01,
    5.912667e-01, 5.912812e-01, 5.912959e-01, 5.913105e-01, 5.913251e-01, 5.913397e-01,
    5.913544e-01, 5.913689e-01, 5.913835e-01, 5.913982e-01, 5.914128e-01, 5.914274e-01,
    5.914420e-01, 5.914566e-01, 5.914712e-01, 5.914858e-01, 5.915005e-01, 5.915150e-01,
    5.915297e-01, 5.915443e-01, 5.915589e-01, 5.915735e-01, 5.915881e-01, 5.916027e-01,
    5.916173e-01, 5.916319e-01, 5.916465e-01, 5.916611e-01, 5.916758e-01, 5.916904e-01,
    5.917049e-01, 5.917196e-01, 5.917342e-01, 5.917488e-01, 5.917634e-01, 5.917780e-01,
    5.917926e-01, 5.918072e-01, 5.918218e-01, 5.918364e-01, 5.918511e-01, 5.918656e-01,
    5.918802e-01, 5.918949e-01, 5.919094e-01, 5.919240e-01, 5.919387e-01, 5.919532e-01,
    5.919679e-01, 5.919825e-01, 5.919971e-01, 5.920117e-01, 5.920263e-01, 5.920409e-01,
    5.920555e-01, 5.920701e-01, 5.920847e-01, 5.920993e-01, 5.921139e-01, 5.921285e-01,
    5.921431e-01, 5.921577e-01, 5.921723e-01, 5.921869e-01, 5.922015e-01, 5.922161e-01,
    5.922307e-01, 5.922453e-01, 5.922599e-01, 5.922745e-01, 5.922891e-01, 5.923038e-01,
    5.923184e-01, 5.923329e-01, 5.923476e-01, 5.923621e-01, 5.923768e-01, 5.923913e-01,
    5.924059e-01, 5.924206e-01, 5.924351e-01, 5.924497e-01, 5.924643e-01, 5.924789e-01,
    5.924935e-01, 5.925081e-01, 5.925227e-01, 5.925373e-01, 5.925519e-01, 5.925665e-01,
    5.925812e-01, 5.925957e-01, 5.926104e-01, 5.926249e-01, 5.926395e-01, 5.926541e-01,
    5.926687e-01, 5.926833e-01, 5.926979e-01, 5.927125e-01, 5.927271e-01, 5.927417e-01,
    5.927563e-01, 5.927709e-01, 5.927855e-01, 5.928001e-01, 5.928147e-01, 5.928293e-01,
    5.928439e-01, 5.928584e-01, 5.928731e-01, 5.928876e-01, 5.929023e-01, 5.929168e-01,
    5.929314e-01, 5.929461e-01, 5.929606e-01, 5.929753e-01, 5.929898e-01, 5.930044e-01,
    5.930190e-01, 5.930336e-01, 5.930482e-01, 5.930628e-01, 5.930774e-01, 5.930920e-01,
    5.931066e-01, 5.931212e-01, 5.931358e-01, 5.931504e-01, 5.931649e-01, 5.931796e-01,
    5.931941e-01, 5.932087e-01, 5.932233e-01, 5.932379e-01, 5.932525e-01, 5.932671e-01,
    5.932817e-01, 5.932963e-01, 5.933109e-01, 5.933255e-01, 5.933400e-01, 5.933546e-01,
    5.933692e-01, 5.933838e-01, 5.933984e-01, 5.934130e-01, 5.934276e-01, 5.934422e-01,
    5.934568e-01, 5.934713e-01, 5.934860e-01, 5.935006e-01, 5.935152e-01, 5.935297e-01,
    5.935443e-01, 5.935589e-01, 5.935735e-01, 5.935881e-01, 5.936027e-01, 5.936173e-01,
    5.936318e-01, 5.936465e-01, 5.936610e-01, 5.936756e-01, 5.936902e-01, 5.937048e-01,
    5.937194e-01, 5.937340e-01, 5.937486e-01, 5.937631e-01, 5.937777e-01, 5.937923e-01,
    5.938069e-01, 5.938215e-01, 5.938361e-01, 5.938506e-01, 5.938653e-01, 5.938798e-01,
    5.938944e-01, 5.939090e-01, 5.939236e-01, 5.939382e-01, 5.939528e-01, 5.939673e-01,
    5.939819e-01, 5.939965e-01, 5.940111e-01, 5.940257e-01, 5.940402e-01, 5.940548e-01,
    5.940694e-01, 5.940840e-01, 5.940986e-01, 5.941132e-01, 5.941277e-01, 5.941423e-01,
    5.941569e-01, 5.941715e-01, 5.941861e-01, 5.942007e-01, 5.942152e-01, 5.942298e-01,
    5.942444e-01, 5.942590e-01, 5.942736e-01, 5.942882e-01, 5.943027e-01, 5.943173e-01,
    5.943319e-01, 5.943465e-01, 5.943610e-01, 5.943757e-01, 5.943902e-01, 5.944048e-01,
    5.944194e-01, 5.944340e-01, 5.944485e-01, 5.944631e-01, 5.944777e-01, 5.944923e-01,
    5.945069e-01, 5.945215e-01, 5.945360e-01, 5.945506e-01, 5.945652e-01, 5.945798e-01,
    5.945943e-01, 5.946089e-01, 5.946235e-01, 5.946380e-01, 5.946527e-01, 5.946672e-01,
    5.946818e-01, 5.946963e-01, 5.947109e-01, 5.947255e-01, 5.947401e-01, 5.947546e-01,
    5.947692e-01, 5.947838e-01, 5.947984e-01, 5.948130e-01, 5.948275e-01, 5.948421e-01,
    5.948567e-01, 5.948713e-01, 5.948858e-01, 5.949004e-01, 5.949150e-01, 5.949296e-01,
    5.949441e-01, 5.949587e-01, 5.949733e-01, 5.949879e-01, 5.950024e-01, 5.950170e-01,
    5.950316e-01, 5.950462e-01, 5.950608e-01, 5.950753e-01, 5.950899e-01, 5.951045e-01,
    5.951191e-01, 5.951336e-01, 5.951482e-01, 5.951627e-01, 5.951774e-01, 5.951919e-01,
    5.952065e-01, 5.952210e-01, 5.952356e-01, 5.952502e-01, 5.952647e-01, 5.952793e-01,
    5.952939e-01, 5.953085e-01, 5.953231e-01, 5.953376e-01, 5.953522e-01, 5.953667e-01,
    5.953813e-01, 5.953959e-01, 5.954105e-01, 5.954251e-01, 5.954396e-01, 5.954542e-01,
    5.954688e-01, 5.954833e-01, 5.954979e-01, 5.955124e-01, 5.955271e-01, 5.955416e-01,
    5.955562e-01, 5.955707e-01, 5.955853e-01, 5.955999e-01, 5.956144e-01, 5.956290e-01,
    5.956436e-01, 5.956581e-01, 5.956727e-01, 5.956873e-01, 5.957019e-01, 5.957164e-01,
    5.957310e-01, 5.957456e-01, 5.957601e-01, 5.957747e-01, 5.957893e-01, 5.958038e-01,
    5.958184e-01, 5.958329e-01, 5.958475e-01, 5.958620e-01, 5.958766e-01, 5.958912e-01,
    5.959058e-01, 5.959203e-01, 5.959349e-01, 5.959495e-01, 5.959640e-01, 5.959786e-01,
    5.959932e-01, 5.960077e-01, 5.960223e-01, 5.960369e-01, 5.960514e-01, 5.960660e-01,
    5.960805e-01, 5.960951e-01, 5.961097e-01, 5.961242e-01, 5.961388e-01, 5.961534e-01,
    5.961679e-01, 5.961825e-01, 5.961970e-01, 5.962116e-01, 5.962262e-01, 5.962407e-01,
    5.962553e-01, 5.962698e-01, 5.962844e-01, 5.962990e-01, 5.963135e-01, 5.963281e-01,
    5.963427e-01, 5.963572e-01, 5.963718e-01, 5.963864e-01, 5.964009e-01, 5.964155e-01,
    5.964300e-01, 5.964445e-01, 5.964592e-01, 5.964737e-01, 5.964882e-01, 5.965028e-01,
    5.965173e-01, 5.965319e-01, 5.965465e-01, 5.965610e-01, 5.965756e-01, 5.965902e-01,
    5.966047e-01, 5.966192e-01, 5.966339e-01, 5.966484e-01, 5.966629e-01, 5.966775e-01,
    5.966920e-01, 5.967066e-01, 5.967212e-01, 5.967357e-01, 5.967503e-01, 5.967649e-01,
    5.967794e-01, 5.967939e-01, 5.968085e-01, 5.968230e-01, 5.968376e-01, 5.968522e-01,
    5.968667e-01, 5.968813e-01, 5.968958e-01, 5.969104e-01, 5.969250e-01, 5.969395e-01,
    5.969540e-01, 5.969687e-01, 5.969832e-01, 5.969977e-01, 5.970123e-01, 5.970268e-01,
    5.970414e-01, 5.970560e-01, 5.970705e-01, 5.970851e-01, 5.970996e-01, 5.971141e-01,
    5.971287e-01, 5.971432e-01, 5.971578e-01, 5.971723e-01, 5.971869e-01, 5.972015e-01,
    5.972160e-01, 5.972306e-01, 5.972452e-01, 5.972597e-01, 5.972742e-01, 5.972888e-01,
    5.973033e-01, 5.973179e-01, 5.973324e-01, 5.973470e-01, 5.973615e-01, 5.973760e-01,
    5.973907e-01, 5.974052e-01, 5.974197e-01, 5.974343e-01, 5.974488e-01, 5.974634e-01,
    5.974779e-01, 5.974925e-01, 5.975070e-01, 5.975215e-01, 5.975361e-01, 5.975507e-01,
    5.975652e-01, 5.975798e-01, 5.975943e-01, 5.976089e-01, 5.976234e-01, 5.976380e-01,
    5.976525e-01, 5.976670e-01, 5.976816e-01, 5.976962e-01, 5.977107e-01, 5.977252e-01,
    5.977398e-01, 5.977544e-01, 5.977688e-01, 5.977834e-01, 5.977980e-01, 5.978125e-01,
    5.978270e-01, 5.978416e-01, 5.978562e-01, 5.978707e-01, 5.978853e-01, 5.978998e-01,
    5.979143e-01, 5.979289e-01, 5.979434e-01, 5.979580e-01, 5.979725e-01, 5.979871e-01,
    5.980016e-01, 5.980161e-01, 5.980307e-01, 5.980452e-01, 5.980598e-01, 5.980743e-01,
    5.980889e-01, 5.981034e-01, 5.981179e-01, 5.981325e-01, 5.981470e-01, 5.981616e-01,
    5.981761e-01, 5.981907e-01, 5.982052e-01, 5.982197e-01, 5.982343e-01, 5.982488e-01,
    5.982634e-01, 5.982779e-01, 5.982924e-01, 5.983070e-01, 5.983216e-01, 5.983360e-01,
    5.983506e-01, 5.983651e-01, 5.983797e-01, 5.983942e-01, 5.984088e-01, 5.984233e-01,
    5.984378e-01, 5.984524e-01, 5.984669e-01, 5.984815e-01, 5.984960e-01, 5.985106e-01,
    5.985250e-01, 5.985396e-01, 5.985541e-01, 5.985687e-01, 5.985832e-01, 5.985978e-01,
    5.986123e-01, 5.986269e-01, 5.986414e-01, 5.986559e-01, 5.986704e-01, 5.986850e-01,
    5.986995e-01, 5.987141e-01, 5.987286e-01, 5.987431e-01, 5.987577e-01, 5.987722e-01,
    5.987868e-01, 5.988013e-01, 5.988158e-01, 5.988303e-01, 5.988449e-01, 5.988594e-01,
    5.988740e-01, 5.988885e-01, 5.989031e-01, 5.989176e-01, 5.989321e-01, 5.989466e-01,
    5.989612e-01, 5.989757e-01, 5.989903e-01, 5.990048e-01, 5.990193e-01, 5.990338e-01,
    5.990484e-01, 5.990629e-01, 5.990775e-01, 5.990919e-01, 5.991065e-01, 5.991210e-01,
    5.991356e-01, 5.991501e-01, 5.991647e-01, 5.991791e-01, 5.991937e-01, 5.992082e-01,
    5.992228e-01, 5.992373e-01, 5.992518e-01, 5.992664e-01, 5.992809e-01, 5.992954e-01,
    5.993100e-01, 5.993245e-01, 5.993390e-01, 5.993535e-01, 5.993680e-01, 5.993826e-01,
    5.993971e-01, 5.994117e-01, 5.994262e-01, 5.994407e-01, 5.994552e-01, 5.994698e-01,
    5.994843e-01, 5.994989e-01, 5.995134e-01, 5.995279e-01, 5.995424e-01, 5.995569e-01,
    5.995715e-01, 5.995860e-01, 5.996006e-01, 5.996150e-01, 5.996296e-01, 5.996441e-01,
    5.996587e-01, 5.996732e-01, 5.996877e-01, 5.997022e-01, 5.997167e-01, 5.997313e-01,
    5.997458e-01, 5.997604e-01, 5.997748e-01, 5.997894e-01, 5.998039e-01, 5.998184e-01,
    5.998330e-01, 5.998475e-01, 5.998620e-01, 5.998765e-01, 5.998911e-01, 5.999056e-01,
    5.999201e-01, 5.999346e-01, 5.999491e-01, 5.999637e-01, 5.999782e-01, 5.999928e-01,
    6.000073e-01, 6.000218e-01, 6.000363e-01, 6.000508e-01, 6.000654e-01, 6.000798e-01,
    6.000944e-01, 6.001089e-01, 6.001235e-01, 6.001379e-01, 6.001524e-01, 6.001670e-01,
    6.001815e-01, 6.001961e-01, 6.002105e-01, 6.002251e-01, 6.002396e-01, 6.002541e-01,
    6.002687e-01, 6.002831e-01, 6.002977e-01, 6.003122e-01, 6.003267e-01, 6.003413e-01,
    6.003558e-01, 6.003703e-01, 6.003848e-01, 6.003993e-01, 6.004139e-01, 6.004283e-01,
    6.004429e-01, 6.004574e-01, 6.004719e-01, 6.004865e-01, 6.005010e-01, 6.005155e-01,
    6.005300e-01, 6.005445e-01, 6.005591e-01, 6.005735e-01, 6.005881e-01, 6.006026e-01,
    6.006171e-01, 6.006316e-01, 6.006461e-01, 6.006607e-01, 6.006752e-01, 6.006897e-01,
    6.007043e-01, 6.007187e-01, 6.007332e-01, 6.007478e-01, 6.007622e-01, 6.007768e-01,
    6.007913e-01, 6.008058e-01, 6.008204e-01, 6.008348e-01, 6.008494e-01, 6.008639e-01,
    6.008784e-01, 6.008930e-01, 6.009074e-01, 6.009219e-01, 6.009365e-01, 6.009510e-01,
    6.009654e-01, 6.009800e-01, 6.009945e-01, 6.010090e-01, 6.010236e-01, 6.010380e-01,
    6.010526e-01, 6.010671e-01, 6.010816e-01, 6.010961e-01, 6.011106e-01, 6.011251e-01,
    6.011397e-01, 6.011541e-01, 6.011687e-01, 6.011832e-01, 6.011977e-01, 6.012122e-01,
    6.012267e-01, 6.012412e-01, 6.012557e-01, 6.012703e-01, 6.012847e-01, 6.012993e-01,
    6.013138e-01, 6.013283e-01, 6.013428e-01, 6.013573e-01, 6.013718e-01, 6.013863e-01,
    6.014009e-01, 6.014153e-01, 6.014299e-01, 6.014444e-01, 6.014589e-01, 6.014734e-01,
    6.014879e-01, 6.015024e-01, 6.015169e-01, 6.015314e-01, 6.015459e-01, 6.015604e-01,
    6.015750e-01, 6.015894e-01, 6.016039e-01, 6.016185e-01, 6.016330e-01, 6.016474e-01,
    6.016620e-01, 6.016765e-01, 6.016910e-01, 6.017055e-01, 6.017200e-01, 6.017345e-01,
    6.017490e-01, 6.017635e-01, 6.017780e-01, 6.017925e-01, 6.018071e-01, 6.018215e-01,
    6.018360e-01, 6.018506e-01, 6.018651e-01, 6.018795e-01, 6.018941e-01, 6.019086e-01,
    6.019231e-01, 6.019376e-01, 6.019521e-01, 6.019666e-01, 6.019811e-01, 6.019956e-01,
    6.020101e-01, 6.020246e-01, 6.020391e-01, 6.020536e-01, 6.020681e-01, 6.020826e-01,
    6.020971e-01, 6.021116e-01, 6.021261e-01, 6.021406e-01, 6.021551e-01, 6.021696e-01,
    6.021841e-01, 6.021986e-01, 6.022131e-01, 6.022276e-01, 6.022421e-01, 6.022567e-01,
    6.022711e-01, 6.022856e-01, 6.023002e-01, 6.023147e-01, 6.023291e-01, 6.023437e-01,
    6.023582e-01, 6.023726e-01, 6.023872e-01, 6.024017e-01, 6.024162e-01, 6.024307e-01,
    6.024452e-01, 6.024597e-01, 6.024742e-01, 6.024886e-01, 6.025032e-01, 6.025177e-01,
    6.025321e-01, 6.025466e-01, 6.025611e-01, 6.025757e-01, 6.025901e-01, 6.026046e-01,
    6.026191e-01, 6.026336e-01, 6.026481e-01, 6.026626e-01, 6.026771e-01, 6.026916e-01,
    6.027061e-01, 6.027206e-01, 6.027351e-01, 6.027496e-01, 6.027641e-01, 6.027786e-01,
    6.027931e-01, 6.028076e-01, 6.028221e-01, 6.028365e-01, 6.028511e-01, 6.028656e-01,
    6.028801e-01, 6.028945e-01, 6.029090e-01, 6.029235e-01, 6.029380e-01, 6.029525e-01,
    6.029670e-01, 6.029815e-01, 6.029961e-01, 6.030105e-01, 6.030250e-01, 6.030395e-01,
    6.030540e-01, 6.030685e-01, 6.030830e-01, 6.030974e-01, 6.031119e-01, 6.031264e-01,
    6.031409e-01, 6.031554e-01, 6.031699e-01, 6.031844e-01, 6.031989e-01, 6.032134e-01,
    6.032279e-01, 6.032424e-01, 6.032569e-01, 6.032714e-01, 6.032858e-01, 6.033003e-01,
    6.033148e-01, 6.033293e-01, 6.033438e-01, 6.033583e-01, 6.033728e-01, 6.033873e-01,
    6.034018e-01, 6.034163e-01, 6.034307e-01, 6.034452e-01, 6.034597e-01, 6.034742e-01,
    6.034887e-01, 6.035032e-01, 6.035177e-01, 6.035322e-01, 6.035467e-01, 6.035612e-01,
    6.035756e-01, 6.035901e-01, 6.036046e-01, 6.036191e-01, 6.036336e-01, 6.036481e-01,
    6.036626e-01, 6.036770e-01, 6.036915e-01, 6.037060e-01, 6.037205e-01, 6.037350e-01,
    6.037495e-01, 6.037640e-01, 6.037785e-01, 6.037930e-01, 6.038074e-01, 6.038219e-01,
    6.038364e-01, 6.038508e-01, 6.038653e-01, 6.038799e-01, 6.038944e-01, 6.039088e-01,
    6.039233e-01, 6.039378e-01, 6.039523e-01, 6.039667e-01, 6.039812e-01, 6.039957e-01,
    6.040102e-01, 6.040247e-01, 6.040392e-01, 6.040537e-01, 6.040681e-01, 6.040826e-01,
    6.040971e-01, 6.041116e-01, 6.041261e-01, 6.041406e-01, 6.041550e-01, 6.041695e-01,
    6.041840e-01, 6.041985e-01, 6.042130e-01, 6.042274e-01, 6.042419e-01, 6.042564e-01,
    6.042709e-01, 6.042854e-01, 6.042998e-01, 6.043143e-01, 6.043288e-01, 6.043433e-01,
    6.043578e-01, 6.043722e-01, 6.043867e-01, 6.044012e-01, 6.044157e-01, 6.044301e-01,
    6.044446e-01, 6.044591e-01, 6.044736e-01, 6.044881e-01, 6.045026e-01, 6.045170e-01,
    6.045315e-01, 6.045460e-01, 6.045604e-01, 6.045750e-01, 6.045895e-01, 6.046039e-01,
    6.046184e-01, 6.046329e-01, 6.046473e-01, 6.046618e-01, 6.046763e-01, 6.046907e-01,
    6.047052e-01, 6.047197e-01, 6.047342e-01, 6.047487e-01, 6.047632e-01, 6.047776e-01,
    6.047921e-01, 6.048065e-01, 6.048211e-01, 6.048355e-01, 6.048500e-01, 6.048645e-01,
    6.048790e-01, 6.048934e-01, 6.049079e-01, 6.049224e-01, 6.049368e-01, 6.049513e-01,
    6.049658e-01, 6.049803e-01, 6.049947e-01, 6.050092e-01, 6.050237e-01, 6.050382e-01,
    6.050526e-01, 6.050671e-01, 6.050816e-01, 6.050960e-01, 6.051105e-01, 6.051250e-01,
    6.051394e-01, 6.051539e-01, 6.051684e-01, 6.051829e-01, 6.051974e-01, 6.052118e-01,
    6.052263e-01, 6.052408e-01, 6.052552e-01, 6.052697e-01, 6.052842e-01, 6.052986e-01,
    6.053131e-01, 6.053276e-01, 6.053420e-01, 6.053565e-01, 6.053710e-01, 6.053855e-01,
    6.054000e-01, 6.054144e-01, 6.054289e-01, 6.054434e-01, 6.054578e-01, 6.054723e-01,
    6.054868e-01, 6.055012e-01, 6.055157e-01, 6.055301e-01, 6.055446e-01, 6.055591e-01,
    6.055736e-01, 6.055880e-01, 6.056025e-01, 6.056169e-01, 6.056315e-01, 6.056459e-01,
    6.056604e-01, 6.056748e-01, 6.056893e-01, 6.057038e-01, 6.057182e-01, 6.057327e-01,
    6.057472e-01, 6.057616e-01, 6.057761e-01, 6.057906e-01, 6.058050e-01, 6.058195e-01,
    6.058339e-01, 6.058484e-01, 6.058629e-01, 6.058773e-01, 6.058918e-01, 6.059062e-01,
    6.059207e-01, 6.059352e-01, 6.059496e-01, 6.059641e-01, 6.059786e-01, 6.059931e-01,
    6.060075e-01, 6.060220e-01, 6.060365e-01, 6.060509e-01, 6.060653e-01, 6.060798e-01,
    6.060943e-01, 6.061088e-01, 6.061232e-01, 6.061377e-01, 6.061522e-01, 6.061666e-01,
    6.061811e-01, 6.061956e-01, 6.062100e-01, 6.062244e-01, 6.062389e-01, 6.062534e-01,
    6.062678e-01, 6.062823e-01, 6.062968e-01, 6.063112e-01, 6.063257e-01, 6.063402e-01,
    6.063546e-01, 6.063691e-01, 6.063835e-01, 6.063980e-01, 6.064125e-01, 6.064269e-01,
    6.064414e-01, 6.064558e-01, 6.064703e-01, 6.064847e-01, 6.064992e-01, 6.065137e-01,
    6.065281e-01, 6.065426e-01, 6.065570e-01, 6.065715e-01, 6.065859e-01, 6.066004e-01,
    6.066148e-01, 6.066293e-01, 6.066438e-01, 6.066582e-01, 6.066726e-01, 6.066872e-01,
    6.067016e-01, 6.067160e-01, 6.067305e-01, 6.067449e-01, 6.067594e-01, 6.067739e-01,
    6.067883e-01, 6.068028e-01, 6.068172e-01, 6.068317e-01, 6.068462e-01, 6.068606e-01,
    6.068751e-01, 6.068895e-01, 6.069040e-01, 6.069185e-01, 6.069329e-01, 6.069473e-01,
    6.069618e-01, 6.069763e-01, 6.069907e-01, 6.070052e-01, 6.070196e-01, 6.070340e-01,
    6.070485e-01, 6.070629e-01, 6.070774e-01, 6.070919e-01, 6.071063e-01, 6.071208e-01,
    6.071352e-01, 6.071497e-01, 6.071641e-01, 6.071786e-01, 6.071931e-01, 6.072075e-01,
    6.072220e-01, 6.072364e-01, 6.072508e-01, 6.072653e-01, 6.072797e-01, 6.072941e-01,
    6.073086e-01, 6.073231e-01, 6.073375e-01, 6.073520e-01, 6.073664e-01, 6.073809e-01,
    6.073954e-01, 6.074098e-01, 6.074243e-01, 6.074387e-01, 6.074531e-01, 6.074676e-01,
    6.074820e-01, 6.074964e-01, 6.075109e-01, 6.075253e-01, 6.075398e-01, 6.075543e-01,
    6.075687e-01, 6.075832e-01, 6.075976e-01, 6.076121e-01, 6.076266e-01, 6.076410e-01,
    6.076554e-01, 6.076699e-01, 6.076843e-01, 6.076987e-01, 6.077132e-01, 6.077276e-01,
    6.077421e-01, 6.077566e-01, 6.077710e-01, 6.077854e-01, 6.077998e-01, 6.078143e-01,
    6.078287e-01, 6.078432e-01, 6.078576e-01, 6.078721e-01, 6.078865e-01, 6.079010e-01,
    6.079154e-01, 6.079299e-01, 6.079443e-01, 6.079587e-01, 6.079732e-01, 6.079876e-01,
    6.080021e-01, 6.080166e-01, 6.080310e-01, 6.080455e-01, 6.080598e-01, 6.080743e-01,
    6.080887e-01, 6.081032e-01, 6.081176e-01, 6.081321e-01, 6.081465e-01, 6.081610e-01,
    6.081754e-01, 6.081898e-01, 6.082042e-01, 6.082187e-01, 6.082332e-01, 6.082476e-01,
    6.082621e-01, 6.082765e-01, 6.082909e-01, 6.083053e-01, 6.083198e-01, 6.083342e-01,
    6.083487e-01, 6.083632e-01, 6.083776e-01, 6.083920e-01, 6.084064e-01, 6.084208e-01,
    6.084353e-01, 6.084498e-01, 6.084642e-01, 6.084786e-01, 6.084931e-01, 6.085075e-01,
    6.085219e-01, 6.085364e-01, 6.085508e-01, 6.085653e-01, 6.085797e-01, 6.085941e-01,
    6.086086e-01, 6.086230e-01, 6.086375e-01, 6.086519e-01, 6.086664e-01, 6.086808e-01,
    6.086952e-01, 6.087096e-01, 6.087241e-01, 6.087385e-01, 6.087529e-01, 6.087674e-01,
    6.087818e-01, 6.087962e-01, 6.088107e-01, 6.088251e-01, 6.088396e-01, 6.088540e-01,
    6.088684e-01, 6.088828e-01, 6.088973e-01, 6.089117e-01, 6.089262e-01, 6.089406e-01,
    6.089550e-01, 6.089694e-01, 6.089839e-01, 6.089984e-01, 6.090127e-01, 6.090272e-01,
    6.090416e-01, 6.090561e-01, 6.090705e-01, 6.090850e-01, 6.090993e-01, 6.091138e-01,
    6.091282e-01, 6.091427e-01, 6.091571e-01, 6.091715e-01, 6.091859e-01, 6.092004e-01,
    6.092148e-01, 6.092292e-01, 6.092437e-01, 6.092581e-01, 6.092725e-01, 6.092870e-01,
    6.093014e-01, 6.093158e-01, 6.093303e-01, 6.093447e-01, 6.093591e-01, 6.093736e-01,
    6.093880e-01, 6.094024e-01, 6.094168e-01, 6.094313e-01, 6.094457e-01, 6.094601e-01,
    6.094745e-01, 6.094890e-01, 6.095034e-01, 6.095178e-01, 6.095323e-01, 6.095467e-01,
    6.095611e-01, 6.095756e-01, 6.095900e-01, 6.096044e-01, 6.096188e-01, 6.096333e-01,
    6.096477e-01, 6.096621e-01, 6.096765e-01, 6.096910e-01, 6.097054e-01, 6.097198e-01,
    6.097342e-01, 6.097487e-01, 6.097631e-01, 6.097775e-01, 6.097919e-01, 6.098064e-01,
    6.098208e-01, 6.098352e-01, 6.098496e-01, 6.098641e-01, 6.098785e-01, 6.098929e-01,
    6.099074e-01, 6.099218e-01, 6.099362e-01, 6.099506e-01, 6.099651e-01, 6.099795e-01,
    6.099939e-01, 6.100083e-01, 6.100227e-01, 6.100371e-01, 6.100516e-01, 6.100660e-01,
    6.100804e-01, 6.100948e-01, 6.101093e-01, 6.101237e-01, 6.101381e-01, 6.101525e-01,
    6.101670e-01, 6.101814e-01, 6.101958e-01, 6.102102e-01, 6.102246e-01, 6.102391e-01,
    6.102535e-01, 6.102679e-01, 6.102823e-01, 6.102967e-01, 6.103112e-01, 6.103256e-01,
    6.103400e-01, 6.103544e-01, 6.103688e-01, 6.103833e-01, 6.103977e-01, 6.104121e-01,
    6.104265e-01, 6.104409e-01, 6.104554e-01, 6.104698e-01, 6.104842e-01, 6.104987e-01,
    6.105130e-01, 6.105275e-01, 6.105419e-01, 6.105563e-01, 6.105707e-01, 6.105852e-01,
    6.105996e-01, 6.106139e-01, 6.106284e-01, 6.106428e-01, 6.106572e-01, 6.106716e-01,
    6.106861e-01, 6.107005e-01, 6.107149e-01, 6.107293e-01, 6.107437e-01, 6.107581e-01,
    6.107726e-01, 6.107870e-01, 6.108014e-01, 6.108158e-01, 6.108302e-01, 6.108446e-01,
    6.108590e-01, 6.108735e-01, 6.108879e-01, 6.109023e-01, 6.109167e-01, 6.109311e-01,
    6.109455e-01, 6.109599e-01, 6.109744e-01, 6.109887e-01, 6.110032e-01, 6.110176e-01,
    6.110320e-01, 6.110464e-01, 6.110609e-01, 6.110753e-01, 6.110896e-01, 6.111041e-01,
    6.111184e-01, 6.111329e-01, 6.111473e-01, 6.111617e-01, 6.111761e-01, 6.111905e-01,
    6.112049e-01, 6.112193e-01, 6.112338e-01, 6.112482e-01, 6.112626e-01, 6.112770e-01,
    6.112914e-01, 6.113058e-01, 6.113203e-01, 6.113346e-01, 6.113490e-01, 6.113635e-01,
    6.113778e-01, 6.113923e-01, 6.114067e-01, 6.114211e-01, 6.114355e-01, 6.114499e-01,
    6.114643e-01, 6.114787e-01, 6.114931e-01, 6.115076e-01, 6.115220e-01, 6.115364e-01,
    6.115508e-01, 6.115652e-01, 6.115796e-01, 6.115940e-01, 6.116084e-01, 6.116228e-01,
    6.116372e-01, 6.116516e-01, 6.116661e-01, 6.116804e-01, 6.116949e-01, 6.117092e-01,
    6.117237e-01, 6.117381e-01, 6.117525e-01, 6.117669e-01, 6.117813e-01, 6.117957e-01,
    6.118101e-01, 6.118245e-01, 6.118389e-01, 6.118533e-01, 6.118677e-01, 6.118821e-01,
    6.118965e-01, 6.119109e-01, 6.119253e-01, 6.119397e-01, 6.119542e-01, 6.119685e-01,
    6.119829e-01, 6.119974e-01, 6.120117e-01, 6.120262e-01, 6.120405e-01, 6.120549e-01,
    6.120694e-01, 6.120837e-01, 6.120982e-01, 6.121126e-01, 6.121269e-01, 6.121414e-01,
    6.121558e-01, 6.121702e-01, 6.121846e-01, 6.121990e-01, 6.122134e-01, 6.122278e-01,
    6.122422e-01, 6.122566e-01, 6.122710e-01, 6.122854e-01, 6.122998e-01, 6.123142e-01,
    6.123286e-01, 6.123430e-01, 6.123574e-01, 6.123718e-01, 6.123862e-01, 6.124006e-01,
    6.124150e-01, 6.124294e-01, 6.124438e-01, 6.124582e-01, 6.124726e-01, 6.124870e-01,
    6.125014e-01, 6.125158e-01, 6.125302e-01, 6.125446e-01, 6.125590e-01, 6.125734e-01,
    6.125877e-01, 6.126022e-01, 6.126165e-01, 6.126310e-01, 6.126454e-01, 6.126598e-01,
    6.126742e-01, 6.126885e-01, 6.127030e-01, 6.127173e-01, 6.127318e-01, 6.127462e-01,
    6.127605e-01, 6.127749e-01, 6.127893e-01, 6.128037e-01, 6.128181e-01, 6.128325e-01,
    6.128469e-01, 6.128613e-01, 6.128757e-01, 6.128901e-01, 6.129045e-01, 6.129189e-01,
    6.129333e-01, 6.129476e-01, 6.129621e-01, 6.129764e-01, 6.129909e-01, 6.130052e-01,
    6.130196e-01, 6.130340e-01, 6.130484e-01, 6.130628e-01, 6.130772e-01, 6.130916e-01,
    6.131060e-01, 6.131204e-01, 6.131348e-01, 6.131492e-01, 6.131635e-01, 6.131780e-01,
    6.131924e-01, 6.132067e-01, 6.132211e-01, 6.132355e-01, 6.132499e-01, 6.132643e-01,
    6.132787e-01, 6.132931e-01, 6.133075e-01, 6.133218e-01, 6.133363e-01, 6.133506e-01,
    6.133651e-01, 6.133794e-01, 6.133938e-01, 6.134082e-01, 6.134226e-01, 6.134369e-01,
    6.134514e-01, 6.134658e-01, 6.134802e-01, 6.134945e-01, 6.135089e-01, 6.135233e-01,
    6.135377e-01, 6.135520e-01, 6.135665e-01, 6.135809e-01, 6.135952e-01, 6.136096e-01,
    6.136240e-01, 6.136384e-01, 6.136528e-01, 6.136671e-01, 6.136816e-01, 6.136960e-01,
    6.137103e-01, 6.137247e-01, 6.137391e-01, 6.137535e-01, 6.137679e-01, 6.137823e-01,
    6.137967e-01, 6.138110e-01, 6.138254e-01, 6.138398e-01, 6.138542e-01, 6.138686e-01,
    6.138830e-01, 6.138974e-01, 6.139117e-01, 6.139261e-01, 6.139405e-01, 6.139549e-01,
    6.139693e-01, 6.139836e-01, 6.139981e-01, 6.140124e-01, 6.140268e-01, 6.140412e-01,
    6.140556e-01, 6.140699e-01, 6.140844e-01, 6.140987e-01, 6.141131e-01, 6.141275e-01,
    6.141419e-01, 6.141562e-01, 6.141706e-01, 6.141850e-01, 6.141994e-01, 6.142138e-01,
    6.142282e-01, 6.142426e-01, 6.142569e-01, 6.142713e-01, 6.142857e-01, 6.143001e-01,
    6.143144e-01, 6.143288e-01, 6.143432e-01, 6.143576e-01, 6.143720e-01, 6.143863e-01,
    6.144007e-01, 6.144151e-01, 6.144295e-01, 6.144439e-01, 6.144583e-01, 6.144726e-01,
    6.144870e-01, 6.145014e-01, 6.145158e-01, 6.145301e-01, 6.145445e-01, 6.145589e-01,
    6.145732e-01, 6.145877e-01, 6.146020e-01, 6.146164e-01, 6.146308e-01, 6.146451e-01,
    6.146595e-01, 6.146739e-01, 6.146883e-01, 6.147026e-01, 6.147170e-01, 6.147314e-01,
    6.147458e-01, 6.147602e-01, 6.147745e-01, 6.147889e-01, 6.148033e-01, 6.148177e-01,
    6.148320e-01, 6.148464e-01, 6.148608e-01, 6.148751e-01, 6.148895e-01, 6.149039e-01,
    6.149183e-01, 6.149327e-01, 6.149470e-01, 6.149614e-01, 6.149758e-01, 6.149901e-01,
    6.150045e-01, 6.150189e-01, 6.150333e-01, 6.150477e-01, 6.150620e-01, 6.150764e-01,
    6.150907e-01, 6.151052e-01, 6.151195e-01, 6.151339e-01, 6.151482e-01, 6.151626e-01,
    6.151770e-01, 6.151913e-01, 6.152058e-01, 6.152201e-01, 6.152345e-01, 6.152489e-01,
    6.152632e-01, 6.152776e-01, 6.152920e-01, 6.153063e-01, 6.153207e-01, 6.153351e-01,
    6.153495e-01, 6.153638e-01, 6.153782e-01, 6.153926e-01, 6.154069e-01, 6.154213e-01,
    6.154357e-01, 6.154500e-01, 6.154644e-01, 6.154788e-01, 6.154931e-01, 6.155075e-01,
    6.155218e-01, 6.155362e-01, 6.155506e-01, 6.155650e-01, 6.155794e-01, 6.155937e-01,
    6.156081e-01, 6.156224e-01, 6.156368e-01, 6.156512e-01, 6.156656e-01, 6.156799e-01,
    6.156943e-01, 6.157086e-01, 6.157230e-01, 6.157374e-01, 6.157517e-01, 6.157661e-01,
    6.157805e-01, 6.157948e-01, 6.158092e-01, 6.158236e-01, 6.158379e-01, 6.158524e-01,
    6.158667e-01, 6.158810e-01, 6.158954e-01, 6.159098e-01, 6.159241e-01, 6.159385e-01,
    6.159528e-01, 6.159672e-01, 6.159816e-01, 6.159959e-01, 6.160103e-01, 6.160247e-01,
    6.160390e-01, 6.160534e-01, 6.160678e-01, 6.160821e-01, 6.160965e-01, 6.161109e-01,
    6.161252e-01, 6.161396e-01, 6.161540e-01, 6.161683e-01, 6.161827e-01, 6.161970e-01,
    6.162114e-01, 6.162257e-01, 6.162401e-01, 6.162544e-01, 6.162688e-01, 6.162832e-01,
    6.162975e-01, 6.163119e-01, 6.163263e-01, 6.163406e-01, 6.163550e-01, 6.163694e-01,
    6.163837e-01, 6.163981e-01, 6.164125e-01, 6.164268e-01, 6.164411e-01, 6.164555e-01,
    6.164699e-01, 6.164842e-01, 6.164986e-01, 6.165130e-01, 6.165273e-01, 6.165417e-01,
    6.165560e-01, 6.165704e-01, 6.165847e-01, 6.165991e-01, 6.166134e-01, 6.166278e-01,
    6.166422e-01, 6.166565e-01, 6.166709e-01, 6.166852e-01, 6.166996e-01, 6.167139e-01,
    6.167283e-01, 6.167427e-01, 6.167570e-01, 6.167713e-01, 6.167857e-01, 6.168001e-01,
    6.168144e-01, 6.168288e-01, 6.168432e-01, 6.168575e-01, 6.168718e-01, 6.168862e-01,
    6.169006e-01, 6.169149e-01, 6.169293e-01, 6.169437e-01, 6.169580e-01, 6.169723e-01,
    6.169867e-01, 6.170011e-01, 6.170154e-01, 6.170298e-01, 6.170442e-01, 6.170585e-01,
    6.170728e-01, 6.170872e-01, 6.171016e-01, 6.171159e-01, 6.171302e-01, 6.171446e-01,
    6.171589e-01, 6.171733e-01, 6.171876e-01, 6.172020e-01, 6.172163e-01, 6.172307e-01,
    6.172450e-01, 6.172594e-01, 6.172737e-01, 6.172881e-01, 6.173024e-01, 6.173168e-01,
    6.173311e-01, 6.173455e-01, 6.173598e-01, 6.173742e-01, 6.173885e-01, 6.174029e-01,
    6.174172e-01, 6.174316e-01, 6.174459e-01, 6.174603e-01, 6.174746e-01, 6.174890e-01,
    6.175033e-01, 6.175177e-01, 6.175320e-01, 6.175464e-01, 6.175607e-01, 6.175750e-01,
    6.175894e-01, 6.176038e-01, 6.176181e-01, 6.176324e-01, 6.176468e-01, 6.176612e-01,
    6.176755e-01, 6.176898e-01, 6.177042e-01, 6.177186e-01, 6.177329e-01, 6.177472e-01,
    6.177616e-01, 6.177759e-01, 6.177903e-01, 6.178046e-01, 6.178190e-01, 6.178333e-01,
    6.178477e-01, 6.178620e-01, 6.178764e-01, 6.178907e-01, 6.179050e-01, 6.179194e-01,
    6.179337e-01, 6.179481e-01, 6.179624e-01, 6.179767e-01, 6.179911e-01, 6.180055e-01,
    6.180198e-01, 6.180341e-01, 6.180485e-01, 6.180628e-01, 6.180772e-01, 6.180915e-01,
    6.181059e-01, 6.181202e-01, 6.181346e-01, 6.181489e-01, 6.181632e-01, 6.181776e-01,
    6.181919e-01, 6.182063e-01, 6.182206e-01, 6.182349e-01, 6.182492e-01, 6.182636e-01,
    6.182779e-01, 6.182923e-01, 6.183066e-01, 6.183209e-01, 6.183353e-01, 6.183497e-01,
    6.183640e-01, 6.183783e-01, 6.183927e-01, 6.184070e-01, 6.184214e-01, 6.184357e-01,
    6.184500e-01, 6.184644e-01, 6.184787e-01, 6.184930e-01, 6.185074e-01, 6.185217e-01,
    6.185361e-01, 6.185504e-01, 6.185647e-01, 6.185791e-01, 6.185935e-01, 6.186078e-01,
    6.186221e-01, 6.186364e-01, 6.186507e-01, 6.186651e-01, 6.186794e-01, 6.186938e-01,
    6.187081e-01, 6.187224e-01, 6.187368e-01, 6.187512e-01, 6.187655e-01, 6.187798e-01,
    6.187941e-01, 6.188084e-01, 6.188228e-01, 6.188371e-01, 6.188514e-01, 6.188658e-01,
    6.188802e-01, 6.188945e-01, 6.189088e-01, 6.189231e-01, 6.189375e-01, 6.189518e-01,
    6.189662e-01, 6.189805e-01, 6.189948e-01, 6.190091e-01, 6.190235e-01, 6.190378e-01,
    6.190522e-01, 6.190665e-01, 6.190808e-01, 6.190951e-01, 6.191095e-01, 6.191238e-01,
    6.191381e-01, 6.191525e-01, 6.191669e-01, 6.191812e-01, 6.191955e-01, 6.192098e-01,
    6.192241e-01, 6.192384e-01, 6.192528e-01, 6.192671e-01, 6.192815e-01, 6.192958e-01,
    6.193101e-01, 6.193244e-01, 6.193388e-01, 6.193531e-01, 6.193674e-01, 6.193818e-01,
    6.193961e-01, 6.194105e-01, 6.194248e-01, 6.194391e-01, 6.194534e-01, 6.194677e-01,
    6.194820e-01, 6.194964e-01, 6.195108e-01, 6.195251e-01, 6.195394e-01, 6.195537e-01,
    6.195680e-01, 6.195824e-01, 6.195967e-01, 6.196110e-01, 6.196254e-01, 6.196397e-01,
    6.196540e-01, 6.196683e-01, 6.196827e-01, 6.196970e-01, 6.197113e-01, 6.197256e-01,
    6.197399e-01, 6.197543e-01, 6.197686e-01, 6.197829e-01, 6.197973e-01, 6.198116e-01,
    6.198260e-01, 6.198403e-01, 6.198546e-01, 6.198689e-01, 6.198832e-01, 6.198975e-01,
    6.199119e-01, 6.199262e-01, 6.199405e-01, 6.199548e-01, 6.199692e-01, 6.199835e-01,
    6.199979e-01, 6.200122e-01, 6.200265e-01, 6.200408e-01, 6.200551e-01, 6.200694e-01,
    6.200837e-01, 6.200981e-01, 6.201124e-01, 6.201267e-01, 6.201411e-01, 6.201554e-01,
    6.201697e-01, 6.201840e-01, 6.201983e-01, 6.202127e-01, 6.202270e-01, 6.202413e-01,
    6.202556e-01, 6.202700e-01, 6.202843e-01, 6.202986e-01, 6.203129e-01, 6.203272e-01,
    6.203415e-01, 6.203558e-01, 6.203702e-01, 6.203845e-01, 6.203988e-01, 6.204131e-01,
    6.204274e-01, 6.204418e-01, 6.204561e-01, 6.204705e-01, 6.204848e-01, 6.204991e-01,
    6.205134e-01, 6.205277e-01, 6.205420e-01, 6.205564e-01, 6.205707e-01, 6.205850e-01,
    6.205993e-01, 6.206136e-01, 6.206279e-01, 6.206422e-01, 6.206565e-01, 6.206709e-01,
    6.206852e-01, 6.206995e-01, 6.207138e-01, 6.207282e-01, 6.207425e-01, 6.207568e-01,
    6.207711e-01, 6.207854e-01, 6.207997e-01, 6.208140e-01, 6.208283e-01, 6.208426e-01,
    6.208570e-01, 6.208713e-01, 6.208856e-01, 6.208999e-01, 6.209143e-01, 6.209286e-01,
    6.209429e-01, 6.209572e-01, 6.209715e-01, 6.209859e-01, 6.210002e-01, 6.210144e-01,
    6.210287e-01, 6.210431e-01, 6.210574e-01, 6.210717e-01, 6.210860e-01, 6.211004e-01,
    6.211147e-01, 6.211290e-01, 6.211433e-01, 6.211576e-01, 6.211719e-01, 6.211862e-01,
    6.212005e-01, 6.212148e-01, 6.212292e-01, 6.212435e-01, 6.212577e-01, 6.212721e-01,
    6.212864e-01, 6.213007e-01, 6.213150e-01, 6.213293e-01, 6.213436e-01, 6.213579e-01,
    6.213722e-01, 6.213866e-01, 6.214009e-01, 6.214152e-01, 6.214294e-01, 6.214438e-01,
    6.214581e-01, 6.214724e-01, 6.214867e-01, 6.215010e-01, 6.215153e-01, 6.215296e-01,
    6.215439e-01, 6.215583e-01, 6.215726e-01, 6.215869e-01, 6.216012e-01, 6.216155e-01,
    6.216298e-01, 6.216441e-01, 6.216584e-01, 6.216727e-01, 6.216871e-01, 6.217013e-01,
    6.217157e-01, 6.217300e-01, 6.217443e-01, 6.217586e-01, 6.217729e-01, 6.217872e-01,
    6.218015e-01, 6.218158e-01, 6.218301e-01, 6.218444e-01, 6.218587e-01, 6.218730e-01,
    6.218873e-01, 6.219016e-01, 6.219159e-01, 6.219302e-01, 6.219445e-01, 6.219589e-01,
    6.219732e-01, 6.219875e-01, 6.220018e-01, 6.220161e-01, 6.220304e-01, 6.220446e-01,
    6.220590e-01, 6.220733e-01, 6.220875e-01, 6.221019e-01, 6.221162e-01, 6.221305e-01,
    6.221448e-01, 6.221591e-01, 6.221734e-01, 6.221877e-01, 6.222020e-01, 6.222163e-01,
    6.222306e-01, 6.222449e-01, 6.222592e-01, 6.222735e-01, 6.222878e-01, 6.223021e-01,
    6.223164e-01, 6.223307e-01, 6.223450e-01, 6.223593e-01, 6.223736e-01, 6.223879e-01,
    6.224022e-01, 6.224165e-01, 6.224308e-01, 6.224451e-01, 6.224594e-01, 6.224737e-01,
    6.224880e-01, 6.225023e-01, 6.225166e-01, 6.225309e-01, 6.225452e-01, 6.225595e-01,
    6.225738e-01, 6.225881e-01, 6.226024e-01, 6.226167e-01, 6.226310e-01, 6.226453e-01,
    6.226596e-01, 6.226739e-01, 6.226882e-01, 6.227025e-01, 6.227168e-01, 6.227311e-01,
    6.227453e-01, 6.227596e-01, 6.227739e-01, 6.227883e-01, 6.228026e-01, 6.228169e-01,
    6.228311e-01, 6.228455e-01, 6.228597e-01, 6.228740e-01, 6.228883e-01, 6.229026e-01,
    6.229169e-01, 6.229312e-01, 6.229455e-01, 6.229598e-01, 6.229741e-01, 6.229884e-01,
    6.230027e-01, 6.230170e-01, 6.230313e-01, 6.230456e-01, 6.230599e-01, 6.230741e-01,
    6.230885e-01, 6.231027e-01, 6.231170e-01, 6.231313e-01, 6.231456e-01, 6.231599e-01,
    6.231742e-01, 6.231885e-01, 6.232028e-01, 6.232170e-01, 6.232314e-01, 6.232457e-01,
    6.232600e-01, 6.232743e-01, 6.232885e-01, 6.233028e-01, 6.233171e-01, 6.233314e-01,
    6.233457e-01, 6.233600e-01, 6.233743e-01, 6.233886e-01, 6.234028e-01, 6.234171e-01,
    6.234314e-01, 6.234457e-01, 6.234600e-01, 6.234743e-01, 6.234885e-01, 6.235029e-01,
    6.235172e-01, 6.235315e-01, 6.235458e-01, 6.235600e-01, 6.235743e-01, 6.235886e-01,
    6.236029e-01, 6.236172e-01, 6.236315e-01, 6.236458e-01, 6.236600e-01, 6.236743e-01,
    6.236886e-01, 6.237029e-01, 6.237172e-01, 6.237315e-01, 6.237458e-01, 6.237600e-01,
    6.237743e-01, 6.237887e-01, 6.238029e-01, 6.238172e-01, 6.238315e-01, 6.238458e-01,
    6.238601e-01, 6.238743e-01, 6.238887e-01, 6.239029e-01, 6.239172e-01, 6.239315e-01,
    6.239458e-01, 6.239601e-01, 6.239743e-01, 6.239886e-01, 6.240029e-01, 6.240172e-01,
    6.240315e-01, 6.240457e-01, 6.240600e-01, 6.240743e-01, 6.240886e-01, 6.241029e-01,
    6.241172e-01, 6.241314e-01, 6.241457e-01, 6.241601e-01, 6.241743e-01, 6.241886e-01,
    6.242028e-01, 6.242172e-01, 6.242315e-01, 6.242457e-01, 6.242600e-01, 6.242743e-01,
    6.242886e-01, 6.243028e-01, 6.243172e-01, 6.243314e-01, 6.243457e-01, 6.243600e-01,
    6.243743e-01, 6.243885e-01, 6.244028e-01, 6.244171e-01, 6.244314e-01, 6.244457e-01,
    6.244599e-01, 6.244742e-01, 6.244885e-01, 6.245028e-01, 6.245170e-01, 6.245313e-01,
    6.245456e-01, 6.245599e-01, 6.245742e-01, 6.245884e-01, 6.246027e-01, 6.246170e-01,
    6.246313e-01, 6.246455e-01, 6.246598e-01, 6.246741e-01, 6.246884e-01, 6.247026e-01,
    6.247169e-01, 6.247312e-01, 6.247455e-01, 6.247598e-01, 6.247740e-01, 6.247883e-01,
    6.248026e-01, 6.248169e-01, 6.248311e-01, 6.248454e-01, 6.248597e-01, 6.248740e-01,
    6.248882e-01, 6.249025e-01, 6.249168e-01, 6.249311e-01, 6.249453e-01, 6.249596e-01,
    6.249739e-01, 6.249882e-01, 6.250024e-01, 6.250167e-01, 6.250310e-01, 6.250453e-01,
    6.250595e-01, 6.250739e-01, 6.250881e-01, 6.251024e-01, 6.251166e-01, 6.251310e-01,
    6.251452e-01, 6.251594e-01, 6.251737e-01, 6.251880e-01, 6.252022e-01, 6.252165e-01,
    6.252308e-01, 6.252451e-01, 6.252593e-01, 6.252736e-01, 6.252879e-01, 6.253022e-01,
    6.253164e-01, 6.253307e-01, 6.253450e-01, 6.253593e-01, 6.253735e-01, 6.253878e-01,
    6.254020e-01, 6.254163e-01, 6.254306e-01, 6.254449e-01, 6.254591e-01, 6.254734e-01,
    6.254877e-01, 6.255019e-01, 6.255162e-01, 6.255305e-01, 6.255447e-01, 6.255590e-01,
    6.255733e-01, 6.255876e-01, 6.256018e-01, 6.256161e-01, 6.256304e-01, 6.256446e-01,
    6.256589e-01, 6.256732e-01, 6.256875e-01, 6.257017e-01, 6.257160e-01, 6.257302e-01,
    6.257445e-01, 6.257588e-01, 6.257731e-01, 6.257873e-01, 6.258016e-01, 6.258159e-01,
    6.258301e-01, 6.258444e-01, 6.258586e-01, 6.258729e-01, 6.258872e-01, 6.259015e-01,
    6.259157e-01, 6.259300e-01, 6.259443e-01, 6.259585e-01, 6.259727e-01, 6.259870e-01,
    6.260013e-01, 6.260155e-01, 6.260298e-01, 6.260440e-01, 6.260583e-01, 6.260726e-01,
    6.260869e-01, 6.261011e-01, 6.261154e-01, 6.261297e-01, 6.261439e-01, 6.261582e-01,
    6.261724e-01, 6.261867e-01, 6.262010e-01, 6.262152e-01, 6.262295e-01, 6.262438e-01,
    6.262580e-01, 6.262723e-01, 6.262866e-01, 6.263008e-01, 6.263151e-01, 6.263294e-01,
    6.263435e-01, 6.263579e-01, 6.263721e-01, 6.263863e-01, 6.264006e-01, 6.264149e-01,
    6.264291e-01, 6.264434e-01, 6.264577e-01, 6.264719e-01, 6.264862e-01, 6.265005e-01,
    6.265147e-01, 6.265290e-01, 6.265432e-01, 6.265575e-01, 6.265718e-01, 6.265860e-01,
    6.266003e-01, 6.266145e-01, 6.266288e-01, 6.266431e-01, 6.266573e-01, 6.266716e-01,
    6.266858e-01, 6.267000e-01, 6.267143e-01, 6.267286e-01, 6.267428e-01, 6.267571e-01,
    6.267713e-01, 6.267856e-01, 6.267999e-01, 6.268141e-01, 6.268284e-01, 6.268426e-01,
    6.268569e-01, 6.268711e-01, 6.268854e-01, 6.268997e-01, 6.269139e-01, 6.269282e-01,
    6.269424e-01, 6.269567e-01, 6.269709e-01, 6.269852e-01, 6.269994e-01, 6.270137e-01,
    6.270279e-01, 6.270422e-01, 6.270564e-01, 6.270707e-01, 6.270850e-01, 6.270992e-01,
    6.271135e-01, 6.271277e-01, 6.271420e-01, 6.271563e-01, 6.271704e-01, 6.271847e-01,
    6.271990e-01, 6.272132e-01, 6.272275e-01, 6.272417e-01, 6.272560e-01, 6.272703e-01,
    6.272845e-01, 6.272988e-01, 6.273130e-01, 6.273273e-01, 6.273415e-01, 6.273558e-01,
    6.273700e-01, 6.273842e-01, 6.273985e-01, 6.274127e-01, 6.274270e-01, 6.274412e-01,
    6.274555e-01, 6.274698e-01, 6.274840e-01, 6.274983e-01, 6.275125e-01, 6.275268e-01,
    6.275410e-01, 6.275553e-01, 6.275695e-01, 6.275837e-01, 6.275980e-01, 6.276122e-01,
    6.276265e-01, 6.276407e-01, 6.276550e-01, 6.276693e-01, 6.276835e-01, 6.276977e-01,
    6.277120e-01, 6.277262e-01, 6.277405e-01, 6.277547e-01, 6.277690e-01, 6.277832e-01,
    6.277975e-01, 6.278117e-01, 6.278260e-01, 6.278402e-01, 6.278545e-01, 6.278687e-01,
    6.278830e-01, 6.278972e-01, 6.279114e-01, 6.279257e-01, 6.279399e-01, 6.279542e-01,
    6.279684e-01, 6.279827e-01, 6.279969e-01, 6.280112e-01, 6.280254e-01, 6.280396e-01,
    6.280539e-01, 6.280681e-01, 6.280823e-01, 6.280966e-01, 6.281109e-01, 6.281251e-01,
    6.281393e-01, 6.281536e-01, 6.281678e-01, 6.281821e-01, 6.281963e-01, 6.282105e-01,
    6.282248e-01, 6.282390e-01, 6.282533e-01, 6.282675e-01, 6.282818e-01, 6.282960e-01,
    6.283103e-01, 6.283245e-01, 6.283388e-01, 6.283530e-01, 6.283672e-01, 6.283814e-01,
    6.283957e-01, 6.284099e-01, 6.284242e-01, 6.284384e-01, 6.284527e-01, 6.284669e-01,
    6.284811e-01, 6.284954e-01, 6.285096e-01, 6.285238e-01, 6.285381e-01, 6.285523e-01,
    6.285666e-01, 6.285808e-01, 6.285951e-01, 6.286093e-01, 6.286235e-01, 6.286378e-01,
    6.286520e-01, 6.286662e-01, 6.286805e-01, 6.286947e-01, 6.287090e-01, 6.287232e-01,
    6.287374e-01, 6.287517e-01, 6.287659e-01, 6.287801e-01, 6.287944e-01, 6.288086e-01,
    6.288229e-01, 6.288371e-01, 6.288514e-01, 6.288655e-01, 6.288798e-01, 6.288940e-01,
    6.289083e-01, 6.289225e-01, 6.289367e-01, 6.289510e-01, 6.289652e-01, 6.289794e-01,
    6.289937e-01, 6.290079e-01, 6.290222e-01, 6.290364e-01, 6.290506e-01, 6.290649e-01,
    6.290791e-01, 6.290933e-01, 6.291075e-01, 6.291218e-01, 6.291360e-01, 6.291503e-01,
    6.291645e-01, 6.291787e-01, 6.291929e-01, 6.292072e-01, 6.292214e-01, 6.292356e-01,
    6.292499e-01, 6.292641e-01, 6.292783e-01, 6.292925e-01, 6.293068e-01, 6.293210e-01,
    6.293352e-01, 6.293495e-01, 6.293637e-01, 6.293780e-01, 6.293922e-01, 6.294064e-01,
    6.294206e-01, 6.294349e-01, 6.294491e-01, 6.294633e-01, 6.294776e-01, 6.294918e-01,
    6.295061e-01, 6.295202e-01, 6.295345e-01, 6.295487e-01, 6.295630e-01, 6.295772e-01,
    6.295914e-01, 6.296057e-01, 6.296199e-01, 6.296341e-01, 6.296483e-01, 6.296625e-01,
    6.296768e-01, 6.296910e-01, 6.297053e-01, 6.297194e-01, 6.297337e-01, 6.297479e-01,
    6.297622e-01, 6.297764e-01, 6.297906e-01, 6.298048e-01, 6.298190e-01, 6.298333e-01,
    6.298475e-01, 6.298617e-01, 6.298760e-01, 6.298902e-01, 6.299044e-01, 6.299186e-01,
    6.299328e-01, 6.299471e-01, 6.299613e-01, 6.299756e-01, 6.299898e-01, 6.300040e-01,
    6.300182e-01, 6.300324e-01, 6.300467e-01, 6.300609e-01, 6.300751e-01, 6.300893e-01,
    6.301035e-01, 6.301178e-01, 6.301320e-01, 6.301463e-01, 6.301605e-01, 6.301746e-01,
    6.301889e-01, 6.302031e-01, 6.302174e-01, 6.302316e-01, 6.302457e-01, 6.302600e-01,
    6.302742e-01, 6.302885e-01, 6.303027e-01, 6.303169e-01, 6.303311e-01, 6.303453e-01,
    6.303596e-01, 6.303738e-01, 6.303880e-01, 6.304022e-01, 6.304165e-01, 6.304306e-01,
    6.304449e-01, 6.304591e-01, 6.304734e-01, 6.304876e-01, 6.305017e-01, 6.305160e-01,
    6.305302e-01, 6.305444e-01, 6.305587e-01, 6.305729e-01, 6.305871e-01, 6.306013e-01,
    6.306155e-01, 6.306297e-01, 6.306440e-01, 6.306582e-01, 6.306724e-01, 6.306866e-01,
    6.307008e-01, 6.307151e-01, 6.307293e-01, 6.307435e-01, 6.307577e-01, 6.307719e-01,
    6.307861e-01, 6.308004e-01, 6.308146e-01, 6.308288e-01, 6.308430e-01, 6.308572e-01,
    6.308714e-01, 6.308857e-01, 6.308998e-01, 6.309141e-01, 6.309283e-01, 6.309425e-01,
    6.309568e-01, 6.309710e-01, 6.309851e-01, 6.309994e-01, 6.310136e-01, 6.310278e-01,
    6.310420e-01, 6.310562e-01, 6.310705e-01, 6.310847e-01, 6.310989e-01, 6.311131e-01,
    6.311273e-01, 6.311415e-01, 6.311557e-01, 6.311700e-01, 6.311842e-01, 6.311984e-01,
    6.312126e-01, 6.312268e-01, 6.312410e-01, 6.312552e-01, 6.312695e-01, 6.312836e-01,
    6.312979e-01, 6.313121e-01, 6.313263e-01, 6.313405e-01, 6.313547e-01, 6.313689e-01,
    6.313831e-01, 6.313973e-01, 6.314116e-01, 6.314257e-01, 6.314400e-01, 6.314542e-01,
    6.314684e-01, 6.314826e-01, 6.314968e-01, 6.315110e-01, 6.315252e-01, 6.315394e-01,
    6.315536e-01, 6.315678e-01, 6.315821e-01, 6.315963e-01, 6.316105e-01, 6.316247e-01,
    6.316389e-01, 6.316531e-01, 6.316673e-01, 6.316815e-01, 6.316957e-01, 6.317099e-01,
    6.317242e-01, 6.317384e-01, 6.317526e-01, 6.317668e-01, 6.317810e-01, 6.317952e-01,
    6.318094e-01, 6.318236e-01, 6.318378e-01, 6.318520e-01, 6.318662e-01, 6.318804e-01,
    6.318946e-01, 6.319088e-01, 6.319230e-01, 6.319373e-01, 6.319515e-01, 6.319657e-01,
    6.319799e-01, 6.319941e-01, 6.320083e-01, 6.320225e-01, 6.320367e-01, 6.320509e-01,
    6.320651e-01, 6.320793e-01, 6.320935e-01, 6.321077e-01, 6.321219e-01, 6.321361e-01,
    6.321503e-01, 6.321645e-01, 6.321787e-01, 6.321930e-01, 6.322072e-01, 6.322213e-01,
    6.322356e-01, 6.322498e-01, 6.322640e-01, 6.322782e-01, 6.322924e-01, 6.323066e-01,
    6.323208e-01, 6.323349e-01, 6.323491e-01, 6.323634e-01, 6.323776e-01, 6.323918e-01,
    6.324059e-01, 6.324202e-01, 6.324344e-01, 6.324486e-01, 6.324627e-01, 6.324770e-01,
    6.324912e-01, 6.325054e-01, 6.325195e-01, 6.325338e-01, 6.325480e-01, 6.325622e-01,
    6.325764e-01, 6.325906e-01, 6.326048e-01, 6.326190e-01, 6.326331e-01, 6.326474e-01,
    6.326616e-01, 6.326758e-01, 6.326900e-01, 6.327042e-01, 6.327184e-01, 6.327326e-01,
    6.327468e-01, 6.327610e-01, 6.327752e-01, 6.327894e-01, 6.328036e-01, 6.328177e-01,
    6.328319e-01, 6.328462e-01, 6.328604e-01, 6.328745e-01, 6.328887e-01, 6.329029e-01,
    6.329171e-01, 6.329314e-01, 6.329455e-01, 6.329597e-01, 6.329739e-01, 6.329881e-01,
    6.330023e-01, 6.330165e-01, 6.330307e-01, 6.330449e-01, 6.330591e-01, 6.330733e-01,
    6.330875e-01, 6.331017e-01, 6.331159e-01, 6.331301e-01, 6.331443e-01, 6.331584e-01,
    6.331726e-01, 6.331868e-01, 6.332010e-01, 6.332152e-01, 6.332294e-01, 6.332436e-01,
    6.332578e-01, 6.332720e-01, 6.332862e-01, 6.333004e-01, 6.333145e-01, 6.333287e-01,
    6.333429e-01, 6.333571e-01, 6.333714e-01, 6.333855e-01, 6.333997e-01, 6.334139e-01,
    6.334281e-01, 6.334423e-01, 6.334565e-01, 6.334707e-01, 6.334848e-01, 6.334990e-01,
    6.335132e-01, 6.335274e-01, 6.335416e-01, 6.335558e-01, 6.335700e-01, 6.335841e-01,
    6.335984e-01, 6.336126e-01, 6.336268e-01, 6.336409e-01, 6.336551e-01, 6.336693e-01,
    6.336835e-01, 6.336977e-01, 6.337119e-01, 6.337261e-01, 6.337402e-01, 6.337544e-01,
    6.337686e-01, 6.337828e-01, 6.337970e-01, 6.338112e-01, 6.338254e-01, 6.338395e-01,
    6.338537e-01, 6.338679e-01, 6.338821e-01, 6.338963e-01, 6.339105e-01, 6.339247e-01,
    6.339389e-01, 6.339531e-01, 6.339673e-01, 6.339815e-01, 6.339956e-01, 6.340098e-01,
    6.340240e-01, 6.340382e-01, 6.340523e-01, 6.340665e-01, 6.340807e-01, 6.340949e-01,
    6.341091e-01, 6.341233e-01, 6.341375e-01, 6.341516e-01, 6.341658e-01, 6.341800e-01,
    6.341942e-01, 6.342084e-01, 6.342226e-01, 6.342368e-01, 6.342509e-01, 6.342651e-01,
    6.342793e-01, 6.342935e-01, 6.343077e-01, 6.343219e-01, 6.343361e-01, 6.343502e-01,
    6.343644e-01, 6.343786e-01, 6.343927e-01, 6.344069e-01, 6.344211e-01, 6.344353e-01,
    6.344495e-01, 6.344637e-01, 6.344779e-01, 6.344920e-01, 6.345062e-01, 6.345204e-01,
    6.345345e-01, 6.345487e-01, 6.345629e-01, 6.345771e-01, 6.345913e-01, 6.346055e-01,
    6.346197e-01, 6.346338e-01, 6.346480e-01, 6.346622e-01, 6.346763e-01, 6.346905e-01,
    6.347047e-01, 6.347189e-01, 6.347331e-01, 6.347473e-01, 6.347615e-01, 6.347756e-01,
    6.347898e-01, 6.348040e-01, 6.348181e-01, 6.348323e-01, 6.348465e-01, 6.348607e-01,
    6.348749e-01, 6.348890e-01, 6.349032e-01, 6.349174e-01, 6.349316e-01, 6.349457e-01,
    6.349599e-01, 6.349741e-01, 6.349882e-01, 6.350024e-01, 6.350166e-01, 6.350308e-01,
    6.350449e-01, 6.350591e-01, 6.350733e-01, 6.350875e-01, 6.351017e-01, 6.351159e-01,
    6.351300e-01, 6.351442e-01, 6.351584e-01, 6.351725e-01, 6.351867e-01, 6.352009e-01,
    6.352150e-01, 6.352292e-01, 6.352434e-01, 6.352575e-01, 6.352717e-01, 6.352859e-01,
    6.353001e-01, 6.353143e-01, 6.353284e-01, 6.353426e-01, 6.353568e-01, 6.353710e-01,
    6.353852e-01, 6.353993e-01, 6.354135e-01, 6.354277e-01, 6.354418e-01, 6.354560e-01,
    6.354702e-01, 6.354843e-01, 6.354985e-01, 6.355127e-01, 6.355268e-01, 6.355410e-01,
    6.355551e-01, 6.355693e-01, 6.355835e-01, 6.355977e-01, 6.356118e-01, 6.356260e-01,
    6.356402e-01, 6.356544e-01, 6.356685e-01, 6.356827e-01, 6.356968e-01, 6.357110e-01,
    6.357252e-01, 6.357394e-01, 6.357536e-01, 6.357677e-01, 6.357819e-01, 6.357960e-01,
    6.358103e-01, 6.358244e-01, 6.358386e-01, 6.358527e-01, 6.358669e-01, 6.358811e-01,
    6.358953e-01, 6.359094e-01, 6.359236e-01, 6.359377e-01, 6.359519e-01, 6.359661e-01,
    6.359802e-01, 6.359944e-01, 6.360085e-01, 6.360227e-01, 6.360369e-01, 6.360511e-01,
    6.360652e-01, 6.360794e-01, 6.360935e-01, 6.361077e-01, 6.361219e-01, 6.361361e-01,
    6.361502e-01, 6.361644e-01, 6.361786e-01, 6.361927e-01, 6.362069e-01, 6.362210e-01,
    6.362352e-01, 6.362494e-01, 6.362635e-01, 6.362777e-01, 6.362918e-01, 6.363060e-01,
    6.363202e-01, 6.363343e-01, 6.363485e-01, 6.363626e-01, 6.363768e-01, 6.363910e-01,
    6.364051e-01, 6.364193e-01, 6.364334e-01, 6.364476e-01, 6.364618e-01, 6.364759e-01,
    6.364900e-01, 6.365043e-01, 6.365184e-01, 6.365326e-01, 6.365467e-01, 6.365609e-01,
    6.365751e-01, 6.365892e-01, 6.366034e-01, 6.366175e-01, 6.366317e-01, 6.366459e-01,
    6.366600e-01, 6.366742e-01, 6.366884e-01, 6.367025e-01, 6.367167e-01, 6.367308e-01,
    6.367450e-01, 6.367592e-01, 6.367733e-01, 6.367874e-01, 6.368016e-01, 6.368158e-01,
    6.368299e-01, 6.368440e-01, 6.368582e-01, 6.368724e-01, 6.368865e-01, 6.369007e-01,
    6.369148e-01, 6.369290e-01, 6.369432e-01, 6.369573e-01, 6.369715e-01, 6.369857e-01,
    6.369998e-01, 6.370140e-01, 6.370281e-01, 6.370423e-01, 6.370564e-01, 6.370705e-01,
    6.370847e-01, 6.370989e-01, 6.371130e-01, 6.371272e-01, 6.371413e-01, 6.371555e-01,
    6.371697e-01, 6.371838e-01, 6.371980e-01, 6.372122e-01, 6.372263e-01, 6.372404e-01,
    6.372546e-01, 6.372687e-01, 6.372828e-01, 6.372970e-01, 6.373112e-01, 6.373253e-01,
    6.373395e-01, 6.373537e-01, 6.373678e-01, 6.373820e-01, 6.373961e-01, 6.374103e-01,
    6.374244e-01, 6.374385e-01, 6.374527e-01, 6.374668e-01, 6.374810e-01, 6.374952e-01,
    6.375093e-01, 6.375235e-01, 6.375376e-01, 6.375518e-01, 6.375659e-01, 6.375800e-01,
    6.375942e-01, 6.376084e-01, 6.376225e-01, 6.376367e-01, 6.376508e-01, 6.376650e-01,
    6.376791e-01, 6.376933e-01, 6.377074e-01, 6.377215e-01, 6.377357e-01, 6.377499e-01,
    6.377640e-01, 6.377782e-01, 6.377923e-01, 6.378065e-01, 6.378206e-01, 6.378348e-01,
    6.378489e-01, 6.378630e-01, 6.378772e-01, 6.378914e-01, 6.379055e-01, 6.379197e-01,
    6.379338e-01, 6.379479e-01, 6.379621e-01, 6.379762e-01, 6.379904e-01, 6.380045e-01,
    6.380187e-01, 6.380328e-01, 6.380469e-01, 6.380611e-01, 6.380752e-01, 6.380894e-01,
    6.381035e-01, 6.381177e-01, 6.381318e-01, 6.381460e-01, 6.381601e-01, 6.381742e-01,
    6.381884e-01, 6.382025e-01, 6.382167e-01, 6.382309e-01, 6.382450e-01, 6.382591e-01,
    6.382733e-01, 6.382874e-01, 6.383016e-01, 6.383157e-01, 6.383299e-01, 6.383440e-01,
    6.383582e-01, 6.383722e-01, 6.383864e-01, 6.384006e-01, 6.384147e-01, 6.384288e-01,
    6.384430e-01, 6.384571e-01, 6.384712e-01, 6.384854e-01, 6.384996e-01, 6.385137e-01,
    6.385278e-01, 6.385419e-01, 6.385561e-01, 6.385702e-01, 6.385844e-01, 6.385986e-01,
    6.386127e-01, 6.386268e-01, 6.386410e-01, 6.386551e-01, 6.386693e-01, 6.386834e-01,
    6.386975e-01, 6.387116e-01, 6.387258e-01, 6.387399e-01, 6.387541e-01, 6.387682e-01,
    6.387823e-01, 6.387965e-01, 6.388106e-01, 6.388248e-01, 6.388389e-01, 6.388530e-01,
    6.388672e-01, 6.388813e-01, 6.388955e-01, 6.389096e-01, 6.389237e-01, 6.389379e-01,
    6.389520e-01, 6.389661e-01, 6.389803e-01, 6.389944e-01, 6.390085e-01, 6.390227e-01,
    6.390368e-01, 6.390510e-01, 6.390651e-01, 6.390792e-01, 6.390934e-01, 6.391075e-01,
    6.391217e-01, 6.391358e-01, 6.391499e-01, 6.391640e-01, 6.391782e-01, 6.391923e-01,
    6.392065e-01, 6.392205e-01, 6.392347e-01, 6.392488e-01, 6.392630e-01, 6.392771e-01,
    6.392912e-01, 6.393054e-01, 6.393195e-01, 6.393337e-01, 6.393478e-01, 6.393619e-01,
    6.393760e-01, 6.393902e-01, 6.394043e-01, 6.394184e-01, 6.394325e-01, 6.394467e-01,
    6.394608e-01, 6.394750e-01, 6.394891e-01, 6.395032e-01, 6.395174e-01, 6.395315e-01,
    6.395456e-01, 6.395597e-01, 6.395739e-01, 6.395880e-01, 6.396021e-01, 6.396163e-01,
    6.396304e-01, 6.396446e-01, 6.396587e-01, 6.396728e-01, 6.396869e-01, 6.397010e-01,
    6.397152e-01, 6.397293e-01, 6.397434e-01, 6.397576e-01, 6.397717e-01, 6.397858e-01,
    6.398000e-01, 6.398141e-01, 6.398282e-01, 6.398423e-01, 6.398565e-01, 6.398706e-01,
    6.398847e-01, 6.398988e-01, 6.399130e-01, 6.399271e-01, 6.399413e-01, 6.399553e-01,
    6.399695e-01, 6.399836e-01, 6.399977e-01, 6.400118e-01, 6.400260e-01, 6.400402e-01,
    6.400542e-01, 6.400684e-01, 6.400825e-01, 6.400967e-01, 6.401107e-01, 6.401249e-01,
    6.401390e-01, 6.401531e-01, 6.401672e-01, 6.401814e-01, 6.401955e-01, 6.402096e-01,
    6.402237e-01, 6.402379e-01, 6.402520e-01, 6.402661e-01, 6.402802e-01, 6.402944e-01,
    6.403085e-01, 6.403226e-01, 6.403368e-01, 6.403509e-01, 6.403649e-01, 6.403791e-01,
    6.403932e-01, 6.404074e-01, 6.404215e-01, 6.404356e-01, 6.404497e-01, 6.404639e-01,
    6.404780e-01, 6.404921e-01, 6.405062e-01, 6.405203e-01, 6.405345e-01, 6.405486e-01,
    6.405627e-01, 6.405768e-01, 6.405909e-01, 6.406050e-01, 6.406192e-01, 6.406333e-01,
    6.406474e-01, 6.406615e-01, 6.406757e-01, 6.406898e-01, 6.407039e-01, 6.407180e-01,
    6.407322e-01, 6.407462e-01, 6.407604e-01, 6.407745e-01, 6.407886e-01, 6.408027e-01,
    6.408169e-01, 6.408309e-01, 6.408451e-01, 6.408592e-01, 6.408733e-01, 6.408874e-01,
    6.409016e-01, 6.409156e-01, 6.409298e-01, 6.409439e-01, 6.409580e-01, 6.409721e-01,
    6.409863e-01, 6.410004e-01, 6.410145e-01, 6.410286e-01, 6.410427e-01, 6.410568e-01,
    6.410710e-01, 6.410851e-01, 6.410992e-01, 6.411133e-01, 6.411274e-01, 6.411415e-01,
    6.411557e-01, 6.411698e-01, 6.411839e-01, 6.411980e-01, 6.412121e-01, 6.412262e-01,
    6.412403e-01, 6.412545e-01, 6.412686e-01, 6.412827e-01, 6.412968e-01, 6.413109e-01,
    6.413250e-01, 6.413391e-01, 6.413532e-01, 6.413674e-01, 6.413815e-01, 6.413956e-01,
    6.414097e-01, 6.414238e-01, 6.414379e-01, 6.414520e-01, 6.414661e-01, 6.414803e-01,
    6.414944e-01, 6.415085e-01, 6.415226e-01, 6.415367e-01, 6.415508e-01, 6.415650e-01,
    6.415790e-01, 6.415932e-01, 6.416073e-01, 6.416214e-01, 6.416355e-01, 6.416496e-01,
    6.416637e-01, 6.416778e-01, 6.416919e-01, 6.417060e-01, 6.417202e-01, 6.417342e-01,
    6.417484e-01, 6.417624e-01, 6.417766e-01, 6.417907e-01, 6.418048e-01, 6.418189e-01,
    6.418330e-01, 6.418471e-01, 6.418612e-01, 6.418754e-01, 6.418895e-01, 6.419036e-01,
    6.419176e-01, 6.419318e-01, 6.419459e-01, 6.419600e-01, 6.419741e-01, 6.419882e-01,
    6.420023e-01, 6.420164e-01, 6.420305e-01, 6.420447e-01, 6.420587e-01, 6.420729e-01,
    6.420869e-01, 6.421010e-01, 6.421152e-01, 6.421292e-01, 6.421434e-01, 6.421575e-01,
    6.421716e-01, 6.421857e-01, 6.421998e-01, 6.422139e-01, 6.422280e-01, 6.422421e-01,
    6.422562e-01, 6.422703e-01, 6.422845e-01, 6.422985e-01, 6.423126e-01, 6.423267e-01,
    6.423408e-01, 6.423550e-01, 6.423690e-01, 6.423832e-01, 6.423972e-01, 6.424114e-01,
    6.424255e-01, 6.424395e-01, 6.424537e-01, 6.424677e-01, 6.424819e-01, 6.424960e-01,
    6.425101e-01, 6.425242e-01, 6.425382e-01, 6.425524e-01, 6.425665e-01, 6.425806e-01,
    6.425947e-01, 6.426088e-01, 6.426229e-01, 6.426370e-01, 6.426511e-01, 6.426652e-01,
    6.426793e-01, 6.426934e-01, 6.427075e-01, 6.427216e-01, 6.427357e-01, 6.427498e-01,
    6.427639e-01, 6.427780e-01, 6.427921e-01, 6.428062e-01, 6.428203e-01, 6.428344e-01,
    6.428485e-01, 6.428626e-01, 6.428767e-01, 6.428908e-01, 6.429049e-01, 6.429189e-01,
    6.429331e-01, 6.429471e-01, 6.429613e-01, 6.429754e-01, 6.429895e-01, 6.430036e-01,
    6.430176e-01, 6.430317e-01, 6.430458e-01, 6.430600e-01, 6.430740e-01, 6.430882e-01,
    6.431022e-01, 6.431164e-01, 6.431304e-01, 6.431445e-01, 6.431586e-01, 6.431727e-01,
    6.431868e-01, 6.432009e-01, 6.432150e-01, 6.432291e-01, 6.432432e-01, 6.432573e-01,
    6.432714e-01, 6.432855e-01, 6.432996e-01, 6.433136e-01, 6.433278e-01, 6.433418e-01,
    6.433560e-01, 6.433700e-01, 6.433841e-01, 6.433982e-01, 6.434124e-01, 6.434264e-01,
    6.434405e-01, 6.434546e-01, 6.434687e-01, 6.434828e-01, 6.434969e-01, 6.435109e-01,
    6.435251e-01, 6.435392e-01, 6.435533e-01, 6.435673e-01, 6.435814e-01, 6.435955e-01,
    6.436096e-01, 6.436237e-01, 6.436378e-01, 6.436519e-01, 6.436660e-01, 6.436801e-01,
    6.436942e-01, 6.437082e-01, 6.437224e-01, 6.437364e-01, 6.437505e-01, 6.437646e-01,
    6.437787e-01, 6.437928e-01, 6.438069e-01, 6.438209e-01, 6.438351e-01, 6.438491e-01,
    6.438632e-01, 6.438773e-01, 6.438914e-01, 6.439055e-01, 6.439196e-01, 6.439337e-01,
    6.439478e-01, 6.439618e-01, 6.439759e-01, 6.439900e-01, 6.440041e-01, 6.440182e-01,
    6.440323e-01, 6.440464e-01, 6.440604e-01, 6.440746e-01, 6.440886e-01, 6.441027e-01,
    6.441168e-01, 6.441309e-01, 6.441450e-01, 6.441591e-01, 6.441731e-01, 6.441873e-01,
    6.442013e-01, 6.442154e-01, 6.442295e-01, 6.442436e-01, 6.442577e-01, 6.442717e-01,
    6.442859e-01, 6.442999e-01, 6.443140e-01, 6.443281e-01, 6.443422e-01, 6.443563e-01,
    6.443703e-01, 6.443844e-01, 6.443985e-01, 6.444126e-01, 6.444267e-01, 6.444408e-01,
    6.444548e-01, 6.444689e-01, 6.444830e-01, 6.444971e-01, 6.445112e-01, 6.445252e-01,
    6.445394e-01, 6.445534e-01, 6.445675e-01, 6.445816e-01, 6.445957e-01, 6.446097e-01,
    6.446238e-01, 6.446379e-01, 6.446520e-01, 6.446661e-01, 6.446801e-01, 6.446943e-01,
    6.447083e-01, 6.447224e-01, 6.447365e-01, 6.447505e-01, 6.447647e-01, 6.447787e-01,
    6.447928e-01, 6.448069e-01, 6.448209e-01, 6.448350e-01, 6.448491e-01, 6.448632e-01,
    6.448773e-01, 6.448913e-01, 6.449054e-01, 6.449195e-01, 6.449336e-01, 6.449476e-01,
    6.449617e-01, 6.449758e-01, 6.449899e-01, 6.450040e-01, 6.450180e-01, 6.450321e-01,
    6.450462e-01, 6.450603e-01, 6.450744e-01, 6.450884e-01, 6.451025e-01, 6.451166e-01,
    6.451306e-01, 6.451448e-01, 6.451588e-01, 6.451729e-01, 6.451870e-01, 6.452010e-01,
    6.452151e-01, 6.452292e-01, 6.452433e-01, 6.452574e-01, 6.452714e-01, 6.452855e-01,
    6.452996e-01, 6.453136e-01, 6.453277e-01, 6.453418e-01, 6.453559e-01, 6.453699e-01,
    6.453840e-01, 6.453981e-01, 6.454121e-01, 6.454263e-01, 6.454403e-01, 6.454543e-01,
    6.454685e-01, 6.454825e-01, 6.454966e-01, 6.455107e-01, 6.455247e-01, 6.455388e-01,
    6.455529e-01, 6.455670e-01, 6.455810e-01, 6.455951e-01, 6.456092e-01, 6.456233e-01,
    6.456373e-01, 6.456514e-01, 6.456655e-01, 6.456795e-01, 6.456936e-01, 6.457077e-01,
    6.457217e-01, 6.457358e-01, 6.457499e-01, 6.457640e-01, 6.457781e-01, 6.457921e-01,
    6.458061e-01, 6.458202e-01, 6.458343e-01, 6.458484e-01, 6.458625e-01, 6.458765e-01,
    6.458906e-01, 6.459047e-01, 6.459187e-01, 6.459328e-01, 6.459469e-01, 6.459609e-01,
    6.459750e-01, 6.459891e-01, 6.460031e-01, 6.460172e-01, 6.460313e-01, 6.460453e-01,
    6.460594e-01, 6.460735e-01, 6.460875e-01, 6.461017e-01, 6.461157e-01, 6.461297e-01,
    6.461438e-01, 6.461579e-01, 6.461719e-01, 6.461861e-01, 6.462001e-01, 6.462141e-01,
    6.462282e-01, 6.462423e-01, 6.462563e-01, 6.462704e-01, 6.462845e-01, 6.462985e-01,
    6.463126e-01, 6.463267e-01, 6.463407e-01, 6.463548e-01, 6.463689e-01, 6.463829e-01,
    6.463969e-01, 6.464111e-01, 6.464251e-01, 6.464392e-01, 6.464533e-01, 6.464673e-01,
    6.464813e-01, 6.464954e-01, 6.465095e-01, 6.465235e-01, 6.465376e-01, 6.465517e-01,
    6.465657e-01, 6.465798e-01, 6.465939e-01, 6.466079e-01, 6.466220e-01, 6.466361e-01,
    6.466501e-01, 6.466642e-01, 6.466783e-01, 6.466923e-01, 6.467063e-01, 6.467204e-01,
    6.467345e-01, 6.467485e-01, 6.467626e-01, 6.467767e-01, 6.467907e-01, 6.468047e-01,
    6.468188e-01, 6.468329e-01, 6.468470e-01, 6.468610e-01, 6.468751e-01, 6.468892e-01,
    6.469032e-01, 6.469173e-01, 6.469313e-01, 6.469454e-01, 6.469594e-01, 6.469735e-01,
    6.469876e-01, 6.470016e-01, 6.470157e-01, 6.470298e-01, 6.470438e-01, 6.470578e-01,
    6.470719e-01, 6.470860e-01, 6.471000e-01, 6.471141e-01, 6.471281e-01, 6.471422e-01,
    6.471562e-01, 6.471703e-01, 6.471844e-01, 6.471984e-01, 6.472124e-01, 6.472265e-01,
    6.472406e-01, 6.472546e-01, 6.472687e-01, 6.472828e-01, 6.472968e-01, 6.473109e-01,
    6.473249e-01, 6.473389e-01, 6.473530e-01, 6.473671e-01, 6.473811e-01, 6.473952e-01,
    6.474093e-01, 6.474233e-01, 6.474373e-01, 6.474514e-01, 6.474655e-01, 6.474795e-01,
    6.474935e-01, 6.475076e-01, 6.475216e-01, 6.475357e-01, 6.475497e-01, 6.475638e-01,
    6.475779e-01, 6.475919e-01, 6.476060e-01, 6.476200e-01, 6.476341e-01, 6.476482e-01,
    6.476622e-01, 6.476762e-01, 6.476903e-01, 6.477043e-01, 6.477184e-01, 6.477324e-01,
    6.477465e-01, 6.477605e-01, 6.477746e-01, 6.477886e-01, 6.478027e-01, 6.478168e-01,
    6.478308e-01, 6.478449e-01, 6.478589e-01, 6.478730e-01, 6.478870e-01, 6.479011e-01,
    6.479151e-01, 6.479291e-01, 6.479432e-01, 6.479572e-01, 6.479713e-01, 6.479853e-01,
    6.479993e-01, 6.480134e-01, 6.480275e-01, 6.480415e-01, 6.480556e-01, 6.480696e-01,
    6.480837e-01, 6.480978e-01, 6.481118e-01, 6.481258e-01, 6.481399e-01, 6.481539e-01,
    6.481680e-01, 6.481820e-01, 6.481961e-01, 6.482101e-01, 6.482242e-01, 6.482382e-01,
    6.482522e-01, 6.482663e-01, 6.482803e-01, 6.482944e-01, 6.483084e-01, 6.483225e-01,
    6.483365e-01, 6.483505e-01, 6.483646e-01, 6.483786e-01, 6.483927e-01, 6.484067e-01,
    6.484208e-01, 6.484348e-01, 6.484489e-01, 6.484629e-01, 6.484770e-01, 6.484910e-01,
    6.485050e-01, 6.485191e-01, 6.485331e-01, 6.485472e-01, 6.485612e-01, 6.485752e-01,
    6.485893e-01, 6.486033e-01, 6.486174e-01, 6.486315e-01, 6.486455e-01, 6.486595e-01,
    6.486735e-01, 6.486876e-01, 6.487017e-01, 6.487157e-01, 6.487297e-01, 6.487437e-01,
    6.487578e-01, 6.487718e-01, 6.487859e-01, 6.488000e-01, 6.488140e-01, 6.488280e-01,
    6.488420e-01, 6.488561e-01, 6.488701e-01, 6.488842e-01, 6.488982e-01, 6.489123e-01,
    6.489263e-01, 6.489403e-01, 6.489543e-01, 6.489684e-01, 6.489825e-01, 6.489965e-01,
    6.490105e-01, 6.490245e-01, 6.490386e-01, 6.490526e-01, 6.490667e-01, 6.490807e-01,
    6.490948e-01, 6.491088e-01, 6.491228e-01, 6.491368e-01, 6.491509e-01, 6.491649e-01,
    6.491790e-01, 6.491930e-01, 6.492071e-01, 6.492211e-01, 6.492351e-01, 6.492492e-01,
    6.492632e-01, 6.492773e-01, 6.492913e-01, 6.493053e-01, 6.493194e-01, 6.493334e-01,
    6.493474e-01, 6.493614e-01, 6.493755e-01, 6.493895e-01, 6.494036e-01, 6.494176e-01,
    6.494316e-01, 6.494457e-01, 6.494597e-01, 6.494737e-01, 6.494877e-01, 6.495018e-01,
    6.495158e-01, 6.495298e-01, 6.495439e-01, 6.495579e-01, 6.495720e-01, 6.495860e-01,
    6.496000e-01, 6.496141e-01, 6.496281e-01, 6.496421e-01, 6.496562e-01, 6.496702e-01,
    6.496842e-01, 6.496983e-01, 6.497123e-01, 6.497263e-01, 6.497403e-01, 6.497543e-01,
    6.497684e-01, 6.497824e-01, 6.497965e-01, 6.498105e-01, 6.498246e-01, 6.498386e-01,
    6.498526e-01, 6.498666e-01, 6.498806e-01, 6.498947e-01, 6.499087e-01, 6.499227e-01,
    6.499367e-01, 6.499508e-01, 6.499648e-01, 6.499788e-01, 6.499929e-01, 6.500069e-01,
    6.500210e-01, 6.500350e-01, 6.500490e-01, 6.500630e-01, 6.500770e-01, 6.500911e-01,
    6.501051e-01, 6.501191e-01, 6.501331e-01, 6.501472e-01, 6.501612e-01, 6.501753e-01,
    6.501893e-01, 6.502033e-01, 6.502174e-01, 6.502314e-01, 6.502454e-01, 6.502594e-01,
    6.502734e-01, 6.502874e-01, 6.503015e-01, 6.503155e-01, 6.503296e-01, 6.503436e-01,
    6.503576e-01, 6.503716e-01, 6.503856e-01, 6.503997e-01, 6.504137e-01, 6.504277e-01,
    6.504418e-01, 6.504558e-01, 6.504698e-01, 6.504838e-01, 6.504979e-01, 6.505119e-01,
    6.505259e-01, 6.505399e-01, 6.505539e-01, 6.505679e-01, 6.505820e-01, 6.505960e-01,
    6.506100e-01, 6.506240e-01, 6.506381e-01, 6.506521e-01, 6.506661e-01, 6.506801e-01,
    6.506942e-01, 6.507082e-01, 6.507222e-01, 6.507362e-01, 6.507503e-01, 6.507643e-01,
    6.507783e-01, 6.507923e-01, 6.508064e-01, 6.508204e-01, 6.508344e-01, 6.508484e-01,
    6.508624e-01, 6.508764e-01, 6.508905e-01, 6.509045e-01, 6.509185e-01, 6.509326e-01,
    6.509466e-01, 6.509606e-01, 6.509746e-01, 6.509886e-01, 6.510026e-01, 6.510167e-01,
    6.510307e-01, 6.510447e-01, 6.510587e-01, 6.510727e-01, 6.510867e-01, 6.511008e-01,
    6.511148e-01, 6.511288e-01, 6.511428e-01, 6.511568e-01, 6.511708e-01, 6.511849e-01,
    6.511989e-01, 6.512129e-01, 6.512269e-01, 6.512409e-01, 6.512550e-01, 6.512690e-01,
    6.512830e-01, 6.512970e-01, 6.513110e-01, 6.513250e-01, 6.513391e-01, 6.513531e-01,
    6.513671e-01, 6.513811e-01, 6.513951e-01, 6.514091e-01, 6.514232e-01, 6.514372e-01,
    6.514512e-01, 6.514652e-01, 6.514792e-01, 6.514932e-01, 6.515072e-01, 6.515212e-01,
    6.515353e-01, 6.515493e-01, 6.515633e-01, 6.515773e-01, 6.515913e-01, 6.516053e-01,
    6.516194e-01, 6.516334e-01, 6.516474e-01, 6.516614e-01, 6.516753e-01, 6.516894e-01,
    6.517034e-01, 6.517174e-01, 6.517314e-01, 6.517454e-01, 6.517594e-01, 6.517735e-01,
    6.517875e-01, 6.518015e-01, 6.518155e-01, 6.518295e-01, 6.518435e-01, 6.518576e-01,
    6.518716e-01, 6.518856e-01, 6.518996e-01, 6.519136e-01, 6.519276e-01, 6.519416e-01,
    6.519556e-01, 6.519696e-01, 6.519836e-01, 6.519977e-01, 6.520116e-01, 6.520256e-01,
    6.520396e-01, 6.520537e-01, 6.520677e-01, 6.520817e-01, 6.520957e-01, 6.521097e-01,
    6.521237e-01, 6.521378e-01, 6.521518e-01, 6.521657e-01, 6.521798e-01, 6.521938e-01,
    6.522078e-01, 6.522217e-01, 6.522357e-01, 6.522498e-01, 6.522638e-01, 6.522778e-01,
    6.522918e-01, 6.523058e-01, 6.523198e-01, 6.523339e-01, 6.523478e-01, 6.523618e-01,
    6.523759e-01, 6.523899e-01, 6.524038e-01, 6.524178e-01, 6.524319e-01, 6.524459e-01,
    6.524599e-01, 6.524739e-01, 6.524879e-01, 6.525019e-01, 6.525159e-01, 6.525299e-01,
    6.525439e-01, 6.525579e-01, 6.525719e-01, 6.525859e-01, 6.525999e-01, 6.526139e-01,
    6.526279e-01, 6.526420e-01, 6.526559e-01, 6.526700e-01, 6.526840e-01, 6.526979e-01,
    6.527119e-01, 6.527260e-01, 6.527399e-01, 6.527539e-01, 6.527680e-01, 6.527820e-01,
    6.527960e-01, 6.528100e-01, 6.528240e-01, 6.528380e-01, 6.528520e-01, 6.528659e-01,
    6.528800e-01, 6.528940e-01, 6.529080e-01, 6.529220e-01, 6.529360e-01, 6.529500e-01,
    6.529640e-01, 6.529779e-01, 6.529920e-01, 6.530060e-01, 6.530200e-01, 6.530340e-01,
    6.530480e-01, 6.530620e-01, 6.530760e-01, 6.530899e-01, 6.531040e-01, 6.531180e-01,
    6.531320e-01, 6.531460e-01, 6.531600e-01, 6.531740e-01, 6.531879e-01, 6.532020e-01,
    6.532159e-01, 6.532300e-01, 6.532440e-01, 6.532580e-01, 6.532719e-01, 6.532859e-01,
    6.533000e-01, 6.533139e-01, 6.533279e-01, 6.533419e-01, 6.533560e-01, 6.533699e-01,
    6.533839e-01, 6.533979e-01, 6.534119e-01, 6.534259e-01, 6.534399e-01, 6.534539e-01,
    6.534679e-01, 6.534819e-01, 6.534959e-01, 6.535099e-01, 6.535239e-01, 6.535379e-01,
    6.535519e-01, 6.535658e-01, 6.535799e-01, 6.535938e-01, 6.536078e-01, 6.536219e-01,
    6.536359e-01, 6.536498e-01, 6.536638e-01, 6.536778e-01, 6.536918e-01, 6.537058e-01,
    6.537198e-01, 6.537338e-01, 6.537477e-01, 6.537618e-01, 6.537758e-01, 6.537898e-01,
    6.538038e-01, 6.538177e-01, 6.538317e-01, 6.538457e-01, 6.538597e-01, 6.538737e-01,
    6.538877e-01, 6.539017e-01, 6.539156e-01, 6.539297e-01, 6.539437e-01, 6.539577e-01,
    6.539716e-01, 6.539856e-01, 6.539996e-01, 6.540136e-01, 6.540276e-01, 6.540416e-01,
    6.540556e-01, 6.540696e-01, 6.540835e-01, 6.540976e-01, 6.541116e-01, 6.541255e-01,
    6.541395e-01, 6.541535e-01, 6.541675e-01, 6.541815e-01, 6.541955e-01, 6.542094e-01,
    6.542234e-01, 6.542374e-01, 6.542514e-01, 6.542654e-01, 6.542794e-01, 6.542934e-01,
    6.543074e-01, 6.543214e-01, 6.543353e-01, 6.543493e-01, 6.543633e-01, 6.543773e-01,
    6.543913e-01, 6.544053e-01, 6.544192e-01, 6.544333e-01, 6.544472e-01, 6.544612e-01,
    6.544752e-01, 6.544892e-01, 6.545032e-01, 6.545172e-01, 6.545311e-01, 6.545451e-01,
    6.545591e-01, 6.545731e-01, 6.545871e-01, 6.546010e-01, 6.546150e-01, 6.546291e-01,
    6.546430e-01, 6.546570e-01, 6.546710e-01, 6.546850e-01, 6.546990e-01, 6.547129e-01,
    6.547269e-01, 6.547409e-01, 6.547549e-01, 6.547689e-01, 6.547828e-01, 6.547968e-01,
    6.548108e-01, 6.548248e-01, 6.548388e-01, 6.548527e-01, 6.548667e-01, 6.548808e-01,
    6.548947e-01, 6.549087e-01, 6.549227e-01, 6.549366e-01, 6.549507e-01, 6.549646e-01,
    6.549786e-01, 6.549926e-01, 6.550065e-01, 6.550205e-01, 6.550345e-01, 6.550485e-01,
    6.550625e-01, 6.550764e-01, 6.550905e-01, 6.551044e-01, 6.551183e-01, 6.551324e-01,
    6.551464e-01, 6.551604e-01, 6.551743e-01, 6.551883e-01, 6.552023e-01, 6.552162e-01,
    6.552302e-01, 6.552442e-01, 6.552582e-01, 6.552722e-01, 6.552861e-01, 6.553001e-01,
    6.553141e-01, 6.553281e-01, 6.553420e-01, 6.553560e-01, 6.553700e-01, 6.553839e-01,
    6.553980e-01, 6.554119e-01, 6.554259e-01, 6.554399e-01, 6.554539e-01, 6.554679e-01,
    6.554818e-01, 6.554958e-01, 6.555098e-01, 6.555237e-01, 6.555377e-01, 6.555517e-01,
    6.555657e-01, 6.555796e-01, 6.555936e-01, 6.556076e-01, 6.556215e-01, 6.556355e-01,
    6.556495e-01, 6.556635e-01, 6.556774e-01, 6.556914e-01, 6.557054e-01, 6.557193e-01,
    6.557333e-01, 6.557473e-01, 6.557613e-01, 6.557752e-01, 6.557893e-01, 6.558032e-01,
    6.558172e-01, 6.558312e-01, 6.558451e-01, 6.558591e-01, 6.558731e-01, 6.558871e-01,
    6.559010e-01, 6.559150e-01, 6.559290e-01, 6.559429e-01, 6.559569e-01, 6.559709e-01,
    6.559849e-01, 6.559988e-01, 6.560128e-01, 6.560267e-01, 6.560407e-01, 6.560547e-01,
    6.560687e-01, 6.560826e-01, 6.560966e-01, 6.561106e-01, 6.561245e-01, 6.561385e-01,
    6.561525e-01, 6.561664e-01, 6.561804e-01, 6.561944e-01, 6.562083e-01, 6.562223e-01,
    6.562363e-01, 6.562503e-01, 6.562642e-01, 6.562782e-01, 6.562921e-01, 6.563061e-01,
    6.563201e-01, 6.563341e-01, 6.563480e-01, 6.563620e-01, 6.563760e-01, 6.563900e-01,
    6.564039e-01, 6.564179e-01, 6.564319e-01, 6.564458e-01, 6.564598e-01, 6.564738e-01,
    6.564877e-01, 6.565017e-01, 6.565157e-01, 6.565296e-01, 6.565436e-01, 6.565575e-01,
    6.565715e-01, 6.565855e-01, 6.565995e-01, 6.566133e-01, 6.566274e-01, 6.566413e-01,
    6.566553e-01, 6.566693e-01, 6.566832e-01, 6.566972e-01, 6.567112e-01, 6.567251e-01,
    6.567391e-01, 6.567530e-01, 6.567670e-01, 6.567810e-01, 6.567950e-01, 6.568089e-01,
    6.568229e-01, 6.568368e-01, 6.568508e-01, 6.568647e-01, 6.568787e-01, 6.568927e-01,
    6.569066e-01, 6.569206e-01, 6.569346e-01, 6.569485e-01, 6.569625e-01, 6.569765e-01,
    6.569904e-01, 6.570044e-01, 6.570183e-01, 6.570323e-01, 6.570463e-01, 6.570602e-01,
    6.570742e-01, 6.570882e-01, 6.571020e-01, 6.571161e-01, 6.571300e-01, 6.571440e-01,
    6.571579e-01, 6.571719e-01, 6.571858e-01, 6.571998e-01, 6.572137e-01, 6.572277e-01,
    6.572417e-01, 6.572556e-01, 6.572696e-01, 6.572835e-01, 6.572976e-01, 6.573114e-01,
    6.573254e-01, 6.573394e-01, 6.573533e-01, 6.573673e-01, 6.573812e-01, 6.573952e-01,
    6.574092e-01, 6.574231e-01, 6.574371e-01, 6.574510e-01, 6.574650e-01, 6.574790e-01,
    6.574929e-01, 6.575069e-01, 6.575208e-01, 6.575348e-01, 6.575487e-01, 6.575627e-01,
    6.575767e-01, 6.575906e-01, 6.576046e-01, 6.576185e-01, 6.576325e-01, 6.576464e-01,
    6.576604e-01, 6.576743e-01, 6.576883e-01, 6.577023e-01, 6.577162e-01, 6.577302e-01,
    6.577441e-01, 6.577581e-01, 6.577720e-01, 6.577860e-01, 6.577999e-01, 6.578138e-01,
    6.578279e-01, 6.578417e-01, 6.578557e-01, 6.578697e-01, 6.578836e-01, 6.578976e-01,
    6.579115e-01, 6.579255e-01, 6.579394e-01, 6.579534e-01, 6.579673e-01, 6.579813e-01,
    6.579953e-01, 6.580092e-01, 6.580232e-01, 6.580371e-01, 6.580511e-01, 6.580650e-01,
    6.580790e-01, 6.580929e-01, 6.581069e-01, 6.581208e-01, 6.581348e-01, 6.581487e-01,
    6.581627e-01, 6.581766e-01, 6.581905e-01, 6.582045e-01, 6.582184e-01, 6.582325e-01,
    6.582463e-01, 6.582603e-01, 6.582742e-01, 6.582882e-01, 6.583022e-01, 6.583161e-01,
    6.583301e-01, 6.583440e-01, 6.583579e-01, 6.583719e-01, 6.583858e-01, 6.583998e-01,
    6.584137e-01, 6.584277e-01, 6.584417e-01, 6.584556e-01, 6.584695e-01, 6.584834e-01,
    6.584974e-01, 6.585114e-01, 6.585253e-01, 6.585392e-01, 6.585532e-01, 6.585671e-01,
    6.585811e-01, 6.585950e-01, 6.586090e-01, 6.586229e-01, 6.586369e-01, 6.586508e-01,
    6.586648e-01, 6.586787e-01, 6.586927e-01, 6.587066e-01, 6.587206e-01, 6.587345e-01,
    6.587484e-01, 6.587624e-01, 6.587763e-01, 6.587902e-01, 6.588042e-01, 6.588181e-01,
    6.588321e-01, 6.588461e-01, 6.588600e-01, 6.588739e-01, 6.588879e-01, 6.589018e-01,
    6.589158e-01, 6.589297e-01, 6.589436e-01, 6.589576e-01, 6.589715e-01, 6.589854e-01,
    6.589994e-01, 6.590133e-01, 6.590273e-01, 6.590412e-01, 6.590552e-01, 6.590691e-01,
    6.590831e-01, 6.590970e-01, 6.591110e-01, 6.591249e-01, 6.591388e-01, 6.591527e-01,
    6.591667e-01, 6.591806e-01, 6.591946e-01, 6.592085e-01, 6.592224e-01, 6.592364e-01,
    6.592503e-01, 6.592643e-01, 6.592782e-01, 6.592922e-01, 6.593060e-01, 6.593201e-01,
    6.593339e-01, 6.593479e-01, 6.593618e-01, 6.593758e-01, 6.593897e-01, 6.594037e-01,
    6.594176e-01, 6.594315e-01, 6.594455e-01, 6.594594e-01, 6.594734e-01, 6.594873e-01,
    6.595012e-01, 6.595151e-01, 6.595291e-01, 6.595430e-01, 6.595569e-01, 6.595709e-01,
    6.595849e-01, 6.595988e-01, 6.596127e-01, 6.596267e-01, 6.596406e-01, 6.596545e-01,
    6.596684e-01, 6.596824e-01, 6.596963e-01, 6.597103e-01, 6.597242e-01, 6.597381e-01,
    6.597521e-01, 6.597660e-01, 6.597799e-01, 6.597939e-01, 6.598078e-01, 6.598217e-01,
    6.598356e-01, 6.598496e-01, 6.598635e-01, 6.598775e-01, 6.598914e-01, 6.599053e-01,
    6.599193e-01, 6.599332e-01, 6.599472e-01, 6.599610e-01, 6.599750e-01, 6.599889e-01,
    6.600028e-01, 6.600168e-01, 6.600307e-01, 6.600447e-01, 6.600586e-01, 6.600725e-01,
    6.600865e-01, 6.601003e-01, 6.601143e-01, 6.601282e-01, 6.601422e-01, 6.601561e-01,
    6.601700e-01, 6.601840e-01, 6.601979e-01, 6.602118e-01, 6.602257e-01, 6.602397e-01,
    6.602536e-01, 6.602675e-01, 6.602815e-01, 6.602954e-01, 6.603093e-01, 6.603233e-01,
    6.603372e-01, 6.603511e-01, 6.603650e-01, 6.603790e-01, 6.603929e-01, 6.604068e-01,
    6.604208e-01, 6.604347e-01, 6.604486e-01, 6.604625e-01, 6.604764e-01, 6.604904e-01,
    6.605043e-01, 6.605182e-01, 6.605322e-01, 6.605461e-01, 6.605600e-01, 6.605740e-01,
    6.605879e-01, 6.606019e-01, 6.606157e-01, 6.606296e-01, 6.606436e-01, 6.606575e-01,
    6.606714e-01, 6.606854e-01, 6.606993e-01, 6.607133e-01, 6.607271e-01, 6.607410e-01,
    6.607550e-01, 6.607689e-01, 6.607828e-01, 6.607968e-01, 6.608107e-01, 6.608247e-01,
    6.608385e-01, 6.608524e-01, 6.608664e-01, 6.608803e-01, 6.608942e-01, 6.609082e-01,
    6.609221e-01, 6.609360e-01, 6.609499e-01, 6.609638e-01, 6.609778e-01, 6.609917e-01,
    6.610056e-01, 6.610195e-01, 6.610335e-01, 6.610474e-01, 6.610613e-01, 6.610752e-01,
    6.610891e-01, 6.611031e-01, 6.611170e-01, 6.611309e-01, 6.611448e-01, 6.611587e-01,
    6.611727e-01, 6.611866e-01, 6.612005e-01, 6.612144e-01, 6.612284e-01, 6.612423e-01,
    6.612562e-01, 6.612701e-01, 6.612840e-01, 6.612980e-01, 6.613119e-01, 6.613258e-01,
    6.613397e-01, 6.613536e-01, 6.613675e-01, 6.613815e-01, 6.613954e-01, 6.614093e-01,
    6.614232e-01, 6.614372e-01, 6.614511e-01, 6.614650e-01, 6.614789e-01, 6.614928e-01,
    6.615067e-01, 6.615207e-01, 6.615345e-01, 6.615484e-01, 6.615624e-01, 6.615763e-01,
    6.615902e-01, 6.616042e-01, 6.616181e-01, 6.616320e-01, 6.616459e-01, 6.616598e-01,
    6.616737e-01, 6.616876e-01, 6.617016e-01, 6.617154e-01, 6.617294e-01, 6.617433e-01,
    6.617572e-01, 6.617711e-01, 6.617851e-01, 6.617990e-01, 6.618129e-01, 6.618268e-01,
    6.618407e-01, 6.618546e-01, 6.618685e-01, 6.618825e-01, 6.618964e-01, 6.619103e-01,
    6.619242e-01, 6.619381e-01, 6.619520e-01, 6.619660e-01, 6.619799e-01, 6.619937e-01,
    6.620076e-01, 6.620216e-01, 6.620355e-01, 6.620494e-01, 6.620634e-01, 6.620772e-01,
    6.620911e-01, 6.621050e-01, 6.621190e-01, 6.621329e-01, 6.621468e-01, 6.621607e-01,
    6.621746e-01, 6.621885e-01, 6.622024e-01, 6.622164e-01, 6.622303e-01, 6.622442e-01,
    6.622581e-01, 6.622720e-01, 6.622859e-01, 6.622998e-01, 6.623137e-01, 6.623276e-01,
    6.623415e-01, 6.623554e-01, 6.623693e-01, 6.623833e-01, 6.623971e-01, 6.624111e-01,
    6.624250e-01, 6.624389e-01, 6.624528e-01, 6.624667e-01, 6.624806e-01, 6.624945e-01,
    6.625084e-01, 6.625224e-01, 6.625363e-01, 6.625502e-01, 6.625640e-01, 6.625780e-01,
    6.625919e-01, 6.626058e-01, 6.626197e-01, 6.626336e-01, 6.626475e-01, 6.626614e-01,
    6.626753e-01, 6.626892e-01, 6.627032e-01, 6.627170e-01, 6.627309e-01, 6.627449e-01,
    6.627588e-01, 6.627727e-01, 6.627865e-01, 6.628005e-01, 6.628144e-01, 6.628283e-01,
    6.628422e-01, 6.628561e-01, 6.628700e-01, 6.628839e-01, 6.628978e-01, 6.629117e-01,
    6.629256e-01, 6.629395e-01, 6.629534e-01, 6.629673e-01, 6.629813e-01, 6.629952e-01,
    6.630090e-01, 6.630229e-01, 6.630368e-01, 6.630507e-01, 6.630647e-01, 6.630785e-01,
    6.630924e-01, 6.631064e-01, 6.631203e-01, 6.631342e-01, 6.631480e-01, 6.631619e-01,
    6.631758e-01, 6.631898e-01, 6.632037e-01, 6.632175e-01, 6.632315e-01, 6.632454e-01,
    6.632593e-01, 6.632732e-01, 6.632871e-01, 6.633010e-01, 6.633149e-01, 6.633288e-01,
    6.633427e-01, 6.633565e-01, 6.633705e-01, 6.633844e-01, 6.633983e-01, 6.634122e-01,
    6.634261e-01, 6.634400e-01, 6.634539e-01, 6.634678e-01, 6.634817e-01, 6.634955e-01,
    6.635094e-01, 6.635233e-01, 6.635373e-01, 6.635512e-01, 6.635650e-01, 6.635789e-01,
    6.635929e-01, 6.636068e-01, 6.636207e-01, 6.636345e-01, 6.636484e-01, 6.636624e-01,
    6.636763e-01, 6.636901e-01, 6.637040e-01, 6.637179e-01, 6.637318e-01, 6.637457e-01,
    6.637596e-01, 6.637735e-01, 6.637874e-01, 6.638013e-01, 6.638152e-01, 6.638291e-01,
    6.638430e-01, 6.638569e-01, 6.638708e-01, 6.638847e-01, 6.638986e-01, 6.639125e-01,
    6.639264e-01, 6.639403e-01, 6.639541e-01, 6.639680e-01, 6.639819e-01, 6.639958e-01,
    6.640097e-01, 6.640236e-01, 6.640375e-01, 6.640514e-01, 6.640653e-01, 6.640792e-01,
    6.640931e-01, 6.641070e-01, 6.641209e-01, 6.641347e-01, 6.641486e-01, 6.641625e-01,
    6.641764e-01, 6.641904e-01, 6.642042e-01, 6.642181e-01, 6.642320e-01, 6.642459e-01,
    6.642598e-01, 6.642737e-01, 6.642876e-01, 6.643015e-01, 6.643153e-01, 6.643292e-01,
    6.643431e-01, 6.643570e-01, 6.643709e-01, 6.643848e-01, 6.643987e-01, 6.644126e-01,
    6.644264e-01, 6.644403e-01, 6.644542e-01, 6.644681e-01, 6.644820e-01, 6.644959e-01,
    6.645098e-01, 6.645237e-01, 6.645375e-01, 6.645514e-01, 6.645653e-01, 6.645792e-01,
    6.645931e-01, 6.646070e-01, 6.646209e-01, 6.646348e-01, 6.646487e-01, 6.646625e-01,
    6.646764e-01, 6.646903e-01, 6.647042e-01, 6.647181e-01, 6.647320e-01, 6.647459e-01,
    6.647598e-01, 6.647736e-01, 6.647875e-01, 6.648014e-01, 6.648153e-01, 6.648292e-01,
    6.648430e-01, 6.648569e-01, 6.648708e-01, 6.648847e-01, 6.648986e-01, 6.649125e-01,
    6.649264e-01, 6.649402e-01, 6.649541e-01, 6.649680e-01, 6.649819e-01, 6.649958e-01,
    6.650097e-01, 6.650236e-01, 6.650375e-01, 6.650513e-01, 6.650652e-01, 6.650791e-01,
    6.650930e-01, 6.651069e-01, 6.651208e-01, 6.651347e-01, 6.651486e-01, 6.651624e-01,
    6.651763e-01, 6.651902e-01, 6.652040e-01, 6.652179e-01, 6.652318e-01, 6.652457e-01,
    6.652596e-01, 6.652734e-01, 6.652873e-01, 6.653012e-01, 6.653151e-01, 6.653290e-01,
    6.653429e-01, 6.653567e-01, 6.653706e-01, 6.653845e-01, 6.653984e-01, 6.654122e-01,
    6.654261e-01, 6.654400e-01, 6.654539e-01, 6.654678e-01, 6.654817e-01, 6.654956e-01,
    6.655094e-01, 6.655233e-01, 6.655372e-01, 6.655511e-01, 6.655650e-01, 6.655788e-01,
    6.655927e-01, 6.656066e-01, 6.656204e-01, 6.656343e-01, 6.656482e-01, 6.656621e-01,
    6.656759e-01, 6.656898e-01, 6.657037e-01, 6.657176e-01, 6.657315e-01, 6.657454e-01,
    6.657592e-01, 6.657731e-01, 6.657870e-01, 6.658008e-01, 6.658147e-01, 6.658286e-01,
    6.658425e-01, 6.658563e-01, 6.658702e-01, 6.658841e-01, 6.658980e-01, 6.659119e-01,
    6.659257e-01, 6.659396e-01, 6.659535e-01, 6.659673e-01, 6.659812e-01, 6.659951e-01,
    6.660089e-01, 6.660228e-01, 6.660367e-01, 6.660506e-01, 6.660644e-01, 6.660783e-01,
    6.660922e-01, 6.661061e-01, 6.661200e-01, 6.661338e-01, 6.661477e-01, 6.661616e-01,
    6.661754e-01, 6.661893e-01, 6.662032e-01, 6.662171e-01, 6.662310e-01, 6.662448e-01,
    6.662587e-01, 6.662726e-01, 6.662864e-01, 6.663003e-01, 6.663141e-01, 6.663280e-01,
    6.663419e-01, 6.663558e-01, 6.663697e-01, 6.663836e-01, 6.663974e-01, 6.664113e-01,
    6.664251e-01, 6.664390e-01, 6.664529e-01, 6.664667e-01, 6.664806e-01, 6.664945e-01,
    6.665084e-01, 6.665222e-01, 6.665361e-01, 6.665500e-01, 6.665638e-01, 6.665777e-01,
    6.665915e-01, 6.666054e-01, 6.666193e-01, 6.666332e-01, 6.666470e-01, 6.666609e-01,
    6.666748e-01, 6.666886e-01, 6.667025e-01, 6.667164e-01, 6.667303e-01, 6.667441e-01,
    6.667580e-01, 6.667718e-01, 6.667857e-01, 6.667995e-01, 6.668134e-01, 6.668273e-01,
    6.668412e-01, 6.668550e-01, 6.668689e-01, 6.668828e-01, 6.668966e-01, 6.669105e-01,
    6.669244e-01, 6.669382e-01, 6.669521e-01, 6.669660e-01, 6.669798e-01, 6.669937e-01,
    6.670076e-01, 6.670215e-01, 6.670353e-01, 6.670492e-01, 6.670630e-01, 6.670769e-01,
    6.670907e-01, 6.671046e-01, 6.671185e-01, 6.671324e-01, 6.671462e-01, 6.671600e-01,
    6.671739e-01, 6.671878e-01, 6.672016e-01, 6.672155e-01, 6.672294e-01, 6.672432e-01,
    6.672571e-01, 6.672710e-01, 6.672848e-01, 6.672987e-01, 6.673126e-01, 6.673264e-01,
    6.673403e-01, 6.673541e-01, 6.673680e-01, 6.673819e-01, 6.673957e-01, 6.674096e-01,
    6.674234e-01, 6.674373e-01, 6.674511e-01, 6.674650e-01, 6.674789e-01, 6.674927e-01,
    6.675066e-01, 6.675205e-01, 6.675343e-01, 6.675482e-01, 6.675621e-01, 6.675759e-01,
    6.675897e-01, 6.676036e-01, 6.676175e-01, 6.676313e-01, 6.676452e-01, 6.676590e-01,
    6.676729e-01, 6.676868e-01, 6.677006e-01, 6.677145e-01, 6.677283e-01, 6.677422e-01,
    6.677560e-01, 6.677699e-01, 6.677838e-01, 6.677976e-01, 6.678115e-01, 6.678253e-01,
    6.678392e-01, 6.678531e-01, 6.678669e-01, 6.678808e-01, 6.678946e-01, 6.679085e-01,
    6.679223e-01, 6.679362e-01, 6.679500e-01, 6.679639e-01, 6.679778e-01, 6.679916e-01,
    6.680055e-01, 6.680193e-01, 6.680332e-01, 6.680471e-01, 6.680609e-01, 6.680747e-01,
    6.680886e-01, 6.681024e-01, 6.681163e-01, 6.681302e-01, 6.681440e-01, 6.681578e-01,
    6.681717e-01, 6.681856e-01, 6.681994e-01, 6.682132e-01, 6.682271e-01, 6.682410e-01,
    6.682549e-01, 6.682687e-01, 6.682825e-01, 6.682964e-01, 6.683102e-01, 6.683241e-01,
    6.683379e-01, 6.683518e-01, 6.683657e-01, 6.683795e-01, 6.683933e-01, 6.684072e-01,
    6.684211e-01, 6.684349e-01, 6.684487e-01, 6.684626e-01, 6.684765e-01, 6.684903e-01,
    6.685042e-01, 6.685180e-01, 6.685318e-01, 6.685457e-01, 6.685596e-01, 6.685734e-01,
    6.685873e-01, 6.686011e-01, 6.686149e-01, 6.686288e-01, 6.686426e-01, 6.686565e-01,
    6.686704e-01, 6.686842e-01, 6.686980e-01, 6.687119e-01, 6.687257e-01, 6.687396e-01,
    6.687534e-01, 6.687673e-01, 6.687812e-01, 6.687950e-01, 6.688088e-01, 6.688227e-01,
    6.688365e-01, 6.688504e-01, 6.688642e-01, 6.688781e-01, 6.688919e-01, 6.689057e-01,
    6.689196e-01, 6.689335e-01, 6.689473e-01, 6.689611e-01, 6.689750e-01, 6.689888e-01,
    6.690027e-01, 6.690165e-01, 6.690304e-01, 6.690442e-01, 6.690580e-01, 6.690719e-01,
    6.690857e-01, 6.690996e-01, 6.691134e-01, 6.691273e-01, 6.691411e-01, 6.691549e-01,
    6.691688e-01, 6.691827e-01, 6.691965e-01, 6.692103e-01, 6.692242e-01, 6.692380e-01,
    6.692519e-01, 6.692657e-01, 6.692796e-01, 6.692934e-01, 6.693072e-01, 6.693211e-01,
    6.693349e-01, 6.693488e-01, 6.693626e-01, 6.693765e-01, 6.693903e-01, 6.694041e-01,
    6.694180e-01, 6.694318e-01, 6.694456e-01, 6.694595e-01, 6.694734e-01, 6.694872e-01,
    6.695010e-01, 6.695149e-01, 6.695287e-01, 6.695426e-01, 6.695564e-01, 6.695702e-01,
    6.695840e-01, 6.695979e-01, 6.696118e-01, 6.696256e-01, 6.696394e-01, 6.696533e-01,
    6.696671e-01, 6.696809e-01, 6.696948e-01, 6.697086e-01, 6.697224e-01, 6.697363e-01,
    6.697502e-01, 6.697640e-01, 6.697778e-01, 6.697916e-01, 6.698055e-01, 6.698193e-01,
    6.698332e-01, 6.698470e-01, 6.698608e-01, 6.698747e-01, 6.698885e-01, 6.699023e-01,
    6.699162e-01, 6.699300e-01, 6.699438e-01, 6.699577e-01, 6.699715e-01, 6.699854e-01,
    6.699992e-01, 6.700130e-01, 6.700268e-01, 6.700407e-01, 6.700546e-01, 6.700684e-01,
    6.700822e-01, 6.700960e-01, 6.701099e-01, 6.701238e-01, 6.701375e-01, 6.701514e-01,
    6.701652e-01, 6.701791e-01, 6.701929e-01, 6.702067e-01, 6.702206e-01, 6.702344e-01,
    6.702482e-01, 6.702620e-01, 6.702759e-01, 6.702898e-01, 6.703035e-01, 6.703174e-01,
    6.703312e-01, 6.703450e-01, 6.703589e-01, 6.703727e-01, 6.703866e-01, 6.704004e-01,
    6.704142e-01, 6.704280e-01, 6.704419e-01, 6.704557e-01, 6.704695e-01, 6.704834e-01,
    6.704972e-01, 6.705111e-01, 6.705248e-01, 6.705387e-01, 6.705526e-01, 6.705664e-01,
    6.705801e-01, 6.705940e-01, 6.706079e-01, 6.706217e-01, 6.706355e-01, 6.706493e-01,
    6.706632e-01, 6.706770e-01, 6.706908e-01, 6.707047e-01, 6.707185e-01, 6.707323e-01,
    6.707461e-01, 6.707600e-01, 6.707738e-01, 6.707876e-01, 6.708014e-01, 6.708153e-01,
    6.708291e-01, 6.708429e-01, 6.708568e-01, 6.708705e-01, 6.708844e-01, 6.708983e-01,
    6.709121e-01, 6.709259e-01, 6.709397e-01, 6.709536e-01, 6.709674e-01, 6.709812e-01,
    6.709951e-01, 6.710088e-01, 6.710227e-01, 6.710365e-01, 6.710503e-01, 6.710642e-01,
    6.710780e-01, 6.710918e-01, 6.711056e-01, 6.711195e-01, 6.711333e-01, 6.711471e-01,
    6.711609e-01, 6.711748e-01, 6.711886e-01, 6.712024e-01, 6.712162e-01, 6.712301e-01,
    6.712439e-01, 6.712577e-01, 6.712716e-01, 6.712853e-01, 6.712992e-01, 6.713130e-01,
    6.713268e-01, 6.713406e-01, 6.713545e-01, 6.713683e-01, 6.713821e-01, 6.713960e-01,
    6.714098e-01, 6.714236e-01, 6.714374e-01, 6.714512e-01, 6.714650e-01, 6.714789e-01,
    6.714927e-01, 6.715065e-01, 6.715203e-01, 6.715342e-01, 6.715479e-01, 6.715618e-01,
    6.715756e-01, 6.715894e-01, 6.716033e-01, 6.716170e-01, 6.716309e-01, 6.716447e-01,
    6.716586e-01, 6.716723e-01, 6.716862e-01, 6.717000e-01, 6.717138e-01, 6.717277e-01,
    6.717414e-01, 6.717553e-01, 6.717691e-01, 6.717829e-01, 6.717967e-01, 6.718106e-01,
    6.718244e-01, 6.718382e-01, 6.718520e-01, 6.718658e-01, 6.718796e-01, 6.718935e-01,
    6.719073e-01, 6.719211e-01, 6.719349e-01, 6.719487e-01, 6.719625e-01, 6.719764e-01,
    6.719902e-01, 6.720040e-01, 6.720178e-01, 6.720316e-01, 6.720454e-01, 6.720593e-01,
    6.720731e-01, 6.720869e-01, 6.721007e-01, 6.721145e-01, 6.721283e-01, 6.721421e-01,
    6.721560e-01, 6.721697e-01, 6.721836e-01, 6.721974e-01, 6.722112e-01, 6.722251e-01,
    6.722389e-01, 6.722527e-01, 6.722665e-01, 6.722803e-01, 6.722941e-01, 6.723079e-01,
    6.723217e-01, 6.723356e-01, 6.723493e-01, 6.723632e-01, 6.723770e-01, 6.723908e-01,
    6.724046e-01, 6.724185e-01, 6.724322e-01, 6.724461e-01, 6.724598e-01, 6.724737e-01,
    6.724875e-01, 6.725013e-01, 6.725151e-01, 6.725289e-01, 6.725428e-01, 6.725566e-01,
    6.725703e-01, 6.725842e-01, 6.725980e-01, 6.726118e-01, 6.726256e-01, 6.726394e-01,
    6.726532e-01, 6.726670e-01, 6.726809e-01, 6.726947e-01, 6.727085e-01, 6.727223e-01,
    6.727361e-01, 6.727499e-01, 6.727637e-01, 6.727775e-01, 6.727913e-01, 6.728051e-01,
    6.728190e-01, 6.728328e-01, 6.728466e-01, 6.728604e-01, 6.728742e-01, 6.728880e-01,
    6.729018e-01, 6.729156e-01, 6.729294e-01, 6.729432e-01, 6.729570e-01, 6.729708e-01,
    6.729846e-01, 6.729985e-01, 6.730123e-01, 6.730261e-01, 6.730399e-01, 6.730537e-01,
    6.730675e-01, 6.730813e-01, 6.730950e-01, 6.731089e-01, 6.731227e-01, 6.731365e-01,
    6.731503e-01, 6.731641e-01, 6.731780e-01, 6.731917e-01, 6.732056e-01, 6.732193e-01,
    6.732332e-01, 6.732469e-01, 6.732607e-01, 6.732746e-01, 6.732884e-01, 6.733022e-01,
    6.733160e-01, 6.733298e-01, 6.733436e-01, 6.733574e-01, 6.733712e-01, 6.733850e-01,
    6.733988e-01, 6.734126e-01, 6.734264e-01, 6.734402e-01, 6.734540e-01, 6.734678e-01,
    6.734816e-01, 6.734954e-01, 6.735092e-01, 6.735230e-01, 6.735368e-01, 6.735506e-01,
    6.735644e-01, 6.735782e-01, 6.735920e-01, 6.736058e-01, 6.736196e-01, 6.736334e-01,
    6.736472e-01, 6.736611e-01, 6.736748e-01, 6.736887e-01, 6.737024e-01, 6.737162e-01,
    6.737300e-01, 6.737438e-01, 6.737576e-01, 6.737714e-01, 6.737853e-01, 6.737990e-01,
    6.738129e-01, 6.738266e-01, 6.738405e-01, 6.738542e-01, 6.738681e-01, 6.738818e-01,
    6.738956e-01, 6.739094e-01, 6.739232e-01, 6.739370e-01, 6.739508e-01, 6.739646e-01,
    6.739784e-01, 6.739922e-01, 6.740060e-01, 6.740198e-01, 6.740336e-01, 6.740474e-01,
    6.740612e-01, 6.740750e-01, 6.740888e-01, 6.741026e-01, 6.741164e-01, 6.741302e-01,
    6.741440e-01, 6.741577e-01, 6.741716e-01, 6.741853e-01, 6.741992e-01, 6.742130e-01,
    6.742268e-01, 6.742406e-01, 6.742543e-01, 6.742681e-01, 6.742820e-01, 6.742957e-01,
    6.743096e-01, 6.743233e-01, 6.743371e-01, 6.743509e-01, 6.743647e-01, 6.743785e-01,
    6.743923e-01, 6.744061e-01, 6.744199e-01, 6.744336e-01, 6.744475e-01, 6.744612e-01,
    6.744751e-01, 6.744888e-01, 6.745026e-01, 6.745164e-01, 6.745302e-01, 6.745440e-01,
    6.745578e-01, 6.745716e-01, 6.745854e-01, 6.745992e-01, 6.746129e-01, 6.746268e-01,
    6.746405e-01, 6.746544e-01, 6.746681e-01, 6.746819e-01, 6.746957e-01, 6.747095e-01,
    6.747233e-01, 6.747371e-01, 6.747509e-01, 6.747647e-01, 6.747785e-01, 6.747922e-01,
    6.748061e-01, 6.748198e-01, 6.748336e-01, 6.748474e-01, 6.748612e-01, 6.748750e-01,
    6.748888e-01, 6.749026e-01, 6.749164e-01, 6.749302e-01, 6.749439e-01, 6.749578e-01,
    6.749715e-01, 6.749853e-01, 6.749991e-01, 6.750128e-01, 6.750267e-01, 6.750405e-01,
    6.750542e-01, 6.750680e-01, 6.750818e-01, 6.750956e-01, 6.751094e-01, 6.751232e-01,
    6.751369e-01, 6.751508e-01, 6.751645e-01, 6.751783e-01, 6.751921e-01, 6.752059e-01,
    6.752197e-01, 6.752335e-01, 6.752473e-01, 6.752610e-01, 6.752748e-01, 6.752886e-01,
    6.753024e-01, 6.753162e-01, 6.753299e-01, 6.753438e-01, 6.753575e-01, 6.753713e-01,
    6.753851e-01, 6.753989e-01, 6.754127e-01, 6.754264e-01, 6.754403e-01, 6.754540e-01,
    6.754678e-01, 6.754816e-01, 6.754953e-01, 6.755092e-01, 6.755229e-01, 6.755367e-01,
    6.755505e-01, 6.755643e-01, 6.755781e-01, 6.755918e-01, 6.756057e-01, 6.756194e-01,
    6.756332e-01, 6.756470e-01, 6.756607e-01, 6.756746e-01, 6.756883e-01, 6.757021e-01,
    6.757159e-01, 6.757297e-01, 6.757435e-01, 6.757572e-01, 6.757710e-01, 6.757848e-01,
    6.757985e-01, 6.758124e-01, 6.758261e-01, 6.758399e-01, 6.758537e-01, 6.758675e-01,
    6.758813e-01, 6.758950e-01, 6.759088e-01, 6.759226e-01, 6.759363e-01, 6.759502e-01,
    6.759639e-01, 6.759777e-01, 6.759915e-01, 6.760052e-01, 6.760190e-01, 6.760328e-01,
    6.760466e-01, 6.760604e-01, 6.760741e-01, 6.760879e-01, 6.761017e-01, 6.761155e-01,
    6.761292e-01, 6.761431e-01, 6.761568e-01, 6.761706e-01, 6.761844e-01, 6.761982e-01,
    6.762119e-01, 6.762257e-01, 6.762395e-01, 6.762533e-01, 6.762670e-01, 6.762808e-01,
    6.762946e-01, 6.763083e-01, 6.763221e-01, 6.763359e-01, 6.763497e-01, 6.763634e-01,
    6.763772e-01, 6.763910e-01, 6.764048e-01, 6.764185e-01, 6.764323e-01, 6.764461e-01,
    6.764598e-01, 6.764736e-01, 6.764874e-01, 6.765012e-01, 6.765149e-01, 6.765288e-01,
    6.765425e-01, 6.765563e-01, 6.765701e-01, 6.765838e-01, 6.765976e-01, 6.766114e-01,
    6.766251e-01, 6.766389e-01, 6.766527e-01, 6.766665e-01, 6.766802e-01, 6.766940e-01,
    6.767078e-01, 6.767216e-01, 6.767353e-01, 6.767491e-01, 6.767629e-01, 6.767766e-01,
    6.767904e-01, 6.768042e-01, 6.768180e-01, 6.768317e-01, 6.768455e-01, 6.768593e-01,
    6.768730e-01, 6.768868e-01, 6.769006e-01, 6.769143e-01, 6.769281e-01, 6.769419e-01,
    6.769556e-01, 6.769694e-01, 6.769832e-01, 6.769970e-01, 6.770107e-01, 6.770245e-01,
    6.770383e-01, 6.770520e-01, 6.770658e-01, 6.770796e-01, 6.770933e-01, 6.771071e-01,
    6.771209e-01, 6.771346e-01, 6.771484e-01, 6.771622e-01, 6.771759e-01, 6.771897e-01,
    6.772035e-01, 6.772172e-01, 6.772310e-01, 6.772448e-01, 6.772585e-01, 6.772723e-01,
    6.772861e-01, 6.772999e-01, 6.773136e-01, 6.773273e-01, 6.773412e-01, 6.773549e-01,
    6.773687e-01, 6.773824e-01, 6.773962e-01, 6.774099e-01, 6.774237e-01, 6.774375e-01,
    6.774513e-01, 6.774650e-01, 6.774788e-01, 6.774926e-01, 6.775063e-01, 6.775200e-01,
    6.775338e-01, 6.775476e-01, 6.775614e-01, 6.775751e-01, 6.775889e-01, 6.776026e-01,
    6.776164e-01, 6.776302e-01, 6.776440e-01, 6.776577e-01, 6.776715e-01, 6.776853e-01,
    6.776990e-01, 6.777128e-01, 6.777265e-01, 6.777403e-01, 6.777540e-01, 6.777678e-01,
    6.777816e-01, 6.777953e-01, 6.778091e-01, 6.778228e-01, 6.778366e-01, 6.778504e-01,
    6.778641e-01, 6.778779e-01, 6.778917e-01, 6.779054e-01, 6.779192e-01, 6.779330e-01,
    6.779467e-01, 6.779605e-01, 6.779742e-01, 6.779880e-01, 6.780018e-01, 6.780155e-01,
    6.780292e-01, 6.780430e-01, 6.780568e-01, 6.780705e-01, 6.780843e-01, 6.780980e-01,
    6.781118e-01, 6.781256e-01, 6.781393e-01, 6.781531e-01, 6.781669e-01, 6.781806e-01,
    6.781943e-01, 6.782081e-01, 6.782219e-01, 6.782357e-01, 6.782494e-01, 6.782631e-01,
    6.782769e-01, 6.782906e-01, 6.783044e-01, 6.783181e-01, 6.783319e-01, 6.783457e-01,
    6.783594e-01, 6.783732e-01, 6.783869e-01, 6.784007e-01, 6.784145e-01, 6.784282e-01,
    6.784420e-01, 6.784557e-01, 6.784695e-01, 6.784832e-01, 6.784970e-01, 6.785107e-01,
    6.785245e-01, 6.785383e-01, 6.785520e-01, 6.785657e-01, 6.785795e-01, 6.785933e-01,
    6.786070e-01, 6.786208e-01, 6.786345e-01, 6.786483e-01, 6.786620e-01, 6.786758e-01,
    6.786895e-01, 6.787033e-01, 6.787170e-01, 6.787308e-01, 6.787446e-01, 6.787583e-01,
    6.787720e-01, 6.787858e-01, 6.787996e-01, 6.788133e-01, 6.788270e-01, 6.788408e-01,
    6.788546e-01, 6.788683e-01, 6.788821e-01, 6.788958e-01, 6.789095e-01, 6.789233e-01,
    6.789371e-01, 6.789508e-01, 6.789646e-01, 6.789783e-01, 6.789920e-01, 6.790058e-01,
    6.790196e-01, 6.790333e-01, 6.790470e-01, 6.790608e-01, 6.790746e-01, 6.790883e-01,
    6.791021e-01, 6.791158e-01, 6.791295e-01, 6.791433e-01, 6.791570e-01, 6.791708e-01,
    6.791846e-01, 6.791983e-01, 6.792120e-01, 6.792258e-01, 6.792396e-01, 6.792533e-01,
    6.792670e-01, 6.792808e-01, 6.792945e-01, 6.793082e-01, 6.793220e-01, 6.793358e-01,
    6.793495e-01, 6.793633e-01, 6.793770e-01, 6.793908e-01, 6.794045e-01, 6.794182e-01,
    6.794320e-01, 6.794457e-01, 6.794595e-01, 6.794732e-01, 6.794870e-01, 6.795007e-01,
    6.795145e-01, 6.795282e-01, 6.795419e-01, 6.795557e-01, 6.795694e-01, 6.795832e-01,
    6.795969e-01, 6.796107e-01, 6.796244e-01, 6.796381e-01, 6.796519e-01, 6.796656e-01,
    6.796794e-01, 6.796932e-01, 6.797069e-01, 6.797206e-01, 6.797344e-01, 6.797481e-01,
    6.797618e-01, 6.797756e-01, 6.797893e-01, 6.798031e-01, 6.798168e-01, 6.798306e-01,
    6.798443e-01, 6.798580e-01, 6.798718e-01, 6.798855e-01, 6.798993e-01, 6.799130e-01,
    6.799268e-01, 6.799405e-01, 6.799542e-01, 6.799680e-01, 6.799817e-01, 6.799955e-01,
    6.800092e-01, 6.800230e-01, 6.800367e-01, 6.800504e-01, 6.800641e-01, 6.800779e-01,
    6.800916e-01, 6.801053e-01, 6.801191e-01, 6.801329e-01, 6.801466e-01, 6.801603e-01,
    6.801741e-01, 6.801878e-01, 6.802015e-01, 6.802153e-01, 6.802290e-01, 6.802428e-01,
    6.802565e-01, 6.802703e-01, 6.802840e-01, 6.802977e-01, 6.803114e-01, 6.803252e-01,
    6.803389e-01, 6.803527e-01, 6.803664e-01, 6.803801e-01, 6.803939e-01, 6.804076e-01,
    6.804214e-01, 6.804351e-01, 6.804488e-01, 6.804625e-01, 6.804762e-01, 6.804900e-01,
    6.805037e-01, 6.805175e-01, 6.805312e-01, 6.805449e-01, 6.805587e-01, 6.805724e-01,
    6.805862e-01, 6.805999e-01, 6.806136e-01, 6.806273e-01, 6.806411e-01, 6.806548e-01,
    6.806685e-01, 6.806823e-01, 6.806960e-01, 6.807098e-01, 6.807235e-01, 6.807373e-01,
    6.807510e-01, 6.807647e-01, 6.807784e-01, 6.807922e-01, 6.808059e-01, 6.808196e-01,
    6.808333e-01, 6.808471e-01, 6.808608e-01, 6.808745e-01, 6.808883e-01, 6.809020e-01,
    6.809158e-01, 6.809295e-01, 6.809432e-01, 6.809570e-01, 6.809707e-01, 6.809844e-01,
    6.809981e-01, 6.810119e-01, 6.810256e-01, 6.810393e-01, 6.810530e-01, 6.810668e-01,
    6.810805e-01, 6.810942e-01, 6.811079e-01, 6.811217e-01, 6.811354e-01, 6.811491e-01,
    6.811629e-01, 6.811766e-01, 6.811904e-01, 6.812041e-01, 6.812178e-01, 6.812316e-01,
    6.812453e-01, 6.812590e-01, 6.812727e-01, 6.812865e-01, 6.813002e-01, 6.813139e-01,
    6.813276e-01, 6.813414e-01, 6.813551e-01, 6.813688e-01, 6.813825e-01, 6.813963e-01,
    6.814100e-01, 6.814237e-01, 6.814374e-01, 6.814512e-01, 6.814649e-01, 6.814786e-01,
    6.814923e-01, 6.815061e-01, 6.815198e-01, 6.815335e-01, 6.815472e-01, 6.815610e-01,
    6.815747e-01, 6.815884e-01, 6.816022e-01, 6.816159e-01, 6.816297e-01, 6.816434e-01,
    6.816571e-01, 6.816708e-01, 6.816846e-01, 6.816983e-01, 6.817120e-01, 6.817257e-01,
    6.817394e-01, 6.817531e-01, 6.817669e-01, 6.817806e-01, 6.817943e-01, 6.818080e-01,
    6.818218e-01, 6.818355e-01, 6.818492e-01, 6.818630e-01, 6.818767e-01, 6.818904e-01,
    6.819041e-01, 6.819178e-01, 6.819316e-01, 6.819453e-01, 6.819590e-01, 6.819727e-01,
    6.819864e-01, 6.820001e-01, 6.820138e-01, 6.820276e-01, 6.820413e-01, 6.820551e-01,
    6.820688e-01, 6.820825e-01, 6.820962e-01, 6.821099e-01, 6.821236e-01, 6.821373e-01,
    6.821511e-01, 6.821648e-01, 6.821785e-01, 6.821922e-01, 6.822059e-01, 6.822197e-01,
    6.822334e-01, 6.822471e-01, 6.822608e-01, 6.822745e-01, 6.822882e-01, 6.823019e-01,
    6.823157e-01, 6.823294e-01, 6.823431e-01, 6.823568e-01, 6.823706e-01, 6.823843e-01,
    6.823980e-01, 6.824117e-01, 6.824254e-01, 6.824391e-01, 6.824529e-01, 6.824666e-01,
    6.824803e-01, 6.824940e-01, 6.825078e-01, 6.825215e-01, 6.825352e-01, 6.825489e-01,
    6.825626e-01, 6.825763e-01, 6.825900e-01, 6.826037e-01, 6.826174e-01, 6.826312e-01,
    6.826449e-01, 6.826586e-01, 6.826723e-01, 6.826860e-01, 6.826997e-01, 6.827134e-01,
    6.827272e-01, 6.827409e-01, 6.827546e-01, 6.827683e-01, 6.827821e-01, 6.827958e-01,
    6.828095e-01, 6.828232e-01, 6.828369e-01, 6.828506e-01, 6.828643e-01, 6.828780e-01,
    6.828917e-01, 6.829054e-01, 6.829191e-01, 6.829329e-01, 6.829466e-01, 6.829603e-01,
    6.829740e-01, 6.829877e-01, 6.830015e-01, 6.830152e-01, 6.830289e-01, 6.830425e-01,
    6.830563e-01, 6.830700e-01, 6.830837e-01, 6.830974e-01, 6.831111e-01, 6.831248e-01,
    6.831385e-01, 6.831523e-01, 6.831660e-01, 6.831797e-01, 6.831934e-01, 6.832071e-01,
    6.832208e-01, 6.832345e-01, 6.832482e-01, 6.832619e-01, 6.832756e-01, 6.832893e-01,
    6.833031e-01, 6.833168e-01, 6.833305e-01, 6.833442e-01, 6.833579e-01, 6.833716e-01,
    6.833853e-01, 6.833990e-01, 6.834127e-01, 6.834264e-01, 6.834401e-01, 6.834539e-01,
    6.834676e-01, 6.834813e-01, 6.834949e-01, 6.835087e-01, 6.835224e-01, 6.835361e-01,
    6.835498e-01, 6.835635e-01, 6.835772e-01, 6.835909e-01, 6.836047e-01, 6.836184e-01,
    6.836320e-01, 6.836457e-01, 6.836594e-01, 6.836731e-01, 6.836869e-01, 6.837006e-01,
    6.837143e-01, 6.837280e-01, 6.837417e-01, 6.837554e-01, 6.837691e-01, 6.837828e-01,
    6.837965e-01, 6.838102e-01, 6.838239e-01, 6.838376e-01, 6.838513e-01, 6.838650e-01,
    6.838787e-01, 6.838924e-01, 6.839061e-01, 6.839198e-01, 6.839335e-01, 6.839472e-01,
    6.839609e-01, 6.839747e-01, 6.839883e-01, 6.840020e-01, 6.840158e-01, 6.840295e-01,
    6.840432e-01, 6.840569e-01, 6.840705e-01, 6.840842e-01, 6.840979e-01, 6.841117e-01,
    6.841254e-01, 6.841391e-01, 6.841527e-01, 6.841664e-01, 6.841802e-01, 6.841938e-01,
    6.842076e-01, 6.842213e-01, 6.842350e-01, 6.842487e-01, 6.842623e-01, 6.842760e-01,
    6.842898e-01, 6.843035e-01, 6.843172e-01, 6.843309e-01, 6.843445e-01, 6.843582e-01,
    6.843719e-01, 6.843857e-01, 6.843994e-01, 6.844130e-01, 6.844268e-01, 6.844404e-01,
    6.844541e-01, 6.844679e-01, 6.844816e-01, 6.844953e-01, 6.845089e-01, 6.845226e-01,
    6.845363e-01, 6.845500e-01, 6.845638e-01, 6.845774e-01, 6.845911e-01, 6.846048e-01,
    6.846185e-01, 6.846322e-01, 6.846459e-01, 6.846596e-01, 6.846733e-01, 6.846870e-01,
    6.847007e-01, 6.847144e-01, 6.847281e-01, 6.847418e-01, 6.847554e-01, 6.847692e-01,
    6.847829e-01, 6.847966e-01, 6.848102e-01, 6.848239e-01, 6.848376e-01, 6.848513e-01,
    6.848650e-01, 6.848787e-01, 6.848924e-01, 6.849061e-01, 6.849198e-01, 6.849335e-01,
    6.849472e-01, 6.849609e-01, 6.849746e-01, 6.849883e-01, 6.850020e-01, 6.850157e-01,
    6.850293e-01, 6.850430e-01, 6.850567e-01, 6.850704e-01, 6.850841e-01, 6.850978e-01,
    6.851115e-01, 6.851252e-01, 6.851389e-01, 6.851526e-01, 6.851662e-01, 6.851799e-01,
    6.851936e-01, 6.852074e-01, 6.852210e-01, 6.852347e-01, 6.852484e-01, 6.852621e-01,
    6.852758e-01, 6.852894e-01, 6.853032e-01, 6.853169e-01, 6.853305e-01, 6.853442e-01,
    6.853579e-01, 6.853716e-01, 6.853853e-01, 6.853990e-01, 6.854127e-01, 6.854264e-01,
    6.854401e-01, 6.854538e-01, 6.854674e-01, 6.854811e-01, 6.854948e-01, 6.855085e-01,
    6.855222e-01, 6.855358e-01, 6.855496e-01, 6.855633e-01, 6.855769e-01, 6.855906e-01,
    6.856043e-01, 6.856180e-01, 6.856317e-01, 6.856454e-01, 6.856591e-01, 6.856727e-01,
    6.856865e-01, 6.857001e-01, 6.857138e-01, 6.857275e-01, 6.857412e-01, 6.857548e-01,
    6.857685e-01, 6.857823e-01, 6.857959e-01, 6.858096e-01, 6.858233e-01, 6.858370e-01,
    6.858506e-01, 6.858643e-01, 6.858780e-01, 6.858917e-01, 6.859054e-01, 6.859191e-01,
    6.859328e-01, 6.859465e-01, 6.859601e-01, 6.859738e-01, 6.859875e-01, 6.860012e-01,
    6.860148e-01, 6.860285e-01, 6.860422e-01, 6.860559e-01, 6.860695e-01, 6.860833e-01,
    6.860970e-01, 6.861106e-01, 6.861243e-01, 6.861380e-01, 6.861517e-01, 6.861654e-01,
    6.861790e-01, 6.861927e-01, 6.862064e-01, 6.862201e-01, 6.862338e-01, 6.862475e-01,
    6.862611e-01, 6.862748e-01, 6.862885e-01, 6.863022e-01, 6.863158e-01, 6.863295e-01,
    6.863432e-01, 6.863569e-01, 6.863706e-01, 6.863843e-01, 6.863979e-01, 6.864116e-01,
    6.864253e-01, 6.864390e-01, 6.864527e-01, 6.864663e-01, 6.864800e-01, 6.864937e-01,
    6.865073e-01, 6.865211e-01, 6.865347e-01, 6.865484e-01, 6.865621e-01, 6.865758e-01,
    6.865894e-01, 6.866031e-01, 6.866168e-01, 6.866304e-01, 6.866441e-01, 6.866578e-01,
    6.866715e-01, 6.866852e-01, 6.866989e-01, 6.867126e-01, 6.867262e-01, 6.867399e-01,
    6.867536e-01, 6.867672e-01, 6.867809e-01, 6.867946e-01, 6.868082e-01, 6.868219e-01,
    6.868356e-01, 6.868493e-01, 6.868630e-01, 6.868767e-01, 6.868903e-01, 6.869040e-01,
    6.869177e-01, 6.869313e-01, 6.869450e-01, 6.869587e-01, 6.869724e-01, 6.869860e-01,
    6.869997e-01, 6.870134e-01, 6.870270e-01, 6.870407e-01, 6.870544e-01, 6.870680e-01,
    6.870818e-01, 6.870954e-01, 6.871091e-01, 6.871228e-01, 6.871364e-01, 6.871501e-01,
    6.871638e-01, 6.871774e-01, 6.871911e-01, 6.872048e-01, 6.872185e-01, 6.872321e-01,
    6.872458e-01, 6.872595e-01, 6.872731e-01, 6.872869e-01, 6.873005e-01, 6.873142e-01,
    6.873279e-01, 6.873415e-01, 6.873552e-01, 6.873689e-01, 6.873825e-01, 6.873962e-01,
    6.874098e-01, 6.874235e-01, 6.874372e-01, 6.874508e-01, 6.874645e-01, 6.874782e-01,
    6.874919e-01, 6.875055e-01, 6.875192e-01, 6.875329e-01, 6.875466e-01, 6.875603e-01,
    6.875739e-01, 6.875876e-01, 6.876012e-01, 6.876149e-01, 6.876286e-01, 6.876422e-01,
    6.876559e-01, 6.876696e-01, 6.876832e-01, 6.876969e-01, 6.877105e-01, 6.877242e-01,
    6.877379e-01, 6.877516e-01, 6.877652e-01, 6.877789e-01, 6.877925e-01, 6.878062e-01,
    6.878199e-01, 6.878335e-01, 6.878473e-01, 6.878609e-01, 6.878746e-01, 6.878882e-01,
    6.879019e-01, 6.879156e-01, 6.879292e-01, 6.879429e-01, 6.879565e-01, 6.879702e-01,
    6.879839e-01, 6.879975e-01, 6.880112e-01, 6.880248e-01, 6.880385e-01, 6.880522e-01,
    6.880659e-01, 6.880795e-01, 6.880932e-01, 6.881068e-01, 6.881205e-01, 6.881342e-01,
    6.881478e-01, 6.881615e-01, 6.881751e-01, 6.881889e-01, 6.882025e-01, 6.882161e-01,
    6.882298e-01, 6.882435e-01, 6.882572e-01, 6.882708e-01, 6.882845e-01, 6.882981e-01,
    6.883118e-01, 6.883254e-01, 6.883391e-01, 6.883528e-01, 6.883665e-01, 6.883801e-01,
    6.883938e-01, 6.884074e-01, 6.884211e-01, 6.884347e-01, 6.884484e-01, 6.884621e-01,
    6.884757e-01, 6.884894e-01, 6.885030e-01, 6.885167e-01, 6.885303e-01, 6.885440e-01,
    6.885576e-01, 6.885713e-01, 6.885850e-01, 6.885986e-01, 6.886123e-01, 6.886260e-01,
    6.886396e-01, 6.886533e-01, 6.886669e-01, 6.886806e-01, 6.886942e-01, 6.887079e-01,
    6.887215e-01, 6.887352e-01, 6.887489e-01, 6.887625e-01, 6.887762e-01, 6.887898e-01,
    6.888035e-01, 6.888171e-01, 6.888308e-01, 6.888445e-01, 6.888582e-01, 6.888718e-01,
    6.888855e-01, 6.888991e-01, 6.889127e-01, 6.889264e-01, 6.889400e-01, 6.889537e-01,
    6.889674e-01, 6.889811e-01, 6.889947e-01, 6.890084e-01, 6.890220e-01, 6.890357e-01,
    6.890493e-01, 6.890630e-01, 6.890766e-01, 6.890903e-01, 6.891039e-01, 6.891176e-01,
    6.891312e-01, 6.891449e-01, 6.891586e-01, 6.891722e-01, 6.891859e-01, 6.891995e-01,
    6.892132e-01, 6.892268e-01, 6.892405e-01, 6.892541e-01, 6.892678e-01, 6.892814e-01,
    6.892951e-01, 6.893087e-01, 6.893224e-01, 6.893360e-01, 6.893497e-01, 6.893633e-01,
    6.893770e-01, 6.893906e-01, 6.894042e-01, 6.894179e-01, 6.894316e-01, 6.894452e-01,
    6.894589e-01, 6.894725e-01, 6.894862e-01, 6.894998e-01, 6.895135e-01, 6.895271e-01,
    6.895408e-01, 6.895544e-01, 6.895681e-01, 6.895817e-01, 6.895954e-01, 6.896091e-01,
    6.896226e-01, 6.896363e-01, 6.896499e-01, 6.896636e-01, 6.896772e-01, 6.896909e-01,
    6.897045e-01, 6.897182e-01, 6.897318e-01, 6.897455e-01, 6.897591e-01, 6.897728e-01,
    6.897865e-01, 6.898001e-01, 6.898137e-01, 6.898274e-01, 6.898410e-01, 6.898547e-01,
    6.898683e-01, 6.898820e-01, 6.898956e-01, 6.899093e-01, 6.899229e-01, 6.899366e-01,
    6.899502e-01, 6.899639e-01, 6.899775e-01, 6.899911e-01, 6.900048e-01, 6.900184e-01,
    6.900321e-01, 6.900457e-01, 6.900594e-01, 6.900730e-01, 6.900867e-01, 6.901003e-01,
    6.901140e-01, 6.901276e-01, 6.901412e-01, 6.901549e-01, 6.901685e-01, 6.901821e-01,
    6.901958e-01, 6.902094e-01, 6.902231e-01, 6.902367e-01, 6.902504e-01, 6.902640e-01,
    6.902777e-01, 6.902913e-01, 6.903049e-01, 6.903186e-01, 6.903322e-01, 6.903459e-01,
    6.903595e-01, 6.903732e-01, 6.903868e-01, 6.904004e-01, 6.904141e-01, 6.904277e-01,
    6.904414e-01, 6.904550e-01, 6.904687e-01, 6.904823e-01, 6.904959e-01, 6.905096e-01,
    6.905233e-01, 6.905369e-01, 6.905505e-01, 6.905642e-01, 6.905778e-01, 6.905915e-01,
    6.906050e-01, 6.906187e-01, 6.906323e-01, 6.906460e-01, 6.906596e-01, 6.906732e-01,
    6.906869e-01, 6.907005e-01, 6.907142e-01, 6.907278e-01, 6.907414e-01, 6.907551e-01,
    6.907687e-01, 6.907824e-01, 6.907960e-01, 6.908096e-01, 6.908233e-01, 6.908369e-01,
    6.908506e-01, 6.908642e-01, 6.908779e-01, 6.908914e-01, 6.909051e-01, 6.909187e-01,
    6.909324e-01, 6.909460e-01, 6.909596e-01, 6.909733e-01, 6.909869e-01, 6.910005e-01,
    6.910142e-01, 6.910278e-01, 6.910415e-01, 6.910551e-01, 6.910687e-01, 6.910824e-01,
    6.910960e-01, 6.911097e-01, 6.911233e-01, 6.911369e-01, 6.911505e-01, 6.911642e-01,
    6.911778e-01, 6.911914e-01, 6.912051e-01, 6.912187e-01, 6.912323e-01, 6.912460e-01,
    6.912596e-01, 6.912733e-01, 6.912869e-01, 6.913005e-01, 6.913142e-01, 6.913278e-01,
    6.913414e-01, 6.913550e-01, 6.913686e-01, 6.913823e-01, 6.913959e-01, 6.914095e-01,
    6.914232e-01, 6.914368e-01, 6.914505e-01, 6.914641e-01, 6.914777e-01, 6.914914e-01,
    6.915050e-01, 6.915186e-01, 6.915323e-01, 6.915459e-01, 6.915595e-01, 6.915731e-01,
    6.915868e-01, 6.916004e-01, 6.916140e-01, 6.916277e-01, 6.916413e-01, 6.916549e-01,
    6.916686e-01, 6.916822e-01, 6.916958e-01, 6.917095e-01, 6.917230e-01, 6.917367e-01,
    6.917503e-01, 6.917639e-01, 6.917776e-01, 6.917912e-01, 6.918048e-01, 6.918185e-01,
    6.918321e-01, 6.918457e-01, 6.918594e-01, 6.918730e-01, 6.918866e-01, 6.919002e-01,
    6.919138e-01, 6.919275e-01, 6.919411e-01, 6.919547e-01, 6.919684e-01, 6.919820e-01,
    6.919956e-01, 6.920093e-01, 6.920229e-01, 6.920365e-01, 6.920502e-01, 6.920637e-01,
    6.920774e-01, 6.920910e-01, 6.921046e-01, 6.921182e-01, 6.921319e-01, 6.921455e-01,
    6.921591e-01, 6.921728e-01, 6.921864e-01, 6.922000e-01, 6.922136e-01, 6.922272e-01,
    6.922409e-01, 6.922545e-01, 6.922681e-01, 6.922818e-01, 6.922954e-01, 6.923090e-01,
    6.923226e-01, 6.923363e-01, 6.923499e-01, 6.923635e-01, 6.923772e-01, 6.923907e-01,
    6.924044e-01, 6.924180e-01, 6.924316e-01, 6.924452e-01, 6.924589e-01, 6.924725e-01,
    6.924861e-01, 6.924997e-01, 6.925133e-01, 6.925270e-01, 6.925406e-01, 6.925542e-01,
    6.925678e-01, 6.925814e-01, 6.925951e-01, 6.926087e-01, 6.926223e-01, 6.926359e-01,
    6.926495e-01, 6.926632e-01, 6.926768e-01, 6.926904e-01, 6.927040e-01, 6.927177e-01,
    6.927313e-01, 6.927449e-01, 6.927585e-01, 6.927722e-01, 6.927857e-01, 6.927994e-01,
    6.928130e-01, 6.928266e-01, 6.928402e-01, 6.928538e-01, 6.928675e-01, 6.928811e-01,
    6.928947e-01, 6.929083e-01, 6.929219e-01, 6.929355e-01, 6.929492e-01, 6.929628e-01,
    6.929764e-01, 6.929900e-01, 6.930036e-01, 6.930172e-01, 6.930309e-01, 6.930445e-01,
    6.930581e-01, 6.930717e-01, 6.930854e-01, 6.930990e-01, 6.931126e-01, 6.931262e-01,
    6.931398e-01, 6.931534e-01, 6.931670e-01, 6.931806e-01, 6.931943e-01, 6.932079e-01,
    6.932214e-01, 6.932351e-01, 6.932487e-01, 6.932623e-01, 6.932759e-01, 6.932896e-01,
    6.933032e-01, 6.933168e-01, 6.933304e-01, 6.933440e-01, 6.933576e-01, 6.933712e-01,
    6.933849e-01, 6.933985e-01, 6.934121e-01, 6.934257e-01, 6.934393e-01, 6.934529e-01,
    6.934665e-01, 6.934801e-01, 6.934938e-01, 6.935074e-01, 6.935210e-01, 6.935346e-01,
    6.935482e-01, 6.935619e-01, 6.935754e-01, 6.935890e-01, 6.936027e-01, 6.936163e-01,
    6.936299e-01, 6.936435e-01, 6.936571e-01, 6.936707e-01, 6.936843e-01, 6.936979e-01,
    6.937115e-01, 6.937252e-01, 6.937388e-01, 6.937524e-01, 6.937660e-01, 6.937796e-01,
    6.937932e-01, 6.938068e-01, 6.938204e-01, 6.938340e-01, 6.938476e-01, 6.938612e-01,
    6.938748e-01, 6.938885e-01, 6.939021e-01, 6.939157e-01, 6.939293e-01, 6.939429e-01,
    6.939565e-01, 6.939701e-01, 6.939837e-01, 6.939973e-01, 6.940109e-01, 6.940246e-01,
    6.940382e-01, 6.940517e-01, 6.940653e-01, 6.940790e-01, 6.940926e-01, 6.941062e-01,
    6.941198e-01, 6.941334e-01, 6.941470e-01, 6.941606e-01, 6.941742e-01, 6.941878e-01,
    6.942014e-01, 6.942150e-01, 6.942286e-01, 6.942422e-01, 6.942559e-01, 6.942695e-01,
    6.942831e-01, 6.942967e-01, 6.943102e-01, 6.943239e-01, 6.943375e-01, 6.943511e-01,
    6.943647e-01, 6.943783e-01, 6.943919e-01, 6.944055e-01, 6.944191e-01, 6.944327e-01,
    6.944463e-01, 6.944599e-01, 6.944735e-01, 6.944872e-01, 6.945007e-01, 6.945143e-01,
    6.945279e-01, 6.945415e-01, 6.945551e-01, 6.945688e-01, 6.945823e-01, 6.945959e-01,
    6.946095e-01, 6.946231e-01, 6.946368e-01, 6.946504e-01, 6.946639e-01, 6.946776e-01,
    6.946912e-01, 6.947047e-01, 6.947184e-01, 6.947320e-01, 6.947455e-01, 6.947592e-01,
    6.947728e-01, 6.947864e-01, 6.948000e-01, 6.948135e-01, 6.948271e-01, 6.948407e-01,
    6.948544e-01, 6.948680e-01, 6.948816e-01, 6.948951e-01, 6.949087e-01, 6.949223e-01,
    6.949359e-01, 6.949496e-01, 6.949632e-01, 6.949767e-01, 6.949903e-01, 6.950039e-01,
    6.950175e-01, 6.950311e-01, 6.950448e-01, 6.950583e-01, 6.950719e-01, 6.950855e-01,
    6.950991e-01, 6.951127e-01, 6.951263e-01, 6.951399e-01, 6.951535e-01, 6.951671e-01,
    6.951807e-01, 6.951943e-01, 6.952079e-01, 6.952215e-01, 6.952351e-01, 6.952487e-01,
    6.952623e-01, 6.952759e-01, 6.952895e-01, 6.953031e-01, 6.953167e-01, 6.953303e-01,
    6.953439e-01, 6.953574e-01, 6.953710e-01, 6.953846e-01, 6.953982e-01, 6.954118e-01,
    6.954255e-01, 6.954390e-01, 6.954526e-01, 6.954662e-01, 6.954798e-01, 6.954933e-01,
    6.955070e-01, 6.955206e-01, 6.955342e-01, 6.955478e-01, 6.955613e-01, 6.955749e-01,
    6.955886e-01, 6.956021e-01, 6.956157e-01, 6.956293e-01, 6.956429e-01, 6.956565e-01,
    6.956701e-01, 6.956837e-01, 6.956973e-01, 6.957109e-01, 6.957245e-01, 6.957381e-01,
    6.957517e-01, 6.957653e-01, 6.957788e-01, 6.957924e-01, 6.958060e-01, 6.958196e-01,
    6.958332e-01, 6.958468e-01, 6.958604e-01, 6.958740e-01, 6.958876e-01, 6.959012e-01,
    6.959147e-01, 6.959283e-01, 6.959419e-01, 6.959555e-01, 6.959690e-01, 6.959826e-01,
    6.959962e-01, 6.960098e-01, 6.960234e-01, 6.960370e-01, 6.960506e-01, 6.960642e-01,
    6.960778e-01, 6.960914e-01, 6.961050e-01, 6.961186e-01, 6.961321e-01, 6.961457e-01,
    6.961593e-01, 6.961729e-01, 6.961865e-01, 6.962001e-01, 6.962137e-01, 6.962273e-01,
    6.962408e-01, 6.962544e-01, 6.962680e-01, 6.962816e-01, 6.962952e-01, 6.963088e-01,
    6.963224e-01, 6.963360e-01, 6.963496e-01, 6.963632e-01, 6.963767e-01, 6.963903e-01,
    6.964039e-01, 6.964175e-01, 6.964310e-01, 6.964446e-01, 6.964582e-01, 6.964718e-01,
    6.964853e-01, 6.964989e-01, 6.965125e-01, 6.965261e-01, 6.965397e-01, 6.965533e-01,
    6.965669e-01, 6.965805e-01, 6.965941e-01, 6.966076e-01, 6.966212e-01, 6.966348e-01,
    6.966484e-01, 6.966619e-01, 6.966755e-01, 6.966891e-01, 6.967027e-01, 6.967163e-01,
    6.967299e-01, 6.967434e-01, 6.967570e-01, 6.967706e-01, 6.967842e-01, 6.967978e-01,
    6.968114e-01, 6.968250e-01, 6.968386e-01, 6.968521e-01, 6.968657e-01, 6.968793e-01,
    6.968929e-01, 6.969064e-01, 6.969200e-01, 6.969336e-01, 6.969472e-01, 6.969607e-01,
    6.969743e-01, 6.969879e-01, 6.970015e-01, 6.970150e-01, 6.970286e-01, 6.970422e-01,
    6.970558e-01, 6.970693e-01, 6.970829e-01, 6.970965e-01, 6.971101e-01, 6.971236e-01,
    6.971372e-01, 6.971508e-01, 6.971644e-01, 6.971780e-01, 6.971916e-01, 6.972051e-01,
    6.972187e-01, 6.972323e-01, 6.972459e-01, 6.972595e-01, 6.972730e-01, 6.972866e-01,
    6.973002e-01, 6.973138e-01, 6.973274e-01, 6.973409e-01, 6.973545e-01, 6.973681e-01,
    6.973817e-01, 6.973953e-01, 6.974088e-01, 6.974224e-01, 6.974360e-01, 6.974496e-01,
    6.974631e-01, 6.974767e-01, 6.974903e-01, 6.975038e-01, 6.975174e-01, 6.975310e-01,
    6.975446e-01, 6.975581e-01, 6.975717e-01, 6.975853e-01, 6.975988e-01, 6.976124e-01,
    6.976260e-01, 6.976395e-01, 6.976531e-01, 6.976667e-01, 6.976802e-01, 6.976938e-01,
    6.977074e-01, 6.977210e-01, 6.977345e-01, 6.977481e-01, 6.977617e-01, 6.977753e-01,
    6.977888e-01, 6.978024e-01, 6.978160e-01, 6.978296e-01, 6.978431e-01, 6.978567e-01,
    6.978703e-01, 6.978838e-01, 6.978974e-01, 6.979110e-01, 6.979246e-01, 6.979381e-01,
    6.979517e-01, 6.979653e-01, 6.979789e-01, 6.979924e-01, 6.980060e-01, 6.980196e-01,
    6.980331e-01, 6.980467e-01, 6.980603e-01, 6.980739e-01, 6.980874e-01, 6.981010e-01,
    6.981146e-01, 6.981281e-01, 6.981417e-01, 6.981552e-01, 6.981688e-01, 6.981824e-01,
    6.981959e-01, 6.982095e-01, 6.982231e-01, 6.982366e-01, 6.982502e-01, 6.982638e-01,
    6.982774e-01, 6.982909e-01, 6.983045e-01, 6.983181e-01, 6.983317e-01, 6.983452e-01,
    6.983588e-01, 6.983723e-01, 6.983859e-01, 6.983994e-01, 6.984130e-01, 6.984265e-01,
    6.984401e-01, 6.984537e-01, 6.984673e-01, 6.984808e-01, 6.984944e-01, 6.985080e-01,
    6.985216e-01, 6.985351e-01, 6.985487e-01, 6.985622e-01, 6.985758e-01, 6.985894e-01,
    6.986029e-01, 6.986165e-01, 6.986301e-01, 6.986436e-01, 6.986572e-01, 6.986707e-01,
    6.986843e-01, 6.986979e-01, 6.987115e-01, 6.987250e-01, 6.987386e-01, 6.987522e-01,
    6.987657e-01, 6.987793e-01, 6.987928e-01, 6.988064e-01, 6.988199e-01, 6.988335e-01,
    6.988471e-01, 6.988606e-01, 6.988742e-01, 6.988878e-01, 6.989014e-01, 6.989149e-01,
    6.989285e-01, 6.989420e-01, 6.989555e-01, 6.989691e-01, 6.989827e-01, 6.989962e-01,
    6.990098e-01, 6.990234e-01, 6.990370e-01, 6.990505e-01, 6.990640e-01, 6.990776e-01,
    6.990911e-01, 6.991047e-01, 6.991183e-01, 6.991318e-01, 6.991454e-01, 6.991590e-01,
    6.991725e-01, 6.991861e-01, 6.991996e-01, 6.992132e-01, 6.992267e-01, 6.992403e-01,
    6.992539e-01, 6.992674e-01, 6.992810e-01, 6.992945e-01, 6.993081e-01, 6.993217e-01,
    6.993352e-01, 6.993488e-01, 6.993623e-01, 6.993759e-01, 6.993895e-01, 6.994030e-01,
    6.994166e-01, 6.994301e-01, 6.994437e-01, 6.994572e-01, 6.994708e-01, 6.994843e-01,
    6.994979e-01, 6.995115e-01, 6.995250e-01, 6.995386e-01, 6.995521e-01, 6.995656e-01,
    6.995792e-01, 6.995928e-01, 6.996064e-01, 6.996199e-01, 6.996335e-01, 6.996470e-01,
    6.996605e-01, 6.996741e-01, 6.996877e-01, 6.997012e-01, 6.997148e-01, 6.997283e-01,
    6.997419e-01, 6.997554e-01, 6.997690e-01, 6.997826e-01, 6.997961e-01, 6.998097e-01,
    6.998232e-01, 6.998367e-01, 6.998503e-01, 6.998639e-01, 6.998774e-01, 6.998910e-01,
    6.999045e-01, 6.999180e-01, 6.999316e-01, 6.999452e-01, 6.999587e-01, 6.999723e-01,
    6.999858e-01, 6.999993e-01, 7.000129e-01, 7.000265e-01, 7.000400e-01, 7.000536e-01,
    7.000671e-01, 7.000806e-01, 7.000942e-01, 7.001078e-01, 7.001213e-01, 7.001349e-01,
    7.001484e-01, 7.001620e-01, 7.001755e-01, 7.001891e-01, 7.002026e-01, 7.002162e-01,
    7.002297e-01, 7.002433e-01, 7.002568e-01, 7.002704e-01, 7.002839e-01, 7.002975e-01,
    7.003110e-01, 7.003246e-01, 7.003381e-01, 7.003517e-01, 7.003652e-01, 7.003788e-01,
    7.003923e-01, 7.004058e-01, 7.004194e-01, 7.004329e-01, 7.004465e-01, 7.004601e-01,
    7.004736e-01, 7.004871e-01, 7.005007e-01, 7.005143e-01, 7.005278e-01, 7.005413e-01,
    7.005548e-01, 7.005684e-01, 7.005820e-01, 7.005955e-01, 7.006090e-01, 7.006226e-01,
    7.006361e-01, 7.006497e-01, 7.006632e-01, 7.006767e-01, 7.006903e-01, 7.007039e-01,
    7.007174e-01, 7.007309e-01, 7.007445e-01, 7.007580e-01, 7.007716e-01, 7.007851e-01,
    7.007986e-01, 7.008122e-01, 7.008258e-01, 7.008393e-01, 7.008528e-01, 7.008663e-01,
    7.008799e-01, 7.008935e-01, 7.009070e-01, 7.009205e-01, 7.009341e-01, 7.009476e-01,
    7.009612e-01, 7.009747e-01, 7.009882e-01, 7.010018e-01, 7.010154e-01, 7.010289e-01,
    7.010424e-01, 7.010559e-01, 7.010695e-01, 7.010831e-01, 7.010966e-01, 7.011101e-01,
    7.011237e-01, 7.011372e-01, 7.011507e-01, 7.011643e-01, 7.011778e-01, 7.011914e-01,
    7.012049e-01, 7.012184e-01, 7.012320e-01, 7.012455e-01, 7.012591e-01, 7.012726e-01,
    7.012862e-01, 7.012997e-01, 7.013132e-01, 7.013268e-01, 7.013403e-01, 7.013538e-01,
    7.013674e-01, 7.013809e-01, 7.013945e-01, 7.014080e-01, 7.014215e-01, 7.014351e-01,
    7.014486e-01, 7.014621e-01, 7.014757e-01, 7.014893e-01, 7.015027e-01, 7.015163e-01,
    7.015298e-01, 7.015434e-01, 7.015569e-01, 7.015705e-01, 7.015840e-01, 7.015975e-01,
    7.016110e-01, 7.016246e-01, 7.016382e-01, 7.016517e-01, 7.016652e-01, 7.016787e-01,
    7.016923e-01, 7.017058e-01, 7.017193e-01, 7.017329e-01, 7.017464e-01, 7.017599e-01,
    7.017735e-01, 7.017871e-01, 7.018005e-01, 7.018141e-01, 7.018276e-01, 7.018412e-01,
    7.018546e-01, 7.018682e-01, 7.018818e-01, 7.018953e-01, 7.019088e-01, 7.019224e-01,
    7.019359e-01, 7.019494e-01, 7.019629e-01, 7.019765e-01, 7.019900e-01, 7.020035e-01,
    7.020171e-01, 7.020306e-01, 7.020441e-01, 7.020577e-01, 7.020712e-01, 7.020847e-01,
    7.020983e-01, 7.021118e-01, 7.021253e-01, 7.021388e-01, 7.021524e-01, 7.021659e-01,
    7.021794e-01, 7.021930e-01, 7.022065e-01, 7.022200e-01, 7.022336e-01, 7.022471e-01,
    7.022606e-01, 7.022741e-01, 7.022877e-01, 7.023012e-01, 7.023147e-01, 7.023283e-01,
    7.023418e-01, 7.023553e-01, 7.023689e-01, 7.023824e-01, 7.023959e-01, 7.024094e-01,
    7.024230e-01, 7.024365e-01, 7.024500e-01, 7.024636e-01, 7.024771e-01, 7.024906e-01,
    7.025042e-01, 7.025176e-01, 7.025312e-01, 7.025447e-01, 7.025582e-01, 7.025718e-01,
    7.025853e-01, 7.025988e-01, 7.026124e-01, 7.026259e-01, 7.026394e-01, 7.026530e-01,
    7.026665e-01, 7.026800e-01, 7.026935e-01, 7.027071e-01, 7.027205e-01, 7.027341e-01,
    7.027476e-01, 7.027611e-01, 7.027747e-01, 7.027882e-01, 7.028017e-01, 7.028152e-01,
    7.028288e-01, 7.028423e-01, 7.028558e-01, 7.028694e-01, 7.028829e-01, 7.028964e-01,
    7.029099e-01, 7.029235e-01, 7.029369e-01, 7.029505e-01, 7.029640e-01, 7.029775e-01,
    7.029910e-01, 7.030046e-01, 7.030181e-01, 7.030316e-01, 7.030452e-01, 7.030587e-01,
    7.030722e-01, 7.030857e-01, 7.030993e-01, 7.031128e-01, 7.031263e-01, 7.031398e-01,
    7.031534e-01, 7.031668e-01, 7.031804e-01, 7.031939e-01, 7.032074e-01, 7.032210e-01,
    7.032344e-01, 7.032480e-01, 7.032615e-01, 7.032750e-01, 7.032885e-01, 7.033021e-01,
    7.033156e-01, 7.033291e-01, 7.033426e-01, 7.033561e-01, 7.033697e-01, 7.033831e-01,
    7.033967e-01, 7.034102e-01, 7.034237e-01, 7.034373e-01, 7.034507e-01, 7.034643e-01,
    7.034778e-01, 7.034913e-01, 7.035049e-01, 7.035184e-01, 7.035319e-01, 7.035454e-01,
    7.035589e-01, 7.035725e-01, 7.035860e-01, 7.035995e-01, 7.036130e-01, 7.036265e-01,
    7.036400e-01, 7.036535e-01, 7.036670e-01, 7.036806e-01, 7.036941e-01, 7.037076e-01,
    7.037211e-01, 7.037346e-01, 7.037482e-01, 7.037616e-01, 7.037752e-01, 7.037887e-01,
    7.038022e-01, 7.038158e-01, 7.038292e-01, 7.038428e-01, 7.038563e-01, 7.038698e-01,
    7.038833e-01, 7.038968e-01, 7.039104e-01, 7.039238e-01, 7.039374e-01, 7.039509e-01,
    7.039644e-01, 7.039779e-01, 7.039914e-01, 7.040049e-01, 7.040185e-01, 7.040319e-01,
    7.040455e-01, 7.040589e-01, 7.040725e-01, 7.040860e-01, 7.040995e-01, 7.041131e-01,
    7.041265e-01, 7.041401e-01, 7.041535e-01, 7.041671e-01, 7.041806e-01, 7.041941e-01,
    7.042076e-01, 7.042211e-01, 7.042347e-01, 7.042481e-01, 7.042617e-01, 7.042752e-01,
    7.042887e-01, 7.043022e-01, 7.043157e-01, 7.043293e-01, 7.043427e-01, 7.043563e-01,
    7.043697e-01, 7.043833e-01, 7.043968e-01, 7.044103e-01, 7.044238e-01, 7.044373e-01,
    7.044508e-01, 7.044643e-01, 7.044778e-01, 7.044913e-01, 7.045048e-01, 7.045183e-01,
    7.045318e-01, 7.045454e-01, 7.045588e-01, 7.045724e-01, 7.045859e-01, 7.045994e-01,
    7.046129e-01, 7.046264e-01, 7.046399e-01, 7.046534e-01, 7.046669e-01, 7.046804e-01,
    7.046940e-01, 7.047074e-01, 7.047210e-01, 7.047344e-01, 7.047480e-01, 7.047614e-01,
    7.047750e-01, 7.047885e-01, 7.048020e-01, 7.048155e-01, 7.048290e-01, 7.048425e-01,
    7.048560e-01, 7.048695e-01, 7.048830e-01, 7.048966e-01, 7.049100e-01, 7.049236e-01,
    7.049370e-01, 7.049506e-01, 7.049640e-01, 7.049776e-01, 7.049910e-01, 7.050046e-01,
    7.050180e-01, 7.050316e-01, 7.050451e-01, 7.050586e-01, 7.050721e-01, 7.050856e-01,
    7.050991e-01, 7.051126e-01, 7.051261e-01, 7.051396e-01, 7.051531e-01, 7.051666e-01,
    7.051801e-01, 7.051936e-01, 7.052071e-01, 7.052206e-01, 7.052341e-01, 7.052476e-01,
    7.052611e-01, 7.052746e-01, 7.052881e-01, 7.053016e-01, 7.053151e-01, 7.053286e-01,
    7.053421e-01, 7.053556e-01, 7.053691e-01, 7.053826e-01, 7.053961e-01, 7.054096e-01,
    7.054231e-01, 7.054366e-01, 7.054501e-01, 7.054636e-01, 7.054771e-01, 7.054906e-01,
    7.055041e-01, 7.055176e-01, 7.055311e-01, 7.055447e-01, 7.055581e-01, 7.055717e-01,
    7.055851e-01, 7.055987e-01, 7.056121e-01, 7.056257e-01, 7.056391e-01, 7.056527e-01,
    7.056661e-01, 7.056797e-01, 7.056931e-01, 7.057067e-01, 7.057201e-01, 7.057336e-01,
    7.057471e-01, 7.057606e-01, 7.057741e-01, 7.057876e-01, 7.058011e-01, 7.058146e-01,
    7.058281e-01, 7.058416e-01, 7.058551e-01, 7.058686e-01, 7.058821e-01, 7.058955e-01,
    7.059091e-01, 7.059225e-01, 7.059361e-01, 7.059495e-01, 7.059631e-01, 7.059765e-01,
    7.059900e-01, 7.060035e-01, 7.060170e-01, 7.060305e-01, 7.060440e-01, 7.060575e-01,
    7.060710e-01, 7.060845e-01, 7.060980e-01, 7.061115e-01, 7.061250e-01, 7.061385e-01,
    7.061520e-01, 7.061654e-01, 7.061790e-01, 7.061924e-01, 7.062060e-01, 7.062194e-01,
    7.062330e-01, 7.062464e-01, 7.062599e-01, 7.062734e-01, 7.062869e-01, 7.063004e-01,
    7.063138e-01, 7.063274e-01, 7.063408e-01, 7.063544e-01, 7.063679e-01, 7.063813e-01,
    7.063949e-01, 7.064083e-01, 7.064219e-01, 7.064353e-01, 7.064488e-01, 7.064623e-01,
    7.064758e-01, 7.064893e-01, 7.065027e-01, 7.065163e-01, 7.065297e-01, 7.065433e-01,
    7.065567e-01, 7.065702e-01, 7.065837e-01, 7.065971e-01, 7.066107e-01, 7.066242e-01,
    7.066377e-01, 7.066512e-01, 7.066646e-01, 7.066782e-01, 7.066916e-01, 7.067051e-01,
    7.067186e-01, 7.067321e-01, 7.067456e-01, 7.067590e-01, 7.067726e-01, 7.067860e-01,
    7.067995e-01, 7.068130e-01, 7.068265e-01, 7.068400e-01, 7.068534e-01, 7.068670e-01,
    7.068805e-01, 7.068939e-01, 7.069075e-01, 7.069209e-01, 7.069344e-01, 7.069479e-01,
    7.069613e-01, 7.069749e-01, 7.069883e-01, 7.070018e-01, 7.070153e-01, 7.070287e-01,
    7.070423e-01, 7.070557e-01, 7.070692e-01, 7.070827e-01, 7.070962e-01, 7.071097e-01,
    7.071232e-01, 7.071367e-01, 7.071502e-01, 7.071636e-01, 7.071771e-01, 7.071906e-01,
    7.072041e-01, 7.072176e-01, 7.072310e-01, 7.072445e-01, 7.072580e-01, 7.072715e-01,
    7.072850e-01, 7.072985e-01, 7.073119e-01, 7.073255e-01, 7.073389e-01, 7.073524e-01,
    7.073659e-01, 7.073793e-01, 7.073929e-01, 7.074063e-01, 7.074198e-01, 7.074333e-01,
    7.074468e-01, 7.074603e-01, 7.074737e-01, 7.074872e-01, 7.075007e-01, 7.075142e-01,
    7.075276e-01, 7.075412e-01, 7.075546e-01, 7.075681e-01, 7.075816e-01, 7.075951e-01,
    7.076085e-01, 7.076220e-01, 7.076355e-01, 7.076490e-01, 7.076624e-01, 7.076759e-01,
    7.076894e-01, 7.077029e-01, 7.077163e-01, 7.077298e-01, 7.077433e-01, 7.077568e-01,
    7.077703e-01, 7.077838e-01, 7.077972e-01, 7.078107e-01, 7.078242e-01, 7.078377e-01,
    7.078511e-01, 7.078646e-01, 7.078781e-01, 7.078916e-01, 7.079051e-01, 7.079185e-01,
    7.079320e-01, 7.079455e-01, 7.079590e-01, 7.079724e-01, 7.079859e-01, 7.079994e-01,
    7.080128e-01, 7.080263e-01, 7.080398e-01, 7.080533e-01, 7.080668e-01, 7.080802e-01,
    7.080937e-01, 7.081072e-01, 7.081207e-01, 7.081341e-01, 7.081476e-01, 7.081611e-01,
    7.081745e-01, 7.081881e-01, 7.082015e-01, 7.082150e-01, 7.082285e-01, 7.082419e-01,
    7.082554e-01, 7.082689e-01, 7.082824e-01, 7.082958e-01, 7.083093e-01, 7.083228e-01,
    7.083362e-01, 7.083497e-01, 7.083632e-01, 7.083766e-01, 7.083901e-01, 7.084036e-01,
    7.084171e-01, 7.084305e-01, 7.084441e-01, 7.084575e-01, 7.084709e-01, 7.084845e-01,
    7.084979e-01, 7.085114e-01, 7.085249e-01, 7.085384e-01, 7.085518e-01, 7.085653e-01,
    7.085788e-01, 7.085922e-01, 7.086056e-01, 7.086192e-01, 7.086326e-01, 7.086461e-01,
    7.086596e-01, 7.086731e-01, 7.086865e-01, 7.086999e-01, 7.087135e-01, 7.087269e-01,
    7.087404e-01, 7.087539e-01, 7.087674e-01, 7.087808e-01, 7.087942e-01, 7.088078e-01,
    7.088212e-01, 7.088346e-01, 7.088481e-01, 7.088616e-01, 7.088751e-01, 7.088885e-01,
    7.089020e-01, 7.089155e-01, 7.089289e-01, 7.089424e-01, 7.089559e-01, 7.089694e-01,
    7.089828e-01, 7.089963e-01, 7.090098e-01, 7.090232e-01, 7.090367e-01, 7.090502e-01,
    7.090636e-01, 7.090771e-01, 7.090905e-01, 7.091040e-01, 7.091175e-01, 7.091309e-01,
    7.091444e-01, 7.091579e-01, 7.091713e-01, 7.091848e-01, 7.091983e-01, 7.092117e-01,
    7.092252e-01, 7.092386e-01, 7.092521e-01, 7.092656e-01, 7.092791e-01, 7.092925e-01,
    7.093060e-01, 7.093194e-01, 7.093329e-01, 7.093464e-01, 7.093599e-01, 7.093733e-01,
    7.093868e-01, 7.094002e-01, 7.094137e-01, 7.094271e-01, 7.094406e-01, 7.094541e-01,
    7.094675e-01, 7.094810e-01, 7.094945e-01, 7.095079e-01, 7.095214e-01, 7.095348e-01,
    7.095483e-01, 7.095618e-01, 7.095752e-01, 7.095887e-01, 7.096022e-01, 7.096156e-01,
    7.096291e-01, 7.096425e-01, 7.096560e-01, 7.096695e-01, 7.096829e-01, 7.096964e-01,
    7.097098e-01, 7.097233e-01, 7.097368e-01, 7.097502e-01, 7.097636e-01, 7.097771e-01,
    7.097906e-01, 7.098041e-01, 7.098175e-01, 7.098310e-01, 7.098445e-01, 7.098579e-01,
    7.098714e-01, 7.098848e-01, 7.098983e-01, 7.099118e-01, 7.099252e-01, 7.099386e-01,
    7.099521e-01, 7.099656e-01, 7.099791e-01, 7.099925e-01, 7.100059e-01, 7.100194e-01,
    7.100329e-01, 7.100464e-01, 7.100598e-01, 7.100732e-01, 7.100867e-01, 7.101002e-01,
    7.101136e-01, 7.101271e-01, 7.101405e-01, 7.101539e-01, 7.101674e-01, 7.101809e-01,
    7.101943e-01, 7.102078e-01, 7.102212e-01, 7.102347e-01, 7.102482e-01, 7.102616e-01,
    7.102751e-01, 7.102885e-01, 7.103020e-01, 7.103154e-01, 7.103289e-01, 7.103423e-01,
    7.103558e-01, 7.103692e-01, 7.103827e-01, 7.103961e-01, 7.104096e-01, 7.104231e-01,
    7.104365e-01, 7.104500e-01, 7.104634e-01, 7.104769e-01, 7.104903e-01, 7.105038e-01,
    7.105172e-01, 7.105307e-01, 7.105441e-01, 7.105576e-01, 7.105711e-01, 7.105845e-01,
    7.105979e-01, 7.106114e-01, 7.106248e-01, 7.106383e-01, 7.106518e-01, 7.106652e-01,
    7.106786e-01, 7.106921e-01, 7.107055e-01, 7.107190e-01, 7.107325e-01, 7.107459e-01,
    7.107593e-01, 7.107728e-01, 7.107862e-01, 7.107997e-01, 7.108132e-01, 7.108266e-01,
    7.108400e-01, 7.108535e-01, 7.108669e-01, 7.108804e-01, 7.108939e-01, 7.109073e-01,
    7.109208e-01, 7.109342e-01, 7.109476e-01, 7.109611e-01, 7.109746e-01, 7.109880e-01,
    7.110015e-01, 7.110149e-01, 7.110283e-01, 7.110418e-01, 7.110552e-01, 7.110687e-01,
    7.110822e-01, 7.110956e-01, 7.111090e-01, 7.111225e-01, 7.111359e-01, 7.111494e-01,
    7.111628e-01, 7.111763e-01, 7.111897e-01, 7.112032e-01, 7.112166e-01, 7.112300e-01,
    7.112435e-01, 7.112570e-01, 7.112704e-01, 7.112838e-01, 7.112973e-01, 7.113107e-01,
    7.113242e-01, 7.113376e-01, 7.113511e-01, 7.113645e-01, 7.113779e-01, 7.113914e-01,
    7.114048e-01, 7.114183e-01, 7.114317e-01, 7.114452e-01, 7.114586e-01, 7.114720e-01,
    7.114854e-01, 7.114989e-01, 7.115124e-01, 7.115258e-01, 7.115393e-01, 7.115527e-01,
    7.115662e-01, 7.115796e-01, 7.115930e-01, 7.116064e-01, 7.116199e-01, 7.116334e-01,
    7.116468e-01, 7.116603e-01, 7.116737e-01, 7.116871e-01, 7.117006e-01, 7.117140e-01,
    7.117274e-01, 7.117409e-01, 7.117543e-01, 7.117678e-01, 7.117813e-01, 7.117947e-01,
    7.118081e-01, 7.118216e-01, 7.118350e-01, 7.118484e-01, 7.118618e-01, 7.118753e-01,
    7.118887e-01, 7.119022e-01, 7.119157e-01, 7.119291e-01, 7.119425e-01, 7.119559e-01,
    7.119694e-01, 7.119828e-01, 7.119963e-01, 7.120097e-01, 7.120231e-01, 7.120366e-01,
    7.120500e-01, 7.120635e-01, 7.120769e-01, 7.120903e-01, 7.121037e-01, 7.121172e-01,
    7.121306e-01, 7.121441e-01, 7.121575e-01, 7.121710e-01, 7.121844e-01, 7.121978e-01,
    7.122113e-01, 7.122247e-01, 7.122381e-01, 7.122515e-01, 7.122650e-01, 7.122784e-01,
    7.122919e-01, 7.123053e-01, 7.123188e-01, 7.123322e-01, 7.123457e-01, 7.123591e-01,
    7.123725e-01, 7.123860e-01, 7.123994e-01, 7.124128e-01, 7.124262e-01, 7.124397e-01,
    7.124531e-01, 7.124665e-01, 7.124799e-01, 7.124934e-01, 7.125068e-01, 7.125203e-01,
    7.125337e-01, 7.125472e-01, 7.125606e-01, 7.125740e-01, 7.125875e-01, 7.126009e-01,
    7.126143e-01, 7.126278e-01, 7.126412e-01, 7.126546e-01, 7.126680e-01, 7.126815e-01,
    7.126949e-01, 7.127084e-01, 7.127218e-01, 7.127352e-01, 7.127486e-01, 7.127621e-01,
    7.127755e-01, 7.127889e-01, 7.128024e-01, 7.128158e-01, 7.128292e-01, 7.128427e-01,
    7.128561e-01, 7.128695e-01, 7.128829e-01, 7.128964e-01, 7.129098e-01, 7.129232e-01,
    7.129366e-01, 7.129501e-01, 7.129635e-01, 7.129769e-01, 7.129904e-01, 7.130038e-01,
    7.130172e-01, 7.130307e-01, 7.130441e-01, 7.130575e-01, 7.130710e-01, 7.130844e-01,
    7.130978e-01, 7.131113e-01, 7.131247e-01, 7.131381e-01, 7.131516e-01, 7.131650e-01,
    7.131784e-01, 7.131919e-01, 7.132053e-01, 7.132187e-01, 7.132321e-01, 7.132456e-01,
    7.132590e-01, 7.132724e-01, 7.132858e-01, 7.132993e-01, 7.133127e-01, 7.133261e-01,
    7.133395e-01, 7.133529e-01, 7.133664e-01, 7.133798e-01, 7.133932e-01, 7.134066e-01,
    7.134201e-01, 7.134335e-01, 7.134469e-01, 7.134603e-01, 7.134737e-01, 7.134872e-01,
    7.135006e-01, 7.135140e-01, 7.135274e-01, 7.135409e-01, 7.135543e-01, 7.135677e-01,
    7.135811e-01, 7.135946e-01, 7.136080e-01, 7.136214e-01, 7.136348e-01, 7.136483e-01,
    7.136617e-01, 7.136751e-01, 7.136886e-01, 7.137020e-01, 7.137154e-01, 7.137288e-01,
    7.137423e-01, 7.137557e-01, 7.137691e-01, 7.137825e-01, 7.137960e-01, 7.138094e-01,
    7.138228e-01, 7.138362e-01, 7.138496e-01, 7.138631e-01, 7.138765e-01, 7.138899e-01,
    7.139033e-01, 7.139168e-01, 7.139302e-01, 7.139436e-01, 7.139570e-01, 7.139704e-01,
    7.139838e-01, 7.139973e-01, 7.140107e-01, 7.140241e-01, 7.140375e-01, 7.140509e-01,
    7.140644e-01, 7.140778e-01, 7.140912e-01, 7.141047e-01, 7.141181e-01, 7.141315e-01,
    7.141449e-01, 7.141583e-01, 7.141717e-01, 7.141851e-01, 7.141985e-01, 7.142119e-01,
    7.142254e-01, 7.142388e-01, 7.142522e-01, 7.142656e-01, 7.142791e-01, 7.142925e-01,
    7.143059e-01, 7.143193e-01, 7.143328e-01, 7.143462e-01, 7.143596e-01, 7.143730e-01,
    7.143864e-01, 7.143998e-01, 7.144132e-01, 7.144266e-01, 7.144400e-01, 7.144535e-01,
    7.144669e-01, 7.144803e-01, 7.144937e-01, 7.145071e-01, 7.145205e-01, 7.145339e-01,
    7.145474e-01, 7.145608e-01, 7.145742e-01, 7.145876e-01, 7.146010e-01, 7.146145e-01,
    7.146279e-01, 7.146413e-01, 7.146547e-01, 7.146681e-01, 7.146815e-01, 7.146949e-01,
    7.147083e-01, 7.147217e-01, 7.147352e-01, 7.147486e-01, 7.147620e-01, 7.147754e-01,
    7.147889e-01, 7.148023e-01, 7.148157e-01, 7.148291e-01, 7.148425e-01, 7.148559e-01,
    7.148693e-01, 7.148827e-01, 7.148961e-01, 7.149096e-01, 7.149230e-01, 7.149364e-01,
    7.149498e-01, 7.149632e-01, 7.149766e-01, 7.149900e-01, 7.150034e-01, 7.150168e-01,
    7.150303e-01, 7.150437e-01, 7.150571e-01, 7.150705e-01, 7.150839e-01, 7.150973e-01,
    7.151107e-01, 7.151241e-01, 7.151375e-01, 7.151510e-01, 7.151644e-01, 7.151778e-01,
    7.151912e-01, 7.152046e-01, 7.152179e-01, 7.152314e-01, 7.152448e-01, 7.152582e-01,
    7.152717e-01, 7.152851e-01, 7.152985e-01, 7.153118e-01, 7.153252e-01, 7.153386e-01,
    7.153521e-01, 7.153655e-01, 7.153789e-01, 7.153923e-01, 7.154057e-01, 7.154191e-01,
    7.154325e-01, 7.154459e-01, 7.154593e-01, 7.154727e-01, 7.154861e-01, 7.154995e-01,
    7.155130e-01, 7.155264e-01, 7.155398e-01, 7.155532e-01, 7.155666e-01, 7.155800e-01,
    7.155933e-01, 7.156068e-01, 7.156202e-01, 7.156336e-01, 7.156470e-01, 7.156604e-01,
    7.156738e-01, 7.156872e-01, 7.157006e-01, 7.157140e-01, 7.157274e-01, 7.157409e-01,
    7.157543e-01, 7.157676e-01, 7.157810e-01, 7.157944e-01, 7.158079e-01, 7.158213e-01,
    7.158347e-01, 7.158481e-01, 7.158615e-01, 7.158749e-01, 7.158883e-01, 7.159017e-01,
    7.159151e-01, 7.159285e-01, 7.159419e-01, 7.159553e-01, 7.159687e-01, 7.159821e-01,
    7.159955e-01, 7.160089e-01, 7.160223e-01, 7.160357e-01, 7.160491e-01, 7.160625e-01,
    7.160759e-01, 7.160893e-01, 7.161027e-01, 7.161161e-01, 7.161295e-01, 7.161429e-01,
    7.161563e-01, 7.161697e-01, 7.161831e-01, 7.161965e-01, 7.162099e-01, 7.162233e-01,
    7.162367e-01, 7.162501e-01, 7.162635e-01, 7.162769e-01, 7.162903e-01, 7.163037e-01,
    7.163171e-01, 7.163305e-01, 7.163439e-01, 7.163573e-01, 7.163707e-01, 7.163841e-01,
    7.163975e-01, 7.164109e-01, 7.164243e-01, 7.164377e-01, 7.164511e-01, 7.164645e-01,
    7.164779e-01, 7.164913e-01, 7.165046e-01, 7.165180e-01, 7.165315e-01, 7.165449e-01,
    7.165582e-01, 7.165716e-01, 7.165850e-01, 7.165985e-01, 7.166119e-01, 7.166252e-01,
    7.166386e-01, 7.166520e-01, 7.166654e-01, 7.166789e-01, 7.166922e-01, 7.167056e-01,
    7.167190e-01, 7.167324e-01, 7.167458e-01, 7.167592e-01, 7.167726e-01, 7.167860e-01,
    7.167994e-01, 7.168128e-01, 7.168261e-01, 7.168396e-01, 7.168529e-01, 7.168663e-01,
    7.168797e-01, 7.168931e-01, 7.169065e-01, 7.169199e-01, 7.169333e-01, 7.169467e-01,
    7.169601e-01, 7.169735e-01, 7.169868e-01, 7.170002e-01, 7.170137e-01, 7.170271e-01,
    7.170404e-01, 7.170538e-01, 7.170672e-01, 7.170807e-01, 7.170940e-01, 7.171074e-01,
    7.171208e-01, 7.171342e-01, 7.171476e-01, 7.171609e-01, 7.171744e-01, 7.171877e-01,
    7.172012e-01, 7.172145e-01, 7.172279e-01, 7.172413e-01, 7.172547e-01, 7.172681e-01,
    7.172815e-01, 7.172949e-01, 7.173082e-01, 7.173216e-01, 7.173350e-01, 7.173484e-01,
    7.173618e-01, 7.173752e-01, 7.173886e-01, 7.174020e-01, 7.174153e-01, 7.174287e-01,
    7.174422e-01, 7.174556e-01, 7.174689e-01, 7.174823e-01, 7.174957e-01, 7.175091e-01,
    7.175224e-01, 7.175359e-01, 7.175493e-01, 7.175627e-01, 7.175760e-01, 7.175894e-01,
    7.176028e-01, 7.176162e-01, 7.176296e-01, 7.176430e-01, 7.176563e-01, 7.176697e-01,
    7.176831e-01, 7.176965e-01, 7.177099e-01, 7.177233e-01, 7.177367e-01, 7.177500e-01,
    7.177634e-01, 7.177768e-01, 7.177902e-01, 7.178036e-01, 7.178169e-01, 7.178304e-01,
    7.178437e-01, 7.178571e-01, 7.178705e-01, 7.178839e-01, 7.178973e-01, 7.179106e-01,
    7.179241e-01, 7.179375e-01, 7.179508e-01, 7.179642e-01, 7.179776e-01, 7.179910e-01,
    7.180043e-01, 7.180177e-01, 7.180311e-01, 7.180445e-01, 7.180579e-01, 7.180712e-01,
    7.180846e-01, 7.180980e-01, 7.181114e-01, 7.181248e-01, 7.181382e-01, 7.181516e-01,
    7.181649e-01, 7.181783e-01, 7.181917e-01, 7.182051e-01, 7.182184e-01, 7.182319e-01,
    7.182452e-01, 7.182586e-01, 7.182720e-01, 7.182854e-01, 7.182987e-01, 7.183121e-01,
    7.183255e-01, 7.183389e-01, 7.183523e-01, 7.183657e-01, 7.183790e-01, 7.183924e-01,
    7.184058e-01, 7.184192e-01, 7.184325e-01, 7.184459e-01, 7.184593e-01, 7.184727e-01,
    7.184861e-01, 7.184994e-01, 7.185128e-01, 7.185262e-01, 7.185395e-01, 7.185529e-01,
    7.185663e-01, 7.185797e-01, 7.185931e-01, 7.186065e-01, 7.186198e-01, 7.186332e-01,
    7.186466e-01, 7.186599e-01, 7.186733e-01, 7.186868e-01, 7.187001e-01, 7.187135e-01,
    7.187269e-01, 7.187402e-01, 7.187536e-01, 7.187670e-01, 7.187803e-01, 7.187937e-01,
    7.188071e-01, 7.188205e-01, 7.188339e-01, 7.188472e-01, 7.188606e-01, 7.188740e-01,
    7.188873e-01, 7.189007e-01, 7.189141e-01, 7.189274e-01, 7.189409e-01, 7.189542e-01,
    7.189676e-01, 7.189810e-01, 7.189944e-01, 7.190077e-01, 7.190211e-01, 7.190345e-01,
    7.190478e-01, 7.190612e-01, 7.190746e-01, 7.190880e-01, 7.191013e-01, 7.191147e-01,
    7.191281e-01, 7.191415e-01, 7.191548e-01, 7.191682e-01, 7.191816e-01, 7.191949e-01,
    7.192083e-01, 7.192217e-01, 7.192351e-01, 7.192484e-01, 7.192618e-01, 7.192752e-01,
    7.192885e-01, 7.193019e-01, 7.193153e-01, 7.193286e-01, 7.193421e-01, 7.193554e-01,
    7.193688e-01, 7.193822e-01, 7.193955e-01, 7.194089e-01, 7.194223e-01, 7.194356e-01,
    7.194490e-01, 7.194624e-01, 7.194757e-01, 7.194891e-01, 7.195024e-01, 7.195158e-01,
    7.195292e-01, 7.195426e-01, 7.195559e-01, 7.195693e-01, 7.195827e-01, 7.195960e-01,
    7.196094e-01, 7.196228e-01, 7.196361e-01, 7.196496e-01, 7.196628e-01, 7.196763e-01,
    7.196896e-01, 7.197030e-01, 7.197164e-01, 7.197297e-01, 7.197431e-01, 7.197565e-01,
    7.197698e-01, 7.197832e-01, 7.197965e-01, 7.198099e-01, 7.198233e-01, 7.198367e-01,
    7.198500e-01, 7.198634e-01, 7.198768e-01, 7.198901e-01, 7.199035e-01, 7.199168e-01,
    7.199302e-01, 7.199436e-01, 7.199569e-01, 7.199703e-01, 7.199836e-01, 7.199970e-01,
    7.200104e-01, 7.200238e-01, 7.200372e-01, 7.200505e-01, 7.200639e-01, 7.200772e-01,
    7.200906e-01, 7.201040e-01, 7.201173e-01, 7.201307e-01, 7.201440e-01, 7.201574e-01,
    7.201708e-01, 7.201841e-01, 7.201975e-01, 7.202109e-01, 7.202242e-01, 7.202376e-01,
    7.202510e-01, 7.202643e-01, 7.202777e-01, 7.202910e-01, 7.203044e-01, 7.203177e-01,
    7.203311e-01, 7.203445e-01, 7.203578e-01, 7.203712e-01, 7.203845e-01, 7.203979e-01,
    7.204113e-01, 7.204246e-01, 7.204380e-01, 7.204514e-01, 7.204647e-01, 7.204781e-01,
    7.204914e-01, 7.205048e-01, 7.205182e-01, 7.205315e-01, 7.205449e-01, 7.205582e-01,
    7.205716e-01, 7.205849e-01, 7.205983e-01, 7.206117e-01, 7.206250e-01, 7.206384e-01,
    7.206517e-01, 7.206651e-01, 7.206784e-01, 7.206919e-01, 7.207052e-01, 7.207186e-01,
    7.207319e-01, 7.207452e-01, 7.207586e-01, 7.207720e-01, 7.207853e-01, 7.207987e-01,
    7.208120e-01, 7.208254e-01, 7.208387e-01, 7.208521e-01, 7.208654e-01, 7.208788e-01,
    7.208922e-01, 7.209055e-01, 7.209189e-01, 7.209322e-01, 7.209456e-01, 7.209589e-01,
    7.209723e-01, 7.209857e-01, 7.209991e-01, 7.210124e-01, 7.210258e-01, 7.210391e-01,
    7.210525e-01, 7.210658e-01, 7.210791e-01, 7.210925e-01, 7.211059e-01, 7.211192e-01,
    7.211326e-01, 7.211459e-01, 7.211593e-01, 7.211726e-01, 7.211860e-01, 7.211993e-01,
    7.212127e-01, 7.212260e-01, 7.212394e-01, 7.212527e-01, 7.212662e-01, 7.212794e-01,
    7.212929e-01, 7.213061e-01, 7.213196e-01, 7.213328e-01, 7.213462e-01, 7.213596e-01,
    7.213729e-01, 7.213863e-01, 7.213996e-01, 7.214130e-01, 7.214264e-01, 7.214397e-01,
    7.214530e-01, 7.214664e-01, 7.214798e-01, 7.214931e-01, 7.215064e-01, 7.215198e-01,
    7.215332e-01, 7.215465e-01, 7.215598e-01, 7.215732e-01, 7.215866e-01, 7.215999e-01,
    7.216132e-01, 7.216266e-01, 7.216400e-01, 7.216533e-01, 7.216666e-01, 7.216800e-01,
    7.216933e-01, 7.217067e-01, 7.217200e-01, 7.217334e-01, 7.217467e-01, 7.217601e-01,
    7.217734e-01, 7.217867e-01, 7.218001e-01, 7.218135e-01, 7.218269e-01, 7.218401e-01,
    7.218535e-01, 7.218668e-01, 7.218803e-01, 7.218935e-01, 7.219069e-01, 7.219202e-01,
    7.219335e-01, 7.219470e-01, 7.219603e-01, 7.219736e-01, 7.219869e-01, 7.220004e-01,
    7.220137e-01, 7.220270e-01, 7.220404e-01, 7.220537e-01, 7.220671e-01, 7.220804e-01,
    7.220938e-01, 7.221071e-01, 7.221204e-01, 7.221338e-01, 7.221472e-01, 7.221605e-01,
    7.221738e-01, 7.221872e-01, 7.222005e-01, 7.222139e-01, 7.222272e-01, 7.222406e-01,
    7.222539e-01, 7.222672e-01, 7.222805e-01, 7.222939e-01, 7.223073e-01, 7.223206e-01,
    7.223339e-01, 7.223473e-01, 7.223606e-01, 7.223740e-01, 7.223873e-01, 7.224007e-01,
    7.224140e-01, 7.224273e-01, 7.224407e-01, 7.224541e-01, 7.224674e-01, 7.224807e-01,
    7.224941e-01, 7.225074e-01, 7.225207e-01, 7.225340e-01, 7.225474e-01, 7.225608e-01,
    7.225741e-01, 7.225874e-01, 7.226008e-01, 7.226141e-01, 7.226274e-01, 7.226408e-01,
    7.226542e-01, 7.226675e-01, 7.226808e-01, 7.226942e-01, 7.227075e-01, 7.227208e-01,
    7.227342e-01, 7.227476e-01, 7.227609e-01, 7.227742e-01, 7.227875e-01, 7.228009e-01,
    7.228142e-01, 7.228275e-01, 7.228408e-01, 7.228542e-01, 7.228676e-01, 7.228809e-01,
    7.228943e-01, 7.229076e-01, 7.229209e-01, 7.229342e-01, 7.229475e-01, 7.229609e-01,
    7.229742e-01, 7.229877e-01, 7.230009e-01, 7.230143e-01, 7.230276e-01, 7.230409e-01,
    7.230543e-01, 7.230676e-01, 7.230809e-01, 7.230943e-01, 7.231076e-01, 7.231209e-01,
    7.231342e-01, 7.231477e-01, 7.231610e-01, 7.231743e-01, 7.231876e-01, 7.232010e-01,
    7.232143e-01, 7.232276e-01, 7.232410e-01, 7.232543e-01, 7.232676e-01, 7.232810e-01,
    7.232943e-01, 7.233076e-01, 7.233210e-01, 7.233343e-01, 7.233477e-01, 7.233610e-01,
    7.233743e-01, 7.233877e-01, 7.234010e-01, 7.234143e-01, 7.234277e-01, 7.234410e-01,
    7.234543e-01, 7.234676e-01, 7.234809e-01, 7.234943e-01, 7.235076e-01, 7.235209e-01,
    7.235343e-01, 7.235476e-01, 7.235609e-01, 7.235743e-01, 7.235876e-01, 7.236009e-01,
    7.236143e-01, 7.236276e-01, 7.236409e-01, 7.236542e-01, 7.236676e-01, 7.236810e-01,
    7.236943e-01, 7.237076e-01, 7.237210e-01, 7.237343e-01, 7.237476e-01, 7.237610e-01,
    7.237743e-01, 7.237876e-01, 7.238010e-01, 7.238142e-01, 7.238276e-01, 7.238410e-01,
    7.238542e-01, 7.238676e-01, 7.238809e-01, 7.238942e-01, 7.239076e-01, 7.239209e-01,
    7.239342e-01, 7.239475e-01, 7.239609e-01, 7.239742e-01, 7.239875e-01, 7.240009e-01,
    7.240142e-01, 7.240275e-01, 7.240409e-01, 7.240542e-01, 7.240675e-01, 7.240809e-01,
    7.240941e-01, 7.241074e-01, 7.241207e-01, 7.241341e-01, 7.241474e-01, 7.241607e-01,
    7.241741e-01, 7.241874e-01, 7.242007e-01, 7.242140e-01, 7.242274e-01, 7.242407e-01,
    7.242540e-01, 7.242674e-01, 7.242807e-01, 7.242940e-01, 7.243074e-01, 7.243207e-01,
    7.243340e-01, 7.243474e-01, 7.243606e-01, 7.243740e-01, 7.243873e-01, 7.244006e-01,
    7.244140e-01, 7.244272e-01, 7.244405e-01, 7.244539e-01, 7.244672e-01, 7.244805e-01,
    7.244939e-01, 7.245072e-01, 7.245205e-01, 7.245339e-01, 7.245471e-01, 7.245605e-01,
    7.245739e-01, 7.245871e-01, 7.246005e-01, 7.246137e-01, 7.246271e-01, 7.246404e-01,
    7.246537e-01, 7.246670e-01, 7.246804e-01, 7.246937e-01, 7.247070e-01, 7.247204e-01,
    7.247337e-01, 7.247470e-01, 7.247604e-01, 7.247736e-01, 7.247869e-01, 7.248002e-01,
    7.248136e-01, 7.248269e-01, 7.248402e-01, 7.248536e-01, 7.248669e-01, 7.248802e-01,
    7.248936e-01, 7.249068e-01, 7.249201e-01, 7.249334e-01, 7.249468e-01, 7.249601e-01,
    7.249734e-01, 7.249867e-01, 7.250001e-01, 7.250133e-01, 7.250267e-01, 7.250400e-01,
    7.250533e-01, 7.250667e-01, 7.250800e-01, 7.250933e-01, 7.251067e-01, 7.251199e-01,
    7.251332e-01, 7.251465e-01, 7.251599e-01, 7.251732e-01, 7.251865e-01, 7.251998e-01,
    7.252131e-01, 7.252264e-01, 7.252398e-01, 7.252530e-01, 7.252664e-01, 7.252797e-01,
    7.252930e-01, 7.253063e-01, 7.253196e-01, 7.253330e-01, 7.253463e-01, 7.253596e-01,
    7.253730e-01, 7.253862e-01, 7.253995e-01, 7.254128e-01, 7.254262e-01, 7.254395e-01,
    7.254528e-01, 7.254661e-01, 7.254794e-01, 7.254927e-01, 7.255061e-01, 7.255194e-01,
    7.255327e-01, 7.255459e-01, 7.255593e-01, 7.255726e-01, 7.255859e-01, 7.255993e-01,
    7.256126e-01, 7.256259e-01, 7.256392e-01, 7.256525e-01, 7.256658e-01, 7.256792e-01,
    7.256924e-01, 7.257057e-01, 7.257190e-01, 7.257324e-01, 7.257457e-01, 7.257590e-01,
    7.257723e-01, 7.257856e-01, 7.257990e-01, 7.258123e-01, 7.258255e-01, 7.258388e-01,
    7.258522e-01, 7.258655e-01, 7.258788e-01, 7.258921e-01, 7.259054e-01, 7.259187e-01,
    7.259321e-01, 7.259453e-01, 7.259586e-01, 7.259719e-01, 7.259853e-01, 7.259986e-01,
    7.260119e-01, 7.260252e-01, 7.260385e-01, 7.260519e-01, 7.260651e-01, 7.260784e-01,
    7.260917e-01, 7.261051e-01, 7.261183e-01, 7.261316e-01, 7.261450e-01, 7.261583e-01,
    7.261716e-01, 7.261848e-01, 7.261982e-01, 7.262115e-01, 7.262248e-01, 7.262381e-01,
    7.262514e-01, 7.262648e-01, 7.262780e-01, 7.262914e-01, 7.263047e-01, 7.263180e-01,
    7.263312e-01, 7.263446e-01, 7.263579e-01, 7.263712e-01, 7.263845e-01, 7.263978e-01,
    7.264111e-01, 7.264243e-01, 7.264377e-01, 7.264510e-01, 7.264643e-01, 7.264776e-01,
    7.264909e-01, 7.265043e-01, 7.265176e-01, 7.265308e-01, 7.265441e-01, 7.265575e-01,
    7.265707e-01, 7.265840e-01, 7.265974e-01, 7.266107e-01, 7.266240e-01, 7.266373e-01,
    7.266506e-01, 7.266638e-01, 7.266772e-01, 7.266905e-01, 7.267038e-01, 7.267171e-01,
    7.267304e-01, 7.267438e-01, 7.267570e-01, 7.267703e-01, 7.267836e-01, 7.267969e-01,
    7.268102e-01, 7.268235e-01, 7.268368e-01, 7.268501e-01, 7.268634e-01, 7.268767e-01,
    7.268900e-01, 7.269033e-01, 7.269166e-01, 7.269299e-01, 7.269433e-01, 7.269565e-01,
    7.269698e-01, 7.269831e-01, 7.269964e-01, 7.270097e-01, 7.270230e-01, 7.270363e-01,
    7.270496e-01, 7.270629e-01, 7.270762e-01, 7.270895e-01, 7.271028e-01, 7.271160e-01,
    7.271294e-01, 7.271428e-01, 7.271560e-01, 7.271693e-01, 7.271826e-01, 7.271959e-01,
    7.272092e-01, 7.272224e-01, 7.272358e-01, 7.272491e-01, 7.272623e-01, 7.272757e-01,
    7.272890e-01, 7.273023e-01, 7.273155e-01, 7.273289e-01, 7.273421e-01, 7.273555e-01,
    7.273687e-01, 7.273821e-01, 7.273954e-01, 7.274086e-01, 7.274219e-01, 7.274353e-01,
    7.274485e-01, 7.274619e-01, 7.274751e-01, 7.274884e-01, 7.275017e-01, 7.275150e-01,
    7.275283e-01, 7.275416e-01, 7.275549e-01, 7.275682e-01, 7.275814e-01, 7.275948e-01,
    7.276080e-01, 7.276214e-01, 7.276347e-01, 7.276480e-01, 7.276613e-01, 7.276745e-01,
    7.276878e-01, 7.277012e-01, 7.277144e-01, 7.277277e-01, 7.277410e-01, 7.277543e-01,
    7.277676e-01, 7.277809e-01, 7.277942e-01, 7.278075e-01, 7.278208e-01, 7.278340e-01,
    7.278473e-01, 7.278607e-01, 7.278739e-01, 7.278873e-01, 7.279005e-01, 7.279138e-01,
    7.279270e-01, 7.279404e-01, 7.279537e-01, 7.279670e-01, 7.279803e-01, 7.279935e-01,
    7.280068e-01, 7.280201e-01, 7.280334e-01, 7.280467e-01, 7.280600e-01, 7.280734e-01,
    7.280866e-01, 7.280999e-01, 7.281131e-01, 7.281265e-01, 7.281397e-01, 7.281530e-01,
    7.281663e-01, 7.281796e-01, 7.281929e-01, 7.282062e-01, 7.282195e-01, 7.282327e-01,
    7.282461e-01, 7.282593e-01, 7.282727e-01, 7.282859e-01, 7.282992e-01, 7.283125e-01,
    7.283258e-01, 7.283390e-01, 7.283524e-01, 7.283656e-01, 7.283790e-01, 7.283922e-01,
    7.284055e-01, 7.284188e-01, 7.284321e-01, 7.284454e-01, 7.284586e-01, 7.284719e-01,
    7.284852e-01, 7.284985e-01, 7.285118e-01, 7.285250e-01, 7.285384e-01, 7.285516e-01,
    7.285649e-01, 7.285782e-01, 7.285915e-01, 7.286047e-01, 7.286181e-01, 7.286313e-01,
    7.286447e-01, 7.286579e-01, 7.286713e-01, 7.286845e-01, 7.286978e-01, 7.287111e-01,
    7.287244e-01, 7.287376e-01, 7.287509e-01, 7.287642e-01, 7.287775e-01, 7.287908e-01,
    7.288041e-01, 7.288173e-01, 7.288306e-01, 7.288439e-01, 7.288572e-01, 7.288705e-01,
    7.288837e-01, 7.288970e-01, 7.289103e-01, 7.289236e-01, 7.289369e-01, 7.289502e-01,
    7.289634e-01, 7.289767e-01, 7.289900e-01, 7.290033e-01, 7.290165e-01, 7.290298e-01,
    7.290431e-01, 7.290564e-01, 7.290697e-01, 7.290829e-01, 7.290963e-01, 7.291095e-01,
    7.291229e-01, 7.291361e-01, 7.291493e-01, 7.291627e-01, 7.291759e-01, 7.291892e-01,
    7.292025e-01, 7.292158e-01, 7.292290e-01, 7.292423e-01, 7.292556e-01, 7.292688e-01,
    7.292822e-01, 7.292954e-01, 7.293088e-01, 7.293220e-01, 7.293352e-01, 7.293486e-01,
    7.293618e-01, 7.293751e-01, 7.293884e-01, 7.294016e-01, 7.294149e-01, 7.294282e-01,
    7.294415e-01, 7.294548e-01, 7.294680e-01, 7.294813e-01, 7.294946e-01, 7.295079e-01,
    7.295212e-01, 7.295344e-01, 7.295477e-01, 7.295610e-01, 7.295743e-01, 7.295876e-01,
    7.296008e-01, 7.296141e-01, 7.296274e-01, 7.296407e-01, 7.296540e-01, 7.296672e-01,
    7.296805e-01, 7.296938e-01, 7.297070e-01, 7.297203e-01, 7.297336e-01, 7.297469e-01,
    7.297601e-01, 7.297734e-01, 7.297867e-01, 7.297999e-01, 7.298132e-01, 7.298265e-01,
    7.298397e-01, 7.298530e-01, 7.298663e-01, 7.298796e-01, 7.298929e-01, 7.299061e-01,
    7.299194e-01, 7.299327e-01, 7.299460e-01, 7.299592e-01, 7.299725e-01, 7.299858e-01,
    7.299990e-01, 7.300124e-01, 7.300256e-01, 7.300388e-01, 7.300522e-01, 7.300654e-01,
    7.300786e-01, 7.300920e-01, 7.301052e-01, 7.301185e-01, 7.301318e-01, 7.301450e-01,
    7.301583e-01, 7.301716e-01, 7.301849e-01, 7.301981e-01, 7.302114e-01, 7.302247e-01,
    7.302379e-01, 7.302513e-01, 7.302645e-01, 7.302777e-01, 7.302911e-01, 7.303043e-01,
    7.303175e-01, 7.303308e-01, 7.303441e-01, 7.303573e-01, 7.303706e-01, 7.303839e-01,
    7.303972e-01, 7.304104e-01, 7.304237e-01, 7.304370e-01, 7.304502e-01, 7.304634e-01,
    7.304768e-01, 7.304900e-01, 7.305033e-01, 7.305166e-01, 7.305298e-01, 7.305431e-01,
    7.305564e-01, 7.305697e-01, 7.305829e-01, 7.305961e-01, 7.306095e-01, 7.306227e-01,
    7.306359e-01, 7.306492e-01, 7.306625e-01, 7.306758e-01, 7.306890e-01, 7.307023e-01,
    7.307156e-01, 7.307288e-01, 7.307421e-01, 7.307554e-01, 7.307686e-01, 7.307819e-01,
    7.307951e-01, 7.308084e-01, 7.308217e-01, 7.308350e-01, 7.308482e-01, 7.308615e-01,
    7.308748e-01, 7.308880e-01, 7.309012e-01, 7.309146e-01, 7.309278e-01, 7.309411e-01,
    7.309543e-01, 7.309676e-01, 7.309809e-01, 7.309941e-01, 7.310073e-01, 7.310207e-01,
    7.310339e-01, 7.310472e-01, 7.310604e-01, 7.310737e-01, 7.310870e-01, 7.311002e-01,
    7.311135e-01, 7.311267e-01, 7.311400e-01, 7.311533e-01, 7.311665e-01, 7.311798e-01,
    7.311931e-01, 7.312064e-01, 7.312196e-01, 7.312328e-01, 7.312461e-01, 7.312594e-01,
    7.312726e-01, 7.312859e-01, 7.312991e-01, 7.313124e-01, 7.313257e-01, 7.313389e-01,
    7.313522e-01, 7.313654e-01, 7.313787e-01, 7.313920e-01, 7.314053e-01, 7.314185e-01,
    7.314317e-01, 7.314450e-01, 7.314583e-01, 7.314715e-01, 7.314848e-01, 7.314980e-01,
    7.315112e-01, 7.315245e-01, 7.315378e-01, 7.315511e-01, 7.315643e-01, 7.315776e-01,
    7.315908e-01, 7.316042e-01, 7.316174e-01, 7.316306e-01, 7.316439e-01, 7.316571e-01,
    7.316703e-01, 7.316837e-01, 7.316969e-01, 7.317101e-01, 7.317234e-01, 7.317367e-01,
    7.317499e-01, 7.317631e-01, 7.317765e-01, 7.317897e-01, 7.318029e-01, 7.318162e-01,
    7.318294e-01, 7.318427e-01, 7.318560e-01, 7.318692e-01, 7.318825e-01, 7.318957e-01,
    7.319090e-01, 7.319222e-01, 7.319354e-01, 7.319488e-01, 7.319620e-01, 7.319753e-01,
    7.319885e-01, 7.320018e-01, 7.320150e-01, 7.320282e-01, 7.320415e-01, 7.320548e-01,
    7.320681e-01, 7.320813e-01, 7.320945e-01, 7.321078e-01, 7.321211e-01, 7.321343e-01,
    7.321475e-01, 7.321607e-01, 7.321741e-01, 7.321873e-01, 7.322006e-01, 7.322138e-01,
    7.322270e-01, 7.322403e-01, 7.322536e-01, 7.322668e-01, 7.322800e-01, 7.322934e-01,
    7.323066e-01, 7.323198e-01, 7.323331e-01, 7.323463e-01, 7.323596e-01, 7.323728e-01,
    7.323861e-01, 7.323993e-01, 7.324125e-01, 7.324258e-01, 7.324391e-01, 7.324523e-01,
    7.324656e-01, 7.324789e-01, 7.324921e-01, 7.325053e-01, 7.325186e-01, 7.325318e-01,
    7.325451e-01, 7.325583e-01, 7.325715e-01, 7.325848e-01, 7.325980e-01, 7.326112e-01,
    7.326246e-01, 7.326378e-01, 7.326511e-01, 7.326643e-01, 7.326776e-01, 7.326908e-01,
    7.327040e-01, 7.327173e-01, 7.327305e-01, 7.327438e-01, 7.327570e-01, 7.327703e-01,
    7.327835e-01, 7.327967e-01, 7.328100e-01, 7.328233e-01, 7.328365e-01, 7.328497e-01,
    7.328629e-01, 7.328762e-01, 7.328895e-01, 7.329028e-01, 7.329160e-01, 7.329293e-01,
    7.329425e-01, 7.329558e-01, 7.329690e-01, 7.329822e-01, 7.329955e-01, 7.330087e-01,
    7.330220e-01, 7.330352e-01, 7.330484e-01, 7.330617e-01, 7.330749e-01, 7.330882e-01,
    7.331014e-01, 7.331147e-01, 7.331279e-01, 7.331411e-01, 7.331544e-01, 7.331676e-01,
    7.331809e-01, 7.331941e-01, 7.332073e-01, 7.332206e-01, 7.332339e-01, 7.332471e-01,
    7.332603e-01, 7.332736e-01, 7.332868e-01, 7.333000e-01, 7.333133e-01, 7.333266e-01,
    7.333398e-01, 7.333530e-01, 7.333663e-01, 7.333795e-01, 7.333928e-01, 7.334060e-01,
    7.334192e-01, 7.334325e-01, 7.334457e-01, 7.334590e-01, 7.334722e-01, 7.334855e-01,
    7.334987e-01, 7.335119e-01, 7.335252e-01, 7.335384e-01, 7.335516e-01, 7.335648e-01,
    7.335781e-01, 7.335913e-01, 7.336046e-01, 7.336178e-01, 7.336310e-01, 7.336443e-01,
    7.336575e-01, 7.336708e-01, 7.336840e-01, 7.336972e-01, 7.337105e-01, 7.337238e-01,
    7.337370e-01, 7.337502e-01, 7.337635e-01, 7.337767e-01, 7.337899e-01, 7.338032e-01,
    7.338163e-01, 7.338296e-01, 7.338428e-01, 7.338561e-01, 7.338693e-01, 7.338825e-01,
    7.338958e-01, 7.339091e-01, 7.339223e-01, 7.339355e-01, 7.339488e-01, 7.339620e-01,
    7.339752e-01, 7.339885e-01, 7.340016e-01, 7.340149e-01, 7.340282e-01, 7.340414e-01,
    7.340546e-01, 7.340679e-01, 7.340811e-01, 7.340944e-01, 7.341076e-01, 7.341208e-01,
    7.341341e-01, 7.341473e-01, 7.341605e-01, 7.341737e-01, 7.341869e-01, 7.342002e-01,
    7.342135e-01, 7.342267e-01, 7.342399e-01, 7.342532e-01, 7.342663e-01, 7.342796e-01,
    7.342928e-01, 7.343060e-01, 7.343193e-01, 7.343326e-01, 7.343458e-01, 7.343590e-01,
    7.343723e-01, 7.343854e-01, 7.343987e-01, 7.344119e-01, 7.344252e-01, 7.344384e-01,
    7.344517e-01, 7.344649e-01, 7.344781e-01, 7.344913e-01, 7.345045e-01, 7.345178e-01,
    7.345310e-01, 7.345443e-01, 7.345575e-01, 7.345707e-01, 7.345839e-01, 7.345971e-01,
    7.346104e-01, 7.346236e-01, 7.346369e-01, 7.346501e-01, 7.346632e-01, 7.346765e-01,
    7.346898e-01, 7.347030e-01, 7.347162e-01, 7.347295e-01, 7.347428e-01, 7.347559e-01,
    7.347691e-01, 7.347824e-01, 7.347956e-01, 7.348089e-01, 7.348221e-01, 7.348353e-01,
    7.348485e-01, 7.348617e-01, 7.348750e-01, 7.348883e-01, 7.349014e-01, 7.349146e-01,
    7.349279e-01, 7.349411e-01, 7.349544e-01, 7.349676e-01, 7.349808e-01, 7.349940e-01,
    7.350072e-01, 7.350205e-01, 7.350338e-01, 7.350469e-01, 7.350601e-01, 7.350734e-01,
    7.350866e-01, 7.350999e-01, 7.351130e-01, 7.351263e-01, 7.351395e-01, 7.351527e-01,
    7.351660e-01, 7.351791e-01, 7.351924e-01, 7.352057e-01, 7.352189e-01, 7.352321e-01,
    7.352453e-01, 7.352585e-01, 7.352718e-01, 7.352850e-01, 7.352982e-01, 7.353114e-01,
    7.353246e-01, 7.353379e-01, 7.353511e-01, 7.353643e-01, 7.353775e-01, 7.353908e-01,
    7.354040e-01, 7.354172e-01, 7.354304e-01, 7.354437e-01, 7.354569e-01, 7.354701e-01,
    7.354833e-01, 7.354965e-01, 7.355098e-01, 7.355229e-01, 7.355362e-01, 7.355494e-01,
    7.355627e-01, 7.355758e-01, 7.355891e-01, 7.356023e-01, 7.356156e-01, 7.356287e-01,
    7.356420e-01, 7.356552e-01, 7.356684e-01, 7.356816e-01, 7.356948e-01, 7.357081e-01,
    7.357213e-01, 7.357345e-01, 7.357477e-01, 7.357609e-01, 7.357742e-01, 7.357873e-01,
    7.358006e-01, 7.358139e-01, 7.358270e-01, 7.358403e-01, 7.358535e-01, 7.358667e-01,
    7.358799e-01, 7.358931e-01, 7.359064e-01, 7.359195e-01, 7.359328e-01, 7.359460e-01,
    7.359592e-01, 7.359724e-01, 7.359856e-01, 7.359989e-01, 7.360120e-01, 7.360253e-01,
    7.360385e-01, 7.360517e-01, 7.360649e-01, 7.360782e-01, 7.360914e-01, 7.361045e-01,
    7.361178e-01, 7.361311e-01, 7.361442e-01, 7.361575e-01, 7.361707e-01, 7.361839e-01,
    7.361971e-01, 7.362103e-01, 7.362235e-01, 7.362368e-01, 7.362500e-01, 7.362632e-01,
    7.362764e-01, 7.362896e-01, 7.363028e-01, 7.363160e-01, 7.363293e-01, 7.363424e-01,
    7.363557e-01, 7.363689e-01, 7.363821e-01, 7.363953e-01, 7.364085e-01, 7.364217e-01,
    7.364349e-01, 7.364482e-01, 7.364613e-01, 7.364746e-01, 7.364879e-01, 7.365010e-01,
    7.365142e-01, 7.365275e-01, 7.365406e-01, 7.365539e-01, 7.365671e-01, 7.365803e-01,
    7.365935e-01, 7.366068e-01, 7.366199e-01, 7.366332e-01, 7.366463e-01, 7.366596e-01,
    7.366728e-01, 7.366860e-01, 7.366992e-01, 7.367125e-01, 7.367256e-01, 7.367389e-01,
    7.367520e-01, 7.367653e-01, 7.367785e-01, 7.367917e-01, 7.368049e-01, 7.368181e-01,
    7.368313e-01, 7.368445e-01, 7.368577e-01, 7.368709e-01, 7.368842e-01, 7.368973e-01,
    7.369106e-01, 7.369238e-01, 7.369370e-01, 7.369502e-01, 7.369634e-01, 7.369766e-01,
    7.369898e-01, 7.370030e-01, 7.370163e-01, 7.370294e-01, 7.370427e-01, 7.370558e-01,
    7.370691e-01, 7.370823e-01, 7.370955e-01, 7.371087e-01, 7.371219e-01, 7.371351e-01,
    7.371482e-01, 7.371615e-01, 7.371747e-01, 7.371879e-01, 7.372012e-01, 7.372143e-01,
    7.372276e-01, 7.372408e-01, 7.372540e-01, 7.372672e-01, 7.372803e-01, 7.372936e-01,
    7.373067e-01, 7.373200e-01, 7.373331e-01, 7.373464e-01, 7.373596e-01, 7.373728e-01,
    7.373860e-01, 7.373992e-01, 7.374124e-01, 7.374256e-01, 7.374388e-01, 7.374520e-01,
    7.374652e-01, 7.374784e-01, 7.374916e-01, 7.375048e-01, 7.375180e-01, 7.375312e-01,
    7.375444e-01, 7.375576e-01, 7.375708e-01, 7.375841e-01, 7.375972e-01, 7.376105e-01,
    7.376236e-01, 7.376369e-01, 7.376501e-01, 7.376633e-01, 7.376765e-01, 7.376897e-01,
    7.377029e-01, 7.377161e-01, 7.377293e-01, 7.377424e-01, 7.377557e-01, 7.377688e-01,
    7.377821e-01, 7.377952e-01, 7.378085e-01, 7.378216e-01, 7.378349e-01, 7.378480e-01,
    7.378613e-01, 7.378744e-01, 7.378877e-01, 7.379009e-01, 7.379141e-01, 7.379273e-01,
    7.379405e-01, 7.379537e-01, 7.379669e-01, 7.379801e-01, 7.379933e-01, 7.380065e-01,
    7.380197e-01, 7.380328e-01, 7.380461e-01, 7.380592e-01, 7.380725e-01, 7.380856e-01,
    7.380989e-01, 7.381120e-01, 7.381253e-01, 7.381384e-01, 7.381517e-01, 7.381648e-01,
    7.381781e-01, 7.381912e-01, 7.382044e-01, 7.382177e-01, 7.382308e-01, 7.382441e-01,
    7.382572e-01, 7.382705e-01, 7.382836e-01, 7.382969e-01, 7.383100e-01, 7.383232e-01,
    7.383364e-01, 7.383496e-01, 7.383628e-01, 7.383760e-01, 7.383892e-01, 7.384024e-01,
    7.384156e-01, 7.384288e-01, 7.384420e-01, 7.384552e-01, 7.384684e-01, 7.384815e-01,
    7.384947e-01, 7.385079e-01, 7.385211e-01, 7.385343e-01, 7.385475e-01, 7.385607e-01,
    7.385739e-01, 7.385871e-01, 7.386003e-01, 7.386135e-01, 7.386267e-01, 7.386398e-01,
    7.386531e-01, 7.386662e-01, 7.386794e-01, 7.386926e-01, 7.387058e-01, 7.387190e-01,
    7.387322e-01, 7.387454e-01, 7.387586e-01, 7.387718e-01, 7.387850e-01, 7.387981e-01,
    7.388113e-01, 7.388245e-01, 7.388377e-01, 7.388510e-01, 7.388641e-01, 7.388773e-01,
    7.388905e-01, 7.389037e-01, 7.389169e-01, 7.389301e-01, 7.389432e-01, 7.389565e-01,
    7.389696e-01, 7.389829e-01, 7.389960e-01, 7.390092e-01, 7.390224e-01, 7.390356e-01,
    7.390488e-01, 7.390620e-01, 7.390751e-01, 7.390884e-01, 7.391015e-01, 7.391147e-01,
    7.391279e-01, 7.391411e-01, 7.391543e-01, 7.391675e-01, 7.391807e-01, 7.391939e-01,
    7.392070e-01, 7.392202e-01, 7.392334e-01, 7.392466e-01, 7.392598e-01, 7.392730e-01,
    7.392862e-01, 7.392993e-01, 7.393126e-01, 7.393257e-01, 7.393390e-01, 7.393521e-01,
    7.393653e-01, 7.393785e-01, 7.393917e-01, 7.394049e-01, 7.394181e-01, 7.394313e-01,
    7.394444e-01, 7.394576e-01, 7.394708e-01, 7.394840e-01, 7.394972e-01, 7.395104e-01,
    7.395235e-01, 7.395368e-01, 7.395499e-01, 7.395630e-01, 7.395763e-01, 7.395895e-01,
    7.396026e-01, 7.396159e-01, 7.396290e-01, 7.396421e-01, 7.396553e-01, 7.396685e-01,
    7.396817e-01, 7.396949e-01, 7.397081e-01, 7.397213e-01, 7.397345e-01, 7.397477e-01,
    7.397608e-01, 7.397740e-01, 7.397872e-01, 7.398004e-01, 7.398136e-01, 7.398267e-01,
    7.398400e-01, 7.398531e-01, 7.398663e-01, 7.398795e-01, 7.398927e-01, 7.399058e-01,
    7.399190e-01, 7.399322e-01, 7.399454e-01, 7.399585e-01, 7.399718e-01, 7.399849e-01,
    7.399981e-01, 7.400113e-01, 7.400245e-01, 7.400376e-01, 7.400508e-01, 7.400640e-01,
    7.400772e-01, 7.400904e-01, 7.401035e-01, 7.401168e-01, 7.401299e-01, 7.401431e-01,
    7.401562e-01, 7.401695e-01, 7.401826e-01, 7.401958e-01, 7.402089e-01, 7.402222e-01,
    7.402353e-01, 7.402485e-01, 7.402617e-01, 7.402749e-01, 7.402881e-01, 7.403012e-01,
    7.403144e-01, 7.403276e-01, 7.403408e-01, 7.403539e-01, 7.403671e-01, 7.403803e-01,
    7.403935e-01, 7.404066e-01, 7.404198e-01, 7.404330e-01, 7.404462e-01, 7.404593e-01,
    7.404725e-01, 7.404857e-01, 7.404989e-01, 7.405121e-01, 7.405252e-01, 7.405384e-01,
    7.405516e-01, 7.405648e-01, 7.405779e-01, 7.405911e-01, 7.406042e-01, 7.406175e-01,
    7.406306e-01, 7.406438e-01, 7.406570e-01, 7.406701e-01, 7.406834e-01, 7.406965e-01,
    7.407097e-01, 7.407228e-01, 7.407360e-01, 7.407492e-01, 7.407624e-01, 7.407755e-01,
    7.407887e-01, 7.408019e-01, 7.408151e-01, 7.408283e-01, 7.408414e-01, 7.408546e-01,
    7.408677e-01, 7.408810e-01, 7.408941e-01, 7.409073e-01, 7.409204e-01, 7.409336e-01,
    7.409468e-01, 7.409600e-01, 7.409732e-01, 7.409863e-01, 7.409995e-01, 7.410126e-01,
    7.410259e-01, 7.410390e-01, 7.410522e-01, 7.410653e-01, 7.410785e-01, 7.410917e-01,
    7.411049e-01, 7.411180e-01, 7.411312e-01, 7.411444e-01, 7.411575e-01, 7.411706e-01,
    7.411838e-01, 7.411970e-01, 7.412102e-01, 7.412234e-01, 7.412366e-01, 7.412497e-01,
    7.412629e-01, 7.412760e-01, 7.412893e-01, 7.413024e-01, 7.413155e-01, 7.413287e-01,
    7.413419e-01, 7.413551e-01, 7.413682e-01, 7.413814e-01, 7.413946e-01, 7.414078e-01,
    7.414209e-01, 7.414340e-01, 7.414472e-01, 7.414604e-01, 7.414736e-01, 7.414868e-01,
    7.414999e-01, 7.415131e-01, 7.415262e-01, 7.415394e-01, 7.415525e-01, 7.415657e-01,
    7.415789e-01, 7.415920e-01, 7.416053e-01, 7.416185e-01, 7.416316e-01, 7.416447e-01,
    7.416579e-01, 7.416710e-01, 7.416842e-01, 7.416974e-01, 7.417105e-01, 7.417237e-01,
    7.417369e-01, 7.417501e-01, 7.417632e-01, 7.417764e-01, 7.417895e-01, 7.418027e-01,
    7.418159e-01, 7.418290e-01, 7.418422e-01, 7.418553e-01, 7.418685e-01, 7.418817e-01,
    7.418949e-01, 7.419081e-01, 7.419212e-01, 7.419344e-01, 7.419475e-01, 7.419606e-01,
    7.419738e-01, 7.419870e-01, 7.420002e-01, 7.420133e-01, 7.420264e-01, 7.420396e-01,
    7.420528e-01, 7.420659e-01, 7.420791e-01, 7.420923e-01, 7.421055e-01, 7.421187e-01,
    7.421318e-01, 7.421449e-01, 7.421581e-01, 7.421713e-01, 7.421844e-01, 7.421976e-01,
    7.422107e-01, 7.422239e-01, 7.422370e-01, 7.422502e-01, 7.422634e-01, 7.422765e-01,
    7.422897e-01, 7.423028e-01, 7.423160e-01, 7.423291e-01, 7.423423e-01, 7.423555e-01,
    7.423686e-01, 7.423818e-01, 7.423949e-01, 7.424081e-01, 7.424213e-01, 7.424345e-01,
    7.424476e-01, 7.424608e-01, 7.424740e-01, 7.424871e-01, 7.425002e-01, 7.425134e-01,
    7.425266e-01, 7.425398e-01, 7.425529e-01, 7.425660e-01, 7.425792e-01, 7.425923e-01,
    7.426055e-01, 7.426187e-01, 7.426319e-01, 7.426450e-01, 7.426581e-01, 7.426713e-01,
    7.426845e-01, 7.426976e-01, 7.427108e-01, 7.427239e-01, 7.427371e-01, 7.427502e-01,
    7.427634e-01, 7.427766e-01, 7.427897e-01, 7.428029e-01, 7.428159e-01, 7.428291e-01,
    7.428423e-01, 7.428554e-01, 7.428685e-01, 7.428817e-01, 7.428949e-01, 7.429081e-01,
    7.429212e-01, 7.429343e-01, 7.429475e-01, 7.429607e-01, 7.429738e-01, 7.429870e-01,
    7.430001e-01, 7.430133e-01, 7.430264e-01, 7.430396e-01, 7.430528e-01, 7.430659e-01,
    7.430791e-01, 7.430922e-01, 7.431054e-01, 7.431185e-01, 7.431317e-01, 7.431449e-01,
    7.431579e-01, 7.431711e-01, 7.431843e-01, 7.431974e-01, 7.432106e-01, 7.432237e-01,
    7.432368e-01, 7.432500e-01, 7.432632e-01, 7.432764e-01, 7.432895e-01, 7.433026e-01,
    7.433158e-01, 7.433290e-01, 7.433421e-01, 7.433552e-01, 7.433683e-01, 7.433815e-01,
    7.433947e-01, 7.434078e-01, 7.434210e-01, 7.434341e-01, 7.434473e-01, 7.434604e-01,
    7.434736e-01, 7.434868e-01, 7.434998e-01, 7.435130e-01, 7.435262e-01, 7.435393e-01,
    7.435524e-01, 7.435656e-01, 7.435788e-01, 7.435919e-01, 7.436051e-01, 7.436182e-01,
    7.436313e-01, 7.436445e-01, 7.436576e-01, 7.436708e-01, 7.436839e-01, 7.436971e-01,
    7.437103e-01, 7.437234e-01, 7.437366e-01, 7.437496e-01, 7.437628e-01, 7.437760e-01,
    7.437891e-01, 7.438022e-01, 7.438154e-01, 7.438286e-01, 7.438417e-01, 7.438548e-01,
    7.438679e-01, 7.438811e-01, 7.438943e-01, 7.439075e-01, 7.439206e-01, 7.439337e-01,
    7.439468e-01, 7.439600e-01, 7.439731e-01, 7.439863e-01, 7.439994e-01, 7.440126e-01,
    7.440258e-01, 7.440388e-01, 7.440520e-01, 7.440652e-01, 7.440783e-01, 7.440915e-01,
    7.441046e-01, 7.441177e-01, 7.441308e-01, 7.441440e-01, 7.441571e-01, 7.441703e-01,
    7.441835e-01, 7.441966e-01, 7.442097e-01, 7.442228e-01, 7.442360e-01, 7.442492e-01,
    7.442623e-01, 7.442755e-01, 7.442886e-01, 7.443017e-01, 7.443148e-01, 7.443280e-01,
    7.443412e-01, 7.443542e-01, 7.443674e-01, 7.443805e-01, 7.443937e-01, 7.444069e-01,
    7.444199e-01, 7.444331e-01, 7.444463e-01, 7.444594e-01, 7.444726e-01, 7.444857e-01,
    7.444988e-01, 7.445120e-01, 7.445251e-01, 7.445382e-01, 7.445514e-01, 7.445645e-01,
    7.445776e-01, 7.445908e-01, 7.446039e-01, 7.446170e-01, 7.446302e-01, 7.446433e-01,
    7.446565e-01, 7.446697e-01, 7.446827e-01, 7.446959e-01, 7.447090e-01, 7.447222e-01,
    7.447352e-01, 7.447484e-01, 7.447616e-01, 7.447748e-01, 7.447879e-01, 7.448010e-01,
    7.448141e-01, 7.448273e-01, 7.448404e-01, 7.448535e-01, 7.448667e-01, 7.448798e-01,
    7.448930e-01, 7.449061e-01, 7.449192e-01, 7.449324e-01, 7.449455e-01, 7.449586e-01,
    7.449718e-01, 7.449849e-01, 7.449980e-01, 7.450112e-01, 7.450243e-01, 7.450374e-01,
    7.450506e-01, 7.450637e-01, 7.450768e-01, 7.450900e-01, 7.451031e-01, 7.451162e-01,
    7.451293e-01, 7.451425e-01, 7.451557e-01, 7.451687e-01, 7.451819e-01, 7.451951e-01,
    7.452081e-01, 7.452213e-01, 7.452344e-01, 7.452476e-01, 7.452607e-01, 7.452738e-01,
    7.452870e-01, 7.453002e-01, 7.453132e-01, 7.453264e-01, 7.453395e-01, 7.453526e-01,
    7.453657e-01, 7.453789e-01, 7.453920e-01, 7.454051e-01, 7.454183e-01, 7.454314e-01,
    7.454445e-01, 7.454577e-01, 7.454708e-01, 7.454839e-01, 7.454970e-01, 7.455102e-01,
    7.455233e-01, 7.455364e-01, 7.455496e-01, 7.455627e-01, 7.455758e-01, 7.455890e-01,
    7.456021e-01, 7.456152e-01, 7.456284e-01, 7.456415e-01, 7.456546e-01, 7.456678e-01,
    7.456809e-01, 7.456940e-01, 7.457072e-01, 7.457203e-01, 7.457334e-01, 7.457466e-01,
    7.457597e-01, 7.457728e-01, 7.457859e-01, 7.457991e-01, 7.458121e-01, 7.458253e-01,
    7.458385e-01, 7.458515e-01, 7.458647e-01, 7.458779e-01, 7.458909e-01, 7.459041e-01,
    7.459172e-01, 7.459303e-01, 7.459434e-01, 7.459566e-01, 7.459697e-01, 7.459828e-01,
    7.459959e-01, 7.460091e-01, 7.460222e-01, 7.460353e-01, 7.460485e-01, 7.460616e-01,
    7.460747e-01, 7.460878e-01, 7.461010e-01, 7.461141e-01, 7.461272e-01, 7.461403e-01,
    7.461534e-01, 7.461666e-01, 7.461796e-01, 7.461928e-01, 7.462060e-01, 7.462190e-01,
    7.462322e-01, 7.462453e-01, 7.462584e-01, 7.462716e-01, 7.462847e-01, 7.462978e-01,
    7.463109e-01, 7.463241e-01, 7.463372e-01, 7.463503e-01, 7.463634e-01, 7.463766e-01,
    7.463896e-01, 7.464028e-01, 7.464159e-01, 7.464290e-01, 7.464421e-01, 7.464553e-01,
    7.464684e-01, 7.464815e-01, 7.464947e-01, 7.465077e-01, 7.465209e-01, 7.465340e-01,
    7.465471e-01, 7.465603e-01, 7.465733e-01, 7.465865e-01, 7.465997e-01, 7.466127e-01,
    7.466259e-01, 7.466390e-01, 7.466521e-01, 7.466652e-01, 7.466784e-01, 7.466915e-01,
    7.467046e-01, 7.467177e-01, 7.467308e-01, 7.467439e-01, 7.467570e-01, 7.467701e-01,
    7.467833e-01, 7.467964e-01, 7.468095e-01, 7.468226e-01, 7.468358e-01, 7.468488e-01,
    7.468620e-01, 7.468750e-01, 7.468882e-01, 7.469013e-01, 7.469144e-01, 7.469276e-01,
    7.469407e-01, 7.469538e-01, 7.469669e-01, 7.469801e-01, 7.469931e-01, 7.470063e-01,
    7.470194e-01, 7.470325e-01, 7.470456e-01, 7.470587e-01, 7.470718e-01, 7.470850e-01,
    7.470980e-01, 7.471112e-01, 7.471244e-01, 7.471374e-01, 7.471506e-01, 7.471637e-01,
    7.471768e-01, 7.471899e-01, 7.472031e-01, 7.472161e-01, 7.472293e-01, 7.472423e-01,
    7.472555e-01, 7.472686e-01, 7.472817e-01, 7.472948e-01, 7.473080e-01, 7.473210e-01,
    7.473342e-01, 7.473472e-01, 7.473604e-01, 7.473735e-01, 7.473866e-01, 7.473997e-01,
    7.474129e-01, 7.474259e-01, 7.474391e-01, 7.474521e-01, 7.474653e-01, 7.474784e-01,
    7.474915e-01, 7.475046e-01, 7.475178e-01, 7.475308e-01, 7.475440e-01, 7.475570e-01,
    7.475702e-01, 7.475833e-01, 7.475964e-01, 7.476096e-01, 7.476226e-01, 7.476358e-01,
    7.476488e-01, 7.476620e-01, 7.476751e-01, 7.476882e-01, 7.477013e-01, 7.477145e-01,
    7.477275e-01, 7.477407e-01, 7.477537e-01, 7.477668e-01, 7.477800e-01, 7.477930e-01,
    7.478062e-01, 7.478192e-01, 7.478324e-01, 7.478455e-01, 7.478586e-01, 7.478717e-01,
    7.478848e-01, 7.478979e-01, 7.479110e-01, 7.479241e-01, 7.479373e-01, 7.479504e-01,
    7.479635e-01, 7.479766e-01, 7.479897e-01, 7.480028e-01, 7.480159e-01, 7.480290e-01,
    7.480422e-01, 7.480552e-01, 7.480684e-01, 7.480814e-01, 7.480945e-01, 7.481077e-01,
    7.481207e-01, 7.481339e-01, 7.481470e-01, 7.481601e-01, 7.481732e-01, 7.481863e-01,
    7.481994e-01, 7.482125e-01, 7.482256e-01, 7.482387e-01, 7.482518e-01, 7.482650e-01,
    7.482780e-01, 7.482912e-01, 7.483042e-01, 7.483173e-01, 7.483305e-01, 7.483435e-01,
    7.483566e-01, 7.483698e-01, 7.483829e-01, 7.483960e-01, 7.484091e-01, 7.484221e-01,
    7.484353e-01, 7.484484e-01, 7.484615e-01, 7.484746e-01, 7.484877e-01, 7.485008e-01,
    7.485139e-01, 7.485270e-01, 7.485401e-01, 7.485532e-01, 7.485663e-01, 7.485794e-01,
    7.485925e-01, 7.486057e-01, 7.486187e-01, 7.486318e-01, 7.486449e-01, 7.486580e-01,
    7.486711e-01, 7.486842e-01, 7.486973e-01, 7.487105e-01, 7.487236e-01, 7.487366e-01,
    7.487498e-01, 7.487628e-01, 7.487759e-01, 7.487891e-01, 7.488021e-01, 7.488152e-01,
    7.488284e-01, 7.488415e-01, 7.488545e-01, 7.488677e-01, 7.488807e-01, 7.488938e-01,
    7.489070e-01, 7.489200e-01, 7.489331e-01, 7.489462e-01, 7.489594e-01, 7.489724e-01,
    7.489856e-01, 7.489986e-01, 7.490117e-01, 7.490249e-01, 7.490379e-01, 7.490510e-01,
    7.490641e-01, 7.490772e-01, 7.490903e-01, 7.491034e-01, 7.491165e-01, 7.491296e-01,
    7.491428e-01, 7.491558e-01, 7.491689e-01, 7.491820e-01, 7.491951e-01, 7.492082e-01,
    7.492213e-01, 7.492344e-01, 7.492475e-01, 7.492605e-01, 7.492737e-01, 7.492868e-01,
    7.492999e-01, 7.493129e-01, 7.493261e-01, 7.493392e-01, 7.493522e-01, 7.493654e-01,
    7.493784e-01, 7.493915e-01, 7.494046e-01, 7.494178e-01, 7.494308e-01, 7.494439e-01,
    7.494571e-01, 7.494701e-01, 7.494832e-01, 7.494963e-01, 7.495094e-01, 7.495225e-01,
    7.495356e-01, 7.495486e-01, 7.495618e-01, 7.495748e-01, 7.495880e-01, 7.496010e-01,
    7.496142e-01, 7.496272e-01, 7.496403e-01, 7.496535e-01, 7.496665e-01, 7.496796e-01,
    7.496927e-01, 7.497059e-01, 7.497189e-01, 7.497320e-01, 7.497450e-01, 7.497582e-01,
    7.497712e-01, 7.497844e-01, 7.497974e-01, 7.498105e-01, 7.498236e-01, 7.498367e-01,
    7.498498e-01, 7.498628e-01, 7.498760e-01, 7.498891e-01, 7.499021e-01, 7.499152e-01,
    7.499284e-01, 7.499415e-01, 7.499545e-01, 7.499676e-01, 7.499806e-01, 7.499938e-01,
    7.500069e-01, 7.500200e-01, 7.500330e-01, 7.500462e-01, 7.500592e-01, 7.500723e-01,
    7.500854e-01, 7.500985e-01, 7.501116e-01, 7.501247e-01, 7.501377e-01, 7.501508e-01,
    7.501639e-01, 7.501771e-01, 7.501901e-01, 7.502032e-01, 7.502162e-01, 7.502294e-01,
    7.502425e-01, 7.502556e-01, 7.502686e-01, 7.502817e-01, 7.502948e-01, 7.503079e-01,
    7.503210e-01, 7.503341e-01, 7.503471e-01, 7.503602e-01, 7.503733e-01, 7.503864e-01,
    7.503995e-01, 7.504126e-01, 7.504256e-01, 7.504387e-01, 7.504519e-01, 7.504650e-01,
    7.504780e-01, 7.504911e-01, 7.505042e-01, 7.505172e-01, 7.505304e-01, 7.505435e-01,
    7.505565e-01, 7.505696e-01, 7.505827e-01, 7.505957e-01, 7.506088e-01, 7.506220e-01,
    7.506350e-01, 7.506481e-01, 7.506612e-01, 7.506742e-01, 7.506873e-01, 7.507005e-01,
    7.507135e-01, 7.507266e-01, 7.507397e-01, 7.507527e-01, 7.507659e-01, 7.507789e-01,
    7.507920e-01, 7.508051e-01, 7.508182e-01, 7.508313e-01, 7.508444e-01, 7.508574e-01,
    7.508705e-01, 7.508836e-01, 7.508967e-01, 7.509098e-01, 7.509229e-01, 7.509359e-01,
    7.509490e-01, 7.509621e-01, 7.509751e-01, 7.509882e-01, 7.510013e-01, 7.510144e-01,
    7.510275e-01, 7.510406e-01, 7.510536e-01, 7.510667e-01, 7.510798e-01, 7.510929e-01,
    7.511060e-01, 7.511190e-01, 7.511322e-01, 7.511452e-01, 7.511583e-01, 7.511714e-01,
    7.511845e-01, 7.511975e-01, 7.512106e-01, 7.512237e-01, 7.512367e-01, 7.512498e-01,
    7.512628e-01, 7.512760e-01, 7.512891e-01, 7.513022e-01, 7.513152e-01, 7.513283e-01,
    7.513414e-01, 7.513545e-01, 7.513675e-01, 7.513806e-01, 7.513937e-01, 7.514067e-01,
    7.514198e-01, 7.514329e-01, 7.514460e-01, 7.514591e-01, 7.514722e-01, 7.514852e-01,
    7.514983e-01, 7.515114e-01, 7.515244e-01, 7.515375e-01, 7.515506e-01, 7.515637e-01,
    7.515767e-01, 7.515898e-01, 7.516029e-01, 7.516159e-01, 7.516290e-01, 7.516421e-01,
    7.516552e-01, 7.516682e-01, 7.516813e-01, 7.516944e-01, 7.517076e-01, 7.517206e-01,
    7.517337e-01, 7.517467e-01, 7.517598e-01, 7.517729e-01, 7.517859e-01, 7.517990e-01,
    7.518121e-01, 7.518252e-01, 7.518382e-01, 7.518513e-01, 7.518644e-01, 7.518774e-01,
    7.518905e-01, 7.519036e-01, 7.519166e-01, 7.519298e-01, 7.519428e-01, 7.519559e-01,
    7.519689e-01, 7.519820e-01, 7.519951e-01, 7.520081e-01, 7.520213e-01, 7.520343e-01,
    7.520474e-01, 7.520604e-01, 7.520735e-01, 7.520866e-01, 7.520996e-01, 7.521127e-01,
    7.521258e-01, 7.521389e-01, 7.521519e-01, 7.521650e-01, 7.521781e-01, 7.521911e-01,
    7.522042e-01, 7.522173e-01, 7.522303e-01, 7.522434e-01, 7.522565e-01, 7.522696e-01,
    7.522826e-01, 7.522957e-01, 7.523088e-01, 7.523218e-01, 7.523349e-01, 7.523480e-01,
    7.523611e-01, 7.523741e-01, 7.523872e-01, 7.524003e-01, 7.524133e-01, 7.524264e-01,
    7.524395e-01, 7.524526e-01, 7.524655e-01, 7.524786e-01, 7.524917e-01, 7.525048e-01,
    7.525178e-01, 7.525309e-01, 7.525440e-01, 7.525570e-01, 7.525701e-01, 7.525832e-01,
    7.525963e-01, 7.526093e-01, 7.526224e-01, 7.526355e-01, 7.526485e-01, 7.526616e-01,
    7.526747e-01, 7.526878e-01, 7.527007e-01, 7.527138e-01, 7.527269e-01, 7.527400e-01,
    7.527530e-01, 7.527661e-01, 7.527791e-01, 7.527922e-01, 7.528053e-01, 7.528183e-01,
    7.528315e-01, 7.528445e-01, 7.528576e-01, 7.528706e-01, 7.528836e-01, 7.528967e-01,
    7.529098e-01, 7.529228e-01, 7.529359e-01, 7.529490e-01, 7.529621e-01, 7.529751e-01,
    7.529882e-01, 7.530013e-01, 7.530143e-01, 7.530273e-01, 7.530404e-01, 7.530535e-01,
    7.530665e-01, 7.530796e-01, 7.530927e-01, 7.531058e-01, 7.531188e-01, 7.531319e-01,
    7.531449e-01, 7.531580e-01, 7.531710e-01, 7.531841e-01, 7.531971e-01, 7.532102e-01,
    7.532233e-01, 7.532364e-01, 7.532495e-01, 7.532624e-01, 7.532755e-01, 7.532886e-01,
    7.533016e-01, 7.533147e-01, 7.533278e-01, 7.533408e-01, 7.533538e-01, 7.533669e-01,
    7.533800e-01, 7.533931e-01, 7.534061e-01, 7.534192e-01, 7.534323e-01, 7.534453e-01,
    7.534583e-01, 7.534714e-01, 7.534844e-01, 7.534975e-01, 7.535106e-01, 7.535236e-01,
    7.535366e-01, 7.535497e-01, 7.535628e-01, 7.535759e-01, 7.535889e-01, 7.536020e-01,
    7.536150e-01, 7.536281e-01, 7.536411e-01, 7.536542e-01, 7.536673e-01, 7.536803e-01,
    7.536933e-01, 7.537064e-01, 7.537194e-01, 7.537326e-01, 7.537456e-01, 7.537587e-01,
    7.537717e-01, 7.537847e-01, 7.537978e-01, 7.538109e-01, 7.538239e-01, 7.538370e-01,
    7.538500e-01, 7.538631e-01, 7.538761e-01, 7.538892e-01, 7.539023e-01, 7.539153e-01,
    7.539284e-01, 7.539414e-01, 7.539545e-01, 7.539676e-01, 7.539805e-01, 7.539936e-01,
    7.540067e-01, 7.540197e-01, 7.540329e-01, 7.540458e-01, 7.540589e-01, 7.540720e-01,
    7.540850e-01, 7.540981e-01, 7.541111e-01, 7.541242e-01, 7.541372e-01, 7.541503e-01,
    7.541633e-01, 7.541763e-01, 7.541894e-01, 7.542025e-01, 7.542155e-01, 7.542285e-01,
    7.542416e-01, 7.542547e-01, 7.542678e-01, 7.542807e-01, 7.542938e-01, 7.543069e-01,
    7.543200e-01, 7.543330e-01, 7.543460e-01, 7.543591e-01, 7.543721e-01, 7.543852e-01,
    7.543982e-01, 7.544113e-01, 7.544243e-01, 7.544374e-01, 7.544504e-01, 7.544635e-01,
    7.544765e-01, 7.544896e-01, 7.545026e-01, 7.545156e-01, 7.545288e-01, 7.545417e-01,
    7.545548e-01, 7.545679e-01, 7.545809e-01, 7.545939e-01, 7.546070e-01, 7.546201e-01,
    7.546331e-01, 7.546461e-01, 7.546592e-01, 7.546722e-01, 7.546853e-01, 7.546983e-01,
    7.547114e-01, 7.547244e-01, 7.547374e-01, 7.547505e-01, 7.547636e-01, 7.547767e-01,
    7.547897e-01, 7.548027e-01, 7.548158e-01, 7.548288e-01, 7.548418e-01, 7.548549e-01,
    7.548680e-01, 7.548810e-01, 7.548940e-01, 7.549071e-01, 7.549201e-01, 7.549332e-01,
    7.549462e-01, 7.549592e-01, 7.549723e-01, 7.549853e-01, 7.549984e-01, 7.550114e-01,
    7.550245e-01, 7.550375e-01, 7.550505e-01, 7.550636e-01, 7.550766e-01, 7.550896e-01,
    7.551028e-01, 7.551158e-01, 7.551288e-01, 7.551419e-01, 7.551549e-01, 7.551679e-01,
    7.551810e-01, 7.551941e-01, 7.552071e-01, 7.552201e-01, 7.552332e-01, 7.552462e-01,
    7.552592e-01, 7.552723e-01, 7.552853e-01, 7.552984e-01, 7.553114e-01, 7.553244e-01,
    7.553375e-01, 7.553505e-01, 7.553635e-01, 7.553766e-01, 7.553897e-01, 7.554027e-01,
    7.554157e-01, 7.554288e-01, 7.554418e-01, 7.554548e-01, 7.554680e-01, 7.554809e-01,
    7.554940e-01, 7.555071e-01, 7.555200e-01, 7.555331e-01, 7.555461e-01, 7.555591e-01,
    7.555723e-01, 7.555852e-01, 7.555983e-01, 7.556114e-01, 7.556244e-01, 7.556374e-01,
    7.556504e-01, 7.556635e-01, 7.556766e-01, 7.556895e-01, 7.557026e-01, 7.557157e-01,
    7.557287e-01, 7.557417e-01, 7.557547e-01, 7.557678e-01, 7.557809e-01, 7.557938e-01,
    7.558069e-01, 7.558199e-01, 7.558330e-01, 7.558460e-01, 7.558590e-01, 7.558721e-01,
    7.558851e-01, 7.558981e-01, 7.559112e-01, 7.559242e-01, 7.559373e-01, 7.559503e-01,
    7.559633e-01, 7.559764e-01, 7.559894e-01, 7.560024e-01, 7.560154e-01, 7.560285e-01,
    7.560416e-01, 7.560546e-01, 7.560676e-01, 7.560806e-01, 7.560937e-01, 7.561067e-01,
    7.561197e-01, 7.561328e-01, 7.561458e-01, 7.561589e-01, 7.561719e-01, 7.561849e-01,
    7.561979e-01, 7.562110e-01, 7.562240e-01, 7.562370e-01, 7.562501e-01, 7.562631e-01,
    7.562762e-01, 7.562891e-01, 7.563022e-01, 7.563152e-01, 7.563283e-01, 7.563413e-01,
    7.563543e-01, 7.563674e-01, 7.563804e-01, 7.563934e-01, 7.564064e-01, 7.564195e-01,
    7.564325e-01, 7.564456e-01, 7.564585e-01, 7.564716e-01, 7.564847e-01, 7.564977e-01,
    7.565107e-01, 7.565237e-01, 7.565368e-01, 7.565498e-01, 7.565628e-01, 7.565758e-01,
    7.565889e-01, 7.566019e-01, 7.566150e-01, 7.566280e-01, 7.566410e-01, 7.566540e-01,
    7.566671e-01, 7.566801e-01, 7.566931e-01, 7.567061e-01, 7.567192e-01, 7.567322e-01,
    7.567452e-01, 7.567582e-01, 7.567713e-01, 7.567844e-01, 7.567974e-01, 7.568104e-01,
    7.568234e-01, 7.568365e-01, 7.568495e-01, 7.568625e-01, 7.568755e-01, 7.568886e-01,
    7.569016e-01, 7.569146e-01, 7.569276e-01, 7.569406e-01, 7.569537e-01, 7.569667e-01,
    7.569798e-01, 7.569928e-01, 7.570058e-01, 7.570188e-01, 7.570319e-01, 7.570449e-01,
    7.570579e-01, 7.570709e-01, 7.570840e-01, 7.570969e-01, 7.571100e-01, 7.571230e-01,
    7.571360e-01, 7.571490e-01, 7.571622e-01, 7.571751e-01, 7.571881e-01, 7.572012e-01,
    7.572141e-01, 7.572272e-01, 7.572402e-01, 7.572533e-01, 7.572663e-01, 7.572793e-01,
    7.572923e-01, 7.573054e-01, 7.573184e-01, 7.573314e-01, 7.573444e-01, 7.573574e-01,
    7.573705e-01, 7.573835e-01, 7.573965e-01, 7.574095e-01, 7.574226e-01, 7.574356e-01,
    7.574486e-01, 7.574617e-01, 7.574746e-01, 7.574877e-01, 7.575007e-01, 7.575138e-01,
    7.575268e-01, 7.575397e-01, 7.575528e-01, 7.575658e-01, 7.575788e-01, 7.575918e-01,
    7.576049e-01, 7.576179e-01, 7.576309e-01, 7.576439e-01, 7.576569e-01, 7.576700e-01,
    7.576830e-01, 7.576960e-01, 7.577090e-01, 7.577220e-01, 7.577351e-01, 7.577481e-01,
    7.577611e-01, 7.577741e-01, 7.577871e-01, 7.578002e-01, 7.578132e-01, 7.578261e-01,
    7.578392e-01, 7.578522e-01, 7.578653e-01, 7.578782e-01, 7.578912e-01, 7.579044e-01,
    7.579173e-01, 7.579304e-01, 7.579434e-01, 7.579563e-01, 7.579694e-01, 7.579824e-01,
    7.579955e-01, 7.580085e-01, 7.580214e-01, 7.580345e-01, 7.580475e-01, 7.580605e-01,
    7.580736e-01, 7.580866e-01, 7.580995e-01, 7.581126e-01, 7.581256e-01, 7.581387e-01,
    7.581517e-01, 7.581646e-01, 7.581777e-01, 7.581907e-01, 7.582037e-01, 7.582167e-01,
    7.582297e-01, 7.582427e-01, 7.582558e-01, 7.582688e-01, 7.582818e-01, 7.582948e-01,
    7.583078e-01, 7.583209e-01, 7.583339e-01, 7.583469e-01, 7.583599e-01, 7.583729e-01,
    7.583859e-01, 7.583990e-01, 7.584119e-01, 7.584249e-01, 7.584380e-01, 7.584510e-01,
    7.584640e-01, 7.584770e-01, 7.584900e-01, 7.585030e-01, 7.585161e-01, 7.585291e-01,
    7.585421e-01, 7.585550e-01, 7.585681e-01, 7.585811e-01, 7.585940e-01, 7.586071e-01,
    7.586201e-01, 7.586331e-01, 7.586462e-01, 7.586592e-01, 7.586721e-01, 7.586852e-01,
    7.586982e-01, 7.587112e-01, 7.587242e-01, 7.587372e-01, 7.587502e-01, 7.587632e-01,
    7.587762e-01, 7.587892e-01, 7.588022e-01, 7.588153e-01, 7.588283e-01, 7.588413e-01,
    7.588543e-01, 7.588673e-01, 7.588803e-01, 7.588933e-01, 7.589064e-01, 7.589194e-01,
    7.589324e-01, 7.589453e-01, 7.589584e-01, 7.589714e-01, 7.589844e-01, 7.589974e-01,
    7.590104e-01, 7.590234e-01, 7.590364e-01, 7.590495e-01, 7.590625e-01, 7.590755e-01,
    7.590884e-01, 7.591015e-01, 7.591145e-01, 7.591274e-01, 7.591404e-01, 7.591535e-01,
    7.591665e-01, 7.591795e-01, 7.591925e-01, 7.592055e-01, 7.592185e-01, 7.592315e-01,
    7.592445e-01, 7.592576e-01, 7.592705e-01, 7.592835e-01, 7.592965e-01, 7.593096e-01,
    7.593226e-01, 7.593356e-01, 7.593486e-01, 7.593616e-01, 7.593746e-01, 7.593876e-01,
    7.594005e-01, 7.594137e-01, 7.594267e-01, 7.594396e-01, 7.594526e-01, 7.594656e-01,
    7.594786e-01, 7.594916e-01, 7.595046e-01, 7.595176e-01, 7.595307e-01, 7.595437e-01,
    7.595567e-01, 7.595696e-01, 7.595826e-01, 7.595957e-01, 7.596087e-01, 7.596217e-01,
    7.596346e-01, 7.596476e-01, 7.596607e-01, 7.596737e-01, 7.596866e-01, 7.596996e-01,
    7.597126e-01, 7.597257e-01, 7.597387e-01, 7.597517e-01, 7.597647e-01, 7.597777e-01,
    7.597907e-01, 7.598037e-01, 7.598167e-01, 7.598296e-01, 7.598426e-01, 7.598556e-01,
    7.598687e-01, 7.598817e-01, 7.598947e-01, 7.599077e-01, 7.599207e-01, 7.599337e-01,
    7.599467e-01, 7.599597e-01, 7.599727e-01, 7.599857e-01, 7.599986e-01, 7.600117e-01,
    7.600247e-01, 7.600377e-01, 7.600507e-01, 7.600636e-01, 7.600766e-01, 7.600897e-01,
    7.601027e-01, 7.601157e-01, 7.601287e-01, 7.601417e-01, 7.601546e-01, 7.601676e-01,
    7.601807e-01, 7.601936e-01, 7.602066e-01, 7.602196e-01, 7.602326e-01, 7.602456e-01,
    7.602586e-01, 7.602717e-01, 7.602847e-01, 7.602977e-01, 7.603106e-01, 7.603236e-01,
    7.603366e-01, 7.603496e-01, 7.603626e-01, 7.603756e-01, 7.603886e-01, 7.604016e-01,
    7.604146e-01, 7.604276e-01, 7.604405e-01, 7.604535e-01, 7.604666e-01, 7.604796e-01,
    7.604926e-01, 7.605056e-01, 7.605186e-01, 7.605315e-01, 7.605445e-01, 7.605575e-01,
    7.605705e-01, 7.605836e-01, 7.605965e-01, 7.606095e-01, 7.606225e-01, 7.606355e-01,
    7.606485e-01, 7.606615e-01, 7.606745e-01, 7.606874e-01, 7.607004e-01, 7.607135e-01,
    7.607265e-01, 7.607394e-01, 7.607524e-01, 7.607654e-01, 7.607784e-01, 7.607914e-01,
    7.608044e-01, 7.608173e-01, 7.608303e-01, 7.608433e-01, 7.608563e-01, 7.608694e-01,
    7.608824e-01, 7.608954e-01, 7.609084e-01, 7.609213e-01, 7.609343e-01, 7.609473e-01,
    7.609603e-01, 7.609733e-01, 7.609863e-01, 7.609993e-01, 7.610122e-01, 7.610252e-01,
    7.610382e-01, 7.610512e-01, 7.610642e-01, 7.610772e-01, 7.610902e-01, 7.611032e-01,
    7.611162e-01, 7.611291e-01, 7.611421e-01, 7.611551e-01, 7.611681e-01, 7.611811e-01,
    7.611941e-01, 7.612071e-01, 7.612200e-01, 7.612330e-01, 7.612460e-01, 7.612590e-01,
    7.612720e-01, 7.612850e-01, 7.612979e-01, 7.613109e-01, 7.613239e-01, 7.613369e-01,
    7.613499e-01, 7.613629e-01, 7.613759e-01, 7.613890e-01, 7.614020e-01, 7.614149e-01,
    7.614279e-01, 7.614409e-01, 7.614539e-01, 7.614669e-01, 7.614799e-01, 7.614928e-01,
    7.615058e-01, 7.615188e-01, 7.615318e-01, 7.615448e-01, 7.615578e-01, 7.615708e-01,
    7.615837e-01, 7.615967e-01, 7.616097e-01, 7.616227e-01, 7.616357e-01, 7.616487e-01,
    7.616616e-01, 7.616746e-01, 7.616876e-01, 7.617006e-01, 7.617136e-01, 7.617266e-01,
    7.617396e-01, 7.617525e-01, 7.617655e-01, 7.617785e-01, 7.617915e-01, 7.618045e-01,
    7.618173e-01, 7.618303e-01, 7.618433e-01, 7.618563e-01, 7.618693e-01, 7.618823e-01,
    7.618952e-01, 7.619082e-01, 7.619212e-01, 7.619342e-01, 7.619472e-01, 7.619602e-01,
    7.619732e-01, 7.619861e-01, 7.619991e-01, 7.620121e-01, 7.620251e-01, 7.620381e-01,
    7.620511e-01, 7.620640e-01, 7.620770e-01, 7.620900e-01, 7.621030e-01, 7.621160e-01,
    7.621290e-01, 7.621419e-01, 7.621549e-01, 7.621679e-01, 7.621809e-01, 7.621938e-01,
    7.622068e-01, 7.622198e-01, 7.622328e-01, 7.622458e-01, 7.622588e-01, 7.622718e-01,
    7.622847e-01, 7.622977e-01, 7.623107e-01, 7.623237e-01, 7.623366e-01, 7.623495e-01,
    7.623625e-01, 7.623755e-01, 7.623885e-01, 7.624015e-01, 7.624145e-01, 7.624274e-01,
    7.624404e-01, 7.624534e-01, 7.624664e-01, 7.624794e-01, 7.624923e-01, 7.625053e-01,
    7.625183e-01, 7.625313e-01, 7.625442e-01, 7.625572e-01, 7.625702e-01, 7.625832e-01,
    7.625962e-01, 7.626092e-01, 7.626221e-01, 7.626351e-01, 7.626480e-01, 7.626610e-01,
    7.626740e-01, 7.626870e-01, 7.627000e-01, 7.627130e-01, 7.627259e-01, 7.627388e-01,
    7.627518e-01, 7.627648e-01, 7.627778e-01, 7.627908e-01, 7.628038e-01, 7.628167e-01,
    7.628297e-01, 7.628427e-01, 7.628556e-01, 7.628686e-01, 7.628816e-01, 7.628946e-01,
    7.629076e-01, 7.629206e-01, 7.629334e-01, 7.629464e-01, 7.629594e-01, 7.629724e-01,
    7.629853e-01, 7.629983e-01, 7.630113e-01, 7.630243e-01, 7.630372e-01, 7.630502e-01,
    7.630632e-01, 7.630762e-01, 7.630892e-01, 7.631022e-01, 7.631150e-01, 7.631280e-01,
    7.631410e-01, 7.631540e-01, 7.631670e-01, 7.631800e-01, 7.631929e-01, 7.632059e-01,
    7.632188e-01, 7.632318e-01, 7.632448e-01, 7.632578e-01, 7.632707e-01, 7.632837e-01,
    7.632967e-01, 7.633097e-01, 7.633227e-01, 7.633355e-01, 7.633485e-01, 7.633615e-01,
    7.633745e-01, 7.633875e-01, 7.634004e-01, 7.634134e-01, 7.634264e-01, 7.634393e-01,
    7.634523e-01, 7.634653e-01, 7.634782e-01, 7.634912e-01, 7.635041e-01, 7.635171e-01,
    7.635301e-01, 7.635430e-01, 7.635560e-01, 7.635690e-01, 7.635820e-01, 7.635950e-01,
    7.636079e-01, 7.636209e-01, 7.636338e-01, 7.636468e-01, 7.636598e-01, 7.636727e-01,
    7.636857e-01, 7.636987e-01, 7.637116e-01, 7.637246e-01, 7.637376e-01, 7.637506e-01,
    7.637635e-01, 7.637765e-01, 7.637894e-01, 7.638024e-01, 7.638153e-01, 7.638283e-01,
    7.638413e-01, 7.638542e-01, 7.638672e-01, 7.638802e-01, 7.638931e-01, 7.639061e-01,
    7.639191e-01, 7.639320e-01, 7.639450e-01, 7.639579e-01, 7.639709e-01, 7.639839e-01,
    7.639968e-01, 7.640098e-01, 7.640228e-01, 7.640358e-01, 7.640486e-01, 7.640616e-01,
    7.640746e-01, 7.640876e-01, 7.641005e-01, 7.641135e-01, 7.641265e-01, 7.641395e-01,
    7.641523e-01, 7.641653e-01, 7.641783e-01, 7.641913e-01, 7.642042e-01, 7.642172e-01,
    7.642302e-01, 7.642431e-01, 7.642561e-01, 7.642691e-01, 7.642820e-01, 7.642949e-01,
    7.643079e-01, 7.643209e-01, 7.643338e-01, 7.643468e-01, 7.643598e-01, 7.643728e-01,
    7.643856e-01, 7.643986e-01, 7.644116e-01, 7.644245e-01, 7.644375e-01, 7.644505e-01,
    7.644635e-01, 7.644764e-01, 7.644894e-01, 7.645023e-01, 7.645152e-01, 7.645282e-01,
    7.645412e-01, 7.645541e-01, 7.645671e-01, 7.645801e-01, 7.645930e-01, 7.646060e-01,
    7.646189e-01, 7.646319e-01, 7.646449e-01, 7.646578e-01, 7.646708e-01, 7.646837e-01,
    7.646967e-01, 7.647097e-01, 7.647226e-01, 7.647356e-01, 7.647486e-01, 7.647614e-01,
    7.647744e-01, 7.647874e-01, 7.648003e-01, 7.648133e-01, 7.648263e-01, 7.648392e-01,
    7.648522e-01, 7.648652e-01, 7.648780e-01, 7.648910e-01, 7.649040e-01, 7.649169e-01,
    7.649299e-01, 7.649428e-01, 7.649558e-01, 7.649688e-01, 7.649817e-01, 7.649947e-01,
    7.650076e-01, 7.650205e-01, 7.650335e-01, 7.650465e-01, 7.650594e-01, 7.650724e-01,
    7.650854e-01, 7.650983e-01, 7.651113e-01, 7.651241e-01, 7.651371e-01, 7.651501e-01,
    7.651630e-01, 7.651760e-01, 7.651890e-01, 7.652019e-01, 7.652149e-01, 7.652278e-01,
    7.652407e-01, 7.652537e-01, 7.652667e-01, 7.652797e-01, 7.652926e-01, 7.653055e-01,
    7.653185e-01, 7.653314e-01, 7.653444e-01, 7.653574e-01, 7.653702e-01, 7.653832e-01,
    7.653961e-01, 7.654091e-01, 7.654221e-01, 7.654350e-01, 7.654480e-01, 7.654609e-01,
    7.654739e-01, 7.654868e-01, 7.654998e-01, 7.655128e-01, 7.655256e-01, 7.655386e-01,
    7.655516e-01, 7.655645e-01, 7.655775e-01, 7.655904e-01, 7.656034e-01, 7.656163e-01,
    7.656293e-01, 7.656422e-01, 7.656552e-01, 7.656682e-01, 7.656810e-01, 7.656940e-01,
    7.657069e-01, 7.657199e-01, 7.657329e-01, 7.657458e-01, 7.657588e-01, 7.657717e-01,
    7.657847e-01, 7.657976e-01, 7.658105e-01, 7.658235e-01, 7.658364e-01, 7.658494e-01,
    7.658623e-01, 7.658753e-01, 7.658882e-01, 7.659011e-01, 7.659141e-01, 7.659271e-01,
    7.659400e-01, 7.659529e-01, 7.659659e-01, 7.659788e-01, 7.659918e-01, 7.660047e-01,
    7.660177e-01, 7.660306e-01, 7.660435e-01, 7.660565e-01, 7.660695e-01, 7.660823e-01,
    7.660953e-01, 7.661083e-01, 7.661212e-01, 7.661342e-01, 7.661471e-01, 7.661601e-01,
    7.661730e-01, 7.661860e-01, 7.661989e-01, 7.662119e-01, 7.662247e-01, 7.662377e-01,
    7.662507e-01, 7.662636e-01, 7.662765e-01, 7.662895e-01, 7.663024e-01, 7.663154e-01,
    7.663283e-01, 7.663413e-01, 7.663542e-01, 7.663671e-01, 7.663801e-01, 7.663931e-01,
    7.664059e-01, 7.664189e-01, 7.664318e-01, 7.664448e-01, 7.664577e-01, 7.664707e-01,
    7.664836e-01, 7.664966e-01, 7.665095e-01, 7.665225e-01, 7.665353e-01, 7.665483e-01,
    7.665613e-01, 7.665742e-01, 7.665871e-01, 7.666001e-01, 7.666130e-01, 7.666260e-01,
    7.666389e-01, 7.666519e-01, 7.666648e-01, 7.666777e-01, 7.666907e-01, 7.667035e-01,
    7.667165e-01, 7.667294e-01, 7.667424e-01, 7.667553e-01, 7.667683e-01, 7.667812e-01,
    7.667942e-01, 7.668071e-01, 7.668201e-01, 7.668329e-01, 7.668459e-01, 7.668589e-01,
    7.668718e-01, 7.668847e-01, 7.668976e-01, 7.669106e-01, 7.669235e-01, 7.669365e-01,
    7.669494e-01, 7.669623e-01, 7.669753e-01, 7.669882e-01, 7.670012e-01, 7.670141e-01,
    7.670271e-01, 7.670400e-01, 7.670528e-01, 7.670658e-01, 7.670788e-01, 7.670918e-01,
    7.671046e-01, 7.671176e-01, 7.671305e-01, 7.671434e-01, 7.671564e-01, 7.671693e-01,
    7.671823e-01, 7.671952e-01, 7.672082e-01, 7.672210e-01, 7.672340e-01, 7.672470e-01,
    7.672598e-01, 7.672728e-01, 7.672857e-01, 7.672986e-01, 7.673116e-01, 7.673245e-01,
    7.673375e-01, 7.673504e-01, 7.673633e-01, 7.673762e-01, 7.673892e-01, 7.674022e-01,
    7.674150e-01, 7.674279e-01, 7.674409e-01, 7.674538e-01, 7.674668e-01, 7.674797e-01,
    7.674926e-01, 7.675056e-01, 7.675185e-01, 7.675314e-01, 7.675444e-01, 7.675573e-01,
    7.675703e-01, 7.675832e-01, 7.675961e-01, 7.676091e-01, 7.676219e-01, 7.676349e-01,
    7.676478e-01, 7.676607e-01, 7.676737e-01, 7.676866e-01, 7.676995e-01, 7.677125e-01,
    7.677254e-01, 7.677383e-01, 7.677513e-01, 7.677642e-01, 7.677771e-01, 7.677901e-01,
    7.678030e-01, 7.678159e-01, 7.678288e-01, 7.678418e-01, 7.678548e-01, 7.678676e-01,
    7.678805e-01, 7.678935e-01, 7.679064e-01, 7.679193e-01, 7.679323e-01, 7.679452e-01,
    7.679581e-01, 7.679711e-01, 7.679840e-01, 7.679968e-01, 7.680098e-01, 7.680228e-01,
    7.680357e-01, 7.680486e-01, 7.680615e-01, 7.680745e-01, 7.680874e-01, 7.681003e-01,
    7.681132e-01, 7.681262e-01, 7.681391e-01, 7.681520e-01, 7.681649e-01, 7.681779e-01,
    7.681908e-01, 7.682037e-01, 7.682167e-01, 7.682295e-01, 7.682425e-01, 7.682555e-01,
    7.682683e-01, 7.682812e-01, 7.682942e-01, 7.683071e-01, 7.683200e-01, 7.683329e-01,
    7.683459e-01, 7.683588e-01, 7.683717e-01, 7.683847e-01, 7.683976e-01, 7.684105e-01,
    7.684234e-01, 7.684364e-01, 7.684492e-01, 7.684622e-01, 7.684752e-01, 7.684880e-01,
    7.685009e-01, 7.685139e-01, 7.685269e-01, 7.685397e-01, 7.685526e-01, 7.685656e-01,
    7.685785e-01, 7.685914e-01, 7.686043e-01, 7.686173e-01, 7.686302e-01, 7.686431e-01,
    7.686560e-01, 7.686689e-01, 7.686819e-01, 7.686948e-01, 7.687077e-01, 7.687206e-01,
    7.687336e-01, 7.687464e-01, 7.687594e-01, 7.687724e-01, 7.687852e-01, 7.687981e-01,
    7.688110e-01, 7.688240e-01, 7.688369e-01, 7.688498e-01, 7.688627e-01, 7.688757e-01,
    7.688886e-01, 7.689015e-01, 7.689144e-01, 7.689274e-01, 7.689403e-01, 7.689532e-01,
    7.689661e-01, 7.689791e-01, 7.689919e-01, 7.690049e-01, 7.690178e-01, 7.690306e-01,
    7.690436e-01, 7.690566e-01, 7.690694e-01, 7.690823e-01, 7.690953e-01, 7.691082e-01,
    7.691211e-01, 7.691340e-01, 7.691469e-01, 7.691599e-01, 7.691728e-01, 7.691857e-01,
    7.691986e-01, 7.692115e-01, 7.692245e-01, 7.692374e-01, 7.692503e-01, 7.692631e-01,
    7.692761e-01, 7.692891e-01, 7.693020e-01, 7.693149e-01, 7.693278e-01, 7.693406e-01,
    7.693536e-01, 7.693666e-01, 7.693794e-01, 7.693923e-01, 7.694052e-01, 7.694182e-01,
    7.694311e-01, 7.694440e-01, 7.694569e-01, 7.694698e-01, 7.694827e-01, 7.694957e-01,
    7.695086e-01, 7.695215e-01, 7.695344e-01, 7.695473e-01, 7.695603e-01, 7.695732e-01,
    7.695861e-01, 7.695990e-01, 7.696119e-01, 7.696248e-01, 7.696378e-01, 7.696506e-01,
    7.696636e-01, 7.696764e-01, 7.696893e-01, 7.697023e-01, 7.697151e-01, 7.697281e-01,
    7.697410e-01, 7.697539e-01, 7.697668e-01, 7.697797e-01, 7.697926e-01, 7.698056e-01,
    7.698185e-01, 7.698314e-01, 7.698443e-01, 7.698572e-01, 7.698701e-01, 7.698830e-01,
    7.698959e-01, 7.699089e-01, 7.699218e-01, 7.699347e-01, 7.699476e-01, 7.699605e-01,
    7.699734e-01, 7.699863e-01, 7.699991e-01, 7.700121e-01, 7.700251e-01, 7.700379e-01,
    7.700509e-01, 7.700638e-01, 7.700766e-01, 7.700896e-01, 7.701024e-01, 7.701154e-01,
    7.701283e-01, 7.701412e-01, 7.701541e-01, 7.701671e-01, 7.701799e-01, 7.701928e-01,
    7.702057e-01, 7.702186e-01, 7.702315e-01, 7.702445e-01, 7.702574e-01, 7.702703e-01,
    7.702832e-01, 7.702961e-01, 7.703090e-01, 7.703219e-01, 7.703348e-01, 7.703477e-01,
    7.703606e-01, 7.703735e-01, 7.703865e-01, 7.703994e-01, 7.704123e-01, 7.704252e-01,
    7.704381e-01, 7.704509e-01, 7.704639e-01, 7.704768e-01, 7.704897e-01, 7.705026e-01,
    7.705154e-01, 7.705284e-01, 7.705413e-01, 7.705542e-01, 7.705671e-01, 7.705801e-01,
    7.705929e-01, 7.706059e-01, 7.706187e-01, 7.706316e-01, 7.706445e-01, 7.706574e-01,
    7.706704e-01, 7.706832e-01, 7.706962e-01, 7.707090e-01, 7.707219e-01, 7.707348e-01,
    7.707477e-01, 7.707607e-01, 7.707735e-01, 7.707864e-01, 7.707994e-01, 7.708123e-01,
    7.708252e-01, 7.708381e-01, 7.708510e-01, 7.708639e-01, 7.708768e-01, 7.708897e-01,
    7.709026e-01, 7.709155e-01, 7.709284e-01, 7.709413e-01, 7.709542e-01, 7.709671e-01,
    7.709800e-01, 7.709929e-01, 7.710058e-01, 7.710187e-01, 7.710316e-01, 7.710445e-01,
    7.710574e-01, 7.710703e-01, 7.710832e-01, 7.710961e-01, 7.711090e-01, 7.711219e-01,
    7.711348e-01, 7.711477e-01, 7.711606e-01, 7.711735e-01, 7.711864e-01, 7.711993e-01,
    7.712122e-01, 7.712251e-01, 7.712380e-01, 7.712508e-01, 7.712638e-01, 7.712767e-01,
    7.712896e-01, 7.713025e-01, 7.713153e-01, 7.713283e-01, 7.713411e-01, 7.713541e-01,
    7.713670e-01, 7.713798e-01, 7.713928e-01, 7.714056e-01, 7.714186e-01, 7.714314e-01,
    7.714443e-01, 7.714573e-01, 7.714701e-01, 7.714831e-01, 7.714959e-01, 7.715088e-01,
    7.715217e-01, 7.715346e-01, 7.715476e-01, 7.715604e-01, 7.715732e-01, 7.715861e-01,
    7.715991e-01, 7.716119e-01, 7.716249e-01, 7.716377e-01, 7.716506e-01, 7.716635e-01,
    7.716764e-01, 7.716894e-01, 7.717022e-01, 7.717151e-01, 7.717280e-01, 7.717409e-01,
    7.717538e-01, 7.717667e-01, 7.717796e-01, 7.717925e-01, 7.718054e-01, 7.718182e-01,
    7.718312e-01, 7.718440e-01, 7.718569e-01, 7.718698e-01, 7.718827e-01, 7.718956e-01,
    7.719085e-01, 7.719214e-01, 7.719343e-01, 7.719472e-01, 7.719601e-01, 7.719730e-01,
    7.719859e-01, 7.719987e-01, 7.720116e-01, 7.720245e-01, 7.720374e-01, 7.720503e-01,
    7.720632e-01, 7.720761e-01, 7.720890e-01, 7.721019e-01, 7.721148e-01, 7.721277e-01,
    7.721405e-01, 7.721534e-01, 7.721663e-01, 7.721792e-01, 7.721921e-01, 7.722050e-01,
    7.722179e-01, 7.722308e-01, 7.722437e-01, 7.722566e-01, 7.722694e-01, 7.722823e-01,
    7.722952e-01, 7.723081e-01, 7.723210e-01, 7.723339e-01, 7.723468e-01, 7.723597e-01,
    7.723725e-01, 7.723854e-01, 7.723984e-01, 7.724112e-01, 7.724241e-01, 7.724370e-01,
    7.724499e-01, 7.724627e-01, 7.724757e-01, 7.724885e-01, 7.725014e-01, 7.725143e-01,
    7.725272e-01, 7.725402e-01, 7.725530e-01, 7.725658e-01, 7.725787e-01, 7.725917e-01,
    7.726045e-01, 7.726175e-01, 7.726303e-01, 7.726432e-01, 7.726560e-01, 7.726690e-01,
    7.726818e-01, 7.726948e-01, 7.727076e-01, 7.727205e-01, 7.727333e-01, 7.727463e-01,
    7.727591e-01, 7.727721e-01, 7.727849e-01, 7.727978e-01, 7.728106e-01, 7.728236e-01,
    7.728364e-01, 7.728494e-01, 7.728623e-01, 7.728751e-01, 7.728879e-01, 7.729009e-01,
    7.729138e-01, 7.729267e-01, 7.729396e-01, 7.729524e-01, 7.729653e-01, 7.729782e-01,
    7.729911e-01, 7.730040e-01, 7.730169e-01, 7.730297e-01, 7.730426e-01, 7.730555e-01,
    7.730684e-01, 7.730813e-01, 7.730941e-01, 7.731070e-01, 7.731199e-01, 7.731328e-01,
    7.731457e-01, 7.731585e-01, 7.731714e-01, 7.731843e-01, 7.731972e-01, 7.732101e-01,
    7.732229e-01, 7.732358e-01, 7.732487e-01, 7.732616e-01, 7.732744e-01, 7.732873e-01,
    7.733002e-01, 7.733131e-01, 7.733260e-01, 7.733388e-01, 7.733517e-01, 7.733646e-01,
    7.733775e-01, 7.733904e-01, 7.734032e-01, 7.734161e-01, 7.734290e-01, 7.734419e-01,
    7.734547e-01, 7.734677e-01, 7.734805e-01, 7.734934e-01, 7.735062e-01, 7.735192e-01,
    7.735320e-01, 7.735450e-01, 7.735578e-01, 7.735707e-01, 7.735835e-01, 7.735965e-01,
    7.736093e-01, 7.736222e-01, 7.736351e-01, 7.736480e-01, 7.736608e-01, 7.736737e-01,
    7.736866e-01, 7.736995e-01, 7.737123e-01, 7.737252e-01, 7.737381e-01, 7.737509e-01,
    7.737638e-01, 7.737767e-01, 7.737896e-01, 7.738024e-01, 7.738153e-01, 7.738282e-01,
    7.738411e-01, 7.738539e-01, 7.738668e-01, 7.738797e-01, 7.738925e-01, 7.739054e-01,
    7.739183e-01, 7.739312e-01, 7.739440e-01, 7.739570e-01, 7.739698e-01, 7.739826e-01,
    7.739955e-01, 7.740085e-01, 7.740213e-01, 7.740341e-01, 7.740470e-01, 7.740600e-01,
    7.740728e-01, 7.740856e-01, 7.740986e-01, 7.741114e-01, 7.741243e-01, 7.741371e-01,
    7.741501e-01, 7.741629e-01, 7.741758e-01, 7.741887e-01, 7.742015e-01, 7.742144e-01,
    7.742273e-01, 7.742401e-01, 7.742530e-01, 7.742659e-01, 7.742787e-01, 7.742916e-01,
    7.743045e-01, 7.743173e-01, 7.743302e-01, 7.743431e-01, 7.743559e-01, 7.743688e-01,
    7.743817e-01, 7.743945e-01, 7.744074e-01, 7.744203e-01, 7.744331e-01, 7.744461e-01,
    7.744589e-01, 7.744718e-01, 7.744846e-01, 7.744976e-01, 7.745104e-01, 7.745233e-01,
    7.745362e-01, 7.745489e-01, 7.745619e-01, 7.745748e-01, 7.745876e-01, 7.746005e-01,
    7.746134e-01, 7.746262e-01, 7.746391e-01, 7.746520e-01, 7.746648e-01, 7.746777e-01,
    7.746905e-01, 7.747034e-01, 7.747163e-01, 7.747291e-01, 7.747420e-01, 7.747549e-01,
    7.747678e-01, 7.747806e-01, 7.747934e-01, 7.748063e-01, 7.748193e-01, 7.748321e-01,
    7.748449e-01, 7.748579e-01, 7.748707e-01, 7.748836e-01, 7.748964e-01, 7.749093e-01,
    7.749222e-01, 7.749350e-01, 7.749479e-01, 7.749607e-01, 7.749736e-01, 7.749865e-01,
    7.749993e-01, 7.750122e-01, 7.750251e-01, 7.750379e-01, 7.750508e-01, 7.750636e-01,
    7.750765e-01, 7.750894e-01, 7.751023e-01, 7.751151e-01, 7.751279e-01, 7.751409e-01,
    7.751536e-01, 7.751666e-01, 7.751794e-01, 7.751923e-01, 7.752052e-01, 7.752180e-01,
    7.752309e-01, 7.752438e-01, 7.752566e-01, 7.752695e-01, 7.752823e-01, 7.752952e-01,
    7.753080e-01, 7.753209e-01, 7.753338e-01, 7.753466e-01, 7.753595e-01, 7.753723e-01,
    7.753853e-01, 7.753981e-01, 7.754110e-01, 7.754238e-01, 7.754366e-01, 7.754496e-01,
    7.754624e-01, 7.754753e-01, 7.754881e-01, 7.755010e-01, 7.755138e-01, 7.755267e-01,
    7.755395e-01, 7.755524e-01, 7.755653e-01, 7.755781e-01, 7.755910e-01, 7.756038e-01,
    7.756167e-01, 7.756295e-01, 7.756425e-01, 7.756553e-01, 7.756681e-01, 7.756810e-01,
    7.756939e-01, 7.757066e-01, 7.757196e-01, 7.757325e-01, 7.757453e-01, 7.757582e-01,
    7.757710e-01, 7.757839e-01, 7.757967e-01, 7.758096e-01, 7.758224e-01, 7.758353e-01,
    7.758482e-01, 7.758610e-01, 7.758738e-01, 7.758867e-01, 7.758995e-01, 7.759125e-01,
    7.759253e-01, 7.759382e-01, 7.759510e-01, 7.759639e-01, 7.759767e-01, 7.759896e-01,
    7.760024e-01, 7.760153e-01, 7.760281e-01, 7.760410e-01, 7.760538e-01, 7.760667e-01,
    7.760795e-01, 7.760924e-01, 7.761052e-01, 7.761182e-01, 7.761310e-01, 7.761438e-01,
    7.761567e-01, 7.761695e-01, 7.761824e-01, 7.761953e-01, 7.762081e-01, 7.762210e-01,
    7.762338e-01, 7.762467e-01, 7.762595e-01, 7.762724e-01, 7.762852e-01, 7.762980e-01,
    7.763109e-01, 7.763237e-01, 7.763367e-01, 7.763495e-01, 7.763624e-01, 7.763752e-01,
    7.763880e-01, 7.764009e-01, 7.764138e-01, 7.764266e-01, 7.764395e-01, 7.764523e-01,
    7.764651e-01, 7.764780e-01, 7.764908e-01, 7.765037e-01, 7.765166e-01, 7.765294e-01,
    7.765422e-01, 7.765552e-01, 7.765680e-01, 7.765808e-01, 7.765937e-01, 7.766065e-01,
    7.766194e-01, 7.766322e-01, 7.766451e-01, 7.766579e-01, 7.766708e-01, 7.766836e-01,
    7.766964e-01, 7.767093e-01, 7.767221e-01, 7.767351e-01, 7.767479e-01, 7.767607e-01,
    7.767736e-01, 7.767864e-01, 7.767993e-01, 7.768121e-01, 7.768250e-01, 7.768378e-01,
    7.768506e-01, 7.768635e-01, 7.768763e-01, 7.768892e-01, 7.769020e-01, 7.769148e-01,
    7.769278e-01, 7.769406e-01, 7.769535e-01, 7.769663e-01, 7.769791e-01, 7.769920e-01,
    7.770048e-01, 7.770177e-01, 7.770305e-01, 7.770433e-01, 7.770562e-01, 7.770690e-01,
    7.770819e-01, 7.770947e-01, 7.771075e-01, 7.771205e-01, 7.771333e-01, 7.771462e-01,
    7.771590e-01, 7.771718e-01, 7.771847e-01, 7.771975e-01, 7.772103e-01, 7.772232e-01,
    7.772360e-01, 7.772489e-01, 7.772617e-01, 7.772745e-01, 7.772875e-01, 7.773002e-01,
    7.773131e-01, 7.773260e-01, 7.773388e-01, 7.773516e-01, 7.773645e-01, 7.773773e-01,
    7.773902e-01, 7.774031e-01, 7.774158e-01, 7.774287e-01, 7.774416e-01, 7.774544e-01,
    7.774673e-01, 7.774801e-01, 7.774929e-01, 7.775058e-01, 7.775186e-01, 7.775314e-01,
    7.775443e-01, 7.775571e-01, 7.775699e-01, 7.775828e-01, 7.775956e-01, 7.776085e-01,
    7.776214e-01, 7.776341e-01, 7.776470e-01, 7.776599e-01, 7.776727e-01, 7.776855e-01,
    7.776984e-01, 7.777112e-01, 7.777240e-01, 7.777369e-01, 7.777497e-01, 7.777625e-01,
    7.777755e-01, 7.777883e-01, 7.778011e-01, 7.778140e-01, 7.778268e-01, 7.778396e-01,
    7.778524e-01, 7.778653e-01, 7.778781e-01, 7.778909e-01, 7.779039e-01, 7.779167e-01,
    7.779295e-01, 7.779424e-01, 7.779552e-01, 7.779680e-01, 7.779808e-01, 7.779937e-01,
    7.780065e-01, 7.780193e-01, 7.780322e-01, 7.780451e-01, 7.780579e-01, 7.780707e-01,
    7.780836e-01, 7.780964e-01, 7.781092e-01, 7.781221e-01, 7.781349e-01, 7.781477e-01,
    7.781605e-01, 7.781734e-01, 7.781863e-01, 7.781991e-01, 7.782120e-01, 7.782248e-01,
    7.782376e-01, 7.782504e-01, 7.782633e-01, 7.782761e-01, 7.782889e-01, 7.783017e-01,
    7.783147e-01, 7.783274e-01, 7.783402e-01, 7.783530e-01, 7.783660e-01, 7.783788e-01,
    7.783916e-01, 7.784044e-01, 7.784173e-01, 7.784301e-01, 7.784429e-01, 7.784557e-01,
    7.784686e-01, 7.784814e-01, 7.784942e-01, 7.785071e-01, 7.785200e-01, 7.785328e-01,
    7.785456e-01, 7.785584e-01, 7.785713e-01, 7.785841e-01, 7.785969e-01, 7.786098e-01,
    7.786226e-01, 7.786354e-01, 7.786483e-01, 7.786611e-01, 7.786739e-01, 7.786868e-01,
    7.786996e-01, 7.787124e-01, 7.787252e-01, 7.787381e-01, 7.787510e-01, 7.787638e-01,
    7.787766e-01, 7.787894e-01, 7.788023e-01, 7.788151e-01, 7.788279e-01, 7.788407e-01,
    7.788535e-01, 7.788664e-01, 7.788792e-01, 7.788920e-01, 7.789049e-01, 7.789177e-01,
    7.789306e-01, 7.789434e-01, 7.789562e-01, 7.789690e-01, 7.789818e-01, 7.789947e-01,
    7.790076e-01, 7.790204e-01, 7.790332e-01, 7.790460e-01, 7.790589e-01, 7.790717e-01,
    7.790845e-01, 7.790973e-01, 7.791101e-01, 7.791229e-01, 7.791358e-01, 7.791486e-01,
    7.791615e-01, 7.791743e-01, 7.791871e-01, 7.791999e-01, 7.792128e-01, 7.792256e-01,
    7.792384e-01, 7.792512e-01, 7.792640e-01, 7.792768e-01, 7.792898e-01, 7.793026e-01,
    7.793154e-01, 7.793282e-01, 7.793410e-01, 7.793538e-01, 7.793667e-01, 7.793795e-01,
    7.793924e-01, 7.794052e-01, 7.794180e-01, 7.794308e-01, 7.794436e-01, 7.794565e-01,
    7.794693e-01, 7.794821e-01, 7.794949e-01, 7.795078e-01, 7.795206e-01, 7.795334e-01,
    7.795463e-01, 7.795591e-01, 7.795719e-01, 7.795847e-01, 7.795975e-01, 7.796103e-01,
    7.796232e-01, 7.796360e-01, 7.796488e-01, 7.796617e-01, 7.796745e-01, 7.796873e-01,
    7.797001e-01, 7.797129e-01, 7.797257e-01, 7.797385e-01, 7.797515e-01, 7.797642e-01,
    7.797771e-01, 7.797899e-01, 7.798027e-01, 7.798155e-01, 7.798283e-01, 7.798411e-01,
    7.798539e-01, 7.798668e-01, 7.798797e-01, 7.798925e-01, 7.799053e-01, 7.799181e-01,
    7.799309e-01, 7.799437e-01, 7.799565e-01, 7.799693e-01, 7.799821e-01, 7.799950e-01,
    7.800078e-01, 7.800207e-01, 7.800335e-01, 7.800463e-01, 7.800591e-01, 7.800719e-01,
    7.800847e-01, 7.800975e-01, 7.801104e-01, 7.801232e-01, 7.801360e-01, 7.801488e-01,
    7.801616e-01, 7.801744e-01, 7.801874e-01, 7.802001e-01, 7.802129e-01, 7.802258e-01,
    7.802386e-01, 7.802514e-01, 7.802642e-01, 7.802770e-01, 7.802898e-01, 7.803026e-01,
    7.803155e-01, 7.803283e-01, 7.803411e-01, 7.803539e-01, 7.803667e-01, 7.803795e-01,
    7.803923e-01, 7.804052e-01, 7.804180e-01, 7.804309e-01, 7.804437e-01, 7.804565e-01,
    7.804693e-01, 7.804821e-01, 7.804949e-01, 7.805077e-01, 7.805206e-01, 7.805334e-01,
    7.805462e-01, 7.805590e-01, 7.805718e-01, 7.805846e-01, 7.805974e-01, 7.806103e-01,
    7.806231e-01, 7.806359e-01, 7.806487e-01, 7.806615e-01, 7.806743e-01, 7.806871e-01,
    7.806999e-01, 7.807127e-01, 7.807255e-01, 7.807384e-01, 7.807512e-01, 7.807640e-01,
    7.807768e-01, 7.807896e-01, 7.808024e-01, 7.808152e-01, 7.808281e-01, 7.808409e-01,
    7.808537e-01, 7.808665e-01, 7.808793e-01, 7.808921e-01, 7.809049e-01, 7.809178e-01,
    7.809306e-01, 7.809434e-01, 7.809562e-01, 7.809690e-01, 7.809818e-01, 7.809947e-01,
    7.810075e-01, 7.810202e-01, 7.810330e-01, 7.810459e-01, 7.810587e-01, 7.810715e-01,
    7.810843e-01, 7.810971e-01, 7.811099e-01, 7.811227e-01, 7.811356e-01, 7.811484e-01,
    7.811612e-01, 7.811740e-01, 7.811868e-01, 7.811996e-01, 7.812124e-01, 7.812253e-01,
    7.812381e-01, 7.812509e-01, 7.812636e-01, 7.812764e-01, 7.812892e-01, 7.813020e-01,
    7.813148e-01, 7.813277e-01, 7.813405e-01, 7.813533e-01, 7.813661e-01, 7.813789e-01,
    7.813917e-01, 7.814046e-01, 7.814174e-01, 7.814302e-01, 7.814430e-01, 7.814558e-01,
    7.814686e-01, 7.814814e-01, 7.814941e-01, 7.815070e-01, 7.815198e-01, 7.815326e-01,
    7.815454e-01, 7.815582e-01, 7.815710e-01, 7.815838e-01, 7.815967e-01, 7.816095e-01,
    7.816223e-01, 7.816351e-01, 7.816479e-01, 7.816606e-01, 7.816734e-01, 7.816862e-01,
    7.816991e-01, 7.817119e-01, 7.817247e-01, 7.817375e-01, 7.817503e-01, 7.817631e-01,
    7.817760e-01, 7.817888e-01, 7.818015e-01, 7.818143e-01, 7.818271e-01, 7.818399e-01,
    7.818527e-01, 7.818655e-01, 7.818784e-01, 7.818912e-01, 7.819040e-01, 7.819167e-01,
    7.819296e-01, 7.819423e-01, 7.819551e-01, 7.819679e-01, 7.819808e-01, 7.819936e-01,
    7.820064e-01, 7.820192e-01, 7.820320e-01, 7.820448e-01, 7.820576e-01, 7.820704e-01,
    7.820832e-01, 7.820960e-01, 7.821088e-01, 7.821217e-01, 7.821344e-01, 7.821472e-01,
    7.821600e-01, 7.821728e-01, 7.821856e-01, 7.821984e-01, 7.822112e-01, 7.822239e-01,
    7.822368e-01, 7.822496e-01, 7.822624e-01, 7.822752e-01, 7.822880e-01, 7.823008e-01,
    7.823136e-01, 7.823264e-01, 7.823392e-01, 7.823520e-01, 7.823648e-01, 7.823776e-01,
    7.823904e-01, 7.824032e-01, 7.824160e-01, 7.824288e-01, 7.824416e-01, 7.824544e-01,
    7.824671e-01, 7.824799e-01, 7.824928e-01, 7.825056e-01, 7.825184e-01, 7.825312e-01,
    7.825440e-01, 7.825568e-01, 7.825696e-01, 7.825823e-01, 7.825952e-01, 7.826079e-01,
    7.826207e-01, 7.826335e-01, 7.826464e-01, 7.826592e-01, 7.826720e-01, 7.826847e-01,
    7.826975e-01, 7.827103e-01, 7.827231e-01, 7.827359e-01, 7.827487e-01, 7.827615e-01,
    7.827743e-01, 7.827871e-01, 7.827999e-01, 7.828127e-01, 7.828255e-01, 7.828383e-01,
    7.828511e-01, 7.828639e-01, 7.828766e-01, 7.828894e-01, 7.829022e-01, 7.829151e-01,
    7.829278e-01, 7.829406e-01, 7.829534e-01, 7.829663e-01, 7.829791e-01, 7.829918e-01,
    7.830046e-01, 7.830174e-01, 7.830302e-01, 7.830430e-01, 7.830558e-01, 7.830685e-01,
    7.830814e-01, 7.830942e-01, 7.831069e-01, 7.831197e-01, 7.831326e-01, 7.831454e-01,
    7.831581e-01, 7.831709e-01, 7.831837e-01, 7.831965e-01, 7.832093e-01, 7.832221e-01,
    7.832349e-01, 7.832477e-01, 7.832604e-01, 7.832732e-01, 7.832860e-01, 7.832989e-01,
    7.833116e-01, 7.833244e-01, 7.833372e-01, 7.833500e-01, 7.833627e-01, 7.833756e-01,
    7.833884e-01, 7.834012e-01, 7.834139e-01, 7.834267e-01, 7.834395e-01, 7.834523e-01,
    7.834651e-01, 7.834779e-01, 7.834907e-01, 7.835034e-01, 7.835162e-01, 7.835290e-01,
    7.835419e-01, 7.835546e-01, 7.835674e-01, 7.835802e-01, 7.835929e-01, 7.836058e-01,
    7.836186e-01, 7.836314e-01, 7.836441e-01, 7.836569e-01, 7.836697e-01, 7.836825e-01,
    7.836953e-01, 7.837081e-01, 7.837209e-01, 7.837336e-01, 7.837464e-01, 7.837592e-01,
    7.837720e-01, 7.837848e-01, 7.837976e-01, 7.838103e-01, 7.838231e-01, 7.838359e-01,
    7.838488e-01, 7.838615e-01, 7.838743e-01, 7.838871e-01, 7.838998e-01, 7.839127e-01,
    7.839255e-01, 7.839382e-01, 7.839510e-01, 7.839638e-01, 7.839766e-01, 7.839894e-01,
    7.840022e-01, 7.840149e-01, 7.840277e-01, 7.840405e-01, 7.840533e-01, 7.840661e-01,
    7.840789e-01, 7.840916e-01, 7.841044e-01, 7.841172e-01, 7.841300e-01, 7.841428e-01,
    7.841556e-01, 7.841683e-01, 7.841811e-01, 7.841939e-01, 7.842067e-01, 7.842195e-01,
    7.842323e-01, 7.842450e-01, 7.842578e-01, 7.842706e-01, 7.842833e-01, 7.842962e-01,
    7.843089e-01, 7.843217e-01, 7.843345e-01, 7.843472e-01, 7.843601e-01, 7.843729e-01,
    7.843856e-01, 7.843984e-01, 7.844113e-01, 7.844239e-01, 7.844368e-01, 7.844495e-01,
    7.844623e-01, 7.844751e-01, 7.844878e-01, 7.845007e-01, 7.845135e-01, 7.845262e-01,
    7.845390e-01, 7.845517e-01, 7.845646e-01, 7.845774e-01, 7.845901e-01, 7.846029e-01,
    7.846156e-01, 7.846285e-01, 7.846413e-01, 7.846540e-01, 7.846668e-01, 7.846795e-01,
    7.846923e-01, 7.847052e-01, 7.847179e-01, 7.847307e-01, 7.847434e-01, 7.847562e-01,
    7.847691e-01, 7.847818e-01, 7.847946e-01, 7.848073e-01, 7.848201e-01, 7.848330e-01,
    7.848457e-01, 7.848585e-01, 7.848712e-01, 7.848840e-01, 7.848969e-01, 7.849095e-01,
    7.849224e-01, 7.849351e-01, 7.849479e-01, 7.849606e-01, 7.849734e-01, 7.849863e-01,
    7.849990e-01, 7.850118e-01, 7.850245e-01, 7.850373e-01, 7.850500e-01, 7.850628e-01,
    7.850757e-01, 7.850884e-01, 7.851012e-01, 7.851139e-01, 7.851267e-01, 7.851395e-01,
    7.851523e-01, 7.851650e-01, 7.851778e-01, 7.851906e-01, 7.852034e-01, 7.852162e-01,
    7.852289e-01, 7.852417e-01, 7.852545e-01, 7.852673e-01, 7.852800e-01, 7.852928e-01,
    7.853056e-01, 7.853184e-01, 7.853312e-01, 7.853439e-01, 7.853567e-01, 7.853695e-01,
    7.853823e-01, 7.853950e-01, 7.854078e-01, 7.854205e-01, 7.854334e-01, 7.854460e-01,
    7.854589e-01, 7.854716e-01, 7.854844e-01, 7.854971e-01, 7.855099e-01, 7.855227e-01,
    7.855355e-01, 7.855482e-01, 7.855610e-01, 7.855738e-01, 7.855865e-01, 7.855993e-01,
    7.856121e-01, 7.856249e-01, 7.856376e-01, 7.856504e-01, 7.856632e-01, 7.856760e-01,
    7.856887e-01, 7.857015e-01, 7.857143e-01, 7.857271e-01, 7.857398e-01, 7.857526e-01,
    7.857653e-01, 7.857780e-01, 7.857909e-01, 7.858036e-01, 7.858164e-01, 7.858291e-01,
    7.858419e-01, 7.858547e-01, 7.858675e-01, 7.858802e-01, 7.858930e-01, 7.859058e-01,
    7.859186e-01, 7.859313e-01, 7.859441e-01, 7.859569e-01, 7.859697e-01, 7.859824e-01,
    7.859952e-01, 7.860079e-01, 7.860208e-01, 7.860335e-01, 7.860462e-01, 7.860590e-01,
    7.860717e-01, 7.860845e-01, 7.860973e-01, 7.861101e-01, 7.861228e-01, 7.861356e-01,
    7.861484e-01, 7.861612e-01, 7.861739e-01, 7.861866e-01, 7.861995e-01, 7.862121e-01,
    7.862250e-01, 7.862377e-01, 7.862505e-01, 7.862632e-01, 7.862760e-01, 7.862888e-01,
    7.863015e-01, 7.863143e-01, 7.863271e-01, 7.863398e-01, 7.863526e-01, 7.863654e-01,
    7.863781e-01, 7.863908e-01, 7.864037e-01, 7.864164e-01, 7.864292e-01, 7.864419e-01,
    7.864547e-01, 7.864674e-01, 7.864802e-01, 7.864930e-01, 7.865057e-01, 7.865185e-01,
    7.865313e-01, 7.865441e-01, 7.865568e-01, 7.865695e-01, 7.865824e-01, 7.865950e-01,
    7.866079e-01, 7.866206e-01, 7.866333e-01, 7.866461e-01, 7.866589e-01, 7.866717e-01,
    7.866844e-01, 7.866971e-01, 7.867100e-01, 7.867227e-01, 7.867355e-01, 7.867482e-01,
    7.867609e-01, 7.867737e-01, 7.867865e-01, 7.867992e-01, 7.868120e-01, 7.868248e-01,
    7.868376e-01, 7.868503e-01, 7.868630e-01, 7.868758e-01, 7.868885e-01, 7.869014e-01,
    7.869141e-01, 7.869268e-01, 7.869396e-01, 7.869524e-01, 7.869651e-01, 7.869779e-01,
    7.869906e-01, 7.870033e-01, 7.870162e-01, 7.870289e-01, 7.870417e-01, 7.870544e-01,
    7.870672e-01, 7.870800e-01, 7.870927e-01, 7.871054e-01, 7.871183e-01, 7.871310e-01,
    7.871437e-01, 7.871565e-01, 7.871692e-01, 7.871820e-01, 7.871948e-01, 7.872075e-01,
    7.872202e-01, 7.872331e-01, 7.872458e-01, 7.872585e-01, 7.872713e-01, 7.872840e-01,
    7.872968e-01, 7.873096e-01, 7.873223e-01, 7.873350e-01, 7.873479e-01, 7.873605e-01,
    7.873733e-01, 7.873861e-01, 7.873988e-01, 7.874116e-01, 7.874244e-01, 7.874371e-01,
    7.874498e-01, 7.874627e-01, 7.874753e-01, 7.874881e-01, 7.875009e-01, 7.875136e-01,
    7.875264e-01, 7.875392e-01, 7.875519e-01, 7.875646e-01, 7.875775e-01, 7.875901e-01,
    7.876029e-01, 7.876156e-01, 7.876284e-01, 7.876412e-01, 7.876539e-01, 7.876667e-01,
    7.876794e-01, 7.876921e-01, 7.877049e-01, 7.877177e-01, 7.877304e-01, 7.877432e-01,
    7.877560e-01, 7.877687e-01, 7.877814e-01, 7.877942e-01, 7.878069e-01, 7.878197e-01,
    7.878324e-01, 7.878452e-01, 7.878579e-01, 7.878706e-01, 7.878834e-01, 7.878962e-01,
    7.879089e-01, 7.879217e-01, 7.879345e-01, 7.879472e-01, 7.879599e-01, 7.879726e-01,
    7.879854e-01, 7.879982e-01, 7.880109e-01, 7.880237e-01, 7.880365e-01, 7.880492e-01,
    7.880619e-01, 7.880746e-01, 7.880874e-01, 7.881002e-01, 7.881129e-01, 7.881256e-01,
    7.881384e-01, 7.881511e-01, 7.881639e-01, 7.881766e-01, 7.881894e-01, 7.882022e-01,
    7.882149e-01, 7.882276e-01, 7.882404e-01, 7.882531e-01, 7.882659e-01, 7.882786e-01,
    7.882914e-01, 7.883042e-01, 7.883168e-01, 7.883296e-01, 7.883424e-01, 7.883551e-01,
    7.883679e-01, 7.883806e-01, 7.883933e-01, 7.884061e-01, 7.884189e-01, 7.884316e-01,
    7.884443e-01, 7.884570e-01, 7.884699e-01, 7.884826e-01, 7.884953e-01, 7.885081e-01,
    7.885208e-01, 7.885336e-01, 7.885463e-01, 7.885590e-01, 7.885718e-01, 7.885846e-01,
    7.885973e-01, 7.886100e-01, 7.886227e-01, 7.886355e-01, 7.886483e-01, 7.886610e-01,
    7.886738e-01, 7.886865e-01, 7.886992e-01, 7.887119e-01, 7.887247e-01, 7.887375e-01,
    7.887502e-01, 7.887629e-01, 7.887756e-01, 7.887884e-01, 7.888012e-01, 7.888139e-01,
    7.888266e-01, 7.888393e-01, 7.888521e-01, 7.888649e-01, 7.888776e-01, 7.888904e-01,
    7.889031e-01, 7.889158e-01, 7.889285e-01, 7.889413e-01, 7.889541e-01, 7.889668e-01,
    7.889795e-01, 7.889922e-01, 7.890050e-01, 7.890178e-01, 7.890305e-01, 7.890432e-01,
    7.890559e-01, 7.890687e-01, 7.890814e-01, 7.890942e-01, 7.891070e-01, 7.891197e-01,
    7.891324e-01, 7.891452e-01, 7.891579e-01, 7.891706e-01, 7.891834e-01, 7.891961e-01,
    7.892089e-01, 7.892216e-01, 7.892343e-01, 7.892470e-01, 7.892598e-01, 7.892725e-01,
    7.892853e-01, 7.892981e-01, 7.893108e-01, 7.893235e-01, 7.893362e-01, 7.893490e-01,
    7.893617e-01, 7.893744e-01, 7.893872e-01, 7.893999e-01, 7.894127e-01, 7.894254e-01,
    7.894381e-01, 7.894508e-01, 7.894636e-01, 7.894763e-01, 7.894891e-01, 7.895018e-01,
    7.895145e-01, 7.895273e-01, 7.895400e-01, 7.895527e-01, 7.895654e-01, 7.895782e-01,
    7.895909e-01, 7.896037e-01, 7.896165e-01, 7.896292e-01, 7.896419e-01, 7.896546e-01,
    7.896674e-01, 7.896801e-01, 7.896928e-01, 7.897056e-01, 7.897183e-01, 7.897310e-01,
    7.897437e-01, 7.897565e-01, 7.897693e-01, 7.897820e-01, 7.897947e-01, 7.898074e-01,
    7.898202e-01, 7.898329e-01, 7.898456e-01, 7.898583e-01, 7.898711e-01, 7.898838e-01,
    7.898965e-01, 7.899092e-01, 7.899220e-01, 7.899348e-01, 7.899475e-01, 7.899603e-01,
    7.899730e-01, 7.899857e-01, 7.899984e-01, 7.900112e-01, 7.900239e-01, 7.900366e-01,
    7.900493e-01, 7.900621e-01, 7.900748e-01, 7.900875e-01, 7.901003e-01, 7.901130e-01,
    7.901257e-01, 7.901384e-01, 7.901512e-01, 7.901639e-01, 7.901766e-01, 7.901894e-01,
    7.902021e-01, 7.902149e-01, 7.902276e-01, 7.902403e-01, 7.902530e-01, 7.902658e-01,
    7.902785e-01, 7.902912e-01, 7.903039e-01, 7.903167e-01, 7.903294e-01, 7.903422e-01,
    7.903548e-01, 7.903676e-01, 7.903803e-01, 7.903931e-01, 7.904058e-01, 7.904185e-01,
    7.904312e-01, 7.904440e-01, 7.904567e-01, 7.904694e-01, 7.904822e-01, 7.904949e-01,
    7.905076e-01, 7.905203e-01, 7.905331e-01, 7.905458e-01, 7.905585e-01, 7.905712e-01,
    7.905840e-01, 7.905967e-01, 7.906094e-01, 7.906221e-01, 7.906349e-01, 7.906476e-01,
    7.906603e-01, 7.906730e-01, 7.906858e-01, 7.906985e-01, 7.907112e-01, 7.907239e-01,
    7.907367e-01, 7.907494e-01, 7.907621e-01, 7.907748e-01, 7.907876e-01, 7.908003e-01,
    7.908130e-01, 7.908258e-01, 7.908385e-01, 7.908512e-01, 7.908639e-01, 7.908767e-01,
    7.908894e-01, 7.909021e-01, 7.909148e-01, 7.909275e-01, 7.909402e-01, 7.909529e-01,
    7.909657e-01, 7.909784e-01, 7.909911e-01, 7.910038e-01, 7.910166e-01, 7.910293e-01,
    7.910420e-01, 7.910547e-01, 7.910675e-01, 7.910802e-01, 7.910929e-01, 7.911057e-01,
    7.911184e-01, 7.911311e-01, 7.911438e-01, 7.911566e-01, 7.911692e-01, 7.911819e-01,
    7.911947e-01, 7.912074e-01, 7.912201e-01, 7.912328e-01, 7.912456e-01, 7.912583e-01,
    7.912710e-01, 7.912837e-01, 7.912965e-01, 7.913092e-01, 7.913219e-01, 7.913346e-01,
    7.913473e-01, 7.913600e-01, 7.913728e-01, 7.913855e-01, 7.913982e-01, 7.914109e-01,
    7.914237e-01, 7.914364e-01, 7.914491e-01, 7.914618e-01, 7.914746e-01, 7.914872e-01,
    7.914999e-01, 7.915127e-01, 7.915254e-01, 7.915381e-01, 7.915508e-01, 7.915636e-01,
    7.915763e-01, 7.915890e-01, 7.916017e-01, 7.916144e-01, 7.916271e-01, 7.916399e-01,
    7.916526e-01, 7.916653e-01, 7.916780e-01, 7.916908e-01, 7.917035e-01, 7.917162e-01,
    7.917289e-01, 7.917415e-01, 7.917543e-01, 7.917670e-01, 7.917798e-01, 7.917925e-01,
    7.918052e-01, 7.918179e-01, 7.918305e-01, 7.918433e-01, 7.918560e-01, 7.918687e-01,
    7.918815e-01, 7.918942e-01, 7.919070e-01, 7.919196e-01, 7.919323e-01, 7.919450e-01,
    7.919577e-01, 7.919705e-01, 7.919832e-01, 7.919959e-01, 7.920086e-01, 7.920213e-01,
    7.920340e-01, 7.920467e-01, 7.920595e-01, 7.920722e-01, 7.920848e-01, 7.920976e-01,
    7.921103e-01, 7.921230e-01, 7.921358e-01, 7.921485e-01, 7.921612e-01, 7.921739e-01,
    7.921866e-01, 7.921993e-01, 7.922120e-01, 7.922248e-01, 7.922375e-01, 7.922501e-01,
    7.922629e-01, 7.922755e-01, 7.922883e-01, 7.923010e-01, 7.923137e-01, 7.923264e-01,
    7.923391e-01, 7.923518e-01, 7.923646e-01, 7.923773e-01, 7.923899e-01, 7.924027e-01,
    7.924154e-01, 7.924281e-01, 7.924408e-01, 7.924535e-01, 7.924662e-01, 7.924789e-01,
    7.924917e-01, 7.925044e-01, 7.925170e-01, 7.925298e-01, 7.925425e-01, 7.925552e-01,
    7.925680e-01, 7.925806e-01, 7.925933e-01, 7.926061e-01, 7.926188e-01, 7.926315e-01,
    7.926441e-01, 7.926568e-01, 7.926696e-01, 7.926823e-01, 7.926949e-01, 7.927077e-01,
    7.927204e-01, 7.927331e-01, 7.927458e-01, 7.927585e-01, 7.927712e-01, 7.927840e-01,
    7.927967e-01, 7.928093e-01, 7.928221e-01, 7.928348e-01, 7.928475e-01, 7.928602e-01,
    7.928728e-01, 7.928856e-01, 7.928983e-01, 7.929109e-01, 7.929237e-01, 7.929364e-01,
    7.929491e-01, 7.929619e-01, 7.929745e-01, 7.929872e-01, 7.930000e-01, 7.930127e-01,
    7.930253e-01, 7.930381e-01, 7.930508e-01, 7.930634e-01, 7.930762e-01, 7.930889e-01,
    7.931016e-01, 7.931142e-01, 7.931270e-01, 7.931397e-01, 7.931525e-01, 7.931651e-01,
    7.931778e-01, 7.931905e-01, 7.932032e-01, 7.932159e-01, 7.932286e-01, 7.932413e-01,
    7.932540e-01, 7.932667e-01, 7.932794e-01, 7.932922e-01, 7.933048e-01, 7.933176e-01,
    7.933303e-01, 7.933429e-01, 7.933556e-01, 7.933683e-01, 7.933811e-01, 7.933937e-01,
    7.934064e-01, 7.934192e-01, 7.934318e-01, 7.934445e-01, 7.934573e-01, 7.934700e-01,
    7.934827e-01, 7.934954e-01, 7.935081e-01, 7.935207e-01, 7.935334e-01, 7.935462e-01,
    7.935588e-01, 7.935715e-01, 7.935843e-01, 7.935970e-01, 7.936096e-01, 7.936224e-01,
    7.936351e-01, 7.936477e-01, 7.936605e-01, 7.936732e-01, 7.936859e-01, 7.936985e-01,
    7.937113e-01, 7.937239e-01, 7.937366e-01, 7.937494e-01, 7.937620e-01, 7.937747e-01,
    7.937875e-01, 7.938001e-01, 7.938128e-01, 7.938256e-01, 7.938382e-01, 7.938510e-01,
    7.938637e-01, 7.938763e-01, 7.938890e-01, 7.939017e-01, 7.939144e-01, 7.939271e-01,
    7.939398e-01, 7.939525e-01, 7.939652e-01, 7.939779e-01, 7.939906e-01, 7.940033e-01,
    7.940159e-01, 7.940287e-01, 7.940414e-01, 7.940540e-01, 7.940668e-01, 7.940795e-01,
    7.940921e-01, 7.941049e-01, 7.941176e-01, 7.941302e-01, 7.941430e-01, 7.941556e-01,
    7.941684e-01, 7.941810e-01, 7.941937e-01, 7.942064e-01, 7.942191e-01, 7.942318e-01,
    7.942445e-01, 7.942572e-01, 7.942699e-01, 7.942826e-01, 7.942953e-01, 7.943079e-01,
    7.943207e-01, 7.943333e-01, 7.943461e-01, 7.943587e-01, 7.943714e-01, 7.943842e-01,
    7.943968e-01, 7.944095e-01, 7.944221e-01, 7.944349e-01, 7.944476e-01, 7.944603e-01,
    7.944730e-01, 7.944856e-01, 7.944984e-01, 7.945111e-01, 7.945237e-01, 7.945365e-01,
    7.945491e-01, 7.945618e-01, 7.945746e-01, 7.945872e-01, 7.945999e-01, 7.946126e-01,
    7.946253e-01, 7.946380e-01, 7.946507e-01, 7.946634e-01, 7.946760e-01, 7.946888e-01,
    7.947014e-01, 7.947141e-01, 7.947268e-01, 7.947395e-01, 7.947522e-01, 7.947649e-01,
    7.947776e-01, 7.947902e-01, 7.948030e-01, 7.948157e-01, 7.948283e-01, 7.948411e-01,
    7.948537e-01, 7.948664e-01, 7.948790e-01, 7.948918e-01, 7.949044e-01, 7.949172e-01,
    7.949299e-01, 7.949425e-01, 7.949553e-01, 7.949679e-01, 7.949806e-01, 7.949932e-01,
    7.950060e-01, 7.950186e-01, 7.950313e-01, 7.950440e-01, 7.950567e-01, 7.950695e-01,
    7.950821e-01, 7.950948e-01, 7.951074e-01, 7.951202e-01, 7.951328e-01, 7.951455e-01,
    7.951581e-01, 7.951709e-01, 7.951835e-01, 7.951963e-01, 7.952089e-01, 7.952216e-01,
    7.952343e-01, 7.952470e-01, 7.952597e-01, 7.952724e-01, 7.952850e-01, 7.952977e-01,
    7.953104e-01, 7.953231e-01, 7.953358e-01, 7.953485e-01, 7.953612e-01, 7.953739e-01,
    7.953866e-01, 7.953992e-01, 7.954119e-01, 7.954246e-01, 7.954373e-01, 7.954499e-01,
    7.954627e-01, 7.954753e-01, 7.954881e-01, 7.955007e-01, 7.955133e-01, 7.955260e-01,
    7.955387e-01, 7.955514e-01, 7.955641e-01, 7.955768e-01, 7.955894e-01, 7.956021e-01,
    7.956148e-01, 7.956275e-01, 7.956402e-01, 7.956529e-01, 7.956655e-01, 7.956783e-01,
    7.956909e-01, 7.957036e-01, 7.957163e-01, 7.957290e-01, 7.957416e-01, 7.957544e-01,
    7.957670e-01, 7.957797e-01, 7.957923e-01, 7.958050e-01, 7.958177e-01, 7.958304e-01,
    7.958431e-01, 7.958558e-01, 7.958685e-01, 7.958811e-01, 7.958938e-01, 7.959065e-01,
    7.959192e-01, 7.959318e-01, 7.959445e-01, 7.959572e-01, 7.959698e-01, 7.959826e-01,
    7.959952e-01, 7.960079e-01, 7.960206e-01, 7.960333e-01, 7.960460e-01, 7.960586e-01,
    7.960713e-01, 7.960839e-01, 7.960967e-01, 7.961093e-01, 7.961221e-01, 7.961347e-01,
    7.961473e-01, 7.961600e-01, 7.961727e-01, 7.961854e-01, 7.961981e-01, 7.962108e-01,
    7.962235e-01, 7.962361e-01, 7.962488e-01, 7.962614e-01, 7.962742e-01, 7.962868e-01,
    7.962995e-01, 7.963122e-01, 7.963248e-01, 7.963375e-01, 7.963502e-01, 7.963629e-01,
    7.963756e-01, 7.963882e-01, 7.964009e-01, 7.964135e-01, 7.964263e-01, 7.964389e-01,
    7.964516e-01, 7.964643e-01, 7.964770e-01, 7.964896e-01, 7.965023e-01, 7.965149e-01,
    7.965277e-01, 7.965403e-01, 7.965530e-01, 7.965657e-01, 7.965783e-01, 7.965910e-01,
    7.966037e-01, 7.966163e-01, 7.966291e-01, 7.966417e-01, 7.966543e-01, 7.966670e-01,
    7.966797e-01, 7.966924e-01, 7.967051e-01, 7.967177e-01, 7.967305e-01, 7.967431e-01,
    7.967557e-01, 7.967684e-01, 7.967811e-01, 7.967938e-01, 7.968065e-01, 7.968191e-01,
    7.968318e-01, 7.968445e-01, 7.968571e-01, 7.968698e-01, 7.968825e-01, 7.968951e-01,
    7.969078e-01, 7.969205e-01, 7.969331e-01, 7.969459e-01, 7.969585e-01, 7.969711e-01,
    7.969838e-01, 7.969965e-01, 7.970091e-01, 7.970219e-01, 7.970345e-01, 7.970471e-01,
    7.970599e-01, 7.970725e-01, 7.970852e-01, 7.970979e-01, 7.971105e-01, 7.971231e-01,
    7.971359e-01, 7.971485e-01, 7.971612e-01, 7.971739e-01, 7.971866e-01, 7.971992e-01,
    7.972119e-01, 7.972245e-01, 7.972372e-01, 7.972499e-01, 7.972625e-01, 7.972752e-01,
    7.972879e-01, 7.973006e-01, 7.973132e-01, 7.973259e-01, 7.973385e-01, 7.973512e-01,
    7.973639e-01, 7.973766e-01, 7.973892e-01, 7.974018e-01, 7.974146e-01, 7.974272e-01,
    7.974399e-01, 7.974526e-01, 7.974652e-01, 7.974779e-01, 7.974905e-01, 7.975032e-01,
    7.975159e-01, 7.975285e-01, 7.975413e-01, 7.975539e-01, 7.975665e-01, 7.975792e-01,
    7.975919e-01, 7.976046e-01, 7.976172e-01, 7.976298e-01, 7.976425e-01, 7.976552e-01,
    7.976678e-01, 7.976806e-01, 7.976932e-01, 7.977058e-01, 7.977185e-01, 7.977312e-01,
    7.977439e-01, 7.977565e-01, 7.977691e-01, 7.977818e-01, 7.977945e-01, 7.978072e-01,
    7.978198e-01, 7.978325e-01, 7.978451e-01, 7.978578e-01, 7.978704e-01, 7.978832e-01,
    7.978958e-01, 7.979084e-01, 7.979211e-01, 7.979338e-01, 7.979465e-01, 7.979591e-01,
    7.979717e-01, 7.979844e-01, 7.979971e-01, 7.980098e-01, 7.980224e-01, 7.980351e-01,
    7.980477e-01, 7.980604e-01, 7.980730e-01, 7.980857e-01, 7.980984e-01, 7.981110e-01,
    7.981237e-01, 7.981363e-01, 7.981490e-01, 7.981617e-01, 7.981743e-01, 7.981870e-01,
    7.981997e-01, 7.982123e-01, 7.982250e-01, 7.982376e-01, 7.982503e-01, 7.982630e-01,
    7.982756e-01, 7.982883e-01, 7.983009e-01, 7.983136e-01, 7.983263e-01, 7.983389e-01,
    7.983515e-01, 7.983642e-01, 7.983768e-01, 7.983896e-01, 7.984022e-01, 7.984148e-01,
    7.984275e-01, 7.984401e-01, 7.984529e-01, 7.984655e-01, 7.984781e-01, 7.984908e-01,
    7.985034e-01, 7.985162e-01, 7.985288e-01, 7.985414e-01, 7.985541e-01, 7.985667e-01,
    7.985793e-01, 7.985921e-01, 7.986047e-01, 7.986174e-01, 7.986300e-01, 7.986426e-01,
    7.986553e-01, 7.986680e-01, 7.986807e-01, 7.986933e-01, 7.987059e-01, 7.987186e-01,
    7.987313e-01, 7.987439e-01, 7.987565e-01, 7.987692e-01, 7.987819e-01, 7.987945e-01,
    7.988071e-01, 7.988198e-01, 7.988325e-01, 7.988451e-01, 7.988577e-01, 7.988704e-01,
    7.988831e-01, 7.988958e-01, 7.989084e-01, 7.989210e-01, 7.989337e-01, 7.989463e-01,
    7.989590e-01, 7.989717e-01, 7.989843e-01, 7.989970e-01, 7.990096e-01, 7.990223e-01,
    7.990349e-01, 7.990476e-01, 7.990602e-01, 7.990729e-01, 7.990856e-01, 7.990982e-01,
    7.991108e-01, 7.991235e-01, 7.991361e-01, 7.991488e-01, 7.991614e-01, 7.991741e-01,
    7.991868e-01, 7.991994e-01, 7.992120e-01, 7.992247e-01, 7.992374e-01, 7.992500e-01,
    7.992626e-01, 7.992753e-01, 7.992879e-01, 7.993006e-01, 7.993132e-01, 7.993259e-01,
    7.993386e-01, 7.993512e-01, 7.993639e-01, 7.993765e-01, 7.993891e-01, 7.994018e-01,
    7.994144e-01, 7.994272e-01, 7.994398e-01, 7.994524e-01, 7.994651e-01, 7.994777e-01,
    7.994903e-01, 7.995030e-01, 7.995156e-01, 7.995282e-01, 7.995409e-01, 7.995535e-01,
    7.995661e-01, 7.995789e-01, 7.995915e-01, 7.996042e-01, 7.996168e-01, 7.996294e-01,
    7.996421e-01, 7.996547e-01, 7.996674e-01, 7.996801e-01, 7.996927e-01, 7.997053e-01,
    7.997180e-01, 7.997306e-01, 7.997432e-01, 7.997559e-01, 7.997686e-01, 7.997813e-01,
    7.997939e-01, 7.998065e-01, 7.998192e-01, 7.998318e-01, 7.998444e-01, 7.998571e-01,
    7.998697e-01, 7.998824e-01, 7.998950e-01, 7.999076e-01, 7.999203e-01, 7.999329e-01,
    7.999456e-01, 7.999582e-01, 7.999709e-01, 7.999835e-01, 7.999961e-01, 8.000088e-01,
    8.000214e-01, 8.000340e-01, 8.000467e-01, 8.000594e-01, 8.000721e-01, 8.000847e-01,
    8.000973e-01, 8.001100e-01, 8.001226e-01, 8.001353e-01, 8.001479e-01, 8.001605e-01,
    8.001732e-01, 8.001858e-01, 8.001985e-01, 8.002111e-01, 8.002238e-01, 8.002364e-01,
    8.002490e-01, 8.002617e-01, 8.002743e-01, 8.002869e-01, 8.002996e-01, 8.003122e-01,
    8.003249e-01, 8.003375e-01, 8.003501e-01, 8.003628e-01, 8.003755e-01, 8.003881e-01,
    8.004007e-01, 8.004134e-01, 8.004260e-01, 8.004386e-01, 8.004513e-01, 8.004639e-01,
    8.004766e-01, 8.004892e-01, 8.005018e-01, 8.005145e-01, 8.005272e-01, 8.005398e-01,
    8.005524e-01, 8.005651e-01, 8.005777e-01, 8.005903e-01, 8.006029e-01, 8.006155e-01,
    8.006282e-01, 8.006408e-01, 8.006535e-01, 8.006661e-01, 8.006787e-01, 8.006914e-01,
    8.007040e-01, 8.007166e-01, 8.007293e-01, 8.007419e-01, 8.007545e-01, 8.007672e-01,
    8.007799e-01, 8.007925e-01, 8.008052e-01, 8.008178e-01, 8.008304e-01, 8.008431e-01,
    8.008557e-01, 8.008683e-01, 8.008810e-01, 8.008936e-01, 8.009062e-01, 8.009188e-01,
    8.009315e-01, 8.009441e-01, 8.009567e-01, 8.009694e-01, 8.009820e-01, 8.009946e-01,
    8.010073e-01, 8.010200e-01, 8.010326e-01, 8.010452e-01, 8.010579e-01, 8.010705e-01,
    8.010831e-01, 8.010957e-01, 8.011084e-01, 8.011210e-01, 8.011336e-01, 8.011463e-01,
    8.011589e-01, 8.011715e-01, 8.011842e-01, 8.011968e-01, 8.012094e-01, 8.012221e-01,
    8.012347e-01, 8.012473e-01, 8.012599e-01, 8.012726e-01, 8.012852e-01, 8.012978e-01,
    8.013105e-01, 8.013232e-01, 8.013358e-01, 8.013484e-01, 8.013610e-01, 8.013736e-01,
    8.013862e-01, 8.013989e-01, 8.014116e-01, 8.014242e-01, 8.014368e-01, 8.014495e-01,
    8.014621e-01, 8.014747e-01, 8.014873e-01, 8.015000e-01, 8.015126e-01, 8.015252e-01,
    8.015379e-01, 8.015505e-01, 8.015631e-01, 8.015758e-01, 8.015884e-01, 8.016010e-01,
    8.016136e-01, 8.016263e-01, 8.016389e-01, 8.016515e-01, 8.016642e-01, 8.016768e-01,
    8.016894e-01, 8.017020e-01, 8.017147e-01, 8.017273e-01, 8.017399e-01, 8.017526e-01,
    8.017651e-01, 8.017778e-01, 8.017904e-01, 8.018031e-01, 8.018157e-01, 8.018283e-01,
    8.018410e-01, 8.018535e-01, 8.018662e-01, 8.018788e-01, 8.018914e-01, 8.019041e-01,
    8.019167e-01, 8.019293e-01, 8.019419e-01, 8.019546e-01, 8.019672e-01, 8.019798e-01,
    8.019925e-01, 8.020051e-01, 8.020177e-01, 8.020303e-01, 8.020430e-01, 8.020556e-01,
    8.020683e-01, 8.020808e-01, 8.020934e-01, 8.021061e-01, 8.021187e-01, 8.021314e-01,
    8.021441e-01, 8.021566e-01, 8.021692e-01, 8.021818e-01, 8.021945e-01, 8.022071e-01,
    8.022197e-01, 8.022323e-01, 8.022450e-01, 8.022576e-01, 8.022702e-01, 8.022828e-01,
    8.022954e-01, 8.023081e-01, 8.023207e-01, 8.023334e-01, 8.023459e-01, 8.023586e-01,
    8.023712e-01, 8.023838e-01, 8.023965e-01, 8.024091e-01, 8.024217e-01, 8.024343e-01,
    8.024470e-01, 8.024595e-01, 8.024722e-01, 8.024848e-01, 8.024974e-01, 8.025101e-01,
    8.025227e-01, 8.025353e-01, 8.025479e-01, 8.025606e-01, 8.025731e-01, 8.025858e-01,
    8.025984e-01, 8.026111e-01, 8.026237e-01, 8.026363e-01, 8.026489e-01, 8.026615e-01,
    8.026742e-01, 8.026867e-01, 8.026993e-01, 8.027120e-01, 8.027247e-01, 8.027372e-01,
    8.027498e-01, 8.027624e-01, 8.027751e-01, 8.027877e-01, 8.028003e-01, 8.028129e-01,
    8.028256e-01, 8.028381e-01, 8.028508e-01, 8.028634e-01, 8.028761e-01, 8.028886e-01,
    8.029013e-01, 8.029139e-01, 8.029265e-01, 8.029391e-01, 8.029518e-01, 8.029644e-01,
    8.029769e-01, 8.029896e-01, 8.030022e-01, 8.030149e-01, 8.030274e-01, 8.030400e-01,
    8.030527e-01, 8.030654e-01, 8.030779e-01, 8.030905e-01, 8.031031e-01, 8.031157e-01,
    8.031284e-01, 8.031410e-01, 8.031536e-01, 8.031662e-01, 8.031788e-01, 8.031915e-01,
    8.032041e-01, 8.032167e-01, 8.032293e-01, 8.032420e-01, 8.032545e-01, 8.032672e-01,
    8.032798e-01, 8.032923e-01, 8.033050e-01, 8.033176e-01, 8.033302e-01, 8.033428e-01,
    8.033555e-01, 8.033681e-01, 8.033807e-01, 8.033933e-01, 8.034059e-01, 8.034185e-01,
    8.034312e-01, 8.034438e-01, 8.034563e-01, 8.034690e-01, 8.034816e-01, 8.034942e-01,
    8.035068e-01, 8.035194e-01, 8.035320e-01, 8.035446e-01, 8.035573e-01, 8.035699e-01,
    8.035825e-01, 8.035951e-01, 8.036077e-01, 8.036203e-01, 8.036330e-01, 8.036455e-01,
    8.036581e-01, 8.036708e-01, 8.036833e-01, 8.036960e-01, 8.037086e-01, 8.037212e-01,
    8.037338e-01, 8.037465e-01, 8.037590e-01, 8.037717e-01, 8.037843e-01, 8.037969e-01,
    8.038095e-01, 8.038222e-01, 8.038347e-01, 8.038473e-01, 8.038599e-01, 8.038725e-01,
    8.038852e-01, 8.038977e-01, 8.039104e-01, 8.039230e-01, 8.039356e-01, 8.039482e-01,
    8.039609e-01, 8.039734e-01, 8.039860e-01, 8.039986e-01, 8.040112e-01, 8.040239e-01,
    8.040364e-01, 8.040491e-01, 8.040617e-01, 8.040743e-01, 8.040869e-01, 8.040994e-01,
    8.041121e-01, 8.041248e-01, 8.041373e-01, 8.041499e-01, 8.041625e-01, 8.041751e-01,
    8.041878e-01, 8.042004e-01, 8.042130e-01, 8.042256e-01, 8.042381e-01, 8.042508e-01,
    8.042634e-01, 8.042760e-01, 8.042886e-01, 8.043012e-01, 8.043138e-01, 8.043264e-01,
    8.043391e-01, 8.043516e-01, 8.043642e-01, 8.043769e-01, 8.043894e-01, 8.044021e-01,
    8.044146e-01, 8.044273e-01, 8.044399e-01, 8.044525e-01, 8.044651e-01, 8.044776e-01,
    8.044903e-01, 8.045028e-01, 8.045155e-01, 8.045281e-01, 8.045407e-01, 8.045533e-01,
    8.045659e-01, 8.045785e-01, 8.045911e-01, 8.046037e-01, 8.046163e-01, 8.046289e-01,
    8.046415e-01, 8.046541e-01, 8.046668e-01, 8.046793e-01, 8.046920e-01, 8.047046e-01,
    8.047171e-01, 8.047298e-01, 8.047423e-01, 8.047550e-01, 8.047675e-01, 8.047802e-01,
    8.047927e-01, 8.048053e-01, 8.048179e-01, 8.048306e-01, 8.048432e-01, 8.048558e-01,
    8.048684e-01, 8.048810e-01, 8.048936e-01, 8.049061e-01, 8.049188e-01, 8.049313e-01,
    8.049440e-01, 8.049566e-01, 8.049692e-01, 8.049817e-01, 8.049944e-01, 8.050069e-01,
    8.050196e-01, 8.050322e-01, 8.050448e-01, 8.050574e-01, 8.050700e-01, 8.050826e-01,
    8.050951e-01, 8.051078e-01, 8.051203e-01, 8.051330e-01, 8.051456e-01, 8.051582e-01,
    8.051707e-01, 8.051834e-01, 8.051959e-01, 8.052086e-01, 8.052211e-01, 8.052338e-01,
    8.052464e-01, 8.052590e-01, 8.052715e-01, 8.052841e-01, 8.052967e-01, 8.053094e-01,
    8.053219e-01, 8.053346e-01, 8.053471e-01, 8.053598e-01, 8.053723e-01, 8.053849e-01,
    8.053975e-01, 8.054101e-01, 8.054227e-01, 8.054354e-01, 8.054479e-01, 8.054605e-01,
    8.054731e-01, 8.054857e-01, 8.054983e-01, 8.055108e-01, 8.055235e-01, 8.055360e-01,
    8.055487e-01, 8.055612e-01, 8.055739e-01, 8.055864e-01, 8.055991e-01, 8.056116e-01,
    8.056242e-01, 8.056368e-01, 8.056495e-01, 8.056620e-01, 8.056746e-01, 8.056872e-01,
    8.056998e-01, 8.057124e-01, 8.057250e-01, 8.057376e-01, 8.057501e-01, 8.057628e-01,
    8.057753e-01, 8.057879e-01, 8.058006e-01, 8.058131e-01, 8.058258e-01, 8.058383e-01,
    8.058509e-01, 8.058635e-01, 8.058761e-01, 8.058887e-01, 8.059012e-01, 8.059139e-01,
    8.059264e-01, 8.059391e-01, 8.059517e-01, 8.059643e-01, 8.059768e-01, 8.059894e-01,
    8.060020e-01, 8.060146e-01, 8.060272e-01, 8.060398e-01, 8.060524e-01, 8.060650e-01,
    8.060775e-01, 8.060902e-01, 8.061027e-01, 8.061154e-01, 8.061279e-01, 8.061405e-01,
    8.061531e-01, 8.061656e-01, 8.061783e-01, 8.061908e-01, 8.062034e-01, 8.062161e-01,
    8.062286e-01, 8.062413e-01, 8.062538e-01, 8.062664e-01, 8.062790e-01, 8.062916e-01,
    8.063042e-01, 8.063167e-01, 8.063293e-01, 8.063419e-01, 8.063545e-01, 8.063672e-01,
    8.063797e-01, 8.063923e-01, 8.064049e-01, 8.064175e-01, 8.064301e-01, 8.064426e-01,
    8.064552e-01, 8.064678e-01, 8.064804e-01, 8.064929e-01, 8.065056e-01, 8.065181e-01,
    8.065307e-01, 8.065434e-01, 8.065559e-01, 8.065686e-01, 8.065811e-01, 8.065937e-01,
    8.066063e-01, 8.066188e-01, 8.066314e-01, 8.066440e-01, 8.066566e-01, 8.066691e-01,
    8.066818e-01, 8.066943e-01, 8.067070e-01, 8.067195e-01, 8.067321e-01, 8.067448e-01,
    8.067573e-01, 8.067698e-01, 8.067825e-01, 8.067951e-01, 8.068076e-01, 8.068202e-01,
    8.068328e-01, 8.068454e-01, 8.068580e-01, 8.068705e-01, 8.068831e-01, 8.068957e-01,
    8.069083e-01, 8.069208e-01, 8.069335e-01, 8.069460e-01, 8.069586e-01, 8.069713e-01,
    8.069838e-01, 8.069963e-01, 8.070090e-01, 8.070216e-01, 8.070341e-01, 8.070467e-01,
    8.070593e-01, 8.070719e-01, 8.070845e-01, 8.070970e-01, 8.071096e-01, 8.071222e-01,
    8.071348e-01, 8.071473e-01, 8.071599e-01, 8.071725e-01, 8.071851e-01, 8.071976e-01,
    8.072103e-01, 8.072228e-01, 8.072354e-01, 8.072479e-01, 8.072606e-01, 8.072731e-01,
    8.072857e-01, 8.072984e-01, 8.073109e-01, 8.073235e-01, 8.073361e-01, 8.073487e-01,
    8.073612e-01, 8.073738e-01, 8.073864e-01, 8.073990e-01, 8.074115e-01, 8.074241e-01,
    8.074367e-01, 8.074493e-01, 8.074618e-01, 8.074744e-01, 8.074870e-01, 8.074996e-01,
    8.075121e-01, 8.075247e-01, 8.075373e-01, 8.075499e-01, 8.075624e-01, 8.075750e-01,
    8.075876e-01, 8.076002e-01, 8.076128e-01, 8.076254e-01, 8.076379e-01, 8.076504e-01,
    8.076631e-01, 8.076757e-01, 8.076882e-01, 8.077008e-01, 8.077134e-01, 8.077260e-01,
    8.077385e-01, 8.077511e-01, 8.077638e-01, 8.077763e-01, 8.077888e-01, 8.078014e-01,
    8.078140e-01, 8.078266e-01, 8.078392e-01, 8.078517e-01, 8.078642e-01, 8.078769e-01,
    8.078895e-01, 8.079020e-01, 8.079146e-01, 8.079272e-01, 8.079398e-01, 8.079523e-01,
    8.079649e-01, 8.079775e-01, 8.079901e-01, 8.080026e-01, 8.080152e-01, 8.080277e-01,
    8.080404e-01, 8.080529e-01, 8.080655e-01, 8.080781e-01, 8.080906e-01, 8.081032e-01,
    8.081158e-01, 8.081284e-01, 8.081409e-01, 8.081535e-01, 8.081661e-01, 8.081787e-01,
    8.081912e-01, 8.082038e-01, 8.082164e-01, 8.082290e-01, 8.082415e-01, 8.082541e-01,
    8.082666e-01, 8.082792e-01, 8.082918e-01, 8.083044e-01, 8.083169e-01, 8.083295e-01,
    8.083420e-01, 8.083547e-01, 8.083672e-01, 8.083798e-01, 8.083923e-01, 8.084049e-01,
    8.084175e-01, 8.084301e-01, 8.084427e-01, 8.084552e-01, 8.084677e-01, 8.084803e-01,
    8.084930e-01, 8.085055e-01, 8.085181e-01, 8.085306e-01, 8.085431e-01, 8.085557e-01,
    8.085684e-01, 8.085809e-01, 8.085935e-01, 8.086060e-01, 8.086185e-01, 8.086311e-01,
    8.086438e-01, 8.086563e-01, 8.086689e-01, 8.086814e-01, 8.086940e-01, 8.087065e-01,
    8.087191e-01, 8.087317e-01, 8.087443e-01, 8.087568e-01, 8.087694e-01, 8.087819e-01,
    8.087945e-01, 8.088071e-01, 8.088197e-01, 8.088322e-01, 8.088448e-01, 8.088574e-01,
    8.088699e-01, 8.088825e-01, 8.088951e-01, 8.089077e-01, 8.089202e-01, 8.089328e-01,
    8.089454e-01, 8.089579e-01, 8.089705e-01, 8.089830e-01, 8.089955e-01, 8.090082e-01,
    8.090208e-01, 8.090333e-01, 8.090459e-01, 8.090584e-01, 8.090709e-01, 8.090835e-01,
    8.090961e-01, 8.091086e-01, 8.091213e-01, 8.091338e-01, 8.091464e-01, 8.091589e-01,
    8.091715e-01, 8.091841e-01, 8.091966e-01, 8.092092e-01, 8.092217e-01, 8.092343e-01,
    8.092469e-01, 8.092595e-01, 8.092720e-01, 8.092846e-01, 8.092971e-01, 8.093097e-01,
    8.093222e-01, 8.093348e-01, 8.093473e-01, 8.093599e-01, 8.093724e-01, 8.093850e-01,
    8.093976e-01, 8.094102e-01, 8.094227e-01, 8.094353e-01, 8.094479e-01, 8.094604e-01,
    8.094730e-01, 8.094856e-01, 8.094981e-01, 8.095106e-01, 8.095232e-01, 8.095357e-01,
    8.095483e-01, 8.095608e-01, 8.095735e-01, 8.095860e-01, 8.095986e-01, 8.096111e-01,
    8.096237e-01, 8.096363e-01, 8.096488e-01, 8.096614e-01, 8.096740e-01, 8.096865e-01,
    8.096991e-01, 8.097116e-01, 8.097242e-01, 8.097367e-01, 8.097492e-01, 8.097618e-01,
    8.097744e-01, 8.097869e-01, 8.097995e-01, 8.098121e-01, 8.098246e-01, 8.098372e-01,
    8.098498e-01, 8.098623e-01, 8.098749e-01, 8.098875e-01, 8.099000e-01, 8.099126e-01,
    8.099251e-01, 8.099377e-01, 8.099502e-01, 8.099628e-01, 8.099753e-01, 8.099879e-01,
    8.100004e-01, 8.100130e-01, 8.100256e-01, 8.100381e-01, 8.100507e-01, 8.100632e-01,
    8.100758e-01, 8.100883e-01, 8.101009e-01, 8.101134e-01, 8.101260e-01, 8.101385e-01,
    8.101511e-01, 8.101637e-01, 8.101762e-01, 8.101888e-01, 8.102013e-01, 8.102139e-01,
    8.102264e-01, 8.102390e-01, 8.102515e-01, 8.102641e-01, 8.102766e-01, 8.102892e-01,
    8.103018e-01, 8.103143e-01, 8.103269e-01, 8.103395e-01, 8.103520e-01, 8.103645e-01,
    8.103771e-01, 8.103896e-01, 8.104022e-01, 8.104147e-01, 8.104273e-01, 8.104399e-01,
    8.104524e-01, 8.104650e-01, 8.104776e-01, 8.104901e-01, 8.105026e-01, 8.105152e-01,
    8.105277e-01, 8.105402e-01, 8.105528e-01, 8.105654e-01, 8.105779e-01, 8.105904e-01,
    8.106030e-01, 8.106155e-01, 8.106281e-01, 8.106406e-01, 8.106532e-01, 8.106658e-01,
    8.106783e-01, 8.106909e-01, 8.107034e-01, 8.107160e-01, 8.107285e-01, 8.107411e-01,
    8.107536e-01, 8.107662e-01, 8.107787e-01, 8.107912e-01, 8.108038e-01, 8.108163e-01,
    8.108289e-01, 8.108414e-01, 8.108540e-01, 8.108665e-01, 8.108791e-01, 8.108917e-01,
    8.109042e-01, 8.109168e-01, 8.109293e-01, 8.109419e-01, 8.109545e-01, 8.109669e-01,
    8.109795e-01, 8.109920e-01, 8.110046e-01, 8.110171e-01, 8.110297e-01, 8.110422e-01,
    8.110548e-01, 8.110673e-01, 8.110799e-01, 8.110924e-01, 8.111050e-01, 8.111175e-01,
    8.111300e-01, 8.111426e-01, 8.111551e-01, 8.111677e-01, 8.111802e-01, 8.111928e-01,
    8.112054e-01, 8.112179e-01, 8.112305e-01, 8.112429e-01, 8.112555e-01, 8.112680e-01,
    8.112806e-01, 8.112931e-01, 8.113057e-01, 8.113183e-01, 8.113308e-01, 8.113433e-01,
    8.113558e-01, 8.113684e-01, 8.113809e-01, 8.113935e-01, 8.114061e-01, 8.114186e-01,
    8.114312e-01, 8.114437e-01, 8.114562e-01, 8.114687e-01, 8.114813e-01, 8.114939e-01,
    8.115064e-01, 8.115190e-01, 8.115315e-01, 8.115440e-01, 8.115565e-01, 8.115691e-01,
    8.115817e-01, 8.115942e-01, 8.116068e-01, 8.116193e-01, 8.116318e-01, 8.116443e-01,
    8.116569e-01, 8.116695e-01, 8.116820e-01, 8.116946e-01, 8.117071e-01, 8.117196e-01,
    8.117321e-01, 8.117447e-01, 8.117573e-01, 8.117698e-01, 8.117824e-01, 8.117948e-01,
    8.118074e-01, 8.118199e-01, 8.118325e-01, 8.118451e-01, 8.118576e-01, 8.118701e-01,
    8.118826e-01, 8.118952e-01, 8.119077e-01, 8.119203e-01, 8.119329e-01, 8.119453e-01,
    8.119579e-01, 8.119704e-01, 8.119830e-01, 8.119955e-01, 8.120080e-01, 8.120205e-01,
    8.120331e-01, 8.120457e-01, 8.120582e-01, 8.120708e-01, 8.120832e-01, 8.120958e-01,
    8.121083e-01, 8.121209e-01, 8.121335e-01, 8.121459e-01, 8.121585e-01, 8.121710e-01,
    8.121836e-01, 8.121961e-01, 8.122086e-01, 8.122212e-01, 8.122337e-01, 8.122463e-01,
    8.122588e-01, 8.122713e-01, 8.122839e-01, 8.122964e-01, 8.123090e-01, 8.123214e-01,
    8.123340e-01, 8.123466e-01, 8.123591e-01, 8.123717e-01, 8.123841e-01, 8.123967e-01,
    8.124092e-01, 8.124218e-01, 8.124343e-01, 8.124468e-01, 8.124593e-01, 8.124719e-01,
    8.124844e-01, 8.124970e-01, 8.125095e-01, 8.125221e-01, 8.125346e-01, 8.125471e-01,
    8.125597e-01, 8.125722e-01, 8.125848e-01, 8.125972e-01, 8.126098e-01, 8.126223e-01,
    8.126349e-01, 8.126473e-01, 8.126599e-01, 8.126724e-01, 8.126850e-01, 8.126975e-01,
    8.127100e-01, 8.127226e-01, 8.127351e-01, 8.127476e-01, 8.127602e-01, 8.127728e-01,
    8.127853e-01, 8.127977e-01, 8.128103e-01, 8.128229e-01, 8.128353e-01, 8.128479e-01,
    8.128604e-01, 8.128730e-01, 8.128855e-01, 8.128980e-01, 8.129106e-01, 8.129231e-01,
    8.129356e-01, 8.129482e-01, 8.129607e-01, 8.129731e-01, 8.129857e-01, 8.129983e-01,
    8.130108e-01, 8.130233e-01, 8.130358e-01, 8.130484e-01, 8.130609e-01, 8.130735e-01,
    8.130860e-01, 8.130985e-01, 8.131110e-01, 8.131236e-01, 8.131361e-01, 8.131486e-01,
    8.131611e-01, 8.131737e-01, 8.131862e-01, 8.131987e-01, 8.132113e-01, 8.132238e-01,
    8.132363e-01, 8.132489e-01, 8.132614e-01, 8.132739e-01, 8.132864e-01, 8.132990e-01,
    8.133115e-01, 8.133240e-01, 8.133366e-01, 8.133490e-01, 8.133616e-01, 8.133742e-01,
    8.133866e-01, 8.133992e-01, 8.134117e-01, 8.134242e-01, 8.134367e-01, 8.134493e-01,
    8.134618e-01, 8.134743e-01, 8.134869e-01, 8.134993e-01, 8.135119e-01, 8.135245e-01,
    8.135369e-01, 8.135495e-01, 8.135620e-01, 8.135745e-01, 8.135871e-01, 8.135996e-01,
    8.136121e-01, 8.136246e-01, 8.136372e-01, 8.136497e-01, 8.136622e-01, 8.136747e-01,
    8.136873e-01, 8.136998e-01, 8.137124e-01, 8.137248e-01, 8.137374e-01, 8.137498e-01,
    8.137624e-01, 8.137749e-01, 8.137874e-01, 8.138000e-01, 8.138126e-01, 8.138250e-01,
    8.138375e-01, 8.138501e-01, 8.138626e-01, 8.138751e-01, 8.138876e-01, 8.139002e-01,
    8.139127e-01, 8.139252e-01, 8.139377e-01, 8.139503e-01, 8.139628e-01, 8.139753e-01,
    8.139878e-01, 8.140003e-01, 8.140129e-01, 8.140253e-01, 8.140379e-01, 8.140504e-01,
    8.140630e-01, 8.140755e-01, 8.140880e-01, 8.141005e-01, 8.141130e-01, 8.141255e-01,
    8.141381e-01, 8.141506e-01, 8.141631e-01, 8.141756e-01, 8.141881e-01, 8.142007e-01,
    8.142132e-01, 8.142257e-01, 8.142382e-01, 8.142508e-01, 8.142633e-01, 8.142757e-01,
    8.142883e-01, 8.143008e-01, 8.143134e-01, 8.143259e-01, 8.143384e-01, 8.143509e-01,
    8.143634e-01, 8.143759e-01, 8.143884e-01, 8.144010e-01, 8.144135e-01, 8.144260e-01,
    8.144385e-01, 8.144510e-01, 8.144636e-01, 8.144760e-01, 8.144886e-01, 8.145012e-01,
    8.145136e-01, 8.145262e-01, 8.145387e-01, 8.145512e-01, 8.145637e-01, 8.145762e-01,
    8.145887e-01, 8.146012e-01, 8.146138e-01, 8.146263e-01, 8.146388e-01, 8.146513e-01,
    8.146638e-01, 8.146763e-01, 8.146889e-01, 8.147013e-01, 8.147139e-01, 8.147264e-01,
    8.147389e-01, 8.147514e-01, 8.147640e-01, 8.147765e-01, 8.147889e-01, 8.148015e-01,
    8.148140e-01, 8.148265e-01, 8.148390e-01, 8.148516e-01, 8.148640e-01, 8.148766e-01,
    8.148891e-01, 8.149016e-01, 8.149140e-01, 8.149266e-01, 8.149391e-01, 8.149517e-01,
    8.149641e-01, 8.149767e-01, 8.149891e-01, 8.150017e-01, 8.150142e-01, 8.150267e-01,
    8.150393e-01, 8.150517e-01, 8.150643e-01, 8.150768e-01, 8.150893e-01, 8.151018e-01,
    8.151144e-01, 8.151268e-01, 8.151394e-01, 8.151519e-01, 8.151644e-01, 8.151768e-01,
    8.151894e-01, 8.152019e-01, 8.152145e-01, 8.152269e-01, 8.152395e-01, 8.152519e-01,
    8.152644e-01, 8.152770e-01, 8.152894e-01, 8.153020e-01, 8.153145e-01, 8.153270e-01,
    8.153395e-01, 8.153520e-01, 8.153645e-01, 8.153771e-01, 8.153895e-01, 8.154021e-01,
    8.154145e-01, 8.154271e-01, 8.154396e-01, 8.154521e-01, 8.154646e-01, 8.154771e-01,
    8.154896e-01, 8.155021e-01, 8.155146e-01, 8.155271e-01, 8.155397e-01, 8.155521e-01,
    8.155647e-01, 8.155771e-01, 8.155897e-01, 8.156022e-01, 8.156148e-01, 8.156272e-01,
    8.156397e-01, 8.156523e-01, 8.156647e-01, 8.156772e-01, 8.156897e-01, 8.157023e-01,
    8.157147e-01, 8.157273e-01, 8.157398e-01, 8.157522e-01, 8.157648e-01, 8.157772e-01,
    8.157898e-01, 8.158023e-01, 8.158149e-01, 8.158273e-01, 8.158399e-01, 8.158523e-01,
    8.158648e-01, 8.158774e-01, 8.158898e-01, 8.159024e-01, 8.159149e-01, 8.159273e-01,
    8.159398e-01, 8.159524e-01, 8.159649e-01, 8.159773e-01, 8.159899e-01, 8.160024e-01,
    8.160148e-01, 8.160274e-01, 8.160399e-01, 8.160524e-01, 8.160649e-01, 8.160774e-01,
    8.160899e-01, 8.161024e-01, 8.161150e-01, 8.161274e-01, 8.161399e-01, 8.161525e-01,
    8.161649e-01, 8.161775e-01, 8.161899e-01, 8.162024e-01, 8.162150e-01, 8.162274e-01,
    8.162400e-01, 8.162525e-01, 8.162649e-01, 8.162774e-01, 8.162900e-01, 8.163024e-01,
    8.163149e-01, 8.163275e-01, 8.163400e-01, 8.163524e-01, 8.163649e-01, 8.163775e-01,
    8.163899e-01, 8.164024e-01, 8.164150e-01, 8.164274e-01, 8.164400e-01, 8.164524e-01,
    8.164650e-01, 8.164775e-01, 8.164899e-01, 8.165025e-01, 8.165150e-01, 8.165274e-01,
    8.165399e-01, 8.165525e-01, 8.165649e-01, 8.165775e-01, 8.165900e-01, 8.166024e-01,
    8.166150e-01, 8.166274e-01, 8.166399e-01, 8.166525e-01, 8.166649e-01, 8.166774e-01,
    8.166900e-01, 8.167024e-01, 8.167149e-01, 8.167275e-01, 8.167399e-01, 8.167524e-01,
    8.167650e-01, 8.167774e-01, 8.167899e-01, 8.168024e-01, 8.168149e-01, 8.168274e-01,
    8.168399e-01, 8.168524e-01, 8.168648e-01, 8.168774e-01, 8.168899e-01, 8.169023e-01,
    8.169149e-01, 8.169274e-01, 8.169399e-01, 8.169524e-01, 8.169649e-01, 8.169774e-01,
    8.169899e-01, 8.170024e-01, 8.170149e-01, 8.170273e-01, 8.170398e-01, 8.170524e-01,
    8.170648e-01, 8.170773e-01, 8.170899e-01, 8.171023e-01, 8.171148e-01, 8.171273e-01,
    8.171398e-01, 8.171523e-01, 8.171648e-01, 8.171773e-01, 8.171898e-01, 8.172023e-01,
    8.172148e-01, 8.172272e-01, 8.172398e-01, 8.172523e-01, 8.172647e-01, 8.172772e-01,
    8.172898e-01, 8.173022e-01, 8.173147e-01, 8.173273e-01, 8.173397e-01, 8.173522e-01,
    8.173646e-01, 8.173772e-01, 8.173897e-01, 8.174021e-01, 8.174146e-01, 8.174272e-01,
    8.174396e-01, 8.174521e-01, 8.174646e-01, 8.174771e-01, 8.174896e-01, 8.175021e-01,
    8.175146e-01, 8.175271e-01, 8.175396e-01, 8.175520e-01, 8.175646e-01, 8.175771e-01,
    8.175895e-01, 8.176020e-01, 8.176146e-01, 8.176270e-01, 8.176395e-01, 8.176519e-01,
    8.176645e-01, 8.176770e-01, 8.176894e-01, 8.177019e-01, 8.177145e-01, 8.177269e-01,
    8.177394e-01, 8.177519e-01, 8.177643e-01, 8.177769e-01, 8.177894e-01, 8.178018e-01,
    8.178143e-01, 8.178269e-01, 8.178393e-01, 8.178518e-01, 8.178642e-01, 8.178768e-01,
    8.178893e-01, 8.179017e-01, 8.179142e-01, 8.179267e-01, 8.179393e-01, 8.179517e-01,
    8.179642e-01, 8.179767e-01, 8.179891e-01, 8.180017e-01, 8.180141e-01, 8.180266e-01,
    8.180391e-01, 8.180516e-01, 8.180641e-01, 8.180766e-01, 8.180891e-01, 8.181015e-01,
    8.181141e-01, 8.181266e-01, 8.181390e-01, 8.181515e-01, 8.181639e-01, 8.181765e-01,
    8.181890e-01, 8.182014e-01, 8.182139e-01, 8.182264e-01, 8.182389e-01, 8.182514e-01,
    8.182639e-01, 8.182763e-01, 8.182888e-01, 8.183013e-01, 8.183138e-01, 8.183263e-01,
    8.183388e-01, 8.183512e-01, 8.183637e-01, 8.183762e-01, 8.183887e-01, 8.184012e-01,
    8.184137e-01, 8.184261e-01, 8.184386e-01, 8.184510e-01, 8.184636e-01, 8.184761e-01,
    8.184885e-01, 8.185011e-01, 8.185135e-01, 8.185260e-01, 8.185385e-01, 8.185510e-01,
    8.185635e-01, 8.185759e-01, 8.185884e-01, 8.186009e-01, 8.186134e-01, 8.186259e-01,
    8.186384e-01, 8.186508e-01, 8.186633e-01, 8.186758e-01, 8.186882e-01, 8.187007e-01,
    8.187132e-01, 8.187257e-01, 8.187382e-01, 8.187507e-01, 8.187631e-01, 8.187756e-01,
    8.187881e-01, 8.188006e-01, 8.188131e-01, 8.188255e-01, 8.188381e-01, 8.188505e-01,
    8.188630e-01, 8.188754e-01, 8.188879e-01, 8.189005e-01, 8.189129e-01, 8.189254e-01,
    8.189379e-01, 8.189504e-01, 8.189628e-01, 8.189753e-01, 8.189877e-01, 8.190002e-01,
    8.190128e-01, 8.190252e-01, 8.190377e-01, 8.190502e-01, 8.190627e-01, 8.190751e-01,
    8.190876e-01, 8.191000e-01, 8.191125e-01, 8.191251e-01, 8.191375e-01, 8.191500e-01,
    8.191625e-01, 8.191749e-01, 8.191874e-01, 8.191999e-01, 8.192124e-01, 8.192248e-01,
    8.192373e-01, 8.192497e-01, 8.192623e-01, 8.192748e-01, 8.192872e-01, 8.192997e-01,
    8.193122e-01, 8.193247e-01, 8.193371e-01, 8.193496e-01, 8.193620e-01, 8.193746e-01,
    8.193870e-01, 8.193995e-01, 8.194119e-01, 8.194244e-01, 8.194370e-01, 8.194494e-01,
    8.194619e-01, 8.194744e-01, 8.194869e-01, 8.194993e-01, 8.195118e-01, 8.195242e-01,
    8.195367e-01, 8.195492e-01, 8.195617e-01, 8.195741e-01, 8.195866e-01, 8.195990e-01,
    8.196115e-01, 8.196240e-01, 8.196365e-01, 8.196489e-01, 8.196615e-01, 8.196740e-01,
    8.196864e-01, 8.196989e-01, 8.197114e-01, 8.197238e-01, 8.197363e-01, 8.197488e-01,
    8.197612e-01, 8.197737e-01, 8.197862e-01, 8.197986e-01, 8.198111e-01, 8.198236e-01,
    8.198360e-01, 8.198485e-01, 8.198610e-01, 8.198735e-01, 8.198859e-01, 8.198984e-01,
    8.199109e-01, 8.199233e-01, 8.199358e-01, 8.199483e-01, 8.199607e-01, 8.199732e-01,
    8.199857e-01, 8.199981e-01, 8.200106e-01, 8.200231e-01, 8.200356e-01, 8.200480e-01,
    8.200605e-01, 8.200729e-01, 8.200854e-01, 8.200979e-01, 8.201104e-01, 8.201228e-01,
    8.201353e-01, 8.201478e-01, 8.201602e-01, 8.201727e-01, 8.201852e-01, 8.201976e-01,
    8.202101e-01, 8.202226e-01, 8.202351e-01, 8.202475e-01, 8.202600e-01, 8.202724e-01,
    8.202849e-01, 8.202974e-01, 8.203099e-01, 8.203223e-01, 8.203348e-01, 8.203472e-01,
    8.203597e-01, 8.203722e-01, 8.203847e-01, 8.203971e-01, 8.204096e-01, 8.204221e-01,
    8.204346e-01, 8.204470e-01, 8.204595e-01, 8.204719e-01, 8.204844e-01, 8.204969e-01,
    8.205094e-01, 8.205218e-01, 8.205342e-01, 8.205467e-01, 8.205591e-01, 8.205716e-01,
    8.205841e-01, 8.205966e-01, 8.206090e-01, 8.206215e-01, 8.206339e-01, 8.206464e-01,
    8.206589e-01, 8.206714e-01, 8.206838e-01, 8.206963e-01, 8.207088e-01, 8.207213e-01,
    8.207337e-01, 8.207462e-01, 8.207586e-01, 8.207710e-01, 8.207835e-01, 8.207960e-01,
    8.208084e-01, 8.208209e-01, 8.208334e-01, 8.208458e-01, 8.208583e-01, 8.208708e-01,
    8.208833e-01, 8.208957e-01, 8.209082e-01, 8.209206e-01, 8.209330e-01, 8.209455e-01,
    8.209580e-01, 8.209705e-01, 8.209829e-01, 8.209954e-01, 8.210078e-01, 8.210203e-01,
    8.210328e-01, 8.210453e-01, 8.210577e-01, 8.210701e-01, 8.210826e-01, 8.210950e-01,
    8.211075e-01, 8.211200e-01, 8.211325e-01, 8.211449e-01, 8.211574e-01, 8.211699e-01,
    8.211823e-01, 8.211947e-01, 8.212072e-01, 8.212196e-01, 8.212321e-01, 8.212446e-01,
    8.212571e-01, 8.212695e-01, 8.212820e-01, 8.212944e-01, 8.213068e-01, 8.213193e-01,
    8.213318e-01, 8.213443e-01, 8.213567e-01, 8.213692e-01, 8.213816e-01, 8.213940e-01,
    8.214065e-01, 8.214190e-01, 8.214315e-01, 8.214439e-01, 8.214564e-01, 8.214688e-01,
    8.214812e-01, 8.214937e-01, 8.215062e-01, 8.215187e-01, 8.215311e-01, 8.215436e-01,
    8.215560e-01, 8.215684e-01, 8.215809e-01, 8.215933e-01, 8.216059e-01, 8.216183e-01,
    8.216308e-01, 8.216432e-01, 8.216556e-01, 8.216681e-01, 8.216805e-01, 8.216930e-01,
    8.217055e-01, 8.217180e-01, 8.217304e-01, 8.217428e-01, 8.217553e-01, 8.217677e-01,
    8.217802e-01, 8.217927e-01, 8.218051e-01, 8.218175e-01, 8.218300e-01, 8.218425e-01,
    8.218549e-01, 8.218674e-01, 8.218798e-01, 8.218923e-01, 8.219047e-01, 8.219172e-01,
    8.219297e-01, 8.219421e-01, 8.219545e-01, 8.219670e-01, 8.219795e-01, 8.219919e-01,
    8.220044e-01, 8.220168e-01, 8.220292e-01, 8.220417e-01, 8.220542e-01, 8.220667e-01,
    8.220791e-01, 8.220915e-01, 8.221040e-01, 8.221164e-01, 8.221289e-01, 8.221413e-01,
    8.221537e-01, 8.221663e-01, 8.221787e-01, 8.221911e-01, 8.222036e-01, 8.222160e-01,
    8.222285e-01, 8.222409e-01, 8.222533e-01, 8.222658e-01, 8.222783e-01, 8.222908e-01,
    8.223032e-01, 8.223156e-01, 8.223281e-01, 8.223405e-01, 8.223530e-01, 8.223654e-01,
    8.223779e-01, 8.223903e-01, 8.224028e-01, 8.224152e-01, 8.224276e-01, 8.224401e-01,
    8.224526e-01, 8.224651e-01, 8.224775e-01, 8.224899e-01, 8.225024e-01, 8.225148e-01,
    8.225272e-01, 8.225397e-01, 8.225521e-01, 8.225647e-01, 8.225770e-01, 8.225895e-01,
    8.226020e-01, 8.226144e-01, 8.226268e-01, 8.226393e-01, 8.226517e-01, 8.226642e-01,
    8.226766e-01, 8.226891e-01, 8.227015e-01, 8.227140e-01, 8.227264e-01, 8.227389e-01,
    8.227513e-01, 8.227637e-01, 8.227762e-01, 8.227887e-01, 8.228011e-01, 8.228135e-01,
    8.228260e-01, 8.228384e-01, 8.228509e-01, 8.228633e-01, 8.228757e-01, 8.228882e-01,
    8.229006e-01, 8.229131e-01, 8.229256e-01, 8.229380e-01, 8.229504e-01, 8.229629e-01,
    8.229753e-01, 8.229877e-01, 8.230002e-01, 8.230127e-01, 8.230251e-01, 8.230375e-01,
    8.230500e-01, 8.230624e-01, 8.230748e-01, 8.230873e-01, 8.230998e-01, 8.231121e-01,
    8.231246e-01, 8.231371e-01, 8.231496e-01, 8.231620e-01, 8.231744e-01, 8.231869e-01,
    8.231993e-01, 8.232117e-01, 8.232242e-01, 8.232366e-01, 8.232490e-01, 8.232615e-01,
    8.232739e-01, 8.232864e-01, 8.232988e-01, 8.233112e-01, 8.233237e-01, 8.233361e-01,
    8.233485e-01, 8.233610e-01, 8.233735e-01, 8.233858e-01, 8.233984e-01, 8.234108e-01,
    8.234232e-01, 8.234357e-01, 8.234481e-01, 8.234605e-01, 8.234730e-01, 8.234854e-01,
    8.234978e-01, 8.235103e-01, 8.235227e-01, 8.235351e-01, 8.235476e-01, 8.235601e-01,
    8.235725e-01, 8.235849e-01, 8.235974e-01, 8.236098e-01, 8.236222e-01, 8.236347e-01,
    8.236471e-01, 8.236595e-01, 8.236721e-01, 8.236844e-01, 8.236969e-01, 8.237092e-01,
    8.237218e-01, 8.237342e-01, 8.237466e-01, 8.237591e-01, 8.237715e-01, 8.237839e-01,
    8.237964e-01, 8.238088e-01, 8.238212e-01, 8.238337e-01, 8.238461e-01, 8.238586e-01,
    8.238710e-01, 8.238834e-01, 8.238959e-01, 8.239083e-01, 8.239207e-01, 8.239332e-01,
    8.239456e-01, 8.239580e-01, 8.239705e-01, 8.239829e-01, 8.239954e-01, 8.240077e-01,
    8.240202e-01, 8.240327e-01, 8.240451e-01, 8.240575e-01, 8.240699e-01, 8.240824e-01,
    8.240948e-01, 8.241072e-01, 8.241197e-01, 8.241321e-01, 8.241445e-01, 8.241570e-01,
    8.241694e-01, 8.241819e-01, 8.241943e-01, 8.242067e-01, 8.242192e-01, 8.242316e-01,
    8.242440e-01, 8.242564e-01, 8.242689e-01, 8.242813e-01, 8.242937e-01, 8.243062e-01,
    8.243186e-01, 8.243310e-01, 8.243434e-01, 8.243559e-01, 8.243683e-01, 8.243808e-01,
    8.243933e-01, 8.244056e-01, 8.244181e-01, 8.244305e-01, 8.244429e-01, 8.244553e-01,
    8.244678e-01, 8.244803e-01, 8.244926e-01, 8.245051e-01, 8.245175e-01, 8.245299e-01,
    8.245423e-01, 8.245548e-01, 8.245672e-01, 8.245797e-01, 8.245921e-01, 8.246045e-01,
    8.246170e-01, 8.246294e-01, 8.246418e-01, 8.246542e-01, 8.246667e-01, 8.246791e-01,
    8.246915e-01, 8.247039e-01, 8.247164e-01, 8.247288e-01, 8.247412e-01, 8.247537e-01,
    8.247661e-01, 8.247786e-01, 8.247910e-01, 8.248034e-01, 8.248158e-01, 8.248283e-01,
    8.248407e-01, 8.248531e-01, 8.248655e-01, 8.248780e-01, 8.248904e-01, 8.249028e-01,
    8.249152e-01, 8.249277e-01, 8.249401e-01, 8.249525e-01, 8.249649e-01, 8.249774e-01,
    8.249898e-01, 8.250023e-01, 8.250146e-01, 8.250271e-01, 8.250394e-01, 8.250520e-01,
    8.250643e-01, 8.250768e-01, 8.250892e-01, 8.251016e-01, 8.251140e-01, 8.251265e-01,
    8.251389e-01, 8.251513e-01, 8.251637e-01, 8.251762e-01, 8.251886e-01, 8.252010e-01,
    8.252134e-01, 8.252259e-01, 8.252383e-01, 8.252507e-01, 8.252631e-01, 8.252756e-01,
    8.252880e-01, 8.253005e-01, 8.253129e-01, 8.253253e-01, 8.253377e-01, 8.253502e-01,
    8.253626e-01, 8.253750e-01, 8.253874e-01, 8.253999e-01, 8.254122e-01, 8.254246e-01,
    8.254371e-01, 8.254495e-01, 8.254619e-01, 8.254743e-01, 8.254868e-01, 8.254992e-01,
    8.255116e-01, 8.255240e-01, 8.255365e-01, 8.255489e-01, 8.255613e-01, 8.255737e-01,
    8.255861e-01, 8.255986e-01, 8.256110e-01, 8.256235e-01, 8.256358e-01, 8.256483e-01,
    8.256606e-01, 8.256732e-01, 8.256855e-01, 8.256979e-01, 8.257104e-01, 8.257228e-01,
    8.257352e-01, 8.257476e-01, 8.257601e-01, 8.257725e-01, 8.257849e-01, 8.257973e-01,
    8.258097e-01, 8.258222e-01, 8.258346e-01, 8.258470e-01, 8.258594e-01, 8.258718e-01,
    8.258842e-01, 8.258966e-01, 8.259091e-01, 8.259215e-01, 8.259339e-01, 8.259463e-01,
    8.259587e-01, 8.259712e-01, 8.259836e-01, 8.259960e-01, 8.260084e-01, 8.260208e-01,
    8.260333e-01, 8.260456e-01, 8.260581e-01, 8.260705e-01, 8.260829e-01, 8.260953e-01,
    8.261077e-01, 8.261202e-01, 8.261326e-01, 8.261450e-01, 8.261575e-01, 8.261698e-01,
    8.261823e-01, 8.261947e-01, 8.262070e-01, 8.262196e-01, 8.262319e-01, 8.262443e-01,
    8.262568e-01, 8.262691e-01, 8.262816e-01, 8.262940e-01, 8.263064e-01, 8.263189e-01,
    8.263313e-01, 8.263436e-01, 8.263561e-01, 8.263685e-01, 8.263809e-01, 8.263933e-01,
    8.264057e-01, 8.264182e-01, 8.264306e-01, 8.264430e-01, 8.264554e-01, 8.264678e-01,
    8.264802e-01, 8.264927e-01, 8.265050e-01, 8.265175e-01, 8.265299e-01, 8.265423e-01,
    8.265547e-01, 8.265671e-01, 8.265795e-01, 8.265920e-01, 8.266044e-01, 8.266167e-01,
    8.266292e-01, 8.266416e-01, 8.266540e-01, 8.266664e-01, 8.266788e-01, 8.266912e-01,
    8.267037e-01, 8.267161e-01, 8.267284e-01, 8.267409e-01, 8.267533e-01, 8.267657e-01,
    8.267781e-01, 8.267905e-01, 8.268029e-01, 8.268154e-01, 8.268278e-01, 8.268401e-01,
    8.268526e-01, 8.268650e-01, 8.268774e-01, 8.268898e-01, 8.269022e-01, 8.269146e-01,
    8.269271e-01, 8.269395e-01, 8.269518e-01, 8.269643e-01, 8.269767e-01, 8.269891e-01,
    8.270015e-01, 8.270139e-01, 8.270263e-01, 8.270387e-01, 8.270512e-01, 8.270636e-01,
    8.270759e-01, 8.270884e-01, 8.271008e-01, 8.271132e-01, 8.271256e-01, 8.271380e-01,
    8.271504e-01, 8.271627e-01, 8.271753e-01, 8.271876e-01, 8.272000e-01, 8.272125e-01,
    8.272249e-01, 8.272372e-01, 8.272496e-01, 8.272621e-01, 8.272744e-01, 8.272868e-01,
    8.272993e-01, 8.273117e-01, 8.273241e-01, 8.273365e-01, 8.273489e-01, 8.273613e-01,
    8.273737e-01, 8.273861e-01, 8.273985e-01, 8.274109e-01, 8.274233e-01, 8.274357e-01,
    8.274482e-01, 8.274605e-01, 8.274729e-01, 8.274854e-01, 8.274978e-01, 8.275102e-01,
    8.275226e-01, 8.275350e-01, 8.275474e-01, 8.275598e-01, 8.275722e-01, 8.275846e-01,
    8.275970e-01, 8.276094e-01, 8.276218e-01, 8.276343e-01, 8.276466e-01, 8.276590e-01,
    8.276714e-01, 8.276839e-01, 8.276963e-01, 8.277087e-01, 8.277210e-01, 8.277334e-01,
    8.277459e-01, 8.277583e-01, 8.277707e-01, 8.277830e-01, 8.277955e-01, 8.278079e-01,
    8.278202e-01, 8.278326e-01, 8.278451e-01, 8.278575e-01, 8.278699e-01, 8.278822e-01,
    8.278946e-01, 8.279071e-01, 8.279195e-01, 8.279319e-01, 8.279443e-01, 8.279566e-01,
    8.279691e-01, 8.279815e-01, 8.279939e-01, 8.280063e-01, 8.280187e-01, 8.280311e-01,
    8.280435e-01, 8.280559e-01, 8.280683e-01, 8.280807e-01, 8.280931e-01, 8.281055e-01,
    8.281178e-01, 8.281302e-01, 8.281426e-01, 8.281551e-01, 8.281675e-01, 8.281799e-01,
    8.281922e-01, 8.282046e-01, 8.282171e-01, 8.282295e-01, 8.282419e-01, 8.282543e-01,
    8.282666e-01, 8.282791e-01, 8.282915e-01, 8.283039e-01, 8.283163e-01, 8.283286e-01,
    8.283410e-01, 8.283535e-01, 8.283659e-01, 8.283783e-01, 8.283907e-01, 8.284030e-01,
    8.284154e-01, 8.284279e-01, 8.284402e-01, 8.284526e-01, 8.284650e-01, 8.284774e-01,
    8.284898e-01, 8.285022e-01, 8.285146e-01, 8.285270e-01, 8.285394e-01, 8.285518e-01,
    8.285642e-01, 8.285766e-01, 8.285890e-01, 8.286014e-01, 8.286138e-01, 8.286262e-01,
    8.286386e-01, 8.286510e-01, 8.286634e-01, 8.286758e-01, 8.286881e-01, 8.287005e-01,
    8.287129e-01, 8.287253e-01, 8.287377e-01, 8.287501e-01, 8.287625e-01, 8.287749e-01,
    8.287873e-01, 8.287997e-01, 8.288121e-01, 8.288245e-01, 8.288369e-01, 8.288493e-01,
    8.288617e-01, 8.288741e-01, 8.288864e-01, 8.288988e-01, 8.289112e-01, 8.289236e-01,
    8.289360e-01, 8.289484e-01, 8.289608e-01, 8.289732e-01, 8.289856e-01, 8.289980e-01,
    8.290104e-01, 8.290228e-01, 8.290352e-01, 8.290475e-01, 8.290599e-01, 8.290723e-01,
    8.290848e-01, 8.290972e-01, 8.291095e-01, 8.291219e-01, 8.291343e-01, 8.291467e-01,
    8.291591e-01, 8.291714e-01, 8.291838e-01, 8.291962e-01, 8.292087e-01, 8.292211e-01,
    8.292335e-01, 8.292458e-01, 8.292582e-01, 8.292706e-01, 8.292830e-01, 8.292953e-01,
    8.293077e-01, 8.293201e-01, 8.293325e-01, 8.293449e-01, 8.293573e-01, 8.293697e-01,
    8.293821e-01, 8.293945e-01, 8.294069e-01, 8.294193e-01, 8.294317e-01, 8.294441e-01,
    8.294564e-01, 8.294688e-01, 8.294812e-01, 8.294936e-01, 8.295059e-01, 8.295183e-01,
    8.295307e-01, 8.295431e-01, 8.295555e-01, 8.295680e-01, 8.295803e-01, 8.295927e-01,
    8.296051e-01, 8.296175e-01, 8.296298e-01, 8.296422e-01, 8.296546e-01, 8.296670e-01,
    8.296794e-01, 8.296918e-01, 8.297042e-01, 8.297166e-01, 8.297289e-01, 8.297413e-01,
    8.297537e-01, 8.297661e-01, 8.297784e-01, 8.297908e-01, 8.298032e-01, 8.298156e-01,
    8.298280e-01, 8.298404e-01, 8.298528e-01, 8.298652e-01, 8.298775e-01, 8.298899e-01,
    8.299023e-01, 8.299147e-01, 8.299270e-01, 8.299394e-01, 8.299518e-01, 8.299642e-01,
    8.299766e-01, 8.299890e-01, 8.300014e-01, 8.300138e-01, 8.300262e-01, 8.300385e-01,
    8.300509e-01, 8.300633e-01, 8.300757e-01, 8.300881e-01, 8.301005e-01, 8.301129e-01,
    8.301253e-01, 8.301376e-01, 8.301500e-01, 8.301624e-01, 8.301747e-01, 8.301871e-01,
    8.301995e-01, 8.302119e-01, 8.302242e-01, 8.302366e-01, 8.302490e-01, 8.302613e-01,
    8.302737e-01, 8.302861e-01, 8.302985e-01, 8.303109e-01, 8.303233e-01, 8.303357e-01,
    8.303481e-01, 8.303604e-01, 8.303728e-01, 8.303852e-01, 8.303976e-01, 8.304099e-01,
    8.304223e-01, 8.304347e-01, 8.304471e-01, 8.304595e-01, 8.304719e-01, 8.304843e-01,
    8.304967e-01, 8.305090e-01, 8.305214e-01, 8.305338e-01, 8.305462e-01, 8.305585e-01,
    8.305709e-01, 8.305833e-01, 8.305956e-01, 8.306080e-01, 8.306204e-01, 8.306327e-01,
    8.306451e-01, 8.306575e-01, 8.306699e-01, 8.306823e-01, 8.306947e-01, 8.307071e-01,
    8.307195e-01, 8.307318e-01, 8.307442e-01, 8.307566e-01, 8.307690e-01, 8.307813e-01,
    8.307937e-01, 8.308061e-01, 8.308184e-01, 8.308308e-01, 8.308432e-01, 8.308556e-01,
    8.308679e-01, 8.308803e-01, 8.308927e-01, 8.309051e-01, 8.309175e-01, 8.309299e-01,
    8.309423e-01, 8.309546e-01, 8.309669e-01, 8.309793e-01, 8.309917e-01, 8.310041e-01,
    8.310165e-01, 8.310289e-01, 8.310412e-01, 8.310536e-01, 8.310660e-01, 8.310783e-01,
    8.310907e-01, 8.311031e-01, 8.311154e-01, 8.311278e-01, 8.311402e-01, 8.311526e-01,
    8.311650e-01, 8.311774e-01, 8.311898e-01, 8.312020e-01, 8.312144e-01, 8.312268e-01,
    8.312392e-01, 8.312516e-01, 8.312640e-01, 8.312764e-01, 8.312887e-01, 8.313010e-01,
    8.313134e-01, 8.313258e-01, 8.313382e-01, 8.313506e-01, 8.313629e-01, 8.313753e-01,
    8.313877e-01, 8.314000e-01, 8.314124e-01, 8.314248e-01, 8.314371e-01, 8.314495e-01,
    8.314619e-01, 8.314743e-01, 8.314866e-01, 8.314990e-01, 8.315114e-01, 8.315237e-01,
    8.315361e-01, 8.315485e-01, 8.315609e-01, 8.315732e-01, 8.315856e-01, 8.315979e-01,
    8.316103e-01, 8.316227e-01, 8.316351e-01, 8.316475e-01, 8.316598e-01, 8.316721e-01,
    8.316845e-01, 8.316969e-01, 8.317093e-01, 8.317217e-01, 8.317340e-01, 8.317463e-01,
    8.317587e-01, 8.317711e-01, 8.317835e-01, 8.317959e-01, 8.318082e-01, 8.318205e-01,
    8.318329e-01, 8.318453e-01, 8.318577e-01, 8.318701e-01, 8.318824e-01, 8.318948e-01,
    8.319072e-01, 8.319196e-01, 8.319319e-01, 8.319442e-01, 8.319566e-01, 8.319690e-01,
    8.319814e-01, 8.319938e-01, 8.320062e-01, 8.320184e-01, 8.320308e-01, 8.320432e-01,
    8.320556e-01, 8.320680e-01, 8.320802e-01, 8.320926e-01, 8.321050e-01, 8.321174e-01,
    8.321298e-01, 8.321421e-01, 8.321545e-01, 8.321669e-01, 8.321792e-01, 8.321915e-01,
    8.322039e-01, 8.322163e-01, 8.322287e-01, 8.322411e-01, 8.322534e-01, 8.322657e-01,
    8.322781e-01, 8.322905e-01, 8.323029e-01, 8.323152e-01, 8.323276e-01, 8.323399e-01,
    8.323523e-01, 8.323646e-01, 8.323770e-01, 8.323894e-01, 8.324018e-01, 8.324141e-01,
    8.324265e-01, 8.324388e-01, 8.324512e-01, 8.324636e-01, 8.324759e-01, 8.324883e-01,
    8.325007e-01, 8.325130e-01, 8.325254e-01, 8.325378e-01, 8.325501e-01, 8.325625e-01,
    8.325748e-01, 8.325872e-01, 8.325996e-01, 8.326120e-01, 8.326243e-01, 8.326367e-01,
    8.326490e-01, 8.326614e-01, 8.326737e-01, 8.326861e-01, 8.326985e-01, 8.327109e-01,
    8.327231e-01, 8.327355e-01, 8.327479e-01, 8.327602e-01, 8.327726e-01, 8.327850e-01,
    8.327973e-01, 8.328096e-01, 8.328220e-01, 8.328344e-01, 8.328468e-01, 8.328591e-01,
    8.328715e-01, 8.328838e-01, 8.328962e-01, 8.329085e-01, 8.329209e-01, 8.329333e-01,
    8.329456e-01, 8.329580e-01, 8.329704e-01, 8.329827e-01, 8.329951e-01, 8.330075e-01,
    8.330198e-01, 8.330321e-01, 8.330445e-01, 8.330569e-01, 8.330691e-01, 8.330815e-01,
    8.330939e-01, 8.331062e-01, 8.331186e-01, 8.331310e-01, 8.331434e-01, 8.331557e-01,
    8.331680e-01, 8.331804e-01, 8.331928e-01, 8.332051e-01, 8.332175e-01, 8.332298e-01,
    8.332422e-01, 8.332546e-01, 8.332669e-01, 8.332793e-01, 8.332916e-01, 8.333039e-01,
    8.333163e-01, 8.333287e-01, 8.333411e-01, 8.333533e-01, 8.333657e-01, 8.333781e-01,
    8.333904e-01, 8.334028e-01, 8.334152e-01, 8.334275e-01, 8.334399e-01, 8.334523e-01,
    8.334646e-01, 8.334770e-01, 8.334893e-01, 8.335016e-01, 8.335140e-01, 8.335263e-01,
    8.335387e-01, 8.335510e-01, 8.335634e-01, 8.335757e-01, 8.335881e-01, 8.336004e-01,
    8.336128e-01, 8.336252e-01, 8.336375e-01, 8.336499e-01, 8.336623e-01, 8.336746e-01,
    8.336869e-01, 8.336993e-01, 8.337116e-01, 8.337240e-01, 8.337363e-01, 8.337487e-01,
    8.337610e-01, 8.337734e-01, 8.337857e-01, 8.337981e-01, 8.338104e-01, 8.338228e-01,
    8.338352e-01, 8.338475e-01, 8.338599e-01, 8.338721e-01, 8.338845e-01, 8.338969e-01,
    8.339092e-01, 8.339216e-01, 8.339339e-01, 8.339463e-01, 8.339587e-01, 8.339710e-01,
    8.339834e-01, 8.339957e-01, 8.340080e-01, 8.340204e-01, 8.340327e-01, 8.340451e-01,
    8.340575e-01, 8.340698e-01, 8.340821e-01, 8.340945e-01, 8.341068e-01, 8.341192e-01,
    8.341315e-01, 8.341439e-01, 8.341562e-01, 8.341686e-01, 8.341810e-01, 8.341932e-01,
    8.342056e-01, 8.342179e-01, 8.342303e-01, 8.342426e-01, 8.342550e-01, 8.342674e-01,
    8.342797e-01, 8.342921e-01, 8.343043e-01, 8.343167e-01, 8.343291e-01, 8.343414e-01,
    8.343538e-01, 8.343661e-01, 8.343785e-01, 8.343908e-01, 8.344032e-01, 8.344156e-01,
    8.344278e-01, 8.344402e-01, 8.344525e-01, 8.344649e-01, 8.344772e-01, 8.344896e-01,
    8.345019e-01, 8.345143e-01, 8.345267e-01, 8.345389e-01, 8.345513e-01, 8.345636e-01,
    8.345760e-01, 8.345883e-01, 8.346007e-01, 8.346130e-01, 8.346254e-01, 8.346378e-01,
    8.346500e-01, 8.346624e-01, 8.346747e-01, 8.346871e-01, 8.346994e-01, 8.347118e-01,
    8.347241e-01, 8.347365e-01, 8.347487e-01, 8.347611e-01, 8.347734e-01, 8.347858e-01,
    8.347982e-01, 8.348105e-01, 8.348229e-01, 8.348352e-01, 8.348476e-01, 8.348598e-01,
    8.348722e-01, 8.348845e-01, 8.348969e-01, 8.349092e-01, 8.349216e-01, 8.349339e-01,
    8.349463e-01, 8.349586e-01, 8.349710e-01, 8.349832e-01, 8.349956e-01, 8.350079e-01,
    8.350203e-01, 8.350326e-01, 8.350450e-01, 8.350573e-01, 8.350697e-01, 8.350820e-01,
    8.350943e-01, 8.351067e-01, 8.351190e-01, 8.351313e-01, 8.351437e-01, 8.351560e-01,
    8.351684e-01, 8.351807e-01, 8.351930e-01, 8.352054e-01, 8.352178e-01, 8.352301e-01,
    8.352425e-01, 8.352547e-01, 8.352671e-01, 8.352794e-01, 8.352918e-01, 8.353041e-01,
    8.353165e-01, 8.353288e-01, 8.353412e-01, 8.353534e-01, 8.353658e-01, 8.353781e-01,
    8.353905e-01, 8.354028e-01, 8.354151e-01, 8.354275e-01, 8.354398e-01, 8.354521e-01,
    8.354645e-01, 8.354768e-01, 8.354892e-01, 8.355015e-01, 8.355138e-01, 8.355262e-01,
    8.355385e-01, 8.355509e-01, 8.355632e-01, 8.355755e-01, 8.355879e-01, 8.356001e-01,
    8.356125e-01, 8.356248e-01, 8.356372e-01, 8.356495e-01, 8.356619e-01, 8.356742e-01,
    8.356865e-01, 8.356988e-01, 8.357112e-01, 8.357235e-01, 8.357359e-01, 8.357483e-01,
    8.357605e-01, 8.357729e-01, 8.357852e-01, 8.357975e-01, 8.358099e-01, 8.358222e-01,
    8.358346e-01, 8.358468e-01, 8.358592e-01, 8.358715e-01, 8.358839e-01, 8.358962e-01,
    8.359085e-01, 8.359209e-01, 8.359332e-01, 8.359455e-01, 8.359579e-01, 8.359702e-01,
    8.359826e-01, 8.359948e-01, 8.360072e-01, 8.360195e-01, 8.360319e-01, 8.360442e-01,
    8.360565e-01, 8.360689e-01, 8.360812e-01, 8.360935e-01, 8.361059e-01, 8.361182e-01,
    8.361306e-01, 8.361428e-01, 8.361551e-01, 8.361675e-01, 8.361798e-01, 8.361922e-01,
    8.362045e-01, 8.362168e-01, 8.362292e-01, 8.362415e-01, 8.362538e-01, 8.362662e-01,
    8.362784e-01, 8.362908e-01, 8.363031e-01, 8.363155e-01, 8.363278e-01, 8.363401e-01,
    8.363524e-01, 8.363648e-01, 8.363771e-01, 8.363895e-01, 8.364018e-01, 8.364140e-01,
    8.364264e-01, 8.364387e-01, 8.364511e-01, 8.364634e-01, 8.364757e-01, 8.364881e-01,
    8.365004e-01, 8.365127e-01, 8.365251e-01, 8.365374e-01, 8.365496e-01, 8.365620e-01,
    8.365744e-01, 8.365867e-01, 8.365991e-01, 8.366113e-01, 8.366236e-01, 8.366360e-01,
    8.366483e-01, 8.366606e-01, 8.366730e-01, 8.366853e-01, 8.366976e-01, 8.367100e-01,
    8.367223e-01, 8.367347e-01, 8.367469e-01, 8.367592e-01, 8.367716e-01, 8.367839e-01,
    8.367962e-01, 8.368086e-01, 8.368209e-01, 8.368332e-01, 8.368455e-01, 8.368579e-01,
    8.368701e-01, 8.368825e-01, 8.368948e-01, 8.369071e-01, 8.369194e-01, 8.369318e-01,
    8.369441e-01, 8.369564e-01, 8.369688e-01, 8.369811e-01, 8.369934e-01, 8.370058e-01,
    8.370181e-01, 8.370304e-01, 8.370427e-01, 8.370550e-01, 8.370673e-01, 8.370796e-01,
    8.370920e-01, 8.371043e-01, 8.371166e-01, 8.371290e-01, 8.371413e-01, 8.371536e-01,
    8.371660e-01, 8.371783e-01, 8.371906e-01, 8.372028e-01, 8.372152e-01, 8.372275e-01,
    8.372399e-01, 8.372522e-01, 8.372645e-01, 8.372768e-01, 8.372891e-01, 8.373015e-01,
    8.373138e-01, 8.373261e-01, 8.373384e-01, 8.373508e-01, 8.373631e-01, 8.373753e-01,
    8.373877e-01, 8.374000e-01, 8.374124e-01, 8.374246e-01, 8.374370e-01, 8.374493e-01,
    8.374616e-01, 8.374740e-01, 8.374863e-01, 8.374986e-01, 8.375109e-01, 8.375233e-01,
    8.375356e-01, 8.375478e-01, 8.375602e-01, 8.375725e-01, 8.375849e-01, 8.375971e-01,
    8.376094e-01, 8.376218e-01, 8.376341e-01, 8.376464e-01, 8.376587e-01, 8.376711e-01,
    8.376834e-01, 8.376957e-01, 8.377080e-01, 8.377203e-01, 8.377327e-01, 8.377450e-01,
    8.377572e-01, 8.377696e-01, 8.377819e-01, 8.377942e-01, 8.378065e-01, 8.378188e-01,
    8.378312e-01, 8.378435e-01, 8.378558e-01, 8.378681e-01, 8.378805e-01, 8.378928e-01,
    8.379050e-01, 8.379174e-01, 8.379297e-01, 8.379421e-01, 8.379543e-01, 8.379666e-01,
    8.379789e-01, 8.379913e-01, 8.380036e-01, 8.380159e-01, 8.380282e-01, 8.380405e-01,
    8.380529e-01, 8.380652e-01, 8.380775e-01, 8.380898e-01, 8.381020e-01, 8.381144e-01,
    8.381267e-01, 8.381391e-01, 8.381513e-01, 8.381636e-01, 8.381760e-01, 8.381883e-01,
    8.382006e-01, 8.382129e-01, 8.382252e-01, 8.382376e-01, 8.382499e-01, 8.382622e-01,
    8.382745e-01, 8.382868e-01, 8.382991e-01, 8.383114e-01, 8.383238e-01, 8.383361e-01,
    8.383483e-01, 8.383607e-01, 8.383729e-01, 8.383853e-01, 8.383976e-01, 8.384099e-01,
    8.384222e-01, 8.384345e-01, 8.384469e-01, 8.384592e-01, 8.384715e-01, 8.384838e-01,
    8.384961e-01, 8.385084e-01, 8.385206e-01, 8.385330e-01, 8.385454e-01, 8.385577e-01,
    8.385699e-01, 8.385822e-01, 8.385946e-01, 8.386069e-01, 8.386192e-01, 8.386315e-01,
    8.386438e-01, 8.386561e-01, 8.386684e-01, 8.386807e-01, 8.386931e-01, 8.387054e-01,
    8.387177e-01, 8.387300e-01, 8.387423e-01, 8.387546e-01, 8.387669e-01, 8.387793e-01,
    8.387915e-01, 8.388038e-01, 8.388162e-01, 8.388284e-01, 8.388407e-01, 8.388530e-01,
    8.388653e-01, 8.388777e-01, 8.388900e-01, 8.389023e-01, 8.389146e-01, 8.389269e-01,
    8.389392e-01, 8.389515e-01, 8.389638e-01, 8.389761e-01, 8.389885e-01, 8.390008e-01,
    8.390130e-01, 8.390254e-01, 8.390377e-01, 8.390499e-01, 8.390623e-01, 8.390746e-01,
    8.390869e-01, 8.390992e-01, 8.391115e-01, 8.391238e-01, 8.391361e-01, 8.391484e-01,
    8.391607e-01, 8.391730e-01, 8.391853e-01, 8.391976e-01, 8.392100e-01, 8.392223e-01,
    8.392346e-01, 8.392469e-01, 8.392591e-01, 8.392715e-01, 8.392838e-01, 8.392960e-01,
    8.393084e-01, 8.393207e-01, 8.393329e-01, 8.393452e-01, 8.393576e-01, 8.393700e-01,
    8.393822e-01, 8.393945e-01, 8.394068e-01, 8.394191e-01, 8.394314e-01, 8.394437e-01,
    8.394560e-01, 8.394683e-01, 8.394806e-01, 8.394929e-01, 8.395052e-01, 8.395175e-01,
    8.395298e-01, 8.395422e-01, 8.395545e-01, 8.395668e-01, 8.395790e-01, 8.395913e-01,
    8.396037e-01, 8.396159e-01, 8.396282e-01, 8.396406e-01, 8.396528e-01, 8.396651e-01,
    8.396775e-01, 8.396897e-01, 8.397020e-01, 8.397143e-01, 8.397266e-01, 8.397389e-01,
    8.397512e-01, 8.397635e-01, 8.397758e-01, 8.397881e-01, 8.398004e-01, 8.398128e-01,
    8.398251e-01, 8.398374e-01, 8.398497e-01, 8.398620e-01, 8.398743e-01, 8.398865e-01,
    8.398989e-01, 8.399112e-01, 8.399234e-01, 8.399357e-01, 8.399481e-01, 8.399603e-01,
    8.399726e-01, 8.399850e-01, 8.399972e-01, 8.400095e-01, 8.400218e-01, 8.400341e-01,
    8.400464e-01, 8.400587e-01, 8.400710e-01, 8.400833e-01, 8.400956e-01, 8.401079e-01,
    8.401202e-01, 8.401325e-01, 8.401448e-01, 8.401571e-01, 8.401694e-01, 8.401817e-01,
    8.401940e-01, 8.402063e-01, 8.402185e-01, 8.402309e-01, 8.402432e-01, 8.402554e-01,
    8.402678e-01, 8.402801e-01, 8.402923e-01, 8.403047e-01, 8.403170e-01, 8.403292e-01,
    8.403416e-01, 8.403538e-01, 8.403661e-01, 8.403784e-01, 8.403907e-01, 8.404030e-01,
    8.404153e-01, 8.404276e-01, 8.404399e-01, 8.404521e-01, 8.404644e-01, 8.404767e-01,
    8.404890e-01, 8.405013e-01, 8.405136e-01, 8.405259e-01, 8.405382e-01, 8.405505e-01,
    8.405628e-01, 8.405751e-01, 8.405874e-01, 8.405997e-01, 8.406120e-01, 8.406243e-01,
    8.406366e-01, 8.406489e-01, 8.406612e-01, 8.406734e-01, 8.406858e-01, 8.406981e-01,
    8.407103e-01, 8.407226e-01, 8.407348e-01, 8.407472e-01, 8.407595e-01, 8.407717e-01,
    8.407841e-01, 8.407964e-01, 8.408086e-01, 8.408210e-01, 8.408332e-01, 8.408455e-01,
    8.408578e-01, 8.408701e-01, 8.408824e-01, 8.408947e-01, 8.409069e-01, 8.409193e-01,
    8.409315e-01, 8.409438e-01, 8.409561e-01, 8.409684e-01, 8.409807e-01, 8.409930e-01,
    8.410053e-01, 8.410176e-01, 8.410299e-01, 8.410422e-01, 8.410544e-01, 8.410667e-01,
    8.410790e-01, 8.410913e-01, 8.411036e-01, 8.411159e-01, 8.411282e-01, 8.411405e-01,
    8.411528e-01, 8.411651e-01, 8.411773e-01, 8.411896e-01, 8.412019e-01, 8.412142e-01,
    8.412265e-01, 8.412388e-01, 8.412511e-01, 8.412634e-01, 8.412757e-01, 8.412879e-01,
    8.413002e-01, 8.413125e-01, 8.413247e-01, 8.413371e-01, 8.413494e-01, 8.413616e-01,
    8.413740e-01, 8.413863e-01, 8.413985e-01, 8.414108e-01, 8.414230e-01, 8.414354e-01,
    8.414477e-01, 8.414599e-01, 8.414723e-01, 8.414844e-01, 8.414968e-01, 8.415090e-01,
    8.415213e-01, 8.415337e-01, 8.415459e-01, 8.415582e-01, 8.415706e-01, 8.415827e-01,
    8.415951e-01, 8.416073e-01, 8.416196e-01, 8.416319e-01, 8.416442e-01, 8.416564e-01,
    8.416687e-01, 8.416810e-01, 8.416933e-01, 8.417056e-01, 8.417179e-01, 8.417302e-01,
    8.417424e-01, 8.417547e-01, 8.417670e-01, 8.417793e-01, 8.417916e-01, 8.418039e-01,
    8.418161e-01, 8.418284e-01, 8.418407e-01, 8.418530e-01, 8.418653e-01, 8.418776e-01,
    8.418898e-01, 8.419021e-01, 8.419144e-01, 8.419267e-01, 8.419390e-01, 8.419513e-01,
    8.419635e-01, 8.419758e-01, 8.419881e-01, 8.420004e-01, 8.420127e-01, 8.420249e-01,
    8.420372e-01, 8.420495e-01, 8.420618e-01, 8.420741e-01, 8.420863e-01, 8.420986e-01,
    8.421109e-01, 8.421232e-01, 8.421355e-01, 8.421477e-01, 8.421600e-01, 8.421723e-01,
    8.421846e-01, 8.421969e-01, 8.422091e-01, 8.422214e-01, 8.422337e-01, 8.422460e-01,
    8.422583e-01, 8.422705e-01, 8.422828e-01, 8.422951e-01, 8.423074e-01, 8.423197e-01,
    8.423319e-01, 8.423442e-01, 8.423565e-01, 8.423688e-01, 8.423810e-01, 8.423933e-01,
    8.424056e-01, 8.424179e-01, 8.424302e-01, 8.424424e-01, 8.424547e-01, 8.424670e-01,
    8.424793e-01, 8.424915e-01, 8.425038e-01, 8.425161e-01, 8.425284e-01, 8.425406e-01,
    8.425529e-01, 8.425652e-01, 8.425775e-01, 8.425897e-01, 8.426020e-01, 8.426143e-01,
    8.426266e-01, 8.426388e-01, 8.426511e-01, 8.426634e-01, 8.426757e-01, 8.426879e-01,
    8.427002e-01, 8.427125e-01, 8.427248e-01, 8.427370e-01, 8.427493e-01, 8.427616e-01,
    8.427739e-01, 8.427861e-01, 8.427984e-01, 8.428107e-01, 8.428230e-01, 8.428352e-01,
    8.428475e-01, 8.428598e-01, 8.428721e-01, 8.428843e-01, 8.428966e-01, 8.429089e-01,
    8.429211e-01, 8.429334e-01, 8.429457e-01, 8.429580e-01, 8.429702e-01, 8.429825e-01,
    8.429948e-01, 8.430070e-01, 8.430193e-01, 8.430316e-01, 8.430439e-01, 8.430561e-01,
    8.430684e-01, 8.430807e-01, 8.430929e-01, 8.431052e-01, 8.431175e-01, 8.431298e-01,
    8.431420e-01, 8.431543e-01, 8.431666e-01, 8.431788e-01, 8.431911e-01, 8.432034e-01,
    8.432156e-01, 8.432279e-01, 8.432402e-01, 8.432525e-01, 8.432648e-01, 8.432770e-01,
    8.432893e-01, 8.433015e-01, 8.433138e-01, 8.433262e-01, 8.433383e-01, 8.433506e-01,
    8.433629e-01, 8.433751e-01, 8.433874e-01, 8.433998e-01, 8.434119e-01, 8.434243e-01,
    8.434365e-01, 8.434488e-01, 8.434610e-01, 8.434733e-01, 8.434855e-01, 8.434979e-01,
    8.435102e-01, 8.435224e-01, 8.435346e-01, 8.435469e-01, 8.435591e-01, 8.435715e-01,
    8.435838e-01, 8.435960e-01, 8.436083e-01, 8.436205e-01, 8.436328e-01, 8.436451e-01,
    8.436574e-01, 8.436696e-01, 8.436819e-01, 8.436942e-01, 8.437064e-01, 8.437186e-01,
    8.437310e-01, 8.437432e-01, 8.437555e-01, 8.437677e-01, 8.437800e-01, 8.437923e-01,
    8.438045e-01, 8.438168e-01, 8.438291e-01, 8.438413e-01, 8.438536e-01, 8.438659e-01,
    8.438781e-01, 8.438904e-01, 8.439026e-01, 8.439149e-01, 8.439272e-01, 8.439394e-01,
    8.439517e-01, 8.439640e-01, 8.439762e-01, 8.439885e-01, 8.440008e-01, 8.440130e-01,
    8.440253e-01, 8.440375e-01, 8.440498e-01, 8.440620e-01, 8.440743e-01, 8.440866e-01,
    8.440989e-01, 8.441111e-01, 8.441234e-01, 8.441356e-01, 8.441479e-01, 8.441601e-01,
    8.441725e-01, 8.441848e-01, 8.441970e-01, 8.442093e-01, 8.442215e-01, 8.442338e-01,
    8.442461e-01, 8.442582e-01, 8.442706e-01, 8.442828e-01, 8.442951e-01, 8.443073e-01,
    8.443196e-01, 8.443319e-01, 8.443441e-01, 8.443564e-01, 8.443686e-01, 8.443809e-01,
    8.443932e-01, 8.444054e-01, 8.444177e-01, 8.444299e-01, 8.444422e-01, 8.444544e-01,
    8.444667e-01, 8.444790e-01, 8.444912e-01, 8.445035e-01, 8.445157e-01, 8.445280e-01,
    8.445402e-01, 8.445525e-01, 8.445649e-01, 8.445770e-01, 8.445894e-01, 8.446016e-01,
    8.446139e-01, 8.446261e-01, 8.446383e-01, 8.446506e-01, 8.446628e-01, 8.446752e-01,
    8.446873e-01, 8.446997e-01, 8.447119e-01, 8.447242e-01, 8.447364e-01, 8.447487e-01,
    8.447609e-01, 8.447732e-01, 8.447854e-01, 8.447977e-01, 8.448099e-01, 8.448222e-01,
    8.448345e-01, 8.448467e-01, 8.448590e-01, 8.448712e-01, 8.448835e-01, 8.448957e-01,
    8.449080e-01, 8.449202e-01, 8.449326e-01, 8.449447e-01, 8.449571e-01, 8.449693e-01,
    8.449816e-01, 8.449938e-01, 8.450060e-01, 8.450183e-01, 8.450305e-01, 8.450428e-01,
    8.450550e-01, 8.450673e-01, 8.450796e-01, 8.450919e-01, 8.451041e-01, 8.451164e-01,
    8.451286e-01, 8.451409e-01, 8.451531e-01, 8.451654e-01, 8.451776e-01, 8.451899e-01,
    8.452021e-01, 8.452144e-01, 8.452266e-01, 8.452389e-01, 8.452511e-01, 8.452634e-01,
    8.452756e-01, 8.452879e-01, 8.453001e-01, 8.453124e-01, 8.453246e-01, 8.453369e-01,
    8.453491e-01, 8.453614e-01, 8.453737e-01, 8.453858e-01, 8.453982e-01, 8.454104e-01,
    8.454227e-01, 8.454349e-01, 8.454472e-01, 8.454594e-01, 8.454717e-01, 8.454839e-01,
    8.454962e-01, 8.455084e-01, 8.455207e-01, 8.455329e-01, 8.455452e-01, 8.455575e-01,
    8.455697e-01, 8.455819e-01, 8.455942e-01, 8.456064e-01, 8.456187e-01, 8.456309e-01,
    8.456432e-01, 8.456554e-01, 8.456677e-01, 8.456799e-01, 8.456922e-01, 8.457044e-01,
    8.457167e-01, 8.457289e-01, 8.457412e-01, 8.457534e-01, 8.457657e-01, 8.457779e-01,
    8.457902e-01, 8.458024e-01, 8.458146e-01, 8.458269e-01, 8.458391e-01, 8.458514e-01,
    8.458636e-01, 8.458759e-01, 8.458881e-01, 8.459004e-01, 8.459126e-01, 8.459249e-01,
    8.459372e-01, 8.459494e-01, 8.459617e-01, 8.459739e-01, 8.459861e-01, 8.459984e-01,
    8.460106e-01, 8.460229e-01, 8.460351e-01, 8.460474e-01, 8.460596e-01, 8.460718e-01,
    8.460841e-01, 8.460963e-01, 8.461086e-01, 8.461208e-01, 8.461331e-01, 8.461453e-01,
    8.461576e-01, 8.461699e-01, 8.461820e-01, 8.461943e-01, 8.462066e-01, 8.462188e-01,
    8.462311e-01, 8.462433e-01, 8.462555e-01, 8.462678e-01, 8.462800e-01, 8.462923e-01,
    8.463045e-01, 8.463168e-01, 8.463290e-01, 8.463413e-01, 8.463535e-01, 8.463657e-01,
    8.463780e-01, 8.463902e-01, 8.464025e-01, 8.464147e-01, 8.464270e-01, 8.464392e-01,
    8.464515e-01, 8.464637e-01, 8.464759e-01, 8.464882e-01, 8.465004e-01, 8.465126e-01,
    8.465249e-01, 8.465371e-01, 8.465495e-01, 8.465616e-01, 8.465738e-01, 8.465862e-01,
    8.465983e-01, 8.466105e-01, 8.466229e-01, 8.466351e-01, 8.466473e-01, 8.466596e-01,
    8.466718e-01, 8.466840e-01, 8.466963e-01, 8.467085e-01, 8.467207e-01, 8.467330e-01,
    8.467453e-01, 8.467575e-01, 8.467698e-01, 8.467820e-01, 8.467942e-01, 8.468065e-01,
    8.468187e-01, 8.468310e-01, 8.468432e-01, 8.468554e-01, 8.468677e-01, 8.468799e-01,
    8.468921e-01, 8.469044e-01, 8.469166e-01, 8.469288e-01, 8.469411e-01, 8.469533e-01,
    8.469656e-01, 8.469778e-01, 8.469900e-01, 8.470023e-01, 8.470145e-01, 8.470268e-01,
    8.470390e-01, 8.470512e-01, 8.470635e-01, 8.470757e-01, 8.470879e-01, 8.471002e-01,
    8.471124e-01, 8.471246e-01, 8.471369e-01, 8.471491e-01, 8.471614e-01, 8.471736e-01,
    8.471859e-01, 8.471981e-01, 8.472103e-01, 8.472226e-01, 8.472348e-01, 8.472470e-01,
    8.472593e-01, 8.472715e-01, 8.472837e-01, 8.472960e-01, 8.473082e-01, 8.473204e-01,
    8.473327e-01, 8.473449e-01, 8.473572e-01, 8.473694e-01, 8.473817e-01, 8.473939e-01,
    8.474061e-01, 8.474183e-01, 8.474306e-01, 8.474428e-01, 8.474550e-01, 8.474672e-01,
    8.474795e-01, 8.474917e-01, 8.475039e-01, 8.475162e-01, 8.475285e-01, 8.475407e-01,
    8.475528e-01, 8.475652e-01, 8.475774e-01, 8.475896e-01, 8.476018e-01, 8.476141e-01,
    8.476263e-01, 8.476385e-01, 8.476507e-01, 8.476630e-01, 8.476752e-01, 8.476874e-01,
    8.476996e-01, 8.477119e-01, 8.477241e-01, 8.477364e-01, 8.477486e-01, 8.477609e-01,
    8.477731e-01, 8.477853e-01, 8.477975e-01, 8.478098e-01, 8.478220e-01, 8.478342e-01,
    8.478464e-01, 8.478587e-01, 8.478709e-01, 8.478832e-01, 8.478954e-01, 8.479077e-01,
    8.479199e-01, 8.479321e-01, 8.479443e-01, 8.479565e-01, 8.479688e-01, 8.479810e-01,
    8.479932e-01, 8.480054e-01, 8.480178e-01, 8.480299e-01, 8.480421e-01, 8.480543e-01,
    8.480666e-01, 8.480788e-01, 8.480911e-01, 8.481033e-01, 8.481155e-01, 8.481278e-01,
    8.481400e-01, 8.481522e-01, 8.481644e-01, 8.481767e-01, 8.481889e-01, 8.482012e-01,
    8.482134e-01, 8.482256e-01, 8.482378e-01, 8.482501e-01, 8.482623e-01, 8.482745e-01,
    8.482867e-01, 8.482989e-01, 8.483112e-01, 8.483234e-01, 8.483356e-01, 8.483478e-01,
    8.483601e-01, 8.483723e-01, 8.483846e-01, 8.483968e-01, 8.484090e-01, 8.484212e-01,
    8.484334e-01, 8.484457e-01, 8.484579e-01, 8.484702e-01, 8.484823e-01, 8.484945e-01,
    8.485067e-01, 8.485191e-01, 8.485312e-01, 8.485435e-01, 8.485557e-01, 8.485679e-01,
    8.485801e-01, 8.485924e-01, 8.486046e-01, 8.486168e-01, 8.486291e-01, 8.486413e-01,
    8.486534e-01, 8.486658e-01, 8.486780e-01, 8.486902e-01, 8.487024e-01, 8.487146e-01,
    8.487268e-01, 8.487391e-01, 8.487513e-01, 8.487635e-01, 8.487757e-01, 8.487880e-01,
    8.488002e-01, 8.488124e-01, 8.488247e-01, 8.488369e-01, 8.488491e-01, 8.488613e-01,
    8.488735e-01, 8.488857e-01, 8.488979e-01, 8.489102e-01, 8.489224e-01, 8.489347e-01,
    8.489469e-01, 8.489591e-01, 8.489713e-01, 8.489835e-01, 8.489957e-01, 8.490079e-01,
    8.490202e-01, 8.490324e-01, 8.490446e-01, 8.490568e-01, 8.490691e-01, 8.490813e-01,
    8.490935e-01, 8.491057e-01, 8.491180e-01, 8.491302e-01, 8.491424e-01, 8.491546e-01,
    8.491668e-01, 8.491790e-01, 8.491912e-01, 8.492035e-01, 8.492157e-01, 8.492280e-01,
    8.492402e-01, 8.492524e-01, 8.492646e-01, 8.492768e-01, 8.492890e-01, 8.493012e-01,
    8.493134e-01, 8.493257e-01, 8.493379e-01, 8.493501e-01, 8.493624e-01, 8.493746e-01,
    8.493868e-01, 8.493990e-01, 8.494112e-01, 8.494234e-01, 8.494356e-01, 8.494478e-01,
    8.494601e-01, 8.494723e-01, 8.494845e-01, 8.494967e-01, 8.495090e-01, 8.495212e-01,
    8.495334e-01, 8.495456e-01, 8.495578e-01, 8.495700e-01, 8.495823e-01, 8.495945e-01,
    8.496067e-01, 8.496189e-01, 8.496311e-01, 8.496433e-01, 8.496555e-01, 8.496677e-01,
    8.496799e-01, 8.496922e-01, 8.497044e-01, 8.497167e-01, 8.497289e-01, 8.497411e-01,
    8.497533e-01, 8.497655e-01, 8.497777e-01, 8.497899e-01, 8.498021e-01, 8.498144e-01,
    8.498266e-01, 8.498388e-01, 8.498510e-01, 8.498632e-01, 8.498754e-01, 8.498876e-01,
    8.498998e-01, 8.499120e-01, 8.499243e-01, 8.499364e-01, 8.499486e-01, 8.499609e-01,
    8.499731e-01, 8.499853e-01, 8.499975e-01, 8.500098e-01, 8.500220e-01, 8.500342e-01,
    8.500465e-01, 8.500587e-01, 8.500708e-01, 8.500831e-01, 8.500953e-01, 8.501075e-01,
    8.501197e-01, 8.501319e-01, 8.501441e-01, 8.501563e-01, 8.501685e-01, 8.501807e-01,
    8.501930e-01, 8.502052e-01, 8.502174e-01, 8.502296e-01, 8.502418e-01, 8.502540e-01,
    8.502662e-01, 8.502784e-01, 8.502907e-01, 8.503029e-01, 8.503151e-01, 8.503273e-01,
    8.503395e-01, 8.503517e-01, 8.503639e-01, 8.503761e-01, 8.503883e-01, 8.504006e-01,
    8.504128e-01, 8.504249e-01, 8.504372e-01, 8.504494e-01, 8.504616e-01, 8.504738e-01,
    8.504860e-01, 8.504981e-01, 8.505104e-01, 8.505226e-01, 8.505348e-01, 8.505470e-01,
    8.505592e-01, 8.505714e-01, 8.505836e-01, 8.505958e-01, 8.506081e-01, 8.506203e-01,
    8.506325e-01, 8.506446e-01, 8.506569e-01, 8.506691e-01, 8.506813e-01, 8.506935e-01,
    8.507057e-01, 8.507180e-01, 8.507302e-01, 8.507423e-01, 8.507546e-01, 8.507668e-01,
    8.507790e-01, 8.507912e-01, 8.508034e-01, 8.508155e-01, 8.508278e-01, 8.508400e-01,
    8.508522e-01, 8.508644e-01, 8.508766e-01, 8.508888e-01, 8.509010e-01, 8.509132e-01,
    8.509254e-01, 8.509377e-01, 8.509499e-01, 8.509620e-01, 8.509743e-01, 8.509865e-01,
    8.509986e-01, 8.510108e-01, 8.510230e-01, 8.510352e-01, 8.510475e-01, 8.510597e-01,
    8.510719e-01, 8.510841e-01, 8.510963e-01, 8.511085e-01, 8.511207e-01, 8.511329e-01,
    8.511451e-01, 8.511572e-01, 8.511695e-01, 8.511817e-01, 8.511939e-01, 8.512061e-01,
    8.512183e-01, 8.512306e-01, 8.512427e-01, 8.512549e-01, 8.512672e-01, 8.512793e-01,
    8.512915e-01, 8.513037e-01, 8.513159e-01, 8.513281e-01, 8.513404e-01, 8.513526e-01,
    8.513648e-01, 8.513770e-01, 8.513892e-01, 8.514013e-01, 8.514135e-01, 8.514257e-01,
    8.514379e-01, 8.514501e-01, 8.514624e-01, 8.514746e-01, 8.514868e-01, 8.514989e-01,
    8.515111e-01, 8.515233e-01, 8.515356e-01, 8.515478e-01, 8.515600e-01, 8.515722e-01,
    8.515844e-01, 8.515965e-01, 8.516088e-01, 8.516209e-01, 8.516331e-01, 8.516454e-01,
    8.516576e-01, 8.516698e-01, 8.516820e-01, 8.516941e-01, 8.517063e-01, 8.517185e-01,
    8.517308e-01, 8.517430e-01, 8.517551e-01, 8.517673e-01, 8.517795e-01, 8.517917e-01,
    8.518039e-01, 8.518161e-01, 8.518283e-01, 8.518406e-01, 8.518527e-01, 8.518649e-01,
    8.518771e-01, 8.518893e-01, 8.519015e-01, 8.519138e-01, 8.519258e-01, 8.519381e-01,
    8.519503e-01, 8.519625e-01, 8.519747e-01, 8.519869e-01, 8.519990e-01, 8.520113e-01,
    8.520235e-01, 8.520357e-01, 8.520479e-01, 8.520601e-01, 8.520722e-01, 8.520845e-01,
    8.520966e-01, 8.521088e-01, 8.521211e-01, 8.521332e-01, 8.521454e-01, 8.521576e-01,
    8.521698e-01, 8.521820e-01, 8.521942e-01, 8.522063e-01, 8.522186e-01, 8.522308e-01,
    8.522430e-01, 8.522552e-01, 8.522673e-01, 8.522795e-01, 8.522918e-01, 8.523040e-01,
    8.523162e-01, 8.523283e-01, 8.523405e-01, 8.523527e-01, 8.523650e-01, 8.523771e-01,
    8.523893e-01, 8.524015e-01, 8.524137e-01, 8.524259e-01, 8.524380e-01, 8.524503e-01,
    8.524625e-01, 8.524746e-01, 8.524868e-01, 8.524990e-01, 8.525112e-01, 8.525234e-01,
    8.525356e-01, 8.525478e-01, 8.525600e-01, 8.525721e-01, 8.525844e-01, 8.525966e-01,
    8.526087e-01, 8.526210e-01, 8.526331e-01, 8.526453e-01, 8.526575e-01, 8.526697e-01,
    8.526819e-01, 8.526941e-01, 8.527063e-01, 8.527185e-01, 8.527306e-01, 8.527429e-01,
    8.527550e-01, 8.527672e-01, 8.527794e-01, 8.527916e-01, 8.528038e-01, 8.528160e-01,
    8.528281e-01, 8.528404e-01, 8.528525e-01, 8.528647e-01, 8.528769e-01, 8.528891e-01,
    8.529013e-01, 8.529135e-01, 8.529257e-01, 8.529379e-01, 8.529500e-01, 8.529623e-01,
    8.529744e-01, 8.529866e-01, 8.529988e-01, 8.530110e-01, 8.530232e-01, 8.530354e-01,
    8.530475e-01, 8.530598e-01, 8.530719e-01, 8.530841e-01, 8.530963e-01, 8.531085e-01,
    8.531207e-01, 8.531328e-01, 8.531451e-01, 8.531573e-01, 8.531694e-01, 8.531816e-01,
    8.531938e-01, 8.532060e-01, 8.532181e-01, 8.532304e-01, 8.532426e-01, 8.532547e-01,
    8.532669e-01, 8.532791e-01, 8.532913e-01, 8.533034e-01, 8.533157e-01, 8.533279e-01,
    8.533400e-01, 8.533522e-01, 8.533644e-01, 8.533765e-01, 8.533887e-01, 8.534009e-01,
    8.534131e-01, 8.534253e-01, 8.534375e-01, 8.534497e-01, 8.534619e-01, 8.534740e-01,
    8.534862e-01, 8.534984e-01, 8.535106e-01, 8.535228e-01, 8.535349e-01, 8.535472e-01,
    8.535594e-01, 8.535715e-01, 8.535837e-01, 8.535959e-01, 8.536080e-01, 8.536202e-01,
    8.536325e-01, 8.536445e-01, 8.536568e-01, 8.536690e-01, 8.536811e-01, 8.536933e-01,
    8.537055e-01, 8.537177e-01, 8.537298e-01, 8.537421e-01, 8.537542e-01, 8.537664e-01,
    8.537787e-01, 8.537908e-01, 8.538030e-01, 8.538152e-01, 8.538273e-01, 8.538395e-01,
    8.538516e-01, 8.538638e-01, 8.538761e-01, 8.538882e-01, 8.539004e-01, 8.539126e-01,
    8.539248e-01, 8.539370e-01, 8.539491e-01, 8.539613e-01, 8.539735e-01, 8.539857e-01,
    8.539978e-01, 8.540100e-01, 8.540221e-01, 8.540344e-01, 8.540466e-01, 8.540587e-01,
    8.540709e-01, 8.540831e-01, 8.540953e-01, 8.541074e-01, 8.541196e-01, 8.541318e-01,
    8.541440e-01, 8.541561e-01, 8.541684e-01, 8.541806e-01, 8.541927e-01, 8.542049e-01,
    8.542170e-01, 8.542292e-01, 8.542414e-01, 8.542536e-01, 8.542657e-01, 8.542779e-01,
    8.542901e-01, 8.543023e-01, 8.543144e-01, 8.543267e-01, 8.543388e-01, 8.543510e-01,
    8.543632e-01, 8.543753e-01, 8.543875e-01, 8.543997e-01, 8.544119e-01, 8.544241e-01,
    8.544362e-01, 8.544484e-01, 8.544605e-01, 8.544728e-01, 8.544849e-01, 8.544971e-01,
    8.545093e-01, 8.545215e-01, 8.545336e-01, 8.545458e-01, 8.545580e-01, 8.545702e-01,
    8.545823e-01, 8.545945e-01, 8.546066e-01, 8.546188e-01, 8.546309e-01, 8.546432e-01,
    8.546554e-01, 8.546675e-01, 8.546798e-01, 8.546919e-01, 8.547041e-01, 8.547162e-01,
    8.547284e-01, 8.547405e-01, 8.547527e-01, 8.547649e-01, 8.547771e-01, 8.547893e-01,
    8.548014e-01, 8.548136e-01, 8.548257e-01, 8.548380e-01, 8.548501e-01, 8.548623e-01,
    8.548745e-01, 8.548867e-01, 8.548988e-01, 8.549110e-01, 8.549232e-01, 8.549353e-01,
    8.549475e-01, 8.549596e-01, 8.549718e-01, 8.549840e-01, 8.549962e-01, 8.550083e-01,
    8.550205e-01, 8.550327e-01, 8.550448e-01, 8.550571e-01, 8.550692e-01, 8.550814e-01,
    8.550935e-01, 8.551058e-01, 8.551179e-01, 8.551301e-01, 8.551422e-01, 8.551544e-01,
    8.551666e-01, 8.551787e-01, 8.551909e-01, 8.552031e-01, 8.552152e-01, 8.552274e-01,
    8.552395e-01, 8.552517e-01, 8.552639e-01, 8.552761e-01, 8.552882e-01, 8.553004e-01,
    8.553125e-01, 8.553247e-01, 8.553369e-01, 8.553491e-01, 8.553612e-01, 8.553734e-01,
    8.553855e-01, 8.553978e-01, 8.554099e-01, 8.554221e-01, 8.554342e-01, 8.554465e-01,
    8.554586e-01, 8.554708e-01, 8.554829e-01, 8.554951e-01, 8.555073e-01, 8.555194e-01,
    8.555316e-01, 8.555438e-01, 8.555559e-01, 8.555681e-01, 8.555802e-01, 8.555924e-01,
    8.556046e-01, 8.556168e-01, 8.556289e-01, 8.556411e-01, 8.556532e-01, 8.556654e-01,
    8.556776e-01, 8.556897e-01, 8.557019e-01, 8.557140e-01, 8.557262e-01, 8.557384e-01,
    8.557506e-01, 8.557627e-01, 8.557749e-01, 8.557870e-01, 8.557993e-01, 8.558114e-01,
    8.558236e-01, 8.558357e-01, 8.558478e-01, 8.558601e-01, 8.558722e-01, 8.558844e-01,
    8.558965e-01, 8.559088e-01, 8.559209e-01, 8.559331e-01, 8.559452e-01, 8.559573e-01,
    8.559695e-01, 8.559816e-01, 8.559939e-01, 8.560060e-01, 8.560182e-01, 8.560303e-01,
    8.560424e-01, 8.560547e-01, 8.560668e-01, 8.560790e-01, 8.560911e-01, 8.561033e-01,
    8.561155e-01, 8.561276e-01, 8.561398e-01, 8.561519e-01, 8.561641e-01, 8.561763e-01,
    8.561885e-01, 8.562006e-01, 8.562127e-01, 8.562249e-01, 8.562371e-01, 8.562493e-01,
    8.562614e-01, 8.562735e-01, 8.562857e-01, 8.562979e-01, 8.563101e-01, 8.563222e-01,
    8.563343e-01, 8.563465e-01, 8.563586e-01, 8.563709e-01, 8.563830e-01, 8.563951e-01,
    8.564073e-01, 8.564194e-01, 8.564317e-01, 8.564438e-01, 8.564559e-01, 8.564681e-01,
    8.564802e-01, 8.564925e-01, 8.565046e-01, 8.565167e-01, 8.565289e-01, 8.565410e-01,
    8.565533e-01, 8.565654e-01, 8.565775e-01, 8.565897e-01, 8.566018e-01, 8.566139e-01,
    8.566262e-01, 8.566383e-01, 8.566505e-01, 8.566626e-01, 8.566747e-01, 8.566869e-01,
    8.566990e-01, 8.567112e-01, 8.567234e-01, 8.567355e-01, 8.567476e-01, 8.567598e-01,
    8.567720e-01, 8.567842e-01, 8.567963e-01, 8.568084e-01, 8.568206e-01, 8.568328e-01,
    8.568449e-01, 8.568571e-01, 8.568692e-01, 8.568814e-01, 8.568936e-01, 8.569057e-01,
    8.569179e-01, 8.569300e-01, 8.569422e-01, 8.569543e-01, 8.569665e-01, 8.569787e-01,
    8.569908e-01, 8.570030e-01, 8.570151e-01, 8.570272e-01, 8.570395e-01, 8.570516e-01,
    8.570637e-01, 8.570759e-01, 8.570880e-01, 8.571001e-01, 8.571123e-01, 8.571244e-01,
    8.571366e-01, 8.571488e-01, 8.571609e-01, 8.571730e-01, 8.571852e-01, 8.571974e-01,
    8.572095e-01, 8.572217e-01, 8.572338e-01, 8.572460e-01, 8.572582e-01, 8.572703e-01,
    8.572825e-01, 8.572946e-01, 8.573068e-01, 8.573189e-01, 8.573310e-01, 8.573433e-01,
    8.573554e-01, 8.573675e-01, 8.573797e-01, 8.573918e-01, 8.574039e-01, 8.574162e-01,
    8.574283e-01, 8.574404e-01, 8.574525e-01, 8.574647e-01, 8.574768e-01, 8.574890e-01,
    8.575012e-01, 8.575133e-01, 8.575255e-01, 8.575376e-01, 8.575498e-01, 8.575619e-01,
    8.575740e-01, 8.575863e-01, 8.575984e-01, 8.576105e-01, 8.576226e-01, 8.576348e-01,
    8.576469e-01, 8.576591e-01, 8.576713e-01, 8.576834e-01, 8.576955e-01, 8.577077e-01,
    8.577199e-01, 8.577320e-01, 8.577441e-01, 8.577563e-01, 8.577685e-01, 8.577806e-01,
    8.577927e-01, 8.578048e-01, 8.578171e-01, 8.578292e-01, 8.578413e-01, 8.578535e-01,
    8.578656e-01, 8.578777e-01, 8.578899e-01, 8.579021e-01, 8.579142e-01, 8.579263e-01,
    8.579385e-01, 8.579506e-01, 8.579628e-01, 8.579749e-01, 8.579870e-01, 8.579991e-01,
    8.580114e-01, 8.580235e-01, 8.580356e-01, 8.580478e-01, 8.580599e-01, 8.580721e-01,
    8.580842e-01, 8.580964e-01, 8.581086e-01, 8.581207e-01, 8.581328e-01, 8.581449e-01,
    8.581570e-01, 8.581693e-01, 8.581814e-01, 8.581935e-01, 8.582056e-01, 8.582178e-01,
    8.582300e-01, 8.582421e-01, 8.582542e-01, 8.582664e-01, 8.582786e-01, 8.582907e-01,
    8.583028e-01, 8.583149e-01, 8.583270e-01, 8.583393e-01, 8.583514e-01, 8.583635e-01,
    8.583757e-01, 8.583878e-01, 8.584000e-01, 8.584121e-01, 8.584242e-01, 8.584363e-01,
    8.584486e-01, 8.584607e-01, 8.584728e-01, 8.584849e-01, 8.584971e-01, 8.585092e-01,
    8.585214e-01, 8.585335e-01, 8.585457e-01, 8.585578e-01, 8.585699e-01, 8.585821e-01,
    8.585942e-01, 8.586063e-01, 8.586185e-01, 8.586306e-01, 8.586428e-01, 8.586549e-01,
    8.586671e-01, 8.586792e-01, 8.586913e-01, 8.587034e-01, 8.587157e-01, 8.587278e-01,
    8.587399e-01, 8.587520e-01, 8.587642e-01, 8.587763e-01, 8.587885e-01, 8.588006e-01,
    8.588127e-01, 8.588248e-01, 8.588370e-01, 8.588491e-01, 8.588612e-01, 8.588734e-01,
    8.588856e-01, 8.588977e-01, 8.589098e-01, 8.589219e-01, 8.589340e-01, 8.589463e-01,
    8.589584e-01, 8.589705e-01, 8.589827e-01, 8.589948e-01, 8.590069e-01, 8.590190e-01,
    8.590313e-01, 8.590434e-01, 8.590555e-01, 8.590676e-01, 8.590797e-01, 8.590919e-01,
    8.591040e-01, 8.591161e-01, 8.591283e-01, 8.591405e-01, 8.591526e-01, 8.591647e-01,
    8.591768e-01, 8.591890e-01, 8.592011e-01, 8.592132e-01, 8.592254e-01, 8.592376e-01,
    8.592497e-01, 8.592618e-01, 8.592739e-01, 8.592860e-01, 8.592982e-01, 8.593103e-01,
    8.593225e-01, 8.593346e-01, 8.593467e-01, 8.593588e-01, 8.593710e-01, 8.593831e-01,
    8.593953e-01, 8.594074e-01, 8.594195e-01, 8.594316e-01, 8.594438e-01, 8.594559e-01,
    8.594681e-01, 8.594802e-01, 8.594923e-01, 8.595045e-01, 8.595166e-01, 8.595287e-01,
    8.595408e-01, 8.595529e-01, 8.595651e-01, 8.595773e-01, 8.595894e-01, 8.596016e-01,
    8.596137e-01, 8.596258e-01, 8.596379e-01, 8.596500e-01, 8.596622e-01, 8.596743e-01,
    8.596864e-01, 8.596985e-01, 8.597106e-01, 8.597229e-01, 8.597350e-01, 8.597471e-01,
    8.597593e-01, 8.597714e-01, 8.597835e-01, 8.597956e-01, 8.598077e-01, 8.598199e-01,
    8.598320e-01, 8.598441e-01, 8.598562e-01, 8.598683e-01, 8.598805e-01, 8.598926e-01,
    8.599048e-01, 8.599169e-01, 8.599291e-01, 8.599412e-01, 8.599533e-01, 8.599654e-01,
    8.599776e-01, 8.599897e-01, 8.600018e-01, 8.600140e-01, 8.600261e-01, 8.600382e-01,
    8.600503e-01, 8.600624e-01, 8.600746e-01, 8.600867e-01, 8.600988e-01, 8.601109e-01,
    8.601231e-01, 8.601352e-01, 8.601473e-01, 8.601595e-01, 8.601716e-01, 8.601837e-01,
    8.601958e-01, 8.602079e-01, 8.602201e-01, 8.602322e-01, 8.602443e-01, 8.602564e-01,
    8.602687e-01, 8.602808e-01, 8.602929e-01, 8.603050e-01, 8.603172e-01, 8.603293e-01,
    8.603414e-01, 8.603535e-01, 8.603656e-01, 8.603778e-01, 8.603899e-01, 8.604020e-01,
    8.604141e-01, 8.604262e-01, 8.604384e-01, 8.604505e-01, 8.604627e-01, 8.604748e-01,
    8.604869e-01, 8.604990e-01, 8.605111e-01, 8.605233e-01, 8.605354e-01, 8.605475e-01,
    8.605596e-01, 8.605718e-01, 8.605839e-01, 8.605960e-01, 8.606082e-01, 8.606203e-01,
    8.606323e-01, 8.606445e-01, 8.606566e-01, 8.606687e-01, 8.606808e-01, 8.606929e-01,
    8.607051e-01, 8.607172e-01, 8.607293e-01, 8.607414e-01, 8.607535e-01, 8.607657e-01,
    8.607778e-01, 8.607900e-01, 8.608021e-01, 8.608142e-01, 8.608263e-01, 8.608384e-01,
    8.608506e-01, 8.608627e-01, 8.608748e-01, 8.608869e-01, 8.608990e-01, 8.609112e-01,
    8.609233e-01, 8.609354e-01, 8.609475e-01, 8.609597e-01, 8.609718e-01, 8.609838e-01,
    8.609959e-01, 8.610081e-01, 8.610202e-01, 8.610324e-01, 8.610445e-01, 8.610566e-01,
    8.610687e-01, 8.610808e-01, 8.610930e-01, 8.611051e-01, 8.611172e-01, 8.611293e-01,
    8.611414e-01, 8.611536e-01, 8.611657e-01, 8.611777e-01, 8.611899e-01, 8.612020e-01,
    8.612141e-01, 8.612263e-01, 8.612384e-01, 8.612505e-01, 8.612626e-01, 8.612748e-01,
    8.612869e-01, 8.612990e-01, 8.613111e-01, 8.613232e-01, 8.613353e-01, 8.613474e-01,
    8.613595e-01, 8.613716e-01, 8.613838e-01, 8.613959e-01, 8.614081e-01, 8.614202e-01,
    8.614323e-01, 8.614444e-01, 8.614565e-01, 8.614686e-01, 8.614807e-01, 8.614928e-01,
    8.615050e-01, 8.615171e-01, 8.615292e-01, 8.615413e-01, 8.615534e-01, 8.615656e-01,
    8.615776e-01, 8.615897e-01, 8.616019e-01, 8.616140e-01, 8.616261e-01, 8.616382e-01,
    8.616503e-01, 8.616625e-01, 8.616746e-01, 8.616866e-01, 8.616987e-01, 8.617109e-01,
    8.617230e-01, 8.617352e-01, 8.617473e-01, 8.617594e-01, 8.617715e-01, 8.617836e-01,
    8.617957e-01, 8.618078e-01, 8.618199e-01, 8.618321e-01, 8.618442e-01, 8.618563e-01,
    8.618684e-01, 8.618805e-01, 8.618926e-01, 8.619047e-01, 8.619168e-01, 8.619290e-01,
    8.619411e-01, 8.619532e-01, 8.619652e-01, 8.619774e-01, 8.619895e-01, 8.620017e-01,
    8.620138e-01, 8.620259e-01, 8.620379e-01, 8.620501e-01, 8.620622e-01, 8.620743e-01,
    8.620864e-01, 8.620986e-01, 8.621106e-01, 8.621227e-01, 8.621348e-01, 8.621470e-01,
    8.621591e-01, 8.621712e-01, 8.621833e-01, 8.621954e-01, 8.622075e-01, 8.622196e-01,
    8.622317e-01, 8.622439e-01, 8.622559e-01, 8.622680e-01, 8.622802e-01, 8.622923e-01,
    8.623044e-01, 8.623165e-01, 8.623286e-01, 8.623407e-01, 8.623528e-01, 8.623649e-01,
    8.623770e-01, 8.623891e-01, 8.624012e-01, 8.624133e-01, 8.624255e-01, 8.624376e-01,
    8.624496e-01, 8.624618e-01, 8.624739e-01, 8.624860e-01, 8.624982e-01, 8.625102e-01,
    8.625223e-01, 8.625345e-01, 8.625466e-01, 8.625587e-01, 8.625707e-01, 8.625829e-01,
    8.625950e-01, 8.626071e-01, 8.626192e-01, 8.626313e-01, 8.626434e-01, 8.626555e-01,
    8.626676e-01, 8.626798e-01, 8.626918e-01, 8.627039e-01, 8.627161e-01, 8.627282e-01,
    8.627402e-01, 8.627523e-01, 8.627645e-01, 8.627766e-01, 8.627887e-01, 8.628008e-01,
    8.628129e-01, 8.628250e-01, 8.628371e-01, 8.628492e-01, 8.628613e-01, 8.628734e-01,
    8.628855e-01, 8.628976e-01, 8.629097e-01, 8.629218e-01, 8.629339e-01, 8.629460e-01,
    8.629581e-01, 8.629702e-01, 8.629824e-01, 8.629944e-01, 8.630065e-01, 8.630186e-01,
    8.630308e-01, 8.630428e-01, 8.630549e-01, 8.630671e-01, 8.630792e-01, 8.630912e-01,
    8.631033e-01, 8.631155e-01, 8.631276e-01, 8.631396e-01, 8.631518e-01, 8.631639e-01,
    8.631760e-01, 8.631881e-01, 8.632002e-01, 8.632123e-01, 8.632244e-01, 8.632365e-01,
    8.632486e-01, 8.632607e-01, 8.632728e-01, 8.632849e-01, 8.632970e-01, 8.633091e-01,
    8.633212e-01, 8.633333e-01, 8.633454e-01, 8.633575e-01, 8.633696e-01, 8.633817e-01,
    8.633938e-01, 8.634059e-01, 8.634180e-01, 8.634301e-01, 8.634422e-01, 8.634543e-01,
    8.634664e-01, 8.634785e-01, 8.634906e-01, 8.635027e-01, 8.635148e-01, 8.635269e-01,
    8.635390e-01, 8.635511e-01, 8.635632e-01, 8.635753e-01, 8.635874e-01, 8.635995e-01,
    8.636116e-01, 8.636237e-01, 8.636358e-01, 8.636479e-01, 8.636600e-01, 8.636721e-01,
    8.636841e-01, 8.636963e-01, 8.637084e-01, 8.637204e-01, 8.637326e-01, 8.637447e-01,
    8.637567e-01, 8.637688e-01, 8.637810e-01, 8.637931e-01, 8.638051e-01, 8.638173e-01,
    8.638294e-01, 8.638414e-01, 8.638536e-01, 8.638657e-01, 8.638777e-01, 8.638898e-01,
    8.639020e-01, 8.639140e-01, 8.639261e-01, 8.639383e-01, 8.639503e-01, 8.639624e-01,
    8.639745e-01, 8.639866e-01, 8.639987e-01, 8.640108e-01, 8.640229e-01, 8.640350e-01,
    8.640471e-01, 8.640592e-01, 8.640712e-01, 8.640833e-01, 8.640954e-01, 8.641075e-01,
    8.641196e-01, 8.641317e-01, 8.641438e-01, 8.641559e-01, 8.641680e-01, 8.641800e-01,
    8.641922e-01, 8.642043e-01, 8.642163e-01, 8.642285e-01, 8.642406e-01, 8.642526e-01,
    8.642648e-01, 8.642769e-01, 8.642889e-01, 8.643010e-01, 8.643131e-01, 8.643252e-01,
    8.643373e-01, 8.643494e-01, 8.643615e-01, 8.643736e-01, 8.643857e-01, 8.643978e-01,
    8.644098e-01, 8.644220e-01, 8.644341e-01, 8.644461e-01, 8.644583e-01, 8.644703e-01,
    8.644824e-01, 8.644945e-01, 8.645065e-01, 8.645187e-01, 8.645307e-01, 8.645428e-01,
    8.645550e-01, 8.645670e-01, 8.645791e-01, 8.645912e-01, 8.646033e-01, 8.646154e-01,
    8.646275e-01, 8.646396e-01, 8.646516e-01, 8.646638e-01, 8.646759e-01, 8.646879e-01,
    8.647000e-01, 8.647121e-01, 8.647242e-01, 8.647363e-01, 8.647484e-01, 8.647605e-01,
    8.647726e-01, 8.647847e-01, 8.647967e-01, 8.648088e-01, 8.648210e-01, 8.648330e-01,
    8.648451e-01, 8.648571e-01, 8.648693e-01, 8.648813e-01, 8.648934e-01, 8.649055e-01,
    8.649176e-01, 8.649297e-01, 8.649418e-01, 8.649539e-01, 8.649659e-01, 8.649781e-01,
    8.649901e-01, 8.650022e-01, 8.650143e-01, 8.650264e-01, 8.650385e-01, 8.650506e-01,
    8.650627e-01, 8.650747e-01, 8.650869e-01, 8.650989e-01, 8.651110e-01, 8.651230e-01,
    8.651351e-01, 8.651473e-01, 8.651593e-01, 8.651714e-01, 8.651835e-01, 8.651956e-01,
    8.652077e-01, 8.652198e-01, 8.652318e-01, 8.652439e-01, 8.652560e-01, 8.652681e-01,
    8.652802e-01, 8.652923e-01, 8.653043e-01, 8.653165e-01, 8.653286e-01, 8.653406e-01,
    8.653527e-01, 8.653647e-01, 8.653769e-01, 8.653889e-01, 8.654010e-01, 8.654131e-01,
    8.654252e-01, 8.654373e-01, 8.654494e-01, 8.654614e-01, 8.654735e-01, 8.654855e-01,
    8.654977e-01, 8.655097e-01, 8.655218e-01, 8.655339e-01, 8.655460e-01, 8.655581e-01,
    8.655702e-01, 8.655822e-01, 8.655943e-01, 8.656064e-01, 8.656185e-01, 8.656306e-01,
    8.656427e-01, 8.656547e-01, 8.656669e-01, 8.656789e-01, 8.656910e-01, 8.657030e-01,
    8.657151e-01, 8.657272e-01, 8.657393e-01, 8.657514e-01, 8.657635e-01, 8.657755e-01,
    8.657877e-01, 8.657997e-01, 8.658118e-01, 8.658239e-01, 8.658360e-01, 8.658480e-01,
    8.658600e-01, 8.658722e-01, 8.658842e-01, 8.658963e-01, 8.659084e-01, 8.659205e-01,
    8.659326e-01, 8.659447e-01, 8.659567e-01, 8.659688e-01, 8.659809e-01, 8.659930e-01,
    8.660051e-01, 8.660171e-01, 8.660292e-01, 8.660412e-01, 8.660534e-01, 8.660654e-01,
    8.660775e-01, 8.660896e-01, 8.661017e-01, 8.661137e-01, 8.661259e-01, 8.661379e-01,
    8.661500e-01, 8.661621e-01, 8.661741e-01, 8.661863e-01, 8.661983e-01, 8.662104e-01,
    8.662224e-01, 8.662345e-01, 8.662466e-01, 8.662586e-01, 8.662708e-01, 8.662828e-01,
    8.662949e-01, 8.663070e-01, 8.663191e-01, 8.663311e-01, 8.663431e-01, 8.663553e-01,
    8.663673e-01, 8.663794e-01, 8.663915e-01, 8.664036e-01, 8.664157e-01, 8.664277e-01,
    8.664398e-01, 8.664519e-01, 8.664640e-01, 8.664760e-01, 8.664880e-01, 8.665002e-01,
    8.665122e-01, 8.665243e-01, 8.665364e-01, 8.665484e-01, 8.665606e-01, 8.665726e-01,
    8.665847e-01, 8.665968e-01, 8.666088e-01, 8.666209e-01, 8.666329e-01, 8.666451e-01,
    8.666571e-01, 8.666692e-01, 8.666813e-01, 8.666933e-01, 8.667055e-01, 8.667175e-01,
    8.667295e-01, 8.667417e-01, 8.667537e-01, 8.667658e-01, 8.667778e-01, 8.667899e-01,
    8.668020e-01, 8.668141e-01, 8.668261e-01, 8.668382e-01, 8.668503e-01, 8.668624e-01,
    8.668744e-01, 8.668864e-01, 8.668986e-01, 8.669106e-01, 8.669227e-01, 8.669348e-01,
    8.669468e-01, 8.669590e-01, 8.669710e-01, 8.669831e-01, 8.669952e-01, 8.670072e-01,
    8.670192e-01, 8.670313e-01, 8.670434e-01, 8.670554e-01, 8.670676e-01, 8.670796e-01,
    8.670917e-01, 8.671038e-01, 8.671158e-01, 8.671279e-01, 8.671399e-01, 8.671520e-01,
    8.671641e-01, 8.671762e-01, 8.671882e-01, 8.672003e-01, 8.672124e-01, 8.672244e-01,
    8.672366e-01, 8.672486e-01, 8.672606e-01, 8.672727e-01, 8.672848e-01, 8.672968e-01,
    8.673089e-01, 8.673210e-01, 8.673330e-01, 8.673452e-01, 8.673572e-01, 8.673692e-01,
    8.673813e-01, 8.673934e-01, 8.674054e-01, 8.674175e-01, 8.674296e-01, 8.674416e-01,
    8.674538e-01, 8.674658e-01, 8.674778e-01, 8.674899e-01, 8.675020e-01, 8.675140e-01,
    8.675261e-01, 8.675382e-01, 8.675503e-01, 8.675623e-01, 8.675744e-01, 8.675864e-01,
    8.675985e-01, 8.676106e-01, 8.676226e-01, 8.676347e-01, 8.676467e-01, 8.676589e-01,
    8.676709e-01, 8.676829e-01, 8.676950e-01, 8.677071e-01, 8.677191e-01, 8.677312e-01,
    8.677433e-01, 8.677553e-01, 8.677673e-01, 8.677795e-01, 8.677915e-01, 8.678036e-01,
    8.678157e-01, 8.678277e-01, 8.678398e-01, 8.678518e-01, 8.678640e-01, 8.678759e-01,
    8.678880e-01, 8.679000e-01, 8.679122e-01, 8.679242e-01, 8.679363e-01, 8.679484e-01,
    8.679604e-01, 8.679724e-01, 8.679845e-01, 8.679966e-01, 8.680087e-01, 8.680207e-01,
    8.680328e-01, 8.680449e-01, 8.680569e-01, 8.680689e-01, 8.680810e-01, 8.680931e-01,
    8.681051e-01, 8.681172e-01, 8.681292e-01, 8.681414e-01, 8.681534e-01, 8.681654e-01,
    8.681775e-01, 8.681896e-01, 8.682016e-01, 8.682137e-01, 8.682257e-01, 8.682378e-01,
    8.682498e-01, 8.682619e-01, 8.682739e-01, 8.682861e-01, 8.682981e-01, 8.683102e-01,
    8.683222e-01, 8.683343e-01, 8.683463e-01, 8.683584e-01, 8.683704e-01, 8.683825e-01,
    8.683946e-01, 8.684066e-01, 8.684186e-01, 8.684307e-01, 8.684428e-01, 8.684549e-01,
    8.684669e-01, 8.684790e-01, 8.684910e-01, 8.685031e-01, 8.685151e-01, 8.685272e-01,
    8.685392e-01, 8.685513e-01, 8.685634e-01, 8.685754e-01, 8.685874e-01, 8.685995e-01,
    8.686116e-01, 8.686237e-01, 8.686357e-01, 8.686478e-01, 8.686598e-01, 8.686719e-01,
    8.686839e-01, 8.686960e-01, 8.687080e-01, 8.687201e-01, 8.687322e-01, 8.687442e-01,
    8.687562e-01, 8.687683e-01, 8.687803e-01, 8.687925e-01, 8.688045e-01, 8.688166e-01,
    8.688286e-01, 8.688406e-01, 8.688527e-01, 8.688648e-01, 8.688768e-01, 8.688889e-01,
    8.689009e-01, 8.689129e-01, 8.689250e-01, 8.689371e-01, 8.689491e-01, 8.689612e-01,
    8.689732e-01, 8.689852e-01, 8.689974e-01, 8.690094e-01, 8.690215e-01, 8.690335e-01,
    8.690456e-01, 8.690576e-01, 8.690696e-01, 8.690817e-01, 8.690938e-01, 8.691058e-01,
    8.691179e-01, 8.691299e-01, 8.691419e-01, 8.691540e-01, 8.691661e-01, 8.691781e-01,
    8.691902e-01, 8.692022e-01, 8.692142e-01, 8.692263e-01, 8.692384e-01, 8.692505e-01,
    8.692625e-01, 8.692745e-01, 8.692865e-01, 8.692986e-01, 8.693106e-01, 8.693228e-01,
    8.693348e-01, 8.693469e-01, 8.693589e-01, 8.693709e-01, 8.693830e-01, 8.693950e-01,
    8.694071e-01, 8.694192e-01, 8.694312e-01, 8.694432e-01, 8.694553e-01, 8.694673e-01,
    8.694794e-01, 8.694914e-01, 8.695034e-01, 8.695155e-01, 8.695276e-01, 8.695396e-01,
    8.695517e-01, 8.695637e-01, 8.695757e-01, 8.695878e-01, 8.695998e-01, 8.696120e-01,
    8.696240e-01, 8.696361e-01, 8.696481e-01, 8.696601e-01, 8.696722e-01, 8.696842e-01,
    8.696962e-01, 8.697082e-01, 8.697203e-01, 8.697324e-01, 8.697445e-01, 8.697565e-01,
    8.697686e-01, 8.697806e-01, 8.697926e-01, 8.698047e-01, 8.698167e-01, 8.698288e-01,
    8.698408e-01, 8.698528e-01, 8.698649e-01, 8.698770e-01, 8.698890e-01, 8.699011e-01,
    8.699131e-01, 8.699251e-01, 8.699372e-01, 8.699492e-01, 8.699613e-01, 8.699733e-01,
    8.699853e-01, 8.699974e-01, 8.700094e-01, 8.700215e-01, 8.700336e-01, 8.700456e-01,
    8.700576e-01, 8.700697e-01, 8.700817e-01, 8.700938e-01, 8.701058e-01, 8.701178e-01,
    8.701299e-01, 8.701419e-01, 8.701540e-01, 8.701660e-01, 8.701780e-01, 8.701901e-01,
    8.702021e-01, 8.702142e-01, 8.702262e-01, 8.702383e-01, 8.702503e-01, 8.702624e-01,
    8.702744e-01, 8.702865e-01, 8.702985e-01, 8.703105e-01, 8.703226e-01, 8.703346e-01,
    8.703467e-01, 8.703587e-01, 8.703707e-01, 8.703828e-01, 8.703948e-01, 8.704069e-01,
    8.704189e-01, 8.704309e-01, 8.704430e-01, 8.704550e-01, 8.704671e-01, 8.704791e-01,
    8.704911e-01, 8.705032e-01, 8.705152e-01, 8.705273e-01, 8.705393e-01, 8.705513e-01,
    8.705634e-01, 8.705754e-01, 8.705875e-01, 8.705995e-01, 8.706115e-01, 8.706235e-01,
    8.706356e-01, 8.706476e-01, 8.706596e-01, 8.706717e-01, 8.706837e-01, 8.706958e-01,
    8.707078e-01, 8.707199e-01, 8.707319e-01, 8.707439e-01, 8.707560e-01, 8.707680e-01,
    8.707801e-01, 8.707921e-01, 8.708041e-01, 8.708162e-01, 8.708282e-01, 8.708403e-01,
    8.708523e-01, 8.708643e-01, 8.708764e-01, 8.708884e-01, 8.709005e-01, 8.709125e-01,
    8.709245e-01, 8.709366e-01, 8.709486e-01, 8.709607e-01, 8.709727e-01, 8.709847e-01,
    8.709968e-01, 8.710088e-01, 8.710209e-01, 8.710329e-01, 8.710449e-01, 8.710570e-01,
    8.710690e-01, 8.710811e-01, 8.710931e-01, 8.711051e-01, 8.711172e-01, 8.711292e-01,
    8.711413e-01, 8.711532e-01, 8.711653e-01, 8.711773e-01, 8.711894e-01, 8.712013e-01,
    8.712134e-01, 8.712254e-01, 8.712375e-01, 8.712495e-01, 8.712615e-01, 8.712736e-01,
    8.712856e-01, 8.712977e-01, 8.713097e-01, 8.713217e-01, 8.713338e-01, 8.713458e-01,
    8.713579e-01, 8.713699e-01, 8.713819e-01, 8.713940e-01, 8.714060e-01, 8.714179e-01,
    8.714300e-01, 8.714420e-01, 8.714541e-01, 8.714661e-01, 8.714781e-01, 8.714902e-01,
    8.715022e-01, 8.715143e-01, 8.715263e-01, 8.715383e-01, 8.715504e-01, 8.715624e-01,
    8.715743e-01, 8.715864e-01, 8.715984e-01, 8.716105e-01, 8.716225e-01, 8.716345e-01,
    8.716466e-01, 8.716586e-01, 8.716707e-01, 8.716827e-01, 8.716947e-01, 8.717067e-01,
    8.717188e-01, 8.717308e-01, 8.717428e-01, 8.717549e-01, 8.717669e-01, 8.717790e-01,
    8.717910e-01, 8.718030e-01, 8.718150e-01, 8.718270e-01, 8.718390e-01, 8.718511e-01,
    8.718631e-01, 8.718752e-01, 8.718872e-01, 8.718992e-01, 8.719113e-01, 8.719233e-01,
    8.719352e-01, 8.719473e-01, 8.719593e-01, 8.719714e-01, 8.719834e-01, 8.719954e-01,
    8.720075e-01, 8.720195e-01, 8.720315e-01, 8.720436e-01, 8.720556e-01, 8.720676e-01,
    8.720797e-01, 8.720917e-01, 8.721038e-01, 8.721158e-01, 8.721277e-01, 8.721398e-01,
    8.721518e-01, 8.721638e-01, 8.721759e-01, 8.721879e-01, 8.722000e-01, 8.722119e-01,
    8.722239e-01, 8.722360e-01, 8.722480e-01, 8.722600e-01, 8.722721e-01, 8.722841e-01,
    8.722961e-01, 8.723081e-01, 8.723202e-01, 8.723322e-01, 8.723443e-01, 8.723563e-01,
    8.723682e-01, 8.723803e-01, 8.723923e-01, 8.724043e-01, 8.724164e-01, 8.724284e-01,
    8.724404e-01, 8.724524e-01, 8.724645e-01, 8.724765e-01, 8.724886e-01, 8.725006e-01,
    8.725125e-01, 8.725246e-01, 8.725366e-01, 8.725486e-01, 8.725607e-01, 8.725727e-01,
    8.725847e-01, 8.725967e-01, 8.726088e-01, 8.726208e-01, 8.726328e-01, 8.726448e-01,
    8.726568e-01, 8.726689e-01, 8.726809e-01, 8.726929e-01, 8.727049e-01, 8.727169e-01,
    8.727289e-01, 8.727410e-01, 8.727530e-01, 8.727651e-01, 8.727770e-01, 8.727891e-01,
    8.728011e-01, 8.728132e-01, 8.728252e-01, 8.728371e-01, 8.728492e-01, 8.728612e-01,
    8.728732e-01, 8.728852e-01, 8.728973e-01, 8.729093e-01, 8.729213e-01, 8.729334e-01,
    8.729453e-01, 8.729573e-01, 8.729694e-01, 8.729814e-01, 8.729935e-01, 8.730054e-01,
    8.730175e-01, 8.730295e-01, 8.730416e-01, 8.730535e-01, 8.730655e-01, 8.730776e-01,
    8.730896e-01, 8.731016e-01, 8.731136e-01, 8.731257e-01, 8.731377e-01, 8.731498e-01,
    8.731617e-01, 8.731737e-01, 8.731858e-01, 8.731978e-01, 8.732098e-01, 8.732218e-01,
    8.732338e-01, 8.732458e-01, 8.732578e-01, 8.732699e-01, 8.732819e-01, 8.732939e-01,
    8.733059e-01, 8.733179e-01, 8.733299e-01, 8.733420e-01, 8.733540e-01, 8.733660e-01,
    8.733780e-01, 8.733901e-01, 8.734020e-01, 8.734140e-01, 8.734261e-01, 8.734381e-01,
    8.734501e-01, 8.734621e-01, 8.734742e-01, 8.734861e-01, 8.734981e-01, 8.735102e-01,
    8.735222e-01, 8.735342e-01, 8.735462e-01, 8.735583e-01, 8.735703e-01, 8.735822e-01,
    8.735943e-01, 8.736063e-01, 8.736183e-01, 8.736303e-01, 8.736424e-01, 8.736544e-01,
    8.736663e-01, 8.736784e-01, 8.736904e-01, 8.737024e-01, 8.737144e-01, 8.737265e-01,
    8.737385e-01, 8.737504e-01, 8.737625e-01, 8.737745e-01, 8.737865e-01, 8.737985e-01,
    8.738106e-01, 8.738226e-01, 8.738346e-01, 8.738466e-01, 8.738586e-01, 8.738706e-01,
    8.738827e-01, 8.738947e-01, 8.739066e-01, 8.739187e-01, 8.739307e-01, 8.739427e-01,
    8.739547e-01, 8.739668e-01, 8.739788e-01, 8.739907e-01, 8.740028e-01, 8.740148e-01,
    8.740268e-01, 8.740388e-01, 8.740509e-01, 8.740628e-01, 8.740748e-01, 8.740869e-01,
    8.740988e-01, 8.741109e-01, 8.741229e-01, 8.741348e-01, 8.741469e-01, 8.741589e-01,
    8.741709e-01, 8.741829e-01, 8.741949e-01, 8.742069e-01, 8.742189e-01, 8.742310e-01,
    8.742430e-01, 8.742549e-01, 8.742670e-01, 8.742790e-01, 8.742910e-01, 8.743030e-01,
    8.743150e-01, 8.743270e-01, 8.743390e-01, 8.743510e-01, 8.743631e-01, 8.743750e-01,
    8.743870e-01, 8.743991e-01, 8.744110e-01, 8.744231e-01, 8.744351e-01, 8.744470e-01,
    8.744591e-01, 8.744711e-01, 8.744831e-01, 8.744951e-01, 8.745071e-01, 8.745191e-01,
    8.745311e-01, 8.745431e-01, 8.745552e-01, 8.745672e-01, 8.745791e-01, 8.745912e-01,
    8.746032e-01, 8.746152e-01, 8.746272e-01, 8.746392e-01, 8.746512e-01, 8.746632e-01,
    8.746752e-01, 8.746873e-01, 8.746992e-01, 8.747112e-01, 8.747233e-01, 8.747352e-01,
    8.747473e-01, 8.747593e-01, 8.747712e-01, 8.747833e-01, 8.747953e-01, 8.748073e-01,
    8.748193e-01, 8.748313e-01, 8.748433e-01, 8.748553e-01, 8.748673e-01, 8.748794e-01,
    8.748913e-01, 8.749033e-01, 8.749153e-01, 8.749273e-01, 8.749394e-01, 8.749513e-01,
    8.749633e-01, 8.749753e-01, 8.749874e-01, 8.749993e-01, 8.750113e-01, 8.750234e-01,
    8.750353e-01, 8.750474e-01, 8.750593e-01, 8.750713e-01, 8.750834e-01, 8.750954e-01,
    8.751074e-01, 8.751193e-01, 8.751314e-01, 8.751433e-01, 8.751554e-01, 8.751674e-01,
    8.751794e-01, 8.751914e-01, 8.752034e-01, 8.752154e-01, 8.752273e-01, 8.752394e-01,
    8.752514e-01, 8.752634e-01, 8.752754e-01, 8.752874e-01, 8.752994e-01, 8.753114e-01,
    8.753234e-01, 8.753354e-01, 8.753474e-01, 8.753594e-01, 8.753714e-01, 8.753834e-01,
    8.753954e-01, 8.754074e-01, 8.754194e-01, 8.754314e-01, 8.754434e-01, 8.754554e-01,
    8.754674e-01, 8.754794e-01, 8.754914e-01, 8.755034e-01, 8.755155e-01, 8.755274e-01,
    8.755394e-01, 8.755514e-01, 8.755634e-01, 8.755754e-01, 8.755874e-01, 8.755994e-01,
    8.756114e-01, 8.756233e-01, 8.756354e-01, 8.756474e-01, 8.756594e-01, 8.756713e-01,
    8.756834e-01, 8.756953e-01, 8.757074e-01, 8.757193e-01, 8.757313e-01, 8.757433e-01,
    8.757554e-01, 8.757674e-01, 8.757793e-01, 8.757914e-01, 8.758034e-01, 8.758154e-01,
    8.758273e-01, 8.758394e-01, 8.758513e-01, 8.758634e-01, 8.758753e-01, 8.758873e-01,
    8.758993e-01, 8.759114e-01, 8.759233e-01, 8.759353e-01, 8.759473e-01, 8.759593e-01,
    8.759713e-01, 8.759833e-01, 8.759953e-01, 8.760072e-01, 8.760192e-01, 8.760312e-01,
    8.760433e-01, 8.760552e-01, 8.760672e-01, 8.760792e-01, 8.760912e-01, 8.761032e-01,
    8.761152e-01, 8.761272e-01, 8.761392e-01, 8.761511e-01, 8.761632e-01, 8.761752e-01,
    8.761872e-01, 8.761991e-01, 8.762112e-01, 8.762231e-01, 8.762352e-01, 8.762471e-01,
    8.762591e-01, 8.762711e-01, 8.762830e-01, 8.762951e-01, 8.763071e-01, 8.763191e-01,
    8.763310e-01, 8.763431e-01, 8.763551e-01, 8.763671e-01, 8.763791e-01, 8.763910e-01,
    8.764030e-01, 8.764150e-01, 8.764271e-01, 8.764390e-01, 8.764510e-01, 8.764630e-01,
    8.764750e-01, 8.764870e-01, 8.764990e-01, 8.765110e-01, 8.765229e-01, 8.765349e-01,
    8.765469e-01, 8.765590e-01, 8.765709e-01, 8.765829e-01, 8.765949e-01, 8.766068e-01,
    8.766189e-01, 8.766308e-01, 8.766429e-01, 8.766548e-01, 8.766668e-01, 8.766788e-01,
    8.766907e-01, 8.767028e-01, 8.767148e-01, 8.767268e-01, 8.767387e-01, 8.767507e-01,
    8.767627e-01, 8.767747e-01, 8.767867e-01, 8.767987e-01, 8.768107e-01, 8.768227e-01,
    8.768346e-01, 8.768467e-01, 8.768586e-01, 8.768706e-01, 8.768826e-01, 8.768945e-01,
    8.769066e-01, 8.769186e-01, 8.769306e-01, 8.769425e-01, 8.769545e-01, 8.769665e-01,
    8.769785e-01, 8.769906e-01, 8.770025e-01, 8.770145e-01, 8.770265e-01, 8.770384e-01,
    8.770505e-01, 8.770624e-01, 8.770744e-01, 8.770864e-01, 8.770984e-01, 8.771103e-01,
    8.771223e-01, 8.771343e-01, 8.771464e-01, 8.771583e-01, 8.771703e-01, 8.771823e-01,
    8.771942e-01, 8.772062e-01, 8.772182e-01, 8.772302e-01, 8.772422e-01, 8.772542e-01,
    8.772661e-01, 8.772781e-01, 8.772901e-01, 8.773021e-01, 8.773141e-01, 8.773261e-01,
    8.773380e-01, 8.773500e-01, 8.773620e-01, 8.773741e-01, 8.773860e-01, 8.773980e-01,
    8.774100e-01, 8.774220e-01, 8.774339e-01, 8.774459e-01, 8.774579e-01, 8.774698e-01,
    8.774819e-01, 8.774939e-01, 8.775058e-01, 8.775178e-01, 8.775298e-01, 8.775417e-01,
    8.775538e-01, 8.775657e-01, 8.775777e-01, 8.775897e-01, 8.776017e-01, 8.776136e-01,
    8.776256e-01, 8.776376e-01, 8.776495e-01, 8.776616e-01, 8.776736e-01, 8.776855e-01,
    8.776975e-01, 8.777095e-01, 8.777214e-01, 8.777335e-01, 8.777454e-01, 8.777574e-01,
    8.777694e-01, 8.777814e-01, 8.777934e-01, 8.778054e-01, 8.778173e-01, 8.778293e-01,
    8.778414e-01, 8.778533e-01, 8.778653e-01, 8.778772e-01, 8.778892e-01, 8.779012e-01,
    8.779131e-01, 8.779252e-01, 8.779371e-01, 8.779491e-01, 8.779611e-01, 8.779731e-01,
    8.779850e-01, 8.779970e-01, 8.780090e-01, 8.780209e-01, 8.780329e-01, 8.780450e-01,
    8.780569e-01, 8.780689e-01, 8.780809e-01, 8.780928e-01, 8.781048e-01, 8.781167e-01,
    8.781288e-01, 8.781407e-01, 8.781527e-01, 8.781646e-01, 8.781767e-01, 8.781887e-01,
    8.782006e-01, 8.782126e-01, 8.782246e-01, 8.782365e-01, 8.782485e-01, 8.782606e-01,
    8.782725e-01, 8.782845e-01, 8.782964e-01, 8.783084e-01, 8.783204e-01, 8.783323e-01,
    8.783444e-01, 8.783563e-01, 8.783683e-01, 8.783802e-01, 8.783923e-01, 8.784042e-01,
    8.784162e-01, 8.784281e-01, 8.784401e-01, 8.784521e-01, 8.784641e-01, 8.784760e-01,
    8.784881e-01, 8.785000e-01, 8.785120e-01, 8.785239e-01, 8.785360e-01, 8.785479e-01,
    8.785599e-01, 8.785718e-01, 8.785838e-01, 8.785958e-01, 8.786077e-01, 8.786197e-01,
    8.786317e-01, 8.786437e-01, 8.786557e-01, 8.786676e-01, 8.786796e-01, 8.786916e-01,
    8.787035e-01, 8.787155e-01, 8.787275e-01, 8.787395e-01, 8.787515e-01, 8.787634e-01,
    8.787754e-01, 8.787873e-01, 8.787994e-01, 8.788113e-01, 8.788233e-01, 8.788352e-01,
    8.788472e-01, 8.788592e-01, 8.788711e-01, 8.788831e-01, 8.788950e-01, 8.789071e-01,
    8.789191e-01, 8.789310e-01, 8.789430e-01, 8.789549e-01, 8.789669e-01, 8.789789e-01,
    8.789908e-01, 8.790028e-01, 8.790148e-01, 8.790268e-01, 8.790388e-01, 8.790507e-01,
    8.790627e-01, 8.790746e-01, 8.790867e-01, 8.790986e-01, 8.791106e-01, 8.791225e-01,
    8.791345e-01, 8.791464e-01, 8.791584e-01, 8.791704e-01, 8.791823e-01, 8.791943e-01,
    8.792062e-01, 8.792183e-01, 8.792303e-01, 8.792422e-01, 8.792542e-01, 8.792661e-01,
    8.792781e-01, 8.792901e-01, 8.793021e-01, 8.793140e-01, 8.793260e-01, 8.793379e-01,
    8.793499e-01, 8.793619e-01, 8.793738e-01, 8.793858e-01, 8.793977e-01, 8.794097e-01,
    8.794217e-01, 8.794337e-01, 8.794457e-01, 8.794576e-01, 8.794696e-01, 8.794815e-01,
    8.794935e-01, 8.795055e-01, 8.795175e-01, 8.795294e-01, 8.795414e-01, 8.795533e-01,
    8.795653e-01, 8.795772e-01, 8.795893e-01, 8.796012e-01, 8.796132e-01, 8.796251e-01,
    8.796371e-01, 8.796490e-01, 8.796610e-01, 8.796729e-01, 8.796850e-01, 8.796969e-01,
    8.797089e-01, 8.797209e-01, 8.797328e-01, 8.797448e-01, 8.797567e-01, 8.797687e-01,
    8.797807e-01, 8.797926e-01, 8.798046e-01, 8.798165e-01, 8.798285e-01, 8.798404e-01,
    8.798524e-01, 8.798643e-01, 8.798764e-01, 8.798884e-01, 8.799003e-01, 8.799123e-01,
    8.799242e-01, 8.799362e-01, 8.799481e-01, 8.799601e-01, 8.799720e-01, 8.799841e-01,
    8.799960e-01, 8.800080e-01, 8.800199e-01, 8.800319e-01, 8.800438e-01, 8.800558e-01,
    8.800677e-01, 8.800797e-01, 8.800916e-01, 8.801036e-01, 8.801156e-01, 8.801275e-01,
    8.801395e-01, 8.801515e-01, 8.801634e-01, 8.801754e-01, 8.801873e-01, 8.801993e-01,
    8.802112e-01, 8.802232e-01, 8.802351e-01, 8.802472e-01, 8.802592e-01, 8.802711e-01,
    8.802831e-01, 8.802950e-01, 8.803070e-01, 8.803189e-01, 8.803309e-01, 8.803428e-01,
    8.803548e-01, 8.803667e-01, 8.803787e-01, 8.803906e-01, 8.804026e-01, 8.804146e-01,
    8.804266e-01, 8.804385e-01, 8.804505e-01, 8.804624e-01, 8.804744e-01, 8.804863e-01,
    8.804983e-01, 8.805102e-01, 8.805222e-01, 8.805342e-01, 8.805461e-01, 8.805581e-01,
    8.805700e-01, 8.805820e-01, 8.805939e-01, 8.806059e-01, 8.806178e-01, 8.806298e-01,
    8.806418e-01, 8.806537e-01, 8.806657e-01, 8.806776e-01, 8.806896e-01, 8.807015e-01,
    8.807135e-01, 8.807255e-01, 8.807374e-01, 8.807494e-01, 8.807613e-01, 8.807733e-01,
    8.807852e-01, 8.807972e-01, 8.808091e-01, 8.808211e-01, 8.808330e-01, 8.808450e-01,
    8.808569e-01, 8.808689e-01, 8.808808e-01, 8.808928e-01, 8.809048e-01, 8.809167e-01,
    8.809287e-01, 8.809406e-01, 8.809526e-01, 8.809645e-01, 8.809765e-01, 8.809884e-01,
    8.810004e-01, 8.810123e-01, 8.810243e-01, 8.810362e-01, 8.810482e-01, 8.810601e-01,
    8.810721e-01, 8.810841e-01, 8.810960e-01, 8.811080e-01, 8.811199e-01, 8.811319e-01,
    8.811438e-01, 8.811558e-01, 8.811677e-01, 8.811797e-01, 8.811916e-01, 8.812036e-01,
    8.812155e-01, 8.812275e-01, 8.812395e-01, 8.812514e-01, 8.812634e-01, 8.812753e-01,
    8.812873e-01, 8.812992e-01, 8.813112e-01, 8.813231e-01, 8.813351e-01, 8.813470e-01,
    8.813590e-01, 8.813709e-01, 8.813829e-01, 8.813948e-01, 8.814068e-01, 8.814188e-01,
    8.814307e-01, 8.814427e-01, 8.814546e-01, 8.814666e-01, 8.814785e-01, 8.814903e-01,
    8.815023e-01, 8.815143e-01, 8.815262e-01, 8.815382e-01, 8.815501e-01, 8.815621e-01,
    8.815740e-01, 8.815860e-01, 8.815979e-01, 8.816099e-01, 8.816218e-01, 8.816338e-01,
    8.816457e-01, 8.816577e-01, 8.816696e-01, 8.816816e-01, 8.816935e-01, 8.817055e-01,
    8.817174e-01, 8.817294e-01, 8.817413e-01, 8.817533e-01, 8.817652e-01, 8.817772e-01,
    8.817891e-01, 8.818011e-01, 8.818130e-01, 8.818250e-01, 8.818369e-01, 8.818489e-01,
    8.818608e-01, 8.818728e-01, 8.818846e-01, 8.818966e-01, 8.819085e-01, 8.819205e-01,
    8.819324e-01, 8.819444e-01, 8.819563e-01, 8.819683e-01, 8.819802e-01, 8.819922e-01,
    8.820041e-01, 8.820161e-01, 8.820280e-01, 8.820400e-01, 8.820519e-01, 8.820639e-01,
    8.820758e-01, 8.820878e-01, 8.820997e-01, 8.821117e-01, 8.821236e-01, 8.821356e-01,
    8.821474e-01, 8.821594e-01, 8.821713e-01, 8.821833e-01, 8.821952e-01, 8.822072e-01,
    8.822191e-01, 8.822311e-01, 8.822430e-01, 8.822549e-01, 8.822669e-01, 8.822788e-01,
    8.822908e-01, 8.823027e-01, 8.823147e-01, 8.823267e-01, 8.823386e-01, 8.823504e-01,
    8.823624e-01, 8.823743e-01, 8.823863e-01, 8.823982e-01, 8.824102e-01, 8.824221e-01,
    8.824341e-01, 8.824460e-01, 8.824579e-01, 8.824699e-01, 8.824819e-01, 8.824938e-01,
    8.825058e-01, 8.825177e-01, 8.825297e-01, 8.825415e-01, 8.825535e-01, 8.825654e-01,
    8.825774e-01, 8.825893e-01, 8.826013e-01, 8.826132e-01, 8.826251e-01, 8.826371e-01,
    8.826490e-01, 8.826610e-01, 8.826729e-01, 8.826849e-01, 8.826967e-01, 8.827087e-01,
    8.827206e-01, 8.827326e-01, 8.827446e-01, 8.827565e-01, 8.827684e-01, 8.827803e-01,
    8.827923e-01, 8.828042e-01, 8.828162e-01, 8.828281e-01, 8.828400e-01, 8.828520e-01,
    8.828639e-01, 8.828759e-01, 8.828878e-01, 8.828998e-01, 8.829116e-01, 8.829236e-01,
    8.829355e-01, 8.829475e-01, 8.829594e-01, 8.829713e-01, 8.829833e-01, 8.829952e-01,
    8.830072e-01, 8.830191e-01, 8.830311e-01, 8.830429e-01, 8.830549e-01, 8.830668e-01,
    8.830788e-01, 8.830907e-01, 8.831026e-01, 8.831146e-01, 8.831265e-01, 8.831385e-01,
    8.831505e-01, 8.831623e-01, 8.831742e-01, 8.831862e-01, 8.831981e-01, 8.832101e-01,
    8.832220e-01, 8.832339e-01, 8.832459e-01, 8.832578e-01, 8.832698e-01, 8.832816e-01,
    8.832936e-01, 8.833055e-01, 8.833175e-01, 8.833294e-01, 8.833413e-01, 8.833533e-01,
    8.833652e-01, 8.833772e-01, 8.833891e-01, 8.834010e-01, 8.834130e-01, 8.834249e-01,
    8.834368e-01, 8.834487e-01, 8.834607e-01, 8.834726e-01, 8.834845e-01, 8.834965e-01,
    8.835084e-01, 8.835204e-01, 8.835323e-01, 8.835442e-01, 8.835561e-01, 8.835681e-01,
    8.835800e-01, 8.835919e-01, 8.836039e-01, 8.836158e-01, 8.836278e-01, 8.836396e-01,
    8.836516e-01, 8.836635e-01, 8.836755e-01, 8.836874e-01, 8.836993e-01, 8.837113e-01,
    8.837232e-01, 8.837351e-01, 8.837470e-01, 8.837590e-01, 8.837709e-01, 8.837828e-01,
    8.837948e-01, 8.838067e-01, 8.838187e-01, 8.838305e-01, 8.838425e-01, 8.838544e-01,
    8.838663e-01, 8.838782e-01, 8.838902e-01, 8.839022e-01, 8.839141e-01, 8.839260e-01,
    8.839380e-01, 8.839499e-01, 8.839617e-01, 8.839737e-01, 8.839856e-01, 8.839976e-01,
    8.840095e-01, 8.840215e-01, 8.840334e-01, 8.840452e-01, 8.840572e-01, 8.840691e-01,
    8.840810e-01, 8.840930e-01, 8.841049e-01, 8.841169e-01, 8.841287e-01, 8.841407e-01,
    8.841527e-01, 8.841645e-01, 8.841765e-01, 8.841884e-01, 8.842003e-01, 8.842123e-01,
    8.842242e-01, 8.842362e-01, 8.842480e-01, 8.842600e-01, 8.842719e-01, 8.842838e-01,
    8.842958e-01, 8.843077e-01, 8.843195e-01, 8.843315e-01, 8.843434e-01, 8.843554e-01,
    8.843673e-01, 8.843793e-01, 8.843911e-01, 8.844030e-01, 8.844150e-01, 8.844269e-01,
    8.844388e-01, 8.844508e-01, 8.844627e-01, 8.844746e-01, 8.844866e-01, 8.844985e-01,
    8.845104e-01, 8.845223e-01, 8.845343e-01, 8.845462e-01, 8.845581e-01, 8.845700e-01,
    8.845819e-01, 8.845939e-01, 8.846058e-01, 8.846177e-01, 8.846297e-01, 8.846415e-01,
    8.846534e-01, 8.846654e-01, 8.846773e-01, 8.846893e-01, 8.847012e-01, 8.847131e-01,
    8.847250e-01, 8.847370e-01, 8.847488e-01, 8.847608e-01, 8.847727e-01, 8.847846e-01,
    8.847966e-01, 8.848085e-01, 8.848204e-01, 8.848323e-01, 8.848442e-01, 8.848562e-01,
    8.848681e-01, 8.848799e-01, 8.848919e-01, 8.849039e-01, 8.849158e-01, 8.849277e-01,
    8.849396e-01, 8.849515e-01, 8.849635e-01, 8.849753e-01, 8.849873e-01, 8.849992e-01,
    8.850111e-01, 8.850231e-01, 8.850349e-01, 8.850469e-01, 8.850588e-01, 8.850707e-01,
    8.850827e-01, 8.850946e-01, 8.851065e-01, 8.851184e-01, 8.851303e-01, 8.851423e-01,
    8.851542e-01, 8.851660e-01, 8.851780e-01, 8.851899e-01, 8.852018e-01, 8.852138e-01,
    8.852257e-01, 8.852376e-01, 8.852495e-01, 8.852614e-01, 8.852734e-01, 8.852853e-01,
    8.852972e-01, 8.853090e-01, 8.853210e-01, 8.853330e-01, 8.853449e-01, 8.853568e-01,
    8.853686e-01, 8.853806e-01, 8.853925e-01, 8.854044e-01, 8.854164e-01, 8.854282e-01,
    8.854402e-01, 8.854521e-01, 8.854640e-01, 8.854760e-01, 8.854879e-01, 8.854998e-01,
    8.855116e-01, 8.855236e-01, 8.855355e-01, 8.855475e-01, 8.855594e-01, 8.855712e-01,
    8.855832e-01, 8.855951e-01, 8.856070e-01, 8.856189e-01, 8.856308e-01, 8.856427e-01,
    8.856547e-01, 8.856666e-01, 8.856785e-01, 8.856905e-01, 8.857023e-01, 8.857142e-01,
    8.857262e-01, 8.857381e-01, 8.857499e-01, 8.857619e-01, 8.857738e-01, 8.857857e-01,
    8.857977e-01, 8.858095e-01, 8.858215e-01, 8.858334e-01, 8.858453e-01, 8.858572e-01,
    8.858691e-01, 8.858810e-01, 8.858929e-01, 8.859048e-01, 8.859168e-01, 8.859288e-01,
    8.859406e-01, 8.859525e-01, 8.859644e-01, 8.859764e-01, 8.859882e-01, 8.860002e-01,
    8.860121e-01, 8.860240e-01, 8.860359e-01, 8.860478e-01, 8.860597e-01, 8.860716e-01,
    8.860835e-01, 8.860955e-01, 8.861073e-01, 8.861193e-01, 8.861312e-01, 8.861431e-01,
    8.861549e-01, 8.861669e-01, 8.861788e-01, 8.861907e-01, 8.862026e-01, 8.862146e-01,
    8.862264e-01, 8.862384e-01, 8.862503e-01, 8.862622e-01, 8.862740e-01, 8.862860e-01,
    8.862979e-01, 8.863099e-01, 8.863217e-01, 8.863336e-01, 8.863455e-01, 8.863575e-01,
    8.863693e-01, 8.863813e-01, 8.863932e-01, 8.864051e-01, 8.864170e-01, 8.864290e-01,
    8.864408e-01, 8.864527e-01, 8.864646e-01, 8.864766e-01, 8.864884e-01, 8.865004e-01,
    8.865123e-01, 8.865242e-01, 8.865361e-01, 8.865480e-01, 8.865599e-01, 8.865718e-01,
    8.865837e-01, 8.865957e-01, 8.866075e-01, 8.866194e-01, 8.866314e-01, 8.866432e-01,
    8.866552e-01, 8.866671e-01, 8.866790e-01, 8.866909e-01, 8.867028e-01, 8.867147e-01,
    8.867266e-01, 8.867385e-01, 8.867504e-01, 8.867623e-01, 8.867742e-01, 8.867862e-01,
    8.867980e-01, 8.868099e-01, 8.868218e-01, 8.868338e-01, 8.868456e-01, 8.868576e-01,
    8.868695e-01, 8.868814e-01, 8.868933e-01, 8.869051e-01, 8.869171e-01, 8.869290e-01,
    8.869410e-01, 8.869528e-01, 8.869647e-01, 8.869766e-01, 8.869885e-01, 8.870004e-01,
    8.870123e-01, 8.870242e-01, 8.870361e-01, 8.870480e-01, 8.870599e-01, 8.870718e-01,
    8.870838e-01, 8.870956e-01, 8.871076e-01, 8.871195e-01, 8.871313e-01, 8.871433e-01,
    8.871551e-01, 8.871671e-01, 8.871790e-01, 8.871908e-01, 8.872028e-01, 8.872147e-01,
    8.872266e-01, 8.872384e-01, 8.872504e-01, 8.872623e-01, 8.872741e-01, 8.872861e-01,
    8.872980e-01, 8.873099e-01, 8.873218e-01, 8.873336e-01, 8.873456e-01, 8.873575e-01,
    8.873693e-01, 8.873813e-01, 8.873932e-01, 8.874051e-01, 8.874170e-01, 8.874288e-01,
    8.874408e-01, 8.874527e-01, 8.874646e-01, 8.874765e-01, 8.874884e-01, 8.875003e-01,
    8.875121e-01, 8.875241e-01, 8.875360e-01, 8.875479e-01, 8.875598e-01, 8.875717e-01,
    8.875836e-01, 8.875955e-01, 8.876073e-01, 8.876193e-01, 8.876312e-01, 8.876430e-01,
    8.876550e-01, 8.876669e-01, 8.876787e-01, 8.876907e-01, 8.877025e-01, 8.877144e-01,
    8.877264e-01, 8.877382e-01, 8.877501e-01, 8.877621e-01, 8.877739e-01, 8.877859e-01,
    8.877978e-01, 8.878096e-01, 8.878216e-01, 8.878334e-01, 8.878453e-01, 8.878573e-01,
    8.878691e-01, 8.878810e-01, 8.878930e-01, 8.879048e-01, 8.879167e-01, 8.879286e-01,
    8.879405e-01, 8.879523e-01, 8.879643e-01, 8.879762e-01, 8.879880e-01, 8.880000e-01,
    8.880119e-01, 8.880237e-01, 8.880357e-01, 8.880476e-01, 8.880594e-01, 8.880714e-01,
    8.880832e-01, 8.880951e-01, 8.881071e-01, 8.881189e-01, 8.881308e-01, 8.881428e-01,
    8.881546e-01, 8.881665e-01, 8.881784e-01, 8.881903e-01, 8.882022e-01, 8.882141e-01,
    8.882260e-01, 8.882378e-01, 8.882497e-01, 8.882617e-01, 8.882735e-01, 8.882854e-01,
    8.882974e-01, 8.883092e-01, 8.883211e-01, 8.883330e-01, 8.883449e-01, 8.883567e-01,
    8.883687e-01, 8.883806e-01, 8.883924e-01, 8.884043e-01, 8.884163e-01, 8.884282e-01,
    8.884400e-01, 8.884520e-01, 8.884639e-01, 8.884757e-01, 8.884876e-01, 8.884995e-01,
    8.885114e-01, 8.885233e-01, 8.885352e-01, 8.885471e-01, 8.885589e-01, 8.885708e-01,
    8.885828e-01, 8.885946e-01, 8.886065e-01, 8.886185e-01, 8.886303e-01, 8.886422e-01,
    8.886541e-01, 8.886660e-01, 8.886779e-01, 8.886898e-01, 8.887016e-01, 8.887135e-01,
    8.887254e-01, 8.887373e-01, 8.887492e-01, 8.887611e-01, 8.887730e-01, 8.887848e-01,
    8.887967e-01, 8.888087e-01, 8.888205e-01, 8.888324e-01, 8.888443e-01, 8.888562e-01,
    8.888681e-01, 8.888800e-01, 8.888918e-01, 8.889037e-01, 8.889157e-01, 8.889275e-01,
    8.889394e-01, 8.889513e-01, 8.889632e-01, 8.889750e-01, 8.889869e-01, 8.889989e-01,
    8.890107e-01, 8.890226e-01, 8.890345e-01, 8.890464e-01, 8.890583e-01, 8.890702e-01,
    8.890820e-01, 8.890940e-01, 8.891059e-01, 8.891177e-01, 8.891296e-01, 8.891414e-01,
    8.891534e-01, 8.891653e-01, 8.891771e-01, 8.891890e-01, 8.892009e-01, 8.892128e-01,
    8.892247e-01, 8.892366e-01, 8.892484e-01, 8.892604e-01, 8.892722e-01, 8.892841e-01,
    8.892960e-01, 8.893079e-01, 8.893198e-01, 8.893316e-01, 8.893435e-01, 8.893554e-01,
    8.893673e-01, 8.893792e-01, 8.893911e-01, 8.894029e-01, 8.894148e-01, 8.894267e-01,
    8.894386e-01, 8.894505e-01, 8.894624e-01, 8.894742e-01, 8.894861e-01, 8.894981e-01,
    8.895099e-01, 8.895218e-01, 8.895336e-01, 8.895455e-01, 8.895575e-01, 8.895693e-01,
    8.895812e-01, 8.895931e-01, 8.896049e-01, 8.896168e-01, 8.896288e-01, 8.896406e-01,
    8.896525e-01, 8.896644e-01, 8.896762e-01, 8.896882e-01, 8.897001e-01, 8.897119e-01,
    8.897238e-01, 8.897356e-01, 8.897475e-01, 8.897595e-01, 8.897713e-01, 8.897832e-01,
    8.897951e-01, 8.898069e-01, 8.898188e-01, 8.898306e-01, 8.898426e-01, 8.898545e-01,
    8.898664e-01, 8.898782e-01, 8.898901e-01, 8.899019e-01, 8.899139e-01, 8.899258e-01,
    8.899376e-01, 8.899495e-01, 8.899614e-01, 8.899732e-01, 8.899851e-01, 8.899971e-01,
    8.900089e-01, 8.900208e-01, 8.900326e-01, 8.900445e-01, 8.900564e-01, 8.900682e-01,
    8.900802e-01, 8.900921e-01, 8.901039e-01, 8.901158e-01, 8.901277e-01, 8.901395e-01,
    8.901514e-01, 8.901633e-01, 8.901752e-01, 8.901871e-01, 8.901989e-01, 8.902108e-01,
    8.902227e-01, 8.902346e-01, 8.902465e-01, 8.902583e-01, 8.902702e-01, 8.902821e-01,
    8.902940e-01, 8.903059e-01, 8.903177e-01, 8.903296e-01, 8.903415e-01, 8.903533e-01,
    8.903652e-01, 8.903772e-01, 8.903890e-01, 8.904009e-01, 8.904127e-01, 8.904246e-01,
    8.904365e-01, 8.904483e-01, 8.904602e-01, 8.904721e-01, 8.904839e-01, 8.904959e-01,
    8.905078e-01, 8.905196e-01, 8.905315e-01, 8.905433e-01, 8.905552e-01, 8.905671e-01,
    8.905790e-01, 8.905908e-01, 8.906027e-01, 8.906146e-01, 8.906264e-01, 8.906384e-01,
    8.906503e-01, 8.906621e-01, 8.906740e-01, 8.906859e-01, 8.906977e-01, 8.907096e-01,
    8.907214e-01, 8.907333e-01, 8.907452e-01, 8.907570e-01, 8.907689e-01, 8.907808e-01,
    8.907927e-01, 8.908046e-01, 8.908165e-01, 8.908283e-01, 8.908402e-01, 8.908521e-01,
    8.908640e-01, 8.908758e-01, 8.908877e-01, 8.908995e-01, 8.909114e-01, 8.909233e-01,
    8.909351e-01, 8.909470e-01, 8.909588e-01, 8.909708e-01, 8.909826e-01, 8.909945e-01,
    8.910064e-01, 8.910183e-01, 8.910301e-01, 8.910421e-01, 8.910539e-01, 8.910658e-01,
    8.910776e-01, 8.910895e-01, 8.911014e-01, 8.911132e-01, 8.911251e-01, 8.911369e-01,
    8.911488e-01, 8.911607e-01, 8.911726e-01, 8.911844e-01, 8.911963e-01, 8.912082e-01,
    8.912200e-01, 8.912319e-01, 8.912438e-01, 8.912556e-01, 8.912675e-01, 8.912793e-01,
    8.912912e-01, 8.913031e-01, 8.913150e-01, 8.913268e-01, 8.913387e-01, 8.913506e-01,
    8.913624e-01, 8.913743e-01, 8.913862e-01, 8.913980e-01, 8.914099e-01, 8.914217e-01,
    8.914337e-01, 8.914455e-01, 8.914574e-01, 8.914692e-01, 8.914811e-01, 8.914930e-01,
    8.915048e-01, 8.915167e-01, 8.915285e-01, 8.915404e-01, 8.915523e-01, 8.915642e-01,
    8.915761e-01, 8.915879e-01, 8.915998e-01, 8.916116e-01, 8.916235e-01, 8.916354e-01,
    8.916472e-01, 8.916591e-01, 8.916709e-01, 8.916828e-01, 8.916947e-01, 8.917066e-01,
    8.917184e-01, 8.917303e-01, 8.917422e-01, 8.917540e-01, 8.917659e-01, 8.917778e-01,
    8.917896e-01, 8.918015e-01, 8.918134e-01, 8.918253e-01, 8.918371e-01, 8.918490e-01,
    8.918608e-01, 8.918727e-01, 8.918846e-01, 8.918964e-01, 8.919083e-01, 8.919201e-01,
    8.919320e-01, 8.919438e-01, 8.919557e-01, 8.919675e-01, 8.919794e-01, 8.919913e-01,
    8.920032e-01, 8.920150e-01, 8.920269e-01, 8.920388e-01, 8.920506e-01, 8.920625e-01,
    8.920743e-01, 8.920862e-01, 8.920981e-01, 8.921099e-01, 8.921218e-01, 8.921337e-01,
    8.921456e-01, 8.921574e-01, 8.921692e-01, 8.921810e-01, 8.921930e-01, 8.922048e-01,
    8.922167e-01, 8.922285e-01, 8.922404e-01, 8.922523e-01, 8.922641e-01, 8.922760e-01,
    8.922879e-01, 8.922997e-01, 8.923116e-01, 8.923234e-01, 8.923352e-01, 8.923471e-01,
    8.923590e-01, 8.923708e-01, 8.923827e-01, 8.923946e-01, 8.924065e-01, 8.924183e-01,
    8.924302e-01, 8.924420e-01, 8.924539e-01, 8.924657e-01, 8.924776e-01, 8.924894e-01,
    8.925013e-01, 8.925132e-01, 8.925250e-01, 8.925369e-01, 8.925487e-01, 8.925607e-01,
    8.925725e-01, 8.925843e-01, 8.925961e-01, 8.926080e-01, 8.926199e-01, 8.926318e-01,
    8.926436e-01, 8.926555e-01, 8.926674e-01, 8.926792e-01, 8.926910e-01, 8.927029e-01,
    8.927147e-01, 8.927266e-01, 8.927385e-01, 8.927503e-01, 8.927622e-01, 8.927740e-01,
    8.927858e-01, 8.927977e-01, 8.928096e-01, 8.928214e-01, 8.928333e-01, 8.928452e-01,
    8.928570e-01, 8.928689e-01, 8.928807e-01, 8.928925e-01, 8.929044e-01, 8.929163e-01,
    8.929282e-01, 8.929400e-01, 8.929519e-01, 8.929636e-01, 8.929756e-01, 8.929874e-01,
    8.929993e-01, 8.930112e-01, 8.930230e-01, 8.930349e-01, 8.930467e-01, 8.930585e-01,
    8.930704e-01, 8.930823e-01, 8.930941e-01, 8.931060e-01, 8.931178e-01, 8.931296e-01,
    8.931415e-01, 8.931534e-01, 8.931652e-01, 8.931771e-01, 8.931890e-01, 8.932008e-01,
    8.932126e-01, 8.932245e-01, 8.932363e-01, 8.932482e-01, 8.932601e-01, 8.932719e-01,
    8.932837e-01, 8.932956e-01, 8.933074e-01, 8.933193e-01, 8.933311e-01, 8.933430e-01,
    8.933548e-01, 8.933667e-01, 8.933786e-01, 8.933905e-01, 8.934022e-01, 8.934141e-01,
    8.934259e-01, 8.934378e-01, 8.934497e-01, 8.934615e-01, 8.934733e-01, 8.934852e-01,
    8.934970e-01, 8.935090e-01, 8.935208e-01, 8.935326e-01, 8.935444e-01, 8.935563e-01,
    8.935682e-01, 8.935801e-01, 8.935918e-01, 8.936037e-01, 8.936156e-01, 8.936275e-01,
    8.936393e-01, 8.936511e-01, 8.936629e-01, 8.936749e-01, 8.936867e-01, 8.936985e-01,
    8.937103e-01, 8.937222e-01, 8.937341e-01, 8.937460e-01, 8.937577e-01, 8.937696e-01,
    8.937814e-01, 8.937933e-01, 8.938051e-01, 8.938169e-01, 8.938288e-01, 8.938407e-01,
    8.938526e-01, 8.938643e-01, 8.938762e-01, 8.938881e-01, 8.938999e-01, 8.939117e-01,
    8.939236e-01, 8.939354e-01, 8.939473e-01, 8.939592e-01, 8.939710e-01, 8.939828e-01,
    8.939947e-01, 8.940066e-01, 8.940184e-01, 8.940302e-01, 8.940421e-01, 8.940539e-01,
    8.940657e-01, 8.940776e-01, 8.940895e-01, 8.941013e-01, 8.941131e-01, 8.941250e-01,
    8.941368e-01, 8.941487e-01, 8.941605e-01, 8.941724e-01, 8.941842e-01, 8.941961e-01,
    8.942079e-01, 8.942198e-01, 8.942316e-01, 8.942434e-01, 8.942553e-01, 8.942671e-01,
    8.942790e-01, 8.942908e-01, 8.943027e-01, 8.943145e-01, 8.943264e-01, 8.943381e-01,
    8.943501e-01, 8.943619e-01, 8.943738e-01, 8.943855e-01, 8.943974e-01, 8.944093e-01,
    8.944210e-01, 8.944329e-01, 8.944448e-01, 8.944567e-01, 8.944684e-01, 8.944803e-01,
    8.944921e-01, 8.945040e-01, 8.945158e-01, 8.945277e-01, 8.945395e-01, 8.945513e-01,
    8.945632e-01, 8.945751e-01, 8.945869e-01, 8.945987e-01, 8.946106e-01, 8.946224e-01,
    8.946342e-01, 8.946461e-01, 8.946580e-01, 8.946698e-01, 8.946816e-01, 8.946935e-01,
    8.947052e-01, 8.947171e-01, 8.947290e-01, 8.947408e-01, 8.947526e-01, 8.947645e-01,
    8.947763e-01, 8.947881e-01, 8.948000e-01, 8.948118e-01, 8.948237e-01, 8.948355e-01,
    8.948474e-01, 8.948592e-01, 8.948711e-01, 8.948829e-01, 8.948947e-01, 8.949066e-01,
    8.949184e-01, 8.949302e-01, 8.949421e-01, 8.949540e-01, 8.949657e-01, 8.949776e-01,
    8.949894e-01, 8.950012e-01, 8.950131e-01, 8.950250e-01, 8.950368e-01, 8.950486e-01,
    8.950605e-01, 8.950723e-01, 8.950841e-01, 8.950960e-01, 8.951078e-01, 8.951197e-01,
    8.951314e-01, 8.951433e-01, 8.951552e-01, 8.951669e-01, 8.951788e-01, 8.951907e-01,
    8.952025e-01, 8.952143e-01, 8.952262e-01, 8.952380e-01, 8.952498e-01, 8.952617e-01,
    8.952735e-01, 8.952854e-01, 8.952971e-01, 8.953090e-01, 8.953209e-01, 8.953326e-01,
    8.953445e-01, 8.953564e-01, 8.953682e-01, 8.953800e-01, 8.953919e-01, 8.954037e-01,
    8.954155e-01, 8.954273e-01, 8.954392e-01, 8.954511e-01, 8.954628e-01, 8.954747e-01,
    8.954865e-01, 8.954983e-01, 8.955102e-01, 8.955220e-01, 8.955339e-01, 8.955457e-01,
    8.955575e-01, 8.955694e-01, 8.955812e-01, 8.955930e-01, 8.956049e-01, 8.956167e-01,
    8.956286e-01, 8.956403e-01, 8.956522e-01, 8.956640e-01, 8.956758e-01, 8.956877e-01,
    8.956995e-01, 8.957114e-01, 8.957232e-01, 8.957350e-01, 8.957469e-01, 8.957586e-01,
    8.957705e-01, 8.957824e-01, 8.957942e-01, 8.958060e-01, 8.958178e-01, 8.958297e-01,
    8.958415e-01, 8.958533e-01, 8.958652e-01, 8.958770e-01, 8.958889e-01, 8.959006e-01,
    8.959125e-01, 8.959243e-01, 8.959361e-01, 8.959480e-01, 8.959598e-01, 8.959717e-01,
    8.959835e-01, 8.959953e-01, 8.960072e-01, 8.960189e-01, 8.960308e-01, 8.960426e-01,
    8.960544e-01, 8.960662e-01, 8.960781e-01, 8.960899e-01, 8.961018e-01, 8.961136e-01,
    8.961254e-01, 8.961373e-01, 8.961490e-01, 8.961609e-01, 8.961727e-01, 8.961846e-01,
    8.961964e-01, 8.962082e-01, 8.962201e-01, 8.962319e-01, 8.962438e-01, 8.962555e-01,
    8.962674e-01, 8.962792e-01, 8.962910e-01, 8.963028e-01, 8.963147e-01, 8.963264e-01,
    8.963383e-01, 8.963502e-01, 8.963619e-01, 8.963738e-01, 8.963856e-01, 8.963975e-01,
    8.964093e-01, 8.964211e-01, 8.964329e-01, 8.964448e-01, 8.964565e-01, 8.964684e-01,
    8.964802e-01, 8.964921e-01, 8.965039e-01, 8.965157e-01, 8.965275e-01, 8.965394e-01,
    8.965511e-01, 8.965630e-01, 8.965748e-01, 8.965867e-01, 8.965985e-01, 8.966103e-01,
    8.966222e-01, 8.966340e-01, 8.966458e-01, 8.966576e-01, 8.966694e-01, 8.966812e-01,
    8.966931e-01, 8.967049e-01, 8.967168e-01, 8.967286e-01, 8.967404e-01, 8.967522e-01,
    8.967640e-01, 8.967758e-01, 8.967877e-01, 8.967995e-01, 8.968112e-01, 8.968231e-01,
    8.968349e-01, 8.968468e-01, 8.968586e-01, 8.968704e-01, 8.968822e-01, 8.968941e-01,
    8.969058e-01, 8.969177e-01, 8.969295e-01, 8.969414e-01, 8.969532e-01, 8.969650e-01,
    8.969768e-01, 8.969887e-01, 8.970004e-01, 8.970123e-01, 8.970241e-01, 8.970360e-01,
    8.970478e-01, 8.970596e-01, 8.970714e-01, 8.970832e-01, 8.970950e-01, 8.971068e-01,
    8.971187e-01, 8.971305e-01, 8.971424e-01, 8.971541e-01, 8.971660e-01, 8.971778e-01,
    8.971896e-01, 8.972014e-01, 8.972133e-01, 8.972251e-01, 8.972368e-01, 8.972487e-01,
    8.972605e-01, 8.972723e-01, 8.972842e-01, 8.972960e-01, 8.973078e-01, 8.973197e-01,
    8.973314e-01, 8.973432e-01, 8.973551e-01, 8.973669e-01, 8.973787e-01, 8.973905e-01,
    8.974023e-01, 8.974141e-01, 8.974259e-01, 8.974378e-01, 8.974496e-01, 8.974615e-01,
    8.974732e-01, 8.974851e-01, 8.974969e-01, 8.975087e-01, 8.975205e-01, 8.975323e-01,
    8.975441e-01, 8.975559e-01, 8.975678e-01, 8.975796e-01, 8.975914e-01, 8.976033e-01,
    8.976150e-01, 8.976269e-01, 8.976387e-01, 8.976505e-01, 8.976623e-01, 8.976741e-01,
    8.976859e-01, 8.976977e-01, 8.977096e-01, 8.977214e-01, 8.977332e-01, 8.977451e-01,
    8.977568e-01, 8.977687e-01, 8.977805e-01, 8.977923e-01, 8.978041e-01, 8.978159e-01,
    8.978277e-01, 8.978395e-01, 8.978513e-01, 8.978632e-01, 8.978750e-01, 8.978868e-01,
    8.978986e-01, 8.979104e-01, 8.979223e-01, 8.979341e-01, 8.979458e-01, 8.979577e-01,
    8.979695e-01, 8.979813e-01, 8.979931e-01, 8.980049e-01, 8.980168e-01, 8.980286e-01,
    8.980404e-01, 8.980522e-01, 8.980640e-01, 8.980759e-01, 8.980876e-01, 8.980994e-01,
    8.981113e-01, 8.981231e-01, 8.981348e-01, 8.981467e-01, 8.981585e-01, 8.981703e-01,
    8.981822e-01, 8.981939e-01, 8.982058e-01, 8.982176e-01, 8.982294e-01, 8.982412e-01,
    8.982530e-01, 8.982648e-01, 8.982766e-01, 8.982884e-01, 8.983002e-01, 8.983121e-01,
    8.983238e-01, 8.983356e-01, 8.983475e-01, 8.983593e-01, 8.983710e-01, 8.983830e-01,
    8.983947e-01, 8.984065e-01, 8.984184e-01, 8.984302e-01, 8.984419e-01, 8.984538e-01,
    8.984656e-01, 8.984774e-01, 8.984892e-01, 8.985010e-01, 8.985128e-01, 8.985246e-01,
    8.985364e-01, 8.985482e-01, 8.985600e-01, 8.985718e-01, 8.985837e-01, 8.985955e-01,
    8.986073e-01, 8.986191e-01, 8.986309e-01, 8.986427e-01, 8.986545e-01, 8.986664e-01,
    8.986781e-01, 8.986899e-01, 8.987018e-01, 8.987136e-01, 8.987253e-01, 8.987371e-01,
    8.987490e-01, 8.987608e-01, 8.987725e-01, 8.987844e-01, 8.987962e-01, 8.988080e-01,
    8.988199e-01, 8.988317e-01, 8.988434e-01, 8.988553e-01, 8.988671e-01, 8.988789e-01,
    8.988906e-01, 8.989025e-01, 8.989143e-01, 8.989261e-01, 8.989379e-01, 8.989497e-01,
    8.989615e-01, 8.989733e-01, 8.989851e-01, 8.989969e-01, 8.990087e-01, 8.990206e-01,
    8.990324e-01, 8.990441e-01, 8.990559e-01, 8.990678e-01, 8.990796e-01, 8.990913e-01,
    8.991031e-01, 8.991150e-01, 8.991268e-01, 8.991385e-01, 8.991504e-01, 8.991622e-01,
    8.991740e-01, 8.991858e-01, 8.991976e-01, 8.992094e-01, 8.992212e-01, 8.992330e-01,
    8.992448e-01, 8.992566e-01, 8.992684e-01, 8.992802e-01, 8.992921e-01, 8.993038e-01,
    8.993156e-01, 8.993274e-01, 8.993393e-01, 8.993510e-01, 8.993628e-01, 8.993746e-01,
    8.993865e-01, 8.993982e-01, 8.994100e-01, 8.994218e-01, 8.994337e-01, 8.994454e-01,
    8.994572e-01, 8.994690e-01, 8.994809e-01, 8.994926e-01, 8.995044e-01, 8.995162e-01,
    8.995281e-01, 8.995399e-01, 8.995516e-01, 8.995634e-01, 8.995752e-01, 8.995871e-01,
    8.995988e-01, 8.996106e-01, 8.996224e-01, 8.996343e-01, 8.996460e-01, 8.996578e-01,
    8.996696e-01, 8.996814e-01, 8.996933e-01, 8.997051e-01, 8.997169e-01, 8.997286e-01,
    8.997405e-01, 8.997523e-01, 8.997641e-01, 8.997758e-01, 8.997876e-01, 8.997995e-01,
    8.998113e-01, 8.998230e-01, 8.998348e-01, 8.998466e-01, 8.998585e-01, 8.998702e-01,
    8.998820e-01, 8.998938e-01, 8.999056e-01, 8.999174e-01, 8.999292e-01, 8.999410e-01,
    8.999528e-01, 8.999646e-01, 8.999764e-01, 8.999882e-01, 9.000000e-01, 9.000118e-01,
    9.000236e-01, 9.000353e-01, 9.000472e-01, 9.000590e-01, 9.000708e-01, 9.000825e-01,
    9.000943e-01, 9.001062e-01, 9.001180e-01, 9.001297e-01, 9.001415e-01, 9.001533e-01,
    9.001651e-01, 9.001769e-01, 9.001887e-01, 9.002005e-01, 9.002123e-01, 9.002241e-01,
    9.002359e-01, 9.002478e-01, 9.002595e-01, 9.002713e-01, 9.002831e-01, 9.002948e-01,
    9.003066e-01, 9.003185e-01, 9.003303e-01, 9.003420e-01, 9.003538e-01, 9.003657e-01,
    9.003774e-01, 9.003892e-01, 9.004011e-01, 9.004129e-01, 9.004246e-01, 9.004364e-01,
    9.004482e-01, 9.004599e-01, 9.004718e-01, 9.004836e-01, 9.004954e-01, 9.005072e-01,
    9.005190e-01, 9.005308e-01, 9.005425e-01, 9.005543e-01, 9.005662e-01, 9.005780e-01,
    9.005897e-01, 9.006015e-01, 9.006133e-01, 9.006251e-01, 9.006369e-01, 9.006487e-01,
    9.006605e-01, 9.006723e-01, 9.006841e-01, 9.006959e-01, 9.007076e-01, 9.007194e-01,
    9.007312e-01, 9.007429e-01, 9.007548e-01, 9.007666e-01, 9.007784e-01, 9.007902e-01,
    9.008020e-01, 9.008138e-01, 9.008255e-01, 9.008373e-01, 9.008491e-01, 9.008610e-01,
    9.008727e-01, 9.008845e-01, 9.008963e-01, 9.009081e-01, 9.009199e-01, 9.009317e-01,
    9.009434e-01, 9.009552e-01, 9.009670e-01, 9.009789e-01, 9.009906e-01, 9.010024e-01,
    9.010142e-01, 9.010260e-01, 9.010378e-01, 9.010495e-01, 9.010613e-01, 9.010731e-01,
    9.010848e-01, 9.010966e-01, 9.011085e-01, 9.011203e-01, 9.011320e-01, 9.011438e-01,
    9.011557e-01, 9.011674e-01, 9.011792e-01, 9.011910e-01, 9.012027e-01, 9.012145e-01,
    9.012263e-01, 9.012381e-01, 9.012499e-01, 9.012617e-01, 9.012735e-01, 9.012853e-01,
    9.012971e-01, 9.013089e-01, 9.013206e-01, 9.013324e-01, 9.013442e-01, 9.013560e-01,
    9.013678e-01, 9.013796e-01, 9.013913e-01, 9.014031e-01, 9.014149e-01, 9.014267e-01,
    9.014385e-01, 9.014502e-01, 9.014621e-01, 9.014739e-01, 9.014857e-01, 9.014974e-01,
    9.015092e-01, 9.015210e-01, 9.015328e-01, 9.015446e-01, 9.015564e-01, 9.015681e-01,
    9.015799e-01, 9.015917e-01, 9.016035e-01, 9.016153e-01, 9.016271e-01, 9.016388e-01,
    9.016506e-01, 9.016624e-01, 9.016742e-01, 9.016860e-01, 9.016978e-01, 9.017095e-01,
    9.017213e-01, 9.017330e-01, 9.017448e-01, 9.017566e-01, 9.017684e-01, 9.017802e-01,
    9.017920e-01, 9.018037e-01, 9.018155e-01, 9.018273e-01, 9.018391e-01, 9.018509e-01,
    9.018627e-01, 9.018745e-01, 9.018863e-01, 9.018981e-01, 9.019099e-01, 9.019216e-01,
    9.019334e-01, 9.019452e-01, 9.019570e-01, 9.019688e-01, 9.019806e-01, 9.019923e-01,
    9.020041e-01, 9.020159e-01, 9.020277e-01, 9.020395e-01, 9.020512e-01, 9.020630e-01,
    9.020747e-01, 9.020865e-01, 9.020983e-01, 9.021100e-01, 9.021218e-01, 9.021336e-01,
    9.021454e-01, 9.021572e-01, 9.021689e-01, 9.021807e-01, 9.021925e-01, 9.022043e-01,
    9.022161e-01, 9.022279e-01, 9.022396e-01, 9.022514e-01, 9.022632e-01, 9.022750e-01,
    9.022868e-01, 9.022986e-01, 9.023103e-01, 9.023221e-01, 9.023339e-01, 9.023457e-01,
    9.023575e-01, 9.023693e-01, 9.023810e-01, 9.023928e-01, 9.024045e-01, 9.024163e-01,
    9.024282e-01, 9.024399e-01, 9.024517e-01, 9.024635e-01, 9.024752e-01, 9.024870e-01,
    9.024987e-01, 9.025105e-01, 9.025223e-01, 9.025341e-01, 9.025459e-01, 9.025576e-01,
    9.025694e-01, 9.025812e-01, 9.025930e-01, 9.026048e-01, 9.026166e-01, 9.026283e-01,
    9.026401e-01, 9.026519e-01, 9.026636e-01, 9.026754e-01, 9.026871e-01, 9.026989e-01,
    9.027107e-01, 9.027225e-01, 9.027343e-01, 9.027460e-01, 9.027578e-01, 9.027696e-01,
    9.027814e-01, 9.027932e-01, 9.028050e-01, 9.028167e-01, 9.028285e-01, 9.028402e-01,
    9.028520e-01, 9.028637e-01, 9.028755e-01, 9.028873e-01, 9.028991e-01, 9.029109e-01,
    9.029227e-01, 9.029344e-01, 9.029462e-01, 9.029580e-01, 9.029697e-01, 9.029815e-01,
    9.029933e-01, 9.030051e-01, 9.030168e-01, 9.030286e-01, 9.030404e-01, 9.030522e-01,
    9.030640e-01, 9.030758e-01, 9.030874e-01, 9.030992e-01, 9.031110e-01, 9.031228e-01,
    9.031346e-01, 9.031463e-01, 9.031581e-01, 9.031699e-01, 9.031817e-01, 9.031934e-01,
    9.032052e-01, 9.032170e-01, 9.032287e-01, 9.032405e-01, 9.032523e-01, 9.032640e-01,
    9.032758e-01, 9.032876e-01, 9.032993e-01, 9.033111e-01, 9.033229e-01, 9.033347e-01,
    9.033464e-01, 9.033582e-01, 9.033700e-01, 9.033817e-01, 9.033934e-01, 9.034052e-01,
    9.034171e-01, 9.034288e-01, 9.034406e-01, 9.034524e-01, 9.034641e-01, 9.034759e-01,
    9.034876e-01, 9.034994e-01, 9.035112e-01, 9.035230e-01, 9.035348e-01, 9.035465e-01,
    9.035583e-01, 9.035700e-01, 9.035818e-01, 9.035936e-01, 9.036053e-01, 9.036171e-01,
    9.036288e-01, 9.036406e-01, 9.036524e-01, 9.036642e-01, 9.036760e-01, 9.036877e-01,
    9.036995e-01, 9.037112e-01, 9.037230e-01, 9.037348e-01, 9.037465e-01, 9.037583e-01,
    9.037700e-01, 9.037818e-01, 9.037936e-01, 9.038054e-01, 9.038172e-01, 9.038289e-01,
    9.038406e-01, 9.038524e-01, 9.038642e-01, 9.038759e-01, 9.038877e-01, 9.038994e-01,
    9.039112e-01, 9.039230e-01, 9.039348e-01, 9.039466e-01, 9.039584e-01, 9.039701e-01,
    9.039818e-01, 9.039936e-01, 9.040054e-01, 9.040172e-01, 9.040289e-01, 9.040406e-01,
    9.040524e-01, 9.040642e-01, 9.040760e-01, 9.040877e-01, 9.040995e-01, 9.041113e-01,
    9.041230e-01, 9.041348e-01, 9.041465e-01, 9.041583e-01, 9.041700e-01, 9.041818e-01,
    9.041936e-01, 9.042053e-01, 9.042171e-01, 9.042289e-01, 9.042407e-01, 9.042524e-01,
    9.042642e-01, 9.042759e-01, 9.042877e-01, 9.042995e-01, 9.043112e-01, 9.043230e-01,
    9.043347e-01, 9.043465e-01, 9.043582e-01, 9.043700e-01, 9.043818e-01, 9.043936e-01,
    9.044054e-01, 9.044170e-01, 9.044288e-01, 9.044406e-01, 9.044524e-01, 9.044641e-01,
    9.044759e-01, 9.044876e-01, 9.044994e-01, 9.045111e-01, 9.045229e-01, 9.045346e-01,
    9.045464e-01, 9.045581e-01, 9.045699e-01, 9.045817e-01, 9.045935e-01, 9.046052e-01,
    9.046170e-01, 9.046288e-01, 9.046405e-01, 9.046522e-01, 9.046640e-01, 9.046758e-01,
    9.046876e-01, 9.046993e-01, 9.047110e-01, 9.047228e-01, 9.047346e-01, 9.047463e-01,
    9.047581e-01, 9.047698e-01, 9.047816e-01, 9.047933e-01, 9.048051e-01, 9.048169e-01,
    9.048287e-01, 9.048404e-01, 9.048522e-01, 9.048640e-01, 9.048756e-01, 9.048874e-01,
    9.048992e-01, 9.049110e-01, 9.049227e-01, 9.049345e-01, 9.049462e-01, 9.049579e-01,
    9.049697e-01, 9.049815e-01, 9.049932e-01, 9.050050e-01, 9.050167e-01, 9.050285e-01,
    9.050402e-01, 9.050520e-01, 9.050637e-01, 9.050756e-01, 9.050872e-01, 9.050990e-01,
    9.051108e-01, 9.051225e-01, 9.051343e-01, 9.051461e-01, 9.051577e-01, 9.051695e-01,
    9.051813e-01, 9.051931e-01, 9.052048e-01, 9.052166e-01, 9.052284e-01, 9.052401e-01,
    9.052519e-01, 9.052636e-01, 9.052753e-01, 9.052871e-01, 9.052989e-01, 9.053106e-01,
    9.053224e-01, 9.053341e-01, 9.053459e-01, 9.053576e-01, 9.053694e-01, 9.053811e-01,
    9.053929e-01, 9.054046e-01, 9.054164e-01, 9.054281e-01, 9.054399e-01, 9.054517e-01,
    9.054634e-01, 9.054751e-01, 9.054869e-01, 9.054986e-01, 9.055104e-01, 9.055222e-01,
    9.055339e-01, 9.055457e-01, 9.055575e-01, 9.055691e-01, 9.055809e-01, 9.055927e-01,
    9.056044e-01, 9.056162e-01, 9.056280e-01, 9.056396e-01, 9.056515e-01, 9.056631e-01,
    9.056749e-01, 9.056867e-01, 9.056984e-01, 9.057102e-01, 9.057220e-01, 9.057336e-01,
    9.057454e-01, 9.057572e-01, 9.057689e-01, 9.057807e-01, 9.057925e-01, 9.058042e-01,
    9.058160e-01, 9.058276e-01, 9.058394e-01, 9.058512e-01, 9.058629e-01, 9.058747e-01,
    9.058865e-01, 9.058982e-01, 9.059100e-01, 9.059216e-01, 9.059334e-01, 9.059452e-01,
    9.059569e-01, 9.059687e-01, 9.059805e-01, 9.059922e-01, 9.060039e-01, 9.060156e-01,
    9.060274e-01, 9.060392e-01, 9.060509e-01, 9.060627e-01, 9.060744e-01, 9.060861e-01,
    9.060979e-01, 9.061096e-01, 9.061214e-01, 9.061332e-01, 9.061449e-01, 9.061567e-01,
    9.061683e-01, 9.061801e-01, 9.061919e-01, 9.062036e-01, 9.062154e-01, 9.062271e-01,
    9.062389e-01, 9.062506e-01, 9.062623e-01, 9.062741e-01, 9.062858e-01, 9.062976e-01,
    9.063092e-01, 9.063210e-01, 9.063329e-01, 9.063445e-01, 9.063563e-01, 9.063680e-01,
    9.063798e-01, 9.063916e-01, 9.064032e-01, 9.064150e-01, 9.064267e-01, 9.064385e-01,
    9.064502e-01, 9.064620e-01, 9.064738e-01, 9.064854e-01, 9.064972e-01, 9.065089e-01,
    9.065207e-01, 9.065324e-01, 9.065442e-01, 9.065560e-01, 9.065677e-01, 9.065794e-01,
    9.065912e-01, 9.066029e-01, 9.066146e-01, 9.066264e-01, 9.066382e-01, 9.066499e-01,
    9.066617e-01, 9.066734e-01, 9.066851e-01, 9.066969e-01, 9.067086e-01, 9.067203e-01,
    9.067321e-01, 9.067439e-01, 9.067556e-01, 9.067674e-01, 9.067791e-01, 9.067908e-01,
    9.068025e-01, 9.068143e-01, 9.068260e-01, 9.068378e-01, 9.068494e-01, 9.068612e-01,
    9.068729e-01, 9.068847e-01, 9.068965e-01, 9.069082e-01, 9.069200e-01, 9.069317e-01,
    9.069434e-01, 9.069551e-01, 9.069669e-01, 9.069786e-01, 9.069904e-01, 9.070021e-01,
    9.070139e-01, 9.070256e-01, 9.070374e-01, 9.070491e-01, 9.070609e-01, 9.070725e-01,
    9.070843e-01, 9.070960e-01, 9.071078e-01, 9.071195e-01, 9.071313e-01, 9.071429e-01,
    9.071547e-01, 9.071664e-01, 9.071782e-01, 9.071899e-01, 9.072017e-01, 9.072134e-01,
    9.072252e-01, 9.072369e-01, 9.072486e-01, 9.072604e-01, 9.072721e-01, 9.072839e-01,
    9.072956e-01, 9.073073e-01, 9.073191e-01, 9.073308e-01, 9.073426e-01, 9.073542e-01,
    9.073660e-01, 9.073777e-01, 9.073895e-01, 9.074012e-01, 9.074129e-01, 9.074247e-01,
    9.074364e-01, 9.074481e-01, 9.074599e-01, 9.074716e-01, 9.074834e-01, 9.074951e-01,
    9.075069e-01, 9.075186e-01, 9.075304e-01, 9.075420e-01, 9.075539e-01, 9.075655e-01,
    9.075773e-01, 9.075890e-01, 9.076007e-01, 9.076124e-01, 9.076242e-01, 9.076359e-01,
    9.076476e-01, 9.076594e-01, 9.076711e-01, 9.076829e-01, 9.076946e-01, 9.077064e-01,
    9.077181e-01, 9.077299e-01, 9.077415e-01, 9.077532e-01, 9.077650e-01, 9.077767e-01,
    9.077885e-01, 9.078002e-01, 9.078119e-01, 9.078237e-01, 9.078354e-01, 9.078472e-01,
    9.078588e-01, 9.078706e-01, 9.078823e-01, 9.078941e-01, 9.079058e-01, 9.079176e-01,
    9.079292e-01, 9.079410e-01, 9.079527e-01, 9.079644e-01, 9.079762e-01, 9.079879e-01,
    9.079997e-01, 9.080114e-01, 9.080232e-01, 9.080349e-01, 9.080465e-01, 9.080583e-01,
    9.080700e-01, 9.080818e-01, 9.080935e-01, 9.081053e-01, 9.081170e-01, 9.081287e-01,
    9.081405e-01, 9.081522e-01, 9.081639e-01, 9.081756e-01, 9.081873e-01, 9.081991e-01,
    9.082108e-01, 9.082226e-01, 9.082343e-01, 9.082460e-01, 9.082577e-01, 9.082695e-01,
    9.082812e-01, 9.082929e-01, 9.083046e-01, 9.083164e-01, 9.083281e-01, 9.083399e-01,
    9.083515e-01, 9.083633e-01, 9.083750e-01, 9.083867e-01, 9.083985e-01, 9.084102e-01,
    9.084219e-01, 9.084337e-01, 9.084454e-01, 9.084572e-01, 9.084688e-01, 9.084805e-01,
    9.084923e-01, 9.085040e-01, 9.085157e-01, 9.085275e-01, 9.085392e-01, 9.085510e-01,
    9.085627e-01, 9.085743e-01, 9.085861e-01, 9.085978e-01, 9.086095e-01, 9.086213e-01,
    9.086330e-01, 9.086448e-01, 9.086565e-01, 9.086682e-01, 9.086800e-01, 9.086916e-01,
    9.087033e-01, 9.087151e-01, 9.087268e-01, 9.087386e-01, 9.087503e-01, 9.087620e-01,
    9.087738e-01, 9.087855e-01, 9.087971e-01, 9.088089e-01, 9.088206e-01, 9.088323e-01,
    9.088441e-01, 9.088558e-01, 9.088675e-01, 9.088793e-01, 9.088910e-01, 9.089027e-01,
    9.089144e-01, 9.089261e-01, 9.089379e-01, 9.089496e-01, 9.089614e-01, 9.089730e-01,
    9.089848e-01, 9.089965e-01, 9.090082e-01, 9.090199e-01, 9.090317e-01, 9.090434e-01,
    9.090552e-01, 9.090669e-01, 9.090785e-01, 9.090903e-01, 9.091020e-01, 9.091137e-01,
    9.091255e-01, 9.091372e-01, 9.091489e-01, 9.091607e-01, 9.091724e-01, 9.091840e-01,
    9.091958e-01, 9.092075e-01, 9.092192e-01, 9.092310e-01, 9.092427e-01, 9.092544e-01,
    9.092662e-01, 9.092779e-01, 9.092895e-01, 9.093013e-01, 9.093130e-01, 9.093247e-01,
    9.093364e-01, 9.093482e-01, 9.093599e-01, 9.093716e-01, 9.093834e-01, 9.093950e-01,
    9.094068e-01, 9.094185e-01, 9.094303e-01, 9.094419e-01, 9.094536e-01, 9.094654e-01,
    9.094771e-01, 9.094888e-01, 9.095005e-01, 9.095123e-01, 9.095240e-01, 9.095356e-01,
    9.095474e-01, 9.095591e-01, 9.095708e-01, 9.095826e-01, 9.095943e-01, 9.096060e-01,
    9.096177e-01, 9.096295e-01, 9.096411e-01, 9.096529e-01, 9.096646e-01, 9.096764e-01,
    9.096881e-01, 9.096997e-01, 9.097114e-01, 9.097232e-01, 9.097349e-01, 9.097466e-01,
    9.097583e-01, 9.097701e-01, 9.097818e-01, 9.097934e-01, 9.098052e-01, 9.098169e-01,
    9.098287e-01, 9.098403e-01, 9.098521e-01, 9.098638e-01, 9.098755e-01, 9.098872e-01,
    9.098990e-01, 9.099107e-01, 9.099224e-01, 9.099340e-01, 9.099458e-01, 9.099575e-01,
    9.099692e-01, 9.099810e-01, 9.099927e-01, 9.100044e-01, 9.100161e-01, 9.100278e-01,
    9.100395e-01, 9.100513e-01, 9.100630e-01, 9.100747e-01, 9.100863e-01, 9.100981e-01,
    9.101098e-01, 9.101215e-01, 9.101332e-01, 9.101450e-01, 9.101567e-01, 9.101684e-01,
    9.101801e-01, 9.101918e-01, 9.102036e-01, 9.102153e-01, 9.102269e-01, 9.102386e-01,
    9.102504e-01, 9.102621e-01, 9.102738e-01, 9.102855e-01, 9.102972e-01, 9.103090e-01,
    9.103207e-01, 9.103324e-01, 9.103441e-01, 9.103557e-01, 9.103675e-01, 9.103792e-01,
    9.103909e-01, 9.104027e-01, 9.104143e-01, 9.104261e-01, 9.104378e-01, 9.104495e-01,
    9.104612e-01, 9.104729e-01, 9.104847e-01, 9.104964e-01, 9.105080e-01, 9.105197e-01,
    9.105315e-01, 9.105432e-01, 9.105549e-01, 9.105666e-01, 9.105783e-01, 9.105900e-01,
    9.106018e-01, 9.106135e-01, 9.106252e-01, 9.106368e-01, 9.106486e-01, 9.106603e-01,
    9.106721e-01, 9.106838e-01, 9.106954e-01, 9.107071e-01, 9.107188e-01, 9.107305e-01,
    9.107423e-01, 9.107540e-01, 9.107657e-01, 9.107774e-01, 9.107891e-01, 9.108008e-01,
    9.108126e-01, 9.108242e-01, 9.108359e-01, 9.108476e-01, 9.108593e-01, 9.108710e-01,
    9.108828e-01, 9.108945e-01, 9.109062e-01, 9.109179e-01, 9.109296e-01, 9.109413e-01,
    9.109530e-01, 9.109647e-01, 9.109765e-01, 9.109882e-01, 9.109998e-01, 9.110115e-01,
    9.110232e-01, 9.110350e-01, 9.110467e-01, 9.110584e-01, 9.110701e-01, 9.110818e-01,
    9.110935e-01, 9.111052e-01, 9.111169e-01, 9.111286e-01, 9.111403e-01, 9.111521e-01,
    9.111637e-01, 9.111754e-01, 9.111871e-01, 9.111988e-01, 9.112106e-01, 9.112223e-01,
    9.112340e-01, 9.112457e-01, 9.112574e-01, 9.112691e-01, 9.112808e-01, 9.112925e-01,
    9.113042e-01, 9.113159e-01, 9.113277e-01, 9.113393e-01, 9.113510e-01, 9.113627e-01,
    9.113744e-01, 9.113861e-01, 9.113978e-01, 9.114095e-01, 9.114213e-01, 9.114330e-01,
    9.114447e-01, 9.114563e-01, 9.114681e-01, 9.114798e-01, 9.114915e-01, 9.115031e-01,
    9.115148e-01, 9.115266e-01, 9.115383e-01, 9.115500e-01, 9.115617e-01, 9.115734e-01,
    9.115851e-01, 9.115968e-01, 9.116085e-01, 9.116202e-01, 9.116319e-01, 9.116436e-01,
    9.116552e-01, 9.116670e-01, 9.116787e-01, 9.116904e-01, 9.117022e-01, 9.117138e-01,
    9.117255e-01, 9.117372e-01, 9.117489e-01, 9.117606e-01, 9.117723e-01, 9.117840e-01,
    9.117957e-01, 9.118074e-01, 9.118192e-01, 9.118308e-01, 9.118425e-01, 9.118543e-01,
    9.118659e-01, 9.118776e-01, 9.118893e-01, 9.119011e-01, 9.119127e-01, 9.119244e-01,
    9.119361e-01, 9.119478e-01, 9.119595e-01, 9.119712e-01, 9.119829e-01, 9.119946e-01,
    9.120063e-01, 9.120181e-01, 9.120297e-01, 9.120414e-01, 9.120532e-01, 9.120649e-01,
    9.120765e-01, 9.120882e-01, 9.120999e-01, 9.121116e-01, 9.121233e-01, 9.121350e-01,
    9.121467e-01, 9.121584e-01, 9.121701e-01, 9.121818e-01, 9.121935e-01, 9.122052e-01,
    9.122169e-01, 9.122286e-01, 9.122403e-01, 9.122519e-01, 9.122636e-01, 9.122754e-01,
    9.122871e-01, 9.122987e-01, 9.123104e-01, 9.123221e-01, 9.123338e-01, 9.123455e-01,
    9.123572e-01, 9.123689e-01, 9.123806e-01, 9.123924e-01, 9.124041e-01, 9.124157e-01,
    9.124275e-01, 9.124392e-01, 9.124509e-01, 9.124625e-01, 9.124743e-01, 9.124860e-01,
    9.124976e-01, 9.125093e-01, 9.125210e-01, 9.125327e-01, 9.125444e-01, 9.125561e-01,
    9.125678e-01, 9.125795e-01, 9.125912e-01, 9.126029e-01, 9.126146e-01, 9.126263e-01,
    9.126379e-01, 9.126497e-01, 9.126614e-01, 9.126731e-01, 9.126847e-01, 9.126964e-01,
    9.127080e-01, 9.127197e-01, 9.127315e-01, 9.127432e-01, 9.127548e-01, 9.127665e-01,
    9.127782e-01, 9.127899e-01, 9.128016e-01, 9.128133e-01, 9.128250e-01, 9.128367e-01,
    9.128484e-01, 9.128601e-01, 9.128718e-01, 9.128835e-01, 9.128952e-01, 9.129069e-01,
    9.129186e-01, 9.129303e-01, 9.129419e-01, 9.129537e-01, 9.129654e-01, 9.129770e-01,
    9.129887e-01, 9.130004e-01, 9.130121e-01, 9.130238e-01, 9.130355e-01, 9.130472e-01,
    9.130588e-01, 9.130705e-01, 9.130822e-01, 9.130939e-01, 9.131056e-01, 9.131173e-01,
    9.131290e-01, 9.131407e-01, 9.131524e-01, 9.131641e-01, 9.131758e-01, 9.131874e-01,
    9.131991e-01, 9.132109e-01, 9.132226e-01, 9.132342e-01, 9.132459e-01, 9.132576e-01,
    9.132692e-01, 9.132809e-01, 9.132926e-01, 9.133043e-01, 9.133160e-01, 9.133277e-01,
    9.133394e-01, 9.133511e-01, 9.133628e-01, 9.133745e-01, 9.133862e-01, 9.133979e-01,
    9.134096e-01, 9.134212e-01, 9.134329e-01, 9.134446e-01, 9.134563e-01, 9.134679e-01,
    9.134797e-01, 9.134914e-01, 9.135031e-01, 9.135147e-01, 9.135264e-01, 9.135382e-01,
    9.135497e-01, 9.135615e-01, 9.135731e-01, 9.135848e-01, 9.135965e-01, 9.136082e-01,
    9.136199e-01, 9.136316e-01, 9.136433e-01, 9.136550e-01, 9.136666e-01, 9.136783e-01,
    9.136900e-01, 9.137017e-01, 9.137134e-01, 9.137251e-01, 9.137368e-01, 9.137484e-01,
    9.137602e-01, 9.137717e-01, 9.137835e-01, 9.137952e-01, 9.138069e-01, 9.138185e-01,
    9.138302e-01, 9.138420e-01, 9.138536e-01, 9.138653e-01, 9.138770e-01, 9.138886e-01,
    9.139003e-01, 9.139120e-01, 9.139237e-01, 9.139354e-01, 9.139471e-01, 9.139587e-01,
    9.139704e-01, 9.139821e-01, 9.139938e-01, 9.140055e-01, 9.140172e-01, 9.140289e-01,
    9.140405e-01, 9.140522e-01, 9.140639e-01, 9.140756e-01, 9.140873e-01, 9.140990e-01,
    9.141107e-01, 9.141223e-01, 9.141340e-01, 9.141456e-01, 9.141573e-01, 9.141691e-01,
    9.141808e-01, 9.141924e-01, 9.142041e-01, 9.142157e-01, 9.142274e-01, 9.142391e-01,
    9.142509e-01, 9.142625e-01, 9.142742e-01, 9.142858e-01, 9.142975e-01, 9.143092e-01,
    9.143209e-01, 9.143326e-01, 9.143442e-01, 9.143559e-01, 9.143676e-01, 9.143793e-01,
    9.143910e-01, 9.144027e-01, 9.144143e-01, 9.144260e-01, 9.144377e-01, 9.144494e-01,
    9.144611e-01, 9.144727e-01, 9.144844e-01, 9.144961e-01, 9.145077e-01, 9.145195e-01,
    9.145312e-01, 9.145428e-01, 9.145545e-01, 9.145662e-01, 9.145778e-01, 9.145895e-01,
    9.146011e-01, 9.146128e-01, 9.146246e-01, 9.146363e-01, 9.146479e-01, 9.146596e-01,
    9.146712e-01, 9.146829e-01, 9.146946e-01, 9.147063e-01, 9.147179e-01, 9.147297e-01,
    9.147413e-01, 9.147530e-01, 9.147647e-01, 9.147763e-01, 9.147880e-01, 9.147997e-01,
    9.148114e-01, 9.148231e-01, 9.148347e-01, 9.148464e-01, 9.148581e-01, 9.148698e-01,
    9.148814e-01, 9.148931e-01, 9.149048e-01, 9.149165e-01, 9.149282e-01, 9.149398e-01,
    9.149515e-01, 9.149632e-01, 9.149749e-01, 9.149865e-01, 9.149982e-01, 9.150099e-01,
    9.150215e-01, 9.150332e-01, 9.150448e-01, 9.150566e-01, 9.150683e-01, 9.150800e-01,
    9.150916e-01, 9.151033e-01, 9.151149e-01, 9.151266e-01, 9.151382e-01, 9.151499e-01,
    9.151617e-01, 9.151734e-01, 9.151850e-01, 9.151967e-01, 9.152083e-01, 9.152200e-01,
    9.152316e-01, 9.152433e-01, 9.152550e-01, 9.152668e-01, 9.152783e-01, 9.152901e-01,
    9.153017e-01, 9.153134e-01, 9.153250e-01, 9.153367e-01, 9.153484e-01, 9.153600e-01,
    9.153717e-01, 9.153834e-01, 9.153951e-01, 9.154067e-01, 9.154184e-01, 9.154301e-01,
    9.154418e-01, 9.154534e-01, 9.154651e-01, 9.154768e-01, 9.154884e-01, 9.155001e-01,
    9.155118e-01, 9.155235e-01, 9.155351e-01, 9.155468e-01, 9.155585e-01, 9.155701e-01,
    9.155818e-01, 9.155935e-01, 9.156052e-01, 9.156168e-01, 9.156285e-01, 9.156402e-01,
    9.156518e-01, 9.156635e-01, 9.156752e-01, 9.156869e-01, 9.156985e-01, 9.157102e-01,
    9.157219e-01, 9.157335e-01, 9.157452e-01, 9.157569e-01, 9.157685e-01, 9.157802e-01,
    9.157919e-01, 9.158036e-01, 9.158152e-01, 9.158269e-01, 9.158386e-01, 9.158502e-01,
    9.158618e-01, 9.158736e-01, 9.158852e-01, 9.158969e-01, 9.159086e-01, 9.159202e-01,
    9.159319e-01, 9.159436e-01, 9.159552e-01, 9.159669e-01, 9.159786e-01, 9.159902e-01,
    9.160019e-01, 9.160135e-01, 9.160253e-01, 9.160368e-01, 9.160486e-01, 9.160603e-01,
    9.160719e-01, 9.160836e-01, 9.160953e-01, 9.161069e-01, 9.161186e-01, 9.161302e-01,
    9.161419e-01, 9.161536e-01, 9.161652e-01, 9.161769e-01, 9.161885e-01, 9.162002e-01,
    9.162118e-01, 9.162235e-01, 9.162351e-01, 9.162468e-01, 9.162586e-01, 9.162701e-01,
    9.162819e-01, 9.162936e-01, 9.163052e-01, 9.163169e-01, 9.163285e-01, 9.163402e-01,
    9.163519e-01, 9.163635e-01, 9.163752e-01, 9.163868e-01, 9.163985e-01, 9.164101e-01,
    9.164218e-01, 9.164335e-01, 9.164451e-01, 9.164568e-01, 9.164684e-01, 9.164801e-01,
    9.164919e-01, 9.165034e-01, 9.165152e-01, 9.165267e-01, 9.165385e-01, 9.165502e-01,
    9.165618e-01, 9.165735e-01, 9.165851e-01, 9.165968e-01, 9.166085e-01, 9.166201e-01,
    9.166318e-01, 9.166434e-01, 9.166551e-01, 9.166667e-01, 9.166784e-01, 9.166901e-01,
    9.167017e-01, 9.167134e-01, 9.167250e-01, 9.167367e-01, 9.167483e-01, 9.167600e-01,
    9.167717e-01, 9.167833e-01, 9.167950e-01, 9.168066e-01, 9.168184e-01, 9.168299e-01,
    9.168417e-01, 9.168532e-01, 9.168650e-01, 9.168767e-01, 9.168882e-01, 9.169000e-01,
    9.169115e-01, 9.169233e-01, 9.169350e-01, 9.169466e-01, 9.169583e-01, 9.169699e-01,
    9.169816e-01, 9.169932e-01, 9.170049e-01, 9.170166e-01, 9.170282e-01, 9.170399e-01,
    9.170515e-01, 9.170632e-01, 9.170749e-01, 9.170865e-01, 9.170982e-01, 9.171098e-01,
    9.171215e-01, 9.171331e-01, 9.171448e-01, 9.171565e-01, 9.171681e-01, 9.171798e-01,
    9.171914e-01, 9.172031e-01, 9.172147e-01, 9.172264e-01, 9.172380e-01, 9.172497e-01,
    9.172614e-01, 9.172730e-01, 9.172847e-01, 9.172963e-01, 9.173080e-01, 9.173196e-01,
    9.173313e-01, 9.173429e-01, 9.173546e-01, 9.173663e-01, 9.173779e-01, 9.173896e-01,
    9.174012e-01, 9.174129e-01, 9.174245e-01, 9.174362e-01, 9.174478e-01, 9.174595e-01,
    9.174711e-01, 9.174828e-01, 9.174944e-01, 9.175061e-01, 9.175177e-01, 9.175294e-01,
    9.175411e-01, 9.175527e-01, 9.175644e-01, 9.175760e-01, 9.175877e-01, 9.175993e-01,
    9.176110e-01, 9.176226e-01, 9.176343e-01, 9.176459e-01, 9.176576e-01, 9.176692e-01,
    9.176809e-01, 9.176925e-01, 9.177042e-01, 9.177158e-01, 9.177275e-01, 9.177392e-01,
    9.177508e-01, 9.177625e-01, 9.177741e-01, 9.177858e-01, 9.177974e-01, 9.178091e-01,
    9.178208e-01, 9.178324e-01, 9.178441e-01, 9.178557e-01, 9.178674e-01, 9.178790e-01,
    9.178907e-01, 9.179023e-01, 9.179140e-01, 9.179256e-01, 9.179373e-01, 9.179489e-01,
    9.179606e-01, 9.179722e-01, 9.179839e-01, 9.179955e-01, 9.180072e-01, 9.180188e-01,
    9.180305e-01, 9.180421e-01, 9.180538e-01, 9.180654e-01, 9.180771e-01, 9.180887e-01,
    9.181004e-01, 9.181120e-01, 9.181237e-01, 9.181353e-01, 9.181470e-01, 9.181586e-01,
    9.181703e-01, 9.181819e-01, 9.181935e-01, 9.182052e-01, 9.182168e-01, 9.182285e-01,
    9.182401e-01, 9.182518e-01, 9.182634e-01, 9.182751e-01, 9.182867e-01, 9.182984e-01,
    9.183100e-01, 9.183217e-01, 9.183334e-01, 9.183450e-01, 9.183567e-01, 9.183683e-01,
    9.183800e-01, 9.183916e-01, 9.184033e-01, 9.184149e-01, 9.184266e-01, 9.184382e-01,
    9.184499e-01, 9.184615e-01, 9.184731e-01, 9.184848e-01, 9.184964e-01, 9.185081e-01,
    9.185197e-01, 9.185314e-01, 9.185430e-01, 9.185546e-01, 9.185663e-01, 9.185779e-01,
    9.185896e-01, 9.186012e-01, 9.186129e-01, 9.186245e-01, 9.186361e-01, 9.186478e-01,
    9.186594e-01, 9.186711e-01, 9.186828e-01, 9.186944e-01, 9.187061e-01, 9.187176e-01,
    9.187294e-01, 9.187409e-01, 9.187527e-01, 9.187642e-01, 9.187759e-01, 9.187875e-01,
    9.187992e-01, 9.188108e-01, 9.188225e-01, 9.188341e-01, 9.188458e-01, 9.188574e-01,
    9.188691e-01, 9.188807e-01, 9.188924e-01, 9.189040e-01, 9.189156e-01, 9.189273e-01,
    9.189389e-01, 9.189506e-01, 9.189622e-01, 9.189738e-01, 9.189855e-01, 9.189971e-01,
    9.190088e-01, 9.190204e-01, 9.190320e-01, 9.190437e-01, 9.190553e-01, 9.190670e-01,
    9.190786e-01, 9.190903e-01, 9.191020e-01, 9.191136e-01, 9.191251e-01, 9.191369e-01,
    9.191484e-01, 9.191601e-01, 9.191718e-01, 9.191834e-01, 9.191951e-01, 9.192067e-01,
    9.192183e-01, 9.192300e-01, 9.192416e-01, 9.192533e-01, 9.192649e-01, 9.192765e-01,
    9.192882e-01, 9.192998e-01, 9.193114e-01, 9.193231e-01, 9.193347e-01, 9.193463e-01,
    9.193580e-01, 9.193696e-01, 9.193813e-01, 9.193929e-01, 9.194046e-01, 9.194162e-01,
    9.194279e-01, 9.194394e-01, 9.194512e-01, 9.194627e-01, 9.194744e-01, 9.194860e-01,
    9.194977e-01, 9.195093e-01, 9.195210e-01, 9.195326e-01, 9.195442e-01, 9.195559e-01,
    9.195675e-01, 9.195791e-01, 9.195908e-01, 9.196024e-01, 9.196140e-01, 9.196257e-01,
    9.196373e-01, 9.196489e-01, 9.196606e-01, 9.196723e-01, 9.196839e-01, 9.196956e-01,
    9.197071e-01, 9.197187e-01, 9.197304e-01, 9.197420e-01, 9.197537e-01, 9.197654e-01,
    9.197770e-01, 9.197886e-01, 9.198003e-01, 9.198119e-01, 9.198235e-01, 9.198352e-01,
    9.198468e-01, 9.198584e-01, 9.198701e-01, 9.198817e-01, 9.198933e-01, 9.199049e-01,
    9.199166e-01, 9.199283e-01, 9.199398e-01, 9.199516e-01, 9.199631e-01, 9.199747e-01,
    9.199864e-01, 9.199980e-01, 9.200097e-01, 9.200213e-01, 9.200330e-01, 9.200446e-01,
    9.200562e-01, 9.200679e-01, 9.200795e-01, 9.200911e-01, 9.201028e-01, 9.201144e-01,
    9.201260e-01, 9.201376e-01, 9.201493e-01, 9.201609e-01, 9.201725e-01, 9.201841e-01,
    9.201958e-01, 9.202074e-01, 9.202191e-01, 9.202307e-01, 9.202424e-01, 9.202540e-01,
    9.202656e-01, 9.202773e-01, 9.202889e-01, 9.203005e-01, 9.203122e-01, 9.203238e-01,
    9.203354e-01, 9.203470e-01, 9.203587e-01, 9.203703e-01, 9.203819e-01, 9.203935e-01,
    9.204052e-01, 9.204168e-01, 9.204285e-01, 9.204401e-01, 9.204518e-01, 9.204634e-01,
    9.204749e-01, 9.204866e-01, 9.204983e-01, 9.205099e-01, 9.205215e-01, 9.205331e-01,
    9.205448e-01, 9.205564e-01, 9.205680e-01, 9.205796e-01, 9.205913e-01, 9.206029e-01,
    9.206145e-01, 9.206262e-01, 9.206378e-01, 9.206495e-01, 9.206610e-01, 9.206727e-01,
    9.206843e-01, 9.206960e-01, 9.207076e-01, 9.207192e-01, 9.207308e-01, 9.207425e-01,
    9.207541e-01, 9.207657e-01, 9.207773e-01, 9.207890e-01, 9.208006e-01, 9.208122e-01,
    9.208238e-01, 9.208356e-01, 9.208471e-01, 9.208587e-01, 9.208704e-01, 9.208820e-01,
    9.208937e-01, 9.209053e-01, 9.209169e-01, 9.209285e-01, 9.209401e-01, 9.209518e-01,
    9.209634e-01, 9.209750e-01, 9.209866e-01, 9.209982e-01, 9.210099e-01, 9.210215e-01,
    9.210331e-01, 9.210448e-01, 9.210564e-01, 9.210681e-01, 9.210796e-01, 9.210913e-01,
    9.211029e-01, 9.211145e-01, 9.211262e-01, 9.211378e-01, 9.211494e-01, 9.211610e-01,
    9.211726e-01, 9.211843e-01, 9.211959e-01, 9.212075e-01, 9.212191e-01, 9.212307e-01,
    9.212424e-01, 9.212540e-01, 9.212657e-01, 9.212773e-01, 9.212888e-01, 9.213005e-01,
    9.213122e-01, 9.213238e-01, 9.213354e-01, 9.213470e-01, 9.213586e-01, 9.213702e-01,
    9.213819e-01, 9.213935e-01, 9.214051e-01, 9.214168e-01, 9.214283e-01, 9.214399e-01,
    9.214516e-01, 9.214633e-01, 9.214749e-01, 9.214865e-01, 9.214981e-01, 9.215097e-01,
    9.215214e-01, 9.215330e-01, 9.215446e-01, 9.215562e-01, 9.215679e-01, 9.215794e-01,
    9.215911e-01, 9.216027e-01, 9.216143e-01, 9.216260e-01, 9.216376e-01, 9.216492e-01,
    9.216608e-01, 9.216725e-01, 9.216841e-01, 9.216957e-01, 9.217073e-01, 9.217189e-01,
    9.217305e-01, 9.217421e-01, 9.217538e-01, 9.217654e-01, 9.217771e-01, 9.217886e-01,
    9.218003e-01, 9.218119e-01, 9.218235e-01, 9.218351e-01, 9.218468e-01, 9.218584e-01,
    9.218700e-01, 9.218816e-01, 9.218932e-01, 9.219048e-01, 9.219164e-01, 9.219280e-01,
    9.219397e-01, 9.219514e-01, 9.219630e-01, 9.219745e-01, 9.219862e-01, 9.219978e-01,
    9.220094e-01, 9.220210e-01, 9.220326e-01, 9.220443e-01, 9.220559e-01, 9.220675e-01,
    9.220791e-01, 9.220908e-01, 9.221023e-01, 9.221140e-01, 9.221256e-01, 9.221372e-01,
    9.221488e-01, 9.221605e-01, 9.221721e-01, 9.221837e-01, 9.221953e-01, 9.222069e-01,
    9.222185e-01, 9.222301e-01, 9.222417e-01, 9.222534e-01, 9.222649e-01, 9.222766e-01,
    9.222882e-01, 9.222999e-01, 9.223115e-01, 9.223231e-01, 9.223347e-01, 9.223463e-01,
    9.223579e-01, 9.223695e-01, 9.223812e-01, 9.223927e-01, 9.224043e-01, 9.224160e-01,
    9.224276e-01, 9.224393e-01, 9.224509e-01, 9.224625e-01, 9.224741e-01, 9.224857e-01,
    9.224973e-01, 9.225089e-01, 9.225205e-01, 9.225321e-01, 9.225438e-01, 9.225553e-01,
    9.225670e-01, 9.225786e-01, 9.225902e-01, 9.226018e-01, 9.226134e-01, 9.226250e-01,
    9.226367e-01, 9.226483e-01, 9.226599e-01, 9.226716e-01, 9.226831e-01, 9.226947e-01,
    9.227064e-01, 9.227180e-01, 9.227296e-01, 9.227412e-01, 9.227528e-01, 9.227644e-01,
    9.227760e-01, 9.227876e-01, 9.227992e-01, 9.228109e-01, 9.228224e-01, 9.228340e-01,
    9.228457e-01, 9.228573e-01, 9.228688e-01, 9.228805e-01, 9.228921e-01, 9.229037e-01,
    9.229153e-01, 9.229269e-01, 9.229386e-01, 9.229502e-01, 9.229618e-01, 9.229735e-01,
    9.229851e-01, 9.229966e-01, 9.230083e-01, 9.230199e-01, 9.230315e-01, 9.230431e-01,
    9.230547e-01, 9.230663e-01, 9.230779e-01, 9.230895e-01, 9.231011e-01, 9.231128e-01,
    9.231244e-01, 9.231359e-01, 9.231476e-01, 9.231592e-01, 9.231708e-01, 9.231824e-01,
    9.231940e-01, 9.232056e-01, 9.232172e-01, 9.232289e-01, 9.232404e-01, 9.232520e-01,
    9.232637e-01, 9.232753e-01, 9.232869e-01, 9.232985e-01, 9.233101e-01, 9.233217e-01,
    9.233333e-01, 9.233449e-01, 9.233565e-01, 9.233682e-01, 9.233798e-01, 9.233913e-01,
    9.234030e-01, 9.234146e-01, 9.234262e-01, 9.234377e-01, 9.234493e-01, 9.234609e-01,
    9.234725e-01, 9.234841e-01, 9.234958e-01, 9.235073e-01, 9.235190e-01, 9.235306e-01,
    9.235422e-01, 9.235538e-01, 9.235654e-01, 9.235770e-01, 9.235886e-01, 9.236003e-01,
    9.236118e-01, 9.236234e-01, 9.236351e-01, 9.236467e-01, 9.236583e-01, 9.236699e-01,
    9.236815e-01, 9.236931e-01, 9.237047e-01, 9.237163e-01, 9.237279e-01, 9.237396e-01,
    9.237511e-01, 9.237627e-01, 9.237743e-01, 9.237859e-01, 9.237975e-01, 9.238091e-01,
    9.238207e-01, 9.238323e-01, 9.238439e-01, 9.238555e-01, 9.238672e-01, 9.238787e-01,
    9.238904e-01, 9.239020e-01, 9.239136e-01, 9.239252e-01, 9.239367e-01, 9.239483e-01,
    9.239599e-01, 9.239715e-01, 9.239832e-01, 9.239948e-01, 9.240063e-01, 9.240180e-01,
    9.240296e-01, 9.240412e-01, 9.240528e-01, 9.240644e-01, 9.240760e-01, 9.240875e-01,
    9.240991e-01, 9.241108e-01, 9.241224e-01, 9.241340e-01, 9.241456e-01, 9.241572e-01,
    9.241688e-01, 9.241804e-01, 9.241920e-01, 9.242036e-01, 9.242151e-01, 9.242268e-01,
    9.242384e-01, 9.242500e-01, 9.242616e-01, 9.242732e-01, 9.242848e-01, 9.242964e-01,
    9.243080e-01, 9.243196e-01, 9.243312e-01, 9.243428e-01, 9.243544e-01, 9.243660e-01,
    9.243776e-01, 9.243892e-01, 9.244008e-01, 9.244124e-01, 9.244241e-01, 9.244356e-01,
    9.244472e-01, 9.244587e-01, 9.244704e-01, 9.244820e-01, 9.244936e-01, 9.245052e-01,
    9.245168e-01, 9.245284e-01, 9.245399e-01, 9.245515e-01, 9.245632e-01, 9.245748e-01,
    9.245864e-01, 9.245980e-01, 9.246096e-01, 9.246211e-01, 9.246327e-01, 9.246444e-01,
    9.246560e-01, 9.246675e-01, 9.246792e-01, 9.246908e-01, 9.247023e-01, 9.247139e-01,
    9.247255e-01, 9.247371e-01, 9.247487e-01, 9.247603e-01, 9.247720e-01, 9.247835e-01,
    9.247951e-01, 9.248067e-01, 9.248183e-01, 9.248299e-01, 9.248415e-01, 9.248531e-01,
    9.248646e-01, 9.248763e-01, 9.248879e-01, 9.248995e-01, 9.249111e-01, 9.249227e-01,
    9.249342e-01, 9.249458e-01, 9.249575e-01, 9.249690e-01, 9.249806e-01, 9.249923e-01,
    9.250038e-01, 9.250154e-01, 9.250270e-01, 9.250386e-01, 9.250502e-01, 9.250618e-01,
    9.250733e-01, 9.250849e-01, 9.250966e-01, 9.251082e-01, 9.251198e-01, 9.251313e-01,
    9.251429e-01, 9.251545e-01, 9.251661e-01, 9.251778e-01, 9.251894e-01, 9.252009e-01,
    9.252125e-01, 9.252241e-01, 9.252357e-01, 9.252473e-01, 9.252588e-01, 9.252704e-01,
    9.252821e-01, 9.252937e-01, 9.253052e-01, 9.253168e-01, 9.253284e-01, 9.253400e-01,
    9.253516e-01, 9.253632e-01, 9.253747e-01, 9.253864e-01, 9.253980e-01, 9.254096e-01,
    9.254212e-01, 9.254327e-01, 9.254443e-01, 9.254559e-01, 9.254676e-01, 9.254791e-01,
    9.254907e-01, 9.255023e-01, 9.255139e-01, 9.255255e-01, 9.255370e-01, 9.255486e-01,
    9.255602e-01, 9.255719e-01, 9.255834e-01, 9.255950e-01, 9.256066e-01, 9.256182e-01,
    9.256298e-01, 9.256413e-01, 9.256529e-01, 9.256645e-01, 9.256762e-01, 9.256877e-01,
    9.256993e-01, 9.257109e-01, 9.257225e-01, 9.257341e-01, 9.257456e-01, 9.257572e-01,
    9.257689e-01, 9.257805e-01, 9.257920e-01, 9.258036e-01, 9.258152e-01, 9.258268e-01,
    9.258384e-01, 9.258499e-01, 9.258615e-01, 9.258732e-01, 9.258847e-01, 9.258963e-01,
    9.259079e-01, 9.259195e-01, 9.259310e-01, 9.259427e-01, 9.259542e-01, 9.259658e-01,
    9.259773e-01, 9.259890e-01, 9.260006e-01, 9.260121e-01, 9.260237e-01, 9.260353e-01,
    9.260470e-01, 9.260585e-01, 9.260701e-01, 9.260817e-01, 9.260933e-01, 9.261048e-01,
    9.261164e-01, 9.261280e-01, 9.261397e-01, 9.261512e-01, 9.261628e-01, 9.261744e-01,
    9.261859e-01, 9.261975e-01, 9.262092e-01, 9.262207e-01, 9.262323e-01, 9.262438e-01,
    9.262555e-01, 9.262670e-01, 9.262786e-01, 9.262902e-01, 9.263018e-01, 9.263133e-01,
    9.263250e-01, 9.263366e-01, 9.263481e-01, 9.263597e-01, 9.263713e-01, 9.263828e-01,
    9.263945e-01, 9.264060e-01, 9.264176e-01, 9.264292e-01, 9.264408e-01, 9.264524e-01,
    9.264639e-01, 9.264755e-01, 9.264871e-01, 9.264987e-01, 9.265103e-01, 9.265219e-01,
    9.265335e-01, 9.265450e-01, 9.265566e-01, 9.265682e-01, 9.265798e-01, 9.265913e-01,
    9.266030e-01, 9.266145e-01, 9.266261e-01, 9.266377e-01, 9.266492e-01, 9.266608e-01,
    9.266725e-01, 9.266840e-01, 9.266956e-01, 9.267072e-01, 9.267187e-01, 9.267303e-01,
    9.267419e-01, 9.267535e-01, 9.267651e-01, 9.267766e-01, 9.267882e-01, 9.267998e-01,
    9.268114e-01, 9.268229e-01, 9.268345e-01, 9.268461e-01, 9.268577e-01, 9.268693e-01,
    9.268809e-01, 9.268924e-01, 9.269040e-01, 9.269156e-01, 9.269271e-01, 9.269388e-01,
    9.269504e-01, 9.269619e-01, 9.269735e-01, 9.269850e-01, 9.269966e-01, 9.270082e-01,
    9.270198e-01, 9.270314e-01, 9.270430e-01, 9.270545e-01, 9.270661e-01, 9.270777e-01,
    9.270893e-01, 9.271008e-01, 9.271125e-01, 9.271240e-01, 9.271356e-01, 9.271471e-01,
    9.271587e-01, 9.271703e-01, 9.271818e-01, 9.271935e-01, 9.272051e-01, 9.272166e-01,
    9.272282e-01, 9.272397e-01, 9.272513e-01, 9.272630e-01, 9.272745e-01, 9.272861e-01,
    9.272976e-01, 9.273092e-01, 9.273208e-01, 9.273323e-01, 9.273440e-01, 9.273556e-01,
    9.273671e-01, 9.273787e-01, 9.273902e-01, 9.274018e-01, 9.274134e-01, 9.274250e-01,
    9.274366e-01, 9.274481e-01, 9.274597e-01, 9.274713e-01, 9.274828e-01, 9.274944e-01,
    9.275060e-01, 9.275176e-01, 9.275292e-01, 9.275407e-01, 9.275523e-01, 9.275638e-01,
    9.275755e-01, 9.275870e-01, 9.275986e-01, 9.276102e-01, 9.276217e-01, 9.276333e-01,
    9.276448e-01, 9.276565e-01, 9.276680e-01, 9.276796e-01, 9.276912e-01, 9.277027e-01,
    9.277143e-01, 9.277259e-01, 9.277375e-01, 9.277490e-01, 9.277606e-01, 9.277722e-01,
    9.277837e-01, 9.277953e-01, 9.278069e-01, 9.278185e-01, 9.278300e-01, 9.278416e-01,
    9.278532e-01, 9.278647e-01, 9.278764e-01, 9.278879e-01, 9.278995e-01, 9.279110e-01,
    9.279226e-01, 9.279342e-01, 9.279457e-01, 9.279574e-01, 9.279689e-01, 9.279805e-01,
    9.279920e-01, 9.280036e-01, 9.280152e-01, 9.280267e-01, 9.280384e-01, 9.280499e-01,
    9.280615e-01, 9.280730e-01, 9.280846e-01, 9.280961e-01, 9.281077e-01, 9.281192e-01,
    9.281309e-01, 9.281425e-01, 9.281540e-01, 9.281656e-01, 9.281771e-01, 9.281887e-01,
    9.282002e-01, 9.282119e-01, 9.282234e-01, 9.282350e-01, 9.282465e-01, 9.282581e-01,
    9.282696e-01, 9.282812e-01, 9.282928e-01, 9.283044e-01, 9.283159e-01, 9.283275e-01,
    9.283391e-01, 9.283506e-01, 9.283623e-01, 9.283738e-01, 9.283854e-01, 9.283969e-01,
    9.284085e-01, 9.284201e-01, 9.284316e-01, 9.284432e-01, 9.284548e-01, 9.284663e-01,
    9.284779e-01, 9.284894e-01, 9.285011e-01, 9.285126e-01, 9.285242e-01, 9.285357e-01,
    9.285473e-01, 9.285588e-01, 9.285704e-01, 9.285820e-01, 9.285936e-01, 9.286051e-01,
    9.286167e-01, 9.286282e-01, 9.286398e-01, 9.286514e-01, 9.286630e-01, 9.286745e-01,
    9.286861e-01, 9.286976e-01, 9.287092e-01, 9.287208e-01, 9.287324e-01, 9.287439e-01,
    9.287554e-01, 9.287670e-01, 9.287785e-01, 9.287902e-01, 9.288017e-01, 9.288133e-01,
    9.288248e-01, 9.288364e-01, 9.288480e-01, 9.288595e-01, 9.288711e-01, 9.288827e-01,
    9.288942e-01, 9.289058e-01, 9.289173e-01, 9.289290e-01, 9.289405e-01, 9.289520e-01,
    9.289636e-01, 9.289751e-01, 9.289867e-01, 9.289982e-01, 9.290099e-01, 9.290214e-01,
    9.290330e-01, 9.290445e-01, 9.290561e-01, 9.290677e-01, 9.290792e-01, 9.290908e-01,
    9.291023e-01, 9.291139e-01, 9.291254e-01, 9.291371e-01, 9.291486e-01, 9.291602e-01,
    9.291717e-01, 9.291833e-01, 9.291948e-01, 9.292064e-01, 9.292179e-01, 9.292295e-01,
    9.292411e-01, 9.292526e-01, 9.292642e-01, 9.292758e-01, 9.292873e-01, 9.292989e-01,
    9.293104e-01, 9.293220e-01, 9.293335e-01, 9.293451e-01, 9.293567e-01, 9.293682e-01,
    9.293798e-01, 9.293913e-01, 9.294029e-01, 9.294145e-01, 9.294261e-01, 9.294376e-01,
    9.294491e-01, 9.294607e-01, 9.294722e-01, 9.294838e-01, 9.294954e-01, 9.295069e-01,
    9.295185e-01, 9.295300e-01, 9.295416e-01, 9.295532e-01, 9.295647e-01, 9.295763e-01,
    9.295878e-01, 9.295994e-01, 9.296110e-01, 9.296225e-01, 9.296341e-01, 9.296456e-01,
    9.296572e-01, 9.296687e-01, 9.296802e-01, 9.296919e-01, 9.297034e-01, 9.297150e-01,
    9.297265e-01, 9.297380e-01, 9.297497e-01, 9.297612e-01, 9.297728e-01, 9.297843e-01,
    9.297958e-01, 9.298074e-01, 9.298189e-01, 9.298305e-01, 9.298421e-01, 9.298536e-01,
    9.298652e-01, 9.298767e-01, 9.298882e-01, 9.298999e-01, 9.299114e-01, 9.299229e-01,
    9.299345e-01, 9.299461e-01, 9.299576e-01, 9.299692e-01, 9.299807e-01, 9.299923e-01,
    9.300038e-01, 9.300154e-01, 9.300269e-01, 9.300385e-01, 9.300500e-01, 9.300616e-01,
    9.300731e-01, 9.300848e-01, 9.300963e-01, 9.301078e-01, 9.301194e-01, 9.301310e-01,
    9.301425e-01, 9.301541e-01, 9.301656e-01, 9.301771e-01, 9.301887e-01, 9.302002e-01,
    9.302118e-01, 9.302233e-01, 9.302349e-01, 9.302464e-01, 9.302580e-01, 9.302695e-01,
    9.302810e-01, 9.302927e-01, 9.303042e-01, 9.303157e-01, 9.303274e-01, 9.303389e-01,
    9.303504e-01, 9.303620e-01, 9.303735e-01, 9.303851e-01, 9.303966e-01, 9.304082e-01,
    9.304197e-01, 9.304313e-01, 9.304428e-01, 9.304544e-01, 9.304659e-01, 9.304775e-01,
    9.304890e-01, 9.305006e-01, 9.305121e-01, 9.305236e-01, 9.305353e-01, 9.305468e-01,
    9.305583e-01, 9.305699e-01, 9.305815e-01, 9.305930e-01, 9.306045e-01, 9.306161e-01,
    9.306276e-01, 9.306391e-01, 9.306508e-01, 9.306623e-01, 9.306738e-01, 9.306854e-01,
    9.306969e-01, 9.307085e-01, 9.307200e-01, 9.307316e-01, 9.307431e-01, 9.307546e-01,
    9.307662e-01, 9.307777e-01, 9.307893e-01, 9.308009e-01, 9.308124e-01, 9.308239e-01,
    9.308355e-01, 9.308470e-01, 9.308586e-01, 9.308701e-01, 9.308817e-01, 9.308932e-01,
    9.309047e-01, 9.309163e-01, 9.309279e-01, 9.309394e-01, 9.309509e-01, 9.309624e-01,
    9.309741e-01, 9.309856e-01, 9.309971e-01, 9.310088e-01, 9.310203e-01, 9.310318e-01,
    9.310433e-01, 9.310549e-01, 9.310665e-01, 9.310780e-01, 9.310895e-01, 9.311011e-01,
    9.311126e-01, 9.311242e-01, 9.311357e-01, 9.311473e-01, 9.311588e-01, 9.311703e-01,
    9.311818e-01, 9.311934e-01, 9.312050e-01, 9.312165e-01, 9.312280e-01, 9.312396e-01,
    9.312512e-01, 9.312627e-01, 9.312742e-01, 9.312858e-01, 9.312973e-01, 9.313089e-01,
    9.313204e-01, 9.313320e-01, 9.313435e-01, 9.313550e-01, 9.313666e-01, 9.313781e-01,
    9.313897e-01, 9.314012e-01, 9.314127e-01, 9.314243e-01, 9.314358e-01, 9.314474e-01,
    9.314589e-01, 9.314704e-01, 9.314820e-01, 9.314935e-01, 9.315051e-01, 9.315166e-01,
    9.315282e-01, 9.315397e-01, 9.315513e-01, 9.315628e-01, 9.315743e-01, 9.315859e-01,
    9.315974e-01, 9.316090e-01, 9.316205e-01, 9.316321e-01, 9.316436e-01, 9.316551e-01,
    9.316667e-01, 9.316782e-01, 9.316898e-01, 9.317013e-01, 9.317128e-01, 9.317244e-01,
    9.317359e-01, 9.317475e-01, 9.317590e-01, 9.317705e-01, 9.317821e-01, 9.317936e-01,
    9.318052e-01, 9.318167e-01, 9.318282e-01, 9.318398e-01, 9.318513e-01, 9.318629e-01,
    9.318744e-01, 9.318859e-01, 9.318975e-01, 9.319090e-01, 9.319206e-01, 9.319321e-01,
    9.319437e-01, 9.319552e-01, 9.319667e-01, 9.319782e-01, 9.319898e-01, 9.320014e-01,
    9.320129e-01, 9.320244e-01, 9.320359e-01, 9.320474e-01, 9.320590e-01, 9.320706e-01,
    9.320821e-01, 9.320936e-01, 9.321051e-01, 9.321167e-01, 9.321283e-01, 9.321398e-01,
    9.321513e-01, 9.321628e-01, 9.321743e-01, 9.321859e-01, 9.321975e-01, 9.322090e-01,
    9.322205e-01, 9.322320e-01, 9.322436e-01, 9.322551e-01, 9.322667e-01, 9.322782e-01,
    9.322897e-01, 9.323013e-01, 9.323128e-01, 9.323243e-01, 9.323359e-01, 9.323474e-01,
    9.323590e-01, 9.323705e-01, 9.323820e-01, 9.323936e-01, 9.324051e-01, 9.324166e-01,
    9.324282e-01, 9.324397e-01, 9.324512e-01, 9.324628e-01, 9.324743e-01, 9.324858e-01,
    9.324973e-01, 9.325089e-01, 9.325204e-01, 9.325320e-01, 9.325435e-01, 9.325550e-01,
    9.325665e-01, 9.325781e-01, 9.325896e-01, 9.326012e-01, 9.326127e-01, 9.326242e-01,
    9.326358e-01, 9.326473e-01, 9.326588e-01, 9.326704e-01, 9.326819e-01, 9.326935e-01,
    9.327050e-01, 9.327165e-01, 9.327281e-01, 9.327396e-01, 9.327511e-01, 9.327626e-01,
    9.327741e-01, 9.327856e-01, 9.327972e-01, 9.328088e-01, 9.328203e-01, 9.328318e-01,
    9.328433e-01, 9.328549e-01, 9.328664e-01, 9.328779e-01, 9.328895e-01, 9.329010e-01,
    9.329125e-01, 9.329241e-01, 9.329356e-01, 9.329472e-01, 9.329587e-01, 9.329702e-01,
    9.329817e-01, 9.329932e-01, 9.330047e-01, 9.330163e-01, 9.330278e-01, 9.330393e-01,
    9.330509e-01, 9.330624e-01, 9.330740e-01, 9.330855e-01, 9.330970e-01, 9.331086e-01,
    9.331201e-01, 9.331316e-01, 9.331431e-01, 9.331546e-01, 9.331661e-01, 9.331777e-01,
    9.331892e-01, 9.332007e-01, 9.332123e-01, 9.332238e-01, 9.332354e-01, 9.332469e-01,
    9.332584e-01, 9.332700e-01, 9.332815e-01, 9.332930e-01, 9.333045e-01, 9.333161e-01,
    9.333276e-01, 9.333391e-01, 9.333506e-01, 9.333621e-01, 9.333737e-01, 9.333852e-01,
    9.333967e-01, 9.334083e-01, 9.334198e-01, 9.334314e-01, 9.334429e-01, 9.334544e-01,
    9.334660e-01, 9.334775e-01, 9.334890e-01, 9.335005e-01, 9.335120e-01, 9.335235e-01,
    9.335350e-01, 9.335466e-01, 9.335581e-01, 9.335696e-01, 9.335812e-01, 9.335927e-01,
    9.336042e-01, 9.336157e-01, 9.336272e-01, 9.336388e-01, 9.336503e-01, 9.336618e-01,
    9.336733e-01, 9.336849e-01, 9.336964e-01, 9.337079e-01, 9.337195e-01, 9.337310e-01,
    9.337425e-01, 9.337540e-01, 9.337655e-01, 9.337770e-01, 9.337886e-01, 9.338001e-01,
    9.338116e-01, 9.338232e-01, 9.338347e-01, 9.338462e-01, 9.338577e-01, 9.338692e-01,
    9.338807e-01, 9.338923e-01, 9.339038e-01, 9.339153e-01, 9.339268e-01, 9.339384e-01,
    9.339499e-01, 9.339614e-01, 9.339730e-01, 9.339845e-01, 9.339960e-01, 9.340075e-01,
    9.340190e-01, 9.340305e-01, 9.340421e-01, 9.340536e-01, 9.340651e-01, 9.340767e-01,
    9.340882e-01, 9.340997e-01, 9.341112e-01, 9.341227e-01, 9.341342e-01, 9.341458e-01,
    9.341573e-01, 9.341688e-01, 9.341803e-01, 9.341919e-01, 9.342034e-01, 9.342149e-01,
    9.342265e-01, 9.342380e-01, 9.342495e-01, 9.342610e-01, 9.342725e-01, 9.342840e-01,
    9.342956e-01, 9.343071e-01, 9.343186e-01, 9.343302e-01, 9.343417e-01, 9.343532e-01,
    9.343647e-01, 9.343762e-01, 9.343877e-01, 9.343993e-01, 9.344107e-01, 9.344223e-01,
    9.344338e-01, 9.344453e-01, 9.344568e-01, 9.344683e-01, 9.344798e-01, 9.344914e-01,
    9.345029e-01, 9.345144e-01, 9.345260e-01, 9.345375e-01, 9.345490e-01, 9.345605e-01,
    9.345720e-01, 9.345835e-01, 9.345951e-01, 9.346066e-01, 9.346181e-01, 9.346296e-01,
    9.346411e-01, 9.346526e-01, 9.346641e-01, 9.346756e-01, 9.346872e-01, 9.346987e-01,
    9.347102e-01, 9.347218e-01, 9.347333e-01, 9.347448e-01, 9.347563e-01, 9.347678e-01,
    9.347793e-01, 9.347908e-01, 9.348023e-01, 9.348139e-01, 9.348254e-01, 9.348369e-01,
    9.348484e-01, 9.348599e-01, 9.348714e-01, 9.348830e-01, 9.348945e-01, 9.349059e-01,
    9.349174e-01, 9.349290e-01, 9.349405e-01, 9.349520e-01, 9.349636e-01, 9.349751e-01,
    9.349866e-01, 9.349982e-01, 9.350097e-01, 9.350212e-01, 9.350326e-01, 9.350441e-01,
    9.350557e-01, 9.350672e-01, 9.350787e-01, 9.350902e-01, 9.351017e-01, 9.351133e-01,
    9.351248e-01, 9.351362e-01, 9.351478e-01, 9.351593e-01, 9.351708e-01, 9.351823e-01,
    9.351938e-01, 9.352053e-01, 9.352169e-01, 9.352283e-01, 9.352399e-01, 9.352514e-01,
    9.352629e-01, 9.352744e-01, 9.352859e-01, 9.352975e-01, 9.353090e-01, 9.353204e-01,
    9.353319e-01, 9.353434e-01, 9.353550e-01, 9.353665e-01, 9.353780e-01, 9.353896e-01,
    9.354011e-01, 9.354125e-01, 9.354240e-01, 9.354355e-01, 9.354471e-01, 9.354586e-01,
    9.354701e-01, 9.354817e-01, 9.354931e-01, 9.355046e-01, 9.355161e-01, 9.355277e-01,
    9.355392e-01, 9.355507e-01, 9.355621e-01, 9.355736e-01, 9.355852e-01, 9.355967e-01,
    9.356082e-01, 9.356198e-01, 9.356313e-01, 9.356427e-01, 9.356542e-01, 9.356658e-01,
    9.356773e-01, 9.356888e-01, 9.357004e-01, 9.357117e-01, 9.357233e-01, 9.357348e-01,
    9.357463e-01, 9.357579e-01, 9.357694e-01, 9.357808e-01, 9.357923e-01, 9.358039e-01,
    9.358154e-01, 9.358269e-01, 9.358385e-01, 9.358498e-01, 9.358614e-01, 9.358729e-01,
    9.358844e-01, 9.358960e-01, 9.359074e-01, 9.359189e-01, 9.359304e-01, 9.359420e-01,
    9.359535e-01, 9.359649e-01, 9.359764e-01, 9.359879e-01, 9.359995e-01, 9.360110e-01,
    9.360225e-01, 9.360340e-01, 9.360455e-01, 9.360570e-01, 9.360685e-01, 9.360800e-01,
    9.360915e-01, 9.361030e-01, 9.361145e-01, 9.361261e-01, 9.361375e-01, 9.361491e-01,
    9.361606e-01, 9.361721e-01, 9.361836e-01, 9.361950e-01, 9.362066e-01, 9.362181e-01,
    9.362296e-01, 9.362411e-01, 9.362526e-01, 9.362641e-01, 9.362756e-01, 9.362872e-01,
    9.362985e-01, 9.363101e-01, 9.363216e-01, 9.363331e-01, 9.363447e-01, 9.363561e-01,
    9.363676e-01, 9.363791e-01, 9.363907e-01, 9.364021e-01, 9.364136e-01, 9.364251e-01,
    9.364367e-01, 9.364482e-01, 9.364597e-01, 9.364712e-01, 9.364827e-01, 9.364942e-01,
    9.365056e-01, 9.365172e-01, 9.365287e-01, 9.365402e-01, 9.365516e-01, 9.365632e-01,
    9.365747e-01, 9.365862e-01, 9.365976e-01, 9.366091e-01, 9.366207e-01, 9.366322e-01,
    9.366437e-01, 9.366552e-01, 9.366667e-01, 9.366782e-01, 9.366897e-01, 9.367012e-01,
    9.367127e-01, 9.367242e-01, 9.367357e-01, 9.367472e-01, 9.367587e-01, 9.367703e-01,
    9.367816e-01, 9.367932e-01, 9.368047e-01, 9.368162e-01, 9.368277e-01, 9.368392e-01,
    9.368507e-01, 9.368622e-01, 9.368737e-01, 9.368852e-01, 9.368967e-01, 9.369082e-01,
    9.369197e-01, 9.369312e-01, 9.369426e-01, 9.369541e-01, 9.369657e-01, 9.369772e-01,
    9.369887e-01, 9.370002e-01, 9.370117e-01, 9.370232e-01, 9.370347e-01, 9.370462e-01,
    9.370577e-01, 9.370691e-01, 9.370807e-01, 9.370922e-01, 9.371036e-01, 9.371151e-01,
    9.371267e-01, 9.371381e-01, 9.371496e-01, 9.371611e-01, 9.371727e-01, 9.371841e-01,
    9.371957e-01, 9.372072e-01, 9.372186e-01, 9.372301e-01, 9.372416e-01, 9.372531e-01,
    9.372646e-01, 9.372761e-01, 9.372876e-01, 9.372991e-01, 9.373106e-01, 9.373221e-01,
    9.373336e-01, 9.373451e-01, 9.373566e-01, 9.373680e-01, 9.373796e-01, 9.373911e-01,
    9.374025e-01, 9.374141e-01, 9.374256e-01, 9.374370e-01, 9.374486e-01, 9.374601e-01,
    9.374715e-01, 9.374830e-01, 9.374945e-01, 9.375060e-01, 9.375175e-01, 9.375290e-01,
    9.375405e-01, 9.375520e-01, 9.375635e-01, 9.375749e-01, 9.375865e-01, 9.375980e-01,
    9.376094e-01, 9.376209e-01, 9.376324e-01, 9.376439e-01, 9.376554e-01, 9.376670e-01,
    9.376784e-01, 9.376899e-01, 9.377015e-01, 9.377128e-01, 9.377244e-01, 9.377359e-01,
    9.377474e-01, 9.377589e-01, 9.377703e-01, 9.377818e-01, 9.377934e-01, 9.378048e-01,
    9.378163e-01, 9.378278e-01, 9.378393e-01, 9.378508e-01, 9.378622e-01, 9.378738e-01,
    9.378853e-01, 9.378967e-01, 9.379082e-01, 9.379198e-01, 9.379312e-01, 9.379427e-01,
    9.379542e-01, 9.379657e-01, 9.379772e-01, 9.379886e-01, 9.380001e-01, 9.380117e-01,
    9.380231e-01, 9.380347e-01, 9.380461e-01, 9.380576e-01, 9.380691e-01, 9.380805e-01,
    9.380921e-01, 9.381036e-01, 9.381151e-01, 9.381266e-01, 9.381380e-01, 9.381495e-01,
    9.381611e-01, 9.381725e-01, 9.381840e-01, 9.381955e-01, 9.382070e-01, 9.382185e-01,
    9.382299e-01, 9.382415e-01, 9.382529e-01, 9.382644e-01, 9.382759e-01, 9.382874e-01,
    9.382989e-01, 9.383103e-01, 9.383219e-01, 9.383334e-01, 9.383448e-01, 9.383563e-01,
    9.383678e-01, 9.383793e-01, 9.383909e-01, 9.384022e-01, 9.384138e-01, 9.384252e-01,
    9.384367e-01, 9.384482e-01, 9.384597e-01, 9.384713e-01, 9.384826e-01, 9.384942e-01,
    9.385056e-01, 9.385172e-01, 9.385286e-01, 9.385401e-01, 9.385516e-01, 9.385630e-01,
    9.385746e-01, 9.385861e-01, 9.385976e-01, 9.386090e-01, 9.386205e-01, 9.386320e-01,
    9.386435e-01, 9.386550e-01, 9.386664e-01, 9.386780e-01, 9.386894e-01, 9.387009e-01,
    9.387124e-01, 9.387239e-01, 9.387354e-01, 9.387468e-01, 9.387584e-01, 9.387698e-01,
    9.387813e-01, 9.387928e-01, 9.388043e-01, 9.388157e-01, 9.388272e-01, 9.388388e-01,
    9.388502e-01, 9.388617e-01, 9.388732e-01, 9.388847e-01, 9.388961e-01, 9.389076e-01,
    9.389191e-01, 9.389306e-01, 9.389420e-01, 9.389536e-01, 9.389650e-01, 9.389765e-01,
    9.389880e-01, 9.389995e-01, 9.390110e-01, 9.390224e-01, 9.390340e-01, 9.390454e-01,
    9.390569e-01, 9.390684e-01, 9.390799e-01, 9.390913e-01, 9.391028e-01, 9.391143e-01,
    9.391258e-01, 9.391372e-01, 9.391488e-01, 9.391602e-01, 9.391717e-01, 9.391832e-01,
    9.391947e-01, 9.392061e-01, 9.392176e-01, 9.392291e-01, 9.392406e-01, 9.392520e-01,
    9.392636e-01, 9.392750e-01, 9.392865e-01, 9.392980e-01, 9.393095e-01, 9.393209e-01,
    9.393324e-01, 9.393439e-01, 9.393554e-01, 9.393668e-01, 9.393784e-01, 9.393898e-01,
    9.394013e-01, 9.394128e-01, 9.394243e-01, 9.394357e-01, 9.394472e-01, 9.394587e-01,
    9.394702e-01, 9.394816e-01, 9.394932e-01, 9.395046e-01, 9.395161e-01, 9.395276e-01,
    9.395391e-01, 9.395505e-01, 9.395620e-01, 9.395735e-01, 9.395850e-01, 9.395964e-01,
    9.396080e-01, 9.396194e-01, 9.396308e-01, 9.396424e-01, 9.396538e-01, 9.396653e-01,
    9.396768e-01, 9.396883e-01, 9.396997e-01, 9.397112e-01, 9.397227e-01, 9.397342e-01,
    9.397456e-01, 9.397572e-01, 9.397686e-01, 9.397800e-01, 9.397916e-01, 9.398030e-01,
    9.398145e-01, 9.398260e-01, 9.398375e-01, 9.398489e-01, 9.398604e-01, 9.398718e-01,
    9.398834e-01, 9.398948e-01, 9.399062e-01, 9.399178e-01, 9.399292e-01, 9.399408e-01,
    9.399522e-01, 9.399637e-01, 9.399751e-01, 9.399866e-01, 9.399981e-01, 9.400095e-01,
    9.400210e-01, 9.400325e-01, 9.400440e-01, 9.400554e-01, 9.400670e-01, 9.400784e-01,
    9.400898e-01, 9.401014e-01, 9.401128e-01, 9.401243e-01, 9.401358e-01, 9.401473e-01,
    9.401587e-01, 9.401702e-01, 9.401817e-01, 9.401931e-01, 9.402046e-01, 9.402161e-01,
    9.402275e-01, 9.402390e-01, 9.402505e-01, 9.402620e-01, 9.402735e-01, 9.402848e-01,
    9.402964e-01, 9.403079e-01, 9.403194e-01, 9.403308e-01, 9.403423e-01, 9.403538e-01,
    9.403652e-01, 9.403767e-01, 9.403881e-01, 9.403996e-01, 9.404111e-01, 9.404225e-01,
    9.404340e-01, 9.404455e-01, 9.404570e-01, 9.404685e-01, 9.404799e-01, 9.404914e-01,
    9.405029e-01, 9.405143e-01, 9.405258e-01, 9.405373e-01, 9.405488e-01, 9.405602e-01,
    9.405717e-01, 9.405832e-01, 9.405946e-01, 9.406061e-01, 9.406176e-01, 9.406290e-01,
    9.406405e-01, 9.406520e-01, 9.406634e-01, 9.406749e-01, 9.406863e-01, 9.406979e-01,
    9.407094e-01, 9.407207e-01, 9.407323e-01, 9.407437e-01, 9.407551e-01, 9.407667e-01,
    9.407781e-01, 9.407896e-01, 9.408011e-01, 9.408125e-01, 9.408240e-01, 9.408355e-01,
    9.408469e-01, 9.408584e-01, 9.408699e-01, 9.408813e-01, 9.408928e-01, 9.409043e-01,
    9.409157e-01, 9.409272e-01, 9.409387e-01, 9.409501e-01, 9.409616e-01, 9.409730e-01,
    9.409845e-01, 9.409960e-01, 9.410074e-01, 9.410190e-01, 9.410304e-01, 9.410418e-01,
    9.410534e-01, 9.410648e-01, 9.410763e-01, 9.410878e-01, 9.410992e-01, 9.411107e-01,
    9.411222e-01, 9.411336e-01, 9.411451e-01, 9.411566e-01, 9.411680e-01, 9.411795e-01,
    9.411910e-01, 9.412024e-01, 9.412138e-01, 9.412253e-01, 9.412368e-01, 9.412482e-01,
    9.412597e-01, 9.412712e-01, 9.412826e-01, 9.412941e-01, 9.413056e-01, 9.413170e-01,
    9.413285e-01, 9.413400e-01, 9.413514e-01, 9.413629e-01, 9.413744e-01, 9.413858e-01,
    9.413972e-01, 9.414088e-01, 9.414202e-01, 9.414316e-01, 9.414431e-01, 9.414546e-01,
    9.414660e-01, 9.414775e-01, 9.414890e-01, 9.415004e-01, 9.415119e-01, 9.415234e-01,
    9.415348e-01, 9.415463e-01, 9.415577e-01, 9.415692e-01, 9.415807e-01, 9.415921e-01,
    9.416037e-01, 9.416150e-01, 9.416265e-01, 9.416379e-01, 9.416495e-01, 9.416609e-01,
    9.416723e-01, 9.416839e-01, 9.416953e-01, 9.417067e-01, 9.417182e-01, 9.417297e-01,
    9.417411e-01, 9.417526e-01, 9.417640e-01, 9.417756e-01, 9.417869e-01, 9.417984e-01,
    9.418100e-01, 9.418213e-01, 9.418328e-01, 9.418442e-01, 9.418558e-01, 9.418672e-01,
    9.418786e-01, 9.418901e-01, 9.419016e-01, 9.419130e-01, 9.419245e-01, 9.419359e-01,
    9.419474e-01, 9.419588e-01, 9.419703e-01, 9.419817e-01, 9.419932e-01, 9.420047e-01,
    9.420161e-01, 9.420276e-01, 9.420391e-01, 9.420505e-01, 9.420620e-01, 9.420734e-01,
    9.420849e-01, 9.420964e-01, 9.421078e-01, 9.421192e-01, 9.421307e-01, 9.421422e-01,
    9.421536e-01, 9.421651e-01, 9.421766e-01, 9.421880e-01, 9.421995e-01, 9.422109e-01,
    9.422224e-01, 9.422339e-01, 9.422453e-01, 9.422567e-01, 9.422682e-01, 9.422797e-01,
    9.422911e-01, 9.423026e-01, 9.423140e-01, 9.423255e-01, 9.423370e-01, 9.423484e-01,
    9.423599e-01, 9.423713e-01, 9.423828e-01, 9.423943e-01, 9.424057e-01, 9.424171e-01,
    9.424285e-01, 9.424401e-01, 9.424515e-01, 9.424629e-01, 9.424744e-01, 9.424859e-01,
    9.424974e-01, 9.425088e-01, 9.425202e-01, 9.425316e-01, 9.425431e-01, 9.425546e-01,
    9.425660e-01, 9.425775e-01, 9.425889e-01, 9.426004e-01, 9.426119e-01, 9.426233e-01,
    9.426348e-01, 9.426462e-01, 9.426577e-01, 9.426692e-01, 9.426806e-01, 9.426920e-01,
    9.427035e-01, 9.427149e-01, 9.427264e-01, 9.427379e-01, 9.427493e-01, 9.427607e-01,
    9.427722e-01, 9.427837e-01, 9.427952e-01, 9.428065e-01, 9.428180e-01, 9.428294e-01,
    9.428409e-01, 9.428524e-01, 9.428638e-01, 9.428753e-01, 9.428867e-01, 9.428982e-01,
    9.429096e-01, 9.429211e-01, 9.429325e-01, 9.429440e-01, 9.429554e-01, 9.429669e-01,
    9.429783e-01, 9.429898e-01, 9.430013e-01, 9.430127e-01, 9.430241e-01, 9.430355e-01,
    9.430470e-01, 9.430586e-01, 9.430699e-01, 9.430814e-01, 9.430928e-01, 9.431043e-01,
    9.431157e-01, 9.431272e-01, 9.431387e-01, 9.431501e-01, 9.431615e-01, 9.431730e-01,
    9.431844e-01, 9.431959e-01, 9.432073e-01, 9.432188e-01, 9.432303e-01, 9.432417e-01,
    9.432531e-01, 9.432645e-01, 9.432760e-01, 9.432874e-01, 9.432989e-01, 9.433104e-01,
    9.433218e-01, 9.433333e-01, 9.433447e-01, 9.433562e-01, 9.433676e-01, 9.433790e-01,
    9.433905e-01, 9.434020e-01, 9.434134e-01, 9.434248e-01, 9.434363e-01, 9.434477e-01,
    9.434592e-01, 9.434706e-01, 9.434820e-01, 9.434935e-01, 9.435050e-01, 9.435164e-01,
    9.435279e-01, 9.435393e-01, 9.435508e-01, 9.435622e-01, 9.435736e-01, 9.435850e-01,
    9.435965e-01, 9.436080e-01, 9.436194e-01, 9.436309e-01, 9.436423e-01, 9.436538e-01,
    9.436652e-01, 9.436767e-01, 9.436880e-01, 9.436995e-01, 9.437110e-01, 9.437225e-01,
    9.437339e-01, 9.437453e-01, 9.437568e-01, 9.437682e-01, 9.437796e-01, 9.437911e-01,
    9.438025e-01, 9.438140e-01, 9.438254e-01, 9.438368e-01, 9.438484e-01, 9.438598e-01,
    9.438712e-01, 9.438826e-01, 9.438941e-01, 9.439055e-01, 9.439170e-01, 9.439284e-01,
    9.439399e-01, 9.439513e-01, 9.439627e-01, 9.439741e-01, 9.439856e-01, 9.439971e-01,
    9.440085e-01, 9.440200e-01, 9.440314e-01, 9.440429e-01, 9.440543e-01, 9.440657e-01,
    9.440772e-01, 9.440886e-01, 9.441000e-01, 9.441115e-01, 9.441229e-01, 9.441344e-01,
    9.441458e-01, 9.441572e-01, 9.441687e-01, 9.441801e-01, 9.441915e-01, 9.442031e-01,
    9.442145e-01, 9.442260e-01, 9.442374e-01, 9.442488e-01, 9.442602e-01, 9.442717e-01,
    9.442831e-01, 9.442946e-01, 9.443060e-01, 9.443175e-01, 9.443288e-01, 9.443403e-01,
    9.443517e-01, 9.443632e-01, 9.443746e-01, 9.443861e-01, 9.443975e-01, 9.444090e-01,
    9.444203e-01, 9.444318e-01, 9.444432e-01, 9.444547e-01, 9.444661e-01, 9.444776e-01,
    9.444890e-01, 9.445004e-01, 9.445119e-01, 9.445233e-01, 9.445347e-01, 9.445462e-01,
    9.445577e-01, 9.445691e-01, 9.445806e-01, 9.445920e-01, 9.446034e-01, 9.446149e-01,
    9.446263e-01, 9.446378e-01, 9.446492e-01, 9.446606e-01, 9.446720e-01, 9.446835e-01,
    9.446949e-01, 9.447064e-01, 9.447178e-01, 9.447293e-01, 9.447407e-01, 9.447521e-01,
    9.447635e-01, 9.447750e-01, 9.447864e-01, 9.447979e-01, 9.448093e-01, 9.448208e-01,
    9.448322e-01, 9.448436e-01, 9.448550e-01, 9.448665e-01, 9.448779e-01, 9.448893e-01,
    9.449007e-01, 9.449121e-01, 9.449236e-01, 9.449350e-01, 9.449465e-01, 9.449579e-01,
    9.449694e-01, 9.449808e-01, 9.449922e-01, 9.450036e-01, 9.450151e-01, 9.450265e-01,
    9.450380e-01, 9.450494e-01, 9.450608e-01, 9.450723e-01, 9.450837e-01, 9.450951e-01,
    9.451066e-01, 9.451180e-01, 9.451295e-01, 9.451409e-01, 9.451523e-01, 9.451638e-01,
    9.451752e-01, 9.451866e-01, 9.451981e-01, 9.452095e-01, 9.452209e-01, 9.452324e-01,
    9.452437e-01, 9.452552e-01, 9.452666e-01, 9.452780e-01, 9.452895e-01, 9.453009e-01,
    9.453124e-01, 9.453238e-01, 9.453352e-01, 9.453467e-01, 9.453581e-01, 9.453695e-01,
    9.453810e-01, 9.453924e-01, 9.454039e-01, 9.454153e-01, 9.454267e-01, 9.454381e-01,
    9.454495e-01, 9.454610e-01, 9.454724e-01, 9.454838e-01, 9.454952e-01, 9.455067e-01,
    9.455181e-01, 9.455296e-01, 9.455410e-01, 9.455525e-01, 9.455639e-01, 9.455753e-01,
    9.455867e-01, 9.455981e-01, 9.456096e-01, 9.456210e-01, 9.456324e-01, 9.456438e-01,
    9.456553e-01, 9.456667e-01, 9.456782e-01, 9.456896e-01, 9.457011e-01, 9.457124e-01,
    9.457239e-01, 9.457353e-01, 9.457467e-01, 9.457581e-01, 9.457695e-01, 9.457810e-01,
    9.457924e-01, 9.458039e-01, 9.458153e-01, 9.458268e-01, 9.458382e-01, 9.458495e-01,
    9.458610e-01, 9.458724e-01, 9.458839e-01, 9.458953e-01, 9.459067e-01, 9.459181e-01,
    9.459296e-01, 9.459410e-01, 9.459524e-01, 9.459638e-01, 9.459752e-01, 9.459867e-01,
    9.459981e-01, 9.460096e-01, 9.460210e-01, 9.460325e-01, 9.460439e-01, 9.460552e-01,
    9.460667e-01, 9.460781e-01, 9.460896e-01, 9.461010e-01, 9.461124e-01, 9.461238e-01,
    9.461353e-01, 9.461467e-01, 9.461581e-01, 9.461695e-01, 9.461809e-01, 9.461924e-01,
    9.462038e-01, 9.462153e-01, 9.462266e-01, 9.462380e-01, 9.462495e-01, 9.462609e-01,
    9.462724e-01, 9.462838e-01, 9.462953e-01, 9.463066e-01, 9.463180e-01, 9.463295e-01,
    9.463409e-01, 9.463524e-01, 9.463637e-01, 9.463752e-01, 9.463866e-01, 9.463980e-01,
    9.464094e-01, 9.464208e-01, 9.464323e-01, 9.464437e-01, 9.464551e-01, 9.464665e-01,
    9.464779e-01, 9.464894e-01, 9.465008e-01, 9.465123e-01, 9.465236e-01, 9.465351e-01,
    9.465465e-01, 9.465579e-01, 9.465694e-01, 9.465808e-01, 9.465922e-01, 9.466036e-01,
    9.466150e-01, 9.466265e-01, 9.466379e-01, 9.466494e-01, 9.466607e-01, 9.466721e-01,
    9.466836e-01, 9.466950e-01, 9.467065e-01, 9.467178e-01, 9.467292e-01, 9.467407e-01,
    9.467521e-01, 9.467635e-01, 9.467750e-01, 9.467863e-01, 9.467978e-01, 9.468092e-01,
    9.468206e-01, 9.468321e-01, 9.468434e-01, 9.468549e-01, 9.468663e-01, 9.468777e-01,
    9.468892e-01, 9.469005e-01, 9.469120e-01, 9.469234e-01, 9.469348e-01, 9.469463e-01,
    9.469576e-01, 9.469691e-01, 9.469805e-01, 9.469919e-01, 9.470034e-01, 9.470147e-01,
    9.470261e-01, 9.470376e-01, 9.470490e-01, 9.470604e-01, 9.470719e-01, 9.470832e-01,
    9.470947e-01, 9.471061e-01, 9.471175e-01, 9.471289e-01, 9.471403e-01, 9.471518e-01,
    9.471632e-01, 9.471746e-01, 9.471860e-01, 9.471974e-01, 9.472089e-01, 9.472203e-01,
    9.472317e-01, 9.472431e-01, 9.472545e-01, 9.472659e-01, 9.472774e-01, 9.472888e-01,
    9.473002e-01, 9.473116e-01, 9.473230e-01, 9.473345e-01, 9.473459e-01, 9.473573e-01,
    9.473687e-01, 9.473801e-01, 9.473915e-01, 9.474030e-01, 9.474143e-01, 9.474258e-01,
    9.474372e-01, 9.474486e-01, 9.474600e-01, 9.474714e-01, 9.474829e-01, 9.474943e-01,
    9.475057e-01, 9.475171e-01, 9.475285e-01, 9.475399e-01, 9.475513e-01, 9.475628e-01,
    9.475742e-01, 9.475855e-01, 9.475970e-01, 9.476084e-01, 9.476199e-01, 9.476312e-01,
    9.476426e-01, 9.476541e-01, 9.476655e-01, 9.476768e-01, 9.476883e-01, 9.476997e-01,
    9.477111e-01, 9.477225e-01, 9.477339e-01, 9.477454e-01, 9.477568e-01, 9.477682e-01,
    9.477796e-01, 9.477910e-01, 9.478024e-01, 9.478139e-01, 9.478253e-01, 9.478366e-01,
    9.478481e-01, 9.478595e-01, 9.478709e-01, 9.478823e-01, 9.478937e-01, 9.479052e-01,
    9.479165e-01, 9.479280e-01, 9.479394e-01, 9.479507e-01, 9.479622e-01, 9.479736e-01,
    9.479851e-01, 9.479964e-01, 9.480078e-01, 9.480193e-01, 9.480307e-01, 9.480420e-01,
    9.480535e-01, 9.480649e-01, 9.480763e-01, 9.480878e-01, 9.480991e-01, 9.481105e-01,
    9.481220e-01, 9.481334e-01, 9.481447e-01, 9.481562e-01, 9.481676e-01, 9.481789e-01,
    9.481904e-01, 9.482018e-01, 9.482132e-01, 9.482246e-01, 9.482360e-01, 9.482474e-01,
    9.482589e-01, 9.482703e-01, 9.482816e-01, 9.482931e-01, 9.483045e-01, 9.483159e-01,
    9.483273e-01, 9.483387e-01, 9.483501e-01, 9.483615e-01, 9.483730e-01, 9.483843e-01,
    9.483957e-01, 9.484072e-01, 9.484186e-01, 9.484299e-01, 9.484414e-01, 9.484528e-01,
    9.484642e-01, 9.484757e-01, 9.484870e-01, 9.484984e-01, 9.485099e-01, 9.485212e-01,
    9.485326e-01, 9.485441e-01, 9.485554e-01, 9.485669e-01, 9.485782e-01, 9.485897e-01,
    9.486011e-01, 9.486125e-01, 9.486239e-01, 9.486353e-01, 9.486467e-01, 9.486581e-01,
    9.486696e-01, 9.486809e-01, 9.486923e-01, 9.487038e-01, 9.487151e-01, 9.487265e-01,
    9.487379e-01, 9.487494e-01, 9.487608e-01, 9.487721e-01, 9.487836e-01, 9.487950e-01,
    9.488063e-01, 9.488178e-01, 9.488291e-01, 9.488406e-01, 9.488520e-01, 9.488634e-01,
    9.488748e-01, 9.488862e-01, 9.488976e-01, 9.489090e-01, 9.489204e-01, 9.489318e-01,
    9.489433e-01, 9.489546e-01, 9.489660e-01, 9.489774e-01, 9.489889e-01, 9.490002e-01,
    9.490116e-01, 9.490231e-01, 9.490344e-01, 9.490458e-01, 9.490573e-01, 9.490686e-01,
    9.490800e-01, 9.490914e-01, 9.491029e-01, 9.491143e-01, 9.491256e-01, 9.491371e-01,
    9.491484e-01, 9.491599e-01, 9.491713e-01, 9.491826e-01, 9.491941e-01, 9.492055e-01,
    9.492169e-01, 9.492283e-01, 9.492397e-01, 9.492511e-01, 9.492624e-01, 9.492739e-01,
    9.492853e-01, 9.492967e-01, 9.493081e-01, 9.493195e-01, 9.493309e-01, 9.493423e-01,
    9.493537e-01, 9.493650e-01, 9.493765e-01, 9.493879e-01, 9.493993e-01, 9.494107e-01,
    9.494221e-01, 9.494335e-01, 9.494448e-01, 9.494563e-01, 9.494677e-01, 9.494790e-01,
    9.494905e-01, 9.495019e-01, 9.495133e-01, 9.495246e-01, 9.495361e-01, 9.495474e-01,
    9.495589e-01, 9.495703e-01, 9.495816e-01, 9.495931e-01, 9.496045e-01, 9.496159e-01,
    9.496272e-01, 9.496387e-01, 9.496500e-01, 9.496614e-01, 9.496729e-01, 9.496843e-01,
    9.496957e-01, 9.497070e-01, 9.497185e-01, 9.497298e-01, 9.497412e-01, 9.497526e-01,
    9.497640e-01, 9.497754e-01, 9.497868e-01, 9.497982e-01, 9.498096e-01, 9.498211e-01,
    9.498324e-01, 9.498438e-01, 9.498552e-01, 9.498667e-01, 9.498780e-01, 9.498894e-01,
    9.499007e-01, 9.499122e-01, 9.499236e-01, 9.499350e-01, 9.499463e-01, 9.499578e-01,
    9.499691e-01, 9.499806e-01, 9.499919e-01, 9.500033e-01, 9.500147e-01, 9.500262e-01,
    9.500375e-01, 9.500489e-01, 9.500603e-01, 9.500717e-01, 9.500831e-01, 9.500945e-01,
    9.501058e-01, 9.501173e-01, 9.501286e-01, 9.501401e-01, 9.501514e-01, 9.501629e-01,
    9.501742e-01, 9.501857e-01, 9.501970e-01, 9.502084e-01, 9.502198e-01, 9.502313e-01,
    9.502426e-01, 9.502540e-01, 9.502653e-01, 9.502768e-01, 9.502882e-01, 9.502996e-01,
    9.503109e-01, 9.503224e-01, 9.503337e-01, 9.503452e-01, 9.503565e-01, 9.503679e-01,
    9.503793e-01, 9.503908e-01, 9.504021e-01, 9.504135e-01, 9.504249e-01, 9.504363e-01,
    9.504477e-01, 9.504591e-01, 9.504704e-01, 9.504819e-01, 9.504932e-01, 9.505046e-01,
    9.505160e-01, 9.505274e-01, 9.505388e-01, 9.505502e-01, 9.505616e-01, 9.505730e-01,
    9.505844e-01, 9.505957e-01, 9.506072e-01, 9.506186e-01, 9.506299e-01, 9.506413e-01,
    9.506527e-01, 9.506641e-01, 9.506755e-01, 9.506869e-01, 9.506983e-01, 9.507097e-01,
    9.507210e-01, 9.507325e-01, 9.507439e-01, 9.507552e-01, 9.507666e-01, 9.507779e-01,
    9.507894e-01, 9.508008e-01, 9.508122e-01, 9.508235e-01, 9.508350e-01, 9.508463e-01,
    9.508577e-01, 9.508691e-01, 9.508805e-01, 9.508919e-01, 9.509032e-01, 9.509147e-01,
    9.509261e-01, 9.509374e-01, 9.509488e-01, 9.509602e-01, 9.509716e-01, 9.509830e-01,
    9.509944e-01, 9.510058e-01, 9.510171e-01, 9.510285e-01, 9.510399e-01, 9.510514e-01,
    9.510627e-01, 9.510741e-01, 9.510854e-01, 9.510968e-01, 9.511083e-01, 9.511196e-01,
    9.511310e-01, 9.511424e-01, 9.511538e-01, 9.511652e-01, 9.511765e-01, 9.511880e-01,
    9.511993e-01, 9.512107e-01, 9.512221e-01, 9.512334e-01, 9.512449e-01, 9.512563e-01,
    9.512676e-01, 9.512790e-01, 9.512904e-01, 9.513018e-01, 9.513132e-01, 9.513245e-01,
    9.513360e-01, 9.513473e-01, 9.513587e-01, 9.513701e-01, 9.513814e-01, 9.513929e-01,
    9.514042e-01, 9.514157e-01, 9.514270e-01, 9.514384e-01, 9.514498e-01, 9.514611e-01,
    9.514725e-01, 9.514840e-01, 9.514953e-01, 9.515067e-01, 9.515181e-01, 9.515294e-01,
    9.515409e-01, 9.515522e-01, 9.515636e-01, 9.515750e-01, 9.515864e-01, 9.515978e-01,
    9.516091e-01, 9.516205e-01, 9.516320e-01, 9.516433e-01, 9.516547e-01, 9.516661e-01,
    9.516774e-01, 9.516888e-01, 9.517002e-01, 9.517116e-01, 9.517229e-01, 9.517344e-01,
    9.517457e-01, 9.517571e-01, 9.517685e-01, 9.517798e-01, 9.517913e-01, 9.518026e-01,
    9.518140e-01, 9.518254e-01, 9.518368e-01, 9.518481e-01, 9.518595e-01, 9.518709e-01,
    9.518822e-01, 9.518937e-01, 9.519051e-01, 9.519164e-01, 9.519278e-01, 9.519392e-01,
    9.519506e-01, 9.519620e-01, 9.519733e-01, 9.519847e-01, 9.519961e-01, 9.520075e-01,
    9.520188e-01, 9.520302e-01, 9.520416e-01, 9.520530e-01, 9.520644e-01, 9.520757e-01,
    9.520871e-01, 9.520985e-01, 9.521099e-01, 9.521213e-01, 9.521326e-01, 9.521440e-01,
    9.521554e-01, 9.521668e-01, 9.521782e-01, 9.521895e-01, 9.522009e-01, 9.522123e-01,
    9.522237e-01, 9.522350e-01, 9.522464e-01, 9.522578e-01, 9.522691e-01, 9.522806e-01,
    9.522919e-01, 9.523033e-01, 9.523147e-01, 9.523261e-01, 9.523374e-01, 9.523488e-01,
    9.523602e-01, 9.523715e-01, 9.523829e-01, 9.523944e-01, 9.524057e-01, 9.524170e-01,
    9.524285e-01, 9.524398e-01, 9.524512e-01, 9.524626e-01, 9.524740e-01, 9.524853e-01,
    9.524966e-01, 9.525081e-01, 9.525195e-01, 9.525308e-01, 9.525422e-01, 9.525536e-01,
    9.525650e-01, 9.525763e-01, 9.525877e-01, 9.525991e-01, 9.526104e-01, 9.526218e-01,
    9.526332e-01, 9.526446e-01, 9.526559e-01, 9.526673e-01, 9.526787e-01, 9.526901e-01,
    9.527014e-01, 9.527128e-01, 9.527242e-01, 9.527355e-01, 9.527469e-01, 9.527584e-01,
    9.527697e-01, 9.527810e-01, 9.527924e-01, 9.528039e-01, 9.528152e-01, 9.528266e-01,
    9.528379e-01, 9.528493e-01, 9.528607e-01, 9.528720e-01, 9.528834e-01, 9.528948e-01,
    9.529062e-01, 9.529175e-01, 9.529288e-01, 9.529403e-01, 9.529517e-01, 9.529630e-01,
    9.529744e-01, 9.529858e-01, 9.529971e-01, 9.530085e-01, 9.530199e-01, 9.530313e-01,
    9.530426e-01, 9.530540e-01, 9.530653e-01, 9.530767e-01, 9.530881e-01, 9.530995e-01,
    9.531108e-01, 9.531222e-01, 9.531336e-01, 9.531450e-01, 9.531563e-01, 9.531677e-01,
    9.531790e-01, 9.531904e-01, 9.532018e-01, 9.532132e-01, 9.532245e-01, 9.532359e-01,
    9.532473e-01, 9.532586e-01, 9.532700e-01, 9.532813e-01, 9.532928e-01, 9.533041e-01,
    9.533155e-01, 9.533268e-01, 9.533382e-01, 9.533496e-01, 9.533610e-01, 9.533723e-01,
    9.533837e-01, 9.533951e-01, 9.534065e-01, 9.534178e-01, 9.534292e-01, 9.534405e-01,
    9.534519e-01, 9.534633e-01, 9.534746e-01, 9.534860e-01, 9.534974e-01, 9.535087e-01,
    9.535201e-01, 9.535315e-01, 9.535428e-01, 9.535542e-01, 9.535655e-01, 9.535770e-01,
    9.535883e-01, 9.535997e-01, 9.536110e-01, 9.536224e-01, 9.536338e-01, 9.536452e-01,
    9.536565e-01, 9.536679e-01, 9.536792e-01, 9.536906e-01, 9.537020e-01, 9.537134e-01,
    9.537247e-01, 9.537361e-01, 9.537474e-01, 9.537588e-01, 9.537702e-01, 9.537815e-01,
    9.537929e-01, 9.538043e-01, 9.538156e-01, 9.538270e-01, 9.538384e-01, 9.538497e-01,
    9.538611e-01, 9.538724e-01, 9.538838e-01, 9.538952e-01, 9.539066e-01, 9.539179e-01,
    9.539293e-01, 9.539406e-01, 9.539520e-01, 9.539633e-01, 9.539747e-01, 9.539861e-01,
    9.539975e-01, 9.540088e-01, 9.540202e-01, 9.540315e-01, 9.540429e-01, 9.540543e-01,
    9.540657e-01, 9.540770e-01, 9.540884e-01, 9.540997e-01, 9.541111e-01, 9.541224e-01,
    9.541337e-01, 9.541452e-01, 9.541566e-01, 9.541679e-01, 9.541793e-01, 9.541906e-01,
    9.542019e-01, 9.542133e-01, 9.542248e-01, 9.542361e-01, 9.542475e-01, 9.542588e-01,
    9.542702e-01, 9.542815e-01, 9.542928e-01, 9.543042e-01, 9.543155e-01, 9.543270e-01,
    9.543384e-01, 9.543497e-01, 9.543610e-01, 9.543724e-01, 9.543837e-01, 9.543951e-01,
    9.544064e-01, 9.544179e-01, 9.544293e-01, 9.544406e-01, 9.544519e-01, 9.544633e-01,
    9.544746e-01, 9.544860e-01, 9.544973e-01, 9.545087e-01, 9.545200e-01, 9.545315e-01,
    9.545428e-01, 9.545542e-01, 9.545655e-01, 9.545769e-01, 9.545882e-01, 9.545996e-01,
    9.546109e-01, 9.546223e-01, 9.546337e-01, 9.546450e-01, 9.546564e-01, 9.546678e-01,
    9.546791e-01, 9.546905e-01, 9.547018e-01, 9.547132e-01, 9.547246e-01, 9.547359e-01,
    9.547473e-01, 9.547586e-01, 9.547699e-01, 9.547813e-01, 9.547927e-01, 9.548041e-01,
    9.548154e-01, 9.548268e-01, 9.548382e-01, 9.548495e-01, 9.548608e-01, 9.548722e-01,
    9.548835e-01, 9.548949e-01, 9.549062e-01, 9.549176e-01, 9.549289e-01, 9.549403e-01,
    9.549516e-01, 9.549631e-01, 9.549744e-01, 9.549858e-01, 9.549971e-01, 9.550085e-01,
    9.550198e-01, 9.550312e-01, 9.550425e-01, 9.550539e-01, 9.550653e-01, 9.550766e-01,
    9.550880e-01, 9.550993e-01, 9.551106e-01, 9.551220e-01, 9.551333e-01, 9.551447e-01,
    9.551560e-01, 9.551674e-01, 9.551787e-01, 9.551902e-01, 9.552015e-01, 9.552129e-01,
    9.552242e-01, 9.552356e-01, 9.552469e-01, 9.552583e-01, 9.552696e-01, 9.552810e-01,
    9.552923e-01, 9.553037e-01, 9.553151e-01, 9.553264e-01, 9.553378e-01, 9.553491e-01,
    9.553604e-01, 9.553718e-01, 9.553831e-01, 9.553945e-01, 9.554058e-01, 9.554172e-01,
    9.554285e-01, 9.554399e-01, 9.554513e-01, 9.554626e-01, 9.554740e-01, 9.554853e-01,
    9.554967e-01, 9.555080e-01, 9.555194e-01, 9.555307e-01, 9.555420e-01, 9.555534e-01,
    9.555647e-01, 9.555761e-01, 9.555874e-01, 9.555988e-01, 9.556102e-01, 9.556215e-01,
    9.556329e-01, 9.556442e-01, 9.556556e-01, 9.556669e-01, 9.556783e-01, 9.556896e-01,
    9.557010e-01, 9.557123e-01, 9.557236e-01, 9.557350e-01, 9.557464e-01, 9.557577e-01,
    9.557691e-01, 9.557804e-01, 9.557918e-01, 9.558031e-01, 9.558145e-01, 9.558258e-01,
    9.558372e-01, 9.558485e-01, 9.558599e-01, 9.558712e-01, 9.558826e-01, 9.558939e-01,
    9.559053e-01, 9.559166e-01, 9.559280e-01, 9.559394e-01, 9.559507e-01, 9.559621e-01,
    9.559734e-01, 9.559847e-01, 9.559961e-01, 9.560074e-01, 9.560188e-01, 9.560301e-01,
    9.560414e-01, 9.560528e-01, 9.560641e-01, 9.560754e-01, 9.560868e-01, 9.560981e-01,
    9.561095e-01, 9.561208e-01, 9.561322e-01, 9.561436e-01, 9.561549e-01, 9.561663e-01,
    9.561776e-01, 9.561890e-01, 9.562003e-01, 9.562117e-01, 9.562230e-01, 9.562344e-01,
    9.562457e-01, 9.562570e-01, 9.562683e-01, 9.562797e-01, 9.562910e-01, 9.563024e-01,
    9.563137e-01, 9.563251e-01, 9.563364e-01, 9.563478e-01, 9.563591e-01, 9.563705e-01,
    9.563819e-01, 9.563932e-01, 9.564046e-01, 9.564159e-01, 9.564272e-01, 9.564385e-01,
    9.564499e-01, 9.564612e-01, 9.564726e-01, 9.564839e-01, 9.564953e-01, 9.565066e-01,
    9.565180e-01, 9.565293e-01, 9.565406e-01, 9.565520e-01, 9.565634e-01, 9.565746e-01,
    9.565860e-01, 9.565973e-01, 9.566087e-01, 9.566200e-01, 9.566314e-01, 9.566427e-01,
    9.566541e-01, 9.566655e-01, 9.566768e-01, 9.566880e-01, 9.566994e-01, 9.567108e-01,
    9.567221e-01, 9.567335e-01, 9.567448e-01, 9.567562e-01, 9.567675e-01, 9.567789e-01,
    9.567902e-01, 9.568015e-01, 9.568129e-01, 9.568242e-01, 9.568355e-01, 9.568469e-01,
    9.568582e-01, 9.568696e-01, 9.568809e-01, 9.568923e-01, 9.569036e-01, 9.569149e-01,
    9.569263e-01, 9.569376e-01, 9.569489e-01, 9.569603e-01, 9.569716e-01, 9.569830e-01,
    9.569943e-01, 9.570056e-01, 9.570170e-01, 9.570283e-01, 9.570397e-01, 9.570510e-01,
    9.570624e-01, 9.570737e-01, 9.570850e-01, 9.570963e-01, 9.571077e-01, 9.571190e-01,
    9.571304e-01, 9.571418e-01, 9.571531e-01, 9.571643e-01, 9.571757e-01, 9.571871e-01,
    9.571984e-01, 9.572098e-01, 9.572212e-01, 9.572325e-01, 9.572437e-01, 9.572551e-01,
    9.572664e-01, 9.572778e-01, 9.572892e-01, 9.573005e-01, 9.573117e-01, 9.573231e-01,
    9.573345e-01, 9.573458e-01, 9.573572e-01, 9.573685e-01, 9.573799e-01, 9.573911e-01,
    9.574025e-01, 9.574139e-01, 9.574252e-01, 9.574365e-01, 9.574479e-01, 9.574592e-01,
    9.574705e-01, 9.574819e-01, 9.574932e-01, 9.575046e-01, 9.575158e-01, 9.575272e-01,
    9.575385e-01, 9.575499e-01, 9.575612e-01, 9.575726e-01, 9.575838e-01, 9.575952e-01,
    9.576066e-01, 9.576179e-01, 9.576293e-01, 9.576406e-01, 9.576519e-01, 9.576632e-01,
    9.576746e-01, 9.576859e-01, 9.576973e-01, 9.577085e-01, 9.577199e-01, 9.577312e-01,
    9.577426e-01, 9.577539e-01, 9.577652e-01, 9.577765e-01, 9.577879e-01, 9.577993e-01,
    9.578106e-01, 9.578218e-01, 9.578332e-01, 9.578446e-01, 9.578559e-01, 9.578673e-01,
    9.578785e-01, 9.578899e-01, 9.579012e-01, 9.579126e-01, 9.579239e-01, 9.579352e-01,
    9.579465e-01, 9.579579e-01, 9.579692e-01, 9.579805e-01, 9.579918e-01, 9.580032e-01,
    9.580145e-01, 9.580259e-01, 9.580372e-01, 9.580485e-01, 9.580599e-01, 9.580712e-01,
    9.580825e-01, 9.580938e-01, 9.581052e-01, 9.581165e-01, 9.581279e-01, 9.581392e-01,
    9.581505e-01, 9.581619e-01, 9.581732e-01, 9.581845e-01, 9.581958e-01, 9.582072e-01,
    9.582185e-01, 9.582298e-01, 9.582412e-01, 9.582525e-01, 9.582639e-01, 9.582751e-01,
    9.582865e-01, 9.582978e-01, 9.583092e-01, 9.583204e-01, 9.583318e-01, 9.583431e-01,
    9.583545e-01, 9.583657e-01, 9.583771e-01, 9.583884e-01, 9.583998e-01, 9.584111e-01,
    9.584224e-01, 9.584337e-01, 9.584451e-01, 9.584564e-01, 9.584677e-01, 9.584791e-01,
    9.584904e-01, 9.585017e-01, 9.585131e-01, 9.585244e-01, 9.585357e-01, 9.585470e-01,
    9.585584e-01, 9.585697e-01, 9.585811e-01, 9.585924e-01, 9.586037e-01, 9.586151e-01,
    9.586263e-01, 9.586377e-01, 9.586490e-01, 9.586604e-01, 9.586716e-01, 9.586830e-01,
    9.586943e-01, 9.587056e-01, 9.587169e-01, 9.587283e-01, 9.587396e-01, 9.587509e-01,
    9.587622e-01, 9.587736e-01, 9.587849e-01, 9.587962e-01, 9.588076e-01, 9.588189e-01,
    9.588302e-01, 9.588416e-01, 9.588529e-01, 9.588642e-01, 9.588755e-01, 9.588869e-01,
    9.588981e-01, 9.589095e-01, 9.589208e-01, 9.589322e-01, 9.589434e-01, 9.589548e-01,
    9.589661e-01, 9.589774e-01, 9.589888e-01, 9.590001e-01, 9.590114e-01, 9.590227e-01,
    9.590341e-01, 9.590454e-01, 9.590567e-01, 9.590681e-01, 9.590794e-01, 9.590907e-01,
    9.591020e-01, 9.591134e-01, 9.591246e-01, 9.591359e-01, 9.591473e-01, 9.591586e-01,
    9.591699e-01, 9.591813e-01, 9.591926e-01, 9.592039e-01, 9.592153e-01, 9.592265e-01,
    9.592379e-01, 9.592492e-01, 9.592605e-01, 9.592718e-01, 9.592832e-01, 9.592944e-01,
    9.593058e-01, 9.593171e-01, 9.593284e-01, 9.593398e-01, 9.593511e-01, 9.593624e-01,
    9.593738e-01, 9.593851e-01, 9.593964e-01, 9.594077e-01, 9.594191e-01, 9.594303e-01,
    9.594417e-01, 9.594530e-01, 9.594643e-01, 9.594756e-01, 9.594869e-01, 9.594983e-01,
    9.595096e-01, 9.595209e-01, 9.595322e-01, 9.595436e-01, 9.595549e-01, 9.595662e-01,
    9.595776e-01, 9.595888e-01, 9.596002e-01, 9.596114e-01, 9.596228e-01, 9.596341e-01,
    9.596454e-01, 9.596567e-01, 9.596681e-01, 9.596794e-01, 9.596907e-01, 9.597021e-01,
    9.597133e-01, 9.597247e-01, 9.597359e-01, 9.597473e-01, 9.597586e-01, 9.597699e-01,
    9.597812e-01, 9.597925e-01, 9.598039e-01, 9.598152e-01, 9.598265e-01, 9.598379e-01,
    9.598492e-01, 9.598604e-01, 9.598718e-01, 9.598831e-01, 9.598944e-01, 9.599057e-01,
    9.599170e-01, 9.599284e-01, 9.599397e-01, 9.599510e-01, 9.599624e-01, 9.599736e-01,
    9.599850e-01, 9.599962e-01, 9.600076e-01, 9.600189e-01, 9.600302e-01, 9.600415e-01,
    9.600528e-01, 9.600642e-01, 9.600755e-01, 9.600868e-01, 9.600981e-01, 9.601094e-01,
    9.601207e-01, 9.601321e-01, 9.601434e-01, 9.601547e-01, 9.601660e-01, 9.601773e-01,
    9.601886e-01, 9.602000e-01, 9.602113e-01, 9.602225e-01, 9.602339e-01, 9.602452e-01,
    9.602565e-01, 9.602679e-01, 9.602792e-01, 9.602905e-01, 9.603018e-01, 9.603131e-01,
    9.603243e-01, 9.603357e-01, 9.603471e-01, 9.603583e-01, 9.603697e-01, 9.603810e-01,
    9.603923e-01, 9.604036e-01, 9.604149e-01, 9.604262e-01, 9.604375e-01, 9.604489e-01,
    9.604602e-01, 9.604715e-01, 9.604828e-01, 9.604941e-01, 9.605054e-01, 9.605168e-01,
    9.605280e-01, 9.605393e-01, 9.605507e-01, 9.605620e-01, 9.605733e-01, 9.605846e-01,
    9.605960e-01, 9.606072e-01, 9.606186e-01, 9.606298e-01, 9.606411e-01, 9.606524e-01,
    9.606638e-01, 9.606751e-01, 9.606864e-01, 9.606978e-01, 9.607090e-01, 9.607204e-01,
    9.607316e-01, 9.607430e-01, 9.607543e-01, 9.607656e-01, 9.607769e-01, 9.607882e-01,
    9.607995e-01, 9.608108e-01, 9.608221e-01, 9.608334e-01, 9.608447e-01, 9.608561e-01,
    9.608673e-01, 9.608787e-01, 9.608901e-01, 9.609013e-01, 9.609126e-01, 9.609239e-01,
    9.609352e-01, 9.609465e-01, 9.609579e-01, 9.609692e-01, 9.609805e-01, 9.609917e-01,
    9.610031e-01, 9.610144e-01, 9.610257e-01, 9.610370e-01, 9.610484e-01, 9.610596e-01,
    9.610710e-01, 9.610822e-01, 9.610935e-01, 9.611048e-01, 9.611162e-01, 9.611275e-01,
    9.611388e-01, 9.611501e-01, 9.611614e-01, 9.611727e-01, 9.611840e-01, 9.611953e-01,
    9.612067e-01, 9.612179e-01, 9.612293e-01, 9.612405e-01, 9.612519e-01, 9.612631e-01,
    9.612745e-01, 9.612858e-01, 9.612970e-01, 9.613084e-01, 9.613196e-01, 9.613310e-01,
    9.613423e-01, 9.613536e-01, 9.613649e-01, 9.613762e-01, 9.613875e-01, 9.613988e-01,
    9.614101e-01, 9.614214e-01, 9.614327e-01, 9.614441e-01, 9.614553e-01, 9.614667e-01,
    9.614779e-01, 9.614893e-01, 9.615006e-01, 9.615119e-01, 9.615232e-01, 9.615344e-01,
    9.615458e-01, 9.615571e-01, 9.615684e-01, 9.615797e-01, 9.615910e-01, 9.616023e-01,
    9.616137e-01, 9.616249e-01, 9.616362e-01, 9.616475e-01, 9.616588e-01, 9.616702e-01,
    9.616814e-01, 9.616928e-01, 9.617040e-01, 9.617154e-01, 9.617267e-01, 9.617379e-01,
    9.617493e-01, 9.617605e-01, 9.617718e-01, 9.617831e-01, 9.617945e-01, 9.618058e-01,
    9.618170e-01, 9.618284e-01, 9.618396e-01, 9.618510e-01, 9.618623e-01, 9.618736e-01,
    9.618849e-01, 9.618962e-01, 9.619075e-01, 9.619188e-01, 9.619301e-01, 9.619414e-01,
    9.619527e-01, 9.619640e-01, 9.619752e-01, 9.619866e-01, 9.619979e-01, 9.620092e-01,
    9.620205e-01, 9.620318e-01, 9.620431e-01, 9.620544e-01, 9.620657e-01, 9.620770e-01,
    9.620883e-01, 9.620996e-01, 9.621108e-01, 9.621222e-01, 9.621335e-01, 9.621448e-01,
    9.621561e-01, 9.621673e-01, 9.621787e-01, 9.621900e-01, 9.622013e-01, 9.622126e-01,
    9.622238e-01, 9.622352e-01, 9.622465e-01, 9.622578e-01, 9.622691e-01, 9.622803e-01,
    9.622917e-01, 9.623029e-01, 9.623143e-01, 9.623256e-01, 9.623368e-01, 9.623482e-01,
    9.623594e-01, 9.623707e-01, 9.623821e-01, 9.623933e-01, 9.624047e-01, 9.624159e-01,
    9.624272e-01, 9.624386e-01, 9.624498e-01, 9.624612e-01, 9.624724e-01, 9.624837e-01,
    9.624950e-01, 9.625063e-01, 9.625176e-01, 9.625289e-01, 9.625402e-01, 9.625515e-01,
    9.625628e-01, 9.625741e-01, 9.625854e-01, 9.625967e-01, 9.626080e-01, 9.626193e-01,
    9.626306e-01, 9.626418e-01, 9.626532e-01, 9.626645e-01, 9.626758e-01, 9.626871e-01,
    9.626983e-01, 9.627096e-01, 9.627209e-01, 9.627322e-01, 9.627436e-01, 9.627548e-01,
    9.627661e-01, 9.627774e-01, 9.627887e-01, 9.628000e-01, 9.628114e-01, 9.628226e-01,
    9.628339e-01, 9.628452e-01, 9.628565e-01, 9.628677e-01, 9.628791e-01, 9.628904e-01,
    9.629017e-01, 9.629130e-01, 9.629242e-01, 9.629355e-01, 9.629468e-01, 9.629581e-01,
    9.629694e-01, 9.629807e-01, 9.629920e-01, 9.630033e-01, 9.630146e-01, 9.630259e-01,
    9.630371e-01, 9.630485e-01, 9.630598e-01, 9.630710e-01, 9.630824e-01, 9.630936e-01,
    9.631049e-01, 9.631162e-01, 9.631275e-01, 9.631388e-01, 9.631500e-01, 9.631614e-01,
    9.631727e-01, 9.631839e-01, 9.631953e-01, 9.632065e-01, 9.632178e-01, 9.632292e-01,
    9.632404e-01, 9.632517e-01, 9.632630e-01, 9.632743e-01, 9.632856e-01, 9.632968e-01,
    9.633082e-01, 9.633195e-01, 9.633307e-01, 9.633421e-01, 9.633533e-01, 9.633646e-01,
    9.633759e-01, 9.633872e-01, 9.633985e-01, 9.634097e-01, 9.634211e-01, 9.634324e-01,
    9.634436e-01, 9.634549e-01, 9.634662e-01, 9.634775e-01, 9.634888e-01, 9.635001e-01,
    9.635114e-01, 9.635227e-01, 9.635339e-01, 9.635453e-01, 9.635565e-01, 9.635678e-01,
    9.635792e-01, 9.635904e-01, 9.636016e-01, 9.636129e-01, 9.636243e-01, 9.636356e-01,
    9.636468e-01, 9.636581e-01, 9.636694e-01, 9.636807e-01, 9.636919e-01, 9.637032e-01,
    9.637146e-01, 9.637259e-01, 9.637371e-01, 9.637484e-01, 9.637597e-01, 9.637710e-01,
    9.637823e-01, 9.637936e-01, 9.638049e-01, 9.638162e-01, 9.638274e-01, 9.638388e-01,
    9.638500e-01, 9.638613e-01, 9.638726e-01, 9.638838e-01, 9.638951e-01, 9.639064e-01,
    9.639177e-01, 9.639289e-01, 9.639403e-01, 9.639516e-01, 9.639629e-01, 9.639741e-01,
    9.639854e-01, 9.639967e-01, 9.640080e-01, 9.640192e-01, 9.640306e-01, 9.640419e-01,
    9.640532e-01, 9.640644e-01, 9.640757e-01, 9.640870e-01, 9.640983e-01, 9.641095e-01,
    9.641208e-01, 9.641321e-01, 9.641434e-01, 9.641547e-01, 9.641659e-01, 9.641773e-01,
    9.641886e-01, 9.641998e-01, 9.642111e-01, 9.642224e-01, 9.642337e-01, 9.642450e-01,
    9.642562e-01, 9.642675e-01, 9.642788e-01, 9.642901e-01, 9.643014e-01, 9.643127e-01,
    9.643239e-01, 9.643352e-01, 9.643465e-01, 9.643578e-01, 9.643691e-01, 9.643803e-01,
    9.643916e-01, 9.644030e-01, 9.644142e-01, 9.644255e-01, 9.644367e-01, 9.644480e-01,
    9.644594e-01, 9.644706e-01, 9.644819e-01, 9.644932e-01, 9.645044e-01, 9.645157e-01,
    9.645270e-01, 9.645383e-01, 9.645495e-01, 9.645608e-01, 9.645722e-01, 9.645835e-01,
    9.645947e-01, 9.646060e-01, 9.646173e-01, 9.646285e-01, 9.646398e-01, 9.646511e-01,
    9.646624e-01, 9.646736e-01, 9.646849e-01, 9.646962e-01, 9.647076e-01, 9.647188e-01,
    9.647301e-01, 9.647413e-01, 9.647526e-01, 9.647639e-01, 9.647752e-01, 9.647865e-01,
    9.647977e-01, 9.648090e-01, 9.648203e-01, 9.648315e-01, 9.648429e-01, 9.648541e-01,
    9.648654e-01, 9.648767e-01, 9.648879e-01, 9.648992e-01, 9.649106e-01, 9.649218e-01,
    9.649331e-01, 9.649444e-01, 9.649556e-01, 9.649669e-01, 9.649782e-01, 9.649895e-01,
    9.650007e-01, 9.650120e-01, 9.650233e-01, 9.650345e-01, 9.650458e-01, 9.650571e-01,
    9.650685e-01, 9.650797e-01, 9.650910e-01, 9.651023e-01, 9.651135e-01, 9.651248e-01,
    9.651360e-01, 9.651473e-01, 9.651586e-01, 9.651699e-01, 9.651812e-01, 9.651924e-01,
    9.652037e-01, 9.652150e-01, 9.652262e-01, 9.652375e-01, 9.652488e-01, 9.652601e-01,
    9.652714e-01, 9.652826e-01, 9.652939e-01, 9.653051e-01, 9.653164e-01, 9.653277e-01,
    9.653391e-01, 9.653503e-01, 9.653616e-01, 9.653729e-01, 9.653841e-01, 9.653954e-01,
    9.654067e-01, 9.654179e-01, 9.654292e-01, 9.654405e-01, 9.654518e-01, 9.654630e-01,
    9.654743e-01, 9.654856e-01, 9.654968e-01, 9.655081e-01, 9.655194e-01, 9.655306e-01,
    9.655419e-01, 9.655532e-01, 9.655645e-01, 9.655758e-01, 9.655870e-01, 9.655983e-01,
    9.656096e-01, 9.656208e-01, 9.656321e-01, 9.656433e-01, 9.656546e-01, 9.656659e-01,
    9.656771e-01, 9.656885e-01, 9.656998e-01, 9.657111e-01, 9.657223e-01, 9.657336e-01,
    9.657449e-01, 9.657561e-01, 9.657674e-01, 9.657786e-01, 9.657899e-01, 9.658012e-01,
    9.658124e-01, 9.658237e-01, 9.658350e-01, 9.658463e-01, 9.658576e-01, 9.658688e-01,
    9.658801e-01, 9.658914e-01, 9.659026e-01, 9.659139e-01, 9.659252e-01, 9.659364e-01,
    9.659477e-01, 9.659590e-01, 9.659702e-01, 9.659815e-01, 9.659927e-01, 9.660040e-01,
    9.660153e-01, 9.660265e-01, 9.660379e-01, 9.660491e-01, 9.660604e-01, 9.660717e-01,
    9.660829e-01, 9.660942e-01, 9.661055e-01, 9.661167e-01, 9.661280e-01, 9.661393e-01,
    9.661505e-01, 9.661618e-01, 9.661731e-01, 9.661843e-01, 9.661956e-01, 9.662068e-01,
    9.662181e-01, 9.662294e-01, 9.662406e-01, 9.662519e-01, 9.662632e-01, 9.662744e-01,
    9.662857e-01, 9.662970e-01, 9.663082e-01, 9.663195e-01, 9.663308e-01, 9.663420e-01,
    9.663534e-01, 9.663647e-01, 9.663759e-01, 9.663872e-01, 9.663985e-01, 9.664097e-01,
    9.664210e-01, 9.664323e-01, 9.664435e-01, 9.664548e-01, 9.664661e-01, 9.664773e-01,
    9.664886e-01, 9.664999e-01, 9.665111e-01, 9.665224e-01, 9.665337e-01, 9.665449e-01,
    9.665562e-01, 9.665675e-01, 9.665787e-01, 9.665900e-01, 9.666013e-01, 9.666125e-01,
    9.666238e-01, 9.666350e-01, 9.666463e-01, 9.666576e-01, 9.666688e-01, 9.666801e-01,
    9.666914e-01, 9.667026e-01, 9.667139e-01, 9.667251e-01, 9.667364e-01, 9.667476e-01,
    9.667589e-01, 9.667702e-01, 9.667814e-01, 9.667927e-01, 9.668040e-01, 9.668152e-01,
    9.668264e-01, 9.668377e-01, 9.668490e-01, 9.668602e-01, 9.668715e-01, 9.668828e-01,
    9.668940e-01, 9.669053e-01, 9.669166e-01, 9.669278e-01, 9.669391e-01, 9.669504e-01,
    9.669616e-01, 9.669729e-01, 9.669842e-01, 9.669954e-01, 9.670067e-01, 9.670179e-01,
    9.670292e-01, 9.670405e-01, 9.670517e-01, 9.670630e-01, 9.670743e-01, 9.670855e-01,
    9.670968e-01, 9.671081e-01, 9.671193e-01, 9.671305e-01, 9.671417e-01, 9.671530e-01,
    9.671643e-01, 9.671755e-01, 9.671868e-01, 9.671981e-01, 9.672093e-01, 9.672206e-01,
    9.672319e-01, 9.672431e-01, 9.672544e-01, 9.672657e-01, 9.672769e-01, 9.672882e-01,
    9.672995e-01, 9.673107e-01, 9.673219e-01, 9.673332e-01, 9.673445e-01, 9.673557e-01,
    9.673670e-01, 9.673783e-01, 9.673895e-01, 9.674008e-01, 9.674121e-01, 9.674233e-01,
    9.674346e-01, 9.674459e-01, 9.674571e-01, 9.674684e-01, 9.674795e-01, 9.674908e-01,
    9.675021e-01, 9.675133e-01, 9.675246e-01, 9.675359e-01, 9.675471e-01, 9.675584e-01,
    9.675696e-01, 9.675809e-01, 9.675922e-01, 9.676034e-01, 9.676147e-01, 9.676259e-01,
    9.676372e-01, 9.676484e-01, 9.676597e-01, 9.676710e-01, 9.676822e-01, 9.676935e-01,
    9.677048e-01, 9.677159e-01, 9.677272e-01, 9.677384e-01, 9.677497e-01, 9.677610e-01,
    9.677722e-01, 9.677835e-01, 9.677948e-01, 9.678060e-01, 9.678173e-01, 9.678285e-01,
    9.678398e-01, 9.678510e-01, 9.678623e-01, 9.678736e-01, 9.678848e-01, 9.678961e-01,
    9.679074e-01, 9.679185e-01, 9.679298e-01, 9.679410e-01, 9.679523e-01, 9.679636e-01,
    9.679748e-01, 9.679861e-01, 9.679974e-01, 9.680086e-01, 9.680198e-01, 9.680311e-01,
    9.680424e-01, 9.680536e-01, 9.680649e-01, 9.680762e-01, 9.680874e-01, 9.680986e-01,
    9.681098e-01, 9.681211e-01, 9.681324e-01, 9.681436e-01, 9.681549e-01, 9.681662e-01,
    9.681774e-01, 9.681886e-01, 9.681999e-01, 9.682112e-01, 9.682224e-01, 9.682337e-01,
    9.682449e-01, 9.682561e-01, 9.682674e-01, 9.682786e-01, 9.682899e-01, 9.683012e-01,
    9.683124e-01, 9.683236e-01, 9.683349e-01, 9.683462e-01, 9.683574e-01, 9.683687e-01,
    9.683800e-01, 9.683911e-01, 9.684024e-01, 9.684137e-01, 9.684249e-01, 9.684362e-01,
    9.684474e-01, 9.684587e-01, 9.684699e-01, 9.684812e-01, 9.684924e-01, 9.685037e-01,
    9.685150e-01, 9.685261e-01, 9.685374e-01, 9.685487e-01, 9.685599e-01, 9.685712e-01,
    9.685824e-01, 9.685937e-01, 9.686049e-01, 9.686162e-01, 9.686275e-01, 9.686387e-01,
    9.686499e-01, 9.686611e-01, 9.686724e-01, 9.686837e-01, 9.686949e-01, 9.687061e-01,
    9.687174e-01, 9.687287e-01, 9.687399e-01, 9.687512e-01, 9.687623e-01, 9.687736e-01,
    9.687849e-01, 9.687961e-01, 9.688074e-01, 9.688186e-01, 9.688299e-01, 9.688411e-01,
    9.688524e-01, 9.688637e-01, 9.688748e-01, 9.688861e-01, 9.688973e-01, 9.689086e-01,
    9.689199e-01, 9.689311e-01, 9.689423e-01, 9.689536e-01, 9.689649e-01, 9.689761e-01,
    9.689873e-01, 9.689986e-01, 9.690098e-01, 9.690211e-01, 9.690323e-01, 9.690436e-01,
    9.690548e-01, 9.690661e-01, 9.690773e-01, 9.690886e-01, 9.690998e-01, 9.691111e-01,
    9.691224e-01, 9.691335e-01, 9.691448e-01, 9.691560e-01, 9.691673e-01, 9.691785e-01,
    9.691898e-01, 9.692010e-01, 9.692123e-01, 9.692234e-01, 9.692347e-01, 9.692460e-01,
    9.692572e-01, 9.692684e-01, 9.692797e-01, 9.692910e-01, 9.693022e-01, 9.693135e-01,
    9.693246e-01, 9.693359e-01, 9.693472e-01, 9.693584e-01, 9.693696e-01, 9.693809e-01,
    9.693922e-01, 9.694033e-01, 9.694146e-01, 9.694259e-01, 9.694371e-01, 9.694483e-01,
    9.694596e-01, 9.694709e-01, 9.694821e-01, 9.694933e-01, 9.695045e-01, 9.695158e-01,
    9.695271e-01, 9.695383e-01, 9.695495e-01, 9.695608e-01, 9.695721e-01, 9.695832e-01,
    9.695945e-01, 9.696057e-01, 9.696169e-01, 9.696282e-01, 9.696395e-01, 9.696507e-01,
    9.696619e-01, 9.696732e-01, 9.696844e-01, 9.696956e-01, 9.697069e-01, 9.697182e-01,
    9.697294e-01, 9.697406e-01, 9.697518e-01, 9.697631e-01, 9.697743e-01, 9.697856e-01,
    9.697968e-01, 9.698081e-01, 9.698193e-01, 9.698306e-01, 9.698418e-01, 9.698530e-01,
    9.698642e-01, 9.698755e-01, 9.698868e-01, 9.698980e-01, 9.699093e-01, 9.699205e-01,
    9.699317e-01, 9.699429e-01, 9.699542e-01, 9.699654e-01, 9.699767e-01, 9.699879e-01,
    9.699991e-01, 9.700103e-01, 9.700216e-01, 9.700329e-01, 9.700441e-01, 9.700553e-01,
    9.700666e-01, 9.700778e-01, 9.700890e-01, 9.701003e-01, 9.701115e-01, 9.701228e-01,
    9.701340e-01, 9.701452e-01, 9.701564e-01, 9.701677e-01, 9.701789e-01, 9.701902e-01,
    9.702014e-01, 9.702126e-01, 9.702238e-01, 9.702351e-01, 9.702463e-01, 9.702576e-01,
    9.702688e-01, 9.702801e-01, 9.702913e-01, 9.703025e-01, 9.703137e-01, 9.703250e-01,
    9.703363e-01, 9.703475e-01, 9.703587e-01, 9.703700e-01, 9.703811e-01, 9.703924e-01,
    9.704037e-01, 9.704149e-01, 9.704261e-01, 9.704374e-01, 9.704486e-01, 9.704598e-01,
    9.704711e-01, 9.704823e-01, 9.704936e-01, 9.705047e-01, 9.705160e-01, 9.705272e-01,
    9.705384e-01, 9.705497e-01, 9.705610e-01, 9.705721e-01, 9.705834e-01, 9.705946e-01,
    9.706059e-01, 9.706171e-01, 9.706283e-01, 9.706395e-01, 9.706508e-01, 9.706620e-01,
    9.706733e-01, 9.706845e-01, 9.706957e-01, 9.707069e-01, 9.707182e-01, 9.707294e-01,
    9.707407e-01, 9.707519e-01, 9.707631e-01, 9.707744e-01, 9.707856e-01, 9.707968e-01,
    9.708080e-01, 9.708193e-01, 9.708306e-01, 9.708417e-01, 9.708530e-01, 9.708642e-01,
    9.708754e-01, 9.708867e-01, 9.708979e-01, 9.709091e-01, 9.709204e-01, 9.709316e-01,
    9.709429e-01, 9.709540e-01, 9.709653e-01, 9.709765e-01, 9.709877e-01, 9.709990e-01,
    9.710101e-01, 9.710214e-01, 9.710327e-01, 9.710439e-01, 9.710552e-01, 9.710664e-01,
    9.710776e-01, 9.710889e-01, 9.711000e-01, 9.711113e-01, 9.711225e-01, 9.711338e-01,
    9.711450e-01, 9.711562e-01, 9.711674e-01, 9.711787e-01, 9.711899e-01, 9.712011e-01,
    9.712123e-01, 9.712236e-01, 9.712348e-01, 9.712461e-01, 9.712572e-01, 9.712685e-01,
    9.712797e-01, 9.712909e-01, 9.713022e-01, 9.713134e-01, 9.713246e-01, 9.713358e-01,
    9.713471e-01, 9.713582e-01, 9.713695e-01, 9.713808e-01, 9.713920e-01, 9.714032e-01,
    9.714144e-01, 9.714257e-01, 9.714369e-01, 9.714481e-01, 9.714594e-01, 9.714706e-01,
    9.714819e-01, 9.714930e-01, 9.715043e-01, 9.715155e-01, 9.715267e-01, 9.715379e-01,
    9.715492e-01, 9.715604e-01, 9.715716e-01, 9.715829e-01, 9.715940e-01, 9.716053e-01,
    9.716165e-01, 9.716278e-01, 9.716389e-01, 9.716502e-01, 9.716614e-01, 9.716727e-01,
    9.716839e-01, 9.716951e-01, 9.717063e-01, 9.717175e-01, 9.717288e-01, 9.717400e-01,
    9.717513e-01, 9.717624e-01, 9.717737e-01, 9.717849e-01, 9.717962e-01, 9.718073e-01,
    9.718186e-01, 9.718298e-01, 9.718410e-01, 9.718522e-01, 9.718634e-01, 9.718747e-01,
    9.718859e-01, 9.718971e-01, 9.719083e-01, 9.719196e-01, 9.719308e-01, 9.719421e-01,
    9.719532e-01, 9.719645e-01, 9.719757e-01, 9.719869e-01, 9.719982e-01, 9.720094e-01,
    9.720206e-01, 9.720318e-01, 9.720430e-01, 9.720543e-01, 9.720654e-01, 9.720767e-01,
    9.720879e-01, 9.720992e-01, 9.721103e-01, 9.721216e-01, 9.721328e-01, 9.721441e-01,
    9.721552e-01, 9.721665e-01, 9.721777e-01, 9.721889e-01, 9.722001e-01, 9.722114e-01,
    9.722226e-01, 9.722338e-01, 9.722450e-01, 9.722563e-01, 9.722674e-01, 9.722787e-01,
    9.722899e-01, 9.723011e-01, 9.723123e-01, 9.723235e-01, 9.723348e-01, 9.723459e-01,
    9.723572e-01, 9.723684e-01, 9.723797e-01, 9.723908e-01, 9.724021e-01, 9.724133e-01,
    9.724246e-01, 9.724357e-01, 9.724470e-01, 9.724582e-01, 9.724694e-01, 9.724807e-01,
    9.724919e-01, 9.725031e-01, 9.725143e-01, 9.725255e-01, 9.725367e-01, 9.725479e-01,
    9.725592e-01, 9.725704e-01, 9.725816e-01, 9.725928e-01, 9.726040e-01, 9.726153e-01,
    9.726264e-01, 9.726377e-01, 9.726489e-01, 9.726601e-01, 9.726713e-01, 9.726825e-01,
    9.726938e-01, 9.727050e-01, 9.727163e-01, 9.727274e-01, 9.727386e-01, 9.727499e-01,
    9.727610e-01, 9.727723e-01, 9.727835e-01, 9.727948e-01, 9.728059e-01, 9.728172e-01,
    9.728284e-01, 9.728395e-01, 9.728508e-01, 9.728620e-01, 9.728733e-01, 9.728844e-01,
    9.728957e-01, 9.729069e-01, 9.729181e-01, 9.729294e-01, 9.729405e-01, 9.729518e-01,
    9.729630e-01, 9.729742e-01, 9.729854e-01, 9.729966e-01, 9.730079e-01, 9.730190e-01,
    9.730303e-01, 9.730415e-01, 9.730526e-01, 9.730639e-01, 9.730751e-01, 9.730864e-01,
    9.730975e-01, 9.731088e-01, 9.731200e-01, 9.731312e-01, 9.731424e-01, 9.731536e-01,
    9.731649e-01, 9.731761e-01, 9.731872e-01, 9.731985e-01, 9.732097e-01, 9.732209e-01,
    9.732321e-01, 9.732433e-01, 9.732546e-01, 9.732657e-01, 9.732770e-01, 9.732882e-01,
    9.732993e-01, 9.733106e-01, 9.733218e-01, 9.733330e-01, 9.733443e-01, 9.733554e-01,
    9.733667e-01, 9.733779e-01, 9.733890e-01, 9.734003e-01, 9.734115e-01, 9.734228e-01,
    9.734339e-01, 9.734451e-01, 9.734564e-01, 9.734675e-01, 9.734787e-01, 9.734900e-01,
    9.735011e-01, 9.735124e-01, 9.735236e-01, 9.735348e-01, 9.735461e-01, 9.735572e-01,
    9.735684e-01, 9.735797e-01, 9.735909e-01, 9.736021e-01, 9.736133e-01, 9.736245e-01,
    9.736357e-01, 9.736469e-01, 9.736581e-01, 9.736694e-01, 9.736806e-01, 9.736917e-01,
    9.737030e-01, 9.737142e-01, 9.737254e-01, 9.737366e-01, 9.737478e-01, 9.737590e-01,
    9.737703e-01, 9.737814e-01, 9.737927e-01, 9.738039e-01, 9.738150e-01, 9.738263e-01,
    9.738375e-01, 9.738486e-01, 9.738599e-01, 9.738711e-01, 9.738823e-01, 9.738935e-01,
    9.739047e-01, 9.739159e-01, 9.739272e-01, 9.739383e-01, 9.739496e-01, 9.739608e-01,
    9.739720e-01, 9.739832e-01, 9.739944e-01, 9.740056e-01, 9.740168e-01, 9.740281e-01,
    9.740392e-01, 9.740504e-01, 9.740617e-01, 9.740728e-01, 9.740840e-01, 9.740953e-01,
    9.741065e-01, 9.741176e-01, 9.741288e-01, 9.741401e-01, 9.741513e-01, 9.741625e-01,
    9.741737e-01, 9.741849e-01, 9.741961e-01, 9.742073e-01, 9.742185e-01, 9.742297e-01,
    9.742410e-01, 9.742521e-01, 9.742633e-01, 9.742745e-01, 9.742858e-01, 9.742969e-01,
    9.743081e-01, 9.743194e-01, 9.743305e-01, 9.743418e-01, 9.743530e-01, 9.743642e-01,
    9.743754e-01, 9.743865e-01, 9.743978e-01, 9.744090e-01, 9.744202e-01, 9.744315e-01,
    9.744426e-01, 9.744538e-01, 9.744650e-01, 9.744762e-01, 9.744874e-01, 9.744986e-01,
    9.745098e-01, 9.745210e-01, 9.745322e-01, 9.745434e-01, 9.745547e-01, 9.745658e-01,
    9.745770e-01, 9.745883e-01, 9.745995e-01, 9.746106e-01, 9.746218e-01, 9.746331e-01,
    9.746442e-01, 9.746554e-01, 9.746666e-01, 9.746779e-01, 9.746891e-01, 9.747002e-01,
    9.747115e-01, 9.747227e-01, 9.747338e-01, 9.747450e-01, 9.747563e-01, 9.747675e-01,
    9.747787e-01, 9.747899e-01, 9.748011e-01, 9.748123e-01, 9.748235e-01, 9.748346e-01,
    9.748459e-01, 9.748571e-01, 9.748682e-01, 9.748794e-01, 9.748907e-01, 9.749019e-01,
    9.749131e-01, 9.749243e-01, 9.749355e-01, 9.749467e-01, 9.749579e-01, 9.749690e-01,
    9.749803e-01, 9.749915e-01, 9.750026e-01, 9.750139e-01, 9.750251e-01, 9.750363e-01,
    9.750475e-01, 9.750587e-01, 9.750698e-01, 9.750811e-01, 9.750923e-01, 9.751034e-01,
    9.751146e-01, 9.751259e-01, 9.751371e-01, 9.751483e-01, 9.751594e-01, 9.751706e-01,
    9.751819e-01, 9.751930e-01, 9.752042e-01, 9.752154e-01, 9.752267e-01, 9.752378e-01,
    9.752491e-01, 9.752602e-01, 9.752714e-01, 9.752827e-01, 9.752938e-01, 9.753050e-01,
    9.753162e-01, 9.753274e-01, 9.753386e-01, 9.753498e-01, 9.753610e-01, 9.753722e-01,
    9.753835e-01, 9.753946e-01, 9.754058e-01, 9.754170e-01, 9.754282e-01, 9.754394e-01,
    9.754506e-01, 9.754618e-01, 9.754729e-01, 9.754841e-01, 9.754953e-01, 9.755066e-01,
    9.755177e-01, 9.755290e-01, 9.755401e-01, 9.755513e-01, 9.755626e-01, 9.755737e-01,
    9.755849e-01, 9.755961e-01, 9.756073e-01, 9.756185e-01, 9.756297e-01, 9.756409e-01,
    9.756521e-01, 9.756632e-01, 9.756745e-01, 9.756857e-01, 9.756969e-01, 9.757081e-01,
    9.757192e-01, 9.757304e-01, 9.757416e-01, 9.757528e-01, 9.757640e-01, 9.757752e-01,
    9.757864e-01, 9.757976e-01, 9.758087e-01, 9.758200e-01, 9.758312e-01, 9.758424e-01,
    9.758536e-01, 9.758647e-01, 9.758759e-01, 9.758872e-01, 9.758983e-01, 9.759095e-01,
    9.759207e-01, 9.759319e-01, 9.759431e-01, 9.759544e-01, 9.759655e-01, 9.759767e-01,
    9.759879e-01, 9.759991e-01, 9.760102e-01, 9.760214e-01, 9.760327e-01, 9.760438e-01,
    9.760550e-01, 9.760662e-01, 9.760774e-01, 9.760886e-01, 9.760997e-01, 9.761110e-01,
    9.761222e-01, 9.761333e-01, 9.761446e-01, 9.761557e-01, 9.761669e-01, 9.761781e-01,
    9.761893e-01, 9.762005e-01, 9.762117e-01, 9.762229e-01, 9.762341e-01, 9.762452e-01,
    9.762564e-01, 9.762676e-01, 9.762788e-01, 9.762900e-01, 9.763012e-01, 9.763124e-01,
    9.763236e-01, 9.763348e-01, 9.763460e-01, 9.763571e-01, 9.763683e-01, 9.763796e-01,
    9.763907e-01, 9.764019e-01, 9.764131e-01, 9.764243e-01, 9.764355e-01, 9.764466e-01,
    9.764578e-01, 9.764690e-01, 9.764802e-01, 9.764915e-01, 9.765026e-01, 9.765138e-01,
    9.765249e-01, 9.765362e-01, 9.765473e-01, 9.765585e-01, 9.765697e-01, 9.765809e-01,
    9.765921e-01, 9.766033e-01, 9.766145e-01, 9.766257e-01, 9.766368e-01, 9.766480e-01,
    9.766592e-01, 9.766704e-01, 9.766816e-01, 9.766927e-01, 9.767039e-01, 9.767151e-01,
    9.767264e-01, 9.767376e-01, 9.767487e-01, 9.767599e-01, 9.767711e-01, 9.767823e-01,
    9.767934e-01, 9.768046e-01, 9.768158e-01, 9.768270e-01, 9.768382e-01, 9.768493e-01,
    9.768605e-01, 9.768718e-01, 9.768829e-01, 9.768941e-01, 9.769053e-01, 9.769165e-01,
    9.769276e-01, 9.769388e-01, 9.769500e-01, 9.769612e-01, 9.769724e-01, 9.769835e-01,
    9.769948e-01, 9.770059e-01, 9.770171e-01, 9.770283e-01, 9.770395e-01, 9.770507e-01,
    9.770619e-01, 9.770731e-01, 9.770843e-01, 9.770954e-01, 9.771066e-01, 9.771178e-01,
    9.771290e-01, 9.771401e-01, 9.771513e-01, 9.771625e-01, 9.771737e-01, 9.771849e-01,
    9.771960e-01, 9.772072e-01, 9.772184e-01, 9.772296e-01, 9.772407e-01, 9.772519e-01,
    9.772631e-01, 9.772743e-01, 9.772855e-01, 9.772967e-01, 9.773079e-01, 9.773190e-01,
    9.773303e-01, 9.773415e-01, 9.773526e-01, 9.773638e-01, 9.773750e-01, 9.773862e-01,
    9.773973e-01, 9.774085e-01, 9.774197e-01, 9.774309e-01, 9.774421e-01, 9.774532e-01,
    9.774644e-01, 9.774756e-01, 9.774868e-01, 9.774979e-01, 9.775091e-01, 9.775203e-01,
    9.775315e-01, 9.775427e-01, 9.775538e-01, 9.775651e-01, 9.775762e-01, 9.775874e-01,
    9.775985e-01, 9.776098e-01, 9.776210e-01, 9.776321e-01, 9.776433e-01, 9.776545e-01,
    9.776657e-01, 9.776768e-01, 9.776880e-01, 9.776992e-01, 9.777104e-01, 9.777215e-01,
    9.777327e-01, 9.777439e-01, 9.777551e-01, 9.777663e-01, 9.777774e-01, 9.777886e-01,
    9.777998e-01, 9.778110e-01, 9.778221e-01, 9.778333e-01, 9.778445e-01, 9.778557e-01,
    9.778669e-01, 9.778780e-01, 9.778892e-01, 9.779004e-01, 9.779116e-01, 9.779227e-01,
    9.779339e-01, 9.779450e-01, 9.779562e-01, 9.779674e-01, 9.779786e-01, 9.779897e-01,
    9.780009e-01, 9.780121e-01, 9.780233e-01, 9.780344e-01, 9.780456e-01, 9.780568e-01,
    9.780680e-01, 9.780792e-01, 9.780903e-01, 9.781016e-01, 9.781127e-01, 9.781239e-01,
    9.781350e-01, 9.781463e-01, 9.781574e-01, 9.781686e-01, 9.781798e-01, 9.781910e-01,
    9.782022e-01, 9.782133e-01, 9.782244e-01, 9.782356e-01, 9.782467e-01, 9.782580e-01,
    9.782692e-01, 9.782803e-01, 9.782915e-01, 9.783027e-01, 9.783139e-01, 9.783250e-01,
    9.783362e-01, 9.783474e-01, 9.783586e-01, 9.783697e-01, 9.783809e-01, 9.783921e-01,
    9.784032e-01, 9.784144e-01, 9.784256e-01, 9.784367e-01, 9.784479e-01, 9.784591e-01,
    9.784703e-01, 9.784815e-01, 9.784926e-01, 9.785038e-01, 9.785150e-01, 9.785262e-01,
    9.785373e-01, 9.785484e-01, 9.785596e-01, 9.785708e-01, 9.785820e-01, 9.785932e-01,
    9.786043e-01, 9.786155e-01, 9.786267e-01, 9.786379e-01, 9.786490e-01, 9.786602e-01,
    9.786714e-01, 9.786825e-01, 9.786937e-01, 9.787049e-01, 9.787160e-01, 9.787272e-01,
    9.787384e-01, 9.787496e-01, 9.787607e-01, 9.787719e-01, 9.787831e-01, 9.787942e-01,
    9.788054e-01, 9.788166e-01, 9.788277e-01, 9.788389e-01, 9.788501e-01, 9.788613e-01,
    9.788724e-01, 9.788836e-01, 9.788947e-01, 9.789059e-01, 9.789171e-01, 9.789283e-01,
    9.789394e-01, 9.789506e-01, 9.789618e-01, 9.789730e-01, 9.789842e-01, 9.789953e-01,
    9.790064e-01, 9.790176e-01, 9.790288e-01, 9.790400e-01, 9.790511e-01, 9.790623e-01,
    9.790735e-01, 9.790846e-01, 9.790958e-01, 9.791070e-01, 9.791181e-01, 9.791293e-01,
    9.791405e-01, 9.791517e-01, 9.791628e-01, 9.791740e-01, 9.791851e-01, 9.791963e-01,
    9.792075e-01, 9.792187e-01, 9.792298e-01, 9.792409e-01, 9.792521e-01, 9.792633e-01,
    9.792745e-01, 9.792857e-01, 9.792968e-01, 9.793080e-01, 9.793191e-01, 9.793302e-01,
    9.793414e-01, 9.793526e-01, 9.793638e-01, 9.793750e-01, 9.793861e-01, 9.793972e-01,
    9.794084e-01, 9.794196e-01, 9.794308e-01, 9.794419e-01, 9.794531e-01, 9.794642e-01,
    9.794754e-01, 9.794866e-01, 9.794978e-01, 9.795089e-01, 9.795201e-01, 9.795312e-01,
    9.795424e-01, 9.795536e-01, 9.795648e-01, 9.795759e-01, 9.795870e-01, 9.795982e-01,
    9.796094e-01, 9.796206e-01, 9.796317e-01, 9.796429e-01, 9.796540e-01, 9.796652e-01,
    9.796764e-01, 9.796876e-01, 9.796987e-01, 9.797098e-01, 9.797210e-01, 9.797322e-01,
    9.797434e-01, 9.797546e-01, 9.797657e-01, 9.797768e-01, 9.797880e-01, 9.797992e-01,
    9.798104e-01, 9.798216e-01, 9.798326e-01, 9.798438e-01, 9.798550e-01, 9.798661e-01,
    9.798774e-01, 9.798884e-01, 9.798996e-01, 9.799108e-01, 9.799220e-01, 9.799331e-01,
    9.799442e-01, 9.799554e-01, 9.799666e-01, 9.799778e-01, 9.799889e-01, 9.800001e-01,
    9.800112e-01, 9.800224e-01, 9.800336e-01, 9.800447e-01, 9.800559e-01, 9.800670e-01,
    9.800782e-01, 9.800894e-01, 9.801005e-01, 9.801117e-01, 9.801229e-01, 9.801340e-01,
    9.801451e-01, 9.801563e-01, 9.801674e-01, 9.801787e-01, 9.801899e-01, 9.802009e-01,
    9.802121e-01, 9.802233e-01, 9.802344e-01, 9.802455e-01, 9.802567e-01, 9.802679e-01,
    9.802791e-01, 9.802902e-01, 9.803014e-01, 9.803125e-01, 9.803237e-01, 9.803348e-01,
    9.803460e-01, 9.803572e-01, 9.803684e-01, 9.803795e-01, 9.803906e-01, 9.804018e-01,
    9.804130e-01, 9.804240e-01, 9.804353e-01, 9.804465e-01, 9.804576e-01, 9.804687e-01,
    9.804799e-01, 9.804910e-01, 9.805022e-01, 9.805133e-01, 9.805245e-01, 9.805357e-01,
    9.805469e-01, 9.805580e-01, 9.805691e-01, 9.805803e-01, 9.805915e-01, 9.806026e-01,
    9.806138e-01, 9.806250e-01, 9.806361e-01, 9.806472e-01, 9.806584e-01, 9.806696e-01,
    9.806806e-01, 9.806919e-01, 9.807031e-01, 9.807142e-01, 9.807253e-01, 9.807365e-01,
    9.807476e-01, 9.807587e-01, 9.807699e-01, 9.807811e-01, 9.807923e-01, 9.808034e-01,
    9.808146e-01, 9.808257e-01, 9.808368e-01, 9.808480e-01, 9.808592e-01, 9.808704e-01,
    9.808815e-01, 9.808927e-01, 9.809038e-01, 9.809149e-01, 9.809261e-01, 9.809372e-01,
    9.809484e-01, 9.809595e-01, 9.809707e-01, 9.809819e-01, 9.809930e-01, 9.810042e-01,
    9.810153e-01, 9.810265e-01, 9.810376e-01, 9.810488e-01, 9.810599e-01, 9.810711e-01,
    9.810823e-01, 9.810934e-01, 9.811046e-01, 9.811157e-01, 9.811269e-01, 9.811380e-01,
    9.811491e-01, 9.811603e-01, 9.811714e-01, 9.811826e-01, 9.811938e-01, 9.812049e-01,
    9.812161e-01, 9.812272e-01, 9.812383e-01, 9.812495e-01, 9.812607e-01, 9.812718e-01,
    9.812829e-01, 9.812942e-01, 9.813052e-01, 9.813164e-01, 9.813276e-01, 9.813387e-01,
    9.813499e-01, 9.813610e-01, 9.813721e-01, 9.813833e-01, 9.813945e-01, 9.814056e-01,
    9.814168e-01, 9.814279e-01, 9.814391e-01, 9.814502e-01, 9.814614e-01, 9.814725e-01,
    9.814836e-01, 9.814948e-01, 9.815059e-01, 9.815171e-01, 9.815283e-01, 9.815394e-01,
    9.815506e-01, 9.815617e-01, 9.815728e-01, 9.815840e-01, 9.815952e-01, 9.816063e-01,
    9.816175e-01, 9.816285e-01, 9.816397e-01, 9.816509e-01, 9.816620e-01, 9.816732e-01,
    9.816844e-01, 9.816955e-01, 9.817066e-01, 9.817178e-01, 9.817289e-01, 9.817401e-01,
    9.817512e-01, 9.817623e-01, 9.817736e-01, 9.817846e-01, 9.817958e-01, 9.818070e-01,
    9.818181e-01, 9.818293e-01, 9.818404e-01, 9.818515e-01, 9.818627e-01, 9.818738e-01,
    9.818850e-01, 9.818962e-01, 9.819072e-01, 9.819185e-01, 9.819295e-01, 9.819407e-01,
    9.819519e-01, 9.819630e-01, 9.819741e-01, 9.819853e-01, 9.819964e-01, 9.820076e-01,
    9.820187e-01, 9.820299e-01, 9.820409e-01, 9.820521e-01, 9.820634e-01, 9.820744e-01,
    9.820856e-01, 9.820967e-01, 9.821079e-01, 9.821190e-01, 9.821302e-01, 9.821413e-01,
    9.821524e-01, 9.821636e-01, 9.821748e-01, 9.821858e-01, 9.821970e-01, 9.822081e-01,
    9.822193e-01, 9.822305e-01, 9.822416e-01, 9.822528e-01, 9.822639e-01, 9.822750e-01,
    9.822862e-01, 9.822973e-01, 9.823085e-01, 9.823196e-01, 9.823307e-01, 9.823418e-01,
    9.823530e-01, 9.823642e-01, 9.823753e-01, 9.823865e-01, 9.823976e-01, 9.824088e-01,
    9.824198e-01, 9.824311e-01, 9.824422e-01, 9.824533e-01, 9.824645e-01, 9.824756e-01,
    9.824867e-01, 9.824979e-01, 9.825090e-01, 9.825201e-01, 9.825313e-01, 9.825425e-01,
    9.825535e-01, 9.825647e-01, 9.825758e-01, 9.825870e-01, 9.825981e-01, 9.826093e-01,
    9.826204e-01, 9.826316e-01, 9.826427e-01, 9.826539e-01, 9.826650e-01, 9.826761e-01,
    9.826873e-01, 9.826984e-01, 9.827095e-01, 9.827207e-01, 9.827318e-01, 9.827429e-01,
    9.827541e-01, 9.827653e-01, 9.827763e-01, 9.827875e-01, 9.827986e-01, 9.828098e-01,
    9.828209e-01, 9.828321e-01, 9.828432e-01, 9.828544e-01, 9.828655e-01, 9.828767e-01,
    9.828877e-01, 9.828989e-01, 9.829100e-01, 9.829212e-01, 9.829323e-01, 9.829435e-01,
    9.829546e-01, 9.829657e-01, 9.829769e-01, 9.829880e-01, 9.829991e-01, 9.830103e-01,
    9.830214e-01, 9.830325e-01, 9.830437e-01, 9.830548e-01, 9.830660e-01, 9.830771e-01,
    9.830883e-01, 9.830993e-01, 9.831105e-01, 9.831216e-01, 9.831328e-01, 9.831439e-01,
    9.831551e-01, 9.831662e-01, 9.831774e-01, 9.831885e-01, 9.831996e-01, 9.832107e-01,
    9.832219e-01, 9.832330e-01, 9.832442e-01, 9.832553e-01, 9.832664e-01, 9.832775e-01,
    9.832887e-01, 9.832998e-01, 9.833110e-01, 9.833221e-01, 9.833332e-01, 9.833443e-01,
    9.833555e-01, 9.833666e-01, 9.833778e-01, 9.833889e-01, 9.834000e-01, 9.834111e-01,
    9.834223e-01, 9.834334e-01, 9.834446e-01, 9.834557e-01, 9.834668e-01, 9.834780e-01,
    9.834890e-01, 9.835002e-01, 9.835113e-01, 9.835225e-01, 9.835336e-01, 9.835448e-01,
    9.835559e-01, 9.835671e-01, 9.835781e-01, 9.835894e-01, 9.836004e-01, 9.836116e-01,
    9.836227e-01, 9.836339e-01, 9.836450e-01, 9.836560e-01, 9.836673e-01, 9.836783e-01,
    9.836895e-01, 9.837006e-01, 9.837118e-01, 9.837229e-01, 9.837341e-01, 9.837452e-01,
    9.837563e-01, 9.837674e-01, 9.837785e-01, 9.837897e-01, 9.838008e-01, 9.838120e-01,
    9.838231e-01, 9.838342e-01, 9.838454e-01, 9.838565e-01, 9.838676e-01, 9.838787e-01,
    9.838899e-01, 9.839010e-01, 9.839122e-01, 9.839233e-01, 9.839344e-01, 9.839455e-01,
    9.839566e-01, 9.839678e-01, 9.839789e-01, 9.839901e-01, 9.840012e-01, 9.840123e-01,
    9.840234e-01, 9.840345e-01, 9.840457e-01, 9.840568e-01, 9.840680e-01, 9.840791e-01,
    9.840902e-01, 9.841013e-01, 9.841124e-01, 9.841236e-01, 9.841347e-01, 9.841459e-01,
    9.841570e-01, 9.841681e-01, 9.841793e-01, 9.841903e-01, 9.842015e-01, 9.842126e-01,
    9.842238e-01, 9.842349e-01, 9.842460e-01, 9.842572e-01, 9.842682e-01, 9.842794e-01,
    9.842905e-01, 9.843016e-01, 9.843128e-01, 9.843239e-01, 9.843351e-01, 9.843462e-01,
    9.843572e-01, 9.843684e-01, 9.843795e-01, 9.843907e-01, 9.844018e-01, 9.844128e-01,
    9.844241e-01, 9.844351e-01, 9.844462e-01, 9.844574e-01, 9.844685e-01, 9.844797e-01,
    9.844908e-01, 9.845019e-01, 9.845130e-01, 9.845241e-01, 9.845353e-01, 9.845464e-01,
    9.845575e-01, 9.845687e-01, 9.845798e-01, 9.845909e-01, 9.846020e-01, 9.846131e-01,
    9.846243e-01, 9.846354e-01, 9.846465e-01, 9.846577e-01, 9.846688e-01, 9.846799e-01,
    9.846910e-01, 9.847022e-01, 9.847133e-01, 9.847244e-01, 9.847355e-01, 9.847467e-01,
    9.847578e-01, 9.847689e-01, 9.847801e-01, 9.847912e-01, 9.848022e-01, 9.848134e-01,
    9.848245e-01, 9.848356e-01, 9.848468e-01, 9.848579e-01, 9.848689e-01, 9.848801e-01,
    9.848912e-01, 9.849023e-01, 9.849135e-01, 9.849246e-01, 9.849358e-01, 9.849468e-01,
    9.849580e-01, 9.849691e-01, 9.849802e-01, 9.849913e-01, 9.850025e-01, 9.850136e-01,
    9.850247e-01, 9.850359e-01, 9.850470e-01, 9.850581e-01, 9.850692e-01, 9.850804e-01,
    9.850914e-01, 9.851026e-01, 9.851137e-01, 9.851248e-01, 9.851360e-01, 9.851471e-01,
    9.851581e-01, 9.851694e-01, 9.851804e-01, 9.851915e-01, 9.852026e-01, 9.852138e-01,
    9.852249e-01, 9.852360e-01, 9.852471e-01, 9.852582e-01, 9.852694e-01, 9.852805e-01,
    9.852916e-01, 9.853027e-01, 9.853139e-01, 9.853250e-01, 9.853361e-01, 9.853473e-01,
    9.853584e-01, 9.853694e-01, 9.853805e-01, 9.853917e-01, 9.854028e-01, 9.854139e-01,
    9.854251e-01, 9.854361e-01, 9.854473e-01, 9.854584e-01, 9.854695e-01, 9.854806e-01,
    9.854917e-01, 9.855029e-01, 9.855140e-01, 9.855251e-01, 9.855363e-01, 9.855474e-01,
    9.855585e-01, 9.855695e-01, 9.855807e-01, 9.855918e-01, 9.856029e-01, 9.856141e-01,
    9.856251e-01, 9.856363e-01, 9.856474e-01, 9.856585e-01, 9.856696e-01, 9.856807e-01,
    9.856919e-01, 9.857030e-01, 9.857141e-01, 9.857252e-01, 9.857364e-01, 9.857475e-01,
    9.857585e-01, 9.857696e-01, 9.857808e-01, 9.857919e-01, 9.858030e-01, 9.858142e-01,
    9.858253e-01, 9.858364e-01, 9.858475e-01, 9.858586e-01, 9.858697e-01, 9.858809e-01,
    9.858919e-01, 9.859031e-01, 9.859142e-01, 9.859253e-01, 9.859364e-01, 9.859475e-01,
    9.859586e-01, 9.859697e-01, 9.859808e-01, 9.859920e-01, 9.860031e-01, 9.860142e-01,
    9.860253e-01, 9.860365e-01, 9.860476e-01, 9.860587e-01, 9.860697e-01, 9.860809e-01,
    9.860920e-01, 9.861031e-01, 9.861142e-01, 9.861254e-01, 9.861365e-01, 9.861476e-01,
    9.861587e-01, 9.861698e-01, 9.861810e-01, 9.861920e-01, 9.862031e-01, 9.862142e-01,
    9.862254e-01, 9.862365e-01, 9.862476e-01, 9.862587e-01, 9.862698e-01, 9.862809e-01,
    9.862921e-01, 9.863032e-01, 9.863142e-01, 9.863254e-01, 9.863365e-01, 9.863476e-01,
    9.863587e-01, 9.863698e-01, 9.863809e-01, 9.863920e-01, 9.864032e-01, 9.864143e-01,
    9.864254e-01, 9.864365e-01, 9.864476e-01, 9.864587e-01, 9.864698e-01, 9.864810e-01,
    9.864920e-01, 9.865031e-01, 9.865142e-01, 9.865254e-01, 9.865365e-01, 9.865476e-01,
    9.865587e-01, 9.865698e-01, 9.865809e-01, 9.865921e-01, 9.866031e-01, 9.866142e-01,
    9.866253e-01, 9.866365e-01, 9.866476e-01, 9.866587e-01, 9.866698e-01, 9.866809e-01,
    9.866920e-01, 9.867032e-01, 9.867142e-01, 9.867253e-01, 9.867364e-01, 9.867475e-01,
    9.867586e-01, 9.867698e-01, 9.867809e-01, 9.867920e-01, 9.868031e-01, 9.868142e-01,
    9.868253e-01, 9.868364e-01, 9.868475e-01, 9.868586e-01, 9.868698e-01, 9.868808e-01,
    9.868920e-01, 9.869031e-01, 9.869142e-01, 9.869253e-01, 9.869364e-01, 9.869475e-01,
    9.869586e-01, 9.869697e-01, 9.869809e-01, 9.869919e-01, 9.870030e-01, 9.870141e-01,
    9.870253e-01, 9.870364e-01, 9.870475e-01, 9.870586e-01, 9.870697e-01, 9.870808e-01,
    9.870918e-01, 9.871030e-01, 9.871141e-01, 9.871252e-01, 9.871363e-01, 9.871474e-01,
    9.871585e-01, 9.871696e-01, 9.871808e-01, 9.871919e-01, 9.872029e-01, 9.872140e-01,
    9.872251e-01, 9.872362e-01, 9.872473e-01, 9.872585e-01, 9.872696e-01, 9.872807e-01,
    9.872918e-01, 9.873028e-01, 9.873140e-01, 9.873251e-01, 9.873362e-01, 9.873473e-01,
    9.873584e-01, 9.873695e-01, 9.873806e-01, 9.873917e-01, 9.874028e-01, 9.874139e-01,
    9.874250e-01, 9.874362e-01, 9.874473e-01, 9.874583e-01, 9.874694e-01, 9.874805e-01,
    9.874916e-01, 9.875027e-01, 9.875138e-01, 9.875250e-01, 9.875361e-01, 9.875472e-01,
    9.875582e-01, 9.875693e-01, 9.875804e-01, 9.875916e-01, 9.876027e-01, 9.876137e-01,
    9.876249e-01, 9.876360e-01, 9.876471e-01, 9.876582e-01, 9.876693e-01, 9.876804e-01,
    9.876915e-01, 9.877025e-01, 9.877136e-01, 9.877247e-01, 9.877358e-01, 9.877470e-01,
    9.877581e-01, 9.877692e-01, 9.877803e-01, 9.877914e-01, 9.878024e-01, 9.878136e-01,
    9.878247e-01, 9.878358e-01, 9.878469e-01, 9.878579e-01, 9.878691e-01, 9.878802e-01,
    9.878913e-01, 9.879024e-01, 9.879135e-01, 9.879246e-01, 9.879357e-01, 9.879467e-01,
    9.879578e-01, 9.879690e-01, 9.879801e-01, 9.879912e-01, 9.880022e-01, 9.880133e-01,
    9.880245e-01, 9.880356e-01, 9.880467e-01, 9.880578e-01, 9.880689e-01, 9.880800e-01,
    9.880911e-01, 9.881021e-01, 9.881132e-01, 9.881243e-01, 9.881355e-01, 9.881465e-01,
    9.881576e-01, 9.881687e-01, 9.881798e-01, 9.881909e-01, 9.882021e-01, 9.882132e-01,
    9.882243e-01, 9.882354e-01, 9.882464e-01, 9.882575e-01, 9.882686e-01, 9.882797e-01,
    9.882908e-01, 9.883019e-01, 9.883130e-01, 9.883241e-01, 9.883352e-01, 9.883463e-01,
    9.883574e-01, 9.883685e-01, 9.883795e-01, 9.883907e-01, 9.884018e-01, 9.884129e-01,
    9.884239e-01, 9.884350e-01, 9.884461e-01, 9.884572e-01, 9.884683e-01, 9.884794e-01,
    9.884905e-01, 9.885017e-01, 9.885128e-01, 9.885238e-01, 9.885349e-01, 9.885460e-01,
    9.885572e-01, 9.885682e-01, 9.885793e-01, 9.885904e-01, 9.886015e-01, 9.886126e-01,
    9.886237e-01, 9.886348e-01, 9.886459e-01, 9.886570e-01, 9.886681e-01, 9.886792e-01,
    9.886903e-01, 9.887013e-01, 9.887124e-01, 9.887235e-01, 9.887346e-01, 9.887457e-01,
    9.887568e-01, 9.887679e-01, 9.887790e-01, 9.887901e-01, 9.888012e-01, 9.888123e-01,
    9.888234e-01, 9.888344e-01, 9.888455e-01, 9.888566e-01, 9.888678e-01, 9.888788e-01,
    9.888899e-01, 9.889010e-01, 9.889121e-01, 9.889232e-01, 9.889343e-01, 9.889454e-01,
    9.889565e-01, 9.889676e-01, 9.889787e-01, 9.889898e-01, 9.890009e-01, 9.890119e-01,
    9.890230e-01, 9.890341e-01, 9.890452e-01, 9.890562e-01, 9.890673e-01, 9.890784e-01,
    9.890895e-01, 9.891006e-01, 9.891117e-01, 9.891228e-01, 9.891339e-01, 9.891450e-01,
    9.891561e-01, 9.891672e-01, 9.891782e-01, 9.891893e-01, 9.892004e-01, 9.892115e-01,
    9.892226e-01, 9.892337e-01, 9.892448e-01, 9.892559e-01, 9.892670e-01, 9.892781e-01,
    9.892892e-01, 9.893003e-01, 9.893113e-01, 9.893225e-01, 9.893336e-01, 9.893445e-01,
    9.893556e-01, 9.893668e-01, 9.893779e-01, 9.893889e-01, 9.894000e-01, 9.894111e-01,
    9.894222e-01, 9.894333e-01, 9.894444e-01, 9.894555e-01, 9.894666e-01, 9.894777e-01,
    9.894888e-01, 9.894999e-01, 9.895110e-01, 9.895220e-01, 9.895331e-01, 9.895442e-01,
    9.895552e-01, 9.895663e-01, 9.895774e-01, 9.895885e-01, 9.895996e-01, 9.896107e-01,
    9.896218e-01, 9.896329e-01, 9.896440e-01, 9.896551e-01, 9.896662e-01, 9.896773e-01,
    9.896883e-01, 9.896994e-01, 9.897105e-01, 9.897215e-01, 9.897326e-01, 9.897437e-01,
    9.897548e-01, 9.897659e-01, 9.897770e-01, 9.897881e-01, 9.897992e-01, 9.898102e-01,
    9.898213e-01, 9.898324e-01, 9.898435e-01, 9.898546e-01, 9.898657e-01, 9.898767e-01,
    9.898878e-01, 9.898989e-01, 9.899100e-01, 9.899212e-01, 9.899321e-01, 9.899432e-01,
    9.899543e-01, 9.899654e-01, 9.899765e-01, 9.899876e-01, 9.899987e-01, 9.900098e-01,
    9.900209e-01, 9.900319e-01, 9.900430e-01, 9.900541e-01, 9.900652e-01, 9.900762e-01,
    9.900873e-01, 9.900984e-01, 9.901096e-01, 9.901205e-01, 9.901316e-01, 9.901427e-01,
    9.901538e-01, 9.901649e-01, 9.901760e-01, 9.901871e-01, 9.901982e-01, 9.902092e-01,
    9.902203e-01, 9.902314e-01, 9.902425e-01, 9.902536e-01, 9.902647e-01, 9.902757e-01,
    9.902868e-01, 9.902979e-01, 9.903089e-01, 9.903200e-01, 9.903311e-01, 9.903422e-01,
    9.903533e-01, 9.903644e-01, 9.903754e-01, 9.903865e-01, 9.903976e-01, 9.904087e-01,
    9.904198e-01, 9.904309e-01, 9.904420e-01, 9.904530e-01, 9.904641e-01, 9.904752e-01,
    9.904863e-01, 9.904974e-01, 9.905084e-01, 9.905195e-01, 9.905306e-01, 9.905416e-01,
    9.905527e-01, 9.905638e-01, 9.905749e-01, 9.905860e-01, 9.905970e-01, 9.906081e-01,
    9.906192e-01, 9.906303e-01, 9.906414e-01, 9.906525e-01, 9.906635e-01, 9.906746e-01,
    9.906857e-01, 9.906968e-01, 9.907079e-01, 9.907190e-01, 9.907300e-01, 9.907411e-01,
    9.907522e-01, 9.907632e-01, 9.907743e-01, 9.907854e-01, 9.907964e-01, 9.908075e-01,
    9.908186e-01, 9.908297e-01, 9.908408e-01, 9.908518e-01, 9.908629e-01, 9.908740e-01,
    9.908851e-01, 9.908962e-01, 9.909072e-01, 9.909183e-01, 9.909294e-01, 9.909405e-01,
    9.909515e-01, 9.909626e-01, 9.909737e-01, 9.909847e-01, 9.909958e-01, 9.910070e-01,
    9.910179e-01, 9.910290e-01, 9.910401e-01, 9.910512e-01, 9.910623e-01, 9.910733e-01,
    9.910844e-01, 9.910955e-01, 9.911066e-01, 9.911177e-01, 9.911287e-01, 9.911398e-01,
    9.911509e-01, 9.911620e-01, 9.911731e-01, 9.911841e-01, 9.911952e-01, 9.912063e-01,
    9.912174e-01, 9.912283e-01, 9.912395e-01, 9.912506e-01, 9.912617e-01, 9.912727e-01,
    9.912838e-01, 9.912949e-01, 9.913059e-01, 9.913170e-01, 9.913281e-01, 9.913391e-01,
    9.913502e-01, 9.913613e-01, 9.913724e-01, 9.913834e-01, 9.913945e-01, 9.914056e-01,
    9.914167e-01, 9.914277e-01, 9.914388e-01, 9.914499e-01, 9.914610e-01, 9.914720e-01,
    9.914831e-01, 9.914942e-01, 9.915053e-01, 9.915163e-01, 9.915274e-01, 9.915385e-01,
    9.915496e-01, 9.915606e-01, 9.915717e-01, 9.915828e-01, 9.915938e-01, 9.916049e-01,
    9.916160e-01, 9.916270e-01, 9.916381e-01, 9.916492e-01, 9.916602e-01, 9.916713e-01,
    9.916824e-01, 9.916934e-01, 9.917045e-01, 9.917156e-01, 9.917267e-01, 9.917377e-01,
    9.917488e-01, 9.917599e-01, 9.917710e-01, 9.917820e-01, 9.917931e-01, 9.918042e-01,
    9.918151e-01, 9.918263e-01, 9.918374e-01, 9.918485e-01, 9.918594e-01, 9.918705e-01,
    9.918817e-01, 9.918928e-01, 9.919037e-01, 9.919148e-01, 9.919260e-01, 9.919369e-01,
    9.919480e-01, 9.919591e-01, 9.919702e-01, 9.919812e-01, 9.919923e-01, 9.920034e-01,
    9.920144e-01, 9.920255e-01, 9.920366e-01, 9.920477e-01, 9.920587e-01, 9.920698e-01,
    9.920809e-01, 9.920919e-01, 9.921030e-01, 9.921141e-01, 9.921251e-01, 9.921362e-01,
    9.921473e-01, 9.921584e-01, 9.921694e-01, 9.921805e-01, 9.921916e-01, 9.922026e-01,
    9.922137e-01, 9.922248e-01, 9.922358e-01, 9.922469e-01, 9.922580e-01, 9.922690e-01,
    9.922801e-01, 9.922912e-01, 9.923022e-01, 9.923132e-01, 9.923244e-01, 9.923354e-01,
    9.923464e-01, 9.923575e-01, 9.923686e-01, 9.923796e-01, 9.923907e-01, 9.924018e-01,
    9.924128e-01, 9.924239e-01, 9.924350e-01, 9.924460e-01, 9.924571e-01, 9.924682e-01,
    9.924792e-01, 9.924903e-01, 9.925014e-01, 9.925124e-01, 9.925235e-01, 9.925346e-01,
    9.925456e-01, 9.925567e-01, 9.925678e-01, 9.925788e-01, 9.925899e-01, 9.926010e-01,
    9.926119e-01, 9.926231e-01, 9.926342e-01, 9.926451e-01, 9.926562e-01, 9.926674e-01,
    9.926783e-01, 9.926894e-01, 9.927005e-01, 9.927115e-01, 9.927226e-01, 9.927337e-01,
    9.927447e-01, 9.927558e-01, 9.927669e-01, 9.927779e-01, 9.927890e-01, 9.928001e-01,
    9.928111e-01, 9.928222e-01, 9.928332e-01, 9.928443e-01, 9.928554e-01, 9.928664e-01,
    9.928775e-01, 9.928885e-01, 9.928996e-01, 9.929107e-01, 9.929217e-01, 9.929328e-01,
    9.929439e-01, 9.929549e-01, 9.929660e-01, 9.929771e-01, 9.929881e-01, 9.929992e-01,
    9.930102e-01, 9.930213e-01, 9.930324e-01, 9.930434e-01, 9.930545e-01, 9.930655e-01,
    9.930766e-01, 9.930876e-01, 9.930987e-01, 9.931098e-01, 9.931208e-01, 9.931319e-01,
    9.931430e-01, 9.931540e-01, 9.931651e-01, 9.931762e-01, 9.931872e-01, 9.931983e-01,
    9.932092e-01, 9.932203e-01, 9.932315e-01, 9.932424e-01, 9.932535e-01, 9.932646e-01,
    9.932756e-01, 9.932867e-01, 9.932978e-01, 9.933088e-01, 9.933199e-01, 9.933310e-01,
    9.933420e-01, 9.933531e-01, 9.933642e-01, 9.933751e-01, 9.933862e-01, 9.933974e-01,
    9.934083e-01, 9.934194e-01, 9.934304e-01, 9.934415e-01, 9.934525e-01, 9.934636e-01,
    9.934747e-01, 9.934857e-01, 9.934968e-01, 9.935078e-01, 9.935189e-01, 9.935300e-01,
    9.935410e-01, 9.935521e-01, 9.935631e-01, 9.935742e-01, 9.935852e-01, 9.935963e-01,
    9.936074e-01, 9.936184e-01, 9.936295e-01, 9.936405e-01, 9.936516e-01, 9.936626e-01,
    9.936737e-01, 9.936847e-01, 9.936958e-01, 9.937069e-01, 9.937179e-01, 9.937290e-01,
    9.937400e-01, 9.937511e-01, 9.937621e-01, 9.937732e-01, 9.937842e-01, 9.937953e-01,
    9.938064e-01, 9.938174e-01, 9.938285e-01, 9.938395e-01, 9.938506e-01, 9.938616e-01,
    9.938727e-01, 9.938837e-01, 9.938948e-01, 9.939058e-01, 9.939169e-01, 9.939280e-01,
    9.939390e-01, 9.939501e-01, 9.939611e-01, 9.939722e-01, 9.939832e-01, 9.939943e-01,
    9.940053e-01, 9.940164e-01, 9.940274e-01, 9.940385e-01, 9.940495e-01, 9.940606e-01,
    9.940717e-01, 9.940827e-01, 9.940938e-01, 9.941048e-01, 9.941159e-01, 9.941269e-01,
    9.941379e-01, 9.941490e-01, 9.941601e-01, 9.941711e-01, 9.941822e-01, 9.941932e-01,
    9.942043e-01, 9.942153e-01, 9.942264e-01, 9.942374e-01, 9.942484e-01, 9.942595e-01,
    9.942706e-01, 9.942816e-01, 9.942927e-01, 9.943037e-01, 9.943148e-01, 9.943258e-01,
    9.943368e-01, 9.943479e-01, 9.943590e-01, 9.943700e-01, 9.943811e-01, 9.943921e-01,
    9.944032e-01, 9.944142e-01, 9.944253e-01, 9.944363e-01, 9.944474e-01, 9.944584e-01,
    9.944695e-01, 9.944805e-01, 9.944916e-01, 9.945026e-01, 9.945137e-01, 9.945247e-01,
    9.945357e-01, 9.945468e-01, 9.945579e-01, 9.945689e-01, 9.945800e-01, 9.945910e-01,
    9.946021e-01, 9.946131e-01, 9.946241e-01, 9.946352e-01, 9.946463e-01, 9.946573e-01,
    9.946684e-01, 9.946794e-01, 9.946904e-01, 9.947014e-01, 9.947125e-01, 9.947236e-01,
    9.947346e-01, 9.947457e-01, 9.947567e-01, 9.947678e-01, 9.947788e-01, 9.947899e-01,
    9.948009e-01, 9.948120e-01, 9.948230e-01, 9.948341e-01, 9.948451e-01, 9.948561e-01,
    9.948672e-01, 9.948782e-01, 9.948893e-01, 9.949003e-01, 9.949114e-01, 9.949224e-01,
    9.949335e-01, 9.949445e-01, 9.949556e-01, 9.949666e-01, 9.949776e-01, 9.949887e-01,
    9.949997e-01, 9.950108e-01, 9.950218e-01, 9.950329e-01, 9.950439e-01, 9.950550e-01,
    9.950660e-01, 9.950770e-01, 9.950881e-01, 9.950991e-01, 9.951102e-01, 9.951212e-01,
    9.951323e-01, 9.951433e-01, 9.951543e-01, 9.951654e-01, 9.951764e-01, 9.951875e-01,
    9.951985e-01, 9.952096e-01, 9.952206e-01, 9.952316e-01, 9.952427e-01, 9.952537e-01,
    9.952648e-01, 9.952758e-01, 9.952869e-01, 9.952979e-01, 9.953089e-01, 9.953200e-01,
    9.953310e-01, 9.953421e-01, 9.953531e-01, 9.953641e-01, 9.953752e-01, 9.953862e-01,
    9.953973e-01, 9.954083e-01, 9.954193e-01, 9.954304e-01, 9.954414e-01, 9.954525e-01,
    9.954636e-01, 9.954746e-01, 9.954856e-01, 9.954966e-01, 9.955077e-01, 9.955187e-01,
    9.955298e-01, 9.955409e-01, 9.955518e-01, 9.955629e-01, 9.955739e-01, 9.955850e-01,
    9.955961e-01, 9.956070e-01, 9.956182e-01, 9.956291e-01, 9.956402e-01, 9.956512e-01,
    9.956623e-01, 9.956734e-01, 9.956843e-01, 9.956954e-01, 9.957064e-01, 9.957175e-01,
    9.957286e-01, 9.957396e-01, 9.957505e-01, 9.957616e-01, 9.957727e-01, 9.957837e-01,
    9.957948e-01, 9.958058e-01, 9.958169e-01, 9.958279e-01, 9.958389e-01, 9.958500e-01,
    9.958610e-01, 9.958720e-01, 9.958831e-01, 9.958941e-01, 9.959051e-01, 9.959162e-01,
    9.959272e-01, 9.959383e-01, 9.959493e-01, 9.959603e-01, 9.959714e-01, 9.959824e-01,
    9.959934e-01, 9.960045e-01, 9.960155e-01, 9.960265e-01, 9.960376e-01, 9.960486e-01,
    9.960596e-01, 9.960707e-01, 9.960817e-01, 9.960927e-01, 9.961038e-01, 9.961149e-01,
    9.961259e-01, 9.961369e-01, 9.961479e-01, 9.961590e-01, 9.961700e-01, 9.961810e-01,
    9.961922e-01, 9.962031e-01, 9.962142e-01, 9.962252e-01, 9.962363e-01, 9.962472e-01,
    9.962583e-01, 9.962693e-01, 9.962804e-01, 9.962915e-01, 9.963025e-01, 9.963135e-01,
    9.963245e-01, 9.963356e-01, 9.963466e-01, 9.963577e-01, 9.963686e-01, 9.963797e-01,
    9.963908e-01, 9.964018e-01, 9.964128e-01, 9.964238e-01, 9.964349e-01, 9.964459e-01,
    9.964569e-01, 9.964680e-01, 9.964790e-01, 9.964900e-01, 9.965011e-01, 9.965121e-01,
    9.965231e-01, 9.965342e-01, 9.965452e-01, 9.965562e-01, 9.965673e-01, 9.965783e-01,
    9.965893e-01, 9.966003e-01, 9.966114e-01, 9.966224e-01, 9.966334e-01, 9.966446e-01,
    9.966555e-01, 9.966666e-01, 9.966776e-01, 9.966887e-01, 9.966996e-01, 9.967107e-01,
    9.967217e-01, 9.967328e-01, 9.967437e-01, 9.967549e-01, 9.967659e-01, 9.967769e-01,
    9.967879e-01, 9.967990e-01, 9.968100e-01, 9.968210e-01, 9.968321e-01, 9.968431e-01,
    9.968541e-01, 9.968651e-01, 9.968762e-01, 9.968872e-01, 9.968982e-01, 9.969092e-01,
    9.969203e-01, 9.969313e-01, 9.969423e-01, 9.969534e-01, 9.969644e-01, 9.969754e-01,
    9.969864e-01, 9.969975e-01, 9.970086e-01, 9.970195e-01, 9.970306e-01, 9.970416e-01,
    9.970527e-01, 9.970636e-01, 9.970747e-01, 9.970858e-01, 9.970968e-01, 9.971077e-01,
    9.971189e-01, 9.971299e-01, 9.971409e-01, 9.971519e-01, 9.971630e-01, 9.971740e-01,
    9.971850e-01, 9.971960e-01, 9.972071e-01, 9.972181e-01, 9.972291e-01, 9.972401e-01,
    9.972512e-01, 9.972622e-01, 9.972732e-01, 9.972842e-01, 9.972953e-01, 9.973063e-01,
    9.973173e-01, 9.973283e-01, 9.973394e-01, 9.973505e-01, 9.973614e-01, 9.973724e-01,
    9.973835e-01, 9.973946e-01, 9.974055e-01, 9.974166e-01, 9.974276e-01, 9.974387e-01,
    9.974497e-01, 9.974607e-01, 9.974717e-01, 9.974827e-01, 9.974938e-01, 9.975048e-01,
    9.975158e-01, 9.975268e-01, 9.975379e-01, 9.975489e-01, 9.975599e-01, 9.975709e-01,
    9.975819e-01, 9.975930e-01, 9.976040e-01, 9.976150e-01, 9.976261e-01, 9.976370e-01,
    9.976481e-01, 9.976591e-01, 9.976702e-01, 9.976811e-01, 9.976922e-01, 9.977033e-01,
    9.977143e-01, 9.977252e-01, 9.977363e-01, 9.977474e-01, 9.977584e-01, 9.977694e-01,
    9.977804e-01, 9.977914e-01, 9.978025e-01, 9.978135e-01, 9.978245e-01, 9.978355e-01,
    9.978465e-01, 9.978575e-01, 9.978686e-01, 9.978796e-01, 9.978907e-01, 9.979016e-01,
    9.979126e-01, 9.979237e-01, 9.979348e-01, 9.979457e-01, 9.979568e-01, 9.979678e-01,
    9.979789e-01, 9.979899e-01, 9.980009e-01, 9.980119e-01, 9.980229e-01, 9.980339e-01,
    9.980450e-01, 9.980560e-01, 9.980670e-01, 9.980780e-01, 9.980890e-01, 9.981000e-01,
    9.981111e-01, 9.981221e-01, 9.981331e-01, 9.981441e-01, 9.981551e-01, 9.981661e-01,
    9.981772e-01, 9.981883e-01, 9.981993e-01, 9.982103e-01, 9.982213e-01, 9.982323e-01,
    9.982434e-01, 9.982544e-01, 9.982654e-01, 9.982764e-01, 9.982874e-01, 9.982984e-01,
    9.983094e-01, 9.983205e-01, 9.983315e-01, 9.983425e-01, 9.983535e-01, 9.983645e-01,
    9.983755e-01, 9.983866e-01, 9.983976e-01, 9.984086e-01, 9.984196e-01, 9.984307e-01,
    9.984416e-01, 9.984527e-01, 9.984637e-01, 9.984748e-01, 9.984858e-01, 9.984968e-01,
    9.985078e-01, 9.985188e-01, 9.985298e-01, 9.985408e-01, 9.985519e-01, 9.985629e-01,
    9.985739e-01, 9.985849e-01, 9.985960e-01, 9.986069e-01, 9.986179e-01, 9.986290e-01,
    9.986401e-01, 9.986510e-01, 9.986621e-01, 9.986731e-01, 9.986840e-01, 9.986951e-01,
    9.987061e-01, 9.987171e-01, 9.987281e-01, 9.987392e-01, 9.987502e-01, 9.987612e-01,
    9.987722e-01, 9.987832e-01, 9.987943e-01, 9.988052e-01, 9.988163e-01, 9.988273e-01,
    9.988384e-01, 9.988493e-01, 9.988604e-01, 9.988714e-01, 9.988824e-01, 9.988934e-01,
    9.989044e-01, 9.989154e-01, 9.989264e-01, 9.989374e-01, 9.989485e-01, 9.989595e-01,
    9.989705e-01, 9.989815e-01, 9.989925e-01, 9.990035e-01, 9.990146e-01, 9.990255e-01,
    9.990366e-01, 9.990476e-01, 9.990585e-01, 9.990696e-01, 9.990807e-01, 9.990917e-01,
    9.991027e-01, 9.991137e-01, 9.991247e-01, 9.991357e-01, 9.991467e-01, 9.991577e-01,
    9.991687e-01, 9.991797e-01, 9.991907e-01, 9.992017e-01, 9.992127e-01, 9.992238e-01,
    9.992349e-01, 9.992459e-01, 9.992568e-01, 9.992679e-01, 9.992789e-01, 9.992899e-01,
    9.993009e-01, 9.993119e-01, 9.993229e-01, 9.993339e-01, 9.993449e-01, 9.993559e-01,
    9.993669e-01, 9.993780e-01, 9.993889e-01, 9.994000e-01, 9.994110e-01, 9.994221e-01,
    9.994330e-01, 9.994441e-01, 9.994551e-01, 9.994661e-01, 9.994771e-01, 9.994881e-01,
    9.994991e-01, 9.995101e-01, 9.995211e-01, 9.995321e-01, 9.995431e-01, 9.995542e-01,
    9.995651e-01, 9.995762e-01, 9.995872e-01, 9.995981e-01, 9.996092e-01, 9.996202e-01,
    9.996312e-01, 9.996422e-01, 9.996532e-01, 9.996643e-01, 9.996753e-01, 9.996863e-01,
    9.996973e-01, 9.997083e-01, 9.997193e-01, 9.997303e-01, 9.997413e-01, 9.997523e-01,
    9.997634e-01, 9.997743e-01, 9.997854e-01, 9.997964e-01, 9.998074e-01, 9.998184e-01,
    9.998294e-01, 9.998404e-01, 9.998514e-01, 9.998624e-01, 9.998734e-01, 9.998844e-01,
    9.998955e-01, 9.999064e-01, 9.999174e-01, 9.999285e-01, 9.999394e-01, 9.999505e-01,
    9.999615e-01, 9.999725e-01, 9.999835e-01, 9.999945e-01,
};

/* fast pow lookup table, precision 16, size 65536 */
const uint32_t fast_pow_precision    = 16;
const uint32_t fast_pow_table_size   = 65536;
const uint32_t fast_pow_table[65536] = {
    44,      133,     222,     311,     399,     488,     577,     665,     754,     843,
    932,     1020,    1109,    1198,    1287,    1375,    1464,    1553,    1642,    1730,
    1819,    1908,    1997,    2085,    2174,    2263,    2351,    2440,    2529,    2618,
    2706,    2795,    2884,    2973,    3061,    3150,    3239,    3328,    3417,    3505,
    3594,    3683,    3772,    3860,    3949,    4038,    4127,    4215,    4304,    4393,
    4482,    4570,    4659,    4748,    4837,    4926,    5014,    5103,    5192,    5281,
    5369,    5458,    5547,    5636,    5725,    5813,    5902,    5991,    6080,    6169,
    6257,    6346,    6435,    6524,    6612,    6701,    6790,    6879,    6968,    7056,
    7145,    7234,    7323,    7412,    7500,    7589,    7678,    7767,    7856,    7944,
    8033,    8122,    8211,    8300,    8388,    8477,    8566,    8655,    8744,    8833,
    8921,    9010,    9099,    9188,    9277,    9365,    9454,    9543,    9632,    9721,
    9810,    9898,    9987,    10076,   10165,   10254,   10343,   10431,   10520,   10609,
    10698,   10787,   10876,   10964,   11053,   11142,   11231,   11320,   11409,   11497,
    11586,   11675,   11764,   11853,   11942,   12031,   12119,   12208,   12297,   12386,
    12475,   12564,   12653,   12741,   12830,   12919,   13008,   13097,   13186,   13275,
    13363,   13452,   13541,   13630,   13719,   13808,   13897,   13985,   14074,   14163,
    14252,   14341,   14430,   14519,   14608,   14696,   14785,   14874,   14963,   15052,
    15141,   15230,   15319,   15408,   15496,   15585,   15674,   15763,   15852,   15941,
    16030,   16119,   16208,   16296,   16385,   16474,   16563,   16652,   16741,   16830,
    16919,   17008,   17097,   17185,   17274,   17363,   17452,   17541,   17630,   17719,
    17808,   17897,   17986,   18075,   18163,   18252,   18341,   18430,   18519,   18608,
    18697,   18786,   18875,   18964,   19053,   19142,   19231,   19319,   19408,   19497,
    19586,   19675,   19764,   19853,   19942,   20031,   20120,   20209,   20298,   20387,
    20476,   20565,   20653,   20742,   20831,   20920,   21009,   21098,   21187,   21276,
    21365,   21454,   21543,   21632,   21721,   21810,   21899,   21988,   22077,   22166,
    22255,   22343,   22432,   22521,   22610,   22699,   22788,   22877,   22966,   23055,
    23144,   23233,   23322,   23411,   23500,   23589,   23678,   23767,   23856,   23945,
    24034,   24123,   24212,   24301,   24390,   24479,   24568,   24657,   24746,   24835,
    24924,   25013,   25102,   25191,   25280,   25369,   25458,   25547,   25636,   25725,
    25814,   25903,   25992,   26081,   26170,   26259,   26348,   26437,   26526,   26615,
    26704,   26793,   26882,   26971,   27060,   27149,   27238,   27327,   27416,   27505,
    27594,   27683,   27772,   27861,   27950,   28039,   28128,   28217,   28306,   28395,
    28484,   28573,   28662,   28751,   28840,   28929,   29018,   29107,   29196,   29285,
    29374,   29463,   29552,   29641,   29730,   29819,   29908,   29997,   30087,   30176,
    30265,   30354,   30443,   30532,   30621,   30710,   30799,   30888,   30977,   31066,
    31155,   31244,   31333,   31422,   31511,   31600,   31689,   31778,   31868,   31957,
    32046,   32135,   32224,   32313,   32402,   32491,   32580,   32669,   32758,   32847,
    32936,   33025,   33114,   33204,   33293,   33382,   33471,   33560,   33649,   33738,
    33827,   33916,   34005,   34094,   34183,   34272,   34362,   34451,   34540,   34629,
    34718,   34807,   34896,   34985,   35074,   35163,   35252,   35342,   35431,   35520,
    35609,   35698,   35787,   35876,   35965,   36054,   36143,   36233,   36322,   36411,
    36500,   36589,   36678,   36767,   36856,   36945,   37035,   37124,   37213,   37302,
    37391,   37480,   37569,   37658,   37748,   37837,   37926,   38015,   38104,   38193,
    38282,   38371,   38461,   38550,   38639,   38728,   38817,   38906,   38995,   39084,
    39174,   39263,   39352,   39441,   39530,   39619,   39708,   39798,   39887,   39976,
    40065,   40154,   40243,   40332,   40422,   40511,   40600,   40689,   40778,   40867,
    40957,   41046,   41135,   41224,   41313,   41402,   41491,   41581,   41670,   41759,
    41848,   41937,   42026,   42116,   42205,   42294,   42383,   42472,   42561,   42651,
    42740,   42829,   42918,   43007,   43097,   43186,   43275,   43364,   43453,   43542,
    43632,   43721,   43810,   43899,   43988,   44078,   44167,   44256,   44345,   44434,
    44524,   44613,   44702,   44791,   44880,   44970,   45059,   45148,   45237,   45326,
    45416,   45505,   45594,   45683,   45772,   45862,   45951,   46040,   46129,   46218,
    46308,   46397,   46486,   46575,   46664,   46754,   46843,   46932,   47021,   47111,
    47200,   47289,   47378,   47467,   47557,   47646,   47735,   47824,   47914,   48003,
    48092,   48181,   48270,   48360,   48449,   48538,   48627,   48717,   48806,   48895,
    48984,   49074,   49163,   49252,   49341,   49431,   49520,   49609,   49698,   49788,
    49877,   49966,   50055,   50145,   50234,   50323,   50412,   50502,   50591,   50680,
    50769,   50859,   50948,   51037,   51126,   51216,   51305,   51394,   51484,   51573,
    51662,   51751,   51841,   51930,   52019,   52108,   52198,   52287,   52376,   52466,
    52555,   52644,   52733,   52823,   52912,   53001,   53090,   53180,   53269,   53358,
    53448,   53537,   53626,   53715,   53805,   53894,   53983,   54073,   54162,   54251,
    54341,   54430,   54519,   54608,   54698,   54787,   54876,   54966,   55055,   55144,
    55234,   55323,   55412,   55501,   55591,   55680,   55769,   55859,   55948,   56037,
    56127,   56216,   56305,   56395,   56484,   56573,   56663,   56752,   56841,   56931,
    57020,   57109,   57199,   57288,   57377,   57467,   57556,   57645,   57735,   57824,
    57913,   58003,   58092,   58181,   58271,   58360,   58449,   58539,   58628,   58717,
    58807,   58896,   58985,   59075,   59164,   59253,   59343,   59432,   59521,   59611,
    59700,   59789,   59879,   59968,   60058,   60147,   60236,   60326,   60415,   60504,
    60594,   60683,   60772,   60862,   60951,   61041,   61130,   61219,   61309,   61398,
    61487,   61577,   61666,   61755,   61845,   61934,   62024,   62113,   62202,   62292,
    62381,   62471,   62560,   62649,   62739,   62828,   62917,   63007,   63096,   63186,
    63275,   63364,   63454,   63543,   63633,   63722,   63811,   63901,   63990,   64080,
    64169,   64258,   64348,   64437,   64527,   64616,   64705,   64795,   64884,   64974,
    65063,   65152,   65242,   65331,   65421,   65510,   65600,   65689,   65778,   65868,
    65957,   66047,   66136,   66225,   66315,   66404,   66494,   66583,   66673,   66762,
    66851,   66941,   67030,   67120,   67209,   67299,   67388,   67477,   67567,   67656,
    67746,   67835,   67925,   68014,   68104,   68193,   68282,   68372,   68461,   68551,
    68640,   68730,   68819,   68909,   68998,   69088,   69177,   69266,   69356,   69445,
    69535,   69624,   69714,   69803,   69893,   69982,   70072,   70161,   70250,   70340,
    70429,   70519,   70608,   70698,   70787,   70877,   70966,   71056,   71145,   71235,
    71324,   71414,   71503,   71593,   71682,   71772,   71861,   71951,   72040,   72129,
    72219,   72308,   72398,   72487,   72577,   72666,   72756,   72845,   72935,   73024,
    73114,   73203,   73293,   73382,   73472,   73561,   73651,   73740,   73830,   73919,
    74009,   74098,   74188,   74277,   74367,   74456,   74546,   74635,   74725,   74814,
    74904,   74994,   75083,   75173,   75262,   75352,   75441,   75531,   75620,   75710,
    75799,   75889,   75978,   76068,   76157,   76247,   76336,   76426,   76515,   76605,
    76694,   76784,   76874,   76963,   77053,   77142,   77232,   77321,   77411,   77500,
    77590,   77679,   77769,   77858,   77948,   78038,   78127,   78217,   78306,   78396,
    78485,   78575,   78664,   78754,   78844,   78933,   79023,   79112,   79202,   79291,
    79381,   79470,   79560,   79650,   79739,   79829,   79918,   80008,   80097,   80187,
    80277,   80366,   80456,   80545,   80635,   80724,   80814,   80904,   80993,   81083,
    81172,   81262,   81352,   81441,   81531,   81620,   81710,   81799,   81889,   81979,
    82068,   82158,   82247,   82337,   82427,   82516,   82606,   82695,   82785,   82875,
    82964,   83054,   83143,   83233,   83323,   83412,   83502,   83591,   83681,   83771,
    83860,   83950,   84039,   84129,   84219,   84308,   84398,   84488,   84577,   84667,
    84756,   84846,   84936,   85025,   85115,   85204,   85294,   85384,   85473,   85563,
    85653,   85742,   85832,   85922,   86011,   86101,   86190,   86280,   86370,   86459,
    86549,   86639,   86728,   86818,   86908,   86997,   87087,   87176,   87266,   87356,
    87445,   87535,   87625,   87714,   87804,   87894,   87983,   88073,   88163,   88252,
    88342,   88432,   88521,   88611,   88701,   88790,   88880,   88970,   89059,   89149,
    89239,   89328,   89418,   89508,   89597,   89687,   89777,   89866,   89956,   90046,
    90135,   90225,   90315,   90404,   90494,   90584,   90673,   90763,   90853,   90942,
    91032,   91122,   91211,   91301,   91391,   91480,   91570,   91660,   91750,   91839,
    91929,   92019,   92108,   92198,   92288,   92377,   92467,   92557,   92647,   92736,
    92826,   92916,   93005,   93095,   93185,   93274,   93364,   93454,   93544,   93633,
    93723,   93813,   93902,   93992,   94082,   94172,   94261,   94351,   94441,   94531,
    94620,   94710,   94800,   94889,   94979,   95069,   95159,   95248,   95338,   95428,
    95518,   95607,   95697,   95787,   95876,   95966,   96056,   96146,   96235,   96325,
    96415,   96505,   96594,   96684,   96774,   96864,   96953,   97043,   97133,   97223,
    97312,   97402,   97492,   97582,   97671,   97761,   97851,   97941,   98030,   98120,
    98210,   98300,   98389,   98479,   98569,   98659,   98749,   98838,   98928,   99018,
    99108,   99197,   99287,   99377,   99467,   99556,   99646,   99736,   99826,   99916,
    100005,  100095,  100185,  100275,  100364,  100454,  100544,  100634,  100724,  100813,
    100903,  100993,  101083,  101173,  101262,  101352,  101442,  101532,  101622,  101711,
    101801,  101891,  101981,  102071,  102160,  102250,  102340,  102430,  102520,  102609,
    102699,  102789,  102879,  102969,  103058,  103148,  103238,  103328,  103418,  103508,
    103597,  103687,  103777,  103867,  103957,  104046,  104136,  104226,  104316,  104406,
    104496,  104585,  104675,  104765,  104855,  104945,  105035,  105124,  105214,  105304,
    105394,  105484,  105574,  105663,  105753,  105843,  105933,  106023,  106113,  106202,
    106292,  106382,  106472,  106562,  106652,  106742,  106831,  106921,  107011,  107101,
    107191,  107281,  107371,  107460,  107550,  107640,  107730,  107820,  107910,  108000,
    108089,  108179,  108269,  108359,  108449,  108539,  108629,  108719,  108808,  108898,
    108988,  109078,  109168,  109258,  109348,  109438,  109527,  109617,  109707,  109797,
    109887,  109977,  110067,  110157,  110247,  110336,  110426,  110516,  110606,  110696,
    110786,  110876,  110966,  111056,  111145,  111235,  111325,  111415,  111505,  111595,
    111685,  111775,  111865,  111955,  112044,  112134,  112224,  112314,  112404,  112494,
    112584,  112674,  112764,  112854,  112944,  113034,  113123,  113213,  113303,  113393,
    113483,  113573,  113663,  113753,  113843,  113933,  114023,  114113,  114203,  114292,
    114382,  114472,  114562,  114652,  114742,  114832,  114922,  115012,  115102,  115192,
    115282,  115372,  115462,  115552,  115642,  115732,  115821,  115911,  116001,  116091,
    116181,  116271,  116361,  116451,  116541,  116631,  116721,  116811,  116901,  116991,
    117081,  117171,  117261,  117351,  117441,  117531,  117621,  117711,  117801,  117891,
    117980,  118070,  118160,  118250,  118340,  118430,  118520,  118610,  118700,  118790,
    118880,  118970,  119060,  119150,  119240,  119330,  119420,  119510,  119600,  119690,
    119780,  119870,  119960,  120050,  120140,  120230,  120320,  120410,  120500,  120590,
    120680,  120770,  120860,  120950,  121040,  121130,  121220,  121310,  121400,  121490,
    121580,  121670,  121760,  121850,  121940,  122030,  122120,  122210,  122300,  122390,
    122480,  122570,  122660,  122750,  122840,  122930,  123020,  123110,  123200,  123290,
    123380,  123470,  123560,  123651,  123741,  123831,  123921,  124011,  124101,  124191,
    124281,  124371,  124461,  124551,  124641,  124731,  124821,  124911,  125001,  125091,
    125181,  125271,  125361,  125451,  125541,  125631,  125721,  125812,  125902,  125992,
    126082,  126172,  126262,  126352,  126442,  126532,  126622,  126712,  126802,  126892,
    126982,  127072,  127162,  127252,  127343,  127433,  127523,  127613,  127703,  127793,
    127883,  127973,  128063,  128153,  128243,  128333,  128423,  128514,  128604,  128694,
    128784,  128874,  128964,  129054,  129144,  129234,  129324,  129414,  129505,  129595,
    129685,  129775,  129865,  129955,  130045,  130135,  130225,  130315,  130405,  130496,
    130586,  130676,  130766,  130856,  130946,  131036,  131126,  131216,  131307,  131397,
    131487,  131577,  131667,  131757,  131847,  131937,  132027,  132118,  132208,  132298,
    132388,  132478,  132568,  132658,  132748,  132839,  132929,  133019,  133109,  133199,
    133289,  133379,  133470,  133560,  133650,  133740,  133830,  133920,  134010,  134100,
    134191,  134281,  134371,  134461,  134551,  134641,  134731,  134822,  134912,  135002,
    135092,  135182,  135272,  135363,  135453,  135543,  135633,  135723,  135813,  135903,
    135994,  136084,  136174,  136264,  136354,  136444,  136535,  136625,  136715,  136805,
    136895,  136985,  137076,  137166,  137256,  137346,  137436,  137527,  137617,  137707,
    137797,  137887,  137977,  138068,  138158,  138248,  138338,  138428,  138519,  138609,
    138699,  138789,  138879,  138969,  139060,  139150,  139240,  139330,  139420,  139511,
    139601,  139691,  139781,  139871,  139962,  140052,  140142,  140232,  140322,  140413,
    140503,  140593,  140683,  140774,  140864,  140954,  141044,  141134,  141225,  141315,
    141405,  141495,  141585,  141676,  141766,  141856,  141946,  142037,  142127,  142217,
    142307,  142397,  142488,  142578,  142668,  142758,  142849,  142939,  143029,  143119,
    143210,  143300,  143390,  143480,  143571,  143661,  143751,  143841,  143932,  144022,
    144112,  144202,  144293,  144383,  144473,  144563,  144654,  144744,  144834,  144924,
    145015,  145105,  145195,  145285,  145376,  145466,  145556,  145646,  145737,  145827,
    145917,  146007,  146098,  146188,  146278,  146368,  146459,  146549,  146639,  146730,
    146820,  146910,  147000,  147091,  147181,  147271,  147362,  147452,  147542,  147632,
    147723,  147813,  147903,  147994,  148084,  148174,  148264,  148355,  148445,  148535,
    148626,  148716,  148806,  148896,  148987,  149077,  149167,  149258,  149348,  149438,
    149529,  149619,  149709,  149799,  149890,  149980,  150070,  150161,  150251,  150341,
    150432,  150522,  150612,  150703,  150793,  150883,  150974,  151064,  151154,  151245,
    151335,  151425,  151515,  151606,  151696,  151786,  151877,  151967,  152057,  152148,
    152238,  152328,  152419,  152509,  152599,  152690,  152780,  152870,  152961,  153051,
    153142,  153232,  153322,  153413,  153503,  153593,  153684,  153774,  153864,  153955,
    154045,  154135,  154226,  154316,  154406,  154497,  154587,  154677,  154768,  154858,
    154949,  155039,  155129,  155220,  155310,  155400,  155491,  155581,  155671,  155762,
    155852,  155943,  156033,  156123,  156214,  156304,  156394,  156485,  156575,  156666,
    156756,  156846,  156937,  157027,  157117,  157208,  157298,  157389,  157479,  157569,
    157660,  157750,  157841,  157931,  158021,  158112,  158202,  158293,  158383,  158473,
    158564,  158654,  158745,  158835,  158925,  159016,  159106,  159197,  159287,  159377,
    159468,  159558,  159649,  159739,  159829,  159920,  160010,  160101,  160191,  160282,
    160372,  160462,  160553,  160643,  160734,  160824,  160914,  161005,  161095,  161186,
    161276,  161367,  161457,  161547,  161638,  161728,  161819,  161909,  162000,  162090,
    162181,  162271,  162361,  162452,  162542,  162633,  162723,  162814,  162904,  162995,
    163085,  163175,  163266,  163356,  163447,  163537,  163628,  163718,  163809,  163899,
    163989,  164080,  164170,  164261,  164351,  164442,  164532,  164623,  164713,  164804,
    164894,  164985,  165075,  165166,  165256,  165346,  165437,  165527,  165618,  165708,
    165799,  165889,  165980,  166070,  166161,  166251,  166342,  166432,  166523,  166613,
    166704,  166794,  166885,  166975,  167066,  167156,  167247,  167337,  167428,  167518,
    167609,  167699,  167790,  167880,  167971,  168061,  168152,  168242,  168333,  168423,
    168514,  168604,  168695,  168785,  168876,  168966,  169057,  169147,  169238,  169328,
    169419,  169509,  169600,  169690,  169781,  169871,  169962,  170052,  170143,  170233,
    170324,  170414,  170505,  170595,  170686,  170776,  170867,  170958,  171048,  171139,
    171229,  171320,  171410,  171501,  171591,  171682,  171772,  171863,  171953,  172044,
    172135,  172225,  172316,  172406,  172497,  172587,  172678,  172768,  172859,  172949,
    173040,  173131,  173221,  173312,  173402,  173493,  173583,  173674,  173764,  173855,
    173946,  174036,  174127,  174217,  174308,  174398,  174489,  174580,  174670,  174761,
    174851,  174942,  175032,  175123,  175214,  175304,  175395,  175485,  175576,  175666,
    175757,  175848,  175938,  176029,  176119,  176210,  176301,  176391,  176482,  176572,
    176663,  176753,  176844,  176935,  177025,  177116,  177206,  177297,  177388,  177478,
    177569,  177659,  177750,  177841,  177931,  178022,  178112,  178203,  178294,  178384,
    178475,  178566,  178656,  178747,  178837,  178928,  179019,  179109,  179200,  179290,
    179381,  179472,  179562,  179653,  179744,  179834,  179925,  180015,  180106,  180197,
    180287,  180378,  180469,  180559,  180650,  180740,  180831,  180922,  181012,  181103,
    181194,  181284,  181375,  181466,  181556,  181647,  181738,  181828,  181919,  182009,
    182100,  182191,  182281,  182372,  182463,  182553,  182644,  182735,  182825,  182916,
    183007,  183097,  183188,  183279,  183369,  183460,  183551,  183641,  183732,  183823,
    183913,  184004,  184095,  184185,  184276,  184367,  184457,  184548,  184639,  184729,
    184820,  184911,  185001,  185092,  185183,  185273,  185364,  185455,  185545,  185636,
    185727,  185818,  185908,  185999,  186090,  186180,  186271,  186362,  186452,  186543,
    186634,  186724,  186815,  186906,  186997,  187087,  187178,  187269,  187359,  187450,
    187541,  187631,  187722,  187813,  187904,  187994,  188085,  188176,  188266,  188357,
    188448,  188539,  188629,  188720,  188811,  188901,  188992,  189083,  189174,  189264,
    189355,  189446,  189537,  189627,  189718,  189809,  189899,  189990,  190081,  190172,
    190262,  190353,  190444,  190535,  190625,  190716,  190807,  190898,  190988,  191079,
    191170,  191261,  191351,  191442,  191533,  191624,  191714,  191805,  191896,  191987,
    192077,  192168,  192259,  192350,  192440,  192531,  192622,  192713,  192803,  192894,
    192985,  193076,  193166,  193257,  193348,  193439,  193529,  193620,  193711,  193802,
    193893,  193983,  194074,  194165,  194256,  194346,  194437,  194528,  194619,  194710,
    194800,  194891,  194982,  195073,  195163,  195254,  195345,  195436,  195527,  195617,
    195708,  195799,  195890,  195981,  196071,  196162,  196253,  196344,  196435,  196525,
    196616,  196707,  196798,  196889,  196979,  197070,  197161,  197252,  197343,  197433,
    197524,  197615,  197706,  197797,  197888,  197978,  198069,  198160,  198251,  198342,
    198432,  198523,  198614,  198705,  198796,  198887,  198977,  199068,  199159,  199250,
    199341,  199432,  199522,  199613,  199704,  199795,  199886,  199977,  200067,  200158,
    200249,  200340,  200431,  200522,  200612,  200703,  200794,  200885,  200976,  201067,
    201158,  201248,  201339,  201430,  201521,  201612,  201703,  201793,  201884,  201975,
    202066,  202157,  202248,  202339,  202430,  202520,  202611,  202702,  202793,  202884,
    202975,  203066,  203156,  203247,  203338,  203429,  203520,  203611,  203702,  203793,
    203883,  203974,  204065,  204156,  204247,  204338,  204429,  204520,  204611,  204701,
    204792,  204883,  204974,  205065,  205156,  205247,  205338,  205429,  205519,  205610,
    205701,  205792,  205883,  205974,  206065,  206156,  206247,  206338,  206428,  206519,
    206610,  206701,  206792,  206883,  206974,  207065,  207156,  207247,  207338,  207428,
    207519,  207610,  207701,  207792,  207883,  207974,  208065,  208156,  208247,  208338,
    208429,  208520,  208610,  208701,  208792,  208883,  208974,  209065,  209156,  209247,
    209338,  209429,  209520,  209611,  209702,  209793,  209884,  209975,  210065,  210156,
    210247,  210338,  210429,  210520,  210611,  210702,  210793,  210884,  210975,  211066,
    211157,  211248,  211339,  211430,  211521,  211612,  211703,  211794,  211885,  211976,
    212066,  212157,  212248,  212339,  212430,  212521,  212612,  212703,  212794,  212885,
    212976,  213067,  213158,  213249,  213340,  213431,  213522,  213613,  213704,  213795,
    213886,  213977,  214068,  214159,  214250,  214341,  214432,  214523,  214614,  214705,
    214796,  214887,  214978,  215069,  215160,  215251,  215342,  215433,  215524,  215615,
    215706,  215797,  215888,  215979,  216070,  216161,  216252,  216343,  216434,  216525,
    216616,  216707,  216798,  216889,  216980,  217071,  217162,  217253,  217344,  217435,
    217526,  217617,  217708,  217799,  217890,  217981,  218072,  218163,  218254,  218345,
    218436,  218527,  218619,  218710,  218801,  218892,  218983,  219074,  219165,  219256,
    219347,  219438,  219529,  219620,  219711,  219802,  219893,  219984,  220075,  220166,
    220257,  220348,  220439,  220530,  220622,  220713,  220804,  220895,  220986,  221077,
    221168,  221259,  221350,  221441,  221532,  221623,  221714,  221805,  221896,  221987,
    222079,  222170,  222261,  222352,  222443,  222534,  222625,  222716,  222807,  222898,
    222989,  223080,  223171,  223263,  223354,  223445,  223536,  223627,  223718,  223809,
    223900,  223991,  224082,  224173,  224265,  224356,  224447,  224538,  224629,  224720,
    224811,  224902,  224993,  225084,  225176,  225267,  225358,  225449,  225540,  225631,
    225722,  225813,  225904,  225996,  226087,  226178,  226269,  226360,  226451,  226542,
    226633,  226724,  226816,  226907,  226998,  227089,  227180,  227271,  227362,  227453,
    227545,  227636,  227727,  227818,  227909,  228000,  228091,  228182,  228274,  228365,
    228456,  228547,  228638,  228729,  228820,  228912,  229003,  229094,  229185,  229276,
    229367,  229459,  229550,  229641,  229732,  229823,  229914,  230005,  230097,  230188,
    230279,  230370,  230461,  230552,  230644,  230735,  230826,  230917,  231008,  231099,
    231191,  231282,  231373,  231464,  231555,  231646,  231738,  231829,  231920,  232011,
    232102,  232193,  232285,  232376,  232467,  232558,  232649,  232741,  232832,  232923,
    233014,  233105,  233196,  233288,  233379,  233470,  233561,  233652,  233744,  233835,
    233926,  234017,  234108,  234200,  234291,  234382,  234473,  234564,  234656,  234747,
    234838,  234929,  235020,  235112,  235203,  235294,  235385,  235476,  235568,  235659,
    235750,  235841,  235933,  236024,  236115,  236206,  236297,  236389,  236480,  236571,
    236662,  236754,  236845,  236936,  237027,  237118,  237210,  237301,  237392,  237483,
    237575,  237666,  237757,  237848,  237940,  238031,  238122,  238213,  238305,  238396,
    238487,  238578,  238670,  238761,  238852,  238943,  239035,  239126,  239217,  239308,
    239400,  239491,  239582,  239673,  239765,  239856,  239947,  240038,  240130,  240221,
    240312,  240403,  240495,  240586,  240677,  240768,  240860,  240951,  241042,  241134,
    241225,  241316,  241407,  241499,  241590,  241681,  241773,  241864,  241955,  242046,
    242138,  242229,  242320,  242411,  242503,  242594,  242685,  242777,  242868,  242959,
    243051,  243142,  243233,  243324,  243416,  243507,  243598,  243690,  243781,  243872,
    243964,  244055,  244146,  244237,  244329,  244420,  244511,  244603,  244694,  244785,
    244877,  244968,  245059,  245151,  245242,  245333,  245424,  245516,  245607,  245698,
    245790,  245881,  245972,  246064,  246155,  246246,  246338,  246429,  246520,  246612,
    246703,  246794,  246886,  246977,  247068,  247160,  247251,  247342,  247434,  247525,
    247616,  247708,  247799,  247890,  247982,  248073,  248164,  248256,  248347,  248439,
    248530,  248621,  248713,  248804,  248895,  248987,  249078,  249169,  249261,  249352,
    249443,  249535,  249626,  249718,  249809,  249900,  249992,  250083,  250174,  250266,
    250357,  250448,  250540,  250631,  250723,  250814,  250905,  250997,  251088,  251179,
    251271,  251362,  251454,  251545,  251636,  251728,  251819,  251911,  252002,  252093,
    252185,  252276,  252367,  252459,  252550,  252642,  252733,  252824,  252916,  253007,
    253099,  253190,  253281,  253373,  253464,  253556,  253647,  253738,  253830,  253921,
    254013,  254104,  254196,  254287,  254378,  254470,  254561,  254653,  254744,  254835,
    254927,  255018,  255110,  255201,  255293,  255384,  255475,  255567,  255658,  255750,
    255841,  255933,  256024,  256115,  256207,  256298,  256390,  256481,  256573,  256664,
    256755,  256847,  256938,  257030,  257121,  257213,  257304,  257396,  257487,  257578,
    257670,  257761,  257853,  257944,  258036,  258127,  258219,  258310,  258401,  258493,
    258584,  258676,  258767,  258859,  258950,  259042,  259133,  259225,  259316,  259408,
    259499,  259590,  259682,  259773,  259865,  259956,  260048,  260139,  260231,  260322,
    260414,  260505,  260597,  260688,  260780,  260871,  260963,  261054,  261146,  261237,
    261329,  261420,  261512,  261603,  261694,  261786,  261877,  261969,  262060,  262152,
    262243,  262335,  262426,  262518,  262609,  262701,  262792,  262884,  262975,  263067,
    263158,  263250,  263341,  263433,  263525,  263616,  263708,  263799,  263891,  263982,
    264074,  264165,  264257,  264348,  264440,  264531,  264623,  264714,  264806,  264897,
    264989,  265080,  265172,  265263,  265355,  265446,  265538,  265629,  265721,  265813,
    265904,  265996,  266087,  266179,  266270,  266362,  266453,  266545,  266636,  266728,
    266819,  266911,  267003,  267094,  267186,  267277,  267369,  267460,  267552,  267643,
    267735,  267827,  267918,  268010,  268101,  268193,  268284,  268376,  268467,  268559,
    268651,  268742,  268834,  268925,  269017,  269108,  269200,  269292,  269383,  269475,
    269566,  269658,  269749,  269841,  269933,  270024,  270116,  270207,  270299,  270390,
    270482,  270574,  270665,  270757,  270848,  270940,  271032,  271123,  271215,  271306,
    271398,  271490,  271581,  271673,  271764,  271856,  271948,  272039,  272131,  272222,
    272314,  272406,  272497,  272589,  272680,  272772,  272864,  272955,  273047,  273138,
    273230,  273322,  273413,  273505,  273596,  273688,  273780,  273871,  273963,  274055,
    274146,  274238,  274329,  274421,  274513,  274604,  274696,  274788,  274879,  274971,
    275062,  275154,  275246,  275337,  275429,  275521,  275612,  275704,  275796,  275887,
    275979,  276070,  276162,  276254,  276345,  276437,  276529,  276620,  276712,  276804,
    276895,  276987,  277079,  277170,  277262,  277354,  277445,  277537,  277629,  277720,
    277812,  277904,  277995,  278087,  278179,  278270,  278362,  278454,  278545,  278637,
    278729,  278820,  278912,  279004,  279095,  279187,  279279,  279370,  279462,  279554,
    279645,  279737,  279829,  279920,  280012,  280104,  280195,  280287,  280379,  280470,
    280562,  280654,  280746,  280837,  280929,  281021,  281112,  281204,  281296,  281387,
    281479,  281571,  281662,  281754,  281846,  281938,  282029,  282121,  282213,  282304,
    282396,  282488,  282580,  282671,  282763,  282855,  282946,  283038,  283130,  283222,
    283313,  283405,  283497,  283588,  283680,  283772,  283864,  283955,  284047,  284139,
    284231,  284322,  284414,  284506,  284597,  284689,  284781,  284873,  284964,  285056,
    285148,  285240,  285331,  285423,  285515,  285607,  285698,  285790,  285882,  285974,
    286065,  286157,  286249,  286341,  286432,  286524,  286616,  286708,  286799,  286891,
    286983,  287075,  287166,  287258,  287350,  287442,  287533,  287625,  287717,  287809,
    287900,  287992,  288084,  288176,  288268,  288359,  288451,  288543,  288635,  288726,
    288818,  288910,  289002,  289094,  289185,  289277,  289369,  289461,  289552,  289644,
    289736,  289828,  289920,  290011,  290103,  290195,  290287,  290379,  290470,  290562,
    290654,  290746,  290838,  290929,  291021,  291113,  291205,  291297,  291388,  291480,
    291572,  291664,  291756,  291847,  291939,  292031,  292123,  292215,  292306,  292398,
    292490,  292582,  292674,  292766,  292857,  292949,  293041,  293133,  293225,  293316,
    293408,  293500,  293592,  293684,  293776,  293867,  293959,  294051,  294143,  294235,
    294327,  294418,  294510,  294602,  294694,  294786,  294878,  294969,  295061,  295153,
    295245,  295337,  295429,  295521,  295612,  295704,  295796,  295888,  295980,  296072,
    296163,  296255,  296347,  296439,  296531,  296623,  296715,  296806,  296898,  296990,
    297082,  297174,  297266,  297358,  297450,  297541,  297633,  297725,  297817,  297909,
    298001,  298093,  298185,  298276,  298368,  298460,  298552,  298644,  298736,  298828,
    298920,  299011,  299103,  299195,  299287,  299379,  299471,  299563,  299655,  299747,
    299838,  299930,  300022,  300114,  300206,  300298,  300390,  300482,  300574,  300666,
    300757,  300849,  300941,  301033,  301125,  301217,  301309,  301401,  301493,  301585,
    301677,  301768,  301860,  301952,  302044,  302136,  302228,  302320,  302412,  302504,
    302596,  302688,  302780,  302872,  302963,  303055,  303147,  303239,  303331,  303423,
    303515,  303607,  303699,  303791,  303883,  303975,  304067,  304159,  304251,  304342,
    304434,  304526,  304618,  304710,  304802,  304894,  304986,  305078,  305170,  305262,
    305354,  305446,  305538,  305630,  305722,  305814,  305906,  305998,  306090,  306181,
    306273,  306365,  306457,  306549,  306641,  306733,  306825,  306917,  307009,  307101,
    307193,  307285,  307377,  307469,  307561,  307653,  307745,  307837,  307929,  308021,
    308113,  308205,  308297,  308389,  308481,  308573,  308665,  308757,  308849,  308941,
    309033,  309125,  309217,  309309,  309401,  309493,  309585,  309677,  309769,  309861,
    309953,  310045,  310137,  310229,  310321,  310413,  310505,  310597,  310689,  310781,
    310873,  310965,  311057,  311149,  311241,  311333,  311425,  311517,  311609,  311701,
    311793,  311885,  311977,  312069,  312161,  312253,  312345,  312437,  312529,  312621,
    312713,  312805,  312897,  312989,  313081,  313173,  313265,  313357,  313449,  313541,
    313634,  313726,  313818,  313910,  314002,  314094,  314186,  314278,  314370,  314462,
    314554,  314646,  314738,  314830,  314922,  315014,  315106,  315198,  315290,  315382,
    315475,  315567,  315659,  315751,  315843,  315935,  316027,  316119,  316211,  316303,
    316395,  316487,  316579,  316671,  316763,  316856,  316948,  317040,  317132,  317224,
    317316,  317408,  317500,  317592,  317684,  317776,  317868,  317960,  318053,  318145,
    318237,  318329,  318421,  318513,  318605,  318697,  318789,  318881,  318973,  319066,
    319158,  319250,  319342,  319434,  319526,  319618,  319710,  319802,  319894,  319987,
    320079,  320171,  320263,  320355,  320447,  320539,  320631,  320723,  320816,  320908,
    321000,  321092,  321184,  321276,  321368,  321460,  321553,  321645,  321737,  321829,
    321921,  322013,  322105,  322197,  322290,  322382,  322474,  322566,  322658,  322750,
    322842,  322935,  323027,  323119,  323211,  323303,  323395,  323487,  323580,  323672,
    323764,  323856,  323948,  324040,  324132,  324225,  324317,  324409,  324501,  324593,
    324685,  324777,  324870,  324962,  325054,  325146,  325238,  325330,  325423,  325515,
    325607,  325699,  325791,  325883,  325976,  326068,  326160,  326252,  326344,  326436,
    326529,  326621,  326713,  326805,  326897,  326990,  327082,  327174,  327266,  327358,
    327450,  327543,  327635,  327727,  327819,  327911,  328004,  328096,  328188,  328280,
    328372,  328465,  328557,  328649,  328741,  328833,  328926,  329018,  329110,  329202,
    329294,  329387,  329479,  329571,  329663,  329755,  329848,  329940,  330032,  330124,
    330217,  330309,  330401,  330493,  330585,  330678,  330770,  330862,  330954,  331046,
    331139,  331231,  331323,  331415,  331508,  331600,  331692,  331784,  331877,  331969,
    332061,  332153,  332245,  332338,  332430,  332522,  332614,  332707,  332799,  332891,
    332983,  333076,  333168,  333260,  333352,  333445,  333537,  333629,  333721,  333814,
    333906,  333998,  334090,  334183,  334275,  334367,  334459,  334552,  334644,  334736,
    334828,  334921,  335013,  335105,  335198,  335290,  335382,  335474,  335567,  335659,
    335751,  335843,  335936,  336028,  336120,  336213,  336305,  336397,  336489,  336582,
    336674,  336766,  336859,  336951,  337043,  337135,  337228,  337320,  337412,  337505,
    337597,  337689,  337781,  337874,  3